/*
 * Decompiled with CFR 0.152.
 */
package com.creditcall;

import android.util.Log;
import com.creditcall.CardEaseCallable;
import com.creditcall.CardEaseXMLCommunicationException;
import com.creditcall.CardEaseXMLRequestException;
import com.creditcall.CardEaseXMLResponseException;
import com.creditcall.CardEaseXmlEncryptionException;
import com.creditcall.KevlarState;
import com.creditcall.OperationResponse;
import com.creditcall.PerformHead;
import com.creditcall.PerformPost;
import com.creditcall.PerformRequest;
import com.creditcall.RecoveryAction;
import com.creditcall.Request;
import com.creditcall.RequestInfo;
import com.creditcall.RequestType;
import com.creditcall.Response;
import com.creditcall.ServerURL;
import com.creditcall.XMLEncoding;
import com.creditcall.XmlEncryptor;
import com.creditcall.XmlUtils;
import com.creditcall.internal.XMLWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Client {
    private static String SDK_NAME = "CardEaseXMLClient-Android";
    private static String SDK_VERSION = "4.1.3";
    private List<ServerURL> m_serverURLs = new ArrayList<ServerURL>();
    private X509Certificate m_xmlEncryptionCertificate;
    private String m_xmlEncryptionCertificateFile;
    private Request m_request = new Request();
    private Response m_response = null;
    private XMLEncoding m_xmlEncoding = XMLEncoding.UTF_8;
    private KevlarState m_kevlarState = KevlarState.None;
    static HashMap<String, Object> m_configOptions = new HashMap();
    private Boolean usingClientRequest;

    public static String getCardEaseXMLSDKName() {
        return SDK_NAME;
    }

    public static String getCardEaseXMLSDKVersion() {
        return SDK_VERSION;
    }

    public void addServerURL(ServerURL serverURL) {
        if (this.m_serverURLs == null) {
            this.m_serverURLs = new ArrayList<ServerURL>();
        }
        this.m_serverURLs.add(serverURL);
    }

    public void addServerURL(String url, int timeout) throws CardEaseXMLCommunicationException {
        if (this.m_serverURLs == null) {
            this.m_serverURLs = new ArrayList<ServerURL>();
        }
        this.m_serverURLs.add(new ServerURL(url, timeout));
    }

    public void addServerURL(URL url, int timeout) throws CardEaseXMLCommunicationException {
        if (this.m_serverURLs == null) {
            this.m_serverURLs = new ArrayList<ServerURL>();
        }
        this.m_serverURLs.add(new ServerURL(url, timeout));
    }

    public List<ServerURL> getServerURLs() {
        return this.m_serverURLs;
    }

    public void setXmlEncryptionCertificate(X509Certificate x509Certificate) {
        this.m_xmlEncryptionCertificate = x509Certificate;
    }

    public X509Certificate getXmlEncryptionCertificate() {
        return this.m_xmlEncryptionCertificate;
    }

    public void setXmlEncryptionCertificateFile(String fileName) {
        this.m_xmlEncryptionCertificateFile = fileName;
    }

    public String getXmlEncryptionCertificateFile() {
        return this.m_xmlEncryptionCertificateFile;
    }

    public Request getRequest() {
        return this.m_request;
    }

    public Response getResponse() {
        return this.m_response;
    }

    public XMLEncoding getXMLEncoding() {
        return this.m_xmlEncoding;
    }

    public Response processRequest(Request request) throws CardEaseXMLCommunicationException, CardEaseXMLRequestException, CardEaseXMLResponseException {
        this.m_request = request;
        return this.processRequest();
    }

    public Response processRequest() throws CardEaseXMLCommunicationException, CardEaseXMLRequestException, CardEaseXMLResponseException {
        this.m_response = null;
        if (this.m_request == null) {
            throw new CardEaseXMLRequestException("No request to process");
        }
        if (this.m_serverURLs == null || this.m_serverURLs.size() == 0) {
            throw new CardEaseXMLCommunicationException("No servers to contact");
        }
        CardEaseXMLCommunicationException lastCommunicationException = null;
        this.usingClientRequest = true;
        for (ServerURL url : this.m_serverURLs) {
            if (url == null) continue;
            try {
                return this.getResponse(url, this.getRequestAsString());
            }
            catch (CardEaseXMLCommunicationException e) {
                lastCommunicationException = e;
            }
        }
        if (lastCommunicationException != null) {
            throw lastCommunicationException;
        }
        return this.m_response;
    }

    public Response processRequestFromEncryptedString(String requestXML) throws CardEaseXMLRequestException, CardEaseXMLResponseException, CardEaseXMLCommunicationException {
        return this.processRequest(requestXML);
    }

    public Response processRequest(String requestXML) throws CardEaseXMLCommunicationException, CardEaseXMLRequestException, CardEaseXMLResponseException {
        this.m_response = null;
        this.m_kevlarState = KevlarState.None;
        if (requestXML == null) {
            throw new CardEaseXMLRequestException("No request to process");
        }
        if (this.m_serverURLs == null || this.m_serverURLs.size() == 0) {
            throw new CardEaseXMLCommunicationException("No servers to contact");
        }
        CardEaseXMLCommunicationException lastCommunicationException = null;
        this.usingClientRequest = false;
        for (ServerURL url : this.m_serverURLs) {
            if (url == null) continue;
            try {
                return this.getResponse(url, requestXML);
            }
            catch (CardEaseXMLCommunicationException e) {
                lastCommunicationException = e;
            }
        }
        if (lastCommunicationException != null) {
            throw lastCommunicationException;
        }
        return this.m_response;
    }

    private Response getResponse(ServerURL url, String xmlRequest) throws CardEaseXMLCommunicationException, CardEaseXMLRequestException, CardEaseXMLResponseException {
        RequestInfo requestInfo = this.getRequestInfo(xmlRequest);
        int reliabilityMode = (Integer)Client.getConfigOption("ReliabilityMode", 0);
        OperationResponse opResponse = null;
        String operationToken = null;
        if (reliabilityMode == 1 && Client.isKevlarMessageType(requestInfo.requestType).booleanValue()) {
            PerformHead performHead = new PerformHead(Client.getOperationUrl(url.getURL()), (Integer)Client.getConfigOption("OperationHeadTimeout", 10000), requestInfo, this.m_xmlEncoding);
            opResponse = this.getResponse(performHead, (Integer)Client.getConfigOption("OperationHeadTimeout", 10000), requestInfo.requestType, null, OperationResponse.class);
            operationToken = opResponse.operationToken;
        }
        PerformRequest performRequest = new PerformRequest(url, xmlRequest, this.m_xmlEncoding, (Integer)Client.getConfigOption("ReliabilityMode", 0), (Integer)Client.getConfigOption("TransferMode", 0), this.m_kevlarState, requestInfo, operationToken, Client.getOperationUrl(url.getURL()), (Integer)Client.getConfigOption("TransferModePullIntervalTimeout", 5000));
        this.m_response = this.getResponse(performRequest, url.getTimeout(), requestInfo.requestType, opResponse != null ? opResponse.operationGuid : null, Response.class);
        if (reliabilityMode == 1 && Client.isKevlarMessageType(requestInfo.requestType).booleanValue()) {
            if (opResponse == null || operationToken == null || operationToken.length() == 0 || opResponse.operationGuid == null || opResponse.operationGuid.length() == 0) {
                throw new CardEaseXMLCommunicationException("Unable to notify server of response", opResponse.operationGuid, RecoveryAction.getRecoveryAction(requestInfo.requestType, this.m_response, this.m_kevlarState));
            }
            PerformPost performPost = new PerformPost(Client.getOperationUrl(url.getURL()), (Integer)Client.getConfigOption("OperationPostTimeout", 10000), this.m_xmlEncoding, requestInfo, this.m_kevlarState, operationToken);
            if (!this.getResponse(performPost, (Integer)Client.getConfigOption("OperationPostTimeout", 10000), requestInfo.requestType, opResponse.operationGuid, Boolean.class).booleanValue()) {
                throw new CardEaseXMLCommunicationException("Server rejected notification", opResponse.operationGuid, RecoveryAction.getRecoveryAction(requestInfo.requestType, this.m_response, this.m_kevlarState));
            }
        }
        return this.m_response;
    }

    private <V, T extends CardEaseCallable<V>> V getResponse(T action, int timeout, RequestType requestType, String operationGuid, Class<V> vClass) throws CardEaseXMLCommunicationException, CardEaseXMLRequestException, CardEaseXMLResponseException {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future future = executor.submit(action);
        Object out = null;
        try {
            out = future.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException ex) {
            future.cancel(true);
            throw new CardEaseXMLCommunicationException("Unable to send request", operationGuid, RecoveryAction.getRecoveryAction(requestType, this.m_response, action.getKevlarState()));
        }
        catch (InterruptedException ex) {
            future.cancel(true);
            throw new CardEaseXMLCommunicationException("Unable to send request", operationGuid, RecoveryAction.getRecoveryAction(requestType, this.m_response, action.getKevlarState()));
        }
        catch (ExecutionException ex) {
            future.cancel(true);
            Throwable rootException = ex.getCause();
            if (rootException != null) {
                if (rootException instanceof CardEaseXMLCommunicationException) {
                    throw new CardEaseXMLCommunicationException(rootException.getMessage(), operationGuid, RecoveryAction.getRecoveryAction(requestType, this.m_response, action.getKevlarState()));
                }
                if (rootException instanceof CardEaseXMLRequestException) {
                    throw new CardEaseXMLRequestException();
                }
                if (rootException instanceof CardEaseXMLResponseException) {
                    throw new CardEaseXMLResponseException();
                }
            }
            throw new CardEaseXMLCommunicationException("Unable to send request", operationGuid, RecoveryAction.getRecoveryAction(requestType, this.m_response, action.getKevlarState()));
        }
        executor.shutdownNow();
        this.m_kevlarState = action.getKevlarState();
        return vClass.cast(out);
    }

    static URL getOperationUrl(URL url) {
        URL newUrl;
        try {
            newUrl = new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), (String)Client.getConfigOption("OperationPath", "/operation.cex"), url.getQuery(), url.getRef()).toURL();
        }
        catch (MalformedURLException | URISyntaxException e) {
            return null;
        }
        return newUrl;
    }

    RequestInfo getRequestInfo(String xmlRequest) throws CardEaseXMLCommunicationException {
        RequestInfo requestInfo = new RequestInfo();
        if (this.usingClientRequest.booleanValue()) {
            requestInfo.terminalId = this.m_request.getTerminalID();
            requestInfo.cardEaseReference = this.m_request.getCardEaseReference();
            requestInfo.requestType = this.m_request.getRequestType();
            requestInfo.apiKey = this.m_request.getApiKey();
        } else if (xmlRequest != null) {
            String encoding = "UTF-8";
            if (this.m_xmlEncoding == XMLEncoding.UTF_8) {
                encoding = "UTF-8";
            } else if (this.m_xmlEncoding == XMLEncoding.UTF_16) {
                encoding = "UTF-16";
            } else if (this.m_xmlEncoding == XMLEncoding.US_ASCII) {
                encoding = "US-ASCII";
            }
            ByteArrayInputStream xmlStream = null;
            try {
                xmlStream = new ByteArrayInputStream(xmlRequest.getBytes(encoding));
            }
            catch (IOException e) {
                throw new CardEaseXMLCommunicationException("Unable to send request", e);
            }
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            try {
                NodeList childNodes;
                NodeList requestTypeList;
                NodeList childNodes2;
                NodeList apiKeyNodeList;
                NodeList childNodes3;
                NodeList tidNodeList;
                NodeList childNodes4;
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document doc = documentBuilder.parse(xmlStream);
                NodeList cardEaseRefList = doc.getElementsByTagName("CardEaseReference");
                if (cardEaseRefList != null && cardEaseRefList.getLength() > 0 && (childNodes4 = cardEaseRefList.item(0).getChildNodes()) != null && childNodes4.getLength() > 0) {
                    requestInfo.cardEaseReference = childNodes4.item(0).getNodeValue();
                }
                if ((tidNodeList = doc.getElementsByTagName("TerminalID")) != null && tidNodeList.getLength() > 0 && (childNodes3 = tidNodeList.item(0).getChildNodes()) != null && childNodes3.getLength() > 0) {
                    requestInfo.terminalId = childNodes3.item(0).getNodeValue();
                }
                if ((apiKeyNodeList = doc.getElementsByTagName("ApiKey")) != null && apiKeyNodeList.getLength() > 0 && (childNodes2 = apiKeyNodeList.item(0).getChildNodes()) != null && childNodes2.getLength() > 0) {
                    requestInfo.apiKey = childNodes2.item(0).getNodeValue();
                }
                if ((requestTypeList = doc.getElementsByTagName("MessageType")) != null && requestTypeList.getLength() > 0 && (childNodes = requestTypeList.item(0).getChildNodes()) != null & childNodes.getLength() > 0) {
                    requestInfo.requestType = RequestType.valueOf(childNodes.item(0).getNodeValue());
                }
            }
            catch (Exception e) {
                Log.d((String)"CardEaseXMLClient", (String)"Failed to retrieve CardEaseV2 request header information");
            }
        }
        return requestInfo;
    }

    public void setServerURLs(List<ServerURL> serverURLs) {
        this.m_serverURLs = serverURLs;
    }

    public void setRequest(Request request) {
        this.m_request = request;
    }

    public String getRequestAsString() throws CardEaseXMLRequestException {
        return this.saveRequestAsString(false);
    }

    public void saveEncryptedRequestAsFile(String fileName) throws CardEaseXMLRequestException, IOException {
        String xml = this.saveEncryptedRequestAsString();
        FileOutputStream outputStream = new FileOutputStream(fileName);
        outputStream.write(xml.getBytes("UTF-8"));
        outputStream.close();
    }

    public String saveEncryptedRequestAsString() throws CardEaseXMLRequestException {
        return this.saveRequestAsString(true);
    }

    private String saveRequestAsString(boolean enableEncryption) throws CardEaseXMLRequestException {
        if (this.m_request == null) {
            throw new CardEaseXMLRequestException("No request to process");
        }
        StringWriter stringWriter = new StringWriter();
        XMLWriter xmlWriter = new XMLWriter(stringWriter, this.m_xmlEncoding);
        if (enableEncryption) {
            if (!this.isXmlEncryptionAvailable()) {
                throw new CardEaseXMLRequestException("Certificate not available");
            }
            Document unencryptedXmlDocument = XmlUtils.getXmlDocument(this.getRequestAsString());
            Element encryptedXml = unencryptedXmlDocument.createElement("EncryptedXml");
            encryptedXml.setAttribute("responseEncrypted", "false");
            if (unencryptedXmlDocument.getDocumentElement() != null) {
                ArrayList<Element> extendedPropertiesElements;
                unencryptedXmlDocument.getDocumentElement().appendChild(encryptedXml);
                ArrayList<Element> elementsToEncrypt = new ArrayList<Element>();
                ArrayList<Element> cardDetailsElements = XmlUtils.getElementsNamed(unencryptedXmlDocument, "CardDetails");
                if (cardDetailsElements != null && cardDetailsElements.size() > 0) {
                    elementsToEncrypt.addAll(cardDetailsElements);
                }
                if ((extendedPropertiesElements = XmlUtils.getElementsNamed(unencryptedXmlDocument, "ExtendedPropertyList")) != null && extendedPropertiesElements.size() > 0) {
                    elementsToEncrypt.addAll(extendedPropertiesElements);
                }
                try {
                    XmlEncryptor xmlEncryptor = new XmlEncryptor(this.m_xmlEncryptionCertificate);
                    xmlEncryptor.encryptElements(elementsToEncrypt);
                }
                catch (CardEaseXmlEncryptionException e) {
                    throw new CardEaseXMLRequestException("Failed to encrypt request", e);
                }
            }
            TransformerFactory tf = TransformerFactory.newInstance();
            try {
                Transformer transformer = tf.newTransformer();
                transformer.transform(new DOMSource(unencryptedXmlDocument), new StreamResult(stringWriter));
            }
            catch (TransformerConfigurationException e) {
                throw new CardEaseXMLRequestException("Failed to write encrypted xml", e);
            }
            catch (TransformerException e) {
                throw new CardEaseXMLRequestException("Failed to write encrypted xml", e);
            }
        }
        this.m_request.generateRequestXml(xmlWriter);
        return stringWriter.toString();
    }

    public boolean isXmlEncryptionAvailable() {
        if (this.m_xmlEncryptionCertificate == null && this.m_xmlEncryptionCertificateFile == null) {
            return false;
        }
        if (this.m_xmlEncryptionCertificateFile != null) {
            File file = new File(this.m_xmlEncryptionCertificateFile);
            if (!file.exists()) {
                return false;
            }
            try {
                FileInputStream inputStream = new FileInputStream(file);
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                this.m_xmlEncryptionCertificate = (X509Certificate)cf.generateCertificate(inputStream);
            }
            catch (FileNotFoundException | CertificateException e) {
                return false;
            }
            return true;
        }
        try {
            this.m_xmlEncryptionCertificate.checkValidity();
        }
        catch (CertificateNotYetValidException e) {
            return false;
        }
        catch (CertificateExpiredException e) {
            return false;
        }
        return true;
    }

    public void setXMLEncoding(XMLEncoding xmlEncoding) {
        this.m_xmlEncoding = xmlEncoding;
    }

    public static void setConfigOption(String option, Object value) {
        if (option != null) {
            option = option.toLowerCase();
        }
        if (value == null) {
            m_configOptions.remove(option);
        } else {
            m_configOptions.put(option, value);
        }
    }

    static Object getConfigOption(String option, Object defaultObject) {
        if (option == null) {
            return defaultObject;
        }
        if (m_configOptions.containsKey(option = option.toLowerCase())) {
            return m_configOptions.get(option);
        }
        return defaultObject;
    }

    public Object getConfigOption(String option) {
        return Client.getConfigOption(option, null);
    }

    static Boolean isKevlarMessageType(RequestType req) {
        if (req == null) {
            return true;
        }
        switch (req) {
            case Auth: 
            case Conf: 
            case DeferredAuth: 
            case Offline: 
            case PartialConfirm: 
            case PreAuth: 
            case Refund: 
            case Update: 
            case VoiceReferralNotification: 
            case Void: {
                return true;
            }
        }
        return false;
    }

    public class ConfigOptions {
        public static final String OperationHeadTimeout = "OperationHeadTimeout";
        public static final String OperationPath = "OperationPath";
        public static final String ReliabilityMode = "ReliabilityMode";
        public static final String OperationPostTimeout = "OperationPostTimeout";
        public static final String TransferMode = "TransferMode";
        public static final String TransferModePullIntervalTimeout = "TransferModePullIntervalTimeout";
    }
}

