/*
 * Decompiled with CFR 0.152.
 */
package com.creditcall;

import com.creditcall.CardToken;
import java.util.ArrayList;

public class FundingCard {
    private String m_CardReference;
    private String m_CardHash;
    private String m_pan;
    private String m_expiryDate;
    private String m_expiryDateFormat;
    private ArrayList<CardToken> m_cardTokens;

    public FundingCard(String cardReference, String cardHash, String pan, String expiryDate, String expiryDateFormat, ArrayList<CardToken> cardTokens) {
        this.m_CardReference = cardReference;
        this.m_CardHash = cardHash;
        this.m_pan = pan;
        this.m_expiryDate = expiryDate;
        this.m_expiryDateFormat = expiryDateFormat;
        this.m_cardTokens = cardTokens;
    }

    public String getCardReference() {
        return this.m_CardReference;
    }

    public String getCardHash() {
        return this.m_CardHash;
    }

    public String getPAN() {
        return this.m_pan;
    }

    public String getExpiryDate() {
        return this.m_expiryDate;
    }

    public String getExpiryDateFormat() {
        return this.m_expiryDateFormat;
    }

    public ArrayList<CardToken> getCardTokens() {
        return this.m_cardTokens;
    }

    private String cardTokensToString() {
        StringBuilder sb = new StringBuilder();
        if (this.m_cardTokens != null) {
            for (CardToken token : this.m_cardTokens) {
                sb.append(token.getAlgorithm());
                sb.append(token.getKey());
                sb.append(token.getValue());
            }
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.m_CardReference);
        sb.append(":");
        sb.append(this.m_CardHash);
        sb.append(":");
        sb.append(this.m_pan);
        sb.append(":");
        sb.append(this.m_expiryDate);
        sb.append(":");
        sb.append(this.m_expiryDateFormat);
        if (this.m_cardTokens != null && !this.m_cardTokens.isEmpty()) {
            sb.append(this.cardTokensToString());
        }
        return sb.toString();
    }
}

