/*
 * Decompiled with CFR 0.152.
 */
package com.creditcall;

import com.creditcall.CardEaseCallable;
import com.creditcall.CardEaseXMLCommunicationException;
import com.creditcall.KevlarState;
import com.creditcall.OperationResponse;
import com.creditcall.RequestInfo;
import com.creditcall.XMLEncoding;
import java.io.IOException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.UnknownHostException;
import javax.net.ssl.HttpsURLConnection;

class PerformHead
extends CardEaseCallable {
    private URL m_url;
    private int m_timeout;

    public PerformHead(URL url, int timeout, RequestInfo requestInfo, XMLEncoding encoding) {
        super(encoding, requestInfo);
        this.m_url = url;
        this.m_timeout = timeout;
    }

    @Override
    public OperationResponse call() throws CardEaseXMLCommunicationException {
        HttpsURLConnection httpConnection = this.getHttpsURLConnection(this.m_url, this.m_timeout, false);
        try {
            httpConnection.setRequestMethod("HEAD");
        }
        catch (ProtocolException e) {
            throw new CardEaseXMLCommunicationException("Unknown protocol", e);
        }
        if (this.m_requestInfo != null) {
            if (this.m_requestInfo.terminalId != null && this.m_requestInfo.terminalId.length() > 0) {
                httpConnection.setRequestProperty("CardEaseV2-TerminalID", this.m_requestInfo.terminalId);
            } else if (this.m_requestInfo.apiKey != null && this.m_requestInfo.apiKey.length() > 0) {
                httpConnection.setRequestProperty("CardEaseV2-TerminalID", this.m_requestInfo.apiKey);
            }
            if (this.m_requestInfo.cardEaseReference != null && this.m_requestInfo.cardEaseReference.length() > 0) {
                httpConnection.setRequestProperty("CardEaseV2-TransactionGUID", this.m_requestInfo.cardEaseReference);
            }
        }
        this.m_kevlarState = KevlarState.TokenRequestSent;
        try {
            int responseCode = httpConnection.getResponseCode();
            httpConnection.getInputStream().close();
            httpConnection.disconnect();
            if (responseCode != 200) {
                throw new CardEaseXMLCommunicationException("Unexpected HTTP response: " + responseCode);
            }
        }
        catch (UnknownHostException e) {
            throw new CardEaseXMLCommunicationException("Unable to connect to host", e);
        }
        catch (IOException e) {
            throw new CardEaseXMLCommunicationException("Unable to retrieve HTTP response code", e);
        }
        String operationToken = httpConnection.getHeaderField("CardEaseV2-OperationToken");
        String operationGuid = httpConnection.getHeaderField("CardEaseV2-OperationGUID");
        if (operationToken == null || operationToken.length() == 0 || operationGuid == null || operationGuid.length() == 0) {
            throw new CardEaseXMLCommunicationException("Unable to retrieve server token");
        }
        this.m_kevlarState = KevlarState.TokenRequestComplete;
        return new OperationResponse(operationGuid, operationToken);
    }
}

