/*
 * Decompiled with CFR 0.152.
 */
package com.creditcall;

import com.creditcall.CardEaseCallable;
import com.creditcall.CardEaseXMLCommunicationException;
import com.creditcall.KevlarState;
import com.creditcall.RequestInfo;
import com.creditcall.XMLEncoding;
import com.creditcall.internal.ByteList;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ProtocolException;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;

class PerformPost
extends CardEaseCallable {
    private URL m_url;
    private int m_timeout;
    private String m_operationToken;

    PerformPost(URL url, int timeout, XMLEncoding xmlEncoding, RequestInfo requestInfo, KevlarState kevlarState, String operationToken) {
        super(xmlEncoding, requestInfo);
        this.m_kevlarState = kevlarState;
        this.m_operationToken = operationToken;
        this.m_url = url;
        this.m_timeout = timeout;
    }

    @Override
    public Boolean call() throws CardEaseXMLCommunicationException {
        HttpsURLConnection urlConnection = this.getHttpsURLConnection(this.m_url, this.m_timeout, true);
        try {
            urlConnection.setRequestMethod("POST");
        }
        catch (ProtocolException e) {
            throw new CardEaseXMLCommunicationException("Unable to specify communication protocol", e);
        }
        if (this.m_requestInfo.terminalId != null && this.m_requestInfo.terminalId.length() > 0) {
            urlConnection.setRequestProperty("CardEaseV2-TerminalID", this.m_requestInfo.terminalId);
        } else if (this.m_requestInfo.apiKey != null && this.m_requestInfo.apiKey.length() > 0) {
            urlConnection.setRequestProperty("CardEaseV2-TerminalID", this.m_requestInfo.apiKey);
        }
        if (this.m_requestInfo.cardEaseReference != null && this.m_requestInfo.cardEaseReference.length() > 0) {
            urlConnection.setRequestProperty("CardEaseV2-TransactionGUID", this.m_requestInfo.cardEaseReference);
        }
        if (this.m_operationToken != null && this.m_operationToken.length() > 0) {
            urlConnection.setRequestProperty("CardEaseV2-OperationToken", this.m_operationToken);
        }
        this.m_kevlarState = KevlarState.ResponseNotificationSent;
        String response = null;
        try {
            OutputStream requestStream = urlConnection.getOutputStream();
            requestStream.write("OK".getBytes("UTF-8"));
        }
        catch (IOException e) {
            throw new CardEaseXMLCommunicationException("Unable to send HTTP request");
        }
        try {
            int responseCode = urlConnection.getResponseCode();
            if (responseCode != 200) {
                throw new CardEaseXMLCommunicationException("Unexpected HTTP response: " + responseCode);
            }
            int bytesRead = 0;
            byte[] buffer = new byte[1024];
            ByteList byteList = new ByteList();
            InputStream responseStream = urlConnection.getInputStream();
            while ((bytesRead = responseStream.read(buffer, 0, buffer.length)) > 0) {
                byteList.add(buffer, 0, bytesRead);
            }
            responseStream.close();
            response = new String(byteList.toArray());
        }
        catch (IOException e) {
            throw new CardEaseXMLCommunicationException("Unable to read HTTP response", e);
        }
        if (response.equals("OK")) {
            this.m_kevlarState = KevlarState.ResponseNotificationComplete;
            return true;
        }
        return false;
    }
}

