/*
 * Decompiled with CFR 0.152.
 */
package com.creditcall;

import android.util.Log;
import com.creditcall.CardEaseCallable;
import com.creditcall.CardEaseXMLCommunicationException;
import com.creditcall.CardEaseXMLRequestException;
import com.creditcall.CardEaseXMLResponseException;
import com.creditcall.Client;
import com.creditcall.KevlarState;
import com.creditcall.RequestInfo;
import com.creditcall.Response;
import com.creditcall.ServerURL;
import com.creditcall.XMLEncoding;
import com.creditcall.internal.ByteList;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ProtocolException;
import java.net.URL;
import java.net.UnknownHostException;
import javax.net.ssl.HttpsURLConnection;

class PerformRequest
extends CardEaseCallable {
    private ServerURL url;
    private String xmlRequest;
    private Integer reliabilityMode = 0;
    private String operationToken;
    private Integer transferMode = 0;
    private int pullIntervalTimeout;
    private URL pullUrl;

    PerformRequest(ServerURL url, String xmlRequest, XMLEncoding xmlEncoding, Integer reliabilityMode, Integer transferMode, KevlarState kevlarState, RequestInfo requestInfo, String operationToken, URL pullUrl, int pullIntervalTimeout) {
        super(xmlEncoding, requestInfo);
        this.url = url;
        this.xmlRequest = xmlRequest;
        this.reliabilityMode = reliabilityMode;
        this.m_kevlarState = kevlarState;
        this.operationToken = operationToken;
        this.transferMode = transferMode;
        this.pullIntervalTimeout = pullIntervalTimeout;
        this.pullUrl = pullUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response call() throws CardEaseXMLCommunicationException, CardEaseXMLRequestException, CardEaseXMLResponseException {
        if (this.xmlRequest == null) {
            throw new CardEaseXMLRequestException();
        }
        HttpsURLConnection httpConnection = this.getUrlConnection(this.url.getURL(), this.url.getTimeout(), true);
        try {
            httpConnection.setRequestMethod("POST");
        }
        catch (ProtocolException e) {
            throw new CardEaseXMLCommunicationException("Unable to specify communication protocol", e);
        }
        String encoding = "UTF-8";
        if (this.m_xmlEncoding == XMLEncoding.UTF_8) {
            encoding = "UTF-8";
        } else if (this.m_xmlEncoding == XMLEncoding.UTF_16) {
            encoding = "UTF-16";
        } else if (this.m_xmlEncoding == XMLEncoding.US_ASCII) {
            encoding = "US-ASCII";
        }
        if (this.reliabilityMode == 1 && Client.isKevlarMessageType(this.m_requestInfo.requestType).booleanValue()) {
            this.m_kevlarState = KevlarState.TransactionRequestSent;
        }
        String responseXML = null;
        int httpResponse = -1;
        if (this.reliabilityMode == 1 && this.transferMode == 1 && Client.isKevlarMessageType(this.m_requestInfo.requestType).booleanValue()) {
            try {
                InputStream inputStream = null;
                httpConnection.setReadTimeout(this.pullIntervalTimeout);
                try {
                    OutputStream requestStream = httpConnection.getOutputStream();
                    if (this.xmlRequest == null) {
                        throw new CardEaseXMLRequestException();
                    }
                    requestStream.write(this.xmlRequest.getBytes(encoding));
                    inputStream = httpConnection.getInputStream();
                    httpResponse = httpConnection.getResponseCode();
                    if (httpResponse != 200) {
                        throw new CardEaseXMLCommunicationException("Unexpected HTTP response: " + httpResponse);
                    }
                }
                catch (Exception e) {
                    if (inputStream != null) {
                        Log.d((String)"CardEaseXML", (String)("Exception on post: " + httpResponse + ", " + inputStream.available()));
                    }
                    Log.d((String)"CardEaseXML", (String)("Exception on post: " + httpResponse));
                }
                long finish = System.currentTimeMillis() + (long)this.url.getTimeout();
                long lastAttempt = 0L;
                Exception lastException = null;
                int available = -1;
                if (httpConnection != null) {
                    available = httpConnection.getContentLength();
                }
                while (System.currentTimeMillis() < finish && available < 1) {
                    if (System.currentTimeMillis() < lastAttempt + (long)this.pullIntervalTimeout) {
                        try {
                            Thread.sleep(lastAttempt + (long)this.pullIntervalTimeout - System.currentTimeMillis());
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    try {
                        lastException = null;
                        httpConnection = this.getUrlConnection(this.pullUrl, this.pullIntervalTimeout, false);
                        httpConnection.setRequestMethod("GET");
                        httpResponse = httpConnection.getResponseCode();
                        inputStream = httpConnection.getInputStream();
                        if (inputStream != null) {
                            available = httpConnection.getContentLength();
                        }
                        if (httpResponse == 200 && inputStream != null && available <= 0) continue;
                        break;
                    }
                    catch (Exception e) {
                        lastException = e;
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException e1) {
                            Log.d((String)"CardEaseXML", (String)"Interrupted when waiting to resending GET");
                        }
                    }
                    finally {
                        lastAttempt = System.currentTimeMillis();
                        if (available >= 1) continue;
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        httpConnection.disconnect();
                    }
                }
                if (lastException != null || available < 1) {
                    throw new CardEaseXMLCommunicationException("Unable to read HTTP response", lastException);
                }
                responseXML = this.getResponse(inputStream);
                httpConnection.disconnect();
            }
            catch (IOException e) {
                throw new CardEaseXMLCommunicationException("Unable to retrieve HTTP response code", e);
            }
        }
        try {
            OutputStream requestStream = httpConnection.getOutputStream();
            if (this.xmlRequest == null) {
                throw new CardEaseXMLRequestException();
            }
            requestStream.write(this.xmlRequest.getBytes(encoding));
        }
        catch (UnknownHostException e) {
            if (this.reliabilityMode == 1) {
                throw new CardEaseXMLCommunicationException("Unable to send request", e);
            }
            throw new CardEaseXMLCommunicationException("Unable to connect to host");
        }
        catch (IOException e) {
            throw new CardEaseXMLCommunicationException("Unable to send request", e);
        }
        try {
            int responseCode = httpConnection.getResponseCode();
            if (responseCode != 200) {
                throw new CardEaseXMLCommunicationException("Unexpected HTTP response: " + responseCode);
            }
        }
        catch (IOException e) {
            throw new CardEaseXMLCommunicationException("Unable to retrieve HTTP response code", e);
        }
        try {
            responseXML = this.getResponse(httpConnection.getInputStream());
        }
        catch (IOException e) {
            throw new CardEaseXMLCommunicationException("Unable to read HTTP response", e);
        }
        httpConnection.disconnect();
        if (responseXML == null || responseXML.length() == 0) {
            throw new CardEaseXMLCommunicationException("Unable to retrieve server response");
        }
        Response response = new Response();
        response.parseResponseXML(responseXML.toString());
        if (this.reliabilityMode == 1 && Client.isKevlarMessageType(this.m_requestInfo.requestType).booleanValue()) {
            this.m_kevlarState = KevlarState.TranasctionResponseReceived;
        }
        return response;
    }

    private String getResponse(InputStream inputStream) throws CardEaseXMLCommunicationException, IOException {
        int bytesRead = 0;
        byte[] buffer = new byte[1024];
        ByteList byteList = new ByteList();
        InputStream responseStream = inputStream;
        while ((bytesRead = responseStream.read(buffer, 0, buffer.length)) > 0) {
            byteList.add(buffer, 0, bytesRead);
        }
        responseStream.close();
        return new String(byteList.toArray());
    }

    private HttpsURLConnection getUrlConnection(URL url, int timeout, Boolean doOutput) throws CardEaseXMLCommunicationException {
        HttpsURLConnection httpConnection = this.getHttpsURLConnection(url, timeout, doOutput);
        if (this.m_requestInfo != null) {
            if (this.m_requestInfo.terminalId != null && this.m_requestInfo.terminalId.length() > 0) {
                httpConnection.setRequestProperty("CardEaseV2-TerminalID", this.m_requestInfo.terminalId);
            } else if (this.m_requestInfo.apiKey != null && this.m_requestInfo.apiKey.length() > 0) {
                httpConnection.setRequestProperty("CardEaseV2-TerminalID", this.m_requestInfo.apiKey);
            }
            if (this.m_requestInfo.cardEaseReference != null && this.m_requestInfo.cardEaseReference.length() > 0) {
                httpConnection.setRequestProperty("CardEaseV2-TransactionGUID", this.m_requestInfo.cardEaseReference);
            }
        }
        if (this.operationToken != null && this.operationToken.length() > 0) {
            httpConnection.setRequestProperty("CardEaseV2-OperationToken", this.operationToken);
        }
        if (this.reliabilityMode == 1 && this.transferMode == 1 && Client.isKevlarMessageType(this.m_requestInfo != null ? this.m_requestInfo.requestType : null).booleanValue()) {
            httpConnection.setRequestProperty("CardEaseV2-TransferMode", "polled");
            httpConnection.setRequestProperty("CardEaseV2-TransferModePullIntervalTimeout", Integer.toString(this.pullIntervalTimeout));
            httpConnection.setReadTimeout(this.pullIntervalTimeout);
        }
        return httpConnection;
    }
}

