/*
 * Decompiled with CFR 0.152.
 */
package com.creditcall;

public enum ResultCode {
    Empty("-1"),
    Approved("0"),
    Declined("1"),
    VoiceReferralRequired("2"),
    PartialApproval("10"),
    TestOK("99");

    private final String m_code;

    protected static ResultCode parse(String code) {
        for (ResultCode item : ResultCode.values()) {
            if (!code.equalsIgnoreCase(item.m_code)) continue;
            return item;
        }
        throw new IllegalArgumentException("Unknown code: " + code);
    }

    private ResultCode(String code) {
        this.m_code = code;
    }

    public String toString() {
        return this.m_code;
    }
}

