/*
 * Decompiled with CFR 0.152.
 */
package com.creditcall.internal;

import com.creditcall.XMLEncoding;
import java.io.IOException;
import java.io.Writer;
import java.util.Stack;

public class XMLWriter {
    private XMLEncoding m_encoding = XMLEncoding.UTF_8;
    private boolean m_isNodeEmpty = false;
    private boolean m_isTagOpen = false;
    private Stack<String> m_tags = new Stack();
    private Writer m_writer;

    public XMLWriter(Writer writer) {
        this(writer, XMLEncoding.UTF_8);
    }

    public XMLWriter(Writer writer, XMLEncoding encoding) {
        this.m_writer = writer;
        this.m_encoding = encoding;
    }

    public void close() throws IOException {
        this.m_writer.close();
        if (!this.m_tags.empty()) {
            throw new IOException("Tags are not all closed (" + this.m_tags.pop() + "?)");
        }
    }

    private void closeTag() throws IOException {
        if (this.m_isTagOpen) {
            this.m_writer.write(">");
            this.m_isTagOpen = false;
        }
    }

    public void writeAttributeString(String name, String value) throws IOException {
        if (!this.m_isTagOpen) {
            throw new IOException("No open tag found");
        }
        this.m_writer.write(" " + name + "=\"" + this.xmlSpecialChars(value) + "\"");
    }

    public void writeComment(String comment) throws IOException {
        this.writeString("<!--" + comment + "-->");
    }

    public void writeElementString(String name, String text) throws IOException {
        this.writeStartElement(name);
        this.writeString(text);
        this.writeEndElement();
    }

    public void writeEndDocument() {
    }

    public void writeEndElement() throws IOException {
        if (this.m_tags.empty()) {
            throw new IOException("No open element found");
        }
        String tag = this.m_tags.pop();
        if (this.m_isNodeEmpty) {
            this.m_writer.write("/>");
        } else {
            this.m_writer.write("</" + tag + ">");
        }
        this.m_isNodeEmpty = false;
        this.m_isTagOpen = false;
    }

    public void writeStartDocument() throws IOException {
        this.writeStartDocument(false);
    }

    public void writeStartDocument(boolean standalone) throws IOException {
        this.m_writer.write("<?xml version=\"1.0\"");
        if (this.m_encoding != null) {
            this.m_writer.write(" encoding=\"" + this.xmlSpecialChars(this.m_encoding.toString()) + "\"");
        }
        if (standalone) {
            this.m_writer.write(" standalone=\"yes\"");
        }
        this.m_writer.write("?>");
    }

    public void writeStartElement(String name) throws IOException {
        this.writeStartElement(name, null);
    }

    public void writeStartElement(String name, String namespace) throws IOException {
        this.closeTag();
        this.m_writer.write("<" + name);
        this.m_isTagOpen = true;
        this.m_isNodeEmpty = true;
        this.m_tags.add(name);
        if (namespace != null) {
            this.writeAttributeString("xmlns", namespace);
        }
    }

    public void writeString(String text) throws IOException {
        this.closeTag();
        this.m_writer.write(this.xmlSpecialChars(text));
        this.m_isNodeEmpty = false;
    }

    private String xmlSpecialChars(String str) {
        String rep = str;
        rep = rep.replaceAll("&", "&amp;");
        rep = rep.replaceAll("\"", "&quot;");
        rep = rep.replaceAll("'", "&apos;");
        rep = rep.replaceAll("<", "&lt;");
        rep = rep.replaceAll(">", "&gt;");
        return rep.toString();
    }
}

