/*
 * Decompiled with CFR 0.152.
 */
package android_serialport_api;

import android.util.Log;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Iterator;
import java.util.Vector;

public class SerialPortFinder {
    private static final String TAG = "SerialPort";
    private Vector<Driver> mDrivers = null;

    Vector<Driver> getDrivers() throws IOException {
        if (this.mDrivers == null) {
            String l;
            this.mDrivers = new Vector();
            LineNumberReader r = new LineNumberReader(new FileReader("/proc/tty/drivers"));
            while ((l = r.readLine()) != null) {
                String drivername = l.substring(0, 21).trim();
                String[] w = l.split(" +");
                if (w.length < 5 || !w[w.length - 1].equals("serial")) continue;
                Log.d((String)TAG, (String)("Found new driver " + drivername + " on " + w[w.length - 4]));
                this.mDrivers.add(new Driver(drivername, w[w.length - 4]));
            }
            r.close();
        }
        return this.mDrivers;
    }

    private String[] getAllDevices() {
        Vector<String> devices = new Vector<String>();
        try {
            for (Driver driver : this.getDrivers()) {
                Iterator itdev = driver.getDevices().iterator();
                while (itdev.hasNext()) {
                    String device = ((File)itdev.next()).getName();
                    String value = String.format("%s (%s)", device, driver.getName());
                    devices.add(value);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return devices.toArray(new String[devices.size()]);
    }

    private String[] getAllDevicesPath() {
        Vector<String> devices = new Vector<String>();
        try {
            for (Driver driver : this.getDrivers()) {
                Iterator itdev = driver.getDevices().iterator();
                while (itdev.hasNext()) {
                    String device = ((File)itdev.next()).getAbsolutePath();
                    devices.add(device);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return devices.toArray(new String[devices.size()]);
    }

    private class Driver {
        private String mDriverName;
        private String mDeviceRoot;
        Vector<File> mDevices = null;

        private Driver(String name, String root) {
            this.mDriverName = name;
            this.mDeviceRoot = root;
        }

        private Vector<File> getDevices() {
            if (this.mDevices == null) {
                this.mDevices = new Vector();
                File dev = new File("/dev");
                File[] files = dev.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    if (!files[i].getAbsolutePath().startsWith(this.mDeviceRoot)) continue;
                    Log.d((String)SerialPortFinder.TAG, (String)("Found new device: " + files[i]));
                    this.mDevices.add(files[i]);
                }
            }
            return this.mDevices;
        }

        private String getName() {
            return this.mDriverName;
        }
    }
}

