/*
 * Decompiled with CFR 0.152.
 */
package com.idtechproducts.device;

import java.math.BigInteger;

public class CardData {
    private String stringData;
    private byte[] byteData;

    public CardData(String data) {
        if (data.length() % 2 == 0) {
            this.stringData = data;
            this.byteData = new byte[this.stringData.length() / 2];
            this.convertStringToByte();
        }
    }

    public CardData(byte[] data) {
        this.stringData = "";
        this.byteData = data;
        this.convertByteToString();
    }

    private String getSTX() {
        return this.stringData.substring(0, 2);
    }

    private int getDataLength() {
        if (!this.isDataEncrypted()) {
            return this.byteData.length;
        }
        return 0xFFFF & (this.byteData[2] << 8) + 255 & this.byteData[1];
    }

    private String getCardEncodeType() {
        if (!this.isDataEncrypted()) {
            return null;
        }
        return this.stringData.substring(6, 8);
    }

    private String getTrackStatus() {
        if (!this.isDataEncrypted()) {
            return null;
        }
        return this.stringData.substring(8, 10);
    }

    private int getTrack1Length() {
        if (!this.isDataEncrypted()) {
            return this.getT1Data().length() / 2;
        }
        return this.byteData[5];
    }

    private int getTrack2Length() {
        if (!this.isDataEncrypted()) {
            return this.getT2Data().length() / 2;
        }
        return this.byteData[6];
    }

    private int getTrack3Length() {
        if (!this.isDataEncrypted()) {
            return 0;
        }
        return this.byteData[7];
    }

    private String getFieldByte1() {
        if (!this.isDataEncrypted()) {
            return null;
        }
        return this.stringData.substring(16, 18);
    }

    private String getFieldByte2() {
        if (!this.isDataEncrypted()) {
            return null;
        }
        return this.stringData.substring(18, 20);
    }

    private String getT1Data() {
        if (!this.isDataEncrypted()) {
            int endIndex = this.stringData.indexOf("3f");
            return this.stringData.substring(0, endIndex + 2);
        }
        if (!this.isT1DataPresent()) {
            return null;
        }
        return this.stringData.substring(20, (this.getTrack1Length() + 10) * 2);
    }

    private String getT1DataAscii() {
        StringBuffer sf = new StringBuffer();
        if (!this.isDataEncrypted()) {
            for (int i = 0; i < this.getT1Data().length() / 2; ++i) {
                sf.append((char)this.byteData[i]);
            }
            return sf.toString();
        }
        if (!this.isT1DataPresent()) {
            return null;
        }
        for (int i = 10; i < this.getTrack1Length() + 10; ++i) {
            sf.append((char)this.byteData[i]);
        }
        return sf.toString();
    }

    private String getT2Data() {
        if (!this.isDataEncrypted()) {
            int startIndex = this.stringData.indexOf("3b");
            int endIndex1 = this.stringData.indexOf("3f");
            int endIndex2 = this.stringData.lastIndexOf("3f");
            if (endIndex2 > endIndex1 && startIndex > 0) {
                return this.stringData.substring(startIndex, endIndex2 + 2);
            }
            return null;
        }
        if (!this.isT1DataPresent()) {
            return null;
        }
        return this.stringData.substring((this.getTrack1Length() + 10) * 2, (this.getTrack1Length() + 10) * 2 + this.getTrack2Length() * 2);
    }

    private String getT2DataAscii() {
        String strData;
        StringBuffer sf = new StringBuffer();
        if (!this.isDataEncrypted() && null != (strData = this.getT2Data())) {
            if (strData.length() > 0) {
                int startIndex = this.stringData.indexOf("3b");
                int endIndex = this.stringData.lastIndexOf("3f") + 2;
                for (int i = startIndex / 2; i < endIndex / 2; ++i) {
                    sf.append((char)this.byteData[i]);
                }
                return sf.toString();
            }
            return null;
        }
        if (!this.isT1DataPresent()) {
            return null;
        }
        for (int i = this.getTrack1Length() + 10; i < this.getTrack1Length() + 10 + this.getTrack2Length(); ++i) {
            sf.append((char)this.byteData[i]);
        }
        return sf.toString();
    }

    private String getEncryptedSection() {
        if (!this.isDataEncrypted()) {
            return null;
        }
        int startIndex = 20;
        if (this.isT1DataPresent()) {
            startIndex += this.getTrack1Length() * 2;
        }
        if (this.isT2DataPresent()) {
            startIndex += this.getTrack2Length() * 2;
        }
        return this.stringData.substring(startIndex, startIndex + this.lengthOfEncryptedSection() * 2);
    }

    private int lengthOfEncryptedSection() {
        if (!this.isDataEncrypted()) {
            return 0;
        }
        int result = 0;
        if (this.isEncryptedWithTDES()) {
            result = this.getTrack1Length() % 8 == 0 ? (result += this.getTrack1Length()) : (result += this.getTrack1Length() / 8 * 8 + 8);
            result = this.getTrack2Length() % 8 == 0 ? (result += this.getTrack2Length()) : (result += this.getTrack2Length() / 8 * 8 + 8);
        } else if (this.isEncryptedWithAES()) {
            result = this.getTrack1Length() % 16 == 0 ? (result += this.getTrack1Length()) : (result += this.getTrack1Length() / 16 * 16 + 16);
            result = this.getTrack2Length() % 16 == 0 ? (result += this.getTrack2Length()) : (result += this.getTrack2Length() / 16 * 16 + 16);
        } else {
            return 0;
        }
        return result;
    }

    private String getSerialNumber() {
        if (!this.isDataEncrypted()) {
            return null;
        }
        if (!this.isSNPresent()) {
            return null;
        }
        if (this.isKSNPresent()) {
            return this.stringData.substring(this.stringData.length() - 46, this.stringData.length() - 26);
        }
        return this.stringData.substring(this.stringData.length() - 26, this.stringData.length() - 6);
    }

    private String getKSN() {
        if (!this.isDataEncrypted()) {
            return null;
        }
        if (!this.isKSNPresent()) {
            return null;
        }
        return this.stringData.substring(this.stringData.length() - 26, this.stringData.length() - 6);
    }

    private String getLRC() {
        if (!this.isDataEncrypted()) {
            return null;
        }
        return this.stringData.substring(this.stringData.length() - 6, this.stringData.length() - 4);
    }

    private String getCheckSum() {
        if (!this.isDataEncrypted()) {
            return null;
        }
        return this.stringData.substring(this.stringData.length() - 4, this.stringData.length() - 2);
    }

    private String getETX() {
        return this.stringData.substring(this.stringData.length() - 2);
    }

    private byte calculateCheckSum() {
        if (!this.isDataEncrypted()) {
            return 0;
        }
        byte result = 0;
        for (int i = 3; i < this.byteData.length - 3; ++i) {
            result = (byte)(result + this.byteData[i]);
        }
        return result;
    }

    private byte calculateLRC() {
        if (!this.isDataEncrypted()) {
            return 0;
        }
        byte result = 0;
        for (int i = 3; i < this.byteData.length - 3; ++i) {
            result = (byte)(result ^ this.byteData[i]);
        }
        return result;
    }

    private boolean isStartingWithSTX() {
        return this.getSTX().equals("02") || this.getSTX().equals("25");
    }

    private boolean isEndingWithETX() {
        return this.getETX().equalsIgnoreCase("03") || this.getETX().equals("0d");
    }

    private boolean isLRCCorrect() {
        if (!this.isDataEncrypted()) {
            return false;
        }
        String lrc = Integer.toHexString(0xFF & this.calculateLRC());
        if (lrc.length() == 1) {
            lrc = "0" + lrc;
        }
        return lrc.equalsIgnoreCase(this.getLRC());
    }

    private boolean isCheckSumCorrect() {
        if (!this.isDataEncrypted()) {
            return false;
        }
        String checkSum = Integer.toHexString(0xFF & this.calculateCheckSum());
        if (checkSum.length() == 1) {
            checkSum = "0" + checkSum;
        }
        return checkSum.equalsIgnoreCase(this.getCheckSum());
    }

    private boolean isSNPresent() {
        if (!this.isDataEncrypted()) {
            return false;
        }
        String binaryString = this.getFieldByte1Binary();
        if (binaryString.length() != 8) {
            return false;
        }
        return binaryString.charAt(0) == '1';
    }

    private boolean isKSNPresent() {
        if (!this.isDataEncrypted()) {
            return false;
        }
        String binaryString = this.getFieldByte2Binary();
        if (binaryString.length() != 8) {
            return false;
        }
        return binaryString.charAt(0) == '1';
    }

    private boolean isT1DataPresent() {
        if (!this.isDataEncrypted()) {
            return false;
        }
        String binaryString = this.getFieldByte1Binary();
        if (binaryString.length() != 8) {
            return false;
        }
        return binaryString.charAt(7) == '1';
    }

    private boolean isT2DataPresent() {
        if (!this.isDataEncrypted()) {
            return false;
        }
        String binaryString = this.getFieldByte1Binary();
        if (binaryString.length() != 8) {
            return false;
        }
        return binaryString.charAt(6) == '1';
    }

    private boolean isEncryptedWithTDES() {
        if (!this.isDataEncrypted()) {
            return false;
        }
        String binaryString = this.getFieldByte1Binary();
        while (binaryString.length() < 8) {
            binaryString = "00" + binaryString;
        }
        return binaryString.substring(2, 4).equals("00");
    }

    private boolean isEncryptedWithAES() {
        if (!this.isDataEncrypted()) {
            return false;
        }
        String binaryString = this.getFieldByte1Binary();
        if (binaryString.length() != 8) {
            return false;
        }
        return binaryString.substring(2, 4).equals("01");
    }

    private boolean isDataEncrypted() {
        if (this.byteData[0] == 37 && this.byteData[this.byteData.length - 1] == 13) {
            return false;
        }
        return this.byteData[0] == 2 && this.byteData[this.byteData.length - 1] == 3;
    }

    private String getFieldByte1Binary() {
        String binaryString = this.hexToBin(this.getFieldByte1());
        while (binaryString.length() < 8) {
            binaryString = "00" + binaryString;
        }
        return binaryString;
    }

    private String getFieldByte2Binary() {
        String binaryString = this.hexToBin(this.getFieldByte2());
        while (binaryString.length() < 8) {
            binaryString = "00" + binaryString;
        }
        return binaryString;
    }

    private void convertByteToString() {
        String str = null;
        StringBuffer hexString = new StringBuffer();
        for (int i = 0; i < this.byteData.length; ++i) {
            str = Integer.toHexString(0xFF & this.byteData[i]);
            if (str.length() == 1) {
                str = "0" + str;
            }
            hexString.append(str);
        }
        this.stringData = hexString.toString();
    }

    private String byteToString(byte[] value) {
        String str = null;
        StringBuffer hexString = new StringBuffer();
        for (int i = 0; i < value.length; ++i) {
            str = Integer.toHexString(0xFF & value[i]);
            if (str.length() == 1) {
                str = "0" + str;
            }
            hexString.append(str);
        }
        return hexString.toString();
    }

    private String byteToString(byte value) {
        return Integer.toHexString(0xFF & value);
    }

    private void convertStringToByte() {
        for (int i = 0; i < this.stringData.length() / 2; ++i) {
            this.byteData[i] = (byte)((Character.digit(this.stringData.charAt(i * 2), 16) << 4) + Character.digit(this.stringData.charAt(i * 2 + 1), 16));
        }
    }

    private String getStringData() {
        return this.stringData;
    }

    private byte[] getByteData() {
        return this.byteData;
    }

    public String toString() {
        String encryptionType = "No Encryption";
        if (this.isEncryptedWithTDES()) {
            encryptionType = "TDES";
        }
        if (this.isEncryptedWithAES()) {
            encryptionType = "AES";
        }
        if (this.isDataEncrypted()) {
            return "Encryption Type: " + encryptionType + "\nSTX: " + this.getSTX() + "\nData Length: " + this.getDataLength() + "\nCard Encode Type: " + this.getCardEncodeType() + "\nTrack 1-3 Status: " + this.getTrackStatus() + "\nTrack 1 Data Length: " + this.getTrack1Length() + "\nTrack 2 Data Length: " + this.getTrack2Length() + "\nTrack 3 Data Length: " + this.getTrack3Length() + "\nField Byte 1: " + this.getFieldByte1() + "\nField Byte 2: " + this.getFieldByte2() + "\n\nTrack 1 Data: " + this.getT1Data() + "\n\nTrack 1 Data (Ascii): " + this.getT1DataAscii() + "\n\nTrack 2 Data: " + this.getT2Data() + "\n\nTrack 2 Data (Ascii): " + this.getT2DataAscii() + "\n\nEncrypted Section: " + this.getEncryptedSection() + "\n\nSerial Number: " + this.getSerialNumber() + "\nKSN: " + this.getKSN() + "\nLRC: " + this.getLRC() + "\nCheck Sum: " + this.getCheckSum() + "\nETX: " + this.getETX() + "\n\nStrting with STX: " + this.isStartingWithSTX() + "\nEnding with ETX: " + this.isEndingWithETX() + "\nChecking LRC: " + this.isLRCCorrect() + "\nChecking Check Sum: " + this.isCheckSumCorrect() + "\n";
        }
        return "Encryption Type: " + encryptionType + "\nTrack 1 Data: " + this.getT1Data() + "\n\nTrack 1 Data (Ascii): " + this.getT1DataAscii() + "\n\nTrack 2 Data: " + this.getT2Data() + "\n\nTrack 2 Data (Ascii): " + this.getT2DataAscii() + "\n\n";
    }

    private String hexToBin(String hex) {
        return new BigInteger(hex, 16).toString(2);
    }
}

