/*
 * Decompiled with CFR 0.152.
 */
package com.idtechproducts.device.audiojack.io;

import android.content.Context;
import android.content.Intent;
import android.media.AudioRecord;
import android.os.Build;
import com.idtechproducts.device.StructConfigParameters;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

class Recorder {
    private static final String TAG = "SDK::Recorder";
    private final Context _context;
    private boolean _state_isRecording = false;
    private volatile boolean _state_keepRunning = false;
    private StructConfigParameters _config;
    private AudioRecord _recorder;
    private Thread _thread;
    private final BlockingQueue<short[]> _dataQueue = new LinkedBlockingQueue<short[]>();

    public Recorder(Context context) {
        if (context == null) {
            throw new NullPointerException();
        }
        this._context = context;
    }

    public void release() {
        this.stop();
        if (this._recorder != null) {
            try {
                this._recorder.release();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._recorder = null;
        }
    }

    public void setConfig(StructConfigParameters newConfig) {
        boolean isRecordParamEqual;
        if (this._state_isRecording) {
            throw new IllegalStateException("cannot set config while recording");
        }
        if (newConfig == null) {
            throw new NullPointerException();
        }
        boolean bl = isRecordParamEqual = this._config != null && this._config.getFrequenceInput() == newConfig.getFrequenceInput() && this._config.getRecordReadBufferSize() == newConfig.getRecordReadBufferSize() && this._config.getRecordBufferSize() == newConfig.getRecordBufferSize() && this._config.getUseVoiceRecognition() == newConfig.getUseVoiceRecognition();
        if (!isRecordParamEqual) {
            this.release();
        }
        this._config = newConfig.clone();
    }

    public void start() throws IllegalStateException {
        if (this._config == null) {
            throw new IllegalStateException("Recorder has no config");
        }
        if (this._state_isRecording) {
            throw new IllegalStateException("already recording");
        }
        boolean vrAvailable = Build.VERSION.SDK_INT >= 7;
        boolean source_mic = true;
        int source_vr = vrAvailable ? 6 : 1;
        int ar_audioSource = this._config.getUseVoiceRecognition() == 0 ? 1 : source_vr;
        int ar_sampleRate = this._config.getFrequenceInput();
        int ar_channelConfig = 16;
        int ar_audioFormat = 2;
        int ar_bufferSize = this._config.getRecordReadBufferSize();
        if (ar_bufferSize <= 0) {
            ar_bufferSize = AudioRecord.getMinBufferSize((int)ar_sampleRate, (int)ar_channelConfig, (int)ar_audioFormat) * 4;
        }
        if (this._recorder == null) {
            try {
                this._recorder = new AudioRecord(ar_audioSource, ar_sampleRate, ar_channelConfig, ar_audioFormat, ar_bufferSize);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("error instantiating AudioRecord");
            }
            if (this._recorder.getState() != 1) {
                this.release();
                throw new RuntimeException("error instantiating AudioRecord");
            }
        }
        this._recorder.startRecording();
        if (this._recorder.getRecordingState() != 3) {
            this.release();
            throw new RuntimeException("error starting AudioRecord");
        }
        this.broadcastHeadsetPlugEvent(this._config);
        this._state_isRecording = true;
        final BlockingQueue<short[]> queue = this._dataQueue;
        final AudioRecord ar = this._recorder;
        int shovelSize_byte = this._config.getRecordBufferSize() > 0 ? this._config.getRecordBufferSize() : ar_bufferSize / 2;
        final int shovelSize_elements = shovelSize_byte / 2;
        this._dataQueue.clear();
        this._state_keepRunning = true;
        this._thread = new Thread(){

            @Override
            public void run() {
                short[] shovel = null;
                block0: while (Recorder.this._state_keepRunning) {
                    shovel = new short[shovelSize_elements];
                    int elementsInShovel = 0;
                    while (elementsInShovel < shovel.length) {
                        int elementsRead = ar.read(shovel, elementsInShovel, shovel.length - elementsInShovel);
                        if (!Recorder.this._state_keepRunning) break block0;
                        if (elementsRead < 0) continue;
                        elementsInShovel += elementsRead;
                    }
                    if (queue.size() > 600) {
                        queue.remove();
                    }
                    queue.add(shovel);
                }
                ar.stop();
            }
        };
        this._thread.setName("UMRecorder");
        this._thread.start();
    }

    public BlockingQueue<short[]> getDataQueue() {
        return this._dataQueue;
    }

    public void stop() {
        this._state_keepRunning = false;
        if (this._thread != null) {
            try {
                while (this._thread != null && this._thread.isAlive()) {
                    this._thread.join();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this._thread = null;
        }
        this._state_isRecording = false;
    }

    private void broadcastHeadsetPlugEvent(StructConfigParameters config) {
        if (config.getForceHeadsetPlug() == 1 && Build.VERSION.SDK_INT == 8) {
            Intent intent = new Intent("android.intent.action.HEADSET_PLUG");
            intent.addFlags(0x40000000);
            intent.putExtra("state", 1);
            intent.putExtra("microphone", 1);
            intent.putExtra("false_event", 1);
            this._context.sendBroadcast(intent);
        }
    }
}

