/*
 * Decompiled with CFR 0.152.
 */
package com.idtechproducts.device.audiojack.io;

import android.media.AudioTrack;
import com.idtechproducts.device.Common;
import com.idtechproducts.device.audiojack.io.PlayerAudioTrack;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;

public class UARTPlayerAudioTrack
extends PlayerAudioTrack {
    static final int kAUDIO_CHANNEL = 4;
    static final int kAUDIO_ENCODING = 3;
    byte H = (byte)-1;
    byte M = (byte)-128;
    byte L = 1;
    byte[] midFrame = new byte[]{this.M};
    byte[] lineFrame = null;
    byte[] positiveFrame = null;
    byte[] negativeFrame = null;
    byte[] positiveFrameLine = null;
    byte[] peak2idleSmooth = new byte[20];

    @Override
    public AudioTrack getCommandAudioTrack(byte[] commandString) {
        int[] ret_loopFrameIndex;
        boolean coverAllBaudRate;
        byte[] toneData;
        int outputFreq = this.config.getFrequenceOutput();
        AudioTrack ret = new AudioTrack(3, outputFreq, 4, 3, (toneData = this.synthesizeCommandString(commandString, coverAllBaudRate = Common.coverAllBaudRate, outputFreq, ret_loopFrameIndex = new int[2])).length, 0);
        if (ret.write(toneData, 0, toneData.length) != toneData.length) {
            ret.release();
            toneData = null;
            throw new RuntimeException();
        }
        if (ret.getState() != 1) {
            toneData = null;
            throw new RuntimeException();
        }
        toneData = null;
        return ret;
    }

    private void adjustFrame(int adjustBaudrate) {
        int i;
        int playbackFrequency = this.config.getFrequenceOutput();
        this.positiveFrame = null;
        this.negativeFrame = null;
        if (1 == this.config.getDirectionOutputWave()) {
            this.H = 1;
            this.L = (byte)-1;
            for (i = 0; i < 20; ++i) {
                this.peak2idleSmooth[i] = (byte)((i + 1) * 6);
            }
        } else {
            this.H = (byte)-1;
            this.L = 1;
            for (i = 0; i < 20; ++i) {
                this.peak2idleSmooth[i] = (byte)(255 - (i + 1) * 6);
            }
        }
        int sampleCount = (int)Math.round((double)playbackFrequency / (double)adjustBaudrate);
        switch (sampleCount) {
            case 3: {
                this.positiveFrame = new byte[sampleCount - 1];
                this.positiveFrameLine = new byte[sampleCount - 1];
                this.negativeFrame = new byte[sampleCount - 1];
                this.lineFrame = new byte[sampleCount - 1];
                for (int i2 = 0; i2 < sampleCount - 1; ++i2) {
                    this.positiveFrame[i2] = this.H;
                    this.negativeFrame[i2] = this.L;
                    this.lineFrame[i2] = this.M;
                }
                break;
            }
            case 5: 
            case 10: 
            case 20: {
                this.positiveFrame = new byte[sampleCount];
                this.positiveFrameLine = new byte[sampleCount];
                this.negativeFrame = new byte[sampleCount];
                this.lineFrame = new byte[sampleCount];
                for (int i3 = 0; i3 < sampleCount; ++i3) {
                    this.positiveFrame[i3] = this.H;
                    this.negativeFrame[i3] = this.L;
                    this.lineFrame[i3] = this.M;
                }
                break;
            }
        }
        System.arraycopy(this.positiveFrame, 0, this.positiveFrameLine, 0, this.positiveFrame.length);
    }

    private byte[] getWaveBufferData(byte[] charBuffer, int sampleCount) {
        ArrayList<byte[]> _listWaveData = new ArrayList<byte[]>();
        switch (sampleCount) {
            case 3: {
                byte[] tmpUARTByte;
                byte _data;
                int i;
                if (charBuffer == null) break;
                for (i = 0; i < charBuffer.length; ++i) {
                    _data = charBuffer[i];
                    tmpUARTByte = this.getWaveBufferDataByFlag3(_data);
                    _listWaveData.add(tmpUARTByte);
                }
                break;
            }
            case 5: 
            case 10: 
            case 20: {
                byte[] tmpUARTByte;
                byte _data;
                int i;
                if (charBuffer == null) break;
                for (i = 0; i < charBuffer.length; ++i) {
                    _data = charBuffer[i];
                    tmpUARTByte = this.getWaveBufferDataByFlag5X(_data);
                    _listWaveData.add(tmpUARTByte);
                }
                break;
            }
        }
        int totaoLenEx = 0;
        int totaoLen = 0;
        if (_listWaveData.size() <= 0) {
            return null;
        }
        for (int i = 0; i < _listWaveData.size(); ++i) {
            totaoLen += ((byte[])_listWaveData.get(i)).length;
        }
        byte[] realBuffer = new byte[totaoLen];
        for (int i = 0; i < _listWaveData.size(); ++i) {
            System.arraycopy(_listWaveData.get(i), 0, realBuffer, totaoLenEx, ((byte[])_listWaveData.get(i)).length);
            totaoLenEx += ((byte[])_listWaveData.get(i)).length;
        }
        _listWaveData.clear();
        _listWaveData = null;
        charBuffer = null;
        return realBuffer;
    }

    private byte[] getWaveBufferDataByFlag3(byte halfByte) {
        int writePos = 0;
        byte[] realBuffer = new byte[this.positiveFrame.length * 10 + 5];
        System.arraycopy(this.negativeFrame, 0, realBuffer, writePos, this.negativeFrame.length);
        writePos += this.negativeFrame.length;
        byte flag = (byte)(halfByte >> 4 & 0xF);
        switch (flag) {
            case 0: {
                byte oneBit = 0;
                byte fourBits = halfByte;
                for (int i = 0; i < 4; ++i) {
                    oneBit = (byte)(fourBits & 1);
                    if (oneBit == 0) {
                        System.arraycopy(this.positiveFrame, 0, realBuffer, writePos, this.positiveFrame.length);
                        System.arraycopy(this.midFrame, 0, realBuffer, writePos += this.positiveFrame.length, this.midFrame.length);
                        System.arraycopy(this.negativeFrame, 0, realBuffer, writePos += this.midFrame.length, this.negativeFrame.length);
                        writePos += this.negativeFrame.length;
                    } else {
                        System.arraycopy(this.negativeFrame, 0, realBuffer, writePos, this.negativeFrame.length);
                        System.arraycopy(this.midFrame, 0, realBuffer, writePos += this.negativeFrame.length, this.midFrame.length);
                        System.arraycopy(this.positiveFrame, 0, realBuffer, writePos += this.midFrame.length, this.positiveFrame.length);
                        writePos += this.positiveFrame.length;
                    }
                    fourBits = (byte)(halfByte >> 1 + i);
                }
                System.arraycopy(this.positiveFrame, 0, realBuffer, writePos, this.positiveFrame.length);
                writePos += this.positiveFrame.length;
                break;
            }
            case 15: {
                writePos = 0;
                realBuffer = null;
                realBuffer = new byte[this.positiveFrameLine.length];
                for (int i = 0; i < 1; ++i) {
                    System.arraycopy(this.positiveFrameLine, 0, realBuffer, writePos, this.positiveFrameLine.length);
                    writePos += this.positiveFrameLine.length;
                }
                break;
            }
            case 7: {
                realBuffer = null;
                realBuffer = new byte[this.lineFrame.length];
                writePos = 0;
                for (int i = 0; i < 1; ++i) {
                    System.arraycopy(this.lineFrame, 0, realBuffer, writePos, this.lineFrame.length);
                    writePos += this.lineFrame.length;
                }
                break;
            }
            case 6: {
                realBuffer = null;
                realBuffer = new byte[this.peak2idleSmooth.length];
                writePos = 0;
                for (int i = 0; i < 1; ++i) {
                    System.arraycopy(this.peak2idleSmooth, 0, realBuffer, writePos, this.peak2idleSmooth.length);
                    writePos += this.peak2idleSmooth.length;
                }
                break;
            }
        }
        return realBuffer;
    }

    private byte[] getWaveBufferDataByFlag5X(byte halfByte) {
        int writePos = 0;
        byte[] realBuffer = new byte[this.positiveFrame.length * 10];
        System.arraycopy(this.negativeFrame, 0, realBuffer, writePos, this.negativeFrame.length);
        writePos += this.negativeFrame.length;
        byte flag = (byte)(halfByte >> 4 & 0xF);
        switch (flag) {
            case 0: {
                byte oneBit = 0;
                byte fourBits = halfByte;
                for (int i = 0; i < 4; ++i) {
                    oneBit = (byte)(fourBits & 1);
                    if (oneBit == 0) {
                        System.arraycopy(this.positiveFrame, 0, realBuffer, writePos, this.positiveFrame.length);
                        System.arraycopy(this.negativeFrame, 0, realBuffer, writePos += this.positiveFrame.length, this.negativeFrame.length);
                        writePos += this.negativeFrame.length;
                    } else {
                        System.arraycopy(this.negativeFrame, 0, realBuffer, writePos, this.negativeFrame.length);
                        System.arraycopy(this.positiveFrame, 0, realBuffer, writePos += this.negativeFrame.length, this.positiveFrame.length);
                        writePos += this.positiveFrame.length;
                    }
                    fourBits = (byte)(halfByte >> 1 + i);
                }
                System.arraycopy(this.positiveFrame, 0, realBuffer, writePos, this.positiveFrame.length);
                writePos += this.positiveFrame.length;
                break;
            }
            case 15: {
                writePos = 0;
                realBuffer = null;
                realBuffer = new byte[this.positiveFrameLine.length];
                for (int i = 0; i < 1; ++i) {
                    System.arraycopy(this.positiveFrameLine, 0, realBuffer, writePos, this.positiveFrameLine.length);
                    writePos += this.positiveFrameLine.length;
                }
                break;
            }
            case 7: {
                realBuffer = null;
                realBuffer = new byte[this.lineFrame.length];
                writePos = 0;
                for (int i = 0; i < 1; ++i) {
                    System.arraycopy(this.lineFrame, 0, realBuffer, writePos, this.lineFrame.length);
                    writePos += this.lineFrame.length;
                }
                break;
            }
            case 6: {
                realBuffer = null;
                realBuffer = new byte[this.peak2idleSmooth.length];
                writePos = 0;
                for (int i = 0; i < 1; ++i) {
                    System.arraycopy(this.peak2idleSmooth, 0, realBuffer, writePos, this.peak2idleSmooth.length);
                    writePos += this.peak2idleSmooth.length;
                }
                break;
            }
        }
        return realBuffer;
    }

    private String writethedata(byte[] data, int length, boolean bSetBR) {
        Calendar c = Calendar.getInstance();
        int mHour = 0;
        int mMinute = 0;
        int mDay = 0;
        int second = 0;
        mDay = c.get(5);
        mHour = c.get(11);
        mMinute = c.get(12);
        second = c.get(13);
        int frequenceAudio = this.config.getFrequenceOutput();
        String strFileN = null;
        strFileN = String.format(Locale.US, "IDT_Log_Wave_%d_%d_%d_%d_%d.wav", mDay, mHour, mMinute, second, frequenceAudio);
        String _strSaveLogFilePath = Common.getMyStorageFilePath(Common.context);
        String strFileName = _strSaveLogFilePath + File.separator + strFileN;
        RandomAccessFile fisWriter = null;
        try {
            fisWriter = new RandomAccessFile(strFileName, "rw");
        }
        catch (FileNotFoundException e2) {
            e2.printStackTrace();
            return strFileN;
        }
        byte[] wav_template = new byte[]{82, 73, 70, 70, 48, 0, 0, 0, 87, 65, 86, 69, 102, 109, 116, 32, 16, 0, 0, 0, 1, 0, 1, 0, -128, -69, 0, 0, 0, 119, 1, 0, 1, 0, 8, 0, 100, 97, 116, 97, 0, 0, 0, 0};
        try {
            fisWriter.write(wav_template);
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return strFileN;
        }
        byte[] realBuffer = data;
        int dataBlock = length;
        try {
            fisWriter.write(realBuffer);
            realBuffer = null;
        }
        catch (IOException e) {
            e.printStackTrace();
            realBuffer = null;
            return strFileN;
        }
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return strFileN;
        }
        try {
            fisWriter.seek(4L);
            long wavelength = wav_template.length + dataBlock - 8;
            byte[] byteWaveLength = new byte[]{(byte)(wavelength & 0xFFL), (byte)(wavelength >> 8 & 0xFFL), (byte)(wavelength >> 16 & 0xFFL), (byte)(wavelength >> 24 & 0xFFL)};
            fisWriter.write(byteWaveLength);
            fisWriter.seek(24L);
            byteWaveLength[0] = (byte)(frequenceAudio & 0xFF);
            byteWaveLength[1] = (byte)(frequenceAudio >> 8 & 0xFF);
            byteWaveLength[2] = (byte)(frequenceAudio >> 16 & 0xFF);
            byteWaveLength[3] = (byte)(frequenceAudio >> 24 & 0xFF);
            fisWriter.write(byteWaveLength);
            int frqA_2 = frequenceAudio * 2;
            fisWriter.seek(28L);
            byteWaveLength[0] = (byte)(frqA_2 & 0xFF);
            byteWaveLength[1] = (byte)(frqA_2 >> 8 & 0xFF);
            byteWaveLength[2] = (byte)(frqA_2 >> 16 & 0xFF);
            byteWaveLength[3] = (byte)(frqA_2 >> 24 & 0xFF);
            fisWriter.write(byteWaveLength);
            fisWriter.seek(40L);
            byteWaveLength[0] = (byte)(dataBlock & 0xFF);
            byteWaveLength[1] = (byte)(dataBlock >> 8 & 0xFF);
            byteWaveLength[2] = (byte)(dataBlock >> 16 & 0xFF);
            byteWaveLength[3] = (byte)(dataBlock >> 24 & 0xFF);
            fisWriter.write(byteWaveLength);
            fisWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return strFileN;
        }
        return strFileN;
    }

    private byte[] synthesizeCommandString(byte[] command_string, boolean coverAllBaudRate, int playbackFrequency, int[] ret_loopFrameIndex) {
        int baudrate = this.config.getBaudRate();
        ArrayList<byte[]> _listWaveData = new ArrayList<byte[]>();
        int sampleCount = (int)Math.round((double)playbackFrequency / (double)baudrate);
        byte[] realBuffer = null;
        if (!coverAllBaudRate) {
            this.adjustFrame(this.config.getBaudRate());
            realBuffer = this.getWaveBufferData(command_string, sampleCount);
        } else {
            int i;
            int[] baudList = new int[]{9600, 4800, 2400};
            for (int i2 = 0; i2 < 3; ++i2) {
                baudrate = baudList[i2];
                byte[] data = Common.makeSetBaudAndLevelCommand(this.config, baudrate);
                this.adjustFrame(baudrate);
                sampleCount = (int)Math.round((double)playbackFrequency / (double)baudrate);
                byte[] tmpUARTByte = this.getWaveBufferData(data, sampleCount);
                _listWaveData.add(tmpUARTByte);
            }
            int totaoLenEx = 0;
            int totaoLen = 0;
            if (_listWaveData.size() <= 0) {
                return null;
            }
            for (i = 0; i < _listWaveData.size(); ++i) {
                totaoLen += ((byte[])_listWaveData.get(i)).length;
            }
            realBuffer = new byte[totaoLen];
            for (i = 0; i < _listWaveData.size(); ++i) {
                System.arraycopy(_listWaveData.get(i), 0, realBuffer, totaoLenEx, ((byte[])_listWaveData.get(i)).length);
                totaoLenEx += ((byte[])_listWaveData.get(i)).length;
            }
            _listWaveData.clear();
            _listWaveData = null;
        }
        return realBuffer;
    }
}

