/*
 * Decompiled with CFR 0.152.
 */
package com.idtechproducts.device.bluetooth;

import android.app.Activity;
import android.app.PendingIntent;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothSocket;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.util.Log;
import android.widget.Toast;
import com.idtechproducts.device.Common;
import com.idtechproducts.device.IDTMSRData;
import com.idtechproducts.device.IDT_Device;
import com.idtechproducts.device.ReaderInfo;
import com.idtechproducts.device.ResDataStruct;
import com.idtechproducts.device.audiojack.UMLog;
import com.idtechproducts.device.bluetooth.BluetoothControllerMsg;
import com.idtechproducts.device.bluetooth.IDTechBluetoothMsg;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;
import java.util.UUID;

public class BluetoothController
extends Activity {
    private static final String TAG = "SDK::BT Controller";
    private PendingIntent pi;
    private BluetoothDevice btDevice = null;
    private static boolean connection = false;
    private Context ctx = null;
    private static IDTechBluetoothMsg _msg = null;
    private BluetoothControllerMsg _btMsg = null;
    private IntentFilter mBTFilter = null;
    private CheckDeviceThread checkThread;
    private Set<BluetoothDevice> pairedDevices;
    private BluetoothAdapter mBluetoothAdapter;
    private boolean result = false;
    private BroadcastReceiver btReceiver = null;
    private static boolean btEnabled = false;
    private InputStream is = null;
    private OutputStream os = null;
    private BluetoothSocket mmSocket = null;
    private boolean waitingForResult = false;
    private int swipeTimeoutSec;
    private int swipeCount = 0;
    private SwipeDataReceiver swipeThread;
    private byte[] swipeBuffer;
    private byte[] temp;
    private boolean registered = false;
    private boolean cancelFlag = false;
    boolean inLoop = false;

    public BluetoothController(Context context, IDTechBluetoothMsg msg, BluetoothControllerMsg msg2) {
        this.ctx = context;
        _msg = msg;
        this._btMsg = msg2;
        this.swipeBuffer = new byte[1024];
        this.swipeTimeoutSec = 200;
    }

    public static boolean isBTEnabled() {
        return btEnabled;
    }

    public boolean isConnected() {
        return connection;
    }

    private boolean init() {
        this.mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        if (this.mBluetoothAdapter == null) {
            Toast.makeText((Context)this.getApplicationContext(), (CharSequence)"Your device does not support Bluetooth", (int)1).show();
            return false;
        }
        if (this.btDevice == null) {
            return false;
        }
        this.btConnect();
        return true;
    }

    public boolean initWithThread() {
        if (connection) {
            return true;
        }
        this.mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        if (this.mBluetoothAdapter == null) {
            return false;
        }
        if (!this.mBluetoothAdapter.isEnabled()) {
            btEnabled = false;
            return false;
        }
        if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_BTPAY || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_BTMAG) {
            btEnabled = true;
            this.btDevice = null;
            this.pairedDevices = this.mBluetoothAdapter.getBondedDevices();
            String deviceName = null;
            if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_BTPAY) {
                deviceName = "BTPay";
            } else if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_BTMAG) {
                deviceName = "BT MAG";
            }
            for (BluetoothDevice device : this.pairedDevices) {
                if (!device.getName().startsWith(deviceName)) continue;
                this.btDevice = device;
                break;
            }
        }
        if (this.btDevice == null) {
            return false;
        }
        this.btConnect();
        return true;
    }

    public void startCheckingConnection() {
        UMLog.i(TAG, "SDK starts monitoring if reader is connected.");
        this.checkThread = new CheckDeviceThread();
        this.checkThread.start();
    }

    public boolean isRegistered() {
        return this.registered;
    }

    public void registerReceiver() {
        UMLog.i(TAG, "Register a Broadcast receiver to get BluetoothDevice.ACTION_FOUND.");
        this.btReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                if ("android.bluetooth.device.action.FOUND".equals(action)) {
                    BluetoothDevice bluetoothDevice = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                } else if ("android.bluetooth.device.action.ACL_CONNECTED".equals(action)) {
                    connection = true;
                    _msg.bt_onReceiveMsgConnected();
                } else if ("android.bluetooth.device.action.ACL_DISCONNECTED".equals(action)) {
                    connection = false;
                    _msg.bt_onReceiveMsgDisconnected();
                }
            }
        };
        IntentFilter filter = new IntentFilter("android.bluetooth.device.action.FOUND");
        this.ctx.registerReceiver(this.btReceiver, filter);
        IntentFilter filter1 = new IntentFilter("android.bluetooth.device.action.ACL_CONNECTED");
        IntentFilter filter3 = new IntentFilter("android.bluetooth.device.action.ACL_DISCONNECTED");
        this.ctx.registerReceiver(this.btReceiver, filter1);
        this.ctx.registerReceiver(this.btReceiver, filter3);
        this.registered = true;
    }

    public void unregisterReceiver() {
        UMLog.i(TAG, "A Broadcast receiver unregistered.");
        this.ctx.unregisterReceiver(this.btReceiver);
        this.close();
        this.mBTFilter = null;
        this.registered = false;
    }

    public boolean enableSwipe() {
        if (!connection || this.waitingForResult) {
            return false;
        }
        UMLog.i(TAG, "SDK starts polling card data from reader.");
        if (this.swipeThread != null) {
            this.swipeThread.close();
        }
        this.swipeThread = new SwipeDataReceiver();
        this.waitingForResult = true;
        this.swipeCount = 0;
        this.swipeThread.start();
        return true;
    }

    public boolean enableRead(int timeout, ResDataStruct respData) {
        if (!connection) {
            return false;
        }
        long startTime = System.currentTimeMillis();
        UMLog.i(TAG, "SDK starts polling data from reader.");
        respData.resData = new byte[]{0, 13, 0};
        while (System.currentTimeMillis() - startTime < (long)((timeout + 10) * 1000)) {
            int length = this.readMSR(this.swipeBuffer);
            if (length > 0) {
                if (this.swipeBuffer[0] != 6) {
                    return false;
                }
                respData.resData = new byte[length - 1];
                System.arraycopy(this.swipeBuffer, 1, respData.resData, 0, length - 1);
                UMLog.i(TAG, "got: " + Common.getByteArrDesc(this.swipeBuffer));
                break;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (timeout != 0) continue;
            startTime = System.currentTimeMillis();
        }
        return true;
    }

    public boolean readMessage(int timeout, long startTime, ResDataStruct respData) {
        if (!connection) {
            return false;
        }
        respData.resData = new byte[]{0, 13, 0};
        byte[] buff = new byte[2048];
        int res = 0;
        long endTime = System.currentTimeMillis();
        while (endTime - startTime <= (long)(timeout * 1000)) {
            if (IDT_Device.isTransactionRead && (IDT_Device.emvCancelTransaction || IDT_Device.cancelTransaction)) {
                Log.i((String)TAG, (String)"## Transaction Cancelled ");
                return false;
            }
            try {
                res = this.is.available();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (res > 0) {
                try {
                    res = this.is.read(buff);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (res > 0) break;
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            endTime = System.currentTimeMillis();
        }
        this.clearReadBuffer(this.is);
        IDT_Device.isTransactionRead = false;
        if (endTime - startTime > (long)(timeout * 1000)) {
            return false;
        }
        if (res > 0) {
            UMLog.i("**getResponse**", Common.base16Encode(respData.resData));
            _msg.bt_onReceiveMsgGetResponse(respData.resData);
            if (res > 6) {
                respData.resData = null;
                respData.resData = new byte[res - 6];
                System.arraycopy(buff, 3, respData.resData, 0, res - 6);
                return true;
            }
        }
        return false;
    }

    public void disableSwipe() {
        UMLog.i(TAG, "SDK stops polling card data from reader.");
        if (this.swipeThread != null) {
            this.swipeThread.close();
        }
        this.waitingForResult = false;
    }

    private boolean isSwipeEnabled() {
        return this.waitingForResult;
    }

    public void setTimeoutOfSwipeCard(int timeoutInSec) {
        UMLog.i(TAG, "Timeout for card swipe changed to " + timeoutInSec + " seconds.");
        this.swipeTimeoutSec = timeoutInSec;
    }

    public int cancelTransaction() {
        if (!this.inLoop) {
            return 10;
        }
        this.cancelFlag = true;
        return 0;
    }

    public byte[] sendCommand(byte[] command, int timeout) {
        if (!connection || this.waitingForResult) {
            UMLog.i(TAG, "Failed to send a command: ");
            this.waitingForResult = false;
            return null;
        }
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        long startTime = System.currentTimeMillis();
        byte[] responseData = null;
        byte[] buff = new byte[2048];
        int res = 0;
        this.clearReadBuffer(this.is);
        try {
            this.os.write(command);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.cancelFlag = false;
        while (System.currentTimeMillis() - startTime < (long)((timeout + 3) * 1000)) {
            this.inLoop = true;
            if (this.cancelFlag) {
                this.cancelFlag = false;
                try {
                    this.os.write(Common.grsiP2Command((byte)5, (byte)1, new byte[0]));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            try {
                res = this.is.available();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (res > 0) {
                try {
                    res = this.is.read(buff);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_BTPAY ? res > 0 && buff[0] == 2 && (buff[3] == 6 || buff[3] == 21) : res > 0) break;
            try {
                Thread.sleep(700L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (timeout != 0) continue;
            startTime = System.currentTimeMillis();
        }
        this.inLoop = false;
        this.clearReadBuffer(this.is);
        if (res > 0) {
            responseData = null;
            responseData = new byte[res];
            System.arraycopy(buff, 0, responseData, 0, res);
            this.waitingForResult = false;
            UMLog.i("**getResponse**", Common.base16Encode(responseData));
            _msg.bt_onReceiveMsgGetResponse(responseData);
            return responseData;
        }
        this.waitingForResult = false;
        return null;
    }

    public byte[] sendCommandOnly(byte[] command, int timeout) {
        if (!connection || this.waitingForResult) {
            UMLog.i(TAG, "Failed to send a command: ");
            this.waitingForResult = false;
            return null;
        }
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.clearReadBuffer(this.is);
        try {
            this.os.write(command);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.waitingForResult = false;
        return null;
    }

    private void clearReadBuffer(InputStream is) {
        int res = 0;
        byte[] buff = new byte[2048];
        try {
            res = is.available();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (res > 0) {
            try {
                res = is.read(buff);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static String asciiBytesToString(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return "";
        }
        char[] result = new char[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            result[i] = (char)bytes[i];
        }
        return new String(result);
    }

    public byte[] sendCommandFw(byte[] command) {
        if (!connection || this.waitingForResult) {
            UMLog.i(TAG, "Failed to send a command: ");
            this.waitingForResult = false;
            return null;
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        byte[] responseData = null;
        byte[] buff = new byte[2048];
        int res = 0;
        this.clearReadBuffer(this.is);
        try {
            this.os.write(command, 0, command.length);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        for (int i = 0; i < 5; ++i) {
            try {
                res = this.is.available();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (res > 0) {
                try {
                    this.is.read(buff);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (res > 0) break;
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.clearReadBuffer(this.is);
        if (res > 0) {
            responseData = null;
            responseData = new byte[res];
            System.arraycopy(buff, 0, responseData, 0, res);
            this.waitingForResult = false;
            return responseData;
        }
        this.waitingForResult = false;
        return null;
    }

    private int readMSR(byte[] data) {
        if (!connection) {
            return 0;
        }
        this.temp = new byte[1024];
        int dataLen = 0;
        int res = 0;
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        try {
            res = this.is.available();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (res == 0) {
            return 0;
        }
        do {
            try {
                res = this.is.read(this.temp);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                Thread.sleep(150L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } while (res <= 5 || this.temp[0] != 2);
        if (res > 0) {
            if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_BTMAG) {
                dataLen = res - 2;
                System.arraycopy(this.temp, 1, data, 0, dataLen);
            } else {
                dataLen = (this.temp[1] & 0xFF) + (this.temp[2] & 0xFF) * 256;
                System.arraycopy(this.temp, 3, data, 0, dataLen);
                byte[] tmp = new byte[dataLen];
                System.arraycopy(this.temp, 3, tmp, 0, dataLen);
                try {
                    Thread.sleep(30L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            return dataLen;
        }
        return 0;
    }

    private boolean close() {
        if (connection) {
            this.cancel();
            connection = false;
        }
        System.gc();
        return true;
    }

    private void btConnect() {
        UUID MY_UUID = UUID.fromString("00001101-0000-1000-8000-00805f9b34fb");
        boolean hasException = false;
        try {
            this.mmSocket = this.btDevice.createInsecureRfcommSocketToServiceRecord(MY_UUID);
            this.mmSocket.connect();
        }
        catch (IOException e) {
            hasException = true;
        }
        if (hasException) {
            this.is = null;
            this.os = null;
            if (this.mmSocket != null) {
                try {
                    this.mmSocket.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            this.mmSocket = null;
        } else {
            try {
                this.is = this.mmSocket.getInputStream();
                this.os = this.mmSocket.getOutputStream();
            }
            catch (IOException e) {
                this.is = null;
                this.os = null;
            }
        }
    }

    private void cancel() {
        try {
            if (this.mmSocket != null) {
                this.mmSocket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.mmSocket = null;
        this.is = null;
        this.os = null;
        connection = false;
    }

    private class CheckDeviceThread
    extends Thread {
        boolean res = false;

        private CheckDeviceThread() {
        }

        @Override
        public void run() {
            try {
                CheckDeviceThread.sleep(300L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            while (!this.res) {
                this.res = BluetoothController.this.initWithThread();
                try {
                    CheckDeviceThread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private class SwipeDataReceiver
    extends Thread {
        private boolean swipeCancelled = false;

        private SwipeDataReceiver() {
        }

        @Override
        public void run() {
            while (BluetoothController.this.swipeCount < BluetoothController.this.swipeTimeoutSec && !this.swipeCancelled) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                int length = BluetoothController.this.readMSR(BluetoothController.this.swipeBuffer);
                if (length > 0) {
                    this.swipeCancelled = true;
                    IDTMSRData card = new IDTMSRData();
                    byte[] cardData = new byte[length];
                    System.arraycopy(BluetoothController.this.swipeBuffer, 0, cardData, 0, length);
                    if (cardData[0] == 2 && (cardData[3] == -128 || cardData[3] == -127 || cardData[3] == -125 || cardData[3] == -124 || cardData[3] == -123 || cardData[3] == -122 || cardData[3] == -64)) {
                        Common.Response.parseCardData(cardData, card, 3);
                    } else if (cardData[1] == 2 && (BluetoothController.this.temp[4] == -128 || cardData[4] == -127 || cardData[4] == -125 || cardData[4] == -124 || cardData[4] == -123 || cardData[4] == -122 || cardData[4] == -64)) {
                        Common.Response.parseCardDataUniPay(cardData, card);
                    } else {
                        Common.Response.parseCardClearData(cardData, card);
                    }
                    UMLog.i(BluetoothController.TAG, "got: " + Common.getByteArrDesc(BluetoothController.this.swipeBuffer));
                    _msg.bt_onReceiveMsgCardData(card);
                    break;
                }
                BluetoothController.this.swipeCount++;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (BluetoothController.this.swipeCount >= BluetoothController.this.swipeTimeoutSec) {
                this.close();
                _msg.bt_onReceiveMsgSwipeTimeout();
            }
            BluetoothController.this.waitingForResult = false;
            IDT_Device.isCommandRunning = false;
        }

        public void close() {
            this.swipeCancelled = true;
        }
    }
}

