/*
 * Decompiled with CFR 0.152.
 */
package com.idtechproducts.device.usb;

import android.content.Context;
import com.idtechproducts.device.Common;
import com.idtechproducts.device.IDT_Device;
import com.idtechproducts.device.ReaderInfo;
import com.idtechproducts.device.ResDataStruct;
import com.idtechproducts.device.USBBypassListener;
import com.idtechproducts.device.audiojack.UMLog;
import com.idtechproducts.device.audiojack.tools.FirmwareUpdateTool;
import com.idtechproducts.device.audiojack.tools.FirmwareUpdateToolMsg;
import com.idtechproducts.device.usb.IDTechUsbHidMsg;
import com.idtechproducts.device.usb.UsbController;
import com.idtechproducts.device.usb.UsbControllerMsg;
import java.util.Arrays;

public class IDTechUsbHid {
    private static final String SDK_VER_STRING = "ID TECH USB-HID SDK Ver 1.0";
    private static final String TAG = "SDK::USB";
    private final int FW_CMD_RETRY = 10;
    private static final int VID = 2765;
    private static final int PID_UNIPAY = 12560;
    private static final int PID_MINISMART_II = 13328;
    private static final int PID_VP3300_AJ = 13600;
    private static final int PID_VP3300_BT = 13632;
    private static final int PID_BTPAY = 10512;
    private static final int PID_AUGUSTA = 14368;
    private static final int PID_UNIPAY_I_V = 12592;
    private static final int PID_UNIPAY_I_V_TTK = 12608;
    private static final int PID_AUGUSTA_S_TTK = 14384;
    private static final int PID_AUGUSTA_S = 14624;
    private static final int PID_AUGUSTA_S_THALES = 17424;
    private static final int PID_KIOSK_III = 14096;
    private static final int PID_VP2000 = 17460;
    private static final int PID_KIOSK_III_S = 10288;
    private static final int PID_VENDI = 13584;
    private static final int PID_VP3300_USB = 13616;
    private static final int PID_VP8800 = 16912;
    private static final int PID_SECUREMAG = 8208;
    private static final int PID_SECUREMAG_KB = 8240;
    private static final int PID_PIP_READER = 17984;
    private final IDTechUsbHidMsg _msg;
    private UsbController _usb = null;
    private Context _context;
    private volatile boolean _state_isConnected;
    private IDT_Device.TaskExport _taskExport;
    private USBBypassListener m_recListener;
    boolean isWakeupThreadRunning = false;
    PAT_Wakeup_Runnable wakeup_Runnable = null;
    public static boolean isFirstTimeEraseSpace = true;
    public static boolean isStartFirmwareUpadte = false;

    public void externalConnect() {
        if (IDT_Device.getUSBBypass() && this._usb != null) {
            this._usb.externalConnect();
        }
    }

    public void externalDisconnect() {
        if (IDT_Device.getUSBBypass() && this._usb != null) {
            this._usb.externalDisconnect();
        }
    }

    public void externalDeviceNotFound() {
        if (IDT_Device.getUSBBypass() && this._usb != null) {
            this._usb.externalDeviceNotFound();
        }
    }

    public IDTechUsbHid(IDTechUsbHidMsg callback, Context context, IDT_Device.TaskExport taskExport, USBBypassListener listener, int PID) {
        this.m_recListener = listener;
        this._msg = callback;
        this._context = context;
        this._state_isConnected = false;
        this._taskExport = taskExport;
        switch (this._taskExport.getReaderType()) {
            case DEVICE_MINISMART_II: {
                this._usb = new UsbController(context, this._msg, new UsbControllerMsgImpl(), 2765, 13328, this.m_recListener);
                break;
            }
            case DEVICE_VP3300_AJ_USB: {
                this._usb = new UsbController(context, this._msg, new UsbControllerMsgImpl(), 2765, 13600, this.m_recListener);
                break;
            }
            case DEVICE_VP3300_BT_USB: {
                this._usb = new UsbController(context, this._msg, new UsbControllerMsgImpl(), 2765, 13632, this.m_recListener);
                break;
            }
            case DEVICE_UNIPAY_I_V_USB: {
                if (IDT_Device._isTTK) {
                    this._usb = new UsbController(context, this._msg, new UsbControllerMsgImpl(), 2765, 12608, this.m_recListener);
                    break;
                }
                this._usb = new UsbController(context, this._msg, new UsbControllerMsgImpl(), 2765, 12592, this.m_recListener);
                break;
            }
            case DEVICE_VENDI: {
                this._usb = new UsbController(context, this._msg, new UsbControllerMsgImpl(), 2765, 13584, this.m_recListener);
                break;
            }
            case DEVICE_BTPAY_USB: {
                this._usb = new UsbController(context, this._msg, new UsbControllerMsgImpl(), 2765, 10512, this.m_recListener);
                break;
            }
            case DEVICE_AUGUSTA: {
                if (IDT_Device._isSRED) {
                    this._usb = new UsbController(context, this._msg, new UsbControllerMsgImpl(), 2765, 14624, this.m_recListener);
                    break;
                }
                if (IDT_Device._isTTK) {
                    this._usb = new UsbController(context, this._msg, new UsbControllerMsgImpl(), 2765, 14384, this.m_recListener);
                    break;
                }
                if (IDT_Device._isThales) {
                    this._usb = new UsbController(context, this._msg, new UsbControllerMsgImpl(), 2765, 17424, this.m_recListener);
                    break;
                }
                this._usb = new UsbController(context, this._msg, new UsbControllerMsgImpl(), 2765, 14368, this.m_recListener);
                break;
            }
            case DEVICE_KIOSK_III: {
                if (IDT_Device._isSRED) {
                    this._usb = new UsbController(context, this._msg, new UsbControllerMsgImpl(), 2765, 10288, this.m_recListener);
                    break;
                }
                if (PID == 0) {
                    this._usb = new UsbController(context, this._msg, new UsbControllerMsgImpl(), 2765, 14096, this.m_recListener);
                    break;
                }
                this._usb = new UsbController(context, this._msg, new UsbControllerMsgImpl(), 2765, PID, this.m_recListener);
                break;
            }
            case DEVICE_PIP_READER: {
                this._usb = new UsbController(context, this._msg, new UsbControllerMsgImpl(), 2765, 17984, this.m_recListener);
                break;
            }
            case DEVICE_VP3300_USB: {
                this._usb = new UsbController(context, this._msg, new UsbControllerMsgImpl(), 2765, 13616, this.m_recListener);
                break;
            }
            case DEVICE_VP2000: {
                this._usb = new UsbController(context, this._msg, new UsbControllerMsgImpl(), 2765, 17460, this.m_recListener);
                break;
            }
            case DEVICE_NEO2_USB: {
                this._usb = new UsbController(context, this._msg, new UsbControllerMsgImpl(), 2765, PID, this.m_recListener);
                break;
            }
            case DEVICE_VP8800: {
                this._usb = new UsbController(context, this._msg, new UsbControllerMsgImpl(), 2765, 16912, this.m_recListener);
                break;
            }
            case DEVICE_SECUREMAG: {
                this._usb = new UsbController(context, this._msg, new UsbControllerMsgImpl(), 2765, 8208, this.m_recListener);
                break;
            }
            case DEVICE_SECUREMAG_KB: {
                this._usb = new UsbController(context, this._msg, new UsbControllerMsgImpl(), 2765, 8240, this.m_recListener);
                break;
            }
            default: {
                this._usb = new UsbController(context, this._msg, new UsbControllerMsgImpl(), 2765, 12560, this.m_recListener);
            }
        }
    }

    private static String getSDKVersionInfo() {
        return SDK_VER_STRING;
    }

    public void registerListen() {
        if (!this._usb.isRegistered()) {
            this._usb.registerReceiver();
        }
        if (this._usb.init()) {
            this._state_isConnected = true;
            if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB) {
                this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB);
            } else if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_BTPAY_USB) {
                this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_BTPAY_USB);
            } else if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II) {
                this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II);
            } else if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA) {
                this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA);
            } else if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB) {
                this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB);
            } else if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI) {
                this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_VENDI);
            } else if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III) {
                this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III);
            } else if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER) {
                this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER);
            } else if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP2000) {
                this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_VP2000);
            } else if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB) {
                this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB);
            } else if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB) {
                this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB);
            } else if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB) {
                this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB);
            } else if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800) {
                this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_VP8800);
            } else if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG) {
                this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG);
            } else if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG_KB) {
                this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG_KB);
            } else {
                this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_USB);
            }
            this._msg.usb_onReceiveMsgConnected();
        }
    }

    public void unregisterListen() {
        if (this._usb.isRegistered()) {
            this._usb.unregisterReceiver();
        }
        this._state_isConnected = false;
    }

    public boolean isReaderConnected() {
        return this._state_isConnected;
    }

    public byte[] sendCommand(String cmd, int timeout) {
        if (!this._state_isConnected) {
            return null;
        }
        if (Common.isNeedWakeup()) {
            this.PAT_stopWakeupThread();
        }
        if (Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG && Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG_KB) {
            this._usb.disableSwipe();
        }
        byte[] command = Common.makeCommand(cmd);
        if (cmd != null && (cmd.contains("5669564F7465636832009025") || cmd.contains("5669564f7465636832009025"))) {
            UMLog.i("**sendCommand**", "5669564F7465636832009025 timeout: " + timeout);
        } else {
            UMLog.i("**sendCommand**", Common.base16Encode(command) + " timeout: " + timeout);
        }
        byte[] _return = this._usb.sendCommand(command, timeout);
        if (Common.isNeedWakeup()) {
            this.PAT_startWakeupThread();
        }
        return _return;
    }

    public byte[] sendCommand(byte[] command, int timeout) {
        String cmd;
        if (!this._state_isConnected) {
            return null;
        }
        if (Common.isNeedWakeup()) {
            this.PAT_stopWakeupThread();
        }
        if (Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG && Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG_KB) {
            this._usb.disableSwipe();
        }
        if ((cmd = Common.base16Encode(command)) != null && (cmd.contains("5669564F7465636832009025") || cmd.contains("5669564f7465636832009025"))) {
            UMLog.i("**sendCommand**", "5669564F7465636832009025 timeout: " + timeout);
        } else {
            UMLog.i("**sendCommand**", Common.base16Encode(command) + " timeout: " + timeout);
        }
        byte[] _return = this._usb.sendCommand(command, timeout);
        if (Common.isNeedWakeup()) {
            this.PAT_startWakeupThread();
        }
        return _return;
    }

    public byte[] sendCommandOnly(String cmd, int timeout) {
        if (!this._state_isConnected) {
            return null;
        }
        if (Common.isNeedWakeup()) {
            this.PAT_stopWakeupThread();
        }
        this._usb.disableSwipe();
        byte[] command = Common.makeCommand(cmd);
        if (cmd != null && (cmd.contains("5669564F7465636832009025") || cmd.contains("5669564f7465636832009025"))) {
            UMLog.i("**sendCommand**", "5669564F7465636832009025 timeout: " + timeout);
        } else {
            UMLog.i("**sendCommand**", Common.base16Encode(command) + " timeout: " + timeout);
        }
        byte[] _return = this._usb.sendCommandOnly(command, timeout);
        if (Common.isNeedWakeup()) {
            this.PAT_startWakeupThread();
        }
        return _return;
    }

    private byte[] PAT_sendCommand(String cmd, int timeout) {
        if (!this._state_isConnected) {
            return null;
        }
        this._usb.disableSwipe();
        byte[] command = Common.makeCommand(cmd);
        UMLog.i("**PAT_sendCommand**", Common.base16Encode(command) + " timeout: " + timeout);
        byte[] _return = this._usb.sendCommand(command, timeout);
        return _return;
    }

    private boolean isWakeup_Thread_Running() {
        return this.isWakeupThreadRunning;
    }

    public void PAT_Wakeup() {
        this._usb.disableSwipe();
        byte[] command = new byte[]{0};
        int ret = this._usb.writeNothing();
        UMLog.i("**writeNothing:", " ret = " + ret);
    }

    private void PAT_startWakeupThread() {
        if (this.isWakeupThreadRunning) {
            this.PAT_stopWakeupThread();
        }
        this.isWakeupThreadRunning = true;
        this.wakeup_Runnable = new PAT_Wakeup_Runnable();
        this.wakeup_Runnable.start();
    }

    private void PAT_stopWakeupThread() {
        if (!this.isWakeupThreadRunning) {
            return;
        }
        this.isWakeupThreadRunning = false;
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        if (this.wakeup_Runnable != null) {
            while (this.wakeup_Runnable.isAlive()) {
                try {
                    this.wakeup_Runnable.join();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.wakeup_Runnable = null;
        }
    }

    public byte[] sendCommandForRKI(String cmd, int timeout) {
        if (!this._state_isConnected) {
            return null;
        }
        this._usb.disableSwipe();
        byte[] command = IDTechUsbHid.makeCommandForRKI(cmd);
        UMLog.i("**sendCommandForRKI**", Common.base16Encode(command) + " timeout: " + timeout);
        return this._usb.sendCommandForRKI(command, timeout);
    }

    public boolean readMessage(int timeout, long startTime, ResDataStruct respData, boolean ignoreLCDMsg) {
        return this._usb.readMessage(timeout, startTime, respData, ignoreLCDMsg);
    }

    private byte[] sendCommandFw(String cmd) {
        if (!this._state_isConnected) {
            return null;
        }
        byte[] command = Common.makeCommand(cmd);
        return this._usb.sendCommandFw(command);
    }

    public boolean startSwipeCard() {
        UMLog.i(TAG, "To enable Swipe...");
        if (!this._state_isConnected) {
            IDT_Device.isCommandRunning = false;
            return false;
        }
        return this._usb.enableSwipe();
    }

    public boolean startListenCard() {
        UMLog.i(TAG, "To enable Listen...");
        if (!this._state_isConnected) {
            return false;
        }
        return this._usb.enableListen();
    }

    public boolean stopListenCard() {
        UMLog.i(TAG, "To disable Listen...");
        return this._usb.disableListen();
    }

    private boolean startReadCard(int timeout, ResDataStruct respData) {
        UMLog.i(TAG, "To enable read...");
        if (!this._state_isConnected) {
            return false;
        }
        return this._usb.enableRead(timeout, respData);
    }

    private void stopSwipeCard() {
        UMLog.i(TAG, "To disable Swipe...");
        this._usb.disableSwipe();
    }

    public boolean setTimeoutOfSwipeCard(int timeoutValue) {
        this._usb.setTimeoutOfSwipeCard(timeoutValue);
        return true;
    }

    public void readBuffer(ResDataStruct respData) {
        this._usb.readBuffer(respData);
    }

    private boolean enterBootloader() {
        if (this._usb == null) {
            return false;
        }
        byte[] ret = this.sendCommand("78467A495246570000000000000000", 5);
        if (ret != null) {
            UMLog.w(TAG, "RET: " + Common.base16Encode(ret));
            return ret[3] == 6;
        }
        return false;
    }

    public boolean updateFirmware(FirmwareUpdateToolMsg _umtMsg, FirmwareUpdateTool.FMStruct fmFile) {
        if (this._usb == null) {
            return false;
        }
        FwUpdateThread fwThread = new FwUpdateThread(fmFile, _umtMsg);
        fwThread.start();
        return true;
    }

    private static byte[] makeCommandForRKI(String commandBodyData) {
        if (commandBodyData == null) {
            return null;
        }
        String sum = IDTechUsbHid.getSUM(commandBodyData);
        String lrc = IDTechUsbHid.getLRC(commandBodyData);
        short length = (short)(commandBodyData.length() / 2);
        byte[] lowHigh = new byte[2];
        byte[] cmdLen = new byte[1];
        lowHigh[0] = (byte)(length & 0xFF);
        lowHigh[1] = (byte)(length >> 8 & 0xFF);
        cmdLen[0] = lowHigh[0];
        String lengthCommand = Common.getHexStringFromBytes(lowHigh);
        String commandData = "02" + lengthCommand + commandBodyData + lrc + sum + "03";
        return Common.getByteArray(commandData);
    }

    private static String getSUM(String strData) {
        String strLRC = null;
        byte[] toCharArray = Common.getByteArray(strData);
        byte[] sum = new byte[]{toCharArray[0]};
        for (int i = 1; i < toCharArray.length; ++i) {
            sum[0] = (byte)(sum[0] + toCharArray[i]);
        }
        strLRC = Common.getHexStringFromBytes(sum);
        return strLRC;
    }

    private static String getLRC(String strData) {
        String strLRC = null;
        byte[] toCharArray = Common.getByteArray(strData);
        byte[] lrc = new byte[]{toCharArray[0]};
        for (int i = 1; i < toCharArray.length; ++i) {
            lrc[0] = (byte)(lrc[0] ^ toCharArray[i]);
        }
        strLRC = Common.getHexStringFromBytes(lrc);
        return strLRC;
    }

    class PAT_Wakeup_Runnable
    extends Thread {
        PAT_Wakeup_Runnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block16: {
                this.setName("Wakeup PAT-110 Thread Background");
                try {
                    long timeBegin = System.currentTimeMillis();
                    long lastTime = 0L;
                    long wakeup_heartbeat = 4000L;
                    int ret = 0;
                    while (IDTechUsbHid.this.isWakeupThreadRunning) {
                        do {
                            if (!IDTechUsbHid.this.isWakeupThreadRunning) {
                                break block16;
                            }
                            try {
                                lastTime = System.currentTimeMillis() - timeBegin;
                                if (lastTime > wakeup_heartbeat) {
                                    timeBegin = System.currentTimeMillis();
                                    IDTechUsbHid.this._usb.disableSwipe();
                                    int timeout = 5;
                                    int wakeup_option = 1;
                                    switch (wakeup_option) {
                                        case 0: {
                                            byte[] version = IDTechUsbHid.this.PAT_sendCommand("784601", timeout);
                                            UMLog.i("**Wakeup: Get Version **", "Ret:" + Common.getHexStringFromBytes(version));
                                            break;
                                        }
                                        case 1: {
                                            byte[] command = new byte[]{0};
                                            IDTechUsbHid.this._usb.PAT_wakeup_sendCommand(command, timeout);
                                            UMLog.i("**Wakeup: Zero Packet **" + lastTime, " Zero Packet  ");
                                            break;
                                        }
                                        case 2: {
                                            ret = IDTechUsbHid.this._usb.writeNothing();
                                            UMLog.i("**Wakeup: NULL Packet ** " + lastTime, " ret = " + ret);
                                        }
                                    }
                                    continue;
                                }
                                Thread.sleep(300L);
                            }
                            catch (InterruptedException e) {
                                break block16;
                            }
                        } while (IDTechUsbHid.this.isWakeupThreadRunning);
                        if (IDTechUsbHid.this.isWakeupThreadRunning) continue;
                        break;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                finally {
                    IDTechUsbHid.this.isWakeupThreadRunning = false;
                }
            }
        }
    }

    private class UsbControllerMsgImpl
    implements UsbControllerMsg {
        private UsbControllerMsgImpl() {
        }

        @Override
        public void onDeviceAttached() {
            if (IDTechUsbHid.this._usb.init()) {
                IDTechUsbHid.this._state_isConnected = true;
                if (IDTechUsbHid.this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY) {
                    IDTechUsbHid.this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_USB);
                } else if (IDTechUsbHid.this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ) {
                    IDTechUsbHid.this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB);
                } else if (IDTechUsbHid.this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V) {
                    IDTechUsbHid.this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB);
                } else if (IDTechUsbHid.this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_BTPAY) {
                    IDTechUsbHid.this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_BTPAY_USB);
                } else if (IDTechUsbHid.this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II) {
                    IDTechUsbHid.this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II);
                } else if (IDTechUsbHid.this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA) {
                    IDTechUsbHid.this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA);
                } else if (IDTechUsbHid.this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III) {
                    IDTechUsbHid.this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III);
                } else if (IDTechUsbHid.this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER) {
                    IDTechUsbHid.this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER);
                } else if (IDTechUsbHid.this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP2000) {
                    IDTechUsbHid.this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_VP2000);
                } else if (IDTechUsbHid.this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI) {
                    IDTechUsbHid.this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_VENDI);
                } else if (IDTechUsbHid.this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB) {
                    IDTechUsbHid.this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB);
                } else if (IDTechUsbHid.this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB) {
                    IDTechUsbHid.this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB);
                } else if (IDTechUsbHid.this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB) {
                    IDTechUsbHid.this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB);
                } else if (IDTechUsbHid.this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800) {
                    IDTechUsbHid.this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_VP8800);
                } else if (IDTechUsbHid.this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG) {
                    IDTechUsbHid.this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG);
                } else if (IDTechUsbHid.this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG_KB) {
                    IDTechUsbHid.this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG_KB);
                }
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        IDTechUsbHid.this._msg.usb_onReceiveMsgConnected();
                    }
                }).start();
            }
        }

        @Override
        public void onDeviceDetached() {
            IDTechUsbHid.this._state_isConnected = false;
            IDTechUsbHid.this._msg.usb_onReceiveMsgDisconnected();
            if (IDTechUsbHid.this._usb != null) {
                IDTechUsbHid.this._usb.startCheckingConnection();
            }
        }

        @Override
        public void onDeviceNotFound() {
            if (IDTechUsbHid.this._usb != null) {
                IDTechUsbHid.this._usb.startCheckingConnection();
            }
        }

        @Override
        public void onDeviceMSRData(byte[] data) {
            UMLog.i(IDTechUsbHid.TAG, "Data: " + Common.getHexStringFromBytes(data));
            IDTechUsbHid.this._msg.usb_onReceiveMsgCardData(data);
        }
    }

    public class FwUpdateThread
    extends Thread {
        FirmwareUpdateTool.FMStruct fmFile;
        FirmwareUpdateToolMsg _umtMsg;
        ReaderInfo.FIRMWARE_UPDATE_TYPES _ft;

        private FwUpdateThread(FirmwareUpdateTool.FMStruct fm, FirmwareUpdateToolMsg msg) {
            this.fmFile = fm;
            this._umtMsg = msg;
        }

        @Override
        public void run() {
            int retries = 3;
            if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && this.fmFile.commands != null) {
                ResDataStruct respData = new ResDataStruct();
                int timeout = 0;
                int sleep = 0;
                int cmdCount = 0;
                int prevSend = -1;
                int repeatCount = 0;
                boolean jumpLine = false;
                boolean isLastC743 = false;
                for (int i2 = 0; i2 < this.fmFile.commands.length; ++i2) {
                    String[] strArray;
                    if (this.fmFile.commands[i2].length() == 0) {
                        jumpLine = true;
                    }
                    if ((strArray = this.fmFile.commands[i2].split(":"))[0].equalsIgnoreCase("TIMEOUT")) {
                        timeout = Integer.parseInt(strArray[1]);
                        if (timeout == 0) {
                            Common.commandTime = 5.0;
                            timeout = 5;
                        } else {
                            if (timeout < 3000) {
                                timeout = 3000;
                            }
                            Common.commandTime = timeout / 1000;
                        }
                        if (isFirstTimeEraseSpace) continue;
                        this._umtMsg.onReceiveMsgUpdateFirmwareProgress(i2 / this.fmFile.commands.length + 1);
                        continue;
                    }
                    if (strArray[0].equalsIgnoreCase("SLEEP")) {
                        sleep = Integer.parseInt(strArray[1]);
                        try {
                            Thread.sleep(sleep);
                        }
                        catch (InterruptedException ex) {
                            UMLog.i(IDTechUsbHid.TAG, "notify failed firmware update (Line#" + i2 + ") SLEEP");
                            this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                            IDT_Device.isCommandRunning = false;
                            return;
                        }
                        if (isFirstTimeEraseSpace) continue;
                        this._umtMsg.onReceiveMsgUpdateFirmwareProgress(i2 * 100 / this.fmFile.commands.length + 1);
                        continue;
                    }
                    if (strArray[0].equalsIgnoreCase("SEND")) {
                        byte[] ret;
                        byte[] cmd = Common.removeReportIds(strArray[1]);
                        String strCmd = Common.getHexStringFromBytes(cmd);
                        ++cmdCount;
                        if (cmd[10] == -57 && cmd[11] == 21) {
                            try {
                                Thread.sleep(10000L);
                            }
                            catch (InterruptedException ex) {
                                UMLog.i(IDTechUsbHid.TAG, "notify failed firmware update (Line#" + i2 + ") SEND");
                                this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                                IDT_Device.isCommandRunning = false;
                                return;
                            }
                        } else if (cmd[10] == -57 && cmd[11] == 65) {
                            Common.setBootLoaderMode(true);
                            if ((Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER) && !isFirstTimeEraseSpace) continue;
                        }
                        repeatCount = prevSend == i2 ? ++repeatCount : 0;
                        prevSend = i2;
                        if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB) {
                            if (i2 > this.fmFile.commands.length - 5 && strArray[1].contains("5669564F746563683200C7430104")) {
                                isLastC743 = true;
                                try {
                                    Thread.sleep(2000L);
                                }
                                catch (InterruptedException ex) {
                                    UMLog.i(IDTechUsbHid.TAG, "notify failed firmware update (Line#" + i2 + ") SEND");
                                    this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                                    IDT_Device.isCommandRunning = false;
                                    return;
                                }
                                ret = IDTechUsbHid.this._usb.sendCommandFw(cmd, timeout / 1000 > 7 ? timeout / 1000 : 7);
                            } else {
                                ret = IDTechUsbHid.this._usb.sendCommandFw(cmd, timeout / 1000);
                            }
                        } else {
                            ret = IDTechUsbHid.this._usb.sendCommand(cmd, timeout / 1000);
                        }
                        if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB) {
                            if (cmd[10] == -57 && cmd[11] == 65) {
                                if (isFirstTimeEraseSpace) {
                                    this._umtMsg.onReceiveMsgUpdateFirmwareResult(310);
                                    isFirstTimeEraseSpace = false;
                                    IDT_Device.isCommandRunning = false;
                                    return;
                                }
                            } else {
                                if (cmd[10] == -57 && cmd[11] == 22) {
                                    respData.resData = new byte[16];
                                    System.arraycopy(Common.getByteArray("5669564F746563683200C7000000866E"), 0, respData.resData, 0, 16);
                                    continue;
                                }
                                if (isLastC743) {
                                    try {
                                        Thread.sleep(3000L);
                                    }
                                    catch (InterruptedException ex) {
                                        UMLog.i(IDTechUsbHid.TAG, "notify failed firmware update (Line#" + i2 + ") SEND");
                                        this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                                        IDT_Device.isCommandRunning = false;
                                        return;
                                    }
                                }
                            }
                        } else if (cmd[10] == -57 && cmd[11] == 18 && isFirstTimeEraseSpace) {
                            this._umtMsg.onReceiveMsgUpdateFirmwareResult(310);
                            isFirstTimeEraseSpace = false;
                            IDT_Device.isCommandRunning = false;
                            return;
                        }
                        if (ret == null) {
                            UMLog.i(IDTechUsbHid.TAG, "notify failed firmware update (Line#" + i2 + ") SEND");
                            this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                            IDT_Device.isCommandRunning = false;
                            return;
                        }
                        UMLog.i(IDTechUsbHid.TAG, "Line#" + (i2 + 1) + " sent successfully.");
                        respData.resData = new byte[ret.length];
                        System.arraycopy(ret, 0, respData.resData, 0, ret.length);
                        if (isFirstTimeEraseSpace) continue;
                        this._umtMsg.onReceiveMsgUpdateFirmwareProgress(i2 * 100 / this.fmFile.commands.length + 1);
                        continue;
                    }
                    if (!strArray[0].equalsIgnoreCase("WAIT")) continue;
                    byte[] resp = Common.removeReportIds(strArray[1]);
                    if (!(isLastC743 || Arrays.equals(resp, respData.resData) || strArray[1].contains("5669564F7465636832002900"))) {
                        if (repeatCount < 3) {
                            i2 = jumpLine ? (i2 -= 3) : (i2 -= 2);
                        } else {
                            UMLog.i(IDTechUsbHid.TAG, "notify failed firmware update (Line#" + i2 + ") WAIT");
                            this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                            IDT_Device.isCommandRunning = false;
                            return;
                        }
                    }
                    if (!isFirstTimeEraseSpace) {
                        this._umtMsg.onReceiveMsgUpdateFirmwareProgress(i2 * 100 / this.fmFile.commands.length + 1);
                    }
                    try {
                        if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB) {
                            Thread.sleep(100L);
                        } else {
                            Thread.sleep(500L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (!isLastC743) continue;
                    isLastC743 = false;
                }
                this._umtMsg.onReceiveMsgUpdateFirmwareResult(301);
                Common.setBootLoaderMode(false);
                isFirstTimeEraseSpace = true;
                IDT_Device.isCommandRunning = false;
            } else if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB) {
                byte[] data = null;
                if (Common.update_type == ReaderInfo.FIRMWARE_UPDATE_TYPES.FU_APPLICATION) {
                    int k;
                    int i;
                    IDT_Device.kernel = false;
                    if (isFirstTimeEraseSpace) {
                        IDT_Device.isCommandRunning = true;
                        data = IDTechUsbHid.this.sendCommand(Common.getHexStringFromBytes(Common.grsiP2Command((byte)41, (byte)0, new byte[0])), 3);
                        IDT_Device.isCommandRunning = false;
                        if (data == null || data.length < 16 || data[11] != 0) {
                            this._umtMsg.onReceiveMsgUpdateFirmwareResult(302);
                            IDT_Device.isCommandRunning = false;
                            return;
                        }
                        String fwVersion = Common.getHexStringFromBytes(data);
                        if (fwVersion.contains("426F6F746C6F61646572")) {
                            Common.setBootLoaderMode(true);
                            this._umtMsg.onReceiveMsgUpdateFirmwareResult(310);
                            isFirstTimeEraseSpace = false;
                            IDT_Device.isCommandRunning = false;
                            return;
                        }
                        IDT_Device.isCommandRunning = true;
                        data = IDTechUsbHid.this.sendCommand(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-57, (byte)65, new byte[0])), 3);
                        IDT_Device.isCommandRunning = false;
                        if (data == null || data.length < 16 || data[11] != 0) {
                            this._umtMsg.onReceiveMsgUpdateFirmwareResult(302);
                            IDT_Device.isCommandRunning = false;
                            isFirstTimeEraseSpace = true;
                            return;
                        }
                        Common.setBootLoaderMode(true);
                        this._umtMsg.onReceiveMsgUpdateFirmwareResult(310);
                        isFirstTimeEraseSpace = false;
                        isStartFirmwareUpadte = false;
                        IDT_Device.isCommandRunning = false;
                        return;
                    }
                    if (isStartFirmwareUpadte) {
                        return;
                    }
                    isStartFirmwareUpadte = true;
                    byte[] smallBlock = new byte[260];
                    byte[] largeBlock = new byte[1028];
                    int totalblocks = (this.fmFile.blockS[16] & 0xFF) + (this.fmFile.blockS[17] & 0xFF) * 256;
                    int filePointer = 64;
                    smallBlock[1] = 0;
                    smallBlock[2] = 0;
                    smallBlock[3] = 0;
                    UMLog.i("**FwUpdateThread**", "Update K81 or Bootloader");
                    for (i = 0; i < 2; ++i) {
                        smallBlock[0] = (byte)i;
                        System.arraycopy(this.fmFile.blockS, filePointer, smallBlock, 4, 256);
                        filePointer += 256;
                        UMLog.i("**FwUpdateThread**", i + " smallBlock.length=" + smallBlock.length + " " + Common.base16Encode(smallBlock));
                        for (k = 0; k < 11 && ((data = IDTechUsbHid.this._usb.sendCommandFw(Common.grsiP2Command((byte)-57, (byte)67, smallBlock), 5)) == null || data.length < 16 || data[11] != 0); ++k) {
                            if (k == 10) {
                                this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                                isStartFirmwareUpadte = false;
                                isFirstTimeEraseSpace = true;
                                IDT_Device.isCommandRunning = false;
                                return;
                            }
                            try {
                                Thread.sleep(100L);
                                continue;
                            }
                            catch (InterruptedException jumpLine) {
                                // empty catch block
                            }
                        }
                        if (!isFirstTimeEraseSpace) {
                            this._umtMsg.onReceiveMsgUpdateFirmwareProgress(i / ((totalblocks + 3) / 100 == 0 ? 1 : (totalblocks + 3) / 100));
                        }
                        try {
                            Thread.sleep(100L);
                            continue;
                        }
                        catch (InterruptedException jumpLine) {
                            // empty catch block
                        }
                    }
                    byte[] fwStatus = new byte[]{0, 0, this.fmFile.blockS[17], this.fmFile.blockS[16]};
                    int address = (this.fmFile.blockS[18] & 0xFF) * 0x1000000 + (this.fmFile.blockS[19] & 0xFF) * 65536 + (this.fmFile.blockS[20] & 0xFF) * 256 + (this.fmFile.blockS[21] & 0xFF);
                    for (i = 0; i < totalblocks; ++i) {
                        largeBlock[0] = (byte)(address & 0xFF);
                        largeBlock[1] = (byte)(address >> 8 & 0xFF);
                        largeBlock[2] = (byte)(address >> 16 & 0xFF);
                        largeBlock[3] = (byte)(address >> 24 & 0xFF);
                        System.arraycopy(this.fmFile.blockS, filePointer, largeBlock, 4, 1024);
                        UMLog.i("**FwUpdateThread**", i + 2 + " largeBlock.length=" + largeBlock.length + " " + Common.base16Encode(largeBlock));
                        for (k = 0; k < 11 && ((data = IDTechUsbHid.this._usb.sendCommandFw(Common.grsiP2Command((byte)-57, (byte)67, largeBlock), 5)) == null || data.length < 16 || data[11] != 0); ++k) {
                            if (k == 10) {
                                this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                                isStartFirmwareUpadte = false;
                                isFirstTimeEraseSpace = true;
                                IDT_Device.isCommandRunning = false;
                                return;
                            }
                            try {
                                Thread.sleep(100L);
                                continue;
                            }
                            catch (InterruptedException i2) {
                                // empty catch block
                            }
                        }
                        filePointer += 1024;
                        address += 1024;
                        fwStatus[0] = (byte)(i + 1 >> 8 & 0xFF);
                        fwStatus[1] = (byte)(i + 1 & 0xFF);
                        int percentage = (i + 2) / ((totalblocks + 3) / 100 == 0 ? 1 : (totalblocks + 3) / 100);
                        if (percentage > 100) {
                            percentage = 100;
                        }
                        if (isFirstTimeEraseSpace) continue;
                        this._umtMsg.onReceiveMsgUpdateFirmwareProgress(percentage);
                    }
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException percentage) {
                        // empty catch block
                    }
                    smallBlock[0] = -1;
                    smallBlock[1] = -1;
                    smallBlock[2] = -1;
                    smallBlock[3] = -1;
                    System.arraycopy(this.fmFile.blockS, filePointer, smallBlock, 4, 256);
                    filePointer += 256;
                    for (k = 0; k < 11 && ((data = IDTechUsbHid.this._usb.sendCommandFw(Common.grsiP2Command((byte)-57, (byte)67, smallBlock), 7)) == null || data.length < 16 || data[11] != 0); ++k) {
                        if (k == 10) {
                            this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                            isStartFirmwareUpadte = false;
                            isFirstTimeEraseSpace = true;
                            IDT_Device.isCommandRunning = false;
                            return;
                        }
                        try {
                            Thread.sleep(100L);
                            continue;
                        }
                        catch (InterruptedException percentage) {
                            // empty catch block
                        }
                    }
                    if (!isFirstTimeEraseSpace) {
                        this._umtMsg.onReceiveMsgUpdateFirmwareProgress(100);
                    }
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException percentage) {
                        // empty catch block
                    }
                    ResDataStruct resData = new ResDataStruct();
                    IDTechUsbHid.this._usb.readMessage(1, System.currentTimeMillis(), resData, true);
                    Common.setBootLoaderMode(false);
                    isFirstTimeEraseSpace = true;
                    isStartFirmwareUpadte = false;
                    IDT_Device.isCommandRunning = false;
                    UMLog.i("**FwUpdateThread**", "Second smallBlock done");
                    this._umtMsg.onReceiveMsgUpdateFirmwareResult(301);
                } else if (Common.update_type == ReaderInfo.FIRMWARE_UPDATE_TYPES.FU_RT1050 || Common.update_type == ReaderInfo.FIRMWARE_UPDATE_TYPES.FU_KERNEL_DT_PRJ_RT1050) {
                    IDT_Device.kernel = false;
                    IDT_Device.isCommandRunning = true;
                    byte[] C74XData = new byte[]{Common.update_type == ReaderInfo.FIRMWARE_UPDATE_TYPES.FU_KERNEL_DT_PRJ_RT1050 ? (byte)17 : 16, (byte)(this.fmFile.blockS.length & 0xFF), (byte)((this.fmFile.blockS.length & 0xFF00) >> 8), (byte)((this.fmFile.blockS.length & 0xFF0000) >> 16), (byte)((this.fmFile.blockS.length & 0xFF000000) >> 24)};
                    int subCmd = 69;
                    if (Common.update_type == ReaderInfo.FIRMWARE_UPDATE_TYPES.FU_RT1050) {
                        data = IDTechUsbHid.this.sendCommand(Common.getHexStringFromBytes(Common.grsiP2Command((byte)41, (byte)-128, new byte[0])), 9);
                        if (data == null || data.length < 16 || data[11] != 0) {
                            this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                            IDT_Device.isCommandRunning = false;
                            return;
                        }
                        String fwVersion = Common.getAsciiFromByte(data);
                        int start = fwVersion.indexOf("v");
                        int end = start + 14;
                        String rt1050ver = new String(fwVersion.substring(start, end));
                        if (IDT_Device.neoGen == 3) {
                            subCmd = 72;
                        } else if (rt1050ver.compareTo("v1.00.040.0000") < 0) {
                            if (rt1050ver.compareTo("v1.00.001.0098") > 0) {
                                subCmd = 72;
                            }
                        } else if (rt1050ver.compareTo("v1.00.500.0020") > 0) {
                            subCmd = 72;
                        }
                        UMLog.i("**FwUpdateThread**", "Update RT1050");
                    } else {
                        subCmd = 72;
                        UMLog.i("**FwUpdateThread**", "Update RT1050 Device Tree");
                    }
                    data = IDTechUsbHid.this._usb.sendCommandFw(Common.grsiP2Command((byte)-57, (byte)subCmd, C74XData), 3);
                    if (data == null || data.length < 16 || data[11] != 0) {
                        for (int f = 0; f < 10; ++f) {
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            data = IDTechUsbHid.this._usb.sendCommandFw(Common.grsiP2Command((byte)-57, (byte)subCmd, C74XData), 3);
                            if (data != null && data.length >= 16 && data[11] == 0) break;
                            if (f != 9) continue;
                            this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                            IDT_Device.isCommandRunning = false;
                            return;
                        }
                    }
                    try {
                        Thread.sleep(1500L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    int blockSize = 1024;
                    byte[] largeBlock = new byte[blockSize + 4];
                    int totalblocks = this.fmFile.blockS.length / blockSize;
                    int remainingData = this.fmFile.blockS.length % blockSize;
                    int filePointer = 0;
                    for (int i = 0; i < totalblocks; ++i) {
                        largeBlock[0] = Common.update_type == ReaderInfo.FIRMWARE_UPDATE_TYPES.FU_KERNEL_DT_PRJ_RT1050 ? 17 : 16;
                        largeBlock[1] = 0;
                        largeBlock[2] = (byte)(i & 0xFF);
                        largeBlock[3] = (byte)(i >> 8 & 0xFF);
                        System.arraycopy(this.fmFile.blockS, filePointer, largeBlock, 4, blockSize);
                        data = IDTechUsbHid.this._usb.sendCommandFw(Common.grsiP2Command((byte)-57, (byte)70, largeBlock), 3);
                        if (data == null || data.length < 16 || data[11] != 0) {
                            for (int f = 0; f < 10; ++f) {
                                try {
                                    Thread.sleep(500L);
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                                data = IDTechUsbHid.this._usb.sendCommandFw(Common.grsiP2Command((byte)-57, (byte)70, largeBlock), 3);
                                if (data != null && data.length >= 16 && data[11] == 0) break;
                                if (f != 9) continue;
                                this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                                IDT_Device.isCommandRunning = false;
                                return;
                            }
                        }
                        filePointer += 1024;
                        int percentage = (i + 1) / ((totalblocks + 1) / 100 == 0 ? 1 : (totalblocks + 1) / 100);
                        if (percentage > 100) {
                            percentage = 100;
                        }
                        if (i == totalblocks) {
                            this._umtMsg.onReceiveMsgUpdateFirmwareProgress(100);
                            continue;
                        }
                        this._umtMsg.onReceiveMsgUpdateFirmwareProgress(percentage);
                    }
                    if (IDT_Device.neoGen == 3) {
                        byte[] smallBlock = new byte[remainingData + 4];
                        smallBlock[0] = Common.update_type == ReaderInfo.FIRMWARE_UPDATE_TYPES.FU_KERNEL_DT_PRJ_RT1050 ? 17 : 16;
                        smallBlock[1] = 0;
                        smallBlock[2] = (byte)(totalblocks & 0xFF);
                        smallBlock[3] = (byte)(totalblocks >> 8 & 0xFF);
                        System.arraycopy(this.fmFile.blockS, filePointer, smallBlock, 4, remainingData);
                        filePointer += remainingData;
                        data = IDTechUsbHid.this._usb.sendCommandFw(Common.grsiP2Command((byte)-57, (byte)70, smallBlock), 3);
                        if (data == null || data.length < 16 || data[11] != 0 && data[11] != 99) {
                            for (int f = 0; f < 10; ++f) {
                                try {
                                    Thread.sleep(500L);
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                                data = IDTechUsbHid.this._usb.sendCommandFw(Common.grsiP2Command((byte)-57, (byte)70, smallBlock), 3);
                                if (data != null && data.length >= 16 && data[11] == 0) break;
                                if (f != 9) continue;
                                this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                                IDT_Device.isCommandRunning = false;
                                return;
                            }
                        }
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        byte[] cmdData = new byte[]{Common.update_type == ReaderInfo.FIRMWARE_UPDATE_TYPES.FU_KERNEL_DT_PRJ_RT1050 ? (byte)17 : 16};
                        data = IDTechUsbHid.this._usb.sendCommandFw(Common.grsiP2Command((byte)-57, (byte)71, cmdData), 10);
                        if (data == null || data.length < 16 || data[11] != 0 && data[11] != 99) {
                            this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                            IDT_Device.isCommandRunning = false;
                            return;
                        }
                        ResDataStruct respData = new ResDataStruct();
                        IDTechUsbHid.this.readMessage(6, System.currentTimeMillis(), respData, true);
                        IDT_Device.isCommandRunning = false;
                        this._umtMsg.onReceiveMsgUpdateFirmwareResult(301);
                    } else {
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        byte[] smallBlock = new byte[remainingData + 1];
                        smallBlock[0] = 16;
                        System.arraycopy(this.fmFile.blockS, filePointer, smallBlock, 1, remainingData);
                        filePointer += remainingData;
                        data = IDTechUsbHid.this._usb.sendCommandFw(Common.grsiP2Command((byte)-57, (byte)71, smallBlock), 7);
                        if (data == null || data.length < 16 || data[11] != 0 && data[11] != 99) {
                            for (int f = 0; f < 10; ++f) {
                                try {
                                    Thread.sleep(500L);
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                                data = IDTechUsbHid.this._usb.sendCommandFw(Common.grsiP2Command((byte)-57, (byte)71, smallBlock), 7);
                                if (data != null && data.length >= 16 && data[11] == 0) break;
                                if (f != 9) continue;
                                this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                                IDT_Device.isCommandRunning = false;
                                return;
                            }
                        }
                        ResDataStruct respData = new ResDataStruct();
                        IDTechUsbHid.this.readMessage(6, System.currentTimeMillis(), respData, true);
                        IDT_Device.isCommandRunning = false;
                        this._umtMsg.onReceiveMsgUpdateFirmwareResult(301);
                    }
                } else if (Common.update_type == ReaderInfo.FIRMWARE_UPDATE_TYPES.FU_PACKAGE_DOWNLOAD) {
                    int f;
                    byte[] fw;
                    boolean noReboot = false;
                    if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && (fw = IDTechUsbHid.this._usb.sendCommandFw(Common.grsiP2Command((byte)41, (byte)20, new byte[0]), 2)) != null && fw.length > 11 && fw[10] == 41 && fw[11] == 0) {
                        noReboot = true;
                    }
                    IDT_Device.kernel = false;
                    IDT_Device.pk_stop = false;
                    int packageBlockSize = 1024;
                    IDT_Device.PackageDownloadStartIndex = 0;
                    byte[] cmdData = new byte[70];
                    cmdData[0] = 4;
                    cmdData[1] = 0;
                    System.arraycopy(this.fmFile.blockS, 0, cmdData, 2, 68);
                    UMLog.i("**sendCommand**", Common.base16Encode(Common.grsiP2Command((byte)-57, (byte)120, cmdData)) + " timeout: " + 5);
                    data = IDTechUsbHid.this._usb.sendCommandFw(Common.grsiP2Command((byte)-57, (byte)120, cmdData), 5);
                    if (data != null && data.length > 15) {
                        if (data[10] == -57 && data[11] == 0 && data[12] == 0 && data[13] == 2) {
                            IDT_Device.PackageDownloadStartIndex = (data[14] & 0xFF) << 8 | data[15] & 0xFF;
                            UMLog.i("**FwUpdateThread**", "Resume Index: " + IDT_Device.PackageDownloadStartIndex);
                        } else {
                            UMLog.i("**FwUpdateThread**", "No Resume");
                        }
                    } else {
                        UMLog.i("**FwUpdateThread**", "No Resume");
                    }
                    if (this.fmFile.blockS[0] != 70 || this.fmFile.blockS[1] != 87 || this.fmFile.blockS[2] != 80 || this.fmFile.blockS[3] != 75) {
                        UMLog.i("**FwUpdateThread**", "FWPK Error");
                        this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                        IDT_Device.isCommandRunning = false;
                        IDT_Device.kernelDone = true;
                        return;
                    }
                    UMLog.i("**FwUpdateThread**", "Package Download");
                    int fileSize = (this.fmFile.blockS[9] & 0xFF) << 24 | (this.fmFile.blockS[8] & 0xFF) << 16 | (this.fmFile.blockS[7] & 0xFF) << 8 | this.fmFile.blockS[6] & 0xFF;
                    if (fileSize != this.fmFile.blockS.length) {
                        UMLog.i("**FwUpdateThread**", "File Size Error");
                        this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                        IDT_Device.isCommandRunning = false;
                        return;
                    }
                    int blockNum = 0;
                    if (IDT_Device.PackageDownloadStartIndex == 0) {
                        for (int f2 = 0; f2 < 10; ++f2) {
                            byte[] fs = new byte[]{this.fmFile.blockS[9], this.fmFile.blockS[8], this.fmFile.blockS[7], this.fmFile.blockS[6]};
                            data = IDTechUsbHid.this._usb.sendCommandFw(Common.grsiP2Command((byte)-57, (byte)113, fs), 37);
                            if (data != null && data.length >= 16 && data[11] == 0) break;
                            UMLog.i("**FwUpdateThread**", "0xC7-71 retry number " + f2);
                            if (f2 == 9) {
                                UMLog.i("**FwUpdateThread**", "0xC7-71");
                                this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                                IDT_Device.isCommandRunning = false;
                                IDT_Device.kernelDone = true;
                                return;
                            }
                            try {
                                Thread.sleep(500L);
                                continue;
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    blockNum = this.fmFile.blockS.length / packageBlockSize;
                    int remainingSize = this.fmFile.blockS.length % packageBlockSize;
                    for (int index = IDT_Device.PackageDownloadStartIndex; index < (remainingSize > 0 ? blockNum + 1 : blockNum); ++index) {
                        int percentage;
                        byte[] blockData = new byte[packageBlockSize + 2];
                        blockData[0] = (byte)(index + 1 >> 8 & 0xFF);
                        blockData[1] = (byte)(index + 1 & 0xFF);
                        for (int f3 = 0; f3 < 10; ++f3) {
                            if (index == blockNum) {
                                byte[] remaingData = new byte[remainingSize + 2];
                                System.arraycopy(blockData, 0, remaingData, 0, 2);
                                System.arraycopy(this.fmFile.blockS, index * packageBlockSize, remaingData, 2, remainingSize);
                                data = IDTechUsbHid.this._usb.sendCommandFw(Common.grsiP2Command((byte)-57, (byte)114, remaingData), 7);
                            } else {
                                System.arraycopy(this.fmFile.blockS, index * packageBlockSize, blockData, 2, packageBlockSize);
                                data = IDTechUsbHid.this._usb.sendCommandFw(Common.grsiP2Command((byte)-57, (byte)114, blockData), 7);
                            }
                            if (data != null && data.length >= 16 && data[11] == 0 && !IDT_Device.pk_stop) break;
                            UMLog.i("**FwUpdateThread**", "0xC7-72 retry number " + f3);
                            if (f3 == 9 || IDT_Device.pk_stop) {
                                UMLog.i("**FwUpdateThread**", "0xC7-72 Block " + index + " pk_stop " + IDT_Device.pk_stop);
                                this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                                IDT_Device.isCommandRunning = false;
                                IDT_Device.kernelDone = true;
                                IDT_Device.pk_stop = false;
                                return;
                            }
                            try {
                                Thread.sleep(500L);
                                continue;
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                        if ((percentage = (index + 1) / ((blockNum + 1) / 100 == 0 ? 1 : (blockNum + 1) / 100)) > 100) {
                            percentage = 100;
                        }
                        this._umtMsg.onReceiveMsgUpdateFirmwareProgress(percentage);
                    }
                    this._umtMsg.onReceiveMsgUpdateFirmwareProgress(100);
                    for (f = 0; f < 10 && ((data = IDTechUsbHid.this._usb.sendCommandFw(Common.grsiP2Command((byte)-57, (byte)115, new byte[0]), 12)) == null || data.length < 16 || data[11] != 0 || IDT_Device.pk_stop); ++f) {
                        UMLog.i("**FwUpdateThread**", "0xC7-73 retry number " + f + " pk_stop " + IDT_Device.pk_stop);
                        if (f == 9 || IDT_Device.pk_stop) {
                            UMLog.i("**FwUpdateThread**", "0xC7-73");
                            this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                            IDT_Device.isCommandRunning = false;
                            IDT_Device.kernelDone = true;
                            IDT_Device.pk_stop = false;
                            return;
                        }
                        try {
                            Thread.sleep(500L);
                            continue;
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    for (f = 0; f < 10 && ((data = IDTechUsbHid.this._usb.sendCommandFw(Common.grsiP2Command((byte)-57, (byte)117, new byte[0]), 12)) == null || data.length < 16 || data[11] != 0 || IDT_Device.pk_stop); ++f) {
                        UMLog.i("**FwUpdateThread**", "0xC7-75 retry number " + f + " pk_stop " + IDT_Device.pk_stop);
                        if (f == 9 || IDT_Device.pk_stop) {
                            UMLog.i("**FwUpdateThread**", "0xC7-75");
                            this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                            IDT_Device.isCommandRunning = false;
                            IDT_Device.kernelDone = true;
                            IDT_Device.pk_stop = false;
                            return;
                        }
                        try {
                            Thread.sleep(500L);
                            continue;
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    if (noReboot) {
                        try {
                            Thread.sleep(43000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    this._umtMsg.onReceiveMsgUpdateFirmwareResult(301);
                    IDT_Device.isCommandRunning = false;
                    IDT_Device.kernelDone = true;
                } else {
                    byte[] C711Data = new byte[12];
                    IDT_Device.kernel = true;
                    if (Common.update_type == ReaderInfo.FIRMWARE_UPDATE_TYPES.FU_KERNEL_CT) {
                        C711Data[0] = 0;
                        UMLog.i("**FwUpdateThread**", "Update CT");
                    } else if (Common.update_type == ReaderInfo.FIRMWARE_UPDATE_TYPES.FU_KERNEL_PPSE) {
                        C711Data[0] = 1;
                        UMLog.i("**FwUpdateThread**", "Update PPSE");
                    } else if (Common.update_type == ReaderInfo.FIRMWARE_UPDATE_TYPES.FU_KERNEL_VCPS) {
                        C711Data[0] = 2;
                        UMLog.i("**FwUpdateThread**", "Update VCPS");
                    } else if (Common.update_type == ReaderInfo.FIRMWARE_UPDATE_TYPES.FU_KERNEL_MCHIP) {
                        C711Data[0] = 3;
                        UMLog.i("**FwUpdateThread**", "Update MCHIP");
                    } else if (Common.update_type == ReaderInfo.FIRMWARE_UPDATE_TYPES.FU_KERNEL_DPASS) {
                        C711Data[0] = 4;
                        UMLog.i("**FwUpdateThread**", "Update DPASS");
                    } else if (Common.update_type == ReaderInfo.FIRMWARE_UPDATE_TYPES.FU_KERNEL_AMEX) {
                        C711Data[0] = 5;
                        UMLog.i("**FwUpdateThread**", "Update AMEX");
                    } else if (Common.update_type == ReaderInfo.FIRMWARE_UPDATE_TYPES.FU_KERNEL_INTERAC) {
                        C711Data[0] = 6;
                        UMLog.i("**FwUpdateThread**", "Update INTERAC");
                    } else if (Common.update_type == ReaderInfo.FIRMWARE_UPDATE_TYPES.FU_KERNEL_CUP) {
                        C711Data[0] = 7;
                        UMLog.i("**FwUpdateThread**", "Update CUP");
                    } else if (Common.update_type == ReaderInfo.FIRMWARE_UPDATE_TYPES.FU_KERNEL_JCP) {
                        C711Data[0] = 8;
                        UMLog.i("**FwUpdateThread**", "Update JCP");
                    } else if (Common.update_type == ReaderInfo.FIRMWARE_UPDATE_TYPES.FU_KERNEL_APVAS) {
                        C711Data[0] = 9;
                        UMLog.i("**FwUpdateThread**", "Update APVAS");
                    } else if (Common.update_type == ReaderInfo.FIRMWARE_UPDATE_TYPES.FU_KERNEL_SMARTTAP) {
                        C711Data[0] = 10;
                        UMLog.i("**FwUpdateThread**", "Update SMARTTAP");
                    } else if (Common.update_type == ReaderInfo.FIRMWARE_UPDATE_TYPES.FU_KERNEL_SCRP) {
                        C711Data[0] = 11;
                        UMLog.i("**FwUpdateThread**", "Update SCRP");
                    } else if (Common.update_type == ReaderInfo.FIRMWARE_UPDATE_TYPES.FU_KERNEL_DT_SEC) {
                        C711Data[0] = 48;
                        UMLog.i("**FwUpdateThread**", "Update DT SEC");
                    } else if (Common.update_type == ReaderInfo.FIRMWARE_UPDATE_TYPES.FU_KERNEL_DT_PRJ) {
                        C711Data[0] = 49;
                        UMLog.i("**FwUpdateThread**", "Update DT PRJ");
                        if (this.fmFile.blockS[0] == 80 && this.fmFile.blockS[1] == 67 || this.fmFile.blockS[0] == 78 && this.fmFile.blockS[1] == 79) {
                            if (this.fmFile.blockS.length - 832 <= 0) {
                                this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                                IDT_Device.isCommandRunning = false;
                                IDT_Device.kernelDone = true;
                                return;
                            }
                            byte[] temp = new byte[this.fmFile.blockS.length - 832];
                            System.arraycopy(this.fmFile.blockS, 576, temp, 0, temp.length);
                            this.fmFile.blockS = new byte[temp.length];
                            System.arraycopy(temp, 0, this.fmFile.blockS, 0, temp.length);
                        }
                    }
                    C711Data[1] = (byte)(this.fmFile.blockS.length & 0xFF);
                    C711Data[2] = (byte)((this.fmFile.blockS.length & 0xFF00) >> 8);
                    C711Data[3] = (byte)((this.fmFile.blockS.length & 0xFF0000) >> 16);
                    for (int f = 0; f < 10 && ((data = IDTechUsbHid.this._usb.sendCommandFw(Common.grsiP2Command((byte)-57, (byte)17, C711Data), 3)) == null || data.length < 16 || data[11] != 0); ++f) {
                        if (f == 9) {
                            this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                            IDT_Device.isCommandRunning = false;
                            IDT_Device.kernelDone = true;
                            return;
                        }
                        try {
                            Thread.sleep(500L);
                            continue;
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    int blockSize = 2048;
                    if (Common.update_type == ReaderInfo.FIRMWARE_UPDATE_TYPES.FU_KERNEL_DT_PRJ) {
                        blockSize = 1024;
                    }
                    byte[] largeBlock = new byte[blockSize + 4];
                    int totalblocks = this.fmFile.blockS.length / blockSize;
                    int remainingData = this.fmFile.blockS.length % blockSize;
                    int filePointer = 0;
                    for (int i = 0; i < totalblocks; ++i) {
                        largeBlock[0] = C711Data[0];
                        largeBlock[1] = 0;
                        largeBlock[2] = 0;
                        largeBlock[3] = 0;
                        System.arraycopy(this.fmFile.blockS, filePointer, largeBlock, 4, blockSize);
                        data = IDTechUsbHid.this._usb.sendCommandFw(Common.grsiP2Command((byte)-57, (byte)20, largeBlock), 3);
                        if (data == null || data.length < 16 || data[11] != 0) {
                            for (int f = 0; f < 10; ++f) {
                                try {
                                    Thread.sleep(500L);
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                                data = IDTechUsbHid.this._usb.sendCommandFw(Common.grsiP2Command((byte)-57, (byte)20, largeBlock), 3);
                                if (data != null && data.length >= 16 && data[11] == 0) break;
                                if (f != 9) continue;
                                this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                                IDT_Device.isCommandRunning = false;
                                IDT_Device.kernelDone = true;
                                return;
                            }
                        }
                        filePointer += blockSize;
                        int percentage = (i + 1) / ((totalblocks + 1) / 100 == 0 ? 1 : (totalblocks + 1) / 100);
                        if (percentage > 100) {
                            percentage = 100;
                        }
                        if (i == totalblocks) {
                            this._umtMsg.onReceiveMsgUpdateFirmwareProgress(100);
                            continue;
                        }
                        this._umtMsg.onReceiveMsgUpdateFirmwareProgress(percentage);
                    }
                    byte[] smallBlock = new byte[remainingData + 4];
                    smallBlock[0] = C711Data[0];
                    smallBlock[1] = 0;
                    smallBlock[2] = 0;
                    smallBlock[3] = 0;
                    System.arraycopy(this.fmFile.blockS, filePointer, smallBlock, 4, remainingData);
                    filePointer += remainingData;
                    data = IDTechUsbHid.this._usb.sendCommandFw(Common.grsiP2Command((byte)-57, (byte)20, smallBlock), 3);
                    if (data == null || data.length < 16 || data[11] != 0) {
                        for (int f = 0; f < 10; ++f) {
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            data = IDTechUsbHid.this._usb.sendCommandFw(Common.grsiP2Command((byte)-57, (byte)20, smallBlock), 3);
                            if (data != null && data.length >= 16 && data[11] == 0) break;
                            if (f != 9) continue;
                            this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                            IDT_Device.isCommandRunning = false;
                            IDT_Device.kernelDone = true;
                            return;
                        }
                    }
                    byte[] kernelId = new byte[]{C711Data[0]};
                    data = IDTechUsbHid.this._usb.sendCommandFw(Common.grsiP2Command((byte)-57, (byte)21, kernelId), 3);
                    if (data == null || data.length < 16 || data[11] != 0) {
                        for (int f = 0; f < 10; ++f) {
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            data = IDTechUsbHid.this._usb.sendCommandFw(Common.grsiP2Command((byte)-57, (byte)21, kernelId), 3);
                            if (data != null && data.length >= 16 && data[11] == 0) break;
                            if (f != 9) continue;
                            this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                            IDT_Device.isCommandRunning = false;
                            IDT_Device.kernelDone = true;
                            return;
                        }
                    }
                    this._umtMsg.onReceiveMsgUpdateFirmwareResult(301);
                    IDT_Device.isCommandRunning = false;
                    IDT_Device.kernelDone = true;
                }
            } else {
                this._umtMsg.onReceiveMsgUpdateFirmwareProgress(0);
                this._umtMsg.onReceiveMsgUpdateFirmwareProgress(1);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                byte[] ret = IDTechUsbHid.this.sendCommandFw("420000" + Common.base16Encode(this.fmFile.getBlock(0)));
                if (ret == null) {
                    UMLog.i(IDTechUsbHid.TAG, "notify failed firmware update (Block #0)");
                    this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                    return;
                }
                if (ret[3] != 6) {
                    UMLog.i(IDTechUsbHid.TAG, "notify failed firmware update (Block #0)");
                    this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                    return;
                }
                UMLog.i(IDTechUsbHid.TAG, "Block #0 sent successfully.");
                for (int curBlock = 0; curBlock < this.fmFile.N; ++curBlock) {
                    int currentProgress = (curBlock + 2) * 100 / (this.fmFile.N + 3);
                    this._umtMsg.onReceiveMsgUpdateFirmwareProgress(currentProgress);
                    int blockNumber = curBlock + 1;
                    byte[] command = new byte[1027];
                    command[0] = 66;
                    command[1] = (byte)blockNumber;
                    command[2] = 0;
                    System.arraycopy(this.fmFile.getBlock(blockNumber), 0, command, 3, 1024);
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    ret = IDTechUsbHid.this.sendCommandFw(Common.getHexStringFromBytes(command));
                    if (ret == null) {
                        UMLog.i(IDTechUsbHid.TAG, "notify failed firmware update (Block #" + blockNumber + "-0)");
                        this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                    } else if (ret[3] != 6) {
                        UMLog.i(IDTechUsbHid.TAG, "notify failed firmware update (Block #" + blockNumber + "-0)");
                        this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                    } else {
                        UMLog.i(IDTechUsbHid.TAG, "Block #" + blockNumber + "-0 sent successfully.");
                    }
                    command = new byte[1027];
                    command[0] = 66;
                    command[1] = (byte)blockNumber;
                    command[2] = 1;
                    System.arraycopy(this.fmFile.getBlock(blockNumber), 1024, command, 3, 1024);
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    ret = IDTechUsbHid.this.sendCommandFw(Common.getHexStringFromBytes(command));
                    if (ret == null) {
                        UMLog.i(IDTechUsbHid.TAG, "notify failed firmware update (Block #" + blockNumber + "-1)");
                        this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                    } else if (ret[3] != 6) {
                        UMLog.i(IDTechUsbHid.TAG, "notify failed firmware update (Block #" + blockNumber + "-1)");
                        this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                    } else {
                        UMLog.i(IDTechUsbHid.TAG, "Block #" + blockNumber + "-1 sent successfully.");
                    }
                    command = new byte[259];
                    command[0] = 66;
                    command[1] = (byte)blockNumber;
                    command[2] = 2;
                    System.arraycopy(this.fmFile.getBlock(blockNumber), 2048, command, 3, 256);
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    ret = IDTechUsbHid.this.sendCommandFw(Common.getHexStringFromBytes(command));
                    if (ret == null) {
                        UMLog.i(IDTechUsbHid.TAG, "notify failed firmware update (Block #" + blockNumber + "-2)");
                        this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                        continue;
                    }
                    if (ret[3] != 6) {
                        UMLog.i(IDTechUsbHid.TAG, "notify failed firmware update (Block #" + blockNumber + "-2)");
                        this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                        continue;
                    }
                    UMLog.i(IDTechUsbHid.TAG, "Block #" + blockNumber + "-2 sent successfully.");
                }
                int currentProgress = (this.fmFile.N + 2) * 100 / (this.fmFile.N + 3);
                this._umtMsg.onReceiveMsgUpdateFirmwareProgress(currentProgress);
                byte[] checksumCommand = new byte[259];
                checksumCommand[0] = 66;
                checksumCommand[1] = -1;
                checksumCommand[2] = -1;
                System.arraycopy(this.fmFile.blockN, 0, checksumCommand, 3, 256);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                ret = IDTechUsbHid.this.sendCommandFw(Common.base16Encode(checksumCommand));
                if (ret == null) {
                    UMLog.i(IDTechUsbHid.TAG, "notify failed firmware update (checksum block)");
                    this._umtMsg.onReceiveMsgUpdateFirmwareResult(304);
                } else if (ret[3] != 6) {
                    UMLog.i(IDTechUsbHid.TAG, "notify failed firmware update ((checksum block))");
                    this._umtMsg.onReceiveMsgUpdateFirmwareResult(304);
                } else {
                    UMLog.i(IDTechUsbHid.TAG, "Checksum block sent successfully.");
                    UMLog.i(IDTechUsbHid.TAG, "notify finished successfully");
                    this._umtMsg.onReceiveMsgUpdateFirmwareResult(301);
                }
            }
        }
    }
}

