/*
 * Decompiled with CFR 0.152.
 */
package com.idtechproducts.device;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioManager;
import android.media.AudioRecord;
import android.os.Build;
import android.os.Environment;
import android.os.Handler;
import android.util.Log;
import com.idtechproducts.device.APDUResponseStruct;
import com.idtechproducts.device.Common;
import com.idtechproducts.device.ErrorCodeInfo;
import com.idtechproducts.device.Gen2DataStruct;
import com.idtechproducts.device.ICCReaderStatusStruct;
import com.idtechproducts.device.ICCSettingStruct;
import com.idtechproducts.device.IDTEMVData;
import com.idtechproducts.device.IDTLCDData;
import com.idtechproducts.device.IDTMSRData;
import com.idtechproducts.device.MSRSettingStruct;
import com.idtechproducts.device.MetadataScript;
import com.idtechproducts.device.OnReceiverListener;
import com.idtechproducts.device.OnReceiverListenerGen2;
import com.idtechproducts.device.OnReceiverListenerLCD;
import com.idtechproducts.device.OnReceiverListenerPIN;
import com.idtechproducts.device.OnReceiverListenerPINRequest;
import com.idtechproducts.device.PowerOnStructure;
import com.idtechproducts.device.ReaderInfo;
import com.idtechproducts.device.ResDataStruct;
import com.idtechproducts.device.ResultScript;
import com.idtechproducts.device.StructConfigParameters;
import com.idtechproducts.device.USBBypassListener;
import com.idtechproducts.device.WorldPay;
import com.idtechproducts.device.audiojack.CommManagerAudio;
import com.idtechproducts.device.audiojack.UMLog;
import com.idtechproducts.device.audiojack.io.IOManager;
import com.idtechproducts.device.audiojack.tasks.RemoteKeyInjectionTask;
import com.idtechproducts.device.audiojack.tasks.TaskManager;
import com.idtechproducts.device.audiojack.tools.FirmwareUpdateTool;
import com.idtechproducts.device.bluetooth.BluetoothController;
import com.idtechproducts.device.bluetooth.BluetoothLEController;
import com.idtechproducts.device.bluetooth.IDTechBluetooth;
import com.idtechproducts.device.bluetooth.IDTechBluetoothLE;
import com.idtechproducts.device.bluetooth.IDTechBluetoothMsg;
import com.idtechproducts.device.rs232.IDTechRS232;
import com.idtechproducts.device.rs232.IDTechRS232Msg;
import com.idtechproducts.device.usb.IDTechUsbHid;
import com.idtechproducts.device.usb.IDTechUsbHidMsg;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class IDT_Device {
    private final CommManagerAudio _umMan;
    private final TaskManager taskManager;
    private static IDTechUsbHid _usb = null;
    private IDTechRS232 _com = null;
    private IDTechBluetooth _bt = null;
    private static IDTechBluetoothLE _btle = null;
    public OnReceiverListener m_recListener;
    private OnReceiverListenerPIN m_recListenerPIN;
    private OnReceiverListenerGen2 m_recListenerGen2;
    private OnReceiverListenerPINRequest m_recListenerPINRequest;
    private OnReceiverListenerLCD m_recListenerLCD;
    private USBBypassListener bypassListener;
    private FirmwareUpdateTool _fwTool;
    private byte transactionInterface = (byte)4;
    private boolean executingUniPayEMV = false;
    private boolean encryptedUniPay = false;
    private Map<String, byte[]> encryptedTags = null;
    private Map<String, byte[]> maskedTags = null;
    private UsbCallback _usbMsg = null;
    private ComCallback _comMsg = null;
    private BluetoothCallback _btMsg = null;
    public static Context context;
    public static boolean kernelDone;
    public static boolean kernel;
    public static boolean pk_stop;
    private TaskExport _taskExport;
    private boolean activateTransaction = false;
    private boolean setICCTransactionTimeOut = false;
    public static boolean cancelTransaction;
    public static boolean emvCancelTransaction;
    private static boolean cancelPINEntry;
    private IDTMSRData cardData;
    private Map<String, String> emvTags;
    private static ArrayList<BluetoothDevice> BluetoothDeviceList;
    private static ArrayList<String> BLE_ReaderNameList;
    private static boolean[] isBonded;
    private Map<String, String> emvTags_NoOtherAmt;
    public static int maxLoopNum;
    static boolean _allowFallback;
    static boolean _forceOnline;
    static int _timeout;
    private static int bleBondStatus;
    private static boolean inConnectedCallback;
    private boolean addUsbSupported = false;
    private boolean runEMVTransaction = false;
    private boolean runLEDControl = false;
    public static boolean readyForNextCommand;
    public static boolean isBurstModeOn;
    public static boolean isAutoPollOn;
    public static boolean isMonitorCtlsData;
    public static boolean isPassthroughModeOn;
    public static boolean isNotificationOn;
    public static boolean isCommandRunning;
    public static boolean isThreadReading;
    public static boolean isCheckingNotification;
    private static boolean _bypassCompletion;
    private static boolean isEMV_Terminate_TTK;
    private int timeout = 30;
    public static boolean audioUnplugged;
    public static int bleRetryCount;
    private static BluetoothDevice bleDevice;
    private static IDTechBluetoothLE mService;
    public static boolean readyForCardSwipe;
    public static byte[] firmware_version_ttk;
    private boolean isDeviceTransaction = false;
    public static double emv_amount;
    private static double emv_amtOther;
    public static int emv_type;
    public static int emv_timeout;
    public static byte[] emv_tags;
    public static boolean autoEMV;
    public static boolean cardSeated;
    public static int PackageDownloadStartIndex;
    private byte fromOtherTransaction = 0;
    private boolean neo2Transaction = false;
    private int deviceTransactionType = 0;
    private int app_timeout = 0;
    public static boolean infiniteTimeout;
    public static boolean btleFirstConnect;
    public static boolean btleFirstBypass;
    public static boolean btleReConnect;
    public static boolean isTransactionRead;
    private static int connectTimes;
    private static boolean _isFastEMV;
    public static boolean isVP6300;
    public static boolean btleDisconnect;
    public static int neoGen;
    private static int packageDowloadDelay;
    private static ReaderInfo.DEVICE_TYPE connectedDevice;
    private static boolean autoAuthentication;
    private static boolean autoComplete;
    public static boolean _isTTK;
    public static boolean _isThales;
    public static boolean _isSRED;
    public static boolean _isDeviceFilter;
    public static boolean _isK4;
    private BluetoothAdapter mBtAdapter = null;
    private static boolean btleDeviceRegistered;
    public static boolean btleBondCreated;
    private static final int REQUEST_ENABLE_BT = 1;
    private long BLE_ScanTimeout = 5000L;
    boolean mParingReceiverRegistered = false;
    private boolean forIDTech = false;
    private boolean toPair = false;
    private static BroadcastReceiver mPairingReceiver;
    private static BroadcastReceiver mReceiver;
    private boolean stopScanning = false;
    public static boolean paired;
    private BluetoothAdapter.LeScanCallback _mLeScanCallback = null;
    private static String btleDeviceAddress;
    private BluetoothAdapter.LeScanCallback mLeScanCallback = new BluetoothAdapter.LeScanCallback(){

        @SuppressLint(value={"NewApi"})
        public void onLeScan(BluetoothDevice btledevice, int rssi, byte[] scanRecord) {
            if (IDT_Device.this.stopScanning) {
                return;
            }
            if (IDT_Device.this.forIDTech) {
                String deviceName = btledevice.getName();
                UMLog.i("LeScanCallback : ", deviceName);
                if (deviceName != null && deviceName.startsWith("IDTECH")) {
                    for (int i = 0; i < BluetoothDeviceList.size(); ++i) {
                        if (!btledevice.equals(BluetoothDeviceList.get(i))) continue;
                        return;
                    }
                    if (BluetoothDeviceList.size() + 1 > isBonded.length) {
                        int i;
                        boolean[] temp = new boolean[isBonded.length];
                        for (i = 0; i < isBonded.length; ++i) {
                            temp[i] = isBonded[i];
                        }
                        IDT_Device.access$1002(new boolean[temp.length + 10]);
                        for (i = 0; i < temp.length; ++i) {
                            isBonded[i] = temp[i];
                        }
                    }
                    isBonded[BluetoothDeviceList.size()] = btledevice.getBondState() == 12;
                    BluetoothDeviceList.add(btledevice);
                    BLE_ReaderNameList.add(deviceName);
                    UMLog.i("LeScanCallback : ", deviceName + " Added Bonded: " + isBonded[BluetoothDeviceList.size() - 1]);
                }
            } else {
                String BLE_Id = Common.getBLEDeviceName();
                if (BLE_Id != null) {
                    UMLog.i("LeScanCallback BLE_Id: ", BLE_Id);
                    if (BLE_Id.length() == 17 && BLE_Id.charAt(2) == ':' && BLE_Id.charAt(5) == ':' && BLE_Id.charAt(8) == ':' && BLE_Id.charAt(11) == ':' && BLE_Id.charAt(14) == ':') {
                        String deviceAddress = btledevice.getAddress();
                        if (deviceAddress != null && deviceAddress.equalsIgnoreCase(BLE_Id)) {
                            if (IDT_Device.this.device_getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT && btledevice.getBondState() != 12) {
                                paired = false;
                                if (!IDT_Device.this.toPair) {
                                    return;
                                }
                                bleBondStatus = -1;
                                boolean btleCreateBond = btledevice.createBond();
                                if (!btleCreateBond) {
                                    return;
                                }
                                while (bleBondStatus != 12 && bleBondStatus != 10) {
                                    try {
                                        Thread.sleep(100L);
                                    }
                                    catch (InterruptedException e) {
                                        e.printStackTrace();
                                    }
                                }
                                if (bleBondStatus == 12) {
                                    UMLog.i("onLeScan", "BOND_BONDED");
                                    btleBondCreated = true;
                                } else if (bleBondStatus == 10) {
                                    UMLog.i("onLeScan", "BOND_NONE");
                                    return;
                                }
                                try {
                                    Thread.sleep(500L);
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                                btleBondCreated = true;
                                BluetoothLEController.setBluetoothDevice(btledevice);
                                btleDeviceAddress = btledevice.getAddress();
                                IDT_Device.this.stopScanning = true;
                                IDT_Device.this.mBtAdapter.stopLeScan(IDT_Device.this._mLeScanCallback);
                                if (!btleDeviceRegistered) {
                                    IDT_Device.this.registerListen();
                                    btleDeviceRegistered = true;
                                }
                                return;
                            }
                            BluetoothLEController.setBluetoothDevice(btledevice);
                            btleDeviceAddress = deviceAddress;
                            if (!btleDeviceRegistered) {
                                IDT_Device.this.RegisterListen();
                            }
                        }
                    } else {
                        String deviceName = btledevice.getName();
                        if (deviceName != null && deviceName.equals(BLE_Id)) {
                            if (IDT_Device.this.device_getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT && btledevice.getBondState() != 12) {
                                paired = false;
                                if (!IDT_Device.this.toPair) {
                                    return;
                                }
                                bleBondStatus = -1;
                                boolean btleCreateBond = btledevice.createBond();
                                if (!btleCreateBond) {
                                    return;
                                }
                                while (bleBondStatus != 12 && bleBondStatus != 10) {
                                    try {
                                        Thread.sleep(100L);
                                    }
                                    catch (InterruptedException e) {
                                        e.printStackTrace();
                                    }
                                }
                                if (bleBondStatus == 12) {
                                    UMLog.i("onLeScan", "BOND_BONDED");
                                    btleBondCreated = true;
                                } else if (bleBondStatus == 10) {
                                    UMLog.i("onLeScan", "BOND_NONE");
                                    return;
                                }
                                try {
                                    Thread.sleep(500L);
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                                btleBondCreated = true;
                                BluetoothLEController.setBluetoothDevice(btledevice);
                                btleDeviceAddress = btledevice.getAddress();
                                IDT_Device.this.stopScanning = true;
                                IDT_Device.this.mBtAdapter.stopLeScan(IDT_Device.this._mLeScanCallback);
                                if (!btleDeviceRegistered) {
                                    IDT_Device.this.registerListen();
                                    btleDeviceRegistered = true;
                                }
                                return;
                            }
                            BluetoothLEController.setBluetoothDevice(btledevice);
                            IDT_Device.this.stopScanning = true;
                            IDT_Device.this.mBtAdapter.stopLeScan(IDT_Device.this._mLeScanCallback);
                            btleDeviceAddress = btledevice.getAddress();
                            if (!btleDeviceRegistered) {
                                IDT_Device.this.RegisterListen();
                            }
                        }
                    }
                }
            }
        }
    };
    private boolean _validate = false;
    private ReaderInfo.DEVICE_TYPE _deviceType = ReaderInfo.DEVICE_TYPE.DEVICE_UNKNOWN;
    private static boolean _enableUSBBypass;
    public static ReaderInfo.DEVICE_TYPE _bypassDevice;
    private static int vdPOS;
    private static byte[] vdData;
    private static boolean inRD;
    private static boolean inVD;
    private static String[] fw_commands;
    private static byte[] fw_data;
    private static int appReboot;
    private static int origPID;
    private static MetadataScript[] Scripts;
    private static String nextScript;
    private static String kernelVersion;
    private static String bootloaderVersion;
    private static String RT1050Version;
    private static String firmwareVersion;
    private static int ret;
    private static boolean init;
    private static boolean isRT1050;
    private int[] ScriptPID = new int[5];
    private boolean foundPID = false;
    private static boolean _ignorePing;
    private static boolean _vivoAlive;
    private static boolean pingRequest;
    private static boolean wasReadRecord;
    private static byte[] CDOL1;
    private static byte[] CDOL2;
    private static int cdolLen;
    private static int cdolPos;
    static boolean foundBlocked;
    static boolean _82Found;
    private static boolean inEMVAuth;
    private static boolean cancelInEMVAuth;
    private byte[] lcd_data = null;
    private int cardSwipeErrorCode = 0;
    private Handler handler = new Handler();
    private Runnable runnableStartMSRSwipe = new Runnable(){

        @Override
        public void run() {
            IDT_Device.this._msr_startSwipeCard();
        }
    };
    private Runnable runnableStartMSRSwipe_3in1 = new Runnable(){

        @Override
        public void run() {
            readyForCardSwipe = true;
            if (_isFastEMV) {
                IDT_Device.this.processFastEMV(IDT_Device.this.cardData);
            }
            IDT_Device.this.m_recListener.swipeMSRData(IDT_Device.this.cardData);
        }
    };
    private Runnable runnableSwipeTimeOut = new Runnable(){

        @Override
        public void run() {
            readyForCardSwipe = true;
            IDT_Device.this.m_recListener.timeout(24);
        }
    };
    private Runnable runnableSwipeFailed = new Runnable(){

        @Override
        public void run() {
            readyForCardSwipe = true;
            IDT_Device.this.m_recListener.timeout(10);
        }
    };
    private Runnable runnableSwipeError = new Runnable(){

        @Override
        public void run() {
            if (IDT_Device.this.cardSwipeErrorCode != 61088) {
                readyForCardSwipe = true;
            }
            IDT_Device.this.m_recListener.timeout(IDT_Device.this.cardSwipeErrorCode);
        }
    };
    private final Object _sleepMonitor = new Object();
    public static boolean allowReceiverCallback;
    private static boolean isConnected;
    private boolean isVP3310 = false;
    private boolean btleStartListen = false;

    private void resetStatics() {
        _usb = null;
        cancelTransaction = false;
        emvCancelTransaction = false;
        cancelPINEntry = false;
        isCommandRunning = false;
        audioUnplugged = false;
        bleDevice = null;
        mService = null;
        readyForCardSwipe = true;
        btleFirstConnect = false;
        btleFirstBypass = false;
        btleReConnect = false;
        isTransactionRead = false;
        connectTimes = 0;
        connectedDevice = ReaderInfo.DEVICE_TYPE.DEVICE_UNKNOWN;
        CommManagerAudio.audioDevice = null;
    }

    public IDT_Device(OnReceiverListener callback, Context context) {
        this.resetStatics();
        IDT_Device.context = context;
        this._taskExport = new TaskExport();
        this._umMan = new CommManagerAudio(callback, context, this._taskExport);
        int version = Build.VERSION.SDK_INT;
        if (version >= 12) {
            this.addUsbSupported = true;
        }
        if (this.addUsbSupported) {
            this._usbMsg = new UsbCallback();
        }
        this._comMsg = new ComCallback();
        this._btMsg = new BluetoothCallback();
        this.taskManager = new TaskManager(callback, context, this._taskExport);
        this.taskManager.setCfg_connectReaderWithCommand(true);
        this.m_recListener = callback;
        this.m_recListenerPIN = null;
        this.m_recListenerPINRequest = null;
        this.m_recListenerLCD = null;
        CommManagerAudio.audioDevice = this;
    }

    public void setGen2Callback(OnReceiverListenerGen2 callback) {
        this.m_recListenerGen2 = callback;
    }

    public IDT_Device(OnReceiverListener callback, OnReceiverListenerPIN pincallback, Context context) {
        this.resetStatics();
        IDT_Device.context = context;
        this._taskExport = new TaskExport();
        this._umMan = new CommManagerAudio(callback, context, this._taskExport);
        int version = Build.VERSION.SDK_INT;
        if (version >= 12) {
            this.addUsbSupported = true;
        }
        if (this.addUsbSupported) {
            this._usbMsg = new UsbCallback();
        }
        this._comMsg = new ComCallback();
        this._btMsg = new BluetoothCallback();
        this.taskManager = new TaskManager(callback, pincallback, context, this._taskExport);
        this.taskManager.setCfg_connectReaderWithCommand(true);
        this.m_recListener = callback;
        this.m_recListenerPIN = pincallback;
        this.m_recListenerPINRequest = null;
        this.m_recListenerLCD = null;
        CommManagerAudio.audioDevice = this;
    }

    public IDT_Device(OnReceiverListener callback, OnReceiverListenerPIN pincallback, OnReceiverListenerPINRequest pinrequestcallback, OnReceiverListenerLCD lcdcallback, Context context) {
        this.resetStatics();
        IDT_Device.context = context;
        this._taskExport = new TaskExport();
        this._umMan = new CommManagerAudio(callback, context, this._taskExport);
        int version = Build.VERSION.SDK_INT;
        if (version >= 12) {
            this.addUsbSupported = true;
        }
        if (this.addUsbSupported) {
            this._usbMsg = new UsbCallback();
        }
        this._comMsg = new ComCallback();
        this._btMsg = new BluetoothCallback();
        this.taskManager = new TaskManager(callback, pincallback, context, this._taskExport);
        this.taskManager.setCfg_connectReaderWithCommand(true);
        this.m_recListener = callback;
        this.m_recListenerPIN = pincallback;
        this.m_recListenerPINRequest = pinrequestcallback;
        this.m_recListenerLCD = lcdcallback;
        CommManagerAudio.audioDevice = this;
    }

    private void btle_WakeUp() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    long startTime = System.currentTimeMillis();
                    while (System.currentTimeMillis() - startTime < 30000L) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (isCommandRunning) continue;
                    isCommandRunning = true;
                    UMLog.i("IDT SDK", "Wake Up.");
                    ResDataStruct respData = new ResDataStruct();
                    IDT_Device.this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)24, (byte)1, new byte[0])), 1, respData);
                    isCommandRunning = false;
                }
            }
        }).start();
    }

    public void setIDT_Device(FirmwareUpdateTool fwTool) {
        this._fwTool = fwTool;
        if (this._fwTool != null) {
            this._fwTool.setIDT_Device(this);
        }
    }

    public static void device_setMonitorCtlsTransactionData(boolean monitor) {
        isMonitorCtlsData = monitor;
    }

    public static void emv_setAutoAuthenticateTransaction(boolean auto) {
        autoAuthentication = auto;
    }

    public static boolean emv_getAutoAuthenticateTransaction() {
        return autoAuthentication || _isFastEMV;
    }

    public static void emv_setAutoCompleteTransaction(boolean auto) {
        autoComplete = auto;
    }

    public static boolean emv_getAutoCompleteTransaction() {
        return autoComplete || _isFastEMV;
    }

    private static void useUSBIntentFilter() {
        _isDeviceFilter = true;
    }

    public void device_setNEOGen(int gen) {
        neoGen = gen;
    }

    public boolean device_setDeviceType(ReaderInfo.DEVICE_TYPE deviceType) {
        btleFirstConnect = true;
        connectTimes = 0;
        return this.device_setDeviceType(deviceType, false, false);
    }

    public boolean device_setDeviceType(ReaderInfo.DEVICE_TYPE deviceType, int PID) {
        if (deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && PID < 1) {
            return false;
        }
        if (deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III && PID < 1) {
            return false;
        }
        if (deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III) {
            return this.device_setDeviceType(deviceType, false, false, false, PID | Integer.MIN_VALUE);
        }
        return this.device_setDeviceType(deviceType, false, false, false, PID);
    }

    public boolean device_setDeviceType(ReaderInfo.DEVICE_TYPE deviceType, boolean isSRED) {
        return this.device_setDeviceType(deviceType, false, isSRED, false, 0);
    }

    private boolean device_setDeviceType(ReaderInfo.DEVICE_TYPE deviceType, boolean isTTK, boolean isSRED) {
        return this.device_setDeviceType(deviceType, isTTK, isSRED, false, 0);
    }

    public boolean device_setDeviceType(ReaderInfo.DEVICE_TYPE deviceType, boolean isTTK, boolean isSRED, boolean isThales) {
        return this.device_setDeviceType(deviceType, isTTK, isSRED, false, 0);
    }

    public static boolean device_setPackageDownloadDelay(int delay) {
        if (delay < 20 || delay > 50) {
            return false;
        }
        packageDowloadDelay = delay;
        return true;
    }

    public static int device_getPackageDownloadDelay() {
        return packageDowloadDelay;
    }

    public boolean device_disconnectBLE() {
        if (_btle == null) {
            return false;
        }
        btleDisconnect = true;
        this.unregisterListen();
        btleDisconnect = false;
        this.release();
        return true;
    }

    public int device_enableBLESearch(ReaderInfo.DEVICE_TYPE type, String name, int timeout) {
        IntentFilter filter = new IntentFilter("android.bluetooth.device.action.BOND_STATE_CHANGED");
        if (!this.mParingReceiverRegistered) {
            context.registerReceiver(mPairingReceiver, filter);
        }
        this.mParingReceiverRegistered = true;
        this.toPair = false;
        Common.setBLEDeviceName(name);
        this.BLE_ScanTimeout = timeout;
        if (!context.getPackageManager().hasSystemFeature("android.hardware.bluetooth_le")) {
            return 2;
        }
        BluetoothManager bluetoothManager = (BluetoothManager)context.getSystemService("bluetooth");
        this.mBtAdapter = bluetoothManager.getAdapter();
        if (this.mBtAdapter == null) {
            return 3;
        }
        btleDeviceRegistered = false;
        if (!this.mBtAdapter.isEnabled()) {
            return 4;
        }
        if (type == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT || type == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
            this.scanLeDevice(true, this.BLE_ScanTimeout);
        } else {
            paired = false;
            BluetoothDevice btledevice2 = null;
            boolean bFindPairedDevice = false;
            Set bonded = this.mBtAdapter.getBondedDevices();
            if (bonded != null) {
                String name_address = Common.getBLEDeviceName();
                boolean isAddress = false;
                if (name_address.length() == 17 && name_address.charAt(2) == ':' && name_address.charAt(5) == ':' && name_address.charAt(8) == ':' && name_address.charAt(11) == ':' && name_address.charAt(14) == ':') {
                    isAddress = true;
                }
                for (BluetoothDevice btledevice2 : bonded) {
                    String deviceBLE_NameAddress = isAddress ? btledevice2.getAddress() : btledevice2.getName();
                    if (deviceBLE_NameAddress == null || !deviceBLE_NameAddress.equals(name_address)) continue;
                    bFindPairedDevice = true;
                    break;
                }
            }
            if (!bFindPairedDevice) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                return 5;
            }
            BluetoothLEController.setBluetoothDevice(btledevice2);
            btleDeviceAddress = btledevice2.getAddress();
            if (!btleDeviceRegistered) {
                this.registerListen();
                btleDeviceRegistered = true;
            }
        }
        return 0;
    }

    public int device_enableBLESearch_pair(ReaderInfo.DEVICE_TYPE type, String name, int timeout) {
        this.toPair = true;
        Common.setBLEDeviceName(name);
        this.BLE_ScanTimeout = timeout;
        if (!context.getPackageManager().hasSystemFeature("android.hardware.bluetooth_le")) {
            return 2;
        }
        BluetoothManager bluetoothManager = (BluetoothManager)context.getSystemService("bluetooth");
        this.mBtAdapter = bluetoothManager.getAdapter();
        if (this.mBtAdapter == null) {
            return 3;
        }
        btleDeviceRegistered = false;
        if (!this.mBtAdapter.isEnabled()) {
            return 4;
        }
        if (type == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT || type == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
            this.scanLeDevice(true, this.BLE_ScanTimeout);
        } else {
            paired = false;
            BluetoothDevice btledevice2 = null;
            boolean bFindPairedDevice = false;
            Set bonded = this.mBtAdapter.getBondedDevices();
            if (bonded != null) {
                String name_address = Common.getBLEDeviceName();
                boolean isAddress = false;
                if (name_address.length() == 17 && name_address.charAt(2) == ':' && name_address.charAt(5) == ':' && name_address.charAt(8) == ':' && name_address.charAt(11) == ':' && name_address.charAt(14) == ':') {
                    isAddress = true;
                }
                for (BluetoothDevice btledevice2 : bonded) {
                    String deviceBLE_NameAddress = isAddress ? btledevice2.getAddress() : btledevice2.getName();
                    if (deviceBLE_NameAddress == null || !deviceBLE_NameAddress.equals(name_address)) continue;
                    bFindPairedDevice = true;
                    break;
                }
            }
            if (!bFindPairedDevice) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                btleBondCreated = false;
                this.scanLeDevice(true, this.BLE_ScanTimeout);
                long startTime = System.currentTimeMillis();
                while (!btleBondCreated && System.currentTimeMillis() - startTime <= this.BLE_ScanTimeout) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (!btleBondCreated) {
                    return 5;
                }
                return 0;
            }
            BluetoothLEController.setBluetoothDevice(btledevice2);
            btleDeviceAddress = btledevice2.getAddress();
            if (!btleDeviceRegistered) {
                this.registerListen();
                btleDeviceRegistered = true;
            }
        }
        return 0;
    }

    public int device_enableBLESearch(ReaderInfo.DEVICE_TYPE type, int index, int timeout) {
        Common.setBLEDeviceName(BLE_ReaderNameList.get(index));
        this.BLE_ScanTimeout = timeout;
        if (!context.getPackageManager().hasSystemFeature("android.hardware.bluetooth_le")) {
            return 2;
        }
        BluetoothManager bluetoothManager = (BluetoothManager)context.getSystemService("bluetooth");
        this.mBtAdapter = bluetoothManager.getAdapter();
        if (this.mBtAdapter == null) {
            return 3;
        }
        btleDeviceRegistered = false;
        if (!this.mBtAdapter.isEnabled()) {
            return 4;
        }
        if (type == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT || type == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
            this.scanLeDevice(true, this.BLE_ScanTimeout);
        } else {
            paired = false;
            BluetoothDevice btledevice = BluetoothDeviceList.get(index);
            UMLog.i("device_enableBLESearch", "isBonded: " + isBonded[index]);
            if (!isBonded[index]) {
                btleBondCreated = false;
                bleBondStatus = -1;
                boolean cb = btledevice.createBond();
                if (!cb) {
                    return 5;
                }
                while (bleBondStatus != 12 && bleBondStatus != 10) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (bleBondStatus == 12) {
                    UMLog.i("device_enableBLESearch", "BOND_BONDED");
                    btleBondCreated = true;
                } else if (bleBondStatus == 10) {
                    UMLog.i("device_enableBLESearch", "BOND_NONE");
                    return 5;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                BluetoothLEController.setBluetoothDevice(btledevice);
                btleDeviceAddress = btledevice.getAddress();
                this.registerListen();
                btleDeviceRegistered = true;
                return 0;
            }
            BluetoothLEController.setBluetoothDevice(btledevice);
            btleDeviceAddress = btledevice.getAddress();
            if (!btleDeviceRegistered) {
                this.registerListen();
                btleDeviceRegistered = true;
            }
        }
        return 0;
    }

    public ArrayList<String> device_scanDevices(int timeout) {
        this.forIDTech = true;
        BluetoothDeviceList = new ArrayList();
        BLE_ReaderNameList = new ArrayList();
        isBonded = new boolean[30];
        IntentFilter filter = new IntentFilter("android.bluetooth.device.action.BOND_STATE_CHANGED");
        if (!this.mParingReceiverRegistered) {
            context.registerReceiver(mPairingReceiver, filter);
        }
        this.mParingReceiverRegistered = true;
        if (!context.getPackageManager().hasSystemFeature("android.hardware.bluetooth_le")) {
            BLE_ReaderNameList.add("Bluetooth LE is not supported on this device");
            return BLE_ReaderNameList;
        }
        BluetoothManager bluetoothManager = (BluetoothManager)context.getSystemService("bluetooth");
        this.mBtAdapter = bluetoothManager.getAdapter();
        if (this.mBtAdapter == null) {
            BLE_ReaderNameList.add("Bluetooth LE is not available");
            return BLE_ReaderNameList;
        }
        btleDeviceRegistered = false;
        if (!this.mBtAdapter.isEnabled()) {
            BLE_ReaderNameList.add("Bluetooth LE is not enabled");
            return BLE_ReaderNameList;
        }
        Set bonded = this.mBtAdapter.getBondedDevices();
        if (bonded != null) {
            BluetoothDevice btledevice2 = null;
            for (BluetoothDevice btledevice2 : bonded) {
                String deviceName = btledevice2.getName();
                if (!deviceName.startsWith("IDTECH")) continue;
                if (BluetoothDeviceList.size() + 1 > isBonded.length) {
                    int i;
                    boolean[] temp = new boolean[isBonded.length];
                    for (i = 0; i < isBonded.length; ++i) {
                        temp[i] = isBonded[i];
                    }
                    isBonded = new boolean[temp.length + 10];
                    for (i = 0; i < temp.length; ++i) {
                        IDT_Device.isBonded[i] = temp[i];
                    }
                }
                IDT_Device.isBonded[IDT_Device.BluetoothDeviceList.size()] = true;
                BluetoothDeviceList.add(btledevice2);
                BLE_ReaderNameList.add(deviceName);
                UMLog.i("device_scanDevices : ", deviceName + " Added Bonded: " + isBonded[BluetoothDeviceList.size() - 1]);
            }
        }
        this.scanLeDevice(true, timeout);
        try {
            Thread.sleep(timeout);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return BLE_ReaderNameList;
    }

    public ArrayList<String> device_scanDevices_new(int timeout) {
        this.forIDTech = true;
        BluetoothDeviceList = new ArrayList();
        BLE_ReaderNameList = new ArrayList();
        isBonded = new boolean[30];
        IntentFilter filter = new IntentFilter("android.bluetooth.device.action.FOUND");
        context.registerReceiver(mReceiver, filter);
        BluetoothAdapter mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        mBluetoothAdapter.startDiscovery();
        try {
            Thread.sleep(timeout);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        mBluetoothAdapter.cancelDiscovery();
        filter = new IntentFilter("android.bluetooth.device.action.BOND_STATE_CHANGED");
        if (!this.mParingReceiverRegistered) {
            context.registerReceiver(mPairingReceiver, filter);
        }
        this.mParingReceiverRegistered = true;
        if (!context.getPackageManager().hasSystemFeature("android.hardware.bluetooth_le")) {
            BLE_ReaderNameList.add("Bluetooth LE is not supported on this device");
            return BLE_ReaderNameList;
        }
        BluetoothManager bluetoothManager = (BluetoothManager)context.getSystemService("bluetooth");
        this.mBtAdapter = bluetoothManager.getAdapter();
        if (this.mBtAdapter == null) {
            BLE_ReaderNameList.add("Bluetooth LE is not available");
            return BLE_ReaderNameList;
        }
        btleDeviceRegistered = false;
        if (!this.mBtAdapter.isEnabled()) {
            BLE_ReaderNameList.add("Bluetooth LE is not enabled");
            return BLE_ReaderNameList;
        }
        this.scanLeDevice(true, timeout);
        try {
            Thread.sleep(timeout);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return BLE_ReaderNameList;
    }

    private void scanLeDevice(boolean enable, long timeout) {
        if (this._mLeScanCallback == null) {
            this._mLeScanCallback = this.mLeScanCallback;
        }
        if (enable) {
            this.handler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (IDT_Device.this.stopScanning) {
                        return;
                    }
                    IDT_Device.this.stopScanning = true;
                    IDT_Device.this.forIDTech = false;
                    IDT_Device.this.mBtAdapter.stopLeScan(IDT_Device.this._mLeScanCallback);
                }
            }, timeout);
            this.stopScanning = false;
            if (this.device_getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT) {
                UUID[] uuid = new UUID[]{UUID.fromString("00001820-0000-1000-8000-00805f9b34fb")};
                this.mBtAdapter.startLeScan(uuid, this._mLeScanCallback);
            } else {
                this.mBtAdapter.startLeScan(this._mLeScanCallback);
            }
        } else {
            this.stopScanning = true;
            this.forIDTech = false;
            this.mBtAdapter.stopLeScan(this._mLeScanCallback);
        }
    }

    public String getBTLEDeviceAddress() {
        return btleDeviceAddress;
    }

    private void RegisterListen() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                IDT_Device.this.registerListen();
                btleDeviceRegistered = true;
            }
        }).start();
    }

    public boolean device_setDeviceType(ReaderInfo.DEVICE_TYPE deviceType, boolean isTTK, boolean isSRED, boolean isThales, int PID) {
        boolean isK4 = (PID & Integer.MIN_VALUE) != 0;
        PID &= Integer.MAX_VALUE;
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT && connectedDevice == deviceType && _isTTK == isTTK && _isSRED == isSRED && _isThales == isThales && isK4 == _isK4) {
            if (deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_UNIMAG && Common.getDeviceType() == null) {
                connectedDevice = deviceType;
                Common.setDeviceType(deviceType);
            }
            return true;
        }
        if (this.device_isConnected()) {
            return connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT;
        }
        connectedDevice = deviceType;
        _isTTK = isTTK;
        _isSRED = isSRED;
        _isThales = isThales;
        _isK4 = isK4;
        Common.coverAllBaudRate = false;
        if ((connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT) && this.m_recListenerPIN == null) {
            this.m_recListenerPIN = (OnReceiverListenerPIN)((Object)this.m_recListener);
        }
        if (this.isAudioDeviceSelected()) {
            if (_usb != null) {
                _usb.unregisterListen();
            }
            if (this._com != null) {
                this._com.unregisterListen();
            }
            if (_btle != null) {
                _btle.unregisterListen();
            }
            if (this._bt != null) {
                this._bt.unregisterListen();
            }
            this._bt = null;
            _btle = null;
            _usb = null;
            this._com = null;
            this._umMan.getIntern_IOManager().resetPlayer();
            CommManagerAudio.audioDevice = this;
        }
        Common.setDeviceType(deviceType);
        if (deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_UNIMAG_PRO) {
            this.taskManager.setCfg_connectReaderWithCommand(false);
        }
        if (!this.isAudioDeviceSelected()) {
            isConnected = false;
            if (this.isBluetoothDeviceSelected()) {
                if (_usb != null) {
                    _usb.unregisterListen();
                }
                if (this._com != null) {
                    this._com.unregisterListen();
                }
                if (_btle != null) {
                    _btle.unregisterListen();
                }
                _usb = null;
                _btle = null;
                this._com = null;
                if (this._bt != null) {
                    return false;
                }
                this._bt = new IDTechBluetooth(this._btMsg, context, this._taskExport);
            } else if (this.isBluetoothLEDeviceSelected()) {
                if (_usb != null) {
                    _usb.unregisterListen();
                }
                if (this._com != null) {
                    this._com.unregisterListen();
                }
                if (this._bt != null) {
                    this._bt.unregisterListen();
                }
                _usb = null;
                this._com = null;
                this._bt = null;
                if (_btle != null) {
                    return true;
                }
                if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
                    BluetoothLEController.device_BLE_Type = 1;
                } else if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT) {
                    BluetoothLEController.device_BLE_Type = 2;
                }
                if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
                    BluetoothLEController.isVP8800 = true;
                }
                _btle = new IDTechBluetoothLE(this._btMsg, context, this._taskExport);
            } else if (this.isRS232DeviceSelected()) {
                if (_usb != null) {
                    _usb.unregisterListen();
                }
                if (this._com != null) {
                    this._com.unregisterListen();
                }
                if (_btle != null) {
                    _btle.unregisterListen();
                }
                if (this._bt != null) {
                    this._bt.unregisterListen();
                }
                this._bt = null;
                _btle = null;
                _usb = null;
                this._com = new IDTechRS232(this._comMsg, context, this._taskExport, "android_serialport_api.sample_preferences", "115200", 0);
            } else {
                if (_usb != null) {
                    _usb.unregisterListen();
                }
                if (this._com != null) {
                    this._com.unregisterListen();
                }
                if (_btle != null) {
                    _btle.unregisterListen();
                }
                if (this._bt != null) {
                    this._bt.unregisterListen();
                }
                this._bt = null;
                _btle = null;
                this._com = null;
                if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III) {
                    _usb = new IDTechUsbHid(this._usbMsg, context, this._taskExport, this.bypassListener, PID);
                    origPID = PID;
                } else {
                    _usb = new IDTechUsbHid(this._usbMsg, context, this._taskExport, this.bypassListener, 0);
                }
            }
        }
        return true;
    }

    public ReaderInfo.DEVICE_TYPE device_getDeviceType() {
        return connectedDevice;
    }

    private int device_setDisplayReady() {
        if (!this.device_isConnected()) {
            return 1;
        }
        char ch = '\u001c';
        String ready = "     Ready";
        String str = ch + ready + ch + ch;
        if (str.length() < 4) {
            return 27392;
        }
        ResDataStruct respData = new ResDataStruct();
        TaskManager.TaskStartRet r = this.sendCommand_helper("754620000" + Integer.toHexString(str.length()) + Common.asciiToHex(str), 0, respData);
        return this.returnACK(r, respData);
    }

    public void registerListen() {
        if (this.isAudioDeviceSelected()) {
            this._umMan.listener_register();
        } else if (this.addUsbSupported && _usb != null) {
            _usb.registerListen();
        } else if (this._com != null) {
            this._com.registerListen();
        } else if (this._bt != null) {
            this._bt.registerListen();
        } else if (_btle != null) {
            _btle.registerListen();
        }
    }

    private void registerListen(Handler handler) {
        if (this.isAudioDeviceSelected()) {
            this._umMan.listener_register();
        } else if (this.addUsbSupported && _usb != null) {
            _usb.registerListen();
        } else if (this._com != null) {
            this._com.registerListen();
        } else if (this._bt != null) {
            this._bt.registerListen();
        } else if (_btle != null) {
            _btle.registerListen(handler);
        }
    }

    public void unregisterListen() {
        this._umMan.listener_unregister();
        if (this.addUsbSupported && _usb != null) {
            _usb.unregisterListen();
        } else if (this._com != null) {
            this._com.unregisterListen();
        } else if (this._bt != null) {
            this._bt.unregisterListen();
        } else if (_btle != null) {
            _btle.unregisterListen();
        }
    }

    public void release() {
        if (this.isAudioDeviceSelected()) {
            isCommandRunning = false;
            isThreadReading = false;
            readyForCardSwipe = true;
            this._umMan.release();
            this.isVP3310 = false;
            isVP6300 = false;
            this.m_recListener.deviceDisconnected();
        } else if (this.addUsbSupported && _usb != null) {
            isCommandRunning = false;
            isThreadReading = false;
            readyForCardSwipe = true;
            this.btleStartListen = false;
            this.isVP3310 = false;
            isVP6300 = false;
            isConnected = false;
            this.m_recListener.deviceDisconnected();
        } else if (this._com != null) {
            isCommandRunning = false;
            isThreadReading = false;
            readyForCardSwipe = true;
            this.isVP3310 = false;
            isVP6300 = false;
            isConnected = false;
            this.m_recListener.deviceDisconnected();
        } else if (this._bt != null || _btle != null) {
            _btle = null;
            isCommandRunning = false;
            isThreadReading = false;
            readyForCardSwipe = true;
            this.btleStartListen = false;
            this.isVP3310 = false;
            isVP6300 = false;
            isConnected = false;
            this.m_recListener.deviceDisconnected();
        }
        connectedDevice = ReaderInfo.DEVICE_TYPE.DEVICE_UNKNOWN;
    }

    public String config_getXMLVersionInfo() {
        return this._umMan.getInfo_loadedXmlVersion();
    }

    public String phone_getInfoManufacture() {
        return this._umMan.getInfo_Manufacturer();
    }

    public String phone_getInfoModel() {
        return this._umMan.getInfo_Model();
    }

    public static boolean getCancelTransaction() {
        return cancelTransaction;
    }

    public void log_setVerboseLoggingEnable(boolean enableShowLog) {
        this._umMan.log_setEnableVerbose(enableShowLog);
    }

    private String log_exportLogs() {
        String fileName = "IDT_Log_" + Build.MODEL.replaceAll(" ", "") + "_" + Build.VERSION.RELEASE + ".zip";
        int fileCount = UMLog.exportLogs(new File(Common.getSDRootFilePath()), "IDT_Log", fileName);
        if (fileCount <= 0) {
            UMLog.i("IDT SDK", "No log files found.");
            return null;
        }
        UMLog.i("IDT SDK", "Total of " + fileCount + " log files are attached.");
        this.log_deleteLogs();
        return Common.getSDRootFilePath() + File.separator + fileName;
    }

    public void log_setSaveLogEnable(boolean enable) {
        this._umMan.log_setEnableSave(enable);
    }

    public int log_deleteLogs() {
        return this._umMan.log_delete();
    }

    public void config_setXMLFileNameWithPath(String xmlFilename) {
        this._umMan.config_setPath(xmlFilename);
    }

    public boolean config_loadingConfigurationXMLFile(boolean updateAutomatically) {
        return this._umMan.config_load(updateAutomatically);
    }

    public boolean device_connect() {
        if (this._validate) {
            return this.device_connectNoValidation(this._deviceType);
        }
        TaskManager.TaskStartRet taskRet = null;
        this._taskExport.setAllowSwitchReaders(false);
        this.taskManager.setReaderXommunication(this._umMan);
        if (this.isAudioDeviceSelected()) {
            if (!this.isVolumeInControl()) {
                this.m_recListener.msgAudioVolumeAjustFailed();
            }
            taskRet = this.taskManager.task_start_connect();
        } else {
            if (_usb != null && _usb.isReaderConnected()) {
                return true;
            }
            if (this._com != null && this._com.isReaderConnected()) {
                return true;
            }
            if (this._bt != null && this._bt.isReaderConnected()) {
                return true;
            }
            if (_btle != null && _btle.isReaderConnected()) {
                return true;
            }
        }
        return TaskManager.TaskStartRet.SUCCESS == taskRet;
    }

    public void device_ConnectWithoutValidation(boolean noValidate, ReaderInfo.DEVICE_TYPE deviceType) {
        this._validate = noValidate;
        this._deviceType = deviceType;
    }

    private boolean device_connectNoValidation(ReaderInfo.DEVICE_TYPE type) {
        TaskManager.TaskStartRet taskRet = null;
        this._taskExport.setAllowSwitchReaders(false);
        this.taskManager.setReaderXommunication(this._umMan);
        if (this.isAudioDeviceSelected()) {
            if (!this.isVolumeInControl()) {
                this.m_recListener.msgAudioVolumeAjustFailed();
            }
            Common.PUSType pus = Common.PUSType.MSR1xx;
            pus = type == ReaderInfo.DEVICE_TYPE.DEVICE_UNIMAG_PRO ? Common.PUSType.MSR1xx : (type == ReaderInfo.DEVICE_TYPE.DEVICE_UNIMAG ? Common.PUSType.MSR3xx : (type == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY ? Common.PUSType.UniPay : (type == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V ? Common.PUSType.UniPay : (type == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ ? Common.PUSType.UniPay : null))));
            taskRet = this.taskManager.task_start_connect(pus);
        } else {
            if (_usb != null && _usb.isReaderConnected()) {
                return true;
            }
            if (this._com != null && this._com.isReaderConnected()) {
                return true;
            }
            if (this._bt != null && this._bt.isReaderConnected()) {
                return true;
            }
            if (_btle != null && _btle.isReaderConnected()) {
                return true;
            }
        }
        return TaskManager.TaskStartRet.SUCCESS == taskRet;
    }

    private void device_disconnect() {
        if (this.isAudioDeviceSelected()) {
            this._umMan.getIntern_IOManager().notifyIoManager();
            this._umMan.getIntern_IOManager().stopRecordThread();
            this.taskManager.task_stop();
            this._umMan.cxn_setDisconnected();
        }
    }

    public boolean device_isConnected() {
        if (this.isAudioDeviceSelected()) {
            return this._umMan.getState_isConnected();
        }
        if (this.isBluetoothDeviceSelected()) {
            if (this._bt == null) {
                return false;
            }
            return this._bt.isReaderConnected();
        }
        if (this.isBluetoothLEDeviceSelected()) {
            if (_btle == null) {
                return false;
            }
            return _btle.isReaderConnected();
        }
        if (this.isRS232DeviceSelected()) {
            if (this._com == null) {
                return false;
            }
            return this._com.isReaderConnected();
        }
        if (_usb == null) {
            return false;
        }
        return _usb.isReaderConnected();
    }

    public boolean device_connectWithProfile(StructConfigParameters profile) {
        if (_usb != null && _usb.isReaderConnected()) {
            return true;
        }
        if (this._com != null && this._com.isReaderConnected()) {
            return true;
        }
        if (this._bt != null && this._bt.isReaderConnected()) {
            return true;
        }
        if (_btle != null && _btle.isReaderConnected()) {
            return true;
        }
        if (!this._umMan.setCfg_config(profile)) {
            return false;
        }
        return this.device_connect();
    }

    private boolean _msr_startSwipeCard() {
        if (this.isAudioDeviceSelected()) {
            TaskManager.TaskStartRet r = this.taskManager.task_start_swipe();
            return TaskManager.TaskStartRet.SUCCESS == r;
        }
        if (this.isBluetoothDeviceSelected()) {
            return this._bt.startSwipeCard();
        }
        if (this.isBluetoothLEDeviceSelected()) {
            return _btle.startSwipeCard();
        }
        if (this.isRS232DeviceSelected()) {
            return this._com.startSwipeCard();
        }
        return _usb.startSwipeCard();
    }

    private boolean emv_getDisplayMessage(int timeout, long startTime, ResDataStruct resData) {
        if (resData != null && resData.resData != null && resData.resData.length > 10) {
            return true;
        }
        TaskManager.TaskStartRet r = TaskManager.TaskStartRet.NO_RESPONSE;
        byte[] _lcd_data = null;
        if (this.lcd_data != null) {
            _lcd_data = new byte[this.lcd_data.length];
            try {
                System.arraycopy(this.lcd_data, 0, _lcd_data, 0, this.lcd_data.length);
            }
            catch (ArrayIndexOutOfBoundsException exception) {
                return false;
            }
            this.lcd_data = null;
        }
        UMLog.i("emv_getDisplayMessage", "_lcd_data length: " + (_lcd_data != null && _lcd_data.length > 0 ? _lcd_data.length : 0));
        UMLog.i("emv_getDisplayMessage", "_lcd_data: " + (_lcd_data != null && _lcd_data.length > 0 ? Common.base16Encode(_lcd_data) : "null"));
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_BTPAY || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_BTPAY_USB) {
            startTime = System.currentTimeMillis();
        }
        if (this.isAudioDeviceSelected()) {
            int _timeout = (int)((System.currentTimeMillis() - startTime) / 1000L);
            if (_timeout > timeout) {
                return false;
            }
            if (audioUnplugged) {
                audioUnplugged = false;
                return false;
            }
            r = _lcd_data == null ? this.sendCommand_helper(null, 5, resData) : (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V ? this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)97, (byte)1, _lcd_data)), 5, resData) : this.sendCommand_helper("724901" + Common.getHexStringFromBytes(_lcd_data), 0, resData));
            if (r != TaskManager.TaskStartRet.SUCCESS || resData == null || resData.resData == null) {
                return emvCancelTransaction;
            }
            return true;
        }
        if (this.isBluetoothDeviceSelected()) {
            if (_lcd_data == null) {
                isTransactionRead = true;
                boolean bRet = this._bt.readMessage(timeout, startTime, resData);
                isTransactionRead = false;
                return bRet;
            }
            r = this.sendCommand_helper("724901" + Common.getHexStringFromBytes(_lcd_data), 0, resData);
            return r == TaskManager.TaskStartRet.SUCCESS && resData != null && resData.resData != null;
        }
        if (this.isBluetoothLEDeviceSelected()) {
            if (_lcd_data == null) {
                startTime = System.currentTimeMillis();
                isTransactionRead = true;
                boolean bRet = _btle.emv_readMessage(timeout, startTime, resData, false);
                isTransactionRead = false;
                UMLog.i("emv_getDisplayMessage", "readMessage resData length: " + (resData != null && resData.resData != null && resData.resData.length > 0 ? resData.resData.length : 0));
                UMLog.i("emv_getDisplayMessage", "readMessage resData: " + (resData != null && resData.resData != null && resData.resData.length > 0 ? Common.base16Encode(resData.resData) : "null"));
                UMLog.i("emv_getDisplayMessage", "bRet: " + bRet);
                return bRet;
            }
            if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT) {
                UMLog.i("emv_getDisplayMessage", "Send 0x61-01: " + Common.base16Encode(_lcd_data));
                this.sendCommandOnly_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)97, (byte)1, _lcd_data)), 5);
                return true;
            }
            if (resData == null || resData.resData == null) {
                UMLog.i("emv_getDisplayMessage", "return false");
                return false;
            }
            UMLog.i("emv_getDisplayMessage", "return true");
            return true;
        }
        if (this.isRS232DeviceSelected()) {
            if (_lcd_data == null) {
                isTransactionRead = true;
                boolean bRet = this._com.readMessage(timeout, startTime, resData, false);
                isTransactionRead = false;
                return bRet;
            }
            if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
                this.sendCommandOnly_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)97, (byte)1, _lcd_data)), 5);
                return true;
            }
            return r == TaskManager.TaskStartRet.SUCCESS && resData != null && resData.resData != null;
        }
        if (_lcd_data == null) {
            isTransactionRead = true;
            boolean bRet = _usb.readMessage(timeout, startTime, resData, false);
            isTransactionRead = false;
            return bRet;
        }
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
            this.sendCommandOnly_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)97, (byte)1, _lcd_data)), 5);
            return true;
        }
        byte[] data = new byte[_lcd_data.length + 3];
        int len = _lcd_data.length + 2;
        data[0] = (byte)len;
        len = _lcd_data.length;
        data[1] = (byte)(len & 0xFF);
        data[2] = (byte)(len >> 8 & 0xFF);
        try {
            System.arraycopy(_lcd_data, 0, data, 3, _lcd_data.length);
        }
        catch (ArrayIndexOutOfBoundsException exception) {
            return false;
        }
        r = this.sendCommand_helper("724901" + Common.getHexStringFromBytes(data), 5, resData);
        this.convertIDG(resData, 1);
        return r == TaskManager.TaskStartRet.SUCCESS && resData != null && resData.resData != null;
    }

    @Deprecated
    public boolean msr_isSwipeCardRunning() {
        return this.taskManager.getState_getRunningTask() == TaskManager.RUNING_TASK.TASK_MSR;
    }

    public int device_startRKI() {
        return this.device_startRKI(null);
    }

    public int device_startRKI(boolean isDemo) {
        return this.device_startRKI(null, isDemo);
    }

    public int device_startRKI(String Key2) {
        return this.device_startRKI(Key2, false);
    }

    public int device_startRKI(String Key2, boolean isDemo) {
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (!Common.isOnline(context)) {
            UMLog.i("IDT_Device", "RKI failed: No internet connection");
            return 261;
        }
        if (!this.device_isConnected()) {
            UMLog.i("IDT_Device", "RKI failed: reader not connected");
            return 1;
        }
        RemoteKeyInjectionTask.isDemo = isDemo;
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT) {
            if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT) {
                TaskManager.TaskStartRet r = this.taskManager.task_start_rki(this.m_recListener, _btle, Key2);
            } else if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
                TaskManager.TaskStartRet r = this.taskManager.task_start_rki(this.m_recListener, this._com, Key2);
            } else {
                TaskManager.TaskStartRet r = this.taskManager.task_start_rki(this.m_recListener, _usb, Key2);
            }
            return 0;
        }
        return 20;
    }

    public void device_setSymmetric_RKI_URL(String srki_url) {
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER) {
            RemoteKeyInjectionTask.SRKI_URL = srki_url;
        } else {
            RemoteKeyInjectionTask.LSRKI_URL = srki_url;
        }
    }

    public static boolean getUSBBypass() {
        return _enableUSBBypass;
    }

    private static void redirectDeviceOutput(boolean redirect) {
        _enableUSBBypass = redirect;
    }

    private void setBypassListener(USBBypassListener callback) {
        this.bypassListener = callback;
        _enableUSBBypass = true;
    }

    private void clearBypassListener() {
        this.bypassListener = null;
        _enableUSBBypass = false;
    }

    private IDT_Device getSDKInstance() {
        return this;
    }

    private void externalConnect() {
        if (IDT_Device.getUSBBypass() && _usb != null) {
            _usb.externalConnect();
        }
    }

    private void externalDisconnect() {
        if (IDT_Device.getUSBBypass() && _usb != null) {
            _usb.externalDisconnect();
        }
    }

    private void externalDeviceNotFound() {
        if (IDT_Device.getUSBBypass() && _usb != null) {
            _usb.externalDeviceNotFound();
        }
    }

    private static void receiveVirtualData(byte[] data) {
        while (inVD) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (data == null) {
            return;
        }
        if (data.length == 0) {
            return;
        }
        inRD = true;
        System.arraycopy(data, 0, vdData, vdPOS, data.length);
        vdPOS += data.length;
        inRD = false;
    }

    public static int rVD(byte[] response) {
        while (inRD) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        inVD = true;
        if (vdPOS > 0) {
            int len = vdPOS;
            System.arraycopy(vdData, 0, response, 0, len);
            Arrays.fill(vdData, (byte)0);
            vdPOS = 0;
            inVD = false;
            return len;
        }
        inVD = false;
        return 0;
    }

    private void convertIDG(ResDataStruct respData, int offset) {
        if (respData.resData == null || respData.resData.length == 0) {
            return;
        }
        byte[] idgCmd = new byte[]{86, 105, 86, 79, 116, 101, 99, 104};
        byte[] cmd = new byte[8];
        if (respData.resData.length > 8) {
            System.arraycopy(respData.resData, 0, cmd, 0, 8);
        }
        byte[] ret = new byte[respData.resData.length];
        try {
            System.arraycopy(respData.resData, 0, ret, 0, ret.length);
        }
        catch (ArrayIndexOutOfBoundsException exception) {
            return;
        }
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_BTMAG) {
            respData.resData = new byte[ret.length - 2];
            try {
                System.arraycopy(ret, 2, respData.resData, 0, ret.length - 2);
            }
            catch (ArrayIndexOutOfBoundsException exception) {
                return;
            }
            return;
        }
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIMAG) {
            return;
        }
        if (Arrays.equals(cmd, idgCmd)) {
            if (ret.length < 15) {
                return;
            }
            respData.statusCode = ret[11];
            int idgLen = (ret[12] & 0xFF) * 256 + (ret[13] & 0xFF);
            if (idgLen + 16 > ret.length) {
                return;
            }
            if (idgLen > 0) {
                respData.resData = new byte[idgLen - offset];
                System.arraycopy(ret, 14 + offset, respData.resData, 0, idgLen - offset);
                if (respData.responseIdxes != null) {
                    for (int i = 0; i < respData.responseIdxes.length; ++i) {
                        int tempLen = i == respData.responseIdxes.length - 1 ? ret.length - respData.responseIdxes[i] : respData.responseIdxes[i + 1] - respData.responseIdxes[i];
                        byte[] temp = new byte[tempLen];
                        try {
                            System.arraycopy(ret, respData.responseIdxes[i], temp, 0, tempLen);
                        }
                        catch (ArrayIndexOutOfBoundsException exception) {
                            return;
                        }
                        respData.responseIdxes[i] = idgLen;
                        idgLen = (temp[12] & 0xFF) * 256 + (temp[13] & 0xFF);
                        if (idgLen <= 0) continue;
                        try {
                            byte[] tmp = new byte[respData.resData.length];
                            System.arraycopy(respData.resData, 0, tmp, 0, respData.resData.length);
                            respData.resData = new byte[respData.responseIdxes[i] + idgLen];
                            System.arraycopy(tmp, 0, respData.resData, 0, tmp.length);
                            System.arraycopy(temp, 14, respData.resData, tmp.length, idgLen);
                            continue;
                        }
                        catch (ArrayIndexOutOfBoundsException exception) {
                            return;
                        }
                    }
                }
            } else {
                respData.resData = new byte[0];
            }
        } else {
            int idgLen = (ret[2] & 0xFF) * 256 + (ret[1] & 0xFF) - 1;
            if (idgLen + 7 > ret.length) {
                return;
            }
            if ((idgLen += offset) > 0) {
                respData.resData = new byte[idgLen];
                try {
                    System.arraycopy(ret, 4 - offset, respData.resData, 0, idgLen);
                }
                catch (ArrayIndexOutOfBoundsException exception) {
                    return;
                }
            } else {
                respData.resData = new byte[0];
            }
        }
    }

    public TaskManager.TaskStartRet sendAudioCommand_helper(String cmd, int timeout, ResDataStruct respData) {
        return this.sendCommand_helper(cmd, timeout, respData);
    }

    private TaskManager.TaskStartRet sendCommand_helper(String cmd, int timeout, ResDataStruct respData) {
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIMAG_PRO) {
            return TaskManager.TaskStartRet.NOT_SUPPORTED;
        }
        byte[] command = null;
        if (this.isAudioDeviceSelected()) {
            TaskManager.TaskStartRet r;
            Common.beginTimeEachCmd = Common.getCurrentTime();
            Common.commandTime = timeout == 0 ? 5.0 : (double)timeout;
            int powerupBeforeCmd = 200;
            if (this._umMan.getCfg_config() != null) {
                powerupBeforeCmd = this._umMan.getCfg_config().getPowerupLastBeforeCMD();
            }
            if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIMAG || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIJACK || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIMAG_PRO) {
                command = Common.base16Decode(cmd);
                this.m_recListener.dataInOutMonitor(command, false);
                r = this.taskManager.task_start_command_synchro(command, respData);
            } else if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V) {
                _ignorePing = true;
                if (cmd == null) {
                    this.m_recListener.dataInOutMonitor(command, false);
                    r = this.taskManager.task_start_command_synchro(null, respData);
                } else {
                    command = Common.getBytesFromHexString(Common.packageCommandForVendi(cmd));
                    this.m_recListener.dataInOutMonitor(command, false);
                    r = this.taskManager.task_start_command_synchro(command, respData);
                }
            } else {
                command = Common.makeCommand(cmd, powerupBeforeCmd);
                this.m_recListener.dataInOutMonitor(command, false);
                r = this.taskManager.task_start_command_synchro(command, respData);
            }
            if (r == TaskManager.TaskStartRet.SDK_BUSY) {
                return TaskManager.TaskStartRet.SDK_BUSY;
            }
            if (respData.resData == null) {
                return TaskManager.TaskStartRet.NO_RESPONSE;
            }
            return r;
        }
        if (this.isBluetoothDeviceSelected()) {
            command = Common.makeCommand(cmd);
            this.m_recListener.dataInOutMonitor(command, false);
            byte[] ret = this._bt.sendCommand(command, timeout);
            if (ret == null) {
                return TaskManager.TaskStartRet.NO_RESPONSE;
            }
            respData.resData = new byte[ret.length];
            System.arraycopy(ret, 0, respData.resData, 0, ret.length);
            return TaskManager.TaskStartRet.SUCCESS;
        }
        if (this.isBluetoothLEDeviceSelected()) {
            command = Common.makeCommand(cmd);
            if (command.length > 4096) {
                return TaskManager.TaskStartRet.BLE_CMD_OVERFLOW;
            }
            this.m_recListener.dataInOutMonitor(command, false);
            byte[] ret = _btle.sendCommand(command, timeout);
            if (ret == null) {
                return TaskManager.TaskStartRet.NO_RESPONSE;
            }
            if (ret.length == 1 && ret[1] == 7) {
                return TaskManager.TaskStartRet.BLE_CMD_OVERFLOW;
            }
            respData.resData = new byte[ret.length];
            System.arraycopy(ret, 0, respData.resData, 0, ret.length);
            return TaskManager.TaskStartRet.SUCCESS;
        }
        if (this.isRS232DeviceSelected()) {
            if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
                if (timeout == 0) {
                    Common.commandTime = 3.0;
                    timeout = 3;
                } else {
                    Common.commandTime = timeout;
                }
            }
            command = Common.makeCommand(cmd);
            byte[] cmd_no_len = null;
            if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM && command != null && command.length > 1) {
                cmd_no_len = new byte[command.length - 1];
                System.arraycopy(command, 1, cmd_no_len, 0, cmd_no_len.length);
            }
            this.m_recListener.dataInOutMonitor(cmd_no_len, false);
            if (command == null) {
                this._com.PAT_Wakeup();
                return TaskManager.TaskStartRet.SUCCESS;
            }
            byte[] ret = this._com.sendCommand(command, timeout);
            if (ret == null) {
                return TaskManager.TaskStartRet.NO_RESPONSE;
            }
            respData.resData = new byte[ret.length];
            System.arraycopy(ret, 0, respData.resData, 0, ret.length);
            return TaskManager.TaskStartRet.SUCCESS;
        }
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
            if (timeout == 0) {
                if (infiniteTimeout) {
                    Common.commandTime = timeout;
                } else {
                    Common.commandTime = 3.0;
                    timeout = 3;
                }
            } else {
                Common.commandTime = timeout;
            }
        } else if ((connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA) && timeout == 0) {
            timeout = 3;
        }
        command = Common.makeCommand(cmd);
        byte[] cmd_no_len = null;
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB) {
            if (command != null && command.length > 1) {
                cmd_no_len = new byte[command.length - 1];
                System.arraycopy(command, 1, cmd_no_len, 0, cmd_no_len.length);
            }
        } else if (command != null && command.length > 0) {
            cmd_no_len = new byte[command.length];
            System.arraycopy(command, 0, cmd_no_len, 0, cmd_no_len.length);
        }
        if (cmd != null && (cmd.contains("5669564F7465636832009025") || cmd.contains("5669564f7465636832009025"))) {
            byte[] cmd_9025 = new byte[12];
            System.arraycopy(cmd_no_len, 0, cmd_9025, 0, 12);
            this.m_recListener.dataInOutMonitor(cmd_9025, false);
        } else {
            this.m_recListener.dataInOutMonitor(cmd_no_len, false);
        }
        if (command == null) {
            _usb.PAT_Wakeup();
            return TaskManager.TaskStartRet.SUCCESS;
        }
        byte[] ret = _usb.sendCommand(command, timeout);
        if (ret == null) {
            return TaskManager.TaskStartRet.NO_RESPONSE;
        }
        respData.resData = new byte[ret.length];
        System.arraycopy(ret, 0, respData.resData, 0, ret.length);
        return TaskManager.TaskStartRet.SUCCESS;
    }

    private TaskManager.TaskStartRet sendCommandOnly_helper(String cmd, int timeout) {
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIMAG_PRO) {
            return TaskManager.TaskStartRet.NOT_SUPPORTED;
        }
        byte[] command = null;
        if (this.isAudioDeviceSelected()) {
            TaskManager.TaskStartRet r;
            Common.beginTimeEachCmd = Common.getCurrentTime();
            Common.commandTime = timeout == 0 ? 0.0 : (double)timeout;
            int powerupBeforeCmd = 200;
            if (this._umMan.getCfg_config() != null) {
                powerupBeforeCmd = this._umMan.getCfg_config().getPowerupLastBeforeCMD();
            }
            if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIMAG || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIJACK) {
                command = Common.base16Decode(cmd);
                this.m_recListener.dataInOutMonitor(command, false);
                r = this.taskManager.task_start_command_send_only_synchro(command);
            } else if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V) {
                _ignorePing = true;
                if (cmd == null) {
                    this.m_recListener.dataInOutMonitor(command, false);
                    r = this.taskManager.task_start_command_send_only_synchro(null);
                } else {
                    command = Common.getBytesFromHexString(Common.packageCommandForVendi(cmd));
                    this.m_recListener.dataInOutMonitor(command, false);
                    r = this.taskManager.task_start_command_send_only_synchro(command);
                }
            } else {
                command = Common.makeCommand(cmd, powerupBeforeCmd);
                this.m_recListener.dataInOutMonitor(command, false);
                r = this.taskManager.task_start_command_send_only_synchro(command);
            }
            if (r == TaskManager.TaskStartRet.SDK_BUSY) {
                return TaskManager.TaskStartRet.SDK_BUSY;
            }
            return r;
        }
        if (this.isBluetoothDeviceSelected()) {
            command = Common.makeCommand(cmd);
            this.m_recListener.dataInOutMonitor(command, false);
            this._bt.sendCommandOnly(cmd, timeout);
            return TaskManager.TaskStartRet.SUCCESS;
        }
        if (this.isBluetoothLEDeviceSelected()) {
            command = Common.makeCommand(cmd);
            if (command.length > 2048) {
                return TaskManager.TaskStartRet.BLE_CMD_OVERFLOW;
            }
            this.m_recListener.dataInOutMonitor(command, false);
            _btle.sendCommandOnly(cmd, timeout);
            return TaskManager.TaskStartRet.SUCCESS;
        }
        if (this.isRS232DeviceSelected()) {
            if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
                if (timeout == 0) {
                    Common.commandTime = 5.0;
                    timeout = 5;
                } else {
                    Common.commandTime = timeout;
                }
            }
            command = Common.makeCommand(cmd);
            byte[] cmd_no_len = null;
            if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM && command != null && command.length > 1) {
                cmd_no_len = new byte[command.length - 1];
                System.arraycopy(command, 1, cmd_no_len, 0, cmd_no_len.length);
            }
            this.m_recListener.dataInOutMonitor(cmd_no_len, false);
            if (command == null) {
                this._com.PAT_Wakeup();
                return TaskManager.TaskStartRet.SUCCESS;
            }
            this._com.sendCommandOnly(cmd, timeout);
            return TaskManager.TaskStartRet.SUCCESS;
        }
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
            if (timeout == 0) {
                Common.commandTime = 5.0;
                timeout = 5;
            } else {
                Common.commandTime = timeout;
            }
        } else if ((connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA) && timeout == 0) {
            timeout = 5;
        }
        command = Common.makeCommand(cmd);
        byte[] cmd_no_len = null;
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB) {
            if (command != null && command.length > 1) {
                cmd_no_len = new byte[command.length - 1];
                System.arraycopy(command, 1, cmd_no_len, 0, cmd_no_len.length);
            }
        } else if (command != null && command.length > 0) {
            cmd_no_len = new byte[command.length];
            System.arraycopy(command, 0, cmd_no_len, 0, cmd_no_len.length);
        }
        this.m_recListener.dataInOutMonitor(cmd_no_len, false);
        if (command == null) {
            _usb.PAT_Wakeup();
            return TaskManager.TaskStartRet.SUCCESS;
        }
        _usb.sendCommandOnly(cmd, timeout);
        return TaskManager.TaskStartRet.SUCCESS;
    }

    private void waitForNotification() {
        block9: {
            block8: {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA) break block8;
                while (isCheckingNotification) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                break block9;
            }
            if (!isAutoPollOn && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT) break block9;
            UMLog.i("**waitForNotification**", "isCheckingNotification: " + isCheckingNotification + " isThreadReading: " + isThreadReading);
            while (isCheckingNotification || isThreadReading) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public String config_getSDKVersion() {
        return this._umMan.getInfo_SDKVersionString();
    }

    public int device_getFirmwareVersion(StringBuilder version) {
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (version == null) {
            return 27392;
        }
        ResDataStruct respData = new ResDataStruct();
        isCommandRunning = true;
        this.waitForNotification();
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIMAG || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIJACK || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_BTMAG || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIMAG_PRO) {
            r = this.sendCommand_helper("0252220371", 0, respData);
        } else {
            if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG_KB) {
                TaskManager.TaskStartRet r2 = this.sendCommand_helper("0252220371", 3, respData);
                int ec = this.returnACK(r2, respData);
                if (ec == 0) {
                    String verStr = new String(respData.resData);
                    version.append(verStr);
                }
                isCommandRunning = false;
                return ec;
            }
            if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
                TaskManager.TaskStartRet r3;
                int rt = 9;
                int cmd = 41;
                if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V) {
                    this.waitForVivo();
                }
                int loopNum = 0;
                do {
                    r3 = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)41, (byte)0, new byte[0])), 0, respData);
                    ++loopNum;
                    if (r3 == TaskManager.TaskStartRet.SUCCESS) {
                        if (respData.resData == null) {
                            isCommandRunning = false;
                            return 21;
                        }
                        if (respData.resData.length == 1 && respData.resData[0] == 0) {
                            isCommandRunning = false;
                            return 3;
                        }
                        rt = 9;
                        int len = respData.resData.length;
                        if (len > 13) {
                            rt = respData.resData[11];
                            cmd = respData.resData[10];
                            if (rt == 0 && cmd == 41) {
                                int firmLen = respData.resData[13] & 0xFF;
                                byte[] firm = new byte[firmLen];
                                System.arraycopy(respData.resData, 14, firm, 0, firmLen);
                                String verStr = Common.getAsciiFromByte(firm);
                                version.append(verStr);
                            } else if (cmd == -18 && rt == -16) break;
                        }
                    }
                    if (loopNum >= maxLoopNum || rt == 0 && cmd == 41) continue;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException len) {
                        // empty catch block
                    }
                } while (loopNum < maxLoopNum && (rt != 0 || cmd != 41));
                isCommandRunning = false;
                return this.returnACK(r3, respData);
            }
            boolean needTimeDebug = false;
            if (needTimeDebug) {
                int fwTimeout_PAT110 = 300;
                byte[] byteTimeoutPAT110 = new byte[]{(byte)fwTimeout_PAT110};
                String timeoutPAT110 = Common.getHexStringFromBytes(byteTimeoutPAT110);
                r = this.sendCommand_helper("784601" + timeoutPAT110, 0, respData);
            } else {
                r = this.sendCommand_helper("784601", 0, respData);
            }
        }
        int ec = this.returnACK(r, respData);
        if (ec == 0) {
            int respLen;
            int startPos;
            byte[] buff = respData.resData;
            int len = respData.resData.length;
            String ver = new String();
            if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIMAG || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIJACK || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_BTMAG) {
                startPos = 2;
                respLen = len - 2;
            } else {
                startPos = 4;
                respLen = len - 3;
            }
            byte[] slice = Arrays.copyOfRange(buff, startPos, respLen);
            ver = Common.byteToString(slice);
            version.append(ver);
        }
        isCommandRunning = false;
        return ec;
    }

    public int device_getDeviceTreeVersion(StringBuilder version) {
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (version == null) {
            return 27392;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB) {
            return 20;
        }
        ResDataStruct respData = new ResDataStruct();
        isCommandRunning = true;
        this.waitForNotification();
        int rt = 9;
        int cmd = 41;
        int loopNum = 0;
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)41, (byte)11, new byte[]{1})), 0, respData);
            ++loopNum;
            if (r == TaskManager.TaskStartRet.SUCCESS) {
                if (respData.resData == null) {
                    isCommandRunning = false;
                    return 21;
                }
                if (respData.resData.length == 1 && respData.resData[0] == 0) {
                    isCommandRunning = false;
                    return 3;
                }
                rt = 9;
                int len = respData.resData.length;
                if (len > 13) {
                    rt = respData.resData[11];
                    cmd = respData.resData[10];
                    if (rt == 0 && cmd == 41) {
                        int deviceTreeLen = respData.resData[13] & 0xFF;
                        byte[] deviceTree = new byte[deviceTreeLen];
                        System.arraycopy(respData.resData, 14, deviceTree, 0, deviceTreeLen);
                        String verStr = Common.getAsciiFromByte(deviceTree);
                        version.append(verStr);
                    } else if (cmd == -18 && rt == -16) break;
                }
            }
            if (loopNum >= maxLoopNum || rt == 0 && cmd == 41) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != 41));
        isCommandRunning = false;
        return this.returnACK(r, respData);
    }

    private byte[] getFirmwareVersionForTTK() {
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return null;
        }
        if (!this.device_isConnected()) {
            return null;
        }
        ResDataStruct respData = new ResDataStruct();
        byte[] version = null;
        isCommandRunning = true;
        this.waitForNotification();
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIMAG || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIJACK || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_BTMAG) {
            r = this.sendCommand_helper("0252220371", 0, respData);
        } else {
            if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
                int rt = 9;
                int cmd = 41;
                if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V) {
                    this.waitForVivo();
                }
                int loopNum = 0;
                do {
                    TaskManager.TaskStartRet r2 = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)41, (byte)0, new byte[0])), 0, respData);
                    ++loopNum;
                    if (r2 == TaskManager.TaskStartRet.SUCCESS) {
                        if (respData.resData == null) {
                            isCommandRunning = false;
                            return null;
                        }
                        if (respData.resData.length == 1 && respData.resData[0] == 0) {
                            isCommandRunning = false;
                            return null;
                        }
                        rt = 9;
                        int len = respData.resData.length;
                        if (len > 13) {
                            rt = respData.resData[11];
                            cmd = respData.resData[10];
                            if (rt == 0 && cmd == 9) {
                                int firmLen = respData.resData[16] & 0xFF;
                                version = new byte[firmLen];
                                System.arraycopy(respData.resData, 17, version, 0, firmLen);
                            } else if (cmd == -18 && rt == -16) break;
                        }
                    }
                    if (loopNum >= maxLoopNum || rt == 0 && cmd == 41) continue;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException len) {
                        // empty catch block
                    }
                } while (loopNum < maxLoopNum && (rt != 0 || cmd != 41));
                isCommandRunning = false;
                return version;
            }
            r = this.sendCommand_helper("7831", 0, respData);
        }
        int ec = this.returnACK(r, respData);
        if (ec == 0) {
            int respLen;
            int startPos;
            byte[] buff = respData.resData;
            int len = respData.resData.length;
            if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIMAG || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIJACK || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_BTMAG) {
                startPos = 2;
                respLen = len - 2;
            } else {
                startPos = 4;
                respLen = len - 3;
            }
            version = Arrays.copyOfRange(buff, startPos, respLen);
        }
        isCommandRunning = false;
        return version;
    }

    public int device_updateFirmware(String[] commands) {
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VENDI && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
            return 20;
        }
        if (commands == null) {
            return 27392;
        }
        int i = 0;
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER) {
            for (i = 0; i < commands.length && !commands[i].contains("- 1M") && !commands[i].contains("NEO"); ++i) {
            }
        }
        if (i == commands.length) {
            return 27392;
        }
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB ? !commands[i].equalsIgnoreCase("#Unipay III - 1M") : (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB ? !commands[i].equalsIgnoreCase("#Unipay 1.5 - 1M") : connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && !commands[i].equalsIgnoreCase("#NEO2 NEO3"))) {
            return 27392;
        }
        isCommandRunning = true;
        this.waitForNotification();
        if (this._fwTool != null) {
            this._fwTool.setFmFile(commands);
            if (this._fwTool.updateFirmware()) {
                isCommandRunning = false;
                return 0;
            }
            isCommandRunning = false;
            return 9;
        }
        isCommandRunning = false;
        return 9;
    }

    public int device_updateFirmware(byte[] data, ReaderInfo.FIRMWARE_UPDATE_TYPES ft) {
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT || ft != ReaderInfo.FIRMWARE_UPDATE_TYPES.FU_PACKAGE_DOWNLOAD)) {
            return 20;
        }
        if (data == null) {
            return 27392;
        }
        Common.update_type = ft;
        isCommandRunning = true;
        this.waitForNotification();
        if (this._fwTool != null) {
            this._fwTool.setFmFile(data);
            if (this._fwTool.updateFirmware()) {
                return 0;
            }
            isCommandRunning = false;
            return 9;
        }
        isCommandRunning = false;
        return 9;
    }

    private boolean device_updateFirmwareWithZipFile(String zipFilename) {
        int idx = 0;
        String fileNameWithPath = null;
        String path = Environment.getExternalStorageDirectory().toString();
        String directoryNameWithPath = path + "/FirmwareUpdate/";
        ret = 0;
        if (!init) {
            fileNameWithPath = path + File.separator + zipFilename;
            File theDir = new File(directoryNameWithPath);
            if (!theDir.exists()) {
                theDir.mkdirs();
            }
            try {
                Common.unzip(fileNameWithPath, directoryNameWithPath);
            }
            catch (Exception e) {
                Log.e((String)"Decompress", (String)"unzip", (Throwable)e);
                return true;
            }
            for (idx = 0; idx < 20; ++idx) {
                IDT_Device.Scripts[idx] = new MetadataScript();
                IDT_Device.Scripts[idx].ResultScripts = new ResultScript[5];
                IDT_Device.Scripts[idx].ResultScripts[0] = new ResultScript();
                IDT_Device.Scripts[idx].ResultScripts[0].Result = -1;
                IDT_Device.Scripts[idx].ResultScripts[1] = new ResultScript();
                IDT_Device.Scripts[idx].ResultScripts[1].Result = -1;
                IDT_Device.Scripts[idx].ResultScripts[2] = new ResultScript();
                IDT_Device.Scripts[idx].ResultScripts[2].Result = -1;
                IDT_Device.Scripts[idx].ResultScripts[3] = new ResultScript();
                IDT_Device.Scripts[idx].ResultScripts[3].Result = -1;
                IDT_Device.Scripts[idx].ResultScripts[4] = new ResultScript();
                IDT_Device.Scripts[idx].ResultScripts[4].Result = -1;
            }
            String StartScrpt = this.getFirmwareFilenamesFromJson(directoryNameWithPath + "Metadata.json", Scripts);
            if (StartScrpt == null) {
                return true;
            }
            StringBuilder sb = new StringBuilder();
            firmwareVersion = null;
            ret = this.device_getFirmwareVersion(sb);
            if (ret == 0) {
                firmwareVersion = sb.toString();
            }
            ResDataStruct resData = new ResDataStruct();
            bootloaderVersion = null;
            ret = this.device_sendDataCommand("2904", false, null, resData);
            if (ret == 0) {
                bootloaderVersion = Common.getAsciiFromByte(resData.resData);
            }
            RT1050Version = null;
            ret = this.device_sendDataCommand("2980", false, null, resData);
            if (ret == 0) {
                RT1050Version = Common.getAsciiFromByte(resData.resData);
            }
            kernelVersion = null;
            ret = this.device_sendDataCommand("0920", false, null, resData);
            if (ret == 0) {
                kernelVersion = Common.getAsciiFromByte(resData.resData);
            }
            nextScript = StartScrpt;
            init = true;
        }
        if (appReboot >= 2) {
            appReboot = 0;
        }
        idx = 0;
        int start = 0;
        int end = 0;
        while (nextScript != null && nextScript.length() > 0) {
            String version;
            UMLog.i("**device_updateFirmwareWithZipFile**", "nextScript=" + nextScript);
            fw_data = null;
            fw_commands = null;
            for (idx = 0; idx < Scripts.length && !nextScript.equals(IDT_Device.Scripts[idx].Name); ++idx) {
            }
            if (idx >= Scripts.length) {
                init = false;
                return true;
            }
            fileNameWithPath = directoryNameWithPath + IDT_Device.Scripts[idx].fname;
            fw_data = this.getStringArrayFromFirmwareBinaryFile(fileNameWithPath);
            if (fw_data == null || fw_data.length == 0) {
                nextScript = this.getNextScript(Scripts, idx, 1);
                continue;
            }
            if (IDT_Device.Scripts[idx].fname.toLowerCase().contains("_ct_")) {
                end = kernelVersion.indexOf(" ");
                version = kernelVersion.substring(0, end);
                start = kernelVersion.indexOf(version);
                end = kernelVersion.indexOf("\r", start);
                version = kernelVersion.substring(start, end);
                if (IDT_Device.Scripts[idx].BypassWhenVersionStringMatch != null && IDT_Device.Scripts[idx].BypassWhenVersionStringMatch.length() > 0 && IDT_Device.Scripts[idx].BypassWhenVersionStringMatch.equals(version)) {
                    nextScript = this.getNextScript(Scripts, idx, 2);
                    appReboot = 0;
                    continue;
                }
                if (IDT_Device.Scripts[idx].BypassWhenVersionGreaterOrEqualTo != null && IDT_Device.Scripts[idx].BypassWhenVersionGreaterOrEqualTo.length() > 0 && IDT_Device.Scripts[idx].BypassWhenVersionGreaterOrEqualTo.compareTo(version) <= 0) {
                    nextScript = this.getNextScript(Scripts, idx, 3);
                    appReboot = 0;
                    continue;
                }
                if (IDT_Device.Scripts[idx].BypassWhenVersionLessOrEqualTo != null && IDT_Device.Scripts[idx].BypassWhenVersionLessOrEqualTo.length() > 0 && IDT_Device.Scripts[idx].BypassWhenVersionLessOrEqualTo.compareTo(version) >= 0) {
                    nextScript = this.getNextScript(Scripts, idx, 4);
                    appReboot = 0;
                    continue;
                }
                kernelDone = false;
                kernel = true;
                ret = this.device_updateFirmware(fw_data, ReaderInfo.FIRMWARE_UPDATE_TYPES.FU_KERNEL_CT);
            } else if (IDT_Device.Scripts[idx].fname.toLowerCase().contains("_amex")) {
                end = kernelVersion.indexOf(" ");
                version = kernelVersion.substring(0, end);
                start = kernelVersion.indexOf(version);
                end = kernelVersion.indexOf("\r", start);
                version = kernelVersion.substring(start, end);
                if (IDT_Device.Scripts[idx].BypassWhenVersionStringMatch != null && IDT_Device.Scripts[idx].BypassWhenVersionStringMatch.length() > 0 && IDT_Device.Scripts[idx].BypassWhenVersionStringMatch.equals(version)) {
                    nextScript = this.getNextScript(Scripts, idx, 2);
                    appReboot = 0;
                    continue;
                }
                if (IDT_Device.Scripts[idx].BypassWhenVersionGreaterOrEqualTo != null && IDT_Device.Scripts[idx].BypassWhenVersionGreaterOrEqualTo.length() > 0 && IDT_Device.Scripts[idx].BypassWhenVersionGreaterOrEqualTo.compareTo(version) <= 0) {
                    nextScript = this.getNextScript(Scripts, idx, 3);
                    appReboot = 0;
                    continue;
                }
                if (IDT_Device.Scripts[idx].BypassWhenVersionLessOrEqualTo != null && IDT_Device.Scripts[idx].BypassWhenVersionLessOrEqualTo.length() > 0 && IDT_Device.Scripts[idx].BypassWhenVersionLessOrEqualTo.compareTo(version) >= 0) {
                    nextScript = this.getNextScript(Scripts, idx, 4);
                    appReboot = 0;
                    continue;
                }
                kernelDone = false;
                kernel = true;
                ret = this.device_updateFirmware(fw_data, ReaderInfo.FIRMWARE_UPDATE_TYPES.FU_KERNEL_AMEX);
            } else if (IDT_Device.Scripts[idx].fname.toLowerCase().contains("_apvas")) {
                end = kernelVersion.indexOf(" ");
                version = kernelVersion.substring(0, end);
                start = kernelVersion.indexOf(version);
                end = kernelVersion.indexOf("\r", start);
                version = kernelVersion.substring(start, end);
                if (IDT_Device.Scripts[idx].BypassWhenVersionStringMatch != null && IDT_Device.Scripts[idx].BypassWhenVersionStringMatch.length() > 0 && IDT_Device.Scripts[idx].BypassWhenVersionStringMatch.equals(version)) {
                    nextScript = this.getNextScript(Scripts, idx, 2);
                    appReboot = 0;
                    continue;
                }
                if (IDT_Device.Scripts[idx].BypassWhenVersionGreaterOrEqualTo != null && IDT_Device.Scripts[idx].BypassWhenVersionGreaterOrEqualTo.length() > 0 && IDT_Device.Scripts[idx].BypassWhenVersionGreaterOrEqualTo.compareTo(version) <= 0) {
                    nextScript = this.getNextScript(Scripts, idx, 3);
                    appReboot = 0;
                    continue;
                }
                if (IDT_Device.Scripts[idx].BypassWhenVersionLessOrEqualTo != null && IDT_Device.Scripts[idx].BypassWhenVersionLessOrEqualTo.length() > 0 && IDT_Device.Scripts[idx].BypassWhenVersionLessOrEqualTo.compareTo(version) >= 0) {
                    nextScript = this.getNextScript(Scripts, idx, 4);
                    appReboot = 0;
                    continue;
                }
                kernelDone = false;
                kernel = true;
                ret = this.device_updateFirmware(fw_data, ReaderInfo.FIRMWARE_UPDATE_TYPES.FU_KERNEL_APVAS);
            } else if (IDT_Device.Scripts[idx].fname.toLowerCase().contains("_cup")) {
                end = kernelVersion.indexOf(" ");
                version = kernelVersion.substring(0, end);
                start = kernelVersion.indexOf(version);
                end = kernelVersion.indexOf("\r", start);
                version = kernelVersion.substring(start, end);
                if (IDT_Device.Scripts[idx].BypassWhenVersionStringMatch != null && IDT_Device.Scripts[idx].BypassWhenVersionStringMatch.length() > 0 && IDT_Device.Scripts[idx].BypassWhenVersionStringMatch.equals(version)) {
                    nextScript = this.getNextScript(Scripts, idx, 2);
                    appReboot = 0;
                    continue;
                }
                if (IDT_Device.Scripts[idx].BypassWhenVersionGreaterOrEqualTo != null && IDT_Device.Scripts[idx].BypassWhenVersionGreaterOrEqualTo.length() > 0 && IDT_Device.Scripts[idx].BypassWhenVersionGreaterOrEqualTo.compareTo(version) <= 0) {
                    nextScript = this.getNextScript(Scripts, idx, 3);
                    appReboot = 0;
                    continue;
                }
                if (IDT_Device.Scripts[idx].BypassWhenVersionLessOrEqualTo != null && IDT_Device.Scripts[idx].BypassWhenVersionLessOrEqualTo.length() > 0 && IDT_Device.Scripts[idx].BypassWhenVersionLessOrEqualTo.compareTo(version) >= 0) {
                    nextScript = this.getNextScript(Scripts, idx, 4);
                    appReboot = 0;
                    continue;
                }
                kernelDone = false;
                kernel = true;
                ret = this.device_updateFirmware(fw_data, ReaderInfo.FIRMWARE_UPDATE_TYPES.FU_KERNEL_CUP);
            } else if (IDT_Device.Scripts[idx].fname.toLowerCase().contains("_dpass")) {
                end = kernelVersion.indexOf(" ");
                version = kernelVersion.substring(0, end);
                start = kernelVersion.indexOf(version);
                end = kernelVersion.indexOf("\r", start);
                version = kernelVersion.substring(start, end);
                if (IDT_Device.Scripts[idx].BypassWhenVersionStringMatch != null && IDT_Device.Scripts[idx].BypassWhenVersionStringMatch.length() > 0 && IDT_Device.Scripts[idx].BypassWhenVersionStringMatch.equals(version)) {
                    nextScript = this.getNextScript(Scripts, idx, 2);
                    appReboot = 0;
                    continue;
                }
                if (IDT_Device.Scripts[idx].BypassWhenVersionGreaterOrEqualTo != null && IDT_Device.Scripts[idx].BypassWhenVersionGreaterOrEqualTo.length() > 0 && IDT_Device.Scripts[idx].BypassWhenVersionGreaterOrEqualTo.compareTo(version) <= 0) {
                    nextScript = this.getNextScript(Scripts, idx, 3);
                    appReboot = 0;
                    continue;
                }
                if (IDT_Device.Scripts[idx].BypassWhenVersionLessOrEqualTo != null && IDT_Device.Scripts[idx].BypassWhenVersionLessOrEqualTo.length() > 0 && IDT_Device.Scripts[idx].BypassWhenVersionLessOrEqualTo.compareTo(version) >= 0) {
                    nextScript = this.getNextScript(Scripts, idx, 4);
                    appReboot = 0;
                    continue;
                }
                kernelDone = false;
                kernel = true;
                ret = this.device_updateFirmware(fw_data, ReaderInfo.FIRMWARE_UPDATE_TYPES.FU_KERNEL_DPASS);
            } else if (IDT_Device.Scripts[idx].fname.toLowerCase().contains("_interac")) {
                end = kernelVersion.indexOf(" ");
                version = kernelVersion.substring(0, end);
                start = kernelVersion.indexOf(version);
                end = kernelVersion.indexOf("\r", start);
                version = kernelVersion.substring(start, end);
                if (IDT_Device.Scripts[idx].BypassWhenVersionStringMatch != null && IDT_Device.Scripts[idx].BypassWhenVersionStringMatch.length() > 0 && IDT_Device.Scripts[idx].BypassWhenVersionStringMatch.equals(version)) {
                    nextScript = this.getNextScript(Scripts, idx, 2);
                    appReboot = 0;
                    continue;
                }
                if (IDT_Device.Scripts[idx].BypassWhenVersionGreaterOrEqualTo != null && IDT_Device.Scripts[idx].BypassWhenVersionGreaterOrEqualTo.length() > 0 && IDT_Device.Scripts[idx].BypassWhenVersionGreaterOrEqualTo.compareTo(version) <= 0) {
                    nextScript = this.getNextScript(Scripts, idx, 3);
                    appReboot = 0;
                    continue;
                }
                if (IDT_Device.Scripts[idx].BypassWhenVersionLessOrEqualTo != null && IDT_Device.Scripts[idx].BypassWhenVersionLessOrEqualTo.length() > 0 && IDT_Device.Scripts[idx].BypassWhenVersionLessOrEqualTo.compareTo(version) >= 0) {
                    nextScript = this.getNextScript(Scripts, idx, 4);
                    appReboot = 0;
                    continue;
                }
                kernelDone = false;
                kernel = true;
                ret = this.device_updateFirmware(fw_data, ReaderInfo.FIRMWARE_UPDATE_TYPES.FU_KERNEL_INTERAC);
            } else if (IDT_Device.Scripts[idx].fname.toLowerCase().contains("_jcb")) {
                end = kernelVersion.indexOf(" ");
                version = kernelVersion.substring(0, end);
                start = kernelVersion.indexOf(version);
                end = kernelVersion.indexOf("\r", start);
                version = kernelVersion.substring(start, end);
                if (IDT_Device.Scripts[idx].BypassWhenVersionStringMatch != null && IDT_Device.Scripts[idx].BypassWhenVersionStringMatch.length() > 0 && IDT_Device.Scripts[idx].BypassWhenVersionStringMatch.equals(version)) {
                    nextScript = this.getNextScript(Scripts, idx, 2);
                    appReboot = 0;
                    continue;
                }
                if (IDT_Device.Scripts[idx].BypassWhenVersionGreaterOrEqualTo != null && IDT_Device.Scripts[idx].BypassWhenVersionGreaterOrEqualTo.length() > 0 && IDT_Device.Scripts[idx].BypassWhenVersionGreaterOrEqualTo.compareTo(version) <= 0) {
                    nextScript = this.getNextScript(Scripts, idx, 3);
                    appReboot = 0;
                    continue;
                }
                if (IDT_Device.Scripts[idx].BypassWhenVersionLessOrEqualTo != null && IDT_Device.Scripts[idx].BypassWhenVersionLessOrEqualTo.length() > 0 && IDT_Device.Scripts[idx].BypassWhenVersionLessOrEqualTo.compareTo(version) >= 0) {
                    nextScript = this.getNextScript(Scripts, idx, 4);
                    appReboot = 0;
                    continue;
                }
                kernelDone = false;
                kernel = true;
                ret = this.device_updateFirmware(fw_data, ReaderInfo.FIRMWARE_UPDATE_TYPES.FU_KERNEL_JCP);
            } else if (IDT_Device.Scripts[idx].fname.toLowerCase().contains("_mchip")) {
                end = kernelVersion.indexOf(" ");
                version = kernelVersion.substring(0, end);
                start = kernelVersion.indexOf(version);
                end = kernelVersion.indexOf("\r", start);
                version = kernelVersion.substring(start, end);
                if (IDT_Device.Scripts[idx].BypassWhenVersionStringMatch != null && IDT_Device.Scripts[idx].BypassWhenVersionStringMatch.length() > 0 && IDT_Device.Scripts[idx].BypassWhenVersionStringMatch.equals(version)) {
                    nextScript = this.getNextScript(Scripts, idx, 2);
                    appReboot = 0;
                    continue;
                }
                if (IDT_Device.Scripts[idx].BypassWhenVersionGreaterOrEqualTo != null && IDT_Device.Scripts[idx].BypassWhenVersionGreaterOrEqualTo.length() > 0 && IDT_Device.Scripts[idx].BypassWhenVersionGreaterOrEqualTo.compareTo(version) <= 0) {
                    nextScript = this.getNextScript(Scripts, idx, 3);
                    appReboot = 0;
                    continue;
                }
                if (IDT_Device.Scripts[idx].BypassWhenVersionLessOrEqualTo != null && IDT_Device.Scripts[idx].BypassWhenVersionLessOrEqualTo.length() > 0 && IDT_Device.Scripts[idx].BypassWhenVersionLessOrEqualTo.compareTo(version) >= 0) {
                    nextScript = this.getNextScript(Scripts, idx, 4);
                    appReboot = 0;
                    continue;
                }
                kernelDone = false;
                kernel = true;
                ret = this.device_updateFirmware(fw_data, ReaderInfo.FIRMWARE_UPDATE_TYPES.FU_KERNEL_MCHIP);
            } else if (IDT_Device.Scripts[idx].fname.toLowerCase().contains("_ppse")) {
                end = kernelVersion.indexOf(" ");
                version = kernelVersion.substring(0, end);
                start = kernelVersion.indexOf(version);
                end = kernelVersion.indexOf("\r", start);
                version = kernelVersion.substring(start, end);
                if (IDT_Device.Scripts[idx].BypassWhenVersionStringMatch != null && IDT_Device.Scripts[idx].BypassWhenVersionStringMatch.length() > 0 && IDT_Device.Scripts[idx].BypassWhenVersionStringMatch.equals(version)) {
                    nextScript = this.getNextScript(Scripts, idx, 2);
                    appReboot = 0;
                    continue;
                }
                if (IDT_Device.Scripts[idx].BypassWhenVersionGreaterOrEqualTo != null && IDT_Device.Scripts[idx].BypassWhenVersionGreaterOrEqualTo.length() > 0 && IDT_Device.Scripts[idx].BypassWhenVersionGreaterOrEqualTo.compareTo(version) <= 0) {
                    nextScript = this.getNextScript(Scripts, idx, 3);
                    appReboot = 0;
                    continue;
                }
                if (IDT_Device.Scripts[idx].BypassWhenVersionLessOrEqualTo != null && IDT_Device.Scripts[idx].BypassWhenVersionLessOrEqualTo.length() > 0 && IDT_Device.Scripts[idx].BypassWhenVersionLessOrEqualTo.compareTo(version) >= 0) {
                    nextScript = this.getNextScript(Scripts, idx, 4);
                    appReboot = 0;
                    continue;
                }
                kernelDone = false;
                kernel = true;
                ret = this.device_updateFirmware(fw_data, ReaderInfo.FIRMWARE_UPDATE_TYPES.FU_KERNEL_PPSE);
            } else if (IDT_Device.Scripts[idx].fname.toLowerCase().contains("_smarttap")) {
                end = kernelVersion.indexOf(" ");
                version = kernelVersion.substring(0, end);
                start = kernelVersion.indexOf(version);
                end = kernelVersion.indexOf("\r", start);
                version = kernelVersion.substring(start, end);
                if (IDT_Device.Scripts[idx].BypassWhenVersionStringMatch != null && IDT_Device.Scripts[idx].BypassWhenVersionStringMatch.length() > 0 && IDT_Device.Scripts[idx].BypassWhenVersionStringMatch.equals(version)) {
                    nextScript = this.getNextScript(Scripts, idx, 2);
                    appReboot = 0;
                    continue;
                }
                if (IDT_Device.Scripts[idx].BypassWhenVersionGreaterOrEqualTo != null && IDT_Device.Scripts[idx].BypassWhenVersionGreaterOrEqualTo.length() > 0 && IDT_Device.Scripts[idx].BypassWhenVersionGreaterOrEqualTo.compareTo(version) <= 0) {
                    nextScript = this.getNextScript(Scripts, idx, 3);
                    appReboot = 0;
                    continue;
                }
                if (IDT_Device.Scripts[idx].BypassWhenVersionLessOrEqualTo != null && IDT_Device.Scripts[idx].BypassWhenVersionLessOrEqualTo.length() > 0 && IDT_Device.Scripts[idx].BypassWhenVersionLessOrEqualTo.compareTo(version) >= 0) {
                    nextScript = this.getNextScript(Scripts, idx, 4);
                    appReboot = 0;
                    continue;
                }
                kernelDone = false;
                kernel = true;
                ret = this.device_updateFirmware(fw_data, ReaderInfo.FIRMWARE_UPDATE_TYPES.FU_KERNEL_SMARTTAP);
            } else if (IDT_Device.Scripts[idx].fname.toLowerCase().contains("_vcps")) {
                end = kernelVersion.indexOf(" ");
                version = kernelVersion.substring(0, end);
                start = kernelVersion.indexOf(version);
                end = kernelVersion.indexOf("\r", start);
                version = kernelVersion.substring(start, end);
                if (IDT_Device.Scripts[idx].BypassWhenVersionStringMatch != null && IDT_Device.Scripts[idx].BypassWhenVersionStringMatch.length() > 0 && IDT_Device.Scripts[idx].BypassWhenVersionStringMatch.equals(version)) {
                    nextScript = this.getNextScript(Scripts, idx, 2);
                    appReboot = 0;
                    continue;
                }
                if (IDT_Device.Scripts[idx].BypassWhenVersionGreaterOrEqualTo != null && IDT_Device.Scripts[idx].BypassWhenVersionGreaterOrEqualTo.length() > 0 && IDT_Device.Scripts[idx].BypassWhenVersionGreaterOrEqualTo.compareTo(version) <= 0) {
                    nextScript = this.getNextScript(Scripts, idx, 3);
                    appReboot = 0;
                    continue;
                }
                if (IDT_Device.Scripts[idx].BypassWhenVersionLessOrEqualTo != null && IDT_Device.Scripts[idx].BypassWhenVersionLessOrEqualTo.length() > 0 && IDT_Device.Scripts[idx].BypassWhenVersionLessOrEqualTo.compareTo(version) >= 0) {
                    nextScript = this.getNextScript(Scripts, idx, 4);
                    appReboot = 0;
                    continue;
                }
                kernelDone = false;
                kernel = true;
                ret = this.device_updateFirmware(fw_data, ReaderInfo.FIRMWARE_UPDATE_TYPES.FU_KERNEL_VCPS);
            } else if (IDT_Device.Scripts[idx].fname.contains("1050") || IDT_Device.Scripts[idx].fname.toLowerCase().contains("ext_fw") || IDT_Device.Scripts[idx].fname.toLowerCase().contains("ext_dt")) {
                if (IDT_Device.Scripts[idx].BypassWhenVersionStringMatch != null && IDT_Device.Scripts[idx].BypassWhenVersionStringMatch.length() > 0 && IDT_Device.Scripts[idx].BypassWhenVersionStringMatch.equals(RT1050Version)) {
                    nextScript = this.getNextScript(Scripts, idx, 2);
                    appReboot = 0;
                    continue;
                }
                if (IDT_Device.Scripts[idx].BypassWhenVersionGreaterOrEqualTo != null && IDT_Device.Scripts[idx].BypassWhenVersionGreaterOrEqualTo.length() > 0 && IDT_Device.Scripts[idx].BypassWhenVersionGreaterOrEqualTo.compareTo(RT1050Version) <= 0) {
                    nextScript = this.getNextScript(Scripts, idx, 3);
                    appReboot = 0;
                    continue;
                }
                if (IDT_Device.Scripts[idx].BypassWhenVersionLessOrEqualTo != null && IDT_Device.Scripts[idx].BypassWhenVersionLessOrEqualTo.length() > 0 && IDT_Device.Scripts[idx].BypassWhenVersionLessOrEqualTo.compareTo(RT1050Version) >= 0) {
                    nextScript = this.getNextScript(Scripts, idx, 4);
                    appReboot = 0;
                    continue;
                }
                ReaderInfo.FIRMWARE_UPDATE_TYPES fut = IDT_Device.Scripts[idx].fname.toLowerCase().contains("ext_dt") ? ReaderInfo.FIRMWARE_UPDATE_TYPES.FU_KERNEL_DT_PRJ_RT1050 : ReaderInfo.FIRMWARE_UPDATE_TYPES.FU_RT1050;
                kernel = false;
                isRT1050 = true;
                ret = this.device_updateFirmware(fw_data, fut);
            } else if (IDT_Device.Scripts[idx].fname.toLowerCase().contains("_dt_sec_")) {
                end = kernelVersion.indexOf(" ");
                version = kernelVersion.substring(0, end);
                start = kernelVersion.indexOf(version);
                end = kernelVersion.indexOf("\r", start);
                version = kernelVersion.substring(start, end);
                if (IDT_Device.Scripts[idx].BypassWhenVersionStringMatch != null && IDT_Device.Scripts[idx].BypassWhenVersionStringMatch.length() > 0 && IDT_Device.Scripts[idx].BypassWhenVersionStringMatch.equals(version)) {
                    nextScript = this.getNextScript(Scripts, idx, 2);
                    appReboot = 0;
                    continue;
                }
                if (IDT_Device.Scripts[idx].BypassWhenVersionGreaterOrEqualTo != null && IDT_Device.Scripts[idx].BypassWhenVersionGreaterOrEqualTo.length() > 0 && IDT_Device.Scripts[idx].BypassWhenVersionGreaterOrEqualTo.compareTo(version) <= 0) {
                    nextScript = this.getNextScript(Scripts, idx, 3);
                    appReboot = 0;
                    continue;
                }
                if (IDT_Device.Scripts[idx].BypassWhenVersionLessOrEqualTo != null && IDT_Device.Scripts[idx].BypassWhenVersionLessOrEqualTo.length() > 0 && IDT_Device.Scripts[idx].BypassWhenVersionLessOrEqualTo.compareTo(version) >= 0) {
                    nextScript = this.getNextScript(Scripts, idx, 4);
                    appReboot = 0;
                    continue;
                }
                kernelDone = false;
                kernel = true;
                ret = this.device_updateFirmware(fw_data, ReaderInfo.FIRMWARE_UPDATE_TYPES.FU_KERNEL_DT_SEC);
            } else if (IDT_Device.Scripts[idx].fname.toLowerCase().contains("_dt_prj_")) {
                end = kernelVersion.indexOf(" ");
                version = kernelVersion.substring(0, end);
                start = kernelVersion.indexOf(version);
                end = kernelVersion.indexOf("\r", start);
                version = kernelVersion.substring(start, end);
                if (IDT_Device.Scripts[idx].BypassWhenVersionStringMatch != null && IDT_Device.Scripts[idx].BypassWhenVersionStringMatch.length() > 0 && IDT_Device.Scripts[idx].BypassWhenVersionStringMatch.equals(version)) {
                    nextScript = this.getNextScript(Scripts, idx, 2);
                    appReboot = 0;
                    continue;
                }
                if (IDT_Device.Scripts[idx].BypassWhenVersionGreaterOrEqualTo != null && IDT_Device.Scripts[idx].BypassWhenVersionGreaterOrEqualTo.length() > 0 && IDT_Device.Scripts[idx].BypassWhenVersionGreaterOrEqualTo.compareTo(version) <= 0) {
                    nextScript = this.getNextScript(Scripts, idx, 3);
                    appReboot = 0;
                    continue;
                }
                if (IDT_Device.Scripts[idx].BypassWhenVersionLessOrEqualTo != null && IDT_Device.Scripts[idx].BypassWhenVersionLessOrEqualTo.length() > 0 && IDT_Device.Scripts[idx].BypassWhenVersionLessOrEqualTo.compareTo(version) >= 0) {
                    nextScript = this.getNextScript(Scripts, idx, 4);
                    appReboot = 0;
                    continue;
                }
                ReaderInfo.FIRMWARE_UPDATE_TYPES fut = IDT_Device.Scripts[idx].fname.toLowerCase().contains("_ext_") ? ReaderInfo.FIRMWARE_UPDATE_TYPES.FU_KERNEL_DT_PRJ_RT1050 : ReaderInfo.FIRMWARE_UPDATE_TYPES.FU_KERNEL_DT_PRJ;
                kernelDone = false;
                kernel = true;
                ret = this.device_updateFirmware(fw_data, fut);
            } else if (IDT_Device.Scripts[idx].fname.toLowerCase().contains("bootloader")) {
                if (IDT_Device.Scripts[idx].BypassWhenVersionStringMatch != null && IDT_Device.Scripts[idx].BypassWhenVersionStringMatch.length() > 0 && IDT_Device.Scripts[idx].BypassWhenVersionStringMatch.equals(bootloaderVersion)) {
                    nextScript = this.getNextScript(Scripts, idx, 2);
                    appReboot = 0;
                    continue;
                }
                if (IDT_Device.Scripts[idx].BypassWhenVersionGreaterOrEqualTo != null && IDT_Device.Scripts[idx].BypassWhenVersionGreaterOrEqualTo.length() > 0 && IDT_Device.Scripts[idx].BypassWhenVersionGreaterOrEqualTo.compareTo(bootloaderVersion) <= 0) {
                    nextScript = this.getNextScript(Scripts, idx, 3);
                    appReboot = 0;
                    continue;
                }
                if (IDT_Device.Scripts[idx].BypassWhenVersionLessOrEqualTo != null && IDT_Device.Scripts[idx].BypassWhenVersionLessOrEqualTo.length() > 0 && IDT_Device.Scripts[idx].BypassWhenVersionLessOrEqualTo.compareTo(bootloaderVersion) >= 0) {
                    nextScript = this.getNextScript(Scripts, idx, 4);
                    appReboot = 0;
                    continue;
                }
                kernel = false;
                UMLog.i("**device_updateFirmwareWithZipFile bootloader**", "nextScript=" + nextScript);
                if (appReboot < 2) {
                    UMLog.i("**device_updateFirmwareWithZipFile**", "call device_updateFirmware");
                    ret = this.device_updateFirmware(fw_data, ReaderInfo.FIRMWARE_UPDATE_TYPES.FU_APPLICATION);
                }
            } else {
                if (IDT_Device.Scripts[idx].BypassWhenVersionStringMatch != null && IDT_Device.Scripts[idx].BypassWhenVersionStringMatch.length() > 0 && IDT_Device.Scripts[idx].BypassWhenVersionStringMatch.equals(firmwareVersion)) {
                    nextScript = this.getNextScript(Scripts, idx, 2);
                    appReboot = 0;
                    continue;
                }
                if (IDT_Device.Scripts[idx].BypassWhenVersionGreaterOrEqualTo != null && IDT_Device.Scripts[idx].BypassWhenVersionGreaterOrEqualTo.length() > 0 && IDT_Device.Scripts[idx].BypassWhenVersionGreaterOrEqualTo.compareTo(firmwareVersion) <= 0) {
                    nextScript = this.getNextScript(Scripts, idx, 3);
                    appReboot = 0;
                    continue;
                }
                if (IDT_Device.Scripts[idx].BypassWhenVersionLessOrEqualTo != null && IDT_Device.Scripts[idx].BypassWhenVersionLessOrEqualTo.length() > 0 && IDT_Device.Scripts[idx].BypassWhenVersionLessOrEqualTo.compareTo(firmwareVersion) >= 0) {
                    nextScript = this.getNextScript(Scripts, idx, 4);
                    appReboot = 0;
                    continue;
                }
                kernel = false;
                if (appReboot < 2) {
                    ret = this.device_updateFirmware(fw_data, ReaderInfo.FIRMWARE_UPDATE_TYPES.FU_APPLICATION);
                }
            }
            UMLog.i("**device_updateFirmwareWithZipFile**", "ret=" + ret + " kernel=" + kernel);
            if (ret == 0) {
                if (!kernel && !isRT1050) {
                    UMLog.i("**device_updateFirmwareWithZipFile**", "Application appReboot=" + ++appReboot);
                    if (appReboot < 2) {
                        return false;
                    }
                }
                nextScript = this.getNextScript(Scripts, idx, 0);
                UMLog.i("**device_updateFirmwareWithZipFile got next script**", "nextScript=" + nextScript + " appReboot=" + appReboot);
                if (appReboot < 2 && !kernel && !isRT1050) continue;
                isRT1050 = false;
                return false;
            }
            nextScript = this.getNextScript(Scripts, idx, 1);
            appReboot = 0;
        }
        for (idx = 0; idx < 20; ++idx) {
            IDT_Device.Scripts[idx] = null;
        }
        nextScript = null;
        fw_commands = null;
        fw_data = null;
        appReboot = 0;
        origPID = 0;
        init = false;
        return true;
    }

    String getNextScript(MetadataScript[] Scripts, int idx, int errorCode) {
        int i = 0;
        while (Scripts[idx].ResultScripts[i].Result != -1) {
            if (Scripts[idx].ResultScripts[i].Result == errorCode) {
                if (Scripts[idx].ResultScripts[i].NextScript != null && Scripts[idx].ResultScripts[i].NextScript.length() > 0) {
                    return Scripts[idx].ResultScripts[i].NextScript;
                }
                return null;
            }
            ++i;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFirmwareFilenamesFromJson(String strFilePathName, MetadataScript[] scripts) {
        if (scripts == null) {
            return null;
        }
        File file = new File(strFilePathName);
        if (!file.exists()) {
            return null;
        }
        this.foundPID = false;
        String startScript = null;
        int count = -1;
        int resultIdx = 0;
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(file));
            String line = "";
            while ((line = br.readLine()) != null) {
                int end;
                int start;
                if (line.contains("PID")) {
                    int i = 0;
                    while ((line = br.readLine()) != null && !line.contains("]")) {
                        String pid = null;
                        start = line.indexOf("\"");
                        end = line.indexOf("\"", ++start);
                        pid = line.substring(start, end);
                        this.ScriptPID[i] = Integer.parseInt(pid, 16);
                        ++i;
                    }
                    for (int p = 0; p < i; ++p) {
                        if (this.ScriptPID[p] != origPID) continue;
                        this.foundPID = true;
                    }
                    continue;
                }
                if (!line.contains("StartScript")) continue;
                start = line.indexOf("\": \"");
                end = line.indexOf("\",");
                String scriptName = line.substring(start += 4, end);
                startScript = new String(scriptName);
                while ((line = br.readLine()) != null) {
                    if (line.contains("Name")) {
                        resultIdx = 0;
                        start = line.indexOf("\": \"");
                        end = line.indexOf("\",");
                        scriptName = line.substring(start += 4, end);
                        if (scripts.length <= ++count) {
                            String string = null;
                            return string;
                        }
                        scripts[count].Name = new String(scriptName);
                        continue;
                    }
                    if (line.contains("fname")) {
                        start = line.indexOf("\": \"");
                        end = line.indexOf("\",");
                        scriptName = line.substring(start += 4, end);
                        scripts[count].fname = new String(scriptName);
                        continue;
                    }
                    if (line.contains("BypassWhenVersionStringMatch")) {
                        start = line.indexOf("\": \"");
                        end = line.indexOf("\",");
                        if ((start += 4) >= end) {
                            scripts[count].BypassWhenVersionStringMatch = null;
                            continue;
                        }
                        scriptName = line.substring(start, end);
                        scripts[count].BypassWhenVersionStringMatch = new String(scriptName);
                        continue;
                    }
                    if (line.contains("BypassWhenVersionGreaterOrEqualTo")) {
                        start = line.indexOf("\": \"");
                        end = line.indexOf("\",");
                        if ((start += 4) >= end) {
                            scripts[count].BypassWhenVersionGreaterOrEqualTo = null;
                            continue;
                        }
                        scriptName = line.substring(start, end);
                        scripts[count].BypassWhenVersionGreaterOrEqualTo = new String(scriptName);
                        continue;
                    }
                    if (line.contains("BypassWhenVersionLessOrEqualTo")) {
                        start = line.indexOf("\": \"");
                        end = line.indexOf("\",");
                        if ((start += 4) >= end) {
                            scripts[count].BypassWhenVersionLessOrEqualTo = null;
                            continue;
                        }
                        scriptName = line.substring(start, end);
                        scripts[count].BypassWhenVersionLessOrEqualTo = new String(scriptName);
                        continue;
                    }
                    if (!line.contains("\"Result\"")) continue;
                    start = line.indexOf("\": ");
                    end = line.indexOf(",");
                    scriptName = line.substring(start += 3, end);
                    scripts[count].ResultScripts[resultIdx].Result = Integer.parseInt(scriptName);
                    line = br.readLine();
                    if (line != null && line.contains("NextScript")) {
                        start = line.indexOf("\": \"");
                        if ((start += 4) >= (end = line.indexOf("\"", start))) {
                            scripts[count].ResultScripts[resultIdx].NextScript = null;
                        } else {
                            scriptName = line.substring(start, end);
                            scripts[count].ResultScripts[resultIdx].NextScript = new String(scriptName);
                        }
                    }
                    ++resultIdx;
                }
                break;
            }
            br.close();
        }
        catch (IOException e) {
            String string = null;
            return string;
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (Exception ex) {
                return null;
            }
        }
        return startScript;
    }

    private byte[] getStringArrayFromFirmwareBinaryFile(String strFilePathName) {
        File file = new File(strFilePathName);
        byte[] fileData = new byte[(int)file.length()];
        DataInputStream dis = null;
        try {
            dis = new DataInputStream(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        try {
            dis.readFully(fileData);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        try {
            dis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return fileData;
    }

    public int device_controlBeep(int index, int frequency, int duration) {
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA) {
            return 20;
        }
        if (!_isTTK) {
            return 20;
        }
        if (frequency < 1000 || frequency > 20000) {
            return 27392;
        }
        if (duration < 1 || duration > 65525) {
            return 27392;
        }
        isCommandRunning = true;
        this.waitForNotification();
        byte _index = (byte)(index & 0xFF);
        byte[] freq = new byte[2];
        byte[] dur = new byte[2];
        freq[1] = (byte)(frequency % 256);
        freq[0] = (byte)(frequency / 256);
        dur[1] = (byte)(duration % 256);
        dur[0] = (byte)(duration / 256);
        String strFreq = Common.getHexStringFromBytes(freq);
        String strDur = Common.getHexStringFromBytes(dur);
        strFreq = strFreq + strDur;
        ResDataStruct respData = new ResDataStruct();
        TaskManager.TaskStartRet r = this.sendCommand_helper("784604" + String.format(Locale.US, "%02X", _index) + strFreq, 60, respData);
        isCommandRunning = false;
        return this.returnACK(r, respData);
    }

    public int device_controlLED(byte indexLED, byte control, int intervalOn, int intervalOff) {
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA) {
            return 20;
        }
        isCommandRunning = true;
        this.waitForNotification();
        ResDataStruct respData = new ResDataStruct();
        String val = String.format(Locale.US, "%04X", intervalOn) + String.format(Locale.US, "%04X", intervalOff);
        TaskManager.TaskStartRet r = (control & 2) == 2 ? this.sendCommand_helper("784606" + String.format(Locale.US, "%02X", indexLED) + String.format(Locale.US, "%02X", control) + val, 0, respData) : this.sendCommand_helper("784606" + String.format(Locale.US, "%02X", indexLED) + String.format(Locale.US, "%02X", control), 0, respData);
        isCommandRunning = false;
        return this.returnACK(r, respData);
    }

    public int device_controlLED_ICC(int controlMode, int interval) {
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA) {
            return 20;
        }
        isCommandRunning = true;
        this.waitForNotification();
        ResDataStruct respData = new ResDataStruct();
        TaskManager.TaskStartRet r = this.sendCommand_helper("724620" + String.format(Locale.US, "%02X", controlMode) + String.format(Locale.US, "%04X", interval), 0, respData);
        isCommandRunning = false;
        return this.returnACK(r, respData);
    }

    public int device_getTransactionResults(IDTMSRData cardData) {
        int returnCode;
        int len2;
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (cardData == null) {
            return 27392;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VENDI && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
            return 20;
        }
        isCommandRunning = true;
        this.waitForNotification();
        if (isAutoPollOn) {
            try {
                Thread.sleep(150L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        ResDataStruct respData = new ResDataStruct();
        int loopNum = 0;
        int rt = 9;
        int cmd = 3;
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)3, (byte)64, new byte[0])), 10, respData);
            ++loopNum;
            if (r == TaskManager.TaskStartRet.SUCCESS) {
                if (respData.resData == null) {
                    isCommandRunning = false;
                    return 21;
                }
                if (respData.resData.length == 1 && respData.resData[0] == 0) {
                    isCommandRunning = false;
                    return 3;
                }
                rt = 9;
                len2 = respData.resData.length;
                if (len2 > 13) {
                    rt = respData.resData[11];
                    cmd = respData.resData[10];
                    if (cmd == -18 && rt == -16) break;
                }
            }
            if (loopNum >= maxLoopNum || (rt == 0 || rt == 35) && cmd == 3) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException len2) {
                // empty catch block
            }
        } while (loopNum < maxLoopNum && (rt != 0 && rt != 35 || cmd != 3));
        if (r == TaskManager.TaskStartRet.SUCCESS && rt == 11) {
            loopNum = 0;
            do {
                r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)3, (byte)0, new byte[0])), 0, respData);
                ++loopNum;
                if (r == TaskManager.TaskStartRet.SUCCESS) {
                    if (respData.resData == null) {
                        isCommandRunning = false;
                        return 21;
                    }
                    if (respData.resData.length == 1 && respData.resData[0] == 0) {
                        isCommandRunning = false;
                        return 3;
                    }
                    rt = 9;
                    len2 = respData.resData.length;
                    if (len2 > 13) {
                        rt = respData.resData[11];
                        cmd = respData.resData[10];
                    }
                }
                if (loopNum >= maxLoopNum || rt == 0 && cmd == 3) continue;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException len3) {
                    // empty catch block
                }
            } while (loopNum < maxLoopNum && (rt != 0 || cmd != 3));
        }
        if ((returnCode = this.returnACK(r, respData)) == 60963 || returnCode == 60976 || returnCode == 60977) {
            returnCode = 0;
        }
        respData.statusCode = returnCode;
        Common.parseCardData3in1(respData.resData, cardData);
        cardData.result = returnCode;
        isCommandRunning = false;
        return returnCode;
    }

    public int device_selfCheck() {
        TaskManager.TaskStartRet r;
        ResDataStruct respData;
        block12: {
            block13: {
                if (!readyForNextCommand || !readyForCardSwipe) {
                    return 29696;
                }
                if (!this.device_isConnected()) {
                    return 1;
                }
                if (!_isTTK) {
                    return 20;
                }
                isCommandRunning = true;
                this.waitForNotification();
                respData = new ResDataStruct();
                int cmd = 0;
                int rt = 9;
                if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB) break block13;
                this.waitForVivo();
                int loopNum = 0;
                do {
                    r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-57, (byte)59, new byte[0])), 0, respData);
                    ++loopNum;
                    if (r == TaskManager.TaskStartRet.SUCCESS) {
                        if (respData.resData == null) {
                            isCommandRunning = false;
                            return 21;
                        }
                        if (respData.resData.length == 1 && respData.resData[0] == 0) {
                            isCommandRunning = false;
                            return 3;
                        }
                        rt = 9;
                        int len = respData.resData.length;
                        if (len > 11) {
                            rt = respData.resData[11];
                            cmd = respData.resData[10];
                            if (cmd == -18 && rt == -16) break block12;
                            if (rt != 0) {
                                rt = 9;
                            }
                        }
                    }
                    if (loopNum >= maxLoopNum || rt == 0 && cmd == -57) continue;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while (loopNum < maxLoopNum && (rt != 0 || cmd != -57));
                break block12;
                {
                }
            }
            r = this.sendCommand_helper("7846500100", 0, respData);
        }
        isCommandRunning = false;
        return this.returnACK(r, respData);
    }

    void waitForVivo() {
    }

    int pingVivoTech() {
        int ec = 1;
        if (!this.device_isConnected()) {
            return ec;
        }
        ResDataStruct respData = new ResDataStruct();
        pingRequest = true;
        TaskManager.TaskStartRet r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)24, (byte)1, new byte[0])), 0, respData);
        pingRequest = false;
        if (respData.resData != null && respData.resData.length > 1) {
            _vivoAlive = true;
        }
        return this.returnResult(r);
    }

    public int device_pingDevice() {
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VENDI && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        isCommandRunning = true;
        this.waitForNotification();
        ResDataStruct respData = new ResDataStruct();
        byte cmd = 0;
        int rt = 9;
        int loopNum = 0;
        do {
            int len;
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)24, (byte)1, new byte[0])), 1, respData);
            ++loopNum;
            int n = len = respData.resData == null ? 0 : respData.resData.length;
            if (len > 11) {
                cmd = respData.resData[10];
                rt = respData.resData[11];
                if (cmd == -18 && rt == -16) break;
            }
            if (loopNum >= maxLoopNum || rt == 0 && cmd == 24) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != 24));
        isCommandRunning = false;
        return this.returnACK(r, respData);
    }

    public int device_setBurstMode(byte mode) {
        int ret;
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VENDI && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        isCommandRunning = true;
        this.waitForNotification();
        ResDataStruct respData = new ResDataStruct();
        byte cmd = 0;
        int rt = 9;
        int loopNum = 0;
        do {
            int len;
            r = connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB ? this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)4, (byte)0, new byte[]{-33, -18, 126, 1, mode})), 0, respData) : this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)4, (byte)0, new byte[]{-1, -9, 1, mode})), 0, respData);
            ++loopNum;
            int n = len = respData.resData == null ? 0 : respData.resData.length;
            if (len > 11) {
                cmd = respData.resData[10];
                rt = respData.resData[11];
                if (cmd == -18 && rt == -16) break;
            }
            if (loopNum >= maxLoopNum || rt == 0 && cmd == 4) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != 4));
        if ((ret = this.returnACK(r, respData)) == 0 && ((isBurstModeOn = mode != 0) || !isAutoPollOn)) {
            cardSeated = false;
        }
        isCommandRunning = false;
        return ret;
    }

    public int device_setPollMode(byte mode) {
        int ret;
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VENDI && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        isCommandRunning = true;
        this.waitForNotification();
        ResDataStruct respData = new ResDataStruct();
        byte cmd = 0;
        int rt = 9;
        int loopNum = 0;
        do {
            int len;
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)1, (byte)1, new byte[]{mode})), 0, respData);
            ++loopNum;
            int n = len = respData.resData == null ? 0 : respData.resData.length;
            if (len > 11) {
                cmd = respData.resData[10];
                rt = respData.resData[11];
                if (cmd == -18 && rt == -16) break;
            }
            if (loopNum >= maxLoopNum || rt == 0 && cmd == 1) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != 1));
        if ((ret = this.returnACK(r, respData)) == 0) {
            isAutoPollOn = mode == 0;
            if (isBurstModeOn || !isAutoPollOn) {
                cardSeated = false;
            }
        }
        isCommandRunning = false;
        return ret;
    }

    public int device_setBluetoothParameters(String name, byte[] oldPassword, byte[] newPassword) {
        TaskManager.TaskStartRet r;
        byte[] data;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (name == null && (oldPassword != null || newPassword != null) || oldPassword == null && (name != null || newPassword != null) || newPassword == null && (oldPassword != null || name != null)) {
            return 27392;
        }
        if (name != null && (name.length() == 0 || name.length() > 25) || oldPassword != null && oldPassword.length != 6 || newPassword != null && newPassword.length != 6) {
            return 27392;
        }
        isCommandRunning = true;
        this.waitForNotification();
        ResDataStruct respData = new ResDataStruct();
        byte cmd = 0;
        int rt = 9;
        int loopNum = 0;
        if (name == null) {
            data = new byte[]{};
        } else {
            data = new byte[name.length() + 13];
            char[] chars = name.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                data[i] = (byte)chars[i];
            }
            data[chars.length] = 0;
            System.arraycopy(oldPassword, 0, data, chars.length + 1, 6);
            System.arraycopy(newPassword, 0, data, chars.length + 7, 6);
        }
        do {
            int len;
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)119, (byte)-127, data)), 0, respData);
            ++loopNum;
            int n = len = respData.resData == null ? 0 : respData.resData.length;
            if (len > 11) {
                cmd = respData.resData[10];
                rt = respData.resData[11];
                if (cmd == -18 && rt == -16) break;
            }
            if (loopNum >= maxLoopNum || rt == 0 && cmd == 119) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != 119));
        int ret = this.returnACK(r, respData);
        isCommandRunning = false;
        return ret;
    }

    public int device_setSource(byte[] data) {
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (data == null || data.length != 2) {
            return 27392;
        }
        isCommandRunning = true;
        this.waitForNotification();
        ResDataStruct respData = new ResDataStruct();
        byte cmd = 0;
        int rt = 9;
        int loopNum = 0;
        do {
            int len;
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)1, (byte)5, data)), 0, respData);
            ++loopNum;
            int n = len = respData.resData == null ? 0 : respData.resData.length;
            if (len > 11) {
                cmd = respData.resData[10];
                rt = respData.resData[11];
                if (cmd == -18 && rt == -16) break;
            }
            if (loopNum >= maxLoopNum || rt == 0 && cmd == 1) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != 1));
        int ret = this.returnACK(r, respData);
        isCommandRunning = false;
        return ret;
    }

    public int device_getSource(byte[] data) {
        int ret;
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (data == null || data.length != 2) {
            return 27392;
        }
        isCommandRunning = true;
        this.waitForNotification();
        ResDataStruct respData = new ResDataStruct();
        byte cmd = 0;
        int rt = 9;
        int loopNum = 0;
        do {
            int len;
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)1, (byte)5, new byte[0])), 0, respData);
            ++loopNum;
            int n = len = respData.resData == null ? 0 : respData.resData.length;
            if (len > 11) {
                cmd = respData.resData[10];
                rt = respData.resData[11];
                if (cmd == -18 && rt == -16) break;
            }
            if (loopNum >= maxLoopNum || rt == 0 && cmd == 1) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != 1));
        if ((ret = this.returnACK(r, respData)) == 0 && respData.resData != null && respData.resData.length > 15) {
            System.arraycopy(respData.resData, 14, data, 0, 2);
        }
        isCommandRunning = false;
        return ret;
    }

    public int device_controlUserInterface(byte[] values) {
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VENDI && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (values == null || values.length != 4) {
            return 27392;
        }
        isCommandRunning = true;
        this.waitForNotification();
        byte cmd = 0;
        int rt = 9;
        ResDataStruct respData = new ResDataStruct();
        int loopNum = 0;
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)1, (byte)2, values)), 0, respData);
            ++loopNum;
            if (r != TaskManager.TaskStartRet.SUCCESS) continue;
            if (respData.resData == null) {
                isCommandRunning = false;
                return 21;
            }
            if (respData.resData.length == 1 && respData.resData[0] == 0) {
                isCommandRunning = false;
                return 3;
            }
            rt = 9;
            int len = respData.resData.length;
            if (len <= 11) continue;
            rt = respData.resData[11];
            cmd = respData.resData[10];
            if (cmd == -18 && rt == -16) break;
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != true));
        isCommandRunning = false;
        return this.returnACK(r, respData);
    }

    public int device_startTransaction(double amount, double amtOther, int type, int timeout, byte[] tags) {
        return this.device_startTransaction(amount, amtOther, type, timeout, tags, false);
    }

    public int device_startTransaction(double amount, double amtOther, int type, int timeout, byte[] tags, boolean isFastEMV) {
        StringBuilder sb;
        int ret;
        this.neo2Transaction = false;
        if ((connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ) && (ret = this.device_getFirmwareVersion(sb = new StringBuilder())) == 0 && sb.toString().contains("v1.10")) {
            this.neo2Transaction = true;
            UMLog.i("device_startTransaction", "neo2Transaction 1: " + this.neo2Transaction);
        }
        if (!this.neo2Transaction && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VENDI && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB) {
            ICCReaderStatusStruct iccStatus = new ICCReaderStatusStruct();
            ret = this.icc_getICCReaderStatus(iccStatus);
            if (ret != 0) {
                iccStatus.cardSeated = false;
            }
            if (iccStatus.cardSeated || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II) {
                this.deviceTransactionType = 2;
                return this.emv_startTransaction(amount, amtOther, type, timeout, tags, false, isFastEMV);
            }
        }
        emv_amount = amount;
        emv_amtOther = amtOther;
        emv_type = type;
        emv_timeout = timeout;
        emv_tags = tags;
        this.fromOtherTransaction = 1;
        this.deviceTransactionType = 1;
        return this.ctls_startTransaction(amount, amtOther, type, timeout, tags, isFastEMV);
    }

    public int device_cancelTransaction() {
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II) {
            ResDataStruct resData = new ResDataStruct();
            return this.emv_cancelTransaction(resData);
        }
        if (this.deviceTransactionType == 0) {
            UMLog.i("**device_cancelTransaction**", "msr_cancelMSRSwipe()");
            return this.msr_cancelMSRSwipe();
        }
        if (this.deviceTransactionType == 2) {
            ResDataStruct respData = new ResDataStruct();
            UMLog.i("**device_cancelTransaction**", "emv_cancelTransaction()");
            return this.emv_cancelTransaction(respData);
        }
        UMLog.i("**device_cancelTransaction**", "ctls_cancelTransaction()");
        return this.ctls_cancelTransaction();
    }

    public int device_cancelGen2Transaction() {
        BluetoothLEController b;
        if (_btle != null && (b = _btle.getBluetoothController()) != null) {
            return b.cancelTransaction();
        }
        return 10;
    }

    public int device_resetTransaction() {
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT) {
            return 20;
        }
        if (!readyForNextCommand) {
            return 29696;
        }
        return this.msr_cancelMSRSwipe(true);
    }

    public int device_calibrateParameters(byte delta) {
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        ResDataStruct respData = new ResDataStruct();
        isCommandRunning = true;
        this.waitForNotification();
        int cmd = 0;
        int rt = 9;
        byte[] data = new byte[]{delta};
        int loopNum = 0;
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-122, (byte)1, data)), 0, respData);
            ++loopNum;
            if (r != TaskManager.TaskStartRet.SUCCESS) continue;
            if (respData.resData == null) {
                isCommandRunning = false;
                return 21;
            }
            if (respData.resData.length == 1 && respData.resData[0] == 0) {
                isCommandRunning = false;
                return 3;
            }
            rt = 9;
            int len = respData.resData.length;
            if (len <= 11) continue;
            rt = respData.resData[11];
            cmd = respData.resData[10];
            if (cmd == -18 && rt == -16) break;
            if (rt == 0) continue;
            rt = 9;
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != -122));
        int returnCode = this.returnACK(r, respData);
        isCommandRunning = false;
        return returnCode;
    }

    public int device_getDriveFreeSpace(StringBuilder freeSpace, StringBuilder usedSpace) {
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (freeSpace == null || usedSpace == null) {
            return 27392;
        }
        int loopNum = 0;
        int cmd = 0;
        int rt = 9;
        ResDataStruct respData = new ResDataStruct();
        isCommandRunning = true;
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-125, (byte)35, new byte[0])), 0, respData);
            ++loopNum;
            if (r != TaskManager.TaskStartRet.SUCCESS) continue;
            if (respData.resData == null) {
                isCommandRunning = false;
                return 21;
            }
            if (respData.resData.length == 1 && respData.resData[0] == 0) {
                isCommandRunning = false;
                return 3;
            }
            rt = 9;
            int len = respData.resData.length;
            if (len <= 13) continue;
            rt = respData.resData[11];
            cmd = respData.resData[10];
            if (rt == 0 && cmd == -125) {
                int i;
                int spaceLen = respData.resData[13] & 0xFF;
                byte[] space = new byte[spaceLen];
                System.arraycopy(respData.resData, 14, space, 0, spaceLen);
                for (i = 0; i < spaceLen && space[i] != 0; ++i) {
                }
                byte[] fs = new byte[i];
                System.arraycopy(space, 0, fs, 0, fs.length);
                byte[] us = new byte[spaceLen - (i + 1)];
                System.arraycopy(space, i + 1, us, 0, us.length);
                String fsStr = Common.getAsciiFromByte(fs);
                freeSpace.append(fsStr);
                String usStr = Common.getAsciiFromByte(us);
                usedSpace.append(usStr);
                continue;
            }
            if (cmd == -18 && rt == -16) break;
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != -125));
        int returnCode = this.returnACK(r, respData);
        isCommandRunning = false;
        return returnCode;
    }

    public int device_listDirectory(String directoryName, boolean recursive, boolean onSD, StringBuilder directory) {
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (directory == null) {
            return 27392;
        }
        int loopNum = 0;
        int cmd = 0;
        int rt = 9;
        ResDataStruct respData = new ResDataStruct();
        if (directoryName == null) {
            directoryName = "";
        }
        int cmdStringLen = onSD ? directoryName.length() + 10 : directoryName.length() + 5;
        byte[] cmdString = new byte[cmdStringLen];
        cmdString[0] = (byte)(recursive ? 49 : 48);
        cmdString[1] = 48;
        cmdString[2] = 0;
        int idx = 3;
        if (onSD) {
            String sd = "SD://";
            char[] sdChars = sd.toCharArray();
            System.arraycopy(sdChars, 0, cmdString, idx, sdChars.length);
            cmdString[idx += sdChars.length] = 0;
            ++idx;
        } else {
            cmdString[idx] = 0;
            ++idx;
        }
        char[] cmdChars = directoryName.toCharArray();
        if (cmdChars.length > 0) {
            System.arraycopy(cmdChars, 0, cmdString, idx, cmdChars.length);
            idx += cmdChars.length;
        }
        cmdString[idx] = 0;
        ++idx;
        isCommandRunning = true;
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-125, (byte)34, cmdString)), 0, respData);
            ++loopNum;
            if (r != TaskManager.TaskStartRet.SUCCESS) continue;
            if (respData.resData == null) {
                isCommandRunning = false;
                return 21;
            }
            if (respData.resData.length == 1 && respData.resData[0] == 0) {
                isCommandRunning = false;
                return 3;
            }
            rt = 9;
            int len = respData.resData.length;
            if (len <= 13) continue;
            rt = respData.resData[11];
            cmd = respData.resData[10];
            if (rt == 0 && cmd == -125) {
                int dataLen = (respData.resData[12] & 0xFF) << 8 | respData.resData[13] & 0xFF;
                if (dataLen == 0) {
                    directory.append("{EMPTY}");
                    continue;
                }
                byte[] data = new byte[dataLen];
                System.arraycopy(respData.resData, 14, data, 0, dataLen);
                String dataStr = Common.getAsciiFromByte(data);
                directory.append(dataStr);
                continue;
            }
            if (cmd == -18 && rt == -16) break;
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != -125));
        int returnCode = this.returnACK(r, respData);
        isCommandRunning = false;
        return returnCode;
    }

    public int device_readFileFromSD_old(String directoryName, String fileName, int startingOffset, int numBytes, ResDataStruct respData) {
        int i;
        char[] tmp;
        if (respData == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (fileName == null || fileName.length() <= 0 || startingOffset < 0 || startingOffset > 99999999 || numBytes < 0 || numBytes > 99999999) {
            return 27392;
        }
        int loopNum = 0;
        int cmd = 0;
        int rt = 9;
        int totalDataLen = 0;
        if (directoryName == null) {
            directoryName = "";
        }
        String strSO = String.valueOf(startingOffset);
        String strNB = String.valueOf(numBytes);
        int idx = 0;
        int cmdStringLen = directoryName.length() + fileName.length() + strSO.length() + strNB.length() + 4;
        byte[] cmdString = new byte[cmdStringLen];
        if (directoryName.length() > 0) {
            tmp = directoryName.toCharArray();
            System.arraycopy(tmp, 0, cmdString, 0, tmp.length);
            idx += tmp.length;
        }
        cmdString[idx] = 0;
        ++idx;
        tmp = fileName.toCharArray();
        for (i = 0; i < tmp.length; ++i) {
            cmdString[idx + i] = (byte)tmp[i];
        }
        cmdString[idx += tmp.length] = 0;
        ++idx;
        tmp = strSO.toCharArray();
        for (i = 0; i < tmp.length; ++i) {
            cmdString[idx + i] = (byte)tmp[i];
        }
        cmdString[idx += tmp.length] = 0;
        ++idx;
        tmp = strNB.toCharArray();
        for (i = 0; i < tmp.length; ++i) {
            cmdString[idx + i] = (byte)tmp[i];
        }
        cmdString[idx += tmp.length] = 0;
        ++idx;
        isCommandRunning = true;
        do {
            TaskManager.TaskStartRet r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-125, (byte)57, cmdString)), 0, respData);
            ++loopNum;
            if (r == TaskManager.TaskStartRet.SUCCESS) {
                if (respData.resData == null) {
                    isCommandRunning = false;
                    respData.statusCode = 21;
                    return 21;
                }
                if (respData.resData.length == 1 && respData.resData[0] == 0) {
                    isCommandRunning = false;
                    respData.statusCode = 3;
                    return 3;
                }
                rt = 9;
                int len = respData.resData.length;
                if (len > 11) {
                    rt = respData.resData[11];
                    cmd = respData.resData[10];
                    if (cmd == -18 && rt == -16) break;
                }
            }
            if (loopNum >= maxLoopNum || (rt == 0 || rt == 99) && cmd == -125) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException len) {
                // empty catch block
            }
        } while (loopNum < maxLoopNum && (rt != 0 && rt != 99 || cmd != -125));
        int dataLen = 0;
        int chIdx = 14;
        String StrTotalLen = null;
        if (rt == 0 || rt == 99) {
            dataLen = (respData.resData[12] & 0xFF) * 256 + (respData.resData[13] & 0xFF);
            while (respData.resData[chIdx] != 0) {
                ++chIdx;
            }
            byte[] bytes = new byte[chIdx - 14];
            System.arraycopy(respData.resData, 14, bytes, 0, bytes.length);
            StrTotalLen = new String(bytes);
            chIdx += 3;
            for (int i2 = 0; i2 < StrTotalLen.length(); ++i2) {
                totalDataLen = totalDataLen * 10 + StrTotalLen.charAt(i2) - 48;
            }
        } else {
            isCommandRunning = false;
            return rt;
        }
        byte[] temp = new byte[totalDataLen];
        System.arraycopy(respData.resData, chIdx, temp, 0, dataLen -= StrTotalLen.length() + 3);
        idx = dataLen;
        while (rt == 99) {
            long startTime = System.currentTimeMillis();
            if (this.isBluetoothLEDeviceSelected()) {
                _btle.readMessage(1, startTime, respData, true);
            } else {
                _usb.readMessage(1, startTime, respData, true);
            }
            if (respData.resData.length > 14) {
                rt = respData.resData[11];
                dataLen = (respData.resData[12] & 0xFF) * 256 + (respData.resData[13] & 0xFF);
                System.arraycopy(respData.resData, chIdx, temp, idx, dataLen -= StrTotalLen.length() + 3);
                idx += dataLen;
                continue;
            }
            rt = 10;
        }
        respData.resData = temp;
        isCommandRunning = false;
        return rt;
    }

    public int device_readFileFromSD(String directoryName, String fileName, int startingOffset, int numBytes, ResDataStruct respData) {
        if (respData == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (fileName == null || fileName.length() <= 0 || startingOffset < 0 || startingOffset > 99999999 || numBytes < 0 || numBytes > 99999999) {
            return 27392;
        }
        int loopNum = 0;
        int cmd = 0;
        int rt = 9;
        int totalDataLen = 0;
        if (directoryName == null) {
            directoryName = "";
        }
        int times = numBytes / 4000;
        if (numBytes % 4000 != 0) {
            ++times;
        }
        int nBytes = numBytes;
        int sOffset = startingOffset;
        byte[] fullData = null;
        isCommandRunning = true;
        for (int k = 0; k < times; ++k) {
            int i;
            char[] tmp;
            int nb = nBytes > 4000 ? 4000 : nBytes;
            String strSO = String.valueOf(sOffset);
            String strNB = String.valueOf(nb);
            int idx = 0;
            int cmdStringLen = directoryName.length() + fileName.length() + strSO.length() + strNB.length() + 4;
            byte[] cmdString = new byte[cmdStringLen];
            if (directoryName.length() > 0) {
                tmp = directoryName.toCharArray();
                System.arraycopy(tmp, 0, cmdString, 0, tmp.length);
                idx += tmp.length;
            }
            cmdString[idx] = 0;
            ++idx;
            tmp = fileName.toCharArray();
            for (i = 0; i < tmp.length; ++i) {
                cmdString[idx + i] = (byte)tmp[i];
            }
            cmdString[idx += tmp.length] = 0;
            ++idx;
            tmp = strSO.toCharArray();
            for (i = 0; i < tmp.length; ++i) {
                cmdString[idx + i] = (byte)tmp[i];
            }
            cmdString[idx += tmp.length] = 0;
            ++idx;
            tmp = strNB.toCharArray();
            for (i = 0; i < tmp.length; ++i) {
                cmdString[idx + i] = (byte)tmp[i];
            }
            cmdString[idx += tmp.length] = 0;
            ++idx;
            do {
                TaskManager.TaskStartRet r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-125, (byte)57, cmdString)), 0, respData);
                ++loopNum;
                if (r == TaskManager.TaskStartRet.SUCCESS) {
                    if (respData.resData == null) {
                        isCommandRunning = false;
                        respData.statusCode = 21;
                        return 21;
                    }
                    if (respData.resData.length == 1 && respData.resData[0] == 0) {
                        isCommandRunning = false;
                        respData.statusCode = 3;
                        return 3;
                    }
                    rt = 9;
                    int len = respData.resData.length;
                    if (len > 11) {
                        rt = respData.resData[11];
                        cmd = respData.resData[10];
                        if (cmd == -18 && rt == -16) break;
                    }
                }
                if (loopNum >= maxLoopNum || (rt == 0 || rt == 99) && cmd == -125) continue;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException len) {
                    // empty catch block
                }
            } while (loopNum < maxLoopNum && (rt != 0 && rt != 99 || cmd != -125));
            int dataLen = 0;
            int chIdx = 14;
            String StrTotalLen = null;
            if (rt == 0 || rt == 99) {
                dataLen = (respData.resData[12] & 0xFF) * 256 + (respData.resData[13] & 0xFF);
                while (respData.resData[chIdx] != 0) {
                    ++chIdx;
                }
                byte[] bytes = new byte[chIdx - 14];
                System.arraycopy(respData.resData, 14, bytes, 0, bytes.length);
                StrTotalLen = new String(bytes);
                chIdx += 3;
                for (int i2 = 0; i2 < StrTotalLen.length(); ++i2) {
                    totalDataLen = totalDataLen * 10 + StrTotalLen.charAt(i2) - 48;
                }
                dataLen -= StrTotalLen.length() + 3;
            } else {
                isCommandRunning = false;
                if (k == 0) {
                    return rt;
                }
                return 0;
            }
            if (fullData == null) {
                fullData = new byte[dataLen];
                System.arraycopy(respData.resData, chIdx, fullData, 0, dataLen);
            } else {
                byte[] temp = new byte[fullData.length];
                System.arraycopy(fullData, 0, temp, 0, temp.length);
                fullData = new byte[temp.length + dataLen];
                System.arraycopy(temp, 0, fullData, 0, temp.length);
                System.arraycopy(respData.resData, chIdx, fullData, temp.length, dataLen);
            }
            idx = dataLen;
            nBytes -= 4000;
            sOffset += 4000;
        }
        respData.resData = fullData;
        isCommandRunning = false;
        return rt;
    }

    public int device_createDirectory(String directoryName) {
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (directoryName == null || directoryName.length() == 0) {
            return 27392;
        }
        int loopNum = 0;
        int cmd = 0;
        int rt = 9;
        ResDataStruct respData = new ResDataStruct();
        int cmdStringLen = directoryName.length() + 1;
        byte[] cmdString = new byte[cmdStringLen];
        char[] cmdChars = directoryName.toCharArray();
        int idx = 0;
        if (cmdChars.length > 0) {
            System.arraycopy(cmdChars, 0, cmdString, 0, cmdChars.length);
            idx += cmdChars.length;
        }
        cmdString[idx] = 0;
        isCommandRunning = true;
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-125, (byte)37, cmdString)), 0, respData);
            ++loopNum;
            if (r != TaskManager.TaskStartRet.SUCCESS) continue;
            if (respData.resData == null) {
                isCommandRunning = false;
                respData.statusCode = 21;
                return 21;
            }
            if (respData.resData.length == 1 && respData.resData[0] == 0) {
                isCommandRunning = false;
                respData.statusCode = 3;
                return 3;
            }
            rt = 9;
            int len = respData.resData.length;
            if (len <= 11) continue;
            rt = respData.resData[11];
            cmd = respData.resData[10];
            if (cmd == -18 && rt == -16) break;
            if (rt == 0) continue;
            respData.statusCode = 9;
            rt = 9;
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != -125));
        int returnCode = this.returnACK(r, respData);
        isCommandRunning = false;
        return returnCode;
    }

    public int device_deleteDirectory(String directoryName) {
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (directoryName == null || directoryName.length() == 0) {
            return 27392;
        }
        int loopNum = 0;
        int cmd = 0;
        int rt = 9;
        ResDataStruct respData = new ResDataStruct();
        int cmdStringLen = directoryName.length() + 1;
        byte[] cmdString = new byte[cmdStringLen];
        char[] cmdChars = directoryName.toCharArray();
        int idx = 0;
        if (cmdChars.length > 0) {
            System.arraycopy(cmdChars, 0, cmdString, 0, cmdChars.length);
            idx += cmdChars.length;
        }
        cmdString[idx] = 0;
        isCommandRunning = true;
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-125, (byte)38, cmdString)), 0, respData);
            ++loopNum;
            if (r != TaskManager.TaskStartRet.SUCCESS) continue;
            if (respData.resData == null) {
                isCommandRunning = false;
                respData.statusCode = 21;
                return 21;
            }
            if (respData.resData.length == 1 && respData.resData[0] == 0) {
                isCommandRunning = false;
                respData.statusCode = 3;
                return 3;
            }
            rt = 9;
            int len = respData.resData.length;
            if (len <= 11) continue;
            rt = respData.resData[11];
            cmd = respData.resData[10];
            if (cmd == -18 && rt == -16) break;
            if (rt == 0) continue;
            respData.statusCode = 9;
            rt = 9;
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != -125));
        int returnCode = this.returnACK(r, respData);
        isCommandRunning = false;
        return returnCode;
    }

    public int device_deleteFile(String fileName) {
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (fileName == null || fileName.length() == 0) {
            return 27392;
        }
        int loopNum = 0;
        int cmd = 0;
        int rt = 9;
        ResDataStruct respData = new ResDataStruct();
        int cmdStringLen = fileName.length() + 1;
        byte[] cmdString = new byte[cmdStringLen];
        char[] cmdChars = fileName.toCharArray();
        int idx = 0;
        if (cmdChars.length > 0) {
            System.arraycopy(cmdChars, 0, cmdString, 0, cmdChars.length);
            idx += cmdChars.length;
        }
        cmdString[idx] = 0;
        isCommandRunning = true;
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-125, (byte)31, cmdString)), 0, respData);
            ++loopNum;
            if (r != TaskManager.TaskStartRet.SUCCESS) continue;
            if (respData.resData == null) {
                isCommandRunning = false;
                respData.statusCode = 21;
                return 21;
            }
            if (respData.resData.length == 1 && respData.resData[0] == 0) {
                isCommandRunning = false;
                respData.statusCode = 3;
                return 3;
            }
            rt = 9;
            int len = respData.resData.length;
            if (len <= 11) continue;
            rt = respData.resData[11];
            cmd = respData.resData[10];
            if (cmd == -18 && rt == -16) break;
            if (rt == 0) continue;
            respData.statusCode = 9;
            rt = 9;
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != -125));
        int returnCode = this.returnACK(r, respData);
        isCommandRunning = false;
        return returnCode;
    }

    public int device_enhancedPassthrough(byte[] data) {
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (data == null || data.length == 0) {
            return 27392;
        }
        int loopNum = 0;
        int cmd = 0;
        int rt = 9;
        ResDataStruct respData = new ResDataStruct();
        isCommandRunning = true;
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)44, (byte)17, data)), 0, respData);
            ++loopNum;
            if (r != TaskManager.TaskStartRet.SUCCESS) continue;
            if (respData.resData == null) {
                isCommandRunning = false;
                respData.statusCode = 21;
                return 21;
            }
            if (respData.resData.length == 1 && respData.resData[0] == 0) {
                isCommandRunning = false;
                respData.statusCode = 3;
                return 3;
            }
            rt = 9;
            int len = respData.resData.length;
            if (len <= 11) continue;
            rt = respData.resData[11];
            cmd = respData.resData[10];
            if (cmd == -18 && rt == -16) break;
            if (rt == 0) continue;
            respData.statusCode = 9;
            rt = 9;
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != 44));
        int returnCode = this.returnACK(r, respData);
        isCommandRunning = false;
        return returnCode;
    }

    public int device_controlIndicator(byte indicator, boolean enable) {
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (indicator != 0 && indicator != 1 && indicator != 2 && indicator != 3) {
            return 27392;
        }
        int loopNum = 0;
        int cmd = 0;
        int rt = 9;
        ResDataStruct respData = new ResDataStruct();
        byte[] data = new byte[]{indicator, (byte)(enable ? 1 : 0)};
        isCommandRunning = true;
        do {
            r = indicator == 1 ? this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-16, enable ? (byte)-5 : -6, new byte[0])), 0, respData) : this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-16, (byte)-1, data)), 0, respData);
            ++loopNum;
            if (r != TaskManager.TaskStartRet.SUCCESS) continue;
            if (respData.resData == null) {
                isCommandRunning = false;
                respData.statusCode = 21;
                return 21;
            }
            if (respData.resData.length == 1 && respData.resData[0] == 0) {
                isCommandRunning = false;
                respData.statusCode = 3;
                return 3;
            }
            rt = 9;
            int len = respData.resData.length;
            if (len <= 11) continue;
            rt = respData.resData[11];
            cmd = respData.resData[10];
            if (cmd == -18 && rt == -16) break;
            if (rt == 0) continue;
            respData.statusCode = 9;
            rt = 9;
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != 44));
        int returnCode = this.returnACK(r, respData);
        isCommandRunning = false;
        return returnCode;
    }

    public int config_getSerialNumber(StringBuilder serialNumber) {
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (serialNumber == null) {
            return 27392;
        }
        ResDataStruct respData = new ResDataStruct();
        isCommandRunning = true;
        this.waitForNotification();
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIMAG || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIJACK || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_BTMAG || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIMAG_PRO) {
            r = this.sendCommand_helper("02524E031D", 0, respData);
        } else {
            if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG_KB) {
                TaskManager.TaskStartRet r2 = this.sendCommand_helper("02524E031D", 7, respData);
                int ec = this.returnACK(r2, respData);
                if (ec == 0) {
                    String verStr = new String(respData.resData);
                    serialNumber.append(verStr);
                }
                isCommandRunning = false;
                return ec;
            }
            if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
                TaskManager.TaskStartRet r3;
                if (!this.device_isConnected()) {
                    return 1;
                }
                byte[] data = new byte[]{};
                int cmd = 0;
                int rt = 9;
                if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V) {
                    this.waitForVivo();
                }
                int loopNum = 0;
                do {
                    r3 = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)18, (byte)1, data)), 0, respData);
                    ++loopNum;
                    if (r3 == TaskManager.TaskStartRet.SUCCESS) {
                        if (respData.resData == null) {
                            isCommandRunning = false;
                            return 21;
                        }
                        if (respData.resData.length == 1 && respData.resData[0] == 0) {
                            isCommandRunning = false;
                            return 3;
                        }
                        rt = 9;
                        int len = respData.resData.length;
                        byte[] buff = respData.resData;
                        if (len > 11) {
                            rt = respData.resData[11];
                            cmd = respData.resData[10];
                            if (rt == 11) {
                                rt = 25088;
                            } else if (rt == 0 && cmd == 18) {
                                String ver = new String();
                                byte[] slice = Arrays.copyOfRange(buff, 14, 24);
                                ver = Common.byteToString(slice);
                                serialNumber.append(ver);
                            } else if (cmd == -18 && rt == -16) break;
                        }
                    }
                    if (loopNum >= maxLoopNum || rt == 0 && cmd == 18) continue;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException len) {
                        // empty catch block
                    }
                } while (loopNum < maxLoopNum && (rt != 0 || cmd != 18));
                isCommandRunning = false;
                return this.returnACK(r3, respData);
            }
            r = this.sendCommand_helper("784602", 0, respData);
        }
        int ec = this.returnACK(r, respData);
        if (ec == 0) {
            int respLen;
            int startPos;
            String ver = new String();
            byte[] buff = respData.resData;
            int len = respData.resData.length;
            if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIMAG || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIJACK) {
                startPos = 2;
                respLen = len - 2;
            } else if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_BTMAG) {
                startPos = 5;
                respLen = len - 2;
            } else {
                startPos = 4;
                respLen = len - 3;
            }
            byte[] slice = Arrays.copyOfRange(buff, startPos, respLen);
            ver = Common.byteToString(slice);
            serialNumber.append(ver);
        }
        isCommandRunning = false;
        return ec;
    }

    public int config_getModelNumber(StringBuilder modNumber) {
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (modNumber == null) {
            return 27392;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        isCommandRunning = true;
        this.waitForNotification();
        ResDataStruct respData = new ResDataStruct();
        TaskManager.TaskStartRet r = this.sendCommand_helper("784620", 0, respData);
        int ec = this.returnACK(r, respData);
        if (ec == 0) {
            String ver = new String();
            byte[] buff = respData.resData;
            int len = respData.resData.length;
            byte[] slice = Arrays.copyOfRange(buff, 4, len - 3);
            ver = Common.byteToString(slice);
            modNumber.append(ver);
        }
        isCommandRunning = false;
        return ec;
    }

    public int device_getKSN(ResDataStruct resKSN) {
        TaskManager.TaskStartRet r;
        if (resKSN == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            resKSN.statusCode = 29696;
            return 29696;
        }
        if (!this.device_isConnected()) {
            resKSN.statusCode = 1;
            return 1;
        }
        ResDataStruct respData = new ResDataStruct();
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIMAG || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIJACK || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_BTMAG) {
            isCommandRunning = true;
            this.waitForNotification();
            r = this.sendCommand_helper("0252510302", 0, respData);
        } else {
            if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG_KB) {
                isCommandRunning = true;
                this.waitForNotification();
                TaskManager.TaskStartRet r2 = this.sendCommand_helper("0252510302", 8, respData);
                int ec = this.returnACK(r2, respData);
                if (ec == 0 && respData.resData != null && respData.resData.length > 0) {
                    resKSN.resData = new byte[respData.resData.length];
                    System.arraycopy(respData.resData, 0, resKSN.resData, 0, respData.resData.length);
                }
                isCommandRunning = false;
                resKSN.statusCode = ec;
                return ec;
            }
            if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
                resKSN.statusCode = 20;
                return 20;
            }
            if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_BTPAY || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_BTPAY_USB) {
                resKSN.statusCode = 20;
                return 20;
            }
            if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA) {
                resKSN.statusCode = 20;
                return 20;
            }
            isCommandRunning = true;
            this.waitForNotification();
            r = this.sendCommand_helper("784651", 0, respData);
        }
        int ec = this.returnACK(r, respData);
        if (ec == 0) {
            int respLen;
            int startPos;
            byte[] buff = respData.resData;
            int len = respData.resData.length;
            if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIMAG || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIJACK || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_BTMAG) {
                startPos = 2;
                respLen = len - 4;
            } else {
                startPos = 4;
                respLen = len - 7;
            }
            resKSN.resData = new byte[respLen];
            System.arraycopy(buff, startPos, resKSN.resData, 0, respLen);
        }
        isCommandRunning = false;
        resKSN.statusCode = ec;
        return ec;
    }

    public int device_getKSN(byte keyNameIndex, byte[] keySlot, ResDataStruct resKSN) {
        TaskManager.TaskStartRet r;
        if (resKSN == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            resKSN.statusCode = 29696;
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT) {
            resKSN.statusCode = 20;
            return 20;
        }
        if (!this.device_isConnected()) {
            resKSN.statusCode = 1;
            return 1;
        }
        if (keySlot == null || keySlot.length != 2) {
            return 27392;
        }
        int cmd = 0;
        int rt = 9;
        byte[] data = new byte[]{keyNameIndex, keySlot[0], keySlot[1]};
        isCommandRunning = true;
        this.waitForNotification();
        int loopNum = 0;
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-127, (byte)11, data)), 0, resKSN);
            ++loopNum;
            if (r == TaskManager.TaskStartRet.SUCCESS) {
                if (resKSN.resData == null) {
                    isCommandRunning = false;
                    resKSN.statusCode = 21;
                    return 21;
                }
                if (resKSN.resData.length == 1 && resKSN.resData[0] == 0) {
                    isCommandRunning = false;
                    resKSN.statusCode = 3;
                    return 3;
                }
                rt = 9;
                int len = resKSN.resData.length;
                if (len > 11) {
                    rt = resKSN.resData[11];
                    cmd = resKSN.resData[10];
                    if (cmd == -18 && rt == -16) break;
                    if (rt != 0) {
                        rt = 9;
                    }
                }
            }
            if (loopNum >= maxLoopNum || rt == 0 && cmd == -127) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException len) {
                // empty catch block
            }
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != -127));
        int returnCode = this.returnACK(r, resKSN);
        this.convertIDG(resKSN, 0);
        isCommandRunning = false;
        resKSN.statusCode = returnCode;
        return returnCode;
    }

    public int device_ReviewAudioJackSetting(ResDataStruct respData) {
        TaskManager.TaskStartRet r;
        if (respData == null) {
            return 27392;
        }
        if (!this.device_isConnected()) {
            respData.statusCode = 1;
            return 1;
        }
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIMAG || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIJACK || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIMAG_PRO) {
            r = this.sendCommand_helper("02521F034C", 0, respData);
        } else {
            if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_BTPAY || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_BTPAY_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_BTMAG || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
                respData.statusCode = 20;
                return 20;
            }
            r = this.sendCommand_helper("7d5200", 0, respData);
        }
        int ec = this.returnACK(r, respData);
        if (ec == 0) {
            int respLen;
            int startPos;
            byte[] buff = respData.resData;
            int len = respData.resData.length;
            if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIMAG || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIJACK || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_BTMAG) {
                startPos = 2;
                respLen = len - 4;
            } else {
                startPos = 4;
                respLen = len - 7;
            }
            respData.resData = new byte[respLen];
            System.arraycopy(buff, startPos, respData.resData, 0, respLen);
        }
        respData.statusCode = ec;
        return ec;
    }

    public int device_enableTDES(ResDataStruct respData) {
        int ec;
        if (respData == null) {
            return 27392;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIMAG && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIJACK && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_BTMAG && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG_KB) {
            respData.statusCode = 20;
            return 20;
        }
        if (!this.device_isConnected()) {
            respData.statusCode = 1;
            return 1;
        }
        TaskManager.TaskStartRet r = connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG_KB ? this.sendCommand_helper("02534C0131032E", 1, respData) : this.sendCommand_helper("02534C0131032E", 0, respData);
        respData.statusCode = ec = this.returnACK(r, respData);
        return ec;
    }

    public int device_enableAES(ResDataStruct respData) {
        int ec;
        if (respData == null) {
            return 27392;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIMAG && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIJACK && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_BTMAG && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG_KB) {
            respData.statusCode = 20;
            return 20;
        }
        if (!this.device_isConnected()) {
            respData.statusCode = 1;
            return 1;
        }
        TaskManager.TaskStartRet r = connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG_KB ? this.sendCommand_helper("02534C0132032D", 2, respData) : this.sendCommand_helper("02534C0132032D", 0, respData);
        respData.statusCode = ec = this.returnACK(r, respData);
        return ec;
    }

    public int device_switchToKeyboardMode(ResDataStruct respData) {
        int ec;
        if (respData == null) {
            return 27392;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG) {
            respData.statusCode = 20;
            return 20;
        }
        if (!this.device_isConnected()) {
            respData.statusCode = 1;
            return 1;
        }
        TaskManager.TaskStartRet r = this.sendCommand_helper("02532301380348", 17, respData);
        respData.statusCode = ec = this.returnACK(r, respData);
        return ec;
    }

    public int device_switchToHidMode(ResDataStruct respData) {
        int ec;
        if (respData == null) {
            return 27392;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG_KB) {
            respData.statusCode = 20;
            return 20;
        }
        if (!this.device_isConnected()) {
            respData.statusCode = 1;
            return 1;
        }
        TaskManager.TaskStartRet r = this.sendCommand_helper("02532301300340", 16, respData);
        respData.statusCode = ec = this.returnACK(r, respData);
        return ec;
    }

    public int device_calibrateReader(ResDataStruct respData) {
        int ec;
        if (respData == null) {
            return 27392;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIJACK) {
            respData.statusCode = 20;
            return 20;
        }
        byte year = (byte)(Calendar.getInstance().get(1) % 100);
        byte week = (byte)Calendar.getInstance().get(3);
        String yearStr = String.format(Locale.US, "%02x", 0xFF & year).toUpperCase(Locale.US);
        String weekStr = String.format(Locale.US, "%02x", 0xFF & week).toUpperCase(Locale.US);
        String command = "02537F02" + yearStr + weekStr + "03";
        TaskManager.TaskStartRet r = this.sendCommand_helper(command, 0, respData);
        respData.statusCode = ec = this.returnACK(r, respData);
        return ec;
    }

    public int device_enableErrorNotification(ResDataStruct respData, boolean enable) {
        int ec;
        if (respData == null) {
            return 27392;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIMAG && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIJACK && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_BTMAG && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG_KB) {
            respData.statusCode = 20;
            return 20;
        }
        if (!this.device_isConnected()) {
            respData.statusCode = 1;
            return 1;
        }
        TaskManager.TaskStartRet r = connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG_KB ? (enable ? this.sendCommand_helper("0253190134037E", 9, respData) : this.sendCommand_helper("0253190130037A", 10, respData)) : (enable ? this.sendCommand_helper("0253190134037E", 0, respData) : this.sendCommand_helper("0253190130037A", 0, respData));
        respData.statusCode = ec = this.returnACK(r, respData);
        return ec;
    }

    public int device_enableExpDate(ResDataStruct respData, boolean enable) {
        int ec;
        if (respData == null) {
            return 27392;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIMAG && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIJACK && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_BTMAG && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG_KB) {
            respData.statusCode = 20;
            return 20;
        }
        if (!this.device_isConnected()) {
            respData.statusCode = 1;
            return 1;
        }
        TaskManager.TaskStartRet r = connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG_KB ? (enable ? this.sendCommand_helper("02535001310332", 11, respData) : this.sendCommand_helper("02535001300333", 12, respData)) : (enable ? this.sendCommand_helper("02535001310332", 0, respData) : this.sendCommand_helper("02535001300333", 0, respData));
        respData.statusCode = ec = this.returnACK(r, respData);
        return ec;
    }

    public int device_setEnhancedMode(ResDataStruct respData, boolean enable) {
        int ec;
        if (respData == null) {
            return 27392;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG_KB) {
            respData.statusCode = 20;
            return 20;
        }
        if (!this.device_isConnected()) {
            respData.statusCode = 1;
            return 1;
        }
        TaskManager.TaskStartRet r = enable ? this.sendCommand_helper("025385013103E7", 19, respData) : this.sendCommand_helper("025385013003E6", 20, respData);
        respData.statusCode = ec = this.returnACK(r, respData);
        return ec;
    }

    public int device_enableForceEncryption(ResDataStruct respData, boolean enable) {
        int ec;
        if (respData == null) {
            return 27392;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIMAG && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIJACK && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_BTMAG) {
            respData.statusCode = 20;
            return 20;
        }
        if (!this.device_isConnected()) {
            respData.statusCode = 1;
            return 1;
        }
        TaskManager.TaskStartRet r = enable ? this.sendCommand_helper("025384013303E4", 0, respData) : this.sendCommand_helper("025384013003E7", 0, respData);
        respData.statusCode = ec = this.returnACK(r, respData);
        return ec;
    }

    @SuppressLint(value={"SimpleDateFormat"})
    public int device_setDateTime(byte[] mac) {
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA) {
            return 20;
        }
        if (mac != null && mac.length != 30) {
            return 27392;
        }
        isCommandRunning = true;
        this.waitForNotification();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss", Locale.US);
        Date date = new Date();
        String sDateTime = dateFormat.format(date).substring(2, 14);
        ResDataStruct respData = new ResDataStruct();
        TaskManager.TaskStartRet r = connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA ? this.sendCommand_helper("785301500806" + sDateTime + "00", 0, respData) : this.sendCommand_helper("785301502606" + sDateTime + Common.bytesToHex(mac), 0, respData);
        isCommandRunning = false;
        return this.returnACK(r, respData);
    }

    public int device_setRTCDateTime(byte[] dateTime) {
        TaskManager.TaskStartRet r;
        ResDataStruct respData;
        block13: {
            int len;
            int rt;
            byte cmd;
            int loopNum;
            byte[] data;
            block14: {
                if (!readyForNextCommand || !readyForCardSwipe) {
                    return 29696;
                }
                if (!this.device_isConnected()) {
                    return 1;
                }
                if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
                    return 20;
                }
                if (dateTime == null || dateTime.length < 6) {
                    return 27392;
                }
                isCommandRunning = true;
                this.waitForNotification();
                respData = new ResDataStruct();
                data = new byte[]{-102, 3, dateTime[0], dateTime[1], dateTime[2], -97, 33, 3, dateTime[3], dateTime[4], dateTime[5]};
                loopNum = 0;
                cmd = 0;
                rt = 9;
                if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB) break block14;
                do {
                    r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)37, (byte)5, dateTime)), 0, respData);
                    ++loopNum;
                    int n = len = respData.resData == null ? 0 : respData.resData.length;
                    if (len > 11) {
                        cmd = respData.resData[10];
                        rt = respData.resData[11];
                        if (cmd == -18 && rt == -16) break block13;
                    }
                    if (loopNum >= maxLoopNum || rt == 0 && cmd == 37) continue;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while (loopNum < maxLoopNum && (rt != 0 || cmd != 37));
                break block13;
                {
                }
            }
            do {
                r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)4, (byte)0, data)), 0, respData);
                ++loopNum;
                int n = len = respData.resData == null ? 0 : respData.resData.length;
                if (len > 11) {
                    cmd = respData.resData[10];
                    rt = respData.resData[11];
                    if (cmd == -18 && rt == -16) break;
                }
                if (loopNum >= maxLoopNum || rt == 0 && cmd == 4) continue;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (loopNum < maxLoopNum && (rt != 0 || cmd != 4));
        }
        isCommandRunning = false;
        int ec = this.returnACK(r, respData);
        return ec;
    }

    public int device_getRTCDateTime(byte[] dateTime) {
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
            return 20;
        }
        if (dateTime == null || dateTime.length < 6) {
            return 27392;
        }
        isCommandRunning = true;
        this.waitForNotification();
        ResDataStruct respData = new ResDataStruct();
        byte[] data = new byte[]{};
        int loopNum = 0;
        byte cmd = 0;
        int rt = 9;
        int ec = 9;
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB) {
            TaskManager.TaskStartRet r;
            do {
                int len;
                r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)37, (byte)6, data)), 0, respData);
                ++loopNum;
                int n = len = respData.resData == null ? 0 : respData.resData.length;
                if (len > 11) {
                    cmd = respData.resData[10];
                    rt = respData.resData[11];
                    if (cmd == -18 && rt == -16) break;
                }
                if (loopNum >= maxLoopNum || rt == 0 && cmd == 37) continue;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (loopNum < maxLoopNum && (rt != 0 || cmd != 37));
            isCommandRunning = false;
            ec = this.returnACK(r, respData);
            if (ec == 0 && respData.resData != null && respData.resData.length > 19) {
                System.arraycopy(respData.resData, 14, dateTime, 0, 6);
            }
        } else {
            TaskManager.TaskStartRet r;
            do {
                int len;
                r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)3, (byte)2, data)), 0, respData);
                ++loopNum;
                int n = len = respData.resData == null ? 0 : respData.resData.length;
                if (len > 11) {
                    cmd = respData.resData[10];
                    rt = respData.resData[11];
                    if (cmd == -18 && rt == -16) break;
                }
                if (loopNum >= maxLoopNum || rt == 0 && cmd == 3) continue;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (loopNum < maxLoopNum && (rt != 0 || cmd != 3));
            isCommandRunning = false;
            ec = this.returnACK(r, respData);
            if (ec == 0 && respData.resData != null && respData.resData.length > 13) {
                int tagDataLen = (respData.resData[12] & 0xFF) * 256 + (respData.resData[13] & 0xFF);
                byte[] tagData = new byte[tagDataLen];
                System.arraycopy(respData.resData, 14, tagData, 0, tagDataLen);
                Map<String, Map<String, byte[]>> TLVDict = Common.processTLV(tagData);
                Map<String, byte[]> Tags = TLVDict.get("tags");
                byte[] date = Tags.get("9A");
                byte[] time = Tags.get("9F21");
                if (date != null && date.length >= 3 && time != null && time.length >= 3) {
                    System.arraycopy(date, 0, dateTime, 0, 3);
                    System.arraycopy(time, 0, dateTime, 3, 3);
                } else {
                    ec = 10;
                }
            }
        }
        return ec;
    }

    @SuppressLint(value={"SimpleDateFormat"})
    public int device_wakeup() {
        if (!readyForNextCommand) {
            return 29696;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        isCommandRunning = true;
        this.waitForNotification();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss", Locale.US);
        Date date = new Date();
        String sDateTime = dateFormat.format(date).substring(2, 14);
        ResDataStruct respData = new ResDataStruct();
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA) {
            TaskManager.TaskStartRet r = this.sendCommand_helper(null, 0, respData);
        } else {
            TaskManager.TaskStartRet r = this.sendCommand_helper(null, 0, respData);
        }
        isCommandRunning = false;
        return 0;
    }

    public int device_setMerchantRecord(int index, boolean enabled, String merchantID, String merchantURL) {
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VENDI && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (index < 1 || index > 6) {
            return 27392;
        }
        if (merchantID == null || merchantID.length() == 0) {
            return 27392;
        }
        if (merchantURL != null && merchantURL.length() > 64) {
            return 27392;
        }
        isCommandRunning = true;
        this.waitForNotification();
        ResDataStruct respData = new ResDataStruct();
        byte cmd = 0;
        int rt = 9;
        int loopNum = 0;
        byte[] data = new byte[99];
        data[0] = (byte)index;
        data[1] = enabled ? (byte)1 : 0;
        byte[] mid = Common.getHash(merchantID);
        System.arraycopy(mid, 0, data, 2, 32);
        if (merchantURL != null && merchantURL.length() > 0) {
            data[34] = (byte)merchantURL.length();
            byte[] murl = merchantURL.getBytes();
            System.arraycopy(murl, 0, data, 35, murl.length);
        }
        do {
            int len;
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)4, (byte)17, data)), 0, respData);
            ++loopNum;
            int n = len = respData.resData == null ? 0 : respData.resData.length;
            if (len > 11) {
                cmd = respData.resData[10];
                rt = respData.resData[11];
                if (cmd == -18 && rt == -16) break;
            }
            if (loopNum >= maxLoopNum || rt == 0 && cmd == 4) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != 4));
        int ret = this.returnACK(r, respData);
        isCommandRunning = false;
        respData.statusCode = ret;
        return ret;
    }

    public int device_getMerchantRecord(int index, ResDataStruct respData) {
        TaskManager.TaskStartRet r;
        if (respData == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            respData.statusCode = 29696;
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VENDI && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
            respData.statusCode = 20;
            return 20;
        }
        if (!this.device_isConnected()) {
            respData.statusCode = 1;
            return 1;
        }
        if (index < 1 || index > 6) {
            respData.statusCode = 27392;
            return 27392;
        }
        isCommandRunning = true;
        this.waitForNotification();
        byte cmd = 0;
        int rt = 9;
        int loopNum = 0;
        byte[] data = new byte[]{(byte)index};
        do {
            int len;
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)3, (byte)17, data)), 0, respData);
            ++loopNum;
            int n = len = respData.resData == null ? 0 : respData.resData.length;
            if (len > 11) {
                cmd = respData.resData[10];
                rt = respData.resData[11];
                if (cmd == -18 && rt == -16) break;
            }
            if (loopNum >= maxLoopNum || rt == 0 && cmd == 3) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != 3));
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int device_getKeyStatus(ResDataStruct respData) {
        if (respData == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            respData.statusCode = 29696;
            return 29696;
        }
        if (!this.device_isConnected()) {
            respData.statusCode = 1;
            return 1;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA) {
            respData.statusCode = 20;
            return 20;
        }
        isCommandRunning = true;
        this.waitForNotification();
        TaskManager.TaskStartRet r = connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA && _isTTK ? this.sendCommand_helper("784625", 0, respData) : this.sendCommand_helper("784630", 0, respData);
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int device_getDRS(ResDataStruct respData) {
        TaskManager.TaskStartRet r;
        block13: {
            block14: {
                if (respData == null) {
                    return 27392;
                }
                if (!readyForNextCommand || !readyForCardSwipe) {
                    respData.statusCode = 29696;
                    return 29696;
                }
                if (!this.device_isConnected()) {
                    respData.statusCode = 1;
                    return 1;
                }
                if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || !_isTTK && !_isThales) {
                    return 20;
                }
                isCommandRunning = true;
                this.waitForNotification();
                int cmd = 0;
                int rt = 9;
                if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB) break block14;
                this.waitForVivo();
                int loopNum = 0;
                do {
                    r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-57, (byte)58, new byte[0])), 0, respData);
                    ++loopNum;
                    if (r == TaskManager.TaskStartRet.SUCCESS) {
                        if (respData.resData == null) {
                            isCommandRunning = false;
                            respData.statusCode = 21;
                            return 21;
                        }
                        if (respData.resData.length == 1 && respData.resData[0] == 0) {
                            isCommandRunning = false;
                            respData.statusCode = 3;
                            return 3;
                        }
                        rt = 9;
                        int len = respData.resData.length;
                        if (len > 11) {
                            rt = respData.resData[11];
                            cmd = respData.resData[10];
                            if (cmd == -18 && rt == -16) break block13;
                            if (rt != 0) {
                                rt = 9;
                            }
                        }
                    }
                    if (loopNum >= maxLoopNum || rt == 0 && cmd == -57) continue;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while (loopNum < maxLoopNum && (rt != 0 || cmd != -57));
                break block13;
                {
                }
            }
            r = this.sendCommand_helper("75460DFF55", 0, respData);
        }
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int device_verifyBackdoorKey() {
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA || !_isTTK) {
            return 20;
        }
        isCommandRunning = true;
        this.waitForNotification();
        ResDataStruct respData = new ResDataStruct();
        TaskManager.TaskStartRet r = this.sendCommand_helper("784D0155555555AAAAAAAA", 0, respData);
        isCommandRunning = false;
        return this.returnACK(r, respData);
    }

    public int device_loadCertCA(byte certType, byte[] CACertDate) {
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (CACertDate == null || CACertDate.length <= 0) {
            return 27392;
        }
        int cmd = 0;
        int rt = 9;
        byte[] data = new byte[4 + CACertDate.length];
        isCommandRunning = true;
        this.waitForNotification();
        data[0] = certType;
        System.arraycopy(CACertDate, 0, data, 4, CACertDate.length);
        int loopNum = 0;
        ResDataStruct respData = new ResDataStruct();
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-57, (byte)23, data)), 0, respData);
            ++loopNum;
            if (r == TaskManager.TaskStartRet.SUCCESS) {
                if (respData.resData == null) {
                    isCommandRunning = false;
                    respData.statusCode = 21;
                    return 21;
                }
                if (respData.resData.length == 1 && respData.resData[0] == 0) {
                    isCommandRunning = false;
                    respData.statusCode = 3;
                    return 3;
                }
                rt = 9;
                int len = respData.resData.length;
                if (len > 11) {
                    rt = respData.resData[11];
                    cmd = respData.resData[10];
                    if (cmd == -18 && rt == -16) break;
                    if (rt != 0) {
                        rt = 9;
                    }
                }
            }
            if (loopNum >= maxLoopNum || rt == 0 && cmd == -57) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException len) {
                // empty catch block
            }
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != -57));
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int device_rrcUninstallApp(String appName) {
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (appName == null || appName.length() < 2 || appName.length() > 128) {
            return 27392;
        }
        int cmd = 0;
        int rt = 9;
        byte[] data = new byte[1 + appName.length()];
        byte[] appNameBytes = null;
        try {
            appNameBytes = appName.getBytes("ASCII");
        }
        catch (UnsupportedEncodingException ex) {
            return 10;
        }
        if (appNameBytes.length != appName.length()) {
            return 10;
        }
        isCommandRunning = true;
        this.waitForNotification();
        System.arraycopy(appNameBytes, 0, data, 0, appNameBytes.length);
        data[appNameBytes.length] = 0;
        int loopNum = 0;
        ResDataStruct respData = new ResDataStruct();
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)100, (byte)44, data)), this.app_timeout < 5 ? 5 : this.app_timeout, respData);
            ++loopNum;
            if (r == TaskManager.TaskStartRet.SUCCESS) {
                if (respData.resData == null) {
                    isCommandRunning = false;
                    respData.statusCode = 21;
                    return 21;
                }
                if (respData.resData.length == 1 && respData.resData[0] == 0) {
                    isCommandRunning = false;
                    respData.statusCode = 3;
                    return 3;
                }
                rt = 9;
                int len = respData.resData.length;
                if (len > 11) {
                    rt = respData.resData[11];
                    cmd = respData.resData[10];
                    if (cmd == -18 && rt == -16) break;
                    if (rt != 0) {
                        rt = 9;
                    }
                }
            }
            if (loopNum >= maxLoopNum || rt == 0 && cmd == 100) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException len) {
                // empty catch block
            }
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != 100));
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int device_rrcInstallApp(String appName) {
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (appName == null || appName.length() < 2 || appName.length() > 128) {
            return 27392;
        }
        int cmd = 0;
        int rt = 9;
        byte[] data = new byte[1 + appName.length()];
        byte[] appNameBytes = null;
        try {
            appNameBytes = appName.getBytes("ASCII");
        }
        catch (UnsupportedEncodingException ex) {
            return 10;
        }
        if (appNameBytes.length != appName.length()) {
            return 10;
        }
        isCommandRunning = true;
        this.waitForNotification();
        System.arraycopy(appNameBytes, 0, data, 0, appNameBytes.length);
        data[appNameBytes.length] = 0;
        int loopNum = 0;
        ResDataStruct respData = new ResDataStruct();
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)100, (byte)41, data)), this.app_timeout < 5 ? 5 : this.app_timeout, respData);
            ++loopNum;
            if (r == TaskManager.TaskStartRet.SUCCESS) {
                if (respData.resData == null) {
                    isCommandRunning = false;
                    respData.statusCode = 21;
                    return 21;
                }
                if (respData.resData.length == 1 && respData.resData[0] == 0) {
                    isCommandRunning = false;
                    respData.statusCode = 3;
                    return 3;
                }
                rt = 9;
                int len = respData.resData.length;
                if (len > 11) {
                    rt = respData.resData[11];
                    cmd = respData.resData[10];
                    if (cmd == -18 && rt == -16) break;
                    if (rt != 0) {
                        rt = 9;
                    }
                }
            }
            if (loopNum >= maxLoopNum || rt == 0 && cmd == 100) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException len) {
                // empty catch block
            }
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != 100));
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int device_rrcRunApp(String appName) {
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (appName == null || appName.length() < 2 || appName.length() > 128) {
            return 27392;
        }
        int cmd = 0;
        int rt = 9;
        byte[] data = new byte[1 + appName.length()];
        byte[] appNameBytes = null;
        try {
            appNameBytes = appName.getBytes("ASCII");
        }
        catch (UnsupportedEncodingException ex) {
            return 10;
        }
        if (appNameBytes.length != appName.length()) {
            return 10;
        }
        isCommandRunning = true;
        this.waitForNotification();
        System.arraycopy(appNameBytes, 0, data, 0, appNameBytes.length);
        data[appNameBytes.length] = 0;
        int loopNum = 0;
        ResDataStruct respData = new ResDataStruct();
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)100, (byte)42, data)), this.app_timeout < 5 ? 5 : this.app_timeout, respData);
            ++loopNum;
            if (r == TaskManager.TaskStartRet.SUCCESS) {
                if (respData.resData == null) {
                    isCommandRunning = false;
                    respData.statusCode = 21;
                    return 21;
                }
                if (respData.resData.length == 1 && respData.resData[0] == 0) {
                    isCommandRunning = false;
                    respData.statusCode = 3;
                    return 3;
                }
                rt = 9;
                int len = respData.resData.length;
                if (len > 11) {
                    rt = respData.resData[11];
                    cmd = respData.resData[10];
                    if (cmd == -18 && rt == -16) break;
                    if (rt != 0) {
                        rt = 9;
                    }
                }
            }
            if (loopNum >= maxLoopNum || rt == 0 && cmd == 100) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException len) {
                // empty catch block
            }
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != 100));
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int device_rrcDownloadApp(String zipFileName, String appName) {
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (zipFileName == null || zipFileName.length() < 4 || appName == null || appName.length() < 2 || appName.length() > 128) {
            return 27392;
        }
        String path = Environment.getExternalStorageDirectory().toString();
        String fileNameWithPath = path + File.separator + zipFileName;
        File file = new File(fileNameWithPath);
        if (file.length() < 1L || file.length() > 0x1000000L) {
            return 10;
        }
        int count = (int)file.length() / 1000;
        int remaining = (int)file.length() % 1000;
        byte[] fileData = new byte[1000];
        byte[] remainingData = null;
        if (remaining > 0) {
            remainingData = new byte[remaining];
        }
        DataInputStream dis = null;
        try {
            dis = new DataInputStream(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return 10;
        }
        byte[] appNameBytes = null;
        try {
            appNameBytes = appName.getBytes("ASCII");
        }
        catch (UnsupportedEncodingException ex) {
            return 10;
        }
        if (appNameBytes.length != appName.length()) {
            return 10;
        }
        String strFileLen = String.valueOf(file.length());
        byte[] fileLenBytes = null;
        try {
            fileLenBytes = strFileLen.getBytes("ASCII");
        }
        catch (UnsupportedEncodingException ex) {
            return 10;
        }
        if (fileLenBytes.length != strFileLen.length()) {
            return 10;
        }
        ResDataStruct respData = new ResDataStruct();
        int flag = 48;
        byte[] data = null;
        boolean isRemaining = false;
        int returnCode = 0;
        for (int i = 0; i < (remaining > 0 ? count + 1 : count); ++i) {
            TaskManager.TaskStartRet r;
            if (count == 0 && remaining > 0) {
                flag = 51;
                isRemaining = true;
                try {
                    dis.readFully(remainingData);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return 10;
                }
            }
            if (i == 0) {
                flag = 50;
                isRemaining = false;
                try {
                    dis.readFully(fileData);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return 10;
                }
            }
            if (i == (remaining > 0 ? count : count - 1)) {
                flag = 49;
                if (remaining > 0) {
                    isRemaining = true;
                    try {
                        dis.readFully(remainingData);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        return 10;
                    }
                } else {
                    isRemaining = false;
                    try {
                        dis.readFully(fileData);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        return 10;
                    }
                }
            } else {
                flag = 48;
                isRemaining = false;
                try {
                    dis.readFully(fileData);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return 10;
                }
            }
            int cmd = 0;
            int rt = 9;
            isCommandRunning = true;
            this.waitForNotification();
            data = new byte[appName.length() + strFileLen.length() + 4 + (isRemaining ? remaining : 1000)];
            System.arraycopy(appNameBytes, 0, data, 0, appNameBytes.length);
            System.arraycopy(fileLenBytes, 0, data, appNameBytes.length + 1, fileLenBytes.length);
            data[appNameBytes.length + fileLenBytes.length + 2] = flag;
            if (isRemaining) {
                System.arraycopy(remainingData, 0, data, appNameBytes.length + fileLenBytes.length + 4, remainingData.length);
            } else {
                System.arraycopy(fileData, 0, data, appNameBytes.length + fileLenBytes.length + 4, fileData.length);
            }
            int loopNum = 0;
            if (flag == 49) {
                this.app_timeout = (int)(file.length() / 11000L);
                if (this.app_timeout <= 3) {
                    this.app_timeout = 0;
                }
            }
            do {
                r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)100, (byte)43, data)), this.app_timeout, respData);
                ++loopNum;
                if (r == TaskManager.TaskStartRet.SUCCESS) {
                    if (respData.resData == null) {
                        isCommandRunning = false;
                        respData.statusCode = 21;
                        return 21;
                    }
                    if (respData.resData.length == 1 && respData.resData[0] == 0) {
                        isCommandRunning = false;
                        respData.statusCode = 3;
                        return 3;
                    }
                    rt = 9;
                    int len = respData.resData.length;
                    if (len > 11) {
                        rt = respData.resData[11];
                        cmd = respData.resData[10];
                        if (cmd == -18 && rt == -16) break;
                        if (rt != 0) {
                            rt = 9;
                        }
                    }
                }
                if (loopNum >= maxLoopNum || rt == 0 && cmd == 100) continue;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException len) {
                    // empty catch block
                }
            } while (loopNum < maxLoopNum && (rt != 0 || cmd != 100));
            returnCode = this.returnACK(r, respData);
            this.convertIDG(respData, 0);
            respData.statusCode = returnCode;
            if (rt == 0 && cmd == 100) continue;
            isCommandRunning = false;
            try {
                dis.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                return 10;
            }
            return returnCode;
        }
        isCommandRunning = false;
        try {
            dis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return 10;
        }
        return returnCode;
    }

    public int device_rrcConnect() {
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        int cmd = 0;
        int rt = 9;
        isCommandRunning = true;
        this.waitForNotification();
        int loopNum = 0;
        ResDataStruct respData = new ResDataStruct();
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)100, (byte)32, new byte[0])), 0, respData);
            ++loopNum;
            if (r == TaskManager.TaskStartRet.SUCCESS) {
                if (respData.resData == null) {
                    isCommandRunning = false;
                    respData.statusCode = 21;
                    return 21;
                }
                if (respData.resData.length == 1 && respData.resData[0] == 0) {
                    isCommandRunning = false;
                    respData.statusCode = 3;
                    return 3;
                }
                rt = 9;
                int len = respData.resData.length;
                if (len > 11) {
                    rt = respData.resData[11];
                    cmd = respData.resData[10];
                    if (cmd == -18 && rt == -16) break;
                    if (rt != 0) {
                        rt = 9;
                    }
                }
            }
            if (loopNum >= maxLoopNum || rt == 0 && cmd == 100) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException len) {
                // empty catch block
            }
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != 100));
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int device_rrcDisconnect() {
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        int cmd = 0;
        int rt = 9;
        isCommandRunning = true;
        this.waitForNotification();
        int loopNum = 0;
        ResDataStruct respData = new ResDataStruct();
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)100, (byte)33, new byte[0])), 0, respData);
            ++loopNum;
            if (r == TaskManager.TaskStartRet.SUCCESS) {
                if (respData.resData == null) {
                    isCommandRunning = false;
                    respData.statusCode = 21;
                    return 21;
                }
                if (respData.resData.length == 1 && respData.resData[0] == 0) {
                    isCommandRunning = false;
                    respData.statusCode = 3;
                    return 3;
                }
                rt = 9;
                int len = respData.resData.length;
                if (len > 11) {
                    rt = respData.resData[11];
                    cmd = respData.resData[10];
                    if (cmd == -18 && rt == -16) break;
                    if (rt != 0) {
                        rt = 9;
                    }
                }
            }
            if (loopNum >= maxLoopNum || rt == 0 && cmd == 100) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException len) {
                // empty catch block
            }
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != 100));
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public void setfoundBlockedApplication(boolean found) {
        foundBlocked = found;
    }

    public boolean foundBlockedApplication() {
        return foundBlocked;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int icc_getICCReaderStatus(ICCReaderStatusStruct ICCStatus) {
        int ec;
        block22: {
            TaskManager.TaskStartRet r;
            byte dataLen;
            int cmd;
            int rt;
            ResDataStruct respData;
            block21: {
                block20: {
                    if (ICCStatus == null) {
                        return 27392;
                    }
                    if (!readyForNextCommand || !readyForCardSwipe) {
                        return 29696;
                    }
                    if (!this.isICCDeviceSelected() || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
                        return 20;
                    }
                    if (!this.device_isConnected()) {
                        return 1;
                    }
                    respData = new ResDataStruct();
                    isCommandRunning = true;
                    this.waitForNotification();
                    if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) break block20;
                    rt = 9;
                    cmd = 0;
                    dataLen = 0;
                    if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V) {
                        this.waitForVivo();
                    }
                    break block21;
                }
                TaskManager.TaskStartRet r2 = this.sendCommand_helper("724624", 0, respData);
                ec = this.returnACK(r2, respData);
                if (ec == 0) {
                    byte[] buff = respData.resData;
                    if (respData.resData.length > 7) {
                        ICCStatus.resData = new byte[buff.length - 7];
                        System.arraycopy(respData.resData, 4, ICCStatus.resData, 0, respData.resData.length - 7);
                    }
                    byte bt = 0;
                    bt = (byte)(buff[4] & 1);
                    ICCStatus.iccPower = bt == 1;
                    bt = (byte)(buff[4] & 2);
                    ICCStatus.cardSeated = bt == 2;
                }
                break block22;
            }
            int loopNum = 0;
            do {
                r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)96, (byte)20, new byte[]{32})), 0, respData);
                ++loopNum;
                if (r == TaskManager.TaskStartRet.SUCCESS) {
                    if (respData.resData == null) {
                        isCommandRunning = false;
                        return 21;
                    }
                    if (respData.resData.length == 1 && respData.resData[0] == 0) {
                        isCommandRunning = false;
                        return 3;
                    }
                    rt = 9;
                    int len = respData.resData.length;
                    if (len > 13) {
                        rt = respData.resData[11];
                        cmd = respData.resData[10];
                        dataLen = respData.resData[13];
                        if (cmd == -18 && rt == -16) break;
                    }
                }
                if (dataLen == 0) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException len) {
                        // empty catch block
                    }
                }
                if (loopNum >= maxLoopNum || rt == 0 && cmd == 96 && dataLen != 0) continue;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException len) {
                    // empty catch block
                }
            } while (loopNum < maxLoopNum && (rt != 0 || cmd != 96 || dataLen == 0));
            if ((ec = this.returnACK(r, respData)) == 0) {
                if (respData.resData.length > 14 && respData.resData[10] == 96 && respData.resData[11] == 0 && respData.resData[13] == 1) {
                    byte status = respData.resData[14];
                    ICCStatus.iccPower = (status & 1) == 1;
                    ICCStatus.cardSeated = (status & 2) == 2;
                } else {
                    isCommandRunning = false;
                    return 9;
                }
            }
        }
        isCommandRunning = false;
        return ec;
    }

    public int icc_getICCReaderStatus_LEDControl(ICCReaderStatusStruct ICCStatus, Common.EMV_TRANSACTION_STAGE transactionStage) {
        if (!this.isICCDeviceSelected()) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        isCommandRunning = true;
        this.waitForNotification();
        ResDataStruct respData = new ResDataStruct();
        TaskManager.TaskStartRet r = this.sendCommand_helper("724624", 0, respData);
        int ec = this.returnACK(r, respData);
        if (ec == 0) {
            byte[] buff = respData.resData;
            if (respData.resData.length > 7) {
                ICCStatus.resData = new byte[buff.length - 7];
                System.arraycopy(respData.resData, 4, ICCStatus.resData, 0, respData.resData.length - 7);
            }
            byte bt = 0;
            bt = (byte)(buff[4] & 1);
            ICCStatus.iccPower = bt == 1;
            bt = (byte)(buff[4] & 2);
            ICCStatus.cardSeated = bt == 2;
        }
        return ec;
    }

    public int icc_powerOnICC(PowerOnStructure options, ResDataStruct atrPPS) {
        foundBlocked = false;
        return this.icc_powerOnICC(atrPPS);
    }

    public int icc_powerOnICC(ResDataStruct atrPPS) {
        int ec;
        if (atrPPS == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            atrPPS.statusCode = 29696;
            return 29696;
        }
        if (!this.isICCDeviceSelected()) {
            atrPPS.statusCode = 20;
            return 20;
        }
        if (!this.device_isConnected()) {
            atrPPS.statusCode = 1;
            return 1;
        }
        ResDataStruct respData = new ResDataStruct();
        isCommandRunning = true;
        this.waitForNotification();
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
            TaskManager.TaskStartRet r;
            int cmd = 0;
            int rt = 35600;
            if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V) {
                this.waitForVivo();
            }
            int loopNum = 0;
            do {
                int len;
                r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)44, (byte)18, new byte[]{32})), 0, respData);
                ++loopNum;
                int n = len = respData.resData == null ? 0 : respData.resData.length;
                if (len > 11) {
                    rt = respData.resData[11];
                    cmd = respData.resData[10];
                    if (cmd == -18 && rt == -16) break;
                    if (rt != 0) {
                        rt = 35600;
                    }
                }
                if (loopNum >= maxLoopNum || rt == 0 && cmd == 44) continue;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (loopNum < maxLoopNum && (rt != 0 || cmd != 44));
            if ((ec = this.returnACK(r, respData)) == 0 && respData.resData != null && respData.resData.length > 0) {
                atrPPS.resData = new byte[respData.resData.length];
                System.arraycopy(respData.resData, 0, atrPPS.resData, 0, respData.resData.length);
            }
        } else {
            TaskManager.TaskStartRet r;
            if (!(connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA || this.setICCTransactionTimeOut)) {
                this.sendCommand_helper("72530105011E", 0, respData);
                this.setICCTransactionTimeOut = true;
            }
            if ((ec = this.returnACK(r = this.sendCommand_helper("72466e", 0, respData), respData)) == 0) {
                int i = 0;
                byte[] buff = respData.resData;
                int len = respData.resData.length;
                atrPPS.resData = new byte[len - 7];
                for (i = 4; i < len - 3; ++i) {
                    atrPPS.resData[i - 4] = buff[i];
                }
            }
        }
        isCommandRunning = false;
        atrPPS.statusCode = ec;
        return ec;
    }

    private int icc_powerOnICCforAPDU() {
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (!this.isICCDeviceSelected()) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        ResDataStruct respData = new ResDataStruct();
        this.waitForNotification();
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
            TaskManager.TaskStartRet r;
            int cmd = 0;
            int rt = 35600;
            if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V) {
                this.waitForVivo();
            }
            int loopNum = 0;
            if (this.icc_passthroughOnICCforAPDU() != 0) {
                return 35600;
            }
            do {
                int len;
                r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)44, (byte)18, new byte[]{32})), 0, respData);
                ++loopNum;
                int n = len = respData.resData == null ? 0 : respData.resData.length;
                if (len > 11) {
                    rt = respData.resData[11];
                    cmd = respData.resData[10];
                    if (cmd == -18 && rt == -16) break;
                    if (rt != 0) {
                        rt = 35600;
                    }
                }
                if (loopNum >= maxLoopNum || rt == 0 && cmd == 44) continue;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (loopNum < maxLoopNum && (rt != 0 || cmd != 44));
            return this.returnACK(r, respData);
        }
        TaskManager.TaskStartRet r = this.sendCommand_helper("72466e", 0, respData);
        int ec = this.returnACK(r, respData);
        if (ec == 0) {
            int i = 0;
            byte[] buff = respData.resData;
            int len = respData.resData.length;
            respData.resData = new byte[len - 7];
            for (i = 4; i < len - 3; ++i) {
                respData.resData[i - 4] = buff[i];
            }
        }
        return ec;
    }

    public int icc_getATR() {
        if (!this.device_isConnected()) {
            return 1;
        }
        ResDataStruct respData = new ResDataStruct();
        int cmd = 0;
        int rt = 9;
        TaskManager.TaskStartRet r = null;
        isCommandRunning = true;
        this.waitForNotification();
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V) {
            this.waitForVivo();
        }
        for (int i = 0; i < 3; ++i) {
            int len;
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)44, (byte)18, new byte[]{32})), 0, respData);
            int n = len = respData.resData == null ? 0 : respData.resData.length;
            if (len > 11) {
                rt = respData.resData[11];
                cmd = respData.resData[10];
                if (cmd == -18 && rt == -16) break;
                if (rt != 0) {
                    rt = 9;
                }
            }
            if (rt == 0 && cmd == 44) break;
        }
        isCommandRunning = false;
        return this.returnACK(r, respData);
    }

    public int icc_powerOffICC() {
        ResDataStruct respData = new ResDataStruct();
        return this.icc_powerOffICC(respData);
    }

    public int icc_powerOffICC(ResDataStruct respData) {
        int ec;
        TaskManager.TaskStartRet r;
        block10: {
            block11: {
                if (respData == null) {
                    return 27392;
                }
                if (!readyForNextCommand || !readyForCardSwipe) {
                    respData.statusCode = 29696;
                    return 29696;
                }
                if (!this.isICCDeviceSelected()) {
                    respData.statusCode = 20;
                    return 20;
                }
                if (!this.device_isConnected()) {
                    respData.statusCode = 1;
                    return 1;
                }
                isCommandRunning = true;
                this.waitForNotification();
                if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) break block11;
                byte cmd = 0;
                int rt = 35600;
                if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V) {
                    this.waitForVivo();
                }
                int loopNum = 0;
                do {
                    int len;
                    r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)44, (byte)24, new byte[]{32})), 0, respData);
                    ++loopNum;
                    int n = len = respData.resData == null ? 0 : respData.resData.length;
                    if (len > 11) {
                        cmd = respData.resData[10];
                        rt = respData.resData[11];
                        if (cmd == -18 && rt == -16) break block10;
                    }
                    if (loopNum >= maxLoopNum || rt == 0 && cmd == 44) continue;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while (loopNum < maxLoopNum && (rt != 0 || cmd != 44));
                break block10;
                {
                }
            }
            r = this.sendCommand_helper("72464d", 0, respData);
        }
        isCommandRunning = false;
        respData.statusCode = ec = this.returnACK(r, respData);
        return ec;
    }

    private int icc_powerOffICCforAPDU() {
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (!this.isICCDeviceSelected()) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        ResDataStruct respData = new ResDataStruct();
        this.waitForNotification();
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
            byte cmd = 0;
            int rt = 35600;
            int loopNum = 0;
            do {
                int len;
                r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)44, (byte)24, new byte[]{32})), 0, respData);
                ++loopNum;
                int n = len = respData.resData == null ? 0 : respData.resData.length;
                if (len > 11) {
                    cmd = respData.resData[10];
                    rt = respData.resData[11];
                    if (cmd == -18 && rt == -16) break;
                }
                if (loopNum >= maxLoopNum || rt == 0 && cmd == 44) continue;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (loopNum < maxLoopNum && (rt != 0 || cmd != 44));
            if (cmd != -18 || rt != -16) {
                this.icc_passthroughOffICCforAPDU();
            }
        } else {
            r = this.sendCommand_helper("72464d", 0, respData);
        }
        return this.returnACK(r, respData);
    }

    public int icc_passthroughOnICC() {
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VENDI && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        isCommandRunning = true;
        this.waitForNotification();
        ResDataStruct respData = new ResDataStruct();
        int loopNum = 0;
        byte cmd = 0;
        int rt = 9;
        do {
            int len;
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)44, (byte)1, new byte[]{1})), 0, respData);
            ++loopNum;
            int n = len = respData.resData == null ? 0 : respData.resData.length;
            if (len > 11) {
                cmd = respData.resData[10];
                rt = respData.resData[11];
                if (cmd == -18 && rt == -16) break;
            }
            if (loopNum >= maxLoopNum || rt == 0 && cmd == 44) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != 44));
        isCommandRunning = false;
        int ec = this.returnACK(r, respData);
        if (ec == 0) {
            isPassthroughModeOn = true;
        }
        return ec;
    }

    public int icc_passthroughOnICCforAPDU() {
        int ec;
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VENDI && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        this.waitForNotification();
        ResDataStruct respData = new ResDataStruct();
        int loopNum = 0;
        byte cmd = 0;
        int rt = 9;
        do {
            int len;
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)44, (byte)1, new byte[]{1})), 0, respData);
            ++loopNum;
            int n = len = respData.resData == null ? 0 : respData.resData.length;
            if (len > 11) {
                cmd = respData.resData[10];
                rt = respData.resData[11];
                if (cmd == -18 && rt == -16) break;
            }
            if (loopNum >= maxLoopNum || rt == 0 && cmd == 44) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != 44));
        if ((ec = this.returnACK(r, respData)) == 0) {
            isPassthroughModeOn = true;
        }
        return ec;
    }

    public int icc_passthroughOffICC() {
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VENDI && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        isCommandRunning = true;
        this.waitForNotification();
        ResDataStruct respData = new ResDataStruct();
        int loopNum = 0;
        byte cmd = 0;
        int rt = 9;
        do {
            int len;
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)44, (byte)1, new byte[]{0})), 0, respData);
            ++loopNum;
            int n = len = respData.resData == null ? 0 : respData.resData.length;
            if (len > 11) {
                cmd = respData.resData[10];
                rt = respData.resData[11];
                if (cmd == -18 && rt == -16) break;
            }
            if (loopNum >= maxLoopNum || rt == 0 && cmd == 44) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != 44));
        isCommandRunning = false;
        int ec = this.returnACK(r, respData);
        if (ec == 0) {
            isPassthroughModeOn = false;
        }
        return ec;
    }

    public int icc_passthroughOffICCforAPDU() {
        int ec;
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VENDI && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        this.waitForNotification();
        ResDataStruct respData = new ResDataStruct();
        int loopNum = 0;
        byte cmd = 0;
        int rt = 9;
        do {
            int len;
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)44, (byte)1, new byte[]{0})), 0, respData);
            ++loopNum;
            int n = len = respData.resData == null ? 0 : respData.resData.length;
            if (len > 11) {
                cmd = respData.resData[10];
                rt = respData.resData[11];
                if (cmd == -18 && rt == -16) break;
            }
            if (loopNum >= maxLoopNum || rt == 0 && cmd == 44) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != 44));
        if ((ec = this.returnACK(r, respData)) == 0) {
            isPassthroughModeOn = false;
        }
        return ec;
    }

    public int device_pollForToken(int timeout, ResDataStruct respData) {
        int ec;
        TaskManager.TaskStartRet r;
        if (respData == null || timeout <= 0 || timeout / 1000 > 255) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            respData.statusCode = 29696;
            return 29696;
        }
        if (!this.device_isConnected()) {
            respData.statusCode = 1;
            return 1;
        }
        isCommandRunning = true;
        this.waitForNotification();
        byte cmd = 0;
        int rt = 9;
        int loopNum = 0;
        int seconds = timeout / 1000 + 1;
        if (timeout % 1000 != 0) {
            ++seconds;
        }
        byte[] data = new byte[]{(byte)(timeout / 1000), (byte)(timeout % 1000 / 10)};
        do {
            int len;
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)44, (byte)2, data)), seconds, respData);
            ++loopNum;
            int n = len = respData.resData == null ? 0 : respData.resData.length;
            if (len <= 11) continue;
            cmd = respData.resData[10];
            rt = respData.resData[11];
            if (cmd == -18 && rt == -16) break;
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != 44));
        isCommandRunning = false;
        respData.statusCode = ec = this.returnACK(r, respData);
        return ec;
    }

    public int config_getDateTime(StringBuilder dateTime) {
        if (dateTime == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        isCommandRunning = true;
        this.waitForNotification();
        ResDataStruct respData = new ResDataStruct();
        TaskManager.TaskStartRet r = this.sendCommand_helper("78520150", 0, respData);
        if (r == TaskManager.TaskStartRet.SUCCESS) {
            if (respData.resData.length == 1 && respData.resData[0] == 0) {
                isCommandRunning = false;
                return 3;
            }
            int check = Common.Response.checkACK(respData.resData);
            if (1 == check) {
                String ver = new String();
                byte[] buff = respData.resData;
                int len = respData.resData.length;
                for (int i = 8; i < len - 3; ++i) {
                    String temp = String.format(Locale.US, "%02x", buff[i]);
                    ver = ver + temp;
                }
                dateTime.append(ver);
                isCommandRunning = false;
                return 0;
            }
            if (0 == check) {
                isCommandRunning = false;
                return Common.Response.ErrorCode(respData.resData);
            }
            isCommandRunning = false;
            return 9;
        }
        isCommandRunning = false;
        return this.returnResult(r);
    }

    public int config_setLEDControl(byte MSRLedOption, byte ICCLedOption) {
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        isCommandRunning = true;
        this.waitForNotification();
        ResDataStruct respData = new ResDataStruct();
        byte[] options = new byte[]{MSRLedOption, ICCLedOption};
        String op = Common.getHexStringFromBytes(options);
        TaskManager.TaskStartRet r = this.sendCommand_helper("7853011108" + op + "000000000000", 0, respData);
        isCommandRunning = false;
        return this.returnACK(r, respData);
    }

    public int config_setLEDController(boolean firmwareControlMSRLED, boolean firmwareControlICCLED) {
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        isCommandRunning = true;
        this.waitForNotification();
        ResDataStruct respData = new ResDataStruct();
        byte[] options = new byte[]{firmwareControlMSRLED ? (byte)0 : 1, firmwareControlICCLED ? (byte)0 : 1};
        String op = Common.getHexStringFromBytes(options);
        TaskManager.TaskStartRet r = this.sendCommand_helper("7853011108" + op + "000000000000", 0, respData);
        isCommandRunning = false;
        return this.returnACK(r, respData);
    }

    public int config_getLEDController(ResDataStruct respData) {
        if (respData == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            respData.statusCode = 29696;
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA) {
            respData.statusCode = 20;
            return 20;
        }
        if (!this.device_isConnected()) {
            respData.statusCode = 1;
            return 1;
        }
        isCommandRunning = true;
        this.waitForNotification();
        TaskManager.TaskStartRet r = this.sendCommand_helper("78520111", 0, respData);
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int config_setBeeperControl(byte BeeperOption) {
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        isCommandRunning = true;
        this.waitForNotification();
        ResDataStruct respData = new ResDataStruct();
        String op = BeeperOption == 0 ? "00" : "01";
        TaskManager.TaskStartRet r = this.sendCommand_helper("7853011204" + op + "000000", 0, respData);
        isCommandRunning = false;
        return this.returnACK(r, respData);
    }

    public int config_setBeeperController(boolean firmwareControlBeeper) {
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        isCommandRunning = true;
        this.waitForNotification();
        ResDataStruct respData = new ResDataStruct();
        String op = firmwareControlBeeper ? "00" : "01";
        TaskManager.TaskStartRet r = this.sendCommand_helper("7853011204" + op + "000000", 0, respData);
        isCommandRunning = false;
        return this.returnACK(r, respData);
    }

    public int config_getBeeperControl(ResDataStruct respData) {
        if (respData == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            respData.statusCode = 29696;
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA) {
            respData.statusCode = 20;
            return 20;
        }
        if (!this.device_isConnected()) {
            respData.statusCode = 1;
            return 1;
        }
        isCommandRunning = true;
        this.waitForNotification();
        TaskManager.TaskStartRet r = this.sendCommand_helper("78520112", 0, respData);
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int config_beepersControl(int beeperIndex, int frequency, int duration) {
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        isCommandRunning = true;
        this.waitForNotification();
        ResDataStruct respData = new ResDataStruct();
        byte[] bepperControl = new byte[]{(byte)beeperIndex, (byte)(frequency >> 8), (byte)(frequency & 0xFF), (byte)(duration >> 8), (byte)(duration & 0xFF)};
        String bc = Common.getHexStringFromBytes(bepperControl);
        TaskManager.TaskStartRet r = this.sendCommand_helper("784604" + bc, 0, respData);
        isCommandRunning = false;
        return this.returnACK(r, respData);
    }

    public int config_getEncryptionControl(ResDataStruct respData) {
        if (respData == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            respData.statusCode = 29696;
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II) {
            respData.statusCode = 20;
            return 20;
        }
        if (!this.device_isConnected()) {
            respData.statusCode = 1;
            return 1;
        }
        isCommandRunning = true;
        this.waitForNotification();
        TaskManager.TaskStartRet r = this.sendCommand_helper("78520107", 0, respData);
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        if (returnCode == 0) {
            respData.encryptionOption = respData.resData[4];
        }
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int config_setEncryptionControl(byte Encryption) {
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        isCommandRunning = true;
        this.waitForNotification();
        ResDataStruct respData = new ResDataStruct();
        TaskManager.TaskStartRet r = this.sendCommand_helper("7853010702" + String.format(Locale.US, "%02X", Encryption) + "00", 0, respData);
        isCommandRunning = false;
        return this.returnACK(r, respData);
    }

    public int config_setEncryptionControl(boolean msr, boolean icc) {
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        isCommandRunning = true;
        this.waitForNotification();
        byte Encryption = 0;
        if (msr) {
            Encryption = (byte)(Encryption | 1);
        }
        if (icc) {
            Encryption = (byte)(Encryption | 2);
        }
        ResDataStruct respData = new ResDataStruct();
        TaskManager.TaskStartRet r = this.sendCommand_helper("7853010702" + String.format(Locale.US, "%02X", Encryption) + "00", 0, respData);
        isCommandRunning = false;
        return this.returnACK(r, respData);
    }

    public int config_setBLEParameters(String url, String uid, String nameSpaceId, String instanceId) {
        TaskManager.TaskStartRet r;
        int instanceIdLen;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP2000) {
            return 20;
        }
        int urlLen = url == null ? 0 : url.length();
        int uidLen = uid == null ? 0 : uid.length();
        int nameSpaceIdLen = nameSpaceId == null ? 0 : nameSpaceId.length();
        int n = instanceIdLen = instanceId == null ? 0 : instanceId.length();
        if (urlLen > 255 || uidLen > 255 || nameSpaceIdLen > 255 || instanceIdLen > 255) {
            return 27392;
        }
        byte[] tmp = new byte[1];
        String cmdDataStr = "9F60";
        tmp[0] = (byte)urlLen;
        cmdDataStr = cmdDataStr + Common.base16Encode(tmp);
        cmdDataStr = cmdDataStr + Common.asciiToHex(url);
        cmdDataStr = cmdDataStr + "9F61";
        tmp[0] = (byte)uidLen;
        cmdDataStr = cmdDataStr + Common.base16Encode(tmp);
        cmdDataStr = cmdDataStr + Common.asciiToHex(uid);
        cmdDataStr = cmdDataStr + "9F62";
        tmp[0] = (byte)nameSpaceIdLen;
        cmdDataStr = cmdDataStr + Common.base16Encode(tmp);
        cmdDataStr = cmdDataStr + Common.asciiToHex(nameSpaceId);
        cmdDataStr = cmdDataStr + "9F63";
        tmp[0] = (byte)instanceIdLen;
        cmdDataStr = cmdDataStr + Common.base16Encode(tmp);
        cmdDataStr = cmdDataStr + Common.asciiToHex(instanceId);
        byte[] data = Common.getByteArray(cmdDataStr);
        isCommandRunning = true;
        ResDataStruct respData = new ResDataStruct();
        int loopNum = 0;
        byte cmd = 0;
        int rt = 9;
        do {
            int len;
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-57, (byte)97, data)), 0, respData);
            ++loopNum;
            int n2 = len = respData.resData == null ? 0 : respData.resData.length;
            if (len <= 11) continue;
            cmd = respData.resData[10];
            rt = respData.resData[11];
            if (cmd == -18 && rt == -16) break;
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != -57));
        isCommandRunning = false;
        int ec = this.returnACK(r, respData);
        return ec;
    }

    public int config_setLongTermPrivateKey(byte[] encryptedKeyData, byte[] plainDataHash) {
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP2000) {
            return 20;
        }
        if (encryptedKeyData == null || plainDataHash == null || encryptedKeyData.length != 256 || plainDataHash.length != 32) {
            return 27392;
        }
        isCommandRunning = true;
        ResDataStruct respData = new ResDataStruct();
        byte[] data = new byte[288];
        System.arraycopy(encryptedKeyData, 0, data, 0, 256);
        System.arraycopy(plainDataHash, 0, data, 256, 32);
        int loopNum = 0;
        byte cmd = 0;
        int rt = 9;
        do {
            int len;
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-57, (byte)98, data)), 0, respData);
            ++loopNum;
            int n = len = respData.resData == null ? 0 : respData.resData.length;
            if (len <= 11) continue;
            cmd = respData.resData[10];
            rt = respData.resData[11];
            if (cmd == -18 && rt == -16) break;
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != -57));
        isCommandRunning = false;
        int ec = this.returnACK(r, respData);
        return ec;
    }

    public int device_getBatteryVoltage(StringBuilder batteryInfo) {
        if (batteryInfo == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        ResDataStruct respData = new ResDataStruct();
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT) {
            TaskManager.TaskStartRet r;
            isCommandRunning = true;
            this.waitForNotification();
            int loopNum = 0;
            byte cmd = 0;
            int rt = 9;
            do {
                int len;
                r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-16, (byte)2, new byte[]{1})), 0, respData);
                ++loopNum;
                int n = len = respData.resData == null ? 0 : respData.resData.length;
                if (len > 11) {
                    cmd = respData.resData[10];
                    rt = respData.resData[11];
                    if (cmd == -18 && rt == -16) break;
                }
                if (rt != 0 || len <= 14) continue;
                float volt = (respData.resData[15] & 0xFF) * 256 + (respData.resData[14] & 0xFF);
                volt = (float)((double)volt / 1000.0);
                batteryInfo.append(Float.toString(volt));
            } while (loopNum < maxLoopNum && (rt != 0 || cmd != -16));
            isCommandRunning = false;
            int ec = this.returnACK(r, respData);
            return ec;
        }
        TaskManager.TaskStartRet r = this.sendCommand_helper("784605", 0, respData);
        if (r == TaskManager.TaskStartRet.SUCCESS) {
            if (respData.resData == null) {
                return 21;
            }
            if (respData.resData.length == 1 && respData.resData[0] == 0) {
                return 3;
            }
            int check = Common.Response.checkACK(respData.resData);
            if (1 == check) {
                byte[] buff = respData.resData;
                int len = respData.resData.length;
                String ver = new String();
                if (buff[4] == 48) {
                    for (int i = 5; i < len - 3; ++i) {
                        String temp = String.format(Locale.US, "%c", buff[i]);
                        ver = ver + temp;
                        if (i != 5) continue;
                        ver = ver + ".";
                    }
                } else {
                    for (int i = 4; i < len - 3; ++i) {
                        String temp = String.format(Locale.US, "%c", buff[i]);
                        ver = ver + temp;
                        if (i != 5) continue;
                        ver = ver + ".";
                    }
                }
                batteryInfo.append(ver);
                return 0;
            }
            if (0 == check) {
                return Common.Response.ErrorCode(respData.resData);
            }
            return 9;
        }
        return this.returnResult(r);
    }

    public int device_getBatteryPercentage(StringBuilder percentage) {
        TaskManager.TaskStartRet r;
        if (percentage == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        isCommandRunning = true;
        this.waitForNotification();
        ResDataStruct respData = new ResDataStruct();
        int loopNum = 0;
        byte cmd = 0;
        int rt = 9;
        do {
            int len;
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-16, (byte)2, new byte[0])), 0, respData);
            ++loopNum;
            int n = len = respData.resData == null ? 0 : respData.resData.length;
            if (len > 11) {
                cmd = respData.resData[10];
                rt = respData.resData[11];
                if (cmd == -18 && rt == -16) break;
            }
            if (rt != 0 || len <= 13) continue;
            int per = respData.resData[14] & 0xFF;
            percentage.append(Integer.toString(per));
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != -16));
        isCommandRunning = false;
        int ec = this.returnACK(r, respData);
        return ec;
    }

    public int device_rebootDevice() {
        TaskManager.TaskStartRet r;
        ResDataStruct respData;
        block8: {
            block9: {
                if (!readyForNextCommand || !readyForCardSwipe) {
                    return 29696;
                }
                if (!this.device_isConnected()) {
                    return 1;
                }
                if (!(this.isICCDeviceSelected() && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VENDI && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM || _isTTK)) {
                    return 20;
                }
                isCommandRunning = true;
                this.waitForNotification();
                respData = new ResDataStruct();
                if (!_isTTK || connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB) break block9;
                byte cmd = 0;
                int rt = 9;
                int loopNum = 0;
                do {
                    int len;
                    r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)119, (byte)5, new byte[0])), 0, respData);
                    ++loopNum;
                    int n = len = respData.resData == null ? 0 : respData.resData.length;
                    if (len > 11) {
                        cmd = respData.resData[10];
                        rt = respData.resData[11];
                        if (cmd == -18 && rt == -16) break block8;
                    }
                    if (loopNum >= maxLoopNum || rt == 0 && cmd == 119) continue;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while (loopNum < maxLoopNum && (rt != 0 || cmd != 119));
                break block8;
                {
                }
            }
            r = this.sendCommand_helper("784649", 0, respData);
        }
        isCommandRunning = false;
        return this.returnACK(r, respData);
    }

    public int device_sendCommandDirectIO(String hexCommand, ResDataStruct respData) {
        int ec;
        if (respData == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            respData.statusCode = 29696;
            return 29696;
        }
        if (!this.device_isConnected()) {
            respData.statusCode = 1;
            return 1;
        }
        if (hexCommand == null || hexCommand.length() > 4096) {
            respData.statusCode = 27392;
            return 27392;
        }
        if (!this.isICCDeviceSelected() || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
            respData.statusCode = 20;
            return 20;
        }
        isCommandRunning = true;
        this.waitForNotification();
        hexCommand = hexCommand.replaceAll(" ", "");
        TaskManager.TaskStartRet r = this.sendCommand_helper(hexCommand, 0, respData);
        isCommandRunning = false;
        respData.statusCode = ec = this.returnACK(r, respData);
        return ec;
    }

    public int device_sendDataCommand(String cmd, boolean calcLRC, String data, ResDataStruct respData) {
        return this.device_sendDataCommand(cmd, calcLRC, data, respData, 0);
    }

    public int device_sendDataCommand(String cmd, boolean calcLRC, String data, ResDataStruct respData, int timeout) {
        TaskManager.TaskStartRet r;
        block42: {
            byte[] bytesCmd;
            block43: {
                if (respData == null) {
                    return 27392;
                }
                if (!readyForNextCommand || !readyForCardSwipe) {
                    respData.statusCode = 29696;
                    return 29696;
                }
                if (!this.device_isConnected()) {
                    respData.statusCode = 1;
                    return 1;
                }
                if (cmd == null || cmd.length() > 4064) {
                    respData.statusCode = 27392;
                    return 27392;
                }
                if (data != null && data.length() > 8160) {
                    respData.statusCode = 27392;
                    return 27392;
                }
                cmd = cmd.toUpperCase(Locale.US);
                isCommandRunning = true;
                this.waitForNotification();
                bytesCmd = Common.hexStringToByteArray(cmd);
                if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VENDI && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) break block43;
                byte[] bytesData = new byte[]{};
                if (data != null && data.length() > 0) {
                    bytesData = Common.hexStringToByteArray(data);
                }
                int loopNum = 0;
                byte tmp = 0;
                int rt = 9;
                if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB) {
                    if (bytesCmd[0] == 119 && bytesCmd[1] == 5) {
                        timeout = 1;
                    }
                    do {
                        r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command(bytesCmd[0], bytesCmd[1], bytesData)), timeout, respData);
                        ++loopNum;
                        if (r == TaskManager.TaskStartRet.SUCCESS) {
                            if (respData.resData == null) {
                                isCommandRunning = false;
                                respData.statusCode = 21;
                                return 21;
                            }
                            if (respData.resData.length == 1 && respData.resData[0] == 0) {
                                isCommandRunning = false;
                                respData.statusCode = 3;
                                return 3;
                            }
                            rt = 9;
                            int len = respData.resData.length;
                            if (len > 11) {
                                rt = respData.resData[11];
                                tmp = respData.resData[10];
                                if (tmp == -18 && rt == -16) break;
                            }
                        }
                        if (loopNum >= maxLoopNum || (rt == 0 || rt == 99) && tmp == bytesCmd[0]) continue;
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException len) {
                            // empty catch block
                        }
                    } while (loopNum < maxLoopNum && (rt != 0 && rt != 99 || tmp != bytesCmd[0]));
                    if (respData.resData == null) {
                        isCommandRunning = false;
                        respData.statusCode = 21;
                        return 21;
                    }
                    int dataLen = (respData.resData[12] & 0xFF) * 256 + (respData.resData[13] & 0xFF);
                    while (rt == 99) {
                        long startTime = System.currentTimeMillis();
                        ResDataStruct temp = new ResDataStruct();
                        if (this.isBluetoothLEDeviceSelected()) {
                            _btle.readMessage(1, startTime, temp, true);
                        } else {
                            _usb.readMessage(1, startTime, temp, true);
                        }
                        if (respData.resData.length <= 14) continue;
                        if (temp.resData == null || temp.resData.length <= 11) {
                            return 10;
                        }
                        rt = temp.resData[11];
                        UMLog.i("device_sendDataCommand", "rt: " + rt);
                        int len = (temp.resData[12] & 0xFF) * 256 + (temp.resData[13] & 0xFF);
                        UMLog.i("device_sendDataCommand", "len: " + len);
                        respData.resData[11] = temp.resData[11];
                        if (len <= 0) continue;
                        UMLog.i("device_sendDataCommand", "dataLen: " + (dataLen += len));
                        respData.resData[12] = (byte)(dataLen >> 8 & 0xFF);
                        respData.resData[13] = (byte)(dataLen & 0xFF);
                        byte[] tmpData = new byte[dataLen + 16];
                        try {
                            System.arraycopy(respData.resData, 0, tmpData, 0, respData.resData.length - 2);
                            System.arraycopy(temp.resData, 14, tmpData, respData.resData.length - 2, len);
                            respData.resData = new byte[tmpData.length];
                            System.arraycopy(tmpData, 0, respData.resData, 0, tmpData.length);
                        }
                        catch (ArrayStoreException e) {
                            return 9;
                        }
                    }
                } else {
                    do {
                        r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command(bytesCmd[0], bytesCmd[1], bytesData)), timeout, respData);
                        ++loopNum;
                        if (r == TaskManager.TaskStartRet.SUCCESS) {
                            if (respData.resData == null) {
                                isCommandRunning = false;
                                respData.statusCode = 21;
                                return 21;
                            }
                            if (respData.resData.length == 1 && respData.resData[0] == 0) {
                                isCommandRunning = false;
                                respData.statusCode = 3;
                                return 3;
                            }
                            rt = 9;
                            int len = respData.resData.length;
                            if (len > 11) {
                                rt = respData.resData[11];
                                tmp = respData.resData[10];
                                if (tmp == -18 && rt == -16) break block42;
                                if (rt != 0) {
                                    rt = 9;
                                }
                            }
                        }
                        if (loopNum >= maxLoopNum || rt == 0 && tmp == bytesCmd[0]) continue;
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    } while (loopNum < maxLoopNum && (rt != 0 || tmp != bytesCmd[0]));
                }
                break block42;
                {
                }
            }
            if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_BTMAG) {
                r = this.sendCommand_helper(cmd, timeout, respData);
            } else if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG_KB) {
                r = this.sendCommand_helper(cmd, 18, respData);
            } else if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIMAG) {
                if (calcLRC) {
                    String lrc = Common.getLRC(cmd);
                    cmd = cmd + lrc;
                }
                r = this.sendCommand_helper(cmd, timeout, respData);
            } else {
                String command = cmd;
                if (!calcLRC) {
                    if (bytesCmd[0] != 2 || bytesCmd[bytesCmd.length - 1] != 3) {
                        respData.statusCode = 27136;
                        return 27136;
                    }
                    byte[] bytesCmdNoLRC = new byte[bytesCmd.length - 6];
                    System.arraycopy(bytesCmd, 3, bytesCmdNoLRC, 0, bytesCmd.length - 6);
                    command = Common.base16Encode(bytesCmdNoLRC);
                }
                r = this.sendCommand_helper(command, timeout, respData);
            }
        }
        int returnCode = this.returnACK(r, respData);
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG_KB) {
            this.convertIDG(respData, 0);
        }
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public String device_getResponseCodeString(int errorCode) {
        return ErrorCodeInfo.getErrorCodeDescription(errorCode);
    }

    private static void cdolPanTag(byte[] bytes) {
        int vlen = bytes.length;
        int position = 0;
        int combinedLength = 0;
        int currentTagPos = 0;
        byte[] currentTag = new byte[10];
        while (position < vlen) {
            int tagLength;
            if ((bytes[position] & 0xFF & 0x1F) == 31) {
                currentTag[currentTagPos++] = bytes[position++];
                do {
                    currentTag[currentTagPos++] = bytes[position++];
                } while ((bytes[position - 1] & 0xFF & 0x80) == 128);
            } else {
                currentTag[currentTagPos++] = bytes[position++];
            }
            if ((bytes[position] & 0xFF & 0x80) != 128) {
                tagLength = bytes[position++];
            } else {
                switch (bytes[position] & 0xFF & 3) {
                    case 3: {
                        tagLength = (bytes[position + 1] & 0xFF) * 65536 + (bytes[position + 2] & 0xFF) * 256 + (bytes[position + 3] & 0xFF);
                        position += 4;
                        break;
                    }
                    case 2: {
                        tagLength = (bytes[position + 1] & 0xFF) * 256 + (bytes[position + 2] & 0xF);
                        position += 3;
                        break;
                    }
                    case 1: {
                        tagLength = bytes[position + 1] & 0xFF;
                        position += 2;
                        break;
                    }
                    default: {
                        tagLength = bytes[position] & 0xFF;
                        ++position;
                    }
                }
            }
            if ((currentTag[0] & 0xFF) == 90) {
                cdolLen = tagLength;
                cdolPos = combinedLength;
                return;
            }
            combinedLength += tagLength;
            currentTag = new byte[10];
            currentTagPos = 0;
        }
        cdolLen = -1;
        cdolPos = -1;
    }

    private String checkForCDOL(String uniPayCmd, byte[] dataAPDU) {
        int x;
        boolean fail;
        UMLog.i("EMV_KERNEL", "CHECK FOR CDOL=====================");
        UMLog.i("EMV_KERNEL", "CDOL1: " + Common.getHexStringFromBytes(CDOL1));
        UMLog.i("EMV_KERNEL", "CDOL2: " + Common.getHexStringFromBytes(CDOL2));
        UMLog.i("EMV_KERNEL", "dataAPDU: " + Common.getHexStringFromBytes(dataAPDU));
        if (CDOL1 != null) {
            IDT_Device.cdolPanTag(CDOL1);
            if (cdolPos > -1 && dataAPDU.length > 5 + cdolPos + cdolLen) {
                fail = false;
                for (x = 0; x < cdolLen; ++x) {
                    fail |= (dataAPDU[5 + cdolPos + x] & 0xFF) != 255;
                }
                if (!fail) {
                    byte[] pos = new byte[]{(byte)cdolPos};
                    uniPayCmd = "724665" + Common.getHexStringFromBytes(pos);
                    return uniPayCmd;
                }
            }
        }
        if (CDOL2 != null) {
            IDT_Device.cdolPanTag(CDOL2);
            if (cdolPos > -1 && dataAPDU.length > 5 + cdolPos + cdolLen) {
                fail = false;
                for (x = 0; x < cdolLen; ++x) {
                    fail |= dataAPDU[5 + cdolPos + x] != 255;
                }
                if (!fail) {
                    byte[] pos = new byte[]{(byte)cdolPos};
                    uniPayCmd = "724665" + Common.getHexStringFromBytes(pos);
                    return uniPayCmd;
                }
            }
        }
        return uniPayCmd;
    }

    public void cancelCurrentCommand() {
        this.taskManager.cancelCurrentCommand();
    }

    public int icc_exchangeAPDU(byte[] dataAPDU, APDUResponseStruct response) {
        int ec;
        if (response == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (dataAPDU == null || dataAPDU.length > 2032) {
            return 27392;
        }
        if ((!this.isICCDeviceSelected() || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA) && (_isTTK || _isSRED || _isThales)) {
            return 20;
        }
        if (_isTTK) {
            return 20;
        }
        isCommandRunning = true;
        this.waitForNotification();
        ResDataStruct respData = new ResDataStruct();
        TaskManager.TaskStartRet r = null;
        String uniPayCmd = "724641";
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_BTPAY || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_BTPAY_USB) {
            uniPayCmd = "724661";
        }
        boolean isREAD_RECORD = false;
        if (this.executingUniPayEMV && this.encryptedUniPay) {
            uniPayCmd = "72466400";
            if (dataAPDU.length == 5) {
                if (dataAPDU[0] == 0) {
                    if (dataAPDU[1] == -78) {
                        uniPayCmd = "72466401";
                        if (!wasReadRecord) {
                            CDOL1 = null;
                            CDOL2 = null;
                        }
                        isREAD_RECORD = true;
                        wasReadRecord = true;
                        UMLog.i("EMV_KERNEL", "READ TAGS=====================");
                    } else {
                        wasReadRecord = false;
                    }
                }
            } else if (dataAPDU[0] == -128 && dataAPDU[1] == -82) {
                uniPayCmd = this.checkForCDOL(uniPayCmd, dataAPDU);
            }
        }
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_BTPAY || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_BTPAY_USB) {
            UMLog.i("EMV_KERNEL", "C-APDU ICC Original Command: " + uniPayCmd + Common.getHexStringFromBytes(dataAPDU));
            r = this.sendCommand_helper(uniPayCmd + Common.getHexStringFromBytes(dataAPDU), 0, respData);
            String apdu = null;
            if (r == TaskManager.TaskStartRet.SUCCESS) {
                apdu = Common.getHexStringFromBytes(respData.resData);
            }
            UMLog.i("EMV_KERNEL", "R-APDU ICC Original Response: " + apdu);
        }
        if ((ec = this.returnACK(r, respData)) == 0) {
            int length;
            if (respData.resData.length > 2) {
                response.SW1 = respData.resData[respData.resData.length - 5];
                response.SW2 = respData.resData[respData.resData.length - 4];
                if (response.SW1 == 98 && response.SW2 == -125) {
                    UMLog.i("EMV_KERNEL", "BLOCKED APPLICATION FOUND");
                    foundBlocked = true;
                }
            }
            byte[] buff = respData.resData;
            int len = respData.resData.length;
            int i = 0;
            if (buff[4] == 0 || buff[4] == 2) {
                length = len - 8;
                response.response = new byte[length];
                for (i = 5; i < len - 3; ++i) {
                    response.response[i - 5] = buff[i];
                }
                if (this.executingUniPayEMV && this.encryptedUniPay && isREAD_RECORD) {
                    byte[] theResponse = this.parseR_APDU(response.response);
                    response.response = new byte[theResponse.length];
                    for (int x = 0; x < theResponse.length; ++x) {
                        response.response[x] = theResponse[x];
                    }
                }
                response.ksn = new byte[0];
                response.hasKSN = false;
                response.hasEncryption = false;
                response.SW1 = 0;
                response.SW2 = 0;
            }
            if (buff[4] == 1) {
                response.hasKSN = false;
                response.hasEncryption = true;
                if (buff[5] == 10) {
                    response.hasKSN = true;
                    response.ksn = new byte[10];
                    for (i = 6; i < 16; ++i) {
                        response.ksn[i - 6] = buff[i];
                    }
                    length = len - 16 - 3 - 2;
                    response.response = new byte[length];
                    for (i = 0; i < length; ++i) {
                        response.response[i] = buff[i + 16];
                    }
                    response.SW1 = buff[len - 5];
                    response.SW2 = buff[len - 4];
                } else {
                    response.ksn = new byte[0];
                    length = len - 6 - 3 - 2;
                    response.response = new byte[length];
                    for (i = 0; i < length; ++i) {
                        response.response[i] = buff[i + 6];
                    }
                    response.SW1 = buff[len - 5];
                    response.SW2 = buff[len - 4];
                }
            }
        }
        isCommandRunning = false;
        return ec;
    }

    public int icc_exchangeAPDU(byte[] dataAPDU, ResDataStruct response) {
        TaskManager.TaskStartRet r;
        int dataLen;
        if (response == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            response.statusCode = 29696;
            return 29696;
        }
        if (!this.isICCDeviceSelected()) {
            response.statusCode = 20;
            return 20;
        }
        if (!this.device_isConnected()) {
            response.statusCode = 1;
            return 1;
        }
        int n = dataLen = dataAPDU == null ? 0 : dataAPDU.length;
        if (dataLen < 1 || dataLen > 2032) {
            response.statusCode = 27392;
            return 27392;
        }
        byte[] data = new byte[dataLen + 1];
        data[0] = 32;
        System.arraycopy(dataAPDU, 0, data, 1, dataLen);
        int cmd = 0;
        int rt = 9;
        isCommandRunning = true;
        this.waitForNotification();
        int loopNum = 0;
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)44, (byte)19, data)), 0, response);
            ++loopNum;
            if (r == TaskManager.TaskStartRet.SUCCESS) {
                if (response.resData == null) {
                    response.statusCode = 21;
                    this.icc_powerOffICCforAPDU();
                    isCommandRunning = false;
                    return 21;
                }
                if (response.resData.length == 1 && response.resData[0] == 0) {
                    response.statusCode = 3;
                    this.icc_powerOffICCforAPDU();
                    isCommandRunning = false;
                    return 3;
                }
                rt = 9;
                int len = response.resData.length;
                if (len > 11) {
                    rt = response.resData[11];
                    cmd = response.resData[10];
                    if (cmd == -18 && rt == -16) break;
                    if (rt != 0) {
                        rt = 9;
                    }
                }
            }
            if (loopNum >= maxLoopNum || rt == 0 && cmd == 44) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException len) {
                // empty catch block
            }
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != 44));
        int returnCode = this.returnACK(r, response);
        this.convertIDG(response, 0);
        isCommandRunning = false;
        response.statusCode = returnCode;
        return returnCode;
    }

    public int icc_exchangeEncryptedAPDU(byte[] dataAPDU, byte[] ksn, APDUResponseStruct response) {
        int ec;
        if (response == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (dataAPDU == null || dataAPDU.length > 2032) {
            return 27392;
        }
        if (!this.isICCDeviceSelected() || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
            return 20;
        }
        if (ksn != null && ksn.length != 10) {
            return 27392;
        }
        isCommandRunning = true;
        this.waitForNotification();
        TaskManager.TaskStartRet r = null;
        ResDataStruct respData = new ResDataStruct();
        int i = 0;
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_USB) {
            r = this.sendCommand_helper("724663" + Common.getHexStringFromBytes(dataAPDU), 0, respData);
            ec = this.returnACK(r, respData);
            if (ec == 0) {
                byte[] buff = respData.resData;
                int len = respData.resData.length;
                int length = len - 7;
                response.response = new byte[length];
                for (i = 0; i < length; ++i) {
                    response.response[i] = buff[i + 4];
                }
            }
        } else {
            r = this.sendCommand_helper("7246630A" + Common.getHexStringFromBytes(ksn) + Common.getHexStringFromBytes(dataAPDU), 0, respData);
            ec = this.returnACK(r, respData);
            if (ec == 0) {
                byte[] buff = respData.resData;
                int len = respData.resData.length;
                response.hasKSN = false;
                response.hasEncryption = false;
                if (buff[4] == 0) {
                    response.ksn = new byte[0];
                    response.SW1 = buff[5];
                    response.SW2 = buff[6];
                }
                if (buff[4] == 1) {
                    response.hasKSN = false;
                    response.hasEncryption = true;
                    if (buff[5] == 10) {
                        response.hasKSN = true;
                        response.ksn = new byte[10];
                        for (i = 6; i < 16; ++i) {
                            response.ksn[i - 6] = buff[i];
                        }
                        int length = len - 16 - 3 - 2;
                        response.response = new byte[length];
                        for (i = 0; i < length; ++i) {
                            response.response[i] = buff[i + 16];
                        }
                        response.SW1 = buff[len - 5];
                        response.SW2 = buff[len - 4];
                    } else {
                        response.ksn = new byte[0];
                        int length = len - 6 - 3 - 2;
                        response.response = new byte[length];
                        for (i = 0; i < length; ++i) {
                            response.response[i] = buff[i + 6];
                        }
                        response.SW1 = buff[len - 5];
                        response.SW2 = buff[len - 4];
                    }
                }
            }
        }
        isCommandRunning = false;
        return ec;
    }

    public int icc_exchangeMultiAPDU(byte[] dataAPDU, ResDataStruct respData) {
        if (respData == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            respData.statusCode = 29696;
            return 29696;
        }
        if (!this.device_isConnected()) {
            respData.statusCode = 1;
            return 1;
        }
        if (dataAPDU == null || dataAPDU.length == 0 || dataAPDU.length > 2032) {
            respData.statusCode = 4;
            return 4;
        }
        if (!this.isICCDeviceSelected() || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
            respData.statusCode = 20;
            return 20;
        }
        isCommandRunning = true;
        this.waitForNotification();
        Common.beginTimeEachCmd = System.currentTimeMillis();
        boolean isReadRecord = false;
        if (dataAPDU[3] == -78) {
            isReadRecord = true;
        }
        UMLog.i("EMV_KERNEL", "Multi APDU Command = 7246a1" + Common.getHexStringFromBytes(dataAPDU));
        TaskManager.TaskStartRet r = this.sendCommand_helper("7246a1" + Common.getHexStringFromBytes(dataAPDU), 25, respData);
        int ec = this.returnACK(r, respData);
        if (ec == 0) {
            UMLog.i("EMV_KERNEL", "Good Multi APDU - wait for response");
            r = this.taskManager.task_start_receive_synchro(respData, true, this, isReadRecord, _usb);
            UMLog.i("EMV_KERNEL", "Good Multi APDU - continue");
        } else {
            UMLog.i("EMV_KERNEL", "BAD Multi APDU - exit");
            respData.resData = null;
        }
        isCommandRunning = false;
        respData.statusCode = ec;
        return ec;
    }

    public int icc_getAPDU_KSN(ResDataStruct resKSN) {
        if (resKSN == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            resKSN.statusCode = 29696;
            return 29696;
        }
        if (!this.device_isConnected()) {
            resKSN.statusCode = 1;
            return 1;
        }
        if (!this.isICCDeviceSelected() || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
            resKSN.statusCode = 20;
            return 20;
        }
        isCommandRunning = true;
        this.waitForNotification();
        ResDataStruct respData = new ResDataStruct();
        TaskManager.TaskStartRet r = this.sendCommand_helper("724662", 0, respData);
        int ec = this.returnACK(r, respData);
        if (ec == 0) {
            byte[] buff = respData.resData;
            int len = respData.resData.length;
            resKSN.resData = new byte[10];
            int length = len - 7;
            if (length != 10) {
                return 7;
            }
            for (int i = 4; i < len - 3; ++i) {
                resKSN.resData[i - 4] = buff[i];
            }
        }
        isCommandRunning = false;
        resKSN.statusCode = ec;
        return ec;
    }

    public int icc_getAPDU_KSN(byte KeyNameIndex, byte[] KeySlot, ResDataStruct resKSN) {
        if (resKSN == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            resKSN.statusCode = 29696;
            return 29696;
        }
        if (!this.device_isConnected()) {
            resKSN.statusCode = 1;
            return 1;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA) {
            resKSN.statusCode = 20;
            return 20;
        }
        if (KeySlot != null && KeySlot.length > 2) {
            resKSN.statusCode = 4;
            return 4;
        }
        isCommandRunning = true;
        this.waitForNotification();
        int dataLength = 3 + KeySlot.length;
        byte[] dataLen = new byte[]{(byte)(dataLength & 0xFF), (byte)(dataLength >> 8 & 0xFF)};
        byte[] keySlotLen = new byte[]{(byte)(KeySlot.length & 0xFF), (byte)(KeySlot.length >> 8 & 0xFF)};
        String str = "78463E" + Common.getHexStringFromBytes(dataLen) + String.format(Locale.US, "%02X", KeyNameIndex) + Common.getHexStringFromBytes(keySlotLen) + Common.getHexStringFromBytes(KeySlot);
        ResDataStruct respData = new ResDataStruct();
        TaskManager.TaskStartRet r = this.sendCommand_helper("78463E" + Common.getHexStringFromBytes(dataLen) + String.format(Locale.US, "%02X", KeyNameIndex) + Common.getHexStringFromBytes(keySlotLen) + Common.getHexStringFromBytes(KeySlot), 0, respData);
        int ec = this.returnACK(r, respData);
        if (ec == 0) {
            byte[] buff = respData.resData;
            int len = respData.resData.length;
            resKSN.resData = new byte[10];
            System.arraycopy(buff, 9, resKSN.resData, 0, 10);
        }
        isCommandRunning = false;
        resKSN.statusCode = ec;
        return ec;
    }

    public int icc_setKeyTypeForICCDUKPT(byte encryption) {
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        isCommandRunning = true;
        this.waitForNotification();
        ResDataStruct respData = new ResDataStruct();
        TaskManager.TaskStartRet r = encryption == 0 ? this.sendCommand_helper("785301020100", 0, respData) : this.sendCommand_helper("785301020101", 0, respData);
        isCommandRunning = false;
        return this.returnACK(r, respData);
    }

    public int icc_getKeyTypeForICCDUKPT(ResDataStruct respData) {
        if (respData == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            respData.statusCode = 29696;
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA) {
            respData.statusCode = 20;
            return 20;
        }
        if (!this.device_isConnected()) {
            respData.statusCode = 1;
            return 1;
        }
        isCommandRunning = true;
        this.waitForNotification();
        TaskManager.TaskStartRet r = this.sendCommand_helper("78520102", 0, respData);
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        if (returnCode == 0) {
            respData.keyType = respData.resData[4];
        }
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int icc_setKeyFormatForICCDUKPT(byte encryption) {
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        isCommandRunning = true;
        this.waitForNotification();
        ResDataStruct respData = new ResDataStruct();
        TaskManager.TaskStartRet r = encryption == 0 ? this.sendCommand_helper("785301030100", 0, respData) : this.sendCommand_helper("785301030101", 0, respData);
        isCommandRunning = false;
        return this.returnACK(r, respData);
    }

    public int icc_getKeyFormatForICCDUKPT(ResDataStruct respData) {
        if (respData == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            respData.statusCode = 29696;
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA) {
            respData.statusCode = 20;
            return 20;
        }
        if (!this.device_isConnected()) {
            respData.statusCode = 1;
            return 1;
        }
        isCommandRunning = true;
        this.waitForNotification();
        TaskManager.TaskStartRet r = this.sendCommand_helper("78520103", 0, respData);
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        if (returnCode == 0) {
            respData.encryptionOption = respData.resData[4];
        }
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int icc_enable(boolean withNotification) {
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        isCommandRunning = true;
        this.waitForNotification();
        ResDataStruct respData = new ResDataStruct();
        TaskManager.TaskStartRet r = withNotification ? this.sendCommand_helper("725301110132", 0, respData) : this.sendCommand_helper("725301110131", 0, respData);
        isNotificationOn = withNotification;
        isCommandRunning = false;
        return this.returnACK(r, respData);
    }

    public int icc_disable() {
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        isCommandRunning = true;
        this.waitForNotification();
        ResDataStruct respData = new ResDataStruct();
        TaskManager.TaskStartRet r = this.sendCommand_helper("725301110130", 0, respData);
        isNotificationOn = false;
        isCommandRunning = false;
        return this.returnACK(r, respData);
    }

    public int icc_getFunctionStatus(ResDataStruct respData) {
        if (respData == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            respData.statusCode = 29696;
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA) {
            respData.statusCode = 20;
            return 20;
        }
        if (!this.device_isConnected()) {
            respData.statusCode = 1;
            return 1;
        }
        isCommandRunning = true;
        this.waitForNotification();
        TaskManager.TaskStartRet r = this.sendCommand_helper("72520111", 0, respData);
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        if (returnCode == 0) {
            respData.functionStatus = respData.resData[4];
        }
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int icc_enableNotification(boolean enableNotifyICCStatus) {
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (!this.isICCDeviceSelected() || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
            return 20;
        }
        isCommandRunning = true;
        this.waitForNotification();
        ResDataStruct respData = new ResDataStruct();
        byte[] _enableNotifyICCStatus = new byte[]{enableNotifyICCStatus ? (byte)1 : -1};
        respData = new ResDataStruct();
        TaskManager.TaskStartRet r = this.sendCommand_helper("7253011001" + Common.getHexStringFromBytes(_enableNotifyICCStatus), 0, respData);
        isCommandRunning = false;
        return this.returnACK(r, respData);
    }

    public int icc_defaultSetting() {
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (!this.isICCDeviceSelected()) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        isCommandRunning = true;
        this.waitForNotification();
        ResDataStruct respData = new ResDataStruct();
        TaskManager.TaskStartRet r = this.sendCommand_helper("725300", 0, respData);
        isCommandRunning = false;
        return this.returnACK(r, respData);
    }

    public int icc_reviewAllSetting(ICCSettingStruct iccSetting) {
        if (iccSetting == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (!this.isICCDeviceSelected() || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_BTPAY || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_BTPAY_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
            return 20;
        }
        isCommandRunning = true;
        this.waitForNotification();
        ResDataStruct respData = new ResDataStruct();
        TaskManager.TaskStartRet r = this.sendCommand_helper("725200", 0, respData);
        int ec = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        if (ec == 0) {
            iccSetting.resData = new byte[respData.resData.length];
            System.arraycopy(respData.resData, 0, iccSetting.resData, 0, respData.resData.length);
            iccSetting.mainCardTypeOption = iccSetting.resData[4];
            iccSetting.timeout = iccSetting.resData[7];
            iccSetting.readingCharacteristics = iccSetting.resData[10];
            iccSetting.prePANIDLen = iccSetting.resData[13];
            iccSetting.postPANIDLen = iccSetting.resData[14];
            iccSetting.maskCharWithASCII = iccSetting.resData[17];
            iccSetting.maskCharWithBCD = iccSetting.resData[20];
            iccSetting.CTL2Interval = iccSetting.resData[23];
        }
        isCommandRunning = false;
        return ec;
    }

    public int ctls_retrieveApplicationData(String aid, ResDataStruct respData) {
        TaskManager.TaskStartRet r;
        int rt;
        int cmd;
        block27: {
            int loopNum;
            block28: {
                if (respData == null) {
                    return 27392;
                }
                if (!readyForNextCommand || !readyForCardSwipe) {
                    respData.statusCode = 29696;
                    return 29696;
                }
                if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VENDI && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
                    respData.statusCode = 20;
                    return 20;
                }
                if (aid == null || aid.length() == 0) {
                    respData.statusCode = 27392;
                    return 27392;
                }
                if (!this.device_isConnected()) {
                    respData.statusCode = 1;
                    return 1;
                }
                byte[] theAid = Common.getBytesFromHexString(aid);
                if (theAid == null || theAid.length < 5 || theAid.length > 16) {
                    respData.statusCode = 27392;
                    return 27392;
                }
                int dataLen = theAid.length;
                if (dataLen < 1) {
                    respData.statusCode = 27392;
                    return 27392;
                }
                cmd = 0;
                rt = 9;
                isCommandRunning = true;
                this.waitForNotification();
                loopNum = 0;
                if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) break block28;
                byte[] tagAid = connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT ? new byte[theAid.length + 3] : new byte[theAid.length + 8];
                tagAid[0] = -97;
                tagAid[1] = 6;
                tagAid[2] = (byte)theAid.length;
                System.arraycopy(theAid, 0, tagAid, 3, theAid.length);
                if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT) {
                    tagAid[theAid.length + 3] = -33;
                    tagAid[theAid.length + 4] = -18;
                    tagAid[theAid.length + 5] = 79;
                    tagAid[theAid.length + 6] = 1;
                    tagAid[theAid.length + 7] = 1;
                }
                do {
                    r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)3, (byte)4, tagAid)), 0, respData);
                    ++loopNum;
                    if (r != TaskManager.TaskStartRet.SUCCESS) continue;
                    if (respData.resData == null) {
                        isCommandRunning = false;
                        respData.statusCode = 21;
                        return 21;
                    }
                    if (respData.resData.length == 1 && respData.resData[0] == 0) {
                        isCommandRunning = false;
                        respData.statusCode = 3;
                        return 3;
                    }
                    rt = 9;
                    int len = respData.resData.length;
                    if (len <= 11) continue;
                    rt = respData.resData[11];
                    cmd = respData.resData[10];
                    if (cmd == -18 && rt == -16) break block27;
                    if (rt == 0) continue;
                    rt = 9;
                } while (loopNum < maxLoopNum && (rt != 0 || cmd != 3));
                break block27;
                {
                }
            }
            do {
                r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)3, (byte)5, new byte[0])), 0, respData);
                ++loopNum;
                if (r == TaskManager.TaskStartRet.SUCCESS) {
                    if (respData.resData == null) {
                        isCommandRunning = false;
                        respData.statusCode = 21;
                        return 21;
                    }
                    if (respData.resData.length == 1 && respData.resData[0] == 0) {
                        isCommandRunning = false;
                        respData.statusCode = 3;
                        return 3;
                    }
                    rt = 9;
                    int len = respData.resData.length;
                    if (len > 11) {
                        rt = respData.resData[11];
                        cmd = respData.resData[10];
                        if (cmd == -18 && rt == -16) break;
                        if (rt != 0) {
                            rt = 9;
                        }
                    }
                }
                if (loopNum >= maxLoopNum || rt == 0 && cmd == 3) continue;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException len) {
                    // empty catch block
                }
            } while (loopNum < maxLoopNum && (rt != 0 || cmd != 3));
        }
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        if (cmd == -18 && rt == -16) {
            respData.statusCode = returnCode;
            return returnCode;
        }
        if (respData.resData != null && respData.resData.length > 2 && respData.resData[0] == -1 && respData.resData[1] == -28) {
            if (respData.resData == null || respData.resData.length == 0) {
                returnCode = 61024;
            }
        } else if (respData.resData != null && respData.resData.length > 3 && respData.resData[0] == -33 && respData.resData[1] == -18 && respData.resData[2] == 45) {
            if (respData.resData == null || respData.resData.length == 0) {
                returnCode = 61024;
            }
        } else {
            returnCode = 61024;
        }
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int emv_retrieveApplicationData(String aid, ResDataStruct respData) {
        TaskManager.TaskStartRet r;
        byte[] Aid;
        byte[] theAid;
        block24: {
            TaskManager.TaskStartRet r2;
            block23: {
                int loopNum;
                int rt;
                int cmd;
                block25: {
                    if (respData == null) {
                        return 27392;
                    }
                    if (!readyForNextCommand || !readyForCardSwipe) {
                        respData.statusCode = 29696;
                        return 29696;
                    }
                    if (!(this.isICCDeviceSelected() && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI)) {
                        respData.statusCode = 20;
                        return 20;
                    }
                    if (aid == null || aid.length() == 0) {
                        respData.statusCode = 27392;
                        return 27392;
                    }
                    if (!this.device_isConnected()) {
                        respData.statusCode = 1;
                        return 1;
                    }
                    theAid = Common.getBytesFromHexString(aid);
                    if (theAid == null || theAid.length < 5 || theAid.length > 16) {
                        respData.statusCode = 27392;
                        return 27392;
                    }
                    int dataLen = theAid.length;
                    if (dataLen < 1) {
                        respData.statusCode = 27392;
                        return 27392;
                    }
                    cmd = 0;
                    rt = 9;
                    isCommandRunning = true;
                    this.waitForNotification();
                    if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) break block24;
                    if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V) {
                        this.waitForVivo();
                    }
                    loopNum = 0;
                    if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) break block25;
                    byte[] tagAid = new byte[theAid.length + 8];
                    tagAid[0] = -97;
                    tagAid[1] = 6;
                    tagAid[2] = (byte)theAid.length;
                    System.arraycopy(theAid, 0, tagAid, 3, theAid.length);
                    tagAid[theAid.length + 3] = -33;
                    tagAid[theAid.length + 4] = -18;
                    tagAid[theAid.length + 5] = 79;
                    tagAid[theAid.length + 6] = 1;
                    tagAid[theAid.length + 7] = 1;
                    do {
                        r2 = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)3, (byte)4, tagAid)), 0, respData);
                        ++loopNum;
                        if (r2 != TaskManager.TaskStartRet.SUCCESS) continue;
                        if (respData.resData == null) {
                            isCommandRunning = false;
                            respData.statusCode = 21;
                            return 21;
                        }
                        if (respData.resData.length == 1 && respData.resData[0] == 0) {
                            isCommandRunning = false;
                            respData.statusCode = 3;
                            return 3;
                        }
                        rt = 9;
                        int len = respData.resData.length;
                        if (len <= 11) continue;
                        rt = respData.resData[11];
                        cmd = respData.resData[10];
                        if (cmd == -18 && rt == -16) break block23;
                        if (rt == 0) continue;
                        rt = 9;
                    } while (loopNum < maxLoopNum && (rt != 0 || cmd != 3));
                    break block23;
                    {
                    }
                }
                do {
                    r2 = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)96, (byte)1, theAid)), 0, respData);
                    ++loopNum;
                    if (r2 == TaskManager.TaskStartRet.SUCCESS) {
                        if (respData.resData == null) {
                            isCommandRunning = false;
                            respData.statusCode = 21;
                            return 21;
                        }
                        if (respData.resData.length == 1 && respData.resData[0] == 0) {
                            isCommandRunning = false;
                            respData.statusCode = 3;
                            return 3;
                        }
                        rt = 9;
                        int len = respData.resData.length;
                        if (len > 11) {
                            rt = respData.resData[11];
                            cmd = respData.resData[10];
                            if (cmd == -18 && rt == -16) break;
                            if (rt != 0) {
                                rt = 9;
                            }
                        }
                    }
                    if (loopNum >= maxLoopNum || rt == 0 && cmd == 96) continue;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException len) {
                        // empty catch block
                    }
                } while (loopNum < maxLoopNum && (rt != 0 || cmd != 96));
            }
            int returnCode = this.returnACK(r2, respData);
            this.convertIDG(respData, 2);
            isCommandRunning = false;
            respData.statusCode = returnCode;
            return returnCode;
        }
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA) {
            Aid = new byte[theAid.length + 2];
            Aid[0] = (byte)(theAid.length & 0xFF);
            Aid[1] = (byte)(theAid.length >> 8);
            System.arraycopy(theAid, 0, Aid, 2, theAid.length);
            r = this.sendCommand_helper("72460101" + Common.bytesToHex(Aid), 0, respData);
            if (respData.resData != null && respData.resData.length == 3 && respData.resData[0] == 21 && respData.resData[1] == -127 && respData.resData[2] == 0) {
                isCommandRunning = false;
                return 3;
            }
        } else {
            Aid = new byte[theAid.length + 1];
            Aid[0] = (byte)theAid.length;
            System.arraycopy(theAid, 0, Aid, 1, theAid.length);
            r = this.sendCommand_helper("72468101" + Common.bytesToHex(Aid), 0, respData);
        }
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int ctls_removeApplicationData(String aidFile, ResDataStruct respData) {
        TaskManager.TaskStartRet r;
        if (respData == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            respData.statusCode = 29696;
            return 29696;
        }
        if (aidFile == null || aidFile.length() == 0) {
            respData.statusCode = 27392;
            return 27392;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VENDI && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
            respData.statusCode = 20;
            return 20;
        }
        if (!this.device_isConnected()) {
            respData.statusCode = 1;
            return 1;
        }
        byte[] tmp = Common.getBytesFromHexString(aidFile);
        if (tmp == null || tmp.length < 5 || tmp.length > 16) {
            respData.statusCode = 27392;
            return 27392;
        }
        byte[] aid = new byte[tmp.length + 3];
        aid[0] = -97;
        aid[1] = 6;
        aid[2] = (byte)tmp.length;
        System.arraycopy(tmp, 0, aid, 3, tmp.length);
        int dataLen = aid.length;
        if (dataLen < 1) {
            respData.statusCode = 27392;
            return 27392;
        }
        isCommandRunning = true;
        this.waitForNotification();
        int cmd = 0;
        int rt = 9;
        int loopNum = 0;
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)4, (byte)4, aid)), 0, respData);
            ++loopNum;
            if (r == TaskManager.TaskStartRet.SUCCESS) {
                if (respData.resData == null) {
                    isCommandRunning = false;
                    respData.statusCode = 21;
                    return 21;
                }
                if (respData.resData.length == 1 && respData.resData[0] == 0) {
                    isCommandRunning = false;
                    respData.statusCode = 3;
                    return 3;
                }
                rt = 9;
                int len = respData.resData.length;
                if (len > 11) {
                    rt = respData.resData[11];
                    cmd = respData.resData[10];
                    if (cmd == -18 && rt == -16) break;
                    if (rt != 0) {
                        rt = 9;
                    }
                }
            }
            if (loopNum >= maxLoopNum || rt == 0 && cmd == 4) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException len) {
                // empty catch block
            }
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != 4));
        int returnCode = this.returnACK(r, respData);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int emv_removeApplicationData(String aidFile, ResDataStruct respData) {
        TaskManager.TaskStartRet r;
        block28: {
            byte[] aid;
            block30: {
                int rt;
                int cmd;
                block29: {
                    if (respData == null) {
                        return 27392;
                    }
                    if (!readyForNextCommand || !readyForCardSwipe) {
                        respData.statusCode = 29696;
                        return 29696;
                    }
                    if (!(this.isICCDeviceSelected() && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI)) {
                        respData.statusCode = 20;
                        return 20;
                    }
                    if (aidFile == null || aidFile.length() == 0) {
                        respData.statusCode = 27392;
                        return 27392;
                    }
                    if (!this.device_isConnected()) {
                        respData.statusCode = 1;
                        return 1;
                    }
                    if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
                        byte[] tmp = Common.getBytesFromHexString(aidFile);
                        if (tmp == null) {
                            respData.statusCode = 27392;
                            return 27392;
                        }
                        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
                            aid = new byte[tmp.length + 8];
                            aid[0] = -97;
                            aid[1] = 6;
                            aid[2] = (byte)tmp.length;
                            System.arraycopy(tmp, 0, aid, 3, tmp.length);
                            aid[tmp.length + 3] = -33;
                            aid[tmp.length + 4] = -18;
                            aid[tmp.length + 5] = 79;
                            aid[tmp.length + 6] = 1;
                            aid[tmp.length + 7] = 2;
                        } else {
                            aid = new byte[tmp.length + 3];
                            aid[0] = -97;
                            aid[1] = 6;
                            aid[2] = (byte)tmp.length;
                            System.arraycopy(tmp, 0, aid, 3, tmp.length);
                        }
                    } else {
                        aid = Common.getBytesFromHexString(aidFile);
                        if (aid == null) {
                            respData.statusCode = 27392;
                            return 27392;
                        }
                    }
                    int dataLen = aid.length;
                    if (dataLen < 1) {
                        respData.statusCode = 27392;
                        return 27392;
                    }
                    isCommandRunning = true;
                    this.waitForNotification();
                    cmd = 0;
                    rt = 9;
                    if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) break block29;
                    if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V) {
                        this.waitForVivo();
                    }
                    int loopNum = 0;
                    do {
                        r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)96, (byte)2, aid)), 0, respData);
                        ++loopNum;
                        if (r == TaskManager.TaskStartRet.SUCCESS) {
                            if (respData.resData == null) {
                                isCommandRunning = false;
                                respData.statusCode = 21;
                                return 21;
                            }
                            if (respData.resData.length == 1 && respData.resData[0] == 0) {
                                isCommandRunning = false;
                                respData.statusCode = 3;
                                return 3;
                            }
                            rt = 9;
                            int len = respData.resData.length;
                            if (len > 11) {
                                rt = respData.resData[11];
                                cmd = respData.resData[10];
                                if (cmd == -18 && rt == -16) break block28;
                                if (rt != 0) {
                                    respData.statusCode = 9;
                                    rt = 9;
                                }
                            }
                        }
                        if (loopNum >= maxLoopNum || rt == 0 && cmd == 96) continue;
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException len) {
                            // empty catch block
                        }
                    } while (loopNum < maxLoopNum && (rt != 0 || cmd != 96));
                    break block28;
                    {
                    }
                }
                if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) break block30;
                int loopNum = 0;
                do {
                    r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)4, (byte)4, aid)), 0, respData);
                    ++loopNum;
                    if (r != TaskManager.TaskStartRet.SUCCESS) continue;
                    if (respData.resData == null) {
                        isCommandRunning = false;
                        respData.statusCode = 21;
                        return 21;
                    }
                    if (respData.resData.length == 1 && respData.resData[0] == 0) {
                        isCommandRunning = false;
                        respData.statusCode = 3;
                        return 3;
                    }
                    rt = 9;
                    int len = respData.resData.length;
                    if (len <= 11) continue;
                    rt = respData.resData[11];
                    cmd = respData.resData[10];
                    if (cmd == -18 && rt == -16) break block28;
                    if (rt == 0) continue;
                    respData.statusCode = 9;
                    rt = 9;
                } while (loopNum < maxLoopNum && (rt != 0 || cmd != 4));
                break block28;
                {
                }
            }
            if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA) {
                byte[] Aid = new byte[aid.length + 2];
                Aid[0] = (byte)(aid.length & 0xFF);
                Aid[1] = (byte)(aid.length >> 8);
                System.arraycopy(aid, 0, Aid, 2, aid.length);
                r = this.sendCommand_helper("72460102" + Common.bytesToHex(Aid), 0, respData);
            } else {
                byte[] Aid = new byte[aid.length + 1];
                Aid[0] = (byte)aid.length;
                System.arraycopy(aid, 0, Aid, 1, aid.length);
                r = this.sendCommand_helper("72468102" + Common.bytesToHex(Aid), 0, respData);
            }
        }
        int returnCode = this.returnACK(r, respData);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int ctls_removeAllApplicationData() {
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VENDI && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        ResDataStruct respData = new ResDataStruct();
        isCommandRunning = true;
        this.waitForNotification();
        ResDataStruct tempData = new ResDataStruct();
        int ret = this.ctls_retrieveAidList(tempData);
        if (ret == 0 && tempData.stringArray != null && tempData.stringArray.length > 0) {
            for (int i = 0; i < tempData.stringArray.length; ++i) {
                ret = this.ctls_removeApplicationData(tempData.stringArray[i], respData);
                if (ret == 0) continue;
                isCommandRunning = false;
                return ret;
            }
        }
        isCommandRunning = false;
        return ret;
    }

    public int emv_removeAllApplicationData() {
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VENDI && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        ResDataStruct respData = new ResDataStruct();
        TaskManager.TaskStartRet r = null;
        int returnCode = 9;
        ResDataStruct restData = new ResDataStruct();
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
            returnCode = this.emv_retrieveAidList(respData);
            if (returnCode == 0 && respData != null && respData.stringArray != null && respData.stringArray.length > 0) {
                for (int i = 0; i < respData.stringArray.length; ++i) {
                    returnCode = this.emv_removeApplicationData(respData.stringArray[i], restData);
                    if (returnCode == 0) continue;
                    return returnCode;
                }
            }
        } else {
            isCommandRunning = true;
            this.waitForNotification();
            r = this.sendCommand_helper("72460104", 0, respData);
            returnCode = this.returnACK(r, respData);
            isCommandRunning = false;
        }
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int ctls_setApplicationData(byte[] tlv, ResDataStruct respData) {
        TaskManager.TaskStartRet r;
        int dataLen;
        if (respData == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            respData.statusCode = 29696;
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VENDI && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
            respData.statusCode = 20;
            return 20;
        }
        if (!this.device_isConnected()) {
            respData.statusCode = 1;
            return 1;
        }
        int n = dataLen = tlv == null ? 0 : tlv.length;
        if (dataLen < 1 || dataLen > 2032) {
            respData.statusCode = 27392;
            return 27392;
        }
        int cmd = 0;
        int rt = 9;
        byte[] aidData = new byte[tlv.length];
        System.arraycopy(tlv, 0, aidData, 0, aidData.length);
        isCommandRunning = true;
        this.waitForNotification();
        int loopNum = 0;
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)4, (byte)2, aidData)), 0, respData);
            ++loopNum;
            if (r == TaskManager.TaskStartRet.SUCCESS) {
                if (respData.resData == null) {
                    isCommandRunning = false;
                    respData.statusCode = 21;
                    return 21;
                }
                if (respData.resData.length == 1 && respData.resData[0] == 0) {
                    isCommandRunning = false;
                    respData.statusCode = 3;
                    return 3;
                }
                rt = 9;
                int len = respData.resData.length;
                if (len > 11) {
                    rt = respData.resData[11];
                    cmd = respData.resData[10];
                    if (cmd == -18 && rt == -16) break;
                    if (rt != 0) {
                        rt = 9;
                    }
                }
            }
            if (loopNum >= maxLoopNum || rt == 0 && cmd == 4) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException len) {
                // empty catch block
            }
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != 4));
        int returnCode = this.returnACK(r, respData);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int ctls_setConfigurationGroup(byte[] TLV, ResDataStruct respData) {
        int len2;
        TaskManager.TaskStartRet r;
        int dataLen;
        if (respData == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            respData.statusCode = 29696;
            return 29696;
        }
        if (!(this.isICCDeviceSelected() && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP2000)) {
            respData.statusCode = 20;
            return 20;
        }
        if (!this.device_isConnected()) {
            respData.statusCode = 1;
            return 1;
        }
        int n = dataLen = TLV == null ? 0 : TLV.length;
        if (dataLen < 1 || dataLen > 2032) {
            respData.statusCode = 27392;
            return 27392;
        }
        int cmd = 0;
        int rt = 9;
        byte[] aidData = new byte[TLV.length];
        System.arraycopy(TLV, 0, aidData, 0, aidData.length);
        isCommandRunning = true;
        this.waitForNotification();
        int loopNum = 0;
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)4, (byte)3, aidData)), 0, respData);
            ++loopNum;
            if (r == TaskManager.TaskStartRet.SUCCESS) {
                if (respData.resData == null) {
                    isCommandRunning = false;
                    respData.statusCode = 21;
                    return 21;
                }
                if (respData.resData.length == 1 && respData.resData[0] == 0) {
                    isCommandRunning = false;
                    respData.statusCode = 3;
                    return 3;
                }
                rt = 9;
                len2 = respData.resData.length;
                if (len2 > 11) {
                    rt = respData.resData[11];
                    cmd = respData.resData[10];
                    if (cmd == -18 && rt == -16) break;
                    if (rt != 0) {
                        rt = 9;
                    }
                }
            }
            if (loopNum >= maxLoopNum || rt == 0 && cmd == 4) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException len2) {
                // empty catch block
            }
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != 4));
        if ((connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB) && rt == 9) {
            do {
                r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)4, (byte)0, aidData)), 0, respData);
                ++loopNum;
                if (r == TaskManager.TaskStartRet.SUCCESS) {
                    if (respData.resData == null) {
                        isCommandRunning = false;
                        respData.statusCode = 21;
                        return 21;
                    }
                    if (respData.resData.length == 1 && respData.resData[0] == 0) {
                        isCommandRunning = false;
                        respData.statusCode = 3;
                        return 3;
                    }
                    rt = 9;
                    len2 = respData.resData.length;
                    if (len2 > 11) {
                        rt = respData.resData[11];
                        cmd = respData.resData[10];
                        if (rt != 0) {
                            rt = 9;
                        }
                    }
                }
                if (loopNum >= maxLoopNum || rt == 0 && cmd == 4) continue;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException len3) {
                    // empty catch block
                }
            } while (loopNum < maxLoopNum && (rt != 0 || cmd != 4));
        }
        int returnCode = this.returnACK(r, respData);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int ctls_setGlobalConfiguration(byte[] TLV, ResDataStruct respData) {
        TaskManager.TaskStartRet r;
        int dataLen;
        if (respData == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            respData.statusCode = 29696;
            return 29696;
        }
        if (!(this.isICCDeviceSelected() && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP2000)) {
            respData.statusCode = 20;
            return 20;
        }
        if (!this.device_isConnected()) {
            respData.statusCode = 1;
            return 1;
        }
        int n = dataLen = TLV == null ? 0 : TLV.length;
        if (dataLen < 1 || dataLen > 2032) {
            respData.statusCode = 27392;
            return 27392;
        }
        int cmd = 0;
        int rt = 9;
        byte[] aidData = new byte[TLV.length];
        System.arraycopy(TLV, 0, aidData, 0, aidData.length);
        isCommandRunning = true;
        this.waitForNotification();
        int loopNum = 0;
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)4, (byte)0, aidData)), 0, respData);
            ++loopNum;
            if (r == TaskManager.TaskStartRet.SUCCESS) {
                if (respData.resData == null) {
                    isCommandRunning = false;
                    respData.statusCode = 21;
                    return 21;
                }
                if (respData.resData.length == 1 && respData.resData[0] == 0) {
                    isCommandRunning = false;
                    respData.statusCode = 3;
                    return 3;
                }
                rt = 9;
                int len = respData.resData.length;
                if (len > 11) {
                    rt = respData.resData[11];
                    cmd = respData.resData[10];
                    if (cmd == -18 && rt == -16) break;
                    if (rt != 0) {
                        rt = 9;
                    }
                }
            }
            if (loopNum >= maxLoopNum || rt == 0 && cmd == 4) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException len) {
                // empty catch block
            }
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != 4));
        int returnCode = this.returnACK(r, respData);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int ctls_getConfigurationGroup(int group, ResDataStruct respData) {
        TaskManager.TaskStartRet r;
        if (respData == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            respData.statusCode = 29696;
            return 29696;
        }
        if (!(this.isICCDeviceSelected() && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP2000)) {
            respData.statusCode = 20;
            return 20;
        }
        if (!this.device_isConnected()) {
            respData.statusCode = 1;
            return 1;
        }
        if (group < 0 || group > 255) {
            respData.statusCode = 27392;
            return 27392;
        }
        int cmd = 0;
        int rt = 9;
        isCommandRunning = true;
        this.waitForNotification();
        byte[] data = new byte[]{-1, -28, 1, (byte)group};
        byte[] datasetNumber = new byte[]{-33, -18, 45, 1, (byte)group};
        int loopNum = 0;
        do {
            r = connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB ? this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)3, (byte)6, datasetNumber)), 0, respData) : this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)3, (byte)6, data)), 0, respData);
            ++loopNum;
            if (r == TaskManager.TaskStartRet.SUCCESS) {
                if (respData.resData == null) {
                    isCommandRunning = false;
                    respData.statusCode = 21;
                    return 21;
                }
                if (respData.resData.length == 1 && respData.resData[0] == 0) {
                    isCommandRunning = false;
                    respData.statusCode = 3;
                    return 3;
                }
                rt = 9;
                int len = respData.resData.length;
                if (len > 11) {
                    rt = respData.resData[11];
                    cmd = respData.resData[10];
                    if (cmd == -18 && rt == -16) break;
                    if (rt != 0) {
                        rt = 9;
                    }
                }
            }
            if (loopNum >= maxLoopNum || rt == 0 && cmd == 3) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException len) {
                // empty catch block
            }
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != 3));
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int ctls_getAllConfigurationGroups(ResDataStruct respData) {
        TaskManager.TaskStartRet r;
        if (respData == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            respData.statusCode = 29696;
            return 29696;
        }
        if (!(this.isICCDeviceSelected() && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP2000)) {
            respData.statusCode = 20;
            return 20;
        }
        if (!this.device_isConnected()) {
            respData.statusCode = 1;
            return 1;
        }
        int cmd = 0;
        int rt = 9;
        isCommandRunning = true;
        this.waitForNotification();
        int loopNum = 0;
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB) {
            do {
                r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)3, (byte)7, new byte[0])), 0, respData);
                ++loopNum;
                if (r == TaskManager.TaskStartRet.SUCCESS) {
                    if (respData.resData == null) {
                        isCommandRunning = false;
                        respData.statusCode = 21;
                        return 21;
                    }
                    if (respData.resData.length == 1 && respData.resData[0] == 0) {
                        isCommandRunning = false;
                        respData.statusCode = 3;
                        return 3;
                    }
                    rt = 9;
                    int len = respData.resData.length;
                    if (len > 11) {
                        rt = respData.resData[11];
                        cmd = respData.resData[10];
                        if (cmd == -18 && rt == -16) break;
                    }
                }
                if (loopNum >= maxLoopNum || (rt == 0 || rt == 99) && cmd == 3) continue;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException len) {
                    // empty catch block
                }
            } while (loopNum < maxLoopNum && (rt != 0 && rt != 99 || cmd != 3));
            byte[] temp = new byte[respData.resData.length];
            System.arraycopy(respData.resData, 0, temp, 0, temp.length);
            int dataLen = (respData.resData[12] & 0xFF) * 256 + (respData.resData[13] & 0xFF);
            while (rt == 99) {
                long startTime = System.currentTimeMillis();
                if (this.isBluetoothLEDeviceSelected()) {
                    _btle.readMessage(1, startTime, respData, true);
                } else {
                    _usb.readMessage(1, startTime, respData, true);
                }
                if (respData.resData.length <= 14) continue;
                rt = respData.resData[11];
                int len = (respData.resData[12] & 0xFF) * 256 + (respData.resData[13] & 0xFF);
                temp[11] = respData.resData[11];
                if (len <= 0) continue;
                temp[12] = (byte)((dataLen += len) >> 8 & 0xFF);
                temp[13] = (byte)(dataLen & 0xFF);
                byte[] tmp = new byte[dataLen + 16];
                System.arraycopy(temp, 0, tmp, 0, temp.length - 2);
                System.arraycopy(respData.resData, 14, tmp, temp.length - 2, len);
                temp = new byte[tmp.length];
                System.arraycopy(tmp, 0, temp, 0, tmp.length);
                respData.resData = new byte[temp.length];
                System.arraycopy(temp, 0, respData.resData, 0, temp.length);
            }
        } else {
            do {
                r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)3, (byte)7, new byte[0])), 0, respData);
                ++loopNum;
                if (r == TaskManager.TaskStartRet.SUCCESS) {
                    if (respData.resData == null) {
                        isCommandRunning = false;
                        respData.statusCode = 21;
                        return 21;
                    }
                    if (respData.resData.length == 1 && respData.resData[0] == 0) {
                        isCommandRunning = false;
                        respData.statusCode = 3;
                        return 3;
                    }
                    rt = 9;
                    int len = respData.resData.length;
                    if (len > 11) {
                        rt = respData.resData[11];
                        cmd = respData.resData[10];
                        if (rt != 0) {
                            rt = 9;
                        }
                    }
                }
                if (loopNum >= maxLoopNum || rt == 0 && cmd == 3) continue;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException len) {
                    // empty catch block
                }
            } while (loopNum < maxLoopNum && (rt != 0 || cmd != 3));
        }
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int ctls_removeConfigurationGroup(int group) {
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (!(this.isICCDeviceSelected() && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP2000)) {
            return 20;
        }
        if (group < 0 || group > 255) {
            return 27392;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        ResDataStruct respData = new ResDataStruct();
        isCommandRunning = true;
        this.waitForNotification();
        int cmd = 0;
        int rt = 9;
        byte[] data = new byte[]{-1, -28, 1, (byte)group};
        byte[] datasetNumber = new byte[]{-33, -18, 45, 1, (byte)group};
        int loopNum = 0;
        do {
            r = connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB ? this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)4, (byte)5, datasetNumber)), 0, respData) : this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)4, (byte)5, data)), 0, respData);
            ++loopNum;
            if (r == TaskManager.TaskStartRet.SUCCESS) {
                if (respData.resData == null) {
                    isCommandRunning = false;
                    return 21;
                }
                if (respData.resData.length == 1 && respData.resData[0] == 0) {
                    isCommandRunning = false;
                    return 3;
                }
                rt = 9;
                int len = respData.resData.length;
                if (len > 11) {
                    rt = respData.resData[11];
                    cmd = respData.resData[10];
                    if (cmd == -18 && rt == -16) break;
                    if (rt != 0) {
                        rt = 9;
                    }
                }
            }
            if (loopNum >= maxLoopNum || rt == 0 && cmd == 4) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException len) {
                // empty catch block
            }
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != 4));
        int returnCode = this.returnACK(r, respData);
        isCommandRunning = false;
        return returnCode;
    }

    public int ctls_resetConfigurationGroup(int group) {
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
            return 20;
        }
        if (group < 0 || group > 255) {
            return 27392;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        ResDataStruct respData = new ResDataStruct();
        isCommandRunning = true;
        this.waitForNotification();
        int cmd = 0;
        int rt = 9;
        byte[] data = new byte[]{-33, -18, 45, 1, (byte)group};
        int loopNum = 0;
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)4, (byte)16, data)), 0, respData);
            ++loopNum;
            if (r != TaskManager.TaskStartRet.SUCCESS) continue;
            if (respData.resData == null) {
                isCommandRunning = false;
                return 21;
            }
            if (respData.resData.length == 1 && respData.resData[0] == 0) {
                isCommandRunning = false;
                return 3;
            }
            rt = 9;
            int len = respData.resData.length;
            if (len <= 11) continue;
            rt = respData.resData[11];
            cmd = respData.resData[10];
            if (cmd == -18 && rt == -16) break;
            if (rt == 0) continue;
            rt = 9;
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != 4));
        int returnCode = this.returnACK(r, respData);
        isCommandRunning = false;
        return returnCode;
    }

    public int ctls_displayOnlineAuthResult(boolean isOK, byte[] tlv) {
        TaskManager.TaskStartRet r;
        byte[] data;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        ResDataStruct respData = new ResDataStruct();
        isCommandRunning = true;
        this.waitForNotification();
        int cmd = 0;
        int rt = 9;
        if (tlv != null && tlv.length > 0) {
            data = new byte[tlv.length + 1];
            System.arraycopy(tlv, 0, data, 1, tlv.length);
        } else {
            data = new byte[]{isOK ? (byte)0 : 1};
        }
        int loopNum = 0;
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)3, (byte)3, data)), 0, respData);
            ++loopNum;
            if (r != TaskManager.TaskStartRet.SUCCESS) continue;
            if (respData.resData == null) {
                isCommandRunning = false;
                return 21;
            }
            if (respData.resData.length == 1 && respData.resData[0] == 0) {
                isCommandRunning = false;
                return 3;
            }
            rt = 9;
            int len = respData.resData.length;
            if (len <= 11) continue;
            rt = respData.resData[11];
            cmd = respData.resData[10];
            if (cmd == -18 && rt == -16) break;
            if (rt == 0) continue;
            rt = 9;
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != 3));
        int returnCode = this.returnACK(r, respData);
        isCommandRunning = false;
        return returnCode;
    }

    public int emv_setApplicationData(String name, byte[] tlv, ResDataStruct respData) {
        TaskManager.TaskStartRet r;
        block24: {
            byte[] aidData;
            byte[] aid;
            block26: {
                int loopNum;
                int rt;
                int cmd;
                block25: {
                    int dataLen;
                    if (respData == null) {
                        return 27392;
                    }
                    if (!readyForNextCommand || !readyForCardSwipe) {
                        respData.statusCode = 29696;
                        return 29696;
                    }
                    if (name == null || name.length() < 10 || name.length() > 32) {
                        respData.statusCode = 4;
                        return 4;
                    }
                    if (!(this.isICCDeviceSelected() && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI)) {
                        respData.statusCode = 20;
                        return 20;
                    }
                    if (!this.device_isConnected()) {
                        respData.statusCode = 1;
                        return 1;
                    }
                    aid = Common.getBytesFromHexString(name);
                    if (aid == null) {
                        respData.statusCode = 27392;
                        return 27392;
                    }
                    int n = dataLen = tlv == null ? 0 : tlv.length;
                    if (dataLen < 1 || dataLen > 2032) {
                        respData.statusCode = 27392;
                        return 27392;
                    }
                    cmd = 0;
                    rt = 9;
                    aidData = new byte[aid.length + tlv.length + 4];
                    aidData[0] = (byte)aid.length;
                    aidData[1] = 0;
                    System.arraycopy(aid, 0, aidData, 2, aid.length);
                    Map<String, Map<String, byte[]>> TLVDict = Common.processTLV(tlv);
                    Map<String, byte[]> unencryptedTags = null;
                    if (TLVDict != null) {
                        unencryptedTags = TLVDict.get("tags");
                        aidData[aid.length + 2] = (byte)unencryptedTags.size();
                        aidData[aid.length + 3] = 0;
                    }
                    System.arraycopy(tlv, 0, aidData, aid.length + 4, tlv.length);
                    isCommandRunning = true;
                    this.waitForNotification();
                    if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) break block25;
                    if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V) {
                        this.waitForVivo();
                    }
                    loopNum = 0;
                    do {
                        r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)96, (byte)3, aidData)), 0, respData);
                        ++loopNum;
                        if (r == TaskManager.TaskStartRet.SUCCESS) {
                            if (respData.resData == null) {
                                isCommandRunning = false;
                                respData.statusCode = 21;
                                return 21;
                            }
                            if (respData.resData.length == 1 && respData.resData[0] == 0) {
                                isCommandRunning = false;
                                respData.statusCode = 3;
                                return 3;
                            }
                            rt = 9;
                            int len = respData.resData.length;
                            if (len > 11) {
                                rt = respData.resData[11];
                                cmd = respData.resData[10];
                                if (cmd == -18 && rt == -16) break block24;
                                if (rt != 0) {
                                    rt = 9;
                                }
                            }
                        }
                        if (loopNum >= maxLoopNum || rt == 0 && cmd == 96) continue;
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException len) {
                            // empty catch block
                        }
                    } while (loopNum < maxLoopNum && (rt != 0 || cmd != 96));
                    break block24;
                    {
                    }
                }
                if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) break block26;
                loopNum = 0;
                byte[] data = new byte[aid.length + tlv.length + 1];
                data[0] = (byte)aid.length;
                System.arraycopy(aid, 0, data, 1, aid.length);
                System.arraycopy(tlv, 0, data, aid.length + 1, tlv.length);
                aidData = new byte[data.length + 7];
                aidData[0] = -33;
                aidData[1] = -18;
                aidData[2] = 45;
                aidData[3] = 1;
                aidData[4] = 8;
                aidData[5] = -97;
                aidData[6] = 6;
                System.arraycopy(data, 0, aidData, 7, data.length);
                do {
                    r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)4, (byte)2, aidData)), 0, respData);
                    ++loopNum;
                    if (r != TaskManager.TaskStartRet.SUCCESS) continue;
                    if (respData.resData == null) {
                        isCommandRunning = false;
                        respData.statusCode = 21;
                        return 21;
                    }
                    if (respData.resData.length == 1 && respData.resData[0] == 0) {
                        isCommandRunning = false;
                        respData.statusCode = 3;
                        return 3;
                    }
                    rt = 9;
                    int len = respData.resData.length;
                    if (len <= 11) continue;
                    rt = respData.resData[11];
                    cmd = respData.resData[10];
                    if (cmd == -18 && rt == -16) break block24;
                    if (rt == 0) continue;
                    rt = 9;
                } while (loopNum < maxLoopNum && (rt != 0 || cmd != 4));
                break block24;
                {
                }
            }
            if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA) {
                r = this.sendCommand_helper("72460103" + Common.bytesToHex(aidData), 0, respData);
            } else {
                aidData = new byte[aid.length + tlv.length + 1];
                aidData[0] = (byte)aid.length;
                System.arraycopy(aid, 0, aidData, 1, aid.length);
                System.arraycopy(tlv, 0, aidData, aid.length + 1, tlv.length);
                r = this.sendCommand_helper("72468103" + Common.bytesToHex(aidData), 0, respData);
            }
        }
        int returnCode = this.returnACK(r, respData);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int ctls_retrieveAidList(ResDataStruct respData) {
        TaskManager.TaskStartRet r;
        if (respData == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            respData.statusCode = 29696;
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VENDI && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
            respData.statusCode = 20;
            return 20;
        }
        if (!this.device_isConnected()) {
            respData.statusCode = 1;
            return 1;
        }
        int cmd = 0;
        int rt = 9;
        isCommandRunning = true;
        this.waitForNotification();
        int loopNum = 0;
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB) {
            do {
                r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)3, (byte)5, new byte[0])), 0, respData);
                ++loopNum;
                if (r == TaskManager.TaskStartRet.SUCCESS) {
                    if (respData.resData == null) {
                        isCommandRunning = false;
                        respData.statusCode = 21;
                        return 21;
                    }
                    if (respData.resData.length == 1 && respData.resData[0] == 0) {
                        isCommandRunning = false;
                        respData.statusCode = 3;
                        return 3;
                    }
                    rt = 9;
                    int len = respData.resData.length;
                    if (len > 11) {
                        rt = respData.resData[11];
                        cmd = respData.resData[10];
                        if (cmd == -18 && rt == -16) break;
                    }
                }
                if (loopNum >= maxLoopNum || (rt == 0 || rt == 99) && cmd == 3) continue;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException len) {
                    // empty catch block
                }
            } while (loopNum < maxLoopNum && (rt != 0 && rt != 99 || cmd != 3));
            byte[] temp = new byte[respData.resData.length];
            System.arraycopy(respData.resData, 0, temp, 0, temp.length);
            int dataLen = (respData.resData[12] & 0xFF) * 256 + (respData.resData[13] & 0xFF);
            while (rt == 99) {
                long startTime = System.currentTimeMillis();
                if (this.isBluetoothLEDeviceSelected()) {
                    _btle.readMessage(1, startTime, respData, true);
                } else {
                    _usb.readMessage(1, startTime, respData, true);
                }
                if (respData.resData.length <= 14) continue;
                rt = respData.resData[11];
                int len = (respData.resData[12] & 0xFF) * 256 + (respData.resData[13] & 0xFF);
                temp[11] = respData.resData[11];
                if (len <= 0) continue;
                temp[12] = (byte)((dataLen += len) >> 8 & 0xFF);
                temp[13] = (byte)(dataLen & 0xFF);
                byte[] tmp = new byte[dataLen + 16];
                System.arraycopy(temp, 0, tmp, 0, temp.length - 2);
                System.arraycopy(respData.resData, 14, tmp, temp.length - 2, len);
                temp = new byte[tmp.length];
                System.arraycopy(tmp, 0, temp, 0, tmp.length);
                respData.resData = new byte[temp.length];
                System.arraycopy(temp, 0, respData.resData, 0, temp.length);
            }
            UMLog.i("IDT_Device", "ctls_retrieveAidList final data: " + Common.base16Encode(respData.resData));
        } else {
            do {
                r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)3, (byte)5, new byte[0])), 0, respData);
                ++loopNum;
                if (r == TaskManager.TaskStartRet.SUCCESS) {
                    if (respData.resData == null) {
                        isCommandRunning = false;
                        respData.statusCode = 21;
                        return 21;
                    }
                    if (respData.resData.length == 1 && respData.resData[0] == 0) {
                        isCommandRunning = false;
                        respData.statusCode = 3;
                        return 3;
                    }
                    rt = 9;
                    int len = respData.resData.length;
                    if (len > 11) {
                        rt = respData.resData[11];
                        cmd = respData.resData[10];
                        if (cmd == -18 && rt == -16) break;
                        if (rt != 0) {
                            rt = 9;
                        }
                    }
                }
                if (loopNum >= maxLoopNum || rt == 0 && cmd == 3) continue;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException len) {
                    // empty catch block
                }
            } while (loopNum < maxLoopNum && (rt != 0 || cmd != 3));
        }
        byte[][] getAIDList = Common.getAIDList(respData.resData, true);
        if (getAIDList != null) {
            respData.stringArray = new String[getAIDList.length];
            for (int i = 0; i < respData.stringArray.length; ++i) {
                if (getAIDList[i].length <= 0) continue;
                respData.stringArray[i] = Common.base16Encode(getAIDList[i]);
            }
        } else {
            respData.stringArray = null;
        }
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int emv_retrieveAidList(ResDataStruct respData) {
        TaskManager.TaskStartRet r;
        block21: {
            block23: {
                int len2;
                int loopNum;
                int rt;
                int cmd;
                block22: {
                    if (respData == null) {
                        return 27392;
                    }
                    if (!readyForNextCommand || !readyForCardSwipe) {
                        respData.statusCode = 29696;
                        return 29696;
                    }
                    if (!this.isICCDeviceSelected() || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_USB) {
                        respData.statusCode = 20;
                        return 20;
                    }
                    if (!this.device_isConnected()) {
                        respData.statusCode = 1;
                        return 1;
                    }
                    cmd = 0;
                    rt = 9;
                    isCommandRunning = true;
                    this.waitForNotification();
                    if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VENDI && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) break block22;
                    if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V) {
                        this.waitForVivo();
                    }
                    loopNum = 0;
                    do {
                        r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)96, (byte)7, new byte[0])), 0, respData);
                        ++loopNum;
                        if (r == TaskManager.TaskStartRet.SUCCESS) {
                            if (respData.resData == null) {
                                isCommandRunning = false;
                                respData.statusCode = 21;
                                return 21;
                            }
                            if (respData.resData.length == 1 && respData.resData[0] == 0) {
                                isCommandRunning = false;
                                respData.statusCode = 3;
                                return 3;
                            }
                            rt = 9;
                            len2 = respData.resData.length;
                            if (len2 > 11) {
                                rt = respData.resData[11];
                                cmd = respData.resData[10];
                                if (cmd == -18 && rt == -16) break block21;
                                if (rt != 0) {
                                    rt = 9;
                                }
                            }
                        }
                        if (loopNum >= maxLoopNum || rt == 0 && cmd == 96) continue;
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException len2) {
                            // empty catch block
                        }
                    } while (loopNum < maxLoopNum && (rt != 0 || cmd != 96));
                    break block21;
                    {
                    }
                }
                if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) break block23;
                loopNum = 0;
                do {
                    r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)3, (byte)5, new byte[0])), 0, respData);
                    ++loopNum;
                    if (r != TaskManager.TaskStartRet.SUCCESS) continue;
                    if (respData.resData == null) {
                        isCommandRunning = false;
                        respData.statusCode = 21;
                        return 21;
                    }
                    if (respData.resData.length == 1 && respData.resData[0] == 0) {
                        isCommandRunning = false;
                        respData.statusCode = 3;
                        return 3;
                    }
                    rt = 9;
                    len2 = respData.resData.length;
                    if (len2 <= 11) continue;
                    rt = respData.resData[11];
                    cmd = respData.resData[10];
                    if (cmd == -18 && rt == -16) break block21;
                    if (rt == 0) continue;
                    rt = 9;
                } while (loopNum < maxLoopNum && (rt != 0 || cmd != 3));
                break block21;
                {
                }
            }
            r = connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA ? this.sendCommand_helper("72460301", 0, respData) : this.sendCommand_helper("72468104", 0, respData);
        }
        byte[][] getAIDList = Common.getAIDList(respData.resData, false);
        if (getAIDList != null) {
            respData.stringArray = new String[getAIDList.length];
            for (int i = 0; i < respData.stringArray.length; ++i) {
                if (getAIDList[i].length <= 0) continue;
                respData.stringArray[i] = Common.base16Encode(getAIDList[i]);
            }
        } else {
            respData.stringArray = null;
        }
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int ctls_retrieveTerminalData(ResDataStruct respData) {
        TaskManager.TaskStartRet r;
        if (respData == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            respData.statusCode = 29696;
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VENDI && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
            respData.statusCode = 20;
            return 20;
        }
        if (!this.device_isConnected()) {
            respData.statusCode = 1;
            return 1;
        }
        int cmd = 0;
        int rt = 9;
        isCommandRunning = true;
        this.waitForNotification();
        int loopNum = 0;
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)3, (byte)2, new byte[0])), 0, respData);
            ++loopNum;
            if (r == TaskManager.TaskStartRet.SUCCESS) {
                if (respData.resData == null) {
                    isCommandRunning = false;
                    respData.statusCode = 21;
                    return 21;
                }
                if (respData.resData.length == 1 && respData.resData[0] == 0) {
                    isCommandRunning = false;
                    respData.statusCode = 3;
                    return 3;
                }
                rt = 9;
                int len = respData.resData.length;
                if (len > 11) {
                    rt = respData.resData[11];
                    cmd = respData.resData[10];
                    if (cmd == -18 && rt == -16) break;
                    if (rt != 0) {
                        rt = 9;
                    }
                }
            }
            if (loopNum >= maxLoopNum || rt == 0 && cmd == 3) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException len) {
                // empty catch block
            }
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != 3));
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int emv_retrieveTerminalData(ResDataStruct respData) {
        if (respData == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            respData.statusCode = 29696;
            return 29696;
        }
        if (!(this.isICCDeviceSelected() && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI)) {
            respData.statusCode = 20;
            return 20;
        }
        if (!this.device_isConnected()) {
            respData.statusCode = 1;
            return 1;
        }
        int cmd = 0;
        int rt = 9;
        isCommandRunning = true;
        this.waitForNotification();
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
            TaskManager.TaskStartRet r;
            if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V) {
                this.waitForVivo();
            }
            int loopNum = 0;
            do {
                r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)96, (byte)4, new byte[0])), 0, respData);
                ++loopNum;
                if (r == TaskManager.TaskStartRet.SUCCESS) {
                    if (respData.resData == null) {
                        isCommandRunning = false;
                        respData.statusCode = 21;
                        return 21;
                    }
                    if (respData.resData.length == 1 && respData.resData[0] == 0) {
                        isCommandRunning = false;
                        respData.statusCode = 3;
                        return 3;
                    }
                    rt = 9;
                    int len = respData.resData.length;
                    if (len > 11) {
                        rt = respData.resData[11];
                        cmd = respData.resData[10];
                        if (cmd == -18 && rt == -16) break;
                        if (rt != 0) {
                            rt = 9;
                        }
                    }
                }
                if (loopNum >= maxLoopNum || rt == 0 && cmd == 96) continue;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException len) {
                    // empty catch block
                }
            } while (loopNum < maxLoopNum && (rt != 0 || cmd != 96));
            int returnCode = this.returnACK(r, respData);
            this.convertIDG(respData, 2);
            isCommandRunning = false;
            respData.statusCode = returnCode;
            return returnCode;
        }
        TaskManager.TaskStartRet r = connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA ? this.sendCommand_helper("72460201", 0, respData) : this.sendCommand_helper("72468201", 0, respData);
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int emv_removeTerminalData(ResDataStruct respData) {
        TaskManager.TaskStartRet r;
        block14: {
            block15: {
                if (respData == null) {
                    return 27392;
                }
                if (!readyForNextCommand || !readyForCardSwipe) {
                    respData.statusCode = 29696;
                    return 29696;
                }
                if (!this.isICCDeviceSelected() || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_USB) {
                    respData.statusCode = 20;
                    return 20;
                }
                if (!this.device_isConnected()) {
                    respData.statusCode = 1;
                    return 1;
                }
                int cmd = 0;
                int rt = 9;
                isCommandRunning = true;
                this.waitForNotification();
                if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) break block15;
                if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V) {
                    this.waitForVivo();
                }
                int loopNum = 0;
                do {
                    r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)96, (byte)5, new byte[0])), 0, respData);
                    ++loopNum;
                    if (r == TaskManager.TaskStartRet.SUCCESS) {
                        if (respData.resData == null) {
                            isCommandRunning = false;
                            respData.statusCode = 21;
                            return 21;
                        }
                        if (respData.resData.length == 1 && respData.resData[0] == 0) {
                            isCommandRunning = false;
                            respData.statusCode = 3;
                            return 3;
                        }
                        rt = 9;
                        int len = respData.resData.length;
                        if (len > 11) {
                            rt = respData.resData[11];
                            cmd = respData.resData[10];
                            if (cmd == -18 && rt == -16) break block14;
                            if (rt != 0) {
                                rt = 9;
                            }
                        }
                    }
                    if (loopNum >= maxLoopNum || rt == 0 && cmd == 96) continue;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while (loopNum < maxLoopNum && (rt != 0 || cmd != 96));
                break block14;
                {
                }
            }
            r = connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA ? this.sendCommand_helper("72460202", 0, respData) : this.sendCommand_helper("72468202", 0, respData);
        }
        int returnCode = this.returnACK(r, respData);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    private int keyCmd(byte cmd, boolean hasData, byte[] data, Gen2DataStruct respData) {
        int ret;
        Gen2DataStruct gen2Data = new Gen2DataStruct();
        byte[] mac = Common.getByteArray("0000000000000000");
        int offset = 0;
        if (data.length > 127) {
            ++offset;
        }
        if (data.length > 255) {
            ++offset;
        }
        int jwsoffset = 0;
        if (cmd == 24 || cmd == 26) {
            jwsoffset = 7;
        }
        byte[] data2 = new byte[4 + offset + data.length + jwsoffset];
        int pos = 0;
        data2[pos++] = -33;
        data2[pos++] = -1;
        data2[pos++] = cmd;
        if (offset == 2) {
            data2[pos++] = -126;
            data2[pos++] = (byte)(data.length >> 8 & 0xFF);
            data2[pos++] = (byte)(data.length & 0xFF);
        } else if (offset == 1) {
            data2[pos++] = -127;
            data2[pos++] = (byte)data.length;
        } else {
            data2[pos++] = (byte)data.length;
        }
        System.arraycopy(data, 0, data2, pos, data.length);
        pos += data.length;
        if (jwsoffset > 0) {
            data2[pos++] = -33;
            data2[pos++] = -1;
            data2[pos++] = 31;
            data2[pos++] = 3;
            data2[pos++] = 74;
            data2[pos++] = 87;
            data2[pos++] = 84;
        }
        if ((ret = this.device_sendGen2Cmd(data2, mac, gen2Data, 6)) != 0) {
            return ret;
        }
        if (respData == null) {
            respData = new Gen2DataStruct();
        }
        respData.statusCode = gen2Data.payload[gen2Data.payload.length - 1];
        if (hasData && gen2Data.payload.length > 9) {
            int len = Common.byteToUnsignedInt(gen2Data.payload[3]);
            if (len == 130) {
                len = Common.byteToUnsignedInt(gen2Data.payload[4]) * 256 + Common.byteToUnsignedInt(gen2Data.payload[5]);
                respData.payload = new byte[len];
                System.arraycopy(gen2Data.payload, 6, respData.payload, 0, len);
            } else if (len == 129) {
                len = Common.byteToUnsignedInt(gen2Data.payload[4]);
                respData.payload = new byte[len];
                System.arraycopy(gen2Data.payload, 5, respData.payload, 0, len);
            } else {
                respData.payload = new byte[len];
                System.arraycopy(gen2Data.payload, 4, respData.payload, 0, len);
            }
        }
        return ret;
    }

    public int expireSessionKeys(Gen2DataStruct respData) {
        return this.keyCmd((byte)8, false, new byte[]{1}, respData);
    }

    public int removeEnrollment(Gen2DataStruct respData) {
        return this.keyCmd((byte)7, false, new byte[]{1}, respData);
    }

    public int getSessionKeyStatus(Gen2DataStruct respData) {
        return this.keyCmd((byte)6, false, new byte[]{1}, respData);
    }

    public int startVTRTPolling(byte timeout, Gen2DataStruct respData) {
        if (timeout < 1 || timeout > 255) {
            return 27392;
        }
        return this.keyCmd((byte)23, false, new byte[]{timeout}, respData);
    }

    public int cancelVTRTPolling(Gen2DataStruct respData) {
        return this.keyCmd((byte)23, false, new byte[]{0}, respData);
    }

    public String createFastEMVData(IDTEMVData emvData) {
        String fastEMV = "";
        StringBuilder dfff23 = null;
        byte[] cardData = null;
        boolean _swipeCaptured = false;
        if (emvData != null && emvData.msr_cardData != null && emvData.msr_cardData.rawTrackData != null && emvData.msr_cardData.rawTrackData.length > 0) {
            cardData = emvData.msr_cardData.rawTrackData;
        } else if (emvData != null && emvData.unencryptedTags != null && emvData.encryptedTags.containsKey("DFEE23")) {
            cardData = emvData.encryptedTags.get("DFEE23");
        }
        if (cardData != null) {
            byte[] b;
            if (!emvData.msr_cardData.iccPresent) {
                return Common.msrToKB(cardData);
            }
            dfff23 = new StringBuilder();
            dfff23.append("DFEE23");
            boolean bLen = false;
            int cardLen = cardData.length;
            if (cardLen < 127) {
                b = new byte[]{(byte)cardLen};
                dfff23.append(Common.bytesToHex(b));
            } else if (cardLen < 256) {
                b = new byte[]{-127, (byte)cardLen};
                dfff23.append(Common.bytesToHex(b));
            } else {
                b = new byte[]{-127, (byte)(cardLen / 256), (byte)(cardLen % 256)};
                dfff23.append(Common.bytesToHex(b));
            }
            dfff23.append(Common.msrToKB(cardData));
        }
        if (emvData != null && emvData.msr_cardData != null && emvData.msr_cardData.rawTrackData != null && emvData.msr_cardData.rawTrackData.length > 0) {
            _swipeCaptured = true;
        }
        if (emvData == null) {
            return fastEMV;
        }
        if (emvData != null && emvData.msr_cardData != null && emvData.msr_cardData.iccPresent) {
            emvData.cardType = 1;
        }
        if (_swipeCaptured && emvData.cardType != 1) {
            return Common.bytesToHex(emvData.msr_cardData.rawTrackData);
        }
        int rt = -1;
        HashMap<String, Map<String, byte[]>> _cardTLV = new HashMap<String, Map<String, byte[]>>();
        byte[] tagx = null;
        tagx = _swipeCaptured ? Common.hexStringToByteArray("4F50575A5F205F245F2A5F305F3482848A959A9B9C9F029F039F069F079F099F0D9F0E9F0F9F109F129F1A9F1E9F219F269F279F339F349F359F369F379F399F409F419F539F7CDFEE12DFEE25DFEE26DFEF57DFEF5BDFEF5D") : Common.hexStringToByteArray("4F50575A5F205F245F2A5F305F3482848A959A9B9C9F029F039F069F079F099F0D9F0E9F0F9F109F129F1A9F1E9F219F269F279F339F349F359F369F379F399F409F419F539F7CDFEE12DFEE25DFEE26DFEF57DFEF5BDFEF5DDFEE23");
        rt = this.emv_retrieveTransactionResult(tagx, _cardTLV);
        if (rt != 0) {
            return "";
        }
        Map<String, byte[]> unenc = null;
        Map<String, byte[]> masked = null;
        Map<String, byte[]> enc = null;
        HashMap<String, byte[]> finalTags = new HashMap<String, byte[]>();
        Map<Object, Object> ff8105unenc = new HashMap();
        Map<Object, Object> ff8105masked = new HashMap();
        Map<Object, Object> ff8105enc = new HashMap();
        Map<Object, Object> ff8106unenc = new HashMap();
        Map<Object, Object> ff8106masked = new HashMap();
        Map<Object, Object> ff8106enc = new HashMap();
        Map<Object, Object> ffee01unenc = new HashMap();
        Map<Object, Object> ffee01masked = new HashMap();
        Map<Object, Object> ffee01enc = new HashMap();
        if (_cardTLV != null) {
            Set ar;
            unenc = (Map<String, byte[]>)_cardTLV.get("tags");
            masked = (Map<String, byte[]>)_cardTLV.get("masked");
            enc = (Map<String, byte[]>)_cardTLV.get("encrypted");
            Set<Object> unencArray = unenc.keySet();
            Set<Object> maskedArray = masked.keySet();
            Set<Object> encArray = enc.keySet();
            if (emvData.unencryptedTags != null && emvData.unencryptedTags.size() > 0) {
                Set<String> unencArrayOrig = emvData.unencryptedTags.keySet();
                for (String string : unencArrayOrig) {
                    if (string.equals("FF8105")) {
                        Map<String, Map<String, byte[]>> map = Common.processTLV(emvData.unencryptedTags.get(string));
                        ff8105unenc = map.get("tags");
                        ff8105masked = map.get("masked");
                        ff8105enc = map.get("encrypted");
                    } else if (string.equals("FF8106")) {
                        Map<String, Map<String, byte[]>> map = Common.processTLV(emvData.unencryptedTags.get(string));
                        ff8106unenc = map.get("tags");
                        ff8106masked = map.get("masked");
                        ff8106enc = map.get("encrypted");
                    } else if (string.equals("FFEE01")) {
                        Map<String, Map<String, byte[]>> map = Common.processTLV(emvData.unencryptedTags.get(string));
                        ffee01unenc = map.get("tags");
                        ffee01masked = map.get("masked");
                        ffee01enc = map.get("encrypted");
                    } else if (unencArray.contains(string)) {
                        unenc.remove(string);
                        unenc.put(string, emvData.unencryptedTags.get(string));
                    } else {
                        unenc.put(string, emvData.unencryptedTags.get(string));
                    }
                    unencArray = unenc.keySet();
                }
            }
            unencArray = unenc.keySet();
            encArray = enc.keySet();
            maskedArray = masked.keySet();
            if (ff8106unenc != null && ff8106unenc.size() > 0) {
                ar = ff8106unenc.keySet();
                for (String string : ar) {
                    if (unencArray.contains(string)) {
                        unenc.remove(string);
                    }
                    unenc.put(string, (byte[])ff8106unenc.get(string));
                    unencArray = unenc.keySet();
                }
            }
            if (ff8105unenc != null && ff8105unenc.size() > 0) {
                ar = ff8105unenc.keySet();
                for (String string : ar) {
                    if (unencArray.contains(string)) {
                        unenc.remove(string);
                    }
                    unenc.put(string, (byte[])ff8105unenc.get(string));
                    unencArray = unenc.keySet();
                }
            }
            if (ffee01unenc != null && ffee01unenc.size() > 0) {
                ar = ffee01unenc.keySet();
                for (String string : ar) {
                    if (unencArray.contains(string)) {
                        unenc.remove(string);
                    }
                    unenc.put(string, (byte[])ffee01unenc.get(string));
                    unencArray = unenc.keySet();
                }
            }
            if (emvData.maskedTags != null && emvData.maskedTags.size() > 0) {
                ar = masked.keySet();
                for (String string : ar) {
                    if (unencArray.contains(string)) {
                        masked.remove(string);
                    }
                    masked.put(string, emvData.maskedTags.get(string));
                    maskedArray = masked.keySet();
                }
            }
            if (ff8106masked != null && ff8106masked.size() > 0) {
                ar = ff8106masked.keySet();
                for (String string : ar) {
                    if (unencArray.contains(string)) {
                        masked.remove(string);
                    }
                    masked.put(string, (byte[])ff8106masked.get(string));
                    maskedArray = masked.keySet();
                }
            }
            if (ff8105masked != null && ff8105masked.size() > 0) {
                ar = ff8105masked.keySet();
                for (String string : ar) {
                    if (unencArray.contains(string)) {
                        masked.remove(string);
                    }
                    masked.put(string, (byte[])ff8105masked.get(string));
                    maskedArray = masked.keySet();
                }
            }
            if (ffee01masked != null && ffee01masked.size() > 0) {
                ar = ffee01masked.keySet();
                for (String string : ar) {
                    if (unencArray.contains(string)) {
                        masked.remove(string);
                    }
                    masked.put(string, (byte[])ffee01masked.get(string));
                    maskedArray = masked.keySet();
                }
            }
            if (emvData.encryptedTags != null && emvData.encryptedTags.size() > 0) {
                ar = enc.keySet();
                for (String string : ar) {
                    if (unencArray.contains(string)) {
                        enc.remove(string);
                    }
                    enc.put(string, emvData.encryptedTags.get(string));
                    encArray = enc.keySet();
                }
            }
            if (ff8106enc != null && ff8106enc.size() > 0) {
                ar = ff8106enc.keySet();
                for (String string : ar) {
                    if (unencArray.contains(string)) {
                        enc.remove(string);
                    }
                    enc.put(string, (byte[])ff8106enc.get(string));
                    encArray = enc.keySet();
                }
            }
            if (ff8105enc != null && ff8105enc.size() > 0) {
                ar = ff8105enc.keySet();
                for (String string : ar) {
                    if (unencArray.contains(string)) {
                        enc.remove(string);
                    }
                    enc.put(string, (byte[])ff8105enc.get(string));
                    encArray = enc.keySet();
                }
            }
            if (ffee01enc != null && ffee01enc.size() > 0) {
                ar = ffee01enc.keySet();
                for (String string : ar) {
                    if (unencArray.contains(string)) {
                        enc.remove(string);
                    }
                    enc.put(string, (byte[])ffee01enc.get(string));
                    encArray = enc.keySet();
                }
            }
            for (String key : encArray) {
                if (unencArray.contains(key)) {
                    unenc.remove(key);
                }
                unenc.put(key, enc.get(key));
                unencArray = unenc.keySet();
            }
            unenc = Common.updateTags_Old_To_New(unenc);
            masked = Common.updateTags_Old_To_New(masked);
            enc = Common.updateTags_Old_To_New(enc);
            byte[] val = null;
            Set finalArray = finalTags.keySet();
            for (String string : unencArray) {
                val = unenc.get(string);
                if (val != null && val.length > 0) {
                    finalTags.put(string, val);
                }
                finalArray = finalTags.keySet();
            }
            val = masked.get("57");
            if (val != null && val.length > 0 && !finalArray.contains("DFEF5D")) {
                finalTags.put("DFEF5D", val);
            }
            finalArray = finalTags.keySet();
            val = masked.get("56");
            if (val != null && val.length > 0 && !finalArray.contains("DFEF5C")) {
                finalTags.put("DFEF5C", val);
            }
            finalArray = finalTags.keySet();
            val = masked.get("5A");
            if (val != null && val.length > 0 && !finalArray.contains("DFEF5B")) {
                finalTags.put("DFEF5B", val);
            }
            finalArray = finalTags.keySet();
            val = masked.get("9F6B");
            if (val != null && val.length > 0 && !finalArray.contains("DFEF5E")) {
                finalTags.put("DFEF5E", val);
            }
            finalArray = finalTags.keySet();
            val = masked.get("FFEE13");
            if (val != null && val.length > 0 && !finalArray.contains("DFEF5F")) {
                finalTags.put("DFEF5F", val);
            }
            finalArray = finalTags.keySet();
            val = masked.get("FFEE14");
            if (val != null && val.length > 0 && !finalArray.contains("DFEF60")) {
                finalTags.put("DFEF60", val);
            }
            finalArray = finalTags.keySet();
            if (_swipeCaptured) {
                val = masked.get("DFEE23");
                if (val != null && val.length > 0) {
                    String string = Common.bytesToHex(emvData.msr_cardData.rawTrackData);
                    val = string.startsWith("8") || string.startsWith("9") || string.startsWith("C") || string.startsWith("c") ? Common.makeCommand(string) : emvData.msr_cardData.rawTrackData;
                    if (!finalArray.contains("DFEE23")) {
                        finalTags.put("DFEE23", val);
                    }
                }
                finalArray = finalTags.keySet();
                val = masked.get("9F39");
                if (val != null && val.length > 0) {
                    finalTags.remove("9F39");
                }
                val = new byte[]{-128};
                finalTags.put("9F39", val);
                finalArray = finalTags.keySet();
            }
            StringBuilder stringBuilder = new StringBuilder();
            val = (byte[])finalTags.get("DFEE25");
            if (_swipeCaptured) {
                stringBuilder.append("DFEE25025005");
            } else if (val != null && val.length > 0) {
                stringBuilder.append(Common.tagToString("DFEE25", val));
            } else {
                stringBuilder.append("DFEE25025001");
            }
            finalTags.remove("DFEE25");
            finalArray = finalTags.keySet();
            val = (byte[])finalTags.get("DFEE26");
            if (val != null && val.length > 0) {
                stringBuilder.append(Common.tagToString("DFEE26", val));
                finalTags.remove("DFEE26");
                finalArray = finalTags.keySet();
            }
            if ((val = (byte[])finalTags.get("DFEE12")) != null && val.length > 0) {
                stringBuilder.append(Common.tagToString("DFEE12", val));
                finalTags.remove("DFEE12");
                finalArray = finalTags.keySet();
            }
            if (_swipeCaptured) {
                stringBuilder.append("9F390180");
                finalTags.remove("9F39");
                if (dfff23 != null) {
                    val = (byte[])finalTags.get("DFFF23");
                    if (val != null && val.length > 0) {
                        finalTags.remove("DFFF23");
                    }
                    stringBuilder.append((CharSequence)dfff23);
                }
                finalArray = finalTags.keySet();
            }
            for (String key : finalArray) {
                val = (byte[])finalTags.get(key);
                stringBuilder.append(Common.tagToString(key, val));
            }
            return stringBuilder.toString().toUpperCase();
        }
        return fastEMV;
    }

    public int startVTRT(byte[] data, Gen2DataStruct respData) {
        return this.keyCmd((byte)28, true, data, respData);
    }

    public int finalizeVTRT(byte[] data, Gen2DataStruct respData) {
        return this.keyCmd((byte)30, false, data, respData);
    }

    public int startSession(byte[] data, Gen2DataStruct respData) {
        return this.keyCmd((byte)24, true, data, respData);
    }

    public int finalizeSession(byte[] data, Gen2DataStruct respData) {
        return this.keyCmd((byte)26, false, data, respData);
    }

    public int device_sendGen2Cmd(byte[] encPayload, byte[] payloadMac, Gen2DataStruct respData, int timeout) {
        int dataLen;
        Common.isGen2 = true;
        if (respData == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            respData.statusCode = 29696;
            return 29696;
        }
        if (encPayload == null || encPayload.length == 0) {
            respData.statusCode = 27392;
            return 27392;
        }
        if (payloadMac == null || payloadMac.length != 8) {
            respData.statusCode = 27392;
            return 27392;
        }
        int tlvLen = 16 + encPayload.length;
        if (encPayload.length > 255) {
            tlvLen += 2;
        } else if (encPayload.length > 127) {
            ++tlvLen;
        }
        byte[] TLV = new byte[tlvLen];
        int pos = 0;
        TLV[pos++] = -33;
        TLV[pos++] = -1;
        TLV[pos++] = 1;
        if (encPayload.length > 255) {
            TLV[pos++] = -126;
            TLV[pos++] = (byte)(encPayload.length >> 8 & 0xFF);
            TLV[pos++] = (byte)(encPayload.length & 0xFF);
        } else if (encPayload.length > 127) {
            TLV[pos++] = -127;
            TLV[pos++] = (byte)(encPayload.length & 0xFF);
        } else {
            TLV[pos++] = (byte)(encPayload.length & 0xFF);
        }
        for (int x = 0; x < encPayload.length; ++x) {
            TLV[pos++] = encPayload[x];
        }
        TLV[pos++] = -33;
        TLV[pos++] = -1;
        TLV[pos++] = 2;
        TLV[pos++] = 8;
        boolean notZero = false;
        for (int x = 0; x < payloadMac.length; ++x) {
            TLV[pos++] = payloadMac[x];
            if (payloadMac[x] == 0) continue;
            notZero = true;
        }
        if (!notZero) {
            TLV[0] = -1;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VENDI && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
            respData.statusCode = 20;
            return 20;
        }
        if (!this.device_isConnected()) {
            respData.statusCode = 1;
            return 1;
        }
        int n = dataLen = TLV == null ? 0 : TLV.length;
        if (dataLen < 1 || dataLen > 2032) {
            respData.statusCode = 27392;
            return 27392;
        }
        int cmd = 0;
        int rt = 9;
        byte[] data = TLV;
        isCommandRunning = true;
        this.waitForNotification();
        ResDataStruct gen2Data = new ResDataStruct();
        int loopNum = 0;
        TaskManager.TaskStartRet r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-96, (byte)0, data)), timeout, gen2Data);
        ++loopNum;
        if (r == TaskManager.TaskStartRet.SUCCESS) {
            int myDataLen;
            byte[] tlvData;
            Map<String, Map<String, byte[]>> TLVDict;
            Map<String, byte[]> tags;
            if (gen2Data.resData == null) {
                isCommandRunning = false;
                respData.statusCode = 21;
                return 21;
            }
            if (gen2Data.resData.length == 1 && gen2Data.resData[0] == 0) {
                isCommandRunning = false;
                gen2Data.statusCode = 3;
                return 3;
            }
            rt = 9;
            int len = gen2Data.resData.length;
            if (len > 11) {
                rt = gen2Data.resData[11];
                cmd = gen2Data.resData[10];
                if (rt != 0) {
                    rt = 9;
                }
            }
            if (!(tags = (TLVDict = Common.processTLV(tlvData = Arrays.copyOfRange(gen2Data.resData, 14, 14 + (myDataLen = (gen2Data.resData[12] & 0xFF) * 256 + (gen2Data.resData[13] & 0xFF))))).get("tags")).isEmpty()) {
                respData.payload = tags.get("DFFF01");
                if (respData.payload == null) {
                    respData.payload = tags.get("FFFF01");
                }
                respData.macData = tags.get("DFFF02");
                respData.bleName = tags.get("DFFF09");
            }
        }
        if (loopNum < maxLoopNum && (rt != 0 || cmd != 160)) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException len) {
                // empty catch block
            }
        }
        int returnCode = rt;
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int ctls_setTerminalData(byte[] TLV, ResDataStruct respData) {
        TaskManager.TaskStartRet r;
        int dataLen;
        if (respData == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            respData.statusCode = 29696;
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VENDI && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
            respData.statusCode = 20;
            return 20;
        }
        if (!this.device_isConnected()) {
            respData.statusCode = 1;
            return 1;
        }
        int n = dataLen = TLV == null ? 0 : TLV.length;
        if (dataLen < 1 || dataLen > 2032) {
            respData.statusCode = 27392;
            return 27392;
        }
        int cmd = 0;
        int rt = 9;
        byte[] data = TLV;
        isCommandRunning = true;
        this.waitForNotification();
        int loopNum = 0;
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)4, (byte)0, data)), 0, respData);
            ++loopNum;
            if (r == TaskManager.TaskStartRet.SUCCESS) {
                if (respData.resData == null) {
                    isCommandRunning = false;
                    respData.statusCode = 21;
                    return 21;
                }
                if (respData.resData.length == 1 && respData.resData[0] == 0) {
                    isCommandRunning = false;
                    respData.statusCode = 3;
                    return 3;
                }
                rt = 9;
                int len = respData.resData.length;
                if (len > 11) {
                    rt = respData.resData[11];
                    cmd = respData.resData[10];
                    if (cmd == -18 && rt == -16) break;
                    if (rt != 0) {
                        rt = 9;
                    }
                }
            }
            if (loopNum >= maxLoopNum || rt == 0 && cmd == 4) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException len) {
                // empty catch block
            }
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != 4));
        int returnCode = this.returnACK(r, respData);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int emv_setTerminalData(byte[] TLV, ResDataStruct respData) {
        TaskManager.TaskStartRet r;
        block16: {
            byte[] data;
            block17: {
                int dataLen;
                if (respData == null) {
                    return 27392;
                }
                if (!readyForNextCommand || !readyForCardSwipe) {
                    respData.statusCode = 29696;
                    return 29696;
                }
                if (!(this.isICCDeviceSelected() && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI)) {
                    respData.statusCode = 20;
                    return 20;
                }
                if (!this.device_isConnected()) {
                    respData.statusCode = 1;
                    return 1;
                }
                int n = dataLen = TLV == null ? 0 : TLV.length;
                if (dataLen < 1 || dataLen > 2032) {
                    respData.statusCode = 27392;
                    return 27392;
                }
                int cmd = 0;
                int rt = 9;
                data = new byte[TLV.length + 2];
                Map<String, Map<String, byte[]>> TLVDict = Common.processTLV(TLV);
                Map<String, byte[]> unencryptedTags = null;
                if (TLVDict != null) {
                    unencryptedTags = TLVDict.get("tags");
                    data[0] = (byte)unencryptedTags.size();
                    data[1] = 0;
                }
                System.arraycopy(TLV, 0, data, 2, TLV.length);
                isCommandRunning = true;
                this.waitForNotification();
                if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) break block17;
                if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V) {
                    this.waitForVivo();
                }
                int loopNum = 0;
                do {
                    r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)96, (byte)6, data)), 0, respData);
                    ++loopNum;
                    if (r == TaskManager.TaskStartRet.SUCCESS) {
                        if (respData.resData == null) {
                            isCommandRunning = false;
                            respData.statusCode = 21;
                            return 21;
                        }
                        if (respData.resData.length == 1 && respData.resData[0] == 0) {
                            isCommandRunning = false;
                            respData.statusCode = 3;
                            return 3;
                        }
                        rt = 9;
                        int len = respData.resData.length;
                        if (len > 11) {
                            rt = respData.resData[11];
                            cmd = respData.resData[10];
                            if (cmd == -18 && rt == -16) break block16;
                            if (rt != 0) {
                                rt = 9;
                            }
                        }
                    }
                    if (loopNum >= maxLoopNum || rt == 0 && cmd == 96) continue;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while (loopNum < maxLoopNum && (rt != 0 || cmd != 96));
                break block16;
                {
                }
            }
            r = connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA ? this.sendCommand_helper("72460203" + Common.bytesToHex(data), 0, respData) : this.sendCommand_helper("72468203" + Common.bytesToHex(data), 0, respData);
        }
        int returnCode = this.returnACK(r, respData);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int emv_setTerminalMajorConfiguration(int configuration) {
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (configuration < 1 || configuration > 23) {
            return 27392;
        }
        int cmd = 0;
        int rt = 9;
        ResDataStruct respData = new ResDataStruct();
        isCommandRunning = true;
        this.waitForNotification();
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V) {
            this.waitForVivo();
        }
        int loopNum = 0;
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)96, (byte)22, new byte[]{(byte)configuration})), 0, respData);
            ++loopNum;
            if (r == TaskManager.TaskStartRet.SUCCESS) {
                if (respData.resData == null) {
                    isCommandRunning = false;
                    respData.statusCode = 21;
                    return 21;
                }
                if (respData.resData.length == 1 && respData.resData[0] == 0) {
                    isCommandRunning = false;
                    respData.statusCode = 3;
                    return 3;
                }
                rt = 9;
                int len = respData.resData.length;
                if (len > 11) {
                    rt = respData.resData[11];
                    cmd = respData.resData[10];
                    if (cmd == -18 && rt == -16) break;
                    if (rt != 0) {
                        rt = 9;
                    }
                }
            }
            if (loopNum >= maxLoopNum || rt == 0 && cmd == 96) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException len) {
                // empty catch block
            }
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != 96));
        int returnCode = this.returnACK(r, respData);
        isCommandRunning = false;
        return returnCode;
    }

    public int ctls_retrieveCAPK(byte[] capk, ResDataStruct respData) {
        TaskManager.TaskStartRet r;
        int dataLen;
        if (respData == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            respData.statusCode = 29696;
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VENDI && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
            respData.statusCode = 20;
            return 20;
        }
        if (!this.device_isConnected()) {
            respData.statusCode = 1;
            return 1;
        }
        int n = dataLen = capk == null ? 0 : capk.length;
        if (dataLen < 5 || dataLen > 16) {
            respData.statusCode = 27392;
            return 27392;
        }
        int cmd = 0;
        int rt = 9;
        isCommandRunning = true;
        this.waitForNotification();
        byte[] newData = new byte[capk.length + 1];
        newData[0] = 1;
        System.arraycopy(capk, 0, newData, 1, capk.length);
        int loopNum = 0;
        do {
            r = connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT ? this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-48, (byte)1, newData)), 0, respData) : this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-48, (byte)1, capk)), 0, respData);
            ++loopNum;
            if (r == TaskManager.TaskStartRet.SUCCESS) {
                if (respData.resData == null) {
                    isCommandRunning = false;
                    respData.statusCode = 21;
                    return 21;
                }
                if (respData.resData.length == 1 && respData.resData[0] == 0) {
                    isCommandRunning = false;
                    respData.statusCode = 3;
                    return 3;
                }
                rt = 9;
                int len = respData.resData.length;
                if (len > 11) {
                    rt = respData.resData[11];
                    cmd = respData.resData[10];
                    if (cmd == -18 && rt == -16) break;
                    if (rt != 0) {
                        rt = 9;
                    }
                }
            }
            if (loopNum >= maxLoopNum || rt == 0 && cmd == -48) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException len) {
                // empty catch block
            }
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != -48));
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int emv_retrieveCAPK(byte[] capk, ResDataStruct respData) {
        TaskManager.TaskStartRet r;
        block19: {
            block20: {
                int loopNum;
                int rt;
                int cmd;
                block21: {
                    int dataLen;
                    if (respData == null) {
                        return 27392;
                    }
                    if (!readyForNextCommand || !readyForCardSwipe) {
                        respData.statusCode = 29696;
                        return 29696;
                    }
                    if (!(this.isICCDeviceSelected() && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI)) {
                        respData.statusCode = 20;
                        return 20;
                    }
                    if (!this.device_isConnected()) {
                        respData.statusCode = 1;
                        return 1;
                    }
                    int n = dataLen = capk == null ? 0 : capk.length;
                    if (dataLen != 6) {
                        respData.statusCode = 27392;
                        return 27392;
                    }
                    cmd = 0;
                    rt = 9;
                    isCommandRunning = true;
                    this.waitForNotification();
                    if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) break block20;
                    if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V) {
                        this.waitForVivo();
                    }
                    byte[] newdata = null;
                    loopNum = 0;
                    if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) break block21;
                    newdata = new byte[capk.length + 1];
                    newdata[0] = 2;
                    System.arraycopy(capk, 0, newdata, 1, capk.length);
                    do {
                        r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-48, (byte)33, newdata)), 0, respData);
                        ++loopNum;
                        if (r != TaskManager.TaskStartRet.SUCCESS) continue;
                        if (respData.resData == null) {
                            isCommandRunning = false;
                            respData.statusCode = 21;
                            return 21;
                        }
                        if (respData.resData.length == 1 && respData.resData[0] == 0) {
                            isCommandRunning = false;
                            respData.statusCode = 3;
                            return 3;
                        }
                        rt = 9;
                        int len = respData.resData.length;
                        if (len <= 11) continue;
                        rt = respData.resData[11];
                        cmd = respData.resData[10];
                        if (cmd == -18 && rt == -16) break block19;
                        if (rt == 0) continue;
                        rt = 9;
                    } while (loopNum < maxLoopNum && (rt != 0 || cmd != -48));
                    break block19;
                    {
                    }
                }
                do {
                    r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)96, (byte)8, capk)), 0, respData);
                    ++loopNum;
                    if (r == TaskManager.TaskStartRet.SUCCESS) {
                        if (respData.resData == null) {
                            isCommandRunning = false;
                            respData.statusCode = 21;
                            return 21;
                        }
                        if (respData.resData.length == 1 && respData.resData[0] == 0) {
                            isCommandRunning = false;
                            respData.statusCode = 3;
                            return 3;
                        }
                        rt = 9;
                        int len = respData.resData.length;
                        if (len > 11) {
                            rt = respData.resData[11];
                            cmd = respData.resData[10];
                            if (cmd == -18 && rt == -16) break block19;
                            if (rt != 0) {
                                rt = 9;
                            }
                        }
                    }
                    if (loopNum >= maxLoopNum || rt == 0 && cmd == 96) continue;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while (loopNum < maxLoopNum && (rt != 0 || cmd != 96));
                break block19;
            }
            r = connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA ? this.sendCommand_helper("72460401" + Common.bytesToHex(capk), 0, respData) : this.sendCommand_helper("72468401" + Common.bytesToHex(capk), 0, respData);
        }
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int ctls_removeCAPK(byte[] capk, ResDataStruct respData) {
        TaskManager.TaskStartRet r;
        int dataLen;
        if (respData == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            respData.statusCode = 29696;
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VENDI && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
            respData.statusCode = 20;
            return 20;
        }
        if (!this.device_isConnected()) {
            respData.statusCode = 1;
            return 1;
        }
        int n = dataLen = capk == null ? 0 : capk.length;
        if (dataLen != 6) {
            respData.statusCode = 27392;
            return 27392;
        }
        int cmd = 0;
        int rt = 9;
        isCommandRunning = true;
        this.waitForNotification();
        byte[] newcapk = new byte[capk.length + 1];
        newcapk[0] = 1;
        System.arraycopy(capk, 0, newcapk, 1, capk.length);
        int loopNum = 0;
        do {
            r = connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT ? this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-48, (byte)36, newcapk)), 0, respData) : this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-48, (byte)4, capk)), 0, respData);
            ++loopNum;
            if (r == TaskManager.TaskStartRet.SUCCESS) {
                if (respData.resData == null) {
                    isCommandRunning = false;
                    respData.statusCode = 21;
                    return 21;
                }
                if (respData.resData.length == 1 && respData.resData[0] == 0) {
                    isCommandRunning = false;
                    respData.statusCode = 3;
                    return 3;
                }
                rt = 9;
                int len = respData.resData.length;
                if (len > 11) {
                    rt = respData.resData[11];
                    cmd = respData.resData[10];
                    if (cmd == -18 && rt == -16) break;
                    if (rt != 0) {
                        rt = 9;
                    }
                }
            }
            if (loopNum >= maxLoopNum || rt == 0 && cmd == -48) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException len) {
                // empty catch block
            }
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != -48));
        int returnCode = this.returnACK(r, respData);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int emv_removeCAPK(byte[] capk, ResDataStruct respData) {
        TaskManager.TaskStartRet r;
        block19: {
            block20: {
                int loopNum;
                int rt;
                int cmd;
                block21: {
                    int dataLen;
                    if (respData == null) {
                        return 27392;
                    }
                    if (!readyForNextCommand || !readyForCardSwipe) {
                        respData.statusCode = 29696;
                        return 29696;
                    }
                    if (!(this.isICCDeviceSelected() && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI)) {
                        respData.statusCode = 20;
                        return 20;
                    }
                    if (!this.device_isConnected()) {
                        respData.statusCode = 1;
                        return 1;
                    }
                    int n = dataLen = capk == null ? 0 : capk.length;
                    if (dataLen != 6) {
                        respData.statusCode = 27392;
                        return 27392;
                    }
                    cmd = 0;
                    rt = 9;
                    isCommandRunning = true;
                    this.waitForNotification();
                    if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) break block20;
                    if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V) {
                        this.waitForVivo();
                    }
                    loopNum = 0;
                    if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) break block21;
                    byte[] newdata = new byte[capk.length + 1];
                    newdata[0] = 2;
                    System.arraycopy(capk, 0, newdata, 1, capk.length);
                    do {
                        r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-48, (byte)36, newdata)), 0, respData);
                        ++loopNum;
                        if (r != TaskManager.TaskStartRet.SUCCESS) continue;
                        if (respData.resData == null) {
                            isCommandRunning = false;
                            respData.statusCode = 21;
                            return 21;
                        }
                        if (respData.resData.length == 1 && respData.resData[0] == 0) {
                            isCommandRunning = false;
                            respData.statusCode = 3;
                            return 3;
                        }
                        rt = 9;
                        int len = respData.resData.length;
                        if (len <= 11) continue;
                        rt = respData.resData[11];
                        cmd = respData.resData[10];
                        if (cmd == -18 && rt == -16) break block19;
                        if (rt == 0) continue;
                        rt = 9;
                    } while (loopNum < maxLoopNum && (rt != 0 || cmd != -48));
                    break block19;
                    {
                    }
                }
                do {
                    r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)96, (byte)9, capk)), 0, respData);
                    ++loopNum;
                    if (r == TaskManager.TaskStartRet.SUCCESS) {
                        if (respData.resData == null) {
                            isCommandRunning = false;
                            respData.statusCode = 21;
                            return 21;
                        }
                        if (respData.resData.length == 1 && respData.resData[0] == 0) {
                            isCommandRunning = false;
                            respData.statusCode = 3;
                            return 3;
                        }
                        rt = 9;
                        int len = respData.resData.length;
                        if (len > 11) {
                            rt = respData.resData[11];
                            cmd = respData.resData[10];
                            if (cmd == -18 && rt == -16) break block19;
                            if (rt != 0) {
                                rt = 9;
                            }
                        }
                    }
                    if (loopNum >= maxLoopNum || rt == 0 && cmd == 96) continue;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while (loopNum < maxLoopNum && (rt != 0 || cmd != 96));
                break block19;
            }
            r = connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA ? this.sendCommand_helper("72460402" + Common.bytesToHex(capk), 0, respData) : this.sendCommand_helper("72468402" + Common.bytesToHex(capk), 0, respData);
        }
        int returnCode = this.returnACK(r, respData);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int ctls_setCAPK(byte[] data, ResDataStruct respData) {
        TaskManager.TaskStartRet r;
        int dataLen;
        if (respData == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            respData.statusCode = 29696;
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VENDI && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
            respData.statusCode = 20;
            return 20;
        }
        if (!this.device_isConnected()) {
            respData.statusCode = 1;
            return 1;
        }
        int n = dataLen = data == null ? 0 : data.length;
        if (dataLen < 1 || dataLen > 2032) {
            respData.statusCode = 27392;
            return 27392;
        }
        int cmd = 0;
        int rt = 9;
        isCommandRunning = true;
        this.waitForNotification();
        byte[] newData = new byte[data.length + 1];
        newData[0] = 1;
        System.arraycopy(data, 0, newData, 1, data.length);
        int loopNum = 0;
        do {
            r = connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT ? this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-48, (byte)35, newData)), 0, respData) : this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-48, (byte)3, data)), 0, respData);
            ++loopNum;
            if (r == TaskManager.TaskStartRet.SUCCESS) {
                if (respData.resData == null) {
                    isCommandRunning = false;
                    respData.statusCode = 21;
                    return 21;
                }
                if (respData.resData.length == 1 && respData.resData[0] == 0) {
                    isCommandRunning = false;
                    respData.statusCode = 3;
                    return 3;
                }
                rt = 9;
                int len = respData.resData.length;
                if (len > 11) {
                    rt = respData.resData[11];
                    cmd = respData.resData[10];
                    if (cmd == -18 && rt == -16) break;
                    if (rt != 0) {
                        rt = 9;
                    }
                }
            }
            if (loopNum >= maxLoopNum || rt == 0 && cmd == -48) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException len) {
                // empty catch block
            }
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != -48));
        int returnCode = this.returnACK(r, respData);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int emv_setCAPK(byte[] data, ResDataStruct respData) {
        TaskManager.TaskStartRet r;
        block19: {
            block20: {
                int loopNum;
                int rt;
                int cmd;
                block21: {
                    int dataLen;
                    if (respData == null) {
                        return 27392;
                    }
                    if (!readyForNextCommand || !readyForCardSwipe) {
                        respData.statusCode = 29696;
                        return 29696;
                    }
                    if (!(this.isICCDeviceSelected() && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI)) {
                        respData.statusCode = 20;
                        return 20;
                    }
                    if (!this.device_isConnected()) {
                        respData.statusCode = 1;
                        return 1;
                    }
                    int n = dataLen = data == null ? 0 : data.length;
                    if (dataLen < 1 || dataLen > 2032) {
                        respData.statusCode = 27392;
                        return 27392;
                    }
                    cmd = 0;
                    rt = 9;
                    isCommandRunning = true;
                    this.waitForNotification();
                    if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) break block20;
                    if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V) {
                        this.waitForVivo();
                    }
                    loopNum = 0;
                    if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) break block21;
                    byte[] newdata = new byte[data.length + 1];
                    newdata[0] = 2;
                    System.arraycopy(data, 0, newdata, 1, data.length);
                    do {
                        r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-48, (byte)35, newdata)), 0, respData);
                        ++loopNum;
                        if (r != TaskManager.TaskStartRet.SUCCESS) continue;
                        if (respData.resData == null) {
                            isCommandRunning = false;
                            respData.statusCode = 21;
                            return 21;
                        }
                        if (respData.resData.length == 1 && respData.resData[0] == 0) {
                            isCommandRunning = false;
                            respData.statusCode = 3;
                            return 3;
                        }
                        rt = 9;
                        int len = respData.resData.length;
                        if (len <= 11) continue;
                        rt = respData.resData[11];
                        cmd = respData.resData[10];
                        if (cmd == -18 && rt == -16) break block19;
                        if (rt == 0) continue;
                        rt = 9;
                    } while (loopNum < maxLoopNum && (rt != 0 || cmd != -48));
                    break block19;
                    {
                    }
                }
                do {
                    r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)96, (byte)10, data)), 0, respData);
                    ++loopNum;
                    if (r == TaskManager.TaskStartRet.SUCCESS) {
                        if (respData.resData == null) {
                            isCommandRunning = false;
                            respData.statusCode = 21;
                            return 21;
                        }
                        if (respData.resData.length == 1 && respData.resData[0] == 0) {
                            isCommandRunning = false;
                            respData.statusCode = 3;
                            return 3;
                        }
                        rt = 9;
                        int len = respData.resData.length;
                        if (len > 11) {
                            rt = respData.resData[11];
                            cmd = respData.resData[10];
                            if (cmd == -18 && rt == -16) break block19;
                            if (rt != 0) {
                                rt = 9;
                            }
                        }
                    }
                    if (loopNum >= maxLoopNum || rt == 0 && cmd == 96) continue;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while (loopNum < maxLoopNum && (rt != 0 || cmd != 96));
                break block19;
            }
            r = connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA ? this.sendCommand_helper("72460403" + Common.bytesToHex(data), 0, respData) : this.sendCommand_helper("72468403" + Common.bytesToHex(data), 0, respData);
        }
        int returnCode = this.returnACK(r, respData);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int ctls_retrieveCAPKList(ResDataStruct respData) {
        int returnCode;
        TaskManager.TaskStartRet r;
        if (respData == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            respData.statusCode = 29696;
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VENDI && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
            respData.statusCode = 20;
            return 20;
        }
        if (!this.device_isConnected()) {
            respData.statusCode = 1;
            return 1;
        }
        int cmd = 0;
        int rt = 9;
        isCommandRunning = true;
        this.waitForNotification();
        int loopNum = 0;
        ResDataStruct tempData = new ResDataStruct();
        do {
            r = connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT ? this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-48, (byte)38, new byte[]{1})), 0, tempData) : this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-48, (byte)6, new byte[0])), 0, tempData);
            ++loopNum;
            if (r == TaskManager.TaskStartRet.SUCCESS) {
                if (tempData.resData == null) {
                    isCommandRunning = false;
                    respData.statusCode = 21;
                    return 21;
                }
                if (tempData.resData.length == 1 && tempData.resData[0] == 0) {
                    isCommandRunning = false;
                    respData.statusCode = 3;
                    return 3;
                }
                rt = 9;
                int len = tempData.resData.length;
                if (len > 11) {
                    rt = tempData.resData[11];
                    cmd = tempData.resData[10];
                    if (cmd == -18 && rt == -16) break;
                    if (rt != 0) {
                        rt = 9;
                    }
                }
            }
            if (loopNum >= maxLoopNum || rt == 0 && cmd == -48) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException len) {
                // empty catch block
            }
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != -48));
        if ((returnCode = this.returnACK(r, tempData)) != 0) {
            respData.statusCode = returnCode;
            isCommandRunning = false;
            return returnCode;
        }
        this.convertIDG(tempData, 0);
        int numRid = tempData.resData.length / 5;
        ResDataStruct tmpData = new ResDataStruct();
        int index = 0;
        byte[] rid = new byte[2048];
        for (int i = 0; i < numRid; ++i) {
            byte[] data = new byte[5];
            System.arraycopy(tempData.resData, i * 5, data, 0, 5);
            loopNum = 0;
            do {
                r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-48, (byte)7, data)), 0, tmpData);
                ++loopNum;
                if (r != TaskManager.TaskStartRet.SUCCESS) continue;
                if (tmpData.resData == null) {
                    isCommandRunning = false;
                    respData.statusCode = 21;
                    return 21;
                }
                if (tmpData.resData.length == 1 && tmpData.resData[0] == 0) {
                    isCommandRunning = false;
                    respData.statusCode = 3;
                    return 3;
                }
                rt = 9;
                int len = tmpData.resData.length;
                if (len <= 11) continue;
                rt = tmpData.resData[11];
                cmd = tmpData.resData[10];
                if (cmd == -18 && rt == -16) break;
                if (rt == 0) continue;
                rt = 9;
            } while (loopNum < maxLoopNum && (rt != 0 || cmd != -48));
            returnCode = this.returnACK(r, tmpData);
            this.convertIDG(tmpData, 0);
            respData.statusCode = returnCode;
            if (returnCode == 0 && tmpData.resData.length > 5) {
                System.arraycopy(tmpData.resData, 0, data, 0, 5);
                for (int j = 0; j < tmpData.resData.length - 5; ++j) {
                    System.arraycopy(data, 0, rid, index, 5);
                    System.arraycopy(tmpData.resData, 5 + j, rid, index += 5, 1);
                    ++index;
                }
            } else {
                respData.resData = new byte[tmpData.resData.length];
                System.arraycopy(tmpData.resData, 0, respData.resData, 0, tmpData.resData.length);
                isCommandRunning = false;
                respData.statusCode = returnCode;
                return returnCode;
            }
            respData.resData = new byte[index];
            System.arraycopy(rid, 0, respData.resData, 0, index);
        }
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int emv_retrieveCAPKList(ResDataStruct respData) {
        TaskManager.TaskStartRet r;
        block18: {
            block19: {
                int loopNum;
                int rt;
                int cmd;
                block20: {
                    if (respData == null) {
                        return 27392;
                    }
                    if (!readyForNextCommand || !readyForCardSwipe) {
                        respData.statusCode = 29696;
                        return 29696;
                    }
                    if (!(this.isICCDeviceSelected() && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI)) {
                        return 20;
                    }
                    if (!this.device_isConnected()) {
                        respData.statusCode = 1;
                        return 1;
                    }
                    cmd = 0;
                    rt = 9;
                    isCommandRunning = true;
                    this.waitForNotification();
                    if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) break block19;
                    if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V) {
                        this.waitForVivo();
                    }
                    loopNum = 0;
                    if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) break block20;
                    do {
                        r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-48, (byte)38, new byte[]{2})), 0, respData);
                        ++loopNum;
                        if (r != TaskManager.TaskStartRet.SUCCESS) continue;
                        if (respData.resData == null) {
                            isCommandRunning = false;
                            respData.statusCode = 21;
                            return 21;
                        }
                        if (respData.resData.length == 1 && respData.resData[0] == 0) {
                            isCommandRunning = false;
                            respData.statusCode = 3;
                            return 3;
                        }
                        rt = 9;
                        int len = respData.resData.length;
                        if (len <= 11) continue;
                        rt = respData.resData[11];
                        cmd = respData.resData[10];
                        if (cmd == -18 && rt == -16) break block18;
                        if (rt == 0) continue;
                        rt = 9;
                    } while (loopNum < maxLoopNum && (rt != 0 || cmd != -48));
                    break block18;
                    {
                    }
                }
                do {
                    r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)96, (byte)11, new byte[0])), 0, respData);
                    ++loopNum;
                    if (r == TaskManager.TaskStartRet.SUCCESS) {
                        if (respData.resData == null) {
                            isCommandRunning = false;
                            respData.statusCode = 21;
                            return 21;
                        }
                        if (respData.resData.length == 1 && respData.resData[0] == 0) {
                            isCommandRunning = false;
                            respData.statusCode = 3;
                            return 3;
                        }
                        rt = 9;
                        int len = respData.resData.length;
                        if (len > 11) {
                            rt = respData.resData[11];
                            cmd = respData.resData[10];
                            if (cmd == -18 && rt == -16) break block18;
                            if (rt != 0) {
                                rt = 9;
                            }
                        }
                    }
                    if (loopNum >= maxLoopNum || rt == 0 && cmd == 96) continue;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while (loopNum < maxLoopNum && (rt != 0 || cmd != 96));
                break block18;
            }
            r = connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA ? this.sendCommand_helper("72460405", 0, respData) : this.sendCommand_helper("72468404", 0, respData);
        }
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int ctls_removeAllCAPK() {
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VENDI && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
            return 20;
        }
        ResDataStruct respData = new ResDataStruct();
        if (!this.device_isConnected()) {
            return 1;
        }
        int cmd = 0;
        int rt = 9;
        isCommandRunning = true;
        this.waitForNotification();
        int loopNum = 0;
        do {
            r = connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT ? this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-48, (byte)37, new byte[]{1})), 0, respData) : this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-48, (byte)5, new byte[0])), 0, respData);
            ++loopNum;
            if (r == TaskManager.TaskStartRet.SUCCESS) {
                if (respData.resData == null) {
                    isCommandRunning = false;
                    return 21;
                }
                if (respData.resData.length == 1 && respData.resData[0] == 0) {
                    isCommandRunning = false;
                    return 3;
                }
                rt = 9;
                int len = respData.resData.length;
                if (len > 11) {
                    rt = respData.resData[11];
                    cmd = respData.resData[10];
                    if (cmd == -18 && rt == -16) break;
                    if (rt != 0) {
                        rt = 9;
                    }
                }
            }
            if (loopNum >= maxLoopNum || rt == 0 && cmd == -48) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException len) {
                // empty catch block
            }
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != -48));
        int returnCode = this.returnACK(r, respData);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int emv_removeAllCAPK() {
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VENDI && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        ResDataStruct respData = new ResDataStruct();
        int cmd = 0;
        int rt = 9;
        isCommandRunning = true;
        this.waitForNotification();
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
            TaskManager.TaskStartRet r;
            int loopNum = 0;
            do {
                r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-48, (byte)37, new byte[]{2})), 0, respData);
                ++loopNum;
                if (r != TaskManager.TaskStartRet.SUCCESS) continue;
                if (respData.resData == null) {
                    isCommandRunning = false;
                    respData.statusCode = 21;
                    return 21;
                }
                if (respData.resData.length == 1 && respData.resData[0] == 0) {
                    isCommandRunning = false;
                    respData.statusCode = 3;
                    return 3;
                }
                rt = 9;
                int len = respData.resData.length;
                if (len <= 11) continue;
                rt = respData.resData[11];
                cmd = respData.resData[10];
                if (cmd == -18 && rt == -16) break;
                if (rt == 0) continue;
                rt = 9;
            } while (loopNum < maxLoopNum && (rt != 0 || cmd != 13));
            int returnCode = this.returnACK(r, respData);
            this.convertIDG(respData, 2);
            isCommandRunning = false;
            respData.statusCode = returnCode;
            return returnCode;
        }
        TaskManager.TaskStartRet r = this.sendCommand_helper("72460404", 0, respData);
        int returnCode = this.returnACK(r, respData);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int emv_retrieveCRL(ResDataStruct respData) {
        if (respData == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            respData.statusCode = 29696;
            return 29696;
        }
        if (!this.isICCDeviceSelected() || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_USB) {
            respData.statusCode = 20;
            return 20;
        }
        if (!this.device_isConnected()) {
            respData.statusCode = 1;
            return 1;
        }
        int cmd = 0;
        int rt = 9;
        isCommandRunning = true;
        this.waitForNotification();
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
            TaskManager.TaskStartRet r;
            if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V) {
                this.waitForVivo();
            }
            int loopNum = 0;
            if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
                TaskManager.TaskStartRet r2;
                do {
                    r2 = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-124, (byte)7, new byte[]{48, 0, 0, 0})), 0, respData);
                    ++loopNum;
                    if (r2 != TaskManager.TaskStartRet.SUCCESS) continue;
                    if (respData.resData == null) {
                        isCommandRunning = false;
                        respData.statusCode = 21;
                        return 21;
                    }
                    if (respData.resData.length == 1 && respData.resData[0] == 0) {
                        isCommandRunning = false;
                        respData.statusCode = 3;
                        return 3;
                    }
                    rt = 9;
                    int len = respData.resData.length;
                    if (len <= 11) continue;
                    rt = respData.resData[11];
                    cmd = respData.resData[10];
                    if (cmd == -18 && rt == -16) break;
                    if (rt == 0) continue;
                    rt = 9;
                } while (loopNum < maxLoopNum && (rt != 0 || cmd != -124));
                int returnCode = this.returnACK(r2, respData);
                this.convertIDG(respData, 0);
                isCommandRunning = false;
                respData.statusCode = returnCode;
                return returnCode;
            }
            do {
                r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)96, (byte)12, new byte[0])), 0, respData);
                ++loopNum;
                if (r == TaskManager.TaskStartRet.SUCCESS) {
                    if (respData.resData == null) {
                        isCommandRunning = false;
                        respData.statusCode = 21;
                        return 21;
                    }
                    if (respData.resData.length == 1 && respData.resData[0] == 0) {
                        isCommandRunning = false;
                        respData.statusCode = 3;
                        return 3;
                    }
                    rt = 9;
                    int len = respData.resData.length;
                    if (len > 11) {
                        rt = respData.resData[11];
                        cmd = respData.resData[10];
                        if (cmd == -18 && rt == -16) break;
                        if (rt != 0) {
                            rt = 9;
                        }
                    }
                }
                if (loopNum >= maxLoopNum || rt == 0 && cmd == 96) continue;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException len) {
                    // empty catch block
                }
            } while (loopNum < maxLoopNum && (rt != 0 || cmd != 96));
            int returnCode = this.returnACK(r, respData);
            this.convertIDG(respData, 2);
            isCommandRunning = false;
            respData.statusCode = returnCode;
            return returnCode;
        }
        TaskManager.TaskStartRet r = connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA ? this.sendCommand_helper("72468501", 0, respData) : this.sendCommand_helper("72468504", 0, respData);
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int emv_removeCRL(byte[] crlList, ResDataStruct respData) {
        TaskManager.TaskStartRet r;
        block26: {
            block27: {
                int loopNum;
                int rt;
                int cmd;
                block28: {
                    if (respData == null) {
                        return 27392;
                    }
                    if (!readyForNextCommand || !readyForCardSwipe) {
                        respData.statusCode = 29696;
                        return 29696;
                    }
                    if (!this.isICCDeviceSelected() || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_USB) {
                        respData.statusCode = 20;
                        return 20;
                    }
                    if (!this.device_isConnected()) {
                        respData.statusCode = 1;
                        return 1;
                    }
                    if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA) {
                        byte[] data = new byte[crlList.length + 2];
                        data[0] = (byte)(crlList.length & 0xFF);
                        data[1] = (byte)(crlList.length >> 8 & 0xFF);
                        System.arraycopy(crlList, 0, data, 2, crlList.length);
                        crlList = data;
                    }
                    if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
                        if (crlList == null || crlList.length < 1 || crlList.length % 6 != 0) {
                            respData.statusCode = 27392;
                            return 27392;
                        }
                    } else if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA) {
                        if (crlList == null || crlList.length < 3 || (crlList.length - 2) % 9 != 0) {
                            respData.statusCode = 27392;
                            return 27392;
                        }
                    } else if (crlList == null || crlList.length < 1 || crlList.length % 9 != 0) {
                        respData.statusCode = 27392;
                        return 27392;
                    }
                    cmd = 0;
                    rt = 9;
                    isCommandRunning = true;
                    this.waitForNotification();
                    if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) break block27;
                    if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V) {
                        this.waitForVivo();
                    }
                    loopNum = 0;
                    if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) break block28;
                    do {
                        r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-124, (byte)5, crlList)), 0, respData);
                        ++loopNum;
                        if (r != TaskManager.TaskStartRet.SUCCESS) continue;
                        if (respData.resData == null) {
                            isCommandRunning = false;
                            respData.statusCode = 21;
                            return 21;
                        }
                        if (respData.resData.length == 1 && respData.resData[0] == 0) {
                            isCommandRunning = false;
                            respData.statusCode = 3;
                            return 3;
                        }
                        rt = 9;
                        int len = respData.resData.length;
                        if (len <= 11) continue;
                        rt = respData.resData[11];
                        cmd = respData.resData[10];
                        if (cmd == -18 && rt == -16) break block26;
                        if (rt == 0) continue;
                        rt = 9;
                    } while (loopNum < maxLoopNum && (rt != 0 || cmd != -124));
                    break block26;
                    {
                    }
                }
                do {
                    r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)96, (byte)13, crlList)), 0, respData);
                    ++loopNum;
                    if (r == TaskManager.TaskStartRet.SUCCESS) {
                        if (respData.resData == null) {
                            isCommandRunning = false;
                            respData.statusCode = 21;
                            return 21;
                        }
                        if (respData.resData.length == 1 && respData.resData[0] == 0) {
                            isCommandRunning = false;
                            respData.statusCode = 3;
                            return 3;
                        }
                        rt = 9;
                        int len = respData.resData.length;
                        if (len > 11) {
                            rt = respData.resData[11];
                            cmd = respData.resData[10];
                            if (cmd == -18 && rt == -16) break block26;
                            if (rt != 0) {
                                rt = 9;
                            }
                        }
                    }
                    if (loopNum >= maxLoopNum || rt == 0 && cmd == 96) continue;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while (loopNum < maxLoopNum && (rt != 0 || cmd != 96));
                break block26;
            }
            r = this.sendCommand_helper("72468502" + Common.bytesToHex(crlList), 0, respData);
        }
        int returnCode = this.returnACK(r, respData);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int emv_removeAllCRL() {
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
            TaskManager.TaskStartRet r;
            int cmd = 0;
            ResDataStruct respData = new ResDataStruct();
            int rt = 9;
            isCommandRunning = true;
            int loopNum = 0;
            do {
                r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-124, (byte)6, new byte[0])), 0, respData);
                ++loopNum;
                if (r != TaskManager.TaskStartRet.SUCCESS) continue;
                if (respData.resData == null) {
                    isCommandRunning = false;
                    respData.statusCode = 21;
                    return 21;
                }
                if (respData.resData.length == 1 && respData.resData[0] == 0) {
                    isCommandRunning = false;
                    respData.statusCode = 3;
                    return 3;
                }
                rt = 9;
                int len = respData.resData.length;
                if (len <= 11) continue;
                rt = respData.resData[11];
                cmd = respData.resData[10];
                if (cmd == -18 && rt == -16) break;
                if (rt == 0) continue;
                rt = 9;
            } while (loopNum < maxLoopNum && (rt != 0 || cmd != -124));
            int returnCode = this.returnACK(r, respData);
            isCommandRunning = false;
            respData.statusCode = returnCode;
            return returnCode;
        }
        isCommandRunning = true;
        this.waitForNotification();
        ResDataStruct respData = new ResDataStruct();
        TaskManager.TaskStartRet r = this.sendCommand_helper("72468504", 0, respData);
        int returnCode = this.returnACK(r, respData);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int emv_retrieveCRLStatus(ResDataStruct respData) {
        TaskManager.TaskStartRet r;
        if (respData == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            respData.statusCode = 29696;
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
            respData.statusCode = 20;
            return 20;
        }
        if (!this.device_isConnected()) {
            respData.statusCode = 1;
            return 1;
        }
        int cmd = 0;
        int rt = 9;
        isCommandRunning = true;
        this.waitForNotification();
        int loopNum = 0;
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-124, (byte)3, new byte[0])), 0, respData);
            ++loopNum;
            if (r != TaskManager.TaskStartRet.SUCCESS) continue;
            if (respData.resData == null) {
                isCommandRunning = false;
                respData.statusCode = 21;
                return 21;
            }
            if (respData.resData.length == 1 && respData.resData[0] == 0) {
                isCommandRunning = false;
                respData.statusCode = 3;
                return 3;
            }
            rt = 9;
            int len = respData.resData.length;
            if (len <= 11) continue;
            rt = respData.resData[11];
            cmd = respData.resData[10];
            if (cmd == -18 && rt == -16) break;
            if (rt == 0) continue;
            rt = 9;
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != -124));
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int emv_retrieveExceptionList(ResDataStruct respData) {
        TaskManager.TaskStartRet r;
        if (respData == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            respData.statusCode = 29696;
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
            respData.statusCode = 20;
            return 20;
        }
        if (!this.device_isConnected()) {
            respData.statusCode = 1;
            return 1;
        }
        int cmd = 0;
        int rt = 9;
        isCommandRunning = true;
        this.waitForNotification();
        int loopNum = 0;
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-124, (byte)12, new byte[]{48, 0, 0, 0})), 0, respData);
            ++loopNum;
            if (r != TaskManager.TaskStartRet.SUCCESS) continue;
            if (respData.resData == null) {
                isCommandRunning = false;
                respData.statusCode = 21;
                return 21;
            }
            if (respData.resData.length == 1 && respData.resData[0] == 0) {
                isCommandRunning = false;
                respData.statusCode = 3;
                return 3;
            }
            rt = 9;
            int len = respData.resData.length;
            if (len <= 11) continue;
            rt = respData.resData[11];
            cmd = respData.resData[10];
            if (cmd == -18 && rt == -16) break;
            if (rt == 0) continue;
            rt = 9;
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != -124));
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int emv_setException(byte[] exception) {
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        int cmd = 0;
        int rt = 9;
        ResDataStruct respData = new ResDataStruct();
        isCommandRunning = true;
        this.waitForNotification();
        int loopNum = 0;
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-124, (byte)9, exception)), 0, respData);
            ++loopNum;
            if (r != TaskManager.TaskStartRet.SUCCESS) continue;
            if (respData.resData == null) {
                isCommandRunning = false;
                respData.statusCode = 21;
                return 21;
            }
            if (respData.resData.length == 1 && respData.resData[0] == 0) {
                isCommandRunning = false;
                respData.statusCode = 3;
                return 3;
            }
            rt = 9;
            int len = respData.resData.length;
            if (len <= 11) continue;
            rt = respData.resData[11];
            cmd = respData.resData[10];
            if (cmd == -18 && rt == -16) break;
            if (rt == 0) continue;
            rt = 9;
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != -124));
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int emv_removeException(byte[] exception) {
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        int cmd = 0;
        int rt = 9;
        ResDataStruct respData = new ResDataStruct();
        isCommandRunning = true;
        this.waitForNotification();
        int loopNum = 0;
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-124, (byte)10, exception)), 0, respData);
            ++loopNum;
            if (r != TaskManager.TaskStartRet.SUCCESS) continue;
            if (respData.resData == null) {
                isCommandRunning = false;
                respData.statusCode = 21;
                return 21;
            }
            if (respData.resData.length == 1 && respData.resData[0] == 0) {
                isCommandRunning = false;
                respData.statusCode = 3;
                return 3;
            }
            rt = 9;
            int len = respData.resData.length;
            if (len <= 11) continue;
            rt = respData.resData[11];
            cmd = respData.resData[10];
            if (cmd == -18 && rt == -16) break;
            if (rt == 0) continue;
            rt = 9;
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != -124));
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int emv_removeAllExceptions() {
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        int cmd = 0;
        int rt = 9;
        ResDataStruct respData = new ResDataStruct();
        isCommandRunning = true;
        this.waitForNotification();
        int loopNum = 0;
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-124, (byte)11, new byte[0])), 0, respData);
            ++loopNum;
            if (r != TaskManager.TaskStartRet.SUCCESS) continue;
            if (respData.resData == null) {
                isCommandRunning = false;
                respData.statusCode = 21;
                return 21;
            }
            if (respData.resData.length == 1 && respData.resData[0] == 0) {
                isCommandRunning = false;
                respData.statusCode = 3;
                return 3;
            }
            rt = 9;
            int len = respData.resData.length;
            if (len <= 11) continue;
            rt = respData.resData[11];
            cmd = respData.resData[10];
            if (cmd == -18 && rt == -16) break;
            if (rt == 0) continue;
            rt = 9;
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != -124));
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int emv_retrieveExceptionLogStatus(ResDataStruct respData) {
        TaskManager.TaskStartRet r;
        if (respData == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            respData.statusCode = 29696;
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
            respData.statusCode = 20;
            return 20;
        }
        if (!this.device_isConnected()) {
            respData.statusCode = 1;
            return 1;
        }
        int cmd = 0;
        int rt = 9;
        isCommandRunning = true;
        this.waitForNotification();
        int loopNum = 0;
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-124, (byte)8, new byte[0])), 0, respData);
            ++loopNum;
            if (r != TaskManager.TaskStartRet.SUCCESS) continue;
            if (respData.resData == null) {
                isCommandRunning = false;
                respData.statusCode = 21;
                return 21;
            }
            if (respData.resData.length == 1 && respData.resData[0] == 0) {
                isCommandRunning = false;
                respData.statusCode = 3;
                return 3;
            }
            rt = 9;
            int len = respData.resData.length;
            if (len <= 11) continue;
            rt = respData.resData[11];
            cmd = respData.resData[10];
            if (cmd == -18 && rt == -16) break;
            if (rt == 0) continue;
            rt = 9;
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != -124));
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int emv_removeTransactionLog() {
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        int cmd = 0;
        int rt = 9;
        ResDataStruct respData = new ResDataStruct();
        isCommandRunning = true;
        this.waitForNotification();
        int loopNum = 0;
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-124, (byte)1, new byte[0])), 0, respData);
            ++loopNum;
            if (r != TaskManager.TaskStartRet.SUCCESS) continue;
            if (respData.resData == null) {
                isCommandRunning = false;
                respData.statusCode = 21;
                return 21;
            }
            if (respData.resData.length == 1 && respData.resData[0] == 0) {
                isCommandRunning = false;
                respData.statusCode = 3;
                return 3;
            }
            rt = 9;
            int len = respData.resData.length;
            if (len <= 11) continue;
            rt = respData.resData[11];
            cmd = respData.resData[10];
            if (cmd == -18 && rt == -16) break;
            if (rt == 0) continue;
            rt = 9;
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != -124));
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int emv_retrieveTransactionLogStatus(ResDataStruct respData) {
        TaskManager.TaskStartRet r;
        if (respData == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            respData.statusCode = 29696;
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
            respData.statusCode = 20;
            return 20;
        }
        if (!this.device_isConnected()) {
            respData.statusCode = 1;
            return 1;
        }
        int cmd = 0;
        int rt = 9;
        isCommandRunning = true;
        this.waitForNotification();
        int loopNum = 0;
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-124, (byte)0, new byte[0])), 0, respData);
            ++loopNum;
            if (r != TaskManager.TaskStartRet.SUCCESS) continue;
            if (respData.resData == null) {
                isCommandRunning = false;
                respData.statusCode = 21;
                return 21;
            }
            if (respData.resData.length == 1 && respData.resData[0] == 0) {
                isCommandRunning = false;
                respData.statusCode = 3;
                return 3;
            }
            rt = 9;
            int len = respData.resData.length;
            if (len <= 11) continue;
            rt = respData.resData[11];
            cmd = respData.resData[10];
            if (cmd == -18 && rt == -16) break;
            if (rt == 0) continue;
            rt = 9;
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != -124));
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int emv_retrieveTransactionLog(ResDataStruct respData) {
        TaskManager.TaskStartRet r;
        if (respData == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            respData.statusCode = 29696;
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
            respData.statusCode = 20;
            return 20;
        }
        if (!this.device_isConnected()) {
            respData.statusCode = 1;
            return 1;
        }
        int cmd = 0;
        int rt = 9;
        isCommandRunning = true;
        this.waitForNotification();
        int loopNum = 0;
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-124, (byte)2, new byte[]{1, -128})), 0, respData);
            ++loopNum;
            if (r != TaskManager.TaskStartRet.SUCCESS) continue;
            if (respData.resData == null) {
                isCommandRunning = false;
                respData.statusCode = 21;
                return 21;
            }
            if (respData.resData.length == 1 && respData.resData[0] == 0) {
                isCommandRunning = false;
                respData.statusCode = 3;
                return 3;
            }
            rt = 9;
            int len = respData.resData.length;
            if (len <= 11) continue;
            rt = respData.resData[11];
            cmd = respData.resData[10];
            if (cmd == -18 && rt == -16) break;
            if (rt == 0) continue;
            rt = 9;
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != -124));
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int icc_removeCRLByRIDIndex(byte[] data, ResDataStruct respData) {
        int ec;
        if (respData == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            respData.statusCode = 29696;
            return 29696;
        }
        if (!this.isICCDeviceSelected()) {
            respData.statusCode = 20;
            return 20;
        }
        if (!this.device_isConnected()) {
            respData.statusCode = 1;
            return 1;
        }
        int dataLen = data.length;
        if (data == null || dataLen < 1 || dataLen > 2032) {
            respData.statusCode = 27392;
            return 27392;
        }
        isCommandRunning = true;
        this.waitForNotification();
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
            respData.statusCode = 20;
            return 20;
        }
        TaskManager.TaskStartRet r = this.sendCommand_helper("72468505" + Common.bytesToHex(data), 0, respData);
        isCommandRunning = false;
        respData.statusCode = ec = this.returnACK(r, respData);
        return ec;
    }

    public int emv_setCRL(byte[] crlList, ResDataStruct respData) {
        TaskManager.TaskStartRet r;
        block21: {
            byte[] data;
            block22: {
                int loopNum;
                int rt;
                int cmd;
                block23: {
                    if (respData == null) {
                        return 27392;
                    }
                    if (!readyForNextCommand || !readyForCardSwipe) {
                        respData.statusCode = 29696;
                        return 29696;
                    }
                    if (!this.isICCDeviceSelected() || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_USB) {
                        respData.statusCode = 20;
                        return 20;
                    }
                    if (crlList == null || crlList.length < 2) {
                        respData.statusCode = 27392;
                        return 27392;
                    }
                    if (!this.device_isConnected()) {
                        respData.statusCode = 1;
                        return 1;
                    }
                    data = new byte[crlList.length + 2];
                    int crllen = crlList.length;
                    if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT) {
                        crllen -= 2;
                    }
                    data[0] = (byte)(crllen & 0xFF);
                    data[1] = (byte)(crllen >> 8 & 0xFF);
                    System.arraycopy(crlList, 0, data, 2, crlList.length);
                    int dataLen = data.length;
                    if (dataLen < 1) {
                        respData.statusCode = 27392;
                        return 27392;
                    }
                    cmd = 0;
                    rt = 9;
                    isCommandRunning = true;
                    this.waitForNotification();
                    if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) break block22;
                    if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V) {
                        this.waitForVivo();
                    }
                    loopNum = 0;
                    if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) break block23;
                    do {
                        r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-124, (byte)4, crlList)), 0, respData);
                        ++loopNum;
                        if (r != TaskManager.TaskStartRet.SUCCESS) continue;
                        if (respData.resData == null) {
                            isCommandRunning = false;
                            respData.statusCode = 21;
                            return 21;
                        }
                        if (respData.resData.length == 1 && respData.resData[0] == 0) {
                            isCommandRunning = false;
                            respData.statusCode = 3;
                            return 3;
                        }
                        rt = 9;
                        int len = respData.resData.length;
                        if (len <= 11) continue;
                        rt = respData.resData[11];
                        cmd = respData.resData[10];
                        if (cmd == -18 && rt == -16) break block21;
                        if (rt == 0) continue;
                        rt = 9;
                    } while (loopNum < maxLoopNum && (rt != 0 || cmd != -124));
                    break block21;
                    {
                    }
                }
                do {
                    r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)96, (byte)14, data)), 0, respData);
                    ++loopNum;
                    if (r == TaskManager.TaskStartRet.SUCCESS) {
                        if (respData.resData == null) {
                            isCommandRunning = false;
                            respData.statusCode = 21;
                            return 21;
                        }
                        if (respData.resData.length == 1 && respData.resData[0] == 0) {
                            isCommandRunning = false;
                            respData.statusCode = 3;
                            return 3;
                        }
                        rt = 9;
                        int len = respData.resData.length;
                        if (len > 11) {
                            rt = respData.resData[11];
                            cmd = respData.resData[10];
                            if (cmd == -18 && rt == -16) break block21;
                            if (rt != 0) {
                                rt = 9;
                            }
                        }
                    }
                    if (loopNum >= maxLoopNum || rt == 0 && cmd == 96) continue;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while (loopNum < maxLoopNum && (rt != 0 || cmd != 96));
                break block21;
            }
            r = connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_BTPAY || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_BTPAY_USB ? this.sendCommand_helper("72468503" + Common.bytesToHex(crlList), 0, respData) : this.sendCommand_helper("72468503" + Common.bytesToHex(data), 0, respData);
        }
        int returnCode = this.returnACK(r, respData);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int icc_getInterfaceDeviceSerialNumber(ResDataStruct respData) {
        int ec;
        if (respData == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            respData.statusCode = 29696;
            return 29696;
        }
        if (!this.isICCDeviceSelected()) {
            respData.statusCode = 20;
            return 20;
        }
        if (!this.device_isConnected()) {
            respData.statusCode = 1;
            return 1;
        }
        isCommandRunning = true;
        this.waitForNotification();
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
            respData.statusCode = 20;
            return 20;
        }
        TaskManager.TaskStartRet r = this.sendCommand_helper("72468601", 0, respData);
        isCommandRunning = false;
        respData.statusCode = ec = this.returnACK(r, respData);
        return ec;
    }

    public int icc_setInterfaceDeviceSerialNumber(byte[] data, ResDataStruct respData) {
        int ec;
        int dataLen;
        if (respData == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            respData.statusCode = 29696;
            return 29696;
        }
        if (!this.isICCDeviceSelected()) {
            respData.statusCode = 20;
            return 20;
        }
        if (!this.device_isConnected()) {
            respData.statusCode = 1;
            return 1;
        }
        int n = dataLen = data == null ? 0 : data.length;
        if (dataLen < 1 || dataLen > 2032) {
            respData.statusCode = 27392;
            return 27392;
        }
        isCommandRunning = true;
        this.waitForNotification();
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
            respData.statusCode = 20;
            return 20;
        }
        TaskManager.TaskStartRet r = this.sendCommand_helper("72468603" + Common.bytesToHex(data), 0, respData);
        isCommandRunning = false;
        respData.statusCode = ec = this.returnACK(r, respData);
        return ec;
    }

    public int icc_getTerminalId(ResDataStruct respData) {
        int ec;
        if (respData == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            respData.statusCode = 29696;
            return 29696;
        }
        if (!this.isICCDeviceSelected()) {
            respData.statusCode = 20;
            return 20;
        }
        if (!this.device_isConnected()) {
            respData.statusCode = 1;
            return 1;
        }
        isCommandRunning = true;
        this.waitForNotification();
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
            respData.statusCode = 20;
            return 20;
        }
        TaskManager.TaskStartRet r = this.sendCommand_helper("72468701", 0, respData);
        isCommandRunning = false;
        respData.statusCode = ec = this.returnACK(r, respData);
        return ec;
    }

    public int icc_setTerminalId(byte[] data, ResDataStruct respData) {
        int ec;
        int dataLen;
        if (respData == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            respData.statusCode = 29696;
            return 29696;
        }
        if (!this.isICCDeviceSelected()) {
            respData.statusCode = 20;
            return 20;
        }
        if (!this.device_isConnected()) {
            respData.statusCode = 1;
            return 1;
        }
        int n = dataLen = data == null ? 0 : data.length;
        if (dataLen < 1 || dataLen > 2032) {
            respData.statusCode = 27392;
            return 27392;
        }
        isCommandRunning = true;
        this.waitForNotification();
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
            respData.statusCode = 20;
            return 20;
        }
        TaskManager.TaskStartRet r = this.sendCommand_helper("72468703" + Common.bytesToHex(data), 0, respData);
        isCommandRunning = false;
        respData.statusCode = ec = this.returnACK(r, respData);
        return ec;
    }

    private boolean emv_controlLED_Transaction_old(Common.EMV_TRANSACTION_STAGE transactionStage, int timeout) {
        ResDataStruct respData = new ResDataStruct();
        ICCReaderStatusStruct iccStatus = new ICCReaderStatusStruct();
        long sleepTime = 100L;
        int ret = 9;
        this.runLEDControl = true;
        iccStatus.cardSeated = true;
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (transactionStage != Common.EMV_TRANSACTION_STAGE.EMV_MIDDLE_TRANSACTION) {
            ret = this.icc_getICCReaderStatus_LEDControl(iccStatus, transactionStage);
        }
        if (transactionStage == Common.EMV_TRANSACTION_STAGE.EMV_BEFORE_TRANSACTION) {
            readyForNextCommand = false;
            if (ret == 0) {
                if (!iccStatus.cardSeated) {
                    this.sendCommand_helper("7246200201F4", 5, respData);
                } else {
                    this.sendCommand_helper("724620010000", 5, respData);
                }
            } else {
                this.sendCommand_helper("724620010000", 5, respData);
            }
        } else if (transactionStage == Common.EMV_TRANSACTION_STAGE.EMV_AFTER_TRANSACTION) {
            if (ret == 0 && iccStatus.cardSeated) {
                this.sendCommand_helper("7246200201F4", 5, respData);
            }
            while (iccStatus.cardSeated) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.icc_getICCReaderStatus_LEDControl(iccStatus, transactionStage);
                isCommandRunning = false;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.sendCommand_helper("7246200001F4", 5, respData);
            readyForNextCommand = true;
        } else {
            while (iccStatus.cardSeated && !this.runEMVTransaction) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.icc_getICCReaderStatus_LEDControl(iccStatus, transactionStage);
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.runEMVTransaction) {
                this.sendCommand_helper("7246200001F4", 5, respData);
            }
        }
        this.runLEDControl = false;
        return true;
    }

    private boolean emv_controlLED_Transaction(Common.EMV_TRANSACTION_STAGE transactionStage, int timeout) {
        ResDataStruct respData = new ResDataStruct();
        ICCReaderStatusStruct iccStatus = new ICCReaderStatusStruct();
        long sleepTime = 100L;
        int ret = 9;
        this.runLEDControl = true;
        iccStatus.cardSeated = true;
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (transactionStage != Common.EMV_TRANSACTION_STAGE.EMV_MIDDLE_TRANSACTION && transactionStage != Common.EMV_TRANSACTION_STAGE.EMV_AFTER_TRANSACTION) {
            ret = this.icc_getICCReaderStatus_LEDControl(iccStatus, transactionStage);
        }
        if (transactionStage == Common.EMV_TRANSACTION_STAGE.EMV_BEFORE_TRANSACTION) {
            readyForNextCommand = false;
            if (ret == 0) {
                if (!iccStatus.cardSeated) {
                    this.sendCommand_helper("7246200201F4", 5, respData);
                } else {
                    this.sendCommand_helper("724620010000", 5, respData);
                }
            } else {
                this.sendCommand_helper("724620010000", 5, respData);
            }
        } else if (transactionStage == Common.EMV_TRANSACTION_STAGE.EMV_AFTER_TRANSACTION) {
            readyForNextCommand = true;
        } else {
            while (iccStatus.cardSeated && !this.runEMVTransaction) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.icc_getICCReaderStatus_LEDControl(iccStatus, transactionStage);
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.runEMVTransaction) {
                this.sendCommand_helper("7246200001F4", 5, respData);
            }
        }
        this.runLEDControl = false;
        return true;
    }

    public static IDTEMVData checkCID82(IDTEMVData emvData) {
        Map<String, byte[]> unencryptedTags = emvData.unencryptedTags;
        return emvData;
    }

    private void emv_startTransaction_Augusta(String fallback, byte[] baTimeout, String tagsString, int timeout) {
        ResDataStruct respData = new ResDataStruct();
        IDTEMVData emvData = new IDTEMVData();
        if (!this.emv_controlLED_Transaction(Common.EMV_TRANSACTION_STAGE.EMV_BEFORE_TRANSACTION, timeout)) {
            isCommandRunning = false;
            return;
        }
        String additionalStrings = "DFEE1A485F2857DF4ADF4C849F395F349F279F029F039F349F359F1E9F539F099F41DF4D9F269F10829F369F37959A9C9F339F15DF4FDF4F9F075F255F24DF4BDFEE23DFEE25DFEE265ADF34";
        if (!_isTTK) {
            additionalStrings = "";
        }
        TaskManager.TaskStartRet r = this.sendCommand_helper("72460501" + fallback + Common.bytesToHex(baTimeout) + Common.bytesToHex(baTimeout) + tagsString + additionalStrings, timeout, respData);
        if (respData.resData == null || respData.resData.length == 0) {
            emvData.result = 20517;
            this.m_recListener.emvTransactionData(this.checkBypassCompletion(emvData));
            this.emv_controlLED_Transaction(Common.EMV_TRANSACTION_STAGE.EMV_AFTER_TRANSACTION, timeout);
            isCommandRunning = false;
            return;
        }
        byte[] tmp2 = respData.resData;
        if (respData.resData.length == 9 && tmp2[3] == 21) {
            emvData.result = 20517;
            this.m_recListener.emvTransactionData(this.checkBypassCompletion(emvData));
            this.emv_controlLED_Transaction(Common.EMV_TRANSACTION_STAGE.EMV_AFTER_TRANSACTION, timeout);
            isCommandRunning = false;
            return;
        }
        if (respData.resData.length == 3 && tmp2[0] == 21) {
            emvData.result = 20517;
            this.m_recListener.emvTransactionData(this.checkBypassCompletion(emvData));
            this.emv_controlLED_Transaction(Common.EMV_TRANSACTION_STAGE.EMV_AFTER_TRANSACTION, timeout);
            isCommandRunning = false;
            return;
        }
        if (respData.resData.length == 2) {
            emvData.result = 20517;
            this.m_recListener.emvTransactionData(this.checkBypassCompletion(emvData));
            this.emv_controlLED_Transaction(Common.EMV_TRANSACTION_STAGE.EMV_AFTER_TRANSACTION, timeout);
            isCommandRunning = false;
            return;
        }
        if (r != TaskManager.TaskStartRet.SUCCESS) {
            emvData.result = 20517;
            this.m_recListener.emvTransactionData(this.checkBypassCompletion(emvData));
            this.emv_controlLED_Transaction(Common.EMV_TRANSACTION_STAGE.EMV_AFTER_TRANSACTION, timeout);
            isCommandRunning = false;
            return;
        }
        if (respData.resData[0] == 21 && respData.resData[1] == 129 && respData.resData[2] == 0) {
            emvData.result = 8;
            this.m_recListener.emvTransactionData(this.checkBypassCompletion(emvData));
            this.emv_controlLED_Transaction(Common.EMV_TRANSACTION_STAGE.EMV_AFTER_TRANSACTION, timeout);
            isCommandRunning = false;
            return;
        }
        if (respData.resData.length > 100) {
            this.emv_secondResponse(timeout, 1, respData);
        } else {
            this.emv_secondResponse(timeout, 1, null);
        }
    }

    public static void emv_allowFallback(boolean allow) {
        _allowFallback = allow;
    }

    public void waitForOtherCommands() {
        while (isCommandRunning) {
            try {
                Thread.sleep(30L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @SuppressLint(value={"SimpleDateFormat"})
    public int emv_startTransaction(double amount, double amtOther, int type, int timeout, byte[] tags, boolean forceOnline) {
        return this.emv_startTransaction(amount, amtOther, type, timeout, tags, forceOnline, false);
    }

    @SuppressLint(value={"SimpleDateFormat"})
    public int emv_startTransaction(double amount, double amtOther, int type, final int timeout, byte[] tags, boolean forceOnline, boolean isFastEMV) {
        TaskManager.TaskStartRet r;
        byte bcd;
        int temp;
        int i;
        String stDecimal;
        String[] numbers;
        int p;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (!this.isICCDeviceSelected() || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_USB) {
            return 20;
        }
        if (type < 0 || type > 255) {
            return 27392;
        }
        if (timeout < 0 || timeout > 65535) {
            return 27392;
        }
        if (amount > 9.99999999999E9 || amount < 0.0) {
            return 27392;
        }
        if (amtOther > 9.99999999999E9 || amtOther < 0.0) {
            return 27392;
        }
        emvCancelTransaction = false;
        ResDataStruct respData = new ResDataStruct();
        _forceOnline = forceOnline;
        _timeout = timeout;
        _isFastEMV = isFastEMV;
        if (!this.device_isConnected()) {
            return 1;
        }
        if (_isTTK) {
            firmware_version_ttk = this.getFirmwareVersionForTTK();
        }
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT && (p = this.device_pingDevice()) != 0) {
            this.device_pingDevice();
        }
        isEMV_Terminate_TTK = false;
        this.waitForOtherCommands();
        isCommandRunning = true;
        this.waitForNotification();
        byte[] baTimeout = new byte[]{(byte)(timeout >> 8 & 0xFF), (byte)(timeout & 0xFF)};
        if (tags == null) {
            tags = new byte[]{};
        } else if (tags.length > 2032) {
            isCommandRunning = false;
            return 27392;
        }
        Map<String, Map<String, byte[]>> TLVDict = Common.processTLV(tags);
        Map<String, byte[]> unencryptedTags = null;
        if (TLVDict != null) {
            unencryptedTags = TLVDict.get("tags");
        }
        byte[] baAmount = null;
        byte[] baOtherAmount = null;
        byte[] baTransactionType = null;
        int exponent = 2;
        if (unencryptedTags != null) {
            byte[] baExponent = null;
            baAmount = unencryptedTags.get("9F02");
            baOtherAmount = unencryptedTags.get("9F03");
            baTransactionType = unencryptedTags.get("9C");
            baExponent = unencryptedTags.get("5F36");
            if (baAmount != null && baAmount.length != 6) {
                baAmount = null;
            }
            if (baOtherAmount != null && baOtherAmount.length != 6) {
                baOtherAmount = null;
            }
            if (baTransactionType != null && baTransactionType.length != 1) {
                baTransactionType = null;
            }
            if (baExponent != null && baExponent.length == 1) {
                exponent = baExponent[0];
            }
        }
        int time = 10;
        if (exponent > 0 && exponent < 12) {
            for (int i2 = 0; i2 < exponent - 1; ++i2) {
                time *= 10;
            }
        }
        if (baAmount == null) {
            baAmount = new byte[6];
            String strAmount = String.valueOf(amount);
            numbers = strAmount.split("\\.");
            long lAmount = Long.valueOf(numbers[0]);
            if (exponent > 0 && exponent < 12) {
                lAmount *= (long)time;
            }
            stDecimal = "";
            if (exponent > 0 && exponent < 12) {
                for (i = 0; i < exponent; ++i) {
                    stDecimal = numbers[1] != null && i < numbers[1].length() ? stDecimal + numbers[1].substring(i, i + 1) : stDecimal + "0";
                }
                lAmount += Long.valueOf(stDecimal).longValue();
            }
            for (i = 5; i >= 0; --i) {
                temp = (int)(lAmount % 100L);
                baAmount[i] = bcd = (byte)(temp % 10 | temp / 10 << 4);
                lAmount /= 100L;
            }
            unencryptedTags.put("9F02", baAmount);
        }
        if (baOtherAmount == null) {
            baOtherAmount = new byte[6];
            String strOtherAmount = String.valueOf(amtOther);
            numbers = strOtherAmount.split("\\.");
            long lOtherAmount = Long.valueOf(numbers[0]);
            if (exponent > 0 && exponent < 12) {
                lOtherAmount *= (long)time;
            }
            stDecimal = "";
            if (exponent > 0 && exponent < 12) {
                for (i = 0; i < exponent; ++i) {
                    stDecimal = numbers[1] != null && i < numbers[1].length() ? stDecimal + numbers[1].substring(i, i + 1) : stDecimal + "0";
                }
                lOtherAmount += Long.valueOf(stDecimal).longValue();
            }
            for (i = 5; i >= 0; --i) {
                temp = (int)(lOtherAmount % 100L);
                baOtherAmount[i] = bcd = (byte)(temp % 10 | temp / 10 << 4);
                lOtherAmount /= 100L;
            }
            unencryptedTags.put("9F03", baOtherAmount);
        }
        if (baTransactionType == null) {
            baTransactionType = new byte[]{(byte)type};
            unencryptedTags.put("9C", baTransactionType);
        }
        String tagsString = "";
        int cmd = 0;
        int rt = 9;
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_BTPAY || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_BTPAY_USB) {
            tagsString = Common.getTagString(unencryptedTags);
            r = this.sendCommand_helper("724601" + Common.bytesToHex(baTimeout) + Common.bytesToHex(baTimeout) + tagsString, timeout, respData);
            if (respData.resData == null || respData.resData.length == 0) {
                isCommandRunning = false;
                return rt;
            }
            byte[] tmp2 = respData.resData;
            if (respData.resData.length == 9 && tmp2[3] == 21) {
                isCommandRunning = false;
                return tmp2[5] + tmp2[4] * 256;
            }
            if (respData.resData.length == 3 && tmp2[0] == 21) {
                isCommandRunning = false;
                return tmp2[2] + tmp2[1] * 256;
            }
            if (respData.resData.length == 2) {
                isCommandRunning = false;
                return tmp2[1] + tmp2[0] * 256;
            }
            if (r != TaskManager.TaskStartRet.SUCCESS) {
                isCommandRunning = false;
                return tmp2[2] + tmp2[1] * 256;
            }
            if (respData.resData[0] == 0 && respData.resData[1] == 13) {
                isCommandRunning = false;
                return 3;
            }
        } else if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA) {
            String fallback = _allowFallback ? "01" : "00";
            tagsString = Common.getTagString(unencryptedTags);
            if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA) {
                final String _fallback = fallback;
                final byte[] _baTimeout = baTimeout;
                final String _tagsString = tagsString;
                final int _timeout = timeout;
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        IDT_Device.this.emv_startTransaction_Augusta(_fallback, _baTimeout, _tagsString, _timeout);
                    }
                }).start();
                return 0;
            }
            r = this.sendCommand_helper("72460501" + fallback + Common.bytesToHex(baTimeout) + Common.bytesToHex(baTimeout) + tagsString, timeout, respData);
            if (respData.resData == null || respData.resData.length == 0) {
                isCommandRunning = false;
                return rt;
            }
            byte[] tmp2 = respData.resData;
            if (respData.resData.length == 9 && tmp2[3] == 21) {
                isCommandRunning = false;
                return tmp2[5] + tmp2[4] * 256;
            }
            if (respData.resData.length == 3 && tmp2[0] == 21) {
                isCommandRunning = false;
                return tmp2[2] + tmp2[1] * 256;
            }
            if (respData.resData.length == 2) {
                isCommandRunning = false;
                return tmp2[1] + tmp2[0] * 256;
            }
            if (r != TaskManager.TaskStartRet.SUCCESS) {
                isCommandRunning = false;
                return tmp2[2] + tmp2[1] * 256;
            }
            if (respData.resData[0] == 21 && respData.resData[1] == 129 && respData.resData[2] == 0) {
                isCommandRunning = false;
                return 3;
            }
        } else {
            if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
                TaskManager.TaskStartRet r2;
                SimpleDateFormat sdf = new SimpleDateFormat("yyMMdd", Locale.US);
                String d = sdf.format(Calendar.getInstance().getTime());
                SimpleDateFormat sdf2 = new SimpleDateFormat("HHmmss", Locale.US);
                String d2 = sdf2.format(Calendar.getInstance().getTime());
                tagsString = Common.getTagString(unencryptedTags);
                byte[] data = Common.hexStringToByteArray(Common.bytesToHex(baTimeout) + "06000000" + tagsString);
                int loopNum = 0;
                do {
                    r2 = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)2, (byte)5, data)), timeout, respData);
                    ++loopNum;
                    if (r2 != TaskManager.TaskStartRet.SUCCESS) continue;
                    if (respData.resData == null) {
                        isCommandRunning = false;
                        return 21;
                    }
                    if (respData.resData.length == 1 && respData.resData[0] == 0) {
                        isCommandRunning = false;
                        return 3;
                    }
                    rt = 9;
                    int len = respData.resData.length;
                    if (len <= 11) continue;
                    rt = respData.resData[11];
                    cmd = respData.resData[10];
                } while (loopNum < maxLoopNum && cmd != 2);
                if (rt == 0 || rt == 48 || rt == 89) {
                    IDTEMVData emvData = new IDTEMVData();
                    if (rt == 0) {
                        emvData.result = 2;
                        respData.resData[11] = 0;
                    } else if (rt == 48) {
                        emvData.result = 4;
                        respData.resData[11] = 99;
                    } else {
                        IDT_Device.emv_setAutoAuthenticateTransaction(false);
                        emvData.result = 16;
                        respData.resData[11] = 0;
                    }
                    if (respData.resData.length > 18) {
                        int len = (respData.resData[13] & 0xFF) + (respData.resData[12] & 0xFF) * 256 - 1;
                        byte attribute = respData.resData[14];
                        byte[] tlvData = new byte[len];
                        System.arraycopy(respData.resData, 15, tlvData, 0, tlvData.length);
                        emvData.cardType = attribute & 1;
                        emvData.encryptionMode = attribute >> 1 & 1;
                        Map<String, Map<String, byte[]>> tlvDict = Common.processTLV(tlvData);
                        if (tlvDict != null) {
                            emvData.unencryptedTags = tlvDict.get("tags");
                            emvData.encryptedTags = tlvDict.get("encrypted");
                            emvData.maskedTags = tlvDict.get("masked");
                        }
                        this.cardData = new IDTMSRData();
                        this.cardData.result = emvData.result;
                    }
                    isCommandRunning = false;
                    UMLog.i("**emv_startTransaction**", "emvTransactionData() 1");
                    this.m_recListener.emvTransactionData(this.checkBypassCompletion(emvData));
                    return this.returnACK(r2, respData);
                }
                isCommandRunning = false;
                return this.returnACK(r2, respData);
            }
            String fallback = _allowFallback ? "01" : "00";
            baOtherAmount = null;
            SimpleDateFormat sdf = new SimpleDateFormat("yyMMdd", Locale.US);
            String d = sdf.format(Calendar.getInstance().getTime());
            SimpleDateFormat sdf2 = new SimpleDateFormat("HHmmss", Locale.US);
            String d2 = sdf2.format(Calendar.getInstance().getTime());
            if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT) {
                byte[] baDate = null;
                byte[] baTime = null;
                if (unencryptedTags != null) {
                    baDate = unencryptedTags.get("9A");
                    baTime = unencryptedTags.get("9F21");
                    if (baDate != null && baDate.length != 3) {
                        baDate = null;
                    }
                    if (baTime != null && baTime.length != 3) {
                        baTime = null;
                    }
                }
                if (baDate == null) {
                    unencryptedTags.put("9A", Common.getBytesFromHexString(d));
                }
                if (baTime == null) {
                    unencryptedTags.put("9F21", Common.getBytesFromHexString(d2));
                }
            }
            if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
                // empty if block
            }
            tagsString = Common.getTagString(unencryptedTags);
            String additionalStrings = "DFEE1A485F2857DF4ADF4C849F395F349F279F029F039F349F359F1E9F539F099F41DF4D9F269F10829F369F37959A9C9F339F15DF4FDF4F9F075F255F24DF4BDFEE23DFEE25DFEE265ADF34";
            if (!_isTTK) {
                additionalStrings = "";
            }
            byte[] data = Common.hexStringToByteArray(fallback + Common.bytesToHex(baTimeout) + Common.bytesToHex(baTimeout) + tagsString + additionalStrings);
            if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V) {
                this.waitForVivo();
            }
            int loopNum = 0;
            do {
                r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)96, (byte)16, data)), timeout + 2, respData);
                ++loopNum;
                if (r == TaskManager.TaskStartRet.SUCCESS) {
                    if (respData.resData == null) {
                        isCommandRunning = false;
                        return 21;
                    }
                    if (respData.resData.length == 1 && respData.resData[0] == 0) {
                        isCommandRunning = false;
                        return 3;
                    }
                    rt = 9;
                    int len = respData.resData.length;
                    if (len > 11) {
                        rt = respData.resData[11];
                        cmd = respData.resData[10];
                        if (cmd == -18 && rt == -16) break;
                    }
                }
                if (loopNum >= maxLoopNum || rt == 99 || cmd == 96) continue;
                try {
                    Thread.sleep(450L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (loopNum < 1 && rt != 99 && cmd != 96);
            if (!(rt == 99 && cmd == 96 || cmd == 97 && rt == 1)) {
                isCommandRunning = false;
                return this.returnACK(r, respData);
            }
        }
        if (respData.resData.length > 100) {
            this.emv_secondResponse(timeout + 2, 1, respData);
        } else {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    IDT_Device.this.emv_secondResponse(timeout + 2, 1, null);
                }
            }).start();
        }
        return this.returnACK(r, respData);
    }

    public void device_enableAutoPollEMV(boolean enabled, double amount, double amtOther, int type, int timeout, byte[] tags) {
        emv_amount = amount;
        emv_amtOther = amtOther;
        emv_type = type;
        emv_timeout = timeout;
        emv_tags = tags;
        autoEMV = enabled;
    }

    public void emv_setTransactionParameters(double amount, double amtOther, int type, int timeout, byte[] tags) {
        emv_amount = amount;
        emv_amtOther = amtOther;
        emv_type = type;
        emv_timeout = timeout;
        emv_tags = tags;
    }

    private IDTEMVData checkBypassCompletion(IDTEMVData emvData) {
        if (_isTTK && _bypassCompletion) {
            emvData.encryptedTags = null;
            emvData.maskedTags = null;
            emvData.unencryptedTags = null;
            _bypassCompletion = false;
        }
        return emvData;
    }

    public void bt_onReceiveMsgLCD(byte[] resData) {
        ResDataStruct resStruct = new ResDataStruct();
        resStruct.resData = new byte[resData.length];
        System.arraycopy(resData, 0, resStruct.resData, 0, resData.length);
        this.processLCDMessage(resStruct);
    }

    private void processLCDMessage_old(ResDataStruct resData) {
        UMLog.i("processLCDMessage", "resData.length " + resData.resData.length + " resData = " + Common.base16Encode(resData.resData));
        byte[] display = new byte[resData.resData.length];
        try {
            System.arraycopy(resData.resData, 0, display, 0, resData.resData.length);
        }
        catch (ArrayIndexOutOfBoundsException exception) {
            return;
        }
        int modeIndex = 5;
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
            modeIndex = 14;
        }
        try {
            byte type = display[modeIndex];
            int timeout = 30;
            if (type == 1 || type == 2 || type == 8) {
                timeout = display[modeIndex + 3] & 0xFF | (display[modeIndex + 4] & 0xFF) << 8;
            }
            ResDataStruct toData = new ResDataStruct();
            String strApplication = Common.getDisplayMessage(display, toData);
            String[] theStrings = strApplication.split("\r\n");
            if (type == 8) {
                int langLen = display[modeIndex + 9] & 0xFF | (display[modeIndex + 10] & 0xFF) << 8;
                int langCount = langLen / 4;
                theStrings = new String[langCount];
                int[] lineNum = new int[langCount];
                for (int i = 0; i < langCount; ++i) {
                    lineNum[i] = display[modeIndex + 11 + i * 4] & 0xFF;
                    if (display[modeIndex + 13 + i * 4] == 78) {
                        theStrings[i] = i + 1 + ". English";
                        continue;
                    }
                    if (display[modeIndex + 13 + i * 4] == 82) {
                        theStrings[i] = i + 1 + ". French";
                        continue;
                    }
                    if (display[modeIndex + 13 + i * 4] == 83) {
                        theStrings[i] = i + 1 + ". Spanish";
                        continue;
                    }
                    if (display[modeIndex + 13 + i * 4] != 72) continue;
                    theStrings[i] = i + 1 + ". Chinese";
                }
            }
            UMLog.i("IDT_Device", "String = " + strApplication);
            UMLog.i("IDT_Device", "Number of Strings = " + theStrings.length);
            if (theStrings.length > 0) {
                for (int x = 0; x < theStrings.length; ++x) {
                    UMLog.i("IDT_Device", "Strings #" + (x + 1) + " = " + theStrings[x]);
                }
            }
            UMLog.i("processLCDMessage", "before m_recListener.lcdDisplay");
            this.m_recListener.lcdDisplay(type, theStrings, timeout);
            this.m_recListener.lcdDisplay(type, theStrings, timeout, toData.resData, toData.settingValue);
        }
        catch (ArrayIndexOutOfBoundsException exception) {
            return;
        }
    }

    private void processLCDMessage(ResDataStruct resData) {
        UMLog.i("processLCDMessage", "resData.length " + resData.resData.length + " resData = " + Common.base16Encode(resData.resData));
        int modeIndex = 5;
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
            modeIndex = 14;
        }
        int idx = 0;
        if (resData.ret <= 0) {
            resData.ret = 1;
        }
        for (int j = 0; j < resData.ret; ++j) {
            try {
                int dataLen = (resData.resData[12 + idx] & 0xFF) << 8 | resData.resData[13 + idx] & 0xFF;
                byte[] display = new byte[dataLen + 16];
                try {
                    System.arraycopy(resData.resData, idx, display, 0, display.length);
                }
                catch (ArrayIndexOutOfBoundsException exception) {
                    return;
                }
                byte type = display[modeIndex];
                int timeout = 30;
                if (type == 1 || type == 2 || type == 8) {
                    timeout = display[modeIndex + 3] & 0xFF | (display[modeIndex + 4] & 0xFF) << 8;
                }
                ResDataStruct toData = new ResDataStruct();
                String strApplication = Common.getDisplayMessage(display, toData);
                String[] theStrings = strApplication.split("\r\n");
                if (type == 8) {
                    int langLen = display[modeIndex + 9] & 0xFF | (display[modeIndex + 10] & 0xFF) << 8;
                    int langCount = langLen / 4;
                    theStrings = new String[langCount];
                    int[] lineNum = new int[langCount];
                    for (int i = 0; i < langCount; ++i) {
                        lineNum[i] = display[modeIndex + 11 + i * 4] & 0xFF;
                        if (display[modeIndex + 13 + i * 4] == 78) {
                            theStrings[i] = i + 1 + ". English";
                            continue;
                        }
                        if (display[modeIndex + 13 + i * 4] == 82) {
                            theStrings[i] = i + 1 + ". French";
                            continue;
                        }
                        if (display[modeIndex + 13 + i * 4] == 83) {
                            theStrings[i] = i + 1 + ". Spanish";
                            continue;
                        }
                        if (display[modeIndex + 13 + i * 4] != 72) continue;
                        theStrings[i] = i + 1 + ". Chinese";
                    }
                }
                UMLog.i("IDT_Device", "String = " + strApplication);
                UMLog.i("IDT_Device", "Number of Strings = " + theStrings.length);
                if (theStrings.length > 0) {
                    for (int x = 0; x < theStrings.length; ++x) {
                        UMLog.i("IDT_Device", "Strings #" + (x + 1) + " = " + theStrings[x]);
                    }
                }
                UMLog.i("processLCDMessage", "before m_recListener.lcdDisplay");
                this.m_recListener.lcdDisplay(type, theStrings, timeout);
                this.m_recListener.lcdDisplay(type, theStrings, timeout, toData.resData, toData.settingValue);
                idx += dataLen + 16;
            }
            catch (ArrayIndexOutOfBoundsException exception) {
                return;
            }
            if (j >= resData.ret - 1) continue;
            try {
                Thread.sleep(30L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void processPINMessage(ResDataStruct resData) {
        if (resData.resData.length <= 14) {
            return;
        }
        byte[] rBytes = new byte[resData.resData.length];
        try {
            System.arraycopy(resData.resData, 0, rBytes, 0, resData.resData.length);
        }
        catch (ArrayIndexOutOfBoundsException exception) {
            return;
        }
        int thePos = 14;
        byte mode = rBytes[thePos++];
        byte lenLow = 0;
        int lenHigh = 0;
        int theLen = 0;
        byte[] key = null;
        byte[] PAN = null;
        if (mode == 0) {
            this.m_recListenerPINRequest.pinRequest(0, key, PAN, 0, 0, "");
            return;
        }
        try {
            if (mode == 1 || mode == 2) {
                int x;
                if ((theLen = (lenLow = rBytes[thePos++]) + (lenHigh = rBytes[thePos++] * 256)) > 0) {
                    key = new byte[theLen];
                    for (x = 0; x < theLen; ++x) {
                        key[x] = rBytes[thePos++];
                    }
                }
                if ((theLen = (lenLow = rBytes[thePos++]) + (lenHigh = rBytes[thePos++] * 256)) > 0) {
                    PAN = new byte[theLen];
                    for (x = 0; x < theLen; ++x) {
                        PAN[x] = rBytes[thePos++];
                    }
                }
            }
            thePos += 2;
            byte startTO = rBytes[thePos++];
            thePos += 2;
            byte intervalTO = rBytes[thePos++];
            thePos += 2;
            byte[] lang = new byte[]{rBytes[thePos++], rBytes[thePos++]};
            String language = new String(lang);
            this.m_recListenerPINRequest.pinRequest(mode, key, PAN, startTO, intervalTO, language);
        }
        catch (ArrayIndexOutOfBoundsException exception) {
            return;
        }
    }

    public void emv_secondResponse(int timeout, int mode, ResDataStruct respData) {
        ResDataStruct resData;
        if (timeout < 1) {
            timeout = 32;
        }
        UMLog.i("emv_secondResponse", "timeout: " + timeout + " mode: " + mode);
        long startTime = System.currentTimeMillis();
        byte[] tlvData = null;
        IDTEMVData emvData = new IDTEMVData();
        boolean secondResponse = false;
        if (mode == 4 || respData != null) {
            resData = respData;
            secondResponse = true;
        } else {
            resData = new ResDataStruct();
            resData.ret = 0;
        }
        while (mode != 4 && this.emv_getDisplayMessage(timeout, startTime, resData)) {
            if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
                String strTemp;
                if (emvCancelTransaction) {
                    if (inEMVAuth) {
                        cancelInEMVAuth = true;
                    }
                    emvData.result = 18;
                    this.m_recListener.emvTransactionData(emvData);
                    emvCancelTransaction = false;
                    return;
                }
                if (resData.resData == null || resData.resData.length == 1 && resData.resData[0] == 0) {
                    UMLog.i("IDT_Device", "resData.resData == null || resData.resData[0] == 0x00");
                    continue;
                }
                if (resData.resData.length > 12 && resData.resData[10] == 97 && resData.resData[11] == -1) {
                    UMLog.i("IDT_Device", "ignore the \"ENTER\" button event for PIN");
                    continue;
                }
                if (resData.resData != null && resData.resData.length > 8 && (strTemp = Common.base16Encode(resData.resData)).startsWith("450055")) {
                    UMLog.i("IDT_Device", "Ignore async LCD message");
                    resData.resData = null;
                    continue;
                }
                if (resData.resData.length > 12 && resData.resData[10] == -18 && resData.resData[11] == -16) {
                    emvData.result = 20517;
                    this.m_recListener.emvTransactionData(emvData);
                    isCommandRunning = false;
                    return;
                }
                if (resData.resData.length > 12 && (resData.resData[10] == 96 || resData.resData[10] == 2 || resData.resData[10] == 98) && resData.resData[11] != 99) {
                    secondResponse = true;
                    resData.timeout = timeout;
                    if (resData.resData[10] == 98) {
                        mode = 5;
                    }
                    UMLog.i("IDT_Device", "Got the second response");
                    break;
                }
                if (resData.resData.length > 12 && resData.resData[10] == 97 && resData.resData[11] == 1) {
                    resData.timeout = timeout;
                    boolean done = false;
                    UMLog.i("emv_secondResponse", "lcd message length: " + resData.resData.length);
                    UMLog.i("emv_secondResponse", "lcd message: " + Common.base16Encode(resData.resData));
                    if (resData.resData.length > 14) {
                        if (resData.resData[14] == 1 || resData.resData[14] == 2 || resData.resData[14] == 8) {
                            done = true;
                        }
                        if (resData.resData.length > 24 && (resData.resData[24] == 19 || resData.resData[24] == 98 || resData.resData[24] == 87 || resData.resData[24] == 14)) {
                            timeout = 260;
                        }
                    }
                    ResDataStruct resDataNew = null;
                    if (resData.ret > 1 || resData.statusCode == 1) {
                        int dataLen = (resData.resData[12] & 0xFF) << 8 | resData.resData[13] & 0xFF;
                        resDataNew = new ResDataStruct();
                        resDataNew.resData = new byte[resData.resData.length - (dataLen += 16)];
                        System.arraycopy(resData.resData, dataLen, resDataNew.resData, 0, resDataNew.resData.length);
                        resDataNew.ret = --resData.ret;
                        resDataNew.statusCode = resData.statusCode;
                        byte[] temp = new byte[dataLen];
                        System.arraycopy(resData.resData, 0, temp, 0, dataLen);
                        resData.resData = temp;
                    }
                    this.processLCDMessage(resData);
                    UMLog.i("emv_secondResponse", "done: " + done);
                    if (done) {
                        return;
                    }
                    if (resDataNew != null) {
                        resData = resDataNew;
                        if (resData.statusCode != 1 || resData.resData.length <= 12 || resData.resData[10] == 97) continue;
                        secondResponse = true;
                        mode = 4;
                        break;
                    }
                } else if (resData.resData.length > 12 && resData.resData[10] == 97 && resData.resData[11] == 4) {
                    if (resData.resData.length > 14) {
                        String[] theStrings = new String[1];
                        char[] chars = new char[]{(char)resData.resData[14]};
                        String s = new String(chars);
                        theStrings[0] = new String(s);
                        this.m_recListener.lcdDisplay(34, theStrings, timeout);
                        this.m_recListener.lcdDisplay(34, theStrings, timeout, null, (byte)0);
                    }
                } else {
                    if (resData.resData.length > 12 && resData.resData[10] == 97 && resData.resData[11] == 2) {
                        resData.timeout = timeout;
                        this.processPINMessage(resData);
                        isCommandRunning = false;
                        return;
                    }
                    if (resData.resData.length > 12 && resData.resData[0] != 86 && resData.resData[1] != 105 && resData.resData[2] != 86) {
                        break;
                    }
                }
            } else {
                if (emvCancelTransaction) {
                    emvData.result = 18;
                    this.m_recListener.emvTransactionData(emvData);
                    return;
                }
                if (resData.resData.length > 1 && (resData.resData[0] == 6 || resData.resData[0] == 21)) {
                    secondResponse = true;
                    resData.timeout = timeout;
                    break;
                }
                if (resData.resData.length > 3 && resData.resData[0] == 73 && resData.resData[1] == 114 && resData.resData[2] == 1) {
                    boolean done = false;
                    if (resData.resData.length > 5 && (resData.resData[5] == 1 || resData.resData[5] == 2 || resData.resData[5] == 8)) {
                        done = true;
                    }
                    resData.timeout = timeout;
                    this.processLCDMessage(resData);
                    if (done) {
                        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA) {
                            isCommandRunning = false;
                        }
                        return;
                    }
                } else if (resData.resData.length > 3 && resData.resData[0] == 73 && resData.resData[1] == 114 && resData.resData[2] == 3) {
                    secondResponse = true;
                    byte[] displayLanguage = new byte[2];
                    try {
                        System.arraycopy(resData.resData, 7, displayLanguage, 0, 2);
                        int messageControlLen = resData.resData[9] & 0xFF | (resData.resData[10] & 0xFF) << 8;
                        if (messageControlLen > 0) {
                            byte[] messageControlData = new byte[messageControlLen];
                            System.arraycopy(resData.resData, 11, messageControlData, 0, messageControlLen);
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException exception) {
                        return;
                    }
                }
            }
            resData = new ResDataStruct();
        }
        UMLog.i("emv_secondResponse", "resData.resData: " + Common.base16Encode(resData.resData));
        if (!secondResponse) {
            resData.ret = 3;
        }
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_BTPAY || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_BTPAY_USB) {
            int index = resData.resData[0] == 0 ? 0 : 1;
            try {
                if (resData.resData[index] == 0 && resData.resData[index + 1] == 13 && resData.resData[index + 2] == 0) {
                    resData.ret = 3;
                }
            }
            catch (ArrayIndexOutOfBoundsException exception) {
                return;
            }
        }
        int offset = 4;
        boolean msrFallback = false;
        UMLog.i("emv_secondResponse", "mode: " + mode);
        if (mode == 5) {
            resData.statusCode = 0;
            if (resData.resData == null || resData.resData.length == 1 && resData.resData[0] == 0) {
                resData.statusCode = 10;
            } else {
                this.convertIDG(resData, 0);
            }
            isCommandRunning = false;
            readyForNextCommand = true;
            if (resData.statusCode != 0) {
                resData.resData = null;
            }
            this.m_recListenerPIN.pinpadData(resData.resData);
        } else if (mode == 1 || mode == 2 || mode == 3 || mode == 4) {
            int len;
            if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA) {
                if (resData.ret == 3) {
                    emvData.result = 8;
                    this.cardData = new IDTMSRData();
                    Common.parseCardData3in1(resData.resData, this.cardData);
                    emvData.msr_cardData = this.cardData;
                    this.m_recListener.emvTransactionData(this.checkBypassCompletion(emvData));
                    if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA && mode == 3) {
                        this.runEMVTransaction = false;
                    }
                    if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA) {
                        this.emv_controlLED_Transaction(Common.EMV_TRANSACTION_STAGE.EMV_AFTER_TRANSACTION, timeout);
                    }
                    isCommandRunning = false;
                    return;
                }
                len = resData.resData[0] & 0xFF;
                if (len == 2) {
                    if (resData.resData[1] == 2) {
                        emvData.result = 0;
                    }
                    emvData.emv_hasReversal = (resData.resData[1] & 2) != 0;
                    boolean bl = emvData.emv_hasAdvise = (resData.resData[1] & 1) != 0;
                }
                if (resData.resData.length > 2) {
                    emvData.result = resData.resData[0] == 21 ? (resData.resData[1] & 0xFF) * 256 + resData.resData[2] : (resData.resData[1] & 0xFC) * 256 + resData.resData[2];
                }
                if (emvData.result == 7) {
                    msrFallback = true;
                    offset = 4;
                } else {
                    offset = emvData.result == 17 ? 4 : 4;
                }
            } else if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
                if (resData.ret == 3) {
                    emvData.result = 8;
                    this.cardData = new IDTMSRData();
                    if (resData.resData != null) {
                        Common.parseCardData3in1(resData.resData, this.cardData);
                    }
                    emvData.msr_cardData = this.cardData;
                    this.m_recListener.emvTransactionData(this.checkBypassCompletion(emvData));
                    isCommandRunning = false;
                    return;
                }
                int index = Common.indexOf(resData.resData, new byte[]{-33, -18, 37});
                if (index < 10) {
                    emvData.result = resData.resData[11] == 0 ? 2 : (resData.resData[11] == 35 ? 9 : 256);
                    UMLog.i("emv_secondResponse", "Missing DFEE25 Error Tag");
                    UMLog.i("emv_secondResponse", "emvData.result: " + emvData.result);
                } else {
                    index += 3;
                    try {
                        int len2 = resData.resData[index] & 0xFF;
                        if (len2 == 2) {
                            if (resData.resData[index + 1] == 2) {
                                emvData.result = 0;
                            }
                            emvData.emv_hasReversal = (resData.resData[index + 1] & 2) != 0;
                            emvData.emv_hasAdvise = (resData.resData[index + 1] & 1) != 0;
                        }
                        emvData.result = (resData.resData[index + 1] & 0xFC) * 256 + resData.resData[index + 2];
                        if (index == 2) {
                            emvData.result = 0xEE00 | resData.resData[11];
                            int idx = Common.indexOf(resData.resData, new byte[]{-97, 39, 1});
                            boolean isContactless = false;
                            boolean isGoOnline = false;
                            if ((idx += 3) > 2 && resData.resData[idx] == -128) {
                                isGoOnline = true;
                            }
                            idx = Common.indexOf(resData.resData, new byte[]{-97, 57, 1});
                            if ((idx += 3) > 2 && resData.resData[idx] == 7) {
                                isContactless = true;
                            }
                            if (isGoOnline) {
                                emvData.result = isContactless ? 9 : 4;
                            }
                        }
                        UMLog.i("emv_secondResponse", "emvData.result: " + emvData.result);
                        if (len2 == 2 && emvData.result == 7) {
                            msrFallback = true;
                        }
                        offset = index + 1 + len2;
                    }
                    catch (ArrayIndexOutOfBoundsException exception) {
                        return;
                    }
                }
            } else {
                if (resData.ret == 3) {
                    emvData.result = 8;
                    this.m_recListener.emvTransactionData(this.checkBypassCompletion(emvData));
                    isCommandRunning = false;
                    return;
                }
                emvData.result = resData.resData[1] * 256 + resData.resData[2];
                offset = 4;
            }
            if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
                if (resData.resData.length > 11 && resData.resData[11] == 0 && resData.resData.length > offset) {
                    try {
                        len = (resData.resData[13] & 0xFF) + (resData.resData[12] & 0xFF) * 256 - 1;
                        tlvData = new byte[len];
                        System.arraycopy(resData.resData, 15, tlvData, 0, tlvData.length);
                    }
                    catch (ArrayIndexOutOfBoundsException exception) {
                        return;
                    }
                }
            } else if (emvData.result != 7 && emvData.result != 17 && resData.resData.length > 0 && resData.resData[0] != 21 && resData.resData.length > offset) {
                try {
                    tlvData = new byte[resData.resData.length - offset];
                    System.arraycopy(resData.resData, offset, tlvData, 0, resData.resData.length - offset);
                }
                catch (ArrayIndexOutOfBoundsException exception) {
                    return;
                }
            }
            if ((autoAuthentication || _isFastEMV) && emvData.result == 16) {
                inEMVAuth = true;
                resData.ret = this.emv_authenticateTransaction(null);
                UMLog.i("emv_secondResponse", "emv_authenticateTransaction resData.ret: " + resData.ret);
                if ((resData.ret & 0xFF) == 99) {
                    this.cardData = new IDTMSRData();
                    Common.parseCardData3in1(resData.resData, this.cardData);
                    emvData.msr_cardData = this.cardData;
                } else if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
                    emvData.result = resData.ret == 6144 ? 18 : 20517;
                }
                inEMVAuth = false;
                if (!cancelInEMVAuth && !emvCancelTransaction) {
                    this.m_recListener.emvTransactionData(this.checkBypassCompletion(emvData));
                }
                cancelInEMVAuth = false;
            } else {
                byte attribute = 0;
                if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
                    if (resData.resData.length > 14) {
                        attribute = resData.resData[14];
                    }
                } else if (resData.resData.length > 3) {
                    attribute = resData.resData[3];
                }
                emvData.cardType = attribute & 1;
                emvData.encryptionMode = attribute >> 1 & 1;
                Map<String, Map<String, byte[]>> TLVDict = Common.processTLV(tlvData);
                if (TLVDict != null) {
                    emvData.unencryptedTags = TLVDict.get("tags");
                    emvData.encryptedTags = TLVDict.get("encrypted");
                    emvData.maskedTags = TLVDict.get("masked");
                }
                this.cardData = new IDTMSRData();
                this.cardData.result = emvData.result;
                if (emvData.result == 7 || emvData.result == 17 || emvData.result == 9) {
                    if (resData.resData.length > 3) {
                        int dataLen;
                        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA) {
                            if (_isTTK) {
                                byte[] msrData = new byte[resData.resData.length + 3];
                                dataLen = resData.resData.length;
                                msrData[0] = 2;
                                msrData[1] = (byte)(dataLen & 0xFF);
                                msrData[2] = (byte)(dataLen >> 8 & 0xFF);
                                try {
                                    System.arraycopy(resData.resData, 0, msrData, 3, msrData.length - 3);
                                }
                                catch (ArrayIndexOutOfBoundsException exception) {
                                    return;
                                }
                                this.cardData.result = 7;
                                Common.parseCardData3in1(msrData, this.cardData);
                            } else {
                                byte[] msrData = new byte[resData.resData.length + 6];
                                dataLen = resData.resData.length - 6;
                                msrData[0] = 2;
                                msrData[1] = (byte)(dataLen & 0xFF);
                                msrData[2] = (byte)(dataLen >> 8 & 0xFF);
                                try {
                                    System.arraycopy(resData.resData, 0, msrData, 3, msrData.length - 6);
                                }
                                catch (ArrayIndexOutOfBoundsException exception) {
                                    return;
                                }
                                String strData = Common.base16Encode(resData.resData);
                                String sum = Common.getSUM(strData.substring(6));
                                String lrc = Common.getLRC(strData.substring(6));
                                byte[] b = null;
                                b = Common.getBytesFromHexString(lrc);
                                msrData[msrData.length - 3] = b == null ? (byte)0 : b[0];
                                b = Common.getBytesFromHexString(sum);
                                msrData[msrData.length - 2] = b == null ? (byte)0 : b[0];
                                msrData[msrData.length - 1] = 3;
                                Common.Response.parseCardDataAugusta(msrData, this.cardData);
                                this.cardData.rawTrackData = new byte[msrData.length - 6];
                                try {
                                    System.arraycopy(msrData, 3, this.cardData.rawTrackData, 0, msrData.length - 6);
                                }
                                catch (ArrayIndexOutOfBoundsException exception) {
                                    return;
                                }
                                this.cardData.result = 0;
                            }
                        } else if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
                            if (_isTTK) {
                                byte[] msrData = new byte[resData.resData.length];
                                try {
                                    System.arraycopy(resData.resData, 0, msrData, 0, msrData.length);
                                }
                                catch (ArrayIndexOutOfBoundsException exception) {
                                    return;
                                }
                                this.cardData.result = 7;
                                Common.parseCardData3in1(msrData, this.cardData);
                                this.cardData.result = 0;
                                if (msrData.length > 11) {
                                    this.cardData.result = 0xEE00 | msrData[11];
                                }
                            } else {
                                byte[] msrData = new byte[resData.resData.length];
                                try {
                                    System.arraycopy(resData.resData, 0, msrData, 0, msrData.length);
                                }
                                catch (ArrayIndexOutOfBoundsException exception) {
                                    return;
                                }
                                this.cardData.result = 7;
                                Common.parseCardData3in1(msrData, this.cardData);
                                this.cardData.result = 0;
                                if (msrData.length > 11) {
                                    this.cardData.result = 0xEE00 | msrData[11];
                                }
                            }
                        } else {
                            byte[] msrData = new byte[resData.resData.length + 3];
                            dataLen = resData.resData.length;
                            msrData[0] = 2;
                            msrData[1] = (byte)(dataLen & 0xFF);
                            msrData[2] = (byte)(dataLen >> 8 & 0xFF);
                            try {
                                System.arraycopy(resData.resData, 0, msrData, 3, msrData.length - 3);
                            }
                            catch (ArrayIndexOutOfBoundsException exception) {
                                return;
                            }
                            this.cardData.result = 7;
                            Common.parseCardData3in1(msrData, this.cardData);
                        }
                    }
                } else if (_isTTK) {
                    if (isEMV_Terminate_TTK) {
                        emvData.encryptedTags = null;
                        emvData.maskedTags = null;
                        emvData.unencryptedTags = null;
                        isEMV_Terminate_TTK = false;
                    } else if (this.cardData.result == 17) {
                        Common.parseCardData3in1(resData.resData, this.cardData);
                    } else {
                        this.cardData.result = -2147483641;
                        Common.parseCardData3in1(resData.resData, this.cardData);
                        this.cardData.result = 0;
                    }
                } else {
                    UMLog.i("emv_secondResponse", "parseCardData3in1");
                    Common.parseCardData3in1(resData.resData, this.cardData);
                }
                emvData.msr_cardData = this.cardData;
                if (_isFastEMV && emvData.result != 4 && emvData.result != 16) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    UMLog.i("emv_secondResponse", "processFastEMV");
                    this.processFastEMV(emvData);
                }
                if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA) {
                    if (emvData.result == 4 || emvData.result == 16) {
                        if (!autoComplete && !_isFastEMV && emvData.result == 4 && mode == 2 && secondResponse) {
                            this.runEMVTransaction = false;
                        }
                        if (emvData.result == 16 && autoAuthentication || emvData.result == 4 && autoComplete) {
                            this.emv_controlLED_Transaction(Common.EMV_TRANSACTION_STAGE.EMV_MIDDLE_TRANSACTION, timeout);
                        }
                    } else {
                        if (mode == 3) {
                            this.runEMVTransaction = false;
                        }
                        this.emv_controlLED_Transaction(Common.EMV_TRANSACTION_STAGE.EMV_AFTER_TRANSACTION, timeout);
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                this.m_recListener.emvTransactionData(this.checkBypassCompletion(emvData));
                if (!autoComplete || emvData.result != 4) {
                    isCommandRunning = false;
                }
                UMLog.i("emv_secondResponse", "isCommandRunning: " + isCommandRunning);
            }
        } else {
            resData.ret = 9;
        }
    }

    public int emv_callbackResponseMSR(byte[] MSR) {
        if (!this.device_isConnected()) {
            return 1;
        }
        byte[] MSRLen = new byte[]{(byte)(MSR.length & 0xFF), (byte)(MSR.length >> 8 & 0xFF)};
        String data = Common.bytesToHex(MSRLen) + Common.bytesToHex(MSR);
        ResDataStruct respData = new ResDataStruct();
        TaskManager.TaskStartRet r = null;
        r = this.sendCommand_helper("72490306" + data, 0, respData);
        return this.returnACK(r, respData);
    }

    public int emv_callbackResponsePIN(int mode, byte[] KSN, byte[] PIN) {
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        isCommandRunning = true;
        this.waitForNotification();
        TaskManager.TaskStartRet r = null;
        ResDataStruct respData = new ResDataStruct();
        boolean cmd = false;
        int rt = 9;
        boolean loopNum = false;
        if (mode == -1) {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)5, (byte)1, new byte[0])), 0, respData);
        } else if (mode == 0) {
            r = this.sendCommandOnly_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)97, (byte)2, new byte[]{0})), 0);
        } else {
            int x;
            int length = 5 + (PIN == null ? 0 : PIN.length);
            if (KSN != null) {
                length += KSN.length;
            }
            byte[] theCMD = new byte[length];
            int pointer = 0;
            theCMD[pointer++] = (byte)mode;
            theCMD[pointer++] = KSN != null ? (byte)KSN.length : (byte)0;
            theCMD[pointer++] = 0;
            if (KSN != null && KSN.length > 0) {
                for (x = 0; x < KSN.length; ++x) {
                    theCMD[pointer++] = KSN[x];
                }
            }
            theCMD[pointer++] = PIN == null ? (byte)0 : (byte)PIN.length;
            theCMD[pointer++] = 0;
            if (PIN != null) {
                for (x = 0; x < PIN.length; ++x) {
                    theCMD[pointer++] = PIN[x];
                }
            }
            r = this.sendCommandOnly_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)97, (byte)2, theCMD)), 0);
        }
        isBurstModeOn = mode != 0;
        if (isBurstModeOn || !isAutoPollOn) {
            cardSeated = false;
        }
        isCommandRunning = false;
        final int timeout = _timeout;
        new Thread(new Runnable(){

            @Override
            public void run() {
                IDT_Device.this.emv_secondResponse(timeout, 1, null);
            }
        }).start();
        return 0;
    }

    public int emv_completeTransaction(boolean commError, byte[] authCode, byte[] iad, byte[] tlvScripts, byte[] tags) {
        TaskManager.TaskStartRet r;
        String commandString;
        String string = commandString = commError ? "00" : "01";
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_BTPAY || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_BTPAY_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
            String string2 = commandString = commError ? "01" : "00";
        }
        if (!this.isICCDeviceSelected() || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_USB) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        isCommandRunning = true;
        this.waitForNotification();
        ResDataStruct respData = new ResDataStruct();
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA) {
            this.runEMVTransaction = true;
        }
        if (!commError) {
            if (authCode == null) {
                isCommandRunning = false;
                return 27392;
            }
            if (authCode.length != 2) {
                isCommandRunning = false;
                return 27392;
            }
            if (iad == null) {
                iad = new byte[]{};
            } else if (iad.length > 2032) {
                isCommandRunning = false;
                return 27392;
            }
            if (tlvScripts == null) {
                tlvScripts = new byte[]{};
            } else if (tlvScripts.length > 2032) {
                isCommandRunning = false;
                return 27392;
            }
            if (tags == null) {
                tags = new byte[]{};
            } else if (tags.length > 2032) {
                isCommandRunning = false;
                return 27392;
            }
            byte[] t8A = new byte[]{-118, (byte)authCode.length};
            commandString = commandString + Common.getHexStringFromBytes(t8A);
            commandString = commandString + Common.getHexStringFromBytes(authCode);
            if (iad.length > 0) {
                byte[] t91 = new byte[]{-111, (byte)iad.length};
                commandString = commandString + Common.getHexStringFromBytes(t91);
                commandString = commandString + Common.getHexStringFromBytes(iad);
            }
            if (tlvScripts.length > 0) {
                commandString = commandString + Common.getHexStringFromBytes(tlvScripts);
            }
            if (tags.length > 0) {
                String temp = Common.getHexStringFromBytes(tags);
                if (_isTTK && temp.contains("DFEF510101")) {
                    temp = temp.replace("DFEF510101", "");
                    _bypassCompletion = true;
                }
                commandString = commandString + temp;
            }
            if (_isTTK) {
                commandString = commandString + "DFEE1A485F2857DF4ADF4C849F395F349F279F029F039F349F359F1E9F539F099F41DF4D9F269F10829F369F37959A9C9F339F15DF4FDF4F9F075F255F24DF4BDFEE23DFEE25DFEE265ADF34";
            }
        }
        int cmd = 0;
        int rt = 9;
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_BTPAY || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_BTPAY_USB) {
            r = this.sendCommand_helper("724603" + commandString, _timeout, respData);
            if (respData.resData == null || respData.resData.length == 0) {
                isCommandRunning = false;
                return rt;
            }
            byte[] tmp2 = respData.resData;
            if (respData.resData.length == 9 && tmp2[3] == 21) {
                isCommandRunning = false;
                return tmp2[5] + tmp2[4] * 256;
            }
            if (respData.resData.length == 3 && tmp2[0] == 21) {
                isCommandRunning = false;
                return tmp2[2] + tmp2[1] * 256;
            }
            if (respData.resData.length == 2) {
                isCommandRunning = false;
                return tmp2[1] + tmp2[0] * 256;
            }
            if (r != TaskManager.TaskStartRet.SUCCESS) {
                isCommandRunning = false;
                return tmp2[2] + tmp2[1] * 256;
            }
        } else if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA) {
            if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA) {
                while (this.runLEDControl) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException tmp2) {}
                }
            }
            r = this.sendCommand_helper("72460503" + commandString, _timeout, respData);
            if (respData.resData == null || respData.resData.length == 0) {
                isCommandRunning = false;
                return rt;
            }
            byte[] tmp2 = respData.resData;
            if (respData.resData.length == 9 && tmp2[3] == 21) {
                isCommandRunning = false;
                return tmp2[5] + tmp2[4] * 256;
            }
            if (respData.resData.length == 3 && tmp2[0] == 21) {
                isCommandRunning = false;
                return tmp2[2] + tmp2[1] * 256;
            }
            if (respData.resData.length == 2) {
                isCommandRunning = false;
                return tmp2[1] + tmp2[0] * 256;
            }
            if (r != TaskManager.TaskStartRet.SUCCESS) {
                isCommandRunning = false;
                return tmp2[2] + tmp2[1] * 256;
            }
            final int timeout = _timeout;
            if (respData.resData.length > 100) {
                this.emv_secondResponse(timeout, 3, respData);
            } else {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        IDT_Device.this.emv_secondResponse(timeout, 3, null);
                    }
                }).start();
            }
        } else {
            if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
                int len;
                TaskManager.TaskStartRet r2;
                if (emvCancelTransaction) {
                    return 6144;
                }
                int loopNum = 0;
                do {
                    r2 = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)2, (byte)6, Common.getBytesFromHexString(commandString))), _timeout, respData);
                    ++loopNum;
                    if (r2 != TaskManager.TaskStartRet.SUCCESS) continue;
                    if (respData.resData == null) {
                        isCommandRunning = false;
                        return 21;
                    }
                    if (respData.resData.length == 1 && respData.resData[0] == 0) {
                        isCommandRunning = false;
                        return 3;
                    }
                    rt = 9;
                    int len2 = respData.resData.length;
                    if (len2 <= 11) continue;
                    rt = respData.resData[11];
                    cmd = respData.resData[10];
                    if (cmd != -18 || rt != -16) continue;
                    isCommandRunning = false;
                    return this.returnACK(r2, respData);
                } while (loopNum < maxLoopNum && (rt != 0 || cmd != 2));
                isCommandRunning = false;
                IDTEMVData emvData = new IDTEMVData();
                int index = Common.indexOf(respData.resData, new byte[]{-33, -18, 37});
                if (index != -1) {
                    len = respData.resData[index += 3] & 0xFF;
                    if (len == 2) {
                        if (respData.resData[index + 1] == 2) {
                            emvData.result = 0;
                        }
                        emvData.emv_hasReversal = (respData.resData[index + 1] & 2) != 0;
                        emvData.emv_hasAdvise = (respData.resData[index + 1] & 1) != 0;
                    }
                    emvData.result = (respData.resData[index + 1] & 0xFC) * 256 + respData.resData[index + 2];
                } else {
                    emvData.result = rt == 0 ? 2 : 256;
                }
                if (respData.resData.length > 18) {
                    len = (respData.resData[13] & 0xFF) + (respData.resData[12] & 0xFF) * 256 - 1;
                    byte attribute = respData.resData[14];
                    byte[] tlvData = new byte[len];
                    System.arraycopy(respData.resData, 15, tlvData, 0, tlvData.length);
                    emvData.cardType = attribute & 1;
                    emvData.encryptionMode = attribute >> 1 & 1;
                    Map<String, Map<String, byte[]>> tlvDict = Common.processTLV(tlvData);
                    if (tlvDict != null) {
                        emvData.unencryptedTags = tlvDict.get("tags");
                        emvData.encryptedTags = tlvDict.get("encrypted");
                        emvData.maskedTags = tlvDict.get("masked");
                    }
                    this.cardData = new IDTMSRData();
                    this.cardData.result = emvData.result;
                }
                isCommandRunning = false;
                if (_isFastEMV) {
                    this.processFastEMV(emvData);
                }
                UMLog.i("**emv_completeTransaction**", "emvTransactionData()");
                this.m_recListener.emvTransactionData(this.checkBypassCompletion(emvData));
                return this.returnACK(r2, respData);
            }
            if (emvCancelTransaction) {
                return 6144;
            }
            int loopNum = 0;
            do {
                UMLog.i("**emv_completeTransaction**", "loopNum: " + loopNum + " _timeout: " + _timeout);
                r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)96, (byte)18, Common.getBytesFromHexString(commandString))), _timeout, respData);
                ++loopNum;
                if (r == TaskManager.TaskStartRet.SUCCESS) {
                    if (respData.resData == null) {
                        isCommandRunning = false;
                        return 21;
                    }
                    if (respData.resData.length == 1 && respData.resData[0] == 0) {
                        isCommandRunning = false;
                        return 3;
                    }
                    UMLog.i("**emv_completeTransaction**", "respData.resData " + Common.base16Encode(respData.resData));
                    rt = 9;
                    int len = respData.resData.length;
                    if (len > 11) {
                        rt = respData.resData[11];
                        cmd = respData.resData[10];
                        if (cmd == -18 && rt == -16) break;
                    }
                }
                if (loopNum < maxLoopNum && (rt != 99 && rt != 0 || cmd != 96)) {
                    try {
                        Thread.sleep(450L);
                    }
                    catch (InterruptedException len) {
                        // empty catch block
                    }
                }
                UMLog.i("**emv_completeTransaction**", "loopNum: " + loopNum + " maxLoopNum: " + maxLoopNum + " rt: " + rt);
            } while (loopNum < maxLoopNum && (rt != 99 && rt != 0 || cmd != 96));
            UMLog.i("**emv_completeTransaction**", "rt: " + rt);
            if (rt != 99 && rt != 0) {
                isCommandRunning = false;
                return this.returnACK(r, respData);
            }
            final int timeout = _timeout;
            if (respData.resData.length > 100) {
                this.emv_secondResponse(timeout, 3, respData);
            } else {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        IDT_Device.this.emv_secondResponse(timeout, 3, null);
                    }
                }).start();
            }
        }
        return this.returnACK(r, respData);
    }

    public int emv_retrieveTransactionResult(byte[] tags, Map<String, Map<String, byte[]>> retrievedTags) {
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (tags == null || tags.length == 0 || tags.length > 2032 || retrievedTags == null) {
            return 27392;
        }
        ResDataStruct respData = new ResDataStruct();
        isCommandRunning = true;
        this.waitForNotification();
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA) {
            r = this.sendCommand_helper("72460701" + String.format(Locale.US, "%02X", (byte)tags.length) + "00" + Common.getHexStringFromBytes(tags), 0, respData);
            if (respData.resData != null && respData.resData.length > 7 && respData.resData[3] == 6) {
                int tvlLen = respData.resData.length - 7;
                byte[] tlvData = new byte[tvlLen];
                System.arraycopy(respData.resData, 4, tlvData, 0, tvlLen);
                Map<String, Map<String, byte[]>> returnTags = Common.processTLV(tlvData);
                retrievedTags.putAll(returnTags);
            }
        } else {
            int loopNum = 0;
            int cmd = 0;
            int rt = 9;
            do {
                r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)96, (byte)19, tags)), _timeout, respData);
                ++loopNum;
                if (r == TaskManager.TaskStartRet.SUCCESS) {
                    if (respData.resData == null) {
                        isCommandRunning = false;
                        return 21;
                    }
                    if (respData.resData.length == 1 && respData.resData[0] == 0) {
                        isCommandRunning = false;
                        return 3;
                    }
                    rt = 9;
                    int len = respData.resData.length;
                    if (len > 11) {
                        rt = respData.resData[11];
                        cmd = respData.resData[10];
                        if (cmd == -18 && rt == -16) break;
                    }
                }
                if (loopNum >= maxLoopNum || rt == 0 && cmd == 96) continue;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException len) {
                    // empty catch block
                }
            } while (loopNum < maxLoopNum && (rt != 0 || cmd != 96));
            if (rt != 0) {
                isCommandRunning = false;
                return this.returnACK(r, respData);
            }
            int dataLen = 0;
            if (respData.resData.length > 13) {
                dataLen = (respData.resData[12] & 0xFF) << 8 | respData.resData[13] & 0xFF;
            }
            byte attribute = 0;
            if (dataLen > 1) {
                attribute = respData.resData[14];
                byte[] tlvData = new byte[dataLen - 1];
                System.arraycopy(respData.resData, 15, tlvData, 0, dataLen - 1);
                Map<String, Map<String, byte[]>> returnTags = Common.processTLV(tlvData);
                retrievedTags.putAll(returnTags);
            }
        }
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int emv_cancelTransaction(ResDataStruct respData) {
        TaskManager.TaskStartRet r;
        block23: {
            block24: {
                if (respData == null) {
                    return 27392;
                }
                if (!this.isICCDeviceSelected() || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_USB) {
                    respData.statusCode = 20;
                    return 20;
                }
                isCommandRunning = true;
                this.waitForNotification();
                if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) break block24;
                emvCancelTransaction = true;
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                int cmd = 0;
                int rt = 9;
                int loopNum = 0;
                do {
                    r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)5, (byte)1, new byte[0])), 0, respData);
                    ++loopNum;
                    if (r == TaskManager.TaskStartRet.NO_RESPONSE) {
                        rt = 21;
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    if (r == TaskManager.TaskStartRet.SUCCESS) {
                        if (respData.resData == null) {
                            cancelTransaction = false;
                            isCommandRunning = false;
                            respData.statusCode = 21;
                            return 21;
                        }
                        if (respData.resData.length == 1 && respData.resData[0] == 0) {
                            if (loopNum < maxLoopNum) {
                                rt = 0;
                                cmd = 0;
                                continue;
                            }
                            cancelTransaction = false;
                            isCommandRunning = false;
                            respData.statusCode = 3;
                            return 3;
                        }
                        rt = 9;
                        int len = respData.resData.length;
                        if (len > 11) {
                            rt = respData.resData[11];
                            cmd = respData.resData[10];
                            if (cmd == -18 && rt == -16) break block23;
                            if (rt != 0) {
                                rt = 9;
                            }
                        }
                    }
                    if (loopNum >= maxLoopNum || rt == 0 && cmd == 5) continue;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while (loopNum < maxLoopNum && (rt != 0 || cmd != 5));
                break block23;
                {
                }
            }
            emvCancelTransaction = true;
            if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA) {
                this.runEMVTransaction = true;
                while (this.runLEDControl) {
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException cmd) {}
                }
            }
            r = this.sendCommand_helper("724606", 0, respData);
            if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA) {
                this.runEMVTransaction = false;
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        IDT_Device.this.emv_controlLED_Transaction(Common.EMV_TRANSACTION_STAGE.EMV_AFTER_TRANSACTION, 5);
                        isCommandRunning = false;
                    }
                }).start();
            }
        }
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA) {
            isCommandRunning = false;
        }
        respData.statusCode = returnCode;
        return returnCode;
    }

    public void emv_lcdControlResponse(byte mode, byte selection) {
        this.lcd_data = new byte[4];
        this.lcd_data[0] = mode;
        this.lcd_data[1] = 1;
        this.lcd_data[2] = 0;
        this.lcd_data[3] = selection;
        final int timeout = _timeout;
        new Thread(new Runnable(){

            @Override
            public void run() {
                IDT_Device.this.emv_secondResponse(timeout, 1, null);
            }
        }).start();
    }

    public int emv_getEMVKernelVersion(StringBuilder version) {
        if (!(this.isICCDeviceSelected() && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI)) {
            return 20;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (!this.isICCDeviceSelected()) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (version == null) {
            return 27392;
        }
        ResDataStruct respData = new ResDataStruct();
        int cmd = 0;
        int rt = 9;
        isCommandRunning = true;
        this.waitForNotification();
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
            TaskManager.TaskStartRet r;
            if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V) {
                this.waitForVivo();
            }
            int loopNum = 0;
            do {
                r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)41, (byte)6, new byte[0])), 0, respData);
                ++loopNum;
                if (r == TaskManager.TaskStartRet.SUCCESS) {
                    if (respData.resData == null) {
                        isCommandRunning = false;
                        respData.statusCode = 21;
                        return 21;
                    }
                    if (respData.resData.length == 1 && respData.resData[0] == 0) {
                        isCommandRunning = false;
                        respData.statusCode = 3;
                        return 3;
                    }
                    rt = 9;
                    int len = respData.resData.length;
                    if (len > 11) {
                        rt = respData.resData[11];
                        cmd = respData.resData[10];
                        if (cmd == -18 && rt == -16) break;
                        if (rt != 0) {
                            rt = 9;
                        }
                    }
                }
                if (loopNum >= maxLoopNum || rt == 0 && cmd == 41) continue;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException len) {
                    // empty catch block
                }
            } while (loopNum < maxLoopNum && (rt != 0 || cmd != 41));
            int returnCode = this.returnACK(r, respData);
            this.convertIDG(respData, 0);
            String verStr = Common.getAsciiFromByte(respData.resData);
            version.append(verStr);
            isCommandRunning = false;
            respData.statusCode = returnCode;
            return returnCode;
        }
        TaskManager.TaskStartRet r = connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA ? this.sendCommand_helper("72460802", 0, respData) : this.sendCommand_helper("72460802", 0, respData);
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        String verStr = Common.getAsciiFromByte(respData.resData);
        version.append(verStr);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int emv_getEMVKernelCheckValue(ResDataStruct respData) {
        if (respData == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            respData.statusCode = 29696;
            return 29696;
        }
        if (!(this.isICCDeviceSelected() && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI)) {
            respData.statusCode = 20;
            return 20;
        }
        if (!this.device_isConnected()) {
            respData.statusCode = 1;
            return 1;
        }
        int cmd = 0;
        int rt = 9;
        isCommandRunning = true;
        this.waitForNotification();
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
            TaskManager.TaskStartRet r;
            if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V) {
                this.waitForVivo();
            }
            int loopNum = 0;
            do {
                r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)41, (byte)8, new byte[0])), 0, respData);
                ++loopNum;
                if (r == TaskManager.TaskStartRet.SUCCESS) {
                    if (respData.resData == null) {
                        isCommandRunning = false;
                        respData.statusCode = 21;
                        return 21;
                    }
                    if (respData.resData.length == 1 && respData.resData[0] == 0) {
                        isCommandRunning = false;
                        respData.statusCode = 3;
                        return 3;
                    }
                    rt = 9;
                    int len = respData.resData.length;
                    if (len > 11) {
                        rt = respData.resData[11];
                        cmd = respData.resData[10];
                        if (cmd == -18 && rt == -16) break;
                        if (rt != 0) {
                            rt = 9;
                        }
                    }
                }
                if (loopNum >= maxLoopNum || rt == 0 && cmd == 41) continue;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException len) {
                    // empty catch block
                }
            } while (loopNum < maxLoopNum && (rt != 0 || cmd != 41));
            int returnCode = this.returnACK(r, respData);
            this.convertIDG(respData, 2);
            isCommandRunning = false;
            respData.statusCode = returnCode;
            return returnCode;
        }
        TaskManager.TaskStartRet r = connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA ? this.sendCommand_helper("72460901", 0, respData) : this.sendCommand_helper("72460901", 0, respData);
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int emv_getEMVConfigurationCheckValue(ResDataStruct respData) {
        if (respData == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            respData.statusCode = 29696;
            return 29696;
        }
        if (!(this.isICCDeviceSelected() && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI)) {
            respData.statusCode = 20;
            return 20;
        }
        if (!this.device_isConnected()) {
            respData.statusCode = 1;
            return 1;
        }
        int cmd = 0;
        int rt = 9;
        isCommandRunning = true;
        this.waitForNotification();
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
            TaskManager.TaskStartRet r;
            if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V) {
                this.waitForVivo();
            }
            int loopNum = 0;
            do {
                r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)41, (byte)9, new byte[0])), 0, respData);
                ++loopNum;
                if (r == TaskManager.TaskStartRet.SUCCESS) {
                    if (respData.resData == null) {
                        isCommandRunning = false;
                        respData.statusCode = 21;
                        return 21;
                    }
                    if (respData.resData.length == 1 && respData.resData[0] == 0) {
                        isCommandRunning = false;
                        respData.statusCode = 3;
                        return 3;
                    }
                    rt = 9;
                    int len = respData.resData.length;
                    if (len > 11) {
                        rt = respData.resData[11];
                        cmd = respData.resData[10];
                        if (cmd == -18 && rt == -16) break;
                        if (rt != 0) {
                            rt = 9;
                        }
                    }
                }
                if (loopNum >= maxLoopNum || rt == 0 && cmd == 41) continue;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException len) {
                    // empty catch block
                }
            } while (loopNum < maxLoopNum && (rt != 0 || cmd != 41));
            int returnCode = this.returnACK(r, respData);
            this.convertIDG(respData, 2);
            isCommandRunning = false;
            respData.statusCode = returnCode;
            return returnCode;
        }
        TaskManager.TaskStartRet r = connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA ? this.sendCommand_helper("72460902", 0, respData) : this.sendCommand_helper("72460902", 0, respData);
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int emv_authenticateTransaction(byte[] tags) {
        TaskManager.TaskStartRet r;
        if (!this.isICCDeviceSelected() || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_USB) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        isCommandRunning = true;
        this.waitForNotification();
        int dataLen = 0;
        if (tags == null) {
            tags = new byte[]{};
        } else if (tags.length > 2032) {
            isCommandRunning = false;
            return 27392;
        }
        if (_isTTK) {
            String additionalStrings = Common.getHexStringFromBytes(tags);
            additionalStrings = additionalStrings + "DFEE1A485F2857DF4ADF4C849F395F349F279F029F039F349F359F1E9F539F099F41DF4D9F269F10829F369F37959A9C9F339F15DF4FDF4F9F075F255F24DF4BDFEE23DFEE25DFEE265ADF34";
            tags = Common.getByteArray(additionalStrings);
        }
        if (tags != null) {
            dataLen = tags.length;
        }
        int cmd = 0;
        int rt = 9;
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA) {
            this.runEMVTransaction = true;
        }
        ResDataStruct respData = new ResDataStruct();
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
            if (emvCancelTransaction) {
                return 6144;
            }
            if (_timeout == 0) {
                _timeout = 30;
            }
            byte[] baTimeout = new byte[]{(byte)(_timeout >> 8 & 0xFF), (byte)(_timeout & 0xFF)};
            byte[] data = new byte[dataLen + 3];
            data[0] = _forceOnline ? (byte)1 : 0;
            System.arraycopy(baTimeout, 0, data, 1, 2);
            if (dataLen > 0) {
                System.arraycopy(tags, 0, data, 3, tags.length);
            }
            if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V) {
                this.waitForVivo();
            }
            int loopNum = 0;
            do {
                r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)96, (byte)17, data)), 0, respData);
                ++loopNum;
                if (r == TaskManager.TaskStartRet.SUCCESS) {
                    if (respData.resData == null) {
                        isCommandRunning = false;
                        return 21;
                    }
                    if (respData.resData.length == 1 && respData.resData[0] == 0) {
                        isCommandRunning = false;
                        return 3;
                    }
                    rt = 9;
                    int len = respData.resData.length;
                    if (len > 11) {
                        rt = respData.resData[11];
                        cmd = respData.resData[10];
                        if (cmd == -18 && rt == -16) break;
                    }
                }
                if (loopNum >= maxLoopNum || (rt == 99 || rt == 0) && cmd == 96) continue;
                try {
                    Thread.sleep(450L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (loopNum < maxLoopNum && (rt != 99 && rt != 0 || cmd != 96));
            if (rt != 99 && rt != 0) {
                isCommandRunning = false;
                return this.returnACK(r, respData);
            }
        } else {
            String foreceOnline = _forceOnline ? "01" : "00";
            byte[] baTimeout = new byte[]{(byte)(_timeout & 0xFF), (byte)(_timeout >> 8 & 0xFF)};
            if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA) {
                while (this.runLEDControl) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            r = this.sendCommand_helper("72460502" + foreceOnline + Common.bytesToHex(baTimeout) + (tags == null ? "" : Common.bytesToHex(tags)), _timeout, respData);
        }
        final int timeout = _timeout;
        if (respData.resData.length > 100) {
            this.emv_secondResponse(timeout, 2, respData);
        } else {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    IDT_Device.this.emv_secondResponse(timeout, 2, null);
                }
            }).start();
        }
        return this.returnACK(r, respData);
    }

    public int device_setPMCStatus(byte[] idleSleepTime, ResDataStruct respData) {
        int ec;
        TaskManager.TaskStartRet r;
        int dataLen;
        if (respData == null) {
            return 27392;
        }
        if (!this.device_isConnected()) {
            respData.statusCode = 1;
            return 1;
        }
        int n = dataLen = idleSleepTime == null ? 0 : idleSleepTime.length;
        if (dataLen < 1 || dataLen > 2032) {
            respData.statusCode = 27392;
            return 27392;
        }
        int cmd = 0;
        int rt = 9;
        isCommandRunning = true;
        this.waitForNotification();
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V) {
            this.waitForVivo();
        }
        int loopNum = 0;
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-16, (byte)0, idleSleepTime)), 0, respData);
            ++loopNum;
            if (r == TaskManager.TaskStartRet.SUCCESS) {
                if (respData.resData == null) {
                    isCommandRunning = false;
                    respData.statusCode = 21;
                    return 21;
                }
                if (respData.resData.length == 1 && respData.resData[0] == 0) {
                    isCommandRunning = false;
                    respData.statusCode = 3;
                    return 3;
                }
                rt = 9;
                int len = respData.resData.length;
                if (len > 11) {
                    rt = respData.resData[11];
                    cmd = respData.resData[10];
                    if (cmd == -18 && rt == -16) break;
                    if (rt != 0) {
                        rt = 9;
                    }
                }
            }
            if (loopNum >= maxLoopNum || rt == 0 && cmd == -16) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException len) {
                // empty catch block
            }
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != -16));
        isCommandRunning = false;
        respData.statusCode = ec = this.returnACK(r, respData);
        return ec;
    }

    public int device_getPMCStatus(ResDataStruct respData) {
        int ec;
        TaskManager.TaskStartRet r;
        if (respData == null) {
            return 27392;
        }
        if (!this.device_isConnected()) {
            respData.statusCode = 1;
            return 1;
        }
        int cmd = 0;
        int rt = 9;
        isCommandRunning = true;
        this.waitForNotification();
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V) {
            this.waitForVivo();
        }
        int loopNum = 0;
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-16, (byte)1, new byte[0])), 0, respData);
            ++loopNum;
            if (r == TaskManager.TaskStartRet.SUCCESS) {
                if (respData.resData == null) {
                    isCommandRunning = false;
                    respData.statusCode = 21;
                    return 21;
                }
                if (respData.resData.length == 1 && respData.resData[0] == 0) {
                    isCommandRunning = false;
                    respData.statusCode = 3;
                    return 3;
                }
                rt = 9;
                int len = respData.resData.length;
                if (len > 11) {
                    rt = respData.resData[11];
                    cmd = respData.resData[10];
                    if (cmd == -18 && rt == -16) break;
                    if (rt != 0) {
                        rt = 9;
                    }
                }
            }
            if (loopNum >= maxLoopNum || rt == 0 && cmd == -16) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException len) {
                // empty catch block
            }
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != -16));
        isCommandRunning = false;
        respData.statusCode = ec = this.returnACK(r, respData);
        return ec;
    }

    public int device_shutOffPower(ResDataStruct respData) {
        int ec;
        TaskManager.TaskStartRet r;
        if (respData == null) {
            return 27392;
        }
        if (!this.device_isConnected()) {
            respData.statusCode = 1;
            return 1;
        }
        int cmd = 0;
        int rt = 9;
        isCommandRunning = true;
        this.waitForNotification();
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V) {
            this.waitForVivo();
        }
        int loopNum = 0;
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-16, (byte)15, new byte[0])), 0, respData);
            ++loopNum;
            if (r == TaskManager.TaskStartRet.SUCCESS) {
                if (respData.resData == null) {
                    isCommandRunning = false;
                    respData.statusCode = 21;
                    return 21;
                }
                if (respData.resData.length == 1 && respData.resData[0] == 0) {
                    isCommandRunning = false;
                    respData.statusCode = 3;
                    return 3;
                }
                rt = 9;
                int len = respData.resData.length;
                if (len > 11) {
                    rt = respData.resData[11];
                    cmd = respData.resData[10];
                    if (cmd == -18 && rt == -16) break;
                    if (rt != 0) {
                        rt = 9;
                    }
                }
            }
            if (loopNum >= maxLoopNum || rt == 0 && cmd == -16) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException len) {
                // empty catch block
            }
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != -16));
        isCommandRunning = false;
        respData.statusCode = ec = this.returnACK(r, respData);
        return ec;
    }

    public int msr_reviewAllSetting(MSRSettingStruct msrSetting) {
        if (msrSetting == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_BTPAY && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_BTPAY_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_BTMAG && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA) {
            return 20;
        }
        ResDataStruct respData = new ResDataStruct();
        isCommandRunning = true;
        this.waitForNotification();
        TaskManager.TaskStartRet r = connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_BTMAG ? this.sendCommand_helper("02521F034C", 0, respData) : (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG_KB ? this.sendCommand_helper("02521F034C", 4, respData) : this.sendCommand_helper("735200", 0, respData));
        int ec = this.returnACK(r, respData);
        if (ec == 0) {
            byte[] buff = respData.resData;
            int len = respData.resData.length;
            int i = 0;
            for (i = 5; i < len - 3; ++i) {
                if (buff[i] == 73) {
                    msrSetting.prePANID = buff[i += 2];
                }
                if (buff[i] == 74) {
                    msrSetting.postPANID = buff[i += 2];
                }
                if (buff[i] == 75) {
                    msrSetting.maskCharID = buff[i += 2];
                }
                if (buff[i] == 76) {
                    msrSetting.EncryptionType = buff[i += 2];
                }
                if (buff[i] == 80) {
                    msrSetting.dispExpDateID = buff[i += 2];
                }
                if (buff[i] == 126) {
                    msrSetting.Security_LevelID = buff[i += 2];
                }
                if (buff[i] == -124) {
                    msrSetting.EnOptionID = buff[i += 2];
                }
                if (buff[i] != -122) continue;
                msrSetting.MaskOptID = buff[i += 2];
            }
        }
        isCommandRunning = false;
        return ec;
    }

    public int device_reviewAllSetting(ResDataStruct respData) {
        TaskManager.TaskStartRet r;
        if (respData == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            respData.statusCode = 29696;
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VENDI && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG_KB) {
            respData.statusCode = 20;
            return 20;
        }
        if (!this.device_isConnected()) {
            respData.statusCode = 1;
            return 1;
        }
        byte[] data = new byte[]{};
        int cmd = 0;
        int rt = 9;
        isCommandRunning = true;
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG_KB) {
            TaskManager.TaskStartRet r2 = this.sendCommand_helper("02521F034C", 4, respData);
            int ec = this.returnACK(r2, respData);
            isCommandRunning = false;
            respData.statusCode = ec;
            return ec;
        }
        this.waitForNotification();
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V) {
            this.waitForVivo();
        }
        int loopNum = 0;
        do {
            r = connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI ? this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)3, (byte)7, data)), 0, respData) : this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)3, (byte)2, data)), 0, respData);
            ++loopNum;
            if (r == TaskManager.TaskStartRet.SUCCESS) {
                if (respData.resData == null) {
                    isCommandRunning = false;
                    respData.statusCode = 21;
                    return 21;
                }
                if (respData.resData.length == 1 && respData.resData[0] == 0) {
                    isCommandRunning = false;
                    respData.statusCode = 3;
                    return 3;
                }
                rt = 9;
                int len = respData.resData.length;
                if (len > 11) {
                    rt = respData.resData[11];
                    cmd = respData.resData[10];
                    if (cmd == -18 && rt == -16) break;
                    if (rt != 0) {
                        rt = 9;
                    }
                }
            }
            if (loopNum >= maxLoopNum || rt == 0 && cmd == 3) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException len) {
                // empty catch block
            }
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != 3));
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
            ResDataStruct resData = new ResDataStruct();
            int responseCount = 1;
            int[] responseIdx = new int[5];
            int idx = respData.resData.length;
            emvCancelTransaction = false;
            do {
                if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
                    this._com.readMessage(1, System.currentTimeMillis(), resData, true);
                } else {
                    _usb.readMessage(1, System.currentTimeMillis(), resData, true);
                }
                if (resData.resData.length == 1 && resData.resData[0] == 0) continue;
                responseIdx[responseCount - 1] = idx;
                ++responseCount;
                byte[] temp = new byte[idx += resData.resData.length];
                System.arraycopy(respData.resData, 0, temp, 0, respData.resData.length);
                System.arraycopy(resData.resData, 0, temp, respData.resData.length, resData.resData.length);
                respData.resData = temp;
            } while (resData.resData.length != 1 || resData.resData[0] != 0);
            if (responseCount > 1) {
                respData.responseIdxes = new int[responseCount - 1];
                for (int i = 0; i < responseCount - 1; ++i) {
                    respData.responseIdxes[i] = responseIdx[i];
                }
            }
        }
        int ec = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = ec;
        return ec;
    }

    public int msr_reviewSecurityLevel(byte[] secSetting) {
        if (!this.device_isConnected()) {
            return 1;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_BTMAG) {
            return 20;
        }
        ResDataStruct respData = new ResDataStruct();
        isCommandRunning = true;
        this.waitForNotification();
        TaskManager.TaskStartRet r = this.sendCommand_helper("02527E032D", 0, respData);
        int ec = this.returnACK(r, respData);
        if (ec == 0) {
            secSetting = new byte[respData.resData.length];
            System.arraycopy(respData.resData, 0, secSetting, 0, respData.resData.length);
        }
        isCommandRunning = false;
        return ec;
    }

    public int msr_setDecodingMethod(int method) {
        TaskManager.TaskStartRet r;
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_BTMAG) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        ResDataStruct respData = new ResDataStruct();
        isCommandRunning = true;
        this.waitForNotification();
        switch (method) {
            case 1: {
                r = this.sendCommand_helper("02531D0131037F", 0, respData);
                break;
            }
            case 2: {
                r = this.sendCommand_helper("02531D0133037D", 0, respData);
                break;
            }
            case 3: {
                r = this.sendCommand_helper("02531D0132037C", 0, respData);
                break;
            }
            case 4: {
                r = this.sendCommand_helper("02531D0130037E", 0, respData);
                break;
            }
            case 5: {
                r = this.sendCommand_helper("02531D0134037A", 0, respData);
                break;
            }
            default: {
                r = this.sendCommand_helper("02531D0131037F", 0, respData);
            }
        }
        isCommandRunning = false;
        return this.returnACK(r, respData);
    }

    public int msr_setKeyManagement(boolean fixed) {
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_BTMAG) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        ResDataStruct respData = new ResDataStruct();
        isCommandRunning = true;
        this.waitForNotification();
        TaskManager.TaskStartRet r = fixed ? this.sendCommand_helper("0253580130033B", 0, respData) : this.sendCommand_helper("0253580131033A", 0, respData);
        isCommandRunning = false;
        return this.returnACK(r, respData);
    }

    public int msr_selectMagneticTrack(int trackMode) {
        TaskManager.TaskStartRet r;
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_BTMAG) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        ResDataStruct respData = new ResDataStruct();
        isCommandRunning = true;
        this.waitForNotification();
        switch (trackMode) {
            case 1: {
                r = this.sendCommand_helper("02531301300370", 0, respData);
                break;
            }
            case 2: {
                r = this.sendCommand_helper("02531301310371", 0, respData);
                break;
            }
            case 3: {
                r = this.sendCommand_helper("02531301320372", 0, respData);
                break;
            }
            case 4: {
                r = this.sendCommand_helper("02531301330373", 0, respData);
                break;
            }
            case 5: {
                r = this.sendCommand_helper("02531301340374", 0, respData);
                break;
            }
            case 6: {
                r = this.sendCommand_helper("02531301350375", 0, respData);
                break;
            }
            case 7: {
                r = this.sendCommand_helper("02531301360376", 0, respData);
                break;
            }
            case 8: {
                r = this.sendCommand_helper("02531301370377", 0, respData);
                break;
            }
            case 9: {
                r = this.sendCommand_helper("02531301380378", 0, respData);
                break;
            }
            case 10: {
                r = this.sendCommand_helper("02531301390379", 0, respData);
                break;
            }
            default: {
                r = this.sendCommand_helper("02531301300370", 0, respData);
            }
        }
        isCommandRunning = false;
        return this.returnACK(r, respData);
    }

    public int msr_setTrackSeparator(int sep, String zz) {
        TaskManager.TaskStartRet r;
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_BTMAG) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        ResDataStruct respData = new ResDataStruct();
        isCommandRunning = true;
        this.waitForNotification();
        switch (sep) {
            case 1: {
                r = this.sendCommand_helper("025317010D0349", 0, respData);
                break;
            }
            case 2: {
                r = this.sendCommand_helper("02531701000344", 0, respData);
                break;
            }
            case 3: {
                if (zz == null) {
                    zz = "";
                }
                List<String> list = Common.getSUM_And_LRC("531701" + zz);
                String XX = list.get(0);
                r = this.sendCommand_helper("02531701" + zz + "03" + XX, 0, respData);
                break;
            }
            default: {
                r = this.sendCommand_helper("025317010D0349", 0, respData);
            }
        }
        isCommandRunning = false;
        return this.returnACK(r, respData);
    }

    public int msr_setTerminator(int ter, String zz) {
        TaskManager.TaskStartRet r;
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_BTMAG) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        ResDataStruct respData = new ResDataStruct();
        isCommandRunning = true;
        this.waitForNotification();
        switch (ter) {
            case 1: {
                r = this.sendCommand_helper("025321010D037F", 0, respData);
                break;
            }
            case 2: {
                r = this.sendCommand_helper("02532101000372", 0, respData);
                break;
            }
            case 3: {
                if (zz == null) {
                    zz = "";
                }
                List<String> list = Common.getSUM_And_LRC("532101" + zz);
                String XX = list.get(0);
                r = this.sendCommand_helper("02532101" + zz + "03" + XX, 0, respData);
                break;
            }
            default: {
                r = this.sendCommand_helper("025321010D037F", 0, respData);
            }
        }
        isCommandRunning = false;
        return this.returnACK(r, respData);
    }

    public int msr_setTrackPrefix(int track, String zz) {
        TaskManager.TaskStartRet r;
        byte[] len;
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_BTMAG) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        ResDataStruct respData = new ResDataStruct();
        if (zz == null) {
            zz = "";
        }
        len = new byte[]{(byte)(zz.length() / 2), (byte)(len[0] + 1)};
        String xxyy = Common.bytesToHex(len);
        isCommandRunning = true;
        this.waitForNotification();
        switch (track) {
            case 1: {
                List<String> list = Common.getSUM_And_LRC("5334" + xxyy + zz);
                String XX = list.get(0);
                r = this.sendCommand_helper("025334" + xxyy + zz + "03" + XX, 0, respData);
                break;
            }
            case 2: {
                List<String> list = Common.getSUM_And_LRC("5335" + xxyy + zz);
                String XX = list.get(0);
                r = this.sendCommand_helper("025335" + xxyy + zz + "03" + XX, 0, respData);
                break;
            }
            case 3: {
                List<String> list = Common.getSUM_And_LRC("5336" + xxyy + zz);
                String XX = list.get(0);
                r = this.sendCommand_helper("025336" + xxyy + zz + "03" + XX, 0, respData);
                break;
            }
            default: {
                List<String> list = Common.getSUM_And_LRC("5334" + xxyy + zz);
                String XX = list.get(0);
                r = this.sendCommand_helper("025334" + xxyy + zz + "03" + XX, 0, respData);
            }
        }
        isCommandRunning = false;
        return this.returnACK(r, respData);
    }

    public int msr_setTrackSuffix(int track, String zz) {
        TaskManager.TaskStartRet r;
        byte[] len;
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_BTMAG) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        ResDataStruct respData = new ResDataStruct();
        if (zz == null) {
            zz = "";
        }
        len = new byte[]{(byte)(zz.length() / 2), (byte)(len[0] + 1)};
        String xxyy = Common.bytesToHex(len);
        isCommandRunning = true;
        this.waitForNotification();
        switch (track) {
            case 1: {
                List<String> list = Common.getSUM_And_LRC("5337" + xxyy + zz);
                String XX = list.get(0);
                r = this.sendCommand_helper("025337" + xxyy + zz + "03" + XX, 0, respData);
                break;
            }
            case 2: {
                List<String> list = Common.getSUM_And_LRC("5338" + xxyy + zz);
                String XX = list.get(0);
                r = this.sendCommand_helper("025338" + xxyy + zz + "03" + XX, 0, respData);
                break;
            }
            case 3: {
                List<String> list = Common.getSUM_And_LRC("5339" + xxyy + zz);
                String XX = list.get(0);
                r = this.sendCommand_helper("025339" + xxyy + zz + "03" + XX, 0, respData);
                break;
            }
            default: {
                List<String> list = Common.getSUM_And_LRC("5337" + xxyy + zz);
                String XX = list.get(0);
                r = this.sendCommand_helper("025337" + xxyy + zz + "03" + XX, 0, respData);
            }
        }
        isCommandRunning = false;
        return this.returnACK(r, respData);
    }

    public int msr_showTrackPrefixMessage(int track) {
        TaskManager.TaskStartRet r;
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_BTMAG) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        ResDataStruct respData = new ResDataStruct();
        isCommandRunning = true;
        this.waitForNotification();
        switch (track) {
            case 1: {
                r = this.sendCommand_helper("0252340367", 0, respData);
                break;
            }
            case 2: {
                r = this.sendCommand_helper("0252350366", 0, respData);
                break;
            }
            case 3: {
                r = this.sendCommand_helper("0252360365", 0, respData);
                break;
            }
            default: {
                r = this.sendCommand_helper("0252340367", 0, respData);
            }
        }
        isCommandRunning = false;
        return this.returnACK(r, respData);
    }

    public int msr_showTrackSuffixMessage(int track) {
        TaskManager.TaskStartRet r;
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_BTMAG) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        ResDataStruct respData = new ResDataStruct();
        isCommandRunning = true;
        this.waitForNotification();
        switch (track) {
            case 1: {
                r = this.sendCommand_helper("0252370364", 0, respData);
                break;
            }
            case 2: {
                r = this.sendCommand_helper("025238036B", 0, respData);
                break;
            }
            case 3: {
                r = this.sendCommand_helper("025239036A", 0, respData);
                break;
            }
            default: {
                r = this.sendCommand_helper("0252370364", 0, respData);
            }
        }
        isCommandRunning = false;
        return this.returnACK(r, respData);
    }

    public int msr_changeToDefault() {
        return this.msr_defaultAllSetting();
    }

    public int msr_setPreamble(String zz) {
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_BTMAG) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        ResDataStruct respData = new ResDataStruct();
        isCommandRunning = true;
        this.waitForNotification();
        if (zz == null) {
            zz = "";
        }
        List<String> list = Common.getSUM_And_LRC("53D20201" + zz);
        String XX = list.get(0);
        TaskManager.TaskStartRet r = this.sendCommand_helper("0253D20201" + zz + "03" + XX, 0, respData);
        isCommandRunning = false;
        return this.returnACK(r, respData);
    }

    public int msr_setPostamble(String zz) {
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_BTMAG) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        ResDataStruct respData = new ResDataStruct();
        isCommandRunning = true;
        this.waitForNotification();
        if (zz == null) {
            zz = "";
        }
        List<String> list = Common.getSUM_And_LRC("53D30201" + zz);
        String XX = list.get(0);
        TaskManager.TaskStartRet r = this.sendCommand_helper("0253D30201" + zz + "03" + XX, 0, respData);
        isCommandRunning = false;
        return this.returnACK(r, respData);
    }

    public int msr_defaultAllSetting() {
        if (!this.device_isConnected()) {
            return 1;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_BTMAG && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG_KB) {
            return 20;
        }
        isCommandRunning = true;
        this.waitForNotification();
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_BTMAG) {
            ResDataStruct respData = new ResDataStruct();
            TaskManager.TaskStartRet r = this.sendCommand_helper("025318034A", 0, respData);
            if (r == TaskManager.TaskStartRet.SUCCESS && (r = this.sendCommand_helper("0253D20201020381", 0, respData)) == TaskManager.TaskStartRet.SUCCESS && (r = this.sendCommand_helper("0253D30201030381", 0, respData)) == TaskManager.TaskStartRet.SUCCESS && (r = this.sendCommand_helper("0253190135037F", 0, respData)) == TaskManager.TaskStartRet.SUCCESS) {
                r = this.sendCommand_helper("025385013103E7", 0, respData);
            }
            isCommandRunning = false;
            return this.returnACK(r, respData);
        }
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG_KB) {
            ResDataStruct respData = new ResDataStruct();
            TaskManager.TaskStartRet r = this.sendCommand_helper("025318034A", 6, respData);
            isCommandRunning = false;
            return this.returnACK(r, respData);
        }
        ResDataStruct respData = new ResDataStruct();
        TaskManager.TaskStartRet r = this.sendCommand_helper("735300", 0, respData);
        isCommandRunning = false;
        return this.returnACK(r, respData);
    }

    public int msr_getSingleSetting(byte funcID, byte[] response) {
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_USB) {
            return 20;
        }
        if (response == null || response.length < 1) {
            return 4;
        }
        if (funcID != 73 && funcID != 74 && funcID != 75 && funcID != 76 && funcID != 80 && funcID != 126 && funcID != -124 && funcID != -122) {
            return 4;
        }
        ResDataStruct respData = new ResDataStruct();
        byte[] _funcID = new byte[]{funcID};
        isCommandRunning = true;
        this.waitForNotification();
        TaskManager.TaskStartRet r = this.sendCommand_helper("735201" + Common.getHexStringFromBytes(_funcID), 0, respData);
        int ec = this.returnACK(r, respData);
        if (ec == 0) {
            byte[] buff = respData.resData;
            response[0] = buff[8];
        }
        isCommandRunning = false;
        return ec;
    }

    public int msr_setSingleSetting(byte funcID, byte setData) {
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_USB) {
            return 20;
        }
        if (funcID != 73 && funcID != 74 && funcID != 75 && funcID != 76 && funcID != 80 && funcID != 126 && funcID != -124 && funcID != -122) {
            return 4;
        }
        ResDataStruct respData = new ResDataStruct();
        byte[] _funcID = new byte[]{funcID};
        byte[] _setData = new byte[]{setData};
        isCommandRunning = true;
        this.waitForNotification();
        TaskManager.TaskStartRet r = this.sendCommand_helper("735301" + Common.getHexStringFromBytes(_funcID) + "01" + Common.getHexStringFromBytes(_setData), 0, respData);
        isCommandRunning = false;
        return this.returnACK(r, respData);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int ctls_startTransaction() {
        int check;
        TaskManager.TaskStartRet r;
        ResDataStruct respData;
        block28: {
            int p;
            if (!readyForNextCommand || !readyForCardSwipe) {
                return 29696;
            }
            if (!this.device_isConnected()) {
                return 1;
            }
            if (isAutoPollOn) {
                return 27137;
            }
            if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT && (p = this.device_pingDevice()) != 0) {
                this.device_pingDevice();
            }
            _isFastEMV = false;
            this.neo2Transaction = false;
            this.timeout = 30;
            this.transactionInterface = 1;
            this.cardSwipeErrorCode = 0;
            isCommandRunning = true;
            readyForCardSwipe = false;
            this.waitForNotification();
            if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIMAG || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIMAG_PRO) {
                this.handler.post(this.runnableStartMSRSwipe);
                return 0;
            }
            if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
                int ec;
                SimpleDateFormat sdf = new SimpleDateFormat("yyMMdd", Locale.US);
                String d = sdf.format(Calendar.getInstance().getTime());
                SimpleDateFormat sdf2 = new SimpleDateFormat("HHmmss", Locale.US);
                String d2 = sdf2.format(Calendar.getInstance().getTime());
                this.activateTransaction = true;
                this.emvTags = new HashMap<String, String>();
                this.emvTags.put("9F02", "000000000100");
                if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT) {
                    this.emvTags.put("DFEF37", "02");
                } else {
                    this.emvTags.put("9A", d);
                    this.emvTags.put("9F21", d2);
                }
                this.emvTags.put("9C", "00");
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        IDT_Device.this.activateTransaction();
                    }
                }).start();
                if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V) {
                    try {
                        Thread.sleep(1500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if ((ec = this.cardSwipeErrorCode) != 0) {
                    readyForCardSwipe = true;
                }
                return ec;
            }
            respData = new ResDataStruct();
            if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIJACK) {
                r = this.sendCommand_helper("00", 0, respData);
            } else if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_BTMAG) {
                r = this.sendCommand_helper("02531A01310378", 0, respData);
            } else {
                if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA) {
                    r = this.sendCommand_helper("7353011A0132", 0, respData);
                    if (r != TaskManager.TaskStartRet.SUCCESS) {
                        isCommandRunning = false;
                        readyForCardSwipe = true;
                        return this.returnResult(r);
                    }
                    if (respData.resData == null) {
                        isCommandRunning = false;
                        readyForCardSwipe = true;
                        return 59136;
                    }
                    if (respData.resData.length == 1 && respData.resData[0] == 0) {
                        isCommandRunning = false;
                        readyForCardSwipe = true;
                        return 3;
                    }
                    check = Common.Response.checkACK(respData.resData);
                    if (1 == check) {
                        r = this.sendCommand_helper("7346500130", 0, respData);
                        break block28;
                    } else {
                        if (0 == check) {
                            isCommandRunning = false;
                            readyForCardSwipe = true;
                            return Common.Response.ErrorCode(respData.resData);
                        }
                        isCommandRunning = false;
                        readyForCardSwipe = true;
                        return 9;
                    }
                }
                r = this.sendCommand_helper("73465130", 0, respData);
            }
        }
        if (r != TaskManager.TaskStartRet.SUCCESS) {
            isCommandRunning = false;
            readyForCardSwipe = true;
            return this.returnResult(r);
        }
        if (respData.resData == null) {
            isCommandRunning = false;
            readyForCardSwipe = true;
            return 59136;
        }
        if (respData.resData.length == 1 && respData.resData[0] == 0) {
            isCommandRunning = false;
            readyForCardSwipe = true;
            return 3;
        }
        check = connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIJACK || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_BTMAG ? Common.Response.checkUMACK(respData.resData) : Common.Response.checkACK(respData.resData);
        if (1 == check) {
            this.handler.post(this.runnableStartMSRSwipe);
            return 0;
        }
        if (0 == check) {
            isCommandRunning = false;
            readyForCardSwipe = true;
            return Common.Response.ErrorCode(respData.resData);
        }
        isCommandRunning = false;
        readyForCardSwipe = true;
        return 9;
    }

    public int msr_startTransaction(double amount, double amtOther, int type, int timeout, byte[] tags) {
        return this.msr_startTransaction(amount, amtOther, type, timeout, tags, false);
    }

    public int msr_startTransaction(double amount, double amtOther, int type, int timeout, byte[] tags, boolean isFastEMV) {
        this.fromOtherTransaction = (byte)2;
        return this.ctls_startTransaction(amount, amtOther, type, timeout, tags, isFastEMV);
    }

    @SuppressLint(value={"SimpleDateFormat"})
    public int ctls_startTransaction(double amount, double amtOther, int type, int timeout, byte[] tags) {
        return this.ctls_startTransaction(amount, amtOther, type, timeout, tags, false);
    }

    @SuppressLint(value={"SimpleDateFormat"})
    public int ctls_startTransaction(double amount, double amtOther, int type, int timeout, byte[] tags, boolean isFastEMV) {
        int ec;
        byte bcd;
        int temp;
        int i;
        String stDecimal;
        String[] numbers;
        int p;
        byte fot = this.fromOtherTransaction;
        this.fromOtherTransaction = 0;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (isAutoPollOn || isPassthroughModeOn) {
            return 27137;
        }
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT && (p = this.device_pingDevice()) != 0) {
            this.device_pingDevice();
        }
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT ? timeout < 0 || timeout > 12216 : timeout < 0 || timeout > 255) {
            return 27392;
        }
        if (type < 0 || type > 255) {
            return 27392;
        }
        if (amount > 9.99999999999E9 || amount < 0.0) {
            return 27392;
        }
        if (amtOther > 9.99999999999E9 || amtOther < 0.0) {
            return 27392;
        }
        this.cardSwipeErrorCode = 0;
        isCommandRunning = true;
        emvCancelTransaction = false;
        readyForCardSwipe = false;
        this.waitForNotification();
        this.activateTransaction = true;
        this.timeout = timeout;
        _isFastEMV = isFastEMV;
        if (tags == null) {
            tags = new byte[]{};
        } else if (tags.length > 2032) {
            return 27392;
        }
        UMLog.i("ctls_startTransaction", "fot: " + fot);
        if (fot == 1) {
            this.isDeviceTransaction = true;
            this.transactionInterface = this.isVP3310 ? (byte)6 : (byte)7;
            UMLog.i("ctls_startTransaction", "neo2Transaction 2: " + this.neo2Transaction);
        } else if (fot == 2) {
            this.isDeviceTransaction = false;
            this.neo2Transaction = false;
            this.transactionInterface = connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT ? (byte)4 : (byte)1;
        } else {
            this.isDeviceTransaction = false;
            this.neo2Transaction = false;
            this.transactionInterface = connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT ? (byte)1 : (byte)2;
        }
        Map<String, Map<String, byte[]>> TLVDict = Common.processTLV(tags);
        Map<String, byte[]> unencryptedTags = null;
        if (TLVDict != null) {
            unencryptedTags = TLVDict.get("tags");
        }
        byte[] baAmount = null;
        byte[] baOtherAmount = null;
        byte[] baTransactionType = null;
        int exponent = 2;
        if (unencryptedTags != null) {
            byte[] baExponent = null;
            baAmount = unencryptedTags.get("9F02");
            baOtherAmount = unencryptedTags.get("9F03");
            baTransactionType = unencryptedTags.get("9C");
            baExponent = unencryptedTags.get("5F36");
            if (baAmount != null && baAmount.length != 6) {
                baAmount = null;
            }
            if (baOtherAmount != null && baOtherAmount.length != 6) {
                baOtherAmount = null;
            }
            if (baTransactionType != null && baTransactionType.length != 1) {
                baTransactionType = null;
            }
            if (baExponent != null && baExponent.length == 1) {
                exponent = baExponent[0];
            }
        }
        int time = 10;
        if (baAmount == null) {
            baAmount = new byte[6];
            String strAmount = String.valueOf(amount);
            numbers = strAmount.split("\\.");
            long lAmount = Long.valueOf(numbers[0]);
            if (exponent > 0 && exponent < 12) {
                for (int i2 = 0; i2 < exponent - 1; ++i2) {
                    time *= 10;
                }
                lAmount *= (long)time;
            }
            stDecimal = "";
            if (exponent > 0 && exponent < 12) {
                for (i = 0; i < exponent; ++i) {
                    stDecimal = numbers[1] != null && i < numbers[1].length() ? stDecimal + numbers[1].substring(i, i + 1) : stDecimal + "0";
                }
                lAmount += Long.valueOf(stDecimal).longValue();
            }
            for (i = 5; i >= 0; --i) {
                temp = (int)(lAmount % 100L);
                baAmount[i] = bcd = (byte)(temp % 10 | temp / 10 << 4);
                lAmount /= 100L;
            }
            unencryptedTags.put("9F02", baAmount);
        }
        if (baTransactionType == null) {
            baTransactionType = new byte[]{(byte)type};
            unencryptedTags.put("9C", baTransactionType);
        }
        if (baOtherAmount == null) {
            baOtherAmount = new byte[6];
            String strOtherAmount = String.valueOf(amtOther);
            numbers = strOtherAmount.split("\\.");
            long lOtherAmount = Long.valueOf(numbers[0]);
            if (exponent > 0 && exponent < 12) {
                lOtherAmount *= (long)time;
            }
            stDecimal = "";
            if (exponent > 0 && exponent < 12) {
                for (i = 0; i < exponent; ++i) {
                    stDecimal = numbers[1] != null && i < numbers[1].length() ? stDecimal + numbers[1].substring(i, i + 1) : stDecimal + "0";
                }
                lOtherAmount += Long.valueOf(stDecimal).longValue();
            }
            for (i = 5; i >= 0; --i) {
                temp = (int)(lOtherAmount % 100L);
                baOtherAmount[i] = bcd = (byte)(temp % 10 | temp / 10 << 4);
                lOtherAmount /= 100L;
            }
            unencryptedTags.put("9F03", baOtherAmount);
        }
        if (this.neo2Transaction || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT) {
            byte[] dfef3c;
            byte[] dfef37 = unencryptedTags.get("DFEF37");
            if (dfef37 != null && dfef37.length == 1) {
                if ((dfef37[0] & 4) == 4 && ((dfef3c = unencryptedTags.get("DFEF3C")) == null || dfef3c.length == 0)) {
                    int theTO = timeout;
                    if (theTO > 99) {
                        theTO = 99;
                    }
                    byte bcd2 = (byte)(theTO % 10 | theTO / 10 << 4);
                    unencryptedTags.put("DFEF3C", new byte[]{1, 0, bcd2});
                }
            } else if (this.isDeviceTransaction) {
                if (this.isVP3310) {
                    unencryptedTags.put("DFEF37", new byte[]{6});
                } else {
                    unencryptedTags.put("DFEF37", new byte[]{7});
                }
                dfef3c = unencryptedTags.get("DFEF3C");
                if (dfef3c == null || dfef3c.length == 0) {
                    int theTO = timeout;
                    if (theTO > 99) {
                        theTO = 99;
                    }
                    byte bcd3 = (byte)(theTO % 10 | theTO / 10 << 4);
                    unencryptedTags.put("DFEF3C", new byte[]{1, 0, bcd3});
                }
            } else {
                unencryptedTags.put("DFEF37", new byte[]{this.transactionInterface});
            }
            byte[] _dfef37 = unencryptedTags.get("DFEF37");
            byte[] _dfef3c = unencryptedTags.get("DFEF3C");
            if ((_dfef37[0] & 1) != 1 && _dfef3c != null && _dfef3c.length > 0 && _dfef3c[0] == 1) {
                _dfef3c[0] = 0;
                unencryptedTags.put("DFEF3C", _dfef3c);
            }
        } else if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
            // empty if block
        }
        this.emvTags = new HashMap<String, String>();
        Common.convertMapByteToMapString(unencryptedTags, this.emvTags);
        new Thread(new Runnable(){

            @Override
            public void run() {
                IDT_Device.this.activateTransaction();
            }
        }).start();
        if (this.isAudioDeviceSelected()) {
            try {
                Thread.sleep(1500L);
            }
            catch (InterruptedException dfef37) {
                // empty catch block
            }
        }
        if ((ec = this.cardSwipeErrorCode) != 0) {
            readyForCardSwipe = true;
        }
        return ec;
    }

    @SuppressLint(value={"SimpleDateFormat"})
    public int ctls_activateTransaction(int timeout, byte[] tags) {
        int ec;
        byte[] dfef37;
        int p;
        this.fromOtherTransaction = 0;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (isAutoPollOn || isPassthroughModeOn) {
            return 27137;
        }
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT ? timeout < 0 || timeout > 12216 : timeout < 0 || timeout > 255) {
            return 27392;
        }
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT && (p = this.device_pingDevice()) != 0) {
            this.device_pingDevice();
        }
        this.cardSwipeErrorCode = 0;
        isCommandRunning = true;
        emvCancelTransaction = false;
        readyForCardSwipe = false;
        this.waitForNotification();
        this.activateTransaction = true;
        this.timeout = timeout;
        if (tags == null) {
            tags = new byte[]{};
        } else if (tags.length > 2032) {
            return 27392;
        }
        Map<String, Map<String, byte[]>> TLVDict = Common.processTLV(tags);
        Map<String, byte[]> unencryptedTags = null;
        if (TLVDict != null) {
            unencryptedTags = TLVDict.get("tags");
        }
        if ((dfef37 = (byte[])unencryptedTags.get("DFEF37")) != null && dfef37.length == 1) {
            unencryptedTags.remove("DFEF37");
        }
        unencryptedTags.put("DFEF37", new byte[]{2});
        this.emvTags = new HashMap<String, String>();
        Common.convertMapByteToMapString(unencryptedTags, this.emvTags);
        new Thread(new Runnable(){

            @Override
            public void run() {
                IDT_Device.this.activateTransaction();
            }
        }).start();
        if (this.isAudioDeviceSelected()) {
            try {
                Thread.sleep(1500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if ((ec = this.cardSwipeErrorCode) != 0) {
            readyForCardSwipe = true;
        }
        return ec;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"SimpleDateFormat"})
    public int msr_startMSRSwipe() {
        int check;
        TaskManager.TaskStartRet r;
        ResDataStruct respData;
        block29: {
            int p;
            if (!readyForNextCommand || !readyForCardSwipe) {
                return 29696;
            }
            if (!this.device_isConnected()) {
                return 1;
            }
            if (isAutoPollOn) {
                return 27137;
            }
            if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT && (p = this.device_pingDevice()) != 0) {
                this.device_pingDevice();
            }
            _isFastEMV = false;
            this.neo2Transaction = false;
            this.timeout = 30;
            this.transactionInterface = (byte)4;
            this.cardSwipeErrorCode = 0;
            isCommandRunning = true;
            readyForCardSwipe = false;
            this.isDeviceTransaction = false;
            emvCancelTransaction = false;
            this.waitForNotification();
            if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIMAG || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIMAG_PRO) {
                this.handler.post(this.runnableStartMSRSwipe);
                return 0;
            }
            if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
                int ec;
                SimpleDateFormat sdf = new SimpleDateFormat("yyMMdd", Locale.US);
                String d = sdf.format(Calendar.getInstance().getTime());
                SimpleDateFormat sdf2 = new SimpleDateFormat("HHmmss", Locale.US);
                String d2 = sdf2.format(Calendar.getInstance().getTime());
                this.activateTransaction = true;
                this.emvTags = new HashMap<String, String>();
                this.emvTags.put("9F02", "000000000100");
                if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT) {
                    this.emvTags.put("DFEF37", "01");
                } else {
                    this.emvTags.put("9A", d);
                    this.emvTags.put("9F21", d2);
                }
                this.emvTags.put("9C", "00");
                if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
                    // empty if block
                }
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        IDT_Device.this.activateTransaction();
                    }
                }).start();
                if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V) {
                    try {
                        Thread.sleep(1500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if ((ec = this.cardSwipeErrorCode) != 0) {
                    readyForCardSwipe = true;
                }
                return ec;
            }
            respData = new ResDataStruct();
            if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIJACK) {
                r = this.sendCommand_helper("00", 0, respData);
            } else if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_BTMAG) {
                r = this.sendCommand_helper("02531A01310378", 0, respData);
            } else {
                if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA) {
                    r = this.sendCommand_helper("7353011A0132", 0, respData);
                    if (r != TaskManager.TaskStartRet.SUCCESS) {
                        isCommandRunning = false;
                        readyForCardSwipe = true;
                        return this.returnResult(r);
                    }
                    if (respData.resData == null) {
                        isCommandRunning = false;
                        readyForCardSwipe = true;
                        return 59136;
                    }
                    if (respData.resData.length == 1 && respData.resData[0] == 0) {
                        isCommandRunning = false;
                        readyForCardSwipe = true;
                        return 3;
                    }
                    check = Common.Response.checkACK(respData.resData);
                    if (1 == check) {
                        r = this.sendCommand_helper("7346500130", 0, respData);
                        break block29;
                    } else {
                        if (0 == check) {
                            isCommandRunning = false;
                            readyForCardSwipe = true;
                            return Common.Response.ErrorCode(respData.resData);
                        }
                        isCommandRunning = false;
                        readyForCardSwipe = true;
                        return 9;
                    }
                }
                r = this.sendCommand_helper("73465130", 0, respData);
            }
        }
        if (r != TaskManager.TaskStartRet.SUCCESS) {
            isCommandRunning = false;
            readyForCardSwipe = true;
            return this.returnResult(r);
        }
        if (respData.resData == null) {
            isCommandRunning = false;
            readyForCardSwipe = true;
            return 59136;
        }
        if (respData.resData.length == 1 && respData.resData[0] == 0) {
            isCommandRunning = false;
            readyForCardSwipe = true;
            return 3;
        }
        check = connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIJACK || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_BTMAG ? Common.Response.checkUMACK(respData.resData) : Common.Response.checkACK(respData.resData);
        if (1 == check) {
            this.handler.post(this.runnableStartMSRSwipe);
            return 0;
        }
        if (0 == check) {
            isCommandRunning = false;
            readyForCardSwipe = true;
            return Common.Response.ErrorCode(respData.resData);
        }
        isCommandRunning = false;
        readyForCardSwipe = true;
        return 9;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"SimpleDateFormat"})
    public int msr_startMSRSwipe(int timeout) {
        int check;
        TaskManager.TaskStartRet r;
        ResDataStruct respData;
        block34: {
            block36: {
                block35: {
                    block33: {
                        int p;
                        if (!readyForNextCommand || !readyForCardSwipe) {
                            return 29696;
                        }
                        if (!this.device_isConnected()) {
                            return 1;
                        }
                        if (isAutoPollOn) {
                            return 27137;
                        }
                        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT && (p = this.device_pingDevice()) != 0) {
                            this.device_pingDevice();
                        }
                        _isFastEMV = false;
                        this.neo2Transaction = false;
                        this.transactionInterface = (byte)4;
                        this.timeout = timeout;
                        this.cardSwipeErrorCode = 0;
                        isCommandRunning = true;
                        readyForCardSwipe = false;
                        this.isDeviceTransaction = false;
                        this.waitForNotification();
                        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIMAG || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIMAG_PRO) {
                            this.handler.post(this.runnableStartMSRSwipe);
                            return 0;
                        }
                        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
                            int ec = 1;
                            if (!this.device_isConnected()) {
                                isCommandRunning = false;
                                readyForCardSwipe = true;
                                return ec;
                            }
                            SimpleDateFormat sdf = new SimpleDateFormat("yyMMdd", Locale.US);
                            String d = sdf.format(Calendar.getInstance().getTime());
                            SimpleDateFormat sdf2 = new SimpleDateFormat("HHmmss", Locale.US);
                            String d2 = sdf2.format(Calendar.getInstance().getTime());
                            this.activateTransaction = true;
                            this.emvTags = new HashMap<String, String>();
                            this.emvTags.put("5F2A", "0840");
                            this.emvTags.put("9F02", "000000000100");
                            this.emvTags.put("9F1A", "0840");
                            this.emvTags.put("9C", "00");
                            if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT) {
                                this.emvTags.put("DFEF37", "01");
                            } else {
                                this.emvTags.put("9A", d);
                                this.emvTags.put("9F21", d2);
                                if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
                                    // empty if block
                                }
                            }
                            new Thread(new Runnable(){

                                @Override
                                public void run() {
                                    IDT_Device.this.activateTransaction();
                                }
                            }).start();
                            if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V) {
                                try {
                                    Thread.sleep(1500L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }
                            if ((ec = this.cardSwipeErrorCode) != 0) {
                                readyForCardSwipe = true;
                            }
                            return ec;
                        }
                        respData = new ResDataStruct();
                        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIJACK) break block33;
                        r = this.sendCommand_helper("00", timeout, respData);
                        break block34;
                    }
                    if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_BTMAG) break block35;
                    r = this.sendCommand_helper("02531A01310378", timeout, respData);
                    break block34;
                }
                if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA) break block36;
                r = this.sendCommand_helper("7353011A0132", 0, respData);
                if (r != TaskManager.TaskStartRet.SUCCESS) {
                    isCommandRunning = false;
                    readyForCardSwipe = true;
                    return this.returnResult(r);
                }
                if (respData.resData == null) {
                    isCommandRunning = false;
                    readyForCardSwipe = true;
                    return 59136;
                }
                if (respData.resData.length == 1 && respData.resData[0] == 0) {
                    isCommandRunning = false;
                    readyForCardSwipe = true;
                    return 3;
                }
                check = Common.Response.checkACK(respData.resData);
                if (1 == check) {
                    int adjustedTimeout;
                    r = this.sendCommand_helper("7346500130", 0, respData);
                    if (timeout == 0) {
                        timeout = 5;
                        adjustedTimeout = timeout + timeout / 4;
                    } else if (timeout > 30) {
                        if (_isThales) {
                            if (timeout > 7200) {
                                timeout = 7200;
                            }
                            adjustedTimeout = timeout + 10;
                        } else {
                            timeout = 30;
                            adjustedTimeout = timeout + timeout / 4;
                        }
                    } else {
                        adjustedTimeout = timeout + timeout / 4;
                    }
                    _usb.setTimeoutOfSwipeCard(adjustedTimeout);
                    break block34;
                } else {
                    if (0 == check) {
                        isCommandRunning = false;
                        readyForCardSwipe = true;
                        return Common.Response.ErrorCode(respData.resData);
                    }
                    isCommandRunning = false;
                    readyForCardSwipe = true;
                    return 9;
                }
            }
            r = this.sendCommand_helper("73465130", 0, respData);
        }
        if (r != TaskManager.TaskStartRet.SUCCESS) {
            isCommandRunning = false;
            readyForCardSwipe = true;
            return this.returnResult(r);
        }
        if (respData.resData == null) {
            isCommandRunning = false;
            readyForCardSwipe = true;
            return 59136;
        }
        if (respData.resData.length == 1 && respData.resData[0] == 0) {
            isCommandRunning = false;
            readyForCardSwipe = true;
            return 3;
        }
        check = connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIJACK || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_BTMAG ? Common.Response.checkUMACK(respData.resData) : Common.Response.checkACK(respData.resData);
        if (1 == check) {
            this.handler.post(this.runnableStartMSRSwipe);
            return 0;
        }
        if (0 == check) {
            isCommandRunning = false;
            readyForCardSwipe = true;
            return Common.Response.ErrorCode(respData.resData);
        }
        isCommandRunning = false;
        readyForCardSwipe = true;
        return 9;
    }

    public int msr_startMSRSwipeWithDisplay(String line1, String line2, String line3) {
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (isAutoPollOn) {
            return 27137;
        }
        _isFastEMV = false;
        if (line1 == null) {
            line1 = "";
        }
        if (line2 == null) {
            line2 = "";
        }
        if (line3 == null) {
            line3 = "";
        }
        char ch = '\u001c';
        String str = line1 + ch + line2 + ch + line3 + ch;
        if (str.length() < 4) {
            return 27392;
        }
        if (line1.length() > 12) {
            return 27392;
        }
        if (line2.length() > 16) {
            return 27392;
        }
        if (line3.length() > 16) {
            return 27392;
        }
        ResDataStruct respData = new ResDataStruct();
        isCommandRunning = true;
        readyForCardSwipe = false;
        this.waitForNotification();
        TaskManager.TaskStartRet r = this.sendCommand_helper("7346E130" + Integer.toHexString(str.length()) + Common.asciiToHex(str), 0, respData);
        int ec = this.returnACK(r, respData);
        if (ec == 0) {
            this.handler.post(this.runnableStartMSRSwipe);
        } else {
            isCommandRunning = false;
            readyForCardSwipe = true;
        }
        return ec;
    }

    public int msr_setExpirationMask(boolean mask) {
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY) {
            return 20;
        }
        String val = mask ? "30" : "31";
        ResDataStruct respData = new ResDataStruct();
        isCommandRunning = true;
        this.waitForNotification();
        TaskManager.TaskStartRet r = this.sendCommand_helper("7353015001" + val, 0, respData);
        isCommandRunning = false;
        return this.returnACK(r, respData);
    }

    public int msr_getExpirationMask(ResDataStruct respData) {
        if (respData == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            respData.statusCode = 29696;
            return 29696;
        }
        if (!this.device_isConnected()) {
            respData.statusCode = 1;
            return 1;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY) {
            respData.statusCode = 20;
            return 20;
        }
        isCommandRunning = true;
        this.waitForNotification();
        TaskManager.TaskStartRet r = this.sendCommand_helper("73520150", 0, respData);
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        if (returnCode == 0) {
            respData.settingValue = respData.resData[4];
        }
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int msr_setClearPANID(byte value) {
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY) {
            return 20;
        }
        isCommandRunning = true;
        this.waitForNotification();
        ResDataStruct respData = new ResDataStruct();
        TaskManager.TaskStartRet r = this.sendCommand_helper("7353014901" + String.format(Locale.US, "%02X", value), 0, respData);
        isCommandRunning = false;
        return this.returnACK(r, respData);
    }

    public int msr_getSwipeForcedEncryptionOption(ResDataStruct respData) {
        if (respData == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            respData.statusCode = 29696;
            return 29696;
        }
        if (!this.device_isConnected()) {
            respData.statusCode = 1;
            return 1;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY) {
            respData.statusCode = 20;
            return 20;
        }
        isCommandRunning = true;
        this.waitForNotification();
        TaskManager.TaskStartRet r = this.sendCommand_helper("73520184", 0, respData);
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        if (returnCode == 0) {
            respData.encryptionOption = respData.resData[4];
        }
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int msr_setSwipeForcedEncryptionOption(boolean track1, boolean track2, boolean track3, boolean track3card0) {
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY) {
            return 20;
        }
        isCommandRunning = true;
        this.waitForNotification();
        ResDataStruct respData = new ResDataStruct();
        byte val = 0;
        val = (byte)(val + (byte)(track1 ? 1 : 0));
        val = (byte)(val + (byte)(track2 ? 2 : 0));
        val = (byte)(val + (byte)(track3 ? 4 : 0));
        val = (byte)(val + (byte)(track3card0 ? 8 : 0));
        TaskManager.TaskStartRet r = this.sendCommand_helper("7353018401" + String.format(Locale.US, "%02X", val), 0, respData);
        isCommandRunning = false;
        return this.returnACK(r, respData);
    }

    public int msr_getSwipeMaskOption(ResDataStruct respData) {
        if (respData == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            respData.statusCode = 29696;
            return 29696;
        }
        if (!this.device_isConnected()) {
            respData.statusCode = 1;
            return 1;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY) {
            respData.statusCode = 20;
            return 20;
        }
        isCommandRunning = true;
        this.waitForNotification();
        TaskManager.TaskStartRet r = this.sendCommand_helper("73520186", 0, respData);
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        if (returnCode == 0) {
            respData.settingValue = respData.resData[4];
        }
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int msr_setSwipeMaskOption(boolean track1, boolean track2, boolean track3) {
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY) {
            return 20;
        }
        isCommandRunning = true;
        this.waitForNotification();
        ResDataStruct respData = new ResDataStruct();
        byte val = 0;
        val = (byte)(val + (byte)(track1 ? 1 : 0));
        val = (byte)(val + (byte)(track2 ? 2 : 0));
        val = (byte)(val + (byte)(track3 ? 4 : 0));
        TaskManager.TaskStartRet r = this.sendCommand_helper("7353018601" + String.format(Locale.US, "%02X", val), 0, respData);
        isCommandRunning = false;
        return this.returnACK(r, respData);
    }

    public int msr_getClearPANID(ResDataStruct respData) {
        if (respData == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            respData.statusCode = 29696;
            return 29696;
        }
        if (!this.device_isConnected()) {
            respData.statusCode = 1;
            return 1;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY) {
            respData.statusCode = 20;
            return 20;
        }
        isCommandRunning = true;
        this.waitForNotification();
        TaskManager.TaskStartRet r = this.sendCommand_helper("73520149", 0, respData);
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        if (returnCode == 0) {
            respData.settingValue = respData.resData[4];
        }
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int msr_getSetting(byte setting, ResDataStruct respData) {
        if (respData == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            respData.statusCode = 29696;
            return 29696;
        }
        if (!this.device_isConnected()) {
            respData.statusCode = 1;
            return 1;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY) {
            respData.statusCode = 20;
            return 20;
        }
        isCommandRunning = true;
        this.waitForNotification();
        TaskManager.TaskStartRet r = this.sendCommand_helper("735201" + String.format(Locale.US, "%02X", setting), 0, respData);
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        if (returnCode == 0) {
            respData.settingValue = respData.resData[4];
        }
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int msr_setSetting(byte setting, byte val) {
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY) {
            return 20;
        }
        isCommandRunning = true;
        this.waitForNotification();
        ResDataStruct respData = new ResDataStruct();
        TaskManager.TaskStartRet r = this.sendCommand_helper("735301" + String.format(Locale.US, "%02X", setting) + "01" + String.format(Locale.US, "%02X", val), 0, respData);
        isCommandRunning = false;
        return this.returnACK(r, respData);
    }

    public int msr_setSetting(byte setting, byte[] val) {
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY) {
            return 20;
        }
        if (val == null || val.length == 0) {
            return 27392;
        }
        isCommandRunning = true;
        this.waitForNotification();
        ResDataStruct respData = new ResDataStruct();
        TaskManager.TaskStartRet r = this.sendCommand_helper("735301" + String.format(Locale.US, "%02X", setting) + String.format(Locale.US, "%02X", val.length + 1) + String.format(Locale.US, "%02X", val.length) + Common.getHexStringFromBytes(val), 0, respData);
        isCommandRunning = false;
        return this.returnACK(r, respData);
    }

    public int msr_setSwipeEncryption(byte encryption) {
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_USB) {
            return 20;
        }
        isCommandRunning = true;
        this.waitForNotification();
        ResDataStruct respData = new ResDataStruct();
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_USB) {
            byte val = (byte)(48 + encryption);
            r = this.sendCommand_helper("7353014C01" + String.format(Locale.US, "%02X", val), 0, respData);
        } else {
            r = this.sendCommand_helper("7853010301" + String.format(Locale.US, "%02X", encryption), 0, respData);
        }
        isCommandRunning = false;
        return this.returnACK(r, respData);
    }

    public int msr_getSwipeEncryption(ResDataStruct respData) {
        if (respData == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            respData.statusCode = 29696;
            return 29696;
        }
        if (!this.device_isConnected()) {
            respData.statusCode = 1;
            return 1;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY) {
            respData.statusCode = 20;
            return 20;
        }
        isCommandRunning = true;
        this.waitForNotification();
        TaskManager.TaskStartRet r = this.sendCommand_helper("7352014C", 0, respData);
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        if (returnCode == 0) {
            respData.settingValue = respData.resData[4];
        }
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int msr_enableBufferMode(boolean isBufferMode, boolean withNotification) {
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA) {
            return 20;
        }
        isCommandRunning = true;
        this.waitForNotification();
        ResDataStruct respData = new ResDataStruct();
        if (isBufferMode) {
            r = withNotification ? this.sendCommand_helper("7353011A0133", 0, respData) : this.sendCommand_helper("7353011A0132", 0, respData);
        } else {
            isCommandRunning = false;
            return 27136;
        }
        isCommandRunning = false;
        return this.returnACK(r, respData);
    }

    public int msr_disable() {
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA) {
            return 20;
        }
        isCommandRunning = true;
        this.waitForNotification();
        ResDataStruct respData = new ResDataStruct();
        TaskManager.TaskStartRet r = this.sendCommand_helper("7353011A0130", 0, respData);
        isCommandRunning = false;
        return this.returnACK(r, respData);
    }

    public int msr_setWhiteList(byte[] val) {
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA) {
            return 20;
        }
        if (val == null || val.length > 2032) {
            return 27392;
        }
        isCommandRunning = true;
        this.waitForNotification();
        ResDataStruct respData = new ResDataStruct();
        int valLen = val.length;
        String.format(Locale.US, "%02X", (byte)(valLen & 0xFF));
        String.format(Locale.US, "%02X", (byte)(valLen >> 8));
        TaskManager.TaskStartRet r = this.sendCommand_helper("78464D03" + String.format(Locale.US, "%02X", (byte)(valLen & 0xFF)) + String.format(Locale.US, "%02X", (byte)(valLen >> 8)) + Common.getHexStringFromBytes(val) + "0000", 0, respData);
        isCommandRunning = false;
        return this.returnACK(r, respData);
    }

    public int msr_RetrieveWhiteList(ResDataStruct respData) {
        if (respData == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            respData.statusCode = 29696;
            return 29696;
        }
        if (!this.device_isConnected()) {
            respData.statusCode = 1;
            return 1;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY) {
            respData.statusCode = 20;
            return 20;
        }
        isCommandRunning = true;
        this.waitForNotification();
        TaskManager.TaskStartRet r = this.sendCommand_helper("78464D01", 0, respData);
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int msr_getFunctionStatus(ResDataStruct respData) {
        if (respData == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            respData.statusCode = 29696;
            return 29696;
        }
        if (!this.device_isConnected()) {
            respData.statusCode = 1;
            return 1;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA) {
            respData.statusCode = 20;
            return 20;
        }
        isCommandRunning = true;
        this.waitForNotification();
        TaskManager.TaskStartRet r = this.sendCommand_helper("7352011A", 0, respData);
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        if (returnCode == 0) {
            respData.functionStatus = respData.resData[4];
        }
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int msr_flushTrackData() {
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        int cmd = 0;
        int rt = 9;
        isCommandRunning = true;
        this.waitForNotification();
        ResDataStruct respData = new ResDataStruct();
        int loopNum = 0;
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)23, (byte)2, new byte[0])), 0, respData);
            ++loopNum;
            if (r != TaskManager.TaskStartRet.SUCCESS) continue;
            if (respData.resData == null) {
                isCommandRunning = false;
                respData.statusCode = 21;
                return 21;
            }
            if (respData.resData.length == 1 && respData.resData[0] == 0) {
                isCommandRunning = false;
                respData.statusCode = 3;
                return 3;
            }
            rt = 9;
            int len = respData.resData.length;
            if (len <= 11) continue;
            rt = respData.resData[11];
            cmd = respData.resData[10];
            if (cmd == -18 && rt == -16) break;
            if (rt == 0) continue;
            rt = 9;
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != 23));
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    private int activateTransaction() {
        int ec = 1;
        if (!this.device_isConnected()) {
            isCommandRunning = false;
            return ec;
        }
        _ignorePing = true;
        ec = this.msr_transaction();
        UMLog.i("activateTransaction", "ec = " + ec);
        this.activateTransaction = false;
        if (WorldPay.inTransaction) {
            if (ec != 0) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                UMLog.i("activateTransaction", "WorldPay.hasVAS = " + WorldPay.hasVAS);
                if (!WorldPay.hasVAS) {
                    this.cardSwipeErrorCode = ec;
                    this.handler.post(this.runnableSwipeError);
                }
            }
        } else if (ec == 61024) {
            this.cardSwipeErrorCode = ec;
            this.handler.post(this.runnableSwipeError);
        }
        return 0;
    }

    private int pollOnDemand() {
        TaskManager.TaskStartRet r;
        if (!this.device_isConnected()) {
            return 1;
        }
        ResDataStruct respData = new ResDataStruct();
        byte cmd = 0;
        int rt = 9;
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V) {
            this.waitForVivo();
        }
        int loopNum = 0;
        do {
            if (cancelTransaction) {
                return 0;
            }
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)1, (byte)1, new byte[]{1})), 0, respData);
            ++loopNum;
            if (r != TaskManager.TaskStartRet.SUCCESS) continue;
            if (respData.resData == null) {
                return 21;
            }
            if (respData.resData.length == 1 && respData.resData[0] == 0) {
                return 3;
            }
            rt = 9;
            int len = respData.resData.length;
            if (len <= 11) continue;
            rt = respData.resData[11];
            cmd = respData.resData[10];
            if (cmd == -18 && rt == -16) break;
            if (rt == 0) continue;
            rt = 9;
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != true));
        return this.returnACK(r, respData);
    }

    private int burstModeOff() {
        TaskManager.TaskStartRet r;
        if (!this.device_isConnected()) {
            return 1;
        }
        ResDataStruct respData = new ResDataStruct();
        byte[] data = new byte[]{-1, -9, 1, 0};
        int cmd = 0;
        int rt = 9;
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V) {
            this.waitForVivo();
        }
        int loopNum = 0;
        do {
            if (cancelTransaction) {
                return 0;
            }
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)4, (byte)0, data)), 0, respData);
            if (r != TaskManager.TaskStartRet.SUCCESS) continue;
            if (respData.resData == null) {
                return 21;
            }
            if (respData.resData.length == 1 && respData.resData[0] == 0) {
                return 3;
            }
            rt = 9;
            int len = respData.resData.length;
            if (len <= 11) continue;
            rt = respData.resData[11];
            cmd = respData.resData[10];
            if (cmd == -18 && rt == -16) break;
            if (rt == 0) continue;
            rt = 9;
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != 4));
        return this.returnACK(r, respData);
    }

    private void msr_skipBadSwipe(ResDataStruct resData, long endTime) {
        int len;
        String CDCVM = "5669564F74656368320002A000003413";
        String POWEROFF = "5669564F746563683200EEF00002";
        String UIMessage = "450055";
        String MediaEvent = "0750DFEF360403";
        String LCDMessage = "5669564F7465636832006101";
        byte[] temp = new byte[16];
        byte[] tempPw = new byte[18];
        byte[] tempMsg = new byte[9];
        String strTemp = "";
        UMLog.i("**msr_skipBadSwipe Data 1** ", resData.resData != null ? Common.base16Encode(resData.resData) : "null");
        if (resData.resData != null && resData.resData.length > 0) {
            int i;
            for (i = resData.resData.length - 1; i >= 0 && resData.resData[i] == 0; --i) {
            }
            if (i < resData.resData.length - 1) {
                len = i + 1;
                byte[] tmp = new byte[len];
                System.arraycopy(resData.resData, 0, tmp, 0, len);
                resData.resData = new byte[len];
                System.arraycopy(tmp, 0, resData.resData, 0, len);
            }
        }
        UMLog.i("**msr_skipBadSwipe Data 2** ", resData.resData != null ? Common.base16Encode(resData.resData) : "null");
        if (resData.resData != null && resData.resData.length > 15) {
            System.arraycopy(resData.resData, 0, temp, 0, 16);
            strTemp = Common.base16Encode(temp);
            if (strTemp.startsWith(MediaEvent)) {
                if ((resData.resData[7] & 0x10) != 0) {
                    this.m_recListener.ctlsEvent((byte)4, (byte)1, (byte)0);
                } else if ((resData.resData[7] & 8) != 0) {
                    this.m_recListener.ctlsEvent((byte)4, (byte)2, (byte)0);
                }
                int len2 = resData.resData.length - 12;
                byte[] tmp = new byte[len2];
                System.arraycopy(resData.resData, 12, tmp, 0, len2);
                resData.resData = new byte[len2];
                System.arraycopy(tmp, 0, resData.resData, 0, len2);
                if (len2 > 15) {
                    System.arraycopy(resData.resData, 0, temp, 0, 16);
                    strTemp = Common.base16Encode(temp);
                } else if (len2 > 8) {
                    System.arraycopy(resData.resData, 0, tempMsg, 0, 9);
                    strTemp = Common.base16Encode(tempMsg);
                } else {
                    strTemp = "";
                }
            }
        } else if (resData.resData != null && resData.resData.length > 8) {
            System.arraycopy(resData.resData, 0, tempMsg, 0, 9);
            strTemp = Common.base16Encode(tempMsg);
        } else {
            strTemp = "";
        }
        while (resData.resData == null || resData.resData != null && resData.resData.length == 1 && resData.resData[0] == 0 || resData.resData != null && resData.resData.length > 3 && resData.resData[0] == 2 && resData.resData[1] == 1 && resData.resData[2] == 107 && resData.resData[3] == 76 || resData.resData != null && resData.resData.length > 15 && strTemp.equals(CDCVM) || resData.resData != null && resData.resData.length > 15 && strTemp.startsWith(LCDMessage) || resData.resData != null && resData.resData.length > 17 && strTemp.startsWith(POWEROFF) || resData.resData != null && resData.resData.length > 8 && strTemp.startsWith(UIMessage) || resData.resData != null && resData.resData.length > 11 && strTemp.startsWith(MediaEvent)) {
            long startTime;
            if (resData.resData != null && resData.resData.length > 19 && resData.resData[0] == 2 && resData.resData[1] == 1 && resData.resData[2] == 107 && resData.resData[3] == 76) {
                byte[] tmp = new byte[resData.resData.length - 4];
                System.arraycopy(resData.resData, 4, tmp, 0, tmp.length);
                resData.resData = new byte[tmp.length];
                System.arraycopy(tmp, 0, resData.resData, 0, tmp.length);
                continue;
            }
            if (resData.resData != null && resData.resData.length > 17 && strTemp.startsWith(POWEROFF)) {
                this.cardSwipeErrorCode = 61168;
                this.handler.post(this.runnableSwipeError);
                return;
            }
            if (resData.resData != null && resData.resData.length > 15 && strTemp.equals(CDCVM)) {
                this.cardSwipeErrorCode = 61088;
                this.handler.post(this.runnableSwipeError);
            } else if (resData.resData != null && resData.resData.length > 8 && (strTemp.startsWith(UIMessage) || strTemp.startsWith(MediaEvent))) {
                boolean isMediaEvent = false;
                if (strTemp.startsWith(MediaEvent)) {
                    isMediaEvent = true;
                }
                len = 0;
                if (isMediaEvent) {
                    if ((resData.resData[7] & 0x10) != 0) {
                        this.m_recListener.ctlsEvent((byte)4, (byte)1, (byte)0);
                    } else if ((resData.resData[7] & 8) != 0) {
                        this.m_recListener.ctlsEvent((byte)4, (byte)2, (byte)0);
                    }
                    len = 12;
                } else {
                    this.m_recListener.ctlsEvent(resData.resData[5], resData.resData[3], resData.resData[6]);
                    len = resData.resData[4] + 7;
                }
                if (resData.resData.length > len) {
                    byte[] newData = new byte[resData.resData.length - len];
                    System.arraycopy(resData.resData, len, newData, 0, newData.length);
                    boolean allzero = true;
                    for (int x = 0; x < newData.length; ++x) {
                        if (newData[x] == 0) continue;
                        allzero = false;
                        break;
                    }
                    if (!allzero) {
                        resData.resData = newData;
                        if (resData.resData != null && resData.resData.length > 17) {
                            System.arraycopy(resData.resData, 0, tempPw, 0, 18);
                            strTemp = Common.base16Encode(tempPw);
                            continue;
                        }
                        if (resData.resData != null && resData.resData.length > 15) {
                            System.arraycopy(resData.resData, 0, temp, 0, 16);
                            strTemp = Common.base16Encode(temp);
                            continue;
                        }
                        if (resData.resData != null && resData.resData.length > 8) {
                            System.arraycopy(resData.resData, 0, tempMsg, 0, 9);
                            strTemp = Common.base16Encode(tempMsg);
                            continue;
                        }
                        strTemp = "";
                        continue;
                    }
                }
            }
            if (this.isAudioDeviceSelected()) {
                if (audioUnplugged) {
                    audioUnplugged = false;
                    return;
                }
                this.sendCommand_helper(null, 1, resData);
            } else if (this.isBluetoothDeviceSelected()) {
                startTime = System.currentTimeMillis();
                isTransactionRead = true;
                this._bt.readMessage(1, startTime, resData);
                isTransactionRead = false;
                if (cancelTransaction) {
                    return;
                }
            } else if (this.isBluetoothLEDeviceSelected()) {
                startTime = System.currentTimeMillis();
                isTransactionRead = true;
                _btle.readMessage(1, startTime, resData, true);
                isTransactionRead = false;
                UMLog.i("**msr_skipBadSwipe**", Common.base16Encode(resData.resData));
                if (cancelTransaction) {
                    return;
                }
            } else if (this.isRS232DeviceSelected()) {
                startTime = System.currentTimeMillis();
                isTransactionRead = true;
                this._com.readMessage(1, startTime, resData, true);
                isTransactionRead = false;
                if (cancelTransaction) {
                    return;
                }
            } else {
                startTime = System.currentTimeMillis();
                isTransactionRead = true;
                _usb.readMessage(1, startTime, resData, true);
                isTransactionRead = false;
                if (cancelTransaction) {
                    return;
                }
            }
            if (System.currentTimeMillis() > endTime) {
                return;
            }
            if (resData.resData != null && resData.resData.length > 17) {
                System.arraycopy(resData.resData, 0, tempPw, 0, 18);
                strTemp = Common.base16Encode(tempPw);
                continue;
            }
            if (resData.resData != null && resData.resData.length > 15) {
                System.arraycopy(resData.resData, 0, temp, 0, 16);
                strTemp = Common.base16Encode(temp);
                continue;
            }
            if (resData.resData != null && resData.resData.length > 8) {
                System.arraycopy(resData.resData, 0, tempMsg, 0, 9);
                strTemp = Common.base16Encode(tempMsg);
                continue;
            }
            strTemp = "";
        }
    }

    private int msr_transaction() {
        byte attribute;
        TaskManager.TaskStartRet r;
        long endTime;
        cancelTransaction = false;
        if (!this.device_isConnected()) {
            return 1;
        }
        ResDataStruct respData = new ResDataStruct();
        infiniteTimeout = false;
        if (this.timeout == 0 && (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB)) {
            infiniteTimeout = true;
        }
        byte[] data = Common.encodeTags(this.emvTags, this.timeout);
        int cmd = 0;
        int rt = 9;
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V) {
            this.waitForVivo();
        }
        this.activateTransaction = true;
        if (cancelTransaction) {
            TaskManager.TaskStartRet taskStartRet = TaskManager.TaskStartRet.SUCCESS;
        }
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800) {
            byte[] newData = new byte[data.length + 5];
            newData[0] = (byte)(this.timeout >> 8);
            newData[1] = (byte)(this.timeout & 0xFF);
            newData[2] = this.transactionInterface;
            newData[3] = 0;
            newData[4] = 0;
            newData[5] = 0;
            System.arraycopy(data, 1, newData, 6, data.length - 1);
            endTime = System.currentTimeMillis() + (long)((this.timeout + 2) * 1000);
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)2, (byte)5, newData)), this.timeout, respData);
            if (respData.resData != null && respData.resData.length > 11) {
                byte status = respData.resData[11];
                byte by = attribute = respData.resData.length > 14 ? respData.resData[14] : (byte)0;
                if ((attribute & 0x19) == 0 && (status == 0 || status == 48 || status == 89)) {
                    IDTEMVData emvData = new IDTEMVData();
                    if (status == 0) {
                        emvData.result = 2;
                        respData.resData[11] = 0;
                    } else if (status == 48) {
                        emvData.result = 4;
                        respData.resData[11] = 99;
                    } else {
                        IDT_Device.emv_setAutoAuthenticateTransaction(false);
                        emvData.result = 16;
                        respData.resData[11] = 0;
                    }
                    if (respData.resData.length > 18) {
                        int len = (respData.resData[13] & 0xFF) + (respData.resData[12] & 0xFF) * 256 - 1;
                        byte[] tlvData = new byte[len];
                        System.arraycopy(respData.resData, 15, tlvData, 0, tlvData.length);
                        emvData.cardType = attribute & 1;
                        emvData.encryptionMode = attribute >> 1 & 1;
                        Map<String, Map<String, byte[]>> tlvDict = Common.processTLV(tlvData);
                        if (tlvDict != null) {
                            emvData.unencryptedTags = tlvDict.get("tags");
                            emvData.encryptedTags = tlvDict.get("encrypted");
                            emvData.maskedTags = tlvDict.get("masked");
                        }
                        this.cardData = new IDTMSRData();
                        this.cardData.result = emvData.result;
                    }
                    UMLog.i("**msr_transaction**", "isCommandRunning = false 1");
                    isCommandRunning = false;
                    this.activateTransaction = false;
                    readyForCardSwipe = true;
                    UMLog.i("**msr_transaction**", "emvTransactionData() 1");
                    this.m_recListener.emvTransactionData(this.checkBypassCompletion(emvData));
                    return this.returnACK(r, respData);
                }
                if (respData.resData[11] == 35) {
                    endTime = System.currentTimeMillis() + (long)((this.timeout + 2) * 1000);
                    ResDataStruct resData = new ResDataStruct();
                    this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)3, (byte)3, new byte[]{0})), this.timeout, resData);
                }
            }
        } else {
            endTime = System.currentTimeMillis() + (long)(this.timeout * 1000) + 100L;
            if (this.neo2Transaction || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB) {
                isTransactionRead = true;
            }
            int loopNum = 0;
            do {
                r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)2, (byte)64, data)), this.timeout, respData);
                ++loopNum;
                if (r == TaskManager.TaskStartRet.SUCCESS) {
                    if (respData.resData == null || respData.resData.length == 1 && respData.resData[0] == 0) break;
                    rt = 9;
                    int len = respData.resData.length;
                    if (len > 11) {
                        rt = respData.resData[11];
                        cmd = respData.resData[10];
                        if (cmd == -18 && rt == -16) break;
                    }
                }
                if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ && r == TaskManager.TaskStartRet.TRANS_FAIL) {
                    r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)2, (byte)64, data)), this.timeout, respData);
                    ++loopNum;
                    if (r == TaskManager.TaskStartRet.SUCCESS) {
                        if (respData.resData == null || respData.resData.length == 1 && respData.resData[0] == 0) break;
                        rt = 9;
                        int len = respData.resData.length;
                        if (len > 11) {
                            rt = respData.resData[11];
                            cmd = respData.resData[10];
                            if (cmd == -18 && rt == -16) break;
                        }
                    }
                }
                if (loopNum >= 1 || (rt == 0 || rt == 99 || rt == 35 || rt == 8 || rt == 87) && cmd == 2) continue;
                try {
                    Thread.sleep(450L);
                }
                catch (InterruptedException len) {
                    // empty catch block
                }
            } while (loopNum < 1 && (rt != 0 && rt != 99 && rt != 35 && rt != 8 && rt != 87 || cmd != 2));
            if (this.neo2Transaction || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB) {
                if (!isTransactionRead) {
                    r = TaskManager.TaskStartRet.SUCCESS;
                    cancelTransaction = false;
                    infiniteTimeout = false;
                    UMLog.i("**msr_transaction**", "!isTransactionRead");
                    return 0;
                }
                isTransactionRead = false;
            }
        }
        if ((this.neo2Transaction || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB) && respData != null && respData.resData != null && respData.resData.length > 11 && respData.resData[10] == 2 && respData.resData[11] == 99) {
            long startTime;
            if (this.isBluetoothLEDeviceSelected()) {
                startTime = System.currentTimeMillis();
                emvCancelTransaction = false;
                isTransactionRead = true;
                do {
                    _btle.emv_readMessage(infiniteTimeout ? 0 : this.timeout + 5, startTime, respData, !this.isDeviceTransaction);
                    if (respData.resData[0] != 69 || respData.resData[1] != 0 || respData.resData[2] != 85) continue;
                    this.m_recListener.ctlsEvent(respData.resData[5], respData.resData[3], respData.resData[6]);
                } while (respData.resData[0] == 69 && respData.resData[1] == 0 && respData.resData[2] == 85);
                if (respData.resData != null && respData.resData.length > 11 && Common.base16Encode(respData.resData).toUpperCase().contains("5669564F74656368320002630000")) {
                    _btle.emv_readMessage(infiniteTimeout ? 0 : this.timeout + 5, startTime, respData, !this.isDeviceTransaction);
                }
                isTransactionRead = false;
                UMLog.i("**msr_transaction**", "respData: " + Common.base16Encode(respData.resData));
            } else {
                startTime = System.currentTimeMillis();
                emvCancelTransaction = false;
                isTransactionRead = true;
                do {
                    _usb.readMessage(infiniteTimeout ? 0 : this.timeout + 5, startTime, respData, !this.isDeviceTransaction);
                    if (respData.resData[0] != 69 || respData.resData[1] != 0 || respData.resData[2] != 85) continue;
                    this.m_recListener.ctlsEvent(respData.resData[5], respData.resData[3], respData.resData[6]);
                } while (respData.resData[0] == 69 && respData.resData[1] == 0 && respData.resData[2] == 85);
                isTransactionRead = false;
                UMLog.i("**msr_transaction**", "respData: " + Common.base16Encode(respData.resData));
            }
            boolean isMSR = true;
            if (respData.resData.length > 14) {
                if ((respData.resData[14] & 8) == 8) {
                    boolean isFallbackToMSR;
                    String tmp = Common.base16Encode(respData.resData).toUpperCase(Locale.US);
                    boolean bl = isFallbackToMSR = tmp.contains("9F390180");
                    isMSR = !isFallbackToMSR;
                } else {
                    isMSR = (respData.resData[14] & 0x19) != 0 && respData.resData[10] != 97;
                }
            }
            UMLog.i("**msr_transaction**", "isMSR: " + isMSR);
            if (!isMSR) {
                if (respData.resData[10] == 2 && respData.resData[11] == 8) {
                    readyForNextCommand = true;
                    readyForCardSwipe = true;
                    infiniteTimeout = false;
                    return 3;
                }
                if (respData.resData[10] == 97) {
                    readyForNextCommand = true;
                    readyForCardSwipe = true;
                    this.emv_secondResponse(this.timeout + 2, 1, respData);
                    infiniteTimeout = false;
                    return 0;
                }
                this.emv_secondResponse(this.timeout + 2, 4, respData);
                readyForCardSwipe = true;
                infiniteTimeout = false;
                return 0;
            }
        }
        if (r == TaskManager.TaskStartRet.SUCCESS && !cancelTransaction) {
            this.msr_skipBadSwipe(respData, endTime);
        }
        if (cancelTransaction) {
            r = TaskManager.TaskStartRet.SUCCESS;
            cancelTransaction = false;
            infiniteTimeout = false;
            return 0;
        }
        if (r == TaskManager.TaskStartRet.SUCCESS) {
            if (respData.resData == null) {
                if (cancelTransaction) {
                    r = TaskManager.TaskStartRet.SUCCESS;
                } else {
                    UMLog.i("**msr_transaction**", "isCommandRunning = false 2");
                    isCommandRunning = false;
                    infiniteTimeout = false;
                    return 21;
                }
            }
            if (respData.resData.length == 1 && respData.resData[0] == 0) {
                if (cancelTransaction) {
                    r = TaskManager.TaskStartRet.SUCCESS;
                } else {
                    if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
                        this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)5, (byte)1, new byte[0])), 5, respData);
                    }
                    this.activateTransaction = false;
                    this.handler.post(this.runnableSwipeTimeOut);
                    UMLog.i("**msr_transaction**", "isCommandRunning = false 3");
                    isCommandRunning = false;
                    infiniteTimeout = false;
                    return 3;
                }
            }
            if ((connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III && !_isSRED || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI) && isBurstModeOn && isAutoPollOn) {
                if (respData.resData.length > 0) {
                    this.cardData = new IDTMSRData();
                    this.activateTransaction = false;
                    if (Common.processCTLSData(respData.resData, this.cardData)) {
                        this.cardData.result = 0;
                        this.handler.post(this.runnableStartMSRSwipe_3in1);
                        UMLog.i("**msr_transaction**", "isCommandRunning = false 4");
                        isCommandRunning = false;
                        infiniteTimeout = false;
                        return 0;
                    }
                    if (this.cardData.cardData.length > 11 && this.cardData.cardData[11] == 8) {
                        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
                            this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)5, (byte)1, new byte[0])), 0, respData);
                        }
                        this.activateTransaction = false;
                        this.handler.post(this.runnableSwipeTimeOut);
                        UMLog.i("**msr_transaction**", "isCommandRunning = false 5");
                        isCommandRunning = false;
                        infiniteTimeout = false;
                        return 3;
                    }
                }
            } else {
                if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER && respData.resData.length > 18 && (respData.resData[14] & 0x19) == 1 && (respData.resData[11] == 0 || respData.resData[11] == 35)) {
                    IDTEMVData emvData = new IDTEMVData();
                    int len = (respData.resData[13] & 0xFF) + (respData.resData[12] & 0xFF) * 256 - 1;
                    if (len == 6 && respData.resData[15] == -33 && respData.resData[16] == -18 && respData.resData[17] == 37 && respData.resData[20] == 8) {
                        emvData.result = 8;
                    } else {
                        attribute = respData.resData[14];
                        byte[] tlvData = new byte[len];
                        System.arraycopy(respData.resData, 15, tlvData, 0, tlvData.length);
                        emvData.result = 9;
                        emvData.cardType = attribute & 1;
                        emvData.encryptionMode = attribute >> 1 & 1;
                        Map<String, Map<String, byte[]>> tlvDict = Common.processTLV(tlvData);
                        if (tlvDict != null) {
                            emvData.unencryptedTags = tlvDict.get("tags");
                            emvData.encryptedTags = tlvDict.get("encrypted");
                            emvData.maskedTags = tlvDict.get("masked");
                        }
                        this.cardData = new IDTMSRData();
                        Common.parseCardData3in1(respData.resData, this.cardData);
                        emvData.msr_cardData = this.cardData;
                    }
                    UMLog.i("**msr_transaction**", "isCommandRunning = false 6");
                    isCommandRunning = false;
                    UMLog.i("**msr_transaction**", "emvTransactionData() 2");
                    this.m_recListener.emvTransactionData(emvData);
                    this.activateTransaction = false;
                    readyForNextCommand = true;
                    readyForCardSwipe = true;
                    infiniteTimeout = false;
                    return rt;
                }
                rt = 9;
                int len = respData.resData.length;
                if (len > 11) {
                    int dataLen2;
                    rt = respData.resData[11];
                    cmd = respData.resData[10];
                    if ((rt == 0 || rt == 35 || rt == 10 || rt == 87) && cmd == 2) {
                        this.cardData = new IDTMSRData();
                        this.activateTransaction = false;
                        int n = dataLen2 = len > 13 ? (respData.resData[12] & 0xFF) << 8 | respData.resData[13] & 0xFF : 0;
                        if (dataLen2 + 16 <= respData.resData.length) {
                            if (_isTTK) {
                                this.cardData.result = 17;
                            }
                            byte[] newData = new byte[dataLen2 + 16];
                            System.arraycopy(respData.resData, 0, newData, 0, newData.length);
                            respData.resData = newData;
                            Common.parseCardData3in1(respData.resData, this.cardData);
                            if (rt == 10) {
                                String temp = Common.base16Encode(respData.resData).toUpperCase(Locale.US);
                                if (temp.contains("9F0607A0000001523010") && temp.contains("9F710200A7")) {
                                    rt = 131;
                                }
                            } else {
                                rt = 0;
                            }
                        } else {
                            rt = 33536;
                        }
                        this.cardData.result = rt;
                        if (this.cardData.iccPresent && this.isDeviceTransaction && _isFastEMV) {
                            UMLog.i("**msr_transaction**", "isCommandRunning = false 7");
                            isCommandRunning = false;
                            readyForCardSwipe = true;
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException newData) {
                                // empty catch block
                            }
                            IDT_Device.emv_setAutoAuthenticateTransaction(true);
                            IDT_Device.emv_setAutoCompleteTransaction(true);
                            infiniteTimeout = false;
                            return this.emv_startTransaction(emv_amount, emv_amtOther, emv_type, emv_timeout, emv_tags, false, true);
                        }
                        this.handler.post(this.runnableStartMSRSwipe_3in1);
                        UMLog.i("**msr_transaction**", "isCommandRunning = false 8");
                        isCommandRunning = false;
                        infiniteTimeout = false;
                        return rt;
                    }
                    if (rt == -93) {
                        if (this.isDeviceTransaction) {
                            this.cardSwipeErrorCode = 61091;
                            this.activateTransaction = false;
                            this.handler.post(this.runnableSwipeError);
                            UMLog.i("**msr_transaction**", "isCommandRunning = false 9");
                            isCommandRunning = false;
                            readyForCardSwipe = true;
                            infiniteTimeout = false;
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException dataLen2) {
                                // empty catch block
                            }
                            return this.emv_startTransaction(emv_amount, emv_amtOther, emv_type, emv_timeout, emv_tags, false, _isFastEMV);
                        }
                    } else if (rt == 0 && cmd == 0 && this.isDeviceTransaction) {
                        String temp;
                        this.activateTransaction = false;
                        readyForCardSwipe = true;
                        int n = dataLen2 = len > 13 ? (respData.resData[12] & 0xFF) << 8 | respData.resData[13] & 0xFF : 0;
                        if (dataLen2 + 16 == respData.resData.length && (temp = Common.base16Encode(respData.resData).toUpperCase(Locale.US)).contains("DFEE25020010")) {
                            byte attribute2 = respData.resData[14];
                            IDTEMVData emvData = new IDTEMVData();
                            emvData.result = 16;
                            emvData.cardType = attribute2 & 1;
                            emvData.encryptionMode = attribute2 >> 1 & 1;
                            byte[] tlvData = new byte[dataLen2];
                            System.arraycopy(respData.resData, 15, tlvData, 0, tlvData.length);
                            Map<String, Map<String, byte[]>> TLVDict = Common.processTLV(tlvData);
                            if (TLVDict != null) {
                                emvData.unencryptedTags = TLVDict.get("tags");
                                emvData.encryptedTags = TLVDict.get("encrypted");
                                emvData.maskedTags = TLVDict.get("masked");
                                if (autoAuthentication || _isFastEMV) {
                                    int ret = this.emv_authenticateTransaction(null);
                                    if ((ret & 0xFF) == 99) {
                                        this.cardData = new IDTMSRData();
                                        Common.parseCardData3in1(respData.resData, this.cardData);
                                        emvData.msr_cardData = this.cardData;
                                    } else {
                                        emvData.result = 20517;
                                    }
                                } else {
                                    UMLog.i("**msr_transaction**", "isCommandRunning = false 10");
                                    isCommandRunning = false;
                                    UMLog.i("**msr_transaction**", "emvTransactionData() 3");
                                    this.m_recListener.emvTransactionData(this.checkBypassCompletion(emvData));
                                    endTime = System.currentTimeMillis() + 5000000L;
                                }
                                infiniteTimeout = false;
                                return rt;
                            }
                        }
                    }
                    if (rt != 0 && rt != 35) {
                        if (rt == 8) {
                            this.activateTransaction = false;
                            this.handler.post(this.runnableSwipeTimeOut);
                            UMLog.i("**msr_transaction**", "isCommandRunning = false 11");
                            isCommandRunning = false;
                            infiniteTimeout = false;
                            return 3;
                        }
                        if (rt == 10) {
                            this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)5, (byte)1, new byte[0])), 0, respData);
                            this.activateTransaction = false;
                            this.handler.post(this.runnableSwipeFailed);
                            UMLog.i("**msr_transaction**", "isCommandRunning = false 12");
                            isCommandRunning = false;
                            infiniteTimeout = false;
                            return 10;
                        }
                        this.cardSwipeErrorCode = rt & 0xFF | 0xEE00;
                        this.activateTransaction = false;
                        this.handler.post(this.runnableSwipeError);
                        UMLog.i("**msr_transaction**", "isCommandRunning = false 13");
                        isCommandRunning = false;
                        infiniteTimeout = false;
                        return this.cardSwipeErrorCode;
                    }
                }
            }
        } else if (r == TaskManager.TaskStartRet.NO_RESPONSE) {
            if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
                this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)5, (byte)1, new byte[0])), 5, respData);
            }
            this.activateTransaction = false;
            this.handler.post(this.runnableSwipeTimeOut);
            UMLog.i("**msr_transaction**", "isCommandRunning = false 14");
            isCommandRunning = false;
            infiniteTimeout = false;
            return 21;
        }
        this.activateTransaction = false;
        if (cancelTransaction) {
            r = TaskManager.TaskStartRet.SUCCESS;
            cancelTransaction = false;
        }
        this.cardSwipeErrorCode = this.returnACK(r, respData);
        UMLog.i("**msr_transaction**", "isCommandRunning = false 15");
        isCommandRunning = false;
        infiniteTimeout = false;
        return this.cardSwipeErrorCode;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void processFastEMV(IDTMSRData cData) {
        if (!_isFastEMV) {
            if (cData == null) return;
            cData.fastEMV = null;
            return;
        }
        if (cData == null) return;
        if (cData.isCTLS) {
            if (cData.cardData != null && cData.cardData.length > 1) {
                IDTEMVData emvData = new IDTEMVData();
                emvData.msr_cardData = new IDTMSRData();
                byte[] tlv = new byte[cData.cardData.length - 1];
                System.arraycopy(cData.cardData, 1, tlv, 0, tlv.length);
                Map<String, Map<String, byte[]>> TLVDict = Common.processTLV(tlv);
                if (TLVDict != null) {
                    emvData.unencryptedTags = TLVDict.get("tags");
                    emvData.encryptedTags = TLVDict.get("encrypted");
                    emvData.maskedTags = TLVDict.get("masked");
                }
                this.processFastEMV(emvData);
                cData.fastEMV = emvData.msr_cardData.fastEMV;
                return;
            }
            if (cData == null) return;
            cData.fastEMV = null;
            return;
        }
        if (cData.rawTrackData != null && cData.rawTrackData.length > 0) {
            cData.fastEMV = Common.base16Encode(cData.rawTrackData);
            return;
        }
        if (cData == null) return;
        cData.fastEMV = null;
    }

    private void processFastEMV(IDTEMVData cData) {
        byte[] len;
        byte[] value;
        byte[] value2;
        Set<String> keys;
        if (!_isFastEMV) {
            if (cData.msr_cardData != null) {
                cData.msr_cardData.fastEMV = null;
            }
            return;
        }
        if (cData != null && cData.msr_cardData != null && !cData.msr_cardData.iccPresent && cData.msr_cardData.rawTrackData != null && cData.msr_cardData.rawTrackData.length > 0 && cData.result == 17) {
            if (cData.msr_cardData.rawTrackData.length > 6 && cData.msr_cardData.rawTrackData[0] == 2 && cData.msr_cardData.rawTrackData[cData.msr_cardData.rawTrackData.length - 1] == 3 && ((cData.msr_cardData.rawTrackData[2] & 0xFF) << 8 | cData.msr_cardData.rawTrackData[1] & 0xFF) == cData.msr_cardData.rawTrackData.length - 6) {
                cData.msr_cardData.fastEMV = Common.base16Encode(cData.msr_cardData.rawTrackData);
            } else {
                byte[] cmd = Common.makeCommand(Common.base16Encode(cData.msr_cardData.rawTrackData));
                cData.msr_cardData.fastEMV = Common.getHexStringFromBytes(cmd);
            }
            return;
        }
        HashMap<String, Map<String, byte[]>> retrievedTags = new HashMap<String, Map<String, byte[]>>();
        _timeout = 3;
        if (cData != null && cData.msr_cardData != null && cData.msr_cardData.rawTrackData != null && cData.msr_cardData.rawTrackData.length > 0) {
            readyForNextCommand = true;
            this.emv_retrieveTransactionResult(Common.getByteArray("4F50575A5F205F245F2A5F305F3482848A959A9B9C9F029F039F069F079F099F0D9F0E9F0F9F109F129F1A9F1E9F219F269F279F339F349F359F369F379F399F409F419F539F7CDFEE12DFEE25DFEE26DFEF57DFEF5BDFEF5D"), retrievedTags);
        } else {
            cData.msr_cardData = new IDTMSRData();
            readyForNextCommand = true;
            this.emv_retrieveTransactionResult(Common.getByteArray("4F50575A5F205F245F2A5F305F3482848A959A9B9C9F029F039F069F079F099F0D9F0E9F0F9F109F129F1A9F1E9F219F269F279F339F349F359F369F379F399F409F419F539F7CDFEE12DFEE25DFEE26DFEF57DFEF5BDFEF5DDFEE23"), retrievedTags);
        }
        HashMap<String, byte[]> unencryptedTags = (HashMap<String, byte[]>)retrievedTags.get("tags");
        HashMap<String, byte[]> maskedTags = (HashMap<String, byte[]>)retrievedTags.get("masked");
        HashMap<String, byte[]> encryptedTags = (HashMap<String, byte[]>)retrievedTags.get("encrypted");
        HashMap<String, byte[]> finalTags = new HashMap<String, byte[]>();
        if (unencryptedTags == null) {
            unencryptedTags = new HashMap<String, byte[]>();
        }
        if (maskedTags == null) {
            maskedTags = new HashMap<String, byte[]>();
        }
        if (encryptedTags == null) {
            encryptedTags = new HashMap<String, byte[]>();
        }
        if (cData.unencryptedTags != null && !cData.unencryptedTags.isEmpty()) {
            keys = cData.unencryptedTags.keySet();
            for (String key : keys) {
                if (unencryptedTags.containsKey(key)) {
                    unencryptedTags.remove(key);
                }
                unencryptedTags.put(key, cData.unencryptedTags.get(key));
            }
        }
        if (cData.maskedTags != null && !cData.maskedTags.isEmpty()) {
            keys = cData.maskedTags.keySet();
            for (String key : keys) {
                if (maskedTags.containsKey(key)) {
                    maskedTags.remove(key);
                }
                maskedTags.put(key, cData.maskedTags.get(key));
            }
        }
        if (cData.encryptedTags != null && !cData.encryptedTags.isEmpty()) {
            keys = cData.encryptedTags.keySet();
            for (String key : keys) {
                if (encryptedTags.containsKey(key)) {
                    encryptedTags.remove(key);
                }
                encryptedTags.put(key, cData.encryptedTags.get(key));
            }
        }
        if (encryptedTags != null && !encryptedTags.isEmpty()) {
            keys = encryptedTags.keySet();
            for (String key : keys) {
                if (unencryptedTags.containsKey(key)) {
                    unencryptedTags.remove(key);
                }
                unencryptedTags.put(key, (byte[])encryptedTags.get(key));
            }
        }
        if (unencryptedTags != null && !unencryptedTags.isEmpty()) {
            keys = unencryptedTags.keySet();
            for (String key : keys) {
                byte[] value3 = (byte[])unencryptedTags.get(key);
                if (value3 == null || value3.length <= 0) continue;
                finalTags.put(key, value3);
            }
        }
        if (maskedTags.containsKey("57") && (value2 = (byte[])unencryptedTags.get("57")) != null && value2.length > 0 && !finalTags.containsKey("DFEF5D")) {
            finalTags.put("DFEF5D", value2);
        }
        if (maskedTags.containsKey("5A") && (value2 = (byte[])unencryptedTags.get("5A")) != null && value2.length > 0 && !finalTags.containsKey("DFEF5B")) {
            finalTags.put("DFEF5B", value2);
        }
        if (cData != null && cData.msr_cardData != null && cData.msr_cardData.rawTrackData != null && cData.msr_cardData.rawTrackData.length > 0 && !finalTags.containsKey("DFEE23")) {
            if ((cData.msr_cardData.rawTrackData[0] & 0x80) == 128 || (cData.msr_cardData.rawTrackData[0] & 0x90) == 144 || (cData.msr_cardData.rawTrackData[0] & 0xC0) == 192) {
                finalTags.put("DFEE23", Common.makeCommand(Common.base16Encode(cData.msr_cardData.rawTrackData)));
            } else {
                finalTags.put("DFEE23", cData.msr_cardData.rawTrackData);
            }
        }
        StringBuilder sb = new StringBuilder();
        if (finalTags.containsKey("DFEE25")) {
            sb.append("DFEE25");
            value = (byte[])finalTags.get("DFEE25");
            len = new byte[]{(byte)value.length};
            sb.append(Common.getHexStringFromBytes(len));
            sb.append(Common.getHexStringFromBytes(value));
            finalTags.remove("DFEE25");
        }
        if (finalTags.containsKey("DFEE26")) {
            sb.append("DFEE26");
            value = (byte[])finalTags.get("DFEE26");
            len = new byte[]{(byte)value.length};
            sb.append(Common.getHexStringFromBytes(len));
            sb.append(Common.getHexStringFromBytes(value));
            finalTags.remove("DFEE26");
        }
        if (finalTags.containsKey("DFEE12")) {
            sb.append("DFEE12");
            value = (byte[])finalTags.get("DFEE12");
            len = new byte[]{(byte)value.length};
            sb.append(Common.getHexStringFromBytes(len));
            sb.append(Common.getHexStringFromBytes(value));
            finalTags.remove("DFEE12");
        }
        LinkedHashMap<String, String> strTags = new LinkedHashMap<String, String>();
        Set keys2 = finalTags.keySet();
        for (String key : keys2) {
            byte[] value4 = (byte[])finalTags.get(key);
            String newKey = this.updateTag(key);
            if (value4 == null || value4.length == 0) {
                strTags.put(newKey, "");
                continue;
            }
            strTags.put(newKey, Common.getHexStringFromBytes(value4));
        }
        if (strTags.size() > 0) {
            sb.append(Common.getHexStringFromBytes(Common.encodeTags(strTags, 30)).substring(2));
        }
        cData.msr_cardData.fastEMV = sb.toString().toUpperCase(Locale.US);
    }

    private String updateTag(String oldKey) {
        LinkedHashMap<String, String> tagsTable = new LinkedHashMap<String, String>();
        tagsTable.put("DF01", "DFED26");
        tagsTable.put("DF02", "DFEE02");
        tagsTable.put("DF10", "DFEE10");
        tagsTable.put("DF11", "DFEE11");
        tagsTable.put("DF13", "DFEE13");
        tagsTable.put("DF14", "DFEE14");
        tagsTable.put("DF15", "DFEE04");
        tagsTable.put("DF17", "DFEE05");
        tagsTable.put("DF18", "DFEE06");
        tagsTable.put("DF19", "DFEE07");
        tagsTable.put("DF1F", "DFEE09");
        tagsTable.put("DF21", "DFEE0B");
        tagsTable.put("DF22", "DFEE0D");
        tagsTable.put("DF25", "DFEE0E");
        tagsTable.put("DF26", "DFEE0F");
        tagsTable.put("DF27", "DFEE3E");
        tagsTable.put("DF28", "DFEE28");
        tagsTable.put("DF29", "DFEE29");
        tagsTable.put("DF2A", "DFEE2A");
        tagsTable.put("DF2B", "DFEE2B");
        tagsTable.put("DF2C", "DFEE2C");
        tagsTable.put("DF30", "DFEE30");
        tagsTable.put("DF31", "DFEE31");
        tagsTable.put("DF32", "DFEE32");
        tagsTable.put("DF33", "DFEE33");
        tagsTable.put("DF40", "DFEE40");
        tagsTable.put("DF41", "DFEE41");
        tagsTable.put("DF42", "DFEE42");
        tagsTable.put("DF43", "DFEE43");
        tagsTable.put("DF45", "DFEE45");
        tagsTable.put("DF46", "DFEE46");
        tagsTable.put("DF47", "DFEE47");
        tagsTable.put("DF48", "DFEE48");
        tagsTable.put("DF49", "DFEE49");
        tagsTable.put("DF4E", "DFEE4E");
        tagsTable.put("DF50", "DFEE50");
        tagsTable.put("DF52", "DFEE52");
        tagsTable.put("DF55", "DFEE55");
        tagsTable.put("DF56", "DFEE56");
        tagsTable.put("DF57", "DFEE57");
        tagsTable.put("DF58", "DFEE58");
        tagsTable.put("DF5A", "DFEE5A");
        tagsTable.put("DF5B", "DFEE5B");
        tagsTable.put("DF5C", "DFEE5C");
        tagsTable.put("DF5D", "DFEE5D");
        tagsTable.put("DF5E", "DFEE5E");
        tagsTable.put("DF5F", "DFEE5F");
        tagsTable.put("DF60", "DFEE60");
        tagsTable.put("DF61", "DFEE61");
        tagsTable.put("DF62", "DFEE62");
        tagsTable.put("DF63", "DFEE63");
        tagsTable.put("DF64", "DFEE64");
        tagsTable.put("DF65", "DFEE65");
        tagsTable.put("DF66", "DFEE66");
        tagsTable.put("DF68", "DFEE68");
        tagsTable.put("DF69", "DFEE69");
        tagsTable.put("DF6A", "DFEE6A");
        tagsTable.put("DF6C", "DFEE6C");
        tagsTable.put("DF6D", "DFEE6D");
        tagsTable.put("DF6E", "FFEE09");
        tagsTable.put("DF6F", "DFEE6F");
        tagsTable.put("DF70", "DFEE70");
        tagsTable.put("DF71", "DFEE71");
        tagsTable.put("DF72", "DFEE72");
        tagsTable.put("DF73", "DFEE73");
        tagsTable.put("DF74", "DFEE74");
        tagsTable.put("DF75", "DFEE75");
        tagsTable.put("DF76", "DFEE76");
        tagsTable.put("DF77", "DFEE77");
        tagsTable.put("DF78", "DFEE78");
        tagsTable.put("DF79", "DFEE79");
        tagsTable.put("DF7A", "DFEE7A");
        tagsTable.put("DF7B", "DFEE7B");
        tagsTable.put("DF7C", "DFEE7C");
        tagsTable.put("DF7D", "DFEE7D");
        tagsTable.put("DF7F", "DFEE7F");
        tagsTable.put("FF69", "FFEE69");
        tagsTable.put("FF70", "DFEF09");
        tagsTable.put("FF71", "DFEF14");
        tagsTable.put("FF74", "DFEF0F");
        tagsTable.put("FF75", "DFEF10");
        tagsTable.put("FF76", "DFEF11");
        tagsTable.put("FF77", "DFEF15");
        tagsTable.put("FF78", "DFEF1B");
        tagsTable.put("FF79", "DFEF03");
        tagsTable.put("FF7A", "DFEF1D");
        tagsTable.put("FF7B", "DFEE03");
        tagsTable.put("FF7C", "DFEF12");
        tagsTable.put("FF7D", "DFEF13");
        tagsTable.put("FFE0", "DFEE4A");
        tagsTable.put("FFE1", "DFEE4B");
        tagsTable.put("FFE2", "DFEE4C");
        tagsTable.put("FFE3", "DFEE4D");
        tagsTable.put("FFE4", "DFEE2D");
        tagsTable.put("FFE5", "DFEE2E");
        tagsTable.put("FFE6", "DFEE2F");
        tagsTable.put("FFE7", "DFEE4F");
        tagsTable.put("FFE8", "DFEE53");
        tagsTable.put("FFE9", "DFEE54");
        tagsTable.put("FFEA", "DFEE59");
        tagsTable.put("FFEE12", "DFEE12");
        tagsTable.put("FFEE13", "DFEF17");
        tagsTable.put("FFEE14", "DFEF18");
        tagsTable.put("FFEE1C", "DFEF19");
        tagsTable.put("FFEE1D", "DFEE1D");
        tagsTable.put("FFEE1E", "DFEE0A");
        tagsTable.put("FFEE1F", "DFEE02");
        tagsTable.put("FFEE20", "DFEE5C");
        tagsTable.put("FFF0", "DFEE67");
        tagsTable.put("FFF1", "DFEE34");
        tagsTable.put("FFF2", "DFEE6B");
        tagsTable.put("FFF3", "DFEE44");
        tagsTable.put("FFF4", "DFEE35");
        tagsTable.put("FFF6", "DFEE6E");
        tagsTable.put("FFF7", "DFEE7E");
        tagsTable.put("FFF8", "DFEE37");
        tagsTable.put("FFF9", "DFEE1C");
        tagsTable.put("FFFA", "DFEF29");
        tagsTable.put("FFFB", "DFEE38");
        tagsTable.put("FFFC", "DFEE39");
        if (tagsTable.containsKey(oldKey)) {
            return (String)tagsTable.get(oldKey);
        }
        return oldKey;
    }

    public int ctls_cancelTransaction() {
        return this.msr_cancelMSRSwipe();
    }

    public int msr_cancelMSRSwipe() {
        return this.msr_cancelMSRSwipe(false);
    }

    private int msr_cancelMSRSwipe(boolean reset) {
        TaskManager.TaskStartRet r;
        BluetoothController b;
        if (this._bt != null && (b = this._bt.getBluetoothController()) != null) {
            b.cancelTransaction();
        }
        emvCancelTransaction = true;
        cancelTransaction = true;
        UMLog.i("**msr_cancelMSRSwipe**", "activateTransaction: " + this.activateTransaction);
        if (this.activateTransaction) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.stopWaitingTask();
        UMLog.i("**msr_cancelMSRSwipe**", "Check 1");
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIMAG || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIMAG_PRO) {
            readyForCardSwipe = true;
            emvCancelTransaction = false;
            cancelTransaction = false;
            return 0;
        }
        ResDataStruct respData = new ResDataStruct();
        UMLog.i("**msr_cancelMSRSwipe**", "isCommandRunning = true");
        isCommandRunning = true;
        UMLog.i("**msr_cancelMSRSwipe**", "Check 2");
        this.waitForNotification();
        UMLog.i("**msr_cancelMSRSwipe**", "Check 3");
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIJACK) {
            TaskManager.TaskStartRet r2 = this.sendCommand_helper("05", 0, respData);
            UMLog.i("**msr_cancelMSRSwipe**", "isCommandRunning = false 1");
            isCommandRunning = false;
            readyForCardSwipe = true;
            return 0;
        }
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
            TaskManager.TaskStartRet r3;
            UMLog.i("**msr_cancelMSRSwipe**", "Check 4");
            if (!this.device_isConnected()) {
                cancelTransaction = false;
                UMLog.i("**msr_cancelMSRSwipe**", "isCommandRunning = false 2");
                isCommandRunning = false;
                readyForCardSwipe = true;
                return 1;
            }
            int cmd = 0;
            int rt = 9;
            int loopNum = 0;
            if (!this.activateTransaction) {
                cancelTransaction = false;
            }
            UMLog.i("**msr_cancelMSRSwipe**", "Check 5");
            do {
                byte[] byArray;
                if (reset) {
                    byte[] byArray2 = new byte[1];
                    byArray = byArray2;
                    byArray2[0] = 1;
                } else {
                    byArray = new byte[]{};
                }
                r3 = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)5, (byte)1, byArray)), 0, respData);
                ++loopNum;
                if (r3 == TaskManager.TaskStartRet.NO_RESPONSE) {
                    rt = 21;
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (r3 == TaskManager.TaskStartRet.SUCCESS) {
                    if (respData.resData == null) {
                        UMLog.i("**msr_cancelMSRSwipe**", "Check 6");
                        cancelTransaction = false;
                        UMLog.i("**msr_cancelMSRSwipe**", "isCommandRunning = false 3");
                        isCommandRunning = false;
                        readyForCardSwipe = true;
                        return 21;
                    }
                    if (respData.resData.length == 1 && respData.resData[0] == 0) {
                        if (loopNum < maxLoopNum) {
                            rt = 0;
                            cmd = 0;
                            continue;
                        }
                        UMLog.i("**msr_cancelMSRSwipe**", "Check 7");
                        cancelTransaction = false;
                        UMLog.i("**msr_cancelMSRSwipe**", "isCommandRunning = false 4");
                        isCommandRunning = false;
                        readyForCardSwipe = true;
                        return 3;
                    }
                    rt = 9;
                    int len = respData.resData.length;
                    if (len > 11) {
                        rt = respData.resData[11];
                        cmd = respData.resData[10];
                        if (cmd == -18 && rt == -16) break;
                        if (rt != 0) {
                            rt = 9;
                        }
                    }
                }
                if (loopNum >= maxLoopNum || (rt != 0 || cmd == 5) && rt != 21) continue;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (loopNum < maxLoopNum && (rt == 0 && cmd != 5 || rt == 21));
            if (this.activateTransaction) {
                this.activateTransaction = false;
            } else {
                cancelTransaction = false;
            }
            UMLog.i("**msr_cancelMSRSwipe**", "isCommandRunning = false 5");
            isCommandRunning = false;
            readyForCardSwipe = true;
            UMLog.i("**msr_cancelMSRSwipe**", "Check 8");
            return this.returnACK(r3, respData);
        }
        if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_BTPAY || connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_BTPAY_USB) {
            r = this.sendCommand_helper("7346E131", 0, respData);
        } else if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_BTMAG) {
            r = this.sendCommand_helper("02531A01300379", 0, respData);
        } else if (connectedDevice == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA) {
            r = this.sendCommand_helper("7353011A0130", 0, respData);
            if (r == TaskManager.TaskStartRet.SUCCESS && respData.resData[0] == 21) {
                r = this.sendCommand_helper("7353011A0130", 0, respData);
            }
        } else {
            r = this.sendCommand_helper("734619", 0, respData);
        }
        UMLog.i("**msr_cancelMSRSwipe**", "isCommandRunning = false 6");
        isCommandRunning = false;
        readyForCardSwipe = true;
        UMLog.i("**msr_cancelMSRSwipe**", "Check 9");
        return this.returnACK(r, respData);
    }

    private void readPINData(int timeout) {
        ResDataStruct respData = new ResDataStruct();
        long startTime = System.currentTimeMillis();
        boolean isTimeout = false;
        do {
            long currenttTime;
            if (this.isBluetoothDeviceSelected()) {
                currenttTime = System.currentTimeMillis();
                emvCancelTransaction = false;
                this._bt.readMessage(1, currenttTime, respData);
            } else if (this.isBluetoothLEDeviceSelected()) {
                currenttTime = System.currentTimeMillis();
                emvCancelTransaction = false;
                _btle.readMessage(1, currenttTime, respData, true);
            } else {
                currenttTime = System.currentTimeMillis();
                emvCancelTransaction = false;
                _usb.readMessage(1, currenttTime, respData, true);
            }
            if (timeout <= 0 || System.currentTimeMillis() - startTime <= (long)(timeout * 1000)) continue;
            isTimeout = true;
            break;
        } while (respData.resData == null || respData.resData != null && respData.resData.length == 1 && respData.resData[0] == 0 || respData.resData != null && respData.resData.length < 14);
        if (!isTimeout) {
            this.convertIDG(respData, 0);
            if (respData.statusCode != 0) {
                respData.resData = null;
            }
        }
        isCommandRunning = false;
        readyForNextCommand = true;
        if (isTimeout) {
            this.m_recListener.timeout(3);
        } else {
            this.m_recListenerPIN.pinpadData(respData.resData);
        }
    }

    public int felica_authentication(byte[] key) {
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (key == null || key.length != 16) {
            return 27392;
        }
        int cmd = 0;
        int rt = 9;
        isCommandRunning = true;
        this.waitForNotification();
        ResDataStruct respData = new ResDataStruct();
        int loopNum = 0;
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)44, (byte)66, key)), 0, respData);
            ++loopNum;
            if (r == TaskManager.TaskStartRet.SUCCESS) {
                if (respData.resData == null) {
                    isCommandRunning = false;
                    respData.statusCode = 21;
                    return 21;
                }
                if (respData.resData.length == 1 && respData.resData[0] == 0) {
                    isCommandRunning = false;
                    respData.statusCode = 3;
                    return 3;
                }
                rt = 9;
                int len = respData.resData.length;
                if (len > 11) {
                    rt = respData.resData[11];
                    cmd = respData.resData[10];
                    if (cmd == -18 && rt == -16) break;
                    if (rt != 0) {
                        rt = 9;
                    }
                }
            }
            if (loopNum >= maxLoopNum || rt == 0 && cmd == 44) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException len) {
                // empty catch block
            }
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != 44));
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int felica_readWithMac(int blockCnt, byte[] blockList, ResDataStruct respData) {
        TaskManager.TaskStartRet r;
        if (respData == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            respData.statusCode = 29696;
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB) {
            respData.statusCode = 20;
            return 20;
        }
        if (!this.device_isConnected()) {
            respData.statusCode = 1;
            return 1;
        }
        if (blockCnt < 1 || blockCnt > 3 || blockList == null || blockList.length < blockCnt * 2 || blockList.length > blockCnt * 3) {
            respData.statusCode = 27392;
            return 27392;
        }
        int cmd = 0;
        int rt = 9;
        isCommandRunning = true;
        this.waitForNotification();
        int loopNum = 0;
        byte[] data = new byte[blockList.length + 2];
        data[0] = 6;
        data[1] = (byte)blockCnt;
        System.arraycopy(blockList, 0, data, 2, blockList.length);
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)44, (byte)67, data)), 0, respData);
            ++loopNum;
            if (r == TaskManager.TaskStartRet.SUCCESS) {
                if (respData.resData == null) {
                    isCommandRunning = false;
                    respData.statusCode = 21;
                    return 21;
                }
                if (respData.resData.length == 1 && respData.resData[0] == 0) {
                    isCommandRunning = false;
                    respData.statusCode = 3;
                    return 3;
                }
                rt = 9;
                int len = respData.resData.length;
                if (len > 11) {
                    rt = respData.resData[11];
                    cmd = respData.resData[10];
                    if (cmd == -18 && rt == -16) break;
                    if (rt != 0) {
                        rt = 9;
                    }
                }
            }
            if (loopNum >= maxLoopNum || rt == 0 && cmd == 44) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException len) {
                // empty catch block
            }
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != 44));
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int felica_writeWithMac(byte blockNum, byte[] blockData) {
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (blockData == null || blockData.length != 16) {
            return 27392;
        }
        int cmd = 0;
        int rt = 9;
        isCommandRunning = true;
        this.waitForNotification();
        int loopNum = 0;
        byte[] data = new byte[blockData.length + 2];
        data[0] = 8;
        data[1] = blockNum;
        System.arraycopy(blockData, 0, data, 2, blockData.length);
        ResDataStruct respData = new ResDataStruct();
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)44, (byte)67, data)), 0, respData);
            ++loopNum;
            if (r == TaskManager.TaskStartRet.SUCCESS) {
                if (respData.resData == null) {
                    isCommandRunning = false;
                    respData.statusCode = 21;
                    return 21;
                }
                if (respData.resData.length == 1 && respData.resData[0] == 0) {
                    isCommandRunning = false;
                    respData.statusCode = 3;
                    return 3;
                }
                rt = 9;
                int len = respData.resData.length;
                if (len > 11) {
                    rt = respData.resData[11];
                    cmd = respData.resData[10];
                    if (cmd == -18 && rt == -16) break;
                    if (rt != 0) {
                        rt = 9;
                    }
                }
            }
            if (loopNum >= maxLoopNum || rt == 0 && cmd == 44) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException len) {
                // empty catch block
            }
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != 44));
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int felica_read(byte[] serviceCodeList, int blockCnt, byte[] blockList, ResDataStruct respData) {
        TaskManager.TaskStartRet r;
        if (respData == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            respData.statusCode = 29696;
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB) {
            respData.statusCode = 20;
            return 20;
        }
        if (!this.device_isConnected()) {
            respData.statusCode = 1;
            return 1;
        }
        if (blockCnt < 1 || blockCnt > 4 || blockList == null || blockList.length < blockCnt * 2 || blockList.length > blockCnt * 3 || serviceCodeList == null || serviceCodeList.length < 2 || serviceCodeList.length % 2 != 0) {
            respData.statusCode = 27392;
            return 27392;
        }
        int cmd = 0;
        int rt = 9;
        isCommandRunning = true;
        this.waitForNotification();
        int loopNum = 0;
        int serviceCodeCnt = serviceCodeList.length / 2;
        byte[] data = new byte[serviceCodeList.length + blockList.length + 3];
        data[0] = 6;
        data[1] = (byte)serviceCodeCnt;
        System.arraycopy(serviceCodeList, 0, data, 2, serviceCodeList.length);
        data[serviceCodeList.length + 2] = (byte)blockCnt;
        System.arraycopy(blockList, 0, data, serviceCodeList.length + 3, blockList.length);
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)44, (byte)65, data)), 0, respData);
            ++loopNum;
            if (r == TaskManager.TaskStartRet.SUCCESS) {
                if (respData.resData == null) {
                    isCommandRunning = false;
                    respData.statusCode = 21;
                    return 21;
                }
                if (respData.resData.length == 1 && respData.resData[0] == 0) {
                    isCommandRunning = false;
                    respData.statusCode = 3;
                    return 3;
                }
                rt = 9;
                int len = respData.resData.length;
                if (len > 11) {
                    rt = respData.resData[11];
                    cmd = respData.resData[10];
                    if (cmd == -18 && rt == -16) break;
                    if (rt != 0) {
                        rt = 9;
                    }
                }
            }
            if (loopNum >= maxLoopNum || rt == 0 && cmd == 44) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException len) {
                // empty catch block
            }
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != 44));
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int felica_write(byte[] serviceCodeList, int blockCnt, byte[] blockList, byte[] blockData, ResDataStruct respData) {
        TaskManager.TaskStartRet r;
        if (respData == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            respData.statusCode = 29696;
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB) {
            respData.statusCode = 20;
            return 20;
        }
        if (!this.device_isConnected()) {
            respData.statusCode = 1;
            return 1;
        }
        if (blockCnt < 1 || blockCnt > 255 || blockList == null || blockList.length < blockCnt * 2 || blockList.length > blockCnt * 3 || blockData == null || blockData.length != 16 * blockCnt || serviceCodeList == null || serviceCodeList.length < 2 || serviceCodeList.length % 2 != 0) {
            respData.statusCode = 27392;
            return 27392;
        }
        int cmd = 0;
        int rt = 9;
        isCommandRunning = true;
        this.waitForNotification();
        int loopNum = 0;
        int serviceCodeCnt = serviceCodeList.length / 2;
        byte[] data = new byte[serviceCodeList.length + blockList.length + blockData.length + 3];
        data[0] = 8;
        data[1] = (byte)serviceCodeCnt;
        System.arraycopy(serviceCodeList, 0, data, 2, serviceCodeList.length);
        data[serviceCodeList.length + 2] = (byte)blockCnt;
        System.arraycopy(blockList, 0, data, serviceCodeList.length + 3, blockList.length);
        System.arraycopy(blockData, 0, data, serviceCodeList.length + blockList.length + 3, blockData.length);
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)44, (byte)65, data)), 0, respData);
            ++loopNum;
            if (r == TaskManager.TaskStartRet.SUCCESS) {
                if (respData.resData == null) {
                    isCommandRunning = false;
                    respData.statusCode = 21;
                    return 21;
                }
                if (respData.resData.length == 1 && respData.resData[0] == 0) {
                    isCommandRunning = false;
                    respData.statusCode = 3;
                    return 3;
                }
                rt = 9;
                int len = respData.resData.length;
                if (len > 11) {
                    rt = respData.resData[11];
                    cmd = respData.resData[10];
                    if (cmd == -18 && rt == -16) break;
                    if (rt != 0) {
                        rt = 9;
                    }
                }
            }
            if (loopNum >= maxLoopNum || rt == 0 && cmd == 44) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException len) {
                // empty catch block
            }
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != 44));
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int felica_poll(byte[] systemCode, ResDataStruct respData) {
        TaskManager.TaskStartRet r;
        if (respData == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            respData.statusCode = 29696;
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB) {
            respData.statusCode = 20;
            return 20;
        }
        if (!this.device_isConnected()) {
            respData.statusCode = 1;
            return 1;
        }
        if (systemCode == null || systemCode.length != 2 || systemCode[0] != -1) {
            respData.statusCode = 27392;
            return 27392;
        }
        int cmd = 0;
        int rt = 9;
        isCommandRunning = true;
        this.waitForNotification();
        int loopNum = 0;
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)44, (byte)64, systemCode)), systemCode[1] + 1, respData);
            ++loopNum;
            if (r == TaskManager.TaskStartRet.SUCCESS) {
                if (respData.resData == null) {
                    isCommandRunning = false;
                    respData.statusCode = 21;
                    return 21;
                }
                if (respData.resData.length == 1 && respData.resData[0] == 0) {
                    isCommandRunning = false;
                    respData.statusCode = 3;
                    return 3;
                }
                rt = 9;
                int len = respData.resData.length;
                if (len > 11) {
                    rt = respData.resData[11];
                    cmd = respData.resData[10];
                    if (cmd == -18 && rt == -16) break;
                    if (rt != 0) {
                        rt = 9;
                    }
                }
            }
            if (loopNum >= maxLoopNum || rt == 0 && cmd == 44) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException len) {
                // empty catch block
            }
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != 44));
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int felica_requestService(byte[] nodeCode, ResDataStruct respData) {
        TaskManager.TaskStartRet r;
        if (respData == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            respData.statusCode = 29696;
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB) {
            respData.statusCode = 20;
            return 20;
        }
        if (!this.device_isConnected()) {
            respData.statusCode = 1;
            return 1;
        }
        if (nodeCode == null || nodeCode.length < 1) {
            respData.statusCode = 27392;
            return 27392;
        }
        int cmd = 0;
        int rt = 9;
        isCommandRunning = true;
        this.waitForNotification();
        int loopNum = 0;
        byte[] data = new byte[nodeCode.length + 2];
        data[0] = 2;
        data[1] = (byte)(nodeCode.length / 2);
        System.arraycopy(nodeCode, 0, data, 2, nodeCode.length);
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)44, (byte)65, data)), 0, respData);
            ++loopNum;
            if (r == TaskManager.TaskStartRet.SUCCESS) {
                if (respData.resData == null) {
                    isCommandRunning = false;
                    respData.statusCode = 21;
                    return 21;
                }
                if (respData.resData.length == 1 && respData.resData[0] == 0) {
                    isCommandRunning = false;
                    respData.statusCode = 3;
                    return 3;
                }
                rt = 9;
                int len = respData.resData.length;
                if (len > 11) {
                    rt = respData.resData[11];
                    cmd = respData.resData[10];
                    if (cmd == -18 && rt == -16) break;
                    if (rt != 0) {
                        rt = 9;
                    }
                }
            }
            if (loopNum >= maxLoopNum || rt == 0 && cmd == 44) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException len) {
                // empty catch block
            }
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != 44));
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int felica_SendCommand(byte[] command, ResDataStruct respData) {
        TaskManager.TaskStartRet r;
        if (respData == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            respData.statusCode = 29696;
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB) {
            respData.statusCode = 20;
            return 20;
        }
        if (!this.device_isConnected()) {
            respData.statusCode = 1;
            return 1;
        }
        if (command == null || command.length <= 0 || command.length > 255) {
            respData.statusCode = 27392;
            return 27392;
        }
        int cmd = 0;
        int rt = 9;
        isCommandRunning = true;
        this.waitForNotification();
        int loopNum = 0;
        byte[] data = new byte[command.length + 1];
        data[0] = (byte)command.length;
        System.arraycopy(command, 0, data, 1, command.length);
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)44, (byte)68, data)), 0, respData);
            ++loopNum;
            if (r == TaskManager.TaskStartRet.SUCCESS) {
                if (respData.resData == null) {
                    isCommandRunning = false;
                    respData.statusCode = 21;
                    return 21;
                }
                if (respData.resData.length == 1 && respData.resData[0] == 0) {
                    isCommandRunning = false;
                    respData.statusCode = 3;
                    return 3;
                }
                rt = 9;
                int len = respData.resData.length;
                if (len > 11) {
                    rt = respData.resData[11];
                    cmd = respData.resData[10];
                    if (cmd == -18 && rt == -16) break;
                    if (rt != 0) {
                        rt = 9;
                    }
                }
            }
            if (loopNum >= maxLoopNum || rt == 0 && cmd == 44) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException len) {
                // empty catch block
            }
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != 44));
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    private boolean checkSecondResponse(TaskManager.TaskStartRet r, ResDataStruct respData) {
        if (respData == null || respData.resData == null || respData.resData.length == 0) {
            return false;
        }
        if (respData.resData.length > 13) {
            int len = respData.resData.length;
            int idgLen = (respData.resData[12] & 0xFF) * 256 + (respData.resData[13] & 0xFF);
            if (len > idgLen + 16) {
                if (len - (idgLen + 16) >= 16) {
                    int newLen = len - (idgLen + 16);
                    byte[] newData = new byte[newLen];
                    System.arraycopy(respData.resData, idgLen + 16, newData, 0, newLen);
                    respData.resData = newData;
                    int returnCode = this.returnACK(r, respData);
                    this.convertIDG(respData, 0);
                    isCommandRunning = false;
                    readyForCardSwipe = true;
                    respData.statusCode = returnCode;
                    return true;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    public int pin_getEncryptedOnlinePIN(int keyType, int timeout) {
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (timeout < 0 || timeout > 255 || keyType < 0 || keyType > 4) {
            return 27392;
        }
        int cmd = 0;
        int rt = 9;
        isCommandRunning = true;
        this.waitForNotification();
        ResDataStruct respData = new ResDataStruct();
        int loopNum = 0;
        byte[] data = new byte[]{(byte)timeout, (byte)keyType, 0};
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-125, (byte)67, data)), 0, respData);
            ++loopNum;
            if (r != TaskManager.TaskStartRet.SUCCESS) continue;
            if (respData.resData == null) {
                isCommandRunning = false;
                respData.statusCode = 21;
                return 21;
            }
            if (respData.resData.length == 1 && respData.resData[0] == 0) {
                isCommandRunning = false;
                respData.statusCode = 3;
                return 3;
            }
            rt = 9;
            int len = respData.resData.length;
            if (len <= 11) continue;
            rt = respData.resData[11];
            cmd = respData.resData[10];
            if (cmd == -18 && rt == -16) break;
            if (rt == 0) continue;
            rt = 9;
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != -125));
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int pin_getPAN(int getCSC, int timeout) {
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (timeout < 0 || timeout > 65535 || getCSC < 0 || getCSC > 1) {
            return 27392;
        }
        int cmd = 0;
        int rt = 9;
        isCommandRunning = true;
        this.waitForNotification();
        ResDataStruct respData = new ResDataStruct();
        int loopNum = 0;
        byte[] data = new byte[]{0, 0, 0, 0};
        if (getCSC == 1) {
            data[2] = 2;
        }
        data[0] = (byte)(timeout >> 8 & 0xFF);
        data[1] = (byte)(timeout & 0xFF);
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-125, (byte)65, data)), 0, respData);
            ++loopNum;
            if (r != TaskManager.TaskStartRet.SUCCESS) continue;
            if (respData.resData == null) {
                isCommandRunning = false;
                respData.statusCode = 21;
                return 21;
            }
            if (respData.resData.length == 1 && respData.resData[0] == 0) {
                isCommandRunning = false;
                respData.statusCode = 3;
                return 3;
            }
            rt = 9;
            int len = respData.resData.length;
            if (len <= 11) continue;
            rt = respData.resData[11];
            cmd = respData.resData[10];
            if (cmd == -18 && rt == -16) break;
            if (rt == 0) continue;
            rt = 9;
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != -125));
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int pin_promptCreditDebit(byte currencySymbol, String displayAmount, int timeout, ResDataStruct respData) {
        TaskManager.TaskStartRet r;
        if (respData == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (timeout < 2 || timeout > 20 || displayAmount == null || displayAmount.length() > 50) {
            return 27392;
        }
        int cmd = 0;
        int rt = 9;
        isCommandRunning = true;
        this.waitForNotification();
        int loopNum = 0;
        byte[] data = new byte[displayAmount.length() + 4];
        int pos = 0;
        data[pos++] = (byte)timeout;
        data[pos++] = currencySymbol;
        data[pos++] = 0;
        if (displayAmount.length() > 0) {
            char[] cDisplayAmount = displayAmount.toCharArray();
            System.arraycopy(cDisplayAmount, 0, data, pos, cDisplayAmount.length);
            pos += cDisplayAmount.length;
        }
        data[pos] = 0;
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-125, (byte)66, data)), 0, respData);
            ++loopNum;
            if (r != TaskManager.TaskStartRet.SUCCESS) continue;
            if (respData.resData == null) {
                isCommandRunning = false;
                respData.statusCode = 21;
                return 21;
            }
            if (respData.resData.length == 1 && respData.resData[0] == 0) {
                isCommandRunning = false;
                respData.statusCode = 3;
                return 3;
            }
            rt = 9;
            int len = respData.resData.length;
            if (len <= 11) continue;
            rt = respData.resData[11];
            cmd = respData.resData[10];
            if (cmd == -18 && rt == -16) break;
            if (rt == 0) continue;
            rt = 9;
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != -125));
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int ws_requestCSR(ResDataStruct respData) {
        TaskManager.TaskStartRet r;
        if (respData == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        int cmd = 0;
        int rt = 9;
        isCommandRunning = true;
        this.waitForNotification();
        int loopNum = 0;
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-123, (byte)0, new byte[0])), 0, respData);
            ++loopNum;
            if (r != TaskManager.TaskStartRet.SUCCESS) continue;
            if (respData.resData == null) {
                isCommandRunning = false;
                respData.statusCode = 21;
                return 21;
            }
            if (respData.resData.length == 1 && respData.resData[0] == 0) {
                isCommandRunning = false;
                respData.statusCode = 3;
                return 3;
            }
            rt = 9;
            int len = respData.resData.length;
            if (len <= 11) continue;
            rt = respData.resData[11];
            cmd = respData.resData[10];
            if (cmd == -18 && rt == -16) break;
            if (rt == 0) continue;
            rt = 9;
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != -123));
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        if (cmd == -18 && rt == -16) {
            respData.statusCode = returnCode;
            return returnCode;
        }
        int pos = 0;
        respData.stringArray = new String[6];
        for (int i = 0; i < 6; ++i) {
            int len = respData.resData[pos] << 8 & 0xFF | respData.resData[pos + 1] & 0xFF;
            pos += 2;
            if (len > 0) {
                char[] ch = new char[len];
                System.arraycopy(respData.resData, pos, ch, 0, len);
                pos += len;
                respData.stringArray[i] = ch.toString();
                continue;
            }
            respData.stringArray[i] = "";
        }
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int ws_loadSSLCert(String name, String dataDER) {
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (name == null || name.length() == 0 || dataDER == null || dataDER.length() == 0) {
            return 27392;
        }
        int cmd = 0;
        int rt = 9;
        isCommandRunning = true;
        this.waitForNotification();
        int loopNum = 0;
        ResDataStruct respData = new ResDataStruct();
        int idx = 0;
        byte[] data = new byte[name.length() + dataDER.length() + 4];
        data[idx++] = (byte)(name.length() & 0xFF);
        data[idx++] = (byte)(name.length() >> 8 & 0xFF);
        char[] ch = name.toCharArray();
        System.arraycopy(ch, 0, data, idx, ch.length);
        idx += name.length();
        data[idx++] = (byte)(dataDER.length() & 0xFF);
        data[idx++] = (byte)(dataDER.length() >> 8 & 0xFF);
        ch = dataDER.toCharArray();
        System.arraycopy(ch, 0, data, idx, ch.length);
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-123, (byte)1, data)), 0, respData);
            ++loopNum;
            if (r != TaskManager.TaskStartRet.SUCCESS) continue;
            if (respData.resData == null) {
                isCommandRunning = false;
                respData.statusCode = 21;
                return 21;
            }
            if (respData.resData.length == 1 && respData.resData[0] == 0) {
                isCommandRunning = false;
                respData.statusCode = 3;
                return 3;
            }
            rt = 9;
            int len = respData.resData.length;
            if (len <= 11) continue;
            rt = respData.resData[11];
            cmd = respData.resData[10];
            if (cmd == -18 && rt == -16) break;
            if (rt == 0) continue;
            rt = 9;
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != -123));
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int ws_revokeSSLCert(String name) {
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (name == null || name.length() == 0) {
            return 27392;
        }
        int cmd = 0;
        int rt = 9;
        isCommandRunning = true;
        this.waitForNotification();
        int loopNum = 0;
        ResDataStruct respData = new ResDataStruct();
        byte[] data = new byte[name.length()];
        char[] ch = name.toCharArray();
        System.arraycopy(ch, 0, data, 0, ch.length);
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-123, (byte)3, data)), 0, respData);
            ++loopNum;
            if (r != TaskManager.TaskStartRet.SUCCESS) continue;
            if (respData.resData == null) {
                isCommandRunning = false;
                respData.statusCode = 21;
                return 21;
            }
            if (respData.resData.length == 1 && respData.resData[0] == 0) {
                isCommandRunning = false;
                respData.statusCode = 3;
                return 3;
            }
            rt = 9;
            int len = respData.resData.length;
            if (len <= 11) continue;
            rt = respData.resData[11];
            cmd = respData.resData[10];
            if (cmd == -18 && rt == -16) break;
            if (rt == 0) continue;
            rt = 9;
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != -123));
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int ws_deleteSSLCert(String name) {
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (name == null || name.length() == 0) {
            return 27392;
        }
        int cmd = 0;
        int rt = 9;
        isCommandRunning = true;
        this.waitForNotification();
        int loopNum = 0;
        ResDataStruct respData = new ResDataStruct();
        byte[] data = new byte[name.length()];
        char[] ch = name.toCharArray();
        System.arraycopy(ch, 0, data, 0, ch.length);
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-123, (byte)2, data)), 0, respData);
            ++loopNum;
            if (r != TaskManager.TaskStartRet.SUCCESS) continue;
            if (respData.resData == null) {
                isCommandRunning = false;
                respData.statusCode = 21;
                return 21;
            }
            if (respData.resData.length == 1 && respData.resData[0] == 0) {
                isCommandRunning = false;
                respData.statusCode = 3;
                return 3;
            }
            rt = 9;
            int len = respData.resData.length;
            if (len <= 11) continue;
            rt = respData.resData[11];
            cmd = respData.resData[10];
            if (cmd == -18 && rt == -16) break;
            if (rt == 0) continue;
            rt = 9;
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != -123));
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int ws_getCertChainType(ResDataStruct respData) {
        TaskManager.TaskStartRet r;
        if (respData == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        int cmd = 0;
        int rt = 9;
        isCommandRunning = true;
        this.waitForNotification();
        int loopNum = 0;
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-123, (byte)4, new byte[0])), 0, respData);
            ++loopNum;
            if (r != TaskManager.TaskStartRet.SUCCESS) continue;
            if (respData.resData == null) {
                isCommandRunning = false;
                respData.statusCode = 21;
                return 21;
            }
            if (respData.resData.length == 1 && respData.resData[0] == 0) {
                isCommandRunning = false;
                respData.statusCode = 3;
                return 3;
            }
            rt = 9;
            int len = respData.resData.length;
            if (len <= 11) continue;
            rt = respData.resData[11];
            cmd = respData.resData[10];
            if (cmd == -18 && rt == -16) break;
            if (rt == 0 && len > 14 && respData.resData[13] == 1) {
                respData.ret = respData.resData[14];
            }
            if (rt == 0) continue;
            rt = 9;
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != -123));
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int ws_updateRootCertificate(String name, String dataDER, String signature) {
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (name == null || name.length() == 0 || dataDER == null || dataDER.length() == 0 || signature == null || signature.length() == 0) {
            return 27392;
        }
        int cmd = 0;
        int rt = 9;
        isCommandRunning = true;
        this.waitForNotification();
        int loopNum = 0;
        ResDataStruct respData = new ResDataStruct();
        int idx = 0;
        byte[] data = new byte[name.length() + dataDER.length() + signature.length() + 6];
        data[idx++] = (byte)(name.length() & 0xFF);
        data[idx++] = (byte)(name.length() >> 8 & 0xFF);
        char[] ch = name.toCharArray();
        System.arraycopy(ch, 0, data, idx, ch.length);
        idx += name.length();
        data[idx++] = (byte)(dataDER.length() & 0xFF);
        data[idx++] = (byte)(dataDER.length() >> 8 & 0xFF);
        ch = dataDER.toCharArray();
        System.arraycopy(ch, 0, data, idx, ch.length);
        idx += dataDER.length();
        data[idx++] = (byte)(signature.length() & 0xFF);
        data[idx++] = (byte)(signature.length() >> 8 & 0xFF);
        ch = signature.toCharArray();
        System.arraycopy(ch, 0, data, idx, ch.length);
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-123, (byte)5, data)), 0, respData);
            ++loopNum;
            if (r != TaskManager.TaskStartRet.SUCCESS) continue;
            if (respData.resData == null) {
                isCommandRunning = false;
                respData.statusCode = 21;
                return 21;
            }
            if (respData.resData.length == 1 && respData.resData[0] == 0) {
                isCommandRunning = false;
                respData.statusCode = 3;
                return 3;
            }
            rt = 9;
            int len = respData.resData.length;
            if (len <= 11) continue;
            rt = respData.resData[11];
            cmd = respData.resData[10];
            if (cmd == -18 && rt == -16) break;
            if (rt == 0) continue;
            rt = 9;
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != -123));
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int pin_cancelPINEntry() {
        int returnCode;
        TaskManager.TaskStartRet r;
        if (!readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        ResDataStruct respData = new ResDataStruct();
        int cmd = 0;
        int rt = 9;
        isCommandRunning = true;
        this.waitForNotification();
        int loopNum = 0;
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)98, (byte)0, new byte[0])), 0, respData);
            ++loopNum;
            if (r == TaskManager.TaskStartRet.SUCCESS) {
                if (respData.resData == null) {
                    isCommandRunning = false;
                    respData.statusCode = 21;
                    return 21;
                }
                if (respData.resData.length == 1 && respData.resData[0] == 0) {
                    isCommandRunning = false;
                    respData.statusCode = 3;
                    return 3;
                }
                rt = 9;
                int len = respData.resData.length;
                if (len > 11) {
                    rt = respData.resData[11];
                    cmd = respData.resData[10];
                    if (cmd == -18 && rt == -16) break;
                    if (rt != 0) {
                        rt = 9;
                    }
                }
            }
            if (loopNum >= maxLoopNum || rt == 0 && cmd == 98) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException len) {
                // empty catch block
            }
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != 98));
        if ((returnCode = this.returnACK(r, respData)) == 0) {
            cancelPINEntry = true;
        }
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int pin_displayMessageGetEncryptedPIN(byte PANKeyType, byte[] PAN, byte PINMaxLen, byte PINMinLen, byte[] LCDMsg, ResDataStruct respData) {
        TaskManager.TaskStartRet r;
        if (respData == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        int cmd = 0;
        int rt = 9;
        int dataLen = (PAN == null ? 0 : PAN.length) + (LCDMsg == null ? 0 : LCDMsg.length) + 5;
        byte[] data = new byte[dataLen];
        data[0] = PANKeyType;
        data[1] = (byte)(PAN == null ? 0 : PAN.length);
        int idx = 2;
        if (PAN != null && PAN.length > 0) {
            System.arraycopy(PAN, 0, data, idx, PAN.length);
            idx += PAN.length;
        }
        data[idx++] = PINMaxLen;
        data[idx++] = PINMinLen;
        data[idx++] = (byte)(LCDMsg == null ? 0 : LCDMsg.length);
        if (LCDMsg != null && LCDMsg.length > 0) {
            System.arraycopy(LCDMsg, 0, data, idx, LCDMsg.length);
            idx += LCDMsg.length;
        }
        cancelPINEntry = false;
        isCommandRunning = true;
        readyForNextCommand = false;
        this.waitForNotification();
        int loopNum = 0;
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)98, (byte)1, data)), 0, respData);
            ++loopNum;
            if (r == TaskManager.TaskStartRet.SUCCESS) {
                if (respData.resData == null) {
                    isCommandRunning = false;
                    readyForNextCommand = true;
                    respData.statusCode = 21;
                    return 21;
                }
                if (respData.resData.length == 1 && respData.resData[0] == 0) {
                    isCommandRunning = false;
                    readyForNextCommand = true;
                    respData.statusCode = 3;
                    return 3;
                }
                rt = 9;
                int len = respData.resData.length;
                if (len > 11) {
                    rt = respData.resData[11];
                    cmd = respData.resData[10];
                    if (cmd == -18 && rt == -16) break;
                }
            }
            if (loopNum >= maxLoopNum || rt == 0 && cmd == 98) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException len) {
                // empty catch block
            }
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != 98));
        if (this.checkSecondResponse(r, respData)) {
            return respData.statusCode;
        }
        if (rt == 0) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    emvCancelTransaction = false;
                    IDT_Device.this.emv_secondResponse(182, 5, null);
                }
            }).start();
        } else {
            isCommandRunning = false;
            readyForNextCommand = true;
        }
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int pin_getFunctionKey(ResDataStruct respData) {
        TaskManager.TaskStartRet r;
        if (respData == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        int cmd = 0;
        int rt = 9;
        isCommandRunning = true;
        cancelPINEntry = false;
        readyForNextCommand = false;
        this.waitForNotification();
        int loopNum = 0;
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)98, (byte)2, new byte[0])), 0, respData);
            ++loopNum;
            if (r == TaskManager.TaskStartRet.SUCCESS) {
                if (respData.resData == null) {
                    isCommandRunning = false;
                    readyForNextCommand = true;
                    respData.statusCode = 21;
                    return 21;
                }
                if (respData.resData.length == 1 && respData.resData[0] == 0) {
                    isCommandRunning = false;
                    readyForNextCommand = true;
                    respData.statusCode = 3;
                    return 3;
                }
                rt = 9;
                int len = respData.resData.length;
                if (len > 11) {
                    rt = respData.resData[11];
                    cmd = respData.resData[10];
                    if (cmd == -18 && rt == -16) break;
                }
            }
            if (loopNum >= maxLoopNum || rt == 0 && cmd == 98) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException len) {
                // empty catch block
            }
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != 98));
        if (this.checkSecondResponse(r, respData)) {
            return respData.statusCode;
        }
        if (rt == 0) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    IDT_Device.this.readPINData(0);
                }
            }).start();
        } else {
            isCommandRunning = false;
            readyForNextCommand = true;
        }
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int pin_displayMessageGetNumericKey(byte DisplayFlag, byte KeyMaxLen, byte KeyMinLen, byte[] TextDisplayMsg, byte[] DisplayMsgSig, ResDataStruct respData) {
        TaskManager.TaskStartRet r;
        if (respData == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        int cmd = 0;
        int rt = 9;
        int dataLen = (TextDisplayMsg == null ? 0 : TextDisplayMsg.length) + (DisplayMsgSig == null ? 0 : DisplayMsgSig.length) + 3;
        byte[] data = new byte[dataLen];
        data[0] = DisplayFlag;
        data[1] = KeyMaxLen;
        data[2] = KeyMinLen;
        int idx = 3;
        if (TextDisplayMsg != null && TextDisplayMsg.length > 0) {
            System.arraycopy(TextDisplayMsg, 0, data, idx, TextDisplayMsg.length);
            idx += TextDisplayMsg.length;
        }
        if (DisplayMsgSig != null && DisplayMsgSig.length > 0) {
            System.arraycopy(DisplayMsgSig, 0, data, idx, DisplayMsgSig.length);
            idx += DisplayMsgSig.length;
        }
        isCommandRunning = true;
        readyForNextCommand = false;
        cancelPINEntry = false;
        this.waitForNotification();
        int loopNum = 0;
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)98, (byte)3, data)), 0, respData);
            ++loopNum;
            if (r == TaskManager.TaskStartRet.SUCCESS) {
                if (respData.resData == null) {
                    isCommandRunning = false;
                    readyForNextCommand = true;
                    respData.statusCode = 21;
                    return 21;
                }
                if (respData.resData.length == 1 && respData.resData[0] == 0) {
                    isCommandRunning = false;
                    readyForNextCommand = true;
                    respData.statusCode = 3;
                    return 3;
                }
                rt = 9;
                int len = respData.resData.length;
                if (len > 11) {
                    rt = respData.resData[11];
                    cmd = respData.resData[10];
                    if (cmd == -18 && rt == -16) break;
                    if (rt != 0) {
                        rt = 9;
                    }
                }
            }
            if (loopNum >= maxLoopNum || rt == 0 && cmd == 98) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException len) {
                // empty catch block
            }
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != 98));
        if (this.checkSecondResponse(r, respData)) {
            return respData.statusCode;
        }
        if (rt == 0) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    IDT_Device.this.readPINData(0);
                }
            }).start();
        } else {
            isCommandRunning = false;
            readyForNextCommand = true;
        }
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int pin_displayMessageGetAmount(byte DisplayFlag, byte KeyMaxLen, byte KeyMinLen, byte[] TextDisplayMsg, byte[] DisplayMsgSig, ResDataStruct respData) {
        TaskManager.TaskStartRet r;
        if (respData == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        int cmd = 0;
        int rt = 9;
        int dataLen = (TextDisplayMsg == null ? 0 : TextDisplayMsg.length) + (DisplayMsgSig == null ? 0 : DisplayMsgSig.length) + 3;
        byte[] data = new byte[dataLen];
        data[0] = DisplayFlag;
        data[1] = KeyMaxLen;
        data[2] = KeyMinLen;
        int idx = 3;
        if (TextDisplayMsg != null && TextDisplayMsg.length > 0) {
            System.arraycopy(TextDisplayMsg, 0, data, idx, TextDisplayMsg.length);
            idx += TextDisplayMsg.length;
        }
        if (DisplayMsgSig != null && DisplayMsgSig.length > 0) {
            System.arraycopy(DisplayMsgSig, 0, data, idx, DisplayMsgSig.length);
            idx += DisplayMsgSig.length;
        }
        isCommandRunning = true;
        readyForNextCommand = false;
        cancelPINEntry = false;
        this.waitForNotification();
        int loopNum = 0;
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)98, (byte)4, data)), 0, respData);
            ++loopNum;
            if (r == TaskManager.TaskStartRet.SUCCESS) {
                if (respData.resData == null) {
                    isCommandRunning = false;
                    readyForNextCommand = true;
                    respData.statusCode = 21;
                    return 21;
                }
                if (respData.resData.length == 1 && respData.resData[0] == 0) {
                    isCommandRunning = false;
                    readyForNextCommand = true;
                    respData.statusCode = 3;
                    return 3;
                }
                rt = 9;
                int len = respData.resData.length;
                if (len > 11) {
                    rt = respData.resData[11];
                    cmd = respData.resData[10];
                    if (cmd == -18 && rt == -16) break;
                    if (rt != 0) {
                        rt = 9;
                    }
                }
            }
            if (loopNum >= maxLoopNum || rt == 0 && cmd == 98) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException len) {
                // empty catch block
            }
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != 98));
        if (rt == 0) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    IDT_Device.this.readPINData(0);
                }
            }).start();
        } else {
            isCommandRunning = false;
            readyForNextCommand = true;
        }
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int lcd_resetInitialState() {
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        int cmd = 0;
        int rt = 9;
        isCommandRunning = true;
        this.waitForNotification();
        ResDataStruct respData = new ResDataStruct();
        int loopNum = 0;
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-125, (byte)1, new byte[0])), 0, respData);
            ++loopNum;
            if (r != TaskManager.TaskStartRet.SUCCESS) continue;
            if (respData.resData == null) {
                isCommandRunning = false;
                respData.statusCode = 21;
                return 21;
            }
            if (respData.resData.length == 1 && respData.resData[0] == 0) {
                isCommandRunning = false;
                respData.statusCode = 3;
                return 3;
            }
            rt = 9;
            int len = respData.resData.length;
            if (len <= 11) continue;
            rt = respData.resData[11];
            cmd = respData.resData[10];
            if (cmd == -18 && rt == -16) break;
            if (rt == 0) continue;
            rt = 9;
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != -125));
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int lcd_customDisplayMode(boolean enable) {
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        int cmd = 0;
        int rt = 9;
        isCommandRunning = true;
        this.waitForNotification();
        ResDataStruct respData = new ResDataStruct();
        int loopNum = 0;
        do {
            r = enable ? this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-125, (byte)8, new byte[0])), 0, respData) : this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-125, (byte)9, new byte[0])), 0, respData);
            ++loopNum;
            if (r != TaskManager.TaskStartRet.SUCCESS) continue;
            if (respData.resData == null) {
                isCommandRunning = false;
                respData.statusCode = 21;
                return 21;
            }
            if (respData.resData.length == 1 && respData.resData[0] == 0) {
                isCommandRunning = false;
                respData.statusCode = 3;
                return 3;
            }
            rt = 9;
            int len = respData.resData.length;
            if (len <= 11) continue;
            rt = respData.resData[11];
            cmd = respData.resData[10];
            if (cmd == -18 && rt == -16) break;
            if (rt == 0) continue;
            rt = 9;
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != -125));
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int lcd_setForeBackColor(byte[] foreRGB, byte[] backRGB) {
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (foreRGB == null || foreRGB.length != 3 || backRGB == null || backRGB.length != 3) {
            return 27392;
        }
        int cmd = 0;
        int rt = 9;
        isCommandRunning = true;
        this.waitForNotification();
        int loopNum = 0;
        ResDataStruct respData = new ResDataStruct();
        byte[] data = new byte[]{0, foreRGB[0], foreRGB[1], foreRGB[2], 0, backRGB[0], backRGB[1], backRGB[2]};
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-125, (byte)10, data)), 0, respData);
            ++loopNum;
            if (r != TaskManager.TaskStartRet.SUCCESS) continue;
            if (respData.resData == null) {
                isCommandRunning = false;
                respData.statusCode = 21;
                return 21;
            }
            if (respData.resData.length == 1 && respData.resData[0] == 0) {
                isCommandRunning = false;
                respData.statusCode = 3;
                return 3;
            }
            rt = 9;
            int len = respData.resData.length;
            if (len <= 11) continue;
            rt = respData.resData[11];
            cmd = respData.resData[10];
            if (cmd == -18 && rt == -16) break;
            if (rt == 0) continue;
            rt = 9;
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != -125));
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int lcd_clearDisplay() {
        TaskManager.TaskStartRet r;
        ResDataStruct respData;
        block10: {
            int len;
            int loopNum;
            int rt;
            int cmd;
            block11: {
                if (!readyForNextCommand || !readyForCardSwipe) {
                    return 29696;
                }
                if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT) {
                    return 20;
                }
                if (!this.device_isConnected()) {
                    return 1;
                }
                cmd = 0;
                rt = 9;
                isCommandRunning = true;
                this.waitForNotification();
                respData = new ResDataStruct();
                loopNum = 0;
                if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) break block11;
                do {
                    r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-125, (byte)13, new byte[0])), 0, respData);
                    ++loopNum;
                    if (r != TaskManager.TaskStartRet.SUCCESS) continue;
                    if (respData.resData == null) {
                        isCommandRunning = false;
                        respData.statusCode = 21;
                        return 21;
                    }
                    if (respData.resData.length == 1 && respData.resData[0] == 0) {
                        isCommandRunning = false;
                        respData.statusCode = 3;
                        return 3;
                    }
                    rt = 9;
                    len = respData.resData.length;
                    if (len <= 11) continue;
                    rt = respData.resData[11];
                    cmd = respData.resData[10];
                    if (cmd == -18 && rt == -16) break block10;
                    if (rt == 0) continue;
                    rt = 9;
                } while (loopNum < maxLoopNum && (rt != 0 || cmd != -125));
                break block10;
                {
                }
            }
            do {
                r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-16, (byte)-7, new byte[0])), 0, respData);
                ++loopNum;
                if (r != TaskManager.TaskStartRet.SUCCESS) continue;
                if (respData.resData == null) {
                    isCommandRunning = false;
                    respData.statusCode = 21;
                    return 21;
                }
                if (respData.resData.length == 1 && respData.resData[0] == 0) {
                    isCommandRunning = false;
                    respData.statusCode = 3;
                    return 3;
                }
                rt = 9;
                len = respData.resData.length;
                if (len <= 11) continue;
                rt = respData.resData[11];
                cmd = respData.resData[10];
                if (cmd == -18 && rt == -16) break;
                if (rt == 0) continue;
                rt = 9;
            } while (loopNum < maxLoopNum && (rt != 0 || cmd != -16));
        }
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int lcd_captureSignature(int timeout) {
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        int cmd = 0;
        int rt = 9;
        isCommandRunning = true;
        this.waitForNotification();
        ResDataStruct respData = new ResDataStruct();
        int loopNum = 0;
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-125, (byte)2, new byte[]{(byte)timeout, 2})), 0, respData);
            ++loopNum;
            if (r != TaskManager.TaskStartRet.SUCCESS) continue;
            if (respData.resData == null) {
                isCommandRunning = false;
                respData.statusCode = 21;
                return 21;
            }
            if (respData.resData.length == 1 && respData.resData[0] == 0) {
                isCommandRunning = false;
                respData.statusCode = 3;
                return 3;
            }
            rt = 9;
            int len = respData.resData.length;
            if (len <= 11) continue;
            rt = respData.resData[11];
            cmd = respData.resData[10];
            if (cmd == -18 && rt == -16) break;
            if (rt == 0) continue;
            rt = 9;
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != -125));
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int lcd_startSlideShow(String files, int posX, int posY, int posMode, boolean touchEnable, boolean recursion, boolean touchTerminate, int delay, int loops, boolean clearScreen) {
        TaskManager.TaskStartRet r;
        String modeString;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (files == null || files.length() < 1 || files.length() > 3999) {
            return 27392;
        }
        if (posX < 0 || posX > 271 || posY < 0 || posY > 479) {
            return 27392;
        }
        int cmd = 0;
        int rt = 9;
        int mode = 2 * posMode;
        if (clearScreen) {
            ++mode;
        }
        if (touchEnable) {
            mode += 8;
        }
        if (recursion) {
            mode += 16;
        }
        if (touchTerminate) {
            mode += 32;
        }
        if ((modeString = Integer.toHexString(mode)).length() == 1) {
            modeString = "0" + modeString;
        }
        byte[] tmpData = new byte[files.length() + 22];
        int idx = 0;
        String temp = Integer.toString(posX).toUpperCase(Locale.US);
        char[] tmp = temp.toCharArray();
        System.arraycopy(tmp, 0, tmpData, idx, tmp.length);
        idx += tmp.length;
        tmpData[idx++] = 0;
        temp = Integer.toString(posY).toUpperCase(Locale.US);
        tmp = temp.toCharArray();
        System.arraycopy(tmp, 0, tmpData, idx, tmp.length);
        idx += tmp.length;
        tmpData[idx++] = 0;
        temp = modeString.toUpperCase(Locale.US);
        tmp = temp.toCharArray();
        System.arraycopy(tmp, 0, tmpData, idx, tmp.length);
        idx += tmp.length;
        tmpData[idx++] = 0;
        temp = Integer.toString(delay).toUpperCase(Locale.US);
        tmp = temp.toCharArray();
        System.arraycopy(tmp, 0, tmpData, idx, tmp.length);
        idx += tmp.length;
        tmpData[idx++] = 0;
        temp = Integer.toString(loops).toUpperCase(Locale.US);
        tmp = temp.toCharArray();
        System.arraycopy(tmp, 0, tmpData, idx, tmp.length);
        idx += tmp.length;
        tmpData[idx++] = 0;
        tmp = files.toCharArray();
        System.arraycopy(tmp, 0, tmpData, idx, tmp.length);
        idx += tmp.length;
        tmpData[idx++] = 0;
        byte[] data = new byte[idx];
        System.arraycopy(tmpData, 0, data, 0, idx);
        isCommandRunning = true;
        this.waitForNotification();
        ResDataStruct respData = new ResDataStruct();
        int loopNum = 0;
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-125, (byte)32, data)), 0, respData);
            ++loopNum;
            if (r != TaskManager.TaskStartRet.SUCCESS) continue;
            if (respData.resData == null) {
                isCommandRunning = false;
                respData.statusCode = 21;
                return 21;
            }
            if (respData.resData.length == 1 && respData.resData[0] == 0) {
                isCommandRunning = false;
                respData.statusCode = 3;
                return 3;
            }
            rt = 9;
            int len = respData.resData.length;
            if (len <= 11) continue;
            rt = respData.resData[11];
            cmd = respData.resData[10];
            if (cmd == -18 && rt == -16) break;
            if (rt == 0) continue;
            rt = 9;
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != -125));
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int lcd_cancelSlideShow(ResDataStruct respData) {
        TaskManager.TaskStartRet r;
        if (respData == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            respData.statusCode = 29696;
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
            respData.statusCode = 20;
            return 20;
        }
        if (!this.device_isConnected()) {
            respData.statusCode = 1;
            return 1;
        }
        int cmd = 0;
        int rt = 9;
        isCommandRunning = true;
        this.waitForNotification();
        int loopNum = 0;
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-125, (byte)33, new byte[0])), 0, respData);
            ++loopNum;
            if (r != TaskManager.TaskStartRet.SUCCESS) continue;
            if (respData.resData == null) {
                isCommandRunning = false;
                respData.statusCode = 21;
                return 21;
            }
            if (respData.resData.length == 1 && respData.resData[0] == 0) {
                isCommandRunning = false;
                respData.statusCode = 3;
                return 3;
            }
            rt = 9;
            int len = respData.resData.length;
            if (len <= 11) continue;
            rt = respData.resData[11];
            cmd = respData.resData[10];
            if (cmd == -18 && rt == -16) break;
            if (rt == 0) continue;
            rt = 9;
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != -125));
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int lcd_setDisplayImage(String files, int posX, int posY, int posMode, boolean touchEnable, boolean clearScreen) {
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (files == null || files.length() < 1 || files.length() > 127) {
            return 27392;
        }
        if (posX < 0 || posX > 271 || posY < 0 || posY > 479) {
            return 27392;
        }
        int cmd = 0;
        int rt = 9;
        int mode = 2 * posMode;
        if (clearScreen) {
            ++mode;
        }
        if (touchEnable) {
            mode += 8;
        }
        String modeString = Integer.toHexString(mode);
        byte[] tmpData = new byte[files.length() + 11];
        int idx = 0;
        String temp = Integer.toString(posX).toUpperCase(Locale.US);
        char[] tmp = temp.toCharArray();
        System.arraycopy(tmp, 0, tmpData, idx, tmp.length);
        idx += tmp.length;
        tmpData[idx++] = 0;
        temp = Integer.toString(posY).toUpperCase(Locale.US);
        tmp = temp.toCharArray();
        System.arraycopy(tmp, 0, tmpData, idx, tmp.length);
        idx += tmp.length;
        tmpData[idx++] = 0;
        temp = modeString.toUpperCase(Locale.US);
        tmp = temp.toCharArray();
        System.arraycopy(tmp, 0, tmpData, idx, tmp.length);
        idx += tmp.length;
        tmpData[idx++] = 0;
        tmp = files.toCharArray();
        System.arraycopy(tmp, 0, tmpData, idx, tmp.length);
        idx += tmp.length;
        tmpData[idx++] = 0;
        byte[] data = new byte[idx];
        System.arraycopy(tmpData, 0, data, 0, idx);
        isCommandRunning = true;
        this.waitForNotification();
        ResDataStruct respData = new ResDataStruct();
        int loopNum = 0;
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-125, (byte)14, data)), 0, respData);
            ++loopNum;
            if (r != TaskManager.TaskStartRet.SUCCESS) continue;
            if (respData.resData == null) {
                isCommandRunning = false;
                respData.statusCode = 21;
                return 21;
            }
            if (respData.resData.length == 1 && respData.resData[0] == 0) {
                isCommandRunning = false;
                respData.statusCode = 3;
                return 3;
            }
            rt = 9;
            int len = respData.resData.length;
            if (len <= 11) continue;
            rt = respData.resData[11];
            cmd = respData.resData[10];
            if (cmd == -18 && rt == -16) break;
            if (rt == 0) continue;
            rt = 9;
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != -125));
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int lcd_setBackgroundImage(String files, boolean enable) {
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (files == null || files.length() < 1 || files.length() > 127) {
            return 27392;
        }
        int cmd = 0;
        int rt = 9;
        byte[] tmpData = new byte[files.length() + 3];
        tmpData[1] = 0;
        int idx = 0;
        if (enable) {
            tmpData[0] = 49;
            idx = 2;
            char[] tmp = files.toCharArray();
            System.arraycopy(tmp, 0, tmpData, idx, tmp.length);
            idx += tmp.length;
            tmpData[idx++] = 0;
        } else {
            tmpData[0] = 48;
            idx = 2;
        }
        byte[] data = new byte[idx];
        System.arraycopy(tmpData, 0, data, 0, idx);
        isCommandRunning = true;
        this.waitForNotification();
        ResDataStruct respData = new ResDataStruct();
        int loopNum = 0;
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-125, (byte)41, data)), 0, respData);
            ++loopNum;
            if (r != TaskManager.TaskStartRet.SUCCESS) continue;
            if (respData.resData == null) {
                isCommandRunning = false;
                respData.statusCode = 21;
                return 21;
            }
            if (respData.resData.length == 1 && respData.resData[0] == 0) {
                isCommandRunning = false;
                respData.statusCode = 3;
                return 3;
            }
            rt = 9;
            int len = respData.resData.length;
            if (len <= 11) continue;
            rt = respData.resData[11];
            cmd = respData.resData[10];
            if (cmd == -18 && rt == -16) break;
            if (rt == 0) continue;
            rt = 9;
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != -125));
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int lcd_displayText(int posX, int posY, int displayWidth, int displayHeight, int fontDesignation, int fontID, int screenPosition, String displayText, ResDataStruct respData) {
        TaskManager.TaskStartRet r;
        if (respData == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            respData.statusCode = 29696;
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
            respData.statusCode = 20;
            return 20;
        }
        if (!this.device_isConnected()) {
            respData.statusCode = 1;
            return 1;
        }
        if (displayText == null || displayText.length() < 1 || displayText.length() > 1900) {
            respData.statusCode = 27392;
            return 27392;
        }
        if (posX < 0 || posX > 271 || posY < 0 || posY > 479 || fontDesignation < 0 || fontID < 0 || fontID > 18 || screenPosition < 0 || screenPosition > 7) {
            respData.statusCode = 27392;
            return 27392;
        }
        int cmd = 0;
        int rt = 9;
        byte[] tmpData = new byte[displayText.length() + 28];
        int idx = 0;
        String temp = Integer.toString(posX).toUpperCase(Locale.US);
        char[] tmp = temp.toCharArray();
        System.arraycopy(tmp, 0, tmpData, idx, tmp.length);
        idx += tmp.length;
        tmpData[idx++] = 0;
        temp = Integer.toString(posY).toUpperCase(Locale.US);
        tmp = temp.toCharArray();
        System.arraycopy(tmp, 0, tmpData, idx, tmp.length);
        idx += tmp.length;
        tmpData[idx++] = 0;
        temp = Integer.toString(displayWidth).toUpperCase(Locale.US);
        tmp = temp.toCharArray();
        System.arraycopy(tmp, 0, tmpData, idx, tmp.length);
        idx += tmp.length;
        tmpData[idx++] = 0;
        temp = Integer.toString(displayHeight).toUpperCase(Locale.US);
        tmp = temp.toCharArray();
        System.arraycopy(tmp, 0, tmpData, idx, tmp.length);
        idx += tmp.length;
        tmpData[idx++] = 0;
        temp = Integer.toString(fontDesignation).toUpperCase(Locale.US);
        tmp = temp.toCharArray();
        System.arraycopy(tmp, 0, tmpData, idx, tmp.length);
        idx += tmp.length;
        tmpData[idx++] = 0;
        temp = Integer.toString(fontID).toUpperCase(Locale.US);
        tmp = temp.toCharArray();
        System.arraycopy(tmp, 0, tmpData, idx, tmp.length);
        idx += tmp.length;
        tmpData[idx++] = 0;
        temp = Integer.toString(screenPosition).toUpperCase(Locale.US);
        tmp = temp.toCharArray();
        System.arraycopy(tmp, 0, tmpData, idx, tmp.length);
        idx += tmp.length;
        tmpData[idx++] = 0;
        tmp = displayText.toCharArray();
        System.arraycopy(tmp, 0, tmpData, idx, tmp.length);
        idx += tmp.length;
        tmpData[idx++] = 0;
        byte[] data = new byte[idx];
        System.arraycopy(tmpData, 0, data, 0, idx);
        isCommandRunning = true;
        this.waitForNotification();
        int loopNum = 0;
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-125, (byte)3, data)), 0, respData);
            ++loopNum;
            if (r != TaskManager.TaskStartRet.SUCCESS) continue;
            if (respData.resData == null) {
                isCommandRunning = false;
                respData.statusCode = 21;
                return 21;
            }
            if (respData.resData.length == 1 && respData.resData[0] == 0) {
                isCommandRunning = false;
                respData.statusCode = 3;
                return 3;
            }
            rt = 9;
            int len = respData.resData.length;
            if (len <= 11) continue;
            rt = respData.resData[11];
            cmd = respData.resData[10];
            if (cmd == -18 && rt == -16) break;
            if (rt == 0) continue;
            rt = 9;
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != -125));
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int lcd_displayParagraph(int posX, int posY, int displayWidth, int displayHeight, int fontDesignation, int fontID, int displayProperties, String displayText) {
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (displayText == null || displayText.length() < 1 || displayText.length() > 1900) {
            return 27392;
        }
        if (posX < 0 || posX > 271 || posY < 0 || posY > 479 || fontDesignation < 0 || fontID < 0 || fontID > 18 || displayProperties < 0 || displayProperties > 5) {
            return 27392;
        }
        int cmd = 0;
        int rt = 9;
        byte[] tmpData = new byte[displayText.length() + 28];
        int idx = 0;
        String temp = Integer.toString(posX).toUpperCase(Locale.US);
        char[] tmp = temp.toCharArray();
        System.arraycopy(tmp, 0, tmpData, idx, tmp.length);
        idx += tmp.length;
        tmpData[idx++] = 0;
        temp = Integer.toString(posY).toUpperCase(Locale.US);
        tmp = temp.toCharArray();
        System.arraycopy(tmp, 0, tmpData, idx, tmp.length);
        idx += tmp.length;
        tmpData[idx++] = 0;
        temp = Integer.toString(displayWidth).toUpperCase(Locale.US);
        tmp = temp.toCharArray();
        System.arraycopy(tmp, 0, tmpData, idx, tmp.length);
        idx += tmp.length;
        tmpData[idx++] = 0;
        temp = Integer.toString(displayHeight).toUpperCase(Locale.US);
        tmp = temp.toCharArray();
        System.arraycopy(tmp, 0, tmpData, idx, tmp.length);
        idx += tmp.length;
        tmpData[idx++] = 0;
        temp = Integer.toString(fontDesignation).toUpperCase(Locale.US);
        tmp = temp.toCharArray();
        System.arraycopy(tmp, 0, tmpData, idx, tmp.length);
        idx += tmp.length;
        tmpData[idx++] = 0;
        temp = Integer.toString(fontID).toUpperCase(Locale.US);
        tmp = temp.toCharArray();
        System.arraycopy(tmp, 0, tmpData, idx, tmp.length);
        idx += tmp.length;
        tmpData[idx++] = 0;
        temp = Integer.toString(displayProperties).toUpperCase(Locale.US);
        tmp = temp.toCharArray();
        System.arraycopy(tmp, 0, tmpData, idx, tmp.length);
        idx += tmp.length;
        tmpData[idx++] = 0;
        tmp = displayText.toCharArray();
        System.arraycopy(tmp, 0, tmpData, idx, tmp.length);
        idx += tmp.length;
        tmpData[idx++] = 0;
        byte[] data = new byte[idx];
        System.arraycopy(tmpData, 0, data, 0, idx);
        ResDataStruct respData = new ResDataStruct();
        isCommandRunning = true;
        this.waitForNotification();
        int loopNum = 0;
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-125, (byte)40, data)), 0, respData);
            ++loopNum;
            if (r != TaskManager.TaskStartRet.SUCCESS) continue;
            if (respData.resData == null) {
                isCommandRunning = false;
                respData.statusCode = 21;
                return 21;
            }
            if (respData.resData.length == 1 && respData.resData[0] == 0) {
                isCommandRunning = false;
                respData.statusCode = 3;
                return 3;
            }
            rt = 9;
            int len = respData.resData.length;
            if (len <= 11) continue;
            rt = respData.resData[11];
            cmd = respData.resData[10];
            if (cmd == -18 && rt == -16) break;
            if (rt == 0) continue;
            rt = 9;
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != -125));
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int lcd_displayButton(int posX, int posY, int buttonWidth, int buttonHeight, int fontDesignation, int fontID, int displayPosition, String buttonLabel, int buttonTextColorR, int buttonTextColorG, int buttonTextColorB, int buttonBackgroundColorR, int buttonBackgroundColorG, int buttonBackgroundColorB, ResDataStruct respData) {
        TaskManager.TaskStartRet r;
        if (respData == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            respData.statusCode = 29696;
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
            respData.statusCode = 20;
            return 20;
        }
        if (!this.device_isConnected()) {
            respData.statusCode = 1;
            return 1;
        }
        if (buttonLabel == null || buttonLabel.length() > 31) {
            respData.statusCode = 27392;
            return 27392;
        }
        if (posX < 0 || posX > 271 || posY < 0 || posY > 479 || fontDesignation < 0 || fontID < 0 || fontID > 18 || buttonWidth < 0 || buttonHeight < 0 || displayPosition < 0) {
            respData.statusCode = 27392;
            return 27392;
        }
        if (buttonTextColorR < 0 || buttonTextColorR > 255 || buttonTextColorG < 0 || buttonTextColorG > 255 || buttonTextColorB < 0 || buttonTextColorB > 255 || buttonBackgroundColorR < 0 || buttonBackgroundColorR > 255 || buttonBackgroundColorG < 0 || buttonBackgroundColorG > 255 || buttonBackgroundColorB < 0 || buttonBackgroundColorB > 255) {
            respData.statusCode = 27392;
            return 27392;
        }
        int cmd = 0;
        int rt = 9;
        byte[] tmpData = new byte[buttonLabel.length() + 100];
        int idx = 0;
        String temp = Integer.toString(posX).toUpperCase(Locale.US);
        char[] tmp = temp.toCharArray();
        System.arraycopy(tmp, 0, tmpData, idx, tmp.length);
        idx += tmp.length;
        tmpData[idx++] = 0;
        temp = Integer.toString(posY).toUpperCase(Locale.US);
        tmp = temp.toCharArray();
        System.arraycopy(tmp, 0, tmpData, idx, tmp.length);
        idx += tmp.length;
        tmpData[idx++] = 0;
        temp = Integer.toString(buttonWidth).toUpperCase(Locale.US);
        tmp = temp.toCharArray();
        System.arraycopy(tmp, 0, tmpData, idx, tmp.length);
        idx += tmp.length;
        tmpData[idx++] = 0;
        temp = Integer.toString(buttonHeight).toUpperCase(Locale.US);
        tmp = temp.toCharArray();
        System.arraycopy(tmp, 0, tmpData, idx, tmp.length);
        idx += tmp.length;
        tmpData[idx++] = 0;
        temp = Integer.toString(fontDesignation).toUpperCase(Locale.US);
        tmp = temp.toCharArray();
        System.arraycopy(tmp, 0, tmpData, idx, tmp.length);
        idx += tmp.length;
        tmpData[idx++] = 0;
        temp = Integer.toString(fontID).toUpperCase(Locale.US);
        tmp = temp.toCharArray();
        System.arraycopy(tmp, 0, tmpData, idx, tmp.length);
        idx += tmp.length;
        tmpData[idx++] = 0;
        temp = Integer.toString(displayPosition).toUpperCase(Locale.US);
        tmp = temp.toCharArray();
        System.arraycopy(tmp, 0, tmpData, idx, tmp.length);
        idx += tmp.length;
        tmpData[idx++] = 0;
        if (buttonLabel.length() > 0) {
            tmp = buttonLabel.toCharArray();
            System.arraycopy(tmp, 0, tmpData, idx, tmp.length);
            idx += tmp.length;
        }
        tmpData[idx++] = 0;
        tmpData[idx++] = (byte)buttonTextColorR;
        tmpData[idx++] = (byte)buttonTextColorG;
        tmpData[idx++] = (byte)buttonTextColorB;
        tmpData[idx++] = 0;
        tmpData[idx++] = (byte)buttonBackgroundColorR;
        tmpData[idx++] = (byte)buttonBackgroundColorG;
        tmpData[idx++] = (byte)buttonBackgroundColorB;
        tmpData[idx++] = 0;
        byte[] data = new byte[idx];
        System.arraycopy(tmpData, 0, data, 0, idx);
        isCommandRunning = true;
        this.waitForNotification();
        int loopNum = 0;
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-125, (byte)5, data)), 0, respData);
            ++loopNum;
            if (r != TaskManager.TaskStartRet.SUCCESS) continue;
            if (respData.resData == null) {
                isCommandRunning = false;
                respData.statusCode = 21;
                return 21;
            }
            if (respData.resData.length == 1 && respData.resData[0] == 0) {
                isCommandRunning = false;
                respData.statusCode = 3;
                return 3;
            }
            rt = 9;
            int len = respData.resData.length;
            if (len <= 11) continue;
            rt = respData.resData[11];
            cmd = respData.resData[10];
            if (cmd == -18 && rt == -16) break;
            if (rt == 0) continue;
            rt = 9;
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != -125));
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int lcd_createList(int posX, int posY, int numOfColumns, int numOfRows, int fontDesignation, int fontID, boolean verticalScrollArrowsVisible, boolean borderedListItems, boolean borderdScrollArrows, boolean touchSensitive, boolean automaticScrolling, ResDataStruct respData) {
        TaskManager.TaskStartRet r;
        if (respData == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            respData.statusCode = 29696;
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
            respData.statusCode = 20;
            return 20;
        }
        if (!this.device_isConnected()) {
            respData.statusCode = 1;
            return 1;
        }
        if (posX < 0 || posX > 271 || posY < 0 || posY > 479 || fontDesignation < 0 || fontID < 0 || fontID > 18 || numOfColumns < 0 || numOfRows < 0) {
            respData.statusCode = 27392;
            return 27392;
        }
        int cmd = 0;
        int rt = 9;
        byte[] tmpData = new byte[20];
        int displayOptions = automaticScrolling ? 1 : 0;
        displayOptions <<= 1;
        displayOptions += touchSensitive ? 1 : 0;
        displayOptions <<= 1;
        displayOptions += borderdScrollArrows ? 1 : 0;
        displayOptions <<= 1;
        displayOptions += borderedListItems ? 1 : 0;
        displayOptions <<= 1;
        displayOptions += verticalScrollArrowsVisible ? 1 : 0;
        int idx = 0;
        String temp = Integer.toString(posX).toUpperCase(Locale.US);
        char[] tmp = temp.toCharArray();
        System.arraycopy(tmp, 0, tmpData, idx, tmp.length);
        idx += tmp.length;
        tmpData[idx++] = 0;
        temp = Integer.toString(posY).toUpperCase(Locale.US);
        tmp = temp.toCharArray();
        System.arraycopy(tmp, 0, tmpData, idx, tmp.length);
        idx += tmp.length;
        tmpData[idx++] = 0;
        temp = Integer.toString(numOfColumns).toUpperCase(Locale.US);
        tmp = temp.toCharArray();
        System.arraycopy(tmp, 0, tmpData, idx, tmp.length);
        idx += tmp.length;
        tmpData[idx++] = 0;
        temp = Integer.toString(numOfRows).toUpperCase(Locale.US);
        tmp = temp.toCharArray();
        System.arraycopy(tmp, 0, tmpData, idx, tmp.length);
        idx += tmp.length;
        tmpData[idx++] = 0;
        temp = Integer.toString(fontDesignation).toUpperCase(Locale.US);
        tmp = temp.toCharArray();
        System.arraycopy(tmp, 0, tmpData, idx, tmp.length);
        idx += tmp.length;
        tmpData[idx++] = 0;
        temp = Integer.toString(fontID).toUpperCase(Locale.US);
        tmp = temp.toCharArray();
        System.arraycopy(tmp, 0, tmpData, idx, tmp.length);
        idx += tmp.length;
        tmpData[idx++] = 0;
        tmpData[idx++] = 0;
        tmpData[idx++] = 0;
        tmpData[idx++] = 0;
        tmpData[idx++] = (byte)displayOptions;
        byte[] data = new byte[idx];
        System.arraycopy(tmpData, 0, data, 0, idx);
        isCommandRunning = true;
        this.waitForNotification();
        int loopNum = 0;
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-125, (byte)16, data)), 0, respData);
            ++loopNum;
            if (r != TaskManager.TaskStartRet.SUCCESS) continue;
            if (respData.resData == null) {
                isCommandRunning = false;
                respData.statusCode = 21;
                return 21;
            }
            if (respData.resData.length == 1 && respData.resData[0] == 0) {
                isCommandRunning = false;
                respData.statusCode = 3;
                return 3;
            }
            rt = 9;
            int len = respData.resData.length;
            if (len <= 11) continue;
            rt = respData.resData[11];
            cmd = respData.resData[10];
            if (cmd == -18 && rt == -16) break;
            if (rt == 0) continue;
            rt = 9;
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != -125));
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int lcd_addItemToList(byte[] listGraphicsID, String itemName, String itemID, boolean selected) {
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (listGraphicsID == null || listGraphicsID.length != 4 || itemName == null || itemName.length() < 1 || itemName.length() > 127) {
            return 27392;
        }
        if (itemID == null || itemID.length() < 1 || itemID.length() > 31) {
            return 27392;
        }
        int cmd = 0;
        int rt = 9;
        byte[] tmpData = new byte[itemName.length() + itemID.length() + 20];
        int idx = 0;
        System.arraycopy(listGraphicsID, 0, tmpData, idx, listGraphicsID.length);
        char[] tmp = itemName.toCharArray();
        System.arraycopy(tmp, 0, tmpData, idx += listGraphicsID.length, tmp.length);
        idx += tmp.length;
        tmpData[idx++] = 0;
        tmp = itemID.toCharArray();
        System.arraycopy(tmp, 0, tmpData, idx, tmp.length);
        idx += tmp.length;
        tmpData[idx++] = 0;
        tmpData[idx++] = 0;
        tmpData[idx++] = 0;
        tmpData[idx++] = 0;
        tmpData[idx++] = (byte)(selected ? 1 : 0);
        byte[] data = new byte[idx];
        System.arraycopy(tmpData, 0, data, 0, idx);
        ResDataStruct respData = new ResDataStruct();
        isCommandRunning = true;
        this.waitForNotification();
        int loopNum = 0;
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-125, (byte)17, data)), 0, respData);
            ++loopNum;
            if (r != TaskManager.TaskStartRet.SUCCESS) continue;
            if (respData.resData == null) {
                isCommandRunning = false;
                respData.statusCode = 21;
                return 21;
            }
            if (respData.resData.length == 1 && respData.resData[0] == 0) {
                isCommandRunning = false;
                respData.statusCode = 3;
                return 3;
            }
            rt = 9;
            int len = respData.resData.length;
            if (len <= 11) continue;
            rt = respData.resData[11];
            cmd = respData.resData[10];
            if (cmd == -18 && rt == -16) break;
            if (rt == 0) continue;
            rt = 9;
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != -125));
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int lcd_getSelectedListItem(byte[] listGraphicsID, String itemID, ResDataStruct respData) {
        TaskManager.TaskStartRet r;
        if (respData == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            respData.statusCode = 29696;
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
            respData.statusCode = 20;
            return 20;
        }
        if (!this.device_isConnected()) {
            respData.statusCode = 1;
            return 1;
        }
        if (listGraphicsID == null || listGraphicsID.length != 4) {
            respData.statusCode = 27392;
            return 27392;
        }
        if (itemID == null || itemID.length() < 1 || itemID.length() > 31) {
            respData.statusCode = 27392;
            return 27392;
        }
        int cmd = 0;
        int rt = 9;
        isCommandRunning = true;
        this.waitForNotification();
        int loopNum = 0;
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-125, (byte)21, listGraphicsID)), 0, respData);
            ++loopNum;
            if (r != TaskManager.TaskStartRet.SUCCESS) continue;
            if (respData.resData == null) {
                isCommandRunning = false;
                respData.statusCode = 21;
                return 21;
            }
            if (respData.resData.length == 1 && respData.resData[0] == 0) {
                isCommandRunning = false;
                respData.statusCode = 3;
                return 3;
            }
            rt = 9;
            int len = respData.resData.length;
            if (len <= 11) continue;
            rt = respData.resData[11];
            cmd = respData.resData[10];
            if (cmd == -18 && rt == -16) break;
            if (rt == 0) continue;
            rt = 9;
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != -125));
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        if (respData.resData != null && respData.resData.length > 0) {
            respData.stringArray = new String[1];
            char[] ch = new char[respData.resData.length];
            System.arraycopy(respData.resData, 0, ch, 0, ch.length);
            respData.stringArray[0] = ch.toString();
        }
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int lcd_clearEventQueue() {
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        int cmd = 0;
        int rt = 9;
        ResDataStruct respData = new ResDataStruct();
        isCommandRunning = true;
        this.waitForNotification();
        int loopNum = 0;
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-125, (byte)12, new byte[0])), 0, respData);
            ++loopNum;
            if (r != TaskManager.TaskStartRet.SUCCESS) continue;
            if (respData.resData == null) {
                isCommandRunning = false;
                respData.statusCode = 21;
                return 21;
            }
            if (respData.resData.length == 1 && respData.resData[0] == 0) {
                isCommandRunning = false;
                respData.statusCode = 3;
                return 3;
            }
            rt = 9;
            int len = respData.resData.length;
            if (len <= 11) continue;
            rt = respData.resData[11];
            cmd = respData.resData[10];
            if (cmd == -18 && rt == -16) break;
            if (rt == 0) continue;
            rt = 9;
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != -125));
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int lcd_getInputEvent(int timeout, ResDataStruct respData) {
        TaskManager.TaskStartRet r;
        if (respData == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            respData.statusCode = 29696;
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
            respData.statusCode = 20;
            return 20;
        }
        if (!this.device_isConnected()) {
            respData.statusCode = 1;
            return 1;
        }
        if (timeout < 0 || timeout > 255) {
            respData.statusCode = 27392;
            return 27392;
        }
        int cmd = 0;
        int rt = 9;
        isCommandRunning = true;
        this.waitForNotification();
        int loopNum = 0;
        respData.ret = 0;
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-125, (byte)6, new byte[]{(byte)timeout})), 0, respData);
            ++loopNum;
            if (r != TaskManager.TaskStartRet.SUCCESS) continue;
            if (respData.resData == null) {
                isCommandRunning = false;
                respData.statusCode = 21;
                return 21;
            }
            if (respData.resData.length == 1 && respData.resData[0] == 0) {
                isCommandRunning = false;
                respData.statusCode = 3;
                return 3;
            }
            rt = 9;
            int len = respData.resData.length;
            if (len <= 11) continue;
            rt = respData.resData[11];
            cmd = respData.resData[10];
            if (cmd == -18 && rt == -16) break;
            if (rt == 0) continue;
            rt = 9;
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != -125));
        if (rt == 0) {
            respData.ret = 1;
        }
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int lcd_createInputField(byte[] specs, ResDataStruct respData) {
        TaskManager.TaskStartRet r;
        if (respData == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            respData.statusCode = 29696;
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
            respData.statusCode = 20;
            return 20;
        }
        if (!this.device_isConnected()) {
            respData.statusCode = 1;
            return 1;
        }
        int cmd = 0;
        int rt = 9;
        isCommandRunning = true;
        this.waitForNotification();
        int loopNum = 0;
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-125, (byte)28, specs == null ? new byte[]{} : specs)), 0, respData);
            ++loopNum;
            if (r != TaskManager.TaskStartRet.SUCCESS) continue;
            if (respData.resData == null) {
                isCommandRunning = false;
                respData.statusCode = 21;
                return 21;
            }
            if (respData.resData.length == 1 && respData.resData[0] == 0) {
                isCommandRunning = false;
                respData.statusCode = 3;
                return 3;
            }
            rt = 9;
            int len = respData.resData.length;
            if (len <= 11) continue;
            rt = respData.resData[11];
            cmd = respData.resData[10];
            if (cmd == -18 && rt == -16) break;
            if (rt == 0) continue;
            rt = 9;
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != -125));
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int lcd_getInputFieldValue(byte[] listGraphicsID, ResDataStruct respData) {
        TaskManager.TaskStartRet r;
        if (respData == null) {
            return 27392;
        }
        if (!readyForNextCommand || !readyForCardSwipe) {
            respData.statusCode = 29696;
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
            respData.statusCode = 20;
            return 20;
        }
        if (!this.device_isConnected()) {
            respData.statusCode = 1;
            return 1;
        }
        if (listGraphicsID == null || listGraphicsID.length != 4) {
            respData.statusCode = 27392;
            return 27392;
        }
        int cmd = 0;
        int rt = 9;
        isCommandRunning = true;
        this.waitForNotification();
        int loopNum = 0;
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-125, (byte)29, listGraphicsID)), 0, respData);
            ++loopNum;
            if (r != TaskManager.TaskStartRet.SUCCESS) continue;
            if (respData.resData == null) {
                isCommandRunning = false;
                respData.statusCode = 21;
                return 21;
            }
            if (respData.resData.length == 1 && respData.resData[0] == 0) {
                isCommandRunning = false;
                respData.statusCode = 3;
                return 3;
            }
            rt = 9;
            int len = respData.resData.length;
            if (len <= 11) continue;
            rt = respData.resData[11];
            cmd = respData.resData[10];
            if (cmd == -18 && rt == -16) break;
            if (rt == 0) continue;
            rt = 9;
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != -125));
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        if (respData.resData != null && respData.resData.length > 0) {
            respData.stringArray = new String[1];
            char[] ch = new char[respData.resData.length];
            System.arraycopy(respData.resData, 0, ch, 0, ch.length);
            respData.stringArray[0] = ch.toString();
        }
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int lcd_createScreen(String screenName, IDTLCDData returnItem) {
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (screenName == null || returnItem == null) {
            return 27392;
        }
        int cmd = 0;
        int rt = 9;
        ResDataStruct respData = new ResDataStruct();
        byte[] data = new byte[screenName.length() + 1];
        byte[] ba = screenName.getBytes();
        System.arraycopy(ba, 0, data, 0, screenName.length());
        isCommandRunning = true;
        this.waitForNotification();
        int loopNum = 0;
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)97, (byte)10, data)), 0, respData);
            ++loopNum;
            if (r != TaskManager.TaskStartRet.SUCCESS) continue;
            if (respData.resData == null) {
                isCommandRunning = false;
                respData.statusCode = 21;
                return 21;
            }
            if (respData.resData.length == 1 && respData.resData[0] == 0) {
                isCommandRunning = false;
                respData.statusCode = 3;
                return 3;
            }
            rt = 9;
            int len = respData.resData.length;
            if (len <= 11) continue;
            rt = respData.resData[11];
            cmd = respData.resData[10];
            if (cmd == -18 && rt == -16) break;
            if (rt == 0) continue;
            rt = 9;
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != 97));
        if (respData.resData != null && respData.resData.length > 15) {
            returnItem.screenName = screenName;
            returnItem.screenID = (respData.resData[14] & 0xFF) << 8 | respData.resData[15] & 0xFF;
        }
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int lcd_getActiveScreen(IDTLCDData returnItem) {
        int len;
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (returnItem == null) {
            return 27392;
        }
        int cmd = 0;
        int rt = 9;
        ResDataStruct respData = new ResDataStruct();
        isCommandRunning = true;
        this.waitForNotification();
        int loopNum = 0;
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)97, (byte)12, new byte[0])), 0, respData);
            ++loopNum;
            if (r != TaskManager.TaskStartRet.SUCCESS) continue;
            if (respData.resData == null) {
                isCommandRunning = false;
                respData.statusCode = 21;
                return 21;
            }
            if (respData.resData.length == 1 && respData.resData[0] == 0) {
                isCommandRunning = false;
                respData.statusCode = 3;
                return 3;
            }
            rt = 9;
            len = respData.resData.length;
            if (len <= 11) continue;
            rt = respData.resData[11];
            cmd = respData.resData[10];
            if (cmd == -18 && rt == -16) break;
            if (rt == 0) continue;
            rt = 9;
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != 97));
        returnItem.screenName = null;
        if (respData.resData != null && respData.resData.length > 13) {
            len = (respData.resData[12] & 0xFF) << 8 | respData.resData[13] & 0xFF;
            byte[] ba = new byte[len -= 2];
            System.arraycopy(respData.resData, 16, ba, 0, ba.length);
            returnItem.screenName = new String(ba);
        }
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int lcd_destroyScreen(String screenName) {
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (screenName == null) {
            return 27392;
        }
        int cmd = 0;
        int rt = 9;
        ResDataStruct respData = new ResDataStruct();
        byte[] data = new byte[screenName.length() + 1];
        byte[] ba = screenName.getBytes();
        System.arraycopy(ba, 0, data, 0, screenName.length());
        isCommandRunning = true;
        this.waitForNotification();
        int loopNum = 0;
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)97, (byte)11, data)), 0, respData);
            ++loopNum;
            if (r != TaskManager.TaskStartRet.SUCCESS) continue;
            if (respData.resData == null) {
                isCommandRunning = false;
                respData.statusCode = 21;
                return 21;
            }
            if (respData.resData.length == 1 && respData.resData[0] == 0) {
                isCommandRunning = false;
                respData.statusCode = 3;
                return 3;
            }
            rt = 9;
            int len = respData.resData.length;
            if (len <= 11) continue;
            rt = respData.resData[11];
            cmd = respData.resData[10];
            if (cmd == -18 && rt == -16) break;
            if (rt == 0) continue;
            rt = 9;
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != 97));
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int lcd_showScreen(String screenName) {
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (screenName == null) {
            return 27392;
        }
        int cmd = 0;
        int rt = 9;
        ResDataStruct respData = new ResDataStruct();
        byte[] data = new byte[screenName.length() + 1];
        byte[] ba = screenName.getBytes();
        System.arraycopy(ba, 0, data, 0, screenName.length());
        isCommandRunning = true;
        this.waitForNotification();
        int loopNum = 0;
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)97, (byte)5, data)), 0, respData);
            ++loopNum;
            if (r != TaskManager.TaskStartRet.SUCCESS) continue;
            if (respData.resData == null) {
                isCommandRunning = false;
                respData.statusCode = 21;
                return 21;
            }
            if (respData.resData.length == 1 && respData.resData[0] == 0) {
                isCommandRunning = false;
                respData.statusCode = 3;
                return 3;
            }
            rt = 9;
            int len = respData.resData.length;
            if (len <= 11) continue;
            rt = respData.resData[11];
            cmd = respData.resData[10];
            if (cmd == -18 && rt == -16) break;
            if (rt == 0) continue;
            rt = 9;
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != 97));
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int lcd_cloneScreen(String screenName, String cloneName, IDTLCDData returnItem) {
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (screenName == null || screenName.length() <= 0 || cloneName == null || cloneName.length() <= 0 || returnItem == null) {
            return 27392;
        }
        int cmd = 0;
        int rt = 9;
        ResDataStruct respData = new ResDataStruct();
        byte[] data = new byte[screenName.length() + cloneName.length() + 2];
        byte[] ba = screenName.getBytes();
        byte[] ba1 = cloneName.getBytes();
        System.arraycopy(ba, 0, data, 0, screenName.length());
        System.arraycopy(ba1, 0, data, screenName.length() + 1, cloneName.length());
        isCommandRunning = true;
        this.waitForNotification();
        int loopNum = 0;
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)97, (byte)13, data)), 0, respData);
            ++loopNum;
            if (r != TaskManager.TaskStartRet.SUCCESS) continue;
            if (respData.resData == null) {
                isCommandRunning = false;
                respData.statusCode = 21;
                return 21;
            }
            if (respData.resData.length == 1 && respData.resData[0] == 0) {
                isCommandRunning = false;
                respData.statusCode = 3;
                return 3;
            }
            rt = 9;
            int len = respData.resData.length;
            if (len <= 11) continue;
            rt = respData.resData[11];
            cmd = respData.resData[10];
            if (cmd == -18 && rt == -16) break;
            if (rt == 0) continue;
            rt = 9;
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != 97));
        if (respData.resData.length > 15) {
            returnItem.screenID = (respData.resData[14] & 0xFF) << 8 | respData.resData[15] & 0xFF;
        }
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int lcd_updateLabel(String screenName, String objectName, String label) {
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (screenName == null || screenName.length() <= 0 || objectName == null || objectName.length() <= 0 || label == null || label.length() <= 0) {
            return 27392;
        }
        int cmd = 0;
        int rt = 9;
        ResDataStruct respData = new ResDataStruct();
        byte[] data = new byte[screenName.length() + objectName.length() + label.length() + 4];
        byte[] ba = screenName.getBytes();
        byte[] ba1 = objectName.getBytes();
        byte[] ba2 = label.getBytes();
        System.arraycopy(ba, 0, data, 0, screenName.length());
        System.arraycopy(ba1, 0, data, screenName.length() + 1, objectName.length());
        data[screenName.length() + objectName.length() + 2] = 0;
        System.arraycopy(ba2, 0, data, screenName.length() + objectName.length() + 3, label.length());
        isCommandRunning = true;
        this.waitForNotification();
        int loopNum = 0;
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)97, (byte)8, data)), 0, respData);
            ++loopNum;
            if (r != TaskManager.TaskStartRet.SUCCESS) continue;
            if (respData.resData == null) {
                isCommandRunning = false;
                respData.statusCode = 21;
                return 21;
            }
            if (respData.resData.length == 1 && respData.resData[0] == 0) {
                isCommandRunning = false;
                respData.statusCode = 3;
                return 3;
            }
            rt = 9;
            int len = respData.resData.length;
            if (len <= 11) continue;
            rt = respData.resData[11];
            cmd = respData.resData[10];
            if (cmd == -18 && rt == -16) break;
            if (rt == 0) continue;
            rt = 9;
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != 97));
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int lcd_updateColor(String screenName, String objectName, byte[] color) {
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (screenName == null || screenName.length() <= 0 || objectName == null || objectName.length() <= 0 || color == null || color.length != 4) {
            return 27392;
        }
        int cmd = 0;
        int rt = 9;
        ResDataStruct respData = new ResDataStruct();
        byte[] data = new byte[screenName.length() + objectName.length() + color.length + 3];
        byte[] ba = screenName.getBytes();
        byte[] ba1 = objectName.getBytes();
        System.arraycopy(ba, 0, data, 0, screenName.length());
        System.arraycopy(ba1, 0, data, screenName.length() + 1, objectName.length());
        data[screenName.length() + objectName.length() + 2] = 1;
        System.arraycopy(color, 0, data, screenName.length() + objectName.length() + 3, color.length);
        isCommandRunning = true;
        this.waitForNotification();
        int loopNum = 0;
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)97, (byte)8, data)), 0, respData);
            ++loopNum;
            if (r != TaskManager.TaskStartRet.SUCCESS) continue;
            if (respData.resData == null) {
                isCommandRunning = false;
                respData.statusCode = 21;
                return 21;
            }
            if (respData.resData.length == 1 && respData.resData[0] == 0) {
                isCommandRunning = false;
                respData.statusCode = 3;
                return 3;
            }
            rt = 9;
            int len = respData.resData.length;
            if (len <= 11) continue;
            rt = respData.resData[11];
            cmd = respData.resData[10];
            if (cmd == -18 && rt == -16) break;
            if (rt == 0) continue;
            rt = 9;
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != 97));
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int lcd_updatePosition(String screenName, String objectName, byte alignment, int new_xCord, int new_yCord) {
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (screenName == null || screenName.length() <= 0 || objectName == null || objectName.length() <= 0) {
            return 27392;
        }
        if (alignment < 0 || alignment > 4) {
            return 27392;
        }
        if (new_xCord < 0 || new_xCord > 271) {
            return 27392;
        }
        if (new_yCord < 0 || new_yCord > 479) {
            return 27392;
        }
        int cmd = 0;
        int rt = 9;
        ResDataStruct respData = new ResDataStruct();
        byte[] data = new byte[screenName.length() + objectName.length() + 8];
        byte[] ba = screenName.getBytes();
        byte[] ba1 = objectName.getBytes();
        System.arraycopy(ba, 0, data, 0, screenName.length());
        System.arraycopy(ba1, 0, data, screenName.length() + 1, objectName.length());
        data[screenName.length() + objectName.length() + 2] = 2;
        data[screenName.length() + objectName.length() + 3] = alignment;
        data[screenName.length() + objectName.length() + 4] = (byte)(new_xCord & 0xFF);
        data[screenName.length() + objectName.length() + 5] = (byte)(new_xCord >> 8 & 0xFF);
        data[screenName.length() + objectName.length() + 6] = (byte)(new_yCord & 0xFF);
        data[screenName.length() + objectName.length() + 7] = (byte)(new_yCord >> 8 & 0xFF);
        isCommandRunning = true;
        this.waitForNotification();
        int loopNum = 0;
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)97, (byte)8, data)), 0, respData);
            ++loopNum;
            if (r != TaskManager.TaskStartRet.SUCCESS) continue;
            if (respData.resData == null) {
                isCommandRunning = false;
                respData.statusCode = 21;
                return 21;
            }
            if (respData.resData.length == 1 && respData.resData[0] == 0) {
                isCommandRunning = false;
                respData.statusCode = 3;
                return 3;
            }
            rt = 9;
            int len = respData.resData.length;
            if (len <= 11) continue;
            rt = respData.resData[11];
            cmd = respData.resData[10];
            if (cmd == -18 && rt == -16) break;
            if (rt == 0) continue;
            rt = 9;
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != 97));
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int lcd_removeItem(String screenName, String objectName) {
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (screenName == null || screenName.length() <= 0 || objectName == null || objectName.length() <= 0) {
            return 27392;
        }
        int cmd = 0;
        int rt = 9;
        ResDataStruct respData = new ResDataStruct();
        byte[] data = new byte[screenName.length() + objectName.length() + 2];
        byte[] ba = screenName.getBytes();
        byte[] ba1 = objectName.getBytes();
        System.arraycopy(ba, 0, data, 0, screenName.length());
        System.arraycopy(ba1, 0, data, screenName.length() + 1, objectName.length());
        isCommandRunning = true;
        this.waitForNotification();
        int loopNum = 0;
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)97, (byte)9, data)), 0, respData);
            ++loopNum;
            if (r != TaskManager.TaskStartRet.SUCCESS) continue;
            if (respData.resData == null) {
                isCommandRunning = false;
                respData.statusCode = 21;
                return 21;
            }
            if (respData.resData.length == 1 && respData.resData[0] == 0) {
                isCommandRunning = false;
                respData.statusCode = 3;
                return 3;
            }
            rt = 9;
            int len = respData.resData.length;
            if (len <= 11) continue;
            rt = respData.resData[11];
            cmd = respData.resData[10];
            if (cmd == -18 && rt == -16) break;
            if (rt == 0) continue;
            rt = 9;
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != 97));
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int lcd_storeScreenInfo() {
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        int cmd = 0;
        int rt = 9;
        ResDataStruct respData = new ResDataStruct();
        isCommandRunning = true;
        this.waitForNotification();
        int loopNum = 0;
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)97, (byte)14, new byte[0])), 0, respData);
            ++loopNum;
            if (r != TaskManager.TaskStartRet.SUCCESS) continue;
            if (respData.resData == null) {
                isCommandRunning = false;
                respData.statusCode = 21;
                return 21;
            }
            if (respData.resData.length == 1 && respData.resData[0] == 0) {
                isCommandRunning = false;
                respData.statusCode = 3;
                return 3;
            }
            rt = 9;
            int len = respData.resData.length;
            if (len <= 11) continue;
            rt = respData.resData[11];
            cmd = respData.resData[10];
            if (cmd == -18 && rt == -16) break;
            if (rt == 0) continue;
            rt = 9;
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != 97));
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int lcd_loadScreenInfo() {
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        int cmd = 0;
        int rt = 9;
        ResDataStruct respData = new ResDataStruct();
        isCommandRunning = true;
        this.waitForNotification();
        int loopNum = 0;
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)97, (byte)15, new byte[0])), 0, respData);
            ++loopNum;
            if (r != TaskManager.TaskStartRet.SUCCESS) continue;
            if (respData.resData == null) {
                isCommandRunning = false;
                respData.statusCode = 21;
                return 21;
            }
            if (respData.resData.length == 1 && respData.resData[0] == 0) {
                isCommandRunning = false;
                respData.statusCode = 3;
                return 3;
            }
            rt = 9;
            int len = respData.resData.length;
            if (len <= 11) continue;
            rt = respData.resData[11];
            cmd = respData.resData[10];
            if (cmd == -18 && rt == -16) break;
            if (rt == 0) continue;
            rt = 9;
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != 97));
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int lcd_clearScreenInfo() {
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        int cmd = 0;
        int rt = 9;
        ResDataStruct respData = new ResDataStruct();
        isCommandRunning = true;
        this.waitForNotification();
        int loopNum = 0;
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)97, (byte)16, new byte[0])), 0, respData);
            ++loopNum;
            if (r != TaskManager.TaskStartRet.SUCCESS) continue;
            if (respData.resData == null) {
                isCommandRunning = false;
                respData.statusCode = 21;
                return 21;
            }
            if (respData.resData.length == 1 && respData.resData[0] == 0) {
                isCommandRunning = false;
                respData.statusCode = 3;
                return 3;
            }
            rt = 9;
            int len = respData.resData.length;
            if (len <= 11) continue;
            rt = respData.resData[11];
            cmd = respData.resData[10];
            if (cmd == -18 && rt == -16) break;
            if (rt == 0) continue;
            rt = 9;
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != 97));
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int lcd_getAllScreens(List<IDTLCDData> IDTScreenInfos) {
        int num;
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        int cmd = 0;
        int rt = 9;
        ResDataStruct respData = new ResDataStruct();
        isCommandRunning = true;
        this.waitForNotification();
        int loopNum = 0;
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)97, (byte)17, new byte[0])), 0, respData);
            ++loopNum;
            if (r != TaskManager.TaskStartRet.SUCCESS) continue;
            if (respData.resData == null) {
                isCommandRunning = false;
                respData.statusCode = 21;
                return 21;
            }
            if (respData.resData.length == 1 && respData.resData[0] == 0) {
                isCommandRunning = false;
                respData.statusCode = 3;
                return 3;
            }
            rt = 9;
            int len = respData.resData.length;
            if (len <= 11) continue;
            rt = respData.resData[11];
            cmd = respData.resData[10];
            if (cmd == -18 && rt == -16) break;
            if (rt == 0) continue;
            rt = 9;
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != 97));
        if (respData.resData.length > 14 && (num = respData.resData[14]) > 0 && respData.resData.length > 16) {
            int position = 15;
            int i = 0;
            for (i = 0; i < num; ++i) {
                IDTLCDData returnItem = new IDTLCDData();
                returnItem.screenID = respData.resData[position] << 8 | respData.resData[position + 1];
                int idx = position += 2;
                while (respData.resData[position] != 0) {
                    ++position;
                }
                byte[] bytes = new byte[++position - idx];
                System.arraycopy(respData.resData, idx, bytes, 0, bytes.length);
                returnItem.screenName = new String(bytes);
                IDTScreenInfos.add(returnItem);
            }
        }
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int lcd_getAllObjects(String screenName, List<IDTLCDData> IDTScreenInfos) {
        int num;
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        int cmd = 0;
        int rt = 9;
        ResDataStruct respData = new ResDataStruct();
        byte[] data = new byte[screenName.length() + 1];
        byte[] ba = screenName.getBytes();
        System.arraycopy(ba, 0, data, 0, screenName.length());
        isCommandRunning = true;
        this.waitForNotification();
        int loopNum = 0;
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)97, (byte)18, data)), 0, respData);
            ++loopNum;
            if (r != TaskManager.TaskStartRet.SUCCESS) continue;
            if (respData.resData == null) {
                isCommandRunning = false;
                respData.statusCode = 21;
                return 21;
            }
            if (respData.resData.length == 1 && respData.resData[0] == 0) {
                isCommandRunning = false;
                respData.statusCode = 3;
                return 3;
            }
            rt = 9;
            int len = respData.resData.length;
            if (len <= 11) continue;
            rt = respData.resData[11];
            cmd = respData.resData[10];
            if (cmd == -18 && rt == -16) break;
            if (rt == 0) continue;
            rt = 9;
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != 97));
        if (respData.resData.length > 14 && (num = respData.resData[14]) > 0 && respData.resData.length > 16) {
            int position = 15;
            int i = 0;
            for (i = 0; i < num; ++i) {
                IDTLCDData returnItem = new IDTLCDData();
                returnItem.objectID = respData.resData[position] << 8 | respData.resData[position + 1];
                int idx = position += 2;
                while (respData.resData[position] != 0) {
                    ++position;
                }
                byte[] bytes = new byte[++position - idx];
                System.arraycopy(respData.resData, idx, bytes, 0, bytes.length);
                returnItem.objectName = new String(bytes);
                IDTScreenInfos.add(returnItem);
            }
        }
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int lcd_queryScreenbyName(String screenName, IDTLCDData returnItem) {
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        if (screenName == null || screenName.length() <= 0) {
            return 27392;
        }
        int cmd = 0;
        int rt = 9;
        ResDataStruct respData = new ResDataStruct();
        byte[] data = new byte[screenName.length() + 1];
        byte[] ba = screenName.getBytes();
        System.arraycopy(ba, 0, data, 0, screenName.length());
        isCommandRunning = true;
        this.waitForNotification();
        int loopNum = 0;
        do {
            r = this.sendCommand_helper(Common.getHexStringFromBytes(Common.grsiP2Command((byte)97, (byte)19, data)), 0, respData);
            ++loopNum;
            if (r != TaskManager.TaskStartRet.SUCCESS) continue;
            if (respData.resData == null) {
                isCommandRunning = false;
                respData.statusCode = 21;
                return 21;
            }
            if (respData.resData.length == 1 && respData.resData[0] == 0) {
                isCommandRunning = false;
                respData.statusCode = 3;
                return 3;
            }
            rt = 9;
            int len = respData.resData.length;
            if (len <= 11) continue;
            rt = respData.resData[11];
            cmd = respData.resData[10];
            if (cmd == -18 && rt == -16) break;
            if (rt == 0) continue;
            rt = 9;
        } while (loopNum < maxLoopNum && (rt != 0 || cmd != 97));
        if (respData.resData.length > 14) {
            returnItem.result = respData.resData[14];
        }
        int returnCode = this.returnACK(r, respData);
        this.convertIDG(respData, 0);
        isCommandRunning = false;
        respData.statusCode = returnCode;
        return returnCode;
    }

    public int lcd_queryObjectbyName(String objectName, List<IDTLCDData> IDTScreenInfos) {
        int num;
        TaskManager.TaskStartRet r;
        if (!readyForNextCommand || !readyForCardSwipe) {
            return 29696;
        }
        if (connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && connectedDevice != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT) {
            return 20;
        }
        if (!this.device_isConnected()) {
            return 1;
        }
        int cmd = 0;
        int rt = 9;
        ResDataStruct respData = new ResDataStruct();
        byte[] data = new byte[objectName.