/*
 * Decompiled with CFR 0.152.
 */
package com.idtechproducts.device;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PostCardDataParse {
    private String firstName = "";
    private String middleInitial = "";
    private String suffix = "";
    private String surname = "";
    private String title = "";
    private String serviceCode = "";
    private String accountNumber = "";
    private String expirationDate = "";
    private String cardHolderName = "";
    private String firstCardNum = "";
    private String lastCardNum = "";
    private String redactedNum = "";
    private String track1DiscretionaryData = "";
    private String track2DiscretionaryData = "";

    public boolean parseTrack1(byte[] t1) {
        if (t1 == null) {
            return false;
        }
        String s = new String(t1);
        Pattern p = Pattern.compile("%?[B\\*]([0-9\\*]{1,19})\\^(.{2,26})\\^([0-9\\*]{4})(.{3})(.*)\\?");
        Pattern p1 = Pattern.compile("[B\\*]([0-9\\*]{1,19})\\^(.{2,26})\\^([0-9\\*]{4})(.{3})(.*)");
        Matcher m = p.matcher(s);
        Matcher m1 = p1.matcher(s);
        if (m.find()) {
            String name;
            if (s.charAt(1) != '*' && s.charAt(1) != 'B') {
                return false;
            }
            String[] ss = new String[m.groupCount()];
            for (int i = 1; i <= m.groupCount(); ++i) {
                ss[i - 1] = m.group(i);
            }
            if (ss[0].length() < 12 || ss[0].length() > 19) {
                return false;
            }
            this.accountNumber = ss[0];
            this.cardHolderName = name = ss[1];
            this.nameParse(name);
            this.expirationDate = ss[2];
            this.serviceCode = ss[3];
            this.firstCardNum = this.accountNumber.substring(0, 6);
            int lenAcc = this.accountNumber.length();
            this.lastCardNum = this.accountNumber.substring(lenAcc - 4, lenAcc);
            this.track1DiscretionaryData = ss[4];
            this.redactedNum = this.accountNumber;
            return true;
        }
        if (m1.find()) {
            String name;
            if (s.charAt(0) != '*' && s.charAt(0) != 'B') {
                return false;
            }
            String[] ss = new String[m1.groupCount()];
            for (int i = 1; i <= m1.groupCount(); ++i) {
                ss[i - 1] = m1.group(i);
            }
            if (ss[0].length() < 12 || ss[0].length() > 19) {
                return false;
            }
            this.accountNumber = ss[0];
            this.cardHolderName = name = ss[1];
            this.nameParse(name);
            this.expirationDate = ss[2];
            this.serviceCode = ss[3];
            this.firstCardNum = this.accountNumber.substring(0, 6);
            int lenAcc = this.accountNumber.length();
            this.lastCardNum = this.accountNumber.substring(lenAcc - 4, lenAcc);
            this.track1DiscretionaryData = ss[4];
            this.redactedNum = this.accountNumber;
            return true;
        }
        return false;
    }

    public boolean parseTrack2(byte[] t2) {
        if (t2 == null) {
            return false;
        }
        String s = new String(t2);
        if (s.length() < 20) {
            return false;
        }
        Pattern p = Pattern.compile(";?([0-9\\*]{1,19})=([0-9\\*]{4})(.{3})(.*)\\?");
        Pattern p1 = Pattern.compile("([0-9\\*]{1,19})=([0-9\\*]{4})(.{3})(.*)");
        Matcher m = p.matcher(s);
        Matcher m1 = p1.matcher(s);
        if (m.find()) {
            String[] ss = new String[m.groupCount()];
            for (int i = 1; i <= m.groupCount(); ++i) {
                ss[i - 1] = m.group(i);
            }
            if (ss[0].length() < 12 || ss[0].length() > 19) {
                return false;
            }
            this.accountNumber = ss[0];
            this.firstCardNum = this.accountNumber.substring(0, 6);
            int lenAcc = this.accountNumber.length();
            this.lastCardNum = this.accountNumber.substring(lenAcc - 4, lenAcc);
            this.expirationDate = ss[1];
            this.serviceCode = ss[2];
            this.track2DiscretionaryData = ss[3];
            this.redactedNum = this.accountNumber;
            return true;
        }
        if (m1.find()) {
            String[] ss = new String[m1.groupCount()];
            for (int i = 1; i <= m1.groupCount(); ++i) {
                ss[i - 1] = m1.group(i);
            }
            if (ss[0].length() < 12 || ss[0].length() > 19) {
                return false;
            }
            this.accountNumber = ss[0];
            this.firstCardNum = this.accountNumber.substring(0, 6);
            int lenAcc = this.accountNumber.length();
            this.lastCardNum = this.accountNumber.substring(lenAcc - 4, lenAcc);
            this.expirationDate = ss[1];
            this.serviceCode = ss[2];
            this.track2DiscretionaryData = ss[3];
            this.redactedNum = this.accountNumber;
            return true;
        }
        return false;
    }

    public boolean parseAAMVATrack1(byte[] t1) {
        if (t1 == null) {
            return false;
        }
        String s = new String(t1);
        if (s.length() < 20) {
            return false;
        }
        String name = new String("");
        Pattern p = Pattern.compile("[/^]+");
        String[] result = p.split(s);
        Pattern p2 = Pattern.compile("[/$]+");
        String[] result2 = p2.split(result[1]);
        int len = result2.length;
        for (int j = 0; j < len; ++j) {
            name = name + result2[j];
            name = name + " ";
        }
        this.cardHolderName = name;
        return true;
    }

    public boolean parseAAMVATrack2(byte[] t2) {
        if (t2 == null) {
            return false;
        }
        String s = new String(t2);
        if (s.length() < 20) {
            return false;
        }
        Pattern p = Pattern.compile(";?([0-9\\*]{1,19})=([0-9\\*]{4})(.{8})(.*)\\?");
        Pattern p1 = Pattern.compile("([0-9\\*]{1,19})=([0-9\\*]{4})(.{8})(.*)");
        Matcher m = p.matcher(s);
        Matcher m1 = p1.matcher(s);
        if (m.find()) {
            String[] ss = new String[m.groupCount()];
            for (int i = 1; i <= m.groupCount(); ++i) {
                ss[i - 1] = m.group(i);
            }
            if (ss[0].length() < 12 || ss[0].length() > 19) {
                return false;
            }
            String rNumber = ss[0];
            this.expirationDate = ss[1];
            int lenAcc = rNumber.length();
            rNumber = rNumber.substring(6, lenAcc);
            String rNumber2 = ss[3];
            int lenAcc2 = rNumber2.length();
            lenAcc = rNumber.length();
            if (lenAcc2 > 0 && lenAcc > 12) {
                rNumber = rNumber + rNumber2;
                byte[] tNum = new byte[lenAcc += lenAcc2];
                for (int x = 0; x < lenAcc - 4; ++x) {
                    tNum[x] = 42;
                }
                String firstrNum = new String(tNum);
                String lastrNum = rNumber.substring(lenAcc - 4, lenAcc);
                this.redactedNum = firstrNum + lastrNum;
            } else {
                byte[] tNum = new byte[lenAcc];
                for (int x = 0; x < lenAcc - 4; ++x) {
                    tNum[x] = 42;
                }
                String firstrNum = new String(tNum);
                String lastrNum = rNumber.substring(lenAcc - 4, lenAcc);
                this.redactedNum = firstrNum + lastrNum;
            }
            return true;
        }
        if (m1.find()) {
            String[] ss = new String[m1.groupCount()];
            for (int i = 1; i <= m1.groupCount(); ++i) {
                ss[i - 1] = m1.group(i);
            }
            if (ss[0].length() < 12 || ss[0].length() > 19) {
                return false;
            }
            String rNumber = ss[0];
            this.expirationDate = ss[1];
            int lenAcc = rNumber.length();
            rNumber = rNumber.substring(6, lenAcc);
            String rNumber2 = ss[3];
            int lenAcc2 = rNumber2.length();
            lenAcc = rNumber.length();
            if (lenAcc2 > 0 && lenAcc > 12) {
                rNumber = rNumber + rNumber2;
                byte[] tNum = new byte[lenAcc += lenAcc2];
                for (int x = 0; x < lenAcc - 4; ++x) {
                    tNum[x] = 42;
                }
                String firstrNum = new String(tNum);
                String lastrNum = rNumber.substring(lenAcc - 4, lenAcc);
                this.redactedNum = firstrNum + lastrNum;
            } else {
                byte[] tNum = new byte[lenAcc];
                for (int x = 0; x < lenAcc - 4; ++x) {
                    tNum[x] = 42;
                }
                String firstrNum = new String(tNum);
                String lastrNum = rNumber.substring(lenAcc - 4, lenAcc);
                this.redactedNum = firstrNum + lastrNum;
            }
            return true;
        }
        return false;
    }

    private void nameParse(String str) {
        if (str == null || str.length() == 0) {
            return;
        }
        int format = 32;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != '/') continue;
            format = 47;
            break;
        }
        try {
            switch (format) {
                case 32: {
                    this.nameParseSpace(str);
                    break;
                }
                case 47: {
                    this.nameParseSlash(str);
                    break;
                }
            }
        }
        catch (IndexOutOfBoundsException e) {
            System.err.println("warning: name parse get fail");
        }
    }

    private void nameParseSpace(String str) throws IndexOutOfBoundsException {
        int i;
        int n;
        String part = str.trim();
        for (n = part.length() - 1; n >= 0; --n) {
            if (part.charAt(n) != ' ') continue;
            ++n;
            break;
        }
        if (n > 0) {
            if (part.length() - n <= 2) {
                for (i = n; i < part.length(); ++i) {
                    this.suffix = this.suffix + part.charAt(i);
                }
                --n;
            } else {
                n = part.length();
            }
        } else {
            n = part.length();
        }
        part = part.substring(0, n);
        n = part.length();
        for (i = n - 1; i >= 0; --i) {
            if (part.charAt(i) != ' ') continue;
            ++i;
            break;
        }
        if (i > 0) {
            this.surname = part.substring(i);
            this.surname = this.surname.trim();
            part = part.substring(0, i);
        }
        part = part.trim();
        for (n = part.length() - 1; n > 0; --n) {
            if (part.charAt(n) != ' ') continue;
            ++n;
            break;
        }
        if (part.length() - n == 1) {
            this.middleInitial = this.middleInitial + part.charAt(n);
            part = part.substring(0, n);
            part = part.trim();
        }
        this.firstName = part.trim();
    }

    private void nameParseSlash(String str) throws IndexOutOfBoundsException {
        int n;
        int i;
        String fpart = "";
        String bpart = "";
        for (i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == '/') {
                ++i;
                break;
            }
            fpart = fpart + str.charAt(i);
        }
        while (i < str.length()) {
            bpart = bpart + str.charAt(i);
            ++i;
        }
        fpart.trim();
        for (n = fpart.length() - 1; n >= 0; --n) {
            if (fpart.charAt(n) != ' ') continue;
            ++n;
            break;
        }
        if (n > 0) {
            if (fpart.length() - 1 - n <= 2) {
                for (i = n; i < fpart.length(); ++i) {
                    this.suffix = this.suffix + fpart.charAt(i);
                }
            } else {
                n = fpart.length();
            }
        } else {
            n = fpart.length();
        }
        for (i = 0; i < n; ++i) {
            this.surname = this.surname + fpart.charAt(i);
        }
        this.surname = this.surname.trim();
        for (n = bpart.length() - 1; n >= 0 && bpart.charAt(n) != '.'; --n) {
        }
        if (n > 0) {
            for (i = n + 1; i < bpart.length(); ++i) {
                this.title = this.title + bpart.charAt(i);
            }
            bpart = bpart.substring(0, n);
        }
        for (n = bpart.length() - 1; n >= 0 && bpart.charAt(n) != ' '; --n) {
        }
        if (n > 0 && bpart.length() - 1 - n > 0) {
            this.middleInitial = this.middleInitial + bpart.charAt(n + 1);
            bpart = bpart.substring(0, n);
        }
        this.firstName = bpart.trim();
    }
}

