/*
 * Decompiled with CFR 0.152.
 */
package com.idtechproducts.device.audiojack;

import android.util.Log;
import com.idtechproducts.device.Common;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class UMLog {
    private static final String UMSDK_LOGCAT_TAG = "UnifiedSDK";
    private static final SimpleDateFormat _dateFormat;
    private static final String[] _levTable;
    private static boolean _isVerbose;
    private static PrintWriter _writer;
    private static File _log_dir;
    private static String _log_prefix;
    private static File _log_fullPath;

    public static synchronized void setEnableVerbose(boolean enable) {
        _isVerbose = enable;
    }

    public static synchronized void open(File dir, String prefix) {
        UMLog.close();
        try {
            String time = new SimpleDateFormat("MM.dd_HH-mm-ss", Locale.US).format(new Date());
            File f = prefix != null && prefix.equalsIgnoreCase("AutoConfig") ? new File(dir, prefix + ".data") : new File(dir, prefix + time + ".txt");
            _writer = new PrintWriter(f);
            _log_dir = dir;
            _log_prefix = prefix;
            _log_fullPath = f;
        }
        catch (FileNotFoundException e) {
            Log.w((String)UMSDK_LOGCAT_TAG, (String)("UMLog: log file not opened: " + e));
        }
    }

    public static synchronized void close() {
        if (_writer != null) {
            _writer.close();
            _writer = null;
            _log_dir = null;
            _log_prefix = null;
            _log_fullPath = null;
        }
    }

    private static synchronized File getPath() {
        return _log_fullPath;
    }

    public static synchronized int exportLogs(File dir, String prefix, String fileName) {
        String path = Common.getSDRootFilePath() + File.separator;
        File[] list = dir.listFiles();
        ArrayList<File> files = new ArrayList<File>();
        int fileCount = 0;
        if (null == list) {
            UMLog.w(UMSDK_LOGCAT_TAG, "UMLog: delete: invalid dir: " + dir);
            return 0;
        }
        for (File f : list) {
            if (!f.getName().startsWith(prefix) && !f.getName().equalsIgnoreCase("autoconfig.data")) continue;
            files.add(f);
            ++fileCount;
        }
        try {
            FileOutputStream fos = new FileOutputStream(path + fileName);
            ZipOutputStream zos = new ZipOutputStream(fos);
            for (int i = 0; i < files.size(); ++i) {
                int length;
                ZipEntry ze = new ZipEntry(((File)files.get(i)).getName());
                FileInputStream fis = new FileInputStream((File)files.get(i));
                zos.putNextEntry(ze);
                byte[] buffer = new byte[4096];
                while ((length = fis.read(buffer)) > 0) {
                    zos.write(buffer, 0, length);
                }
                zos.closeEntry();
                fis.close();
            }
            zos.close();
        }
        catch (Exception e) {
            UMLog.e("ACLog", "Exception: " + e.getMessage());
            return 0;
        }
        return fileCount;
    }

    public static synchronized int deleteLogs(File dir, String prefix) {
        File[] list = dir.listFiles();
        if (null == list) {
            Log.w((String)UMSDK_LOGCAT_TAG, (String)("UMLog: delete: invalid dir: " + dir));
            return 0;
        }
        boolean shouldRecreateLog = false;
        int deleteCount = 0;
        for (File f : list) {
            if (!f.getName().startsWith(prefix)) continue;
            f.delete();
            ++deleteCount;
            if (!f.equals(_log_fullPath)) continue;
            Log.w((String)UMSDK_LOGCAT_TAG, (String)"UMLog: deleted currently opened log file. Recreating");
            shouldRecreateLog = true;
        }
        if (shouldRecreateLog) {
            UMLog.open(_log_dir, _log_prefix);
            --deleteCount;
        }
        return deleteCount;
    }

    public static synchronized void i(String tag, String msg) {
        if (_isVerbose) {
            UMLog.log(tag, msg, null, 4);
        }
    }

    public static synchronized void w(String tag, String msg) {
        UMLog.log(tag, msg, null, 5);
    }

    public static synchronized void e(String tag, String msg) {
        UMLog.log(tag, msg, null, 6);
    }

    public static synchronized void w(String tag, String msg, Throwable tr) {
        UMLog.log(tag, msg, tr, 5);
    }

    private static synchronized void e(String tag, String msg, Throwable tr) {
        UMLog.log(tag, msg, tr, 6);
    }

    private static void log(String tag, String msg, Throwable tr, int level) {
        if (null == tr) {
            Log.println((int)level, (String)UMSDK_LOGCAT_TAG, (String)(tag + ": " + msg));
        } else {
            Log.println((int)level, (String)UMSDK_LOGCAT_TAG, (String)(tag + ": " + msg + "\n" + Log.getStackTraceString((Throwable)tr)));
        }
        if (_writer != null) {
            _writer.append(_dateFormat.format(new Date()));
            _writer.append(_levTable[level]);
            _writer.append(" |");
            _writer.append(tag);
            _writer.append("| ");
            _writer.append(msg);
            _writer.append("\n");
            if (tr != null) {
                tr.printStackTrace(_writer);
            }
            _writer.flush();
        }
    }

    static {
        _isVerbose = false;
        _dateFormat = new SimpleDateFormat("MM-dd HH:mm:ss.SSS", Locale.US);
        _levTable = new String[10];
        UMLog._levTable[4] = " I";
        UMLog._levTable[5] = " W";
        UMLog._levTable[6] = " E";
    }
}

