/*
 * Decompiled with CFR 0.152.
 */
package com.idtechproducts.device.audiojack.io;

import com.idtechproducts.device.audiojack.UMLog;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class RWaveParser {
    private static final byte H = 1;
    private static final byte M = 0;
    private static final byte L = -1;
    private final Client _cfg_client;
    private String _cfg_outFile_prefix = "./";
    private boolean _cfg_log = false;
    private boolean _cfg_logAll = false;
    private int _cfg_samplingRate = 44100;
    private int _cfg_baud = 9600;
    private int _cfg_inFilter_window = 1;
    private boolean _cfg_sdThresholdResolve_high = false;
    private boolean _cfg_sdThresholdResolve_low = false;
    private short[] _ftr_prev;
    private short _hml_sEnvP;
    private short _hml_sEnvN;
    private boolean _sd_inited;
    private AByteList _sd_sdList;
    private List<SDEntry> _sd_sdDbg;
    private byte _sd_sdLevel;
    private short _sd_lastLineLevel;
    private int _sd_noChangeCounter;
    private double _sd_accum;
    private double _sd_accumNext;
    private boolean _sd_snd;
    private List<short[]> _log_inp = null;
    private List<short[]> _log_ftr = new ArrayList<short[]>();
    private List<short[]> _log_hmlEnvP = new ArrayList<short[]>();
    private List<short[]> _log_hmlEnvN = new ArrayList<short[]>();
    private List<short[]> _log_hmlThrP = new ArrayList<short[]>();
    private List<short[]> _log_hmlThrN = new ArrayList<short[]>();
    private List<short[]> _log_hmlHML = new ArrayList<short[]>();
    private Object logDataLock = new Object();

    public RWaveParser(Client client) {
        if (client == null) {
            throw new NullPointerException();
        }
        this._cfg_client = client;
    }

    public void setLogFilePrefix(String prefix) {
        this._cfg_outFile_prefix = prefix;
    }

    public void setLog(boolean enabled, boolean logAll) {
        this._cfg_log = enabled;
        this._cfg_logAll = logAll;
    }

    public void setSamplingRate(int samplingRate) {
        this._cfg_samplingRate = samplingRate;
    }

    public void setBaud(int baud) {
        this._cfg_baud = baud;
    }

    private void setInputFilterWindow(int windowSize) {
        if (windowSize < 1 || windowSize % 2 == 0) {
            throw new IllegalArgumentException();
        }
        this._cfg_inFilter_window = windowSize;
    }

    public void setSdThresholdResolve(boolean high, boolean low) {
        this._cfg_sdThresholdResolve_high = high;
        this._cfg_sdThresholdResolve_low = low;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logClear() {
        if (this._log_inp == null) {
            return;
        }
        Object object = this.logDataLock;
        synchronized (object) {
            this._log_inp.clear();
            this._log_inp = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logBegin() {
        if (!this._cfg_log) {
            return;
        }
        Object object = this.logDataLock;
        synchronized (object) {
            if (this._log_inp == null) {
                this._log_inp = new ArrayList<short[]>();
            }
        }
    }

    public void purge() {
        this._ftr_prev = null;
        this._hml_sEnvN = 0;
        this._hml_sEnvP = 0;
        this._sd_inited = false;
        this._sd_snd = false;
        if (this._log_inp != null) {
            this._log_inp.clear();
        }
        this._log_ftr.clear();
        this._log_hmlEnvP.clear();
        this._log_hmlEnvN.clear();
        this._log_hmlThrP.clear();
        this._log_hmlThrN.clear();
        this._log_hmlHML.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseWaveData(short[] waveData, int length) {
        if (0 == length) {
            return;
        }
        if (waveData.length < length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this._cfg_log) {
            Object object = this.logDataLock;
            synchronized (object) {
                if (this._log_inp != null) {
                    this._log_inp.add(waveData.length == length ? RWaveParser.copyOf(waveData, length) : waveData);
                }
            }
        }
        short[] wFiltered = waveData;
        int wFilteredLen = length;
        if (this._cfg_inFilter_window != 1) {
            wFiltered = this.pipe_inputFilter(waveData, length);
            wFilteredLen = wFiltered.length;
        }
        short[] wHML = this.pipe_lineToHML(wFiltered, wFilteredLen);
        List<AByteList> sdPacketList = this.pipe_hmlToSd(wHML);
        this.pipe_sdToBytes(sdPacketList);
    }

    public boolean isPacketDetected() {
        return this._sd_snd;
    }

    short[] pipe_inputFilter(short[] src, int srcLen) {
        short[] inputFiltered = RWaveParser.medianFilter(this._cfg_inFilter_window, this._ftr_prev, src, srcLen);
        this._ftr_prev = RWaveParser.copyOfRange(src, srcLen - (this._cfg_inFilter_window - 1), srcLen);
        if (this._cfg_log && this._cfg_logAll) {
            this._log_ftr.add(inputFiltered);
        }
        return inputFiltered;
    }

    static short[] medianFilter(int winSize, short[] prev, short[] src, int srcLen) {
        int ssi;
        int pa;
        short[] ret;
        assert (winSize % 2 == 1);
        assert (prev.length == winSize - 1);
        int mBefore = (winSize - 1) / 2;
        int mAfter = (winSize - 1) / 2;
        int midIndex = (winSize - 1) / 2;
        short[] win = new short[winSize];
        if (null == prev) {
            prev = new short[winSize - 1];
            Arrays.fill(prev, src[0]);
            ret = new short[srcLen - mAfter];
            pa = mAfter;
            ssi = mBefore;
        } else {
            ret = new short[srcLen];
            pa = prev.length;
            ssi = winSize - 1;
        }
        int i = 0;
        while (i < ssi) {
            System.arraycopy(prev, prev.length - pa, win, 0, pa);
            System.arraycopy(src, 0, win, pa, winSize - pa);
            Arrays.sort(win);
            ret[i] = win[midIndex];
            ++i;
            --pa;
        }
        i = ssi;
        int srcI = 0;
        while (i < ret.length) {
            System.arraycopy(src, srcI, win, 0, winSize);
            Arrays.sort(win);
            ret[i] = win[midIndex];
            ++i;
            ++srcI;
        }
        return ret;
    }

    short[] pipe_lineToHML(short[] wLine, int len) {
        short[] wHML = new short[len];
        short[] wEnvP = this._cfg_log && this._cfg_logAll ? new short[len] : null;
        short[] wEnvN = this._cfg_log && this._cfg_logAll ? new short[len] : null;
        short[] wThrP = this._cfg_log && this._cfg_logAll ? new short[len] : null;
        short[] wThrN = this._cfg_log && this._cfg_logAll ? new short[len] : null;
        for (int i = 0; i < len; ++i) {
            short sLine = wLine[i];
            if (sLine >= 0) {
                this._hml_sEnvP = sLine >= this._hml_sEnvP ? (short)(this._hml_sEnvP / 2 + sLine / 2) : (short)(19 * this._hml_sEnvP / 20 + sLine / 20);
            } else {
                this._hml_sEnvN = sLine <= this._hml_sEnvN ? (short)(this._hml_sEnvN / 2 + sLine / 2) : (short)(19 * this._hml_sEnvN / 20 + sLine / 20);
            }
            int envDelta = this._hml_sEnvP - this._hml_sEnvN;
            if (envDelta < 4000) {
                i += 150;
                continue;
            }
            int envDeltaDiv3 = envDelta / 3;
            short sThrP = (short)(this._hml_sEnvN + 2 * envDeltaDiv3);
            short sThrN = (short)(this._hml_sEnvN + envDeltaDiv3);
            wHML[i] = sLine > sThrP ? Short.MAX_VALUE : (sLine >= sThrN ? 0 : Short.MIN_VALUE);
            if (!this._cfg_log || !this._cfg_logAll) continue;
            wEnvP[i] = this._hml_sEnvP;
            wEnvN[i] = this._hml_sEnvN;
            wThrP[i] = sThrP;
            wThrN[i] = sThrN;
        }
        if (this._cfg_log && this._cfg_logAll) {
            this._log_hmlEnvP.add(wEnvP);
            this._log_hmlEnvN.add(wEnvN);
            this._log_hmlThrP.add(wThrP);
            this._log_hmlThrN.add(wThrN);
            this._log_hmlHML.add(wHML);
        }
        return wHML;
    }

    List<AByteList> pipe_hmlToSd(short[] wLvl) {
        if (wLvl.length <= 0) {
            throw new RuntimeException("wLvl.length <= 0");
        }
        double sd_thresh = (double)this._cfg_samplingRate / (double)this._cfg_baud * 1.5;
        int packetEnd_thresh = (int)((double)this._cfg_samplingRate / (double)this._cfg_baud * 2.0 * 3.0);
        ArrayList<AByteList> ret = new ArrayList<AByteList>(5);
        int startLoc = false == this._sd_inited ? this.pipe_hmlToSd_init(wLvl, 0) : 0;
        for (int i = startLoc; i < wLvl.length; ++i) {
            if (wLvl[i] != 0) {
                if (wLvl[i] == this._sd_lastLineLevel) {
                    this._sd_accum += 1.0;
                } else if (this._sd_sdLevel != (wLvl[i] > 0 ? (byte)1 : -1)) {
                    if (this._sd_accum == sd_thresh) {
                        if (this._sd_sdLevel == 1 ? this._cfg_sdThresholdResolve_high : this._cfg_sdThresholdResolve_low) {
                            this._sd_sdList.add(this._sd_sdLevel);
                        }
                    } else if (this._sd_accum > sd_thresh) {
                        this._sd_sdList.add(this._sd_sdLevel);
                    }
                    this._sd_sdList.add(this._sd_sdLevel);
                    if (this._cfg_log && this._cfg_logAll) {
                        this._sd_sdDbg.get((int)(this._sd_sdDbg.size() - 1)).acc = this._sd_accum;
                        this._sd_sdDbg.add(new SDEntry(i, 0.0));
                    }
                    if (!this._sd_snd && this._sd_sdList.size() > 200) {
                        this._sd_snd = true;
                        this._cfg_client.soundDetected();
                    }
                    this._sd_accum = this._sd_accumNext + 1.0;
                    this._sd_accumNext = 0.0;
                    this._sd_sdLevel = (byte)(wLvl[i] > 0 ? 1 : -1);
                } else {
                    this._sd_accum += this._sd_accumNext + 1.0;
                    this._sd_accumNext = 0.0;
                }
            } else {
                this._sd_accum += 0.5;
                this._sd_accumNext += 0.5;
            }
            this._sd_noChangeCounter = this._sd_lastLineLevel == wLvl[i] ? this._sd_noChangeCounter + 1 : 0;
            this._sd_lastLineLevel = wLvl[i];
            if (this._sd_noChangeCounter <= packetEnd_thresh) continue;
            if (this._sd_accum > sd_thresh) {
                this._sd_sdList.add(this._sd_sdLevel);
            }
            this._sd_sdList.add(this._sd_sdLevel);
            if (this._cfg_log && this._cfg_logAll) {
                this._sd_sdDbg.get((int)(this._sd_sdDbg.size() - 1)).acc = this._sd_accum;
            }
            ret.add(this._sd_sdList);
            i = this.pipe_hmlToSd_init(wLvl, i) - 1;
        }
        return ret;
    }

    private int pipe_hmlToSd_init(short[] wLvl, int wLvlStart) {
        int startLoc;
        this._sd_sdList = new AByteList();
        if (this._cfg_log && this._cfg_logAll) {
            this._sd_sdDbg = new ArrayList<SDEntry>();
        }
        this._sd_noChangeCounter = 0;
        this._sd_accum = 0.0;
        this._sd_accumNext = 0.0;
        if (wLvl[wLvlStart] != 0) {
            int ti;
            for (ti = wLvlStart; ti < wLvl.length && wLvl[wLvlStart] == wLvl[ti]; ++ti) {
            }
            startLoc = ti - (int)((double)this._cfg_samplingRate / (double)this._cfg_baud * 2.0);
            if (startLoc < wLvlStart) {
                startLoc = wLvlStart;
            }
        } else {
            for (startLoc = wLvlStart; startLoc < wLvl.length && 0 == wLvl[startLoc]; ++startLoc) {
            }
        }
        if (startLoc < wLvl.length) {
            this._sd_sdLevel = (byte)(wLvl[startLoc] > 0 ? 1 : -1);
            if (this._cfg_log && this._cfg_logAll) {
                this._sd_sdDbg.add(new SDEntry(startLoc, 0.0));
            }
            this._sd_lastLineLevel = wLvl[startLoc];
            this._sd_inited = true;
        } else {
            this._sd_inited = false;
        }
        return startLoc;
    }

    void pipe_sdToBytes(List<AByteList> sdPacketList) {
        block0: for (AByteList sdPacket : sdPacketList) {
            int i = 0;
            block1: while (true) {
                boolean isDirUp;
                byte[] uniPreamb = new byte[]{1, -1, -1, 1, 1, -1, -1, 1};
                while (i < sdPacket.size() && !RWaveParser.matchAt(uniPreamb, sdPacket, i)) {
                    ++i;
                }
                if ((i += uniPreamb.length) + 30 >= sdPacket.size()) continue block0;
                if (sdPacket.get(i) == -1) {
                    ++i;
                    isDirUp = true;
                } else {
                    if (!RWaveParser.matchAt(new byte[]{-1, 1}, sdPacket, i + 1)) continue;
                    i += 3;
                    isDirUp = false;
                }
                byte gH = isDirUp ? (byte)1 : -1;
                byte gL = isDirUp ? (byte)-1 : 1;
                byte[] frame5 = new byte[]{gH, gH, gL, gL, gH, gH, gL, gL, gH, gL};
                byte[] frame66 = new byte[]{gH, gL, gH, gH, gL, gH, gL, gL, gH, gL, gH, gL, gH, gH, gL, gH, gL, gL, gH, gL};
                while (RWaveParser.matchAt(frame5, sdPacket, i)) {
                    i += frame5.length;
                }
                if (!RWaveParser.matchAt(frame66, sdPacket, i)) continue;
                i += frame66.length;
                AByteList packetBody = new AByteList();
                while (i + 19 < sdPacket.size()) {
                    byte readByte = 0;
                    int nibI = 0;
                    int nshift = 4;
                    while (nibI < 2) {
                        if (sdPacket.get(i + 10 * nibI + 0) != gH) continue block1;
                        int nibble = 0;
                        for (int bitI = 0; bitI < 4; ++bitI) {
                            byte bit = sdPacket.get(i + 10 * nibI + 1 + bitI * 2);
                            if (sdPacket.get(i + 10 * nibI + 1 + bitI * 2 + 1) != bit * -1) continue block1;
                            nibble = (byte)(nibble | (bit == gH ? 1 << bitI : 0));
                        }
                        if (sdPacket.get(i + 10 * nibI + 9) != gL) continue block1;
                        readByte = (byte)(readByte | nibble << nshift);
                        ++nibI;
                        nshift -= 4;
                    }
                    packetBody.add(readByte);
                    i += 20;
                }
                byte[] byteArr = new byte[packetBody.size()];
                for (int x = 0; x < byteArr.length; ++x) {
                    byteArr[x] = packetBody.get(x);
                }
                boolean continueParsing = this._cfg_client.processParsedData(byteArr);
                byteArr = null;
                if (!continueParsing) break;
            }
            break;
        }
    }

    private static boolean matchAt(byte[] pattern, AByteList in, int inStart) {
        if (in.size() - inStart < pattern.length) {
            return false;
        }
        for (int i = 0; i < pattern.length; ++i) {
            if (pattern[i] == in.get(inStart + i)) continue;
            return false;
        }
        return true;
    }

    private static short[] copyOf(short[] original, int newLength) {
        short[] ret = new short[newLength];
        System.arraycopy(original, 0, ret, 0, original.length < newLength ? original.length : newLength);
        return ret;
    }

    private static short[] copyOfRange(short[] original, int from, int to) {
        short[] ret = new short[to - from];
        System.arraycopy(original, from, ret, 0, to - from);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveLoggedData() {
        Object object = this.logDataLock;
        synchronized (object) {
            if (this._log_inp == null) {
                UMLog.i("RWaveParser", "*## Error, saveLoggedData , ???_log_inp = null.");
            }
            if (this._log_inp != null) {
                this.writeToFile(".wav", this._log_inp);
                this._log_inp.clear();
                this._log_inp = null;
            }
        }
        if (this._cfg_logAll) {
            this.writeToFile("_iftr.wav", this._log_ftr);
            this.writeToFile("_envP.wav", this._log_hmlEnvP);
            this.writeToFile("_envN.wav", this._log_hmlEnvN);
            this.writeToFile("_thrP.wav", this._log_hmlThrP);
            this.writeToFile("_thrN.wav", this._log_hmlThrN);
            this.writeToFile("_hml.wav", this._log_hmlHML);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFile(String path, List<short[]> datas) {
        File qualifiedPath = new File(this._cfg_outFile_prefix + path);
        UMLog.i("RWaveParser", "*## wav file . ## " + this._cfg_outFile_prefix + path + ", data size = " + datas.size());
        OutputStream os = null;
        try {
            os = new BufferedOutputStream(new FileOutputStream(qualifiedPath));
            int dataLenSum = 0;
            for (short[] data : datas) {
                dataLenSum += data.length;
            }
            byte[] header = RWaveParser.getWaveHeader(dataLenSum * 2, this._cfg_samplingRate);
            os.write(header, 0, header.length);
            int buffSize = 4000;
            int buffItemCapacity = 2000;
            byte[] buff = new byte[4000];
            for (short[] data : datas) {
                int itemsLeft = data.length;
                int srcIndex = 0;
                while (itemsLeft > 0) {
                    int itemsToCopy = 2000 < itemsLeft ? 2000 : itemsLeft;
                    for (int i = 0; i < itemsToCopy; ++i) {
                        buff[i * 2] = (byte)(data[srcIndex + i] & 0xFF);
                        buff[i * 2 + 1] = (byte)(data[srcIndex + i] >> 8 & 0xFF);
                    }
                    os.write(buff, 0, itemsToCopy * 2);
                    itemsLeft -= itemsToCopy;
                    srcIndex += itemsToCopy;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static byte[] getWaveHeader(int audioDataSize, int inputSamplingRate) {
        byte[] wavHeaderArray = new byte[]{82, 73, 70, 70, 0, 0, 0, 0, 87, 65, 86, 69, 102, 109, 116, 32, 16, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 16, 0, 100, 97, 116, 97, 0, 0, 0, 0};
        ByteBuffer waveHeader = ByteBuffer.wrap(wavHeaderArray).order(ByteOrder.LITTLE_ENDIAN);
        waveHeader.position(4);
        waveHeader.putInt(36 + audioDataSize);
        waveHeader.position(24);
        waveHeader.putInt(inputSamplingRate);
        waveHeader.position(28);
        waveHeader.putInt(inputSamplingRate * 2);
        waveHeader.position(40);
        waveHeader.putInt(audioDataSize);
        return wavHeaderArray;
    }

    public static interface Client {
        public boolean processParsedData(byte[] var1);

        public void soundDetected();
    }

    private static class AByteList {
        private static final int INC = 150;
        private ArrayList<byte[]> _linkedArrays = new ArrayList();
        private int _length;

        private AByteList() {
        }

        public void add(byte item) {
            if (this._linkedArrays.size() * 150 == this._length) {
                this._linkedArrays.add(new byte[150]);
            }
            this._linkedArrays.get((int)(this._length / 150))[this._length % 150] = item;
            ++this._length;
        }

        public byte get(int index) {
            return this._linkedArrays.get(index / 150)[index % 150];
        }

        public int size() {
            return this._length;
        }
    }

    static class SDEntry
    implements Serializable {
        private static final long serialVersionUID = -9079481752499031780L;
        public int idx;
        public double acc;

        public SDEntry(int idx, double acc) {
            this.idx = idx;
            this.acc = acc;
        }
    }
}

