/*
 * Decompiled with CFR 0.152.
 */
package com.idtechproducts.device.audiojack.io;

import android.media.AudioTrack;
import android.os.Handler;
import android.os.Looper;
import com.idtechproducts.device.StructConfigParameters;
import com.idtechproducts.device.audiojack.UMLog;
import com.idtechproducts.device.audiojack.io.Player;
import com.idtechproducts.device.audiojack.io.ToneType;

public class TonePlayer {
    private static final String TAG = "SDK::TonePlayer";
    private static final Handler mainHandler = new Handler(Looper.getMainLooper());
    private StructConfigParameters config;
    private ToneType tone_state;
    private AudioTrack tone_at = null;
    private ToneType tone_at_track = null;

    public synchronized void release() {
        if (this.tone_state != null) {
            mainHandler.post(new Runnable(){

                @Override
                public void run() {
                    TonePlayer.this.releaseAudioTrack();
                }
            });
            this.tone_state = null;
        }
    }

    public synchronized void setConfig(StructConfigParameters newConfig) {
        if (newConfig == null) {
            throw new NullPointerException();
        }
        boolean isPlayerParamEqual = this.config != null && this.config.getFrequenceOutput() == newConfig.getFrequenceOutput() && this.config.getDirectionOutputWave() == newConfig.getDirectionOutputWave();
        this.config = newConfig.clone();
        if (!isPlayerParamEqual) {
            ToneType originallyPlaying = this.tone_state;
            this.release();
            this.setPlayingTone(originallyPlaying);
        }
    }

    public synchronized ToneType getPlayingTone() {
        return this.tone_state;
    }

    public synchronized void setPlayingTone(final ToneType newTone) {
        if (this.tone_state == newTone) {
            return;
        }
        if (newTone != null && this.config == null) {
            throw new IllegalStateException("no config set");
        }
        final StructConfigParameters config_copy = this.config;
        mainHandler.post(new Runnable(){

            @Override
            public void run() {
                if (newTone == null) {
                    TonePlayer.this.tone_at.pause();
                } else {
                    if (TonePlayer.this.tone_at_track != newTone) {
                        TonePlayer.this.releaseAudioTrack();
                    }
                    if (TonePlayer.this.tone_at == null) {
                        TonePlayer.this.tone_at = TonePlayer.getToneAudioTrack(config_copy, newTone == ToneType.T_2000Hz ? 2000 : 2400);
                        TonePlayer.this.tone_at_track = newTone;
                    }
                    if (TonePlayer.this.tone_at != null) {
                        TonePlayer.this.tone_at.play();
                    }
                }
            }
        });
        this.tone_state = newTone;
    }

    private void releaseAudioTrack() {
        if (this.tone_at != null) {
            this.tone_at.stop();
            this.tone_at.release();
            this.tone_at = null;
            this.tone_at_track = null;
            UMLog.i(TAG, "AudioTrack released");
        }
    }

    private static AudioTrack getToneAudioTrack(StructConfigParameters config, int squareWaveFreq) {
        int outputFreq = config.getFrequenceOutput();
        byte[] toneDataPeriod = Player.synthesizeSquareWavePeriod(config, squareWaveFreq, outputFreq);
        double staticAudioLenSec = 0.1;
        int periodCount = (int)((double)outputFreq * 0.1 / (double)(toneDataPeriod.length / 2));
        byte[] toneDataRepeated = new byte[toneDataPeriod.length * periodCount];
        for (int i = 0; i < periodCount; ++i) {
            System.arraycopy(toneDataPeriod, 0, toneDataRepeated, i * toneDataPeriod.length, toneDataPeriod.length);
        }
        AudioTrack ret = new AudioTrack(3, outputFreq, 12, 3, toneDataRepeated.length, 0);
        if (ret.write(toneDataRepeated, 0, toneDataRepeated.length) != toneDataRepeated.length) {
            ret.release();
            throw new RuntimeException();
        }
        if (ret.setLoopPoints(0, toneDataRepeated.length / 2, -1) != 0) {
            ret.release();
            throw new RuntimeException();
        }
        if (ret.getState() != 1) {
            throw new RuntimeException();
        }
        return ret;
    }
}

