/*
 * Decompiled with CFR 0.152.
 */
package com.idtechproducts.device.audiojack.tasks;

import com.idtechproducts.device.Common;
import com.idtechproducts.device.ResDataStruct;
import com.idtechproducts.device.audiojack.ReaderCommunication;
import com.idtechproducts.device.audiojack.UMLog;
import com.idtechproducts.device.audiojack.io.IOManager;
import com.idtechproducts.device.audiojack.tasks.Task;
import com.idtechproducts.device.audiojack.tasks.TaskManager;

public class CommandSynchroTask
extends Task {
    private final byte[] _cmd;

    public CommandSynchroTask(TaskManager umMan, ReaderCommunication readerCommunication, byte[] command) {
        super(umMan, readerCommunication);
        this._cmd = command;
    }

    @Override
    public TaskManager.TaskType getType() {
        return TaskManager.TaskType.Command;
    }

    @Override
    public void processSound() {
        UMLog.i(this.TAG, "command detected");
    }

    public boolean getResponse(ResDataStruct respData) {
        this.taskSetup();
        if (respData != null) {
            respData.resData = this.getResponse(0);
        } else {
            this.getResponse(1);
        }
        this.taskCleanup();
        UMLog.i(this.TAG, " to do task_signalStoppedStatus.");
        this._taskManager.task_signalStoppedStatus();
        UMLog.i(this.TAG, "task_signalStoppedStatus ok.");
        return true;
    }

    private byte[] getResponse(int mode) {
        IOManager.RPDResult r = mode == 1 ? this._readerCommunication.sendCommand(this._cmd, Common.commandTime, this, this) : this._readerCommunication.sendCommand(this._cmd, Common.commandTime + 2.0, this, this);
        if (r.isCanceledOrFailed()) {
            return null;
        }
        if (r.isTimedOut()) {
            return new byte[]{0};
        }
        if (r.data == null) {
            return null;
        }
        try {
            byte[] byArray;
            if (r.isParsed()) {
                byArray = r.data.get(0);
            } else {
                byte[] byArray2 = new byte[1];
                byArray = byArray2;
                byArray2[0] = 0;
            }
            byte[] returnedData = byArray;
            UMLog.i("**getResponse**", Common.getHexStringFromBytes(returnedData));
            return returnedData;
        }
        catch (IndexOutOfBoundsException e) {
            return new byte[]{0};
        }
    }

    @Override
    protected Runnable taskMain() {
        return null;
    }
}

