/*
 * Decompiled with CFR 0.152.
 */
package com.idtechproducts.device.audiojack.tasks;

import com.idtechproducts.device.Common;
import com.idtechproducts.device.audiojack.ReaderCommunication;
import com.idtechproducts.device.audiojack.io.IOManager;
import com.idtechproducts.device.audiojack.tasks.Task;
import com.idtechproducts.device.audiojack.tasks.TaskManager;
import com.idtechproducts.device.audiojack.tools.FirmwareUpdateToolMsg;

public class FwGetChallengeTask
extends Task {
    private final FirmwareUpdateToolMsg _umtMsg;

    public FwGetChallengeTask(TaskManager umMan, ReaderCommunication readerCommunication, FirmwareUpdateToolMsg umtMsg) {
        super(umMan, readerCommunication);
        this._umtMsg = umtMsg;
    }

    @Override
    public TaskManager.TaskType getType() {
        return TaskManager.TaskType.Command;
    }

    @Override
    protected Runnable taskMain() {
        IOManager.RPDResult r = this._readerCommunication.sendCommand(Common.makeSetBaudCommand(this._config), 1.5, this, this);
        if (r.isCanceledOrFailed()) {
            return null;
        }
        if (r.isParsed() && r.matches("len=15,[0]=x06,[1]=x56")) {
            return this.getBlmResponseRunnable(r.lastMatch);
        }
        for (int i = 0; i < 2; ++i) {
            r = this._readerCommunication.sendCommand(Common.base16Decode("02528003D3"), 3.0, this, this);
            if (r.isCanceledOrFailed()) {
                return null;
            }
            if (r.isTimedOut()) continue;
            if (r.matches("len=15,[0]=x06,[1]=x56")) {
                return this.getBlmResponseRunnable(r.lastMatch);
            }
            if (!r.matches("len=22,[0]=x06,[1]=x02,[-2]=x03") && !r.matches("len=1,[0]=x15")) continue;
            final byte[] dataReturned = r.lastMatch;
            return new Runnable(){

                @Override
                public void run() {
                    FwGetChallengeTask.this._umtMsg.onReceiveMsgChallengeResult(201, dataReturned);
                }
            };
        }
        return new Runnable(){

            @Override
            public void run() {
                FwGetChallengeTask.this._umtMsg.onReceiveMsgChallengeResult(204, null);
            }
        };
    }

    private Runnable getBlmResponseRunnable(final byte[] data) {
        return new Runnable(){

            @Override
            public void run() {
                FwGetChallengeTask.this._umtMsg.onReceiveMsgChallengeResult(205, data);
            }
        };
    }
}

