/*
 * Decompiled with CFR 0.152.
 */
package com.idtechproducts.device.audiojack.tasks;

import android.os.Handler;
import android.os.Looper;
import com.idtechproducts.device.Common;
import com.idtechproducts.device.audiojack.ReaderCommunication;
import com.idtechproducts.device.audiojack.UMLog;
import com.idtechproducts.device.audiojack.io.IOManager;
import com.idtechproducts.device.audiojack.tasks.Task;
import com.idtechproducts.device.audiojack.tasks.TaskManager;
import com.idtechproducts.device.audiojack.tools.FirmwareUpdateToolMsg;
import java.util.Locale;

public class FwUpdateTaskUniJack
extends Task {
    private final FirmwareUpdateToolMsg _umtMsg;
    private final byte[] _bin;
    private final byte[] _challengeResponse;

    private FwUpdateTaskUniJack(TaskManager umMan, ReaderCommunication readerCommunication, FirmwareUpdateToolMsg umtMsg, byte[] bin, byte[] challengeResponse) {
        super(umMan, readerCommunication);
        this._umtMsg = umtMsg;
        this._bin = bin;
        this._challengeResponse = challengeResponse;
    }

    @Override
    public TaskManager.TaskType getType() {
        return TaskManager.TaskType.FwUpdate;
    }

    @Override
    protected Runnable taskMain() {
        IOManager.RPDResult r;
        Runnable retTimeout = new Runnable(){

            @Override
            public void run() {
                UMLog.i(FwUpdateTaskUniJack.this.TAG, "notify timeout");
                FwUpdateTaskUniJack.this._umtMsg.onReceiveMsgUpdateFirmwareResult(305);
            }
        };
        Handler mainThreadHandler = new Handler(Looper.getMainLooper());
        Boolean isInBLM = null;
        int chkBlmTries = 3;
        for (int trial = 1; trial <= 3; ++trial) {
            r = this._readerCommunication.sendCommand(Common.makeSetBaudCommand(this._config), 3.5, this, this);
            if (r.isCanceledOrFailed()) {
                return null;
            }
            if (r.isParsed()) {
                if (r.matches("len=1,[0]=x06")) {
                    isInBLM = false;
                    break;
                }
                if (r.matches("len=2,[0]=x06,[1]=x56")) {
                    isInBLM = true;
                    break;
                }
            }
            if (trial != 3) continue;
            return retTimeout;
        }
        if (!isInBLM.booleanValue()) {
            boolean problemWithChallengeResponse;
            UMLog.i(this.TAG, "not in BLM");
            boolean bl = problemWithChallengeResponse = null == this._challengeResponse || this._challengeResponse.length != 24;
            if (problemWithChallengeResponse) {
                return new Runnable(){

                    @Override
                    public void run() {
                        UMLog.i(FwUpdateTaskUniJack.this.TAG, "notify need CR");
                        FwUpdateTaskUniJack.this._umtMsg.onReceiveMsgUpdateFirmwareResult(309);
                    }
                };
            }
            byte[] challengeResponseCmd = FwUpdateTaskUniJack.makeChallengeResponseCmd(this._challengeResponse);
            for (int trial = 1; trial <= 3; ++trial) {
                r = this._readerCommunication.sendCommand(challengeResponseCmd, 3.0, this, this);
                if (r.isCanceledOrFailed()) {
                    return null;
                }
                if (r.isParsed() && (r.matches("len=1,[0]=x06") || r.matches("len=15,[0]=x06,[1]=x56"))) break;
                if (trial != 3) continue;
                return new Runnable(){

                    @Override
                    public void run() {
                        UMLog.i(FwUpdateTaskUniJack.this.TAG, "notify failed to enter BLM");
                        FwUpdateTaskUniJack.this._umtMsg.onReceiveMsgUpdateFirmwareResult(302);
                    }
                };
            }
        }
        UMLog.i(this.TAG, "now in BLM");
        int BLOCK_SIZE = 1024;
        int BLOCK_COUNT = this._bin.length / 1024;
        block2: for (int curBlock = 0; curBlock < BLOCK_COUNT; ++curBlock) {
            final int progress = (int)((double)curBlock * 1.0 / (double)BLOCK_COUNT * 100.0);
            mainThreadHandler.post(new Runnable(){

                @Override
                public void run() {
                    FwUpdateTaskUniJack.this._umtMsg.onReceiveMsgUpdateFirmwareProgress(progress);
                }
            });
            byte[] blockCmd = new byte[1032];
            FwUpdateTaskUniJack.arrayAppend(blockCmd, 0, Common.base16Decode("025A9A"));
            blockCmd[3] = (byte)curBlock;
            System.arraycopy(this._bin, curBlock * 1024, blockCmd, 4, 1024);
            int binLrc = 0;
            byte binChecksum = 0;
            for (int i = 4; i < 1028; ++i) {
                binLrc = (byte)(binLrc ^ blockCmd[i]);
                binChecksum = (byte)(binChecksum + blockCmd[i]);
            }
            byte lrc = (byte)(binLrc ^ 2);
            lrc = (byte)(lrc ^ 0x5A);
            lrc = (byte)(lrc ^ 0x9A);
            lrc = (byte)(lrc ^ (byte)curBlock);
            lrc = (byte)(lrc ^ binLrc);
            lrc = (byte)(lrc ^ binChecksum);
            lrc = (byte)(lrc ^ 3);
            blockCmd[blockCmd.length - 4] = binLrc;
            blockCmd[blockCmd.length - 3] = binChecksum;
            blockCmd[blockCmd.length - 2] = 3;
            blockCmd[blockCmd.length - 1] = lrc;
            if (this.isCanceled()) {
                return null;
            }
            int sendBlockTries = 3;
            for (int sendTrialN = 1; sendTrialN <= 3; ++sendTrialN) {
                r = this._readerCommunication.sendCommand(blockCmd, 20.0, this, this);
                if (r.isCanceledOrFailed()) {
                    return null;
                }
                if (r.isParsed() && (r.matches("len=2,[0]=x06,[1]=x" + String.format(Locale.US, "%02X", curBlock)) || r.matches("len=1,[0]=x06"))) continue block2;
                if (sendTrialN != 3) continue;
                return new Runnable(){

                    @Override
                    public void run() {
                        UMLog.i(FwUpdateTaskUniJack.this.TAG, "notify send block failed");
                        FwUpdateTaskUniJack.this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                    }
                };
            }
        }
        mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                UMLog.i(FwUpdateTaskUniJack.this.TAG, "notify end block");
                FwUpdateTaskUniJack.this._umtMsg.onReceiveMsgUpdateFirmwareProgress(99);
            }
        });
        byte[] fwEndCommand = Common.base16Decode("025A9AEE0300");
        byte lrc = 0;
        for (int i = 0; i < 5; ++i) {
            lrc = (byte)(lrc ^ fwEndCommand[i]);
        }
        fwEndCommand[5] = lrc;
        r = this._readerCommunication.sendCommand(fwEndCommand, 3.0, this, this);
        if (r.isCanceledOrFailed()) {
            return null;
        }
        if (!r.isParsed() || !r.matches("len=2,[0]=x06,[1]=xEE") && !r.matches("len=1,[0]=x06")) {
            return new Runnable(){

                @Override
                public void run() {
                    UMLog.i(FwUpdateTaskUniJack.this.TAG, "notify end block failed");
                    FwUpdateTaskUniJack.this._umtMsg.onReceiveMsgUpdateFirmwareResult(304);
                }
            };
        }
        return new Runnable(){

            @Override
            public void run() {
                UMLog.i(FwUpdateTaskUniJack.this.TAG, "notify finished successfully");
                FwUpdateTaskUniJack.this._umtMsg.onReceiveMsgUpdateFirmwareProgress(100);
                FwUpdateTaskUniJack.this._umtMsg.onReceiveMsgUpdateFirmwareResult(301);
            }
        };
    }

    private static int arrayAppend(byte[] dst, int dstPos, byte[] src) {
        System.arraycopy(src, 0, dst, dstPos, src.length);
        return dstPos + src.length;
    }

    private static byte[] makeChallengeResponseCmd(byte[] cr) {
        byte[] cmdStart = Common.base16Decode("02537009FF");
        byte[] fullCmd = new byte[cmdStart.length + cr.length + 1 + 1];
        int offset = 0;
        offset = FwUpdateTaskUniJack.arrayAppend(fullCmd, offset, cmdStart);
        offset = FwUpdateTaskUniJack.arrayAppend(fullCmd, offset, cr);
        offset = FwUpdateTaskUniJack.arrayAppend(fullCmd, offset, new byte[]{3});
        byte lrc = 0;
        for (byte b : fullCmd) {
            lrc = (byte)(lrc ^ b);
        }
        fullCmd[fullCmd.length - 1] = lrc;
        return fullCmd;
    }
}

