/*
 * Decompiled with CFR 0.152.
 */
package com.idtechproducts.device.audiojack.tasks;

import com.idtechproducts.device.Common;
import com.idtechproducts.device.IDT_Device;
import com.idtechproducts.device.OnReceiverListener;
import com.idtechproducts.device.ReaderInfo;
import com.idtechproducts.device.ResDataStruct;
import com.idtechproducts.device.audiojack.ReaderCommunication;
import com.idtechproducts.device.audiojack.UMLog;
import com.idtechproducts.device.audiojack.tasks.Task;
import com.idtechproducts.device.audiojack.tasks.TaskManager;
import com.idtechproducts.device.bluetooth.IDTechBluetoothLE;
import com.idtechproducts.device.rs232.IDTechRS232;
import com.idtechproducts.device.usb.IDTechUsbHid;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.Locale;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.json.JSONException;
import org.json.JSONObject;

public class RemoteKeyInjectionTask
extends Task {
    private static final String REVA_DEMO_GEN4_URL = "https://demo-api.rki.idtechproducts.com/api/lrki/process";
    private static final String REVB_DEMO_GEN4_URL = "https://demo-api.rki.idtechproducts.com/api/srki/process";
    private static final String REVA_PROD_GEN4_URL = "https://api.rki.idtechproducts.com/api/lrki/process";
    private static final String REVB_PROD_GEN4_URL = "https://api.rki.idtechproducts.com/api/srki/process";
    private static final String PKI_DEMO_GEN4_URL = "https://demo-api.rki.idtechproducts.com/api/prki/process";
    private static final String PKI_PROD_GEN4_URL = "https://api.rki.idtechproducts.com/api/prki/process";
    public static String RKI_URL = "https://rki.idtechproducts.com:8443/RKS_WebService/rest/rki/";
    public static String SRKI_URL = "";
    public static String LSRKI_URL = "";
    public static boolean isDemo = false;
    private String fwVersion = null;
    private String deviceSn = null;
    private String keyName;
    private IDTechUsbHid _usb;
    private IDTechBluetoothLE _btle;
    private IDTechRS232 _com;
    private OnReceiverListener _callback;
    private IDT_Device.TaskExport _taskExport;

    protected RemoteKeyInjectionTask(TaskManager taskManager, ReaderCommunication umMan, OnReceiverListener callback, IDTechUsbHid usb, IDT_Device.TaskExport taskExport) {
        super(taskManager, umMan);
        this._callback = callback;
        this._usb = usb;
        this._taskExport = taskExport;
        this.keyName = null;
    }

    protected RemoteKeyInjectionTask(TaskManager taskManager, ReaderCommunication umMan, OnReceiverListener callback, IDTechRS232 com, IDT_Device.TaskExport taskExport) {
        super(taskManager, umMan);
        this._callback = callback;
        this._com = com;
        this._taskExport = taskExport;
        this.keyName = null;
    }

    protected RemoteKeyInjectionTask(TaskManager taskManager, ReaderCommunication umMan, OnReceiverListener callback, IDTechBluetoothLE btle, IDT_Device.TaskExport taskExport) {
        super(taskManager, umMan);
        this._callback = callback;
        this._btle = btle;
        this._taskExport = taskExport;
        this.keyName = null;
    }

    protected RemoteKeyInjectionTask(TaskManager taskManager, ReaderCommunication umMan, OnReceiverListener callback, IDTechUsbHid usb, IDT_Device.TaskExport taskExport, String Key2) {
        super(taskManager, umMan);
        this._callback = callback;
        this._usb = usb;
        this._taskExport = taskExport;
        this.keyName = Key2;
    }

    protected RemoteKeyInjectionTask(TaskManager taskManager, ReaderCommunication umMan, OnReceiverListener callback, IDTechRS232 com, IDT_Device.TaskExport taskExport, String Key2) {
        super(taskManager, umMan);
        this._callback = callback;
        this._com = com;
        this._taskExport = taskExport;
        this.keyName = Key2;
    }

    protected RemoteKeyInjectionTask(TaskManager taskManager, ReaderCommunication umMan, OnReceiverListener callback, IDTechBluetoothLE btle, IDT_Device.TaskExport taskExport, String Key2) {
        super(taskManager, umMan);
        this._callback = callback;
        this._btle = btle;
        this._taskExport = taskExport;
        this.keyName = Key2;
    }

    @Override
    public TaskManager.TaskType getType() {
        return TaskManager.TaskType.RemoteKeyInjection;
    }

    @Override
    protected Runnable taskMain() {
        block315: {
            byte[] sn;
            byte[] fw;
            byte[] res;
            byte[] fw2;
            byte[] sn2;
            boolean isRevB = false;
            if (this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY) {
                ResDataStruct fwResp = new ResDataStruct();
                ResDataStruct snResp = new ResDataStruct();
                TaskManager.TaskStartRet retFw = this._taskManager.task_start_command_for_fw(Common.makeCommand("7831", 200), fwResp);
                TaskManager.TaskStartRet retSn = this._taskManager.task_start_command_for_fw(Common.makeCommand("784602", 200), snResp);
                if (retFw != TaskManager.TaskStartRet.SUCCESS || retSn != TaskManager.TaskStartRet.SUCCESS || snResp.resData.length < 10) {
                    return new Runnable(){

                        @Override
                        public void run() {
                            UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to get FW version/Serial Number");
                            IDT_Device.isCommandRunning = false;
                            RemoteKeyInjectionTask.this._callback.timeout(258);
                        }
                    };
                }
                if (fwResp.resData[3] != 6 || snResp.resData[3] != 6) {
                    return new Runnable(){

                        @Override
                        public void run() {
                            UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to get FW version/Serial Number: received NAK");
                            IDT_Device.isCommandRunning = false;
                            RemoteKeyInjectionTask.this._callback.timeout(258);
                        }
                    };
                }
                UMLog.i(this.TAG, "Fw version, SN received successfully");
                this.fwVersion = Common.getHexStringFromBytes(fwResp.resData);
                this.deviceSn = Common.getHexStringFromBytes(snResp.resData);
            } else if (this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V) {
                ResDataStruct snResp = new ResDataStruct();
                TaskManager.TaskStartRet retSn = this._taskManager.task_start_command_for_fw(Common.grsiP2Command((byte)18, (byte)1, new byte[0]), snResp);
                if (retSn != TaskManager.TaskStartRet.SUCCESS || snResp.resData.length < 10) {
                    return new Runnable(){

                        @Override
                        public void run() {
                            UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to get Serial Number");
                            IDT_Device.isCommandRunning = false;
                            RemoteKeyInjectionTask.this._callback.timeout(258);
                        }
                    };
                }
                if (snResp.resData[11] != 0) {
                    return new Runnable(){

                        @Override
                        public void run() {
                            UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to get Serial Number: received NAK");
                            IDT_Device.isCommandRunning = false;
                            RemoteKeyInjectionTask.this._callback.timeout(258);
                        }
                    };
                }
                UMLog.i(this.TAG, "SN received successfully: " + this.deviceSn);
                byte[] ser = new byte[10];
                System.arraycopy(snResp.resData, 14, ser, 0, 10);
                this.deviceSn = Common.getAsciiFromByte(ser);
            } else if (this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI) {
                if (this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT) {
                    sn2 = this._btle.sendCommand(Common.getHexStringFromBytes(Common.grsiP2Command((byte)18, (byte)1, new byte[0])), 3);
                    fw2 = this._btle.sendCommand(Common.getHexStringFromBytes(Common.grsiP2Command((byte)41, (byte)0, new byte[0])), 3);
                } else if (this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
                    sn2 = this._com.sendCommand(Common.getHexStringFromBytes(Common.grsiP2Command((byte)18, (byte)1, new byte[0])), 2);
                    fw2 = this._com.sendCommand(Common.getHexStringFromBytes(Common.grsiP2Command((byte)41, (byte)0, new byte[0])), 2);
                } else {
                    sn2 = this._usb.sendCommand(Common.getHexStringFromBytes(Common.grsiP2Command((byte)18, (byte)1, new byte[0])), 2);
                    fw2 = this._usb.sendCommand(Common.getHexStringFromBytes(Common.grsiP2Command((byte)41, (byte)0, new byte[0])), 2);
                }
                if (sn2 == null || sn2.length < 10) {
                    return new Runnable(){

                        @Override
                        public void run() {
                            UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to get FW version/Serial Number");
                            IDT_Device.isCommandRunning = false;
                            RemoteKeyInjectionTask.this._callback.timeout(258);
                        }
                    };
                }
                if (sn2[11] != 0) {
                    return new Runnable(){

                        @Override
                        public void run() {
                            UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to get Serial Number: received NAK");
                            IDT_Device.isCommandRunning = false;
                            RemoteKeyInjectionTask.this._callback.timeout(258);
                        }
                    };
                }
                if (fw2 != null && fw2.length > 19) {
                    this.fwVersion = Common.getAsciiFromByte(fw2);
                    if (this.fwVersion.contains("v1.1")) {
                        isRevB = true;
                    }
                }
                if (this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI) {
                    isRevB = false;
                }
                byte[] ser = new byte[10];
                System.arraycopy(sn2, 14, ser, 0, 10);
                this.deviceSn = Common.getAsciiFromByte(ser);
                UMLog.i(this.TAG, "SN received successfully: " + this.deviceSn);
                if (isRevB) {
                    byte[] slice = Arrays.copyOfRange(sn2, 14, 24);
                    this.deviceSn = Common.byteToString(slice);
                    byte[] response = this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT ? this._btle.sendCommand(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-112, (byte)34, new byte[0])), 10) : (this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM ? this._com.sendCommand(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-112, (byte)34, new byte[0])), 8) : this._usb.sendCommand(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-112, (byte)34, new byte[0])), 8));
                    if (response == null || response.length < 16 || response[11] != 0) {
                        return new Runnable(){

                            @Override
                            public void run() {
                                UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to get Certificates");
                                IDT_Device.isCommandRunning = false;
                                RemoteKeyInjectionTask.this._callback.timeout(258);
                            }
                        };
                    }
                    int resLen = (response[12] & 0xFF) * 256 + (response[13] & 0xFF);
                    byte[] res2 = new byte[resLen];
                    System.arraycopy(response, 14, res2, 0, resLen);
                    this.fwVersion = Common.getHexStringFromBytes(res2);
                }
            } else if (this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
                if (this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
                    sn2 = this._btle.sendCommand(Common.getHexStringFromBytes(Common.grsiP2Command((byte)18, (byte)1, new byte[0])), 3);
                    fw2 = this._btle.sendCommand(Common.getHexStringFromBytes(Common.grsiP2Command((byte)41, (byte)0, new byte[0])), 3);
                } else {
                    sn2 = this._usb.sendCommand(Common.getHexStringFromBytes(Common.grsiP2Command((byte)18, (byte)1, new byte[0])), 2);
                    fw2 = this._usb.sendCommand(Common.getHexStringFromBytes(Common.grsiP2Command((byte)41, (byte)0, new byte[0])), 2);
                }
                if (sn2 == null || fw2 == null || sn2.length < 10 || fw2.length < 10) {
                    return new Runnable(){

                        @Override
                        public void run() {
                            UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to get FW version/Serial Number");
                            IDT_Device.isCommandRunning = false;
                            RemoteKeyInjectionTask.this._callback.timeout(258);
                        }
                    };
                }
                if (fw2[11] != 0 || sn2[11] != 0) {
                    return new Runnable(){

                        @Override
                        public void run() {
                            UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to get FW version/Serial Number: received NAK");
                            IDT_Device.isCommandRunning = false;
                            RemoteKeyInjectionTask.this._callback.timeout(258);
                        }
                    };
                }
                if (fw2 != null && fw2.length > 19 && fw2[14] == 75 && fw2[15] == 105 && fw2[16] == 111 && fw2[17] == 115 && fw2[18] == 107) {
                    fw2[14] = 78;
                    fw2[15] = 69;
                    fw2[16] = 79;
                    fw2[17] = 32;
                    fw2[18] = 32;
                }
                this.fwVersion = Common.getHexStringFromBytes(fw2);
                this.deviceSn = Common.getHexStringFromBytes(sn2).toLowerCase(Locale.US);
                if (this.deviceSn.startsWith("5669564f7465636832001200000f")) {
                    this.deviceSn = "5669564f7465636832001200000a" + this.deviceSn.substring(28, 52);
                }
                UMLog.i(this.TAG, "Fw version, SN received successfully: " + this.fwVersion + " / " + this.deviceSn);
            } else if (this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT) {
                byte[] certCSK;
                int certCSKLen;
                sn2 = this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT ? this._btle.sendCommand(Common.getHexStringFromBytes(Common.grsiP2Command((byte)18, (byte)1, new byte[0])), 3) : this._usb.sendCommand(Common.getHexStringFromBytes(Common.grsiP2Command((byte)18, (byte)1, new byte[0])), 2);
                if (sn2 == null || sn2.length < 10) {
                    return new Runnable(){

                        @Override
                        public void run() {
                            UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to get FW version/Serial Number");
                            IDT_Device.isCommandRunning = false;
                            RemoteKeyInjectionTask.this._callback.timeout(258);
                        }
                    };
                }
                if (sn2[11] != 0) {
                    return new Runnable(){

                        @Override
                        public void run() {
                            UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to get FW version/Serial Number: received NAK");
                            IDT_Device.isCommandRunning = false;
                            RemoteKeyInjectionTask.this._callback.timeout(258);
                        }
                    };
                }
                byte[] ser = new byte[10];
                System.arraycopy(sn2, 14, ser, 0, 10);
                this.deviceSn = Common.getAsciiFromByte(ser);
                UMLog.i(this.TAG, "SN received successfully: " + this.deviceSn);
                byte[] response = this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT ? this._btle.sendCommand(Common.getHexStringFromBytes(Common.grsiP2Command((byte)18, (byte)0, new byte[]{0})), 3) : this._usb.sendCommand(Common.getHexStringFromBytes(Common.grsiP2Command((byte)18, (byte)0, new byte[]{0})), 2);
                if (response == null || response.length < 10) {
                    return new Runnable(){

                        @Override
                        public void run() {
                            UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to send the command 0x12-00");
                            IDT_Device.isCommandRunning = false;
                            RemoteKeyInjectionTask.this._callback.timeout(258);
                        }
                    };
                }
                if (response[11] != 0) {
                    return new Runnable(){

                        @Override
                        public void run() {
                            UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to send the command 0x12-00: received NAK");
                            IDT_Device.isCommandRunning = false;
                            RemoteKeyInjectionTask.this._callback.timeout(258);
                        }
                    };
                }
                response = this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT ? this._btle.sendCommand(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-110, (byte)0, new byte[0])), 5) : this._usb.sendCommand(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-110, (byte)0, new byte[0])), 2);
                if (response == null || response.length < 16) {
                    return new Runnable(){

                        @Override
                        public void run() {
                            UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to send the command 0x92-00");
                            IDT_Device.isCommandRunning = false;
                            RemoteKeyInjectionTask.this._callback.timeout(258);
                        }
                    };
                }
                int resLen = (response[12] & 0xFF) * 256 + (response[13] & 0xFF);
                res = new byte[resLen];
                System.arraycopy(response, 14, res, 0, resLen);
                this.fwVersion = Common.getHexStringFromBytes(res);
                if (this.fwVersion.contains("066746F4D6020000")) {
                    certCSKLen = (res[5] & 0xFF) * 256 + (res[4] & 0xFF);
                    if (certCSKLen > resLen) {
                        return new Runnable(){

                            @Override
                            public void run() {
                                UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to get certCSK 1");
                                IDT_Device.isCommandRunning = false;
                                RemoteKeyInjectionTask.this._callback.timeout(259);
                            }
                        };
                    }
                    certCSK = new byte[certCSKLen];
                    System.arraycopy(res, 6, certCSK, 0, certCSKLen);
                    this.fwVersion = Common.getHexStringFromBytes(certCSK);
                } else if (resLen > 1020) {
                    certCSKLen = (res[0] & 0xFF) * 256 + (res[1] & 0xFF);
                    if (certCSKLen > resLen - 2) {
                        return new Runnable(){

                            @Override
                            public void run() {
                                UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to get certCSK 2");
                                IDT_Device.isCommandRunning = false;
                                RemoteKeyInjectionTask.this._callback.timeout(259);
                            }
                        };
                    }
                    certCSK = new byte[certCSKLen];
                    System.arraycopy(res, 2, certCSK, 0, certCSKLen);
                    this.fwVersion = Common.getHexStringFromBytes(certCSK);
                    int totalcsk = certCSKLen + 2;
                    if (resLen > totalcsk) {
                        int certCEKLen = (res[totalcsk] & 0xFF) * 256 + (res[totalcsk + 1] & 0xFF);
                        if (certCEKLen > resLen - (totalcsk + 2)) {
                            return new Runnable(){

                                @Override
                                public void run() {
                                    UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify command 0x92-00 response error 3");
                                    IDT_Device.isCommandRunning = false;
                                    RemoteKeyInjectionTask.this._callback.timeout(259);
                                }
                            };
                        }
                        byte[] certCEK = new byte[certCEKLen];
                        System.arraycopy(res, totalcsk + 2, certCEK, 0, certCEKLen);
                        this.fwVersion = this.fwVersion + ";" + Common.getHexStringFromBytes(certCEK);
                    }
                }
            } else if (this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III) {
                byte[] response;
                if (IDT_Device._isK4) {
                    sn2 = this._usb.sendCommand(Common.getHexStringFromBytes(Common.grsiP2Command((byte)18, (byte)1, new byte[0])), 2);
                    if (sn2 == null || sn2.length < 10) {
                        return new Runnable(){

                            @Override
                            public void run() {
                                UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to get Serial Number");
                                IDT_Device.isCommandRunning = false;
                                RemoteKeyInjectionTask.this._callback.timeout(258);
                            }
                        };
                    }
                    if (sn2[11] != 0) {
                        return new Runnable(){

                            @Override
                            public void run() {
                                UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to get Serial Number: received NAK");
                                IDT_Device.isCommandRunning = false;
                                RemoteKeyInjectionTask.this._callback.timeout(258);
                            }
                        };
                    }
                    byte[] slice = Arrays.copyOfRange(sn2, 14, 24);
                    this.deviceSn = Common.byteToString(slice);
                    response = this._usb.sendCommand(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-112, (byte)34, new byte[0])), 8);
                    if (response == null || response.length < 16) {
                        return new Runnable(){

                            @Override
                            public void run() {
                                UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to get Certificates");
                                IDT_Device.isCommandRunning = false;
                                RemoteKeyInjectionTask.this._callback.timeout(258);
                            }
                        };
                    }
                    int resLen = (response[12] & 0xFF) * 256 + (response[13] & 0xFF);
                    res = new byte[resLen];
                    System.arraycopy(response, 14, res, 0, resLen);
                    this.fwVersion = Common.getHexStringFromBytes(res);
                } else {
                    sn2 = this._usb.sendCommand(Common.getHexStringFromBytes(Common.grsiP2Command((byte)18, (byte)1, new byte[0])), 2);
                    if (sn2 == null || sn2.length < 10) {
                        return new Runnable(){

                            @Override
                            public void run() {
                                UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to get Serial Number");
                                IDT_Device.isCommandRunning = false;
                                RemoteKeyInjectionTask.this._callback.timeout(258);
                            }
                        };
                    }
                    if (sn2[11] != 0) {
                        return new Runnable(){

                            @Override
                            public void run() {
                                UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to get Serial Number: received NAK");
                                IDT_Device.isCommandRunning = false;
                                RemoteKeyInjectionTask.this._callback.timeout(258);
                            }
                        };
                    }
                    byte[] slice = Arrays.copyOfRange(sn2, 14, 24);
                    this.deviceSn = Common.byteToString(slice);
                    response = this._usb.sendCommand(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-112, (byte)34, new byte[0])), 8);
                    if (response == null || response.length < 16 || response[11] != 0) {
                        return new Runnable(){

                            @Override
                            public void run() {
                                UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to get Certificates");
                                IDT_Device.isCommandRunning = false;
                                RemoteKeyInjectionTask.this._callback.timeout(258);
                            }
                        };
                    }
                    int resLen = (response[12] & 0xFF) * 256 + (response[13] & 0xFF);
                    res = new byte[resLen];
                    System.arraycopy(response, 14, res, 0, resLen);
                    this.fwVersion = Common.getHexStringFromBytes(res);
                }
            } else if (this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_USB) {
                fw = this._usb.sendCommand("7831", 5);
                if (fw == null || fw.length <= 7) {
                    return new Runnable(){

                        @Override
                        public void run() {
                            UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to get FW version/Serial Number");
                            IDT_Device.isCommandRunning = false;
                            RemoteKeyInjectionTask.this._callback.timeout(258);
                        }
                    };
                }
                if (fw[3] != 6) {
                    return new Runnable(){

                        @Override
                        public void run() {
                            UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to get FW version/Serial Number: received NAK");
                            IDT_Device.isCommandRunning = false;
                            RemoteKeyInjectionTask.this._callback.timeout(258);
                        }
                    };
                }
                this.fwVersion = Common.getHexStringFromBytes(fw);
                UMLog.i(this.TAG, "FW version: " + this.fwVersion);
                sn = this._usb.sendCommand("784602", 5);
                if (sn == null || sn.length <= 7) {
                    return new Runnable(){

                        @Override
                        public void run() {
                            UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to get FW version/Serial Number");
                            IDT_Device.isCommandRunning = false;
                            RemoteKeyInjectionTask.this._callback.timeout(258);
                        }
                    };
                }
                if (sn[3] != 6) {
                    return new Runnable(){

                        @Override
                        public void run() {
                            UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to get FW version/Serial Number: received NAK");
                            IDT_Device.isCommandRunning = false;
                            RemoteKeyInjectionTask.this._callback.timeout(258);
                        }
                    };
                }
                this.deviceSn = Common.getHexStringFromBytes(sn);
                UMLog.i(this.TAG, "Device SN: " + this.deviceSn);
            } else if (this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA) {
                fw = this._usb.sendCommand("7831", 5);
                if (fw == null || fw.length <= 7) {
                    return new Runnable(){

                        @Override
                        public void run() {
                            UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to get FW version/Serial Number");
                            IDT_Device.isCommandRunning = false;
                            RemoteKeyInjectionTask.this._callback.timeout(258);
                        }
                    };
                }
                if (fw[3] != 6) {
                    return new Runnable(){

                        @Override
                        public void run() {
                            UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to get FW version/Serial Number: received NAK");
                            IDT_Device.isCommandRunning = false;
                            RemoteKeyInjectionTask.this._callback.timeout(258);
                        }
                    };
                }
                byte[] fwbytes = new byte[fw.length - 7];
                System.arraycopy(fw, 4, fwbytes, 0, fwbytes.length);
                this.fwVersion = Common.getAsciiFromByte(fwbytes);
                UMLog.i(this.TAG, "FW version: " + this.fwVersion);
                int verPos = this.fwVersion.indexOf(86);
                String ver = this.fwVersion.substring(verPos, verPos + 5);
                isRevB = this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II ? ver.compareTo("V2.03") >= 0 : ver.compareTo("V1.03") >= 0;
                byte[] sn3 = this._usb.sendCommand("784602", 5);
                if (sn3 == null || sn3.length <= 7) {
                    return new Runnable(){

                        @Override
                        public void run() {
                            UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to get FW version/Serial Number");
                            IDT_Device.isCommandRunning = false;
                            RemoteKeyInjectionTask.this._callback.timeout(258);
                        }
                    };
                }
                if (sn3[3] != 6) {
                    return new Runnable(){

                        @Override
                        public void run() {
                            UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to get FW version/Serial Number: received NAK");
                            IDT_Device.isCommandRunning = false;
                            RemoteKeyInjectionTask.this._callback.timeout(258);
                        }
                    };
                }
                byte[] snbytes = new byte[10];
                System.arraycopy(sn3, 4, snbytes, 0, 10);
                this.deviceSn = Common.getAsciiFromByte(snbytes);
                UMLog.i(this.TAG, "Device SN: " + this.deviceSn);
            } else if (this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG_KB) {
                fw = this._usb.sendCommand("0252220371", 3);
                if (fw == null || fw.length < 4) {
                    return new Runnable(){

                        @Override
                        public void run() {
                            UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to get FW version/Serial Number");
                            IDT_Device.isCommandRunning = false;
                            RemoteKeyInjectionTask.this._callback.timeout(258);
                        }
                    };
                }
                if (fw[0] != 6) {
                    return new Runnable(){

                        @Override
                        public void run() {
                            UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to get FW version/Serial Number: received NAK");
                            IDT_Device.isCommandRunning = false;
                            RemoteKeyInjectionTask.this._callback.timeout(258);
                        }
                    };
                }
                this.fwVersion = Common.getHexStringFromBytes(fw);
                UMLog.i(this.TAG, "FW version: " + this.fwVersion);
                sn = this._usb.sendCommand("02524E031D", 7);
                if (sn == null || sn.length < 7) {
                    return new Runnable(){

                        @Override
                        public void run() {
                            UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to get FW version/Serial Number");
                            IDT_Device.isCommandRunning = false;
                            RemoteKeyInjectionTask.this._callback.timeout(258);
                        }
                    };
                }
                if (sn[0] != 6) {
                    return new Runnable(){

                        @Override
                        public void run() {
                            UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to get FW version/Serial Number: received NAK");
                            IDT_Device.isCommandRunning = false;
                            RemoteKeyInjectionTask.this._callback.timeout(258);
                        }
                    };
                }
                this.deviceSn = Common.getHexStringFromBytes(sn);
                UMLog.i(this.TAG, "Device SN: " + this.deviceSn);
            } else {
                return new Runnable(){

                    @Override
                    public void run() {
                        UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify RKI failed: unsupported device");
                        IDT_Device.isCommandRunning = false;
                        RemoteKeyInjectionTask.this._callback.timeout(258);
                    }
                };
            }
            try {
                byte[] resp;
                byte[] resp2;
                JSONObject authObj = null;
                Object result = null;
                String strResponse = "";
                HttpsURLConnection connHttps = null;
                HttpURLConnection connHttp = null;
                DataOutputStream writer = null;
                BufferedReader reader = null;
                OutputStream ostream = null;
                InputStream istream = null;
                URL url = null;
                String soap_action = "";
                String rkiUrl = "";
                if (this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II) {
                    byte[] resp3 = isRevB ? this._usb.sendCommand("55524B4933", 5) : this._usb.sendCommand("55524B4930", 5);
                    if (resp3 == null || resp3.length < 29) {
                        return new Runnable(){

                            @Override
                            public void run() {
                                UMLog.i(RemoteKeyInjectionTask.this.TAG, "Response length is too short");
                                IDT_Device.isCommandRunning = false;
                                RemoteKeyInjectionTask.this._callback.timeout(258);
                            }
                        };
                    }
                    if (resp3[3] != 6) {
                        final String cmd = isRevB ? "55524B4933" : "55524B4930";
                        return new Runnable(){

                            @Override
                            public void run() {
                                UMLog.i(RemoteKeyInjectionTask.this.TAG, "received NAK for command " + cmd);
                                IDT_Device.isCommandRunning = false;
                                RemoteKeyInjectionTask.this._callback.timeout(258);
                            }
                        };
                    }
                    String respStr = Common.getHexStringFromBytes(resp3);
                    UMLog.i(this.TAG, "Response String 1: " + respStr);
                    int len = respStr.length();
                    String strData = respStr.substring(8, len - 6).toUpperCase(Locale.US);
                    rkiUrl = LSRKI_URL.length() > 0 ? LSRKI_URL : REVA_PROD_GEN4_URL;
                    try {
                        int end;
                        int start;
                        url = new URL(rkiUrl);
                        if (rkiUrl.contains("https:")) {
                            connHttps = (HttpsURLConnection)url.openConnection();
                            connHttps.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
                            connHttps.setRequestMethod("POST");
                            connHttps.setConnectTimeout(15000);
                            connHttps.setReadTimeout(35000);
                            connHttps.setDoInput(true);
                            connHttps.setDoOutput(true);
                            connHttps.setUseCaches(false);
                            ostream = connHttps.getOutputStream();
                        } else {
                            connHttp = (HttpURLConnection)url.openConnection();
                            connHttp.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
                            connHttp.setRequestMethod("POST");
                            connHttp.setConnectTimeout(15000);
                            connHttp.setReadTimeout(35000);
                            connHttp.setDoInput(true);
                            connHttp.setDoOutput(true);
                            connHttp.setUseCaches(false);
                            ostream = connHttp.getOutputStream();
                        }
                        writer = new DataOutputStream(ostream);
                        soap_action = "IDTECH01" + this.deviceSn + strData;
                        if (this.keyName != null && this.keyName.length() > 0) {
                            soap_action = soap_action + ";" + this.keyName;
                        }
                        UMLog.i(this.TAG, "1. URL: " + rkiUrl + "\nDATA: " + soap_action);
                        writer.writeBytes(soap_action);
                        writer.flush();
                        writer.close();
                        ostream.close();
                        istream = rkiUrl.contains("https:") ? connHttps.getInputStream() : connHttp.getInputStream();
                        reader = new BufferedReader(new InputStreamReader(istream));
                        String line = "";
                        while ((line = reader.readLine()) != null) {
                            strResponse = strResponse + line;
                        }
                        UMLog.i(this.TAG, "[Response 1] " + strResponse);
                        reader.close();
                        istream.close();
                        if (rkiUrl.contains("https:")) {
                            connHttps.disconnect();
                        } else {
                            connHttp.disconnect();
                        }
                        if (strResponse != null && strResponse.length() > 0) {
                            if (strResponse.charAt(0) == '<') {
                                int start2 = strResponse.indexOf("IDTECH");
                                int end2 = strResponse.lastIndexOf(60);
                                if (start2 == -1 || end2 == -1 || start2 >= end2) {
                                    return new Runnable(){

                                        @Override
                                        public void run() {
                                            UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to parse data from server for < >");
                                            IDT_Device.isCommandRunning = false;
                                            RemoteKeyInjectionTask.this._callback.timeout(258);
                                        }
                                    };
                                }
                                strResponse = strResponse.substring(start2, end2);
                                strResponse = "\"" + strResponse + "\"";
                            } else if (strResponse.charAt(0) != '\"') {
                                strResponse = "\"" + strResponse + "\"";
                            }
                        }
                        if (strResponse == null || strResponse.length() <= 9 || strResponse.charAt(9) != 'Y') {
                            return new Runnable(){

                                @Override
                                public void run() {
                                    UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to parse data from server");
                                    IDT_Device.isCommandRunning = false;
                                    RemoteKeyInjectionTask.this._callback.timeout(258);
                                }
                            };
                        }
                        len = strResponse.length();
                        String command = isRevB ? "55524B4934" + strResponse.substring(10, len - 1) : "55524B4931" + strResponse.substring(10, len - 1);
                        resp3 = this._usb.sendCommand(command, 5);
                        if (resp3 == null || resp3.length < 29) {
                            return new Runnable(){

                                @Override
                                public void run() {
                                    UMLog.i(RemoteKeyInjectionTask.this.TAG, "Response length is too short");
                                    IDT_Device.isCommandRunning = false;
                                    RemoteKeyInjectionTask.this._callback.timeout(258);
                                }
                            };
                        }
                        if (resp3[3] != 6) {
                            final String cmd = isRevB ? "55524B4934" : "55524B4931";
                            return new Runnable(){

                                @Override
                                public void run() {
                                    UMLog.i(RemoteKeyInjectionTask.this.TAG, "received NAK for command " + cmd);
                                    IDT_Device.isCommandRunning = false;
                                    RemoteKeyInjectionTask.this._callback.timeout(258);
                                }
                            };
                        }
                        respStr = Common.getHexStringFromBytes(resp3);
                        UMLog.i(this.TAG, "Response String 2: " + respStr);
                        len = respStr.length();
                        strData = respStr.substring(8, len - 6).toUpperCase(Locale.US);
                        if (rkiUrl.contains("https:")) {
                            connHttps = (HttpsURLConnection)url.openConnection();
                            connHttps.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
                            connHttps.setRequestMethod("POST");
                            connHttps.setConnectTimeout(15000);
                            connHttps.setReadTimeout(35000);
                            connHttps.setDoInput(true);
                            connHttps.setDoOutput(true);
                            connHttps.setUseCaches(false);
                            ostream = connHttps.getOutputStream();
                        } else {
                            connHttp = (HttpURLConnection)url.openConnection();
                            connHttp.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
                            connHttp.setRequestMethod("POST");
                            connHttp.setConnectTimeout(15000);
                            connHttp.setReadTimeout(35000);
                            connHttp.setDoInput(true);
                            connHttp.setDoOutput(true);
                            connHttp.setUseCaches(false);
                            ostream = connHttp.getOutputStream();
                        }
                        writer = new DataOutputStream(ostream);
                        soap_action = "IDTECH02" + this.deviceSn + strData;
                        UMLog.i(this.TAG, "2. URL: " + rkiUrl + "\nDATA: " + soap_action);
                        writer.writeBytes(soap_action);
                        writer.flush();
                        writer.close();
                        ostream.close();
                        istream = rkiUrl.contains("https:") ? connHttps.getInputStream() : connHttp.getInputStream();
                        reader = new BufferedReader(new InputStreamReader(istream));
                        line = "";
                        strResponse = "";
                        while ((line = reader.readLine()) != null) {
                            strResponse = strResponse + line;
                        }
                        UMLog.i(this.TAG, "[Response 2] " + strResponse);
                        reader.close();
                        istream.close();
                        if (rkiUrl.contains("https:")) {
                            connHttps.disconnect();
                        } else {
                            connHttp.disconnect();
                        }
                        if (strResponse != null && strResponse.length() > 0) {
                            if (strResponse.charAt(0) == '<') {
                                start = strResponse.indexOf("IDTECH");
                                end = strResponse.lastIndexOf(60);
                                if (start == -1 || end == -1 || start >= end) {
                                    return new Runnable(){

                                        @Override
                                        public void run() {
                                            UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to parse data from server for < >");
                                            IDT_Device.isCommandRunning = false;
                                            RemoteKeyInjectionTask.this._callback.timeout(258);
                                        }
                                    };
                                }
                                strResponse = strResponse.substring(start, end);
                                strResponse = "\"" + strResponse + "\"";
                            } else if (strResponse.charAt(0) != '\"') {
                                strResponse = "\"" + strResponse + "\"";
                            }
                        }
                        if (strResponse == null || strResponse.length() <= 9 || strResponse.charAt(9) != 'Y') {
                            return new Runnable(){

                                @Override
                                public void run() {
                                    UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to parse data from server");
                                    IDT_Device.isCommandRunning = false;
                                    RemoteKeyInjectionTask.this._callback.timeout(259);
                                }
                            };
                        }
                        len = strResponse.length();
                        command = isRevB ? "55524B4935" + strResponse.substring(10, len - 1) : "55524B4932" + strResponse.substring(10, len - 1);
                        resp3 = this._usb.sendCommand(command, 5);
                        if (resp3 == null || isRevB && resp3.length < 29 || !isRevB && resp3.length < 6) {
                            return new Runnable(){

                                @Override
                                public void run() {
                                    UMLog.i(RemoteKeyInjectionTask.this.TAG, "Response length is too short");
                                    IDT_Device.isCommandRunning = false;
                                    RemoteKeyInjectionTask.this._callback.timeout(258);
                                }
                            };
                        }
                        if (resp3[3] != 6) {
                            final String cmd = isRevB ? "55524B4935" : "55524B4932";
                            return new Runnable(){

                                @Override
                                public void run() {
                                    UMLog.i(RemoteKeyInjectionTask.this.TAG, "received NAK for command " + cmd);
                                    IDT_Device.isCommandRunning = false;
                                    RemoteKeyInjectionTask.this._callback.timeout(258);
                                }
                            };
                        }
                        respStr = Common.getHexStringFromBytes(resp3);
                        UMLog.i(this.TAG, "Response String 3: " + respStr);
                        len = respStr.length();
                        strData = respStr.substring(8, len - 6).toUpperCase(Locale.US);
                        if (rkiUrl.contains("https:")) {
                            connHttps = (HttpsURLConnection)url.openConnection();
                            connHttps.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
                            connHttps.setRequestMethod("POST");
                            connHttps.setConnectTimeout(15000);
                            connHttps.setReadTimeout(35000);
                            connHttps.setDoInput(true);
                            connHttps.setDoOutput(true);
                            connHttps.setUseCaches(false);
                            ostream = connHttps.getOutputStream();
                        } else {
                            connHttp = (HttpURLConnection)url.openConnection();
                            connHttp.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
                            connHttp.setRequestMethod("POST");
                            connHttp.setConnectTimeout(15000);
                            connHttp.setReadTimeout(35000);
                            connHttp.setDoInput(true);
                            connHttp.setDoOutput(true);
                            connHttp.setUseCaches(false);
                            ostream = connHttp.getOutputStream();
                        }
                        writer = new DataOutputStream(ostream);
                        soap_action = "IDTECH03" + this.deviceSn + strData;
                        UMLog.i(this.TAG, "3. URL: " + rkiUrl + "\nDATA: " + soap_action);
                        writer.writeBytes(soap_action);
                        writer.flush();
                        writer.close();
                        ostream.close();
                        istream = rkiUrl.contains("https:") ? connHttps.getInputStream() : connHttp.getInputStream();
                        reader = new BufferedReader(new InputStreamReader(istream));
                        line = "";
                        strResponse = "";
                        while ((line = reader.readLine()) != null) {
                            strResponse = strResponse + line;
                        }
                        UMLog.i(this.TAG, "[Response 3] " + strResponse);
                        reader.close();
                        istream.close();
                        if (rkiUrl.contains("https:")) {
                            connHttps.disconnect();
                        } else {
                            connHttp.disconnect();
                        }
                        if (strResponse != null && strResponse.length() > 0) {
                            if (strResponse.charAt(0) == '<') {
                                start = strResponse.indexOf("IDTECH");
                                end = strResponse.lastIndexOf(60);
                                if (start == -1 || end == -1 || start >= end) {
                                    return new Runnable(){

                                        @Override
                                        public void run() {
                                            UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to parse data from server for < >");
                                            IDT_Device.isCommandRunning = false;
                                            RemoteKeyInjectionTask.this._callback.timeout(258);
                                        }
                                    };
                                }
                                strResponse = strResponse.substring(start, end);
                                strResponse = "\"" + strResponse + "\"";
                            } else if (strResponse.charAt(0) != '\"') {
                                strResponse = "\"" + strResponse + "\"";
                            }
                        }
                        if (strResponse != null && strResponse.length() > 9 && strResponse.charAt(9) == 'Y') {
                            return new Runnable(){

                                @Override
                                public void run() {
                                    UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify RKI Success");
                                    IDT_Device.isCommandRunning = false;
                                    RemoteKeyInjectionTask.this._callback.msgRKICompleted("00");
                                }
                            };
                        }
                        return new Runnable(){

                            @Override
                            public void run() {
                                UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify RKI timeout");
                                IDT_Device.isCommandRunning = false;
                                RemoteKeyInjectionTask.this._callback.timeout(257);
                            }
                        };
                    }
                    catch (Exception E) {
                        System.out.println("Exception While Connecting: " + E.getMessage());
                        UMLog.i(this.TAG, "Exception While Connecting: " + E.getMessage());
                        StringWriter sw = new StringWriter();
                        PrintWriter pw = new PrintWriter(sw);
                        E.printStackTrace(pw);
                        UMLog.i(this.TAG, sw.toString());
                        E.printStackTrace();
                        break block315;
                    }
                }
                if (this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || isRevB) {
                    if (this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III && isDemo) {
                        isRevB = true;
                    }
                    if (isRevB) {
                        rkiUrl = this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III ? (isDemo ? (SRKI_URL.length() > 0 ? SRKI_URL : REVB_DEMO_GEN4_URL) : (SRKI_URL.length() > 0 ? SRKI_URL : REVB_PROD_GEN4_URL)) : (isDemo ? (LSRKI_URL.length() > 0 ? LSRKI_URL : REVB_DEMO_GEN4_URL) : (LSRKI_URL.length() > 0 ? LSRKI_URL : REVB_PROD_GEN4_URL));
                        try {
                            int end;
                            int start;
                            UMLog.i(this.TAG, "URL: " + rkiUrl + "\n");
                            url = new URL(rkiUrl);
                            if (rkiUrl.contains("https:")) {
                                connHttps = (HttpsURLConnection)url.openConnection();
                                connHttps.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
                                connHttps.setRequestMethod("POST");
                                connHttps.setConnectTimeout(15000);
                                connHttps.setReadTimeout(35000);
                                connHttps.setDoInput(true);
                                connHttps.setDoOutput(true);
                                connHttps.setUseCaches(false);
                                ostream = connHttps.getOutputStream();
                            } else {
                                connHttp = (HttpURLConnection)url.openConnection();
                                connHttp.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
                                connHttp.setRequestMethod("POST");
                                connHttp.setConnectTimeout(15000);
                                connHttp.setReadTimeout(35000);
                                connHttp.setDoInput(true);
                                connHttp.setDoOutput(true);
                                connHttp.setUseCaches(false);
                                ostream = connHttp.getOutputStream();
                            }
                            writer = new DataOutputStream(ostream);
                            soap_action = "IDTECH01" + this.deviceSn + this.fwVersion;
                            if (this.keyName != null && this.keyName.length() > 0) {
                                soap_action = soap_action + ";" + this.keyName;
                            }
                            UMLog.i(this.TAG, "1. URL: " + rkiUrl + "\nDATA: " + soap_action);
                            writer.writeBytes(soap_action);
                            writer.flush();
                            writer.close();
                            ostream.close();
                            istream = rkiUrl.contains("https:") ? connHttps.getInputStream() : connHttp.getInputStream();
                            reader = new BufferedReader(new InputStreamReader(istream));
                            String line = "";
                            while ((line = reader.readLine()) != null) {
                                strResponse = strResponse + line;
                            }
                            UMLog.i(this.TAG, "[Response 1] " + strResponse);
                            reader.close();
                            istream.close();
                            if (rkiUrl.contains("https:")) {
                                connHttps.disconnect();
                            } else {
                                connHttp.disconnect();
                            }
                            if (strResponse != null && strResponse.length() > 0) {
                                if (strResponse.charAt(0) == '<') {
                                    int start3 = strResponse.indexOf("IDTECH");
                                    int end3 = strResponse.lastIndexOf(60);
                                    if (start3 == -1 || end3 == -1 || start3 >= end3) {
                                        return new Runnable(){

                                            @Override
                                            public void run() {
                                                UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to parse data from server for < >");
                                                IDT_Device.isCommandRunning = false;
                                                RemoteKeyInjectionTask.this._callback.timeout(258);
                                            }
                                        };
                                    }
                                    strResponse = strResponse.substring(start3, end3);
                                    strResponse = "\"" + strResponse + "\"";
                                } else if (strResponse.charAt(0) != '\"') {
                                    strResponse = "\"" + strResponse + "\"";
                                }
                            }
                            if (strResponse == null || strResponse.length() <= 9 || strResponse.charAt(9) != 'Y') {
                                return new Runnable(){

                                    @Override
                                    public void run() {
                                        UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to parse data from server");
                                        IDT_Device.isCommandRunning = false;
                                        RemoteKeyInjectionTask.this._callback.timeout(258);
                                    }
                                };
                            }
                            byte[] data = Common.base16Decode(strResponse.substring(10, 94));
                            byte[] Response2 = this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT ? this._btle.sendCommand(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-112, (byte)35, data)), 10) : (this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM ? this._com.sendCommand(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-112, (byte)35, data)), 8) : this._usb.sendCommand(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-112, (byte)35, data)), 8));
                            if (Response2 == null || Response2.length < 16 || Response2[11] != 0) {
                                return new Runnable(){

                                    @Override
                                    public void run() {
                                        UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to get Certificates");
                                        IDT_Device.isCommandRunning = false;
                                        RemoteKeyInjectionTask.this._callback.timeout(259);
                                    }
                                };
                            }
                            int RespLen = (Response2[12] & 0xFF) * 256 + (Response2[13] & 0xFF);
                            byte[] Resp = new byte[RespLen];
                            System.arraycopy(Response2, 14, Resp, 0, RespLen);
                            strResponse = Common.getHexStringFromBytes(Resp);
                            soap_action = "IDTECH02" + this.deviceSn + strResponse;
                            UMLog.i(this.TAG, "2. URL: " + rkiUrl + "\nDATA: " + soap_action);
                            if (rkiUrl.contains("https:")) {
                                connHttps = (HttpsURLConnection)url.openConnection();
                                connHttps.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
                                connHttps.setRequestMethod("POST");
                                connHttps.setConnectTimeout(15000);
                                connHttps.setReadTimeout(35000);
                                connHttps.setDoInput(true);
                                connHttps.setDoOutput(true);
                                connHttps.setUseCaches(false);
                                ostream = connHttps.getOutputStream();
                            } else {
                                connHttp = (HttpURLConnection)url.openConnection();
                                connHttp.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
                                connHttp.setRequestMethod("POST");
                                connHttp.setConnectTimeout(15000);
                                connHttp.setReadTimeout(35000);
                                connHttp.setDoInput(true);
                                connHttp.setDoOutput(true);
                                connHttp.setUseCaches(false);
                                ostream = connHttp.getOutputStream();
                            }
                            writer = new DataOutputStream(ostream);
                            writer.writeBytes(soap_action);
                            writer.flush();
                            writer.close();
                            ostream.close();
                            istream = rkiUrl.contains("https:") ? connHttps.getInputStream() : connHttp.getInputStream();
                            reader = new BufferedReader(new InputStreamReader(istream));
                            line = "";
                            strResponse = "";
                            while ((line = reader.readLine()) != null) {
                                strResponse = strResponse + line;
                            }
                            UMLog.i(this.TAG, "[Response 2] " + strResponse);
                            reader.close();
                            istream.close();
                            if (rkiUrl.contains("https:")) {
                                connHttps.disconnect();
                            } else {
                                connHttp.disconnect();
                            }
                            if (strResponse != null && strResponse.length() > 0) {
                                if (strResponse.charAt(0) == '<') {
                                    start = strResponse.indexOf("IDTECH");
                                    end = strResponse.lastIndexOf(60);
                                    if (start == -1 || end == -1 || start >= end) {
                                        return new Runnable(){

                                            @Override
                                            public void run() {
                                                UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to parse data from server for < >");
                                                IDT_Device.isCommandRunning = false;
                                                RemoteKeyInjectionTask.this._callback.timeout(258);
                                            }
                                        };
                                    }
                                    strResponse = strResponse.substring(start, end);
                                    strResponse = "\"" + strResponse + "\"";
                                } else if (strResponse.charAt(0) != '\"') {
                                    strResponse = "\"" + strResponse + "\"";
                                }
                            }
                            if (strResponse == null || strResponse.length() <= 9 || strResponse.charAt(9) != 'Y') {
                                return new Runnable(){

                                    @Override
                                    public void run() {
                                        UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to parse data from server");
                                        IDT_Device.isCommandRunning = false;
                                        RemoteKeyInjectionTask.this._callback.timeout(259);
                                    }
                                };
                            }
                            data = Common.base16Decode(strResponse.substring(10, strResponse.length() - 1));
                            Response2 = this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT ? this._btle.sendCommand(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-112, (byte)36, data)), 10) : (this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM ? this._com.sendCommand(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-112, (byte)36, data)), 8) : this._usb.sendCommand(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-112, (byte)36, data)), 8));
                            if (Response2 == null || Response2.length < 16 || Response2[11] != 0) {
                                return new Runnable(){

                                    @Override
                                    public void run() {
                                        UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to get Certificates");
                                        IDT_Device.isCommandRunning = false;
                                        RemoteKeyInjectionTask.this._callback.timeout(259);
                                    }
                                };
                            }
                            RespLen = (Response2[12] & 0xFF) * 256 + (Response2[13] & 0xFF);
                            Resp = new byte[RespLen];
                            System.arraycopy(Response2, 14, Resp, 0, RespLen);
                            strResponse = Common.getHexStringFromBytes(Resp);
                            soap_action = "IDTECH03" + this.deviceSn + strResponse;
                            UMLog.i(this.TAG, "3. URL: " + rkiUrl + "\nDATA: " + soap_action);
                            if (rkiUrl.contains("https:")) {
                                connHttps = (HttpsURLConnection)url.openConnection();
                                connHttps.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
                                connHttps.setRequestMethod("POST");
                                connHttps.setConnectTimeout(15000);
                                connHttps.setReadTimeout(35000);
                                connHttps.setDoInput(true);
                                connHttps.setDoOutput(true);
                                connHttps.setUseCaches(false);
                                ostream = connHttps.getOutputStream();
                            } else {
                                connHttp = (HttpURLConnection)url.openConnection();
                                connHttp.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
                                connHttp.setRequestMethod("POST");
                                connHttp.setConnectTimeout(15000);
                                connHttp.setReadTimeout(35000);
                                connHttp.setDoInput(true);
                                connHttp.setDoOutput(true);
                                connHttp.setUseCaches(false);
                                ostream = connHttp.getOutputStream();
                            }
                            writer = new DataOutputStream(ostream);
                            writer.writeBytes(soap_action);
                            writer.flush();
                            writer.close();
                            ostream.close();
                            istream = rkiUrl.contains("https:") ? connHttps.getInputStream() : connHttp.getInputStream();
                            reader = new BufferedReader(new InputStreamReader(istream));
                            line = "";
                            strResponse = "";
                            while ((line = reader.readLine()) != null) {
                                strResponse = strResponse + line;
                            }
                            UMLog.i(this.TAG, "[Response 3] " + strResponse);
                            reader.close();
                            istream.close();
                            if (rkiUrl.contains("https:")) {
                                connHttps.disconnect();
                            } else {
                                connHttp.disconnect();
                            }
                            if (strResponse != null && strResponse.length() > 0) {
                                if (strResponse.charAt(0) == '<') {
                                    start = strResponse.indexOf("IDTECH");
                                    end = strResponse.lastIndexOf(60);
                                    if (start == -1 || end == -1 || start >= end) {
                                        return new Runnable(){

                                            @Override
                                            public void run() {
                                                UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to parse data from server for < >");
                                                IDT_Device.isCommandRunning = false;
                                                RemoteKeyInjectionTask.this._callback.timeout(258);
                                            }
                                        };
                                    }
                                    strResponse = strResponse.substring(start, end);
                                    strResponse = "\"" + strResponse + "\"";
                                } else if (strResponse.charAt(0) != '\"') {
                                    strResponse = "\"" + strResponse + "\"";
                                }
                            }
                            if (strResponse != null && strResponse.length() > 9 && strResponse.charAt(9) == 'Y') {
                                return new Runnable(){

                                    @Override
                                    public void run() {
                                        UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify RKI Success");
                                        IDT_Device.isCommandRunning = false;
                                        RemoteKeyInjectionTask.this._callback.msgRKICompleted("00");
                                    }
                                };
                            }
                            return new Runnable(){

                                @Override
                                public void run() {
                                    UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify RKI timeout");
                                    IDT_Device.isCommandRunning = false;
                                    RemoteKeyInjectionTask.this._callback.timeout(257);
                                }
                            };
                        }
                        catch (Exception E) {
                            System.out.println("Exception While Connecting: " + E.getMessage());
                            UMLog.i(this.TAG, "Exception While Connecting: " + E.getMessage());
                            StringWriter sw = new StringWriter();
                            PrintWriter pw = new PrintWriter(sw);
                            E.printStackTrace(pw);
                            UMLog.i(this.TAG, sw.toString());
                            E.printStackTrace();
                            break block315;
                        }
                    }
                    rkiUrl = isDemo ? (SRKI_URL.length() > 0 ? SRKI_URL : REVB_DEMO_GEN4_URL) : (SRKI_URL.length() > 0 ? SRKI_URL : REVB_PROD_GEN4_URL);
                    try {
                        int end;
                        int start;
                        UMLog.i(this.TAG, "URL: " + rkiUrl + "\n");
                        url = new URL(rkiUrl);
                        if (rkiUrl.contains("https:")) {
                            connHttps = (HttpsURLConnection)url.openConnection();
                            connHttps.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
                            connHttps.setRequestMethod("POST");
                            connHttps.setConnectTimeout(15000);
                            connHttps.setReadTimeout(35000);
                            connHttps.setDoInput(true);
                            connHttps.setDoOutput(true);
                            connHttps.setUseCaches(false);
                        } else {
                            connHttp = (HttpURLConnection)url.openConnection();
                            connHttp.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
                            connHttp.setRequestMethod("POST");
                            connHttp.setConnectTimeout(15000);
                            connHttp.setReadTimeout(35000);
                            connHttp.setDoInput(true);
                            connHttp.setDoOutput(true);
                            connHttp.setUseCaches(false);
                        }
                        KeyStore ksTrust = KeyStore.getInstance("BKS");
                        InputStream input = IDT_Device.context.getResources().openRawResource(Common.mystore);
                        ksTrust.load(input, null);
                        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                        tmf.init(ksTrust);
                        SSLContext sslContext = SSLContext.getInstance("TLS");
                        sslContext.init(null, tmf.getTrustManagers(), null);
                        if (rkiUrl.contains("https:")) {
                            connHttps.setSSLSocketFactory(sslContext.getSocketFactory());
                        }
                        ostream = rkiUrl.contains("https:") ? connHttps.getOutputStream() : connHttp.getOutputStream();
                        writer = new DataOutputStream(ostream);
                        soap_action = "IDTECH01" + this.deviceSn + this.fwVersion;
                        if (this.keyName != null && this.keyName.length() > 0) {
                            soap_action = soap_action + ";" + this.keyName;
                        }
                        UMLog.i(this.TAG, "1. URL: " + rkiUrl + "\nDATA: " + soap_action);
                        writer.writeBytes(soap_action);
                        writer.flush();
                        writer.close();
                        ostream.close();
                        istream = rkiUrl.contains("https:") ? connHttps.getInputStream() : connHttp.getInputStream();
                        reader = new BufferedReader(new InputStreamReader(istream));
                        String line = "";
                        while ((line = reader.readLine()) != null) {
                            strResponse = strResponse + line;
                        }
                        UMLog.i(this.TAG, "[Response 1] " + strResponse);
                        reader.close();
                        istream.close();
                        if (rkiUrl.contains("https:")) {
                            connHttps.disconnect();
                        } else {
                            connHttp.disconnect();
                        }
                        if (strResponse != null && strResponse.length() > 0) {
                            if (strResponse.charAt(0) == '<') {
                                int start4 = strResponse.indexOf("IDTECH");
                                int end4 = strResponse.lastIndexOf(60);
                                if (start4 == -1 || end4 == -1 || start4 >= end4) {
                                    return new Runnable(){

                                        @Override
                                        public void run() {
                                            UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to parse data from server for < >");
                                            IDT_Device.isCommandRunning = false;
                                            RemoteKeyInjectionTask.this._callback.timeout(258);
                                        }
                                    };
                                }
                                strResponse = strResponse.substring(start4, end4);
                                strResponse = "\"" + strResponse + "\"";
                            } else if (strResponse.charAt(0) != '\"') {
                                strResponse = "\"" + strResponse + "\"";
                            }
                        }
                        if (strResponse == null || strResponse.length() <= 9 || strResponse.charAt(9) != 'Y') {
                            return new Runnable(){

                                @Override
                                public void run() {
                                    UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to parse data from server");
                                    IDT_Device.isCommandRunning = false;
                                    RemoteKeyInjectionTask.this._callback.timeout(258);
                                }
                            };
                        }
                        byte[] Data = Common.base16Decode(strResponse.substring(10, 94));
                        byte[] Response3 = this._usb.sendCommand(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-112, (byte)35, Data)), 8);
                        if (Response3 == null || Response3.length < 16 || Response3[11] != 0) {
                            return new Runnable(){

                                @Override
                                public void run() {
                                    UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to get Certificates");
                                    IDT_Device.isCommandRunning = false;
                                    RemoteKeyInjectionTask.this._callback.timeout(259);
                                }
                            };
                        }
                        int RespLen = (Response3[12] & 0xFF) * 256 + (Response3[13] & 0xFF);
                        byte[] Resp = new byte[RespLen];
                        System.arraycopy(Response3, 14, Resp, 0, RespLen);
                        strResponse = Common.getHexStringFromBytes(Resp);
                        soap_action = "IDTECH02" + this.deviceSn + strResponse;
                        UMLog.i(this.TAG, "2. URL: " + rkiUrl + "\nDATA: " + soap_action);
                        if (rkiUrl.contains("https:")) {
                            connHttps = (HttpsURLConnection)url.openConnection();
                            connHttps.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
                            connHttps.setRequestMethod("POST");
                            connHttps.setConnectTimeout(15000);
                            connHttps.setReadTimeout(35000);
                            connHttps.setDoInput(true);
                            connHttps.setDoOutput(true);
                            connHttps.setUseCaches(false);
                            connHttps.setSSLSocketFactory(sslContext.getSocketFactory());
                            ostream = connHttps.getOutputStream();
                        } else {
                            connHttp = (HttpURLConnection)url.openConnection();
                            connHttp.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
                            connHttp.setRequestMethod("POST");
                            connHttp.setConnectTimeout(15000);
                            connHttp.setReadTimeout(35000);
                            connHttp.setDoInput(true);
                            connHttp.setDoOutput(true);
                            connHttp.setUseCaches(false);
                            ostream = connHttp.getOutputStream();
                        }
                        writer = new DataOutputStream(ostream);
                        writer.writeBytes(soap_action);
                        writer.flush();
                        writer.close();
                        ostream.close();
                        istream = rkiUrl.contains("https:") ? connHttps.getInputStream() : connHttp.getInputStream();
                        reader = new BufferedReader(new InputStreamReader(istream));
                        line = "";
                        strResponse = "";
                        while ((line = reader.readLine()) != null) {
                            strResponse = strResponse + line;
                        }
                        UMLog.i(this.TAG, "[Response 2] " + strResponse);
                        reader.close();
                        istream.close();
                        if (rkiUrl.contains("https:")) {
                            connHttps.disconnect();
                        } else {
                            connHttp.disconnect();
                        }
                        if (strResponse != null && strResponse.length() > 0) {
                            if (strResponse.charAt(0) == '<') {
                                start = strResponse.indexOf("IDTECH");
                                end = strResponse.lastIndexOf(60);
                                if (start == -1 || end == -1 || start >= end) {
                                    return new Runnable(){

                                        @Override
                                        public void run() {
                                            UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to parse data from server for < >");
                                            IDT_Device.isCommandRunning = false;
                                            RemoteKeyInjectionTask.this._callback.timeout(258);
                                        }
                                    };
                                }
                                strResponse = strResponse.substring(start, end);
                                strResponse = "\"" + strResponse + "\"";
                            } else if (strResponse.charAt(0) != '\"') {
                                strResponse = "\"" + strResponse + "\"";
                            }
                        }
                        if (strResponse == null || strResponse.length() <= 9 || strResponse.charAt(9) != 'Y') {
                            return new Runnable(){

                                @Override
                                public void run() {
                                    UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to parse data from server");
                                    IDT_Device.isCommandRunning = false;
                                    RemoteKeyInjectionTask.this._callback.timeout(258);
                                }
                            };
                        }
                        Data = Common.base16Decode(strResponse.substring(10, strResponse.length() - 1));
                        Response3 = this._usb.sendCommand(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-112, (byte)36, Data)), 8);
                        if (Response3 == null || Response3.length < 16 || Response3[11] != 0) {
                            return new Runnable(){

                                @Override
                                public void run() {
                                    UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to get Certificates");
                                    IDT_Device.isCommandRunning = false;
                                    RemoteKeyInjectionTask.this._callback.timeout(260);
                                }
                            };
                        }
                        RespLen = (Response3[12] & 0xFF) * 256 + (Response3[13] & 0xFF);
                        Resp = new byte[RespLen];
                        System.arraycopy(Response3, 14, Resp, 0, RespLen);
                        strResponse = Common.getHexStringFromBytes(Resp);
                        soap_action = "IDTECH03" + this.deviceSn + strResponse;
                        UMLog.i(this.TAG, "3. URL: " + rkiUrl + "\nDATA: " + soap_action);
                        if (rkiUrl.contains("https:")) {
                            connHttps = (HttpsURLConnection)url.openConnection();
                            connHttps.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
                            connHttps.setRequestMethod("POST");
                            connHttps.setConnectTimeout(15000);
                            connHttps.setReadTimeout(35000);
                            connHttps.setDoInput(true);
                            connHttps.setDoOutput(true);
                            connHttps.setUseCaches(false);
                            connHttps.setSSLSocketFactory(sslContext.getSocketFactory());
                            ostream = connHttps.getOutputStream();
                        } else {
                            connHttp = (HttpURLConnection)url.openConnection();
                            connHttp.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
                            connHttp.setRequestMethod("POST");
                            connHttp.setConnectTimeout(15000);
                            connHttp.setReadTimeout(35000);
                            connHttp.setDoInput(true);
                            connHttp.setDoOutput(true);
                            connHttp.setUseCaches(false);
                            ostream = connHttp.getOutputStream();
                        }
                        writer = new DataOutputStream(ostream);
                        writer.writeBytes(soap_action);
                        writer.flush();
                        writer.close();
                        ostream.close();
                        istream = rkiUrl.contains("https:") ? connHttps.getInputStream() : connHttp.getInputStream();
                        reader = new BufferedReader(new InputStreamReader(istream));
                        line = "";
                        strResponse = "";
                        while ((line = reader.readLine()) != null) {
                            strResponse = strResponse + line;
                        }
                        UMLog.i(this.TAG, "[Response 3] " + strResponse);
                        reader.close();
                        istream.close();
                        if (rkiUrl.contains("https:")) {
                            connHttps.disconnect();
                        } else {
                            connHttp.disconnect();
                        }
                        if (strResponse != null && strResponse.length() > 0) {
                            if (strResponse.charAt(0) == '<') {
                                start = strResponse.indexOf("IDTECH");
                                end = strResponse.lastIndexOf(60);
                                if (start == -1 || end == -1 || start >= end) {
                                    return new Runnable(){

                                        @Override
                                        public void run() {
                                            UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to parse data from server for < >");
                                            IDT_Device.isCommandRunning = false;
                                            RemoteKeyInjectionTask.this._callback.timeout(258);
                                        }
                                    };
                                }
                                strResponse = strResponse.substring(start, end);
                                strResponse = "\"" + strResponse + "\"";
                            } else if (strResponse.charAt(0) != '\"') {
                                strResponse = "\"" + strResponse + "\"";
                            }
                        }
                        if (strResponse != null && strResponse.length() > 9 && strResponse.charAt(9) == 'Y') {
                            return new Runnable(){

                                @Override
                                public void run() {
                                    UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify RKI Success");
                                    IDT_Device.isCommandRunning = false;
                                    RemoteKeyInjectionTask.this._callback.msgRKICompleted("00");
                                }
                            };
                        }
                        return new Runnable(){

                            @Override
                            public void run() {
                                UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify RKI timeout");
                                IDT_Device.isCommandRunning = false;
                                RemoteKeyInjectionTask.this._callback.timeout(257);
                            }
                        };
                    }
                    catch (Exception E) {
                        System.out.println("Exception While Connecting: " + E.getMessage());
                        UMLog.i(this.TAG, "Exception While Connecting: " + E.getMessage());
                        StringWriter sw = new StringWriter();
                        PrintWriter pw = new PrintWriter(sw);
                        E.printStackTrace(pw);
                        UMLog.i(this.TAG, sw.toString());
                        E.printStackTrace();
                        break block315;
                    }
                }
                if (this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI) {
                    String respStr = this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA ? this.sendCommand("55524B4933") : this.sendCommand("55524B4930");
                    if (respStr == null) {
                        return new Runnable(){

                            @Override
                            public void run() {
                                UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed on Initialize RKI command");
                                IDT_Device.isCommandRunning = false;
                                RemoteKeyInjectionTask.this._callback.timeout(257);
                            }
                        };
                    }
                    if (respStr.length() < 30) {
                        return new Runnable(){

                            @Override
                            public void run() {
                                UMLog.i(RemoteKeyInjectionTask.this.TAG, "Response length is too short");
                                IDT_Device.isCommandRunning = false;
                                RemoteKeyInjectionTask.this._callback.timeout(258);
                            }
                        };
                    }
                    UMLog.i(this.TAG, "Response String 1: " + respStr);
                    int len = respStr.length();
                    String strData = respStr.substring(6, len - 6).toUpperCase(Locale.US);
                    rkiUrl = isDemo ? (isRevB ? (LSRKI_URL.length() > 0 ? LSRKI_URL : REVB_DEMO_GEN4_URL) : (LSRKI_URL.length() > 0 ? LSRKI_URL : REVA_DEMO_GEN4_URL)) : (isRevB ? (LSRKI_URL.length() > 0 ? LSRKI_URL : REVB_PROD_GEN4_URL) : (LSRKI_URL.length() > 0 ? LSRKI_URL : REVA_PROD_GEN4_URL));
                    try {
                        int end;
                        int start;
                        url = new URL(rkiUrl);
                        if (rkiUrl.contains("https:")) {
                            connHttps = (HttpsURLConnection)url.openConnection();
                            connHttps.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
                            connHttps.setRequestMethod("POST");
                            connHttps.setConnectTimeout(15000);
                            connHttps.setReadTimeout(35000);
                            connHttps.setDoInput(true);
                            connHttps.setDoOutput(true);
                            connHttps.setUseCaches(false);
                            ostream = connHttps.getOutputStream();
                        } else {
                            connHttp = (HttpURLConnection)url.openConnection();
                            connHttp.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
                            connHttp.setRequestMethod("POST");
                            connHttp.setConnectTimeout(15000);
                            connHttp.setReadTimeout(35000);
                            connHttp.setDoInput(true);
                            connHttp.setDoOutput(true);
                            connHttp.setUseCaches(false);
                            ostream = connHttp.getOutputStream();
                        }
                        writer = new DataOutputStream(ostream);
                        soap_action = "IDTECH01" + this.deviceSn + strData;
                        if (this.keyName != null && this.keyName.length() > 0) {
                            soap_action = soap_action + ";" + this.keyName;
                        }
                        UMLog.i(this.TAG, "1. URL: " + rkiUrl + "\nDATA: " + soap_action);
                        writer.writeBytes(soap_action);
                        writer.flush();
                        writer.close();
                        ostream.close();
                        istream = rkiUrl.contains("https:") ? connHttps.getInputStream() : connHttp.getInputStream();
                        reader = new BufferedReader(new InputStreamReader(istream));
                        String line = "";
                        while ((line = reader.readLine()) != null) {
                            strResponse = strResponse + line;
                        }
                        UMLog.i(this.TAG, "[Response 1] " + strResponse);
                        reader.close();
                        istream.close();
                        if (rkiUrl.contains("https:")) {
                            connHttps.disconnect();
                        } else {
                            connHttp.disconnect();
                        }
                        if (strResponse != null && strResponse.length() > 0) {
                            if (strResponse.charAt(0) == '<') {
                                start = strResponse.indexOf("IDTECH");
                                end = strResponse.lastIndexOf(60);
                                if (start == -1 || end == -1 || start >= end) {
                                    return new Runnable(){

                                        @Override
                                        public void run() {
                                            UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to parse data from server for < >");
                                            IDT_Device.isCommandRunning = false;
                                            RemoteKeyInjectionTask.this._callback.timeout(258);
                                        }
                                    };
                                }
                                strResponse = strResponse.substring(start, end);
                                strResponse = "\"" + strResponse + "\"";
                            } else if (strResponse.charAt(0) != '\"') {
                                strResponse = "\"" + strResponse + "\"";
                            }
                        }
                        if (strResponse == null || strResponse.length() <= 9 || strResponse.charAt(9) != 'Y') {
                            return new Runnable(){

                                @Override
                                public void run() {
                                    UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to parse data from server");
                                    IDT_Device.isCommandRunning = false;
                                    RemoteKeyInjectionTask.this._callback.timeout(258);
                                }
                            };
                        }
                        if (strResponse != null) {
                            len = strResponse.length();
                            strResponse = strResponse.substring(1, len - 1);
                        }
                        strResponse = strResponse.substring(9).toUpperCase(Locale.US);
                        respStr = this.sendCommand("55524B4931" + strResponse);
                        if (respStr == null) {
                            return new Runnable(){

                                @Override
                                public void run() {
                                    UMLog.i(RemoteKeyInjectionTask.this.TAG, "Failed on key request command.");
                                    IDT_Device.isCommandRunning = false;
                                    RemoteKeyInjectionTask.this._callback.timeout(258);
                                }
                            };
                        }
                        UMLog.i(this.TAG, "Response String 2: " + respStr);
                        len = respStr.length();
                        strData = respStr.substring(6, len - 6).toUpperCase(Locale.US);
                        if (rkiUrl.contains("https:")) {
                            connHttps = (HttpsURLConnection)url.openConnection();
                            connHttps.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
                            connHttps.setRequestMethod("POST");
                            connHttps.setConnectTimeout(15000);
                            connHttps.setReadTimeout(35000);
                            connHttps.setDoInput(true);
                            connHttps.setDoOutput(true);
                            connHttps.setUseCaches(false);
                            ostream = connHttps.getOutputStream();
                        } else {
                            connHttp = (HttpURLConnection)url.openConnection();
                            connHttp.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
                            connHttp.setRequestMethod("POST");
                            connHttp.setConnectTimeout(15000);
                            connHttp.setReadTimeout(35000);
                            connHttp.setDoInput(true);
                            connHttp.setDoOutput(true);
                            connHttp.setUseCaches(false);
                            ostream = connHttp.getOutputStream();
                        }
                        writer = new DataOutputStream(ostream);
                        soap_action = "IDTECH02" + this.deviceSn + strData;
                        UMLog.i(this.TAG, "2. URL: " + rkiUrl + "\nDATA: " + soap_action);
                        writer.writeBytes(soap_action);
                        writer.flush();
                        writer.close();
                        ostream.close();
                        istream = rkiUrl.contains("https:") ? connHttps.getInputStream() : connHttp.getInputStream();
                        reader = new BufferedReader(new InputStreamReader(istream));
                        line = "";
                        strResponse = "";
                        while ((line = reader.readLine()) != null) {
                            strResponse = strResponse + line;
                        }
                        UMLog.i(this.TAG, "[Response 2] " + strResponse);
                        reader.close();
                        istream.close();
                        if (rkiUrl.contains("https:")) {
                            connHttps.disconnect();
                        } else {
                            connHttp.disconnect();
                        }
                        if (strResponse != null && strResponse.length() > 0) {
                            if (strResponse.charAt(0) == '<') {
                                start = strResponse.indexOf("IDTECH");
                                end = strResponse.lastIndexOf(60);
                                if (start == -1 || end == -1 || start >= end) {
                                    return new Runnable(){

                                        @Override
                                        public void run() {
                                            UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to parse data from server for < >");
                                            IDT_Device.isCommandRunning = false;
                                            RemoteKeyInjectionTask.this._callback.timeout(258);
                                        }
                                    };
                                }
                                strResponse = strResponse.substring(start, end);
                                strResponse = "\"" + strResponse + "\"";
                            } else if (strResponse.charAt(0) != '\"') {
                                strResponse = "\"" + strResponse + "\"";
                            }
                        }
                        if (strResponse == null || strResponse.length() <= 9 || strResponse.charAt(9) != 'Y') {
                            return new Runnable(){

                                @Override
                                public void run() {
                                    UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to parse data from server");
                                    IDT_Device.isCommandRunning = false;
                                    RemoteKeyInjectionTask.this._callback.timeout(259);
                                }
                            };
                        }
                        if (strResponse != null) {
                            len = strResponse.length();
                            strResponse = strResponse.substring(1, len - 1);
                        }
                        strResponse = strResponse.substring(9).toUpperCase(Locale.US);
                        respStr = this.sendCommand("55524B4932" + strResponse);
                        if (respStr == null || respStr.length() < 7 || respStr.charAt(6) != '0' || respStr.charAt(7) != '6') {
                            return new Runnable(){

                                @Override
                                public void run() {
                                    UMLog.i(RemoteKeyInjectionTask.this.TAG, "Failed on key request command.");
                                    IDT_Device.isCommandRunning = false;
                                    RemoteKeyInjectionTask.this._callback.timeout(258);
                                }
                            };
                        }
                        UMLog.i(this.TAG, "Response String 3: " + respStr);
                        len = respStr.length();
                        strData = respStr.substring(6, len - 6).toUpperCase(Locale.US);
                        if (rkiUrl.contains("https:")) {
                            connHttps = (HttpsURLConnection)url.openConnection();
                            connHttps.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
                            connHttps.setRequestMethod("POST");
                            connHttps.setConnectTimeout(15000);
                            connHttps.setReadTimeout(35000);
                            connHttps.setDoInput(true);
                            connHttps.setDoOutput(true);
                            connHttps.setUseCaches(false);
                            ostream = connHttps.getOutputStream();
                        } else {
                            connHttp = (HttpURLConnection)url.openConnection();
                            connHttp.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
                            connHttp.setRequestMethod("POST");
                            connHttp.setConnectTimeout(15000);
                            connHttp.setReadTimeout(35000);
                            connHttp.setDoInput(true);
                            connHttp.setDoOutput(true);
                            connHttp.setUseCaches(false);
                            ostream = connHttp.getOutputStream();
                        }
                        writer = new DataOutputStream(ostream);
                        soap_action = "IDTECH03" + this.deviceSn + strData;
                        UMLog.i(this.TAG, "3. URL: " + rkiUrl + "\nDATA: " + soap_action);
                        writer.writeBytes(soap_action);
                        writer.flush();
                        writer.close();
                        ostream.close();
                        istream = rkiUrl.contains("https:") ? connHttps.getInputStream() : connHttp.getInputStream();
                        reader = new BufferedReader(new InputStreamReader(istream));
                        line = "";
                        strResponse = "";
                        while ((line = reader.readLine()) != null) {
                            strResponse = strResponse + line;
                        }
                        UMLog.i(this.TAG, "[Response 3] " + strResponse);
                        reader.close();
                        istream.close();
                        if (rkiUrl.contains("https:")) {
                            connHttps.disconnect();
                        } else {
                            connHttp.disconnect();
                        }
                        if (strResponse != null && strResponse.length() > 0) {
                            if (strResponse.charAt(0) == '<') {
                                start = strResponse.indexOf("IDTECH");
                                end = strResponse.lastIndexOf(60);
                                if (start == -1 || end == -1 || start >= end) {
                                    return new Runnable(){

                                        @Override
                                        public void run() {
                                            UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to parse data from server for < >");
                                            IDT_Device.isCommandRunning = false;
                                            RemoteKeyInjectionTask.this._callback.timeout(258);
                                        }
                                    };
                                }
                                strResponse = strResponse.substring(start, end);
                                strResponse = "\"" + strResponse + "\"";
                            } else if (strResponse.charAt(0) != '\"') {
                                strResponse = "\"" + strResponse + "\"";
                            }
                        }
                        if (strResponse != null && strResponse.length() > 9 && strResponse.charAt(9) == 'Y') {
                            return new Runnable(){

                                @Override
                                public void run() {
                                    UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify RKI Success");
                                    IDT_Device.isCommandRunning = false;
                                    RemoteKeyInjectionTask.this._callback.msgRKICompleted("00");
                                }
                            };
                        }
                        return new Runnable(){

                            @Override
                            public void run() {
                                UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify RKI timeout");
                                IDT_Device.isCommandRunning = false;
                                RemoteKeyInjectionTask.this._callback.timeout(257);
                            }
                        };
                    }
                    catch (Exception E) {
                        System.out.println("Exception While Connecting: " + E.getMessage());
                        UMLog.i(this.TAG, "Exception While Connecting: " + E.getMessage());
                        StringWriter sw = new StringWriter();
                        PrintWriter pw = new PrintWriter(sw);
                        E.printStackTrace(pw);
                        UMLog.i(this.TAG, sw.toString());
                        E.printStackTrace();
                        break block315;
                    }
                }
                if (this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT) {
                    rkiUrl = isDemo ? (LSRKI_URL.length() > 0 ? LSRKI_URL : PKI_DEMO_GEN4_URL) : (LSRKI_URL.length() > 0 ? LSRKI_URL : PKI_PROD_GEN4_URL);
                    try {
                        int end;
                        int start;
                        int len;
                        url = new URL(rkiUrl);
                        if (rkiUrl.contains("https:")) {
                            connHttps = (HttpsURLConnection)url.openConnection();
                            connHttps.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
                            connHttps.setRequestMethod("POST");
                            connHttps.setConnectTimeout(15000);
                            connHttps.setReadTimeout(35000);
                            connHttps.setDoInput(true);
                            connHttps.setDoOutput(true);
                            connHttps.setUseCaches(false);
                            ostream = connHttps.getOutputStream();
                        } else {
                            connHttp = (HttpURLConnection)url.openConnection();
                            connHttp.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
                            connHttp.setRequestMethod("POST");
                            connHttp.setConnectTimeout(15000);
                            connHttp.setReadTimeout(35000);
                            connHttp.setDoInput(true);
                            connHttp.setDoOutput(true);
                            connHttp.setUseCaches(false);
                            ostream = connHttp.getOutputStream();
                        }
                        writer = new DataOutputStream(ostream);
                        soap_action = "IDTECH01" + this.deviceSn + this.fwVersion;
                        if (this.keyName != null && this.keyName.length() > 0) {
                            soap_action = soap_action + ";" + this.keyName;
                        }
                        UMLog.i(this.TAG, "1. URL: " + rkiUrl + "\nDATA: " + soap_action);
                        writer.writeBytes(soap_action);
                        writer.flush();
                        writer.close();
                        ostream.close();
                        istream = rkiUrl.contains("https:") ? connHttps.getInputStream() : connHttp.getInputStream();
                        reader = new BufferedReader(new InputStreamReader(istream));
                        String line = "";
                        while ((line = reader.readLine()) != null) {
                            strResponse = strResponse + line;
                        }
                        UMLog.i(this.TAG, "[Response 1] " + strResponse);
                        reader.close();
                        istream.close();
                        if (rkiUrl.contains("https:")) {
                            connHttps.disconnect();
                        } else {
                            connHttp.disconnect();
                        }
                        if (strResponse != null && strResponse.length() > 0) {
                            if (strResponse.charAt(0) == '<') {
                                int start5 = strResponse.indexOf("IDTECH");
                                int end5 = strResponse.lastIndexOf(60);
                                if (start5 == -1 || end5 == -1 || start5 >= end5) {
                                    return new Runnable(){

                                        @Override
                                        public void run() {
                                            UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to parse data from server for < >");
                                            IDT_Device.isCommandRunning = false;
                                            RemoteKeyInjectionTask.this._callback.timeout(258);
                                        }
                                    };
                                }
                                strResponse = strResponse.substring(start5, end5);
                                strResponse = "\"" + strResponse + "\"";
                            } else if (strResponse.charAt(0) != '\"') {
                                strResponse = "\"" + strResponse + "\"";
                            }
                        }
                        if (strResponse == null || strResponse.length() <= 9 || strResponse.charAt(9) != 'Y') {
                            return new Runnable(){

                                @Override
                                public void run() {
                                    UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to parse data from server");
                                    IDT_Device.isCommandRunning = false;
                                    RemoteKeyInjectionTask.this._callback.timeout(258);
                                }
                            };
                        }
                        if (strResponse != null) {
                            len = strResponse.length();
                            strResponse = strResponse.substring(1, len - 1);
                        }
                        if (strResponse == null || !strResponse.startsWith("IDTECH01Y")) {
                            return new Runnable(){

                                @Override
                                public void run() {
                                    UMLog.i(RemoteKeyInjectionTask.this.TAG, "Error RKI identifying device.");
                                    IDT_Device.isCommandRunning = false;
                                    RemoteKeyInjectionTask.this._callback.timeout(258);
                                }
                            };
                        }
                        byte[] KeyRequestData = Common.getBytesFromHexString(strResponse.substring(9, 41));
                        byte[] response = null;
                        byte[] cmdData = Common.getBytesFromHexString(strResponse.substring(41));
                        response = this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT ? this._btle.sendCommand(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-110, (byte)1, cmdData)), 5) : this._usb.sendCommand(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-110, (byte)1, cmdData)), 2);
                        if (response == null || response.length < 10) {
                            return new Runnable(){

                                @Override
                                public void run() {
                                    UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to send the command 0x92-01");
                                    IDT_Device.isCommandRunning = false;
                                    RemoteKeyInjectionTask.this._callback.timeout(258);
                                }
                            };
                        }
                        if (response[11] != 0) {
                            return new Runnable(){

                                @Override
                                public void run() {
                                    UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to send the command 0x92-01: received NAK");
                                    IDT_Device.isCommandRunning = false;
                                    RemoteKeyInjectionTask.this._callback.timeout(258);
                                }
                            };
                        }
                        response = this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT ? this._btle.sendCommand(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-110, (byte)2, KeyRequestData)), 5) : this._usb.sendCommand(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-110, (byte)2, KeyRequestData)), 2);
                        if (response == null || response.length < 16 || response[11] != 0) {
                            return new Runnable(){

                                @Override
                                public void run() {
                                    UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to get Certificates");
                                    IDT_Device.isCommandRunning = false;
                                    RemoteKeyInjectionTask.this._callback.timeout(259);
                                }
                            };
                        }
                        int RespLen = (response[12] & 0xFF) * 256 + (response[13] & 0xFF);
                        byte[] Resp = new byte[RespLen];
                        System.arraycopy(response, 14, Resp, 0, RespLen);
                        strResponse = Common.getHexStringFromBytes(Resp);
                        soap_action = "IDTECH02" + this.deviceSn + strResponse;
                        UMLog.i(this.TAG, "2. URL: " + rkiUrl + "\nDATA: " + soap_action);
                        if (rkiUrl.contains("https:")) {
                            connHttps = (HttpsURLConnection)url.openConnection();
                            connHttps.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
                            connHttps.setRequestMethod("POST");
                            connHttps.setConnectTimeout(15000);
                            connHttps.setReadTimeout(35000);
                            connHttps.setDoInput(true);
                            connHttps.setDoOutput(true);
                            connHttps.setUseCaches(false);
                            ostream = connHttps.getOutputStream();
                        } else {
                            connHttp = (HttpURLConnection)url.openConnection();
                            connHttp.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
                            connHttp.setRequestMethod("POST");
                            connHttp.setConnectTimeout(15000);
                            connHttp.setReadTimeout(35000);
                            connHttp.setDoInput(true);
                            connHttp.setDoOutput(true);
                            connHttp.setUseCaches(false);
                            ostream = connHttp.getOutputStream();
                        }
                        writer = new DataOutputStream(ostream);
                        writer.writeBytes(soap_action);
                        writer.flush();
                        writer.close();
                        ostream.close();
                        istream = rkiUrl.contains("https:") ? connHttps.getInputStream() : connHttp.getInputStream();
                        reader = new BufferedReader(new InputStreamReader(istream));
                        line = "";
                        strResponse = "";
                        while ((line = reader.readLine()) != null) {
                            strResponse = strResponse + line;
                        }
                        UMLog.i(this.TAG, "[Response 2] " + strResponse);
                        reader.close();
                        istream.close();
                        if (rkiUrl.contains("https:")) {
                            connHttps.disconnect();
                        } else {
                            connHttp.disconnect();
                        }
                        if (strResponse != null && strResponse.length() > 0) {
                            if (strResponse.charAt(0) == '<') {
                                start = strResponse.indexOf("IDTECH");
                                end = strResponse.lastIndexOf(60);
                                if (start == -1 || end == -1 || start >= end) {
                                    return new Runnable(){

                                        @Override
                                        public void run() {
                                            UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to parse data from server for < >");
                                            IDT_Device.isCommandRunning = false;
                                            RemoteKeyInjectionTask.this._callback.timeout(258);
                                        }
                                    };
                                }
                                strResponse = strResponse.substring(start, end);
                                strResponse = "\"" + strResponse + "\"";
                            } else if (strResponse.charAt(0) != '\"') {
                                strResponse = "\"" + strResponse + "\"";
                            }
                        }
                        if (strResponse == null || strResponse.length() <= 9 || strResponse.charAt(9) != 'Y') {
                            return new Runnable(){

                                @Override
                                public void run() {
                                    UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to parse data from server");
                                    IDT_Device.isCommandRunning = false;
                                    RemoteKeyInjectionTask.this._callback.timeout(259);
                                }
                            };
                        }
                        if (strResponse != null) {
                            len = strResponse.length();
                            strResponse = strResponse.substring(1, len - 1);
                        }
                        cmdData = Common.getBytesFromHexString(strResponse.substring(41));
                        response = this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT ? this._btle.sendCommand(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-110, (byte)3, cmdData)), 7) : this._usb.sendCommand(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-110, (byte)3, cmdData)), 5);
                        if (response == null || response.length < 10) {
                            return new Runnable(){

                                @Override
                                public void run() {
                                    UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to send the command 0x92-03");
                                    IDT_Device.isCommandRunning = false;
                                    RemoteKeyInjectionTask.this._callback.timeout(258);
                                }
                            };
                        }
                        if (response[11] != 0) {
                            return new Runnable(){

                                @Override
                                public void run() {
                                    UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to send the command 0x92-03: received NAK");
                                    IDT_Device.isCommandRunning = false;
                                    RemoteKeyInjectionTask.this._callback.timeout(258);
                                }
                            };
                        }
                        response = this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT ? this._btle.sendCommand(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-110, (byte)4, new byte[0])), 5) : this._usb.sendCommand(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-110, (byte)4, new byte[0])), 2);
                        if (response == null || response.length < 16 || response[11] != 0) {
                            return new Runnable(){

                                @Override
                                public void run() {
                                    UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to get Certificates");
                                    IDT_Device.isCommandRunning = false;
                                    RemoteKeyInjectionTask.this._callback.timeout(259);
                                }
                            };
                        }
                        RespLen = (response[12] & 0xFF) * 256 + (response[13] & 0xFF);
                        Resp = new byte[RespLen];
                        System.arraycopy(response, 14, Resp, 0, RespLen);
                        strResponse = Common.getHexStringFromBytes(Resp);
                        soap_action = "IDTECH03" + this.deviceSn + strResponse;
                        UMLog.i(this.TAG, "3. URL: " + rkiUrl + "\nDATA: " + soap_action);
                        if (rkiUrl.contains("https:")) {
                            connHttps = (HttpsURLConnection)url.openConnection();
                            connHttps.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
                            connHttps.setRequestMethod("POST");
                            connHttps.setConnectTimeout(15000);
                            connHttps.setReadTimeout(35000);
                            connHttps.setDoInput(true);
                            connHttps.setDoOutput(true);
                            connHttps.setUseCaches(false);
                            ostream = connHttps.getOutputStream();
                        } else {
                            connHttp = (HttpURLConnection)url.openConnection();
                            connHttp.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
                            connHttp.setRequestMethod("POST");
                            connHttp.setConnectTimeout(15000);
                            connHttp.setReadTimeout(35000);
                            connHttp.setDoInput(true);
                            connHttp.setDoOutput(true);
                            connHttp.setUseCaches(false);
                            ostream = connHttp.getOutputStream();
                        }
                        writer = new DataOutputStream(ostream);
                        writer.writeBytes(soap_action);
                        writer.flush();
                        writer.close();
                        ostream.close();
                        istream = rkiUrl.contains("https:") ? connHttps.getInputStream() : connHttp.getInputStream();
                        reader = new BufferedReader(new InputStreamReader(istream));
                        line = "";
                        strResponse = "";
                        while ((line = reader.readLine()) != null) {
                            strResponse = strResponse + line;
                        }
                        UMLog.i(this.TAG, "[Response 3] " + strResponse);
                        reader.close();
                        istream.close();
                        if (rkiUrl.contains("https:")) {
                            connHttps.disconnect();
                        } else {
                            connHttp.disconnect();
                        }
                        if (strResponse != null && strResponse.length() > 0) {
                            if (strResponse.charAt(0) == '<') {
                                start = strResponse.indexOf("IDTECH");
                                end = strResponse.lastIndexOf(60);
                                if (start == -1 || end == -1 || start >= end) {
                                    return new Runnable(){

                                        @Override
                                        public void run() {
                                            UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to parse data from server for < >");
                                            IDT_Device.isCommandRunning = false;
                                            RemoteKeyInjectionTask.this._callback.timeout(258);
                                        }
                                    };
                                }
                                strResponse = strResponse.substring(start, end);
                                strResponse = "\"" + strResponse + "\"";
                            } else if (strResponse.charAt(0) != '\"') {
                                strResponse = "\"" + strResponse + "\"";
                            }
                        }
                        if (strResponse != null) {
                            len = strResponse.length();
                            strResponse = strResponse.substring(1, len - 1);
                        }
                        if (strResponse == null || !strResponse.startsWith("IDTECH03Y")) {
                            return new Runnable(){

                                @Override
                                public void run() {
                                    UMLog.i(RemoteKeyInjectionTask.this.TAG, "Error RKI identifying device.");
                                    IDT_Device.isCommandRunning = false;
                                    RemoteKeyInjectionTask.this._callback.timeout(259);
                                }
                            };
                        }
                        response = this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT ? this._btle.sendCommand(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-112, (byte)7, new byte[]{1})), 3) : this._usb.sendCommand(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-112, (byte)7, new byte[]{1})), 2);
                        if (response == null || response.length < 10) {
                            return new Runnable(){

                                @Override
                                public void run() {
                                    UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to send the command 0x90-07");
                                    IDT_Device.isCommandRunning = false;
                                    RemoteKeyInjectionTask.this._callback.timeout(259);
                                }
                            };
                        }
                        if (response[11] != 0) {
                            return new Runnable(){

                                @Override
                                public void run() {
                                    UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to send the command 0x90-07: received NAK");
                                    IDT_Device.isCommandRunning = false;
                                    RemoteKeyInjectionTask.this._callback.timeout(259);
                                }
                            };
                        }
                        return new Runnable(){

                            @Override
                            public void run() {
                                UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify RKI Success");
                                IDT_Device.isCommandRunning = false;
                                RemoteKeyInjectionTask.this._callback.msgRKICompleted("00");
                            }
                        };
                    }
                    catch (Exception E) {
                        System.out.println("Exception While Connecting: " + E.getMessage());
                        UMLog.i(this.TAG, "Exception While Connecting: " + E.getMessage());
                        StringWriter sw = new StringWriter();
                        PrintWriter pw = new PrintWriter(sw);
                        E.printStackTrace(pw);
                        UMLog.i(this.TAG, sw.toString());
                        E.printStackTrace();
                        break block315;
                    }
                }
                authObj = this.submitRequest(RKI_URL + "authorize/" + this.deviceSn + "/" + this.fwVersion, "Authorize");
                UMLog.i(this.TAG, "URL: " + RKI_URL + "authorize/" + this.deviceSn + "/" + this.fwVersion);
                if (authObj == null) {
                    return new Runnable(){

                        @Override
                        public void run() {
                            UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to parse data from server");
                            IDT_Device.isCommandRunning = false;
                            RemoteKeyInjectionTask.this._callback.timeout(258);
                        }
                    };
                }
                String urlResult = authObj.getString("Result");
                String command1 = null;
                if (!urlResult.equalsIgnoreCase("Success")) {
                    if (urlResult.equalsIgnoreCase("Fail")) {
                        final String errorCode = authObj.getString("Error Code: ");
                        return new Runnable(){

                            @Override
                            public void run() {
                                UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to authorize RKI: error code: " + errorCode);
                                IDT_Device.isCommandRunning = false;
                                RemoteKeyInjectionTask.this._callback.timeout(258);
                            }
                        };
                    }
                    return new Runnable(){

                        @Override
                        public void run() {
                            UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to authorize RKI: unknown error");
                            IDT_Device.isCommandRunning = false;
                            RemoteKeyInjectionTask.this._callback.timeout(258);
                        }
                    };
                }
                command1 = authObj.getString("Command");
                UMLog.i(this.TAG, "Success, next command: " + command1);
                if (command1 != null && this._taskExport.getReaderType() != ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG && this._taskExport.getReaderType() != ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG_KB) {
                    command1 = this.trimNGACommand(command1);
                }
                if (command1 == null) {
                    return new Runnable(){

                        @Override
                        public void run() {
                            UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to authorize RKI");
                            IDT_Device.isCommandRunning = false;
                            RemoteKeyInjectionTask.this._callback.timeout(258);
                        }
                    };
                }
                Object authStr = null;
                authStr = this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG_KB ? ((resp2 = this._usb.sendCommand(command1, 18)) == null || resp2.length < 7 ? null : Common.getHexStringFromBytes(resp2)) : this.sendCommand(command1);
                if (authStr == null) {
                    return new Runnable(){

                        @Override
                        public void run() {
                            UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed on Initialize RKI command");
                            IDT_Device.isCommandRunning = false;
                            RemoteKeyInjectionTask.this._callback.timeout(257);
                        }
                    };
                }
                UMLog.i(this.TAG, "Authentication String 1: " + (String)authStr);
                authObj = this.submitRequest(RKI_URL + "step1/" + (String)authStr, "Step 1");
                if (authObj == null) {
                    return new Runnable(){

                        @Override
                        public void run() {
                            UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to parse data from server");
                            IDT_Device.isCommandRunning = false;
                            RemoteKeyInjectionTask.this._callback.timeout(259);
                        }
                    };
                }
                urlResult = authObj.getString("Result");
                String command4 = null;
                if (!urlResult.equalsIgnoreCase("Success")) {
                    if (urlResult.equalsIgnoreCase("Fail")) {
                        final String errorCode = authObj.getString("Error Code: ");
                        return new Runnable(){

                            @Override
                            public void run() {
                                UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to authorize RKI: error code: " + errorCode);
                                IDT_Device.isCommandRunning = false;
                                RemoteKeyInjectionTask.this._callback.timeout(259);
                            }
                        };
                    }
                    return new Runnable(){

                        @Override
                        public void run() {
                            UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to authorize RKI: unknown error");
                            IDT_Device.isCommandRunning = false;
                            RemoteKeyInjectionTask.this._callback.timeout(259);
                        }
                    };
                }
                command4 = authObj.getString("Command4");
                if (command4 == null) {
                    return new Runnable(){

                        @Override
                        public void run() {
                            UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to authorize RKI: unknown error");
                            IDT_Device.isCommandRunning = false;
                            RemoteKeyInjectionTask.this._callback.timeout(259);
                        }
                    };
                }
                if (this._taskExport.getReaderType() != ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG && this._taskExport.getReaderType() != ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG_KB) {
                    command4 = this.trimNGACommand(command4);
                }
                if (command4 == null) {
                    return new Runnable(){

                        @Override
                        public void run() {
                            UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to authorize RKI: wrong command protocol");
                            IDT_Device.isCommandRunning = false;
                            RemoteKeyInjectionTask.this._callback.timeout(259);
                        }
                    };
                }
                authStr = this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG_KB ? ((resp = this._usb.sendCommand(command4, 18)) == null || resp.length < 7 ? null : Common.getHexStringFromBytes(resp)) : this.sendCommand(command4);
                if (authStr == null) {
                    return new Runnable(){

                        @Override
                        public void run() {
                            UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed on RKI authentication");
                            IDT_Device.isCommandRunning = false;
                            RemoteKeyInjectionTask.this._callback.timeout(257);
                        }
                    };
                }
                authObj = this.submitRequest(RKI_URL + "step2/" + this.deviceSn + "/" + (String)authStr, "Step 2");
                if (authObj == null) {
                    return new Runnable(){

                        @Override
                        public void run() {
                            UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to parse data from server");
                            IDT_Device.isCommandRunning = false;
                            RemoteKeyInjectionTask.this._callback.timeout(259);
                        }
                    };
                }
                urlResult = authObj.getString("Result");
                String command5 = null;
                if (!urlResult.equalsIgnoreCase("Success")) {
                    if (urlResult.equalsIgnoreCase("Fail")) {
                        final String errorCode = authObj.getString("Error Code: ");
                        return new Runnable(){

                            @Override
                            public void run() {
                                UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to authorize RKI: error code: " + errorCode);
                                IDT_Device.isCommandRunning = false;
                                RemoteKeyInjectionTask.this._callback.timeout(259);
                            }
                        };
                    }
                    return new Runnable(){

                        @Override
                        public void run() {
                            UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to authorize RKI: unknown error");
                            IDT_Device.isCommandRunning = false;
                            RemoteKeyInjectionTask.this._callback.timeout(259);
                        }
                    };
                }
                command5 = authObj.getString("Command5");
                if (command5 == null) {
                    return new Runnable(){

                        @Override
                        public void run() {
                            UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to authorize RKI: unknown error");
                            IDT_Device.isCommandRunning = false;
                            RemoteKeyInjectionTask.this._callback.timeout(259);
                        }
                    };
                }
                if (this._taskExport.getReaderType() != ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG && this._taskExport.getReaderType() != ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG_KB) {
                    command5 = this.trimNGACommand(command5);
                }
                if (command5 == null) {
                    return new Runnable(){

                        @Override
                        public void run() {
                            UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to authorize RKI: wrong command protocol");
                            IDT_Device.isCommandRunning = false;
                            RemoteKeyInjectionTask.this._callback.timeout(257);
                        }
                    };
                }
                if (this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG_KB) {
                    byte[] resp4 = this._usb.sendCommand(command5, 18);
                    if (resp4 != null && resp4.length >= 7) {
                        authStr = Common.getHexStringFromBytes(resp4);
                    }
                } else {
                    authStr = this.sendCommand(command5);
                }
                if (authStr == null) {
                    return new Runnable(){

                        @Override
                        public void run() {
                            UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed on RKI authentication");
                            IDT_Device.isCommandRunning = false;
                            RemoteKeyInjectionTask.this._callback.timeout(257);
                        }
                    };
                }
                authObj = this.submitRequest(RKI_URL + "step3/" + this.deviceSn + "/" + (String)authStr, "Step 3");
                if (authObj == null) {
                    return new Runnable(){

                        @Override
                        public void run() {
                            UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to parse data from server");
                            IDT_Device.isCommandRunning = false;
                            RemoteKeyInjectionTask.this._callback.timeout(260);
                        }
                    };
                }
                urlResult = authObj.getString("Result");
                String mac = null;
                if (!urlResult.equalsIgnoreCase("Success")) {
                    if (urlResult.equalsIgnoreCase("Fail")) {
                        final String errorCode = authObj.getString("Error Code: ");
                        return new Runnable(){

                            @Override
                            public void run() {
                                UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to authorize RKI: error code: " + errorCode);
                                IDT_Device.isCommandRunning = false;
                                RemoteKeyInjectionTask.this._callback.timeout(260);
                            }
                        };
                    }
                    return new Runnable(){

                        @Override
                        public void run() {
                            UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to authorize RKI: unknown error");
                            IDT_Device.isCommandRunning = false;
                            RemoteKeyInjectionTask.this._callback.timeout(257);
                        }
                    };
                }
                mac = authObj.getString("Mac Result");
                if (mac != null) {
                    final String macValue = mac;
                    return new Runnable(){

                        @Override
                        public void run() {
                            UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify RKI Success");
                            IDT_Device.isCommandRunning = false;
                            RemoteKeyInjectionTask.this._callback.msgRKICompleted(macValue);
                        }
                    };
                }
                return new Runnable(){

                    @Override
                    public void run() {
                        UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify RKI timeout");
                        IDT_Device.isCommandRunning = false;
                        RemoteKeyInjectionTask.this._callback.timeout(257);
                    }
                };
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return new Runnable(){

            @Override
            public void run() {
                UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to authorize RKI: unknown error");
                IDT_Device.isCommandRunning = false;
                RemoteKeyInjectionTask.this._callback.timeout(257);
            }
        };
    }

    private String sendCommand(String cmd) {
        if (this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY) {
            ResDataStruct resp = new ResDataStruct();
            TaskManager.TaskStartRet ret = this._taskManager.task_start_command_for_fw(Common.makeCommand(cmd, 200), resp);
            if (ret != TaskManager.TaskStartRet.SUCCESS) {
                return null;
            }
            return Common.getHexStringFromBytes(resp.resData);
        }
        if (this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V) {
            ResDataStruct resp = new ResDataStruct();
            TaskManager.TaskStartRet ret = this._taskManager.task_start_command_for_fw(Common.makeCommand(cmd), resp);
            if (ret != TaskManager.TaskStartRet.SUCCESS) {
                return null;
            }
            return Common.getHexStringFromBytes(resp.resData);
        }
        if (this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_USB || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800) {
            byte[] resp = this._usb.sendCommandForRKI(cmd, 5);
            if (resp == null || resp.length < 7) {
                return null;
            }
            return Common.getHexStringFromBytes(resp);
        }
        if (this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
            byte[] resp = this._com.sendCommandForRKI(cmd, 5);
            if (resp == null || resp.length < 7) {
                return null;
            }
            return Common.getHexStringFromBytes(resp);
        }
        if (this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
            byte[] resp = this._btle.sendCommandForRKI(cmd, 7);
            if (resp == null || resp.length < 7) {
                return null;
            }
            return Common.getHexStringFromBytes(resp);
        }
        return null;
    }

    private String trimNGACommand(String command) {
        if (command.startsWith("02") && command.endsWith("03") && command.length() > 14) {
            return command.substring(6, command.length() - 6);
        }
        return null;
    }

    private JSONObject submitRequest(String urlToRequest, String objName) {
        JSONObject jsonToReturn = null;
        try {
            urlToRequest = URLDecoder.decode(urlToRequest, "UTF-8");
            URL url = new URL(urlToRequest);
            BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
            StringBuilder builder = new StringBuilder();
            String line = null;
            while ((line = in.readLine()) != null) {
                builder.append(line);
            }
            String response = builder.toString().replace("},}", "}}").replace("\",    }", "\"    }");
            JSONObject obj = new JSONObject(response);
            jsonToReturn = objName != null && objName.length() > 0 ? obj.getJSONObject(objName) : obj;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return jsonToReturn;
    }
}

