/*
 * Decompiled with CFR 0.152.
 */
package com.idtechproducts.device.audiojack.tasks;

import android.os.Handler;
import android.os.Looper;
import com.idtechproducts.device.OnReceiverListener;
import com.idtechproducts.device.StructConfigParameters;
import com.idtechproducts.device.audiojack.ReaderCommunication;
import com.idtechproducts.device.audiojack.UMLog;
import com.idtechproducts.device.audiojack.io.IOManager;
import com.idtechproducts.device.audiojack.io.TonePlayer;
import com.idtechproducts.device.audiojack.io.ToneType;
import com.idtechproducts.device.audiojack.tasks.TaskManager;
import java.util.List;

public abstract class Task
implements Runnable,
IOManager.ICancel,
IOManager.ResponseProcessor {
    protected final ReaderCommunication _readerCommunication;
    protected OnReceiverListener _umrMsg = null;
    protected IOManager _ioManager = null;
    protected final TonePlayer _tonePlayer;
    protected StructConfigParameters _config = null;
    protected final TaskManager _taskManager;
    protected final String TAG;
    private volatile boolean _isCanceled = false;
    private final Object _sleepMonitor = new Object();
    private ToneType _originalTone;

    protected Task(TaskManager taskManager, ReaderCommunication umMan) {
        this._readerCommunication = umMan;
        if (this._readerCommunication != null) {
            this._umrMsg = this._readerCommunication.getIntern_uniMagReaderMsg();
            this._ioManager = this._readerCommunication.getIntern_IOManager();
            this._config = this._readerCommunication.getIntern_StructConfigParameters();
        }
        this._tonePlayer = null != this._ioManager ? this._ioManager.getTonePlayer() : null;
        this._taskManager = taskManager;
        this.TAG = this.getType().name() + "Task";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        this._isCanceled = true;
        if (this._ioManager != null) {
            this._ioManager.notifyIoManager();
        }
        Object object = this._sleepMonitor;
        synchronized (object) {
            this._sleepMonitor.notify();
        }
    }

    @Override
    public boolean isCanceled() {
        return this._isCanceled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean safeWait(double waitLen) {
        long waitLenMillis = (long)(waitLen * 1000.0);
        long time_start = System.currentTimeMillis();
        try {
            Object object = this._sleepMonitor;
            synchronized (object) {
                this._sleepMonitor.wait(waitLenMillis);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        long time_end = System.currentTimeMillis();
        boolean wasInterrupted = time_end - time_start < waitLenMillis;
        return wasInterrupted;
    }

    @Override
    public boolean processResponse(List<byte[]> response) {
        return true;
    }

    @Override
    public void processSound() {
    }

    protected void tone_saveAndStop() {
        if (null != this._tonePlayer) {
            this._originalTone = this._tonePlayer.getPlayingTone();
            this._tonePlayer.setPlayingTone(null);
        }
    }

    protected void tone_restore() {
        if (null != this._tonePlayer) {
            this._tonePlayer.setPlayingTone(this._originalTone);
        }
    }

    protected void post(Runnable r) {
        Handler h = new Handler(Looper.getMainLooper());
        h.post(r);
    }

    @Override
    public void run() {
        UMLog.i(this.TAG, "started");
        if (!this.taskSetup()) {
            return;
        }
        Runnable actionAfterTaskEnd = this.taskMain();
        this.taskCleanup();
        this._taskManager.task_signalStoppedStatus();
        UMLog.i(this.TAG, "stopped");
        if (actionAfterTaskEnd != null) {
            actionAfterTaskEnd.run();
        }
    }

    public abstract TaskManager.TaskType getType();

    protected boolean taskSetup() {
        this.tone_saveAndStop();
        return true;
    }

    protected void taskCleanup() {
        if (null != this._ioManager) {
            this._ioManager.notifyTaskFinished();
        }
        UMLog.i(this.TAG, "taskCleanup ok.");
    }

    protected abstract Runnable taskMain();
}

