/*
 * Decompiled with CFR 0.152.
 */
package com.idtechproducts.device.audiojack.tools;

import android.content.Context;
import com.idtechproducts.device.Common;
import com.idtechproducts.device.DeviceToolProxy;
import com.idtechproducts.device.IDT_Device;
import com.idtechproducts.device.ReaderInfo;
import com.idtechproducts.device.audiojack.UMLog;
import com.idtechproducts.device.audiojack.tasks.TaskManager;
import com.idtechproducts.device.audiojack.tools.FirmwareUpdateToolMsg;
import com.idtechproducts.device.bluetooth.IDTechBluetoothLE;
import com.idtechproducts.device.rs232.IDTechRS232;
import com.idtechproducts.device.usb.IDTechUsbHid;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Field;

public class FirmwareUpdateTool {
    private final FirmwareUpdateToolMsg _umtMsg;
    private IDT_Device _device = null;
    private TaskManager _umMan = null;
    private IDTechUsbHid _usb = null;
    private IDTechRS232 _com = null;
    private IDTechBluetoothLE _btle = null;
    private boolean _cfg_isEncryptedUpdate = false;
    private byte[] _cfg_bin = null;
    private Short _cfg_bin_crc = null;
    private IDT_Device.TaskExport _taskExport = null;
    private FMStruct fm_file = null;

    public FirmwareUpdateTool(FirmwareUpdateToolMsg callback, Context context) {
        if (callback == null) {
            throw new NullPointerException("argument must not be null");
        }
        this._umtMsg = callback;
    }

    public void setIDT_Device(IDT_Device instance) {
        this._device = instance;
        this._umMan = null;
        for (Field field : instance.getClass().getDeclaredFields()) {
            UMLog.i("**setIDT_Device**", "field.getType().toString()=" + field.getType().toString());
            if (field.getType().equals(TaskManager.class)) {
                try {
                    boolean origVal = field.isAccessible();
                    field.setAccessible(true);
                    this._umMan = (TaskManager)field.get(instance);
                    field.setAccessible(origVal);
                    if (this._usb == null || this._taskExport == null) continue;
                    break;
                }
                catch (IllegalArgumentException origVal) {
                    continue;
                }
                catch (IllegalAccessException origVal) {
                    continue;
                }
            }
            if (field.getType().equals(IDTechUsbHid.class)) {
                try {
                    boolean origVal = field.isAccessible();
                    field.setAccessible(true);
                    this._usb = (IDTechUsbHid)field.get(instance);
                    field.setAccessible(origVal);
                    if (this._umMan == null || this._taskExport == null) continue;
                    break;
                }
                catch (IllegalArgumentException origVal) {
                    continue;
                }
                catch (IllegalAccessException origVal) {
                    continue;
                }
            }
            if (field.getType().equals(IDTechRS232.class)) {
                try {
                    boolean origVal = field.isAccessible();
                    field.setAccessible(true);
                    this._com = (IDTechRS232)field.get(instance);
                    field.setAccessible(origVal);
                    if (this._umMan == null || this._taskExport == null) continue;
                    break;
                }
                catch (IllegalArgumentException origVal) {
                    continue;
                }
                catch (IllegalAccessException origVal) {
                    continue;
                }
            }
            if (field.getType().equals(IDTechBluetoothLE.class)) {
                try {
                    boolean origVal = field.isAccessible();
                    field.setAccessible(true);
                    if (this._btle == null) {
                        this._btle = (IDTechBluetoothLE)field.get(instance);
                    }
                    field.setAccessible(origVal);
                    if (this._btle == null || this._umMan == null || this._taskExport == null) continue;
                    break;
                }
                catch (IllegalArgumentException origVal) {
                    continue;
                }
                catch (IllegalAccessException origVal) {
                    continue;
                }
            }
            if (!field.getType().equals(IDT_Device.TaskExport.class)) continue;
            try {
                boolean origVal = field.isAccessible();
                field.setAccessible(true);
                this._taskExport = (IDT_Device.TaskExport)field.get(instance);
                if (this._umMan == null || this._usb == null) continue;
                break;
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    private FMStruct getFmFile() {
        return this.fm_file;
    }

    public void setFmFile(String[] _commands) {
        this.fm_file = new FMStruct(_commands);
    }

    public void setFmFile(byte[] data) {
        this.fm_file = new FMStruct(data, true);
    }

    private DeviceToolProxy getSDKToolProxy() {
        return null;
    }

    private boolean setFirmwareFile(String strFilePathName) {
        if (strFilePathName.endsWith(".bin")) {
            return this.setFirmwareBINFile(strFilePathName, false);
        }
        if (strFilePathName.endsWith(".fm")) {
            return this.setFirmwareFMFile(strFilePathName);
        }
        if (strFilePathName.endsWith(".txt")) {
            return this.setFirmwareTXTFile(strFilePathName);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setFirmwareFMFile(String strFilePathName) {
        File file = new File(strFilePathName);
        if (!file.exists()) {
            return false;
        }
        FileInputStream fis = null;
        int fileLen = (int)file.length();
        try {
            fis = new FileInputStream(strFilePathName);
            byte[] ret = new byte[fileLen];
            fis.read(ret);
            this.fm_file = new FMStruct(ret);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            UMLog.e("FWUpdate", "file failed to load: " + e);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException iOException) {}
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setFirmwareTXTFile(String strFilePathName) {
        String[] commands;
        File file = new File(strFilePathName);
        if (!file.exists()) {
            return false;
        }
        int count = 0;
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(file));
            String line = "";
            while ((line = br.readLine()) != null && !line.equalsIgnoreCase("END>")) {
                ++count;
            }
            br.close();
            br = null;
            br = new BufferedReader(new FileReader(file));
            line = "";
            commands = new String[++count];
            for (int i = 0; i < count; ++i) {
                line = br.readLine();
                commands[i] = new String(line);
            }
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (Exception ex) {
                return false;
            }
        }
        this.fm_file = new FMStruct(commands);
        return true;
    }

    private boolean setFirmwareEncryptedBINFile(String strFilePathName) {
        return this.setFirmwareBINFile(strFilePathName, true);
    }

    private boolean setFirmwareBINFile(String binPath, boolean isEncryptedUpdate) {
        this._cfg_isEncryptedUpdate = isEncryptedUpdate;
        this._cfg_bin = FirmwareUpdateTool.binfile_checkAndLoad(binPath, isEncryptedUpdate);
        if (this._cfg_bin == null) {
            this._cfg_bin_crc = null;
            return false;
        }
        short crc = -1;
        for (byte b : this._cfg_bin) {
            crc = Common.crc_Update(crc, b);
        }
        this._cfg_bin_crc = crc;
        return true;
    }

    private int getBINFileBlockSize() {
        if (this._taskExport == null) {
            return this._cfg_isEncryptedUpdate ? 258 : 256;
        }
        if (this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_USB) {
            return 1024;
        }
        return this._cfg_isEncryptedUpdate ? 258 : 256;
    }

    private int getRequiredChallengeResponseLength() {
        if (this._taskExport == null) {
            return this._cfg_isEncryptedUpdate ? 24 : 8;
        }
        if (this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_USB) {
            return 0;
        }
        return this._cfg_isEncryptedUpdate ? 24 : 8;
    }

    private Integer getCRCOfBinFile() {
        return this._cfg_bin_crc == null ? null : Integer.valueOf(this._cfg_bin_crc.shortValue());
    }

    private boolean getChallenge() {
        if (this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_USB) {
            return false;
        }
        TaskManager.TaskStartRet r = this._umMan.task_start_fwGetChallenge(this._umtMsg);
        return r == TaskManager.TaskStartRet.SUCCESS;
    }

    public boolean updateFirmware() {
        if (this.fm_file == null) {
            return false;
        }
        if (!this._device.device_isConnected()) {
            return false;
        }
        if (this._taskExport == null) {
            return false;
        }
        if (this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY) {
            TaskManager.TaskStartRet r = this._umMan.task_start_fwUpdate(this._umtMsg, this.fm_file);
            return r == TaskManager.TaskStartRet.SUCCESS;
        }
        if (this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB) {
            return this._usb.updateFirmware(this._umtMsg, this.fm_file);
        }
        if (this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
            return this._com.updateFirmware(this._umtMsg, this.fm_file);
        }
        if (this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT) {
            return this._btle.updateFirmware(this._umtMsg, this.fm_file);
        }
        return false;
    }

    private boolean updateFirmware(byte[] challengeResponse) {
        TaskManager.TaskStartRet r;
        if (this._cfg_bin == null) {
            this._umtMsg.onReceiveMsgUpdateFirmwareResult(306);
            return false;
        }
        if (!this._device.device_isConnected()) {
            return false;
        }
        if (challengeResponse != null) {
            if (!this._cfg_isEncryptedUpdate && challengeResponse.length != 8) {
                this._umtMsg.onReceiveMsgUpdateFirmwareResult(308);
                return false;
            }
            if (this._cfg_isEncryptedUpdate && challengeResponse.length != 24) {
                this._umtMsg.onReceiveMsgUpdateFirmwareResult(309);
                return false;
            }
            challengeResponse = (byte[])challengeResponse.clone();
        }
        return (r = this._umMan.task_start_fwUpdate(this._umtMsg, this._cfg_isEncryptedUpdate, this._cfg_bin, challengeResponse)) == TaskManager.TaskStartRet.SUCCESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] binfile_checkAndLoad(String path, boolean isEncrypted) {
        if (path == null) {
            return null;
        }
        File file = new File(path);
        if (!file.exists()) {
            return null;
        }
        int expectedMultiple = isEncrypted ? 258 : 256;
        int fileLen = (int)file.length();
        if (fileLen == 0 || fileLen % expectedMultiple != 0) {
            return null;
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(path);
            byte[] ret = new byte[fileLen];
            fis.read(ret);
            byte[] byArray = ret;
            return byArray;
        }
        catch (IOException e) {
            UMLog.e("FWUpdate", "file failed to load: " + e);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    public class FMStruct {
        public int N = 0;
        public byte[] blockS;
        private byte[] block0;
        public byte[] blockN;
        private byte[][] blocks;
        public String[] commands;

        public FMStruct(byte[] fmFile) {
            this.blockS = new byte[64];
            System.arraycopy(fmFile, 0, this.blockS, 0, 64);
            this.block0 = new byte[256];
            System.arraycopy(fmFile, 64, this.block0, 0, 256);
            this.blockN = new byte[256];
            System.arraycopy(fmFile, fmFile.length - 256, this.blockN, 0, 256);
            this.N = (fmFile.length - 64 - 256 - 256) / 2304;
            System.out.println("N: " + this.N);
            this.blocks = new byte[this.N][2304];
            int offset = 320;
            for (int i = 0; i < this.N; ++i) {
                System.arraycopy(fmFile, i * 2304 + offset, this.blocks[i], 0, 2304);
            }
        }

        public FMStruct(String[] _commands) {
            this.blockS = null;
            this.commands = new String[_commands.length];
            for (int i = 0; i < _commands.length; ++i) {
                this.commands[i] = new String(_commands[i]);
            }
        }

        public FMStruct(byte[] fmData, boolean neo2) {
            this.commands = null;
            if (fmData != null && fmData.length > 0) {
                this.blockS = new byte[fmData.length];
                System.arraycopy(fmData, 0, this.blockS, 0, fmData.length);
            }
        }

        public byte[] getBlock(int n) {
            if (n < 0) {
                return null;
            }
            if (n == 0) {
                return this.block0;
            }
            return this.blocks[n - 1];
        }
    }
}

