/*
 * Decompiled with CFR 0.152.
 */
package com.idtechproducts.device.bluetooth;

import android.content.Context;
import android.os.Handler;
import com.idtechproducts.device.Common;
import com.idtechproducts.device.IDT_Device;
import com.idtechproducts.device.ReaderInfo;
import com.idtechproducts.device.ResDataStruct;
import com.idtechproducts.device.audiojack.UMLog;
import com.idtechproducts.device.audiojack.tools.FirmwareUpdateTool;
import com.idtechproducts.device.audiojack.tools.FirmwareUpdateToolMsg;
import com.idtechproducts.device.bluetooth.BluetoothControllerMsg;
import com.idtechproducts.device.bluetooth.BluetoothLEController;
import com.idtechproducts.device.bluetooth.IDTechBluetoothMsg;

public class IDTechBluetoothLE {
    private static final String SDK_VER_STRING = "ID TECH Bluetooth SDK Ver 1.0";
    private static final String TAG = "SDK::BTLE";
    private final IDTechBluetoothMsg _msg;
    private BluetoothLEController _btle = null;
    private Context _context;
    private volatile boolean _state_isConnected;
    private IDT_Device.TaskExport _taskExport;
    private final int FW_CMD_RETRY = 10;
    int cnt = 0;

    public IDTechBluetoothLE(IDTechBluetoothMsg callback, Context context, IDT_Device.TaskExport taskExport) {
        this._msg = callback;
        this._context = context;
        this._state_isConnected = false;
        this._taskExport = taskExport;
        switch (this._taskExport.getReaderType()) {
            default: 
        }
        this._btle = new BluetoothLEController(context, this._msg, new BluetoothControllerMsgImpl());
    }

    private static String getSDKVersionInfo() {
        return SDK_VER_STRING;
    }

    public void setRegistered(boolean isRegistered) {
        this._btle.setRegistered(isRegistered);
    }

    public void registerListen() {
        if (!this._btle.isRegistered()) {
            this._btle.registerReceiver();
        }
        if (this._btle.initWithThread()) {
            this._state_isConnected = true;
            if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT) {
                this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT);
            } else if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT) {
                this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT);
            } else if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
                this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT);
            }
            this._msg.bt_onReceiveMsgConnected();
        }
    }

    public void registerListen(Handler handler) {
        if (!this._btle.isRegistered()) {
            this._btle.registerReceiver(handler);
        }
        if (this._btle.initWithThread()) {
            this._state_isConnected = true;
            if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT) {
                this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT);
            } else if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT) {
                this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT);
            } else if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
                this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT);
            }
            this._msg.bt_onReceiveMsgConnected();
        }
    }

    public void unregisterListen() {
        if (this._btle.isRegistered()) {
            this._btle.unregisterReceiver();
        }
    }

    public boolean isReaderConnected() {
        return this._btle.isConnected();
    }

    public BluetoothLEController getBluetoothController() {
        return this._btle;
    }

    public byte[] sendCommand(String cmd, int timeout) {
        if (!this._state_isConnected) {
            return null;
        }
        this._btle.disableSwipe();
        byte[] command = Common.makeCommand(cmd);
        UMLog.i("**sendCommand**", Common.base16Encode(command) + " timeout: " + timeout + " cnt: " + this.cnt);
        ++this.cnt;
        byte[] response = null;
        int retry = IDT_Device.bleRetryCount;
        if (retry < 1) {
            retry = 1;
        }
        boolean doLoop = true;
        int counter = 0;
        while (doLoop) {
            doLoop = false;
            UMLog.i("sendCommand", "counter: " + ++counter);
            response = this._btle.sendCommand(command, timeout);
            if (response == null || response.length <= 11 || response[11] != 4 || counter >= retry) continue;
            doLoop = true;
        }
        return response;
    }

    public byte[] sendCommand(byte[] command, int timeout) {
        if (!this._state_isConnected) {
            return null;
        }
        this._btle.disableSwipe();
        UMLog.i("**sendCommand**", Common.base16Encode(command) + " timeout: " + timeout + " cnt: " + this.cnt);
        ++this.cnt;
        byte[] response = null;
        int retry = IDT_Device.bleRetryCount;
        if (retry < 1) {
            retry = 1;
        }
        boolean doLoop = true;
        int counter = 0;
        while (doLoop) {
            doLoop = false;
            UMLog.i("sendCommand", "counter: " + ++counter);
            response = this._btle.sendCommand(command, timeout);
            if (response == null || response.length <= 11 || response[11] != 4 || counter >= retry) continue;
            doLoop = true;
        }
        return response;
    }

    public byte[] sendCommandOnly(String cmd, int timeout) {
        if (!this._state_isConnected) {
            return null;
        }
        this._btle.disableSwipe();
        byte[] command = Common.makeCommand(cmd);
        UMLog.i("**sendCommand**", Common.base16Encode(command) + " timeout: " + timeout);
        return this._btle.sendCommandOnly(command, timeout);
    }

    private byte[] sendCommandFw(String cmd) {
        if (!this._state_isConnected) {
            return null;
        }
        byte[] command = Common.makeCommand(cmd);
        return this._btle.sendCommandFw(command);
    }

    public byte[] sendCommandFw(String cmd, int timeout) {
        if (!this._state_isConnected) {
            return null;
        }
        this._btle.disableSwipe();
        byte[] command = Common.makeCommand(cmd);
        UMLog.i("**sendCommandFw**", Common.base16Encode(command) + " timeout: " + timeout);
        ++this.cnt;
        byte[] response = null;
        int retry = IDT_Device.bleRetryCount;
        if (retry < 1) {
            retry = 1;
        }
        boolean doLoop = true;
        int counter = 0;
        while (doLoop) {
            doLoop = false;
            UMLog.i("sendCommandFw", "counter: " + ++counter);
            response = this._btle.sendCommand(command, timeout);
            if (response == null || response.length <= 11 || response[11] != 4 || counter >= retry) continue;
            doLoop = true;
        }
        return response;
    }

    public boolean startSwipeCard() {
        UMLog.i(TAG, "To enable Swipe...");
        if (!this._state_isConnected) {
            IDT_Device.isCommandRunning = false;
            return false;
        }
        return this._btle.enableSwipe();
    }

    public boolean startListenCard() {
        UMLog.i(TAG, "To enable Listen...");
        if (!this._state_isConnected) {
            return false;
        }
        return this._btle.enableListen();
    }

    public boolean stopListenCard() {
        UMLog.i(TAG, "To disable Listen...");
        return this._btle.disableListen();
    }

    public void setConnected(boolean connected) {
        this._btle.setConnected(connected);
    }

    private boolean startReadCard(int timeout, ResDataStruct respData) {
        UMLog.i(TAG, "To enable Swipe...");
        if (!this._state_isConnected) {
            return false;
        }
        return this._btle.enableRead(timeout, respData);
    }

    public boolean readMessage(int timeout, long startTime, ResDataStruct respData, boolean ignoreLCDMsg) {
        UMLog.i(TAG, "To read message...");
        if (!this._state_isConnected) {
            return false;
        }
        boolean value = this._btle.readMessage(timeout, startTime, respData, ignoreLCDMsg);
        return value;
    }

    public boolean emv_readMessage(int timeout, long startTime, ResDataStruct respData, boolean ignoreLCDMsg) {
        UMLog.i(TAG, "To read EMV message...");
        if (!this._state_isConnected) {
            return false;
        }
        boolean value = this._btle.emv_readMessage(timeout, startTime, respData, ignoreLCDMsg);
        return value;
    }

    public byte[] sendCommandForRKI(String cmd, int timeout) {
        if (!this._state_isConnected) {
            return null;
        }
        this._btle.disableSwipe();
        byte[] command = IDTechBluetoothLE.makeCommandForRKI(cmd);
        UMLog.i("**sendCommandForRKI**", Common.base16Encode(command) + " timeout: " + timeout);
        return this._btle.sendCommand(command, timeout);
    }

    private static byte[] makeCommandForRKI(String commandBodyData) {
        if (commandBodyData == null) {
            return null;
        }
        String sum = IDTechBluetoothLE.getSUM(commandBodyData);
        String lrc = IDTechBluetoothLE.getLRC(commandBodyData);
        short length = (short)(commandBodyData.length() / 2);
        byte[] lowHigh = new byte[2];
        byte[] cmdLen = new byte[1];
        lowHigh[0] = (byte)(length & 0xFF);
        lowHigh[1] = (byte)(length >> 8 & 0xFF);
        cmdLen[0] = lowHigh[0];
        String lengthCommand = Common.getHexStringFromBytes(lowHigh);
        String commandData = "02" + lengthCommand + commandBodyData + lrc + sum + "03";
        return Common.getByteArray(commandData);
    }

    private void stopSwipeCard() {
        UMLog.i(TAG, "To disable Swipe...");
        this._btle.disableSwipe();
    }

    private boolean setTimeoutOfSwipeCard(int timeoutValue) {
        this._btle.setTimeoutOfSwipeCard(timeoutValue);
        return true;
    }

    private boolean enterBootloader() {
        if (this._btle == null) {
            return false;
        }
        byte[] ret = this.sendCommand("78467A495246570000000000000000", 30);
        if (ret != null) {
            UMLog.w(TAG, "RET: " + Common.base16Encode(ret));
            return ret[3] == 6;
        }
        return false;
    }

    public boolean updateFirmware(FirmwareUpdateToolMsg _umtMsg, FirmwareUpdateTool.FMStruct fmFile) {
        if (this._btle == null) {
            return false;
        }
        FwUpdateThread fwThread = new FwUpdateThread(fmFile, _umtMsg);
        fwThread.start();
        return true;
    }

    private static String getSUM(String strData) {
        String strLRC = null;
        byte[] toCharArray = Common.getByteArray(strData);
        byte[] sum = new byte[]{toCharArray[0]};
        for (int i = 1; i < toCharArray.length; ++i) {
            sum[0] = (byte)(sum[0] + toCharArray[i]);
        }
        strLRC = Common.getHexStringFromBytes(sum);
        return strLRC;
    }

    private static String getLRC(String strData) {
        String strLRC = null;
        byte[] toCharArray = Common.getByteArray(strData);
        byte[] lrc = new byte[]{toCharArray[0]};
        for (int i = 1; i < toCharArray.length; ++i) {
            lrc[0] = (byte)(lrc[0] ^ toCharArray[i]);
        }
        strLRC = Common.getHexStringFromBytes(lrc);
        return strLRC;
    }

    private class BluetoothControllerMsgImpl
    implements BluetoothControllerMsg {
        private BluetoothControllerMsgImpl() {
        }

        @Override
        public void onDeviceAttached() {
            if (IDTechBluetoothLE.this._btle.initWithThread()) {
                IDTechBluetoothLE.this._state_isConnected = true;
                if (IDTechBluetoothLE.this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT) {
                    IDTechBluetoothLE.this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT);
                } else if (IDTechBluetoothLE.this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT) {
                    IDTechBluetoothLE.this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT);
                } else if (IDTechBluetoothLE.this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
                    IDTechBluetoothLE.this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT);
                }
            }
        }

        @Override
        public void onDeviceDetached() {
            IDTechBluetoothLE.this._state_isConnected = false;
            IDTechBluetoothLE.this._msg.bt_onReceiveMsgDisconnected();
            if (IDTechBluetoothLE.this._btle != null) {
                IDTechBluetoothLE.this._btle.startCheckingConnection();
            }
        }

        @Override
        public void onDeviceNotFound() {
            if (IDTechBluetoothLE.this._btle != null) {
                IDTechBluetoothLE.this._btle.startCheckingConnection();
            }
        }
    }

    private class FwUpdateThread
    extends Thread {
        FirmwareUpdateTool.FMStruct fmFile;
        FirmwareUpdateToolMsg _umtMsg;

        private FwUpdateThread(FirmwareUpdateTool.FMStruct fm, FirmwareUpdateToolMsg msg) {
            this.fmFile = fm;
            this._umtMsg = msg;
        }

        public void run_old() {
            this._umtMsg.onReceiveMsgUpdateFirmwareProgress(0);
            this._umtMsg.onReceiveMsgUpdateFirmwareProgress(1);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            byte[] ret = IDTechBluetoothLE.this.sendCommandFw("420000" + Common.base16Encode(this.fmFile.getBlock(0)));
            if (ret == null) {
                UMLog.i(IDTechBluetoothLE.TAG, "notify failed firmware update (Block #0)");
                this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                return;
            }
            if (ret[3] != 6) {
                UMLog.i(IDTechBluetoothLE.TAG, "notify failed firmware update (Block #0)");
                this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                return;
            }
            UMLog.i(IDTechBluetoothLE.TAG, "Block #0 sent successfully.");
            for (int curBlock = 0; curBlock < this.fmFile.N; ++curBlock) {
                int currentProgress = (curBlock + 2) * 100 / (this.fmFile.N + 3);
                this._umtMsg.onReceiveMsgUpdateFirmwareProgress(currentProgress);
                int blockNumber = curBlock + 1;
                byte[] command = new byte[1027];
                command[0] = 66;
                command[1] = (byte)blockNumber;
                command[2] = 0;
                System.arraycopy(this.fmFile.getBlock(blockNumber), 0, command, 3, 1024);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                ret = IDTechBluetoothLE.this.sendCommandFw(Common.getHexStringFromBytes(command));
                if (ret == null) {
                    UMLog.i(IDTechBluetoothLE.TAG, "notify failed firmware update (Block #" + blockNumber + "-0)");
                    this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                } else if (ret[3] != 6) {
                    UMLog.i(IDTechBluetoothLE.TAG, "notify failed firmware update (Block #" + blockNumber + "-0)");
                    this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                } else {
                    UMLog.i(IDTechBluetoothLE.TAG, "Block #" + blockNumber + "-0 sent successfully.");
                }
                command = new byte[1027];
                command[0] = 66;
                command[1] = (byte)blockNumber;
                command[2] = 1;
                System.arraycopy(this.fmFile.getBlock(blockNumber), 1024, command, 3, 1024);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                ret = IDTechBluetoothLE.this.sendCommandFw(Common.getHexStringFromBytes(command));
                if (ret == null) {
                    UMLog.i(IDTechBluetoothLE.TAG, "notify failed firmware update (Block #" + blockNumber + "-1)");
                    this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                } else if (ret[3] != 6) {
                    UMLog.i(IDTechBluetoothLE.TAG, "notify failed firmware update (Block #" + blockNumber + "-1)");
                    this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                } else {
                    UMLog.i(IDTechBluetoothLE.TAG, "Block #" + blockNumber + "-1 sent successfully.");
                }
                command = new byte[259];
                command[0] = 66;
                command[1] = (byte)blockNumber;
                command[2] = 2;
                System.arraycopy(this.fmFile.getBlock(blockNumber), 2048, command, 3, 256);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                ret = IDTechBluetoothLE.this.sendCommandFw(Common.getHexStringFromBytes(command));
                if (ret == null) {
                    UMLog.i(IDTechBluetoothLE.TAG, "notify failed firmware update (Block #" + blockNumber + "-2)");
                    this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                    continue;
                }
                if (ret[3] != 6) {
                    UMLog.i(IDTechBluetoothLE.TAG, "notify failed firmware update (Block #" + blockNumber + "-2)");
                    this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                    continue;
                }
                UMLog.i(IDTechBluetoothLE.TAG, "Block #" + blockNumber + "-2 sent successfully.");
            }
            int currentProgress = (this.fmFile.N + 2) * 100 / (this.fmFile.N + 3);
            this._umtMsg.onReceiveMsgUpdateFirmwareProgress(currentProgress);
            byte[] checksumCommand = new byte[259];
            checksumCommand[0] = 66;
            checksumCommand[1] = -1;
            checksumCommand[2] = -1;
            System.arraycopy(this.fmFile.blockN, 0, checksumCommand, 3, 256);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ret = IDTechBluetoothLE.this.sendCommandFw(Common.base16Encode(checksumCommand));
            if (ret == null) {
                UMLog.i(IDTechBluetoothLE.TAG, "notify failed firmware update (checksum block)");
                this._umtMsg.onReceiveMsgUpdateFirmwareResult(304);
            } else if (ret[3] != 6) {
                UMLog.i(IDTechBluetoothLE.TAG, "notify failed firmware update ((checksum block))");
                this._umtMsg.onReceiveMsgUpdateFirmwareResult(304);
            } else {
                UMLog.i(IDTechBluetoothLE.TAG, "Checksum block sent successfully.");
                UMLog.i(IDTechBluetoothLE.TAG, "notify finished successfully");
                this._umtMsg.onReceiveMsgUpdateFirmwareResult(301);
            }
        }

        public void run_pk_slow() {
            if (Common.update_type == ReaderInfo.FIRMWARE_UPDATE_TYPES.FU_PACKAGE_DOWNLOAD) {
                int f;
                IDT_Device.kernel = false;
                UMLog.i("**FwUpdateThread**", "Package Download Slow");
                IDT_Device.PackageDownloadStartIndex = 0;
                int packageBlockSize = 512;
                byte[] data = null;
                boolean dataExist = false;
                if (this.fmFile.blockS[0] != 70 || this.fmFile.blockS[1] != 87 || this.fmFile.blockS[2] != 80 || this.fmFile.blockS[3] != 75) {
                    UMLog.i("**FwUpdateThread**", "FWPK Error");
                    this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                    IDT_Device.isCommandRunning = false;
                    IDT_Device.kernelDone = true;
                    return;
                }
                UMLog.i("**FwUpdateThread**", "Package Download");
                int fileSize = (this.fmFile.blockS[9] & 0xFF) << 24 | (this.fmFile.blockS[8] & 0xFF) << 16 | (this.fmFile.blockS[7] & 0xFF) << 8 | this.fmFile.blockS[6] & 0xFF;
                if (fileSize != this.fmFile.blockS.length) {
                    UMLog.i("**FwUpdateThread**", "File Size Error");
                    this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                    IDT_Device.isCommandRunning = false;
                    return;
                }
                byte[] cmdData = new byte[70];
                cmdData[0] = 2;
                cmdData[1] = 0;
                System.arraycopy(this.fmFile.blockS, 0, cmdData, 2, 68);
                UMLog.i("**sendCommand**", Common.base16Encode(Common.grsiP2Command((byte)-57, (byte)120, cmdData)) + " timeout: " + 5);
                data = IDTechBluetoothLE.this._btle.sendCommand(Common.grsiP2Command((byte)-57, (byte)120, cmdData), 5);
                if (data != null && data.length > 15) {
                    if (data[10] == -57 && data[11] == 0 && data[12] == 0 && data[13] == 2) {
                        IDT_Device.PackageDownloadStartIndex = (data[14] & 0xFF) << 8 | data[15] & 0xFF;
                        UMLog.i("**FwUpdateThread**", "Resume Index: " + IDT_Device.PackageDownloadStartIndex);
                    } else {
                        UMLog.i("**FwUpdateThread**", "No Resume");
                    }
                } else {
                    UMLog.i("**FwUpdateThread**", "No Resume");
                }
                int blockNum = 0;
                if (!dataExist) {
                    if (IDT_Device.PackageDownloadStartIndex == 0) {
                        for (f = 0; f < 10; ++f) {
                            byte[] fs = new byte[]{this.fmFile.blockS[9], this.fmFile.blockS[8], this.fmFile.blockS[7], this.fmFile.blockS[6]};
                            UMLog.i("**sendCommand**", Common.base16Encode(Common.grsiP2Command((byte)-57, (byte)113, fs)) + " timeout: " + 37);
                            data = IDTechBluetoothLE.this._btle.sendCommand(Common.grsiP2Command((byte)-57, (byte)113, fs), 37);
                            if (data != null && data.length >= 16 && data[11] == 0) break;
                            UMLog.i("**FwUpdateThread**", "0xC7-71 retry number " + f);
                            if (f == 9) {
                                UMLog.i("**FwUpdateThread**", "0xC7-71");
                                this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                                IDT_Device.isCommandRunning = false;
                                IDT_Device.kernelDone = true;
                                return;
                            }
                            try {
                                Thread.sleep(500L);
                                continue;
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    blockNum = this.fmFile.blockS.length / packageBlockSize;
                    int remainingSize = this.fmFile.blockS.length % packageBlockSize;
                    for (int index = IDT_Device.PackageDownloadStartIndex; index < (remainingSize > 0 ? blockNum + 1 : blockNum); ++index) {
                        int percentage;
                        byte[] blockData = new byte[packageBlockSize + 2];
                        blockData[0] = (byte)(index + 1 >> 8 & 0xFF);
                        blockData[1] = (byte)(index + 1 & 0xFF);
                        for (int f2 = 0; f2 < 10; ++f2) {
                            if (index == blockNum) {
                                byte[] remaingData = new byte[remainingSize + 2];
                                System.arraycopy(blockData, 0, remaingData, 0, 2);
                                System.arraycopy(this.fmFile.blockS, index * packageBlockSize, remaingData, 2, remainingSize);
                                UMLog.i("**sendCommand**", Common.base16Encode(Common.grsiP2Command((byte)-57, (byte)114, remaingData)) + " timeout: " + 7);
                                data = IDTechBluetoothLE.this._btle.sendCommand(Common.grsiP2Command((byte)-57, (byte)114, remaingData), 7);
                            } else {
                                System.arraycopy(this.fmFile.blockS, index * packageBlockSize, blockData, 2, packageBlockSize);
                                UMLog.i("**sendCommand**", Common.base16Encode(Common.grsiP2Command((byte)-57, (byte)114, blockData)) + " timeout: " + 7);
                                data = IDTechBluetoothLE.this._btle.sendCommand(Common.grsiP2Command((byte)-57, (byte)114, blockData), 7);
                            }
                            if (data != null && data.length >= 16 && data[11] == 0) break;
                            UMLog.i("**FwUpdateThread**", "0xC7-72 retry number " + f2);
                            if (f2 == 9) {
                                UMLog.i("**FwUpdateThread**", "0xC7-72 Block " + index);
                                this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                                IDT_Device.isCommandRunning = false;
                                IDT_Device.kernelDone = true;
                                return;
                            }
                            try {
                                Thread.sleep(500L);
                                continue;
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                        if ((percentage = (index + 1) / ((blockNum + 1) / 100 == 0 ? 1 : (blockNum + 1) / 100)) > 100) {
                            percentage = 100;
                        }
                        this._umtMsg.onReceiveMsgUpdateFirmwareProgress(percentage);
                    }
                    this._umtMsg.onReceiveMsgUpdateFirmwareProgress(100);
                    for (int f3 = 0; f3 < 10; ++f3) {
                        UMLog.i("**sendCommand**", Common.base16Encode(Common.grsiP2Command((byte)-57, (byte)115, new byte[0])) + " timeout: " + 12);
                        data = IDTechBluetoothLE.this._btle.sendCommand(Common.grsiP2Command((byte)-57, (byte)115, new byte[0]), 12);
                        if (data != null && data.length >= 16 && data[11] == 0) break;
                        UMLog.i("**FwUpdateThread**", "0xC7-73 retry number " + f3);
                        if (f3 == 9) {
                            UMLog.i("**FwUpdateThread**", "0xC7-73");
                            this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                            IDT_Device.isCommandRunning = false;
                            IDT_Device.kernelDone = true;
                            return;
                        }
                        try {
                            Thread.sleep(500L);
                            continue;
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }
                for (f = 0; f < 10; ++f) {
                    UMLog.i("**sendCommand**", Common.base16Encode(Common.grsiP2Command((byte)-57, (byte)117, new byte[0])) + " timeout: " + 12);
                    data = IDTechBluetoothLE.this._btle.sendCommand(Common.grsiP2Command((byte)-57, (byte)117, new byte[0]), 12);
                    if (data != null && data.length >= 16 && data[11] == 0) break;
                    UMLog.i("**FwUpdateThread**", "0xC7-75 retry number " + f);
                    if (f == 9) {
                        UMLog.i("**FwUpdateThread**", "0xC7-75");
                        this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                        IDT_Device.isCommandRunning = false;
                        IDT_Device.kernelDone = true;
                        return;
                    }
                    try {
                        Thread.sleep(500L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                this._umtMsg.onReceiveMsgUpdateFirmwareResult(301);
                IDT_Device.isCommandRunning = false;
                IDT_Device.kernelDone = true;
            }
        }

        public void run_no_resume() {
            if (Common.update_type == ReaderInfo.FIRMWARE_UPDATE_TYPES.FU_PACKAGE_DOWNLOAD) {
                IDT_Device.kernel = false;
                UMLog.i("**FwUpdateThread**", "Package Download");
                byte[] data = null;
                byte[] fileSize = new byte[]{(byte)(this.fmFile.blockS.length >> 24 & 0xFF), (byte)(this.fmFile.blockS.length >> 16 & 0xFF), (byte)(this.fmFile.blockS.length >> 8 & 0xFF), (byte)(this.fmFile.blockS.length & 0xFF)};
                UMLog.i("**sendCommand**", Common.base16Encode(Common.grsiP2Command((byte)-57, (byte)119, fileSize)) + " timeout: " + 3);
                data = IDTechBluetoothLE.this._btle.sendCommand(Common.grsiP2Command((byte)-57, (byte)119, fileSize), 3);
                if (data != null && data.length > 11) {
                    if (data[10] != -57 || data[11] != 0) {
                        UMLog.i("**FwUpdateThread**", "FWPK Error");
                        this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                        IDT_Device.isCommandRunning = false;
                        return;
                    }
                } else {
                    this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                    IDT_Device.isCommandRunning = false;
                    return;
                }
                boolean rt = IDTechBluetoothLE.this._btle.write_raw_data(this.fmFile.blockS, this._umtMsg);
                if (rt) {
                    this._umtMsg.onReceiveMsgUpdateFirmwareResult(301);
                } else {
                    this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                }
                IDT_Device.isCommandRunning = false;
                IDT_Device.kernelDone = true;
            }
        }

        @Override
        public void run() {
            if (Common.update_type == ReaderInfo.FIRMWARE_UPDATE_TYPES.FU_PACKAGE_DOWNLOAD) {
                boolean rt;
                IDT_Device.kernel = false;
                UMLog.i("**FwUpdateThread**", "Package Download");
                IDT_Device.PackageDownloadStartIndex = 0;
                byte[] data = null;
                UMLog.i("**sendCommand**", Common.base16Encode(Common.grsiP2Command((byte)-57, (byte)119, new byte[0])) + " timeout: " + 40);
                data = IDTechBluetoothLE.this._btle.sendCommand(Common.grsiP2Command((byte)-57, (byte)119, new byte[0]), 40);
                if (data != null && data.length > 11 && data[10] == -57 && (data[11] == 10 || data[11] == 2 || data[11] == 3)) {
                    UMLog.i("**FwUpdateThread**", "FWPK Use Slow Way");
                    this.run_pk_slow();
                    return;
                }
                byte[] cmdData = new byte[70];
                cmdData[0] = 0;
                cmdData[1] = -12;
                System.arraycopy(this.fmFile.blockS, 0, cmdData, 2, 68);
                UMLog.i("**sendCommand**", Common.base16Encode(Common.grsiP2Command((byte)-57, (byte)120, cmdData)) + " timeout: " + 5);
                data = IDTechBluetoothLE.this._btle.sendCommand(Common.grsiP2Command((byte)-57, (byte)120, cmdData), 5);
                if (data != null && data.length > 15) {
                    if (data[10] == -57 && data[11] == 0 && data[12] == 0 && data[13] == 2) {
                        IDT_Device.PackageDownloadStartIndex = (data[14] & 0xFF) << 8 | data[15] & 0xFF;
                        UMLog.i("**FwUpdateThread**", "Resume Index: " + IDT_Device.PackageDownloadStartIndex);
                    } else {
                        UMLog.i("**FwUpdateThread**", "No Resume");
                    }
                } else {
                    UMLog.i("**FwUpdateThread**", "No Resume");
                }
                if (IDT_Device.PackageDownloadStartIndex == 0) {
                    data = null;
                    byte[] fileSize = new byte[]{(byte)(this.fmFile.blockS.length >> 24 & 0xFF), (byte)(this.fmFile.blockS.length >> 16 & 0xFF), (byte)(this.fmFile.blockS.length >> 8 & 0xFF), (byte)(this.fmFile.blockS.length & 0xFF)};
                    UMLog.i("**sendCommand**", Common.base16Encode(Common.grsiP2Command((byte)-57, (byte)119, fileSize)) + " timeout: " + 40);
                    data = IDTechBluetoothLE.this._btle.sendCommand(Common.grsiP2Command((byte)-57, (byte)119, fileSize), 40);
                    if (data != null && data.length > 11) {
                        if (data[10] == -57 && (data[11] == 10 || data[11] == 11)) {
                            UMLog.i("**FwUpdateThread**", "FWPK Use Slow Way");
                            this.run_pk_slow();
                            return;
                        }
                        if (data[10] != -57 || data[11] != 0) {
                            UMLog.i("**FwUpdateThread**", "FWPK Error");
                            this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                            IDT_Device.isCommandRunning = false;
                            return;
                        }
                    } else {
                        this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                        IDT_Device.isCommandRunning = false;
                        return;
                    }
                }
                if (rt = IDTechBluetoothLE.this._btle.write_raw_data(this.fmFile.blockS, this._umtMsg)) {
                    this._umtMsg.onReceiveMsgUpdateFirmwareResult(301);
                } else {
                    long startTime = System.currentTimeMillis();
                    ResDataStruct temp = new ResDataStruct();
                    IDTechBluetoothLE.this._btle.readMessage(1, startTime, temp, true);
                    this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                }
                IDT_Device.isCommandRunning = false;
                IDT_Device.kernelDone = true;
            }
        }
    }
}

