/*
 * Decompiled with CFR 0.152.
 */
package com.idtechproducts.device.usb;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.os.Build;
import android.os.Handler;
import android.util.Log;
import com.idtechproducts.device.Common;
import com.idtechproducts.device.IDTLCDData;
import com.idtechproducts.device.IDTMSRData;
import com.idtechproducts.device.IDT_Device;
import com.idtechproducts.device.ReaderInfo;
import com.idtechproducts.device.ResDataStruct;
import com.idtechproducts.device.USBBypassListener;
import com.idtechproducts.device.audiojack.UMLog;
import com.idtechproducts.device.usb.IDTechUsbHidMsg;
import com.idtechproducts.device.usb.UsbControllerMsg;
import java.util.Arrays;
import java.util.HashMap;

public final class UsbController {
    private static final String ACTION_USB_PERMISSION = "com.idtechproducts.usbhid.USB_PERMISSION";
    private static final String TAG = "SDK::USB Controller";
    private final int VID;
    private final int PID;
    private UsbManager mManager = null;
    private PendingIntent pi;
    private UsbDevice usbDevice = null;
    private UsbInterface usbInterface = null;
    private UsbDeviceConnection connection = null;
    private static UsbEndpoint epIn = null;
    private static UsbEndpoint epOut = null;
    private Context ctx = null;
    private IDTechUsbHidMsg _msg = null;
    private UsbControllerMsg _usbMsg = null;
    private IPermissionListener mlistener = null;
    private IntentFilter mUsbFilter = null;
    private CheckDeviceThread checkThread;
    private USBBypassListener m_recListener = null;
    private boolean waitingForResult = false;
    private boolean waitingForBulkTransfer = false;
    private static boolean toClose = false;
    private int swipeTimeoutSec;
    private int swipeCount = 0;
    private SwipeDataReceiver swipeThread;
    private listenForDataOnThread listenThread = null;
    private byte[] swipeBuffer;
    private byte[] cmdBuffer;
    private byte[] temp;
    private Handler mainHandler = null;
    private CommandDataReceiver commandThread;
    private int cmdID = -1;
    private int dataCount = 0;
    private static final int PAUSE_SWIPE_READ = 10;
    private static final int PAUSE_COMMAND_READ = 30;
    private static final int PAUSE_BEFORE_READ_BUFFER = 500;
    private static final int PAUSE_BEFORE_READ_BUFFER_LONGER = 1000;
    private String cmdBufferRet = "";
    private byte[] previousCmdBuffer = null;
    private byte[] secureMagBuf = null;
    private boolean askPermission = false;
    Runnable deviceAttached = new Runnable(){

        @Override
        public void run() {
            UMLog.i(UsbController.TAG, "Sending attached for device_filter");
            UsbController.this._usbMsg.onDeviceAttached();
        }
    };
    private static boolean _inThreadLoop = false;
    private boolean registered = false;
    private static int preSendDelay = 0;
    private static int postSendDelay = 0;
    private BroadcastReceiver mPermissionReceiver = new PermissionReceiver(new IPermissionListener(){

        @Override
        public void onPermissionDenied(UsbDevice d) {
            UMLog.i(UsbController.TAG, "Permission denied on " + d.getDeviceId());
        }
    });
    private BroadcastReceiver mUsbReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            UsbDevice device;
            String action = intent.getAction();
            if (action.equals("android.hardware.usb.action.USB_DEVICE_DETACHED") && (device = (UsbDevice)intent.getParcelableExtra("device")) != null && device.getVendorId() == UsbController.this.VID && device.getProductId() == UsbController.this.PID) {
                UMLog.i(UsbController.TAG, "USB device detached: " + device.getVendorId());
                if (UsbController.this._usbMsg != null && UsbController.this._msg != null) {
                    IDT_Device.pk_stop = true;
                    UMLog.i(UsbController.TAG, "IDT_Device.pk_stop: " + IDT_Device.pk_stop);
                    UsbController.this._usbMsg.onDeviceDetached();
                }
            }
        }
    };

    public void externalConnect() {
        if (IDT_Device.getUSBBypass() && this._usbMsg != null) {
            IDT_Device.allowReceiverCallback = true;
            this._usbMsg.onDeviceAttached();
        }
    }

    public void externalDisconnect() {
        if (IDT_Device.getUSBBypass() && this._usbMsg != null) {
            this._usbMsg.onDeviceDetached();
        }
    }

    public void externalDeviceNotFound() {
        if (IDT_Device.getUSBBypass() && this._usbMsg != null) {
            this._usbMsg.onDeviceNotFound();
        }
    }

    public UsbController(Context context, IDTechUsbHidMsg msg, UsbControllerMsg msg2, int vid, int pid, USBBypassListener listen) {
        this.m_recListener = listen;
        this.ctx = context;
        this.VID = vid;
        this.PID = pid;
        this._msg = msg;
        this._usbMsg = msg2;
        this.swipeBuffer = new byte[4096];
        this.cmdBuffer = new byte[8];
        this.temp = new byte[4096];
        this.swipeTimeoutSec = 200;
        this.mManager = (UsbManager)this.ctx.getSystemService("usb");
        this.mainHandler = new Handler(context.getMainLooper());
    }

    public boolean init() {
        if (this.askPermission) {
            return false;
        }
        if (IDT_Device.getUSBBypass()) {
            this.m_recListener.connectToDevice();
            return true;
        }
        this.mlistener = new IPermissionListener(){

            @Override
            public void onPermissionDenied(UsbDevice d) {
                if (!IDT_Device._isDeviceFilter) {
                    UsbController.this.askPermission = true;
                    UMLog.i(UsbController.TAG, "Asking a permission for accessing USB-HID device (non-thread)");
                    UsbController.this.mManager.requestPermission(d, UsbController.this.pi);
                }
            }
        };
        if (this.findUsbHidDevice(this.mlistener)) {
            UMLog.i(TAG, "USB-HID device is found (non-thread).");
            return true;
        }
        UMLog.i(TAG, "USB-HID device is not found (non-thread).");
        this._usbMsg.onDeviceNotFound();
        return false;
    }

    private boolean initWithThread() {
        if (this.askPermission) {
            return false;
        }
        if (_inThreadLoop) {
            return false;
        }
        if (IDT_Device.getUSBBypass()) {
            this.m_recListener.connectToDevice();
            return true;
        }
        _inThreadLoop = true;
        this.mlistener = new IPermissionListener(){

            @Override
            public void onPermissionDenied(UsbDevice d) {
                if (!IDT_Device._isDeviceFilter) {
                    UsbController.this.askPermission = true;
                    UMLog.i(UsbController.TAG, "Asking a permission for accessing USB-HID device (thread)");
                    UsbController.this.mManager.requestPermission(d, UsbController.this.pi);
                }
            }
        };
        if (this.findUsbHidDevice(this.mlistener)) {
            UMLog.i(TAG, "USB-HID device is found (thread).");
            UMLog.i(TAG, "Permission Granted");
            UMLog.i(TAG, "initWithThread _isDeviceFilter: " + IDT_Device._isDeviceFilter);
            if (IDT_Device._isDeviceFilter) {
                UMLog.i(TAG, "Sending attached for device_filter (thread)");
                this.mainHandler.post(this.deviceAttached);
            }
            _inThreadLoop = false;
            return true;
        }
        _inThreadLoop = false;
        return false;
    }

    public void startCheckingConnection() {
        if (IDT_Device.getUSBBypass()) {
            return;
        }
        UMLog.i(TAG, "SDK starts monitoring if reader is connected.");
        this.checkThread = new CheckDeviceThread();
        this.checkThread.start();
    }

    public boolean isRegistered() {
        if (IDT_Device.getUSBBypass()) {
            return true;
        }
        return this.registered;
    }

    public void registerReceiver() {
        if (IDT_Device.getUSBBypass()) {
            return;
        }
        UMLog.i(TAG, "Register a Broadcast receiver to get UsbManager.ACTION_USB_DEVICE_DETACHED.");
        if (this.mUsbFilter == null) {
            this.mUsbFilter = new IntentFilter();
            this.mUsbFilter.addAction("android.hardware.usb.action.USB_DEVICE_DETACHED");
        }
        this.ctx.registerReceiver(this.mUsbReceiver, this.mUsbFilter);
        if (Build.VERSION.SDK_INT > 33) {
            this.pi = PendingIntent.getBroadcast((Context)this.ctx, (int)0, (Intent)new Intent(ACTION_USB_PERMISSION).setPackage(this.ctx.getPackageName()), (int)0x2000000);
            this.ctx.registerReceiver(this.mPermissionReceiver, new IntentFilter(ACTION_USB_PERMISSION), 2);
        } else if (Build.VERSION.SDK_INT > 22) {
            this.pi = PendingIntent.getBroadcast((Context)this.ctx, (int)0, (Intent)new Intent(ACTION_USB_PERMISSION).setPackage(this.ctx.getPackageName()), (int)0x2000000);
            this.ctx.registerReceiver(this.mPermissionReceiver, new IntentFilter(ACTION_USB_PERMISSION));
        } else {
            this.pi = PendingIntent.getBroadcast((Context)this.ctx, (int)0, (Intent)new Intent(ACTION_USB_PERMISSION), (int)0);
            this.ctx.registerReceiver(this.mPermissionReceiver, new IntentFilter(ACTION_USB_PERMISSION));
        }
        this.registered = true;
    }

    public void unregisterReceiver() {
        if (IDT_Device.getUSBBypass()) {
            this.registered = false;
            return;
        }
        UMLog.i(TAG, "A Broadcast receiver unregistered.");
        this.ctx.unregisterReceiver(this.mUsbReceiver);
        this.ctx.unregisterReceiver(this.mPermissionReceiver);
        this.close();
        this.mUsbFilter = null;
        this.registered = false;
    }

    public boolean enableSwipe() {
        if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG_KB) {
            if (this.connection == null || this.waitingForResult) {
                return false;
            }
            UMLog.i(TAG, "Set Auto Mode...");
            byte[] command = new byte[]{2, 83, 26, 1, 49, 3, 120};
            this.sendCommand(command, 21);
            UMLog.i(TAG, "SDK starts polling card data from reader.");
            this.swipeThread = new SwipeDataReceiver();
            this.swipeThread.start();
            return true;
        }
        if (this.connection == null && !IDT_Device.getUSBBypass() || this.waitingForResult) {
            return false;
        }
        UMLog.i(TAG, "SDK starts polling card data from reader.");
        if (this.swipeThread != null) {
            this.swipeThread.close();
        }
        this.swipeThread = new SwipeDataReceiver();
        this.waitingForResult = true;
        this.swipeCount = 0;
        this.swipeThread.start();
        return true;
    }

    public boolean enableListen() {
        if (this.connection == null && !IDT_Device.getUSBBypass()) {
            return false;
        }
        UMLog.i(TAG, "SDK starts listening card data from reader.");
        if (this.listenThread == null) {
            this.listenThread = new listenForDataOnThread();
            this.listenThread.isRunning = true;
            this.listenThread.start();
        }
        return true;
    }

    public boolean disableListen() {
        UMLog.i(TAG, "SDK stops listening card data from reader.");
        if (this.listenThread == null) {
            return false;
        }
        this.listenThread.isRunning = false;
        return true;
    }

    public boolean enableRead(int timeout, ResDataStruct respData) {
        if (this.connection == null && !IDT_Device.getUSBBypass()) {
            return false;
        }
        long startTime = System.currentTimeMillis();
        UMLog.i(TAG, "SDK starts polling data from reader.");
        respData.resData = Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA ? new byte[]{21, -127, 0} : new byte[]{0, 13, 0};
        while (System.currentTimeMillis() - startTime < (long)((timeout + 10) * 1000)) {
            int length = this.readMSR(this.swipeBuffer);
            if (length > 0) {
                if (this.swipeBuffer[3] != 6) {
                    return false;
                }
                respData.resData = new byte[length - 1];
                System.arraycopy(this.swipeBuffer, 1, respData.resData, 0, length - 1);
                UMLog.i(TAG, "got: " + Common.getByteArrDesc(this.swipeBuffer));
                break;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (timeout != 0) continue;
            startTime = System.currentTimeMillis();
        }
        return true;
    }

    public boolean readMessage(int timeout, long startTime, ResDataStruct respData, boolean ignoreLCDMsg) {
        if (this.connection == null && !IDT_Device.getUSBBypass()) {
            return false;
        }
        respData.resData = Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 ? new byte[]{0} : new byte[]{21, -127, 0};
        byte[] buff = new byte[4096];
        int res = 0;
        long endTime = System.currentTimeMillis();
        while (endTime - startTime <= (long)(timeout * 1000) || IDT_Device.infiniteTimeout) {
            if (IDT_Device.isTransactionRead && (IDT_Device.emvCancelTransaction || IDT_Device.cancelTransaction)) {
                if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB) {
                    IDT_Device.isTransactionRead = false;
                    IDT_Device.cancelTransaction = false;
                }
                Log.i((String)TAG, (String)"## Transaction Cancelled ");
                return true;
            }
            res = this._readMessage(buff);
            if (res > 0) {
                if (Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB) break;
                UMLog.i("**readMessage**", "_readMessage " + Common.base16Encode(buff) + "\n");
                if (res > 20 && buff[10] == 97 && buff[11] == -1) {
                    int dataLen = buff[12] << 8 | buff[13];
                    IDTLCDData lcdData = new IDTLCDData();
                    lcdData.screenID = buff[14] << 8 | buff[15];
                    lcdData.objectID = buff[16] << 8 | buff[17];
                    int chIdx = 18;
                    while (buff[chIdx] != 0) {
                        ++chIdx;
                    }
                    byte[] bytes = new byte[chIdx - 18];
                    System.arraycopy(buff, 18, bytes, 0, bytes.length);
                    lcdData.screenName = new String(bytes);
                    int chIdx2 = ++chIdx;
                    while (buff[chIdx] != 0) {
                        ++chIdx;
                    }
                    bytes = new byte[chIdx - chIdx2];
                    System.arraycopy(buff, chIdx2, bytes, 0, bytes.length);
                    lcdData.objectName = new String(bytes);
                    if (dataLen > 4 + lcdData.screenName.length() + 1 + lcdData.objectName.length() + 1) {
                        lcdData.longPressed = buff[20 + lcdData.screenName.length() + lcdData.objectName.length()];
                    }
                    this._msg.usb_onReceiveMsgLcdData(lcdData);
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    endTime = System.currentTimeMillis();
                    continue;
                }
                if (!ignoreLCDMsg || res <= 12 || buff[10] != 97 || buff[11] != 1) break;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                res = 0;
                continue;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            endTime = System.currentTimeMillis();
        }
        if (endTime - startTime > (long)(timeout * 1000) && !IDT_Device.infiniteTimeout) {
            return false;
        }
        if (res > 0) {
            respData.resData = null;
            if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800) {
                respData.resData = new byte[res];
                try {
                    System.arraycopy(buff, 0, respData.resData, 0, res);
                }
                catch (ArrayIndexOutOfBoundsException exception) {
                    return false;
                }
                UMLog.i("**USB getResponse 1**", Common.base16Encode(respData.resData));
                this._msg.usb_onReceiveMsgGetResponse(respData.resData);
            } else {
                respData.resData = new byte[res - 6];
                byte[] fullNGA = new byte[res];
                try {
                    System.arraycopy(buff, 3, respData.resData, 0, res - 6);
                    System.arraycopy(buff, 0, fullNGA, 0, res);
                }
                catch (ArrayIndexOutOfBoundsException exception) {
                    return false;
                }
                UMLog.i("**USB getResponse 2**", Common.base16Encode(fullNGA));
                this._msg.usb_onReceiveMsgGetResponse(fullNGA);
            }
            return true;
        }
        return false;
    }

    public void disableSwipe() {
        UMLog.i(TAG, "SDK stops polling card data from reader.");
        if (this.swipeThread != null) {
            this.swipeThread.close();
        }
        this.waitingForResult = false;
    }

    private boolean isSwipeEnabled() {
        return this.waitingForResult;
    }

    public void setTimeoutOfSwipeCard(int timeoutInSec) {
        UMLog.i(TAG, "Timeout for card swipe changed to " + timeoutInSec + " seconds.");
        this.swipeTimeoutSec = timeoutInSec;
    }

    public void readBuffer(ResDataStruct respData) {
        respData.resData = null;
        if (this.connection == null) {
            return;
        }
        this.temp = new byte[4096];
        int dataLen = 0;
        int res = 0;
        if (toClose) {
            return;
        }
        this.waitingForBulkTransfer = true;
        res = this.connection.bulkTransfer(epIn, this.temp, 4096, 300);
        this.waitingForBulkTransfer = false;
        if (res > 7) {
            if (this.temp[1] != 2 || this.temp[4] != 6) {
                return;
            }
            int endPos = -1;
            for (int i = this.temp.length - 1; i >= 0; --i) {
                if (this.temp[i] != 3) continue;
                endPos = i;
                break;
            }
            if (endPos > 7) {
                byte[] buffer = new byte[endPos + 1];
                System.arraycopy(this.temp, 0, buffer, 0, endPos + 1);
                dataLen = endPos + 1;
                int countPacket64 = buffer.length / 64;
                if (buffer.length % 64 != 0) {
                    ++countPacket64;
                }
                dataLen = buffer.length - countPacket64;
                respData.resData = new byte[dataLen];
                for (int i = 0; i < countPacket64; ++i) {
                    int startPos = i * 64 + 1;
                    int length = 63;
                    if (i == countPacket64 - 1) {
                        length = buffer.length % 64 - 1;
                    }
                    System.arraycopy(buffer, startPos, respData.resData, i * 63, length);
                }
            } else {
                return;
            }
        }
    }

    private boolean findUsbHidDevice(IPermissionListener listner) {
        if (IDT_Device.getUSBBypass()) {
            this.m_recListener.connectToDevice();
            return true;
        }
        if (this.mManager == null) {
            this.mManager = (UsbManager)this.ctx.getSystemService("usb");
        }
        this.usbDevice = null;
        HashMap deviceList = this.mManager.getDeviceList();
        for (UsbDevice device : deviceList.values()) {
            if (device.getVendorId() != this.VID || device.getProductId() != this.PID) continue;
            if (!this.mManager.hasPermission(device)) {
                listner.onPermissionDenied(device);
            }
            this.usbDevice = device;
            break;
        }
        if (this.usbDevice == null) {
            return false;
        }
        if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && IDT_Device.neoGen == 3 && (this.PID == 18000 || this.PID == 18001 || this.PID == 18176)) {
            for (int i = 0; i < this.usbDevice.getInterfaceCount(); ++i) {
                this.usbInterface = this.usbDevice.getInterface(i);
                if (this.usbInterface.getEndpointCount() < 2) {
                    continue;
                }
                break;
            }
        } else {
            if (this.usbDevice.getInterfaceCount() <= 0) {
                return false;
            }
            UMLog.i("**findUsbHidDevice**", "usbDevice.getInterfaceCount()=" + this.usbDevice.getInterfaceCount());
            this.usbInterface = this.usbDevice.getInterface(this.usbDevice.getInterfaceCount() - 1);
        }
        this.connection = this.mManager.openDevice(this.usbDevice);
        if (this.connection == null) {
            return false;
        }
        this.connection.claimInterface(this.usbInterface, true);
        for (int i = 0; i < this.usbInterface.getEndpointCount(); ++i) {
            if (this.usbInterface.getEndpoint(i).getType() != 3) continue;
            if (this.usbInterface.getEndpoint(i).getDirection() == 128) {
                epIn = this.usbInterface.getEndpoint(i);
                continue;
            }
            if (this.usbInterface.getEndpoint(i).getDirection() != 0) continue;
            epOut = this.usbInterface.getEndpoint(i);
        }
        if (epIn == null) {
            return false;
        }
        toClose = false;
        return true;
    }

    public byte[] PAT_wakeup_sendCommand(byte[] command, int timeout) {
        if (this.connection == null && !IDT_Device.getUSBBypass() || this.waitingForResult) {
            UMLog.i(TAG, "Failed to send a command: ");
            this.waitingForResult = false;
            return null;
        }
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (command != null) {
            this.write(command, command.length);
        }
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return null;
    }

    public byte[] sendCommand(byte[] command, int timeout) {
        long startTime;
        if (this.connection == null && !IDT_Device.getUSBBypass() || this.waitingForResult) {
            UMLog.i(TAG, "Failed to send a command: ");
            this.waitingForResult = false;
            return null;
        }
        try {
            Thread.sleep(preSendDelay);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        byte[] responseData = null;
        byte[] buff = new byte[4096];
        int res = 0;
        if (command != null && Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG && Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG_KB) {
            this.write(command, command.length);
        }
        long endTime = startTime = System.currentTimeMillis();
        if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800) {
            try {
                Thread.sleep(postSendDelay);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            while (endTime - startTime <= (long)(timeout * 1000 + 500) || IDT_Device.infiniteTimeout) {
                if (IDT_Device.getCancelTransaction()) {
                    responseData = null;
                    this.waitingForResult = false;
                    return responseData;
                }
                res = (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI) && IDT_Device.isAutoPollOn ? this.read_KioskIII(buff) : this.read(buff);
                if (res > 0) {
                    if (res > 8) {
                        String AsyncUIMessage = "450055";
                        String MediaEvent = "0750DFEF3604";
                        String strTemp = Common.base16Encode(buff);
                        if (strTemp.startsWith(AsyncUIMessage) || strTemp.startsWith(MediaEvent)) {
                            if (!IDT_Device.readyForCardSwipe) break;
                            endTime = System.currentTimeMillis();
                            res = 0;
                            continue;
                        }
                        if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && res > 20 && buff[10] == 97 && buff[11] == -1) {
                            int dataLen = buff[12] << 8 | buff[13];
                            IDTLCDData lcdData = new IDTLCDData();
                            lcdData.screenID = buff[14] << 8 | buff[15];
                            lcdData.objectID = buff[16] << 8 | buff[17];
                            int chIdx = 18;
                            while (buff[chIdx] != 0) {
                                ++chIdx;
                            }
                            byte[] bytes = new byte[chIdx - 18];
                            System.arraycopy(buff, 18, bytes, 0, bytes.length);
                            lcdData.screenName = new String(bytes);
                            int chIdx2 = ++chIdx;
                            while (buff[chIdx] != 0) {
                                ++chIdx;
                            }
                            bytes = new byte[chIdx - chIdx2];
                            System.arraycopy(buff, chIdx2, bytes, 0, bytes.length);
                            lcdData.objectName = new String(bytes);
                            if (dataLen > 4 + lcdData.screenName.length() + 1 + lcdData.objectName.length() + 1) {
                                lcdData.longPressed = buff[20 + lcdData.screenName.length() + lcdData.objectName.length()];
                            }
                            this._msg.usb_onReceiveMsgLcdData(lcdData);
                            try {
                                Thread.sleep(50L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            endTime = System.currentTimeMillis();
                            res = 0;
                            continue;
                        }
                    }
                    if (res <= 12 || buff[10] == command[11] || command[11] == 97 && command[12] == 1 && (buff[10] == 96 || buff[10] == 2)) break;
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    endTime = System.currentTimeMillis();
                    res = 0;
                    continue;
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                endTime = System.currentTimeMillis();
            }
            if (endTime - startTime > (long)(timeout * 1000 + 500) && !IDT_Device.infiniteTimeout) {
                UMLog.i(TAG, "Command Timeout");
                responseData = null;
                responseData = new byte[]{0};
                return responseData;
            }
        } else {
            if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG_KB) {
                int ret;
                if (this.connection == null) {
                    UMLog.i(TAG, "Failed to send a command: ");
                    return null;
                }
                if (this.commandThread != null && this.commandThread.isAlive()) {
                    UMLog.i(TAG, "Failed to send a command: ");
                    return null;
                }
                this.cmdID = timeout;
                if (command.length <= 8) {
                    ret = this.connection.controlTransfer(33, 9, 768, 0, command, command.length, 0);
                } else {
                    int times = command.length / 8;
                    if (command.length % 8 != 0) {
                        ++times;
                    }
                    for (int i = 0; i < times; ++i) {
                        byte[] temp = new byte[8];
                        int len = i == times - 1 ? command.length - i * 8 : 8;
                        System.arraycopy(command, i * 8, temp, 0, len);
                        ret = this.connection.controlTransfer(33, 9, 768, 0, temp, len, 0);
                    }
                }
                if (this.cmdID == 6) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                } else {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                }
                this.commandThread = new CommandDataReceiver();
                this.waitingForResult = true;
                this.cmdBufferRet = "";
                this.dataCount = 0;
                this.previousCmdBuffer = null;
                this.commandThread.start();
                while (this.waitingForResult) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.secureMagBuf != null && this.secureMagBuf.length > 0) {
                    responseData = new byte[this.secureMagBuf.length];
                    System.arraycopy(this.secureMagBuf, 0, responseData, 0, this.secureMagBuf.length);
                }
                return responseData;
            }
            while (endTime - startTime <= (long)((timeout + 2) * 1000) && (res = this.read(buff)) <= 0) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                endTime = System.currentTimeMillis();
            }
            if (endTime - startTime > (long)((timeout + 2) * 1000) && (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA)) {
                responseData = new byte[]{21, -127, 0};
                return responseData;
            }
        }
        if (res > 0) {
            responseData = null;
            responseData = new byte[res];
            System.arraycopy(buff, 0, responseData, 0, res);
            this.waitingForResult = false;
            UMLog.i("**USB getResponse 3**", Common.base16Encode(responseData));
            this._msg.usb_onReceiveMsgGetResponse(responseData);
            return responseData;
        }
        UMLog.i("**USB getResponse 4**", "NULL");
        this.waitingForResult = false;
        return null;
    }

    public byte[] sendCommandFw(byte[] command, int timeout) {
        long startTime;
        if (this.connection == null && !IDT_Device.getUSBBypass() || this.waitingForResult) {
            UMLog.i(TAG, "Failed to send a command: ");
            this.waitingForResult = false;
            return null;
        }
        try {
            Thread.sleep(preSendDelay);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        byte[] responseData = null;
        byte[] buff = new byte[4096];
        int res = 0;
        if (command != null && Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG && Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG_KB) {
            if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB) {
                UMLog.i("**sendCommandFw**", "write_fw: " + Common.base16Encode(command) + "\n");
                res = this.write_fw(command, command.length);
            } else {
                UMLog.i("**sendCommandFw**", "write: " + Common.base16Encode(command) + "\n");
                res = this.write(command, command.length);
            }
        }
        long endTime = startTime = System.currentTimeMillis();
        if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800) {
            try {
                Thread.sleep(postSendDelay);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            while (endTime - startTime <= (long)(timeout * 1000)) {
                if (IDT_Device.getCancelTransaction()) {
                    responseData = null;
                    this.waitingForResult = false;
                    return responseData;
                }
                res = (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI) && IDT_Device.isAutoPollOn ? this.read_KioskIII(buff) : this.read(buff);
                if (res > 0) {
                    if (Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB) break;
                    if (res > 12 && buff[10] != command[10]) {
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        endTime = System.currentTimeMillis();
                        res = 0;
                        continue;
                    }
                    if (res <= 20 || buff[10] != 97 || buff[11] != -1) break;
                    int dataLen = buff[12] << 8 | buff[13];
                    IDTLCDData lcdData = new IDTLCDData();
                    lcdData.screenID = buff[14] << 8 | buff[15];
                    lcdData.objectID = buff[16] << 8 | buff[17];
                    int chIdx = 18;
                    while (buff[chIdx] != 0) {
                        ++chIdx;
                    }
                    byte[] bytes = new byte[chIdx - 18];
                    System.arraycopy(buff, 18, bytes, 0, bytes.length);
                    lcdData.screenName = new String(bytes);
                    int chIdx2 = ++chIdx;
                    while (buff[chIdx] != 0) {
                        ++chIdx;
                    }
                    bytes = new byte[chIdx - chIdx2];
                    System.arraycopy(buff, chIdx2, bytes, 0, bytes.length);
                    lcdData.objectName = new String(bytes);
                    if (dataLen > 4 + lcdData.screenName.length() + 1 + lcdData.objectName.length() + 1) {
                        lcdData.longPressed = buff[20 + lcdData.screenName.length() + lcdData.objectName.length()];
                    }
                    this._msg.usb_onReceiveMsgLcdData(lcdData);
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    endTime = System.currentTimeMillis();
                    res = 0;
                    continue;
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                endTime = System.currentTimeMillis();
            }
            if (endTime - startTime > (long)(timeout * 1000)) {
                responseData = null;
                responseData = new byte[]{0};
                return responseData;
            }
        } else {
            if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG_KB) {
                int ret;
                if (this.connection == null) {
                    UMLog.i(TAG, "Failed to send a command: ");
                    return null;
                }
                if (this.commandThread != null && this.commandThread.isAlive()) {
                    UMLog.i(TAG, "Failed to send a command: ");
                    return null;
                }
                this.cmdID = timeout;
                if (command.length <= 8) {
                    ret = this.connection.controlTransfer(33, 9, 768, 0, command, command.length, 0);
                } else {
                    int times = command.length / 8;
                    if (command.length % 8 != 0) {
                        ++times;
                    }
                    for (int i = 0; i < times; ++i) {
                        byte[] temp = new byte[8];
                        int len = i == times - 1 ? command.length - i * 8 : 8;
                        System.arraycopy(command, i * 8, temp, 0, len);
                        ret = this.connection.controlTransfer(33, 9, 768, 0, temp, len, 0);
                    }
                }
                if (this.cmdID == 6) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                } else {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                }
                this.commandThread = new CommandDataReceiver();
                this.waitingForResult = true;
                this.cmdBufferRet = "";
                this.dataCount = 0;
                this.previousCmdBuffer = null;
                this.commandThread.start();
                while (this.waitingForResult) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.secureMagBuf != null && this.secureMagBuf.length > 0) {
                    responseData = new byte[this.secureMagBuf.length];
                    System.arraycopy(this.secureMagBuf, 0, responseData, 0, this.secureMagBuf.length);
                }
                return responseData;
            }
            while (endTime - startTime <= (long)(timeout * 1000) && (res = this.read(buff)) <= 0) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                endTime = System.currentTimeMillis();
            }
            if (endTime - startTime > (long)(timeout * 1000) && (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA)) {
                responseData = new byte[]{21, -127, 0};
                return responseData;
            }
        }
        if (res > 0) {
            responseData = null;
            responseData = new byte[res];
            System.arraycopy(buff, 0, responseData, 0, res);
            this.waitingForResult = false;
            UMLog.i("**USB getResponse 5**", Common.base16Encode(responseData));
            this._msg.usb_onReceiveMsgGetResponse(responseData);
            return responseData;
        }
        UMLog.i("**USB getResponse 6**", "NULL");
        this.waitingForResult = false;
        return null;
    }

    public byte[] sendCommandOnly(byte[] command, int timeout) {
        if (this.connection == null && !IDT_Device.getUSBBypass() || this.waitingForResult) {
            UMLog.i(TAG, "Failed to send a command: ");
            this.waitingForResult = false;
            return null;
        }
        try {
            Thread.sleep(preSendDelay);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (command != null) {
            this.write(command, command.length);
        }
        this.waitingForResult = false;
        return null;
    }

    public byte[] sendCommandForRKI(byte[] command, int timeout) {
        long startTime;
        if (this.connection == null && !IDT_Device.getUSBBypass() || this.waitingForResult) {
            UMLog.i(TAG, "Failed to send a command: ");
            this.waitingForResult = false;
            return null;
        }
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        byte[] responseData = null;
        byte[] buff = new byte[1024];
        int res = 0;
        if (command != null) {
            this.write(command, command.length);
        }
        long endTime = startTime = System.currentTimeMillis();
        while (endTime - startTime <= (long)(timeout * 1000)) {
            res = this.readForRKI(buff);
            if (res > 0) {
                if (Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || res <= 20 || buff[10] != 97 || buff[11] != -1) break;
                int dataLen = buff[12] << 8 | buff[13];
                IDTLCDData lcdData = new IDTLCDData();
                lcdData.screenID = buff[14] << 8 | buff[15];
                lcdData.objectID = buff[16] << 8 | buff[17];
                int chIdx = 18;
                while (buff[chIdx] != 0) {
                    ++chIdx;
                }
                byte[] bytes = new byte[chIdx - 18];
                System.arraycopy(buff, 18, bytes, 0, bytes.length);
                lcdData.screenName = new String(bytes);
                int chIdx2 = ++chIdx;
                while (buff[chIdx] != 0) {
                    ++chIdx;
                }
                bytes = new byte[chIdx - chIdx2];
                System.arraycopy(buff, chIdx2, bytes, 0, bytes.length);
                lcdData.objectName = new String(bytes);
                if (dataLen > 4 + lcdData.screenName.length() + 1 + lcdData.objectName.length() + 1) {
                    lcdData.longPressed = buff[20 + lcdData.screenName.length() + lcdData.objectName.length()];
                }
                this._msg.usb_onReceiveMsgLcdData(lcdData);
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            endTime = System.currentTimeMillis();
        }
        if (endTime - startTime > (long)(timeout * 1000) && (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA)) {
            responseData = new byte[]{21, -127, 0};
            return responseData;
        }
        if (res > 0) {
            responseData = null;
            responseData = new byte[res];
            System.arraycopy(buff, 0, responseData, 0, res);
            this.waitingForResult = false;
            UMLog.i("**USB getResponse 7**", Common.base16Encode(responseData));
            this._msg.usb_onReceiveMsgGetResponse(responseData);
            return responseData;
        }
        this.waitingForResult = false;
        return null;
    }

    public byte[] sendCommandFw(byte[] command) {
        if (this.connection == null && !IDT_Device.getUSBBypass() || this.waitingForResult) {
            UMLog.i(TAG, "Failed to send a command: ");
            this.waitingForResult = false;
            return null;
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        byte[] responseData = null;
        byte[] buff = new byte[4096];
        int res = 0;
        this.write(command, command.length);
        for (int i = 0; i < 5 && (res = this.read(buff)) <= 0; ++i) {
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (res > 0) {
            responseData = null;
            responseData = new byte[res];
            System.arraycopy(buff, 0, responseData, 0, res);
            this.waitingForResult = false;
            return responseData;
        }
        this.waitingForResult = false;
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int read(byte[] data) {
        if (IDT_Device.getUSBBypass()) {
            return IDT_Device.rVD(data);
        }
        if (this.connection == null) {
            return 0;
        }
        int i = 0;
        int j = 0;
        int totalLen = 0;
        int dataLen = 0;
        int res = 0;
        Arrays.fill(this.temp, (byte)0);
        byte[] tmp = new byte[64];
        int count = 0;
        int frameCount = 0;
        if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800) {
            while (res != -1) {
                if (toClose) {
                    return 0;
                }
                this.waitingForBulkTransfer = true;
                res = this.connection.bulkTransfer(epIn, tmp, 64, 300);
                this.waitingForBulkTransfer = false;
                if (res != 64) continue;
                if (count > 4096) break;
                try {
                    System.arraycopy(tmp, 0, this.temp, count, 64);
                }
                catch (ArrayIndexOutOfBoundsException exception) {
                    return 0;
                }
                if (count == 0) {
                    dataLen = (this.temp[13] & 0xFF) << 8 | this.temp[14] & 0xFF;
                }
                if (dataLen + 16 + ++frameCount > (count += 64)) continue;
            }
            if (count > 4 && this.temp[0] == 1 && this.temp[1] == 2 && this.temp[2] == 2 && this.temp[3] == 91 && this.temp[4] == 47) {
                IDTMSRData card = new IDTMSRData();
                card.result = 61093;
                this._msg.usb_onReceiveMsgCardData(card);
                return 0;
            }
            if (count > 4 && this.temp[0] == 1 && this.temp[1] == 2 && this.temp[2] == 3 && this.temp[3] == 75 && this.temp[4] == 14) {
                IDTMSRData card = new IDTMSRData();
                card.result = 61094;
                this._msg.usb_onReceiveMsgCardData(card);
                return 0;
            }
            if (Common.isP2()) {
                dataLen = (this.temp[13] & 0xFF) << 8 | this.temp[14] & 0xFF;
                if (frameCount > 0) {
                    totalLen = 14 + dataLen + 2;
                }
                if (frameCount < 1) return totalLen;
                int k = 0;
                while (k < frameCount) {
                    if (frameCount == 1) {
                        boolean allZeros = true;
                        for (int l = 0; l < 64; ++l) {
                            if (this.temp[l] == 0) continue;
                            allZeros = false;
                        }
                        if (allZeros) {
                            return 0;
                        }
                    }
                    if (k == frameCount - 1) {
                        if (totalLen > 4096) {
                            return 0;
                        }
                        try {
                            System.arraycopy(this.temp, 1 + 64 * k, data, k * 63, totalLen - k * 63);
                        }
                        catch (ArrayIndexOutOfBoundsException exception) {
                            return 0;
                        }
                    }
                    try {
                        System.arraycopy(this.temp, 1 + 64 * k, data, k * 63, 63);
                    }
                    catch (ArrayIndexOutOfBoundsException exception) {
                        return 0;
                    }
                    ++k;
                }
                return totalLen;
            }
            if (frameCount == 1) {
                totalLen = 16;
                try {
                    System.arraycopy(this.temp, 1, data, 0, 16);
                    return totalLen;
                }
                catch (ArrayIndexOutOfBoundsException exception) {
                    return 0;
                }
            }
            if (frameCount <= true) return totalLen;
            dataLen = (this.temp[13] & 0xFF) << 8 | this.temp[14] & 0xFF;
            totalLen = 16 + dataLen;
            try {
                System.arraycopy(this.temp, 1, data, 0, 14);
            }
            catch (ArrayIndexOutOfBoundsException exception) {
                return 0;
            }
            int remainingDataLen = dataLen + 2;
            int index = 14;
            if (this.temp[74] != 68) return totalLen;
            if (remainingDataLen <= 53) {
                try {
                    System.arraycopy(this.temp, 75, data, index, remainingDataLen);
                    return totalLen;
                }
                catch (ArrayIndexOutOfBoundsException exception) {
                    return 0;
                }
            }
            try {
                System.arraycopy(this.temp, 75, data, index, 53);
            }
            catch (ArrayIndexOutOfBoundsException exception) {
                return 0;
            }
            remainingDataLen -= 53;
            index += 53;
            int k = 2;
            while (k < frameCount) {
                if (63 - remainingDataLen >= 0) {
                    try {
                        System.arraycopy(this.temp, 1 + 64 * k, data, index, remainingDataLen);
                        return totalLen;
                    }
                    catch (ArrayIndexOutOfBoundsException exception) {
                        return 0;
                    }
                }
                try {
                    System.arraycopy(this.temp, 1 + 64 * k, data, index, 63);
                }
                catch (ArrayIndexOutOfBoundsException exception) {
                    return 0;
                }
                remainingDataLen -= 63;
                index += 63;
                ++k;
            }
            return totalLen;
        }
        if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II) {
            while (res != -1) {
                Arrays.fill(tmp, (byte)0);
                if (toClose) {
                    return 0;
                }
                this.waitingForBulkTransfer = true;
                res = this.connection.bulkTransfer(epIn, tmp, 64, 1000);
                this.waitingForBulkTransfer = false;
                UMLog.i("**USB READ**", "Read res=" + res);
                if (res != 64) continue;
                try {
                    System.arraycopy(tmp, 0, this.temp, count, 64);
                }
                catch (ArrayIndexOutOfBoundsException exception) {
                    return 0;
                }
                if (count == 0 && this.temp[1] == 2) {
                    dataLen = (this.temp[2] & 0xFF) + (this.temp[3] & 0xFF) * 256;
                }
                if (dataLen + 6 + ++frameCount > (count += 64)) continue;
            }
            if (count <= 0) return 0;
            if (this.temp[1] == 2) {
                totalLen = this.temp[0] & 0xFF;
                dataLen = (this.temp[2] & 0xFF) + (this.temp[3] & 0xFF) * 256;
                if (totalLen == dataLen + 6 && totalLen < 64) {
                    i = 0;
                    while (i < totalLen + 1) {
                        data[i] = this.temp[i + 1];
                        ++i;
                    }
                    return totalLen;
                }
                if (totalLen != 191) return 0;
                j = 0;
                i = 0;
                while (i + j < 1024) {
                    if ((i + j) % 64 == 0) {
                        ++j;
                    }
                    data[i] = this.temp[i + j];
                    ++i;
                }
                return dataLen + 6;
            }
            count = 0;
            while (this.temp[count] == -65) {
                try {
                    System.arraycopy(this.temp, count + 1, data, totalLen, 63);
                }
                catch (ArrayIndexOutOfBoundsException exception) {
                    return 0;
                }
                totalLen += 63;
                count += 64;
            }
            try {
                System.arraycopy(this.temp, count + 1, data, totalLen, this.temp[count]);
                return totalLen += this.temp[count];
            }
            catch (ArrayIndexOutOfBoundsException exception) {
                return 0;
            }
        }
        if (toClose) {
            return 0;
        }
        this.waitingForBulkTransfer = true;
        res = this.connection.bulkTransfer(epIn, this.temp, 1024, 2300);
        this.waitingForBulkTransfer = false;
        if (res <= 0) return 0;
        if (this.temp[1] != 2) return 0;
        totalLen = this.temp[0] & 0xFF;
        dataLen = (this.temp[2] & 0xFF) + (this.temp[3] & 0xFF) * 256;
        if (totalLen == dataLen + 6 && totalLen < 64) {
            i = 0;
            while (i < totalLen + 1) {
                data[i] = this.temp[i + 1];
                ++i;
            }
            return totalLen;
        }
        if (totalLen != 191) return 0;
        j = 0;
        i = 0;
        while (i + j < 1024) {
            if ((i + j) % 64 == 0) {
                ++j;
            }
            data[i] = this.temp[i + j];
            ++i;
        }
        return dataLen + 6;
    }

    private int read_KioskIII(byte[] data) {
        if (IDT_Device.getUSBBypass()) {
            return IDT_Device.rVD(data);
        }
        if (this.connection == null) {
            return 0;
        }
        int res = 0;
        Arrays.fill(this.temp, (byte)0);
        byte[] tmp = new byte[64];
        int count = 0;
        while (res != -1) {
            if (toClose) {
                return 0;
            }
            if (IDT_Device.isVP6300 && IDT_Device.isThreadReading && IDT_Device.isCommandRunning) {
                return 0;
            }
            this.waitingForBulkTransfer = true;
            res = this.connection.bulkTransfer(epIn, tmp, 64, 5);
            this.waitingForBulkTransfer = false;
            if (IDT_Device.isVP6300 && IDT_Device.isThreadReading && IDT_Device.isCommandRunning) {
                return 0;
            }
            if (res == 64) {
                System.arraycopy(tmp, 1, data, count, 63);
                count += 63;
                continue;
            }
            if (res == -1) break;
            if (res == 0 || res <= 0) continue;
            System.arraycopy(tmp, 1, data, count, res);
            count += res - 1;
        }
        while (count - 1 >= 0 && data[count - 1] == 0) {
            --count;
        }
        if (count > 3 && data[0] == 2 && data[1] == 2 && data[2] == 91 && data[3] == 47) {
            IDTMSRData card = new IDTMSRData();
            card.result = 61093;
            this._msg.usb_onReceiveMsgCardData(card);
            count = 0;
        } else if (count > 3 && data[0] == 2 && data[1] == 3 && data[2] == 75 && data[3] == 14) {
            IDTMSRData card = new IDTMSRData();
            card.result = 61094;
            this._msg.usb_onReceiveMsgCardData(card);
            count = 0;
        }
        return count;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int readForRKI(byte[] data) {
        if (IDT_Device.getUSBBypass()) {
            return IDT_Device.rVD(data);
        }
        if (this.connection == null) {
            return 0;
        }
        int i = 0;
        int j = 0;
        int totalLen = 0;
        int dataLen = 0;
        int res = 0;
        Arrays.fill(this.temp, (byte)0);
        byte[] tmp = new byte[64];
        int count = 0;
        if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800) {
            while (res != -1) {
                if (toClose) {
                    return 0;
                }
                this.waitingForBulkTransfer = true;
                res = this.connection.bulkTransfer(epIn, tmp, 64, 300);
                this.waitingForBulkTransfer = false;
                if (tmp == null || tmp[1] != 2) continue;
            }
            dataLen = (tmp[2] & 0xFF) + (tmp[3] & 0xFF) * 256;
            totalLen = dataLen + 6;
            for (i = 0; i < totalLen; ++i) {
                data[i] = tmp[i + 1];
            }
            return totalLen;
        }
        if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II) {
            while (res != -1) {
                if (toClose) {
                    return 0;
                }
                this.waitingForBulkTransfer = true;
                res = this.connection.bulkTransfer(epIn, tmp, 64, 300);
                this.waitingForBulkTransfer = false;
                if (res == 64) {
                    System.arraycopy(tmp, 0, this.temp, count, 64);
                    count += 64;
                    continue;
                }
                if (res != 0 || count <= 0) continue;
            }
            if (count <= 0) return 0;
            if (this.temp[1] == 2) {
                totalLen = this.temp[0] & 0xFF;
                dataLen = (this.temp[2] & 0xFF) + (this.temp[3] & 0xFF) * 256;
                if (totalLen == dataLen + 6 && totalLen < 64) {
                    for (i = 0; i < totalLen + 1; ++i) {
                        data[i] = this.temp[i + 1];
                    }
                    return totalLen;
                }
                if (totalLen != 191) return 0;
                j = 0;
                i = 0;
                while (i + j < 1024) {
                    if ((i + j) % 64 == 0) {
                        ++j;
                    }
                    data[i] = this.temp[i + j];
                    ++i;
                }
                return dataLen + 6;
            }
            count = 0;
            while (this.temp[count] == -65) {
                System.arraycopy(this.temp, count + 1, data, totalLen, 63);
                totalLen += 63;
                count += 64;
            }
            System.arraycopy(this.temp, count + 1, data, totalLen, this.temp[count]);
            return totalLen += this.temp[count];
        }
        if (toClose) {
            return 0;
        }
        this.waitingForBulkTransfer = true;
        res = this.connection.bulkTransfer(epIn, this.temp, 1024, 300);
        this.waitingForBulkTransfer = false;
        if (res <= 0 || this.temp[1] != 2) return 0;
        totalLen = this.temp[0] & 0xFF;
        dataLen = (this.temp[2] & 0xFF) + (this.temp[3] & 0xFF) * 256;
        if (totalLen == dataLen + 6 && totalLen < 64) {
            for (i = 0; i < totalLen + 1; ++i) {
                data[i] = this.temp[i + 1];
            }
            return totalLen;
        }
        if (totalLen != 191) return 0;
        j = 0;
        i = 0;
        while (i + j < 1024) {
            if ((i + j) % 64 == 0) {
                ++j;
            }
            data[i] = this.temp[i + j];
            ++i;
        }
        return dataLen + 6;
    }

    private int _readMessage(byte[] data) {
        if (IDT_Device.getUSBBypass()) {
            return IDT_Device.rVD(data);
        }
        if (this.connection == null) {
            return 0;
        }
        int dataLen = 0;
        int res = 1;
        byte[] tmp = new byte[64];
        int index = 0;
        if (toClose) {
            return 0;
        }
        this.waitingForBulkTransfer = true;
        res = this.connection.bulkTransfer(epIn, tmp, 64, 300);
        this.waitingForBulkTransfer = false;
        if (res > 0) {
            if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800) {
                if (res > 4 && tmp[0] == 1 && tmp[1] == 2 && tmp[2] == 2 && tmp[3] == 91 && tmp[4] == 47) {
                    IDTMSRData card = new IDTMSRData();
                    card.result = 61093;
                    this._msg.usb_onReceiveMsgCardData(card);
                    return 0;
                }
                if (res > 4 && tmp[0] == 1 && tmp[1] == 2 && tmp[2] == 3 && tmp[3] == 75 && tmp[4] == 14) {
                    IDTMSRData card = new IDTMSRData();
                    card.result = 61094;
                    this._msg.usb_onReceiveMsgCardData(card);
                    return 0;
                }
                dataLen = (tmp[13] & 0xFF) << 8 | tmp[14] & 0xFF;
                if ((dataLen += 16) <= 63) {
                    try {
                        System.arraycopy(tmp, 1, data, index, dataLen);
                    }
                    catch (ArrayIndexOutOfBoundsException exception) {
                        return 0;
                    }
                }
                try {
                    System.arraycopy(tmp, 1, data, index, 63);
                }
                catch (ArrayIndexOutOfBoundsException exception) {
                    return 0;
                }
                index = 63;
                while (dataLen - index > 63) {
                    if (toClose) {
                        return 0;
                    }
                    this.waitingForBulkTransfer = true;
                    res = this.connection.bulkTransfer(epIn, tmp, 64, 300);
                    this.waitingForBulkTransfer = false;
                    if (index + 63 > data.length) {
                        return 0;
                    }
                    try {
                        System.arraycopy(tmp, 1, data, index, 63);
                    }
                    catch (ArrayIndexOutOfBoundsException exception) {
                        return 0;
                    }
                    index += 63;
                }
                if (toClose) {
                    return 0;
                }
                this.waitingForBulkTransfer = true;
                res = this.connection.bulkTransfer(epIn, tmp, 64, 300);
                this.waitingForBulkTransfer = false;
                if (dataLen > data.length) {
                    return 0;
                }
                try {
                    System.arraycopy(tmp, 1, data, index, dataLen - index);
                }
                catch (ArrayIndexOutOfBoundsException exception) {
                    return 0;
                }
            }
            dataLen = (tmp[2] & 0xFF | (tmp[3] & 0xFF) << 8) + 6;
            if (tmp[0] == -65) {
                try {
                    System.arraycopy(tmp, 1, data, index, 63);
                }
                catch (ArrayIndexOutOfBoundsException exception) {
                    return 0;
                }
                index += 63;
            } else {
                if (index + dataLen > data.length) {
                    return 0;
                }
                try {
                    System.arraycopy(tmp, 1, data, index, dataLen);
                }
                catch (ArrayIndexOutOfBoundsException exception) {
                    return 0;
                }
                index += dataLen;
            }
            while (index < dataLen) {
                if (toClose) {
                    return 0;
                }
                this.waitingForBulkTransfer = true;
                res = this.connection.bulkTransfer(epIn, tmp, 64, 300);
                this.waitingForBulkTransfer = false;
                if (tmp[0] == -65) {
                    if (index + 63 > data.length) {
                        return 0;
                    }
                    try {
                        System.arraycopy(tmp, 1, data, index, 63);
                    }
                    catch (ArrayIndexOutOfBoundsException exception) {
                        return 0;
                    }
                    index += 63;
                    continue;
                }
                if (dataLen > data.length) {
                    return 0;
                }
                try {
                    System.arraycopy(tmp, 1, data, index, dataLen - index);
                }
                catch (ArrayIndexOutOfBoundsException exception) {
                    return 0;
                }
                index = dataLen;
            }
        }
        return dataLen;
    }

    private UsbDeviceConnection getConnection() {
        return this.connection;
    }

    private UsbEndpoint getEndpoint() {
        return epIn;
    }

    private byte[] trimCommandResponse(byte[] data) {
        int pos;
        if (data[0] != 6 && data[0] != 21) {
            return null;
        }
        if (data.length > 1 && (data[0] == 6 || data[0] == 21) && data[1] != 2) {
            byte[] ret = new byte[]{data[0]};
            return ret;
        }
        for (pos = data.length - 1; pos >= 0 && data[pos] == 0; --pos) {
        }
        byte[] ret = new byte[pos + 1];
        System.arraycopy(data, 0, ret, 0, pos + 1);
        while (pos >= 0 && data[pos] != 3) {
            --pos;
        }
        if (data[pos - 1] == 3) {
            --pos;
        }
        if ((ret[0] == 6 || ret[0] == 21) && ret[1] == 2 && pos > 2) {
            byte[] temp = new byte[pos];
            System.arraycopy(ret, 1, temp, 0, pos);
            byte LRC = Common.getLRC(temp);
            if (LRC == ret[pos + 1]) {
                temp = new byte[pos + 2];
                System.arraycopy(ret, 0, temp, 0, pos + 2);
                return temp;
            }
        }
        return ret;
    }

    private boolean isDataRepeated() {
        if (this.previousCmdBuffer == null) {
            this.previousCmdBuffer = new byte[8];
            System.arraycopy(this.cmdBuffer, 0, this.previousCmdBuffer, 0, 8);
            return false;
        }
        for (int i = 0; i < 8; ++i) {
            if (this.previousCmdBuffer[i] == this.cmdBuffer[i]) continue;
            System.arraycopy(this.cmdBuffer, 0, this.previousCmdBuffer, 0, 8);
            return false;
        }
        return true;
    }

    private int readCommandBuffer() {
        if (this.connection == null) {
            return 0;
        }
        return this.connection.controlTransfer(161, 1, 768, 0, this.cmdBuffer, 8, 0);
    }

    private int readBuffer(byte[] buffer) throws Exception {
        if (this.connection != null) {
            return this.connection.bulkTransfer(epIn, buffer, buffer.length, 300);
        }
        return 0;
    }

    private int readMSR(byte[] data) {
        if (IDT_Device.getUSBBypass()) {
            return IDT_Device.rVD(data);
        }
        if (this.connection == null) {
            return 0;
        }
        this.temp = new byte[4096];
        int i = 0;
        int j = 0;
        int totalLen = 0;
        int dataLen = 0;
        int res = 0;
        if (toClose) {
            return 0;
        }
        this.waitingForBulkTransfer = true;
        res = this.connection.bulkTransfer(epIn, this.temp, 4096, 300);
        this.waitingForBulkTransfer = false;
        if (res > 0) {
            if (this.temp[1] == 2 && (totalLen = this.temp[0] & 0xFF) == (dataLen = (this.temp[2] & 0xFF) + (this.temp[3] & 0xFF) * 256) + 6 && totalLen < 64) {
                for (i = 0; i < totalLen + 1; ++i) {
                    data[i] = this.temp[i + 1];
                }
                return totalLen;
            }
            totalLen = this.temp[0] & 0xFF;
            dataLen = (this.temp[3] & 0xFF) + (this.temp[4] & 0xFF) * 256;
            if (totalLen < 64) {
                for (i = 0; i < totalLen + 1; ++i) {
                    data[i] = this.temp[i + 1];
                }
                return totalLen;
            }
            if (totalLen == 191) {
                dataLen = 0;
                j = 0;
                i = 0;
                while (i + j < 4096) {
                    if ((i + j) % 64 == 0) {
                        totalLen = this.temp[i + j] & 0xFF;
                        if (totalLen == 191) {
                            dataLen += 63;
                        } else {
                            if (totalLen < 64 && totalLen > 0) {
                                dataLen += totalLen;
                                ++j;
                                for (int k = 0; k < totalLen; ++k) {
                                    data[i + k] = this.temp[i + j + k];
                                }
                                return dataLen;
                            }
                            if (totalLen == 0) break;
                        }
                        ++j;
                    }
                    data[i] = this.temp[i + j];
                    ++i;
                }
                return dataLen;
            }
        }
        return 0;
    }

    private boolean close() {
        if (IDT_Device.getUSBBypass()) {
            return true;
        }
        toClose = true;
        do {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } while (this.waitingForBulkTransfer);
        if (epIn != null) {
            epIn = null;
        }
        if (this.connection != null) {
            int i = 0;
            boolean res = false;
            for (i = 0; i < 3; ++i) {
                UMLog.i("close", "connection: " + this.connection + " usbInterface: " + this.usbInterface + " index: " + i);
                if (this.connection == null) continue;
                res = this.connection.releaseInterface(this.usbInterface);
                if (res) break;
                try {
                    Thread.sleep(500L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (i >= 3) {
                if (this.connection == null) {
                    UMLog.i(TAG, "Could not close the USB connection ");
                } else {
                    UMLog.i(TAG, "Could not close the USB connection " + this.connection.getSerial());
                }
                return false;
            }
            if (this.connection != null) {
                this.connection.close();
            }
            this.usbInterface = null;
            this.connection = null;
        }
        System.gc();
        return true;
    }

    public int writeNothing() {
        if (this.connection == null) {
            return 0;
        }
        int res = 0;
        int iii = 0;
        do {
            ++iii;
            if (toClose) {
                return 0;
            }
            this.waitingForBulkTransfer = true;
            if (IDT_Device.getUSBBypass()) {
                this.m_recListener.usbBypassData(null);
                res = 0;
            } else {
                res = this.connection.bulkTransfer(epOut, null, 0, 2300);
            }
            this.waitingForBulkTransfer = false;
            UMLog.i("**USB bulkTransfer**", "write res=" + res);
        } while (res != 0 && iii < 10);
        return res;
    }

    private int write(byte[] command, int length) {
        if (IDT_Device.getUSBBypass()) {
            byte[] temp = null;
            if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB) {
                temp = new byte[length - 1];
                System.arraycopy(command, 1, temp, 0, temp.length);
            } else {
                temp = new byte[length];
                System.arraycopy(command, 0, temp, 0, temp.length);
            }
            this.m_recListener.usbBypassData(temp);
            return temp.length;
        }
        if (length <= 0) {
            return 0;
        }
        if (this.connection == null) {
            return 0;
        }
        if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800) {
            return this.write_VP8800(command, length);
        }
        int res = 0;
        if (length >= 64) {
            int len = (length - 1) / 63 + 1 + length;
            byte[] com = new byte[len];
            int j = 0;
            for (int i = 0; i < len; ++i) {
                if (i % 64 == 0) {
                    ++j;
                    if (len - i > 64) {
                        com[i] = -65;
                        continue;
                    }
                    if (len - i < 64) {
                        com[i] = (byte)(length % 63);
                        continue;
                    }
                    com[i] = 63;
                    continue;
                }
                com[i] = command[i - j];
            }
            int iii = 0;
            while (iii * 64 < len) {
                byte[] temp = new byte[64];
                if ((iii + 1) * 64 > len) {
                    System.arraycopy(com, 64 * iii, temp, 0, len - iii * 64);
                } else {
                    System.arraycopy(com, 64 * iii, temp, 0, 64);
                }
                if (toClose) {
                    return 0;
                }
                this.waitingForBulkTransfer = true;
                res = this.connection.bulkTransfer(epOut, temp, 64, 2300);
                this.waitingForBulkTransfer = false;
                UMLog.i("**USB bulkTransfer 1**", "write res=" + res);
                ++iii;
            }
        } else if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800) {
            byte[] com = new byte[64];
            com[0] = (byte)length;
            System.arraycopy(command, 0, com, 1, length);
            for (int i = length + 1; i < 64; ++i) {
                com[i] = 0;
            }
            int iii = 0;
            do {
                ++iii;
                if (toClose) {
                    return 0;
                }
                this.waitingForBulkTransfer = true;
                res = this.connection.bulkTransfer(epOut, com, 64, 2300);
                this.waitingForBulkTransfer = false;
                UMLog.i("**USB bulkTransfer 2**", "write res=" + res);
            } while (res <= 0 && iii < 10);
        } else {
            byte[] com = new byte[length + 1];
            com[0] = (byte)length;
            System.arraycopy(command, 0, com, 1, length);
            if (toClose) {
                return 0;
            }
            this.waitingForBulkTransfer = true;
            res = this.connection.bulkTransfer(epOut, com, length + 1, 2300);
            this.waitingForBulkTransfer = false;
            UMLog.i("**USB bulkTransfer 3**", "write res=" + res);
        }
        UMLog.i("**USB SEND**", "write res=" + res);
        return res;
    }

    private int write_fw(byte[] command, int length) {
        if (IDT_Device.getUSBBypass()) {
            byte[] temp = null;
            if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB) {
                temp = new byte[length - 1];
                System.arraycopy(command, 1, temp, 0, temp.length);
            } else {
                temp = new byte[length];
                System.arraycopy(command, 0, temp, 0, temp.length);
            }
            this.m_recListener.usbBypassData(temp);
            return temp.length;
        }
        if (length <= 0) {
            return 0;
        }
        if (this.connection == null) {
            return 0;
        }
        if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800) {
            return this.write_VP8800(command, length);
        }
        int res = 0;
        if (length >= 64) {
            if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800) {
                int len = (length - 1) / 63 + 1 + (length - 1);
                byte[] com = new byte[len];
                int times = len / 64 + 1;
                for (int i = 0; i < times; ++i) {
                    if (i == times - 1) {
                        com[i * 64] = 4;
                        System.arraycopy(command, 63 * i + 1, com, 64 * i + 1, length - 1 - i * 63);
                        continue;
                    }
                    if (i == 0) {
                        com[0] = 2;
                        System.arraycopy(command, 1, com, 1, 63);
                        continue;
                    }
                    com[i * 64] = 3;
                    System.arraycopy(command, 63 * i + 1, com, 64 * i + 1, 63);
                }
                int iii = 0;
                while (iii * 64 < len) {
                    byte[] temp = new byte[64];
                    if ((iii + 1) * 64 > len) {
                        System.arraycopy(com, 64 * iii, temp, 0, len - iii * 64);
                    } else {
                        System.arraycopy(com, 64 * iii, temp, 0, 64);
                    }
                    if (toClose) {
                        return 0;
                    }
                    this.waitingForBulkTransfer = true;
                    res = this.connection.bulkTransfer(epOut, temp, 64, 2300);
                    this.waitingForBulkTransfer = false;
                    UMLog.i("**USB bulkTransfer 1**", "write res=" + res);
                    ++iii;
                }
            } else if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB) {
                int times = length / 63;
                if (length % 63 != 0) {
                    ++times;
                }
                for (int i = 0; i < times; ++i) {
                    byte[] temp = new byte[64];
                    if (i == times - 1) {
                        temp[0] = 4;
                        System.arraycopy(command, 63 * i, temp, 1, length % 63 == 0 ? 63 : length % 63);
                    } else if (i == 0) {
                        temp[0] = 2;
                        System.arraycopy(command, 0, temp, 1, 63);
                    } else {
                        temp[0] = 3;
                        System.arraycopy(command, 63 * i, temp, 1, 63);
                    }
                    UMLog.i("**USB bulkTransfer 1**", "toClose=" + toClose);
                    if (toClose) {
                        return 0;
                    }
                    UMLog.i("**USB bulkTransfer 1**", "epOut Address=" + epOut.getAddress());
                    this.waitingForBulkTransfer = true;
                    res = this.connection.bulkTransfer(epOut, temp, 64, 2300);
                    this.waitingForBulkTransfer = false;
                    UMLog.i("**USB bulkTransfer 1**", "write res=" + res);
                }
            } else {
                int len = (length - 1) / 63 + 1 + length;
                byte[] com = new byte[len];
                int j = 0;
                for (int i = 0; i < len; ++i) {
                    if (i % 64 == 0) {
                        ++j;
                        if (len - i > 64) {
                            com[i] = -65;
                            continue;
                        }
                        if (len - i < 64) {
                            com[i] = (byte)(length % 63);
                            continue;
                        }
                        com[i] = 63;
                        continue;
                    }
                    com[i] = command[i - j];
                }
                int iii = 0;
                while (iii * 64 < len) {
                    byte[] temp = new byte[64];
                    if ((iii + 1) * 64 > len) {
                        System.arraycopy(com, 64 * iii, temp, 0, len - iii * 64);
                    } else {
                        System.arraycopy(com, 64 * iii, temp, 0, 64);
                    }
                    if (toClose) {
                        return 0;
                    }
                    this.waitingForBulkTransfer = true;
                    res = this.connection.bulkTransfer(epOut, temp, 64, 2300);
                    this.waitingForBulkTransfer = false;
                    UMLog.i("**USB bulkTransfer 1**", "write res=" + res);
                    ++iii;
                }
                do {
                    res = this.connection.bulkTransfer(epOut, com, 64, 2300);
                    UMLog.i("**USB bulkTransfer 1**", "write res=" + res);
                } while (res <= 0 && ++iii < 10);
            }
        } else if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800) {
            byte[] com = new byte[64];
            com[0] = 1;
            System.arraycopy(command, 0, com, 1, length);
            for (int i = length + 1; i < 64; ++i) {
                com[i] = 0;
            }
            int iii = 0;
            do {
                ++iii;
                if (toClose) {
                    return 0;
                }
                this.waitingForBulkTransfer = true;
                res = this.connection.bulkTransfer(epOut, com, 64, 2300);
                this.waitingForBulkTransfer = false;
                UMLog.i("**USB bulkTransfer 2**", "write res=" + res);
            } while (res <= 0 && iii < 10);
        } else if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II) {
            byte[] com = new byte[64];
            com[0] = (byte)length;
            System.arraycopy(command, 0, com, 1, length);
            for (int i = length + 1; i < 64; ++i) {
                com[i] = 0;
            }
            int iii = 0;
            do {
                ++iii;
                if (toClose) {
                    return 0;
                }
                this.waitingForBulkTransfer = true;
                res = this.connection.bulkTransfer(epOut, com, 64, 2300);
                this.waitingForBulkTransfer = false;
                UMLog.i("**USB bulkTransfer 2**", "write res=" + res);
            } while (res <= 0 && iii < 10);
        } else {
            byte[] com = new byte[length + 1];
            com[0] = (byte)length;
            System.arraycopy(command, 0, com, 1, length);
            if (toClose) {
                return 0;
            }
            this.waitingForBulkTransfer = true;
            res = this.connection.bulkTransfer(epOut, com, length + 1, 2300);
            this.waitingForBulkTransfer = false;
            UMLog.i("**USB bulkTransfer 3**", "write res=" + res);
        }
        return res;
    }

    private int write_VP8800(byte[] command, int length) {
        int res = 0;
        byte[] com = new byte[64];
        int index = 0;
        if (length > 63) {
            int count = length / 63;
            if (length % 63 != 0) {
                ++count;
            }
            for (int j = 0; j < count; ++j) {
                for (int i = 1; i < 64; ++i) {
                    com[i] = 0;
                }
                com[0] = j == 0 ? 2 : (j == count - 1 ? 4 : 3);
                System.arraycopy(command, index, com, 1, length - index > 63 ? 63 : length - index);
                index += 63;
                if (toClose) {
                    return 0;
                }
                this.waitingForBulkTransfer = true;
                res = this.connection.bulkTransfer(epOut, com, 64, 2300);
                this.waitingForBulkTransfer = false;
                UMLog.i("**USB bulkTransfer 1**", "write res=" + res);
            }
        } else {
            com[0] = 1;
            System.arraycopy(command, 0, com, 1, length);
            for (int i = length + 1; i < 64; ++i) {
                com[i] = 0;
            }
            int iii = 0;
            do {
                ++iii;
                if (toClose) {
                    return 0;
                }
                this.waitingForBulkTransfer = true;
                res = this.connection.bulkTransfer(epOut, com, 64, 2300);
                this.waitingForBulkTransfer = false;
                UMLog.i("**USB bulkTransfer 2**", "write res=" + res);
            } while (res <= 0 && iii < 10);
        }
        UMLog.i("**USB SEND**", "write res=" + res);
        return res;
    }

    static /* synthetic */ byte[] access$1702(UsbController x0, byte[] x1) {
        x0.secureMagBuf = x1;
        return x1;
    }

    static /* synthetic */ byte[] access$2002(UsbController x0, byte[] x1) {
        x0.swipeBuffer = x1;
        return x1;
    }

    private class listenForDataOnThread
    extends Thread {
        private boolean isRunning = true;

        private listenForDataOnThread() {
        }

        @Override
        public void run() {
            byte[] tmp = new byte[4096];
            while (this.isRunning) {
                if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA) {
                    if (!IDT_Device.isNotificationOn || IDT_Device.isCommandRunning) {
                        try {
                            Thread.sleep(30L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    IDT_Device.isCheckingNotification = true;
                    int length = UsbController.this._readMessage(tmp);
                    if (length > 0) {
                        byte[] data = new byte[length - 6];
                        System.arraycopy(tmp, 3, data, 0, length - 6);
                        UMLog.i("listenForDataOnThread", "got: " + Common.getByteArrDesc(data));
                        UsbController.this._msg.usb_onReceiveMsgGetICCNotifyInfo(data);
                    }
                    try {
                        Thread.sleep(30L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    IDT_Device.isCheckingNotification = false;
                    continue;
                }
                if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB) {
                    if (IDT_Device.isCommandRunning || Common.getBootLoaderMode()) {
                        try {
                            Thread.sleep(30L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                } else if (!IDT_Device.isBurstModeOn || !IDT_Device.isAutoPollOn || IDT_Device.isCommandRunning || Common.getBootLoaderMode()) {
                    try {
                        Thread.sleep(30L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (IDT_Device.isBurstModeOn || !IDT_Device.isAutoPollOn || Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB && Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V && Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB && Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB && Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB && Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800) continue;
                    try {
                        Thread.sleep(950L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (IDT_Device.isCommandRunning) continue;
                    if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB) {
                        if (IDT_Device.isMonitorCtlsData) {
                            IDTMSRData card = new IDTMSRData();
                            byte[] command = Common.getByteArray("105669564F7465636832000340000096E2");
                            byte[] data = UsbController.this.sendCommand(command, 1);
                            int len = 0;
                            if (data != null && data.length > 13) {
                                len = (data[12] & 0xFF) * 256 + (data[13] & 0xFF);
                            }
                            if (len > 7) {
                                Common.parseCardData3in1(data, card);
                                UMLog.i("listenForDataOnThread", "got: " + Common.getByteArrDesc(data));
                                UsbController.this._msg.usb_onReceiveMsgCardData(card);
                                continue;
                            }
                            card.result = 61092;
                            UsbController.this._msg.usb_onReceiveMsgCardData(card);
                            continue;
                        }
                        IDTMSRData card = new IDTMSRData();
                        card.result = 61092;
                        UsbController.this._msg.usb_onReceiveMsgCardData(card);
                        continue;
                    }
                    IDTMSRData card = new IDTMSRData();
                    card.result = 61092;
                    UsbController.this._msg.usb_onReceiveMsgCardData(card);
                    continue;
                }
                IDT_Device.isCheckingNotification = true;
                try {
                    Thread.sleep(30L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                IDT_Device.isThreadReading = true;
                int length = UsbController.this.read_KioskIII(tmp);
                IDT_Device.isThreadReading = false;
                if (length > 0) {
                    int i;
                    for (i = 0; i < tmp.length && tmp[i] == 0; ++i) {
                    }
                    UMLog.i("**listenForDataOnThread 1**", "i " + i + "\n");
                    if (i > 0) {
                        byte[] temp = new byte[tmp.length - i];
                        System.arraycopy(tmp, i, temp, 0, temp.length);
                        Arrays.fill(tmp, (byte)0);
                        System.arraycopy(temp, 0, tmp, 0, temp.length);
                    }
                    UMLog.i("**listenForDataOnThread 1**", "read_KioskIII " + Common.base16Encode(tmp) + "\n");
                    if (length > 10) {
                        while (tmp[0] == 69 && tmp[1] == 0 && tmp[2] == 85 || tmp[0] == 7 && tmp[1] == 80 && tmp[2] == -33 && tmp[3] == -17 && tmp[4] == 54 && tmp[5] == 4 && tmp[6] == 3) {
                            boolean isCtlsLCDMsg = false;
                            if (tmp[0] == 69 && tmp[1] == 0 && tmp[2] == 85) {
                                length -= 11;
                                isCtlsLCDMsg = true;
                            } else {
                                length -= 12;
                                isCtlsLCDMsg = false;
                            }
                            if (length < 0) continue;
                            if (length > 0) {
                                byte[] temp = new byte[length];
                                System.arraycopy(tmp, isCtlsLCDMsg ? 11 : 12, temp, 0, length);
                                Arrays.fill(tmp, (byte)0);
                                System.arraycopy(temp, 0, tmp, 0, length);
                                continue;
                            }
                            Arrays.fill(tmp, (byte)0);
                        }
                        if (length <= 0) continue;
                    }
                    if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB) {
                        UMLog.i("**listenForDataOnThread 2**", "read_KioskIII " + Common.base16Encode(tmp) + "\n");
                        if (length > 12 && tmp[10] == 97 && tmp[11] == 1) {
                            try {
                                Thread.sleep(30L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            continue;
                        }
                        if (length > 12 && tmp[10] == -18 && tmp[11] == -16) {
                            try {
                                Thread.sleep(30L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            continue;
                        }
                        if (length > 20 && tmp[10] == 97 && tmp[11] == -1) {
                            int dataLen = tmp[12] << 8 | tmp[13];
                            IDTLCDData lcdData = new IDTLCDData();
                            lcdData.screenID = tmp[14] << 8 | tmp[15];
                            lcdData.objectID = tmp[16] << 8 | tmp[17];
                            int chIdx = 18;
                            while (tmp[chIdx] != 0) {
                                ++chIdx;
                            }
                            byte[] bytes = new byte[chIdx - 18];
                            System.arraycopy(tmp, 18, bytes, 0, bytes.length);
                            lcdData.screenName = new String(bytes);
                            int chIdx2 = ++chIdx;
                            while (tmp[chIdx] != 0) {
                                ++chIdx;
                            }
                            bytes = new byte[chIdx - chIdx2];
                            System.arraycopy(tmp, chIdx2, bytes, 0, bytes.length);
                            lcdData.objectName = new String(bytes);
                            if (dataLen > 4 + lcdData.screenName.length() + 1 + lcdData.objectName.length() + 1) {
                                lcdData.longPressed = tmp[20 + lcdData.screenName.length() + lcdData.objectName.length()];
                            }
                            UsbController.this._msg.usb_onReceiveMsgLcdData(lcdData);
                            try {
                                Thread.sleep(30L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            continue;
                        }
                    } else if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB) {
                        if (length > 12 && tmp[10] == 2 && tmp[11] == -96) {
                            IDTMSRData card = new IDTMSRData();
                            card.result = 61088;
                            UsbController.this._msg.usb_onReceiveMsgCardData(card);
                            try {
                                Thread.sleep(30L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            continue;
                        }
                        if (length > 12 && tmp[10] == -18 && tmp[11] == -16) {
                            IDTMSRData card = new IDTMSRData();
                            card.result = 61168;
                            UsbController.this._msg.usb_onReceiveMsgCardData(card);
                            try {
                                Thread.sleep(30L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            continue;
                        }
                    }
                    byte[] data = new byte[length];
                    System.arraycopy(tmp, 0, data, 0, length);
                    IDTMSRData card = new IDTMSRData();
                    Common.processCTLSData(data, card);
                    UMLog.i("listenForDataOnThread", "got: " + Common.getByteArrDesc(data));
                    UsbController.this._msg.usb_onReceiveMsgCardData(card);
                }
                try {
                    Thread.sleep(30L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                IDT_Device.isCheckingNotification = false;
            }
            UsbController.this.listenThread = null;
        }
    }

    private static interface IPermissionListener {
        public void onPermissionDenied(UsbDevice var1);
    }

    private class PermissionReceiver
    extends BroadcastReceiver {
        private final IPermissionListener mPermissionListener;

        private PermissionReceiver(IPermissionListener permissionListener) {
            this.mPermissionListener = permissionListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action.equals(UsbController.ACTION_USB_PERMISSION)) {
                PermissionReceiver permissionReceiver = this;
                synchronized (permissionReceiver) {
                    UMLog.i(UsbController.TAG, "ACTION_USB_PERMISSION received, asking permission to user");
                    UsbDevice dev = (UsbDevice)intent.getParcelableExtra("device");
                    if (intent.getBooleanExtra("permission", false)) {
                        if (!IDT_Device.getUSBBypass()) {
                            UMLog.i(UsbController.TAG, "User granted permission");
                            UsbController.this.askPermission = false;
                            UsbController.this._usbMsg.onDeviceAttached();
                        }
                    } else {
                        UMLog.i(UsbController.TAG, "User denied permission");
                        UsbController.this.askPermission = false;
                        this.mPermissionListener.onPermissionDenied(dev);
                    }
                }
            }
        }
    }

    private class CheckDeviceThread
    extends Thread {
        boolean res = false;

        private CheckDeviceThread() {
        }

        @Override
        public void run() {
            try {
                CheckDeviceThread.sleep(300L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            while (!this.res && UsbController.this.mManager != null) {
                this.res = UsbController.this.initWithThread();
                try {
                    CheckDeviceThread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private class SwipeDataReceiver
    extends Thread {
        private boolean swipeCancelled = false;

        private SwipeDataReceiver() {
        }

        @Override
        public void run() {
            if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG_KB) {
                while (!this.swipeCancelled) {
                    try {
                        UsbController.access$2002(UsbController.this, new byte[1024]);
                        int length = UsbController.this.readBuffer(UsbController.this.swipeBuffer);
                        if (length <= 0) {
                            try {
                                Thread.sleep(10L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            continue;
                        }
                        byte[] ret = this.parseCardData(UsbController.this.swipeBuffer);
                        if (ret == null || ret.length <= 0) continue;
                        if (ret[0] == 2 && ret[ret.length - 1] == 3) {
                            if (this.checkLRCAndChecksum(ret)) {
                                UMLog.i(UsbController.TAG, "Card data received: " + Common.getHexStringFromBytes(ret));
                                UsbController.this._usbMsg.onDeviceMSRData(ret);
                                continue;
                            }
                            UMLog.e(UsbController.TAG, "Card data error: " + Common.getHexStringFromBytes(ret));
                            UsbController.this._msg.usb_onReceiveMsgFailureInfo(103);
                            continue;
                        }
                        if (ret[0] == 0 && ret[ret.length - 1] == 13) {
                            UMLog.i(UsbController.TAG, "Card data received: clean text cannot shown shown in Log");
                            UsbController.this._usbMsg.onDeviceMSRData(ret);
                            continue;
                        }
                        UMLog.i(UsbController.TAG, "Filtered non-MSR data: " + Common.getHexStringFromBytes(ret));
                    }
                    catch (Exception e) {
                        UMLog.e(UsbController.TAG, "Exception caught: " + e.getMessage().toString());
                    }
                }
                UsbController.this.waitingForResult = false;
            } else if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA) {
                long startTime;
                long endTime = startTime = System.currentTimeMillis();
                while (endTime - startTime <= (long)(UsbController.this.swipeTimeoutSec * 1000) && !this.swipeCancelled) {
                    byte[] cmd = new byte[]{2, 5, 0, 115, 70, 81, 1, 48, 85, 59, 3};
                    byte[] cardData = UsbController.this.sendCommand(cmd, 1);
                    if (cardData != null && cardData.length > 3) {
                        IDTMSRData card;
                        if (cardData[3] == 21) {
                            card = new IDTMSRData();
                            card.result = 10;
                            if (cardData[1] == 3) {
                                card.result = (cardData[5] & 0xFF) + (cardData[4] & 0xFF) * 256;
                            }
                            UMLog.i(UsbController.TAG, "got: Error Code " + card.result);
                            if (card.result != 34048) {
                                this.swipeCancelled = true;
                                UsbController.this._msg.usb_onReceiveMsgCardData(card);
                                break;
                            }
                        } else {
                            this.swipeCancelled = true;
                            card = new IDTMSRData();
                            Common.Response.parseCardDataAugusta(cardData, card);
                            UMLog.i(UsbController.TAG, "got: " + Common.getByteArrDesc(cardData));
                            UsbController.this._msg.usb_onReceiveMsgCardData(card);
                            break;
                        }
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    endTime = System.currentTimeMillis();
                }
                if (endTime - startTime > (long)(UsbController.this.swipeTimeoutSec * 1000)) {
                    this.close();
                    UsbController.this._msg.usb_onReceiveMsgSwipeTimeout();
                }
                UsbController.this.waitingForResult = false;
                IDT_Device.isCommandRunning = false;
                IDT_Device.readyForCardSwipe = true;
            } else {
                while (UsbController.this.swipeCount < UsbController.this.swipeTimeoutSec && !this.swipeCancelled) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    int length = UsbController.this.readMSR(UsbController.this.swipeBuffer);
                    if (length > 0) {
                        this.swipeCancelled = true;
                        IDTMSRData card = new IDTMSRData();
                        byte[] cardData = new byte[length];
                        System.arraycopy(UsbController.this.swipeBuffer, 0, cardData, 0, length);
                        if (cardData[0] == 2 && (cardData[3] == -128 || cardData[3] == -127 || cardData[3] == -125 || cardData[3] == -124 || cardData[3] == -123 || cardData[3] == -122 || cardData[3] == -64)) {
                            Common.Response.parseCardData(cardData, card, 0);
                        } else if (cardData[1] == 2 && (UsbController.this.temp[4] == -128 || cardData[4] == -127 || cardData[4] == -125 || cardData[4] == -124 || cardData[4] == -123 || cardData[4] == -122 || cardData[4] == -64)) {
                            Common.Response.parseCardDataUniPay(cardData, card);
                        } else {
                            Common.Response.parseCardClearData(cardData, card);
                        }
                        UMLog.i(UsbController.TAG, "got: " + Common.getByteArrDesc(UsbController.this.swipeBuffer));
                        UsbController.this._msg.usb_onReceiveMsgCardData(card);
                        break;
                    }
                    UsbController.this.swipeCount++;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (UsbController.this.swipeCount >= UsbController.this.swipeTimeoutSec) {
                    this.close();
                    UsbController.this._msg.usb_onReceiveMsgSwipeTimeout();
                }
                UsbController.this.waitingForResult = false;
                IDT_Device.isCommandRunning = false;
            }
        }

        private void close() {
            this.swipeCancelled = true;
        }

        private byte[] parseCardData(byte[] data) {
            int pos;
            for (pos = data.length - 1; pos >= 0 && data[pos] == 0; --pos) {
            }
            if (pos == 0) {
                return null;
            }
            byte[] ret = new byte[pos + 1];
            System.arraycopy(data, 0, ret, 0, pos + 1);
            return ret;
        }

        private boolean checkLRCAndChecksum(byte[] data) {
            return data[data.length - 3] == this.calculateLRC(data) && data[data.length - 2] == this.calculateCheckSum(data);
        }

        private byte calculateLRC(byte[] data) {
            int result = 0;
            for (int i = 3; i < data.length - 3; ++i) {
                result = (byte)(result ^ data[i]);
            }
            return (byte)(0xFF & result);
        }

        private byte calculateCheckSum(byte[] data) {
            int result = 0;
            for (int i = 3; i < data.length - 3; ++i) {
                result = (byte)(result + data[i]);
            }
            return (byte)(0xFF & result);
        }
    }

    private class CommandDataReceiver
    extends Thread {
        private CommandDataReceiver() {
        }

        @Override
        public void run() {
            while (UsbController.this.dataCount < 80) {
                try {
                    CommandDataReceiver.sleep(30L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                int length = UsbController.this.readCommandBuffer();
                UMLog.i(UsbController.TAG, "Command response length received: " + length);
                if (length > 0) {
                    if (UsbController.this.isDataRepeated()) {
                        byte[] ret = UsbController.this.trimCommandResponse(Common.getBytesFromHexString(UsbController.this.cmdBufferRet));
                        if (ret == null) {
                            UMLog.i(UsbController.TAG, "Wrong command response received: " + UsbController.this.cmdBufferRet);
                            UsbController.this._msg.usb_onReceiveMsgFailureInfo(102);
                            UsbController.access$1702(UsbController.this, null);
                            break;
                        }
                        UMLog.i(UsbController.TAG, "Command response received: " + Common.getHexStringFromBytes(ret));
                        UsbController.access$1702(UsbController.this, new byte[ret.length]);
                        System.arraycopy(ret, 0, UsbController.this.secureMagBuf, 0, ret.length);
                        break;
                    }
                    UsbController.this.cmdBufferRet = UsbController.this.cmdBufferRet + Common.getHexStringFromBytes(UsbController.this.cmdBuffer);
                } else if (UsbController.this.cmdBufferRet.length() >= 16) {
                    byte[] ret = UsbController.this.trimCommandResponse(Common.getBytesFromHexString(UsbController.this.cmdBufferRet));
                    if (ret == null) {
                        UMLog.i(UsbController.TAG, "Wrong command response received: " + UsbController.this.cmdBufferRet);
                        UsbController.access$1702(UsbController.this, null);
                        break;
                    }
                    UMLog.i(UsbController.TAG, "Command response received: " + Common.getHexStringFromBytes(ret));
                    UsbController.access$1702(UsbController.this, new byte[ret.length]);
                    System.arraycopy(ret, 0, UsbController.this.secureMagBuf, 0, ret.length);
                    break;
                }
                UsbController.this.dataCount++;
            }
            if (UsbController.this.dataCount >= 80) {
                UsbController.this.dataCount = 0;
                UsbController.access$1702(UsbController.this, new byte[1]);
                ((UsbController)UsbController.this).secureMagBuf[0] = 0;
            }
            UsbController.this.waitingForResult = false;
        }
    }
}

