/*
 * Decompiled with CFR 0.152.
 */
package com.creditcall.chipdnamobile;

import android.app.NotificationManager;
import android.content.Context;
import android.media.AudioManager;
import android.media.AudioTrack;
import android.os.Build;
import com.creditcall.chipdnamobile.WM;
import timber.log.Timber;

class AudioUtils {
    private static final int TQ = 44100;
    private static short[] EL;
    private static short[] cL;
    private static Context zv;

    AudioUtils() {
    }

    static void TQ(Context context) {
        zv = context;
    }

    static void TQ(CardEaseMobileTones cardEaseMobileTones) {
        try {
            NotificationManager notificationManager = (NotificationManager)zv.getSystemService("notification");
            if (Build.VERSION.SDK_INT >= 23 && !notificationManager.isNotificationPolicyAccessGranted() && notificationManager.getCurrentInterruptionFilter() != 1) {
                return;
            }
            short[] sArray = AudioUtils.EL(cardEaseMobileTones);
            AudioTrack audioTrack = new AudioTrack(5, 44100, 4, 2, sArray.length * 2, 1);
            AudioManager audioManager = null;
            int n = -1;
            if (zv != null) {
                int n2;
                audioManager = (AudioManager)zv.getSystemService("audio");
                int n3 = audioManager.getStreamVolume(5);
                if (n3 < (n2 = audioManager.getStreamMaxVolume(5) / 2)) {
                    n = n3;
                    audioManager.setStreamVolume(5, (int)((double)n2 * 1.5), 0);
                }
                audioTrack.setNotificationMarkerPosition(sArray.length);
                audioTrack.setPlaybackPositionUpdateListener((AudioTrack.OnPlaybackPositionUpdateListener)new WM(audioManager, n));
            }
            audioTrack.play();
            audioTrack.write(sArray, 0, sArray.length);
        }
        catch (SecurityException securityException) {
            Timber.w((Throwable)securityException, (String)"Failed to play device tone [tone=%s]", (Object[])new Object[]{cardEaseMobileTones});
        }
        catch (Exception exception) {
            Timber.wtf((Throwable)exception);
            throw exception;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean TQ() {
        AudioManager audioManager = (AudioManager)zv.getSystemService("audio");
        if (audioManager == null) return false;
        if (audioManager.getRingerMode() == 0) return false;
        return true;
    }

    private static short[] EL(CardEaseMobileTones cardEaseMobileTones) {
        switch (cardEaseMobileTones) {
            case ContactlessSuccess: {
                if (EL == null) {
                    EL = AudioUtils.TQ(1500.0, 44100, 500);
                }
                return EL;
            }
            case ContactlessError: {
                if (cL == null) {
                    int n;
                    short[] sArray = AudioUtils.TQ(750.0, 44100, 600);
                    for (int i = n = sArray.length / 3; i < n * 2; ++i) {
                        sArray[i] = 0;
                    }
                    cL = sArray;
                }
                return cL;
            }
        }
        return new short[0];
    }

    private static short[] TQ(double d, int n, int n2) {
        short[] sArray = new short[n * n2 / 1000];
        for (int i = 0; i < sArray.length; ++i) {
            double d2 = Math.PI * 2 * (double)i * d / (double)n;
            sArray[i] = (short)(Math.sin(d2) * 32767.0);
        }
        return sArray;
    }

    static enum CardEaseMobileTones {
        ContactlessSuccess,
        ContactlessError;

    }
}

