/*
 * Decompiled with CFR 0.152.
 */
package com.creditcall.chipdnamobile;

import com.creditcall.AuthorisationEntity;
import com.creditcall.ExtendedProperty;
import com.creditcall.ICCTag;
import com.creditcall.Name;
import com.creditcall.Response;
import com.creditcall.ResultCode;
import com.creditcall.VerificationResult;
import com.creditcall.chipdnamobile.CardToken;
import com.creditcall.chipdnamobile.Currency;
import com.creditcall.chipdnamobile.DeferredAuthorizationReason;
import com.creditcall.chipdnamobile.RequestResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

class AuthResponse
extends RequestResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String uq;
    private List<ICCTag> sw;
    private String De;
    private String tA;
    private String Pb;
    private String Ut;
    private AuthorisationEntity og;
    private Name Fp;
    private String Gf;
    private String fG;
    private DeferredAuthorizationReason lT = DeferredAuthorizationReason.None;
    private String Mx;
    private String MY;
    private String mm;
    private String XO;
    private List<CardToken> iW;
    private String BW;

    AuthResponse() {
    }

    @Override
    void TQ(Response response, Currency currency) {
        super.TQ(response, currency);
        this.uq = response.getAuthCode();
        this.sw = response.getICCTags();
        this.De = response.getCardScheme();
        this.tA = response.getPAN();
        this.Pb = response.getPAR();
        this.Ut = response.getIssueNumber();
        this.og = response.getAuthorisationEntity();
        this.EL = response.getCardHash();
        this.cL = response.getCardReference();
        this.Fp = response.getCardHolderName();
        this.fG = response.getAcquirerResponseCode();
        if (response.getResultCode() == ResultCode.VoiceReferralRequired) {
            this.Gf = response.getVoiceReferralTelephoneNumber();
        }
        this.Mx = response.getExpiryDate();
        this.BW = response.getCardSchemeAccountType();
        this.MY = response.getAddressResult().toString();
        this.mm = response.getZipCodeResult().toString();
        this.XO = response.getCSCResult().toString();
        ArrayList arrayList = response.getCardTokens();
        if (arrayList != null && !arrayList.isEmpty()) {
            this.iW = new ArrayList<CardToken>();
            for (com.creditcall.CardToken cardToken : arrayList) {
                String string = cardToken.getAlgorithm();
                String string2 = cardToken.getKey();
                String string3 = cardToken.getValue();
                this.iW.add(new CardToken(string, string2, string3));
            }
        } else {
            this.iW = null;
        }
    }

    @Override
    String TQ() {
        return this.uq;
    }

    void TQ(String string) {
        this.uq = string;
    }

    List<ICCTag> EL() {
        return this.sw;
    }

    String cL() {
        return this.De;
    }

    @Override
    String zv() {
        return this.cL;
    }

    @Override
    String dY() {
        return this.EL;
    }

    String rE() {
        return this.tA;
    }

    String dR() {
        return this.Pb;
    }

    @Override
    boolean NE() {
        return this.dR;
    }

    boolean dC() {
        return this.NE;
    }

    void TQ(List<ICCTag> list) {
        this.sw = list;
    }

    String VT() {
        return this.Ut;
    }

    AuthorisationEntity uq() {
        return this.og;
    }

    Name sw() {
        return this.Fp;
    }

    String De() {
        return this.Gf;
    }

    String tA() {
        ArrayList<ExtendedProperty> arrayList = super.Nu();
        if (arrayList != null) {
            for (ExtendedProperty extendedProperty : arrayList) {
                if (!extendedProperty.getName().equals("receipt-data")) continue;
                return extendedProperty.getValue();
            }
        }
        return null;
    }

    String Pb() {
        return this.Mx;
    }

    String Ut() {
        return this.fG;
    }

    public String og() {
        return this.BW;
    }

    void TQ(DeferredAuthorizationReason deferredAuthorizationReason) {
        this.lT = deferredAuthorizationReason;
    }

    DeferredAuthorizationReason Fp() {
        return this.lT;
    }

    boolean Gf() {
        if (this.sw != null && !this.sw.isEmpty()) {
            for (ICCTag iCCTag : this.sw) {
                if (!iCCTag.getID().equalsIgnoreCase("issuerscriptdata")) continue;
                return true;
            }
        }
        return false;
    }

    String fG() {
        return this.zv(this.MY);
    }

    String lT() {
        return this.zv(this.mm);
    }

    String Mx() {
        return this.zv(this.XO);
    }

    private String zv(String string) {
        if (Objects.equals(string, VerificationResult.Empty.toString())) {
            return null;
        }
        return string;
    }

    List<CardToken> MY() {
        return this.iW;
    }
}

