/*
 * Decompiled with CFR 0.152.
 */
package com.creditcall.chipdnamobile;

import android.util.Base64;
import androidx.annotation.VisibleForTesting;
import com.creditcall.AmountType;
import com.creditcall.AmountUnit;
import com.creditcall.CardEaseXMLCommunicationException;
import com.creditcall.CardEaseXMLRequestException;
import com.creditcall.CardEaseXMLResponseException;
import com.creditcall.Client;
import com.creditcall.CredentialOnFile;
import com.creditcall.Error;
import com.creditcall.ErrorCode;
import com.creditcall.ExtendedProperty;
import com.creditcall.FeatureToken;
import com.creditcall.ICCTag;
import com.creditcall.PurchaseLevel2Data;
import com.creditcall.RecoveryAction;
import com.creditcall.Request;
import com.creditcall.RequestType;
import com.creditcall.Response;
import com.creditcall.ResultCode;
import com.creditcall.ServerURL;
import com.creditcall.TerminalCapabilities;
import com.creditcall.VoiceReferralResult;
import com.creditcall.VoidReason;
import com.creditcall.chipdnamobile.AbstractChipDnaMobileErrorCode;
import com.creditcall.chipdnamobile.AuthResponse;
import com.creditcall.chipdnamobile.CA;
import com.creditcall.chipdnamobile.ChipDnaMobileAmountTypeEnum;
import com.creditcall.chipdnamobile.ChipDnaMobileErrorCode;
import com.creditcall.chipdnamobile.ChipDnaMobileException;
import com.creditcall.chipdnamobile.ChipDnaMobileLocalProperties;
import com.creditcall.chipdnamobile.ChipDnaMobileProperties;
import com.creditcall.chipdnamobile.ConfigurationErrorCode;
import com.creditcall.chipdnamobile.Currency;
import com.creditcall.chipdnamobile.DeferredAuthorizationReason;
import com.creditcall.chipdnamobile.Hk;
import com.creditcall.chipdnamobile.OfflineQueueEntry;
import com.creditcall.chipdnamobile.OfflineRequest;
import com.creditcall.chipdnamobile.OnlineResult;
import com.creditcall.chipdnamobile.PT;
import com.creditcall.chipdnamobile.PaymentMethod;
import com.creditcall.chipdnamobile.PaymentType;
import com.creditcall.chipdnamobile.PinPad;
import com.creditcall.chipdnamobile.PpErrorCode;
import com.creditcall.chipdnamobile.ProcessTypeEnum;
import com.creditcall.chipdnamobile.RequestResponse;
import com.creditcall.chipdnamobile.TransactionErrorCode;
import com.creditcall.chipdnamobile.TransactionException;
import com.creditcall.chipdnamobile.TransactionTypeEnum;
import com.creditcall.chipdnamobile.bk;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import timber.log.Timber;

class BW {
    private ChipDnaMobileProperties TQ;
    private static Hashtable<ErrorCode, AbstractChipDnaMobileErrorCode> EL = new Hashtable();

    BW() {
    }

    BW(ChipDnaMobileProperties chipDnaMobileProperties) {
        this.TQ = chipDnaMobileProperties;
    }

    AuthResponse TQ(PT pT) {
        Request request = this.EL(pT);
        return this.TQ(this.TQ(request));
    }

    Request EL(PT pT) {
        RequestType requestType = pT.TQ() == TransactionTypeEnum.SALE ? RequestType.Auth : (pT.TQ() == TransactionTypeEnum.ACCOUNT_VERIFICATION ? RequestType.PreAuth : RequestType.Refund);
        Request request = this.TQ(requestType, pT.EL(), pT.cL(), pT.zv(), pT.dY(), pT.dR(), pT.NE(), pT.dC(), pT.VT(), pT.uq(), pT.sw(), pT.tA(), pT.Pb(), pT.De());
        if (pT.rE() != null && pT.rE().length() > 0) {
            request.setTrack1(pT.rE());
        }
        if (pT.Pb() != null) {
            request.setEncryptedPANKeyEntryData(pT.Pb());
        }
        if (pT.og() != null) {
            request.setBillingInformation(pT.og());
        }
        if (pT.Fp() != null) {
            request.setPurchaseLevel2Data(pT.Fp());
        }
        if (pT.Gf() != null) {
            request.setTerminalCapabilities(pT.Gf());
        }
        if (pT.fG() != null) {
            request.setTransactionLinks(pT.fG());
        }
        if (pT.Ut() && pT.TQ() != TransactionTypeEnum.REFUND) {
            request.setOmniSale(Boolean.valueOf(pT.Ut()));
        }
        if (pT.lT() != null) {
            request.setCredentialOnFile(pT.lT());
        }
        if (pT.Mx() != null) {
            request.setAddress(pT.Mx());
        }
        if (pT.MY() != null) {
            request.setZipCode(pT.MY());
        }
        if (pT.mm() != null && !pT.mm().isEmpty()) {
            ArrayList<FeatureToken> arrayList = new ArrayList<FeatureToken>();
            for (com.creditcall.chipdnamobile.FeatureToken featureToken : pT.mm()) {
                arrayList.add(new FeatureToken(featureToken.getValue()));
            }
            request.setFeatureTokens(arrayList);
        }
        return request;
    }

    String cL(PT pT) throws CertificateException, IOException, CardEaseXMLRequestException {
        Request request = this.EL(pT);
        if (pT.Ut()) {
            request.setAutoConfirm(true);
        }
        request.setOmniSale(Boolean.valueOf(this.TQ.LO() != null && !this.TQ.LO().isEmpty() && pT.Ut() && pT.TQ() != TransactionTypeEnum.REFUND));
        if (this.TQ.EX() == null) {
            throw new CardEaseXMLRequestException("No certificate found");
        }
        String string = this.TQ(request, this.TQ.EX());
        if (string == null || string.length() == 0) {
            throw new CardEaseXMLRequestException("Failed to generate request xml");
        }
        return Base64.encodeToString((byte[])string.getBytes(StandardCharsets.UTF_8), (int)2);
    }

    RequestResponse TQ(AuthResponse authResponse, List<ICCTag> list, List<ExtendedProperty> list2, String string, boolean bl, TransactionTypeEnum transactionTypeEnum) {
        Request request = new Request();
        this.EL(request);
        if (bl && this.TQ.Sb()) {
            request.setRequestType(RequestType.PartialConfirm);
        } else {
            request.setRequestType(RequestType.Conf);
            if (transactionTypeEnum != TransactionTypeEnum.REFUND) {
                request.setConfirmAllowMultiple(false);
            }
        }
        request.setCardEaseReference(authResponse.XO());
        if (list != null && !list.isEmpty()) {
            request.setICCTags(list);
        }
        request = BW.TQ(request, this.TQ, list2);
        if (string != null && string.length() > 0) {
            request.setTrack2(string);
        }
        return this.TQ(this.TQ(request));
    }

    AuthResponse TQ(String string, List<ICCTag> list, List<ExtendedProperty> list2, String string2, PaymentType paymentType) {
        Request request = new Request();
        this.TQ(request, paymentType);
        request.setCardEaseReference(string);
        request.setRequestType(RequestType.Void);
        request.setVoidReason(VoidReason.TransactionFailure);
        if (list != null && !list.isEmpty()) {
            request.setICCTags(list);
        }
        request = BW.TQ(request, this.TQ, list2);
        if (string2 != null && string2.length() > 0) {
            request.setTrack2(string2);
        }
        return this.TQ(this.TQ(request));
    }

    AuthResponse TQ(String string, String string2, String string3, String string4, PaymentMethod paymentMethod, PaymentType paymentType) {
        Request request = new Request();
        this.TQ(request, paymentType);
        request.setRequestType(RequestType.Refund);
        if (paymentMethod == PaymentMethod.Cash) {
            request.setSubType("Cash");
        } else if (paymentMethod == PaymentMethod.Cheque) {
            request.setSubType("Cheque");
        }
        request.setAmount(string2);
        request.setAmountUnit(AmountUnit.Minor);
        request.setCardEaseReference(string);
        if (string3.length() > 0) {
            request.setUserReference(string3);
        }
        if (string4 != null) {
            request.setTransactionId(string4);
        }
        request = BW.TQ(request, this.TQ, null);
        request = BW.TQ(request, this.TQ);
        return this.TQ(this.TQ(request), paymentType);
    }

    RequestResponse TQ(AuthResponse authResponse, VoiceReferralResult voiceReferralResult, List<ExtendedProperty> list) {
        String string = this.EL(authResponse, voiceReferralResult, list);
        return this.TQ(string);
    }

    RequestResponse TQ() {
        String string;
        Request request = new Request();
        this.EL(request);
        request.setRequestType(RequestType.Test);
        request = BW.TQ(request, this.TQ, null);
        AuthResponse authResponse = new AuthResponse();
        Client client = new Client();
        client.setRequest(request);
        try {
            string = "";
            if (this.TQ != null) {
                if (this.TQ.De()) {
                    string = "https://live.cardeasexml.com/generic.cex";
                } else if (this.TQ.tA()) {
                    string = "https://dev.cardeasexml.com:44300/generic.cex";
                }
            } else {
                string = "https://test.cardeasexml.com/generic.cex";
            }
            client.addServerURL(string, 45000);
            client.processRequest();
        }
        catch (CardEaseXMLCommunicationException cardEaseXMLCommunicationException) {
            authResponse.TQ(TransactionErrorCode.ServerCommunicationError);
            return authResponse;
        }
        catch (CardEaseXMLRequestException cardEaseXMLRequestException) {
            authResponse.TQ(TransactionErrorCode.ServerRequestError);
            return authResponse;
        }
        catch (CardEaseXMLResponseException cardEaseXMLResponseException) {
            authResponse.TQ(TransactionErrorCode.ServerResponseError);
            return authResponse;
        }
        string = client.getResponse();
        if (string == null) {
            authResponse.TQ(TransactionErrorCode.NoResponseFromServer);
            return authResponse;
        }
        authResponse.TQ((Response)string, null);
        ResultCode resultCode = string.getResultCode();
        if (resultCode == ResultCode.TestOK) {
            authResponse.TQ(OnlineResult.Approved);
        } else {
            List list = string.getErrors();
            for (Error error : list) {
                authResponse.TQ(BW.TQ(error));
            }
            if (authResponse.LO().isEmpty()) {
                authResponse.TQ(TransactionErrorCode.TestCheckError);
            }
            authResponse.TQ(OnlineResult.Declined);
        }
        return authResponse;
    }

    RequestResponse TQ(OfflineQueueEntry offlineQueueEntry) {
        return this.TQ(offlineQueueEntry.zv(), offlineQueueEntry.NE(), offlineQueueEntry.dC());
    }

    AuthResponse TQ(String string) {
        return this.TQ(string, this.TQ.yS(), this.TQ.Fd());
    }

    AuthResponse TQ(String string, PaymentType paymentType) {
        return this.TQ(string, this.TQ(paymentType), this.TQ.Fd());
    }

    @VisibleForTesting
    String TQ(PaymentType paymentType) {
        if (PaymentType.TAP_TO_MOBILE == paymentType) {
            return this.TQ.Ro();
        }
        return this.TQ.yS();
    }

    private AuthResponse TQ(String string, String string2, int n) {
        AuthResponse authResponse = new AuthResponse();
        if (string2 == null || string2.isEmpty()) {
            Timber.w((String)"Request URL empty", (Object[])new Object[0]);
            authResponse.TQ(TransactionErrorCode.ServerRequestError);
            authResponse.TQ(OnlineResult.Declined);
            return authResponse;
        }
        if (string == null || string.isEmpty()) {
            Timber.w((String)"Request XML empty", (Object[])new Object[0]);
            authResponse.TQ(TransactionErrorCode.ServerRequestError);
            authResponse.TQ(OnlineResult.Declined);
            return authResponse;
        }
        Client client = new Client();
        if (n < 30) {
            Timber.w((String)"Invalid timeout: %d seconds. Default to 30.", (Object[])new Object[]{n});
            n = 30;
        }
        try {
            Timber.i((String)BW.cL(string), (Object[])new Object[0]);
            client.addServerURL(string2, n * 1000);
            client.processRequest(string);
        }
        catch (CardEaseXMLCommunicationException cardEaseXMLCommunicationException) {
            Timber.w((Throwable)cardEaseXMLCommunicationException, (String)"[Operation Reference = %s], [Recovery Action = %s] ", (Object[])new Object[]{cardEaseXMLCommunicationException.operationReference, String.valueOf(cardEaseXMLCommunicationException.recoveryAction)});
            authResponse.TQ(TransactionErrorCode.ServerCommunicationError);
            authResponse.TQ(this.TQ((Exception)((Object)cardEaseXMLCommunicationException), cardEaseXMLCommunicationException.recoveryAction));
            if (cardEaseXMLCommunicationException.recoveryAction == RecoveryAction.Void) {
                TQ tQ = this.cL(cardEaseXMLCommunicationException.operationReference, string);
                CA cA = CA.EL();
                OfflineQueueEntry offlineQueueEntry = new OfflineQueueEntry();
                offlineQueueEntry.TQ(bk.EL(new Date()));
                offlineQueueEntry.cL(tQ.TQ);
                offlineQueueEntry.TQ(OfflineQueueEntry.OfflineRequestState.Pending);
                offlineQueueEntry.TQ(OfflineRequest.OfflineRequestType.RecoveryVoid);
                offlineQueueEntry.zv(string2);
                offlineQueueEntry.TQ(n);
                offlineQueueEntry.dY(tQ.EL);
                Timber.i((String)"RecoveryVoid [Operation Reference = %s], [Original User Reference = %s] ", (Object[])new Object[]{cardEaseXMLCommunicationException.operationReference, tQ.EL});
                try {
                    cA.TQ(offlineQueueEntry);
                }
                catch (ChipDnaMobileException chipDnaMobileException) {
                    Timber.w((Throwable)chipDnaMobileException, (String)"Unable to write RecoveryVoid request", (Object[])new Object[0]);
                }
                if (this.TQ != null && !this.TQ.zV()) {
                    authResponse.TQ(OnlineResult.Declined);
                }
            }
            return authResponse;
        }
        catch (CardEaseXMLRequestException cardEaseXMLRequestException) {
            Timber.w((Throwable)cardEaseXMLRequestException, (String)"No recovery action [Operation Reference = %s]", (Object[])new Object[]{cardEaseXMLRequestException.operationReference});
            authResponse.TQ(TransactionErrorCode.ServerRequestError);
            authResponse.TQ(this.TQ((Exception)((Object)cardEaseXMLRequestException), RecoveryAction.None));
            return authResponse;
        }
        catch (CardEaseXMLResponseException cardEaseXMLResponseException) {
            Timber.w((Throwable)cardEaseXMLResponseException, (String)"No recovery action [Operation Reference = %s]", (Object[])new Object[]{cardEaseXMLResponseException.operationReference});
            authResponse.TQ(TransactionErrorCode.ServerResponseError);
            authResponse.TQ(this.TQ((Exception)((Object)cardEaseXMLResponseException), RecoveryAction.None));
            return authResponse;
        }
        Response response = client.getResponse();
        if (response == null) {
            Timber.w((String)"No response from server", (Object[])new Object[0]);
            authResponse.TQ(TransactionErrorCode.NoResponseFromServer);
            return authResponse;
        }
        Timber.i((String)"CEX Response ->[User Reference = %s] [CEX Reference = %s] [Result = %s]", (Object[])new Object[]{response.getUserReference(), response.getCardEaseReference(), String.valueOf(response.getResultCode())});
        List list = response.getErrors();
        if (!list.isEmpty()) {
            Timber.i((String)"CEX Response ->[Errors = %s]", (Object[])new Object[]{response.getErrors().toString()});
            for (Error error : list) {
                authResponse.TQ(BW.TQ(error));
            }
            authResponse.TQ(OnlineResult.Declined);
            return authResponse;
        }
        Currency currency = null;
        if (response.getCurrencyData() != null) {
            currency = new Currency(response.getCurrencyData().getNumericCode(), response.getCurrencyData().getSymbol(), response.getCurrencyData().getCharCode(), response.getCurrencyData().getExponent());
        } else if (this.TQ != null) {
            currency = this.TQ.Ut();
        }
        authResponse.TQ(response, currency);
        ResultCode resultCode = response.getResultCode();
        if (resultCode == ResultCode.Approved) {
            authResponse.TQ(OnlineResult.Approved);
        } else if (resultCode == ResultCode.VoiceReferralRequired) {
            authResponse.TQ(OnlineResult.VoiceReferralRequired);
        } else if (resultCode == ResultCode.PartialApproval) {
            authResponse.TQ(OnlineResult.PartialApproval);
        } else if (resultCode == ResultCode.Declined && PpErrorCode.allowsOffline(authResponse.dY)) {
            authResponse.TQ(OnlineResult.Empty);
            authResponse.TQ(DeferredAuthorizationReason.ProcessingFailed);
        } else {
            authResponse.TQ(OnlineResult.Declined);
        }
        return authResponse;
    }

    RequestResponse EL(OfflineQueueEntry offlineQueueEntry) {
        AuthResponse authResponse = new AuthResponse();
        Client client = new Client();
        try {
            client.addServerURL(offlineQueueEntry.NE(), offlineQueueEntry.dC() * 1000);
            client.processRequest(offlineQueueEntry.zv());
        }
        catch (CardEaseXMLCommunicationException cardEaseXMLCommunicationException) {
            authResponse.TQ(TransactionErrorCode.ServerCommunicationError);
            return authResponse;
        }
        catch (CardEaseXMLRequestException cardEaseXMLRequestException) {
            authResponse.TQ(TransactionErrorCode.ServerRequestError);
            return authResponse;
        }
        catch (CardEaseXMLResponseException cardEaseXMLResponseException) {
            authResponse.TQ(TransactionErrorCode.ServerResponseError);
            return authResponse;
        }
        Response response = client.getResponse();
        if (response == null) {
            authResponse.TQ(TransactionErrorCode.NoResponseFromServer);
            authResponse.TQ(OnlineResult.Empty);
            return authResponse;
        }
        if (response.getResultCode() == ResultCode.Approved) {
            authResponse.TQ(OnlineResult.Approved);
        } else {
            authResponse.TQ(OnlineResult.Declined);
        }
        return authResponse;
    }

    RequestResponse TQ(boolean bl) {
        ServerURL serverURL;
        Timber.d((String)"performPaymentGatewayRegisterRequest - tapToMobileSpecific ? %s", (Object[])new Object[]{bl});
        RequestResponse requestResponse = new RequestResponse();
        String string = this.EL(bl);
        Client client = new Client();
        try {
            serverURL = new ServerURL(string, 45000);
        }
        catch (CardEaseXMLCommunicationException cardEaseXMLCommunicationException) {
            requestResponse.TQ(TransactionErrorCode.ServerCommunicationError);
            return requestResponse;
        }
        client.addServerURL(serverURL);
        Request request = new Request();
        request.setRequestType(RequestType.Query);
        request.setSubType("Gw-Register");
        PaymentType paymentType = bl ? PaymentType.TAP_TO_MOBILE : PaymentType.PAYMENT_DEVICE;
        this.TQ(request, paymentType);
        client.setRequest(request);
        try {
            client.processRequest(request);
        }
        catch (CardEaseXMLCommunicationException cardEaseXMLCommunicationException) {
            requestResponse.TQ(TransactionErrorCode.ServerCommunicationError);
            return requestResponse;
        }
        catch (CardEaseXMLRequestException cardEaseXMLRequestException) {
            requestResponse.TQ(TransactionErrorCode.ServerRequestError);
            return requestResponse;
        }
        catch (CardEaseXMLResponseException cardEaseXMLResponseException) {
            requestResponse.TQ(TransactionErrorCode.ServerResponseError);
            return requestResponse;
        }
        Response response = client.getResponse();
        if (response == null) {
            requestResponse.TQ(TransactionErrorCode.NoResponseFromServer);
            return requestResponse;
        }
        requestResponse.TQ(response, null);
        ResultCode resultCode = response.getResultCode();
        if (resultCode == ResultCode.Approved) {
            requestResponse.TQ(OnlineResult.Approved);
        } else {
            List list = response.getErrors();
            if (!list.isEmpty()) {
                for (Error error : list) {
                    requestResponse.TQ(BW.TQ(error));
                }
            } else {
                requestResponse.TQ(TransactionErrorCode.ServerCommunicationError);
            }
            requestResponse.TQ(OnlineResult.Declined);
        }
        return requestResponse;
    }

    @VisibleForTesting
    String EL(boolean bl) {
        String string = this.TQ.kJ();
        if (string == null) {
            string = bl ? (this.TQ.De() ? "https://live.cardeasexml.com/gwdirect.cex" : (this.TQ.tA() ? "https://dev.cardeasexml.com:44300/gwdirect.cex?be=uk1-odt-devx-02" : "https://test.cardeasexml.com/gwdirect.cex")) : (this.TQ.De() ? "https://live.cardeasexml.com/gw.cex" : (this.TQ.tA() ? "https://dev.cardeasexml.com:44300/gw.cex" : "https://test.cardeasexml.com/gw.cex"));
        }
        return string;
    }

    Request TQ(RequestType requestType, String string, ChipDnaMobileAmountTypeEnum chipDnaMobileAmountTypeEnum, String string2, String string3, String string4, String string5, String string6, PinPad.InterfaceType interfaceType, List<ICCTag> list, List<ExtendedProperty> list2, boolean bl, String string7, HashMap<String, String> hashMap) {
        int n;
        Request request = new Request();
        this.EL(request);
        if (string5 != null && string5.length() > 0 && (n = string5.indexOf("=")) > -1 && (n += 7) < string5.length() && (string5.charAt(n) == '3' || string5.charAt(n) == '4')) {
            AuthResponse authResponse = new AuthResponse();
            authResponse.TQ(OnlineResult.Declined);
            authResponse.TQ(TransactionErrorCode.AtmCashOnlyCard);
            return null;
        }
        request.setRequestType(requestType);
        switch (requestType) {
            case Auth: {
                request.setAutoConfirm(false);
                break;
            }
            case Refund: {
                request.setAutoConfirm(true);
                break;
            }
            case Offline: 
            case DeferredAuth: {
                request.setOfflineDateTimeFormat("yyyyMMddHHmmss");
                request.setOfflineDateTime(new SimpleDateFormat("yyyyMMddHHmmss", Locale.US).format(new Date()));
                request.setAutoConfirm(!ChipDnaMobileLocalProperties.INSTANCE.getEndOfDayTippingEnabled());
                break;
            }
        }
        request.setAmount(string);
        request.setAmountType(this.TQ(chipDnaMobileAmountTypeEnum));
        request.setAmountUnit(AmountUnit.Minor);
        request.setICCFallback(bl);
        if (string2 != null) {
            request.setAmountTip(string2);
        }
        if (string6 != null && string6.length() > 0) {
            request.setAuthCode(string6);
        }
        if (interfaceType == PinPad.InterfaceType.ContactlessEMV || interfaceType == PinPad.InterfaceType.ContactlessMag) {
            request.setContactless(true);
            if (interfaceType == PinPad.InterfaceType.ContactlessEMV) {
                request.setICCType("EMV");
            } else if (interfaceType == PinPad.InterfaceType.ContactlessMag) {
                request.setICCType("MSD");
            }
        }
        if (this.TQ.Ut() != null) {
            request.setCurrencyCode(this.TQ.Ut().a());
        }
        if (string3 != null && string3.length() > 0) {
            request.setUserReference(string3);
        }
        if (list != null && !list.isEmpty()) {
            request.setICCTags(list);
        }
        if (string7 != null && string7.length() > 0) {
            request.setEncryptedPANKeyEntryData(string7);
        }
        request = BW.TQ(request, this.TQ, list2);
        if (string4 != null && string4.length() > 0) {
            request.setTrack2(string4);
        }
        if (hashMap != null && !hashMap.isEmpty()) {
            request.setMerchantDefinedFields(Hk.TQ(hashMap));
        }
        request = BW.TQ(request, this.TQ);
        return request;
    }

    String TQ(RequestType requestType, String string, ChipDnaMobileAmountTypeEnum chipDnaMobileAmountTypeEnum, String string2, String string3, String string4, String string5, String string6, boolean bl, List<ICCTag> list, List<ExtendedProperty> list2, PinPad.InterfaceType interfaceType, String string7, HashMap<String, String> hashMap) throws CardEaseXMLRequestException {
        Request request = this.TQ(requestType, string, chipDnaMobileAmountTypeEnum, string2, string3, string4, string5, string6, interfaceType, list, list2, bl, string7, hashMap);
        return this.TQ(request, list, list2, string4);
    }

    public String TQ(RequestType requestType, String string, ChipDnaMobileAmountTypeEnum chipDnaMobileAmountTypeEnum, String string2, String string3, String string4, String string5, PinPad.InterfaceType interfaceType, List<ICCTag> list, List<ExtendedProperty> list2, boolean bl, boolean bl2, PurchaseLevel2Data purchaseLevel2Data, Currency currency, Date date, String string6, TerminalCapabilities terminalCapabilities, CredentialOnFile credentialOnFile, HashMap<String, String> hashMap) throws CardEaseXMLRequestException {
        Request request = this.TQ(requestType, string, chipDnaMobileAmountTypeEnum, string2, string3, string4, null, string5, interfaceType, list, list2, bl, string6, hashMap);
        request.setCurrencyCode(currency.a());
        request.setAutoConfirm(bl2);
        request.setPurchaseLevel2Data(purchaseLevel2Data);
        request.setTerminalCapabilities(terminalCapabilities);
        if (requestType == RequestType.DeferredAuth) {
            request.setCredentialOnFile(credentialOnFile);
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        request.setOfflineDateTimeFormat("yyyyMMddHHmmss");
        request.setOfflineDateTime(simpleDateFormat.format(date));
        return this.TQ(request, null, null, null);
    }

    String TQ(String string, String string2, String string3, String string4, List<ICCTag> list, List<ExtendedProperty> list2, String string5, boolean bl, TransactionTypeEnum transactionTypeEnum) throws CardEaseXMLRequestException {
        Request request = new Request();
        if (bl && this.TQ.Sb()) {
            request.setRequestType(RequestType.PartialConfirm);
        } else {
            request.setRequestType(RequestType.Conf);
            if (transactionTypeEnum != TransactionTypeEnum.REFUND) {
                request.setConfirmAllowMultiple(false);
            }
        }
        request.setCardEaseReference(string);
        if (string2 != null && string2.length() != 0) {
            request.setTransactionId(string2);
        }
        request.setAmount(string3);
        request.setAmountTip(string4);
        return this.TQ(request, list, list2, string5);
    }

    String TQ(String string, String string2, List<ICCTag> list, List<ExtendedProperty> list2, String string3) throws CardEaseXMLRequestException {
        return this.TQ(string, string2, list, list2, string3, null);
    }

    String TQ(String string, String string2, List<ICCTag> list, List<ExtendedProperty> list2, String string3, PaymentType paymentType) throws CardEaseXMLRequestException {
        Request request = new Request();
        request.setRequestType(RequestType.Void);
        request.setVoidReason(VoidReason.TransactionFailure);
        request.setCardEaseReference(string);
        if (string2 != null && string2.length() != 0) {
            request.setTransactionId(string2);
        }
        return this.TQ(request, list, list2, string3, paymentType);
    }

    private Request dR(String string, String string2) {
        Request request = new Request();
        this.EL(request);
        request.setRequestType(RequestType.Query);
        request.setSubType("reference");
        request.setUserReference(string);
        if (string2 != null) {
            ExtendedProperty extendedProperty = new ExtendedProperty("originaltransactiondt", string2);
            ArrayList<ExtendedProperty> arrayList = new ArrayList<ExtendedProperty>();
            arrayList.add(extendedProperty);
            request = BW.TQ(request, this.TQ, arrayList);
        }
        return request;
    }

    String TQ(String string, String string2) throws CardEaseXMLRequestException {
        Request request = this.dR(string, string2);
        Client client = new Client();
        client.setRequest(request);
        return client.getRequestAsString();
    }

    String EL(String string, String string2) throws CardEaseXMLRequestException {
        String string3 = this.TQ(string, string2);
        RequestResponse requestResponse = this.EL(string3);
        boolean bl = requestResponse.mm() == OnlineResult.Approved;
        if (bl) {
            return requestResponse.XO();
        }
        return null;
    }

    RequestResponse EL(String string) {
        RequestResponse requestResponse = new RequestResponse();
        if (string == null || string.equals("")) {
            requestResponse.TQ(TransactionErrorCode.ServerRequestError);
            requestResponse.TQ(OnlineResult.Declined);
            return requestResponse;
        }
        Client client = new Client();
        String string2 = this.TQ.yS();
        int n = this.TQ.Fd();
        if (n < 30) {
            Timber.w((String)"Invalid timeout: %d seconds. Default to 30.", (Object[])new Object[]{n});
            n = 30;
        }
        try {
            client.addServerURL(string2, n * 1000);
            client.processRequest(string);
        }
        catch (CardEaseXMLCommunicationException cardEaseXMLCommunicationException) {
            requestResponse.TQ(TransactionErrorCode.ServerCommunicationError);
            return requestResponse;
        }
        catch (CardEaseXMLRequestException cardEaseXMLRequestException) {
            requestResponse.TQ(TransactionErrorCode.ServerRequestError);
            return requestResponse;
        }
        catch (CardEaseXMLResponseException cardEaseXMLResponseException) {
            requestResponse.TQ(TransactionErrorCode.ServerResponseError);
            return requestResponse;
        }
        Response response = client.getResponse();
        if (response == null) {
            requestResponse.TQ(TransactionErrorCode.NoResponseFromServer);
            return requestResponse;
        }
        List list = response.getErrors();
        if (!list.isEmpty()) {
            for (Error error : list) {
                requestResponse.TQ(BW.TQ(error));
            }
            requestResponse.TQ(OnlineResult.Declined);
            return requestResponse;
        }
        requestResponse.TQ(response, null);
        ResultCode resultCode = response.getResultCode();
        if (resultCode == ResultCode.Approved) {
            requestResponse.TQ(OnlineResult.Approved);
        } else if (resultCode == ResultCode.Empty) {
            requestResponse.TQ(OnlineResult.Empty);
        } else {
            requestResponse.TQ(OnlineResult.Declined);
        }
        return requestResponse;
    }

    String EL(AuthResponse authResponse, VoiceReferralResult voiceReferralResult, List<ExtendedProperty> list) {
        return this.TQ(null, authResponse.XO(), authResponse.TQ(), voiceReferralResult, list, !ChipDnaMobileLocalProperties.INSTANCE.getEndOfDayTippingEnabled());
    }

    String TQ(String string, String string2, String string3, VoiceReferralResult voiceReferralResult, List<ExtendedProperty> list, boolean bl) {
        Request request = new Request();
        this.EL(request);
        request.setRequestType(RequestType.VoiceReferralNotification);
        request.setVoiceReferralResult(voiceReferralResult);
        request.setAuthCode(string3);
        request.setCardEaseReference(string2);
        request.setUserReference(string);
        request.setAutoConfirm(bl);
        request = BW.TQ(request, this.TQ, list);
        return this.TQ(request);
    }

    String TQ(String string, String string2, ProcessTypeEnum processTypeEnum, TransactionTypeEnum transactionTypeEnum) throws CardEaseXMLRequestException {
        Request request = new Request();
        this.EL(request);
        if (transactionTypeEnum == TransactionTypeEnum.REFUND) {
            request.setRequestType(RequestType.Refund);
        } else {
            request.setRequestType(RequestType.Auth);
        }
        if (processTypeEnum == ProcessTypeEnum.CASH) {
            request.setSubType("Cash");
        } else if (processTypeEnum == ProcessTypeEnum.CHEQUE) {
            request.setSubType("Cheque");
        }
        request.setICCFallback(false);
        request.setAutoConfirm(true);
        request.setAmount(string);
        request.setAmountUnit(AmountUnit.Minor);
        request.setCurrencyCode(this.TQ.Ut().a());
        request.setUserReference(string2);
        return this.TQ(request, null, null, null);
    }

    private String TQ(Request request, List<ICCTag> list, List<ExtendedProperty> list2, String string) throws CardEaseXMLRequestException {
        return this.TQ(request, list, list2, string, null);
    }

    private String TQ(Request request, List<ICCTag> list, List<ExtendedProperty> list2, String string, PaymentType paymentType) throws CardEaseXMLRequestException {
        this.TQ(request, paymentType);
        if (list != null && !list.isEmpty()) {
            request.setICCTags(list);
        }
        request = BW.TQ(request, this.TQ, list2);
        if (string != null && string.length() > 0) {
            request.setTrack2(string);
        }
        request = BW.TQ(request, this.TQ);
        Client client = new Client();
        client.setRequest(request);
        return client.getRequestAsString();
    }

    static AbstractChipDnaMobileErrorCode TQ(Error error) {
        AbstractChipDnaMobileErrorCode abstractChipDnaMobileErrorCode = EL.get(error.getCode());
        abstractChipDnaMobileErrorCode.setErrorDescription(error.getMessage());
        if (abstractChipDnaMobileErrorCode.getErrorString() == null) {
            abstractChipDnaMobileErrorCode = TransactionErrorCode.Empty;
        }
        return abstractChipDnaMobileErrorCode;
    }

    private void TQ(Request request, PaymentType paymentType) {
        request.setSoftwareName(ChipDnaMobileProperties.VT());
        request.setSoftwareVersion(ChipDnaMobileProperties.uq());
        if (PaymentType.TAP_TO_MOBILE != paymentType) {
            request.setTerminalID(this.TQ.mm());
            request.setTransactionKey(this.TQ.XO());
        }
        if (this.TQ.LO() != null && !this.TQ.LO().isEmpty()) {
            request.setApiKey(this.TQ.LO());
            request.setApplicationId(this.TQ.dC());
            request.setPosGuid(this.EL(paymentType));
        }
        if (!this.TQ.an().isEmpty() && PaymentType.TAP_TO_MOBILE != paymentType) {
            request.setMachineReference(this.TQ.an());
        }
        request.setPointOfInteraction(this.TQ.UG());
    }

    private void EL(Request request) {
        this.TQ(request, (PaymentType)null);
    }

    private String EL(PaymentType paymentType) {
        if (PaymentType.TAP_TO_MOBILE == paymentType) {
            return this.TQ.CA();
        }
        return this.TQ.Nu();
    }

    String TQ(Request request, X509Certificate x509Certificate) {
        String string;
        Client client = new Client();
        client.setRequest(request);
        client.setXmlEncryptionCertificate(x509Certificate);
        try {
            string = client.isXmlEncryptionAvailable() ? client.saveEncryptedRequestAsString() : client.getRequestAsString();
        }
        catch (CardEaseXMLRequestException cardEaseXMLRequestException) {
            string = "";
        }
        return string;
    }

    String TQ(Request request) {
        return this.TQ(request, (X509Certificate)null);
    }

    private AmountType TQ(ChipDnaMobileAmountTypeEnum chipDnaMobileAmountTypeEnum) {
        if (chipDnaMobileAmountTypeEnum != null) {
            switch (chipDnaMobileAmountTypeEnum) {
                case Unknown: {
                    return AmountType.Unknown;
                }
                case Estimate: {
                    return AmountType.Estimate;
                }
            }
            return AmountType.Actual;
        }
        return AmountType.Actual;
    }

    @VisibleForTesting
    static Request TQ(Request request, ChipDnaMobileProperties chipDnaMobileProperties) {
        if (chipDnaMobileProperties != null && chipDnaMobileProperties.QS() != null) {
            request.setCertificationIdentifier(chipDnaMobileProperties.QS());
        }
        return request;
    }

    private static Request TQ(Request request, ChipDnaMobileProperties chipDnaMobileProperties, List<ExtendedProperty> list) {
        if (list != null && !list.isEmpty()) {
            request.setExtendedProperties(list);
        }
        return BW.EL(request, chipDnaMobileProperties);
    }

    private static Request EL(Request request, ChipDnaMobileProperties chipDnaMobileProperties) {
        if (request != null && chipDnaMobileProperties != null) {
            boolean bl = false;
            for (ExtendedProperty extendedProperty : request.getExtendedProperties()) {
                if (extendedProperty == null || !extendedProperty.getName().equalsIgnoreCase("mpos")) continue;
                bl = true;
                break;
            }
            if (!bl) {
                request.addExtendedProperty(new ExtendedProperty("mpos", chipDnaMobileProperties.HH() ? "true" : "false"));
                if (chipDnaMobileProperties.HH()) {
                    request.addExtendedProperty(new ExtendedProperty("mpos-cardreader-type", "separate"));
                }
            }
        }
        return request;
    }

    private DeferredAuthorizationReason TQ(Exception exception, RecoveryAction recoveryAction) {
        if (recoveryAction == RecoveryAction.Void || this.zv(exception.getMessage())) {
            return DeferredAuthorizationReason.CommunicationFailed;
        }
        if (recoveryAction == RecoveryAction.None) {
            return DeferredAuthorizationReason.ConnectionFailed;
        }
        return DeferredAuthorizationReason.None;
    }

    private boolean zv(String string) {
        String[] stringArray;
        if (string == null || string.length() == 0) {
            return false;
        }
        for (String string2 : stringArray = new String[]{"timeout", "HTTP", "response", "request"}) {
            if (!string.contains(string2)) continue;
            return true;
        }
        return false;
    }

    TQ cL(String string, String string2) {
        String string3 = null;
        TQ tQ = new TQ();
        try {
            Node node;
            Document document = BW.dY(string2);
            Node node2 = document.getElementsByTagName("TransactionDetails").item(0);
            NodeList nodeList = document.getElementsByTagName("CardEaseReference");
            if (nodeList != null && nodeList.getLength() > 0) {
                node = nodeList.item(0);
                node.setTextContent(string);
            } else {
                node = document.createElement("CardEaseReference");
                node.appendChild(document.createTextNode(string));
                node2.appendChild(node);
            }
            nodeList = document.getElementsByTagName("Reference");
            if (nodeList != null && nodeList.getLength() > 0) {
                node = nodeList.item(0);
                tQ.EL = node.getTextContent();
            }
            if ((nodeList = document.getElementsByTagName("MessageType")) != null && nodeList.getLength() > 0) {
                node = nodeList.item(0);
                node.setTextContent("Void");
            } else {
                node = document.createElement("MessageType");
                node.appendChild(document.createTextNode("Void"));
                node2.appendChild(node);
            }
            string3 = BW.TQ(document);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Timber.w((String)"FALSE to generate recovery request", (Object[])new Object[0]);
        }
        tQ.TQ = string3;
        return tQ;
    }

    private static String TQ(Document document) throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        StringWriter stringWriter = new StringWriter();
        transformer.transform(new DOMSource(document), new StreamResult(stringWriter));
        return stringWriter.getBuffer().toString();
    }

    private static Document dY(String string) throws IOException, ParserConfigurationException, SAXException {
        ByteArrayInputStream byteArrayInputStream = BW.rE(string);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        return documentBuilder.parse(byteArrayInputStream);
    }

    private static ByteArrayInputStream rE(String string) throws UnsupportedEncodingException {
        Pattern pattern = Pattern.compile("<[?]xml version=\"1.0\" encoding=\"(.*?)\".*[?]>", 42);
        Matcher matcher = pattern.matcher(string);
        ByteArrayInputStream byteArrayInputStream = null;
        byteArrayInputStream = matcher.matches() ? new ByteArrayInputStream(string.getBytes(matcher.group(1))) : new ByteArrayInputStream(string.getBytes());
        return byteArrayInputStream;
    }

    static String zv(String string, String string2) throws TransactionException {
        try {
            Document document = BW.dY(string);
            Node node = document.getElementsByTagName("TransactionDetails").item(0);
            NodeList nodeList = document.getElementsByTagName("Amount");
            if (nodeList != null && nodeList.getLength() > 0) {
                Node node2 = nodeList.item(0);
                node2.setTextContent(string2);
            } else {
                Element element = document.createElement("Amount");
                element.appendChild(document.createTextNode(string2));
                node.appendChild(element);
            }
            return BW.TQ(document);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new TransactionException(TransactionErrorCode.ServerRequestError);
        }
    }

    static String dY(String string, String string2) throws TransactionException {
        try {
            Element element;
            Document document = BW.dY(string);
            NodeList nodeList = document.getElementsByTagName("Amount");
            if (nodeList != null && nodeList.getLength() > 0) {
                element = (Element)nodeList.item(0);
                if (element.hasAttribute("tip")) {
                    element.removeAttribute("tip");
                }
            } else {
                Timber.w((String)"Cannot update tip. Amount tag not found", (Object[])new Object[0]);
                throw new TransactionException(TransactionErrorCode.ServerRequestError);
            }
            element.setAttribute("tip", string2);
            return BW.TQ(document);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new TransactionException(TransactionErrorCode.ServerRequestError);
        }
    }

    static String TQ(String string, RequestType requestType) throws TransactionException {
        try {
            Document document = BW.dY(string);
            Node node = document.getElementsByTagName("TransactionDetails").item(0);
            NodeList nodeList = document.getElementsByTagName("MessageType");
            if (nodeList != null && nodeList.getLength() > 0) {
                Node node2 = nodeList.item(0);
                node2.setTextContent(requestType.toString());
                try {
                    node2.getAttributes().removeNamedItem("autoconfirm");
                }
                catch (DOMException dOMException) {
                    Timber.w((String)"Failed to remove autoconfirm flag", (Object[])new Object[0]);
                    dOMException.printStackTrace();
                }
            } else {
                Element element = document.createElement("MessageType");
                element.appendChild(document.createTextNode(requestType.toString()));
                node.appendChild(element);
            }
            return BW.TQ(document);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new TransactionException(TransactionErrorCode.ServerRequestError);
        }
    }

    static String rE(String string, String string2) throws TransactionException {
        try {
            Document document = BW.dY(string);
            Node node = document.getElementsByTagName("TransactionDetails").item(0);
            NodeList nodeList = document.getElementsByTagName("CardEaseReference");
            if (nodeList != null && nodeList.getLength() > 0) {
                Node node2 = nodeList.item(0);
                node2.setTextContent(string2);
            } else {
                Element element = document.createElement("CardEaseReference");
                element.appendChild(document.createTextNode(string2));
                node.appendChild(element);
            }
            return BW.TQ(document);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new TransactionException(TransactionErrorCode.ServerRequestError);
        }
    }

    static String cL(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Request log string -> ");
        try {
            Node node;
            Document document = BW.dY(string);
            NodeList nodeList = document.getElementsByTagName("Reference");
            if (nodeList != null && nodeList.getLength() > 0) {
                node = nodeList.item(0);
                stringBuilder.append(String.format("[UserReference = %s]", node.getTextContent()));
            }
            if ((nodeList = document.getElementsByTagName("MessageType")) != null && nodeList.getLength() > 0) {
                node = nodeList.item(0);
                stringBuilder.append(String.format(", [MessageType = %s]", node.getTextContent()));
            }
            if ((nodeList = document.getElementsByTagName("CardEaseReference")) != null && nodeList.getLength() > 0) {
                node = nodeList.item(0);
                stringBuilder.append(String.format(", [CEX Ref = %s]", node.getTextContent()));
            }
        }
        catch (Exception exception) {
            Timber.w((Throwable)exception, (String)"Failed to get loggable data from request XML", (Object[])new Object[0]);
        }
        return stringBuilder.toString();
    }

    static {
        EL.put(ErrorCode.AccessDenied, ChipDnaMobileErrorCode.AccessDenied);
        EL.put(ErrorCode.AmountInvalid, TransactionErrorCode.AmountInvalid);
        EL.put(ErrorCode.AmountMissing, TransactionErrorCode.AmountMissing);
        EL.put(ErrorCode.AmountTooLarge, TransactionErrorCode.AmountTooLarge);
        EL.put(ErrorCode.AmountTooSmall, TransactionErrorCode.AmountTooSmall);
        EL.put(ErrorCode.ApiKeyInvalid, TransactionErrorCode.ApiKeyInvalid);
        EL.put(ErrorCode.ApiKeyMissing, TransactionErrorCode.ApiKeyMissing);
        EL.put(ErrorCode.ApplicationIdMissing, TransactionErrorCode.ApplicationIdMissing);
        EL.put(ErrorCode.CardBanned, TransactionErrorCode.CardBanned);
        EL.put(ErrorCode.CardDetailsNotFound, TransactionErrorCode.CardDetailsNotFound);
        EL.put(ErrorCode.CardDetailsUnavailable, TransactionErrorCode.CardDetailsUnavailable);
        EL.put(ErrorCode.CardEaseReferenceInvalid, TransactionErrorCode.CardEaseReferenceInvalid);
        EL.put(ErrorCode.CardEaseReferenceMissing, TransactionErrorCode.CardEaseReferenceMissing);
        EL.put(ErrorCode.CardHashInvalid, TransactionErrorCode.CardHashInvalid);
        EL.put(ErrorCode.CardReferenceInvalid, TransactionErrorCode.CardReferenceInvalid);
        EL.put(ErrorCode.CardSchemeNotSupported, TransactionErrorCode.CardSchemeNotSupported);
        EL.put(ErrorCode.CardUsageExceeded, TransactionErrorCode.CardUsageExceeded);
        EL.put(ErrorCode.DataTypeError, ChipDnaMobileErrorCode.DataTypeError);
        EL.put(ErrorCode.DeviceConfiguration, ChipDnaMobileErrorCode.DeviceConfiguration);
        EL.put(ErrorCode.DeviceRegistrationFailed, ConfigurationErrorCode.DeviceRegistrationFailed);
        EL.put(ErrorCode.Empty, TransactionErrorCode.Empty);
        EL.put(ErrorCode.ExpiredCard, TransactionErrorCode.ExpiredCard);
        EL.put(ErrorCode.ExpiryDateInvalid, TransactionErrorCode.ExpiryDateInvalid);
        EL.put(ErrorCode.ExpiryDateMissing, TransactionErrorCode.ExpiryDateMissing);
        EL.put(ErrorCode.GatewayGeneralError, ChipDnaMobileErrorCode.GatewayGeneralError);
        EL.put(ErrorCode.GatewayProcessError, ChipDnaMobileErrorCode.GatewayProcessError);
        EL.put(ErrorCode.GatewayRejectedTransaction, TransactionErrorCode.GatewayRejectedTransaction);
        EL.put(ErrorCode.GeneralError, ChipDnaMobileErrorCode.GeneralError);
        EL.put(ErrorCode.InvalidData, TransactionErrorCode.InvalidData);
        EL.put(ErrorCode.InvalidField, ChipDnaMobileErrorCode.InvalidField);
        EL.put(ErrorCode.InvalidHTTPMethod, ChipDnaMobileErrorCode.InvalidHTTPMethod);
        EL.put(ErrorCode.InvalidMessageType, TransactionErrorCode.InvalidMessageType);
        EL.put(ErrorCode.InvalidXMLRequest, TransactionErrorCode.InvalidXMLRequest);
        EL.put(ErrorCode.IssueNoInvalid, TransactionErrorCode.IssueNoInvalid);
        EL.put(ErrorCode.IssueNoMissing, TransactionErrorCode.IssueNoMissing);
        EL.put(ErrorCode.MerchantConfigurationError, ChipDnaMobileErrorCode.MerchantConfigurationError);
        EL.put(ErrorCode.MessageTypeInvalid, TransactionErrorCode.MessageTypeInvalid);
        EL.put(ErrorCode.MessageTypeMissing, TransactionErrorCode.MessageTypeMissing);
        EL.put(ErrorCode.MissingField, ChipDnaMobileErrorCode.MissingField);
        EL.put(ErrorCode.NotAllowed, TransactionErrorCode.NotAllowed);
        EL.put(ErrorCode.ParseError, ChipDnaMobileErrorCode.ParseError);
        EL.put(ErrorCode.PANFailsLuhnCheck, TransactionErrorCode.PANFailsLuhnCheck);
        EL.put(ErrorCode.PANInvalid, TransactionErrorCode.PANInvalid);
        EL.put(ErrorCode.PANMissing, TransactionErrorCode.PANMissing);
        EL.put(ErrorCode.PANTooLong, TransactionErrorCode.PANTooLong);
        EL.put(ErrorCode.PANTooShort, TransactionErrorCode.PANTooShort);
        EL.put(ErrorCode.PosGuidInvalid, TransactionErrorCode.PosGuidInvalid);
        EL.put(ErrorCode.PosGuidMissing, TransactionErrorCode.PosGuidMissing);
        EL.put(ErrorCode.PreValidCard, TransactionErrorCode.PreValidCard);
        EL.put(ErrorCode.TmsUpdateForced, TransactionErrorCode.RegistrationRequired);
        EL.put(ErrorCode.ServerError, ChipDnaMobileErrorCode.ServerError);
        EL.put(ErrorCode.StartDateInvalid, TransactionErrorCode.StartDateInvalid);
        EL.put(ErrorCode.StartDateMissing, TransactionErrorCode.StartDateMissing);
        EL.put(ErrorCode.TemporarilyUnavailable, TransactionErrorCode.TemporarilyUnavailable);
        EL.put(ErrorCode.TerminalIDDisabled, TransactionErrorCode.TerminalIDDisabled);
        EL.put(ErrorCode.TerminalIDInvalid, TransactionErrorCode.TerminalIDInvalid);
        EL.put(ErrorCode.TerminalIDMissing, TransactionErrorCode.TerminalIDMissing);
        EL.put(ErrorCode.TerminalIDUnknown, TransactionErrorCode.TerminalIDUnknown);
        EL.put(ErrorCode.TerminalUsageExceeded, TransactionErrorCode.TerminalUsageExceeded);
        EL.put(ErrorCode.TransactionAlreadyRefunded, TransactionErrorCode.TransactionAlreadyRefunded);
        EL.put(ErrorCode.TransactionAlreadySettled, TransactionErrorCode.TransactionAlreadySettled);
        EL.put(ErrorCode.TransactionAlreadyVoided, TransactionErrorCode.TransactionAlreadyVoided);
        EL.put(ErrorCode.TransactionKeyIncorrect, TransactionErrorCode.TransactionKeyIncorrect);
        EL.put(ErrorCode.TransactionKeyInvalid, TransactionErrorCode.TransactionKeyInvalid);
        EL.put(ErrorCode.TransactionKeyMissing, TransactionErrorCode.TransactionKeyMissing);
        EL.put(ErrorCode.TransactionNotFound, TransactionErrorCode.TransactionNotFound);
        EL.put(ErrorCode.TransactionOriginallyDeclined, TransactionErrorCode.TransactionOriginallyDeclined);
        EL.put(ErrorCode.UnexpectedField, ChipDnaMobileErrorCode.UnexpectedField);
        EL.put(ErrorCode.XMLDecryptionError, TransactionErrorCode.XMLDecryptionError);
        EL.put(ErrorCode.XMLElementMissing, TransactionErrorCode.XMLElementMissing);
    }

    class TQ {
        String TQ;
        String EL;

        TQ() {
        }
    }
}

