/*
 * Decompiled with CFR 0.152.
 */
package com.creditcall.chipdnamobile;

import com.creditcall.chipdnamobile.ChipDnaMobileUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;

public class CardSchemeID {
    private static final int TQ = 1;
    private static final int EL = 2;
    private static final int cL = 3;
    private static final int zv = 4;
    private static final int dY = 5;
    private static final int rE = 6;
    private static final int dR = 7;
    private static final int NE = 12;
    private static final TQ[] dC = new TQ[]{new TQ(400000, 499999)};
    public static final CardSchemeID Visa = new CardSchemeID(1);
    private static final TQ[] VT = new TQ[]{new TQ(222100, 272099), new TQ(510000, 559999)};
    public static final CardSchemeID MasterCard = new CardSchemeID(2);
    private static final TQ[] uq = new TQ[]{new TQ(500000, 509999), new TQ(560000, 699999)};
    private static final TQ[] sw = new TQ[]{new TQ(300000, 305999), new TQ(308800, 310299), new TQ(311200, 312099), new TQ(315800, 315999), new TQ(333700, 334999), new TQ(352800, 358999), new TQ(360000, 369999), new TQ(380000, 399999), new TQ(601100, 601109), new TQ(601120, 601149), new TQ(601174, 601174), new TQ(601177, 601179), new TQ(601186, 601199), new TQ(621094, 621094), new TQ(644000, 659999), new TQ(810000, 817199), new TQ(622126, 622925), new TQ(624000, 626999), new TQ(628200, 628899), new TQ(675924, 675924), new TQ(675938, 675938), new TQ(675940, 675940), new TQ(675963, 675970), new TQ(675976, 675976)};
    public static final CardSchemeID Maestro = new CardSchemeID(3);
    private static final TQ[] De = new TQ[]{new TQ(340000, 349999), new TQ(370000, 379999)};
    public static final CardSchemeID Amex = new CardSchemeID(4);
    private static final TQ[] tA = new TQ[]{new TQ(300000, 305999), new TQ(308800, 310299), new TQ(311200, 312099), new TQ(315800, 315999), new TQ(333700, 334999), new TQ(352800, 358999)};
    public static final CardSchemeID JCB = new CardSchemeID(5);
    private static final TQ[] Pb = new TQ[]{new TQ(300000, 305999), new TQ(309500, 309599), new TQ(360000, 369999), new TQ(380000, 399999)};
    public static final CardSchemeID Diners = new CardSchemeID(6);
    private static final TQ[] Ut = new TQ[]{new TQ(360000, 369999), new TQ(380000, 399999), new TQ(601100, 601109), new TQ(601120, 601149), new TQ(601174, 601174), new TQ(601177, 601179), new TQ(601186, 601199), new TQ(621094, 621094), new TQ(644000, 659999), new TQ(810000, 817199), new TQ(622126, 622925), new TQ(624000, 626999), new TQ(628200, 628899)};
    public static final CardSchemeID Discover = new CardSchemeID(7);
    public static final CardSchemeID Carte_Bleue = new CardSchemeID(8);
    public static final CardSchemeID Carte_Blanc = new CardSchemeID(9);
    public static final CardSchemeID Voyager = new CardSchemeID(10);
    public static final CardSchemeID WEX = new CardSchemeID(11);
    private static final TQ[] og = new TQ[]{new TQ(621094, 621094), new TQ(816399, 816399), new TQ(817199, 817199)};
    public static final CardSchemeID ChinaUnionPay = new CardSchemeID(12);
    public static final CardSchemeID Style = new CardSchemeID(100);
    public static final CardSchemeID ValueLink = new CardSchemeID(101);
    public static final CardSchemeID Interac = new CardSchemeID(1241);
    public static final CardSchemeID Laser = new CardSchemeID(3721);
    public static final CardSchemeID Cash = new CardSchemeID(9401);
    public static final CardSchemeID Cheque = new CardSchemeID(9402);
    private int Fp;
    private String Gf;
    private ArrayList<TQ> fG = new ArrayList();
    private ArrayList<TQ> lT = new ArrayList();
    private static ArrayList<CardSchemeID> Mx;

    private CardSchemeID(int cardSchemeID) {
        this.Fp = cardSchemeID;
        this.Gf = this.zv(cardSchemeID);
        this.cL(cardSchemeID);
        if (Mx == null) {
            Mx = new ArrayList();
        }
        Mx.add(this);
    }

    public String getRid() {
        return this.Gf;
    }

    private void cL(int n) {
        switch (n) {
            case 1: {
                this.fG = new ArrayList<TQ>(Arrays.asList(dC));
                break;
            }
            case 2: {
                this.fG = new ArrayList<TQ>(Arrays.asList(VT));
                break;
            }
            case 3: {
                this.fG = new ArrayList<TQ>(Arrays.asList(uq));
                this.lT = new ArrayList<TQ>(Arrays.asList(sw));
                break;
            }
            case 4: {
                this.fG = new ArrayList<TQ>(Arrays.asList(De));
                break;
            }
            case 5: {
                this.fG = new ArrayList<TQ>(Arrays.asList(tA));
                break;
            }
            case 6: {
                this.fG = new ArrayList<TQ>(Arrays.asList(Pb));
                break;
            }
            case 7: {
                this.fG = new ArrayList<TQ>(Arrays.asList(Ut));
                break;
            }
            case 12: {
                this.fG = new ArrayList<TQ>(Arrays.asList(og));
            }
        }
    }

    static CardSchemeID TQ(int n) {
        if (n == Visa.getCardSchemeID()) {
            return Visa;
        }
        if (n == MasterCard.getCardSchemeID()) {
            return MasterCard;
        }
        if (n == Maestro.getCardSchemeID()) {
            return Maestro;
        }
        if (n == CardSchemeID.Amex.Fp) {
            return Amex;
        }
        if (n == JCB.getCardSchemeID()) {
            return JCB;
        }
        if (n == Diners.getCardSchemeID()) {
            return Diners;
        }
        if (n == Discover.getCardSchemeID()) {
            return Discover;
        }
        if (n == Carte_Bleue.getCardSchemeID()) {
            return Carte_Bleue;
        }
        if (n == Carte_Blanc.getCardSchemeID()) {
            return Carte_Blanc;
        }
        if (n == Voyager.getCardSchemeID()) {
            return Voyager;
        }
        if (n == WEX.getCardSchemeID()) {
            return WEX;
        }
        if (n == ChinaUnionPay.getCardSchemeID()) {
            return ChinaUnionPay;
        }
        if (n == Style.getCardSchemeID()) {
            return Style;
        }
        if (n == ValueLink.getCardSchemeID()) {
            return ValueLink;
        }
        if (n == Interac.getCardSchemeID()) {
            return Interac;
        }
        if (n == Laser.getCardSchemeID()) {
            return Laser;
        }
        if (n == Cash.getCardSchemeID()) {
            return Cash;
        }
        if (n == Cheque.getCardSchemeID()) {
            return Cheque;
        }
        return null;
    }

    static CardSchemeID TQ(String string) {
        if (string == null) {
            return null;
        }
        string = string.toUpperCase(Locale.US);
        CardSchemeID cardSchemeID = null;
        if (string.startsWith("A000000003") || string.startsWith("A000000098") || string.startsWith("A000000241")) {
            cardSchemeID = Visa;
        } else if (string.startsWith("A0000000041010")) {
            cardSchemeID = MasterCard;
        } else if (string.startsWith("A0000000043060") || string.startsWith("A0000000042203")) {
            cardSchemeID = Maestro;
        } else if (string.startsWith("A000000025")) {
            cardSchemeID = Amex;
        } else if (string.startsWith("A000000065")) {
            cardSchemeID = JCB;
        } else if (string.startsWith("A000000324")) {
            cardSchemeID = Discover;
        } else if (string.startsWith("A000000152") || string.startsWith("A000000188")) {
            cardSchemeID = Diners;
        } else if (string.startsWith("A0000003330101")) {
            cardSchemeID = ChinaUnionPay;
        }
        return cardSchemeID;
    }

    static CardSchemeID EL(String string) {
        CardSchemeID cardSchemeID;
        block4: {
            if (Mx == null || string == null) {
                return null;
            }
            cardSchemeID = null;
            try {
                String string2 = string.substring(0, 6);
                if (!ChipDnaMobileUtils.VT(string2)) break block4;
                int n = Integer.parseInt(string2);
                for (CardSchemeID cardSchemeID2 : Mx) {
                    if (!cardSchemeID2.EL(n)) continue;
                    cardSchemeID = cardSchemeID2;
                    break;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return cardSchemeID;
    }

    public int getCardSchemeID() {
        return this.Fp;
    }

    boolean EL(int n) {
        for (TQ tQ : this.lT) {
            if (!tQ.TQ(n)) continue;
            return false;
        }
        for (TQ tQ : this.fG) {
            if (!tQ.TQ(n)) continue;
            return true;
        }
        return false;
    }

    boolean TQ(CardSchemeID cardSchemeID) {
        return cardSchemeID != null && this.getCardSchemeID() == cardSchemeID.getCardSchemeID();
    }

    private String zv(int n) {
        String string = null;
        switch (n) {
            case 1: {
                string = "A000000003";
                break;
            }
            case 2: 
            case 3: {
                string = "A000000004";
                break;
            }
            case 4: {
                string = "A000000025";
                break;
            }
            case 5: {
                string = "A000000065";
                break;
            }
            case 6: {
                string = "A000000152";
                break;
            }
            case 7: {
                string = "A000000324";
                break;
            }
            case 12: {
                string = "A000000333";
                break;
            }
        }
        return string;
    }

    private static class TQ {
        int TQ;
        int EL;

        TQ(int n, int n2) {
            if (n > n2) {
                throw new AssertionError((Object)"Range Min is greater than Range Max");
            }
            this.TQ = n;
            this.EL = n2;
        }

        boolean TQ(int n) {
            return n >= this.TQ && n <= this.EL;
        }
    }
}

