/*
 * Decompiled with CFR 0.152.
 */
package com.creditcall.chipdnamobile;

import com.creditcall.chipdnamobile.ChipDnaMobileUtils;
import com.creditcall.chipdnamobile.Yy;
import java.io.IOException;
import java.util.HashMap;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

class DrlRecord {
    private String TQ;
    private Integer EL;
    private Integer cL;
    private Integer zv;
    private ZeroCheckOptionMode dY;
    private byte[] rE;
    private boolean dR;
    private String NE;

    public DrlRecord(String apid, String name) {
        this.TQ = apid;
        this.NE = name;
    }

    boolean TQ(XmlPullParser xmlPullParser) {
        try {
            int n = xmlPullParser.getEventType();
            if (!xmlPullParser.getName().equalsIgnoreCase("Drl")) {
                return false;
            }
            while (n != 3 || !xmlPullParser.getName().equalsIgnoreCase("Drl")) {
                if (n == 2) {
                    this.cL(xmlPullParser);
                }
                n = xmlPullParser.next();
            }
        }
        catch (IOException | XmlPullParserException throwable) {
            return false;
        }
        return true;
    }

    public String TQ() {
        return this.TQ;
    }

    public String EL() {
        return this.NE;
    }

    public Integer cL() {
        return this.cL;
    }

    public Integer zv() {
        return this.EL;
    }

    public Integer dY() {
        return this.zv;
    }

    public ZeroCheckOptionMode rE() {
        return this.dY;
    }

    public byte[] dR() {
        return this.rE;
    }

    public boolean NE() {
        return this.dR;
    }

    HashMap<String, String> EL(XmlPullParser xmlPullParser) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < xmlPullParser.getAttributeCount(); ++i) {
            String string = xmlPullParser.getAttributeName(i);
            String string2 = xmlPullParser.getAttributeValue(i);
            hashMap.put(string, string2);
        }
        return hashMap;
    }

    void cL(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        if (xmlPullParser.getAttributeCount() > 0) {
            HashMap<String, String> hashMap = this.EL(xmlPullParser);
            if (xmlPullParser.getName().equalsIgnoreCase("Tag")) {
                String string = hashMap.get("name");
                if (string.equalsIgnoreCase("CvmLimit")) {
                    this.cL = Integer.parseInt(xmlPullParser.nextText());
                }
                if (string.equalsIgnoreCase("TxnLimit")) {
                    this.EL = Integer.parseInt(xmlPullParser.nextText());
                }
                if (string.equalsIgnoreCase("TerminalFloorLimit")) {
                    this.zv = Integer.parseInt(xmlPullParser.nextText());
                }
                if (string.equalsIgnoreCase("ZeroCheck")) {
                    switch (xmlPullParser.nextText()) {
                        case "1": {
                            this.dY = ZeroCheckOptionMode.ONLINEREQUIRED;
                            break;
                        }
                        case "2": {
                            this.dY = ZeroCheckOptionMode.NOTALLOWED;
                            break;
                        }
                    }
                }
                if (string.equalsIgnoreCase("StatusCheck")) {
                    this.dR = "1".equalsIgnoreCase(xmlPullParser.nextText());
                }
                if (string.equalsIgnoreCase("TTQ")) {
                    String string2 = xmlPullParser.nextText();
                    if (string2.length() % 2 != 0) {
                        string2 = ChipDnaMobileUtils.TQ(string2, '0', string2.length() + 1);
                    }
                    this.rE = Yy.TQ(string2);
                }
            }
        }
    }

    public static enum ZeroCheckOptionMode {
        ONLINEREQUIRED(1),
        NOTALLOWED(2);

        private byte mode;

        private ZeroCheckOptionMode(byte mode) {
            this.mode = mode;
        }

        public byte getMode() {
            return this.mode;
        }
    }

    private class TQ {
        static final String TQ = "name";

        private TQ() {
        }
    }

    private class EL {
        static final String TQ = "TxnLimit";
        static final String EL = "CvmLimit";
        static final String cL = "TerminalFloorLimit";
        static final String zv = "ZeroCheck";
        static final String dY = "TTQ";
        static final String rE = "StatusCheck";

        private EL() {
        }
    }
}

