/*
 * Decompiled with CFR 0.152.
 */
package com.creditcall.chipdnamobile;

import com.creditcall.chipdnamobile.ChipDnaMobileErrorCode;
import com.creditcall.chipdnamobile.IF;
import com.creditcall.chipdnamobile.TmsUpdateException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import timber.log.Timber;

class IN
extends IF {
    private String TQ;
    private String EL;
    private String cL;
    private Date zv;
    private String dY;
    private String rE;
    private String dR;
    private String NE;

    IN() {
    }

    @Override
    void TQ(InputStream inputStream) throws TmsUpdateException {
        Document document = this.EL(inputStream);
        Element element = document.getDocumentElement();
        if (element == null) {
            throw new TmsUpdateException(ChipDnaMobileErrorCode.ResponseXmlNotFound);
        }
        NodeList nodeList = element.getElementsByTagName("Property");
        if (nodeList == null || nodeList.getLength() == 0) {
            throw new TmsUpdateException(ChipDnaMobileErrorCode.EmptyElementSet);
        }
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            try {
                Node node = nodeList.item(i);
                String string = this.TQ(node, "name");
                Node node2 = node.getFirstChild();
                String string2 = "";
                if (node2 != null) {
                    string2 = node2.getNodeValue();
                }
                if (string.equals("ApplicationState")) {
                    this.TQ = string2;
                    continue;
                }
                if (string.equals("ConfigRequiredUtc")) {
                    this.EL = string2;
                    continue;
                }
                if (string.equals("TerminalState")) {
                    this.cL = string2;
                    continue;
                }
                if (string.equals("Utc")) {
                    if (string2.length() > 0) {
                        try {
                            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss", Locale.US);
                            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                            this.zv = simpleDateFormat.parse(string2);
                        }
                        catch (ParseException parseException) {
                            Timber.w((Throwable)parseException, (String)"Failed to parse Utc date", (Object[])new Object[0]);
                        }
                        continue;
                    }
                    this.zv = null;
                    continue;
                }
                if (string.equals("LogCaptureBeginUtc")) {
                    if (string2.length() > 0) {
                        this.rE = this.TQ(node, "format");
                        if (this.rE == null) {
                            this.rE = "yyyyMMddHHmmss";
                        }
                        this.dY = string2;
                        continue;
                    }
                    this.dY = null;
                    this.rE = null;
                    continue;
                }
                if (!string.equals("LogCaptureEndUtc")) continue;
                if (string2.length() > 0) {
                    this.NE = this.TQ(node, "format");
                    if (this.NE == null) {
                        this.NE = "yyyyMMddHHmmss";
                    }
                    this.dR = string2;
                    continue;
                }
                this.dR = null;
                this.NE = null;
                continue;
            }
            catch (DOMException dOMException) {
                throw new TmsUpdateException(ChipDnaMobileErrorCode.ErrorParsingPropertiesXML);
            }
        }
    }

    Date TQ() {
        return this.zv;
    }

    String EL() {
        return this.TQ;
    }

    String cL() {
        return this.EL;
    }

    String zv() {
        return this.cL;
    }

    String dY() {
        return this.dY;
    }

    String rE() {
        return this.rE;
    }

    String dR() {
        return this.dR;
    }

    String NE() {
        return this.NE;
    }
}

