/*
 * Decompiled with CFR 0.152.
 */
package com.creditcall.chipdnamobile;

import Base64.Base64;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.SQLException;
import com.creditcall.chipdnamobile.CCInternalOfflineRequestType;
import com.creditcall.chipdnamobile.ChipDnaMobileErrorCode;
import com.creditcall.chipdnamobile.ChipDnaMobileException;
import com.creditcall.chipdnamobile.ChipDnaMobileInitialisationException;
import com.creditcall.chipdnamobile.ChipDnaMobileProperties;
import com.creditcall.chipdnamobile.CompletionDetails;
import com.creditcall.chipdnamobile.Currency;
import com.creditcall.chipdnamobile.FirmwareUpdateRequest;
import com.creditcall.chipdnamobile.Mx;
import com.creditcall.chipdnamobile.OfflineQueueEntry;
import com.creditcall.chipdnamobile.OfflineRequest;
import com.creditcall.chipdnamobile.OfflineTransactionRecord;
import com.creditcall.chipdnamobile.TransactionDetails;
import com.creditcall.chipdnamobile.TransactionErrorCode;
import com.creditcall.chipdnamobile.TransactionRegisterEntry;
import com.creditcall.chipdnamobile.TransactionResultEnum;
import com.creditcall.chipdnamobile.bk;
import com.creditcall.chipdnamobile.cm;
import com.creditcall.chipdnamobile.mE;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import net.zetetic.database.DatabaseUtils;
import net.zetetic.database.sqlcipher.SQLiteConnection;
import net.zetetic.database.sqlcipher.SQLiteDatabase;
import net.zetetic.database.sqlcipher.SQLiteDatabaseHook;
import net.zetetic.database.sqlcipher.SQLiteOpenHelper;
import timber.log.Timber;

class CA
extends SQLiteOpenHelper {
    private static final String cL = "ChipDnaMobileProperties.db";
    private static final String zv = "CardEaseMobilePropertiesE.db";
    private static final String dY = "ChipDnaMobile.db";
    private static final String rE = "TmsUpdateProperty.db";
    private static final int dR = 22;
    private static final String NE = "NMI" + File.separator + "ChipDNA";
    static final String TQ = "last_transaction_details";
    static final String EL = "last_refund_details";
    private static final String dC = "identifier";
    private static final String VT = "version";
    private static final String uq = "data";
    private static final String sw = "filename";
    private static final String De = "fileCategory";
    private static final String tA = "pinpadType";
    private static final String Pb = "name";
    private static final String Ut = "value";
    private static CA og;
    private SQLiteDatabase Fp;
    private String Gf;
    private Context fG;
    private SQLiteDatabaseHook lT;

    static synchronized void TQ(String string, Context context) throws ChipDnaMobileException {
        CA.cL(string, context);
        og = new CA(string, context);
    }

    static synchronized boolean TQ() {
        return og != null;
    }

    private static void cL(String string, Context context) throws ChipDnaMobileException {
        Object object;
        File file;
        File file2 = context.getDatabasePath(cL);
        if (file2.exists()) {
            Timber.i((String)"Migrating database", (Object[])new Object[0]);
            file = SQLiteDatabase.openOrCreateDatabase((String)file2.getAbsolutePath(), null, null);
            int n = file.getVersion();
            object = context.getDatabasePath(zv).getAbsolutePath();
            file.execSQL("ATTACH DATABASE ? AS encrypted KEY ?;", new Object[]{object, string});
            file.rawExecSQL(String.format("SELECT sqlcipher_export('encrypted')", new Object[0]), new Object[0]);
            file.rawExecSQL(String.format("DETACH DATABASE encrypted", new Object[0]), new Object[0]);
            file.close();
            new rE(zv, string, n, context);
            context.deleteDatabase(rE);
            context.deleteDatabase(cL);
        }
        if ((file = context.getDatabasePath(zv)).exists()) {
            boolean bl;
            File file3 = new File(context.getFilesDir(), NE);
            if (!file3.exists() && !file3.mkdirs()) {
                Timber.w((String)"Migration failed - Failed to create directory structure", (Object[])new Object[0]);
                throw new ChipDnaMobileException(ChipDnaMobileErrorCode.FailedToMigrate);
            }
            object = new File(file3, dY);
            if (((File)object).exists() && !(bl = ((File)object).delete())) {
                Timber.w((String)"Failed to delete database v4 file.", (Object[])new Object[0]);
                throw new ChipDnaMobileException(ChipDnaMobileErrorCode.FailedToMigrate);
            }
            CA.TQ(file, (File)object, string);
            if (!((File)object).exists()) {
                Timber.w((String)"Failed to create ChipDNAMobile database.", (Object[])new Object[0]);
                throw new ChipDnaMobileException(ChipDnaMobileErrorCode.FailedToMigrate);
            }
            if (!file.delete()) {
                Timber.w((String)"Failed to clean up after successful migration.", (Object[])new Object[0]);
                throw new ChipDnaMobileException(ChipDnaMobileErrorCode.FailedToMigrate);
            }
        }
    }

    static File TQ(Context context) {
        File file = new File(context.getFilesDir(), NE);
        return new File(file, dY);
    }

    private static void TQ(File file, File file2, String string) throws ChipDnaMobileException {
        try {
            SQLiteDatabase sQLiteDatabase = SQLiteDatabase.openDatabase((String)file.getPath(), (String)string, null, (int)0, (SQLiteDatabaseHook)new SQLiteDatabaseHook(){

                public void preKey(SQLiteConnection connection) {
                }

                public void postKey(SQLiteConnection connection) {
                    connection.executeRaw("PRAGMA cipher_compatibility = 3", null, null);
                }
            });
            try {
                if (!file2.createNewFile()) {
                    Timber.w((String)"Failed to create database v4 file.", (Object[])new Object[0]);
                    throw new ChipDnaMobileException(ChipDnaMobileErrorCode.FailedToMigrate);
                }
            }
            catch (IOException iOException) {
                Timber.w((Throwable)iOException, (String)"Failed to create database v4 file.", (Object[])new Object[0]);
                throw new ChipDnaMobileException(ChipDnaMobileErrorCode.FailedToMigrate);
            }
            sQLiteDatabase.execSQL("ATTACH DATABASE ? AS sqlcipher4 KEY ?;", new Object[]{file2.getPath(), string});
            sQLiteDatabase.rawExecSQL("SELECT sqlcipher_export('sqlcipher4');", new Object[0]);
            int n = sQLiteDatabase.getVersion();
            sQLiteDatabase.execSQL(String.format("PRAGMA sqlcipher4.user_version = %d;", n));
            sQLiteDatabase.rawExecSQL("DETACH DATABASE sqlcipher4;", new Object[0]);
            sQLiteDatabase.close();
        }
        catch (SQLException sQLException) {
            Timber.w((Throwable)sQLException, (String)"Migration failed to database v4.", (Object[])new Object[0]);
            throw new ChipDnaMobileException(ChipDnaMobileErrorCode.FailedToMigrate);
        }
    }

    private CA(String string, Context context) throws ChipDnaMobileException {
        super(context, CA.TQ(context).getPath(), null, 22);
        this.Gf = string;
        this.fG = context;
        this.lT = new SQLiteDatabaseHook(){

            public void preKey(SQLiteConnection connection) {
            }

            public void postKey(SQLiteConnection connection) {
                connection.execute("PRAGMA cipher_memory_security = OFF", null, null);
            }
        };
        try {
            this.Fp = this.getWritableDatabase();
        }
        catch (SQLException sQLException) {
            throw new ChipDnaMobileException(ChipDnaMobileErrorCode.FailedToOpen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLiteDatabase getWritableDatabase() {
        File file = CA.TQ(this.fG);
        SQLiteDatabase sQLiteDatabase = SQLiteDatabase.openDatabase((String)file.getPath(), (String)this.Gf, null, (int)0x10000000, (SQLiteDatabaseHook)this.lT);
        int n = sQLiteDatabase.getVersion();
        if (n != 22) {
            sQLiteDatabase.beginTransaction();
            try {
                if (n == 0) {
                    this.onCreate(sQLiteDatabase);
                } else if (n < 22) {
                    this.onUpgrade(sQLiteDatabase, n, 22);
                }
                sQLiteDatabase.setVersion(22);
                sQLiteDatabase.setTransactionSuccessful();
            }
            finally {
                sQLiteDatabase.endTransaction();
            }
        }
        return sQLiteDatabase;
    }

    static synchronized CA EL() {
        if (!CA.TQ()) {
            throw new ChipDnaMobileInitialisationException("ChipDnaMobile hasn't been initialised");
        }
        return og;
    }

    static synchronized void cL() {
        if (og != null) {
            CA.og.Fp.close();
            og = null;
        }
    }

    public void onCreate(SQLiteDatabase db) {
        Timber.i((String)"Creating database", (Object[])new Object[0]);
        db.execSQL("CREATE TABLE properties (name TEXT PRIMARY KEY,value TEXT);");
        db.execSQL("CREATE TABLE transaction_data (name TEXT PRIMARY KEY,value TEXT);");
        db.execSQL("CREATE TABLE transaction_details (name TEXT PRIMARY KEY,value BLOB);");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CREATE TABLE ");
        stringBuffer.append("files");
        stringBuffer.append(" ( ");
        stringBuffer.append(dC);
        stringBuffer.append(" TEXT PRIMARY KEY, ");
        stringBuffer.append(VT);
        stringBuffer.append(" TEXT , ");
        stringBuffer.append(uq);
        stringBuffer.append(" BLOB , ");
        stringBuffer.append(sw);
        stringBuffer.append(" TEXT , ");
        stringBuffer.append(De);
        stringBuffer.append(" TEXT , ");
        stringBuffer.append(tA);
        stringBuffer.append(" TEXT ); ");
        db.execSQL(stringBuffer.toString());
        db.execSQL("CREATE TABLE tms_properties (name TEXT PRIMARY KEY,value TEXT);");
        db.execSQL("CREATE TABLE offline_records (guid INTEGER PRIMARY KEY AUTOINCREMENT,date_and_time TEXT,last_retry_date_and_time TEXT,server_url TEXT,server_timeout TEXT,request_xml TEXT,state TEXT,type TEXT,auth_type TEXT,error_codes TEXT,amount TEXT,gratuity TEXT,reference TEXT,live_mode TEXT,scope TEXT,linked_card_ease_ref TEXT );");
        this.dC(db);
        this.rE(db);
        this.dR(db);
        this.dY(db);
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        int n;
        Object object;
        Object object2;
        Timber.i((String)"Upgrading database", (Object[])new Object[0]);
        db.execSQL("CREATE TABLE IF NOT EXISTS transaction_data (name TEXT PRIMARY KEY,value TEXT);");
        db.execSQL("CREATE TABLE IF NOT EXISTS transaction_details (name TEXT PRIMARY KEY,value BLOB);");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CREATE TABLE IF NOT EXISTS ");
        stringBuffer.append("files");
        stringBuffer.append(" ( ");
        stringBuffer.append(dC);
        stringBuffer.append(" TEXT PRIMARY KEY, ");
        stringBuffer.append(VT);
        stringBuffer.append(" TEXT , ");
        stringBuffer.append(uq);
        stringBuffer.append(" BLOB , ");
        stringBuffer.append(sw);
        stringBuffer.append(" TEXT , ");
        stringBuffer.append(De);
        stringBuffer.append(" TEXT , ");
        stringBuffer.append(tA);
        stringBuffer.append(" TEXT ); ");
        db.execSQL(stringBuffer.toString());
        Cursor cursor = db.rawQuery("SELECT value FROM properties WHERE name=?", new String[]{"kernel"});
        String string = null;
        if (cursor != null && cursor.moveToFirst()) {
            string = cursor.getString(0);
        }
        if (cursor != null) {
            cursor.close();
        }
        if (string != null) {
            byte[] byArray;
            object2 = db.rawQuery("SELECT value FROM properties WHERE name=?", new String[]{"lastTmsKernelVersion"});
            object = null;
            if (object2 != null && object2.moveToFirst()) {
                object = object2.getString(0);
            }
            if (object2 != null) {
                object2.close();
            }
            try {
                byArray = Base64.decode(string, 4);
            }
            catch (IOException iOException) {
                db.execSQL("REPLACE INTO properties (name,value) VALUES (?,?);", new Object[]{"lastTmsKernelVersion", ""});
                db.delete("properties", "name=?", new String[]{"kernel"});
                return;
            }
            ContentValues contentValues = new ContentValues();
            contentValues.put(dC, "kernel");
            contentValues.put(VT, (String)object);
            contentValues.put(uq, byArray);
            contentValues.put(sw, "f:\\boot");
            contentValues.put(De, ChipDnaMobileProperties.FileCategory.Software.toString());
            contentValues.put(tA, "THYRON");
            db.replaceOrThrow("files", null, contentValues);
            db.delete("properties", "name=?", new String[]{"kernel"});
        }
        db.execSQL("DROP TABLE IF EXISTS tms_properties");
        db.execSQL("CREATE TABLE tms_properties (name TEXT PRIMARY KEY,value TEXT);");
        if (oldVersion <= 5) {
            db.execSQL("CREATE TABLE offline_records (guid INTEGER PRIMARY KEY AUTOINCREMENT,date_and_time TEXT,last_retry_date_and_time TEXT,server_url TEXT,server_timeout TEXT,request_xml TEXT,state TEXT,type TEXT,error_codes TEXT,amount TEXT,gratuity TEXT,reference TEXT,live_mode TEXT);");
        }
        if (oldVersion == 6) {
            db.execSQL("ALTER TABLE offline_records ADD gratuity TEXT AFTER amount;");
            object2 = new ContentValues();
            object2.put("gratuity", "0");
            db.update("offline_records", (ContentValues)object2, null, null);
        }
        if (oldVersion <= 7) {
            object2 = new cm();
            if (this.EL(db, "properties", "iccRefundSignatureCheckRequired", null) != null) {
                if (this.TQ(db, "properties", "iccRefundSignatureCheckRequired", false)) {
                    object2.dR |= 1;
                }
                if (this.TQ(db, "properties", "swipeRefundSignatureCheckRequired", false)) {
                    object2.dR |= 2;
                }
                if (this.TQ(db, "properties", "contactlessIccSignatureCheckRequired", false)) {
                    object2.dR |= 4;
                }
                if (this.TQ(db, "properties", "contactlessMagstripeSignatureCheckRequired", false)) {
                    object2.dR |= 8;
                }
                try {
                    this.TQ(db, "properties", "refundSignatureCheckRequired", object2.dR);
                    db.delete("properties", "name=?", new String[]{"iccRefundSignatureCheckRequired"});
                    db.delete("properties", "name=?", new String[]{"swipeRefundSignatureCheckRequired"});
                    db.delete("properties", "name=?", new String[]{"contactlessIccSignatureCheckRequired"});
                    db.delete("properties", "name=?", new String[]{"contactlessMagstripeSignatureCheckRequired"});
                }
                catch (ChipDnaMobileException chipDnaMobileException) {
                    Timber.w((Throwable)chipDnaMobileException, (String)"Failed to save migrated to TMS property SignatureCheckRequired", (Object[])new Object[0]);
                }
            }
            object = new cm();
            if (this.EL(db, "properties", "emvEnabled", null) != null) {
                if (this.TQ(db, "properties", "emvEnabled", true)) {
                    ((cm)object).dR |= 1;
                }
                if (this.TQ(db, "properties", "magstripeEnabled", true)) {
                    ((cm)object).dR |= 2;
                }
                if (this.TQ(db, "properties", "contactlessEmvEnabled", false)) {
                    ((cm)object).dR |= 4;
                }
                if (this.TQ(db, "properties", "contactlessMagstripeEnabled", false)) {
                    ((cm)object).dR |= 8;
                }
                try {
                    this.TQ(db, "properties", "cardDataInputCapability", ((cm)object).dR);
                    db.delete("properties", "name=?", new String[]{"emvEnabled"});
                    db.delete("properties", "name=?", new String[]{"magstripeEnabled"});
                    db.delete("properties", "name=?", new String[]{"contactlessEmvEnabled"});
                    db.delete("properties", "name=?", new String[]{"contactlessMagstripeEnabled"});
                }
                catch (ChipDnaMobileException chipDnaMobileException) {
                    Timber.w((Throwable)chipDnaMobileException, (String)"Failed to save migrated to TMS property CardDataInputCapability", (Object[])new Object[0]);
                }
            }
        }
        if (oldVersion <= 9) {
            db.execSQL("ALTER TABLE offline_records ADD auth_type TEXT AFTER type");
            db.execSQL("UPDATE offline_records SET auth_type=?", new Object[]{OfflineTransactionRecord.AuthType.EMPTY.name()});
            object2 = new ContentValues();
            object2.put("auth_type", OfflineTransactionRecord.AuthType.EMPTY.name());
            db.update("offline_records", (ContentValues)object2, null, null);
        }
        if (oldVersion <= 10) {
            db.delete("properties", "name=?", new String[]{"rkiKeyAvailable"});
            db.execSQL("REPLACE INTO tms_properties (name,value) VALUES (?,?);", new Object[]{"requireFullConfigUpdate", true});
            db.execSQL("REPLACE INTO tms_properties (name,value) VALUES (?,?);", new Object[]{"configUpdateRequired", true});
        }
        if (oldVersion <= 11 && (n = this.TQ("properties", "pinPadConnectionTimeout", 300, db)) == -1) {
            try {
                this.TQ(db, "properties", "pinPadConnectionTimeout", 300);
            }
            catch (ChipDnaMobileException chipDnaMobileException) {
                Timber.w((Throwable)chipDnaMobileException, (String)"Failed to save migrated to TMS property PinPadConnectionTimeout", (Object[])new Object[0]);
            }
        }
        if (oldVersion <= 12) {
            db.execSQL("ALTER TABLE offline_records ADD scope TEXT AFTER live_mode");
            ContentValues contentValues = new ContentValues();
            contentValues.put("scope", OfflineTransactionRecord.Scope.PUBLIC.name());
            db.update("offline_records", contentValues, null, null);
            contentValues.clear();
            db.execSQL("ALTER TABLE offline_records ADD linked_card_ease_ref TEXT AFTER scope");
            contentValues.put("state", OfflineRequest.CEMOfflineRequestState.Pending.toString());
            db.update("offline_records", contentValues, String.format("%s=?", "state"), new String[]{"a"});
            contentValues.put("state", OfflineRequest.CEMOfflineRequestState.Failed.toString());
            db.update("offline_records", contentValues, String.format("%s=?", "state"), new String[]{"b"});
            contentValues.clear();
            contentValues.put("auth_type", OfflineTransactionRecord.AuthType.EMPTY.name());
            db.update("offline_records", contentValues, String.format("%s=?", "auth_type"), new String[]{"a"});
            contentValues.put("auth_type", OfflineTransactionRecord.AuthType.OFFLINE.name());
            db.update("offline_records", contentValues, String.format("%s=?", "auth_type"), new String[]{"b"});
            contentValues.put("auth_type", OfflineTransactionRecord.AuthType.VOICE_REFERRAL.name());
            db.update("offline_records", contentValues, String.format("%s=?", "auth_type"), new String[]{"c"});
            contentValues.put("auth_type", OfflineTransactionRecord.AuthType.DEFERRED_AUTH.name());
            db.update("offline_records", contentValues, String.format("%s=?", "auth_type"), new String[]{"d"});
            contentValues.clear();
        }
        if (oldVersion <= 13) {
            this.dC(db);
        }
        if (oldVersion <= 14) {
            if (oldVersion > 12) {
                ContentValues contentValues = new ContentValues();
                contentValues.put("scope", OfflineTransactionRecord.Scope.PUBLIC.name());
                db.update("offline_records", contentValues, String.format("%s IS NULL", "scope"), new String[0]);
            }
            this.cL(db);
            if (oldVersion == 14) {
                this.EL(db);
            }
        }
        if (oldVersion <= 15) {
            this.NE(db);
            this.rE(db);
            this.dY(db);
            this.zv(db);
            this.TQ(db);
        }
        if (oldVersion <= 21) {
            this.dR(db);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void TQ(SQLiteDatabase sQLiteDatabase) {
        String string;
        String string2;
        String string3;
        String string4;
        boolean bl = this.TQ(sQLiteDatabase, "properties", "liveMode", true);
        if (bl) {
            string4 = this.EL(sQLiteDatabase, "properties", "liveCardEaseTerminalId", "");
            string3 = this.EL(sQLiteDatabase, "properties", "liveTransactionKey", "");
            string2 = this.EL(sQLiteDatabase, "properties", "liveWebMISUsername", "");
            string = this.EL(sQLiteDatabase, "properties", "liveWebMISPassword", "");
        } else {
            string4 = this.EL(sQLiteDatabase, "properties", "testCardEaseTerminalId", "");
            string3 = this.EL(sQLiteDatabase, "properties", "testTransactionKey", "");
            string2 = this.EL(sQLiteDatabase, "properties", "testWebMISUsername", "");
            string = this.EL(sQLiteDatabase, "properties", "testWebMISPassword", "");
        }
        try {
            sQLiteDatabase.beginTransaction();
            this.TQ(sQLiteDatabase, "properties", "cardEaseTerminalId", string4);
            this.TQ(sQLiteDatabase, "properties", "transactionKey", string3);
            this.TQ(sQLiteDatabase, "properties", "webMISUsername", string2);
            this.TQ(sQLiteDatabase, "properties", "webMISPassword", string);
            sQLiteDatabase.setTransactionSuccessful();
        }
        catch (ChipDnaMobileException chipDnaMobileException) {
            chipDnaMobileException.printStackTrace();
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
    }

    private void EL(SQLiteDatabase sQLiteDatabase) {
        Object object;
        Cursor cursor = sQLiteDatabase.query("offline_records", new String[]{"guid", "last_retry_date_and_time", "date_and_time", "error_codes"}, String.format("%s=? AND %s=?", "state", "scope"), new String[]{OfflineRequest.CEMOfflineRequestState.Failed.toString(), OfflineTransactionRecord.Scope.PUBLIC.name()}, null, null, null);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (cursor != null && cursor.moveToFirst()) {
            do {
                Object object2;
                Object object4;
                if ((object4 = cursor.getString(cursor.getColumnIndex("last_retry_date_and_time"))) != null && ((String)object4).length() > 0) {
                    try {
                        SimpleDateFormat parseException = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss", Locale.US);
                        parseException.setTimeZone(TimeZone.getTimeZone("UTC"));
                        object = parseException.parse((String)object4);
                        object2 = parseException.parse(cursor.getString(cursor.getColumnIndex("date_and_time")));
                        long l = (((Date)object).getTime() - ((Date)object2).getTime()) / 1000L;
                        if (l > 2592000L) {
                            continue;
                        }
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
                String string = cursor.getString(cursor.getColumnIndex("error_codes"));
                object = new ArrayList();
                object2 = string.split(",");
                for (String string2 : object2) {
                    if (string2.length() <= 0) continue;
                    object.add(Integer.parseInt(string2));
                }
                if (object.size() != 1 || (Integer)object.get(0) != 5107) continue;
                arrayList.add(cursor.getInt(cursor.getColumnIndex("guid")));
            } while (cursor.moveToNext());
        }
        cursor.close();
        if (!arrayList.isEmpty()) {
            for (Integer n : arrayList) {
                object = new ContentValues();
                object.put("state", OfflineRequest.CEMOfflineRequestState.Pending.name());
                object.putNull("error_codes");
                sQLiteDatabase.update("offline_records", (ContentValues)object, String.format("%s=?", "guid"), new String[]{n.toString()});
            }
        }
    }

    private void cL(SQLiteDatabase sQLiteDatabase) {
        Cursor cursor = sQLiteDatabase.query("offline_records", new String[]{"guid", "error_codes"}, String.format("%s=? OR %s=?", "type", "type"), new String[]{"SaleConf", "RefundConf"}, null, null, null);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (cursor != null && cursor.moveToFirst()) {
            do {
                Object object;
                if ((object = cursor.getString(cursor.getColumnIndex("error_codes"))) == null || !((String)object).contains("5029")) continue;
                arrayList.add(cursor.getInt(cursor.getColumnIndex("guid")));
            } while (cursor.moveToNext());
        }
        if (cursor != null) {
            cursor.close();
        }
        if (!arrayList.isEmpty()) {
            for (Integer n : arrayList) {
                try {
                    this.TQ(n, sQLiteDatabase);
                }
                catch (ChipDnaMobileException chipDnaMobileException) {
                    Timber.w((Throwable)chipDnaMobileException, (String)"Failed to remove already confirmed record", (Object[])new Object[0]);
                }
            }
        }
    }

    void TQ(int n, SQLiteDatabase sQLiteDatabase) throws ChipDnaMobileException {
        long l = sQLiteDatabase.delete("offline_records", "guid=?", new String[]{"" + n});
        if (l == -1L) {
            throw new ChipDnaMobileException(ChipDnaMobileErrorCode.FailedToWrite);
        }
    }

    private void zv(SQLiteDatabase sQLiteDatabase) {
        try {
            List<mE> list;
            List<OfflineTransactionRecord> list2 = this.VT(sQLiteDatabase);
            if (!list2.isEmpty()) {
                this.TQ(sQLiteDatabase, list2);
            }
            if (!(list = this.uq(sQLiteDatabase)).isEmpty()) {
                this.EL(sQLiteDatabase, list);
            }
        }
        catch (ChipDnaMobileException chipDnaMobileException) {
            Timber.w((Throwable)chipDnaMobileException, (String)"Failed data migration To TransactionRegister/TransactionQeueu", (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void TQ(SQLiteDatabase sQLiteDatabase, List<OfflineTransactionRecord> list) throws ChipDnaMobileException {
        try {
            sQLiteDatabase.beginTransaction();
            for (OfflineTransactionRecord offlineTransactionRecord : list) {
                long l;
                ContentValues contentValues;
                long l2 = 0L;
                String string = null;
                if (offlineTransactionRecord.tA() != CCInternalOfflineRequestType.RecoveryVoid) {
                    contentValues = new ContentValues();
                    string = String.format("%sChipDnaMobileMigration_%d", offlineTransactionRecord.De() != null && offlineTransactionRecord.De().trim().length() > 0 ? offlineTransactionRecord.De() + "_" : "", new Date().getTime());
                    contentValues.put("user_reference", string);
                    contentValues.put("amount", offlineTransactionRecord.uq());
                    contentValues.put("gratuity", offlineTransactionRecord.sw());
                    contentValues.put("environment", offlineTransactionRecord.VT() ? "LIVE" : "STAGING");
                    contentValues.put("date_time", offlineTransactionRecord.rE());
                    switch (offlineTransactionRecord.tA()) {
                        case Sale: 
                        case SaleConf: 
                        case SaleVoid: {
                            contentValues.put("transaction_type", String.valueOf((Object)TransactionRegisterEntry.TransactionType.Sale));
                            break;
                        }
                        case Refund: 
                        case RefundConf: 
                        case RefundVoid: {
                            contentValues.put("transaction_type", String.valueOf((Object)TransactionRegisterEntry.TransactionType.Refund));
                            break;
                        }
                    }
                    if (offlineTransactionRecord.zv() == OfflineRequest.CEMOfflineRequestState.Pending) {
                        contentValues.put("state", String.valueOf((Object)TransactionRegisterEntry.TransactionState.Confirmed));
                    } else if (offlineTransactionRecord.zv() == OfflineRequest.CEMOfflineRequestState.Failed) {
                        contentValues.put("state", String.valueOf((Object)TransactionRegisterEntry.TransactionState.Authorised));
                    } else {
                        contentValues.put("state", String.valueOf((Object)TransactionRegisterEntry.TransactionState.Unknown));
                    }
                    contentValues.put("result", String.valueOf((Object)TransactionResultEnum.Approved));
                    contentValues.put("closed", Boolean.valueOf(false));
                    l2 = sQLiteDatabase.insert("transaction_register", null, contentValues);
                    if (l2 == -1L) {
                        throw new ChipDnaMobileException(ChipDnaMobileErrorCode.FailedToWrite);
                    }
                }
                contentValues = new ContentValues();
                contentValues.put("date_time", offlineTransactionRecord.rE());
                contentValues.put("last_retry", offlineTransactionRecord.dR());
                contentValues.put("server_url", offlineTransactionRecord.dY);
                contentValues.put("server_timeout", Integer.valueOf(offlineTransactionRecord.rE));
                contentValues.put("request_xml", offlineTransactionRecord.EL);
                contentValues.put("state", String.valueOf((Object)offlineTransactionRecord.zv()));
                contentValues.put("errors", offlineTransactionRecord.dC());
                if (string != null) {
                    contentValues.put("user_reference", string);
                }
                if (offlineTransactionRecord.Pb() == OfflineTransactionRecord.Scope.PUBLIC) {
                    if (offlineTransactionRecord.Ut() == OfflineTransactionRecord.AuthType.DEFERRED_AUTH) {
                        contentValues.put("type", String.valueOf((Object)OfflineRequest.OfflineRequestType.DeferredAuth));
                    } else if (offlineTransactionRecord.Ut() == OfflineTransactionRecord.AuthType.VOICE_REFERRAL) {
                        contentValues.put("type", String.valueOf((Object)OfflineRequest.OfflineRequestType.VoiceReferral));
                    } else if (offlineTransactionRecord.tA() == CCInternalOfflineRequestType.SaleConf || offlineTransactionRecord.tA() == CCInternalOfflineRequestType.RefundConf) {
                        contentValues.put("type", String.valueOf((Object)OfflineRequest.OfflineRequestType.Conf));
                    } else if (offlineTransactionRecord.tA() == CCInternalOfflineRequestType.SaleVoid || offlineTransactionRecord.tA() == CCInternalOfflineRequestType.RefundVoid) {
                        contentValues.put("type", String.valueOf((Object)OfflineRequest.OfflineRequestType.Void));
                    } else if (offlineTransactionRecord.tA() == CCInternalOfflineRequestType.Refund) {
                        contentValues.put("type", String.valueOf((Object)OfflineRequest.OfflineRequestType.Refund));
                    } else {
                        contentValues.put("type", String.valueOf((Object)OfflineRequest.OfflineRequestType.Offline));
                    }
                } else {
                    contentValues.put("type", String.valueOf((Object)OfflineRequest.OfflineRequestType.RecoveryVoid));
                }
                if (offlineTransactionRecord.tA() != CCInternalOfflineRequestType.RecoveryVoid) {
                    contentValues.put("register_id", Long.valueOf(l2));
                }
                if ((l = sQLiteDatabase.insert("offline_queue", null, contentValues)) != -1L) continue;
                throw new ChipDnaMobileException(ChipDnaMobileErrorCode.FailedToWrite);
            }
            sQLiteDatabase.setTransactionSuccessful();
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void EL(SQLiteDatabase sQLiteDatabase, List<mE> list) {
        try {
            sQLiteDatabase.beginTransaction();
            for (mE mE2 : list) {
                ContentValues contentValues = new ContentValues();
                contentValues.put("date_time", mE2.rE());
                contentValues.put("last_retry", mE2.dR());
                contentValues.put("server_url", mE2.dY);
                contentValues.put("server_timeout", Integer.valueOf(mE2.rE));
                contentValues.put("request_xml", mE2.EL);
                contentValues.put("state", String.valueOf((Object)mE2.zv()));
                contentValues.put("errors", mE2.dC());
                contentValues.put("type", String.valueOf((Object)OfflineRequest.OfflineRequestType.DeviceEvent));
            }
            sQLiteDatabase.setTransactionSuccessful();
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
    }

    private void dY(SQLiteDatabase sQLiteDatabase) {
        sQLiteDatabase.execSQL("CREATE TABLE offline_queue (id INTEGER PRIMARY KEY AUTOINCREMENT,date_time TEXT,last_retry TEXT,server_url TEXT,server_timeout TEXT,request_xml TEXT,state TEXT,errors TEXT,type TEXT,register_id INTEGER,user_reference TEXT);");
    }

    private void rE(SQLiteDatabase sQLiteDatabase) {
        sQLiteDatabase.execSQL("CREATE TABLE transaction_register (id INTEGER PRIMARY KEY AUTOINCREMENT,user_reference TEXT,amount TEXT,gratuity TEXT,environment TEXT,currency TEXT,state TEXT,transaction_type TEXT,transaction_details TEXT,completion_data TEXT,result TEXT,closed TEXT,terminal_id TEXT,transaction_key TEXT,linked_refunds TEXT,date_time TEXT,completion_state TEXT,completion_state_date_time TEXT);");
    }

    private void dR(SQLiteDatabase sQLiteDatabase) {
        sQLiteDatabase.execSQL("CREATE TABLE firmware_properties (device_id TEXT PRIMARY KEY,update_available_date TEXT,update_required TEXT,update_incomplete TEXT,update_complete TEXT,last_attempted_update_time TEXT,last_successful_update_time TEXT,files_to_update TEXT,time_frame INTEGER);");
    }

    private void NE(SQLiteDatabase sQLiteDatabase) {
        Object object;
        Cursor cursor = sQLiteDatabase.query("offline_records", new String[]{"guid", "error_codes"}, null, null, null, null, null);
        HashMap<Integer, ContentValues> hashMap = new HashMap<Integer, ContentValues>();
        if (cursor != null && cursor.moveToFirst()) {
            do {
                ContentValues contentValues;
                if ((object = cursor.getString(cursor.getColumnIndex("error_codes"))) == null) continue;
                StringBuilder stringBuilder = new StringBuilder();
                for (String string : contentValues = ((String)object).split(",")) {
                    if (string.length() <= 0) continue;
                    stringBuilder.append(TransactionErrorCode.TQ(Integer.parseInt(string)));
                    stringBuilder.append(",");
                }
                if (stringBuilder.length() <= 0) continue;
                ContentValues contentValues2 = new ContentValues();
                contentValues2.put("error_codes", stringBuilder.toString());
                hashMap.put(cursor.getInt(cursor.getColumnIndex("guid")), contentValues2);
            } while (cursor.moveToNext());
        }
        cursor.close();
        if (hashMap.size() > 0) {
            object = hashMap.keySet().iterator();
            while (object.hasNext()) {
                int n = (Integer)object.next();
                sQLiteDatabase.update("offline_records", (ContentValues)hashMap.get(n), "guid=?", new String[]{"" + n});
            }
        }
    }

    private void dC(SQLiteDatabase sQLiteDatabase) {
        sQLiteDatabase.execSQL("CREATE TABLE device_event_records (guid INTEGER PRIMARY KEY AUTOINCREMENT,date_and_time TEXT,last_retry_date_and_time TEXT,server_url TEXT,server_timeout TEXT,request_xml TEXT,error_codes TEXT,state TEXT);");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean EL(String string, Context context) {
        if (string == null) {
            throw new IllegalArgumentException("Password cannot be null");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("Password cannot be empty");
        }
        if (CA.EL(context)) {
            return true;
        }
        try {
            og = new CA(string, context);
        }
        catch (ChipDnaMobileException chipDnaMobileException) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (og != null) {
                CA.cL();
            }
        }
        return true;
    }

    static boolean EL(Context context) {
        File file = CA.TQ(context);
        return !file.exists();
    }

    boolean TQ(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Password cannot be null");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("Password cannot be empty");
        }
        this.Fp.rawExecSQL(String.format("PRAGMA rekey = %s", DatabaseUtils.sqlEscapeString((String)string)), new Object[0]);
        this.Gf = string;
        return true;
    }

    void TQ(String string, Vector<String> vector) throws ChipDnaMobileException {
        String string2 = CA.TQ(vector, ',');
        this.TQ(string, "receiptCopyToEmailAddresses", string2);
    }

    void TQ(String string, String string2, Currency currency) throws ChipDnaMobileException {
        String string3 = CA.TQ(currency);
        this.TQ(string, string2, string3);
    }

    void TQ(String string, String string2, Vector<String> vector) throws ChipDnaMobileException {
        String string3 = CA.TQ(vector, '|');
        this.TQ(string, string2, string3);
    }

    void TQ(String string, String string2, String string3) throws ChipDnaMobileException {
        this.TQ(this.Fp, string, string2, string3);
    }

    void TQ(SQLiteDatabase sQLiteDatabase, String string, String string2, String string3) throws ChipDnaMobileException {
        try {
            sQLiteDatabase.execSQL("REPLACE INTO " + string + " (" + Pb + "," + Ut + ") VALUES (?,?);", new Object[]{string2, string3});
        }
        catch (SQLException sQLException) {
            throw new ChipDnaMobileException(ChipDnaMobileErrorCode.FailedToWrite);
        }
    }

    void TQ(String string, String string2, boolean bl) throws ChipDnaMobileException {
        try {
            this.Fp.execSQL("REPLACE INTO " + string + " (" + Pb + "," + Ut + ") VALUES (?,?);", new Object[]{string2, bl});
        }
        catch (SQLException sQLException) {
            throw new ChipDnaMobileException(ChipDnaMobileErrorCode.FailedToWrite);
        }
    }

    void TQ(String string, String string2, int n) throws ChipDnaMobileException {
        this.TQ(this.Fp, string, string2, n);
    }

    void TQ(SQLiteDatabase sQLiteDatabase, String string, String string2, int n) throws ChipDnaMobileException {
        try {
            sQLiteDatabase.execSQL("REPLACE INTO " + string + " (" + Pb + "," + Ut + ") VALUES (?,?);", new Object[]{string2, n});
        }
        catch (SQLException sQLException) {
            throw new ChipDnaMobileException(ChipDnaMobileErrorCode.FailedToWrite);
        }
    }

    void TQ(String string, String string2, long l) throws ChipDnaMobileException {
        try {
            this.Fp.execSQL("REPLACE INTO " + string + " (" + Pb + "," + Ut + ") VALUES (?,?);", new Object[]{string2, l});
        }
        catch (SQLException sQLException) {
            throw new ChipDnaMobileException(ChipDnaMobileErrorCode.FailedToWrite);
        }
    }

    void TQ(String string, ChipDnaMobileProperties.FileCategory fileCategory, byte[] byArray, String string2, String string3, ChipDnaMobileProperties.PINPadType pINPadType) throws ChipDnaMobileException {
        ContentValues contentValues = new ContentValues();
        contentValues.put(dC, string);
        contentValues.put(VT, string2);
        contentValues.put(uq, byArray);
        contentValues.put(sw, string3);
        contentValues.put(De, fileCategory.toString());
        contentValues.put(tA, pINPadType.toString());
        try {
            this.Fp.replaceOrThrow("files", null, contentValues);
        }
        catch (SQLException sQLException) {
            throw new ChipDnaMobileException(ChipDnaMobileErrorCode.FailedToWrite);
        }
    }

    Vector<String> EL(String string, Vector<String> vector) {
        String string2 = CA.TQ(vector, ',');
        String string3 = this.EL(string, "receiptCopyToEmailAddresses", string2);
        return CA.TQ(string3, ',');
    }

    Currency EL(String string, String string2, Currency currency) {
        String string3 = CA.TQ(currency);
        String string4 = this.EL(string, string2, string3);
        return CA.dR(string4);
    }

    boolean EL(String string, String string2, boolean bl) {
        return this.TQ(this.Fp, string, string2, bl);
    }

    boolean TQ(SQLiteDatabase sQLiteDatabase, String string, String string2, boolean bl) {
        String string3 = "0";
        if (bl) {
            string3 = "1";
        }
        String string4 = this.EL(sQLiteDatabase, string, string2, string3);
        return "1".equals(string4);
    }

    String EL(String string, String string2, String string3) {
        return this.EL(this.Fp, string, string2, string3);
    }

    String EL(SQLiteDatabase sQLiteDatabase, String string, String string2, String string3) {
        Cursor cursor = sQLiteDatabase.rawQuery("SELECT value FROM " + string + " WHERE " + Pb + "=?", new String[]{string2});
        String string4 = string3;
        if (cursor != null && cursor.moveToFirst()) {
            string4 = cursor.getString(0);
        }
        if (cursor != null) {
            cursor.close();
        }
        return string4;
    }

    int TQ(String string, String string2, int n, SQLiteDatabase sQLiteDatabase) {
        int n2 = n;
        String string3 = Integer.toString(n);
        String string4 = this.EL(sQLiteDatabase, string, string2, string3);
        try {
            n2 = Integer.parseInt(string4);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n2;
    }

    int EL(String string, String string2, int n) {
        return this.TQ(string, string2, n, this.Fp);
    }

    long EL(String string, String string2, long l) {
        long l2 = l;
        String string3 = String.valueOf(l);
        String string4 = this.EL(string, string2, string3);
        try {
            l2 = Long.parseLong(string4);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return l2;
    }

    Vector<String> EL(String string, String string2, Vector<String> vector) {
        String string3 = CA.TQ(vector, '|');
        String string4 = this.EL(string, string2, string3);
        return CA.TQ(string4, '|');
    }

    void TQ(String string, String string2, Serializable serializable) throws ChipDnaMobileException {
        try {
            this.Fp.execSQL("REPLACE INTO " + string + " (" + Pb + "," + Ut + ") VALUES (?,?);", new Object[]{string2, CA.TQ(serializable)});
        }
        catch (SQLException sQLException) {
            throw new ChipDnaMobileException(ChipDnaMobileErrorCode.FailedToWrite);
        }
    }

    Object TQ(String string, String string2) {
        return this.TQ(string, string2, this.Fp);
    }

    Object TQ(String string, String string2, SQLiteDatabase sQLiteDatabase) {
        Cursor cursor = sQLiteDatabase.rawQuery("SELECT value FROM " + string + " WHERE " + Pb + "=?", new String[]{string2});
        byte[] byArray = null;
        if (cursor != null && cursor.moveToFirst()) {
            byArray = cursor.getBlob(0);
        }
        if (cursor != null) {
            cursor.close();
        }
        if (byArray != null) {
            Object object = CA.TQ(byArray);
            return object;
        }
        return null;
    }

    void TQ(String string, ChipDnaMobileProperties.FileCategory fileCategory, ChipDnaMobileProperties.PINPadType pINPadType) throws ChipDnaMobileException {
        int n = this.Fp.delete("files", String.format("%s=? AND %s=? AND %s=?", dC, De, tA), new String[]{string, fileCategory.toString(), pINPadType.toString()});
        if (n != 1) {
            throw new ChipDnaMobileException(ChipDnaMobileErrorCode.FailedToWrite);
        }
    }

    boolean EL(String string, ChipDnaMobileProperties.FileCategory fileCategory, ChipDnaMobileProperties.PINPadType pINPadType) {
        return DatabaseUtils.longForQuery((SQLiteDatabase)this.Fp, (String)String.format("SELECT COUNT(%2$s) FROM %1$s WHERE %2$s=? AND %3$s=? AND %4$s=?", "files", dC, tA, De), (String[])new String[]{string, pINPadType.toString(), fileCategory.toString()}) > 0L;
    }

    HashMap<String, String> TQ(ChipDnaMobileProperties.FileCategory fileCategory, ChipDnaMobileProperties.PINPadType pINPadType) {
        Cursor cursor = this.Fp.query("files", new String[]{dC, VT}, String.format("%s=? AND %s=?", De, tA), new String[]{fileCategory.toString(), pINPadType.toString()}, null, null, null, null);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (cursor != null && cursor.moveToFirst()) {
            do {
                hashMap.put(cursor.getString(cursor.getColumnIndex(dC)), cursor.getString(cursor.getColumnIndex(VT)));
            } while (cursor.moveToNext());
        }
        if (cursor != null) {
            cursor.close();
        }
        return hashMap;
    }

    HashMap<String, String> EL(ChipDnaMobileProperties.FileCategory fileCategory, ChipDnaMobileProperties.PINPadType pINPadType) {
        Cursor cursor = this.Fp.query("files", new String[]{sw, VT}, String.format("%s=? AND %s=?", De, tA), new String[]{fileCategory.toString(), pINPadType.toString()}, null, null, null, null);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (cursor != null && cursor.moveToFirst()) {
            do {
                hashMap.put(cursor.getString(cursor.getColumnIndex(sw)), cursor.getString(cursor.getColumnIndex(VT)));
            } while (cursor.moveToNext());
        }
        if (cursor != null) {
            cursor.close();
        }
        return hashMap;
    }

    String TQ(String string, ChipDnaMobileProperties.FileCategory fileCategory, ChipDnaMobileProperties.PINPadType pINPadType, String string2) {
        String[] stringArray;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("SELECT %1$s FROM %2$s WHERE %3$s=? AND  %4$s=? AND %5$s=?", sw, "files", dC, tA, De));
        if (string2 != null) {
            stringBuilder.append(String.format(" AND %s=?", VT));
            stringArray = new String[]{string, pINPadType.toString(), fileCategory.toString(), string2};
        } else {
            stringArray = new String[]{string, pINPadType.toString(), fileCategory.toString()};
        }
        return DatabaseUtils.stringForQuery((SQLiteDatabase)this.Fp, (String)stringBuilder.toString(), (String[])stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] TQ(String string, ChipDnaMobileProperties.FileCategory fileCategory, String string2, ChipDnaMobileProperties.PINPadType pINPadType) {
        String[] stringArray;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format(" %s=? AND %s=? AND %s=?", dC, tA, De));
        if (string2 != null) {
            stringBuilder.append(String.format(" AND %s=? ", VT));
            stringArray = new String[]{string, pINPadType.toString(), fileCategory.toString(), string2};
        } else {
            stringArray = new String[]{string, pINPadType.toString(), fileCategory.toString()};
        }
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder2.append(String.format("SELECT length(%1$s) FROM %2$s WHERE %3$s", uq, "files", stringBuilder.toString()));
        Mx mx = new Mx();
        long l = DatabaseUtils.longForQuery((SQLiteDatabase)this.Fp, (String)stringBuilder2.toString(), (String[])stringArray);
        long l2 = 1L;
        long l3 = l;
        long l4 = 1000000L;
        if (l3 > 1000000L) {
            l3 = 1000000L;
        }
        while (l2 <= l3) {
            Cursor cursor = this.Fp.query("files", new String[]{"substr(data," + l2 + "," + 1000000L + ") as " + uq}, stringBuilder.toString(), stringArray, null, null, null, null);
            if (cursor != null) {
                try {
                    if (cursor.moveToFirst()) {
                        byte[] byArray = cursor.getBlob(cursor.getColumnIndex(uq));
                        mx.TQ(byArray, 0, byArray.length);
                    }
                }
                finally {
                    cursor.close();
                }
            }
            l2 = l3 + 1L;
            if (l - l3 > 1000000L) {
                l3 += 1000000L;
                continue;
            }
            l3 = l;
        }
        if (mx.TQ() > 0) {
            return mx.EL();
        }
        return null;
    }

    private static byte[] TQ(Serializable serializable) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);){
            objectOutputStream.writeObject(serializable);
        }
        catch (IOException iOException) {
            Timber.w((Throwable)iOException, (String)"Serialize object error", (Object[])new Object[0]);
            return null;
        }
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object TQ(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream = null;
        Object object = null;
        try {
            objectInputStream = new ObjectInputStream(byteArrayInputStream);
            object = objectInputStream.readObject();
        }
        catch (Exception exception) {
            object = null;
        }
        finally {
            try {
                if (objectInputStream != null) {
                    objectInputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return object;
    }

    private static String TQ(Currency currency) {
        String string = null;
        if (currency != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(currency.a());
            stringBuffer.append(',');
            stringBuffer.append(currency.getCharCode());
            stringBuffer.append(',');
            stringBuffer.append(currency.getExponent());
            stringBuffer.append(',');
            stringBuffer.append(currency.getSymbol());
            string = stringBuffer.toString();
        }
        return string;
    }

    private static String TQ(Vector<String> vector, char c) {
        String string = null;
        if (vector != null) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = true;
            for (String string2 : vector) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(c);
                }
                stringBuffer.append(string2);
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    private static Vector<String> TQ(String string, char c) {
        Vector<String> vector = null;
        if (string != null) {
            String string2;
            vector = new Vector<String>();
            int n = 0;
            int n2 = string.indexOf(c);
            while (n2 != -1) {
                string2 = string.substring(n, n2);
                vector.addElement(string2);
                n = n2 + 1;
                n2 = string.indexOf(c, n);
            }
            if (n < string.length()) {
                string2 = string.substring(n);
                vector.addElement(string2);
            }
        }
        return vector;
    }

    private static Currency dR(String string) {
        Currency currency = null;
        if (string != null && string.length() > 0) {
            int n = 0;
            int n2 = string.indexOf(44);
            String string2 = string.substring(n, n2);
            n = n2 + 1;
            n2 = string.indexOf(44, n);
            String string3 = string.substring(n, n2);
            n = n2 + 1;
            n2 = string.indexOf(44, n);
            String string4 = string.substring(n, n2);
            n = n2 + 1;
            String string5 = string.substring(n);
            currency = new Currency(string2, string5, string3, Integer.parseInt(string4));
        }
        return currency;
    }

    void zv() {
        this.Fp.beginTransaction();
    }

    void dY() {
        this.Fp.setTransactionSuccessful();
    }

    void rE() {
        this.Fp.endTransaction();
    }

    static void cL(Context context) {
        context.deleteDatabase(zv);
        if (!CA.TQ(context).delete()) {
            Timber.w((String)"Failed to delete database", (Object[])new Object[0]);
        }
    }

    static void zv(Context context) {
        context.deleteDatabase(cL);
        context.deleteDatabase(zv);
        context.deleteDatabase(rE);
        if (!CA.TQ(context).delete()) {
            Timber.w((String)"Failed to delete database", (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long EL(String string) throws ChipDnaMobileException {
        try {
            bk.EL(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ChipDnaMobileException(ChipDnaMobileErrorCode.FailedToWrite);
        }
        String string2 = String.format("SELECT count(%1$s.%2$s) FROM %1$s WHERE %1$s.%3$s < ? ;", "transaction_register", "id", "date_time");
        String string3 = String.format(" %s.%s < ? ", "transaction_register", "date_time");
        long l = DatabaseUtils.longForQuery((SQLiteDatabase)this.Fp, (String)string2, (String[])new String[]{string});
        if (l > 0L) {
            try {
                this.Fp.beginTransaction();
                this.Fp.delete("transaction_register", string3, new String[]{string});
                this.Fp.setTransactionSuccessful();
            }
            finally {
                this.Fp.endTransaction();
            }
            this.Fp.execSQL("VACUUM");
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long cL(String string) throws ChipDnaMobileException {
        try {
            bk.EL(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ChipDnaMobileException(ChipDnaMobileErrorCode.FailedToWrite);
        }
        String string2 = String.format("NOT EXISTS (  SELECT * FROM  %2$s  WHERE %1$s.%3$s = %2$s.%4$s )  AND %1$s.%5$s != ?  AND %1$s.%5$s != ?  AND %1$s.%6$s < ? ;", "transaction_register", "offline_queue", "id", "register_id", "state", "date_time");
        String string3 = String.format("SELECT count(%1$s.%3$s) FROM %1$s WHERE NOT EXISTS (  SELECT * FROM  %2$s  WHERE %1$s.%3$s = %2$s.%4$s )  AND %1$s.%5$s != ?  AND %1$s.%5$s != ?  AND %1$s.%6$s < ? ;", "transaction_register", "offline_queue", "id", "register_id", "state", "date_time");
        long l = DatabaseUtils.longForQuery((SQLiteDatabase)this.Fp, (String)string3, (String[])new String[]{TransactionRegisterEntry.TransactionState.Authorised.name(), TransactionRegisterEntry.TransactionState.PartiallyConfirmed.name(), string});
        if (l > 0L) {
            try {
                this.Fp.beginTransaction();
                this.Fp.delete("transaction_register", string2, new String[]{TransactionRegisterEntry.TransactionState.Authorised.name(), TransactionRegisterEntry.TransactionState.PartiallyConfirmed.name(), string});
                this.Fp.setTransactionSuccessful();
            }
            finally {
                this.Fp.endTransaction();
            }
            this.Fp.execSQL("VACUUM");
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OfflineQueueEntry TQ(OfflineQueueEntry offlineQueueEntry) throws ChipDnaMobileException {
        this.Fp.beginTransaction();
        try {
            long l;
            ContentValues contentValues = new ContentValues();
            contentValues.put("user_reference", offlineQueueEntry.uq());
            contentValues.put("date_time", offlineQueueEntry.EL());
            contentValues.put("server_url", offlineQueueEntry.NE());
            contentValues.put("server_timeout", Integer.valueOf(offlineQueueEntry.dC()));
            contentValues.put("request_xml", offlineQueueEntry.zv());
            contentValues.put("state", String.valueOf((Object)offlineQueueEntry.rE()));
            contentValues.put("type", String.valueOf((Object)offlineQueueEntry.dR()));
            contentValues.put("register_id", Long.valueOf(offlineQueueEntry.VT()));
            if (offlineQueueEntry.dY() != null && !offlineQueueEntry.dY().isEmpty()) {
                contentValues.put("errors", offlineQueueEntry.sw());
            }
            if ((l = this.Fp.insert("offline_queue", null, contentValues)) == -1L) {
                throw new ChipDnaMobileException(ChipDnaMobileErrorCode.FailedToWrite);
            }
            offlineQueueEntry.TQ(l);
            this.Fp.setTransactionSuccessful();
            OfflineQueueEntry offlineQueueEntry2 = offlineQueueEntry;
            return offlineQueueEntry2;
        }
        finally {
            this.Fp.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OfflineQueueEntry TQ(SQLiteDatabase sQLiteDatabase, OfflineQueueEntry offlineQueueEntry) throws ChipDnaMobileException {
        sQLiteDatabase.beginTransaction();
        try {
            ContentValues contentValues = new ContentValues();
            if (offlineQueueEntry.uq() != null) {
                contentValues.put("user_reference", offlineQueueEntry.uq());
            }
            contentValues.put("date_time", offlineQueueEntry.EL());
            contentValues.put("server_url", offlineQueueEntry.NE());
            contentValues.put("server_timeout", Integer.valueOf(offlineQueueEntry.dC()));
            contentValues.put("state", String.valueOf((Object)offlineQueueEntry.rE()));
            contentValues.put("type", String.valueOf((Object)offlineQueueEntry.dR()));
            contentValues.put("register_id", Long.valueOf(offlineQueueEntry.VT()));
            if (offlineQueueEntry.cL() != null) {
                contentValues.put("last_retry", offlineQueueEntry.cL());
            } else {
                contentValues.putNull("last_retry");
            }
            if (offlineQueueEntry.zv() != null) {
                contentValues.put("request_xml", offlineQueueEntry.zv());
            } else {
                contentValues.putNull("request_xml");
            }
            if (offlineQueueEntry.dY() != null && !offlineQueueEntry.dY().isEmpty()) {
                contentValues.put("errors", offlineQueueEntry.sw());
            } else {
                contentValues.putNull("errors");
            }
            long l = sQLiteDatabase.update("offline_queue", contentValues, "id=?", new String[]{"" + offlineQueueEntry.TQ()});
            if (l == -1L) {
                throw new ChipDnaMobileException(ChipDnaMobileErrorCode.FailedToWrite);
            }
            sQLiteDatabase.setTransactionSuccessful();
            OfflineQueueEntry offlineQueueEntry2 = offlineQueueEntry;
            return offlineQueueEntry2;
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
    }

    OfflineQueueEntry EL(OfflineQueueEntry offlineQueueEntry) throws ChipDnaMobileException {
        return this.TQ(this.Fp, offlineQueueEntry);
    }

    void cL(OfflineQueueEntry offlineQueueEntry) throws ChipDnaMobileException {
        long l = this.Fp.delete("offline_queue", "id=?", new String[]{"" + offlineQueueEntry.TQ()});
        if (l == -1L) {
            throw new ChipDnaMobileException(ChipDnaMobileErrorCode.FailedToWrite);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OfflineQueueEntry TQ(long l) throws ChipDnaMobileException {
        Cursor cursor = this.Fp.query("offline_queue", new String[]{"id", "date_time", "last_retry", "server_url", "server_timeout", "request_xml", "state", "errors", "type", "register_id", "user_reference"}, String.format("%s=? AND %s!=? AND %s!=?", "register_id", "type", "type"), new String[]{String.valueOf(l), String.valueOf((Object)OfflineRequest.OfflineRequestType.RecoveryVoid), String.valueOf((Object)OfflineRequest.OfflineRequestType.DeviceEvent)}, null, null, null);
        if (cursor == null) {
            throw new ChipDnaMobileException(ChipDnaMobileErrorCode.FailedToRead);
        }
        try {
            Object object;
            OfflineQueueEntry offlineQueueEntry = null;
            if (cursor.moveToFirst()) {
                Object object2;
                Object object3;
                offlineQueueEntry = new OfflineQueueEntry();
                offlineQueueEntry.TQ(cursor.getLong(cursor.getColumnIndex("id")));
                offlineQueueEntry.TQ(cursor.getString(cursor.getColumnIndex("date_time")));
                offlineQueueEntry.EL(cursor.getString(cursor.getColumnIndex("last_retry")));
                offlineQueueEntry.zv(cursor.getString(cursor.getColumnIndex("server_url")));
                offlineQueueEntry.TQ(cursor.getInt(cursor.getColumnIndex("server_timeout")));
                offlineQueueEntry.cL(cursor.getString(cursor.getColumnIndex("request_xml")));
                object = cursor.getString(cursor.getColumnIndex("state"));
                if (object != null && ((String)object).length() > 0) {
                    object3 = Enum.valueOf(OfflineQueueEntry.OfflineRequestState.class, (String)object);
                    offlineQueueEntry.TQ((OfflineQueueEntry.OfflineRequestState)((Object)object3));
                }
                offlineQueueEntry.rE(cursor.getString(cursor.getColumnIndex("errors")));
                object3 = cursor.getString(cursor.getColumnIndex("type"));
                if (object3 != null && ((String)object3).length() > 0) {
                    object2 = Enum.valueOf(OfflineRequest.OfflineRequestType.class, (String)object3);
                    offlineQueueEntry.TQ((OfflineRequest.OfflineRequestType)((Object)object2));
                }
                if ((object2 = cursor.getString(cursor.getColumnIndex("register_id"))) != null && ((String)object2).trim().length() > 0) {
                    offlineQueueEntry.EL(cursor.getLong(cursor.getColumnIndex("register_id")));
                }
                offlineQueueEntry.dY(cursor.getString(cursor.getColumnIndex("user_reference")));
            }
            object = offlineQueueEntry;
            return object;
        }
        finally {
            cursor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<OfflineQueueEntry> TQ(OfflineQueueEntry.OfflineRequestState offlineRequestState) throws ChipDnaMobileException {
        Cursor cursor = this.Fp.query("offline_queue", new String[]{"id", "date_time", "last_retry", "server_url", "server_timeout", "request_xml", "state", "errors", "type", "register_id", "user_reference"}, String.format("%s=?", "state"), new String[]{String.valueOf((Object)offlineRequestState)}, null, null, String.format("%s Collate NOCASE", "date_time"));
        if (cursor == null) {
            throw new ChipDnaMobileException(ChipDnaMobileErrorCode.FailedToRead);
        }
        try {
            Object object;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            if (cursor.moveToFirst()) {
                do {
                    try {
                        Object object2;
                        Object object3;
                        object = new OfflineQueueEntry();
                        ((OfflineQueueEntry)object).TQ(cursor.getLong(cursor.getColumnIndex("id")));
                        ((OfflineQueueEntry)object).TQ(cursor.getString(cursor.getColumnIndex("date_time")));
                        ((OfflineQueueEntry)object).EL(cursor.getString(cursor.getColumnIndex("last_retry")));
                        ((OfflineQueueEntry)object).zv(cursor.getString(cursor.getColumnIndex("server_url")));
                        ((OfflineQueueEntry)object).TQ(cursor.getInt(cursor.getColumnIndex("server_timeout")));
                        ((OfflineQueueEntry)object).cL(cursor.getString(cursor.getColumnIndex("request_xml")));
                        String string = cursor.getString(cursor.getColumnIndex("state"));
                        if (string != null && string.length() > 0) {
                            object3 = Enum.valueOf(OfflineQueueEntry.OfflineRequestState.class, string);
                            ((OfflineQueueEntry)object).TQ((OfflineQueueEntry.OfflineRequestState)((Object)object3));
                        }
                        ((OfflineQueueEntry)object).rE(cursor.getString(cursor.getColumnIndex("errors")));
                        object3 = cursor.getString(cursor.getColumnIndex("type"));
                        if (object3 != null && ((String)object3).length() > 0) {
                            object2 = Enum.valueOf(OfflineRequest.OfflineRequestType.class, (String)object3);
                            ((OfflineQueueEntry)object).TQ((OfflineRequest.OfflineRequestType)((Object)object2));
                        }
                        if ((object2 = cursor.getString(cursor.getColumnIndex("register_id"))) != null && ((String)object2).trim().length() > 0) {
                            ((OfflineQueueEntry)object).EL(cursor.getLong(cursor.getColumnIndex("register_id")));
                        }
                        ((OfflineQueueEntry)object).dY(cursor.getString(cursor.getColumnIndex("user_reference")));
                        arrayList.add(object);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                } while (cursor.moveToNext());
            }
            object = arrayList;
            return object;
        }
        finally {
            cursor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<OfflineQueueEntry> TQ(OfflineQueueEntry.OfflineRequestState offlineRequestState, OfflineRequest.OfflineRequestType offlineRequestType, String string) throws ChipDnaMobileException {
        Cursor cursor = this.Fp.query("offline_queue", new String[]{"id", "date_time", "last_retry", "server_url", "server_timeout", "request_xml", "state", "errors", "type", "register_id", "user_reference"}, String.format("%s=? AND %s=? AND %s=?", "state", "type", "user_reference"), new String[]{String.valueOf((Object)offlineRequestState), String.valueOf((Object)offlineRequestType), string}, null, null, String.format("%s Collate NOCASE", "date_time"));
        if (cursor == null) {
            throw new ChipDnaMobileException(ChipDnaMobileErrorCode.FailedToRead);
        }
        try {
            Object object;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            if (cursor.moveToFirst()) {
                do {
                    try {
                        object = new OfflineQueueEntry();
                        ((OfflineQueueEntry)object).TQ(cursor.getLong(cursor.getColumnIndex("id")));
                        ((OfflineQueueEntry)object).TQ(cursor.getString(cursor.getColumnIndex("date_time")));
                        ((OfflineQueueEntry)object).EL(cursor.getString(cursor.getColumnIndex("last_retry")));
                        ((OfflineQueueEntry)object).zv(cursor.getString(cursor.getColumnIndex("server_url")));
                        ((OfflineQueueEntry)object).TQ(cursor.getInt(cursor.getColumnIndex("server_timeout")));
                        ((OfflineQueueEntry)object).cL(cursor.getString(cursor.getColumnIndex("request_xml")));
                        String string2 = cursor.getString(cursor.getColumnIndex("state"));
                        OfflineQueueEntry.OfflineRequestState offlineRequestState2 = Enum.valueOf(OfflineQueueEntry.OfflineRequestState.class, string2);
                        ((OfflineQueueEntry)object).TQ(offlineRequestState2);
                        ((OfflineQueueEntry)object).rE(cursor.getString(cursor.getColumnIndex("errors")));
                        String string3 = cursor.getString(cursor.getColumnIndex("type"));
                        OfflineRequest.OfflineRequestType offlineRequestType2 = Enum.valueOf(OfflineRequest.OfflineRequestType.class, string3);
                        ((OfflineQueueEntry)object).TQ(offlineRequestType2);
                        String string4 = cursor.getString(cursor.getColumnIndex("register_id"));
                        if (string4 != null && string4.trim().length() > 0) {
                            ((OfflineQueueEntry)object).EL(cursor.getLong(cursor.getColumnIndex("register_id")));
                        }
                        ((OfflineQueueEntry)object).dY(cursor.getString(cursor.getColumnIndex("user_reference")));
                        arrayList.add(object);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                } while (cursor.moveToNext());
            }
            object = arrayList;
            return object;
        }
        finally {
            cursor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TransactionRegisterEntry TQ(TransactionRegisterEntry transactionRegisterEntry) throws ChipDnaMobileException {
        try {
            Object object;
            long l;
            this.Fp.beginTransaction();
            ContentValues contentValues = new ContentValues();
            contentValues.put("user_reference", transactionRegisterEntry.dY());
            contentValues.put("amount", transactionRegisterEntry.rE());
            contentValues.put("gratuity", transactionRegisterEntry.dR());
            contentValues.put("environment", transactionRegisterEntry.NE());
            contentValues.put("currency", CA.TQ(transactionRegisterEntry.dC()));
            contentValues.put("state", String.valueOf((Object)transactionRegisterEntry.VT()));
            contentValues.put("transaction_type", String.valueOf((Object)transactionRegisterEntry.uq()));
            contentValues.put("transaction_details", Base64.encodeBytes(CA.TQ(transactionRegisterEntry.sw())));
            contentValues.put("completion_data", Base64.encodeBytes(CA.TQ(transactionRegisterEntry.De())));
            contentValues.put("result", String.valueOf((Object)transactionRegisterEntry.Pb()));
            contentValues.put("closed", Boolean.valueOf(transactionRegisterEntry.Ut()));
            contentValues.put("terminal_id", transactionRegisterEntry.og());
            contentValues.put("transaction_key", transactionRegisterEntry.Fp());
            contentValues.put("linked_refunds", transactionRegisterEntry.fG());
            contentValues.put("date_time", transactionRegisterEntry.cL());
            if (transactionRegisterEntry.TQ() != null) {
                contentValues.put("completion_state", String.valueOf((Object)transactionRegisterEntry.TQ()));
                contentValues.put("completion_state_date_time", transactionRegisterEntry.EL());
            }
            if ((l = this.Fp.insert("transaction_register", null, contentValues)) == -1L) {
                throw new ChipDnaMobileException(ChipDnaMobileErrorCode.FailedToWrite);
            }
            OfflineQueueEntry offlineQueueEntry = transactionRegisterEntry.tA();
            if (offlineQueueEntry != null) {
                offlineQueueEntry.EL(l);
                if (offlineQueueEntry.TQ() > 0L) {
                    object = new ContentValues();
                    object.put("state", offlineQueueEntry.rE().toString());
                    object.put("register_id", Long.valueOf(offlineQueueEntry.VT()));
                    long l2 = this.Fp.update("offline_queue", (ContentValues)object, "id=?", new String[]{"" + offlineQueueEntry.TQ()});
                    if (l2 == -1L) {
                        throw new ChipDnaMobileException(ChipDnaMobileErrorCode.FailedToWrite);
                    }
                } else {
                    object = this.TQ(offlineQueueEntry);
                    transactionRegisterEntry.TQ((OfflineQueueEntry)object);
                }
            }
            this.Fp.setTransactionSuccessful();
            object = transactionRegisterEntry;
            return object;
        }
        finally {
            this.Fp.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TransactionRegisterEntry EL(TransactionRegisterEntry transactionRegisterEntry) throws ChipDnaMobileException {
        this.Fp.beginTransaction();
        try {
            long l;
            ContentValues contentValues = new ContentValues();
            if (transactionRegisterEntry.dY() != null) {
                contentValues.put("user_reference", transactionRegisterEntry.dY());
            }
            contentValues.put("amount", transactionRegisterEntry.rE());
            contentValues.put("gratuity", transactionRegisterEntry.dR());
            contentValues.put("environment", transactionRegisterEntry.NE());
            contentValues.put("currency", CA.TQ(transactionRegisterEntry.dC()));
            contentValues.put("state", String.valueOf((Object)transactionRegisterEntry.VT()));
            contentValues.put("transaction_type", String.valueOf((Object)transactionRegisterEntry.uq()));
            contentValues.put("transaction_details", Base64.encodeBytes(CA.TQ(transactionRegisterEntry.sw())));
            if (transactionRegisterEntry.cL() != null) {
                contentValues.put("date_time", transactionRegisterEntry.cL());
            }
            if (transactionRegisterEntry.De() != null) {
                contentValues.put("completion_data", Base64.encodeBytes(CA.TQ(transactionRegisterEntry.De())));
            } else {
                contentValues.putNull("completion_data");
            }
            contentValues.put("result", String.valueOf((Object)transactionRegisterEntry.Pb()));
            contentValues.put("closed", Boolean.valueOf(transactionRegisterEntry.Ut()));
            contentValues.put("terminal_id", transactionRegisterEntry.og());
            contentValues.put("transaction_key", transactionRegisterEntry.Fp());
            if (transactionRegisterEntry.fG() != null) {
                contentValues.put("linked_refunds", transactionRegisterEntry.fG());
            } else {
                contentValues.putNull("linked_refunds");
            }
            if (transactionRegisterEntry.TQ() != null) {
                contentValues.put("completion_state", String.valueOf((Object)transactionRegisterEntry.TQ()));
                contentValues.put("completion_state_date_time", transactionRegisterEntry.EL());
            }
            if ((l = (long)this.Fp.update("transaction_register", contentValues, "id=?", new String[]{"" + transactionRegisterEntry.zv()})) == -1L) {
                throw new ChipDnaMobileException(ChipDnaMobileErrorCode.FailedToWrite);
            }
            OfflineQueueEntry offlineQueueEntry = transactionRegisterEntry.tA();
            if (offlineQueueEntry != null) {
                offlineQueueEntry.EL(transactionRegisterEntry.zv());
                offlineQueueEntry = offlineQueueEntry.TQ() > 0L ? this.EL(offlineQueueEntry) : this.TQ(offlineQueueEntry);
                transactionRegisterEntry.TQ(offlineQueueEntry);
            }
            this.Fp.setTransactionSuccessful();
            TransactionRegisterEntry transactionRegisterEntry2 = transactionRegisterEntry;
            return transactionRegisterEntry2;
        }
        finally {
            this.Fp.endTransaction();
        }
    }

    TransactionRegisterEntry zv(String string) throws ChipDnaMobileException {
        Cursor cursor = this.Fp.query("transaction_register", new String[]{"id", "user_reference", "amount", "gratuity", "environment", "currency", "state", "transaction_type", "transaction_details", "completion_data", "result", "closed", "terminal_id", "transaction_key", "linked_refunds", "date_time", "completion_state", "completion_state_date_time"}, String.format("%s=? AND %s != ?", "user_reference", "result"), new String[]{string, TransactionRegisterEntry.TransactionResult.Declined.name()}, null, null, String.format("%s Collate NOCASE DESC", "date_time"));
        return this.TQ(cursor);
    }

    TransactionRegisterEntry dY(String string) throws ChipDnaMobileException {
        Cursor cursor = this.Fp.query("transaction_register", new String[]{"id", "user_reference", "amount", "gratuity", "environment", "currency", "state", "transaction_type", "transaction_details", "completion_data", "result", "closed", "terminal_id", "transaction_key", "linked_refunds", "date_time", "completion_state", "completion_state_date_time"}, String.format("%s=?", "user_reference"), new String[]{string}, null, null, String.format("%s Collate NOCASE DESC", "date_time"));
        return this.TQ(cursor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TransactionRegisterEntry TQ(Cursor cursor) throws ChipDnaMobileException {
        if (cursor == null) {
            throw new ChipDnaMobileException(ChipDnaMobileErrorCode.FailedToRead);
        }
        try {
            Object object;
            TransactionRegisterEntry transactionRegisterEntry = null;
            if (cursor.moveToFirst()) {
                String string;
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                Object object6;
                String string2;
                transactionRegisterEntry = new TransactionRegisterEntry();
                transactionRegisterEntry.TQ(cursor.getLong(cursor.getColumnIndex("id")));
                transactionRegisterEntry.cL(cursor.getString(cursor.getColumnIndex("user_reference")));
                transactionRegisterEntry.zv(cursor.getString(cursor.getColumnIndex("amount")));
                transactionRegisterEntry.dY(cursor.getString(cursor.getColumnIndex("gratuity")));
                transactionRegisterEntry.rE(cursor.getString(cursor.getColumnIndex("environment")));
                transactionRegisterEntry.dR(cursor.getString(cursor.getColumnIndex("terminal_id")));
                transactionRegisterEntry.NE(cursor.getString(cursor.getColumnIndex("transaction_key")));
                transactionRegisterEntry.dC(cursor.getString(cursor.getColumnIndex("linked_refunds")));
                transactionRegisterEntry.EL(cursor.getString(cursor.getColumnIndex("date_time")));
                object = cursor.getString(cursor.getColumnIndex("currency"));
                if (object != null && ((String)object).length() > 0) {
                    transactionRegisterEntry.TQ(CA.dR((String)object));
                }
                if ((string2 = cursor.getString(cursor.getColumnIndex("state"))) != null && string2.length() > 0) {
                    object6 = Enum.valueOf(TransactionRegisterEntry.TransactionState.class, string2);
                    transactionRegisterEntry.TQ((TransactionRegisterEntry.TransactionState)((Object)object6));
                }
                if ((object6 = cursor.getString(cursor.getColumnIndex("transaction_type"))) != null && ((String)object6).length() > 0) {
                    object5 = Enum.valueOf(TransactionRegisterEntry.TransactionType.class, (String)object6);
                    transactionRegisterEntry.TQ((TransactionRegisterEntry.TransactionType)((Object)object5));
                }
                if ((object5 = cursor.getString(cursor.getColumnIndex("transaction_details"))) != null && ((String)object5).length() > 0) {
                    try {
                        object4 = CA.TQ(Base64.decode((String)object5));
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        throw new ChipDnaMobileException(ChipDnaMobileErrorCode.FailedToRead);
                    }
                    transactionRegisterEntry.TQ((TransactionDetails)object4);
                }
                if ((object4 = cursor.getString(cursor.getColumnIndex("completion_data"))) != null && ((String)object4).length() > 0) {
                    try {
                        object3 = CA.TQ(Base64.decode((String)object4));
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        throw new ChipDnaMobileException(ChipDnaMobileErrorCode.FailedToRead);
                    }
                    transactionRegisterEntry.TQ((CompletionDetails)object3);
                }
                if ((object3 = cursor.getString(cursor.getColumnIndex("result"))) != null && ((String)object3).length() > 0) {
                    object2 = Enum.valueOf(TransactionRegisterEntry.TransactionResult.class, (String)object3);
                    transactionRegisterEntry.TQ((TransactionRegisterEntry.TransactionResult)((Object)object2));
                }
                if ((object2 = cursor.getString(cursor.getColumnIndex("closed"))) != null && ((String)object2).length() > 0) {
                    transactionRegisterEntry.TQ(((String)object2).equals("1"));
                }
                if ((string = cursor.getString(cursor.getColumnIndex("completion_state"))) != null && string.length() > 0) {
                    transactionRegisterEntry.TQ(Enum.valueOf(TransactionRegisterEntry.CompletionState.class, string));
                    transactionRegisterEntry.TQ(cursor.getString(cursor.getColumnIndex("completion_state_date_time")));
                }
                transactionRegisterEntry.TQ(this.TQ(transactionRegisterEntry.zv()));
            }
            object = transactionRegisterEntry;
            return object;
        }
        finally {
            cursor.close();
        }
    }

    long dR() throws ChipDnaMobileException {
        return this.EL(OfflineQueueEntry.OfflineRequestState.Pending);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long EL(OfflineQueueEntry.OfflineRequestState offlineRequestState) throws ChipDnaMobileException {
        String string = String.format("SELECT reg_tab.%1$s, reg_tab.%2$s FROM %3$s AS reg_tab INNER JOIN %4$s oq_tab ON reg_tab.%5$s=oq_tab.%6$s WHERE oq_tab.%7$s=? AND oq_tab.%8$s!=? AND oq_tab.%8$s!=? AND reg_tab.%9$s!=?;", "amount", "gratuity", "transaction_register", "offline_queue", "user_reference", "user_reference", "state", "type", "result");
        Cursor cursor = this.Fp.rawQuery(string, new String[]{offlineRequestState.name(), OfflineRequest.OfflineRequestType.RecoveryVoid.name(), OfflineRequest.OfflineRequestType.DeviceEvent.name(), TransactionResultEnum.Declined.name()});
        if (cursor == null) {
            throw new ChipDnaMobileException(ChipDnaMobileErrorCode.FailedToRead);
        }
        try {
            long l = 0L;
            if (cursor.moveToFirst()) {
                do {
                    String string2 = cursor.getString(cursor.getColumnIndex("amount"));
                    String string3 = cursor.getString(cursor.getColumnIndex("gratuity"));
                    l += Long.parseLong(string2) + Long.parseLong(string3);
                } while (cursor.moveToNext());
            }
            long l2 = l;
            return l2;
        }
        finally {
            cursor.close();
        }
    }

    long NE() throws ChipDnaMobileException {
        return this.cL(OfflineQueueEntry.OfflineRequestState.Pending);
    }

    long cL(OfflineQueueEntry.OfflineRequestState offlineRequestState) throws ChipDnaMobileException {
        long l = DatabaseUtils.longForQuery((SQLiteDatabase)this.Fp, (String)"SELECT count(*) FROM offline_queue WHERE state=? AND type!=? AND type!=?;", (String[])new String[]{String.valueOf((Object)offlineRequestState), String.valueOf((Object)OfflineRequest.OfflineRequestType.RecoveryVoid), String.valueOf((Object)OfflineRequest.OfflineRequestType.DeviceEvent)});
        if (l == -1L) {
            throw new ChipDnaMobileException(ChipDnaMobileErrorCode.FailedToRead);
        }
        return l;
    }

    String dC() throws ChipDnaMobileException {
        Cursor cursor = this.Fp.rawQuery("SELECT date_time FROM offline_queue WHERE state=? AND type!=? AND type!=? ORDER BY date_time Collate NOCASE", new String[]{String.valueOf((Object)OfflineQueueEntry.OfflineRequestState.Pending), String.valueOf((Object)OfflineRequest.OfflineRequestType.RecoveryVoid), String.valueOf((Object)OfflineRequest.OfflineRequestType.DeviceEvent)});
        if (cursor == null) {
            throw new ChipDnaMobileException(ChipDnaMobileErrorCode.FailedToRead);
        }
        String string = null;
        try {
            if (cursor.moveToFirst()) {
                string = cursor.getString(cursor.getColumnIndex("date_time"));
            }
        }
        finally {
            cursor.close();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HashMap<OfflineRequest.CEMOfflineRequestType, Long> zv(OfflineQueueEntry.OfflineRequestState offlineRequestState) throws ChipDnaMobileException {
        String string = String.format("SELECT reg_tab.%1$s, oq_tab.%2$s FROM %3$s AS reg_tab INNER JOIN %4$s oq_tab ON reg_tab.%5$s=oq_tab.%6$s WHERE oq_tab.%7$s=? AND oq_tab.%8$s!=? AND oq_tab.%8$s!=? AND reg_tab.%9$s!=?;", "transaction_type", "type", "transaction_register", "offline_queue", "user_reference", "user_reference", "state", "type", "result");
        Cursor cursor = this.Fp.rawQuery(string, new String[]{String.valueOf((Object)offlineRequestState), OfflineRequest.OfflineRequestType.RecoveryVoid.name(), OfflineRequest.OfflineRequestType.DeviceEvent.name(), TransactionResultEnum.Declined.name()});
        if (cursor == null) {
            throw new ChipDnaMobileException(ChipDnaMobileErrorCode.FailedToRead);
        }
        try {
            Object object;
            HashMap<OfflineRequest.CEMOfflineRequestType, Long> hashMap = new HashMap<OfflineRequest.CEMOfflineRequestType, Long>();
            long l = 0L;
            long l2 = 0L;
            long l3 = 0L;
            long l4 = 0L;
            long l5 = 0L;
            long l6 = 0L;
            if (cursor.moveToFirst()) {
                do {
                    object = cursor.getString(cursor.getColumnIndex("transaction_type"));
                    TransactionRegisterEntry.TransactionType transactionType = Enum.valueOf(TransactionRegisterEntry.TransactionType.class, (String)object);
                    String string2 = cursor.getString(cursor.getColumnIndex("type"));
                    OfflineRequest.OfflineRequestType offlineRequestType = Enum.valueOf(OfflineRequest.OfflineRequestType.class, string2);
                    if (transactionType == TransactionRegisterEntry.TransactionType.Sale) {
                        switch (offlineRequestType) {
                            case DeferredAuth: 
                            case Offline: {
                                ++l;
                                break;
                            }
                            case Conf: {
                                ++l2;
                                break;
                            }
                            case Void: {
                                ++l3;
                                break;
                            }
                        }
                        continue;
                    }
                    if (transactionType != TransactionRegisterEntry.TransactionType.Refund) continue;
                    switch (offlineRequestType) {
                        case DeferredAuth: 
                        case Refund: {
                            ++l4;
                            break;
                        }
                        case Conf: {
                            ++l5;
                            break;
                        }
                        case Void: {
                            ++l6;
                            break;
                        }
                    }
                } while (cursor.moveToNext());
            }
            hashMap.put(OfflineRequest.CEMOfflineRequestType.Sale, l);
            hashMap.put(OfflineRequest.CEMOfflineRequestType.SaleConf, l2);
            hashMap.put(OfflineRequest.CEMOfflineRequestType.SaleVoid, l3);
            hashMap.put(OfflineRequest.CEMOfflineRequestType.Refund, l4);
            hashMap.put(OfflineRequest.CEMOfflineRequestType.RefundConf, l5);
            hashMap.put(OfflineRequest.CEMOfflineRequestType.RefundVoid, l6);
            object = hashMap;
            return object;
        }
        finally {
            cursor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HashMap<OfflineRequest.CEMOfflineRequestType, Long> dY(OfflineQueueEntry.OfflineRequestState offlineRequestState) throws ChipDnaMobileException {
        String string = String.format("SELECT reg_tab.%1$s, reg_tab.%2$s, reg_tab.%3$s, oq_tab.%4$s FROM %5$s AS reg_tab INNER JOIN %6$s oq_tab ON reg_tab.%7$s=oq_tab.%8$s WHERE oq_tab.%9$s=? AND oq_tab.%10$s!=? AND oq_tab.%10$s!=? AND reg_tab.%11$s!=?;", "amount", "gratuity", "transaction_type", "type", "transaction_register", "offline_queue", "user_reference", "user_reference", "state", "type", "result");
        Cursor cursor = this.Fp.rawQuery(string, new String[]{String.valueOf((Object)offlineRequestState), OfflineRequest.OfflineRequestType.RecoveryVoid.name(), OfflineRequest.OfflineRequestType.DeviceEvent.name(), TransactionResultEnum.Declined.name()});
        if (cursor == null) {
            throw new ChipDnaMobileException(ChipDnaMobileErrorCode.FailedToRead);
        }
        try {
            Object object;
            HashMap<OfflineRequest.CEMOfflineRequestType, Long> hashMap = new HashMap<OfflineRequest.CEMOfflineRequestType, Long>();
            long l = 0L;
            long l2 = 0L;
            long l3 = 0L;
            long l4 = 0L;
            long l5 = 0L;
            long l6 = 0L;
            if (cursor.moveToFirst()) {
                do {
                    object = cursor.getString(cursor.getColumnIndex("amount"));
                    String string2 = cursor.getString(cursor.getColumnIndex("gratuity"));
                    String string3 = cursor.getString(cursor.getColumnIndex("transaction_type"));
                    TransactionRegisterEntry.TransactionType transactionType = Enum.valueOf(TransactionRegisterEntry.TransactionType.class, string3);
                    String string4 = cursor.getString(cursor.getColumnIndex("type"));
                    OfflineRequest.OfflineRequestType offlineRequestType = Enum.valueOf(OfflineRequest.OfflineRequestType.class, string4);
                    if (transactionType == TransactionRegisterEntry.TransactionType.Sale) {
                        switch (offlineRequestType) {
                            case DeferredAuth: 
                            case Offline: {
                                l += Long.parseLong((String)object) + Long.parseLong(string2);
                                break;
                            }
                            case Conf: {
                                l2 += Long.parseLong((String)object) + Long.parseLong(string2);
                                break;
                            }
                            case Void: {
                                l3 += Long.parseLong((String)object) + Long.parseLong(string2);
                                break;
                            }
                        }
                        continue;
                    }
                    if (transactionType != TransactionRegisterEntry.TransactionType.Refund) continue;
                    switch (offlineRequestType) {
                        case DeferredAuth: 
                        case Refund: {
                            l4 += Long.parseLong((String)object) + Long.parseLong(string2);
                            break;
                        }
                        case Conf: {
                            l5 += Long.parseLong((String)object) + Long.parseLong(string2);
                            break;
                        }
                        case Void: {
                            l6 += Long.parseLong((String)object) + Long.parseLong(string2);
                            break;
                        }
                    }
                } while (cursor.moveToNext());
            }
            hashMap.put(OfflineRequest.CEMOfflineRequestType.Sale, l);
            hashMap.put(OfflineRequest.CEMOfflineRequestType.SaleConf, l2);
            hashMap.put(OfflineRequest.CEMOfflineRequestType.SaleVoid, l3);
            hashMap.put(OfflineRequest.CEMOfflineRequestType.Refund, l4);
            hashMap.put(OfflineRequest.CEMOfflineRequestType.RefundConf, l5);
            hashMap.put(OfflineRequest.CEMOfflineRequestType.RefundVoid, l6);
            object = hashMap;
            return object;
        }
        finally {
            cursor.close();
        }
    }

    private List<OfflineTransactionRecord> VT(SQLiteDatabase sQLiteDatabase) throws ChipDnaMobileException {
        Cursor cursor = sQLiteDatabase.query("offline_records", new String[]{"guid", "date_and_time", "last_retry_date_and_time", "server_url", "server_timeout", "request_xml", "amount", "gratuity", "reference", "type", "auth_type", "error_codes", "scope", "linked_card_ease_ref", "state", "live_mode"}, null, null, null, null, null);
        if (cursor == null) {
            throw new ChipDnaMobileException(ChipDnaMobileErrorCode.FailedToRead);
        }
        ArrayList<OfflineTransactionRecord> arrayList = new ArrayList<OfflineTransactionRecord>();
        if (cursor.moveToFirst()) {
            do {
                int n = cursor.getInt(cursor.getColumnIndex("guid"));
                String string = cursor.getString(cursor.getColumnIndex("date_and_time"));
                String string2 = cursor.getString(cursor.getColumnIndex("last_retry_date_and_time"));
                String string3 = cursor.getString(cursor.getColumnIndex("server_url"));
                String string4 = cursor.getString(cursor.getColumnIndex("server_timeout"));
                int n2 = Integer.parseInt(string4);
                String string5 = cursor.getString(cursor.getColumnIndex("request_xml"));
                String string6 = cursor.getString(cursor.getColumnIndex("amount"));
                String string7 = cursor.getString(cursor.getColumnIndex("gratuity"));
                String string8 = cursor.getString(cursor.getColumnIndex("reference"));
                String string9 = cursor.getString(cursor.getColumnIndex("type"));
                OfflineTransactionRecord.AuthType authType = Enum.valueOf(OfflineTransactionRecord.AuthType.class, cursor.getString(cursor.getColumnIndex("auth_type")));
                CCInternalOfflineRequestType cCInternalOfflineRequestType = Enum.valueOf(CCInternalOfflineRequestType.class, string9);
                String string10 = cursor.getString(cursor.getColumnIndex("error_codes"));
                String string11 = cursor.getString(cursor.getColumnIndex("scope"));
                OfflineTransactionRecord.Scope scope = Enum.valueOf(OfflineTransactionRecord.Scope.class, string11);
                String string12 = cursor.getString(cursor.getColumnIndex("linked_card_ease_ref"));
                String string13 = cursor.getString(cursor.getColumnIndex("state"));
                OfflineRequest.CEMOfflineRequestState cEMOfflineRequestState = Enum.valueOf(OfflineRequest.CEMOfflineRequestState.class, string13);
                String string14 = cursor.getString(cursor.getColumnIndex("live_mode"));
                OfflineTransactionRecord offlineTransactionRecord = new OfflineTransactionRecord(string, string6, string7, string8, string3, n2, cCInternalOfflineRequestType, cEMOfflineRequestState, string5, authType, scope, string12);
                offlineTransactionRecord.TQ(n);
                offlineTransactionRecord.TQ(string2);
                offlineTransactionRecord.EL(string10);
                offlineTransactionRecord.TQ("YES".equalsIgnoreCase(string14));
                arrayList.add(offlineTransactionRecord);
            } while (cursor.moveToNext());
        }
        cursor.close();
        return arrayList;
    }

    private List<mE> uq(SQLiteDatabase sQLiteDatabase) throws ChipDnaMobileException {
        Cursor cursor = sQLiteDatabase.query("device_event_records", new String[]{"guid", "date_and_time", "last_retry_date_and_time", "server_url", "server_timeout", "request_xml", "error_codes", "state"}, null, null, null, null, null);
        if (cursor == null) {
            throw new ChipDnaMobileException(ChipDnaMobileErrorCode.FailedToRead);
        }
        ArrayList<mE> arrayList = new ArrayList<mE>();
        if (cursor.moveToFirst()) {
            do {
                int n = cursor.getInt(cursor.getColumnIndex("guid"));
                String string = cursor.getString(cursor.getColumnIndex("date_and_time"));
                String string2 = cursor.getString(cursor.getColumnIndex("last_retry_date_and_time"));
                String string3 = cursor.getString(cursor.getColumnIndex("server_url"));
                String string4 = cursor.getString(cursor.getColumnIndex("server_timeout"));
                int n2 = Integer.parseInt(string4);
                String string5 = cursor.getString(cursor.getColumnIndex("request_xml"));
                String string6 = cursor.getString(cursor.getColumnIndex("error_codes"));
                String string7 = cursor.getString(cursor.getColumnIndex("state"));
                OfflineRequest.CEMOfflineRequestState cEMOfflineRequestState = Enum.valueOf(OfflineRequest.CEMOfflineRequestState.class, string7);
                mE mE2 = new mE(string5, string, string3, n2, cEMOfflineRequestState);
                mE2.TQ(n);
                mE2.TQ(string2);
                mE2.EL(string6);
                arrayList.add(mE2);
            } while (cursor.moveToNext());
        }
        cursor.close();
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FirmwareUpdateRequest TQ(FirmwareUpdateRequest firmwareUpdateRequest) throws ChipDnaMobileException {
        this.Fp.beginTransaction();
        try {
            ContentValues contentValues = new ContentValues();
            contentValues.put("device_id", firmwareUpdateRequest.getDeviceID());
            contentValues.put("update_available_date", firmwareUpdateRequest.getUpdateAvailableDate());
            contentValues.put("update_required", firmwareUpdateRequest.getUpdateRequired() ? "true" : "false");
            contentValues.put("update_incomplete", firmwareUpdateRequest.getUpdateIncomplete() ? "true" : "false");
            contentValues.put("update_complete", firmwareUpdateRequest.getUpdateComplete() ? "true" : "false");
            contentValues.put("last_attempted_update_time", firmwareUpdateRequest.getLastAttemptedDateTime());
            contentValues.put("last_successful_update_time", firmwareUpdateRequest.getLastSuccessfulDateTime());
            contentValues.put("files_to_update", firmwareUpdateRequest.getFileRequiringUpdate());
            contentValues.put("time_frame", Integer.valueOf(firmwareUpdateRequest.getTimeFrame()));
            long l = this.Fp.insert("firmware_properties", null, contentValues);
            if (l == -1L) {
                throw new ChipDnaMobileException(ChipDnaMobileErrorCode.FailedToWrite);
            }
            this.Fp.setTransactionSuccessful();
            FirmwareUpdateRequest firmwareUpdateRequest2 = firmwareUpdateRequest;
            return firmwareUpdateRequest2;
        }
        finally {
            this.Fp.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FirmwareUpdateRequest rE(String string) throws ChipDnaMobileException {
        Cursor cursor = this.Fp.query("firmware_properties", new String[]{"device_id", "update_available_date", "update_required", "update_incomplete", "update_complete", "last_attempted_update_time", "last_successful_update_time", "files_to_update", "time_frame"}, String.format("%s=?", "device_id"), new String[]{String.valueOf(string)}, null, null, null);
        if (cursor == null) {
            throw new ChipDnaMobileException(ChipDnaMobileErrorCode.FailedToRead);
        }
        try {
            FirmwareUpdateRequest firmwareUpdateRequest = null;
            if (cursor.moveToFirst()) {
                firmwareUpdateRequest = new FirmwareUpdateRequest(cursor.getString(cursor.getColumnIndex("device_id")), cursor.getString(cursor.getColumnIndex("update_available_date")), cursor.getString(cursor.getColumnIndex("update_required")).equals("true"), cursor.getString(cursor.getColumnIndex("update_incomplete")).equals("true"), cursor.getString(cursor.getColumnIndex("update_complete")).equals("true"), cursor.getString(cursor.getColumnIndex("last_attempted_update_time")), cursor.getString(cursor.getColumnIndex("last_successful_update_time")), cursor.getString(cursor.getColumnIndex("files_to_update")), cursor.getInt(cursor.getColumnIndex("time_frame")));
            }
            FirmwareUpdateRequest firmwareUpdateRequest2 = firmwareUpdateRequest;
            return firmwareUpdateRequest2;
        }
        finally {
            cursor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FirmwareUpdateRequest TQ(SQLiteDatabase sQLiteDatabase, FirmwareUpdateRequest firmwareUpdateRequest) throws ChipDnaMobileException {
        sQLiteDatabase.beginTransaction();
        try {
            ContentValues contentValues = new ContentValues();
            contentValues.put("device_id", firmwareUpdateRequest.getDeviceID());
            contentValues.put("update_available_date", firmwareUpdateRequest.getUpdateAvailableDate());
            contentValues.put("update_required", firmwareUpdateRequest.getUpdateRequired() ? "true" : "false");
            contentValues.put("update_incomplete", firmwareUpdateRequest.getUpdateIncomplete() ? "true" : "false");
            contentValues.put("update_complete", firmwareUpdateRequest.getUpdateComplete() ? "true" : "false");
            contentValues.put("last_attempted_update_time", firmwareUpdateRequest.getLastAttemptedDateTime());
            contentValues.put("last_successful_update_time", firmwareUpdateRequest.getLastSuccessfulDateTime());
            contentValues.put("files_to_update", firmwareUpdateRequest.getFileRequiringUpdate());
            contentValues.put("time_frame", Integer.valueOf(firmwareUpdateRequest.getTimeFrame()));
            long l = sQLiteDatabase.update("firmware_properties", contentValues, "device_id=?", new String[]{"" + firmwareUpdateRequest.getDeviceID()});
            if (l == -1L) {
                throw new ChipDnaMobileException(ChipDnaMobileErrorCode.FailedToWrite);
            }
            sQLiteDatabase.setTransactionSuccessful();
            FirmwareUpdateRequest firmwareUpdateRequest2 = firmwareUpdateRequest;
            return firmwareUpdateRequest2;
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
    }

    FirmwareUpdateRequest EL(FirmwareUpdateRequest firmwareUpdateRequest) throws ChipDnaMobileException {
        return this.TQ(this.Fp, firmwareUpdateRequest);
    }

    void cL(FirmwareUpdateRequest firmwareUpdateRequest) throws ChipDnaMobileException {
        long l = this.Fp.delete("firmware_properties", "device_id=?", new String[]{"" + firmwareUpdateRequest.getDeviceID()});
        if (l == -1L) {
            throw new ChipDnaMobileException(ChipDnaMobileErrorCode.FailedToWrite);
        }
    }

    static class rE
    extends SQLiteOpenHelper {
        private String TQ;
        private String EL;

        rE(String string, String string2, int n, Context context) throws ChipDnaMobileException {
            super(context, string, null, n);
            this.TQ = string2;
            this.EL = string;
            try {
                SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
                sQLiteDatabase.setVersion(n);
                sQLiteDatabase.close();
            }
            catch (SQLException sQLException) {
                throw new ChipDnaMobileException(ChipDnaMobileErrorCode.FailedToMigrate);
            }
        }

        public SQLiteDatabase getWritableDatabase() {
            return SQLiteDatabase.openDatabase((String)this.EL, (String)this.TQ, null, (int)0x10000000, null);
        }

        public void onCreate(SQLiteDatabase arg0) {
        }

        public void onUpgrade(SQLiteDatabase arg0, int arg1, int arg2) {
        }
    }

    class zv {
        static final String TQ = "properties";
        static final String EL = "tms_properties";
        static final String cL = "firmware_properties";
        static final String zv = "transaction_data";
        static final String dY = "transaction_details";
        private static final String dR = "files";
        private static final String NE = "offline_records";
        private static final String dC = "device_event_records";
        private static final String VT = "transaction_register";
        private static final String uq = "offline_queue";

        zv() {
        }
    }

    private class cL {
        private static final String EL = "guid";
        private static final String cL = "date_and_time";
        private static final String zv = "last_retry_date_and_time";
        private static final String dY = "server_url";
        private static final String rE = "server_timeout";
        private static final String dR = "request_xml";
        private static final String NE = "state";
        private static final String dC = "type";
        private static final String VT = "auth_type";
        private static final String uq = "error_codes";
        private static final String sw = "amount";
        private static final String De = "gratuity";
        private static final String tA = "reference";
        private static final String Pb = "live_mode";
        private static final String Ut = "scope";
        private static final String og = "linked_card_ease_ref";

        private cL() {
        }
    }

    private class dY {
        private static final String EL = "id";
        private static final String cL = "user_reference";
        private static final String zv = "amount";
        private static final String dY = "gratuity";
        private static final String rE = "environment";
        private static final String dR = "currency";
        private static final String NE = "state";
        private static final String dC = "transaction_type";
        private static final String VT = "transaction_details";
        private static final String uq = "completion_data";
        private static final String sw = "result";
        private static final String De = "closed";
        private static final String tA = "terminal_id";
        private static final String Pb = "transaction_key";
        private static final String Ut = "linked_refunds";
        private static final String og = "date_time";
        private static final String Fp = "completion_state";
        private static final String Gf = "completion_state_date_time";

        private dY() {
        }
    }

    private class EL {
        private static final String EL = "id";
        private static final String cL = "date_time";
        private static final String zv = "last_retry";
        private static final String dY = "server_url";
        private static final String rE = "server_timeout";
        private static final String dR = "request_xml";
        private static final String NE = "state";
        private static final String dC = "errors";
        private static final String VT = "type";
        private static final String uq = "register_id";
        private static final String sw = "user_reference";

        private EL() {
        }
    }

    private class TQ {
        private static final String EL = "device_id";
        private static final String cL = "update_available_date";
        private static final String zv = "update_required";
        private static final String dY = "update_incomplete";
        private static final String rE = "update_complete";
        private static final String dR = "last_attempted_update_time";
        private static final String NE = "last_successful_update_time";
        private static final String dC = "time_frame";
        private static final String VT = "files_to_update";

        private TQ() {
        }
    }
}

