/*
 * Decompiled with CFR 0.152.
 */
package com.creditcall.chipdnamobile;

import android.graphics.Bitmap;
import android.hardware.usb.UsbDevice;
import com.creditcall.chipdnamobile.AbstractChipDnaMobileErrorCode;
import com.creditcall.chipdnamobile.CA;
import com.creditcall.chipdnamobile.ChipDnaMobileErrorCode;
import com.creditcall.chipdnamobile.ChipDnaMobileException;
import com.creditcall.chipdnamobile.ChipDnaMobileFormatException;
import com.creditcall.chipdnamobile.ChipDnaMobileProperties;
import com.creditcall.chipdnamobile.ConfigurationErrorCode;
import com.creditcall.chipdnamobile.Currency;
import com.creditcall.chipdnamobile.Hk;
import com.creditcall.chipdnamobile.Parameter;
import com.creditcall.chipdnamobile.Parameters;
import com.creditcall.chipdnamobile.PaymentMethod;
import com.creditcall.chipdnamobile.RH;
import com.creditcall.chipdnamobile.Signature;
import com.creditcall.chipdnamobile.TerminalConfigurationApplication;
import com.creditcall.chipdnamobile.TransactionErrorCode;
import com.creditcall.chipdnamobile.TransactionException;
import com.creditcall.chipdnamobile.TransactionRegisterEntry;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;

public class ChipDnaMobileUtils {
    private ChipDnaMobileUtils() {
    }

    public static boolean isValidPhoneNumber(String phoneNumber) {
        return phoneNumber != null && phoneNumber.length() != 0 && phoneNumber.matches("^\\+?\\d+$");
    }

    public static boolean isValidEmailAddress(String emailAddress) {
        String[] stringArray;
        if (emailAddress == null) {
            return false;
        }
        if (emailAddress.length() == 0) {
            return false;
        }
        if (emailAddress.matches("[\\x00-\\x1F\\x7F-\\xFF]")) {
            return false;
        }
        if (!emailAddress.matches("^[^@]{1,64}@[^@]{1,255}$")) {
            return false;
        }
        String[] stringArray2 = emailAddress.split("@");
        for (String string : stringArray = stringArray2[0].split("\\.")) {
            if (string.matches("^(([A-Za-z0-9!#$%&'*+\\/=?^_`{|}~-]+)|(\"[^\"]+\"))$")) continue;
            return false;
        }
        if (stringArray2[1].matches("^(25[0-5]|2[0-4]\\d|[01]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[01]?\\d?\\d)){3}$") || stringArray2[1].matches("^\\[(25[0-5]|2[0-4]\\d|[01]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[01]?\\d?\\d)){3}\\]$")) {
            return true;
        }
        String[] stringArray3 = stringArray2[1].split("\\.");
        if (stringArray3.length < 2) {
            return false;
        }
        for (String string : stringArray3) {
            if (string.matches("^(([A-Za-z0-9][A-Za-z0-9-]{0,61}[A-Za-z0-9])|([A-Za-z0-9]))$")) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidPassword(String password) {
        if (password.length() < 8) {
            return false;
        }
        if (password.length() > 255) {
            return false;
        }
        boolean bl = Pattern.compile("[A-Z]").matcher(password).find();
        boolean bl2 = Pattern.compile("[a-z]").matcher(password).find();
        boolean bl3 = Pattern.compile("[-!$\u00a3%^&*()_+| ~=`{}:\";'<>?,./\\\u00ac#]").matcher(password).find();
        boolean bl4 = Pattern.compile("[0-9]").matcher(password).find();
        int n = 0;
        if (bl) {
            ++n;
        }
        if (bl2) {
            ++n;
        }
        if (bl3) {
            ++n;
        }
        if (bl4) {
            ++n;
        }
        return n >= 3;
    }

    static byte[] TQ(String string) {
        int n = string.length();
        byte[] byArray = new byte[n / 2];
        char[] cArray = string.toCharArray();
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            byArray[n3] = (byte)ChipDnaMobileUtils.TQ(cArray[n2], cArray[n2 + 1]);
            n2 += 2;
            ++n3;
        }
        return byArray;
    }

    private static int TQ(char c, char c2) {
        return ChipDnaMobileUtils.TQ(ChipDnaMobileUtils.TQ((byte)c), ChipDnaMobileUtils.TQ((byte)c2));
    }

    private static int TQ(int n, int n2) {
        int n3 = n;
        int n4 = n2;
        if (n3 > 16 || n4 > 16) {
            if (n3 > 47 && n3 < 58) {
                n3 -= 48;
            } else if (n3 > 64 && n3 < 71) {
                n3 -= 55;
            } else if (n3 > 96 && n3 < 103) {
                n3 -= 87;
            }
            if (n4 > 47 && n4 < 58) {
                n4 -= 48;
            } else if (n4 > 64 && n4 < 71) {
                n4 -= 55;
            } else if (n4 > 96 && n4 < 103) {
                n4 -= 87;
            }
        }
        if (n3 > 16 || n4 > 16) {
            return 1;
        }
        int n5 = n3 << 4;
        return n5 |= n4;
    }

    private static int TQ(byte by2) {
        return by2 & 0xFF;
    }

    private static String TQ(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append((char)byArray[i]);
        }
        return stringBuffer.toString();
    }

    static String EL(String string) {
        byte[] byArray = ChipDnaMobileUtils.TQ(string);
        return ChipDnaMobileUtils.TQ(byArray);
    }

    static String TQ(HashMap<String, String> hashMap) {
        try {
            if (hashMap.isEmpty()) {
                throw new Exception("Empty TLV HashMap");
            }
            String string = "";
            for (String string2 : hashMap.keySet()) {
                int n = hashMap.get(string2).length() / 2;
                String string3 = Integer.toHexString(n);
                if (Integer.toHexString(n).length() == 1) {
                    string3 = "0" + string3;
                }
                string = string + string2 + string3 + hashMap.get(string2);
            }
            return string.toUpperCase();
        }
        catch (Exception exception) {
            return "";
        }
    }

    static String TQ(String string, char c, int n) {
        StringBuffer stringBuffer = new StringBuffer(string);
        while (stringBuffer.length() < n) {
            stringBuffer.insert(0, c);
        }
        return stringBuffer.toString();
    }

    public static boolean isValidAmount(String amount) {
        try {
            ChipDnaMobileUtils.cL(amount);
        }
        catch (TransactionException | IllegalArgumentException exception) {
            return false;
        }
        return true;
    }

    static void cL(String string) throws TransactionException {
        ChipDnaMobileUtils.TQ(string, true, true);
    }

    static void TQ(String string, boolean bl, boolean bl2, ChipDnaMobileProperties chipDnaMobileProperties) throws TransactionException {
        long l;
        if (string == null) {
            throw new TransactionException(TransactionErrorCode.AmountMissing);
        }
        if (string.length() == 0) {
            throw new TransactionException(TransactionErrorCode.AmountMissing);
        }
        try {
            l = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TransactionException(TransactionErrorCode.AmountInvalid);
        }
        if (bl && (l <= 0L || l < (long)chipDnaMobileProperties.ft())) {
            throw new TransactionException(TransactionErrorCode.AmountTooSmall);
        }
        if (bl2 && chipDnaMobileProperties.IA() > 0 && l > (long)chipDnaMobileProperties.IA()) {
            throw new TransactionException(TransactionErrorCode.AmountTooLarge);
        }
    }

    static void TQ(String string, boolean bl, boolean bl2) throws TransactionException {
        ChipDnaMobileProperties chipDnaMobileProperties = ChipDnaMobileProperties.cL();
        ChipDnaMobileUtils.TQ(string, bl, bl2, chipDnaMobileProperties);
    }

    static void zv(String string) throws TransactionException {
        long l;
        if (string == null || string.length() == 0) {
            throw new TransactionException(TransactionErrorCode.TaxAmountInvalid);
        }
        try {
            l = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TransactionException(TransactionErrorCode.TaxAmountInvalid);
        }
        if (l > 9999999L) {
            throw new TransactionException(TransactionErrorCode.TaxAmountInvalid);
        }
    }

    static void dY(String string) throws TransactionException, ChipDnaMobileException {
        if (string == null || string.length() == 0) {
            throw new TransactionException(TransactionErrorCode.UserReferenceMissing);
        }
        if (string.length() > 50) {
            throw new TransactionException(TransactionErrorCode.UserReferenceInvalid);
        }
        if (!string.equals(string.trim())) {
            throw new TransactionException(TransactionErrorCode.UserReferenceInvalid);
        }
        if (!ChipDnaMobileUtils.dR(string)) {
            throw new TransactionException(TransactionErrorCode.UserReferenceInvalid);
        }
        CA cA = CA.EL();
        TransactionRegisterEntry transactionRegisterEntry = cA.dY(string);
        if (transactionRegisterEntry != null && transactionRegisterEntry.Pb() != TransactionRegisterEntry.TransactionResult.Declined) {
            throw new TransactionException(TransactionErrorCode.UserReferenceDuplicate);
        }
    }

    static void rE(String string) throws TransactionException {
        if (string == null || string.length() == 0) {
            throw new TransactionException(TransactionErrorCode.PONumberInvalid);
        }
        if (string.length() > 50) {
            throw new TransactionException(TransactionErrorCode.PONumberInvalid);
        }
        if (!string.equals(string.trim())) {
            throw new TransactionException(TransactionErrorCode.PONumberInvalid);
        }
        if (!ChipDnaMobileUtils.dR(string)) {
            throw new TransactionException(TransactionErrorCode.PONumberInvalid);
        }
    }

    public static boolean isValidReference(String reference) {
        return reference == null || reference.length() <= 50 && reference.equals(reference.trim()) && ChipDnaMobileUtils.dR(reference);
    }

    public static boolean isValidTerminalID(String terminalId) {
        return terminalId.length() == 8 && ChipDnaMobileUtils.VT(terminalId);
    }

    public static boolean isValidTransactionKey(String transactionKey) {
        if (transactionKey.length() < 1 || transactionKey.length() > 20) {
            return false;
        }
        return !(ChipDnaMobileUtils.VT(transactionKey) ? transactionKey.length() != 16 && !ChipDnaMobileUtils.sw(transactionKey) : !ChipDnaMobileUtils.dR(transactionKey));
    }

    public static boolean isValidApiKey(String theApiKey) {
        return theApiKey.length() == 32 && ChipDnaMobileUtils.dR(theApiKey);
    }

    public static boolean isUsbMiuraDevice(UsbDevice device) {
        return RH.cL(device);
    }

    static boolean dR(String string) {
        if (string != null) {
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (c >= ' ' && c <= '~') continue;
                return false;
            }
        }
        return true;
    }

    static boolean NE(String string) {
        return string != null && string.matches("(?i)(M02[01]|BluePad-50(\\sCtls)?|CHB2[029]|CHB30|VP3350)");
    }

    static boolean dC(String string) {
        if (string != null) {
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (c >= 'a' && c <= 'z') continue;
                return false;
            }
        }
        return true;
    }

    static boolean VT(String string) {
        if (string != null) {
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (c >= '0' && c <= '9') continue;
                return false;
            }
        }
        return true;
    }

    static boolean uq(String string) {
        if (string != null) {
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (c >= '0' && c <= '9' || c == '.') continue;
                return false;
            }
        }
        return true;
    }

    static boolean sw(String string) {
        try {
            int n = 0;
            int n2 = string.length() - 1;
            int n3 = 0;
            while (n2 >= 0) {
                int n4 = Integer.parseInt(string.substring(n2, n2 + 1)) * (n3 + 1);
                n += n4 > 9 ? n4 - 9 : n4;
                --n2;
                n3 ^= 1;
            }
            return n % 10 == 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    static boolean De(String string) {
        if (string != null) {
            if (string.length() % 2 != 0) {
                return false;
            }
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (c >= '0' && c <= '9' || c >= 'A' && c <= 'F') continue;
                return false;
            }
        }
        return true;
    }

    static String tA(String string) {
        int n;
        Pattern pattern = Pattern.compile("[fF]");
        for (n = string.length(); n > 4 && pattern.matcher(string.subSequence(n - 1, n)).matches(); --n) {
        }
        return string.substring(0, n);
    }

    static void TQ(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("ChipDnaMobile::" + string2 + " operator PIN cannot be null.");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("ChipDnaMobile::" + string2 + " operator PIN cannot be empty.");
        }
        if (string.length() != 4) {
            throw new IllegalArgumentException("ChipDnaMobile::" + string2 + " operator PIN must be 4 characters long.");
        }
        if (!ChipDnaMobileUtils.VT(string)) {
            throw new IllegalArgumentException("ChipDnaMobile::" + string2 + " operator PIN contains illegal characters");
        }
    }

    static void EL(String string, String string2) throws TransactionException {
        if (!string.equals(string2)) {
            try {
                TimeUnit.SECONDS.sleep(3L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            throw new TransactionException(TransactionErrorCode.OperatorPinIncorrect);
        }
    }

    static void Pb(String string) {
        if (string == null) {
            throw new IllegalArgumentException("ChipDnaMobile::voiceReferral approved voice referral authCode cannot be null.");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("ChipDnaMobile::voiceReferral approved voice referral authCode cannot be empty.");
        }
        if (string.length() > 6) {
            throw new IllegalArgumentException("ChipDnaMobile::voiceReferral approved voice referral authCode cannot be longer than 6 characters.");
        }
        if (!ChipDnaMobileUtils.mm(string)) {
            throw new IllegalArgumentException("ChipDnaMobile::voiceReferral approved voice referral authCode contains illegal characters");
        }
    }

    private static boolean mm(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isLetterOrDigit(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    static int TQ(String string, int n) {
        BigDecimal bigDecimal = new BigDecimal(string).multiply(new BigDecimal(Hk.TQ(n)));
        return bigDecimal.intValue();
    }

    static void cL(String string, String string2) throws TransactionException {
        Date date = ChipDnaMobileUtils.Ut(string);
        Date date2 = Calendar.getInstance(Locale.getDefault()).getTime();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        if (string.length() == 4) {
            calendar.add(2, 1);
            calendar.add(5, -1);
        } else {
            calendar.add(5, 1);
            calendar.add(13, -1);
        }
        date = calendar.getTime();
        if (date2.compareTo(date) > 0 || calendar.get(1) - Calendar.getInstance().get(1) > 50) {
            throw new TransactionException(TransactionErrorCode.ExpiredCard);
        }
        if (string2 != null) {
            Date date3 = ChipDnaMobileUtils.Ut(string2);
            if (date3 == null) {
                throw new TransactionException(TransactionErrorCode.StartDateInvalid);
            }
            if (date2.compareTo(date3) < 0) {
                throw new TransactionException(TransactionErrorCode.PreValidCard);
            }
        }
    }

    static Date Ut(String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyMMdd", Locale.getDefault());
        Calendar calendar = Calendar.getInstance(Locale.getDefault());
        calendar.set(2000, calendar.get(2), 0, 0, 0, 0);
        if (string.length() == 4) {
            simpleDateFormat.applyPattern("yyMM");
        }
        simpleDateFormat.set2DigitYearStart(calendar.getTime());
        Date date = null;
        try {
            date = simpleDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            return null;
        }
        return date;
    }

    static String og(String string) {
        if (string == null) {
            return null;
        }
        String string2 = null;
        int n = string.indexOf("=");
        if (n == -1) {
            n = string.toUpperCase().indexOf("D");
        }
        if (n == -1) {
            return null;
        }
        string2 = string.substring(n + 1, n + 5);
        return string2;
    }

    static Date Fp(String string) {
        String string2 = ChipDnaMobileUtils.og(string);
        if (string2 == null) {
            return null;
        }
        return ChipDnaMobileUtils.Ut(string2);
    }

    static boolean Gf(String string) {
        if (string != null && string.length() > 2) {
            return string.charAt(0) != '2' && string.charAt(0) != '6';
        }
        return true;
    }

    static String fG(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            char c = string.charAt(n);
            if (c != '&') {
                stringBuilder.append(c);
                ++n;
                continue;
            }
            if (string.startsWith("&amp;", n)) {
                stringBuilder.append('&');
                n += 5;
                continue;
            }
            if (string.startsWith("&apos;", n)) {
                stringBuilder.append('\'');
                n += 6;
                continue;
            }
            if (string.startsWith("&quot;", n)) {
                stringBuilder.append('\"');
                n += 6;
                continue;
            }
            if (string.startsWith("&lt;", n)) {
                stringBuilder.append('<');
                n += 4;
                continue;
            }
            if (!string.startsWith("&gt;", n)) continue;
            stringBuilder.append('>');
            n += 4;
        }
        return stringBuilder.toString();
    }

    static Currency TQ(String string, Map<PaymentMethod, ArrayList<Currency>> map, PaymentMethod paymentMethod) {
        if (map == null) {
            return null;
        }
        ArrayList<Currency> arrayList = map.get((Object)paymentMethod);
        return ChipDnaMobileUtils.TQ(string, arrayList);
    }

    static Currency TQ(String string, ArrayList<Currency> arrayList) {
        if (string != null && !string.isEmpty() && arrayList != null && !arrayList.isEmpty()) {
            for (Currency currency : arrayList) {
                if (!currency.getCharCode().equalsIgnoreCase(string)) continue;
                return currency;
            }
        }
        return null;
    }

    static int lT(String string) throws ChipDnaMobileFormatException {
        try {
            if (string == null || string.length() < 2 && !ChipDnaMobileUtils.VT(string)) {
                throw new ChipDnaMobileFormatException();
            }
            char c = string.toLowerCase(Locale.US).charAt(string.length() - 1);
            int n = c == 'm' || c == 'h' || c == 'd' || c == 's' ? Integer.parseInt(string.substring(0, string.length() - 1)) : Integer.parseInt(string);
            switch (c) {
                case 'm': {
                    return n * 60;
                }
                case 'h': {
                    return n * 60 * 60;
                }
                case 'd': {
                    return n * 60 * 60 * 24;
                }
            }
            return n;
        }
        catch (Exception exception) {
            throw new ChipDnaMobileFormatException(exception);
        }
    }

    public static String getErrorsString(ArrayList<AbstractChipDnaMobileErrorCode> errorCodes) {
        String string = "";
        if (errorCodes != null && !errorCodes.isEmpty()) {
            for (AbstractChipDnaMobileErrorCode abstractChipDnaMobileErrorCode : errorCodes) {
                string = abstractChipDnaMobileErrorCode.getErrorString() + ",";
            }
        }
        return string;
    }

    public static String getSignaturePngStringFromBitmap(Bitmap signatureImage) throws ChipDnaMobileException {
        return new Signature(signatureImage).rE();
    }

    public static Bitmap processSignatureImage(Bitmap rawImage) throws ChipDnaMobileException {
        try {
            return new Signature(rawImage).TQ();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ChipDnaMobileException(ChipDnaMobileErrorCode.ProvidedSignatureInvalidFormat, (Throwable)illegalArgumentException);
        }
    }

    public static Bitmap getBitmapFromPngString(String pngString) throws ChipDnaMobileException {
        return Signature.TQ(pngString);
    }

    static ArrayList<String> TQ(Parameters parameters) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Parameter parameter : parameters.toList()) {
            if (!parameter.getKey().contains("MERCHANT_DEFINED_FIELD_") || parameter.getValue() != null && parameter.getValue().length() <= 255) continue;
            try {
                String[] stringArray = parameter.getKey().split("_");
                int n = Integer.parseInt(stringArray[3].trim());
                TransactionErrorCode transactionErrorCode = null;
                switch (n) {
                    case 1: {
                        transactionErrorCode = TransactionErrorCode.MerchantDefinedField01Invalid;
                        break;
                    }
                    case 2: {
                        transactionErrorCode = TransactionErrorCode.MerchantDefinedField02Invalid;
                        break;
                    }
                    case 3: {
                        transactionErrorCode = TransactionErrorCode.MerchantDefinedField03Invalid;
                        break;
                    }
                    case 4: {
                        transactionErrorCode = TransactionErrorCode.MerchantDefinedField04Invalid;
                        break;
                    }
                    case 5: {
                        transactionErrorCode = TransactionErrorCode.MerchantDefinedField05Invalid;
                        break;
                    }
                    case 6: {
                        transactionErrorCode = TransactionErrorCode.MerchantDefinedField06Invalid;
                        break;
                    }
                    case 7: {
                        transactionErrorCode = TransactionErrorCode.MerchantDefinedField07Invalid;
                        break;
                    }
                    case 8: {
                        transactionErrorCode = TransactionErrorCode.MerchantDefinedField08Invalid;
                        break;
                    }
                    case 9: {
                        transactionErrorCode = TransactionErrorCode.MerchantDefinedField09Invalid;
                        break;
                    }
                    case 10: {
                        transactionErrorCode = TransactionErrorCode.MerchantDefinedField10Invalid;
                        break;
                    }
                    case 11: {
                        transactionErrorCode = TransactionErrorCode.MerchantDefinedField11Invalid;
                        break;
                    }
                    case 12: {
                        transactionErrorCode = TransactionErrorCode.MerchantDefinedField12Invalid;
                        break;
                    }
                    case 13: {
                        transactionErrorCode = TransactionErrorCode.MerchantDefinedField13Invalid;
                        break;
                    }
                    case 14: {
                        transactionErrorCode = TransactionErrorCode.MerchantDefinedField14Invalid;
                        break;
                    }
                    case 15: {
                        transactionErrorCode = TransactionErrorCode.MerchantDefinedField15Invalid;
                        break;
                    }
                    case 16: {
                        transactionErrorCode = TransactionErrorCode.MerchantDefinedField16Invalid;
                        break;
                    }
                    case 17: {
                        transactionErrorCode = TransactionErrorCode.MerchantDefinedField17Invalid;
                        break;
                    }
                    case 18: {
                        transactionErrorCode = TransactionErrorCode.MerchantDefinedField18Invalid;
                        break;
                    }
                    case 19: {
                        transactionErrorCode = TransactionErrorCode.MerchantDefinedField19Invalid;
                        break;
                    }
                    case 20: {
                        transactionErrorCode = TransactionErrorCode.MerchantDefinedField20Invalid;
                        break;
                    }
                }
                if (transactionErrorCode == null) continue;
                arrayList.add(transactionErrorCode.getErrorString());
            }
            catch (Exception exception) {}
        }
        return arrayList;
    }

    static Parameters TQ(Parameters parameters, Collection<AbstractChipDnaMobileErrorCode> collection) {
        if (collection != null && !collection.isEmpty()) {
            String string = null;
            for (AbstractChipDnaMobileErrorCode abstractChipDnaMobileErrorCode : collection) {
                if (!TransactionErrorCode.GatewayRejectedTransaction.getErrorString().equalsIgnoreCase(abstractChipDnaMobileErrorCode.getErrorString()) && !ChipDnaMobileErrorCode.GatewayProcessError.getErrorString().equalsIgnoreCase(abstractChipDnaMobileErrorCode.getErrorString()) && !ChipDnaMobileErrorCode.GatewayGeneralError.getErrorString().equalsIgnoreCase(abstractChipDnaMobileErrorCode.getErrorString()) && !ConfigurationErrorCode.DeviceRegistrationFailed.getErrorString().equalsIgnoreCase(abstractChipDnaMobileErrorCode.getErrorString()) && !ChipDnaMobileErrorCode.MerchantConfigurationError.getErrorString().equalsIgnoreCase(abstractChipDnaMobileErrorCode.getErrorString()) && !ChipDnaMobileErrorCode.MissingField.getErrorString().equalsIgnoreCase(abstractChipDnaMobileErrorCode.getErrorString()) && !ChipDnaMobileErrorCode.InvalidField.getErrorString().equalsIgnoreCase(abstractChipDnaMobileErrorCode.getErrorString()) && !ChipDnaMobileErrorCode.InvalidHTTPMethod.getErrorString().equalsIgnoreCase(abstractChipDnaMobileErrorCode.getErrorString()) && !ChipDnaMobileErrorCode.AccessDenied.getErrorString().equalsIgnoreCase(abstractChipDnaMobileErrorCode.getErrorString()) && !ChipDnaMobileErrorCode.DeviceConfiguration.getErrorString().equalsIgnoreCase(abstractChipDnaMobileErrorCode.getErrorString()) && !ChipDnaMobileErrorCode.UnexpectedField.getErrorString().equalsIgnoreCase(abstractChipDnaMobileErrorCode.getErrorString()) && !ChipDnaMobileErrorCode.DataTypeError.getErrorString().equalsIgnoreCase(abstractChipDnaMobileErrorCode.getErrorString()) && !ChipDnaMobileErrorCode.ParseError.getErrorString().equalsIgnoreCase(abstractChipDnaMobileErrorCode.getErrorString()) && !ChipDnaMobileErrorCode.ServerError.getErrorString().equalsIgnoreCase(abstractChipDnaMobileErrorCode.getErrorString()) && !ChipDnaMobileErrorCode.GeneralError.getErrorString().equalsIgnoreCase(abstractChipDnaMobileErrorCode.getErrorString())) continue;
                string = abstractChipDnaMobileErrorCode.getErrorDescription();
            }
            if (string != null) {
                parameters.add("ERROR_DESCRIPTION", string);
            }
        }
        return parameters;
    }

    static boolean TQ(Date date, Date date2, Date date3, Date date4, Date date5) {
        if (date2 == null || date3 == null || date == null) {
            return false;
        }
        boolean bl = date.getTime() >= date2.getTime() && date.getTime() <= date3.getTime();
        return date4 == null && date5 == null && bl || date4 != null && date5 != null && bl && (date.getTime() < date4.getTime() || date.getTime() > date5.getTime());
    }

    static String zv(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(string.split("\\.")));
        if (arrayList.size() == 1) {
            arrayList.add(string2);
        } else {
            arrayList.add(arrayList.size() - 1, string2);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < arrayList.size(); ++i) {
            if (i == 0) {
                stringBuilder.append(arrayList.get(i));
                continue;
            }
            stringBuilder.append(String.format(".%s", arrayList.get(i)));
        }
        return stringBuilder.toString();
    }

    static ArrayList<String> EL(Parameters parameters) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Parameter parameter : parameters.toList()) {
            if (!parameter.getKey().contains("BILLING_")) continue;
            TransactionErrorCode transactionErrorCode = null;
            if (parameter.getValue() == null || parameter.getValue().length() > 255) {
                if ("BILLING_ADDRESS_1".equalsIgnoreCase(parameter.getKey())) {
                    transactionErrorCode = TransactionErrorCode.BillingAddress1Invalid;
                }
                if ("BILLING_ADDRESS_2".equalsIgnoreCase(parameter.getKey())) {
                    transactionErrorCode = TransactionErrorCode.BillingAddress2Invalid;
                }
                if ("BILLING_CITY".equalsIgnoreCase(parameter.getKey())) {
                    transactionErrorCode = TransactionErrorCode.BillingCityInvalid;
                }
                if ("BILLING_STATE".equalsIgnoreCase(parameter.getKey())) {
                    transactionErrorCode = TransactionErrorCode.BillingStateInvalid;
                }
                if ("BILLING_ZIP_CODE".equalsIgnoreCase(parameter.getKey())) {
                    transactionErrorCode = TransactionErrorCode.BillingZipCodeInvalid;
                }
                if ("BILLING_POSTAL_CODE".equalsIgnoreCase(parameter.getKey())) {
                    transactionErrorCode = TransactionErrorCode.BillingPostalCodeInvalid;
                }
                if ("BILLING_COUNTRY".equalsIgnoreCase(parameter.getKey())) {
                    transactionErrorCode = TransactionErrorCode.BillingCountryInvalid;
                }
                if ("BILLING_EMAIL_ADDRESS".equalsIgnoreCase(parameter.getKey())) {
                    transactionErrorCode = TransactionErrorCode.BillingEmailIAddressInvalid;
                }
                if ("BILLING_PHONE_NUMBER".equalsIgnoreCase(parameter.getKey())) {
                    transactionErrorCode = TransactionErrorCode.BillingPhoneNumberInvalid;
                }
            }
            if (transactionErrorCode == null) continue;
            arrayList.add(transactionErrorCode.getErrorString());
        }
        if (parameters.containsKey("BILLING_ZIP_CODE") && parameters.containsKey("BILLING_POSTAL_CODE") && !parameters.getValue("BILLING_ZIP_CODE").equalsIgnoreCase(parameters.getValue("BILLING_POSTAL_CODE"))) {
            arrayList.add(TransactionErrorCode.AmbiguousBillingInformation.getErrorString());
        }
        return arrayList;
    }

    static boolean TQ(ArrayList<TerminalConfigurationApplication> arrayList, TerminalConfigurationApplication terminalConfigurationApplication) {
        for (TerminalConfigurationApplication terminalConfigurationApplication2 : arrayList) {
            if (!terminalConfigurationApplication.TQ().equalsIgnoreCase(terminalConfigurationApplication2.TQ())) continue;
            return terminalConfigurationApplication.cL().equals(terminalConfigurationApplication2.cL());
        }
        return false;
    }

    static boolean TQ(ArrayList<TerminalConfigurationApplication> arrayList, String string) {
        for (TerminalConfigurationApplication terminalConfigurationApplication : arrayList) {
            if (!string.equalsIgnoreCase(terminalConfigurationApplication.TQ())) continue;
            return true;
        }
        return false;
    }

    static boolean Mx(String string) {
        if (string != null && !string.isEmpty() && ChipDnaMobileUtils.VT(string)) {
            int n = Integer.parseInt(string);
            return n >= 1 && n <= 30;
        }
        return false;
    }

    static String MY(String string) {
        int n;
        if (string == null) {
            return null;
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        hashMap.put(4, "AF");
        hashMap.put(8, "AL");
        hashMap.put(12, "DZ");
        hashMap.put(16, "AS");
        hashMap.put(20, "AD");
        hashMap.put(24, "AO");
        hashMap.put(28, "AG");
        hashMap.put(31, "AZ");
        hashMap.put(32, "AR");
        hashMap.put(36, "AU");
        hashMap.put(40, "AT");
        hashMap.put(44, "BS");
        hashMap.put(48, "BH");
        hashMap.put(50, "BD");
        hashMap.put(51, "AM");
        hashMap.put(52, "BB");
        hashMap.put(56, "BE");
        hashMap.put(60, "BM");
        hashMap.put(64, "BT");
        hashMap.put(68, "BO");
        hashMap.put(70, "BA");
        hashMap.put(72, "BW");
        hashMap.put(76, "BR");
        hashMap.put(84, "BZ");
        hashMap.put(90, "SB");
        hashMap.put(92, "VG");
        hashMap.put(96, "BN");
        hashMap.put(100, "BG");
        hashMap.put(104, "MM");
        hashMap.put(108, "BI");
        hashMap.put(112, "BY");
        hashMap.put(116, "KH");
        hashMap.put(120, "CM");
        hashMap.put(124, "CA");
        hashMap.put(132, "CV");
        hashMap.put(136, "KY");
        hashMap.put(140, "CF");
        hashMap.put(144, "LK");
        hashMap.put(148, "TD");
        hashMap.put(152, "CL");
        hashMap.put(156, "CN");
        hashMap.put(170, "CO");
        hashMap.put(174, "KM");
        hashMap.put(175, "YT");
        hashMap.put(178, "CG");
        hashMap.put(180, "CD");
        hashMap.put(184, "CK");
        hashMap.put(188, "CR");
        hashMap.put(191, "HR");
        hashMap.put(192, "CU");
        hashMap.put(196, "CY");
        hashMap.put(203, "CZ");
        hashMap.put(204, "BJ");
        hashMap.put(208, "DK");
        hashMap.put(212, "DM");
        hashMap.put(214, "DO");
        hashMap.put(218, "EC");
        hashMap.put(222, "SV");
        hashMap.put(226, "GQ");
        hashMap.put(231, "ET");
        hashMap.put(233, "EE");
        hashMap.put(234, "FO");
        hashMap.put(238, "FK");
        hashMap.put(242, "FJ");
        hashMap.put(246, "FI");
        hashMap.put(250, "FR");
        hashMap.put(262, "DJ");
        hashMap.put(266, "GA");
        hashMap.put(268, "GE");
        hashMap.put(270, "GM");
        hashMap.put(275, "PS");
        hashMap.put(276, "DE");
        hashMap.put(288, "GH");
        hashMap.put(292, "GI");
        hashMap.put(296, "KI");
        hashMap.put(300, "GR");
        hashMap.put(304, "GL");
        hashMap.put(308, "GD");
        hashMap.put(312, "GP");
        hashMap.put(316, "GU");
        hashMap.put(320, "GT");
        hashMap.put(324, "GN");
        hashMap.put(328, "GY");
        hashMap.put(332, "HT");
        hashMap.put(336, "VA");
        hashMap.put(340, "HN");
        hashMap.put(344, "HK");
        hashMap.put(348, "HU");
        hashMap.put(352, "IS");
        hashMap.put(356, "IN");
        hashMap.put(360, "ID");
        hashMap.put(364, "IR");
        hashMap.put(368, "IQ");
        hashMap.put(372, "IE");
        hashMap.put(376, "IL");
        hashMap.put(380, "IT");
        hashMap.put(384, "CI");
        hashMap.put(388, "JM");
        hashMap.put(392, "JP");
        hashMap.put(400, "JO");
        hashMap.put(404, "KE");
        hashMap.put(408, "KP");
        hashMap.put(410, "KR");
        hashMap.put(414, "KW");
        hashMap.put(417, "KG");
        hashMap.put(422, "LB");
        hashMap.put(428, "LV");
        hashMap.put(440, "LT");
        hashMap.put(442, "LU");
        hashMap.put(446, "MO");
        hashMap.put(450, "MG");
        hashMap.put(454, "MW");
        hashMap.put(458, "MY");
        hashMap.put(462, "MV");
        hashMap.put(466, "ML");
        hashMap.put(470, "MT");
        hashMap.put(480, "MU");
        hashMap.put(484, "MX");
        hashMap.put(492, "MC");
        hashMap.put(496, "MN");
        hashMap.put(498, "MD");
        hashMap.put(504, "MA");
        hashMap.put(508, "MZ");
        hashMap.put(512, "OM");
        hashMap.put(516, "NA");
        hashMap.put(524, "NP");
        hashMap.put(528, "NL");
        hashMap.put(554, "NZ");
        hashMap.put(558, "NI");
        hashMap.put(566, "NG");
        hashMap.put(578, "NO");
        hashMap.put(586, "PK");
        hashMap.put(591, "PA");
        hashMap.put(598, "PG");
        hashMap.put(600, "PY");
        hashMap.put(604, "PE");
        hashMap.put(608, "PH");
        hashMap.put(616, "PL");
        hashMap.put(620, "PT");
        hashMap.put(634, "QA");
        hashMap.put(642, "RO");
        hashMap.put(643, "RU");
        hashMap.put(682, "SA");
        hashMap.put(702, "SG");
        hashMap.put(710, "ZA");
        hashMap.put(724, "ES");
        hashMap.put(752, "SE");
        hashMap.put(756, "CH");
        hashMap.put(764, "TH");
        hashMap.put(784, "AE");
        hashMap.put(792, "TR");
        hashMap.put(804, "UA");
        hashMap.put(818, "EG");
        hashMap.put(826, "GB");
        hashMap.put(840, "US");
        hashMap.put(858, "UY");
        hashMap.put(860, "UZ");
        hashMap.put(887, "YE");
        hashMap.put(894, "ZM");
        return (String)hashMap.get(n);
    }
}

