/*
 * Decompiled with CFR 0.152.
 */
package com.creditcall.chipdnamobile;

import com.creditcall.chipdnamobile.ConfigurationErrorCode;
import com.creditcall.chipdnamobile.ConfigurationException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.json.JSONException;
import org.json.JSONObject;
import timber.log.Timber;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0004\u0010\bJ\r\u0010\t\u001a\u00020\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0014\u0010\u000e\u001a\u00020\u00068\u0002X\u0083D\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0010\u001a\u00020\u00028\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u0012"}, d2={"Lcom/creditcall/chipdnamobile/FirmwareUpdateConfiguration;", "", "", "timeFrame", "<init>", "(I)V", "", "jsonString", "(Ljava/lang/String;)V", "getTimeFrame", "()I", "Lorg/json/JSONObject;", "p0", "", "TQ", "(Lorg/json/JSONObject;)V", "EL", "Ljava/lang/String;", "I"})
public final class FirmwareUpdateConfiguration {
    private int TQ;
    @NotNull
    private final String EL;

    public FirmwareUpdateConfiguration(int timeFrame) {
        this.EL = "timeFrame";
        this.TQ = timeFrame;
    }

    public FirmwareUpdateConfiguration(@NotNull String jsonString) throws ConfigurationException {
        Intrinsics.checkNotNullParameter((Object)jsonString, (String)"");
        this.EL = "timeFrame";
        try {
            JSONObject jSONObject = new JSONObject(jsonString);
            this.TQ(jSONObject);
        }
        catch (JSONException jSONException) {
            Timber.w((Throwable)jSONException, (String)"Error parsing FirmwareUpdateConfiguration JSON string", (Object[])new Object[0]);
            throw new ConfigurationException(ConfigurationErrorCode.FirmwareUpdateConfigurationFormatError);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void TQ(JSONObject jSONObject) throws ConfigurationException {
        Object object = jSONObject.get(this.EL);
        if (object instanceof Number) {
            this.TQ = ((Number)object).intValue();
            return;
        } else if (object instanceof String) {
            Integer n = StringsKt.toIntOrNull((String)((String)object));
            if (n == null) throw new ConfigurationException(ConfigurationErrorCode.FirmwareUpdateConfigurationFormatError);
            this.TQ = n;
            return;
        } else {
            Timber.w((String)"TimeFrame is not a number or a string", (Object[])new Object[0]);
            throw new ConfigurationException(ConfigurationErrorCode.FirmwareUpdateConfigurationFormatError);
        }
    }

    public final int getTimeFrame() {
        return this.TQ;
    }
}

