/*
 * Decompiled with CFR 0.152.
 */
package com.creditcall.chipdnamobile;

import android.os.Parcel;
import android.os.Parcelable;
import com.creditcall.chipdnamobile.AcquirerDetails;
import com.creditcall.chipdnamobile.CardSchemeID;
import com.creditcall.chipdnamobile.ChipDnaMobileUtils;
import com.creditcall.chipdnamobile.Currency;
import com.creditcall.chipdnamobile.MerchantCardScheme;
import com.creditcall.chipdnamobile.MerchantDetails;
import com.creditcall.chipdnamobile.MerchantTransactionType;
import com.creditcall.chipdnamobile.PaymentMethod;
import com.creditcall.chipdnamobile.ProviderDetails;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

class MerchantAccount
implements Parcelable,
Serializable {
    private static final long serialVersionUID = 6204085571128427604L;
    private MerchantDetails dY;
    private AcquirerDetails rE;
    private ProviderDetails dR;
    ArrayList<MerchantCardScheme> TQ;
    ArrayList<MerchantTransactionType> EL;
    ArrayList<Currency> cL;
    static Parcelable.Creator<MerchantAccount> zv = new Parcelable.Creator<MerchantAccount>(){

        public MerchantAccount TQ(Parcel parcel) {
            return new MerchantAccount(parcel);
        }

        public MerchantAccount[] TQ(int n) {
            return new MerchantAccount[n];
        }

        public /* synthetic */ Object[] newArray(int n) {
            return this.TQ(n);
        }

        public /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.TQ(parcel);
        }
    };

    MerchantAccount() {
        this.TQ = new ArrayList();
        this.EL = new ArrayList();
        this.cL = new ArrayList();
    }

    boolean TQ(XmlPullParser xmlPullParser) {
        try {
            int n = xmlPullParser.getEventType();
            if (!xmlPullParser.getName().equalsIgnoreCase("MerchantAccount")) {
                return false;
            }
            while (!(n == 1 || n == 3 && xmlPullParser.getName().equalsIgnoreCase("MerchantAccount"))) {
                if (n == 2) {
                    this.cL(xmlPullParser);
                }
                n = xmlPullParser.next();
            }
        }
        catch (IOException | XmlPullParserException throwable) {
            return false;
        }
        return true;
    }

    HashMap<String, String> EL(XmlPullParser xmlPullParser) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < xmlPullParser.getAttributeCount(); ++i) {
            String string = xmlPullParser.getAttributeName(i);
            String string2 = xmlPullParser.getAttributeValue(i);
            hashMap.put(string, string2);
        }
        return hashMap;
    }

    void cL(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        HashMap<String, String> hashMap = new HashMap();
        if (xmlPullParser.getAttributeCount() > 0) {
            hashMap = this.EL(xmlPullParser);
        }
        if (xmlPullParser.getName().equalsIgnoreCase("Merchant")) {
            this.dY = new MerchantDetails(xmlPullParser.nextText(), hashMap);
        } else if (xmlPullParser.getName().equalsIgnoreCase("Acquirer")) {
            this.rE = new AcquirerDetails(xmlPullParser.nextText(), hashMap);
        } else if (xmlPullParser.getName().equalsIgnoreCase("Provider")) {
            this.dR = new ProviderDetails(xmlPullParser.nextText(), hashMap);
        } else if (xmlPullParser.getName().equalsIgnoreCase("TransactionType")) {
            this.EL.add(new MerchantTransactionType(xmlPullParser.nextText(), hashMap));
        } else if (xmlPullParser.getName().equalsIgnoreCase("CardScheme")) {
            this.TQ.add(new MerchantCardScheme(xmlPullParser.nextText(), hashMap));
        } else if (xmlPullParser.getName().equalsIgnoreCase("Currency")) {
            this.cL.add(new Currency(hashMap));
        }
    }

    boolean TQ(PaymentMethod paymentMethod) {
        int n = 0;
        for (MerchantCardScheme merchantCardScheme : this.TQ) {
            if (merchantCardScheme.TQ() == CardSchemeID.Cash) {
                if (paymentMethod == PaymentMethod.Cash) {
                    return true;
                }
                ++n;
            }
            if (merchantCardScheme.TQ() != CardSchemeID.Cheque) continue;
            if (paymentMethod == PaymentMethod.Cheque) {
                return true;
            }
            ++n;
        }
        return this.TQ.size() > n && paymentMethod == PaymentMethod.Card;
    }

    boolean TQ(Currency currency) {
        if (currency == null) {
            return false;
        }
        return ChipDnaMobileUtils.TQ(currency.getCharCode(), this.cL) != null;
    }

    boolean TQ(String string) {
        CardSchemeID cardSchemeID = CardSchemeID.TQ(string);
        return this.TQ(cardSchemeID);
    }

    boolean EL(String string) {
        CardSchemeID cardSchemeID = CardSchemeID.EL(string);
        return this.TQ(cardSchemeID);
    }

    boolean TQ(CardSchemeID cardSchemeID) {
        return this.EL(cardSchemeID) != null;
    }

    MerchantCardScheme EL(CardSchemeID cardSchemeID) {
        if (cardSchemeID == null) {
            return null;
        }
        for (MerchantCardScheme merchantCardScheme : this.TQ) {
            if (merchantCardScheme.TQ() != cardSchemeID) continue;
            return merchantCardScheme;
        }
        return null;
    }

    MerchantDetails TQ() {
        return this.dY;
    }

    AcquirerDetails EL() {
        return this.rE;
    }

    ProviderDetails cL() {
        return this.dR;
    }

    private MerchantAccount(Parcel in) {
        this.dY = (MerchantDetails)in.readParcelable(MerchantDetails.class.getClassLoader());
        this.rE = (AcquirerDetails)in.readParcelable(AcquirerDetails.class.getClassLoader());
        this.dR = (ProviderDetails)in.readParcelable(ProviderDetails.class.getClassLoader());
        this.TQ = new ArrayList();
        this.EL = new ArrayList();
        this.cL = new ArrayList();
        in.readList(this.TQ, null);
        in.readList(this.EL, null);
        in.readList(this.cL, null);
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable((Parcelable)this.dY, flags);
        dest.writeParcelable((Parcelable)this.rE, flags);
        dest.writeParcelable((Parcelable)this.dR, flags);
        dest.writeList(this.TQ);
        dest.writeList(this.EL);
        dest.writeList(this.cL);
    }

    public int describeContents() {
        return 0;
    }
}

