/*
 * Decompiled with CFR 0.152.
 */
package com.creditcall.chipdnamobile;

import android.bluetooth.BluetoothDevice;
import android.content.Context;
import androidx.annotation.Nullable;
import com.bbpos.bbdevice.BBDeviceController;
import com.bbpos.bbdevice.CAPK;
import com.bbpos.bbdevice.ota.BBDeviceControllerNotSetException;
import com.bbpos.bbdevice.ota.BBDeviceControllerNotSupportOTAException;
import com.bbpos.bbdevice.ota.BBDeviceNotConnectedException;
import com.bbpos.bbdevice.ota.BBDeviceOTAController;
import com.bbpos.bbdevice.ota.NoInternetConnectionException;
import com.bbpos.bbdevice.ota.OTAServerURLNotSetException;
import com.creditcall.chipdnamobile.AbstractChipDnaMobileErrorCode;
import com.creditcall.chipdnamobile.BBPOS;
import com.creditcall.chipdnamobile.ChipDnaMobileProperties;
import com.creditcall.chipdnamobile.ConfigurationErrorCode;
import com.creditcall.chipdnamobile.LO;
import com.creditcall.chipdnamobile.PaymentDeviceErrorCode;
import com.creditcall.chipdnamobile.PaymentDeviceException;
import com.creditcall.chipdnamobile.PinPad;
import com.creditcall.chipdnamobile.VT;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import timber.log.Timber;

class Nu
extends LO {
    BBDeviceController NE;
    TQ dC;
    EL VT;
    BBDeviceOTAController uq;
    BluetoothDevice sw;
    boolean De;
    private static final int iQ = 10;
    private CountDownLatch Yy;
    private CountDownLatch Ai;

    Nu(String string, Context context) throws PaymentDeviceException {
        super(string, context);
    }

    @Override
    protected void TQ(ArrayList<String> arrayList, boolean bl) {
        Timber.i((String)"Starting BBPOS Software Update", (Object[])new Object[0]);
        Timber.i((String)"Firmware files to update\n%s", (Object[])new Object[]{arrayList.toString()});
        this.Yy = new CountDownLatch(1);
        this.Ai = new CountDownLatch(1);
        this.De = true;
        VT vT = this.Gf.fw();
        if (vT == null) {
            this.TQ(ConfigurationErrorCode.FirmwareFileDataMissing);
        }
        this.dC = new TQ();
        this.NE = BBDeviceController.getInstance((Context)this.Vo, (BBDeviceController.BBDeviceControllerListener)this.dC);
        if (!this.mm()) {
            Timber.w((String)"FAILED SWITCH TO SDK", (Object[])new Object[0]);
            this.TQ(false, (AbstractChipDnaMobileErrorCode)PaymentDeviceErrorCode.ConnectionFailed);
            return;
        }
        this.EL(bl);
        this.TQ(BBPOS.State.Firmware);
        for (String string : arrayList) {
            Timber.i((String)"Updating firmware file [identifier=%s]", (Object[])new Object[]{string});
            byte[] byArray = this.Gf.TQ(string, ChipDnaMobileProperties.FileCategory.Software, null);
            try {
                this.VT = new EL();
                this.uq = BBDeviceOTAController.getInstance((Context)this.Vo, (BBDeviceOTAController.BBDeviceOTAControllerListener)this.VT);
                this.uq.setBBDeviceController((Object)this.NE);
                this.uq.setOTAServerURL(vT.TQ());
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                hashtable.put("vendorID", vT.EL().TQ());
                hashtable.put("vendorSecret", vT.EL().EL());
                hashtable.put("appID", vT.EL().cL());
                hashtable.put("appSecret", vT.EL().zv());
                hashtable.put("encHex", new String(byArray, StandardCharsets.UTF_8));
                if (bl) {
                    this.uq.startRemoteConfigUpdate(hashtable);
                    continue;
                }
                this.uq.startRemoteFirmwareUpdate(hashtable);
            }
            catch (BBDeviceControllerNotSupportOTAException bBDeviceControllerNotSupportOTAException) {
                this.TQ(PaymentDeviceErrorCode.UnsupportedCommand);
            }
            catch (OTAServerURLNotSetException oTAServerURLNotSetException) {
                this.TQ(ConfigurationErrorCode.CommunicationsFailed);
            }
            catch (BBDeviceNotConnectedException bBDeviceNotConnectedException) {
                this.TQ(ConfigurationErrorCode.ConnectionClosed);
            }
            catch (NoInternetConnectionException noInternetConnectionException) {
                this.TQ(ConfigurationErrorCode.CommunicationsFailed);
            }
            catch (BBDeviceControllerNotSetException bBDeviceControllerNotSetException) {
                this.TQ(ConfigurationErrorCode.CommunicationsFailed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean mm() {
        this.TQ(BBPOS.State.SwitchingSDK);
        ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);
        try {
            this.TQ();
            if (!this.Yy.await(10L, TimeUnit.SECONDS)) {
                return false;
            }
        }
        catch (InterruptedException interruptedException) {
            Timber.w((Throwable)interruptedException, (String)"Disconnection Timeout Interrupted", (Object[])new Object[0]);
            return false;
        }
        this.cL = this.cL != 0 ? this.cL : 10;
        String[] stringArray = new String[]{this.Nu().getName()};
        try {
            this.NE.startBTScan(stringArray, this.cL);
            if (!this.Ai.await(this.cL + 5, TimeUnit.SECONDS)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            Timber.w((Throwable)interruptedException, (String)"Connection Timeout Interrupted", (Object[])new Object[0]);
            boolean bl = false;
            return bl;
        }
        finally {
            scheduledExecutorService.shutdown();
        }
    }

    @Override
    protected void TQ() {
        if (!this.De) {
            super.TQ();
        } else {
            this.TQ.zv();
            this.Yy.countDown();
        }
    }

    private void TQ(AbstractChipDnaMobileErrorCode abstractChipDnaMobileErrorCode) {
        this.TQ(false, abstractChipDnaMobileErrorCode);
        this.XO();
    }

    private void XO() {
        Timber.i((String)"Disconnecting from BBPOS SDK", (Object[])new Object[0]);
        if (this.NE != null) {
            if (this.NE.getConnectedBTDevice() != null) {
                this.NE.disconnectBT();
            }
            this.NE.releaseBBDeviceController();
            this.NE = null;
        }
        this.dC = null;
    }

    void TQ(BBDeviceOTAController.OTAResult oTAResult, String string, boolean bl) {
        try {
            Timber.i((String)"OTA Update Result Message: %s", (Object[])new Object[]{string});
            switch (oTAResult) {
                case SUCCESS: {
                    Timber.i((String)"OTA Update Success", (Object[])new Object[0]);
                    if (!bl) {
                        Timber.i((String)"Rebooting", (Object[])new Object[0]);
                        this.cL(true);
                        Timber.i((String)"Disconnecting BT", (Object[])new Object[0]);
                        this.NE.disconnectBT();
                        break;
                    }
                    Timber.i((String)"Rebooting", (Object[])new Object[0]);
                    this.cL(true);
                    break;
                }
                case SETUP_ERROR: {
                    Timber.w((String)"OTA Setup Error", (Object[])new Object[0]);
                    this.TQ(ConfigurationErrorCode.CommunicationsFailed);
                    break;
                }
                case BATTERY_LOW_ERROR: {
                    Timber.w((String)"Battery Low Error", (Object[])new Object[0]);
                    this.TQ(ConfigurationErrorCode.CommunicationsFailed);
                    break;
                }
                case DEVICE_COMM_ERROR: {
                    Timber.w((String)"Device Communication Error", (Object[])new Object[0]);
                    this.TQ(ConfigurationErrorCode.CommunicationsFailed);
                    break;
                }
                case SERVER_COMM_ERROR: {
                    Timber.w((String)"ServerCommunicationError", (Object[])new Object[0]);
                    this.TQ(ConfigurationErrorCode.CommunicationsFailed);
                    break;
                }
                case FAILED: {
                    Timber.w((String)"OTA Update Failed", (Object[])new Object[0]);
                    this.TQ(ConfigurationErrorCode.PinPadNotConfigured);
                    break;
                }
                case STOPPED: {
                    Timber.w((String)"OTA Update Stopped", (Object[])new Object[0]);
                    this.TQ(ConfigurationErrorCode.PinPadNotConfigured);
                    break;
                }
                case NO_UPDATE_REQUIRED: {
                    try {
                        this.cL();
                        this.EL.add(new BBPOS.TQ(BBPOS.ActionType.PinPadCheckConfiguration));
                    }
                    catch (PaymentDeviceException paymentDeviceException) {
                        Timber.w((String)"Unable to set pinpad info", (Object[])new Object[0]);
                        this.TQ(paymentDeviceException.TQ());
                    }
                    break;
                }
                case INCOMPATIBLE_CONFIG_HEX: {
                    Timber.w((String)"Incompatible Firmware Hex File", (Object[])new Object[0]);
                    this.TQ(ConfigurationErrorCode.IncompatibleDeviceConfiguration);
                    break;
                }
                case INCOMPATIBLE_FIRMWARE_HEX: {
                    Timber.w((String)"Incompatible Configuration Hex File", (Object[])new Object[0]);
                    this.TQ(ConfigurationErrorCode.FirmwareFileParsingFailed);
                    break;
                }
                default: {
                    Timber.w((String)"Unknown OTA Result", (Object[])new Object[0]);
                    this.TQ(PaymentDeviceErrorCode.General);
                }
            }
            this.De = false;
        }
        catch (Exception exception) {
            Timber.e((Throwable)exception);
            throw exception;
        }
    }

    class TQ
    implements BBDeviceController.BBDeviceControllerListener {
        TQ() {
        }

        public void onWaitingForCard(BBDeviceController.CheckCardMode checkCardMode) {
        }

        public void onWaitingReprintOrPrintNext() {
        }

        public void onBTReturnScanResults(List<BluetoothDevice> devices) {
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            executorService.execute(() -> {
                try {
                    Timber.d((String)"scan results", (Object[])new Object[0]);
                    Nu.this.sw = (BluetoothDevice)devices.get(0);
                    Nu.this.NE.stopBTScan();
                    Nu.this.NE.connectBT(Nu.this.sw);
                }
                catch (Exception exception) {
                    Timber.e((Throwable)exception);
                    throw exception;
                }
            });
        }

        public void onBTScanTimeout() {
            try {
                Timber.i((String)"Scan Timeout", (Object[])new Object[0]);
                Nu.this.TQ(ConfigurationErrorCode.CommunicationsFailed);
            }
            catch (Exception exception) {
                Timber.e((Throwable)exception);
                throw exception;
            }
        }

        public void onBTScanStopped() {
            Timber.i((String)"Scan Stopped", (Object[])new Object[0]);
        }

        public void onBTConnected(BluetoothDevice bluetoothDevice) {
            try {
                Timber.i((String)"Connected", (Object[])new Object[0]);
                Nu.this.Ai.countDown();
            }
            catch (Exception exception) {
                Timber.e((Throwable)exception);
                throw exception;
            }
        }

        public void onBTDisconnected() {
            try {
                Timber.i((String)"onBTDisconnected", (Object[])new Object[0]);
                if (!Nu.this.an().equals((Object)PinPad.ProcessState.Rebooting)) {
                    Nu.this.TQ();
                } else {
                    Nu.this.yS();
                }
                Nu.this.XO();
            }
            catch (Exception exception) {
                Timber.e((Throwable)exception);
                throw exception;
            }
        }

        public void onBTRequestPairing() {
        }

        public void onUsbConnected() {
        }

        public void onUsbDisconnected() {
        }

        public void onSerialConnected() {
        }

        public void onSerialDisconnected() {
        }

        public void onReturnCheckCardResult(BBDeviceController.CheckCardResult checkCardResult, Hashtable<String, String> hashtable) {
        }

        public void onReturnCancelCheckCardResult(boolean b) {
        }

        public void onReturnDeviceInfo(Hashtable<String, String> hashtable) {
        }

        public void onReturnTransactionResult(BBDeviceController.TransactionResult transactionResult) {
        }

        public void onReturnBatchData(String s) {
        }

        public void onReturnReversalData(String s) {
        }

        public void onReturnAmountConfirmResult(boolean b) {
        }

        public void onReturnPinEntryResult(BBDeviceController.PinEntryResult pinEntryResult, Hashtable<String, String> hashtable) {
        }

        public void onReturnPrintResult(BBDeviceController.PrintResult printResult) {
        }

        public void onReturnAccountSelectionResult(BBDeviceController.AccountSelectionResult accountSelectionResult, int i) {
        }

        public void onReturnAmount(BBDeviceController.AmountInputResult amountInputResult, Hashtable<String, String> hashtable) {
        }

        public void onReturnUpdateAIDResult(Hashtable<String, Object> hashtable) {
        }

        public void onReturnUpdateTerminalSettingResult(BBDeviceController.TerminalSettingStatus terminalSettingStatus) {
        }

        public void onReturnUpdateTerminalSettingsResult(Hashtable<String, BBDeviceController.TerminalSettingStatus> hashtable) {
        }

        public void onReturnUpdateDisplayStringResult(boolean b, String s) {
        }

        public void onReturnReadDisplayStringResult(boolean b, Hashtable<String, String> hashtable) {
        }

        public void onReturnReadDisplaySettingsResult(boolean b, Hashtable<String, Object> hashtable) {
        }

        public void onReturnReadAIDResult(Hashtable<String, Object> hashtable) {
        }

        public void onReturnReadTerminalSettingResult(Hashtable<String, Object> hashtable) {
        }

        public void onReturnEnableAccountSelectionResult(boolean b) {
        }

        public void onReturnEnableInputAmountResult(boolean b) {
        }

        public void onReturnEnableBluetoothResult(boolean b) {
        }

        public void onReturnCAPKList(List<CAPK> list) {
        }

        public void onReturnCAPKDetail(CAPK capk) {
        }

        public void onReturnCAPKLocation(String s) {
        }

        public void onReturnUpdateCAPKResult(boolean b) {
        }

        public void onReturnRemoveCAPKResult(boolean b) {
        }

        public void onReturnEmvReportList(@Nullable Hashtable<String, String> hashtable) {
        }

        public void onReturnEmvReport(String s) {
        }

        public void onReturnDisableAccountSelectionResult(boolean b) {
        }

        public void onReturnDisableInputAmountResult(boolean b) {
        }

        public void onReturnDisableBluetoothResult(boolean b) {
        }

        public void onReturnEmvCardDataResult(boolean b, @Nullable String s) {
        }

        public void onReturnEmvCardNumber(boolean b, String s) {
        }

        public void onReturnEncryptDataResult(boolean b, Hashtable<String, String> hashtable) {
        }

        public void onReturnPowerOnIccResult(boolean b, String s, String s1, int i) {
        }

        public void onReturnPowerOffIccResult(boolean b) {
        }

        public void onReturnApduResult(boolean b, Hashtable<String, Object> hashtable) {
        }

        public void onRequestSelectApplication(ArrayList<String> arrayList) {
        }

        public void onRequestSelectAccountType() {
        }

        public void onRequestSetAmount() {
        }

        public void onRequestOtherAmount(BBDeviceController.AmountInputType amountInputType) {
        }

        public void onRequestPinEntry(BBDeviceController.PinEntrySource pinEntrySource) {
        }

        public void onRequestManualPanEntry(BBDeviceController.ManualPanEntryType manualPanEntryType) {
        }

        public void onReturnSetPinPadButtonsResult(boolean b) {
        }

        public void onReturnSetPinPadOrientationResult(boolean b) {
        }

        public void onReturnAccessiblePINPadTouchEvent(BBDeviceController.PinPadTouchEvent pinPadTouchEvent) {
        }

        public void onReturnUpdateDisplaySettingsProgress(double v) {
        }

        public void onReturnUpdateDisplaySettingsResult(boolean b, String s) {
        }

        public void onRequestOnlineProcess(String s) {
        }

        public void onRequestTerminalTime() {
        }

        public void onRequestDisplayText(BBDeviceController.DisplayText displayText, String s) {
        }

        public void onRequestDisplayAsterisk(String s, int i) {
        }

        public void onRequestDisplayLEDIndicator(BBDeviceController.ContactlessStatus contactlessStatus) {
        }

        public void onRequestProduceAudioTone(BBDeviceController.ContactlessStatusTone contactlessStatusTone) {
        }

        public void onRequestClearDisplay() {
        }

        public void onRequestFinalConfirm() {
        }

        public void onRequestAmountConfirm(Hashtable<String, String> hashtable) {
        }

        public void onRequestPrintData(int i, boolean b) {
        }

        public void onPrintDataCancelled() {
        }

        public void onPrintDataEnd() {
        }

        public void onBatteryLow(BBDeviceController.BatteryStatus batteryStatus) {
        }

        public void onError(BBDeviceController.Error error, String s) {
            try {
                Timber.w((String)"FW-UPDATE: Error attempting to connect to device", (Object[])new Object[0]);
                Timber.w((String)"ErrorType: %s, Message: %s", (Object[])new Object[]{error, s});
                Nu.this.TQ(ConfigurationErrorCode.IncompatibleDeviceConfiguration);
            }
            catch (Exception exception) {
                Timber.e((Throwable)exception);
                throw exception;
            }
        }

        public void onSessionInitialized() {
        }

        public void onSessionError(BBDeviceController.SessionError sessionError, String s) {
        }

        public void onReturnDebugLog(Hashtable<String, Object> hashtable) {
        }

        public void onDeviceHere(boolean b) {
        }

        public void onPowerDown() {
        }

        public void onPowerButtonPressed() {
        }

        public void onPowerConnected(BBDeviceController.PowerSource powerSource, BBDeviceController.BatteryStatus batteryStatus) {
        }

        public void onPowerDisconnected(BBDeviceController.PowerSource powerSource) {
        }

        public void onDeviceReset(boolean b, BBDeviceController.DeviceResetReason deviceResetReason) {
            try {
                Timber.i((String)"Resetting the device...", (Object[])new Object[0]);
                switch (deviceResetReason) {
                    case UNKNOWN: {
                        Timber.d((String)"Reset Reason: Unknown", (Object[])new Object[0]);
                        break;
                    }
                    case APP_RESET_DEVICE: {
                        Timber.d((String)"Reset initiated by application", (Object[])new Object[0]);
                        break;
                    }
                    case FIRMWARE_SELF_TEST: {
                        Timber.d((String)"Reset due to firmware self-test", (Object[])new Object[0]);
                        break;
                    }
                    case RECOVERY_ATTEMPT: {
                        Timber.d((String)"Reset in attempt to recover from error", (Object[])new Object[0]);
                        break;
                    }
                    case WATCHDOG_TIMEOUT: {
                        Timber.d((String)"Reset due to watchdog timeout", (Object[])new Object[0]);
                        break;
                    }
                    default: {
                        Timber.d((String)"Unexpected reset reason", (Object[])new Object[0]);
                        break;
                    }
                }
            }
            catch (Exception exception) {
                Timber.e((Throwable)exception);
                throw exception;
            }
        }

        public void onDeviceResetAlert(int i) {
            Timber.d((String)"Reset Device in: %d", (Object[])new Object[]{i});
        }

        public void onEnterStandbyMode() {
        }

        public void onReturnWatchdogTimerReset() {
        }

        public void onReturnNfcDataExchangeResult(boolean b, Hashtable<String, String> hashtable) {
        }

        public void onReturnNfcDetectCardResult(BBDeviceController.NfcDetectCardResult nfcDetectCardResult, Hashtable<String, Object> hashtable) {
        }

        public void onReturnControlLEDResult(boolean b, String s) {
        }

        public void onReturnVasResult(BBDeviceController.VASResult vasResult, Hashtable<String, Object> hashtable) {
        }

        public void onRequestStartEmv() {
        }

        public void onDeviceDisplayingPrompt() {
        }

        public void onRequestKeypadResponse() {
        }

        public void onReturnDisplayPromptResult(BBDeviceController.DisplayPromptResult displayPromptResult) {
        }

        public void onReturnFunctionKey(BBDeviceController.FunctionKey functionKey) {
        }

        public void onHardwareFunctionalTestResult(int i, int i1, String s) {
        }

        public void onBarcodeReaderConnected() {
        }

        public void onBarcodeReaderDisconnected() {
        }

        public void onReturnBarcode(String s) {
        }

        public void onRequestVirtuCryptPEDIResponse(boolean b, Hashtable<String, String> hashtable) {
        }

        public void onReturnVirtuCryptPEDICommandResult(boolean b, Hashtable<String, String> hashtable) {
        }

        public void onRequestVirtuCryptPEDKResponse(boolean b, Hashtable<String, String> hashtable) {
        }

        public void onReturnVirtuCryptPEDKCommandResult(boolean b, Hashtable<String, String> hashtable) {
        }
    }

    class EL
    implements BBDeviceOTAController.BBDeviceOTAControllerListener {
        EL() {
        }

        public void onReturnRemoteKeyInjectionResult(BBDeviceOTAController.OTAResult otaResult, String s) {
        }

        public void onReturnRemoteFirmwareUpdateResult(BBDeviceOTAController.OTAResult otaResult, String s) {
            Nu.this.TQ(otaResult, s, true);
        }

        public void onReturnRemoteConfigUpdateResult(BBDeviceOTAController.OTAResult otaResult, String s) {
            Nu.this.TQ(otaResult, s, false);
        }

        public void onReturnLocalFirmwareUpdateResult(BBDeviceOTAController.OTAResult otaResult, String s) {
        }

        public void onReturnLocalConfigUpdateResult(BBDeviceOTAController.OTAResult otaResult, String s) {
        }

        public void onReturnOTAProgress(double v) {
            Timber.i((String)"OTA Process: %.2f", (Object[])new Object[]{v});
        }

        public void onReturnTargetVersionResult(BBDeviceOTAController.OTAResult otaResult, Hashtable<String, String> hashtable) {
        }

        public void onReturnTargetVersionListResult(BBDeviceOTAController.OTAResult otaResult, List<Hashtable<String, String>> list, String s) {
        }

        public void onReturnSetTargetVersionResult(BBDeviceOTAController.OTAResult otaResult, String s) {
        }

        public void onReturnOTADebugLog(Hashtable<String, Object> hashtable) {
        }
    }
}

