/*
 * Decompiled with CFR 0.152.
 */
package com.creditcall;

import com.creditcall.CardEaseXMLCommunicationException;
import com.creditcall.KevlarState;
import com.creditcall.RequestInfo;
import com.creditcall.ServerURL;
import com.creditcall.TLSSocketFactory;
import com.creditcall.XMLEncoding;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.Callable;
import javax.net.ssl.HttpsURLConnection;

abstract class CardEaseCallable<V>
implements Callable<V> {
    protected XMLEncoding m_xmlEncoding;
    protected KevlarState m_kevlarState = KevlarState.None;
    protected RequestInfo m_requestInfo;
    private static TLSSocketFactory m_socketFactory;

    CardEaseCallable(XMLEncoding xmlEncoding, RequestInfo requestInfo) {
        this.m_xmlEncoding = xmlEncoding;
        this.m_requestInfo = requestInfo;
    }

    HttpsURLConnection getHttpsURLConnection(ServerURL url) throws CardEaseXMLCommunicationException {
        return this.getHttpsURLConnection(url.getURL(), url.getTimeout(), true);
    }

    HttpsURLConnection getHttpsURLConnection(URL url, int timeOut, Boolean doOutput) throws CardEaseXMLCommunicationException {
        try {
            URLConnection urlConnection = url.openConnection();
            if (urlConnection instanceof HttpsURLConnection) {
                HttpsURLConnection httpsUrlConnection = (HttpsURLConnection)urlConnection;
                httpsUrlConnection.setConnectTimeout(10000);
                httpsUrlConnection.setReadTimeout(timeOut);
                if (doOutput.booleanValue()) {
                    httpsUrlConnection.setDoOutput(doOutput);
                }
                if (this.m_xmlEncoding == XMLEncoding.UTF_8) {
                    httpsUrlConnection.setRequestProperty("CONTENT-TYPE", "text/xml; charset=utf-8");
                } else if (this.m_xmlEncoding == XMLEncoding.UTF_16) {
                    httpsUrlConnection.setRequestProperty("CONTENT-TYPE", "text/xml; charset=utf-16");
                } else if (this.m_xmlEncoding == XMLEncoding.US_ASCII) {
                    httpsUrlConnection.setRequestProperty("CONTENT-TYPE", "text/xml; charset=us-ascii");
                }
                if (doOutput.booleanValue()) {
                    httpsUrlConnection.setChunkedStreamingMode(0);
                    httpsUrlConnection.setRequestProperty("connection", "close");
                }
                try {
                    if (m_socketFactory == null) {
                        m_socketFactory = new TLSSocketFactory();
                    }
                    httpsUrlConnection.setSSLSocketFactory(m_socketFactory);
                    return httpsUrlConnection;
                }
                catch (Exception e) {
                    throw new CardEaseXMLCommunicationException("Error setting SSL Sockets", e);
                }
            }
            throw new CardEaseXMLCommunicationException("Specified URL is not a HTTP/HTTPS URL");
        }
        catch (MalformedURLException e) {
            throw new CardEaseXMLCommunicationException("Specified URL is malformed", e);
        }
        catch (IOException e) {
            throw new CardEaseXMLCommunicationException("Specified URL cannot be opened", e);
        }
    }

    KevlarState getKevlarState() {
        return this.m_kevlarState;
    }
}

