/*
 * Decompiled with CFR 0.152.
 */
package com.creditcall;

public class CurrencyData {
    private String numericCode;
    private String symbol;
    private String charCode;
    private int exponent;

    CurrencyData(String numericCode, String symbol, String charCode, int exponent) {
        this.numericCode = numericCode;
        if (numericCode != null && numericCode.length() < 3) {
            this.numericCode = String.format("%" + (3 - numericCode.length()) + "s", "").replace(" ", String.valueOf('0')) + numericCode;
        }
        this.symbol = symbol;
        this.charCode = charCode;
        this.exponent = exponent;
    }

    public String getNumericCode() {
        return this.numericCode;
    }

    public int getExponent() {
        return this.exponent;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public String getCharCode() {
        return this.charCode;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(this.numericCode);
        str.append(":");
        str.append(this.symbol);
        str.append(":");
        str.append(this.charCode);
        str.append(":");
        str.append(this.exponent);
        return str.toString();
    }
}

