/*
 * Decompiled with CFR 0.152.
 */
package com.creditcall;

import android.os.Build;
import com.creditcall.Address;
import com.creditcall.AmountType;
import com.creditcall.AmountUnit;
import com.creditcall.BillingInformation;
import com.creditcall.CardEaseXMLRequestException;
import com.creditcall.Client;
import com.creditcall.CredentialOnFile;
import com.creditcall.DCC;
import com.creditcall.EmailAddress;
import com.creditcall.ExtendedProperty;
import com.creditcall.FeatureToken;
import com.creditcall.IAVFormat;
import com.creditcall.ICCTag;
import com.creditcall.ICCTagValueType;
import com.creditcall.MerchantDefinedFieldsKeys;
import com.creditcall.Name;
import com.creditcall.PhoneNumber;
import com.creditcall.PointOfInteraction;
import com.creditcall.Product;
import com.creditcall.PurchaseLevel2Data;
import com.creditcall.RequestType;
import com.creditcall.TerminalCapabilities;
import com.creditcall.ThreeDSecureCardHolderEnrolled;
import com.creditcall.ThreeDSecureTransactionStatus;
import com.creditcall.TransactionFirstStore;
import com.creditcall.TransactionInitiatedBy;
import com.creditcall.TransactionLink;
import com.creditcall.TransactionReason;
import com.creditcall.VoiceReferralResult;
import com.creditcall.VoidReason;
import com.creditcall.XIDFormat;
import com.creditcall.internal.XMLWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class Request {
    private ThreeDSecureCardHolderEnrolled m_3DSecureCardHolderEnrolled = ThreeDSecureCardHolderEnrolled.Empty;
    private String m_3DSecureDirectoryServerTransactionId;
    private String m_3DSecureServerTransactionId;
    private String m_3DSecureECI = null;
    private String m_3DSecureIAV = null;
    private String m_3DSecureIAVAlgorithm = null;
    private IAVFormat m_3DSecureIAVFormat = IAVFormat.Base64;
    private ThreeDSecureTransactionStatus m_3DSecureTransactionStatus = ThreeDSecureTransactionStatus.Empty;
    private String m_3DSecureVersion;
    private String m_3DSecureXID = null;
    private XIDFormat m_3DSecureXIDFormat = XIDFormat.Ascii;
    private String m_address = null;
    private String m_amount = null;
    private String m_amountOther = null;
    private String m_amountOtherTransactionFee = null;
    private String m_amountTip = null;
    private AmountUnit m_amountUnit = AmountUnit.Minor;
    private AmountType m_amountType = AmountType.Unknown;
    private String m_authCode = null;
    private boolean m_autoConfirm = false;
    private boolean m_allowMultipleConfirms = true;
    private String m_batchReference = null;
    private String m_cardEaseReference = null;
    private String m_transactionId = null;
    private HashMap<String, String> m_merchantDefinedFields = null;
    private PurchaseLevel2Data m_purchaseLevel2Data = null;
    private BillingInformation m_billingInformation = null;
    private String m_cardEaseXMLVersion = "1.5.0";
    private String m_cardHash = null;
    private Address m_cardHolderAddress = new Address();
    private List<EmailAddress> m_cardHolderEmailAddresses = new ArrayList<EmailAddress>();
    private Name m_cardHolderName = new Name();
    private List<PhoneNumber> m_cardHolderPhoneNumbers = new ArrayList<PhoneNumber>();
    private String m_cardReference = null;
    private boolean m_contactless = false;
    private String m_csc = null;
    private String m_currencyCode = null;
    private boolean m_debtRepayment = false;
    private DCC m_dcc = new DCC();
    private Address m_deliveryAddress = new Address();
    private List<EmailAddress> m_deliveryEmailAddresses = new ArrayList<EmailAddress>();
    private Name m_deliveryName = new Name();
    private List<PhoneNumber> m_deliveryPhoneNumbers = new ArrayList<PhoneNumber>();
    private String m_expiryDate = null;
    private String m_expiryDateFormat = "yyMM";
    private List<ExtendedProperty> m_extendedProperties = new ArrayList<ExtendedProperty>();
    private List<FeatureToken> m_featureTokens = new ArrayList<FeatureToken>();
    private boolean m_iccFallback = false;
    private List<ICCTag> m_iccTags = new ArrayList<ICCTag>();
    private String m_iccType = "EMV";
    private Address m_invoiceAddress = new Address();
    private List<EmailAddress> m_invoiceEmailAddresses = new ArrayList<EmailAddress>();
    private Name m_invoiceName = new Name();
    private List<PhoneNumber> m_invoicePhoneNumbers = new ArrayList<PhoneNumber>();
    private String m_issueNumber = null;
    private String m_machineReference = null;
    private String m_manualType = "cnp";
    private String m_offlineDateTime = null;
    private String m_offlineDateTimeFormat = "ddMMyy HHmmss";
    private String m_originatingIPAddress = null;
    private String m_pan = null;
    private List<Product> m_products = new ArrayList<Product>();
    private RequestType m_requestType = RequestType.Auth;
    private String m_softwareName = null;
    private String m_softwareVersion = null;
    private String m_startDate = null;
    private String m_startDateFormat = "yyMM";
    private String m_subType = null;
    private String m_terminalID = null;
    private TerminalCapabilities m_terminalCapabilities = null;
    private String m_track1 = null;
    private String m_track2 = null;
    private String m_track3 = null;
    private String m_transactionKey = null;
    private List<TransactionLink> m_transactionLinks;
    private String m_userReference = null;
    private VoiceReferralResult m_voiceReferralResult = VoiceReferralResult.Empty;
    private VoidReason m_voidReason = VoidReason.Empty;
    private String m_zipCode = null;
    private PointOfInteraction m_pointOfInteraction = null;
    private String m_apiKey = null;
    private String m_posGuid = null;
    private String m_applicationId = null;
    private String m_encryptedPanKeyEntryData = null;
    private CredentialOnFile m_credentialOnFile;
    private String m_laneId = null;
    private String m_merchantProcessorId = null;
    private String m_customerVaultCommand = null;
    private String m_customerVaultId = null;
    private String m_certificationIdentifier = null;
    private String m_platformName = "Android";
    private String m_platformVersion = Build.VERSION.RELEASE;
    private Boolean m_omniSale = false;

    public CredentialOnFile getCredentialOnFile() {
        return this.m_credentialOnFile;
    }

    public void setCredentialOnFile(CredentialOnFile m_credentialOnFile) {
        this.m_credentialOnFile = m_credentialOnFile;
    }

    public void addCardHolderEmailAddress(EmailAddress emailAddress) {
        if (this.m_cardHolderEmailAddresses == null) {
            this.m_cardHolderEmailAddresses = new ArrayList<EmailAddress>();
        }
        this.m_cardHolderEmailAddresses.add(emailAddress);
    }

    public void addCardHolderPhoneNumber(PhoneNumber phoneNumber) {
        if (this.m_cardHolderPhoneNumbers == null) {
            this.m_cardHolderPhoneNumbers = new ArrayList<PhoneNumber>();
        }
        this.m_cardHolderPhoneNumbers.add(phoneNumber);
    }

    public void addDeliveryEmailAddress(EmailAddress emailAddress) {
        if (this.m_deliveryEmailAddresses == null) {
            this.m_deliveryEmailAddresses = new ArrayList<EmailAddress>();
        }
        this.m_deliveryEmailAddresses.add(emailAddress);
    }

    public void addDeliveryPhoneNumber(PhoneNumber phoneNumber) {
        if (this.m_deliveryPhoneNumbers == null) {
            this.m_deliveryPhoneNumbers = new ArrayList<PhoneNumber>();
        }
        this.m_deliveryPhoneNumbers.add(phoneNumber);
    }

    public void addExtendedProperty(ExtendedProperty extendedProperty) {
        if (this.m_extendedProperties == null) {
            this.m_extendedProperties = new ArrayList<ExtendedProperty>();
        }
        this.m_extendedProperties.add(extendedProperty);
    }

    public void addFeatureToken(FeatureToken featureToken) {
        if (this.m_featureTokens == null) {
            this.m_featureTokens = new ArrayList<FeatureToken>();
        }
        this.m_featureTokens.add(featureToken);
    }

    public void addICCTag(ICCTag iccTag) {
        if (this.m_iccTags == null) {
            this.m_iccTags = new ArrayList<ICCTag>();
        }
        this.m_iccTags.add(iccTag);
    }

    public void addInvoiceEmailAddress(EmailAddress emailAddress) {
        if (this.m_invoiceEmailAddresses == null) {
            this.m_invoiceEmailAddresses = new ArrayList<EmailAddress>();
        }
        this.m_invoiceEmailAddresses.add(emailAddress);
    }

    public void addInvoicePhoneNumber(PhoneNumber phoneNumber) {
        if (this.m_invoicePhoneNumbers == null) {
            this.m_invoicePhoneNumbers = new ArrayList<PhoneNumber>();
        }
        this.m_invoicePhoneNumbers.add(phoneNumber);
    }

    public void addProduct(Product product) {
        if (this.m_products == null) {
            this.m_products = new ArrayList<Product>();
        }
        this.m_products.add(product);
    }

    protected void generateRequestXml(XMLWriter writer) throws CardEaseXMLRequestException {
        try {
            int id;
            writer.writeStartDocument(true);
            writer.writeStartElement("Request");
            writer.writeAttributeString("type", "CardEaseXML");
            if (this.m_cardEaseXMLVersion != null) {
                writer.writeAttributeString("version", this.m_cardEaseXMLVersion);
            }
            writer.writeStartElement("TransactionDetails");
            writer.writeStartElement("MessageType");
            if (this.m_autoConfirm) {
                writer.writeAttributeString("autoconfirm", "true");
            }
            if (this.m_omniSale.booleanValue()) {
                writer.writeAttributeString("omniSale", "true");
            }
            if (!(this.m_requestType != RequestType.DeferredAuth && this.m_requestType != RequestType.Offline || this.m_autoConfirm)) {
                writer.writeAttributeString("autoconfirm", "false");
            }
            if (this.m_requestType == RequestType.Conf && !this.m_allowMultipleConfirms) {
                writer.writeAttributeString("allowMultipleConfirm", "false");
            }
            if (this.m_subType != null) {
                writer.writeAttributeString("subtype", this.m_subType);
            }
            writer.writeString(this.m_requestType.toString());
            writer.writeEndElement();
            if (this.m_offlineDateTime != null) {
                writer.writeStartElement("OfflineDateTime");
                if (this.m_offlineDateTimeFormat != null) {
                    writer.writeAttributeString("format", this.m_offlineDateTimeFormat);
                }
                writer.writeString(this.m_offlineDateTime);
                writer.writeEndElement();
            }
            if (this.m_originatingIPAddress != null) {
                writer.writeElementString("OriginatingIP", this.m_originatingIPAddress);
            }
            if (this.m_userReference != null) {
                writer.writeElementString("Reference", this.m_userReference);
            }
            if (this.m_transactionLinks != null) {
                writer.writeStartElement("TransactionLinks");
                if (this.m_transactionLinks.size() > 0) {
                    for (int i = 0; i < this.m_transactionLinks.size(); ++i) {
                        if (this.m_transactionLinks.get(i).getGuid() == null || this.m_transactionLinks.get(i).getTransactionLinkType() == null) continue;
                        writer.writeStartElement("Link");
                        writer.writeAttributeString("type", this.m_transactionLinks.get(i).getTransactionLinkType().toString());
                        writer.writeString(this.m_transactionLinks.get(i).getGuid());
                        writer.writeEndElement();
                    }
                }
                writer.writeEndElement();
            }
            if (this.m_deliveryAddress != null && !this.m_deliveryAddress.isEmpty() || this.m_deliveryEmailAddresses != null && this.m_deliveryEmailAddresses.size() != 0 || this.m_deliveryName != null && !this.m_deliveryName.isEmpty() || this.m_deliveryPhoneNumbers != null && this.m_deliveryPhoneNumbers.size() != 0) {
                writer.writeStartElement("Delivery");
                if (this.m_deliveryAddress != null && !this.m_deliveryAddress.isEmpty()) {
                    writer.writeStartElement("Address");
                    writer.writeAttributeString("format", "standard");
                    if (this.m_deliveryAddress.getRecipient() != null) {
                        List<String> recipient = this.m_deliveryAddress.getRecipient();
                        for (id = 0; id < recipient.size(); ++id) {
                            writer.writeStartElement("Recipient");
                            writer.writeAttributeString("id", Integer.toString(id + 1));
                            writer.writeString(recipient.get(id).toString());
                            writer.writeEndElement();
                        }
                    }
                    if (this.m_deliveryAddress.getLines() != null) {
                        List<String> lines = this.m_deliveryAddress.getLines();
                        for (id = 0; id < lines.size(); ++id) {
                            writer.writeStartElement("Line");
                            writer.writeAttributeString("id", Integer.toString(id + 1));
                            writer.writeString(lines.get(id).toString());
                            writer.writeEndElement();
                        }
                    }
                    if (this.m_deliveryAddress.getCity() != null) {
                        writer.writeElementString("City", this.m_deliveryAddress.getCity());
                    }
                    if (this.m_deliveryAddress.getState() != null) {
                        writer.writeElementString("State", this.m_deliveryAddress.getState());
                    }
                    if (this.m_deliveryAddress.getZipCode() != null) {
                        writer.writeElementString("ZipCode", this.m_deliveryAddress.getZipCode());
                    }
                    if (this.m_deliveryAddress.getCountry() != null) {
                        writer.writeElementString("Country", this.m_deliveryAddress.getCountry());
                    }
                    writer.writeEndElement();
                }
                if (this.m_deliveryEmailAddresses != null && this.m_deliveryEmailAddresses.size() != 0 || this.m_deliveryName != null && !this.m_deliveryName.isEmpty() || this.m_deliveryPhoneNumbers != null && this.m_deliveryPhoneNumbers.size() != 0) {
                    int id2;
                    writer.writeStartElement("Contact");
                    if (this.m_deliveryEmailAddresses != null && this.m_deliveryEmailAddresses.size() != 0) {
                        writer.writeStartElement("EmailAddressList");
                        for (id2 = 0; id2 < this.m_deliveryEmailAddresses.size(); ++id2) {
                            EmailAddress emailAddress = this.m_deliveryEmailAddresses.get(id2);
                            writer.writeStartElement("EmailAddress");
                            writer.writeAttributeString("id", Integer.toString(id2 + 1));
                            writer.writeAttributeString("type", emailAddress.getType().toString());
                            writer.writeString(emailAddress.getAddress());
                            writer.writeEndElement();
                        }
                        writer.writeEndElement();
                    }
                    if (this.m_deliveryName != null && !this.m_deliveryName.isEmpty()) {
                        writer.writeStartElement("Name");
                        if (this.m_deliveryName.getTitle() != null) {
                            writer.writeElementString("Title", this.m_deliveryName.getTitle());
                        }
                        if (this.m_deliveryName.getFirstName() != null) {
                            writer.writeElementString("FirstName", this.m_deliveryName.getFirstName());
                        }
                        if (this.m_deliveryName.getInitials() != null) {
                            writer.writeElementString("Initials", this.m_deliveryName.getInitials());
                        }
                        if (this.m_deliveryName.getLastName() != null) {
                            writer.writeElementString("LastName", this.m_deliveryName.getLastName());
                        }
                        writer.writeEndElement();
                    }
                    if (this.m_deliveryPhoneNumbers != null && this.m_deliveryPhoneNumbers.size() != 0) {
                        writer.writeStartElement("PhoneNumberList");
                        for (id2 = 0; id2 < this.m_deliveryPhoneNumbers.size(); ++id2) {
                            PhoneNumber phoneNumber = this.m_deliveryPhoneNumbers.get(id2);
                            writer.writeStartElement("PhoneNumber");
                            writer.writeAttributeString("id", Integer.toString(id2 + 1));
                            writer.writeAttributeString("type", phoneNumber.getType().toString());
                            writer.writeString(phoneNumber.getNumber());
                            writer.writeEndElement();
                        }
                        writer.writeEndElement();
                    }
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            if (this.m_extendedProperties != null && this.m_extendedProperties.size() != 0) {
                writer.writeStartElement("ExtendedPropertyList");
                for (ExtendedProperty extendedProperty : this.m_extendedProperties) {
                    writer.writeStartElement("ExtendedProperty");
                    writer.writeAttributeString("id", extendedProperty.getName());
                    writer.writeString(extendedProperty.getValue());
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            if (this.m_merchantDefinedFields != null && this.m_merchantDefinedFields.size() > 0) {
                writer.writeStartElement("MerchantDefinedFields");
                for (String fieldKey : this.m_merchantDefinedFields.keySet()) {
                    if (this.m_merchantDefinedFields.get(fieldKey) == null) continue;
                    writer.writeStartElement("Field");
                    writer.writeAttributeString("id", MerchantDefinedFieldsKeys.getXmlId(fieldKey));
                    writer.writeString(this.m_merchantDefinedFields.get(fieldKey));
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            if (this.m_invoiceAddress != null && !this.m_invoiceAddress.isEmpty() || this.m_invoiceEmailAddresses != null && this.m_invoiceEmailAddresses.size() != 0 || this.m_invoiceName != null && !this.m_invoiceName.isEmpty() || this.m_invoicePhoneNumbers != null && this.m_invoicePhoneNumbers.size() != 0) {
                writer.writeStartElement("Invoice");
                if (this.m_invoiceAddress != null && !this.m_invoiceAddress.isEmpty()) {
                    writer.writeStartElement("Address");
                    writer.writeAttributeString("format", "standard");
                    if (this.m_invoiceAddress.getRecipient() != null) {
                        List<String> recipient = this.m_invoiceAddress.getRecipient();
                        for (id = 0; id < recipient.size(); ++id) {
                            writer.writeStartElement("Recipient");
                            writer.writeAttributeString("id", Integer.toString(id + 1));
                            writer.writeString(recipient.get(id).toString());
                            writer.writeEndElement();
                        }
                    }
                    if (this.m_invoiceAddress.getLines() != null) {
                        List<String> lines = this.m_invoiceAddress.getLines();
                        for (id = 0; id < lines.size(); ++id) {
                            writer.writeStartElement("Line");
                            writer.writeAttributeString("id", Integer.toString(id + 1));
                            writer.writeString(lines.get(id).toString());
                            writer.writeEndElement();
                        }
                    }
                    if (this.m_invoiceAddress.getCity() != null) {
                        writer.writeElementString("City", this.m_invoiceAddress.getCity());
                    }
                    if (this.m_invoiceAddress.getState() != null) {
                        writer.writeElementString("State", this.m_invoiceAddress.getState());
                    }
                    if (this.m_invoiceAddress.getZipCode() != null) {
                        writer.writeElementString("ZipCode", this.m_invoiceAddress.getZipCode());
                    }
                    if (this.m_invoiceAddress.getCountry() != null) {
                        writer.writeElementString("Country", this.m_invoiceAddress.getCountry());
                    }
                    writer.writeEndElement();
                }
                if (this.m_invoiceEmailAddresses != null && this.m_invoiceEmailAddresses.size() != 0 || this.m_invoiceName != null && !this.m_invoiceName.isEmpty() || this.m_invoicePhoneNumbers != null && this.m_invoicePhoneNumbers.size() != 0) {
                    writer.writeStartElement("Contact");
                    if (this.m_invoiceEmailAddresses != null && this.m_invoiceEmailAddresses.size() != 0) {
                        writer.writeStartElement("EmailAddressList");
                        for (int id3 = 0; id3 < this.m_invoiceEmailAddresses.size(); ++id3) {
                            EmailAddress emailAddress = this.m_invoiceEmailAddresses.get(id3);
                            writer.writeStartElement("EmailAddress");
                            writer.writeAttributeString("id", Integer.toString(id3 + 1));
                            writer.writeAttributeString("type", emailAddress.getType().toString());
                            writer.writeString(emailAddress.getAddress());
                            writer.writeEndElement();
                        }
                        writer.writeEndElement();
                    }
                    if (this.m_invoiceName != null && !this.m_invoiceName.isEmpty()) {
                        writer.writeStartElement("Name");
                        if (this.m_invoiceName.getTitle() != null) {
                            writer.writeElementString("Title", this.m_invoiceName.getTitle());
                        }
                        if (this.m_invoiceName.getFirstName() != null) {
                            writer.writeElementString("FirstName", this.m_invoiceName.getFirstName());
                        }
                        if (this.m_invoiceName.getInitials() != null) {
                            writer.writeElementString("Initials", this.m_invoiceName.getInitials());
                        }
                        if (this.m_invoiceName.getLastName() != null) {
                            writer.writeElementString("LastName", this.m_invoiceName.getLastName());
                        }
                        writer.writeEndElement();
                    }
                    if (this.m_invoicePhoneNumbers != null && this.m_invoicePhoneNumbers.size() != 0) {
                        writer.writeStartElement("PhoneNumberList");
                        for (int id4 = 0; id4 < this.m_invoicePhoneNumbers.size(); ++id4) {
                            PhoneNumber phoneNumber = this.m_invoicePhoneNumbers.get(id4);
                            writer.writeStartElement("PhoneNumber");
                            writer.writeAttributeString("id", Integer.toString(id4 + 1));
                            writer.writeAttributeString("type", phoneNumber.getType().toString());
                            writer.writeString(phoneNumber.getNumber());
                            writer.writeEndElement();
                        }
                        writer.writeEndElement();
                    }
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            if (this.m_products != null && this.m_products.size() != 0) {
                writer.writeStartElement("ProductList");
                for (int id5 = 0; id5 < this.m_products.size(); ++id5) {
                    writer.writeStartElement("Product");
                    writer.writeAttributeString("id", Integer.toString(id5 + 1));
                    Product product = this.m_products.get(id5);
                    if (product.getAmount() != null) {
                        writer.writeStartElement("Amount");
                        if (product.getAmountUnit() == AmountUnit.Major) {
                            writer.writeAttributeString("unit", "major");
                        }
                        writer.writeString(product.getAmount());
                        writer.writeEndElement();
                    }
                    if (product.getCategory() != null) {
                        writer.writeElementString("Category", product.getCategory());
                    }
                    if (product.getCode() != null) {
                        writer.writeElementString("Code", product.getCode());
                    }
                    if (product.getDescription() != null) {
                        writer.writeElementString("Description", product.getDescription());
                    }
                    if (product.getCurrencyCode() != null) {
                        writer.writeElementString("CurrencyCode", product.getCurrencyCode());
                    }
                    if (product.getName() != null) {
                        writer.writeElementString("Name", product.getName());
                    }
                    if (product.getQuantity() != null) {
                        writer.writeElementString("Quantity", product.getQuantity());
                    }
                    if (product.getRisk() != null) {
                        writer.writeElementString("Risk", product.getRisk().toString());
                    }
                    if (product.getType() != null) {
                        writer.writeElementString("Type", product.getType());
                    }
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            if (this.m_batchReference != null) {
                writer.writeElementString("BatchReference", this.m_batchReference);
            }
            if (this.m_cardEaseReference != null) {
                writer.writeElementString("CardEaseReference", this.m_cardEaseReference);
            }
            if (this.m_amount != null) {
                writer.writeStartElement("Amount");
                if (this.m_amountUnit == AmountUnit.Major) {
                    writer.writeAttributeString("unit", "major");
                }
                if (this.m_amountType != AmountType.Unknown) {
                    writer.writeAttributeString("type", this.m_amountType.toString());
                }
                if (this.m_amountOther != null) {
                    writer.writeAttributeString("other", this.m_amountOther);
                }
                if (this.m_amountOtherTransactionFee != null) {
                    writer.writeAttributeString("otherTransactionFee", this.m_amountOtherTransactionFee);
                }
                if (this.m_amountTip != null) {
                    writer.writeAttributeString("tip", this.m_amountTip);
                }
                writer.writeString(this.m_amount);
                writer.writeEndElement();
            }
            if (this.m_purchaseLevel2Data != null) {
                writer.writeStartElement("Level2Data");
                if (this.m_purchaseLevel2Data.getPONumber() != null && !this.m_purchaseLevel2Data.getPONumber().isEmpty()) {
                    writer.writeElementString("PONumber", this.m_purchaseLevel2Data.getPONumber());
                }
                if (this.m_purchaseLevel2Data.getTaxAmount() != null && !this.m_purchaseLevel2Data.getTaxAmount().isEmpty()) {
                    writer.writeElementString("TaxAmount", this.m_purchaseLevel2Data.getTaxAmount());
                }
                writer.writeEndElement();
            }
            if (this.m_currencyCode != null) {
                writer.writeElementString("CurrencyCode", this.m_currencyCode);
            }
            if (this.m_customerVaultCommand != null) {
                writer.writeElementString("GwCustomerVault", this.m_customerVaultCommand);
            }
            if (this.m_customerVaultId != null) {
                writer.writeElementString("GwCustomerVaultId", this.m_customerVaultId);
            }
            if (this.m_merchantProcessorId != null) {
                writer.writeElementString("MerchantProcessorId", this.m_merchantProcessorId);
            }
            if (this.m_debtRepayment) {
                writer.writeStartElement("DebtRepayment");
                writer.writeString(Boolean.toString(this.getDebtRepayment()));
                writer.writeEndElement();
            }
            if (this.m_billingInformation != null) {
                writer.writeStartElement("BillingDetails");
                if (this.m_billingInformation.getLine1() != null && !this.m_billingInformation.getLine1().isEmpty() || this.m_billingInformation.getLine2() != null && !this.m_billingInformation.getLine2().isEmpty() || this.m_billingInformation.getCity() != null && !this.m_billingInformation.getCity().isEmpty() || this.m_billingInformation.getState() != null && !this.m_billingInformation.getState().isEmpty() || this.m_billingInformation.getZipCode() != null && !this.m_billingInformation.getZipCode().isEmpty() || this.m_billingInformation.getCountry() != null && !this.m_billingInformation.getCountry().isEmpty()) {
                    writer.writeStartElement("Address");
                    if (this.m_billingInformation.getLine1() != null) {
                        writer.writeStartElement("Line");
                        writer.writeAttributeString("id", Integer.toString(1));
                        writer.writeString(this.m_billingInformation.getLine1());
                        writer.writeEndElement();
                    }
                    if (this.m_billingInformation.getLine2() != null) {
                        writer.writeStartElement("Line");
                        writer.writeAttributeString("id", Integer.toString(2));
                        writer.writeString(this.m_billingInformation.getLine2());
                        writer.writeEndElement();
                    }
                    if (this.m_billingInformation.getCity() != null) {
                        writer.writeElementString("City", this.m_billingInformation.getCity());
                    }
                    if (this.m_billingInformation.getState() != null) {
                        writer.writeElementString("State", this.m_billingInformation.getState());
                    }
                    if (this.m_billingInformation.getZipCode() != null) {
                        writer.writeElementString("ZipCode", this.m_billingInformation.getZipCode());
                    }
                    if (this.m_billingInformation.getCountry() != null) {
                        writer.writeElementString("Country", this.m_billingInformation.getCountry());
                    }
                    writer.writeEndElement();
                }
                if (this.m_billingInformation.getEmailAddress() != null) {
                    writer.writeElementString("Email", this.m_billingInformation.getEmailAddress());
                }
                if (this.m_billingInformation.getTelephoneNumber() != null) {
                    writer.writeElementString("TelephoneNumber", this.m_billingInformation.getTelephoneNumber());
                }
                writer.writeEndElement();
            }
            if (this.m_dcc != null && this.m_dcc.getAmount() != null) {
                writer.writeStartElement("DCC");
                writer.writeElementString("CurrencyCode", this.m_dcc.getCurrencyCode());
                writer.writeStartElement("Amount");
                if (this.m_dcc.getAmountUnit() == AmountUnit.Major) {
                    writer.writeAttributeString("unit", "major");
                }
                if (this.m_dcc.getAmountOther() != null) {
                    writer.writeAttributeString("other", this.m_dcc.getAmountOther());
                }
                if (this.m_dcc.getAmountOtherTransactionFee() != null) {
                    writer.writeAttributeString("otherTransactionFee", this.m_dcc.getAmountOtherTransactionFee());
                }
                if (this.m_dcc.getAmountTip() != null) {
                    writer.writeAttributeString("tip", this.m_dcc.getAmountTip());
                }
                writer.writeString(this.m_dcc.getAmount());
                writer.writeEndElement();
                writer.writeElementString("ExchangeRate", this.m_dcc.getExchangeRate());
                writer.writeElementString("MarginRate", this.m_dcc.getMarginRate());
                if (this.m_dcc.getCommissionAmount() != null) {
                    writer.writeStartElement("CommissionAmount");
                    if (this.m_dcc.getCommisssionAmountUnit() == AmountUnit.Major) {
                        writer.writeAttributeString("unit", "major");
                    }
                    writer.writeString(this.m_dcc.getCommissionAmount());
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            if (this.m_requestType == RequestType.VoiceReferralNotification) {
                writer.writeElementString("VoiceReferralResult", this.m_voiceReferralResult.toString());
            }
            if ((this.m_requestType == RequestType.VoiceReferralNotification || this.m_requestType == RequestType.Offline || this.m_requestType == RequestType.DeferredAuth) && this.m_authCode != null) {
                writer.writeElementString("AuthCode", this.m_authCode);
            }
            if (this.m_voidReason != VoidReason.Empty) {
                writer.writeElementString("VoidReason", this.m_voidReason.toString());
            }
            if (this.m_transactionId != null) {
                writer.writeElementString("GwTransactionId", this.m_transactionId);
            }
            writer.writeEndElement();
            writer.writeStartElement("TerminalDetails");
            if (this.m_platformName != null) {
                writer.writeStartElement("Platform");
                if (this.m_platformVersion != null) {
                    writer.writeAttributeString("version", this.m_platformVersion);
                }
                writer.writeString(this.m_platformName);
                writer.writeEndElement();
            }
            if (this.m_terminalID != null) {
                writer.writeElementString("TerminalID", this.m_terminalID);
            }
            if (this.m_transactionKey != null) {
                writer.writeElementString("TransactionKey", this.m_transactionKey);
            }
            if (this.m_machineReference != null) {
                writer.writeElementString("MachineReference", this.m_machineReference);
            }
            if (this.m_softwareName != null) {
                writer.writeStartElement("Software");
                if (this.m_softwareVersion != null) {
                    writer.writeAttributeString("version", this.m_softwareVersion);
                }
                writer.writeString(this.m_softwareName);
                writer.writeEndElement();
            }
            if (this.m_featureTokens != null && this.m_featureTokens.size() != 0) {
                writer.writeStartElement("FeatureTokens");
                for (FeatureToken token : this.m_featureTokens) {
                    writer.writeElementString("Token", token.getValue());
                }
                writer.writeEndElement();
            }
            if (this.m_pointOfInteraction != null) {
                writer.writeStartElement("POI");
                if (this.m_pointOfInteraction.getMake() != null) {
                    writer.writeAttributeString("make", this.m_pointOfInteraction.getMake());
                }
                if (this.m_pointOfInteraction.getModel() != null) {
                    writer.writeAttributeString("model", this.m_pointOfInteraction.getModel());
                }
                if (this.m_pointOfInteraction.getSerialNumber() != null) {
                    writer.writeAttributeString("serialNumber", this.m_pointOfInteraction.getSerialNumber());
                }
                if (this.m_pointOfInteraction.getFirmwareName() != null) {
                    writer.writeAttributeString("firmwareName", this.m_pointOfInteraction.getFirmwareName());
                }
                if (this.m_pointOfInteraction.getFirmwareVersion() != null) {
                    writer.writeAttributeString("firmwareVersion", this.m_pointOfInteraction.getFirmwareVersion());
                }
                writer.writeEndElement();
            }
            if (this.m_apiKey != null) {
                writer.writeElementString("ApiKey", this.m_apiKey);
            }
            if (this.m_laneId != null) {
                writer.writeElementString("LaneId", this.m_laneId);
            }
            if (this.m_posGuid != null) {
                writer.writeElementString("PosGuid", this.m_posGuid);
            }
            if (this.m_applicationId != null) {
                writer.writeElementString("ApplicationId", this.m_applicationId);
            }
            writer.writeStartElement("Component");
            writer.writeAttributeString("version", Client.getCardEaseXMLSDKVersion());
            writer.writeString(Client.getCardEaseXMLSDKName());
            writer.writeEndElement();
            this.parseTerminalProperties(writer);
            writer.writeEndElement();
            if (this.isCardDetailsNodeNeeded()) {
                writer.writeStartElement("CardDetails");
                if (this.m_iccTags != null && this.m_iccTags.size() != 0) {
                    writer.writeStartElement("ICC");
                    if (this.m_contactless) {
                        writer.writeAttributeString("contactless", "true");
                    }
                    writer.writeAttributeString("type", this.m_iccType);
                    for (ICCTag tag : this.m_iccTags) {
                        if (tag == null) continue;
                        writer.writeStartElement("ICCTag");
                        writer.writeAttributeString("tagid", tag.getID());
                        if (tag.getType() == ICCTagValueType.String) {
                            writer.writeAttributeString("type", "string");
                        }
                        writer.writeString(tag.getValue());
                        writer.writeEndElement();
                    }
                    writer.writeEndElement();
                } else if (this.m_track2 != null) {
                    writer.writeStartElement("CAT");
                    if (this.m_contactless) {
                        writer.writeAttributeString("contactless", "true");
                    }
                    if (this.m_iccFallback) {
                        writer.writeAttributeString("fallback", "true");
                    }
                    if (this.m_track1 != null) {
                        writer.writeElementString("Track1", this.m_track1);
                    }
                    if (this.m_track2 != null) {
                        writer.writeElementString("Track2", this.m_track2);
                    }
                    if (this.m_track3 != null) {
                        writer.writeElementString("Track3", this.m_track3);
                    }
                    writer.writeEndElement();
                } else if (this.m_encryptedPanKeyEntryData != null) {
                    writer.writeStartElement("Manual");
                    writer.writeAttributeString("type", "cnp");
                    writer.writeElementString("EncryptedData", this.m_encryptedPanKeyEntryData);
                    writer.writeEndElement();
                } else if (this.m_pan != null || this.m_cardReference != null) {
                    writer.writeStartElement("Manual");
                    if (this.m_manualType != null) {
                        writer.writeAttributeString("type", this.m_manualType);
                    }
                    if (this.m_cardReference != null) {
                        writer.writeElementString("CardReference", this.m_cardReference);
                    }
                    if (this.m_cardHash != null) {
                        writer.writeElementString("CardHash", this.m_cardHash);
                    }
                    if (this.m_pan != null) {
                        writer.writeElementString("PAN", this.m_pan);
                    }
                    if (this.m_expiryDate != null) {
                        writer.writeStartElement("ExpiryDate");
                        if (this.m_expiryDateFormat != null) {
                            writer.writeAttributeString("format", this.m_expiryDateFormat);
                        }
                        writer.writeString(this.m_expiryDate);
                        writer.writeEndElement();
                    }
                    if (this.m_startDate != null) {
                        writer.writeStartElement("StartDate");
                        if (this.m_startDateFormat != null) {
                            writer.writeAttributeString("format", this.m_startDateFormat);
                        }
                        writer.writeString(this.m_startDate);
                        writer.writeEndElement();
                    }
                    if (this.m_issueNumber != null) {
                        writer.writeElementString("IssueNumber", this.m_issueNumber);
                    }
                    writer.writeEndElement();
                }
                if (this.m_address != null || this.m_csc != null || this.m_zipCode != null) {
                    writer.writeStartElement("AdditionalVerification");
                    if (this.m_address != null) {
                        writer.writeElementString("Address", this.m_address);
                    }
                    if (this.m_csc != null) {
                        writer.writeElementString("CSC", this.m_csc);
                    }
                    if (this.m_zipCode != null) {
                        writer.writeElementString("Zip", this.m_zipCode);
                    }
                    writer.writeEndElement();
                }
                if (this.m_cardHolderAddress != null && !this.m_cardHolderAddress.isEmpty()) {
                    writer.writeStartElement("Address");
                    writer.writeAttributeString("format", "standard");
                    if (this.m_cardHolderAddress.getRecipient() != null) {
                        List<String> recipient = this.m_cardHolderAddress.getRecipient();
                        for (id = 0; id < recipient.size(); ++id) {
                            writer.writeStartElement("Recipient");
                            writer.writeAttributeString("id", Integer.toString(id + 1));
                            writer.writeString(recipient.get(id).toString());
                            writer.writeEndElement();
                        }
                    }
                    if (this.m_cardHolderAddress.getLines() != null) {
                        List<String> lines = this.m_cardHolderAddress.getLines();
                        for (id = 0; id < lines.size(); ++id) {
                            writer.writeStartElement("Line");
                            writer.writeAttributeString("id", Integer.toString(id + 1));
                            writer.writeString(lines.get(id).toString());
                            writer.writeEndElement();
                        }
                    }
                    if (this.m_cardHolderAddress.getCity() != null) {
                        writer.writeElementString("City", this.m_cardHolderAddress.getCity());
                    }
                    if (this.m_cardHolderAddress.getState() != null) {
                        writer.writeElementString("State", this.m_cardHolderAddress.getState());
                    }
                    if (this.m_cardHolderAddress.getZipCode() != null) {
                        writer.writeElementString("ZipCode", this.m_cardHolderAddress.getZipCode());
                    }
                    if (this.m_cardHolderAddress.getCountry() != null) {
                        writer.writeElementString("Country", this.m_cardHolderAddress.getCountry());
                    }
                    writer.writeEndElement();
                }
                if (this.m_cardHolderEmailAddresses != null && this.m_cardHolderEmailAddresses.size() != 0 || this.m_cardHolderName != null && !this.m_cardHolderName.isEmpty() || this.m_cardHolderPhoneNumbers != null && this.m_cardHolderPhoneNumbers.size() != 0) {
                    writer.writeStartElement("Contact");
                    if (this.m_cardHolderEmailAddresses != null && this.m_cardHolderEmailAddresses.size() != 0) {
                        writer.writeStartElement("EmailAddressList");
                        for (int id6 = 0; id6 < this.m_cardHolderEmailAddresses.size(); ++id6) {
                            EmailAddress emailAddress = this.m_cardHolderEmailAddresses.get(id6);
                            writer.writeStartElement("EmailAddress");
                            writer.writeAttributeString("id", Integer.toString(id6 + 1));
                            writer.writeAttributeString("type", emailAddress.getType().toString());
                            writer.writeString(emailAddress.getAddress());
                            writer.writeEndElement();
                        }
                        writer.writeEndElement();
                    }
                    if (this.m_cardHolderName != null && !this.m_cardHolderName.isEmpty()) {
                        writer.writeStartElement("Name");
                        if (this.m_cardHolderName.getTitle() != null) {
                            writer.writeElementString("Title", this.m_cardHolderName.getTitle());
                        }
                        if (this.m_cardHolderName.getFirstName() != null) {
                            writer.writeElementString("FirstName", this.m_cardHolderName.getFirstName());
                        }
                        if (this.m_cardHolderName.getInitials() != null) {
                            writer.writeElementString("Initials", this.m_cardHolderName.getInitials());
                        }
                        if (this.m_cardHolderName.getLastName() != null) {
                            writer.writeElementString("LastName", this.m_cardHolderName.getLastName());
                        }
                        writer.writeEndElement();
                    }
                    if (this.m_cardHolderPhoneNumbers != null && this.m_cardHolderPhoneNumbers.size() != 0) {
                        writer.writeStartElement("PhoneNumberList");
                        for (int id7 = 0; id7 < this.m_cardHolderPhoneNumbers.size(); ++id7) {
                            PhoneNumber phoneNumber = this.m_cardHolderPhoneNumbers.get(id7);
                            writer.writeStartElement("PhoneNumber");
                            writer.writeAttributeString("id", Integer.toString(id7 + 1));
                            writer.writeAttributeString("type", phoneNumber.getType().toString());
                            writer.writeString(phoneNumber.getNumber());
                            writer.writeEndElement();
                        }
                        writer.writeEndElement();
                    }
                    writer.writeEndElement();
                }
                if (this.m_3DSecureCardHolderEnrolled != ThreeDSecureCardHolderEnrolled.Empty || this.m_3DSecureTransactionStatus != ThreeDSecureTransactionStatus.Empty) {
                    writer.writeStartElement("ThreeDSecure");
                    if (this.m_3DSecureVersion != null && !this.m_3DSecureVersion.isEmpty()) {
                        writer.writeAttributeString("version", this.m_3DSecureVersion);
                    }
                    if (this.m_3DSecureCardHolderEnrolled != ThreeDSecureCardHolderEnrolled.Empty) {
                        writer.writeElementString("CardHolderEnrolled", this.m_3DSecureCardHolderEnrolled.toString());
                    }
                    if (this.m_3DSecureDirectoryServerTransactionId != null && !this.m_3DSecureDirectoryServerTransactionId.isEmpty()) {
                        writer.writeElementString("DirectoryServerTransactionID", this.m_3DSecureDirectoryServerTransactionId);
                    }
                    if (this.m_3DSecureServerTransactionId != null && !this.m_3DSecureServerTransactionId.isEmpty()) {
                        writer.writeElementString("ThreeDSecureServerTransactionID", this.m_3DSecureServerTransactionId);
                    }
                    if (this.m_3DSecureECI != null) {
                        writer.writeElementString("ECI", this.m_3DSecureECI);
                    }
                    if (this.m_3DSecureIAV != null) {
                        writer.writeStartElement("IAV");
                        if (this.m_3DSecureIAVAlgorithm != null) {
                            writer.writeAttributeString("algorithm", this.m_3DSecureIAVAlgorithm);
                        }
                        writer.writeAttributeString("format", this.m_3DSecureIAVFormat.toString());
                        writer.writeString(this.m_3DSecureIAV);
                        writer.writeEndElement();
                    }
                    if (this.m_3DSecureTransactionStatus != ThreeDSecureTransactionStatus.Empty) {
                        writer.writeElementString("TransactionStatus", this.m_3DSecureTransactionStatus.toString());
                    }
                    if (this.m_3DSecureXID != null) {
                        writer.writeStartElement("XID");
                        writer.writeAttributeString("format", this.m_3DSecureXIDFormat.toString());
                        writer.writeString(this.m_3DSecureXID);
                        writer.writeEndElement();
                    }
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            if (this.m_credentialOnFile != null) {
                writer.writeStartElement("CredentialOnFile");
                writer.writeAttributeString("initiatedBy", this.m_credentialOnFile.getInitiatedBy().toString());
                if (this.m_credentialOnFile.getInitiatedBy() == TransactionInitiatedBy.Merchant || this.m_credentialOnFile.getInitiatedBy() == TransactionInitiatedBy.CardHolder) {
                    if (this.m_credentialOnFile.getReason() == TransactionReason.Empty) {
                        writer.writeAttributeString("reason", "NA");
                    } else {
                        writer.writeAttributeString("reason", this.m_credentialOnFile.getReason().toString());
                    }
                }
                if (this.m_credentialOnFile.getCardEaseReference() != null && this.m_credentialOnFile.getCardEaseReference().length() > 0) {
                    writer.writeAttributeString("cardEaseReference", this.m_credentialOnFile.getCardEaseReference());
                }
                if (this.m_credentialOnFile.getFirstStore() == TransactionFirstStore.True) {
                    writer.writeAttributeString("firstStore", "True");
                } else if (this.m_credentialOnFile.getFirstStore() == TransactionFirstStore.False) {
                    writer.writeAttributeString("firstStore", "False");
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.close();
        }
        catch (IOException e) {
            throw new CardEaseXMLRequestException("Unable to generate XML for request", e);
        }
    }

    void parseTerminalProperties(XMLWriter writer) throws CardEaseXMLRequestException {
        try {
            if (this.m_terminalCapabilities != null || this.m_certificationIdentifier != null) {
                writer.writeStartElement("TerminalProperties");
                if (this.m_certificationIdentifier != null) {
                    writer.writeElementString("CertificationIdentifier", this.m_certificationIdentifier);
                }
                if (this.m_terminalCapabilities != null) {
                    this.parseTerminalCapabilities(writer);
                }
                writer.writeEndElement();
            }
        }
        catch (IOException e) {
            throw new CardEaseXMLRequestException("Unable to generate XML for request", e);
        }
    }

    void parseTerminalCapabilities(XMLWriter writer) throws CardEaseXMLRequestException {
        try {
            writer.writeStartElement("TerminalCapabilities");
            if (this.m_terminalCapabilities.terminalCapabilitiesGeneric != null) {
                if (this.m_terminalCapabilities.terminalCapabilitiesGeneric.attendedType != null) {
                    writer.writeStartElement("AttendedType");
                    writer.writeString(this.m_terminalCapabilities.terminalCapabilitiesGeneric.attendedType);
                    writer.writeEndElement();
                }
                if (this.m_terminalCapabilities.terminalCapabilitiesGeneric.deviceType != null) {
                    writer.writeStartElement("DeviceType");
                    writer.writeString(this.m_terminalCapabilities.terminalCapabilitiesGeneric.deviceType);
                    writer.writeEndElement();
                }
                if (this.m_terminalCapabilities.terminalCapabilitiesGeneric.mobilePos != null) {
                    writer.writeStartElement("MobilePos");
                    writer.writeString(this.m_terminalCapabilities.terminalCapabilitiesGeneric.mobilePos);
                    writer.writeEndElement();
                }
                if (this.m_terminalCapabilities.terminalCapabilitiesGeneric.premises != null) {
                    writer.writeStartElement("Premises");
                    writer.writeString(this.m_terminalCapabilities.terminalCapabilitiesGeneric.premises);
                    writer.writeEndElement();
                }
            }
            if (this.m_terminalCapabilities.terminalCapabilitiesCatLevel != null) {
                this.addCatLevelsToXML(writer);
            }
            if (this.m_terminalCapabilities.terminalCapabilitiesCardInput != null) {
                writer.writeStartElement("CardInput");
                if (this.m_terminalCapabilities.terminalCapabilitiesCardInput.keyed != null) {
                    writer.writeStartElement("Keyed");
                    writer.writeString(this.m_terminalCapabilities.terminalCapabilitiesCardInput.keyed);
                    writer.writeEndElement();
                }
                if (this.m_terminalCapabilities.terminalCapabilitiesCardInput.magstripe != null) {
                    writer.writeStartElement("Magstripe");
                    writer.writeString(this.m_terminalCapabilities.terminalCapabilitiesCardInput.magstripe);
                    writer.writeEndElement();
                }
                if (this.m_terminalCapabilities.terminalCapabilitiesCardInput.contactEMV != null) {
                    writer.writeStartElement("ContactEMV");
                    writer.writeString(this.m_terminalCapabilities.terminalCapabilitiesCardInput.contactEMV);
                    writer.writeEndElement();
                }
                if (this.m_terminalCapabilities.terminalCapabilitiesCardInput.contactlessEMV != null) {
                    writer.writeStartElement("ContactlessEMV");
                    writer.writeString(this.m_terminalCapabilities.terminalCapabilitiesCardInput.contactlessEMV);
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            if (this.m_terminalCapabilities.terminalCapabilitiesCardholderAuthentication != null) {
                writer.writeStartElement("CardholderAuthentication");
                if (this.m_terminalCapabilities.terminalCapabilitiesCardholderAuthentication.signature != null) {
                    writer.writeStartElement("Signature");
                    writer.writeString(this.m_terminalCapabilities.terminalCapabilitiesCardholderAuthentication.signature);
                    writer.writeEndElement();
                }
                if (this.m_terminalCapabilities.terminalCapabilitiesCardholderAuthentication.onlinePin != null) {
                    writer.writeStartElement("OnlinePin");
                    writer.writeString(this.m_terminalCapabilities.terminalCapabilitiesCardholderAuthentication.onlinePin);
                    writer.writeEndElement();
                }
                if (this.m_terminalCapabilities.terminalCapabilitiesCardholderAuthentication.pinRetry != null) {
                    writer.writeStartElement("PinRetry");
                    writer.writeString(this.m_terminalCapabilities.terminalCapabilitiesCardholderAuthentication.pinRetry);
                    writer.writeEndElement();
                }
                if (this.m_terminalCapabilities.terminalCapabilitiesCardholderAuthentication.offlinePin != null) {
                    writer.writeStartElement("OfflinePin");
                    writer.writeString(this.m_terminalCapabilities.terminalCapabilitiesCardholderAuthentication.offlinePin);
                    writer.writeEndElement();
                }
                if (this.m_terminalCapabilities.terminalCapabilitiesCardholderAuthentication.pinBypass != null) {
                    writer.writeStartElement("PinBypass");
                    writer.writeString(this.m_terminalCapabilities.terminalCapabilitiesCardholderAuthentication.pinBypass);
                    writer.writeEndElement();
                }
                if (this.m_terminalCapabilities.terminalCapabilitiesCardholderAuthentication.cdcvm != null) {
                    writer.writeStartElement("Cdcvm");
                    writer.writeString(this.m_terminalCapabilities.terminalCapabilitiesCardholderAuthentication.cdcvm);
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            if (this.m_terminalCapabilities.terminalCapabilitiesContactEmv != null) {
                writer.writeStartElement("ContactEmv");
                if (this.m_terminalCapabilities.terminalCapabilitiesContactEmv.fallBack != null) {
                    writer.writeStartElement("FallBack");
                    writer.writeString(this.m_terminalCapabilities.terminalCapabilitiesContactEmv.fallBack);
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            if (this.m_terminalCapabilities.terminalCapabilitiesContactless != null) {
                writer.writeStartElement("Contactless");
                if (this.m_terminalCapabilities.terminalCapabilitiesContactless.fallForward != null) {
                    writer.writeStartElement("FallForward");
                    writer.writeString(this.m_terminalCapabilities.terminalCapabilitiesContactless.fallForward);
                    writer.writeEndElement();
                }
                if (this.m_terminalCapabilities.terminalCapabilitiesContactless.singleTap != null) {
                    writer.writeStartElement("SingleTap");
                    writer.writeString(this.m_terminalCapabilities.terminalCapabilitiesContactless.singleTap);
                    writer.writeEndElement();
                }
                if (this.m_terminalCapabilities.terminalCapabilitiesContactless.magstripe != null) {
                    writer.writeStartElement("Magstripe");
                    writer.writeString(this.m_terminalCapabilities.terminalCapabilitiesContactless.magstripe);
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            if (this.m_terminalCapabilities.terminalCapabilitiesEcomCnp != null || this.isThreeDSecureNodeNeeded()) {
                writer.writeStartElement("EcomCnp");
                if (this.isThreeDSecureNodeNeeded()) {
                    writer.writeStartElement("ThreeDSecure");
                    if (this.isVersionSupportedNodeNeeded()) {
                        writer.writeStartElement("VersionsSupported");
                        if (this.m_terminalCapabilities.terminalCapabilitiesThreeDSecure.threeDSecureVersion1 != null && this.m_terminalCapabilities.terminalCapabilitiesThreeDSecure.threeDSecureVersion1.equals("true")) {
                            writer.writeStartElement("Version");
                            writer.writeString("1");
                            writer.writeEndElement();
                        }
                        if (this.m_terminalCapabilities.terminalCapabilitiesThreeDSecure.threeDSecureVersion2 != null && this.m_terminalCapabilities.terminalCapabilitiesThreeDSecure.threeDSecureVersion2.equals("true")) {
                            writer.writeStartElement("Version");
                            writer.writeString("2");
                            writer.writeEndElement();
                        }
                        writer.writeEndElement();
                    }
                    if (this.isSchemeSupportedNodeNeeded()) {
                        writer.writeStartElement("SchemeSupported");
                        if (this.m_terminalCapabilities.terminalCapabilitiesThreeDSecure.visa != null && this.m_terminalCapabilities.terminalCapabilitiesThreeDSecure.visa.equals("true")) {
                            writer.writeStartElement("Scheme");
                            writer.writeString("Visa");
                            writer.writeEndElement();
                        }
                        if (this.m_terminalCapabilities.terminalCapabilitiesThreeDSecure.mastercard != null && this.m_terminalCapabilities.terminalCapabilitiesThreeDSecure.mastercard.equals("true")) {
                            writer.writeStartElement("Scheme");
                            writer.writeString("Mastercard");
                            writer.writeEndElement();
                        }
                        if (this.m_terminalCapabilities.terminalCapabilitiesThreeDSecure.amex != null && this.m_terminalCapabilities.terminalCapabilitiesThreeDSecure.amex.equals("true")) {
                            writer.writeStartElement("Scheme");
                            writer.writeString("Amex");
                            writer.writeEndElement();
                        }
                        writer.writeEndElement();
                    }
                    writer.writeEndElement();
                }
                if (this.m_terminalCapabilities.terminalCapabilitiesEcomCnp != null) {
                    if (this.m_terminalCapabilities.terminalCapabilitiesEcomCnp.avs != null) {
                        writer.writeStartElement("Avs");
                        writer.writeString(this.m_terminalCapabilities.terminalCapabilitiesEcomCnp.avs);
                        writer.writeEndElement();
                    }
                    if (this.m_terminalCapabilities.terminalCapabilitiesEcomCnp.csc != null) {
                        writer.writeStartElement("Csc");
                        writer.writeString(this.m_terminalCapabilities.terminalCapabilitiesEcomCnp.csc);
                        writer.writeEndElement();
                    }
                    if (this.m_terminalCapabilities.terminalCapabilitiesEcomCnp.ecomUrl != null) {
                        writer.writeStartElement("EcomUrl");
                        writer.writeString(this.m_terminalCapabilities.terminalCapabilitiesEcomCnp.ecomUrl);
                        writer.writeEndElement();
                    }
                }
                writer.writeEndElement();
            }
            if (this.m_terminalCapabilities.terminalCapabilitiesFeatures != null) {
                writer.writeStartElement("Features");
                if (this.m_terminalCapabilities.terminalCapabilitiesFeatures.cardCapture != null) {
                    writer.writeStartElement("CardCapture");
                    writer.writeString(this.m_terminalCapabilities.terminalCapabilitiesFeatures.cardCapture);
                    writer.writeEndElement();
                }
                if (this.m_terminalCapabilities.terminalCapabilitiesFeatures.dcc != null) {
                    writer.writeStartElement("Dcc");
                    writer.writeString(this.m_terminalCapabilities.terminalCapabilitiesFeatures.dcc);
                    writer.writeEndElement();
                }
                if (this.m_terminalCapabilities.terminalCapabilitiesFeatures.multiCurrency != null) {
                    writer.writeStartElement("MultiCurrency");
                    writer.writeString(this.m_terminalCapabilities.terminalCapabilitiesFeatures.multiCurrency);
                    writer.writeEndElement();
                }
                if (this.m_terminalCapabilities.terminalCapabilitiesFeatures.partialAuth != null) {
                    writer.writeStartElement("PartialAuth");
                    writer.writeString(this.m_terminalCapabilities.terminalCapabilitiesFeatures.partialAuth);
                    writer.writeEndElement();
                }
                if (this.m_terminalCapabilities.terminalCapabilitiesFeatures.partialReversal != null) {
                    writer.writeStartElement("PartialReversal");
                    writer.writeString(this.m_terminalCapabilities.terminalCapabilitiesFeatures.partialReversal);
                    writer.writeEndElement();
                }
                if (this.m_terminalCapabilities.terminalCapabilitiesFeatures.voiceReferral != null) {
                    writer.writeStartElement("VoiceReferral");
                    writer.writeString(this.m_terminalCapabilities.terminalCapabilitiesFeatures.voiceReferral);
                    writer.writeEndElement();
                }
                if (this.m_terminalCapabilities.terminalCapabilitiesFeatures.onDeviceTipping != null) {
                    writer.writeStartElement("OnDeviceTipping");
                    writer.writeString(this.m_terminalCapabilities.terminalCapabilitiesFeatures.onDeviceTipping);
                    writer.writeEndElement();
                }
                if (this.m_terminalCapabilities.terminalCapabilitiesFeatures.endOfDayTipping != null) {
                    writer.writeStartElement("EndOfDayTipping");
                    writer.writeString(this.m_terminalCapabilities.terminalCapabilitiesFeatures.endOfDayTipping);
                    writer.writeEndElement();
                }
                if (this.m_terminalCapabilities.terminalCapabilitiesFeatures.digitalSignature != null) {
                    writer.writeStartElement("DigitalSignature");
                    writer.writeString(this.m_terminalCapabilities.terminalCapabilitiesFeatures.digitalSignature);
                    writer.writeEndElement();
                }
                if (this.m_terminalCapabilities.terminalCapabilitiesFeatures.screen != null) {
                    writer.writeStartElement("Screen");
                    writer.writeString(this.m_terminalCapabilities.terminalCapabilitiesFeatures.screen);
                    writer.writeEndElement();
                }
                if (this.m_terminalCapabilities.terminalCapabilitiesFeatures.printer != null) {
                    writer.writeStartElement("Printer");
                    writer.writeString(this.m_terminalCapabilities.terminalCapabilitiesFeatures.printer);
                    writer.writeEndElement();
                }
                if (this.m_terminalCapabilities.terminalCapabilitiesFeatures.receipt != null) {
                    writer.writeStartElement("Receipt");
                    writer.writeString(this.m_terminalCapabilities.terminalCapabilitiesFeatures.receipt);
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        catch (IOException e) {
            throw new CardEaseXMLRequestException("Unable to generate XML for request", e);
        }
    }

    public String getCustomerVaultCommand() {
        return this.m_customerVaultCommand;
    }

    public String getCustomerVaultId() {
        return this.m_customerVaultId;
    }

    public String getLaneId() {
        return this.m_laneId;
    }

    public String getMerchantProcessorId() {
        return this.m_merchantProcessorId;
    }

    public Boolean getOmniSale() {
        return this.m_omniSale;
    }

    public ThreeDSecureCardHolderEnrolled getThreeDSecureCardHolderEnrolled() {
        return this.m_3DSecureCardHolderEnrolled;
    }

    public String getThreeDSecureDirectoryServerTransactionId() {
        return this.m_3DSecureDirectoryServerTransactionId;
    }

    public String getThreeDSecureECI() {
        return this.m_3DSecureECI;
    }

    public String getThreeDSecureIAV() {
        return this.m_3DSecureIAV;
    }

    public String getThreeDSecureIAVAlgorithm() {
        return this.m_3DSecureIAVAlgorithm;
    }

    public IAVFormat getThreeDSecureIAVFormat() {
        return this.m_3DSecureIAVFormat;
    }

    public String getThreeDSecureServerTransactionId() {
        return this.m_3DSecureServerTransactionId;
    }

    public ThreeDSecureTransactionStatus getThreeDSecureTransactionStatus() {
        return this.m_3DSecureTransactionStatus;
    }

    public String getThreeDSecureVersion() {
        return this.m_3DSecureVersion;
    }

    public String getThreeDSecureXID() {
        return this.m_3DSecureXID;
    }

    public XIDFormat getThreeDSecureXIDFormat() {
        return this.m_3DSecureXIDFormat;
    }

    public String getAddress() {
        return this.m_address;
    }

    public String getAmount() {
        return this.m_amount;
    }

    public String getAmountOther() {
        return this.m_amountOther;
    }

    public String getAmountOtherTransactionFee() {
        return this.m_amountOtherTransactionFee;
    }

    public String getAmountTip() {
        return this.m_amountTip;
    }

    public AmountUnit getAmountUnit() {
        return this.m_amountUnit;
    }

    public AmountType getAmountType() {
        return this.m_amountType;
    }

    public String getAuthCode() {
        return this.m_authCode;
    }

    public boolean getAutoConfirm() {
        return this.m_autoConfirm;
    }

    public String getBatchReference() {
        return this.m_batchReference;
    }

    public String getCardEaseReference() {
        return this.m_cardEaseReference;
    }

    public String getTransactionId() {
        return this.m_transactionId;
    }

    public HashMap<String, String> getMerchantDefinedFields() {
        return this.m_merchantDefinedFields;
    }

    public PurchaseLevel2Data getPurchaseLevel2Data() {
        return this.m_purchaseLevel2Data;
    }

    public BillingInformation getBillingInformation() {
        return this.m_billingInformation;
    }

    public TerminalCapabilities getTerminalCapabilities() {
        return this.m_terminalCapabilities;
    }

    public String getCardEaseXMLVersion() {
        return this.m_cardEaseXMLVersion;
    }

    public String getCardHash() {
        return this.m_cardHash;
    }

    public Address getCardHolderAddress() {
        return this.m_cardHolderAddress;
    }

    public List<EmailAddress> getCardHolderEmailAddresses() {
        return this.m_cardHolderEmailAddresses;
    }

    public Name getCardHolderName() {
        return this.m_cardHolderName;
    }

    public List<PhoneNumber> getCardHolderPhoneNumbers() {
        return this.m_cardHolderPhoneNumbers;
    }

    public String getCardReference() {
        return this.m_cardReference;
    }

    public boolean getContactless() {
        return this.m_contactless;
    }

    public String getCSC() {
        return this.m_csc;
    }

    public String getCurrencyCode() {
        return this.m_currencyCode;
    }

    public boolean getDebtRepayment() {
        return this.m_debtRepayment;
    }

    public DCC getDCC() {
        return this.m_dcc;
    }

    public Address getDeliveryAddress() {
        return this.m_deliveryAddress;
    }

    public List<EmailAddress> getDeliveryEmailAddresses() {
        return this.m_deliveryEmailAddresses;
    }

    public Name getDeliveryName() {
        return this.m_deliveryName;
    }

    public List<PhoneNumber> getDeliveryPhoneNumbers() {
        return this.m_deliveryPhoneNumbers;
    }

    public String getExpiryDate() {
        return this.m_expiryDate;
    }

    public String getExpiryDateFormat() {
        return this.m_expiryDateFormat;
    }

    public List<ExtendedProperty> getExtendedProperties() {
        return this.m_extendedProperties;
    }

    public List<FeatureToken> getFeatureTokens() {
        return this.m_featureTokens;
    }

    public boolean getICCFallback() {
        return this.m_iccFallback;
    }

    public List<ICCTag> getICCTags() {
        return this.m_iccTags;
    }

    public String getICCType() {
        return this.m_iccType;
    }

    public Address getInvoiceAddress() {
        return this.m_invoiceAddress;
    }

    public List<EmailAddress> getInvoiceEmailAddresses() {
        return this.m_invoiceEmailAddresses;
    }

    public Name getInvoiceName() {
        return this.m_invoiceName;
    }

    public List<PhoneNumber> getInvoicePhoneNumbers() {
        return this.m_invoicePhoneNumbers;
    }

    public String getIssueNumber() {
        return this.m_issueNumber;
    }

    public String getMachineReference() {
        return this.m_machineReference;
    }

    public String getManualType() {
        return this.m_manualType;
    }

    public String getOfflineDateTime() {
        return this.m_offlineDateTime;
    }

    public String getOfflineDateTimeFormat() {
        return this.m_offlineDateTimeFormat;
    }

    public String getOriginatingIPAddress() {
        return this.m_originatingIPAddress;
    }

    public String getPAN() {
        return this.m_pan;
    }

    public List<Product> getProducts() {
        return this.m_products;
    }

    public RequestType getRequestType() {
        return this.m_requestType;
    }

    public String getSoftwareName() {
        return this.m_softwareName;
    }

    public String getSoftwareVersion() {
        return this.m_softwareVersion;
    }

    public String getStartDate() {
        return this.m_startDate;
    }

    public String getStartDateFormat() {
        return this.m_startDateFormat;
    }

    public String getSubType() {
        return this.m_subType;
    }

    public String getTerminalID() {
        return this.m_terminalID;
    }

    public String getTrack1() {
        return this.m_track1;
    }

    public String getTrack2() {
        return this.m_track2;
    }

    public String getTrack3() {
        return this.m_track3;
    }

    public String getTransactionKey() {
        return this.m_transactionKey;
    }

    public List<TransactionLink> getTransactionLinks() {
        return this.m_transactionLinks;
    }

    public String getUserReference() {
        return this.m_userReference;
    }

    public VoiceReferralResult getVoiceReferralResult() {
        return this.m_voiceReferralResult;
    }

    public VoidReason getVoidReason() {
        return this.m_voidReason;
    }

    public String getZipCode() {
        return this.m_zipCode;
    }

    public PointOfInteraction getPointOfInteraction() {
        return this.m_pointOfInteraction;
    }

    public String getApiKey() {
        return this.m_apiKey;
    }

    public String getPosGuid() {
        return this.m_posGuid;
    }

    public String getApplicationId() {
        return this.m_applicationId;
    }

    public String getEncryptedPANKeyEntryData() {
        return this.m_encryptedPanKeyEntryData;
    }

    public String getCertificationIdentifier() {
        return this.m_certificationIdentifier;
    }

    public String getPlatformName() {
        return this.m_platformName;
    }

    public String getPlatformVersion() {
        return this.m_platformVersion;
    }

    public void setCustomerVaultCommand(String customerVaultCommand) {
        this.m_customerVaultCommand = customerVaultCommand;
    }

    public void setCustomerVaultId(String customerVaultId) {
        this.m_customerVaultId = customerVaultId;
    }

    public void setMerchantProcessorId(String merchantProcessorId) {
        this.m_merchantProcessorId = merchantProcessorId;
    }

    public void setLaneId(String laneId) {
        this.m_laneId = laneId;
    }

    public void setOmniSale(Boolean omniSale) {
        this.m_omniSale = omniSale;
    }

    public void setThreeDSecureCardHolderEnrolled(ThreeDSecureCardHolderEnrolled enrolled) {
        this.m_3DSecureCardHolderEnrolled = enrolled;
    }

    public void setThreeDSecureDirectoryServerTransactionId(String threeDSecureDirectoryServerTransactionId) {
        this.m_3DSecureDirectoryServerTransactionId = threeDSecureDirectoryServerTransactionId;
    }

    public void setThreeDSecureECI(String eci) {
        this.m_3DSecureECI = eci;
    }

    public void setThreeDSecureIAV(String iav) {
        this.m_3DSecureIAV = iav;
    }

    public void setThreeDSecureIAVAlgorithm(String iavAlgorithm) {
        this.m_3DSecureIAVAlgorithm = iavAlgorithm;
    }

    public void setThreeDSecureIAVFormat(IAVFormat format) {
        this.m_3DSecureIAVFormat = format;
    }

    public void setThreeDSecureServerTransactionId(String threeDSecureServerTransactionId) {
        this.m_3DSecureServerTransactionId = threeDSecureServerTransactionId;
    }

    public void setThreeDSecureTransactionStatus(ThreeDSecureTransactionStatus status) {
        this.m_3DSecureTransactionStatus = status;
    }

    public void setThreeDSecureVersion(String threeDSecureVersion) {
        this.m_3DSecureVersion = threeDSecureVersion;
    }

    public void setThreeDSecureXID(String xid) {
        this.m_3DSecureXID = xid;
    }

    public void setThreeDSecureXIDFormat(XIDFormat format) {
        this.m_3DSecureXIDFormat = format;
    }

    public void setAddress(String address) {
        this.m_address = address;
    }

    public void setAmount(String amount) {
        this.m_amount = amount;
    }

    public void setAmountOther(String amountOther) {
        this.m_amountOther = amountOther;
    }

    public void setAmountOtherTransactionFee(String amountOtherTransactionFee) {
        this.m_amountOtherTransactionFee = amountOtherTransactionFee;
    }

    public void setAmountTip(String amountTip) {
        this.m_amountTip = amountTip;
    }

    public void setAmountUnit(AmountUnit amountUnit) {
        this.m_amountUnit = amountUnit;
    }

    public void setAmountType(AmountType amountType) {
        this.m_amountType = amountType;
    }

    public void setAuthCode(String authCode) {
        this.m_authCode = authCode;
    }

    public void setAutoConfirm(boolean autoConfirm) {
        this.m_autoConfirm = autoConfirm;
    }

    public void setBatchReference(String batchReference) {
        this.m_batchReference = batchReference;
    }

    public void setCardEaseReference(String cardEaseReference) {
        this.m_cardEaseReference = cardEaseReference;
    }

    public void setTransactionId(String transactionId) {
        this.m_transactionId = transactionId;
    }

    public void setMerchantDefinedFields(HashMap<String, String> merchantFields) {
        this.m_merchantDefinedFields = merchantFields;
    }

    public void setPurchaseLevel2Data(PurchaseLevel2Data purchaseLevel2Data) {
        this.m_purchaseLevel2Data = purchaseLevel2Data;
    }

    public void setBillingInformation(BillingInformation billingInformation) {
        this.m_billingInformation = billingInformation;
    }

    public void setTerminalCapabilities(TerminalCapabilities terminalCapabilities) {
        this.m_terminalCapabilities = terminalCapabilities;
    }

    public void setCardHash(String cardHash) {
        this.m_cardHash = cardHash;
    }

    public void setCardHolderAddress(Address cardHolderAddress) {
        this.m_cardHolderAddress = cardHolderAddress;
    }

    public void setCardHolderEmailAddresses(List<EmailAddress> cardHolderEmailAddresses) {
        this.m_cardHolderEmailAddresses = cardHolderEmailAddresses;
    }

    public void setCardHolderName(Name cardHolderName) {
        this.m_cardHolderName = cardHolderName;
    }

    public void setCardHolderPhoneNumbers(List<PhoneNumber> cardHolderPhoneNumbers) {
        this.m_cardHolderPhoneNumbers = cardHolderPhoneNumbers;
    }

    public void setCardReference(String cardReference) {
        this.m_cardReference = cardReference;
    }

    public void setContactless(boolean contactless) {
        this.m_contactless = contactless;
    }

    public void setCSC(String csc) {
        this.m_csc = csc;
    }

    public void setCurrencyCode(String currencyCode) {
        this.m_currencyCode = currencyCode;
    }

    public void setDebtRepayment(boolean debtRepayment) {
        this.m_debtRepayment = debtRepayment;
    }

    public void setDCC(DCC dcc) {
        this.m_dcc = dcc;
    }

    public void setDeliveryAddress(Address deliveryAddress) {
        this.m_deliveryAddress = deliveryAddress;
    }

    public void setDeliveryEmailAddresses(List<EmailAddress> deliveryEmailAddresses) {
        this.m_deliveryEmailAddresses = deliveryEmailAddresses;
    }

    public void setDeliveryName(Name deliveryName) {
        this.m_deliveryName = deliveryName;
    }

    public void setDeliveryPhoneNumbers(List<PhoneNumber> deliveryPhoneNumbers) {
        this.m_deliveryPhoneNumbers = deliveryPhoneNumbers;
    }

    public void setExpiryDate(String expiryDate) {
        this.m_expiryDate = expiryDate;
    }

    public void setExpiryDateFormat(String expiryDateFormat) {
        this.m_expiryDateFormat = expiryDateFormat;
    }

    public void setExtendedProperties(List<ExtendedProperty> extendedProperties) {
        this.m_extendedProperties = extendedProperties;
    }

    public void setFeatureTokens(List<FeatureToken> featureTokens) {
        this.m_featureTokens = featureTokens;
    }

    public void setICCFallback(boolean iccFallback) {
        this.m_iccFallback = iccFallback;
    }

    public void setICCTags(List<ICCTag> iccTags) {
        this.m_iccTags = iccTags;
    }

    public void setICCType(String iccType) {
        this.m_iccType = iccType;
    }

    public void setInvoiceAddress(Address invoiceAddress) {
        this.m_invoiceAddress = invoiceAddress;
    }

    public void setInvoiceEmailAddresses(List<EmailAddress> invoiceEmailAddresses) {
        this.m_invoiceEmailAddresses = invoiceEmailAddresses;
    }

    public void setInvoiceName(Name invoiceName) {
        this.m_invoiceName = invoiceName;
    }

    public void setInvoicePhoneNumbers(List<PhoneNumber> invoicePhoneNumbers) {
        this.m_invoicePhoneNumbers = invoicePhoneNumbers;
    }

    public void setIssueNumber(String issueNumber) {
        this.m_issueNumber = issueNumber;
    }

    public void setMachineReference(String machineReference) {
        this.m_machineReference = machineReference;
    }

    public void setManualType(String manualType) {
        this.m_manualType = manualType;
    }

    public void setOfflineDateTime(String offlineDateTime) {
        this.m_offlineDateTime = offlineDateTime;
    }

    public void setOfflineDateTimeFormat(String offlineDateTimeFormat) {
        this.m_offlineDateTimeFormat = offlineDateTimeFormat;
    }

    public void setOriginatingIPAddress(String originatingIPAddress) {
        this.m_originatingIPAddress = originatingIPAddress;
    }

    public void setPAN(String pan) {
        this.m_pan = pan;
    }

    public void setProducts(List<Product> products) {
        this.m_products = products;
    }

    public void setRequestType(RequestType requestType) {
        this.m_requestType = requestType;
    }

    public void setSoftwareName(String softwareName) {
        this.m_softwareName = softwareName;
    }

    public void setSoftwareVersion(String softwareVersion) {
        this.m_softwareVersion = softwareVersion;
    }

    public void setStartDate(String startDate) {
        this.m_startDate = startDate;
    }

    public void setStartDateFormat(String startDateFormat) {
        this.m_startDateFormat = startDateFormat;
    }

    public void setSubType(String subType) {
        this.m_subType = subType;
    }

    public void setTerminalID(String terminalID) {
        this.m_terminalID = terminalID;
    }

    public void setTrack1(String track1) {
        this.m_track1 = track1;
    }

    public void setTrack2(String track2) {
        this.m_track2 = track2;
    }

    public void setTrack3(String track3) {
        this.m_track3 = track3;
    }

    public void setTransactionKey(String transactionKey) {
        this.m_transactionKey = transactionKey;
    }

    public void setTransactionLinks(List<TransactionLink> transactionLinks) {
        this.m_transactionLinks = transactionLinks;
    }

    public void setUserReference(String userReference) {
        this.m_userReference = userReference;
    }

    public void setVoiceReferralResult(VoiceReferralResult voiceReferralResult) {
        this.m_voiceReferralResult = voiceReferralResult;
    }

    public void setVoidReason(VoidReason voidReason) {
        this.m_voidReason = voidReason;
    }

    public void setZipCode(String zipCode) {
        this.m_zipCode = zipCode;
    }

    public void setPointOfInteraction(PointOfInteraction pointOfInteraction) {
        this.m_pointOfInteraction = pointOfInteraction;
    }

    public void setConfirmAllowMultiple(boolean allow) {
        this.m_allowMultipleConfirms = allow;
    }

    public void setApiKey(String apiKey) {
        this.m_apiKey = apiKey;
    }

    public void setPosGuid(String posGuid) {
        this.m_posGuid = posGuid;
    }

    public void setApplicationId(String applicationId) {
        this.m_applicationId = applicationId;
    }

    public void setEncryptedPANKeyEntryData(String encryptedPanKeyEntryData) {
        this.m_encryptedPanKeyEntryData = encryptedPanKeyEntryData;
    }

    public void setCertificationIdentifier(String certificationIdentifier) {
        this.m_certificationIdentifier = certificationIdentifier;
    }

    public void setPlatformName(String platformName) {
        this.m_platformName = platformName;
    }

    public void setPlatformVersion(String platformVersion) {
        this.m_platformVersion = platformVersion;
    }

    private boolean isCardDetailsNodeNeeded() {
        return this.m_iccTags != null && this.m_iccTags.size() != 0 || this.m_contactless || this.m_iccFallback || this.m_track1 != null && !this.m_track1.trim().isEmpty() || this.m_track2 != null && !this.m_track2.trim().isEmpty() || this.m_track3 != null && !this.m_track3.trim().isEmpty() || this.m_pan != null && !this.m_pan.trim().isEmpty() || this.m_cardReference != null && !this.m_cardReference.trim().isEmpty() || this.m_cardHash != null && !this.m_cardHash.trim().isEmpty() || this.m_expiryDate != null && !this.m_expiryDate.trim().isEmpty() || this.m_startDate != null && !this.m_startDate.trim().isEmpty() || this.m_issueNumber != null && !this.m_issueNumber.trim().isEmpty() || this.m_address != null && !this.m_address.trim().isEmpty() || this.m_csc != null && !this.m_csc.trim().isEmpty() || this.m_zipCode != null && !this.m_zipCode.trim().isEmpty() || this.m_cardHolderAddress != null && !this.m_cardHolderAddress.isEmpty() || this.m_cardHolderEmailAddresses != null && this.m_cardHolderEmailAddresses.size() != 0 || !this.m_cardHolderName.isEmpty() || this.m_cardHolderPhoneNumbers != null && this.m_cardHolderPhoneNumbers.size() != 0 || this.m_3DSecureCardHolderEnrolled != null && this.m_3DSecureCardHolderEnrolled != ThreeDSecureCardHolderEnrolled.Empty || this.m_3DSecureTransactionStatus != null && this.m_3DSecureTransactionStatus != ThreeDSecureTransactionStatus.Empty || this.m_3DSecureVersion != null && !this.m_3DSecureVersion.trim().isEmpty() || this.m_3DSecureDirectoryServerTransactionId != null && !this.m_3DSecureDirectoryServerTransactionId.trim().isEmpty() || this.m_3DSecureServerTransactionId != null && !this.m_3DSecureServerTransactionId.trim().isEmpty() || this.m_3DSecureECI != null && !this.m_3DSecureECI.trim().isEmpty() || this.m_3DSecureIAV != null && !this.m_3DSecureIAV.trim().isEmpty() || this.m_3DSecureXID != null && !this.m_3DSecureXID.trim().isEmpty() || this.m_encryptedPanKeyEntryData != null && !this.m_encryptedPanKeyEntryData.trim().isEmpty();
    }

    private boolean isThreeDSecureNodeNeeded() {
        if (this.m_terminalCapabilities.terminalCapabilitiesThreeDSecure == null) {
            return false;
        }
        return this.isVersionSupportedNodeNeeded() || this.isSchemeSupportedNodeNeeded();
    }

    private boolean isVersionSupportedNodeNeeded() {
        return this.m_terminalCapabilities.terminalCapabilitiesThreeDSecure.threeDSecureVersion1 != null && this.m_terminalCapabilities.terminalCapabilitiesThreeDSecure.threeDSecureVersion1.equals("true") || this.m_terminalCapabilities.terminalCapabilitiesThreeDSecure.threeDSecureVersion2 != null && this.m_terminalCapabilities.terminalCapabilitiesThreeDSecure.threeDSecureVersion2.equals("true");
    }

    private boolean isSchemeSupportedNodeNeeded() {
        return this.m_terminalCapabilities.terminalCapabilitiesThreeDSecure.visa != null && this.m_terminalCapabilities.terminalCapabilitiesThreeDSecure.visa.equals("true") || this.m_terminalCapabilities.terminalCapabilitiesThreeDSecure.mastercard != null && this.m_terminalCapabilities.terminalCapabilitiesThreeDSecure.mastercard.equals("true") || this.m_terminalCapabilities.terminalCapabilitiesThreeDSecure.amex != null && this.m_terminalCapabilities.terminalCapabilitiesThreeDSecure.amex.equals("true");
    }

    private void addCatLevelsToXML(XMLWriter writer) throws IOException {
        for (String catLevelValue : this.m_terminalCapabilities.terminalCapabilitiesCatLevel.catLevelMap.values()) {
            if (!catLevelValue.equals("true")) continue;
            writer.writeStartElement("CardholderActivatedTerminal");
            writer.writeStartElement("Level");
            StringBuilder sb = new StringBuilder();
            for (String key : this.m_terminalCapabilities.terminalCapabilitiesCatLevel.catLevelMap.keySet()) {
                if (!this.m_terminalCapabilities.terminalCapabilitiesCatLevel.catLevelMap.get(key).equals("true")) continue;
                sb.append(key);
                sb.append(" ");
            }
            sb.deleteCharAt(sb.length() - 1);
            writer.writeString(sb.toString());
            writer.writeEndElement();
            writer.writeEndElement();
            return;
        }
    }

    public String toString() {
        String eol = System.getProperty("line.separator");
        String sep = ": ";
        StringBuilder str = new StringBuilder();
        str.append("REQUEST:");
        str.append(eol);
        str.append("Address");
        str.append(sep);
        str.append(this.m_address);
        str.append(eol);
        str.append("Amount");
        str.append(sep);
        str.append(this.m_amount);
        str.append(eol);
        str.append("AmountUnit");
        str.append(sep);
        str.append((Object)this.m_amountUnit);
        str.append(eol);
        str.append("AuthCode");
        str.append(sep);
        str.append(this.m_authCode);
        str.append(eol);
        str.append("AutoConfirm");
        str.append(sep);
        str.append(this.m_autoConfirm);
        str.append(eol);
        str.append("BatchReference");
        str.append(sep);
        str.append(this.m_batchReference);
        str.append(eol);
        str.append("CardEaseReference");
        str.append(sep);
        str.append(this.m_cardEaseReference);
        str.append(eol);
        str.append("GwTransactionId");
        str.append(sep);
        str.append(this.m_transactionId);
        str.append(eol);
        str.append("CardHash");
        str.append(sep);
        str.append(this.m_cardHash);
        str.append(eol);
        str.append("CardHolderAddress");
        str.append(sep);
        str.append(this.m_cardHolderAddress);
        str.append(eol);
        str.append("CardHolderEmailAddress");
        str.append(sep);
        str.append(this.m_cardHolderEmailAddresses);
        str.append(eol);
        str.append("CardHolderName");
        str.append(sep);
        str.append(this.m_cardHolderName);
        str.append(eol);
        str.append("CardHolderPhoneNumbers");
        str.append(sep);
        str.append(this.m_cardHolderPhoneNumbers);
        str.append(eol);
        str.append("CardReference");
        str.append(sep);
        str.append(this.m_cardReference);
        str.append(eol);
        str.append("Contacless");
        str.append(sep);
        str.append(this.m_contactless);
        str.append(eol);
        str.append("CSC");
        str.append(sep);
        str.append(this.m_csc);
        str.append(eol);
        str.append("CurrencyCode");
        str.append(sep);
        str.append(this.m_currencyCode);
        str.append(eol);
        str.append("DeliveryAddress");
        str.append(sep);
        str.append(this.m_deliveryAddress);
        str.append(eol);
        str.append("DeliveryEmailAddress");
        str.append(sep);
        str.append(this.m_deliveryEmailAddresses);
        str.append(eol);
        str.append("DeliveryName");
        str.append(sep);
        str.append(this.m_deliveryName);
        str.append(eol);
        str.append("DeliveryPhoneNumbers");
        str.append(sep);
        str.append(this.m_deliveryPhoneNumbers);
        str.append(eol);
        str.append("ExpiryDate");
        str.append(sep);
        str.append(this.m_expiryDate);
        str.append(eol);
        str.append("ExpiryDateFormat");
        str.append(sep);
        str.append(this.m_expiryDateFormat);
        str.append(eol);
        str.append("ExtendedProperties");
        str.append(sep);
        str.append(this.m_extendedProperties);
        str.append(eol);
        str.append("FeatureTokens");
        str.append(sep);
        str.append(this.m_featureTokens);
        str.append(eol);
        str.append("ICCFallback");
        str.append(sep);
        str.append(this.m_iccFallback);
        str.append(eol);
        str.append("ICCTags");
        str.append(sep);
        str.append(this.m_iccTags);
        str.append(eol);
        str.append("ICCType");
        str.append(sep);
        str.append(this.m_iccType);
        str.append(eol);
        str.append("InvoiceAddress");
        str.append(sep);
        str.append(this.m_invoiceAddress);
        str.append(eol);
        str.append("InvoiceEmailAddress");
        str.append(sep);
        str.append(this.m_invoiceEmailAddresses);
        str.append(eol);
        str.append("InvoiceName");
        str.append(sep);
        str.append(this.m_invoiceName);
        str.append(eol);
        str.append("InvoicePhoneNumbers");
        str.append(sep);
        str.append(this.m_invoicePhoneNumbers);
        str.append(eol);
        str.append("IssueNumber");
        str.append(sep);
        str.append(this.m_issueNumber);
        str.append(eol);
        str.append("MachineReference");
        str.append(sep);
        str.append(this.m_machineReference);
        str.append(eol);
        str.append("ManualType");
        str.append(sep);
        str.append(this.m_manualType);
        str.append(eol);
        str.append("OfflineDateTime");
        str.append(sep);
        str.append(this.m_offlineDateTime);
        str.append(eol);
        str.append("OfflineDateTimeFormat");
        str.append(sep);
        str.append(this.m_offlineDateTimeFormat);
        str.append(eol);
        str.append("OriginatingIPAddress");
        str.append(sep);
        str.append(this.m_originatingIPAddress);
        str.append(eol);
        str.append("PAN");
        str.append(sep);
        str.append(this.m_pan);
        str.append(eol);
        str.append("Products");
        str.append(sep);
        str.append(this.m_products);
        str.append(eol);
        str.append("RequestType");
        str.append(sep);
        str.append((Object)this.m_requestType);
        str.append(eol);
        str.append("SoftwareName");
        str.append(sep);
        str.append(this.m_softwareName);
        str.append(eol);
        str.append("SoftwareVersion");
        str.append(sep);
        str.append(this.m_softwareVersion);
        str.append(eol);
        str.append("StartDate");
        str.append(sep);
        str.append(this.m_startDate);
        str.append(eol);
        str.append("StartDateFormat");
        str.append(sep);
        str.append(this.m_startDateFormat);
        str.append(eol);
        str.append("SubType");
        str.append(sep);
        str.append(this.m_subType);
        str.append(eol);
        str.append("TerminalID");
        str.append(sep);
        str.append(this.m_terminalID);
        str.append(eol);
        str.append("ThreeDSecureCardHolderEnrolled");
        str.append(sep);
        str.append((Object)this.m_3DSecureCardHolderEnrolled);
        str.append(eol);
        str.append("ThreeDSecureECI");
        str.append(sep);
        str.append(this.m_3DSecureECI);
        str.append(eol);
        str.append("ThreeDSecureIAV");
        str.append(sep);
        str.append(this.m_3DSecureIAV);
        str.append(eol);
        str.append("ThreeDSecureIAVAlgorithm");
        str.append(sep);
        str.append(this.m_3DSecureIAVAlgorithm);
        str.append(eol);
        str.append("ThreeDSecureIAVFormat");
        str.append(sep);
        str.append((Object)this.m_3DSecureIAVFormat);
        str.append(eol);
        str.append("ThreeDSecureTransactionStatus");
        str.append(sep);
        str.append((Object)this.m_3DSecureTransactionStatus);
        str.append(eol);
        str.append("ThreeDSecureXID");
        str.append(sep);
        str.append(this.m_3DSecureXID);
        str.append(eol);
        str.append("ThreeDSecureXIDFormat");
        str.append(sep);
        str.append((Object)this.m_3DSecureXIDFormat);
        str.append(eol);
        str.append("Track1");
        str.append(sep);
        str.append(this.m_track1);
        str.append(eol);
        str.append("Track2");
        str.append(sep);
        str.append(this.m_track2);
        str.append(eol);
        str.append("Track3");
        str.append(sep);
        str.append(this.m_track3);
        str.append(eol);
        str.append("TransactionKey");
        str.append(sep);
        str.append(this.m_transactionKey);
        str.append(eol);
        str.append("UserReference");
        str.append(sep);
        str.append(this.m_userReference);
        str.append(eol);
        str.append("VoiceReferralResult");
        str.append(sep);
        str.append((Object)this.m_voiceReferralResult);
        str.append(eol);
        str.append("VoidReason");
        str.append(sep);
        str.append((Object)this.m_voidReason);
        str.append(eol);
        str.append("ZipCode");
        str.append(sep);
        str.append(this.m_zipCode);
        str.append(eol);
        str.append("ApiKey");
        str.append(sep);
        str.append(this.m_apiKey);
        str.append(eol);
        str.append("PosGuid");
        str.append(sep);
        str.append(this.m_posGuid);
        str.append(eol);
        str.append("CredentialOnFile");
        str.append(sep);
        str.append(this.m_credentialOnFile);
        str.append(eol);
        str.append("PointOfInteraction");
        str.append(sep);
        str.append(this.m_pointOfInteraction);
        str.append(eol);
        str.append("TerminalCapabilities");
        str.append(sep);
        str.append(this.m_terminalCapabilities);
        str.append(eol);
        return str.toString();
    }
}

