/*
 * Decompiled with CFR 0.152.
 */
package com.creditcall;

import android.text.TextUtils;
import android.util.Base64;
import com.creditcall.CardEaseXmlEncryptionException;
import com.creditcall.internal.XMLWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Locale;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

class XmlEncryptor {
    private final X509Certificate certificate;

    XmlEncryptor(X509Certificate certificate) {
        this.certificate = certificate;
    }

    void encryptElements(ArrayList<Element> elements) throws CardEaseXmlEncryptionException {
        try {
            SecretKey key = this.generateAESKey();
            for (Element element : elements) {
                byte[] encryptedKey = this.encryptKey(key, this.getKeyEncryptionCipher());
                byte[] encryptedElement = this.encryptElement(element, key, this.generateIV());
                String encryptedXMLString = this.writeEncryptedXML(encryptedKey, encryptedElement);
                Document doc = this.convertEncryptedStringToDoc(encryptedXMLString);
                this.replaceXMLWithEncryptedNode(element, doc);
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new CardEaseXmlEncryptionException("AES not supported", e);
        }
        catch (IOException e) {
            throw new CardEaseXmlEncryptionException("Failed to build xml", e);
        }
        catch (GeneralSecurityException e) {
            throw new CardEaseXmlEncryptionException("Failed to encrypt xml", e);
        }
        catch (TransformerConfigurationException e) {
            throw new CardEaseXmlEncryptionException("Failed to initialise XML transformer", e);
        }
        catch (TransformerException e) {
            throw new CardEaseXmlEncryptionException("Failed to transform xml", e);
        }
    }

    private SecretKey generateAESKey() throws NoSuchAlgorithmException {
        KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
        keyGenerator.init(256);
        return keyGenerator.generateKey();
    }

    private IvParameterSpec generateIV() {
        byte[] nonce = new byte[16];
        new SecureRandom().nextBytes(nonce);
        return new IvParameterSpec(nonce);
    }

    private Cipher getKeyEncryptionCipher() throws NoSuchAlgorithmException, NoSuchPaddingException, CardEaseXmlEncryptionException, InvalidKeyException {
        Cipher keyEncryptionCipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        if (!"RSA".equalsIgnoreCase(this.certificate.getPublicKey().getAlgorithm())) {
            throw new CardEaseXmlEncryptionException("Unsupported certificate format");
        }
        keyEncryptionCipher.init(1, this.certificate.getPublicKey());
        return keyEncryptionCipher;
    }

    private byte[] encryptKey(SecretKey key, Cipher keyEncryptionCipher) throws BadPaddingException, IllegalBlockSizeException {
        return keyEncryptionCipher.doFinal(key.getEncoded());
    }

    private Cipher getElementEncryptionCipher(SecretKey key, IvParameterSpec iv) throws InvalidAlgorithmParameterException, InvalidKeyException, NoSuchPaddingException, NoSuchAlgorithmException {
        Cipher elementEncryptionCipher = Cipher.getInstance("AES/CBC/ISO10126Padding");
        elementEncryptionCipher.init(1, (Key)key, iv);
        return elementEncryptionCipher;
    }

    private byte[] encryptElement(Element element, SecretKey key, IvParameterSpec iv) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, InvalidKeyException, TransformerException, UnsupportedEncodingException, BadPaddingException, IllegalBlockSizeException {
        Cipher elementEncryptionCipher = this.getElementEncryptionCipher(key, iv);
        String xml = this.getInnerXml(element);
        byte[] plainData = xml.getBytes("UTF-8");
        byte[] encipheredData = elementEncryptionCipher.doFinal(plainData);
        byte[] encryptedElement = new byte[iv.getIV().length + encipheredData.length];
        System.arraycopy(iv.getIV(), 0, encryptedElement, 0, iv.getIV().length);
        System.arraycopy(encipheredData, 0, encryptedElement, iv.getIV().length, encipheredData.length);
        return encryptedElement;
    }

    private String writeEncryptedXML(byte[] encryptedKeyData, byte[] encryptedElement) throws IOException {
        String encryptionMethod = "http://www.w3.org/2001/04/xmlenc#aes256-cbc";
        StringWriter stringWriter = new StringWriter();
        XMLWriter writer = new XMLWriter(stringWriter);
        writer.writeStartElement("EncryptedData", "http://www.w3.org/2001/04/xmlenc#");
        writer.writeAttributeString("Type", "http://www.w3.org/2001/04/xmlenc#Element");
        writer.writeStartElement("EncryptionMethod");
        writer.writeAttributeString("Algorithm", encryptionMethod);
        writer.writeEndElement();
        writer.writeStartElement("KeyInfo", "http://www.w3.org/2000/09/xmldsig#");
        writer.writeStartElement("EncryptedKey", "http://www.w3.org/2001/04/xmlenc#");
        writer.writeStartElement("EncryptionMethod");
        writer.writeAttributeString("Algorithm", "http://www.w3.org/2001/04/xmlenc#rsa-1_5");
        writer.writeEndElement();
        writer.writeStartElement("KeyInfo", "http://www.w3.org/2000/09/xmldsig#");
        writer.writeStartElement("X509Data");
        writer.writeStartElement("X509IssuerSerial");
        writer.writeElementString("X509SerialNumber", this.serialNumberToBytes(this.certificate.getSerialNumber()));
        writer.writeElementString("X509IssuerName", this.formatDistinguishedName(this.certificate.getIssuerX500Principal().getName()));
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("CipherData");
        writer.writeElementString("CipherValue", Base64.encodeToString((byte[])encryptedKeyData, (int)2));
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("CipherData");
        writer.writeElementString("CipherValue", Base64.encodeToString((byte[])encryptedElement, (int)2));
        writer.writeEndElement();
        writer.writeEndElement();
        writer.close();
        return stringWriter.toString();
    }

    private Document convertEncryptedStringToDoc(String encryptedXMLString) throws CardEaseXmlEncryptionException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document fragmentDoc = builder.parse(new InputSource(new StringReader(encryptedXMLString)));
            return fragmentDoc;
        }
        catch (Exception e) {
            throw new CardEaseXmlEncryptionException("Failed to build encrypted XML fragment, e");
        }
    }

    private void replaceXMLWithEncryptedNode(Element element, Document fragmentDoc) throws CardEaseXmlEncryptionException {
        Node adoptedElement = element.getOwnerDocument().adoptNode(fragmentDoc.getDocumentElement());
        Node parent = element.getParentNode();
        Node encryptedElementForStringBuilder = element.cloneNode(false);
        encryptedElementForStringBuilder.appendChild(adoptedElement);
        if (parent == null) {
            throw new CardEaseXmlEncryptionException("XML node replacement error");
        }
        parent.replaceChild(encryptedElementForStringBuilder, element);
    }

    private String getInnerXml(Node node) throws TransformerException {
        NodeList childeren = node.getChildNodes();
        StreamResult result = new StreamResult(new StringWriter());
        for (int i = 0; i < childeren.getLength(); ++i) {
            Node child = childeren.item(i);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.transform(new DOMSource(child), result);
        }
        return result.getWriter().toString();
    }

    private String formatDistinguishedName(String distinguishedName) {
        if (distinguishedName == null || distinguishedName.length() == 0) {
            return "";
        }
        Object[] components = distinguishedName.split("(?<!\\\\)(?:\\\\\\\\)*,");
        return TextUtils.join((CharSequence)", ", (Object[])components);
    }

    private String serialNumberToBytes(BigInteger serialNumber) {
        String hex = serialNumber.toString(16).toUpperCase(Locale.US);
        if (hex.length() % 2 != 0) {
            hex = "0" + hex;
        }
        return hex;
    }
}

