/*
 * Decompiled with CFR 0.152.
 */
package com.creditcall;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Address {
    private String m_city = null;
    private String m_country = null;
    private List<String> m_lines = new ArrayList<String>();
    private List<String> m_recipient = new ArrayList<String>();
    private String m_state = null;
    private String m_zipCode = null;

    protected Address() {
    }

    public Address(String recipient, String line, String city, String state, String zipCode, String country) {
        if (recipient != null) {
            this.m_recipient = new ArrayList<String>();
            this.m_recipient.add(recipient);
        }
        if (line != null) {
            this.m_lines = new ArrayList<String>();
            this.m_lines.add(line);
        }
        this.m_city = city;
        this.m_state = state;
        this.m_zipCode = zipCode;
        this.m_country = country;
    }

    public Address(List<String> recipient, List<String> lines, String city, String state, String zipCode, String country) {
        this.m_recipient = recipient;
        this.m_lines = lines;
        this.m_city = city;
        this.m_state = state;
        this.m_zipCode = zipCode;
        this.m_country = country;
    }

    public String getCity() {
        return this.m_city;
    }

    public String getCountry() {
        return this.m_country;
    }

    public List<String> getLines() {
        return this.m_lines;
    }

    public List<String> getRecipient() {
        return this.m_recipient;
    }

    public String getState() {
        return this.m_state;
    }

    public String getZipCode() {
        return this.m_zipCode;
    }

    protected boolean isEmpty() {
        return !(this.m_city != null || this.m_country != null || this.m_lines != null && this.m_lines.size() != 0 || this.m_recipient != null && this.m_recipient.size() != 0 || this.m_state != null || this.m_zipCode != null);
    }

    public void setCity(String city) {
        this.m_city = city;
    }

    public void setCountry(String country) {
        this.m_country = country;
    }

    public void setLines(String line) {
        this.m_lines = new ArrayList<String>();
        this.m_lines.add(line);
    }

    public void setLines(List<String> lines) {
        this.m_lines = lines;
    }

    public void setRecipient(String recipient) {
        this.m_recipient = new ArrayList<String>();
        this.m_recipient.add(recipient);
    }

    public void setRecipient(List<String> recipient) {
        this.m_recipient = recipient;
    }

    public void setState(String state) {
        this.m_state = state;
    }

    public void setZipCode(String zipCode) {
        this.m_zipCode = zipCode;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        Iterator<String> i = this.m_recipient.iterator();
        while (i.hasNext()) {
            str.append(i.next());
            str.append(":");
        }
        i = this.m_lines.iterator();
        while (i.hasNext()) {
            str.append(i.next());
            str.append(":");
        }
        str.append(this.m_city);
        str.append(":");
        str.append(this.m_state);
        str.append(":");
        str.append(this.m_zipCode);
        str.append(":");
        str.append(this.m_country);
        return str.toString();
    }
}

