/*
 * Decompiled with CFR 0.152.
 */
package com.creditcall;

import com.creditcall.AmountUnit;
import com.creditcall.DccConvertResult;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class DCC {
    private String m_amount = null;
    private AmountUnit m_amountUnit = AmountUnit.Major;
    private String m_amountOther = null;
    private String m_amountOtherTransactionFee = null;
    private String m_amountTip = null;
    private String m_currencyCode = null;
    private String m_marginRate = null;
    private String m_exchangeRate = null;
    private String m_commissionAmount = null;
    private AmountUnit m_commisssionAmountUnit = AmountUnit.Major;

    public String getAmount() {
        return this.m_amount;
    }

    public void setAmount(String amount) {
        this.m_amount = amount;
    }

    public AmountUnit getAmountUnit() {
        return this.m_amountUnit;
    }

    public void setAmountUnit(AmountUnit amountUnit) {
        this.m_amountUnit = amountUnit;
    }

    public String getAmountOther() {
        return this.m_amountOther;
    }

    public void setAmountOther(String amountOther) {
        this.m_amountOther = amountOther;
    }

    public String getAmountOtherTransactionFee() {
        return this.m_amountOtherTransactionFee;
    }

    public void setAmountOtherTransactionFee(String amountOtherTransactionFee) {
        this.m_amountOtherTransactionFee = amountOtherTransactionFee;
    }

    public String getAmountTip() {
        return this.m_amountTip;
    }

    public void setAmountTip(String amountTip) {
        this.m_amountTip = amountTip;
    }

    public String getCurrencyCode() {
        return this.m_currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.m_currencyCode = currencyCode;
    }

    public String getMarginRate() {
        return this.m_marginRate;
    }

    public void setMarginRate(String marginRate) {
        this.m_marginRate = marginRate;
    }

    public String getExchangeRate() {
        return this.m_exchangeRate;
    }

    public void setExchangeRate(String exchangeRate) {
        this.m_exchangeRate = exchangeRate;
    }

    public String getCommissionAmount() {
        return this.m_commissionAmount;
    }

    public void setCommissionAmount(String commissionAmount) {
        this.m_commissionAmount = commissionAmount;
    }

    public AmountUnit getCommisssionAmountUnit() {
        return this.m_commisssionAmountUnit;
    }

    public void setCommisssionAmountUnit(AmountUnit commisssionAmountUnit) {
        this.m_commisssionAmountUnit = commisssionAmountUnit;
    }

    public static BigDecimal Truncate(BigDecimal value, int decimalPlaces) {
        BigDecimal integralValue = new BigDecimal(value.intValue());
        BigDecimal fraction = value.subtract(integralValue);
        BigDecimal factor = new BigDecimal(10).pow(decimalPlaces);
        BigDecimal truncatedFraction = new BigDecimal(fraction.multiply(factor).intValue()).divide(factor);
        BigDecimal result = integralValue.add(truncatedFraction);
        return result;
    }

    public static BigDecimal CalculateFinalRate(BigDecimal exchangeRate, BigDecimal marginRate, int exchangeRatePrecision) {
        return DCC.Truncate(exchangeRate.add(exchangeRate.multiply(marginRate).divide(new BigDecimal(100))), exchangeRatePrecision);
    }

    public static BigDecimal ConvertTo(BigDecimal amount, BigDecimal rate, int decimalPlaces) {
        return amount.multiply(rate).setScale(decimalPlaces, RoundingMode.UP);
    }

    public static BigDecimal ConvertFrom(BigDecimal amount, BigDecimal rate, int decimalPlaces) {
        return amount.divide(rate).setScale(decimalPlaces, RoundingMode.UP);
    }

    public static DccConvertResult Convert(int currencyExponent, BigDecimal amount, BigDecimal amountOther, BigDecimal amountOtherTransactionFee, BigDecimal amountTip, BigDecimal exchangeRate, int exchangeRatePrecision, BigDecimal marginRate, BigDecimal commission) {
        DccConvertResult result = new DccConvertResult();
        result.setFinalRate(DCC.CalculateFinalRate(exchangeRate, marginRate, exchangeRatePrecision));
        result.setDccAmount(DCC.ConvertTo(amount, result.getFinalRate(), currencyExponent));
        result.setDccAmountOther(DCC.ConvertTo(amountOther, result.getFinalRate(), currencyExponent));
        result.setDccAmountOtherTransactionFee(DCC.ConvertTo(amountOtherTransactionFee, result.getFinalRate(), currencyExponent));
        result.setDccAmountTip(DCC.ConvertTo(amountTip, result.getFinalRate(), currencyExponent));
        System.out.println(String.format("FinalRate = %s", result.getFinalRate().toString()));
        System.out.println(String.format("Base: Amount=%s\tAmountOther=%s\tAmountOtherTransactionFee=%s\tAmountTip=%s", amount.toString(), amountOther.toString(), amountOtherTransactionFee.toString(), amountTip.toString()));
        System.out.println(String.format("DCC : Amount=%s\tAmountOther=%s\tAmountOtherTransactionFee=%s\tAmountTip=%s", result.getDccAmount().toString(), result.getDccAmountOther().toString(), result.getDccAmountOtherTransactionFee().toString(), result.getDccAmountTip().toString()));
        return result;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("DCC: Amount=");
        str.append(this.m_amount);
        return str.toString();
    }
}

