/*
 * Decompiled with CFR 0.152.
 */
package com.creditcall;

public enum ErrorCode {
    Empty("-1"),
    AmountInvalid("1241"),
    AmountMissing("1240"),
    AmountTooLarge("1243"),
    AmountTooSmall("1242"),
    CardBanned("1005"),
    CardDetailsNotFound("2111"),
    CardDetailsUnavailable("2110"),
    CardEaseReferenceInvalid("2101"),
    CardEaseReferenceMissing("2100"),
    CardHashInvalid("1236"),
    CardReferenceInvalid("1235"),
    CardSchemeNotSupported("1003"),
    CardUsageExceeded("1004"),
    ExpiredCard("1001"),
    ExpiryDateInvalid("1211"),
    ExpiryDateMissing("1210"),
    InvalidData("8004"),
    InvalidMessageType("8002"),
    InvalidXMLRequest("8001"),
    IssueNoInvalid("1231"),
    IssueNoMissing("1230"),
    MessageTypeMissing("1250"),
    MessageTypeInvalid("1251"),
    NotAllowed("1006"),
    PANFailsLuhnCheck("1204"),
    PANInvalid("1201"),
    PANMissing("1200"),
    PANTooLong("1202"),
    PANTooShort("1203"),
    PreValidCard("1002"),
    StartDateInvalid("1221"),
    StartDateMissing("1220"),
    TemporarilyUnavailable("7000"),
    TerminalIDDisabled("2004"),
    TerminalIDInvalid("2003"),
    TerminalIDMissing("2001"),
    TerminalIDUnknown("2002"),
    TerminalUsageExceeded("2005"),
    TransactionAlreadyRefunded("2203"),
    TransactionAlreadySettled("2201"),
    TransactionAlreadyVoided("2202"),
    TransactionKeyIncorrect("2023"),
    TransactionKeyInvalid("2022"),
    TransactionKeyMissing("2021"),
    TransactionNotFound("2200"),
    TransactionOriginallyDeclined("2204"),
    ApiKeyMissing("3001"),
    ApiKeyInvalid("3002"),
    PosGuidMissing("3003"),
    PosGuidInvalid("3004"),
    ApplicationIdMissing("3005"),
    GatewayRejectedTransaction("3010"),
    TmsUpdateForced("3011"),
    GatewayProcessError("3012"),
    GatewayGeneralError("3013"),
    DeviceRegistrationFailed("3020"),
    MerchantConfigurationError("3025"),
    MissingField("3026"),
    InvalidField("3027"),
    InvalidHTTPMethod("3028"),
    AccessDenied("3029"),
    DeviceConfiguration("3030"),
    UnexpectedField("3031"),
    DataTypeError("3032"),
    ParseError("3033"),
    ServerError("3034"),
    GeneralError("3035"),
    XMLDecryptionError("8005"),
    XMLElementMissing("8003");

    private final String m_code;

    protected static ErrorCode parse(String code) {
        for (ErrorCode item : ErrorCode.values()) {
            if (!code.equalsIgnoreCase(item.m_code)) continue;
            return item;
        }
        throw new IllegalArgumentException("Unknown code: " + code);
    }

    private ErrorCode(String code) {
        this.m_code = code;
    }

    public int getCode() {
        return Integer.parseInt(this.m_code);
    }

    public String toString() {
        return this.m_code;
    }
}

