/*
 * Decompiled with CFR 0.152.
 */
package com.creditcall;

import com.creditcall.KevlarState;
import com.creditcall.RequestType;
import com.creditcall.Response;
import com.creditcall.ResultCode;

public enum RecoveryAction {
    None,
    Void,
    Retry;


    static RecoveryAction getRecoveryAction(RequestType requestType, Response response, KevlarState state) {
        if (requestType == null) {
            return None;
        }
        switch (state) {
            case TokenRequestSent: 
            case TokenRequestComplete: 
            case TransactionRequestSent: 
            case TranasctionResponseReceived: {
                switch (requestType) {
                    case PartialConfirm: 
                    case Conf: 
                    case Update: 
                    case Void: {
                        return Retry;
                    }
                }
                return None;
            }
            case ResponseNotificationSent: {
                switch (requestType) {
                    case Auth: 
                    case DeferredAuth: 
                    case Offline: 
                    case Refund: 
                    case VoiceReferralNotification: {
                        if (response != null && response.getResultCode() != ResultCode.Approved && response.getResultCode() != ResultCode.PartialApproval) {
                            return None;
                        }
                        return Void;
                    }
                    case PartialConfirm: 
                    case Conf: 
                    case Update: 
                    case Void: {
                        return Retry;
                    }
                }
                return None;
            }
            case ResponseNotificationComplete: {
                return None;
            }
        }
        return None;
    }
}

