/*
 * Decompiled with CFR 0.152.
 */
package com.creditcall;

import com.creditcall.AuthorisationEntity;
import com.creditcall.CardEaseXMLResponseException;
import com.creditcall.CardToken;
import com.creditcall.CertificationAuthority;
import com.creditcall.CurrencyData;
import com.creditcall.Error;
import com.creditcall.ErrorCode;
import com.creditcall.ExtendedProperty;
import com.creditcall.FundingCard;
import com.creditcall.ICCTag;
import com.creditcall.ICCTagValueType;
import com.creditcall.Name;
import com.creditcall.PublicKey;
import com.creditcall.ResultCode;
import com.creditcall.VerificationResult;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Response
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String m_addressResponseData = null;
    private VerificationResult m_addressResult = VerificationResult.Empty;
    private String m_amountOnlineApproved = null;
    private String m_acquirerResponseCode = null;
    private String m_authCode = null;
    private AuthorisationEntity m_authorisationEntity = AuthorisationEntity.Empty;
    private String m_cardEaseReference = null;
    private String m_cardHash = null;
    private String m_cardReference = null;
    private String m_cardScheme = null;
    private String m_cardSchemeId = null;
    private String m_cardSchemeAccountType = null;
    private ArrayList<CardToken> m_cardTokens = null;
    private Name m_cardHolderName = new Name();
    private String m_cscResponseData = null;
    private VerificationResult m_cscResult = VerificationResult.Empty;
    private CurrencyData m_currencyData = null;
    private boolean m_doNotReauthorize = false;
    private String m_doNotReauthorizeReason = null;
    private boolean m_duplicate = false;
    private List<Error> m_errors = new ArrayList<Error>();
    private String m_expiryDate = null;
    private String m_expiryDateFormat = null;
    private List<ExtendedProperty> m_extendedProperties = new ArrayList<ExtendedProperty>();
    private Boolean m_fallforwardToContact = false;
    private List<CertificationAuthority> m_iccCertificationAuthorities = new ArrayList<CertificationAuthority>();
    private boolean m_iccPublicKeyClearExisting = false;
    private String m_iccPublicKeyContent = null;
    private boolean m_iccPublicKeyReplaceExisting = false;
    private String m_iccPublicKeyType = null;
    private List<ICCTag> m_iccTags = new ArrayList<ICCTag>();
    private String m_iccType = null;
    private String m_issueNumber = null;
    private String m_localDateTime = null;
    private String m_localDateTimeFormat = null;
    private String m_transactionId = null;
    private Boolean m_onlinePinRequired = false;
    private String m_originatingIPAddressCity = null;
    private String m_originatingIPAddressContinent = null;
    private String m_originatingIPAddressContinentAlpha2 = null;
    private String m_originatingIPAddressCountry = null;
    private String m_originatingIPAddressCountryAlpha2 = null;
    private String m_originatingIPAddressCountryCode = null;
    private boolean m_originatingIPAddressIsBlackListed = false;
    private boolean m_originatingIPAddressIsKnownProxy = false;
    private String m_originatingIPAddressRegion = null;
    private String m_originatingIPAddressRegionCode = null;
    private String m_originatingIPAddressZipCode = null;
    private String m_par = null;
    private String m_pan = null;
    private FundingCard m_fundingCard = null;
    private ResultCode m_resultCode = ResultCode.Empty;
    private String m_startDate = null;
    private String m_startDateFormat = null;
    private Boolean m_3DSecureRequired = false;
    private String m_userReference = null;
    private String m_utc = null;
    private String m_utcFormat = null;
    private String m_voiceReferralTelephoneNumber = null;
    private String m_zipCodeResponseData = null;
    private VerificationResult m_zipCodeResult = VerificationResult.Empty;
    private String m_paymentProviderErrorCode;
    private String m_paymentProviderErrorDescription;
    private String m_customerVaultId = null;

    protected Response() {
    }

    public String getAddressResponseData() {
        return this.m_addressResponseData;
    }

    public VerificationResult getAddressResult() {
        return this.m_addressResult;
    }

    private static String getAttribute(Node node, String name) {
        NamedNodeMap attributes = node.getAttributes();
        if (attributes == null || attributes.getLength() == 0) {
            return null;
        }
        Node attribute = attributes.getNamedItem(name);
        if (attribute == null) {
            return null;
        }
        return attribute.getNodeValue();
    }

    public String getAmountOnlineApproved() {
        return this.m_amountOnlineApproved;
    }

    public String getAcquirerResponseCode() {
        return this.m_acquirerResponseCode;
    }

    public String getAuthCode() {
        return this.m_authCode;
    }

    public AuthorisationEntity getAuthorisationEntity() {
        return this.m_authorisationEntity;
    }

    public String getCardEaseReference() {
        return this.m_cardEaseReference;
    }

    public String getCardHash() {
        return this.m_cardHash;
    }

    public String getCardReference() {
        return this.m_cardReference;
    }

    public String getCardScheme() {
        return this.m_cardScheme;
    }

    public String getCardSchemeId() {
        return this.m_cardSchemeId;
    }

    public String getCardSchemeAccountType() {
        return this.m_cardSchemeAccountType;
    }

    public ArrayList<CardToken> getCardTokens() {
        return this.m_cardTokens;
    }

    public Name getCardHolderName() {
        return this.m_cardHolderName;
    }

    public String getCSCResponseData() {
        return this.m_cscResponseData;
    }

    public VerificationResult getCSCResult() {
        return this.m_cscResult;
    }

    public CurrencyData getCurrencyData() {
        return this.m_currencyData;
    }

    public boolean getDoNotReauthorize() {
        return this.m_doNotReauthorize;
    }

    public String getDoNotReauthorizeReason() {
        return this.m_doNotReauthorizeReason;
    }

    public boolean getDuplicate() {
        return this.m_duplicate;
    }

    public List<Error> getErrors() {
        return this.m_errors;
    }

    public String getExpiryDate() {
        return this.m_expiryDate;
    }

    public String getExpiryDateFormat() {
        return this.m_expiryDateFormat;
    }

    public List<ExtendedProperty> getExtendedProperties() {
        return this.m_extendedProperties;
    }

    public Boolean getFallfowardToContact() {
        return this.m_fallforwardToContact;
    }

    public List<CertificationAuthority> getICCCertificationAuthorities() {
        return this.m_iccCertificationAuthorities;
    }

    public boolean getICCPublicKeyClearExisting() {
        return this.m_iccPublicKeyClearExisting;
    }

    public String getICCPublicKeyContent() {
        return this.m_iccPublicKeyContent;
    }

    public boolean getICCPublicKeyReplaceExisting() {
        return this.m_iccPublicKeyReplaceExisting;
    }

    public String getICCPublicKeyType() {
        return this.m_iccPublicKeyType;
    }

    public List<ICCTag> getICCTags() {
        return this.m_iccTags;
    }

    public String getICCType() {
        return this.m_iccType;
    }

    public String getIssueNumber() {
        return this.m_issueNumber;
    }

    public String getLocalDateTime() {
        return this.m_localDateTime;
    }

    public String getLocalDateTimeFormat() {
        return this.m_localDateTimeFormat;
    }

    public String getTransactionId() {
        return this.m_transactionId;
    }

    public String getOriginatingIPAddressCity() {
        return this.m_originatingIPAddressCity;
    }

    public String getOriginatingIPAddressContinent() {
        return this.m_originatingIPAddressContinent;
    }

    public String getOriginatingIPAddressContinentAlpha2() {
        return this.m_originatingIPAddressContinentAlpha2;
    }

    public String getOriginatingIPAddressCountry() {
        return this.m_originatingIPAddressCountry;
    }

    public String getOriginatingIPAddressCountryAlpha2() {
        return this.m_originatingIPAddressCountryAlpha2;
    }

    public String getOriginatingIPAddressCountryCode() {
        return this.m_originatingIPAddressCountryCode;
    }

    public boolean getOriginatingIPAddressIsBlackListed() {
        return this.m_originatingIPAddressIsBlackListed;
    }

    public boolean getOriginatingIPAddressIsKnownProxy() {
        return this.m_originatingIPAddressIsKnownProxy;
    }

    public String getOriginatingIPAddressRegion() {
        return this.m_originatingIPAddressRegion;
    }

    public String getOriginatingIPAddressRegionCode() {
        return this.m_originatingIPAddressRegionCode;
    }

    public String getOriginatingIPAddressZipCode() {
        return this.m_originatingIPAddressZipCode;
    }

    public String getPAR() {
        return this.m_par;
    }

    public String getPAN() {
        return this.m_pan;
    }

    public FundingCard getFundingCard() {
        return this.m_fundingCard;
    }

    public ResultCode getResultCode() {
        return this.m_resultCode;
    }

    public String getStartDate() {
        return this.m_startDate;
    }

    public String getStartDateFormat() {
        return this.m_startDateFormat;
    }

    private static String getTextContent(Node node) {
        NodeList nodes = node.getChildNodes();
        if (nodes == null || nodes.getLength() == 0) {
            return null;
        }
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node value = nodes.item(i);
            if (value.getNodeType() != 3) continue;
            return value.getNodeValue();
        }
        return null;
    }

    public Boolean getOnlinePinRequired() {
        return this.m_onlinePinRequired;
    }

    public Boolean getThreeDSecureRequired() {
        return this.m_3DSecureRequired;
    }

    public String getUserReference() {
        return this.m_userReference;
    }

    public String getUTC() {
        return this.m_utc;
    }

    public String getUTCFormat() {
        return this.m_utcFormat;
    }

    public String getVoiceReferralTelephoneNumber() {
        return this.m_voiceReferralTelephoneNumber;
    }

    public String getZipCodeResponseData() {
        return this.m_zipCodeResponseData;
    }

    public VerificationResult getZipCodeResult() {
        return this.m_zipCodeResult;
    }

    public String getPaymentProviderErrorCode() {
        return this.m_paymentProviderErrorCode;
    }

    public String getPaymentProviderErrorDescription() {
        return this.m_paymentProviderErrorDescription;
    }

    public String getCustomerVaultId() {
        return this.m_customerVaultId;
    }

    private void parseAdditionalVerfication(Element rootElement) {
        NodeList nodes = rootElement.getElementsByTagName("AdditionalVerification");
        if (nodes == null || nodes.getLength() == 0) {
            return;
        }
        if ((nodes = nodes.item(0).getChildNodes()) == null || nodes.getLength() == 0) {
            return;
        }
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String name = node.getNodeName().toUpperCase();
            if (name.equals("ADDRESS")) {
                this.m_addressResult = VerificationResult.parse(Response.getTextContent(node));
                this.m_addressResponseData = Response.getAttribute(node, "raw");
                continue;
            }
            if (name.equals("ZIP")) {
                this.m_zipCodeResult = VerificationResult.parse(Response.getTextContent(node));
                this.m_zipCodeResponseData = Response.getAttribute(node, "raw");
                continue;
            }
            if (!name.equals("CSC")) continue;
            this.m_cscResult = VerificationResult.parse(Response.getTextContent(node));
            this.m_cscResponseData = Response.getAttribute(node, "raw");
        }
    }

    private void parseCardDetails(Element rootElement) {
        NodeList nodes = rootElement.getElementsByTagName("CardDetails");
        if (nodes == null || nodes.getLength() == 0) {
            return;
        }
        if ((nodes = nodes.item(0).getChildNodes()) == null || nodes.getLength() == 0) {
            return;
        }
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String name = node.getNodeName().toUpperCase();
            if (name.equals("CARDREFERENCE")) {
                this.m_cardReference = Response.getTextContent(node);
                continue;
            }
            if (name.equals("CARDHASH")) {
                this.m_cardHash = Response.getTextContent(node);
                continue;
            }
            if (name.equals("PAN")) {
                this.m_pan = Response.getTextContent(node);
                continue;
            }
            if (name.equals("PAR")) {
                this.m_par = Response.getTextContent(node);
                continue;
            }
            if (name.equals("EXPIRYDATE")) {
                this.m_expiryDateFormat = Response.getAttribute(node, "format");
                this.m_expiryDate = Response.getTextContent(node);
                continue;
            }
            if (name.equals("STARTDATE")) {
                this.m_startDateFormat = Response.getAttribute(node, "format");
                this.m_startDate = Response.getTextContent(node);
                continue;
            }
            if (name.equals("ISSUENUMBER")) {
                this.m_issueNumber = Response.getTextContent(node);
                continue;
            }
            if (name.equals("CARDSCHEME")) {
                String accountTypeAttribute;
                NodeList schemeNodes = node.getChildNodes();
                if (schemeNodes == null || schemeNodes.getLength() == 0) continue;
                String idAttribute = Response.getAttribute(node, "id");
                if (idAttribute != null && !idAttribute.isEmpty()) {
                    this.m_cardSchemeId = idAttribute;
                }
                if ((accountTypeAttribute = Response.getAttribute(node, "accountType")) != null && !accountTypeAttribute.isEmpty()) {
                    this.m_cardSchemeAccountType = accountTypeAttribute;
                }
                for (int j = 0; j < schemeNodes.getLength(); ++j) {
                    Node scheme = schemeNodes.item(j);
                    String schemeName = scheme.getNodeName().toUpperCase();
                    if (!schemeName.equals("DESCRIPTION")) continue;
                    this.m_cardScheme = Response.getTextContent(scheme);
                }
                continue;
            }
            if (name.equals("CONTACT")) {
                this.parseContactFields(node);
                continue;
            }
            if (name.equals("ICC")) {
                this.parseICCTags(node);
                continue;
            }
            if (name.equals("FUNDINGCARD")) {
                this.parseFundingCard(node);
                continue;
            }
            if (!name.equals("CARDTOKENS")) continue;
            NodeList tokenNodes = node.getChildNodes();
            this.m_cardTokens = new ArrayList();
            for (int j = 0; j < tokenNodes.getLength(); ++j) {
                CardToken token = this.parseCardToken(tokenNodes.item(j));
                if (token == null) continue;
                this.m_cardTokens.add(token);
            }
        }
    }

    private CardToken parseCardToken(Node cardToken) {
        if (cardToken == null) {
            return null;
        }
        String alg = Response.getAttribute(cardToken, "alg");
        String kid = Response.getAttribute(cardToken, "kid");
        String value = Response.getTextContent(cardToken);
        return new CardToken(alg, kid, value);
    }

    private void parseFundingCard(Node fundingCardNode) {
        String cardReference = "";
        String cardHash = "";
        String pan = "";
        String expiryDate = "";
        String expiryDateFormat = "";
        ArrayList<CardToken> cardTokens = null;
        NodeList nodes = fundingCardNode.getChildNodes();
        if (nodes == null || nodes.getLength() == 0) {
            return;
        }
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String name = node.getNodeName().toUpperCase();
            if (name.equals("CARDREFERENCE")) {
                cardReference = Response.getTextContent(node);
                continue;
            }
            if (name.equals("CARDHASH")) {
                cardHash = Response.getTextContent(node);
                continue;
            }
            if (name.equals("PAN")) {
                pan = Response.getTextContent(node);
                continue;
            }
            if (name.equals("EXPIRYDATE")) {
                expiryDateFormat = Response.getAttribute(node, "format");
                expiryDate = Response.getTextContent(node);
                continue;
            }
            if (!name.equals("CARDTOKENS")) continue;
            NodeList tokenNodes = node.getChildNodes();
            cardTokens = new ArrayList<CardToken>();
            for (i = 0; i < tokenNodes.getLength(); ++i) {
                CardToken token = this.parseCardToken(tokenNodes.item(i));
                if (token == null) continue;
                cardTokens.add(token);
            }
        }
        if (!(cardReference.isEmpty() || cardHash.isEmpty() || pan.isEmpty() || expiryDate.isEmpty() || expiryDateFormat.isEmpty())) {
            this.m_fundingCard = new FundingCard(cardReference, cardHash, pan, expiryDate, expiryDateFormat, cardTokens);
        }
    }

    private void parseCertificationAuthority(Node certificationAuthorityNode) {
        String description = Response.getAttribute(certificationAuthorityNode, "description");
        String rid = Response.getAttribute(certificationAuthorityNode, "rid");
        CertificationAuthority certificationAuthority = new CertificationAuthority(description, rid);
        this.m_iccCertificationAuthorities.add(certificationAuthority);
        NodeList nodes = certificationAuthorityNode.getChildNodes();
        if (nodes == null || nodes.getLength() == 0) {
            return;
        }
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String name = node.getNodeName().toUpperCase();
            if (!name.equals("PUBLICKEY")) continue;
            Response.parsePublicKey(node, certificationAuthority);
        }
    }

    private void parseExtendedPropertyList(Node extendedPropertyListNode) {
        NodeList nodes = extendedPropertyListNode.getChildNodes();
        if (nodes == null || nodes.getLength() == 0) {
            return;
        }
        for (int j = 0; j < nodes.getLength(); ++j) {
            Node node = nodes.item(j);
            String id = Response.getAttribute(node, "id");
            String value = Response.getTextContent(node);
            this.m_extendedProperties.add(new ExtendedProperty(id, value));
        }
    }

    private void parseICCPublicKeys(Element rootElement) {
        NodeList nodes = rootElement.getElementsByTagName("ICCPublicKeys");
        if (nodes == null || nodes.getLength() == 0) {
            return;
        }
        this.m_iccPublicKeyType = Response.getAttribute(nodes.item(0), "type");
        this.m_iccPublicKeyContent = Response.getAttribute(nodes.item(0), "content");
        this.m_iccPublicKeyClearExisting = Boolean.valueOf(Response.getAttribute(nodes.item(0), "clearexisting"));
        this.m_iccPublicKeyReplaceExisting = Boolean.valueOf(Response.getAttribute(nodes.item(0), "replaceexisting"));
        if ((nodes = nodes.item(0).getChildNodes()) == null || nodes.getLength() == 0) {
            return;
        }
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String name = node.getNodeName().toUpperCase();
            if (!name.equals("CERTIFICATIONAUTHORITY")) continue;
            this.parseCertificationAuthority(node);
        }
    }

    private void parseContactFields(Node contactNode) {
        for (int i = 0; i < contactNode.getChildNodes().getLength(); ++i) {
            Node node = contactNode.getChildNodes().item(i);
            String name = node.getNodeName().toUpperCase();
            if (!name.equals("NAME")) continue;
            for (int j = 0; j < node.getChildNodes().getLength(); ++j) {
                Node childNode = node.getChildNodes().item(j);
                String childName = childNode.getNodeName().toUpperCase();
                if (childName.equals("TITLE")) {
                    this.m_cardHolderName.setTitle(childNode.getTextContent());
                    continue;
                }
                if (childName.equals("FIRSTNAME")) {
                    this.m_cardHolderName.setFirstName(childNode.getTextContent());
                    continue;
                }
                if (childName.equals("INITIALS")) {
                    this.m_cardHolderName.setInitials(childNode.getTextContent());
                    continue;
                }
                if (!childName.equals("LASTNAME")) continue;
                this.m_cardHolderName.setLastName(childNode.getTextContent());
            }
        }
    }

    private void parseICCTags(Node iccNode) {
        this.m_iccType = Response.getAttribute(iccNode, "type");
        NodeList nodes = iccNode.getChildNodes();
        if (nodes == null || nodes.getLength() == 0) {
            return;
        }
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String id = Response.getAttribute(node, "tagid");
            String type = Response.getAttribute(node, "type");
            String value = Response.getTextContent(node);
            if (type == null) {
                this.m_iccTags.add(new ICCTag(id, value));
                continue;
            }
            this.m_iccTags.add(new ICCTag(id, ICCTagValueType.parse(type), value));
        }
    }

    private static void parsePublicKey(Node publicKeyNode, CertificationAuthority certificationAuthority) {
        String index = Response.getAttribute(publicKeyNode, "index");
        String hash = Response.getAttribute(publicKeyNode, "hash");
        String hashAlgorithm = Response.getAttribute(publicKeyNode, "hashalgorithm");
        PublicKey publicKey = new PublicKey(index, hash, hashAlgorithm);
        certificationAuthority.addPublicKey(publicKey);
        NodeList nodes = publicKeyNode.getChildNodes();
        if (nodes == null || nodes.getLength() == 0) {
            return;
        }
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String name = node.getNodeName().toUpperCase();
            if (name.equals("ALGORITHM")) {
                publicKey.setAlgorithm(Response.getTextContent(node));
                continue;
            }
            if (name.equals("MODULUS")) {
                publicKey.setModulus(Response.getTextContent(node));
                continue;
            }
            if (name.equals("EXPONENT")) {
                publicKey.setExponent(Response.getTextContent(node));
                continue;
            }
            if (name.equals("VALIDFROM")) {
                publicKey.setValidFromDate(Response.getTextContent(node));
                publicKey.setValidFromDateFormat(Response.getAttribute(node, "format"));
                continue;
            }
            if (!name.equals("VALIDTO")) continue;
            publicKey.setValidToDate(Response.getTextContent(node));
            publicKey.setValidToDateFormat(Response.getAttribute(node, "format"));
        }
    }

    protected void parseResponseXML(String xml) throws CardEaseXMLResponseException {
        Document domDocument;
        DocumentBuilder documentBuilder;
        Pattern encoding = Pattern.compile("<[?]xml version=\"1.0\" encoding=\"(.*?)\".*[?]>", 42);
        Matcher match = encoding.matcher(xml);
        ByteArrayInputStream xmlStream = null;
        if (match.matches()) {
            try {
                xmlStream = new ByteArrayInputStream(xml.getBytes(match.group(1)));
            }
            catch (UnsupportedEncodingException e) {
                throw new CardEaseXMLResponseException("Unsupported encoding found in XML", e);
            }
        } else {
            xmlStream = new ByteArrayInputStream(xml.getBytes());
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new CardEaseXMLResponseException("Unable to parse XML due to configuration problem", e);
        }
        try {
            domDocument = documentBuilder.parse(xmlStream);
        }
        catch (SAXException e) {
            throw new CardEaseXMLResponseException("Unable to parse XML", e);
        }
        catch (IOException e) {
            throw new CardEaseXMLResponseException("Unable to read XML", e);
        }
        Element rootElement = domDocument.getDocumentElement();
        if (rootElement == null) {
            throw new CardEaseXMLResponseException("Response not found");
        }
        this.parseTransactionDetails(rootElement);
        this.parseResult(rootElement);
        this.parseCardDetails(rootElement);
        this.parseAdditionalVerfication(rootElement);
        this.parseICCPublicKeys(rootElement);
    }

    private void parseResult(Element rootElement) {
        NodeList nodes = rootElement.getElementsByTagName("Result");
        if (nodes == null || nodes.getLength() == 0) {
            return;
        }
        String duplicate = Response.getAttribute(nodes.item(0), "duplicate");
        if (duplicate != null) {
            this.m_duplicate = Boolean.valueOf(duplicate);
        }
        if ((nodes = nodes.item(0).getChildNodes()) == null || nodes.getLength() == 0) {
            return;
        }
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String name = node.getNodeName().toUpperCase();
            if (name.equals("LOCALRESULT")) {
                this.m_resultCode = ResultCode.parse(Response.getTextContent(node));
                continue;
            }
            if (name.equals("AUTHORISATIONENTITY")) {
                this.m_authorisationEntity = AuthorisationEntity.parse(Response.getTextContent(node));
                continue;
            }
            if (name.equals("AMOUNTONLINEAPPROVED")) {
                this.m_amountOnlineApproved = Response.getTextContent(node);
                continue;
            }
            if (name.equals("AUTHCODE")) {
                this.m_authCode = Response.getTextContent(node);
                continue;
            }
            if (name.equals("FALLFORWARDTOCONTACT")) {
                String fallforwardToContact = Response.getTextContent(node);
                if (fallforwardToContact == null) continue;
                this.m_fallforwardToContact = (boolean)Boolean.valueOf(fallforwardToContact);
                continue;
            }
            if (name.equals("ONLINEPINREQUIRED")) {
                String onlinePinRequired = Response.getTextContent(node);
                if (onlinePinRequired == null) continue;
                this.m_onlinePinRequired = (boolean)Boolean.valueOf(onlinePinRequired);
                continue;
            }
            if (name.equals("THREEDSECUREREQUIRED")) {
                String threeDSecureRequired = Response.getTextContent(node);
                if (threeDSecureRequired == null) continue;
                this.m_3DSecureRequired = (boolean)Boolean.valueOf(threeDSecureRequired);
                continue;
            }
            if (name.equals("DONOTREAUTHORIZE")) {
                String doNotReauthorize = Response.getTextContent(node);
                if (doNotReauthorize == null) continue;
                this.m_doNotReauthorize = Boolean.parseBoolean(doNotReauthorize);
                String doNotReauthorizeReason = Response.getTextContent(node.getAttributes().getNamedItem("reason"));
                if (doNotReauthorizeReason == null) continue;
                this.m_doNotReauthorizeReason = doNotReauthorizeReason;
                continue;
            }
            if (name.equals("REFERRALTELEPHONENUMBER")) {
                this.m_voiceReferralTelephoneNumber = Response.getTextContent(node);
                continue;
            }
            if (name.equals("ERRORS")) {
                NodeList errors = node.getChildNodes();
                if (errors == null || errors.getLength() == 0) {
                    return;
                }
                for (int j = 0; j < errors.getLength(); ++j) {
                    Node error = errors.item(j);
                    String code = Response.getAttribute(error, "code");
                    String message = Response.getTextContent(error);
                    this.m_errors.add(new Error(ErrorCode.parse(code), message));
                }
                continue;
            }
            if (name.equals("ACQUIRERRESPONSECODE")) {
                this.m_acquirerResponseCode = Response.getTextContent(node);
                continue;
            }
            if (!name.equals("PAYMENTPROVIDERERROR")) continue;
            this.m_paymentProviderErrorCode = Response.getAttribute(node, "code");
            this.m_paymentProviderErrorDescription = Response.getTextContent(node);
        }
    }

    private void parseTransactionDetails(Element rootElement) {
        NodeList nodes = rootElement.getElementsByTagName("TransactionDetails");
        if (nodes == null || nodes.getLength() == 0) {
            return;
        }
        if ((nodes = nodes.item(0).getChildNodes()) == null || nodes.getLength() == 0) {
            return;
        }
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String name = node.getNodeName().toUpperCase();
            if (name.equals("REFERENCE")) {
                this.m_userReference = Response.getTextContent(node);
                continue;
            }
            if (name.equals("CARDEASEREFERENCE")) {
                this.m_cardEaseReference = Response.getTextContent(node);
                continue;
            }
            if (name.equals("GWTRANSACTIONID")) {
                this.m_transactionId = Response.getTextContent(node);
                continue;
            }
            if (name.equals("LOCALDATETIME")) {
                this.m_localDateTimeFormat = Response.getAttribute(node, "format");
                this.m_localDateTime = Response.getTextContent(node);
                continue;
            }
            if (name.equals("UTC")) {
                this.m_utcFormat = Response.getAttribute(node, "format");
                this.m_utc = Response.getTextContent(node);
                continue;
            }
            if (name.equals("EXTENDEDPROPERTYLIST")) {
                this.parseExtendedPropertyList(node);
                continue;
            }
            if (name.equals("GEOIP")) {
                NodeList geoipNodes = node.getChildNodes();
                this.m_originatingIPAddressIsBlackListed = Boolean.valueOf(Response.getAttribute(node, "IsBlackListed"));
                this.m_originatingIPAddressIsKnownProxy = Boolean.valueOf(Response.getAttribute(node, "IsKnownProxy"));
                for (int g = 0; g < geoipNodes.getLength(); ++g) {
                    Node geoipNode = geoipNodes.item(g);
                    String geoipName = geoipNode.getNodeName().toUpperCase();
                    if (geoipName.equals("CITY")) {
                        this.m_originatingIPAddressCity = Response.getTextContent(geoipNode);
                        continue;
                    }
                    if (geoipName.equals("CONTINENT")) {
                        this.m_originatingIPAddressContinent = Response.getTextContent(geoipNode);
                        this.m_originatingIPAddressContinentAlpha2 = Response.getAttribute(geoipNode, "alpha2");
                        continue;
                    }
                    if (geoipName.equals("COUNTRY")) {
                        this.m_originatingIPAddressCountry = Response.getTextContent(geoipNode);
                        this.m_originatingIPAddressCountryAlpha2 = Response.getAttribute(geoipNode, "alpha2");
                        this.m_originatingIPAddressCountryCode = Response.getAttribute(geoipNode, "code");
                        continue;
                    }
                    if (geoipName.equals("REGION")) {
                        this.m_originatingIPAddressRegion = Response.getTextContent(geoipNode);
                        this.m_originatingIPAddressRegionCode = Response.getAttribute(geoipNode, "code");
                        continue;
                    }
                    if (!geoipName.equals("ZIPCODE")) continue;
                    this.m_originatingIPAddressZipCode = Response.getTextContent(geoipNode);
                }
                continue;
            }
            if (name.equals("CURRENCYDATA")) {
                String numericCode = Response.getAttribute(node, "currencyCode");
                String symbol = Response.getAttribute(node, "currencySymbol");
                String charCode = Response.getAttribute(node, "currencyAlpha");
                int exponent = Integer.valueOf(Response.getAttribute(node, "currencyExponent"));
                this.m_currencyData = new CurrencyData(numericCode, symbol, charCode, exponent);
                continue;
            }
            if (!name.equals("GWCUSTOMERVAULTID")) continue;
            this.m_customerVaultId = Response.getTextContent(node);
        }
    }

    public String toString() {
        String eol = System.getProperty("line.separator");
        String sep = ": ";
        StringBuilder str = new StringBuilder();
        str.append("RESPONSE:");
        str.append(eol);
        str.append("AddressResponseData");
        str.append(sep);
        str.append(this.m_addressResponseData);
        str.append(eol);
        str.append("AddressResult");
        str.append(sep);
        str.append((Object)this.m_addressResult);
        str.append(eol);
        str.append("AmountOnlineApproved");
        str.append(sep);
        str.append(this.m_amountOnlineApproved);
        str.append(eol);
        str.append("AuthCode");
        str.append(sep);
        str.append(this.m_authCode);
        str.append(eol);
        str.append("AuthorisationEntity");
        str.append(sep);
        str.append((Object)this.m_authorisationEntity);
        str.append(eol);
        str.append("CardEaseReference");
        str.append(sep);
        str.append(this.m_cardEaseReference);
        str.append(eol);
        str.append("CardHash");
        str.append(sep);
        str.append(this.m_cardHash);
        str.append(eol);
        str.append("CardReference");
        str.append(sep);
        str.append(this.m_cardReference);
        str.append(eol);
        str.append("CardScheme");
        str.append(sep);
        str.append(this.m_cardScheme);
        str.append(eol);
        str.append("CardSchemeId");
        str.append(sep);
        str.append(this.m_cardSchemeId);
        str.append(eol);
        str.append("CardSchemeAccountType");
        str.append(sep);
        str.append(this.m_cardSchemeAccountType);
        str.append(eol);
        str.append("CSCResponseData");
        str.append(sep);
        str.append(this.m_cscResponseData);
        str.append(eol);
        str.append("CSCResult");
        str.append(sep);
        str.append((Object)this.m_cscResult);
        str.append(eol);
        if (this.m_currencyData != null) {
            str.append("CurrencyData");
            str.append(sep);
            str.append(this.m_currencyData);
            str.append(eol);
        }
        str.append("DoNotReauthorize");
        str.append(sep);
        str.append(this.m_doNotReauthorize);
        str.append(eol);
        str.append("DoNotReauthorizeReason");
        str.append(sep);
        str.append(this.m_doNotReauthorizeReason);
        str.append(eol);
        str.append("Duplicate");
        str.append(sep);
        str.append(this.m_duplicate);
        str.append(eol);
        str.append("Errors");
        str.append(sep);
        str.append(this.m_errors);
        str.append(eol);
        str.append("ExpiryDate");
        str.append(sep);
        str.append(this.m_expiryDate);
        str.append(eol);
        str.append("ExpiryDateFormat");
        str.append(sep);
        str.append(this.m_expiryDateFormat);
        str.append(eol);
        str.append("ExtendedProperties");
        str.append(sep);
        str.append(this.m_extendedProperties);
        str.append(eol);
        str.append("FallforwardToContact");
        str.append(sep);
        str.append(this.m_fallforwardToContact);
        str.append(eol);
        str.append("ICCCertificationAuthorities");
        str.append(sep);
        str.append(this.m_iccCertificationAuthorities);
        str.append(eol);
        str.append("ICCPublicKeyClearExisting");
        str.append(sep);
        str.append(this.m_iccPublicKeyClearExisting);
        str.append(eol);
        str.append("ICCPublicKeyContent");
        str.append(sep);
        str.append(this.m_iccPublicKeyContent);
        str.append(eol);
        str.append("ICCPublicKeyReplaceExisting");
        str.append(sep);
        str.append(this.m_iccPublicKeyReplaceExisting);
        str.append(eol);
        str.append("ICCPublicKeyType");
        str.append(sep);
        str.append(this.m_iccPublicKeyType);
        str.append(eol);
        str.append("ICCTags");
        str.append(sep);
        str.append(this.m_iccTags);
        str.append(eol);
        str.append("ICCType");
        str.append(sep);
        str.append(this.m_iccType);
        str.append(eol);
        str.append("IssueNumber");
        str.append(sep);
        str.append(this.m_issueNumber);
        str.append(eol);
        str.append("LocalDateTime");
        str.append(sep);
        str.append(this.m_localDateTime);
        str.append(eol);
        str.append("LocalDateTimeFormat");
        str.append(sep);
        str.append(this.m_localDateTimeFormat);
        str.append(eol);
        str.append("OriginatingIPAddressCity");
        str.append(sep);
        str.append(this.m_originatingIPAddressCity);
        str.append(eol);
        str.append("OnlinePinRequired");
        str.append(sep);
        str.append(this.m_onlinePinRequired);
        str.append(eol);
        str.append("OriginatingIPAddressContinent");
        str.append(sep);
        str.append(this.m_originatingIPAddressContinent);
        str.append(eol);
        str.append("OriginatingIPAddressContinentAlpha2");
        str.append(sep);
        str.append(this.m_originatingIPAddressContinentAlpha2);
        str.append(eol);
        str.append("OriginatingIPAddressCountry");
        str.append(sep);
        str.append(this.m_originatingIPAddressCountry);
        str.append(eol);
        str.append("OriginatingIPAddressCountryAlpha2");
        str.append(sep);
        str.append(this.m_originatingIPAddressCountryAlpha2);
        str.append(eol);
        str.append("OriginatingIPAddressCountryCode");
        str.append(sep);
        str.append(this.m_originatingIPAddressCountryCode);
        str.append(eol);
        str.append("OriginatingIPAddressIsBlackListed");
        str.append(sep);
        str.append(this.m_originatingIPAddressIsBlackListed);
        str.append(eol);
        str.append("OriginatingIPAddressIsKnownProxy");
        str.append(sep);
        str.append(this.m_originatingIPAddressIsKnownProxy);
        str.append(eol);
        str.append("OriginatingIPAddressRegion");
        str.append(sep);
        str.append(this.m_originatingIPAddressRegion);
        str.append(eol);
        str.append("OriginatingIPAddressRegionCode");
        str.append(sep);
        str.append(this.m_originatingIPAddressRegionCode);
        str.append(eol);
        str.append("OriginatingIPAddressZipCode");
        str.append(sep);
        str.append(this.m_originatingIPAddressZipCode);
        str.append(eol);
        str.append("PAR");
        str.append(sep);
        str.append(this.m_par);
        str.append(eol);
        str.append("PAN");
        str.append(sep);
        str.append(this.m_pan);
        str.append(eol);
        str.append("Funding Card");
        str.append(sep);
        str.append(this.m_fundingCard);
        str.append(eol);
        str.append("ResultCode");
        str.append(sep);
        str.append((Object)this.m_resultCode);
        str.append(eol);
        str.append("StartDate");
        str.append(sep);
        str.append(this.m_startDate);
        str.append(eol);
        str.append("StartDateFormat");
        str.append(sep);
        str.append(this.m_startDateFormat);
        str.append(eol);
        str.append("UserReference");
        str.append(sep);
        str.append(this.m_userReference);
        str.append(eol);
        str.append("UTC");
        str.append(sep);
        str.append(this.m_utc);
        str.append(eol);
        str.append("UTCFormat");
        str.append(sep);
        str.append(this.m_utcFormat);
        str.append(eol);
        str.append("VoiceReferralTelephoneNumber");
        str.append(sep);
        str.append(this.m_voiceReferralTelephoneNumber);
        str.append(eol);
        str.append("ZipCodeResponseData");
        str.append(sep);
        str.append(this.m_zipCodeResponseData);
        str.append(eol);
        str.append("ZipCodeResult");
        str.append(sep);
        str.append((Object)this.m_zipCodeResult);
        str.append(eol);
        return str.toString();
    }
}

