/*
 * Decompiled with CFR 0.152.
 */
package com.idtechproducts.device;

import android.os.Environment;
import android.os.Handler;
import android.os.StrictMode;
import android.util.Base64;
import com.idtechproducts.device.Common;
import com.idtechproducts.device.IDTEMVData;
import com.idtechproducts.device.IDTMSRData;
import com.idtechproducts.device.IDT_Device;
import com.idtechproducts.device.OnReceiverListener;
import com.idtechproducts.device.ReaderInfo;
import com.idtechproducts.device.ResDataStruct;
import com.idtechproducts.device.StructConfigParameters;
import com.idtechproducts.device.WorldpayListener;
import com.idtechproducts.device.audiojack.UMLog;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Scanner;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class WorldPay
implements OnReceiverListener {
    private Handler handler = null;
    public boolean returnRequest = false;
    WorldpayListener myCallback = null;
    OnReceiverListener originalCallback = null;
    IDT_Device device = null;
    WorldPayData currentData = null;
    boolean _requestOnly = false;
    byte[] lastRawData = null;
    byte[] msrData = null;
    boolean isEMV = false;
    boolean goOnline = false;
    boolean isNEO = false;
    boolean isCTLS = false;
    public static boolean inTransaction = false;
    int hasLicense = -1;
    int transactionType = 0;
    public static boolean hasVAS = false;
    String transName = "";
    String PAN = "";
    String strUrl = "";
    WorldPayData _data = null;
    int recordIdx = -1;
    String strId = null;
    private Runnable doCompletion = new Runnable(){

        @Override
        public void run() {
            int rt = WorldPay.this.device.emv_completeTransaction(true, null, null, null, null);
            if (rt == 99) {
                rt = 0;
            }
            if (rt == 61027) {
                rt = 0;
            }
            if (rt != 0) {
                WorldPay.this.endTransaction("Complete Transaction Failure", rt, 0, WorldPay.this.currentTransactionData);
                return;
            }
            WorldPay.this.goOnline = true;
        }
    };
    private Runnable doAuthentication = new Runnable(){

        @Override
        public void run() {
            int rt = WorldPay.this.device.emv_authenticateTransaction(null);
            if (rt == 99) {
                rt = 0;
            }
            if (rt == 61027) {
                rt = 0;
            }
            if (rt != 0) {
                WorldPay.this.endTransaction("Data Authentication Failure", rt, 0, WorldPay.this.currentTransactionData);
                return;
            }
        }
    };
    static WorldPayData qcData = null;
    static IDTEMVData qcCard = null;
    IDTEMVData firstACData = null;
    IDTEMVData currentTransactionData = null;

    public WorldPay() {
        StrictMode.ThreadPolicy policy = new StrictMode.ThreadPolicy.Builder().permitAll().build();
        StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)policy);
        this.handler = new Handler();
    }

    private void sendMessage(String str) {
        UMLog.i("sendMessage", str);
        if (this.originalCallback != null) {
            this.originalCallback.lcdDisplay(3, new String[]{str}, 0);
        }
    }

    public ReceiptData ReceiptCTLS(IDTEMVData emvData, String xml) {
        Map<String, byte[]> dict2;
        String tagVal;
        IDTMSRData card = null;
        if (emvData != null) {
            card = emvData.msr_cardData;
        }
        ReceiptData receipt = new ReceiptData();
        if (xml == null) {
            xml = "";
        }
        boolean isError = xml.isEmpty();
        receipt.saleType = this.currentData.transactionType;
        receipt.authReversal = this.currentData.authReversal;
        receipt.tokenSubstitute = this.currentData.tokenSubstitute;
        Map<Object, Object> dict = new Hashtable();
        if (emvData != null && emvData.unencryptedTags != null) {
            dict = emvData.unencryptedTags;
        }
        Map<Object, Object> maskedTags = new Hashtable();
        if (emvData != null && emvData.maskedTags != null) {
            maskedTags = emvData.maskedTags;
        }
        if (xml != null && !xml.isEmpty() && (tagVal = Common.getXMLValue(xml, "MagneprintData")) != null && !tagVal.isEmpty() && tagVal.startsWith("DFEE25")) {
            dict2 = Common.processTLVUnencrypted(Common.getByteArray(tagVal));
            for (Map.Entry<String, byte[]> entry : dict2.entrySet()) {
                if (dict.containsKey(entry.getKey())) {
                    dict.remove(entry.getKey());
                }
                dict.put(entry.getKey(), entry.getValue());
            }
        }
        byte[] ff8105 = null;
        if (dict.containsKey("FF8105")) {
            ff8105 = (byte[])dict.get("FF8105");
        }
        if (ff8105 != null && ff8105.length > 0) {
            dict2 = Common.processTLVUnencrypted(ff8105);
            for (Map.Entry<String, byte[]> entry : dict2.entrySet()) {
                if (dict.containsKey(entry.getKey())) {
                    dict.remove(entry.getKey());
                }
                dict.put(entry.getKey(), entry.getValue());
            }
        }
        ff8105 = null;
        if (dict.containsKey("FF8106")) {
            ff8105 = (byte[])dict.get("FF8106");
        }
        if (ff8105 != null && ff8105.length > 0) {
            dict2 = Common.processTLVUnencrypted(ff8105);
            for (Map.Entry<String, byte[]> entry : dict2.entrySet()) {
                if (dict.containsKey(entry.getKey())) {
                    dict.remove(entry.getKey());
                }
                dict.put(entry.getKey(), entry.getValue());
            }
        }
        String transReason = "";
        if (emvData != null) {
            OnReceiverListener.EMV_RESULT_CODE_Types type = OnReceiverListener.EMV_RESULT_CODE_Types.EMV_RESULT_CODE_APPROVED;
            for (OnReceiverListener.EMV_RESULT_CODE_Types e : OnReceiverListener.EMV_RESULT_CODE_Types.values()) {
                if (e.val != emvData.result) continue;
                type = e;
                break;
            }
            switch (type) {
                case EMV_RESULT_CODE_APPROVED: {
                    transReason = "REASON: APPROVED";
                    isError = false;
                    break;
                }
                case EMV_RESULT_CODE_OFFLINE_APPROVED: {
                    transReason = "REASON: APPROVED OFFLINE";
                    isError = false;
                    break;
                }
                case EMV_RESULT_CODE_OFFLINE_DECLINED: {
                    transReason = "REASON: DECLINED OFFLINE";
                    isError = true;
                    break;
                }
                case EMV_RESULT_CODE_DECLINED: {
                    transReason = "REASON: DECLINED";
                    isError = true;
                    break;
                }
                case EMV_RESULT_CODE_CALL_YOUR_BANK: {
                    transReason = "CALL YOUR BANK";
                    isError = true;
                    break;
                }
                case EMV_RESULT_CODE_NOT_ACCEPTED: {
                    transReason = "REASON: NOT ACCEPTED";
                    isError = true;
                    break;
                }
                case EMV_RESULT_CODE_TIME_OUT: {
                    transReason = "TRANSACTION TIMEOUT";
                    isError = true;
                    break;
                }
                case EMV_RESULT_CODE_CTLS_TWO_CARDS: {
                    transReason = "TWO CARDS DETECTED";
                    isError = true;
                    break;
                }
                case EMV_RESULT_CODE_CTLS_TERMINATE: {
                    transReason = "REASON: TERMINATE";
                    isError = true;
                    break;
                }
                case EMV_RESULT_CODE_CTLS_TERMINATE_TRY_ANOTHER: {
                    transReason = "TRY ANOTHER CARD";
                    isError = true;
                    break;
                }
                case EMV_RESULT_CODE_TERMINATE: {
                    transReason = "REASON: FAILED";
                    if (xml != null && !xml.isEmpty() && xml.length() < 35) {
                        transReason = xml;
                    }
                    isError = true;
                    break;
                }
                case EMV_RESULT_CODE_ADVISE_REQUIRED: {
                    transReason = "ADVISE REQUIRED";
                    isError = true;
                    break;
                }
                case EMV_RESULT_CODE_REVERSAL_REQUIRED: {
                    transReason = "REVERSAL REQUIRED";
                    isError = true;
                    break;
                }
                case EMV_RESULT_CODE_ADVISE_REVERSAL_REQUIRED: {
                    transReason = "ADVISE REVERSAL REQUIRED";
                    isError = true;
                    break;
                }
                case EMV_RESULT_CODE_NO_ADVISE_REVERSAL_REQUIRED: {
                    transReason = "NO ADVISE REVERSAL REQUIRED";
                    isError = true;
                    break;
                }
                default: {
                    transReason = "REASON: APPROVED";
                    isError = false;
                }
            }
        }
        byte[] codes = null;
        if (dict.containsKey("FFEE1F")) {
            codes = (byte[])dict.get("FFEE1F");
        }
        if (codes != null && codes.length > 1) {
            if (codes[0] == 32) {
                transReason = "CARD NOT SUPPORTED";
                isError = true;
            }
            if (codes[0] == 66 || codes[0] == 85) {
                transReason = "DECLINE OFFLINE";
                isError = true;
            }
            if (codes[0] == 39) {
                transReason = "NOT SUPPORTED";
                isError = true;
            }
        }
        codes = null;
        if (dict.containsKey("DFEE02")) {
            codes = (byte[])dict.get("DFEE02");
        }
        if (codes != null && codes.length > 1) {
            if (codes[0] == 32) {
                transReason = "CARD NOT SUPPORTED";
                isError = true;
            }
            if (codes[0] == 66 || codes[0] == 85) {
                transReason = "DECLINE OFFLINE";
                isError = true;
            }
            if (codes[0] == 39) {
                transReason = "NOT SUPPORTED";
                isError = true;
            }
        }
        Object var11_18 = null;
        if (xml != null) {
            String string = Common.getXMLValue(xml, "ExpressResponseMessage");
            if (string != null && (string.toUpperCase().contains("APPROVED") || string.toUpperCase().contains("SUCCESS"))) {
                transReason = string.toUpperCase();
                if (string.toUpperCase().contains("PARTIAL APPROVED")) {
                    String tagAmount = Common.getXMLValue(xml, "ApprovedAmount");
                    if (tagAmount == null) {
                        transReason = "PARTIAL APPROVAL DECLINED";
                        isError = true;
                        receipt.amount = null;
                    } else {
                        transReason = "PARTIAL AMOUNT APPROVED";
                        isError = false;
                    }
                } else {
                    isError = false;
                }
            } else {
                transReason = string != null ? string.toUpperCase() : "WORLDPAY XML UNKNOWN ERROR";
                isError = true;
            }
        }
        receipt.isApproved = !isError;
        receipt.result = transReason;
        if (emvData != null && emvData.cardType != 1) {
            receipt.entryMethod = ENTRY_METHOD.ENTRY_METHOD_SWIPE;
        }
        byte[] __pan = null;
        String _pan = null;
        if (dict.containsKey("DFEF5B")) {
            __pan = (byte[])dict.get("DFEF5B");
        }
        if (__pan == null && dict.containsKey("DFEF5D")) {
            __pan = (byte[])dict.get("DFEF5D");
        }
        if (__pan == null && maskedTags.containsKey("57")) {
            __pan = (byte[])maskedTags.get("57");
        }
        receipt.entryMethod = card != null && card.encTrack2 != null && card.encTrack2.length > 0 ? ENTRY_METHOD.ENTRY_METHOD_SWIPE : (emvData != null && emvData.cardType == 1 ? ENTRY_METHOD.ENTRY_METHOD_CTLS : ENTRY_METHOD.ENTRY_METHOD_CONTACT);
        _pan = card != null && card.track2 != null && card.track2.length() > 0 ? card.track2 : (__pan != null && __pan.length > 0 ? Common.getHexStringFromBytes(__pan) : "");
        if (_pan.length() > 0) {
            String[] ar = _pan.split("=");
            _pan = ar[0];
        }
        String _name = "";
        byte[] __name = null;
        if (dict.containsKey("5F20")) {
            __name = (byte[])dict.get("5F20");
        }
        if (__name != null && __name.length > 0) {
            _name = new String(__name);
        } else {
            if (dict.containsKey("FFEE05")) {
                __name = (byte[])dict.get("FFEE05");
            }
            if (__name != null && __name.length > 0) {
                Map<String, byte[]> dict22 = Common.processTLVUnencrypted(__name);
                if (dict.containsKey("5F20")) {
                    __name = (byte[])dict.get("5F20");
                }
                if (__name != null && __name.length > 0) {
                    _name = String.valueOf(__name);
                }
            }
        }
        if (_name == null || _name.length() == 0) {
            String[] strs;
            String track1 = null;
            if (card != null) {
                track1 = card.track1;
            }
            if (track1 == null && emvData != null && emvData.msr_cardData != null) {
                track1 = emvData.msr_cardData.track1;
            }
            if (track1 != null && track1.length() > 0 && (_name == null || _name.length() == 0) && (strs = track1.split("^")).length > 1) {
                _name = strs[1];
            }
        }
        String _aid = "";
        byte[] __aid = null;
        if (dict != null && dict.containsKey("84")) {
            __aid = (byte[])dict.get("84");
        }
        if (__aid == null && dict != null && dict.containsKey("9F06")) {
            __aid = (byte[])dict.get("9F06");
        }
        if (__aid != null) {
            _aid = Common.getHexStringFromBytes(__aid);
        }
        String _transType = "";
        byte[] ___transType = null;
        if (dict.containsKey("9C")) {
            ___transType = (byte[])dict.get("9C");
        }
        if (___transType != null) {
            _transType = Common.getHexStringFromBytes(___transType);
        }
        if (xml != null && xml.length() > 0 && (_pan = Common.getXMLValue(xml, "CardNumberMasked")) == null) {
            _pan = "";
        }
        receipt.account = _pan.length() > 6 ? "************" + _pan.substring(_pan.length() - 4, _pan.length()) : _pan;
        receipt.transType = _transType;
        receipt.dateTime = new Date(System.currentTimeMillis());
        if (xml != null && xml.length() > 0) {
            receipt.amount = Common.getXMLValue(xml, "ApprovedAmount");
        }
        String iad91 = "";
        byte[] _iad91 = null;
        if (dict != null && dict.containsKey("91")) {
            _iad91 = (byte[])dict.get("91");
        }
        if (_iad91 != null) {
            iad91 = Common.getHexStringFromBytes(_iad91);
        }
        receipt.aid = _aid;
        if (xml != null && xml.length() > 0) {
            receipt.authCode = Common.getXMLValue(xml, "ApprovalNumber");
            if (receipt.authCode == null) {
                receipt.authCode = "";
            }
            receipt.transID = Common.getXMLValue(xml, "TransactionID");
            if (receipt.authCode == null) {
                receipt.transID = "";
            }
            receipt.card = Common.getXMLValue(xml, "CardLogo");
        }
        String aac = "";
        byte[] _aac = null;
        if (dict.containsKey("9F26")) {
            _aac = (byte[])dict.get("9F26");
        }
        if (_aac != null) {
            aac = Common.getHexStringFromBytes(_aac);
        }
        if (_name == null) {
            _name = "";
        }
        boolean hasSig = false;
        String _CVM = "";
        byte[] ___CVM = null;
        if (dict.containsKey("9F34")) {
            ___CVM = (byte[])dict.get("9F34");
        }
        if (___CVM != null) {
            _CVM = Common.getHexStringFromBytes(___CVM);
        }
        if (!_CVM.isEmpty()) {
            if (_CVM.toUpperCase().startsWith("1E") || _CVM.toUpperCase().startsWith("5E")) {
                hasSig = true;
            } else if (_CVM.toUpperCase().startsWith("1F") || _CVM.toUpperCase().startsWith("5F")) {
                receipt.cvm = CVM_TYPE.CVM_TYPE_NO_CVM;
                hasSig = false;
            }
        }
        if (!hasSig) {
            byte[] ttq = null;
            if (dict.containsKey("9F66")) {
                ttq = (byte[])dict.get("9F66");
            }
            if (ttq != null && ttq.length == 4 && (ttq[1] & 0x40) == 64) {
                hasSig = true;
            }
        }
        byte[] df71 = null;
        if (dict.containsKey("9F71")) {
            df71 = (byte[])dict.get("9F71");
        }
        if (df71 != null && df71.length == 4) {
            hasSig = (df71[0] & 0x40) == 64;
        }
        receipt.name = _name;
        if (!isError && hasSig) {
            receipt.cvm = CVM_TYPE.CVM_TYPE_SIGNATURE;
        }
        if (receipt.isApproved) {
            this.sendMessage("APPROVED");
        } else {
            this.sendMessage("DECLINED");
        }
        return receipt;
    }

    private String processXML(String WPdata, String password) {
        StringBuilder processedXML = new StringBuilder(WPdata);
        for (int i = 0; i < WPdata.length(); ++i) {
            char ch = (char)(WPdata.charAt(i) ^ password.charAt(i % password.length()));
            processedXML.setCharAt(i, ch);
        }
        return processedXML.toString();
    }

    private boolean writeFiles(WorldPayData data, String WPdata) {
        try {
            String path = Environment.getExternalStorageDirectory().toString();
            String fileNameWithPath = path + File.separator + "wp_records.txt";
            File records = new File(fileNameWithPath);
            FileWriter writer = new FileWriter(records, true);
            String timestamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS", Locale.US).format(new Date());
            String temp = "\"timestamp\": \"" + timestamp + "\",\n";
            writer.append(temp);
            timestamp = timestamp.replace("-", "_");
            timestamp = timestamp.replace(" ", "_");
            timestamp = timestamp.replace(":", "_");
            temp = "\"id\": \"" + timestamp + "\",\n";
            writer.append(temp);
            temp = "\"name\": \"" + this.transName + "\",\n";
            writer.append(temp);
            temp = "\"pan\": \"" + this.PAN + "\",\n";
            writer.append(temp);
            temp = "\"amount\": \"" + data.amount + "\",\n";
            writer.append(temp);
            temp = "\"transactionID\": \"" + data.transactionID + "\",\n";
            writer.append(temp);
            temp = "\"paymentAccountID\": \"\",\n";
            writer.append(temp);
            temp = "\"encrypted\": \"" + (data.storagePassword != null && data.storagePassword.length() > 0 ? "true" : "false") + "\",\n";
            writer.append(temp);
            temp = "\"url\": \"" + (data.isTest ? "https://certtransaction.elementexpress.com" : "https://transaction.elementexpress.com") + "\",\n";
            writer.append(temp);
            temp = "\"memo\": \"" + data.storageMemo + "\",\n";
            writer.append(temp);
            writer.flush();
            writer.close();
            fileNameWithPath = path + File.separator + timestamp + ".txt";
            File xmlFile = new File(fileNameWithPath);
            writer = new FileWriter(xmlFile, false);
            temp = data.storagePassword != null && data.storagePassword.length() > 0 ? this.processXML(WPdata, data.storagePassword) : WPdata;
            writer.append(temp);
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private String retrieveXMLRecord(String id, String password, boolean bypassProcessing) {
        try {
            String path = Environment.getExternalStorageDirectory().toString();
            String fileNameWithPath = path + File.separator + "wp_records.txt";
            File file = new File(fileNameWithPath);
            BufferedReader br = new BufferedReader(new FileReader(file));
            String[] st = new String[10];
            int idx = 0;
            boolean found = false;
            boolean encrypted = false;
            this.strId = null;
            String _memo = null;
            this.strUrl = null;
            this.recordIdx = 0;
            while ((st[idx % 10] = br.readLine()) != null && (st[++idx % 10] = br.readLine()) != null) {
                int end;
                if (st[idx % 10].startsWith("\"id\"")) {
                    end = st[idx % 10].indexOf(44) - 1;
                    this.strId = st[idx % 10].substring(7, end);
                }
                if ((st[++idx % 10] = br.readLine()) == null || (st[++idx % 10] = br.readLine()) == null || (st[++idx % 10] = br.readLine()) == null || (st[++idx % 10] = br.readLine()) == null || (st[++idx % 10] = br.readLine()) == null || (st[++idx % 10] = br.readLine()) == null) break;
                if (st[idx % 10].startsWith("\"encrypted\"")) {
                    end = st[idx % 10].indexOf(44) - 1;
                    encrypted = st[idx % 10].substring(14, end).equals("true");
                }
                if ((st[++idx % 10] = br.readLine()) == null) break;
                if (st[idx % 10].startsWith("\"url\"")) {
                    end = st[idx % 10].indexOf(44) - 1;
                    this.strUrl = end == 8 ? "" : st[idx % 10].substring(8, end);
                }
                if ((st[++idx % 10] = br.readLine()) == null) break;
                if (st[idx % 10].startsWith("\"memo\"")) {
                    end = st[idx % 10].indexOf(44) - 1;
                    _memo = end == 9 ? "" : st[idx % 10].substring(9, end);
                }
                ++idx;
                if (this.strId.equals(id) || _memo.equals(id)) {
                    found = true;
                    break;
                }
                ++this.recordIdx;
            }
            br.close();
            if (found) {
                if (bypassProcessing && encrypted && (password == null || password.length() <= 0)) {
                    return null;
                }
                fileNameWithPath = path + File.separator + this.strId + ".txt";
                file = new File(fileNameWithPath);
                Scanner sc = new Scanner(file);
                sc.useDelimiter("\\Z");
                String xmlStr = sc.next();
                sc.close();
                if (encrypted) {
                    if (password == null || password.length() <= 0) {
                        return null;
                    }
                    if (!(xmlStr = this.processXML(xmlStr, password)).contains("<CreditCardSale xmlns=")) {
                        return null;
                    }
                }
                if (bypassProcessing) {
                    file.delete();
                    fileNameWithPath = path + File.separator + "wp_records.txt";
                    file = new File(fileNameWithPath);
                    br = new BufferedReader(new FileReader(file));
                    fileNameWithPath = path + File.separator + "wp_records_new.txt";
                    File records = new File(fileNameWithPath);
                    FileWriter writer = new FileWriter(records, false);
                    idx = 0;
                    while ((st[0] = br.readLine()) != null) {
                        if (idx != this.recordIdx) {
                            writer.append(st[0] + "\n");
                        }
                        if ((st[0] = br.readLine()) == null) break;
                        if (idx != this.recordIdx) {
                            writer.append(st[0] + "\n");
                        }
                        if ((st[0] = br.readLine()) == null) break;
                        if (idx != this.recordIdx) {
                            writer.append(st[0] + "\n");
                        }
                        if ((st[0] = br.readLine()) == null) break;
                        if (idx != this.recordIdx) {
                            writer.append(st[0] + "\n");
                        }
                        if ((st[0] = br.readLine()) == null) break;
                        if (idx != this.recordIdx) {
                            writer.append(st[0] + "\n");
                        }
                        if ((st[0] = br.readLine()) == null) break;
                        if (idx != this.recordIdx) {
                            writer.append(st[0] + "\n");
                        }
                        if ((st[0] = br.readLine()) == null) break;
                        if (idx != this.recordIdx) {
                            writer.append(st[0] + "\n");
                        }
                        if ((st[0] = br.readLine()) == null) break;
                        if (idx != this.recordIdx) {
                            writer.append(st[0] + "\n");
                        }
                        if ((st[0] = br.readLine()) == null) break;
                        if (idx != this.recordIdx) {
                            writer.append(st[0] + "\n");
                        }
                        if ((st[0] = br.readLine()) == null) break;
                        if (idx != this.recordIdx) {
                            writer.append(st[0] + "\n");
                        }
                        ++idx;
                    }
                    br.close();
                    writer.flush();
                    writer.close();
                    records.renameTo(file);
                    return null;
                }
                return xmlStr;
            }
            this.recordIdx = -1;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return null;
    }

    private boolean storeXMLRecord(WorldPayData data, String WPdata) {
        if (WPdata == null || WPdata.length() <= 0) {
            return false;
        }
        if (data.storeTransaction) {
            return this.writeFiles(data, WPdata);
        }
        if (data.storeOnHostNetworkError) {
            try {
                String strURL = data.isTest ? "https://certtransaction.elementexpress.com" : "https://transaction.elementexpress.com";
                URL url = new URL(strURL);
                HttpURLConnection urlc = (HttpURLConnection)url.openConnection();
                urlc.setRequestProperty("User-Agent", "IDTech Android SDK");
                urlc.setRequestProperty("Connection", "close");
                urlc.setConnectTimeout(10000);
                urlc.connect();
                if (urlc.getResponseCode() != 200) {
                    return this.writeFiles(data, WPdata);
                }
            }
            catch (MalformedURLException e1) {
                e1.printStackTrace();
                return false;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        return false;
    }

    public int executeTransaction(IDT_Device idt_device, WorldPayData data, WorldpayListener callback, boolean requestOnly) {
        if (inTransaction) {
            return 29696;
        }
        inTransaction = true;
        if (data == null || callback == null) {
            inTransaction = false;
            return 4;
        }
        this._data = data;
        this.currentTransactionData = null;
        hasVAS = false;
        this.isCTLS = false;
        if (!data.isTest && this.hasLicense == -1) {
            String lurl = "https://dev-paynow.itscocloud.com/License?Mode=Validate&License=" + data.license + "&AccountToken=" + data.accountToken;
            this.hasLicense = this.checkLicense(lurl, 20000);
        }
        if (!data.isTest && this.hasLicense == 0) {
            inTransaction = false;
            return 61082;
        }
        if (data.transactionType == TRANSACTION_TYPE.TRANSACTION_TYPE_QUICK_CHIP_FINISH) {
            if (qcData == null) {
                inTransaction = false;
                return 4;
            }
            data.cardData = WorldPay.qcData.cardData;
            data.emvData = WorldPay.qcData.emvData;
            data.emvDataKSN = WorldPay.qcData.emvDataKSN;
            data.emvDataTrack1 = WorldPay.qcData.emvDataTrack1;
            data.emvDataTrack2 = WorldPay.qcData.emvDataTrack2;
        }
        if (data.transactionType == TRANSACTION_TYPE.TRANSACTION_TYPE_COMPLETION || data.transactionType == TRANSACTION_TYPE.TRANSACTION_TYPE_VOID || data.transactionType == TRANSACTION_TYPE.TRANSACTION_TYPE_REVERSAL_FULL || data.transactionType == TRANSACTION_TYPE.TRANSACTION_TYPE_REVERSAL_PARTIAL || data.transactionType == TRANSACTION_TYPE.TRANSACTION_TYPE_RETURN || data.transactionType == TRANSACTION_TYPE.TRANSACTION_TYPE_QUICK_CHIP_FINISH) {
            double authAmount = 0.0;
            double completeAmount = 0.0;
            double difference = 0.0;
            try {
                authAmount = Double.parseDouble(data.authAmount);
                completeAmount = Double.parseDouble(data.amount);
                difference = authAmount - completeAmount;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (data.transactionType == TRANSACTION_TYPE.TRANSACTION_TYPE_COMPLETION && authAmount > 0.0 && !requestOnly) {
                String pass;
                String tokRequest;
                String tok;
                String origAmt = data.amount;
                if (difference > 0.0) {
                    data.transactionType = TRANSACTION_TYPE.TRANSACTION_TYPE_REVERSAL_PARTIAL;
                    data.amount = new DecimalFormat("#.00").format(difference);
                    String comp = this.worldPayCompletionXML(data);
                    String compResponse = this.postToWorldPay(data.isTest, comp, 20000, false);
                    if (compResponse != null && compResponse.contains("<ExpressResponseCode>0</ExpressResponseCode>")) {
                        data.authReversal = data.amount;
                    }
                    data.transactionType = TRANSACTION_TYPE.TRANSACTION_TYPE_COMPLETION;
                    data.amount = origAmt;
                } else if (difference < 0.0 && (tok = this.postToWorldPay(data.isTest, tokRequest = this.worldPayToken(data, true), 20000, true)) != null && tok.contains("<ExpressResponseCode>0</ExpressResponseCode>") && tok.contains("<PaymentAccountID>") && (pass = Common.getXMLValue(tok, "PaymentAccountID")) != null) {
                    data.paymentAccountID = pass;
                    data.transactionType = TRANSACTION_TYPE.TRANSACTION_TYPE_SALE;
                    data.declinePartial = false;
                    String tokenSale = this.worldPayXML(data);
                    String tokenSaleResponse = "";
                    tokenSaleResponse = this.postToWorldPay(data.isTest, tokenSale, 20000, false);
                    if (!tokenSaleResponse.contains("ERROR:")) {
                        if (this.returnRequest) {
                            tokenSaleResponse = this.PrettyXml(tokenSale) + "\r\n\r\n" + tokenSaleResponse;
                        }
                        data.tokenSubstitute = data.amount;
                        this.currentData = data;
                        boolean reversal = false;
                        tokRequest = this.worldPayToken(data, false);
                        tok = this.postToWorldPay(data.isTest, tokRequest, 20000, true);
                        if (tok != null && tok.contains("<ExpressResponseCode>0</ExpressResponseCode>")) {
                            data.transactionType = TRANSACTION_TYPE.TRANSACTION_TYPE_REVERSAL_FULL;
                            data.amount = data.authAmount;
                            String comp = this.worldPayCompletionXML(data);
                            String compResponse = this.postToWorldPay(data.isTest, comp, 20000, false);
                            data.authReversal = data.amount;
                            this.currentData.authReversal = data.amount;
                            data.amount = origAmt;
                            this.currentData.amount = origAmt;
                            data.transactionType = TRANSACTION_TYPE.TRANSACTION_TYPE_SALE;
                            this.currentData.transactionType = TRANSACTION_TYPE.TRANSACTION_TYPE_SALE;
                            reversal = true;
                        }
                        this.currentData = data;
                        ReceiptData receipt = this.ReceiptCTLS(qcCard, tokenSaleResponse);
                        receipt.entryMethod = null;
                        if (reversal) {
                            receipt.authReversal = null;
                        }
                        inTransaction = false;
                        callback.WorldPayCallback(tokenSaleResponse, 0, 0);
                        callback.WPCallback(tokenSaleResponse, 0, 0, null, receipt);
                        this.currentData = null;
                        return 0;
                    }
                    data.transactionType = TRANSACTION_TYPE.TRANSACTION_TYPE_COMPLETION;
                }
            }
            String WPdata = "";
            WPdata = data.transactionType == TRANSACTION_TYPE.TRANSACTION_TYPE_QUICK_CHIP_FINISH ? this.worldPayXML(data) : this.worldPayCompletionXML(data);
            if (this.storeXMLRecord(data, WPdata)) {
                this.endTransaction("Transaction Record Stored", 0, 0, null);
                return 0;
            }
            if (requestOnly) {
                inTransaction = false;
                callback.WorldPayCallback(WPdata, 0, 0);
                callback.WPCallback(WPdata, 0, 0, null, null);
                return 0;
            }
            String response = this.postToWorldPay(data.isTest, WPdata, 20000, false);
            UMLog.i("WorldPay", "response: " + response);
            if (this.returnRequest) {
                response = this.PrettyXml(WPdata) + "\r\n\r\n" + response;
            }
            WPdata = WPdata + response;
            this.currentData = data;
            ReceiptData receipt = this.ReceiptCTLS(qcCard, WPdata);
            if (data.transactionType == TRANSACTION_TYPE.TRANSACTION_TYPE_VOID || data.transactionType == TRANSACTION_TYPE.TRANSACTION_TYPE_REVERSAL_FULL) {
                receipt.amount = null;
            }
            inTransaction = false;
            callback.WorldPayCallback(response, 0, 0);
            callback.WPCallback(response, 0, 0, null, receipt);
            this.currentData = null;
            return 0;
        }
        qcData = null;
        qcCard = null;
        if (idt_device == null) {
            inTransaction = false;
            return 4;
        }
        this.device = idt_device;
        ReaderInfo.DEVICE_TYPE mytype = this.device.device_getDeviceType();
        if (mytype == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT || mytype == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB) {
            this.isNEO = true;
        }
        this._requestOnly = requestOnly;
        this.firstACData = null;
        this.msrData = null;
        this.myCallback = callback;
        this.originalCallback = this.device.m_recListener;
        this.currentData = data;
        this.device.m_recListener = this;
        IDT_Device.emv_setAutoAuthenticateTransaction(false);
        IDT_Device.emv_setAutoCompleteTransaction(false);
        this.goOnline = false;
        this.isEMV = false;
        int rt = 0;
        double amount = 0.0;
        try {
            amount = Double.valueOf(data.amount);
        }
        catch (Exception e) {
            inTransaction = false;
            return 27392;
        }
        IDT_Device.maxLoopNum = 2;
        UMLog.i("executeTransaction", "isNEO: " + this.isNEO);
        if (this.isNEO) {
            byte[] tags = null;
            tags = data.msrOnly ? (data.additionalTags.length() > 0 ? (data.additionalTags.contains("DFEF3701") && data.additionalTags.contains("DFED4601") ? Common.getByteArray(data.additionalTags) : (data.additionalTags.contains("DFEF3701") && !data.additionalTags.contains("DFED4601") ? Common.getByteArray(data.additionalTags + "DFED460101") : (!data.additionalTags.contains("DFEF3701") && data.additionalTags.contains("DFED4601") ? Common.getByteArray(data.additionalTags + "DFEF370101") : Common.getByteArray(data.additionalTags + "DFEF370101DFED460101")))) : Common.getByteArray("DFEF370101DFED460101")) : (data.enableCTLS ? (data.additionalTags.length() > 0 ? (data.additionalTags.contains("DFEF3701") && data.additionalTags.contains("DFED4601") ? Common.getByteArray(data.additionalTags) : (data.additionalTags.contains("DFEF3701") && !data.additionalTags.contains("DFED4601") ? Common.getByteArray(data.additionalTags + "DFED460101") : (!data.additionalTags.contains("DFEF3701") && data.additionalTags.contains("DFED4601") ? Common.getByteArray(data.additionalTags + "DFEF370107") : Common.getByteArray(data.additionalTags + "DFEF370107DFED460101")))) : Common.getByteArray("DFEF370107DFED460101")) : (data.additionalTags.length() > 0 ? (data.additionalTags.contains("DFEF3701") && data.additionalTags.contains("DFED4601") ? Common.getByteArray(data.additionalTags) : (data.additionalTags.contains("DFEF3701") && !data.additionalTags.contains("DFED4601") ? Common.getByteArray(data.additionalTags + "DFED460101") : (!data.additionalTags.contains("DFEF3701") && data.additionalTags.contains("DFED4601") ? Common.getByteArray(data.additionalTags + "DFEF370107") : Common.getByteArray(data.additionalTags + "DFEF370105DFED460101")))) : Common.getByteArray("DFEF370105DFED460101")));
            this.transactionType = 3;
            UMLog.i("executeTransaction", "device_startTransaction transactionType: " + this.transactionType);
            rt = this.device.device_startTransaction(amount, 0.0, 0, data.timeout, tags);
        } else {
            ResDataStruct respData = new ResDataStruct();
            rt = this.device.emv_retrieveTerminalData(respData);
            boolean noEMV = false;
            UMLog.i("executeTransaction", "executeTransaction rt: " + rt);
            if (rt == 60940) {
                noEMV = true;
            }
            UMLog.i("executeTransaction", "ctlsOnly: " + noEMV);
            if (noEMV) {
                this.transactionType = 1;
                UMLog.i("executeTransaction", "ctls_startTransaction transactionType: " + this.transactionType);
                rt = this.device.ctls_startTransaction(amount, 0.0, 0, data.timeout, data.additionalTags.length() > 0 ? Common.getByteArray(data.additionalTags) : null);
            } else if (data.msrOnly) {
                this.transactionType = 0;
                UMLog.i("executeTransaction", "msr_startMSRSwipe transactionType: " + this.transactionType);
                rt = this.device.msr_startMSRSwipe();
            } else if (data.enableCTLS) {
                this.transactionType = 3;
                UMLog.i("executeTransaction", "device_startTransaction transactionType: " + this.transactionType);
                rt = this.device.device_startTransaction(amount, 0.0, 0, data.timeout, data.additionalTags.length() > 0 ? Common.getByteArray(data.additionalTags) : null);
            } else {
                this.transactionType = 2;
                UMLog.i("executeTransaction", "emv_startTransaction transactionType: " + this.transactionType);
                rt = this.device.emv_startTransaction(amount, 0.0, 0, data.timeout, data.additionalTags.length() > 0 ? Common.getByteArray(data.additionalTags) : null, false);
            }
        }
        if (rt == 61027) {
            rt = 0;
        }
        UMLog.i("executeTransaction", "rt = " + rt + " transactionType " + this.transactionType);
        if (rt != 0) {
            UMLog.i("executeTransaction", "Reset callbacks 1");
            inTransaction = false;
            this.currentData = null;
            if (this.originalCallback != null) {
                this.device.m_recListener = this.originalCallback;
            }
            this.originalCallback = null;
            this.myCallback = null;
        } else {
            UMLog.i("executeTransaction", "Before PRESENT CARD");
            this.sendMessage("PRESENT CARD");
        }
        return rt;
    }

    public int forwardTransaction(WorldpayListener callback, String forwardID, String password, boolean bypassProcessing) {
        if (inTransaction) {
            return 29696;
        }
        inTransaction = true;
        this.myCallback = callback;
        String xml = this.retrieveXMLRecord(forwardID, password, bypassProcessing);
        if (xml == null) {
            inTransaction = false;
            if (bypassProcessing) {
                this.myCallback.WorldPayCallback(this.strId + " was removed\n", 0, 0);
                this.myCallback.WPCallback(this.strId + " was removed\n", 0, 0, null, null);
                return 0;
            }
            return 10;
        }
        boolean isTest = false;
        if (this.strUrl.equals("https://certtransaction.elementexpress.com")) {
            isTest = true;
        }
        String response = this.postToWorldPay(isTest, xml, 20000, false);
        UMLog.i("WorldPay", "response: " + response);
        if (this.returnRequest) {
            response = this.PrettyXml(xml) + "\r\n\r\n" + response;
        }
        try {
            String path = Environment.getExternalStorageDirectory().toString();
            String fileNameWithPath = path + File.separator + this.strId + ".txt";
            File file = new File(fileNameWithPath);
            file.delete();
            fileNameWithPath = path + File.separator + "wp_records.txt";
            file = new File(fileNameWithPath);
            BufferedReader br = new BufferedReader(new FileReader(file));
            fileNameWithPath = path + File.separator + "wp_records_new.txt";
            File records = new File(fileNameWithPath);
            FileWriter writer = new FileWriter(records, false);
            int idx = 0;
            String temp = null;
            while ((temp = br.readLine()) != null) {
                if (idx != this.recordIdx) {
                    writer.append(temp + "\n");
                }
                if ((temp = br.readLine()) == null) break;
                if (idx != this.recordIdx) {
                    writer.append(temp + "\n");
                }
                if ((temp = br.readLine()) == null) break;
                if (idx != this.recordIdx) {
                    writer.append(temp + "\n");
                }
                if ((temp = br.readLine()) == null) break;
                if (idx != this.recordIdx) {
                    writer.append(temp + "\n");
                }
                if ((temp = br.readLine()) == null) break;
                if (idx != this.recordIdx) {
                    writer.append(temp + "\n");
                }
                if ((temp = br.readLine()) == null) break;
                if (idx != this.recordIdx) {
                    writer.append(temp + "\n");
                }
                if ((temp = br.readLine()) == null) break;
                if (idx != this.recordIdx) {
                    writer.append(temp + "\n");
                }
                if ((temp = br.readLine()) == null) break;
                if (idx != this.recordIdx) {
                    writer.append(temp + "\n");
                }
                if ((temp = br.readLine()) == null) break;
                if (idx != this.recordIdx) {
                    writer.append(temp + "\n");
                }
                if ((temp = br.readLine()) == null) break;
                if (idx != this.recordIdx) {
                    writer.append(temp + "\n");
                }
                ++idx;
            }
            br.close();
            writer.flush();
            writer.close();
            records.renameTo(file);
        }
        catch (IOException e) {
            e.printStackTrace();
            inTransaction = false;
            return 10;
        }
        inTransaction = false;
        this.myCallback.WorldPayCallback(response, 0, 0);
        this.myCallback.WPCallback(response, 0, 0, null, null);
        return 0;
    }

    public int cancelTransaction_org() {
        if (this.device == null) {
            return 10;
        }
        UMLog.i("cancelTransaction", "Reset callbacks");
        this.device.m_recListener = this.originalCallback;
        this.originalCallback = null;
        this.myCallback = null;
        int rt = 0;
        if (this.transactionType == 0) {
            UMLog.i("executeTransaction", "msr_cancelMSRSwipe transactionType: " + this.transactionType);
            rt = this.device.msr_cancelMSRSwipe();
        } else if (this.transactionType == 1) {
            UMLog.i("executeTransaction", "ctls_cancelTransaction transactionType: " + this.transactionType);
            rt = this.device.ctls_cancelTransaction();
        } else if (this.transactionType == 2) {
            ResDataStruct respData = new ResDataStruct();
            UMLog.i("executeTransaction", "emv_cancelTransaction transactionType: " + this.transactionType);
            rt = this.device.emv_cancelTransaction(respData);
        } else {
            UMLog.i("executeTransaction", "device_cancelTransaction transactionType: " + this.transactionType);
            rt = this.device.device_cancelTransaction();
        }
        this.currentData = null;
        if (rt == 0) {
            inTransaction = false;
        }
        return rt;
    }

    public int cancelTransaction() {
        if (this.device == null || !inTransaction) {
            return 10;
        }
        if (this.originalCallback != null) {
            this.device.m_recListener = this.originalCallback;
            this.originalCallback = null;
        }
        this.myCallback = null;
        int rt = 0;
        if (this.transactionType == 0) {
            UMLog.i("executeTransaction", "msr_cancelMSRSwipe transactionType: " + this.transactionType);
            rt = this.device.msr_cancelMSRSwipe();
        } else if (this.transactionType == 1) {
            UMLog.i("executeTransaction", "ctls_cancelTransaction transactionType: " + this.transactionType);
            rt = this.device.ctls_cancelTransaction();
        } else if (this.transactionType == 2) {
            ResDataStruct respData = new ResDataStruct();
            UMLog.i("executeTransaction", "emv_cancelTransaction transactionType: " + this.transactionType);
            rt = this.device.emv_cancelTransaction(respData);
        } else {
            UMLog.i("executeTransaction", "device_cancelTransaction transactionType: " + this.transactionType);
            rt = this.device.device_cancelTransaction();
        }
        if (rt == 0) {
            UMLog.i("executeTransaction", "Reset callbacks 1");
            inTransaction = false;
            this.currentData = null;
            if (this.originalCallback != null) {
                this.device.m_recListener = this.originalCallback;
            }
            this.originalCallback = null;
        }
        return rt;
    }

    private void endTransaction(String reason, int return_code, int emvCode, IDTEMVData emvData) {
        if (return_code == 61096 || return_code == 3159) {
            if (this.myCallback != null) {
                UMLog.i("endTransaction", "Reset callbacks 1");
                inTransaction = false;
                this.myCallback.WorldPayCallback(reason, return_code, emvCode);
                this.myCallback.WPCallback(reason, return_code, emvCode, emvData, null);
                this.device.m_recListener = this.originalCallback;
                this.originalCallback = null;
                this.myCallback = null;
                this.currentData = null;
                this.currentTransactionData = null;
                this.firstACData = null;
            }
            return;
        }
        boolean reqOnly = this._requestOnly;
        if (this.currentData != null && this.currentData.transactionType == TRANSACTION_TYPE.TRANSACTION_TYPE_QUICK_CHIP_START) {
            reason = "QUICKCHIP DATA CAPTURED";
            qcData = this.currentData;
            qcCard = emvData;
            reqOnly = true;
        }
        if (reason.equals("Transaction Record Stored")) {
            reqOnly = true;
        }
        inTransaction = false;
        if (this.myCallback != null) {
            UMLog.i("endTransaction", "Reset callbacks 2");
            ReceiptData receipt = null;
            if (!reqOnly && return_code != 3159) {
                receipt = this.ReceiptCTLS(emvData, reason);
            }
            this.myCallback.WorldPayCallback(reason, return_code, emvCode);
            this.myCallback.WPCallback(reason, return_code, emvCode, emvData, receipt);
            this.device.m_recListener = this.originalCallback;
            this.originalCallback = null;
            this.myCallback = null;
            this.currentData = null;
            this.currentTransactionData = null;
            this.firstACData = null;
        }
    }

    private String PrettyXml(String xml) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setValidating(false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource inputSource = new InputSource(new StringReader(xml));
            Document doc = db.parse(inputSource);
            Transformer tf = TransformerFactory.newInstance().newTransformer();
            tf.setOutputProperty("encoding", "UTF-8");
            tf.setOutputProperty("indent", "yes");
            StringWriter out = new StringWriter();
            tf.transform(new DOMSource(doc), new StreamResult(out));
            return ((Object)out).toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    private String applicationID() {
        if (this.isCTLS) {
            return "11655";
        }
        return "11654";
    }

    public String worldPayXML(WorldPayData data) {
        int verIdx;
        Random random;
        boolean isHosted = false;
        if (data == null) {
            return "";
        }
        if (data.ticketNumber == null) {
            data.ticketNumber = "";
        }
        if (data.referenceNumber == null) {
            data.referenceNumber = "";
        }
        if (data.cardData == null) {
            data.cardData = "";
        }
        if (data.emvData == null) {
            data.emvData = "";
        }
        if (data.terminalID == null) {
            data.terminalID = "";
        }
        if (data.amount == null) {
            data.amount = "";
        }
        if (data.accountID == null) {
            data.accountID = "";
        }
        if (data.accountToken == null) {
            data.accountToken = "";
        }
        if (data.acceptorID == null) {
            data.acceptorID = "";
        }
        StringBuilder sb = new StringBuilder();
        if (data.transactionType == TRANSACTION_TYPE.TRANSACTION_TYPE_SALE || data.transactionType == TRANSACTION_TYPE.TRANSACTION_TYPE_QUICK_CHIP_FINISH || data.transactionType == TRANSACTION_TYPE.TRANSACTION_TYPE_QUICK_CHIP_START) {
            sb.append("<CreditCardSale xmlns=\"https://transaction.elementexpress.com\">\r\n");
        } else {
            sb.append("<CreditCardAuthorization xmlns=\"https://transaction.elementexpress.com\">\r\n");
        }
        sb.append("    <Credentials>\r\n");
        sb.append("        <AccountID>");
        sb.append(data.accountID);
        sb.append("</AccountID>\r\n");
        sb.append("        <AccountToken>");
        sb.append(data.accountToken);
        sb.append("</AccountToken>\r\n");
        sb.append("        <AcceptorID>");
        sb.append(data.acceptorID);
        sb.append("</AcceptorID>\r\n");
        sb.append("    </Credentials>\r\n");
        sb.append("    <Application>\r\n");
        sb.append("        <ApplicationID>");
        sb.append(this.applicationID());
        sb.append("</ApplicationID>\r\n");
        if (this.isCTLS) {
            sb.append("        <ApplicationName>ID Tech CTLS Certification</ApplicationName>\r\n");
        } else {
            sb.append("        <ApplicationName>ID Tech Common L2</ApplicationName>\r\n");
        }
        sb.append("        <ApplicationVersion>1.00</ApplicationVersion>\r\n");
        sb.append("     </Application>\r\n");
        if (data.paymentAccountID != null && data.paymentAccountID.length() > 0) {
            isHosted = true;
            sb.append("    <PaymentAccount>\r\n");
            sb.append("        <PaymentAccountID>" + data.paymentAccountID + "</PaymentAccountID>\r\n");
            sb.append("        <PaymentAccountType>0</PaymentAccountType>\r\n");
            if (data.paymentAccountReferenceNumber != null && data.paymentAccountReferenceNumber.length() > 0) {
                sb.append("        <PaymentAccountReferenceNumber>" + data.paymentAccountReferenceNumber + "</PaymentAccountReferenceNumber>");
            }
            sb.append("    </PaymentAccount>\r\n");
        } else {
            sb.append("    <Card>\r\n");
            isHosted = false;
            if (data.emvDataTrack1 != null && data.emvDataTrack1.length() > 0) {
                sb.append("        <EncryptedTrack2Data>");
                sb.append(data.emvDataTrack1);
                sb.append("</EncryptedTrack2Data>\r\n");
                sb.append("        <CardDataKeySerialNumber>");
                sb.append(data.emvDataKSN);
                sb.append("</CardDataKeySerialNumber>\r\n");
                sb.append("        <EncryptedFormat>0</EncryptedFormat>\r\n");
            } else if (data.emvData != null && data.emvData.length() > 0) {
                sb.append("        <EMVData>");
                sb.append(data.emvData);
                sb.append("</EMVData>\r\n");
                sb.append("        <EMVDataKeySerialNumber>");
                sb.append(data.emvDataKSN);
                sb.append("</EMVDataKeySerialNumber>\r\n");
                sb.append("        <EncryptedEMVFormat>1</EncryptedEMVFormat>\r\n");
                sb.append("        <EncryptedEMVData>");
                sb.append(data.emvDataTrack2);
                sb.append("</EncryptedEMVData>\r\n");
            } else if (data.cardData != null && data.cardData.length() > 0) {
                sb.append("        <MagneprintData>");
                sb.append(data.cardData);
                sb.append("</MagneprintData>\r\n");
                sb.append("        <EncryptedFormat>4</EncryptedFormat>\r\n");
            }
            sb.append("    </Card>\r\n");
        }
        sb.append("    <Transaction>\r\n");
        sb.append("        <TransactionAmount>");
        sb.append(data.amount);
        sb.append("</TransactionAmount>\r\n");
        sb.append("        <ReferenceNumber>");
        if (data.referenceNumber == null || data.referenceNumber.length() == 0) {
            random = new Random();
            data.referenceNumber = String.valueOf(random.nextInt(99999999)) + String.valueOf(random.nextInt(99999999));
        }
        sb.append(data.referenceNumber);
        sb.append("</ReferenceNumber>\r\n");
        sb.append("        <TicketNumber>");
        if (data.ticketNumber == null || data.ticketNumber.length() == 0) {
            random = new Random();
            data.ticketNumber = String.valueOf(random.nextInt(999999));
        }
        sb.append(data.ticketNumber);
        sb.append("</TicketNumber>\r\n");
        if (isHosted) {
            data.marketCode = MARKET_CODE.MARKET_CODE_ECOMMERCE;
        }
        sb.append("        <MarketCode>");
        sb.append(data.marketCode.ordinal());
        sb.append("</MarketCode>\r\n");
        if (data.declinePartial) {
            sb.append("        <PartialApprovedFlag>0</PartialApprovedFlag>\r\n");
        } else {
            sb.append("        <PartialApprovedFlag>1</PartialApprovedFlag>\r\n");
        }
        if (data.duplicateCheckDisable || isHosted) {
            sb.append("        <DuplicateCheckDisableFlag>1</DuplicateCheckDisableFlag>\r\n");
        }
        if (data.duplicateOverride || isHosted) {
            sb.append("        <DuplicateOverrideFlag>1</DuplicateOverrideFlag>\r\n");
        }
        sb.append("        <PaymentType>0</PaymentType>\r\n");
        if (isHosted) {
            sb.append("        <SubmissionType>2</SubmissionType>\r\n");
        } else {
            sb.append("        <SubmissionType>0</SubmissionType>\r\n");
        }
        sb.append("        <NetworkTransactionID></NetworkTransactionID>\r\n");
        sb.append("    </Transaction>\r\n");
        sb.append("    <Terminal>\r\n");
        sb.append("        <TerminalID>");
        if (data.terminalID == null || data.terminalID.length() == 0) {
            data.terminalID = "0001";
        }
        sb.append(data.terminalID);
        sb.append("</TerminalID>\r\n");
        if (isHosted) {
            data.terminalType = TERMINAL_TYPE.TERMINAL_TYPE_ECOMMERCE;
        }
        sb.append("        <TerminalType>");
        sb.append(data.terminalType.ordinal());
        sb.append("</TerminalType>\r\n");
        if (isHosted) {
            data.terminalCapabilityCode = TERMINAL_CAPABILITY_CODE.TERMINAL_CAPABILITY_CODE_KEY_ENTERED;
        }
        sb.append("        <TerminalCapabilityCode>");
        sb.append(data.terminalCapabilityCode.ordinal());
        sb.append("</TerminalCapabilityCode>\r\n");
        sb.append("        <TerminalEnvironmentCode>");
        if (isHosted) {
            sb.append(TERMINAL_ENVIRONMENT_CODE_TYPE.TERMINAL_ENVIRONMENT_CODE_ECOMMERCE.ordinal());
        } else if (this.isCTLS) {
            sb.append(TERMINAL_ENVIRONMENT_CODE_TYPE.TERMINAL_ENVIRONMENT_CODE_LOCAL_ATTENDED.ordinal());
        } else {
            sb.append(data.terminalEnvironmentCode.ordinal());
        }
        sb.append("</TerminalEnvironmentCode>\r\n");
        sb.append("        <CardPresentCode>");
        sb.append(data.cardPresentCode.ordinal());
        sb.append("</CardPresentCode>\r\n");
        sb.append("        <CVVPresenceCode>0</CVVPresenceCode>\r\n");
        sb.append("        <CardInputCode>");
        if (isHosted) {
            sb.append(CARD_INPUT_CODE.CARD_INPUT_CODE_MANUAL_KEYED.ordinal());
        } else if (data.emvDataTrack1 != null && data.emvDataTrack1.length() > 0) {
            sb.append(CARD_INPUT_CODE.CARD_INPUT_CODE_CONTACTLESS_MAGSTRIPE_READ.ordinal());
        } else if (this.isCTLS) {
            sb.append(CARD_INPUT_CODE.CARD_INPUT_CODE_CONTACTLESS_CHIP_READ.ordinal());
        } else {
            sb.append(data.cardInputCode.ordinal());
        }
        sb.append("</CardInputCode>\r\n");
        if (isHosted) {
            data.cardHolderPresent = CARD_HOLDER_PRESENT_CODE.CARD_HOLDER_PRESENT_CODE_ECOMMERCE;
        }
        sb.append("        <CardholderPresentCode>");
        sb.append(data.cardHolderPresent.ordinal());
        sb.append("</CardholderPresentCode>\r\n");
        if (isHosted) {
            sb.append("        <MotoECICode>7</MotoECICode>\r\n");
        } else {
            sb.append("        <MotoECICode>1</MotoECICode>\r\n");
        }
        StringBuilder sb2 = new StringBuilder();
        int ret = this.device.emv_getEMVKernelVersion(sb2);
        UMLog.i("worldPayXML", "sb2 = " + sb2.toString());
        String kernelVer = "";
        if (ret == 0) {
            kernelVer = sb2.toString();
        }
        UMLog.i("worldPayXML", "kernelVer1 = " + kernelVer);
        if (kernelVer == null) {
            kernelVer = "";
        }
        if (kernelVer.length() > 0 && (verIdx = kernelVer.indexOf(46)) > 0) {
            kernelVer = "V" + kernelVer.substring(verIdx - 1);
        }
        UMLog.i("worldPayXML", "kernelVer2 = " + kernelVer);
        sb.append("        <TerminalEMVKernelVersion>");
        sb.append(kernelVer);
        sb.append("</TerminalEMVKernelVersion>\r\n");
        sb.append("        <TerminalModel>VP3300</TerminalModel>\r\n");
        sb.append("        <TerminalPinCapability>2</TerminalPinCapability>\r\n");
        sb.append("    </Terminal>\r\n");
        sb.append("    <ExtendedParameters></ExtendedParameters>\r\n");
        if (data.transactionType == TRANSACTION_TYPE.TRANSACTION_TYPE_SALE || data.transactionType == TRANSACTION_TYPE.TRANSACTION_TYPE_QUICK_CHIP_FINISH || data.transactionType == TRANSACTION_TYPE.TRANSACTION_TYPE_QUICK_CHIP_START) {
            sb.append("</CreditCardSale>\r\n");
        } else {
            sb.append("</CreditCardAuthorization>\r\n");
        }
        return sb.toString();
    }

    public String postToWorldPay(boolean isTest, String xmlPacket, int timeout, boolean isPASS) {
        String url = "https://transaction.elementexpress.com";
        if (isPASS) {
            url = "https://services.elementexpress.com";
        }
        if (isTest) {
            url = "https://certtransaction.elementexpress.com";
            if (isPASS) {
                url = "https://certservices.elementexpress.com";
            }
        }
        String result = this.postXMLData(url, xmlPacket, timeout);
        return this.PrettyXml(result);
    }

    private String postXMLData(String wpurl, String request, int timeout) {
        UMLog.i("postXMLData", "url: " + wpurl);
        UMLog.i("postXMLData", "request: " + request);
        try {
            UMLog.i("postXMLData", "Open HttpURLConnection");
            URL url = new URL(wpurl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            UMLog.i("postXMLData", "Set Timeout");
            connection.setConnectTimeout(timeout);
            connection.setReadTimeout(timeout);
            UMLog.i("postXMLData", "setDoOutput and Post");
            connection.setDoOutput(true);
            connection.setUseCaches(true);
            connection.setRequestMethod("POST");
            UMLog.i("postXMLData", "setRequestProperty");
            connection.setRequestProperty("Accept", "text/xml");
            connection.setRequestProperty("Content-Type", "text/xml");
            UMLog.i("postXMLData", "getOutputStream");
            OutputStream outputStream = connection.getOutputStream();
            UMLog.i("postXMLData", "getBytes and write");
            byte[] b = request.getBytes("UTF-8");
            outputStream.write(b);
            outputStream.flush();
            outputStream.close();
            UMLog.i("postXMLData", "getInputStream and read");
            InputStream inputStream = connection.getInputStream();
            byte[] res = new byte[2048];
            int i = 0;
            StringBuilder response = new StringBuilder();
            while ((i = inputStream.read(res)) != -1) {
                response.append(new String(res, 0, i));
            }
            inputStream.close();
            UMLog.i("postXMLData", "response: " + response.toString());
            return response.toString();
        }
        catch (Exception e) {
            UMLog.i("postXMLData exception", "response: null");
            UMLog.i("Exception Info", e.getMessage());
            UMLog.i("Exception Info", e.toString());
            return "";
        }
    }

    private int checkLicense(String lurl, int timeout) {
        int gotLicense = -1;
        if (lurl.length() <= 0) {
            return gotLicense;
        }
        try {
            URL url = new URL(lurl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(timeout);
            connection.setReadTimeout(timeout);
            connection.setDoOutput(true);
            connection.setUseCaches(true);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Accept", "text/xml");
            connection.setRequestProperty("Content-Type", "text/xml");
            InputStream inputStream = connection.getInputStream();
            byte[] res = new byte[2048];
            int i = 0;
            StringBuilder response = new StringBuilder();
            while ((i = inputStream.read(res)) != -1) {
                response.append(new String(res, 0, i));
            }
            inputStream.close();
            UMLog.i("checkLicense", "response: " + response.toString());
            if (response.toString().length() > 0) {
                gotLicense = response.toString().contains("RETURN_CODE_DO_SUCCESS") ? 1 : 0;
            }
            return gotLicense;
        }
        catch (Exception e) {
            return gotLicense;
        }
    }

    public static String now() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(cal.getTime());
    }

    public String worldPayToken(WorldPayData data, boolean create) {
        if (data == null || data.transactionID == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        String transType = "PaymentAccountCreateWithTransID";
        if (!create) {
            transType = "PaymentAccountDelete";
        }
        sb.append("<");
        sb.append(transType);
        sb.append(" xmlns=\"https://services.elementexpress.com\">");
        sb.append("    <Credentials>\r\n");
        sb.append("        <AccountID>");
        sb.append(data.accountID);
        sb.append("</AccountID>\r\n");
        sb.append("        <AccountToken>");
        sb.append(data.accountToken);
        sb.append("</AccountToken>\r\n");
        sb.append("        <AcceptorID>");
        sb.append(data.acceptorID);
        sb.append("</AcceptorID>\r\n");
        sb.append("    </Credentials>\r\n");
        sb.append("    <Application>\r\n");
        sb.append("        <ApplicationID>");
        sb.append(this.applicationID());
        sb.append("</ApplicationID>\r\n");
        sb.append("        <ApplicationName>ID Tech Common L2</ApplicationName>\r\n");
        sb.append("        <ApplicationVersion>1.00</ApplicationVersion>\r\n");
        sb.append("    </Application>\r\n");
        sb.append("    <Transaction>\r\n");
        sb.append("        <TransactionID>");
        sb.append(data.transactionID);
        sb.append("</TransactionID>\r\n");
        sb.append("    </Transaction>\r\n");
        sb.append("    <PaymentAccount>\n");
        if (create) {
            if (data.paymentAccountReferenceNumber != null && data.paymentAccountReferenceNumber.length() > 0) {
                sb.append("        <PaymentAccountReferenceNumber>" + data.paymentAccountReferenceNumber + "</PaymentAccountReferenceNumber>\n");
            } else {
                sb.append("        <PaymentAccountReferenceNumber>" + WorldPay.now() + "</PaymentAccountReferenceNumber>\r\n");
            }
            sb.append("        <PaymentAccountType>0</PaymentAccountType>\r\n");
        } else if (data.paymentAccountID != null && data.paymentAccountID.length() > 0) {
            sb.append("        <PaymentAccountID>" + data.paymentAccountID + "</PaymentAccountID>\n");
        }
        sb.append("    </PaymentAccount>\r\n");
        sb.append("</");
        sb.append(transType);
        sb.append(">\r\n");
        return sb.toString();
    }

    public String worldPayCompletionXML(WorldPayData data) {
        Random random;
        if (data == null) {
            return "";
        }
        if (data.ticketNumber == null) {
            data.ticketNumber = "";
        }
        if (data.referenceNumber == null) {
            data.referenceNumber = "";
        }
        if (data.cardData == null) {
            data.cardData = "";
        }
        if (data.emvData == null) {
            data.emvData = "";
        }
        if (data.terminalID == null) {
            data.terminalID = "";
        }
        if (data.amount == null) {
            data.amount = "";
        }
        if (data.accountID == null) {
            data.accountID = "";
        }
        if (data.accountToken == null) {
            data.accountToken = "";
        }
        if (data.acceptorID == null) {
            data.acceptorID = "";
        }
        if (data.transactionID == null) {
            data.transactionID = "";
        }
        if (data.originalAmount == null) {
            data.originalAmount = "0.00";
        }
        if (data.salesTax == null) {
            data.salesTax = "0.00";
        }
        if (data.tip == null) {
            data.tip = "0.00";
        }
        if (data.cashBack == null) {
            data.cashBack = "0.00";
        }
        StringBuilder sb = new StringBuilder();
        String transType = "CreditCardAuthorizationCompletion";
        if (data.transactionType == TRANSACTION_TYPE.TRANSACTION_TYPE_RETURN) {
            transType = "CreditCardReturn";
        }
        if (data.transactionType == TRANSACTION_TYPE.TRANSACTION_TYPE_REVERSAL_PARTIAL || data.transactionType == TRANSACTION_TYPE.TRANSACTION_TYPE_REVERSAL_FULL) {
            transType = "CreditCardReversal";
        }
        if (data.transactionType == TRANSACTION_TYPE.TRANSACTION_TYPE_VOID) {
            transType = "CreditCardVoid";
        }
        sb.append("<");
        sb.append(transType);
        sb.append(" xmlns=\"https://transaction.elementexpress.com\">");
        sb.append("    <Credentials>\r\n");
        sb.append("        <AccountID>");
        sb.append(data.accountID);
        sb.append("</AccountID>\r\n");
        sb.append("        <AccountToken>");
        sb.append(data.accountToken);
        sb.append("</AccountToken>\r\n");
        sb.append("        <AcceptorID>");
        sb.append(data.acceptorID);
        sb.append("</AcceptorID>\r\n");
        sb.append("    </Credentials>\r\n");
        sb.append("    <Application>\r\n");
        sb.append("        <ApplicationID>");
        sb.append(this.applicationID());
        sb.append("</ApplicationID>\r\n");
        if (this.isCTLS) {
            sb.append("        <ApplicationName>ID Tech CTLS Certification</ApplicationName>\r\n");
        } else {
            sb.append("        <ApplicationName>ID Tech Common L2</ApplicationName>\r\n");
        }
        sb.append("        <ApplicationVersion>1.00</ApplicationVersion>\r\n");
        sb.append("    </Application>\r\n");
        sb.append("    <Transaction>\r\n");
        if (data.transactionType == TRANSACTION_TYPE.TRANSACTION_TYPE_REVERSAL_FULL) {
            sb.append("        <ReversalType>1</ReversalType>");
        }
        if (data.transactionType == TRANSACTION_TYPE.TRANSACTION_TYPE_REVERSAL_PARTIAL) {
            sb.append("        <ReversalType>2</ReversalType>");
        }
        sb.append("        <TransactionID>");
        sb.append(data.transactionID);
        sb.append("</TransactionID>\r\n");
        sb.append("        <TransactionAmount>");
        sb.append(data.amount);
        sb.append("</TransactionAmount>\r\n");
        sb.append("        <OriginalAuthorizedAmount>");
        sb.append(data.originalAmount);
        sb.append("</OriginalAuthorizedAmount>\r\n");
        sb.append("        <SalesTaxAmount>");
        sb.append(data.salesTax);
        sb.append("</SalesTaxAmount>\r\n");
        sb.append("        <TipAmount>");
        sb.append(data.tip);
        sb.append("</TipAmount>\r\n");
        sb.append("        <CashBackAmount>");
        sb.append(data.cashBack);
        sb.append("</CashBackAmount>\r\n");
        sb.append("        <ReferenceNumber>");
        if (data.referenceNumber == null || data.referenceNumber.length() == 0) {
            random = new Random();
            data.referenceNumber = String.valueOf(random.nextInt(99999999)) + String.valueOf(random.nextInt(99999999));
        }
        sb.append(data.referenceNumber);
        sb.append("</ReferenceNumber>\r\n");
        sb.append("        <TicketNumber>");
        if (data.ticketNumber == null || data.ticketNumber.length() == 0) {
            random = new Random();
            data.ticketNumber = String.valueOf(random.nextInt(999999));
        }
        sb.append(data.ticketNumber);
        sb.append("</TicketNumber>\r\n");
        sb.append("        <MarketCode>");
        sb.append(data.marketCode.ordinal());
        sb.append("</MarketCode>\r\n");
        if (data.declinePartial) {
            sb.append("        <PartialApprovedFlag>0</PartialApprovedFlag>\n");
        } else {
            sb.append("        <PartialApprovedFlag>1</PartialApprovedFlag>\n");
        }
        if (data.duplicateCheckDisable) {
            sb.append("        <DuplicateCheckDisableFlag>1</DuplicateCheckDisableFlag>\r\n");
        }
        if (data.duplicateOverride) {
            sb.append("        <DuplicateOverrideFlag>1</DuplicateOverrideFlag>\r\n");
        }
        sb.append("        <PaymentType>0</PaymentType>\r\n");
        sb.append("        <SubmissionType>0</SubmissionType>\r\n");
        sb.append("    </Transaction>\r\n");
        sb.append("    <Terminal>\r\n");
        sb.append("        <TerminalID>");
        if (data.terminalID == null || data.terminalID.length() == 0) {
            data.terminalID = "0001";
        }
        sb.append(data.terminalID);
        sb.append("</TerminalID>\r\n");
        sb.append("        <TerminalType>");
        sb.append(data.terminalType.ordinal());
        sb.append("</TerminalType>\r\n");
        sb.append("        <TerminalCapabilityCode>");
        sb.append(data.terminalCapabilityCode.ordinal());
        sb.append("</TerminalCapabilityCode>\r\n");
        sb.append("        <TerminalEnvironmentCode>");
        sb.append(data.terminalEnvironmentCode.ordinal());
        sb.append("</TerminalEnvironmentCode>\r\n");
        sb.append("        <CardPresentCode>");
        sb.append(data.cardPresentCode.ordinal());
        sb.append("</CardPresentCode>\r\n");
        sb.append("        <CVVPresenceCode>0</CVVPresenceCode>\r\n");
        sb.append("        <CardInputCode>");
        if (data.enableCTLS) {
            sb.append(CARD_INPUT_CODE.CARD_INPUT_CODE_CONTACTLESS_CHIP_READ.ordinal());
        } else {
            sb.append(data.cardInputCode.ordinal());
        }
        sb.append("</CardInputCode>\r\n");
        sb.append("        <CardholderPresentCode>");
        sb.append(data.cardHolderPresent.ordinal());
        sb.append("</CardholderPresentCode>\r\n");
        sb.append("        <MotoECICode>1</MotoECICode>\r\n");
        sb.append("    </Terminal>\r\n");
        sb.append("</");
        sb.append(transType);
        sb.append(">\r\n");
        return sb.toString();
    }

    @Override
    public void swipeMSRData(IDTMSRData card) {
        String strCardData = "";
        int ffee08 = -1;
        int ffee06 = -1;
        int errorCode = 0;
        byte[] vasData = null;
        if (card != null) {
            String strData;
            int idx;
            if (card.cardData != null && card.cardData.length > 0 && (strCardData = Common.base16Encode(card.cardData)).length() > 0) {
                ffee08 = strCardData.indexOf("FFEE08");
                ffee06 = strCardData.indexOf("FFEE06");
            }
            if (card.unencryptedTags != null && card.unencryptedTags.size() > 0) {
                byte[] fff2 = null;
                if (card.unencryptedTags.containsKey("FFF2")) {
                    fff2 = card.unencryptedTags.get("FFF2");
                    card.unencryptedTags.put("9F1E", fff2);
                    card.unencryptedTags.remove("FFF2");
                }
            }
            if (card.cardData != null && card.cardData.length > 0 && (idx = (strData = Common.getHexStringFromBytes(card.cardData)).toUpperCase().indexOf("FFF2")) != -1) {
                card.cardData[idx /= 2] = -97;
                card.cardData[idx + 1] = 30;
            }
            if (card.result == 10) {
                if (strCardData.length() > 0) {
                    if (ffee08 == -1 && ffee06 == -1 || ffee08 >= 0 && card.cardData.length <= 32 && !strCardData.contains("9505") && (strCardData.substring(ffee08 + 1).contains("FFEE1F") || strCardData.substring(ffee08 + 1).contains("DFEE02"))) {
                        UMLog.i("swipeMSRData", "Before endTransaction Mifare");
                        this.endTransaction("Mifare Card detected", 61096, 0, null);
                        return;
                    }
                    if (ffee08 >= 0 && !strCardData.substring(ffee08 + 1).contains("FFEE1F") && !strCardData.contains("9F02") && (strCardData.contains("FFEE1F") || strCardData.contains("DFEE02") || strCardData.contains("DFEE1F")) || ffee06 >= 0 && !strCardData.substring(ffee06 + 1).contains("DF02") && (strCardData.contains("FFEE1F") || strCardData.contains("DFEE1F") || strCardData.contains("DFEE02"))) {
                        hasVAS = true;
                        this.currentTransactionData = new IDTEMVData();
                        this.currentTransactionData.msr_cardData = card;
                        UMLog.i("swipeMSRData", "Before endTransaction VAS");
                        this.endTransaction("VAS Transaction", 3159, 0, this.currentTransactionData);
                        return;
                    }
                }
                UMLog.i("swipeMSRData", "Before endTransaction FAIL");
                this.endTransaction("Transaction Failed", 10, 0, null);
                return;
            }
            if (card.result != 61091) {
                if (strCardData.length() > 0 && !strCardData.contains("DFEF4D")) {
                    boolean isMifare = false;
                    if (strCardData.contains("DF02")) {
                        isMifare = true;
                    } else if (ffee08 >= 0) {
                        if (strCardData.substring(ffee08).contains("FFEE1F") && strCardData.substring(0, ffee08).contains("FFEE1F")) {
                            isMifare = true;
                        }
                    } else if (!strCardData.contains("FFEE06") && strCardData.contains("FFEE1F")) {
                        isMifare = true;
                    }
                    if (isMifare) {
                        this.endTransaction("Mifare Card detected", 61096, 0, null);
                    } else {
                        hasVAS = true;
                        this.currentTransactionData = new IDTEMVData();
                        this.currentTransactionData.msr_cardData = card;
                        this.endTransaction("Mifare Card detected", 3159, 0, this.currentTransactionData);
                    }
                    return;
                }
            } else if (strCardData.length() > 0 && !strCardData.contains("DFEF4D")) {
                boolean isMifare = false;
                if (strCardData.contains("DF02")) {
                    isMifare = true;
                } else if (ffee08 >= 0) {
                    if (strCardData.substring(0, ffee08).contains("FFEE1F") && strCardData.substring(ffee08).contains("FFEE1F")) {
                        isMifare = true;
                    }
                } else if (ffee06 == -1 && strCardData.contains("FFEE1F")) {
                    isMifare = true;
                }
                if (isMifare) {
                    this.endTransaction("Mifare Card detected", 61096, 0, null);
                } else {
                    hasVAS = true;
                    this.currentTransactionData = new IDTEMVData();
                    this.currentTransactionData.msr_cardData = card;
                    this.endTransaction("Mifare Card detected", 3159, 0, this.currentTransactionData);
                }
                return;
            }
            if (ffee08 >= 0 && !strCardData.contains("FFEE0808DFEE0204206A8202") || ffee06 >= 0) {
                int dataLen;
                hasVAS = true;
                int byteIndex = ffee06 >= 0 ? ffee06 / 2 : ffee08 / 2;
                if (card.cardData[byteIndex + 3] == -127) {
                    dataLen = card.cardData[byteIndex + 4];
                    dataLen += 5;
                } else {
                    dataLen = card.cardData[byteIndex + 3];
                    dataLen += 4;
                }
                int orgLen = card.cardData.length;
                if (orgLen - dataLen > 0) {
                    byte[] temp = new byte[orgLen - dataLen];
                    vasData = new byte[dataLen];
                    if (byteIndex == 0) {
                        System.arraycopy(card.cardData, dataLen, temp, 0, temp.length);
                        System.arraycopy(card.cardData, 0, vasData, 0, vasData.length);
                    } else if (byteIndex + dataLen == orgLen) {
                        System.arraycopy(card.cardData, 0, temp, 0, temp.length);
                        System.arraycopy(card.cardData, byteIndex, vasData, 0, vasData.length);
                    } else {
                        System.arraycopy(card.cardData, 0, temp, 0, byteIndex);
                        System.arraycopy(card.cardData, byteIndex + dataLen, temp, byteIndex, temp.length - byteIndex);
                        System.arraycopy(card.cardData, byteIndex, vasData, 0, vasData.length);
                    }
                    card.cardData = new byte[temp.length];
                    System.arraycopy(temp, 0, card.cardData, 0, card.cardData.length);
                }
            }
            if (hasVAS && strCardData != null && strCardData.length() > 0) {
                int ffee0607 = strCardData.indexOf("FFEE0607");
                if (ffee08 >= 0 || ffee0607 >= 0) {
                    if (ffee08 < 0 || !strCardData.substring(ffee08 + 1).contains("FFEE1F04206A8202")) {
                        errorCode = ffee08 >= 0 && !strCardData.substring(ffee08 + 1).contains("FFEE1F") && !strCardData.substring(ffee08 + 1).contains("DFEE02") ? 61097 : 61098;
                    }
                } else {
                    errorCode = 61097;
                }
            }
        }
        this.currentTransactionData = new IDTEMVData();
        this.currentTransactionData.msr_cardData = card;
        this.currentData.cardInputCode = CARD_INPUT_CODE.CARD_INPUT_CODE_MAGSTRIPE_READ;
        this.msrData = null;
        if (card != null && card.unencryptedTags != null && card.unencryptedTags.containsKey("DFEE23")) {
            this.msrData = card.unencryptedTags.get("DFEE23");
            String strData = Common.getHexStringFromBytes(this.msrData);
            UMLog.i("swipeMSRData msrData: ", strData);
        } else if (card != null && card.cardData != null && card.cardData.length > 20) {
            this.msrData = card.cardData;
        }
        if (this.msrData != null) {
            String transData;
            this.currentData.cardData = transData = this.createQCKB(this.msrData, null);
            String WPdata = this.worldPayXML(this.currentData);
            String reason = "";
            if (this.storeXMLRecord(this._data, WPdata)) {
                if (errorCode == 61097) {
                    reason = "Transaction Record Stored";
                    if (vasData != null) {
                        reason = reason + "^" + Common.getHexStringFromBytes(vasData);
                    }
                    this.endTransaction("Transaction Record Stored", 61097, 0, this.currentTransactionData);
                } else if (errorCode == 61098) {
                    this.endTransaction("Transaction Record Stored", 61098, 0, this.currentTransactionData);
                } else {
                    this.endTransaction("Transaction Record Stored", 0, 0, this.currentTransactionData);
                }
                return;
            }
            if (this._requestOnly) {
                if (errorCode == 61097) {
                    reason = WPdata;
                    if (vasData != null) {
                        reason = reason + "^" + Common.getHexStringFromBytes(vasData);
                    }
                    this.endTransaction(reason, 61097, 0, this.currentTransactionData);
                } else if (errorCode == 61098) {
                    this.endTransaction(WPdata, 61098, 0, this.currentTransactionData);
                } else {
                    this.endTransaction(WPdata, 0, 0, this.currentTransactionData);
                }
                return;
            }
            String response = this.postToWorldPay(this.currentData.isTest, WPdata, 20000, false);
            if (this.returnRequest) {
                response = this.PrettyXml(WPdata) + "\r\n\r\n" + response;
            }
            if (this.isNEO) {
                int n = response.contains("<ExpressResponseMessage>Approved</ExpressResponseMessage>") ? this.device.ctls_displayOnlineAuthResult(true, null) : this.device.ctls_displayOnlineAuthResult(false, null);
            }
            if (errorCode == 61097) {
                reason = response;
                if (vasData != null) {
                    reason = reason + "^" + Common.getHexStringFromBytes(vasData);
                }
                this.endTransaction(reason, 61097, 0, this.currentTransactionData);
            } else if (errorCode == 61098) {
                this.endTransaction(response, 61098, 0, this.currentTransactionData);
            } else {
                this.endTransaction(response, 0, 0, this.currentTransactionData);
            }
            return;
        }
        if (this.originalCallback != null) {
            this.originalCallback.swipeMSRData(card);
        }
        this.endTransaction(WorldPay.getErrorString(card.result), card.result, 0, this.currentTransactionData);
    }

    @Override
    public void lcdDisplay(int mode, String[] lines, int timeout) {
        UMLog.i("lcdDisplay 1", "mode " + mode);
        if (this.originalCallback != null) {
            this.originalCallback.lcdDisplay(mode, lines, timeout);
        }
    }

    @Override
    public void lcdDisplay(int mode, String[] lines, int timeout, byte[] languageCode, byte messageId) {
        UMLog.i("lcdDisplay 2", "mode " + mode);
        if (this.originalCallback != null) {
            this.originalCallback.lcdDisplay(mode, lines, timeout, languageCode, messageId);
        }
    }

    @Override
    public void ctlsEvent(byte event, byte scheme, byte data) {
        UMLog.i("ctlsEvent ", "event " + event);
        if (this.originalCallback != null) {
            this.originalCallback.ctlsEvent(event, scheme, data);
        }
    }

    public String maskTagToKBTag(String tag) {
        if (tag.toUpperCase().equals("57")) {
            return "DFEF5D";
        }
        if (tag.toUpperCase().equals("56")) {
            return "DFEF5C";
        }
        if (tag.toUpperCase().equals("5A")) {
            return "DFEF5B";
        }
        if (tag.toUpperCase().equals("9F6B")) {
            return "DFEF5E";
        }
        if (tag.toUpperCase().equals("FFEE13")) {
            return "DFEF5F";
        }
        if (tag.toUpperCase().equals("FFEE14")) {
            return "DFEF60";
        }
        return tag;
    }

    /*
     * WARNING - void declaration
     */
    public String createQCKB(byte[] msrData, IDTEMVData emvData) {
        byte[] value;
        Object val;
        Map<String, Map<String, byte[]>> map;
        IDT_Device.readyForCardSwipe = true;
        IDT_Device.readyForNextCommand = true;
        if (msrData != null) {
            return this.msrToKB(msrData).toUpperCase();
        }
        String[] tags = new String[]{"DFEE25", "DFEE26", "DFEE12", "4F", "50", "DFEF5D", "57", "DFEF5B", "5A", "82", "84", "87", "8A", "95", "9A", "9B", "9C", "5F24", "5F2A", "5F30", "5F34", "9F02", "9F03", "9F06", "9F07", "9F08", "9F09", "9F11", "9F0D", "9F0E", "9F0F", "9F12", "9F1A", "9F1E", "9F21", "9F33", "9F34", "9F35", "9F36", "9F37", "9F38", "9F39", "9F3C", "9F40", "9F41", "9F53", "9F6E", "9F7C", "5F20", "5F28", "5F2D", "5F56", "DFEE23", "FFEE01", "9F26", "9F27", "9F10", "DFEF4C", "DFEF4D", "DFEF57", "FFEE12"};
        if (this.isCTLS) {
            tags = new String[]{"DFEE26", "DFEE12", "4F", "50", "DFEF5D", "57", "DFEF5B", "5A", "82", "84", "87", "8A", "95", "9A", "9B", "9C", "5F24", "5F2A", "5F30", "5F34", "9F02", "9F06", "9F07", "9F08", "9F09", "9F11", "9F12", "9F1A", "9F1E", "9F0D", "9F0E", "9F0F", "9F12", "9F1A", "9F1E", "9F21", "9F33", "9F34", "9F35", "9F36", "9F37", "9F38", "9F39", "9F3C", "9F40", "9F41", "9F53", "9F6E", "9F7C", "5F20", "5F28", "5F2D", "5F56", "9F26", "9F27", "9F10", "DFEF4C", "DFEF4D", "9F6E", "9F42", "DF8115", "9F03"};
        }
        StringBuilder sb = new StringBuilder();
        for (String str : tags) {
            sb.append(str);
        }
        Map unenc = null;
        Map<String, byte[]> mask = null;
        Map<String, byte[]> enc = null;
        Map<String, byte[]> firstAC = null;
        if (this.firstACData != null && this.firstACData.unencryptedTags != null) {
            firstAC = this.firstACData.unencryptedTags;
        }
        String enc57 = "";
        if (emvData != null && this.isCTLS) {
            UMLog.i("WorldPay emvData != null && ", "isCTLS");
            unenc = emvData.unencryptedTags;
            mask = emvData.maskedTags;
            enc = emvData.encryptedTags;
            if (enc != null && enc.containsKey("57")) {
                UMLog.i("enc 57 ", Common.getHexStringFromBytes(enc.get("57")));
                enc57 = Common.getHexStringFromBytes(enc.get("57"));
            }
            if (emvData.msr_cardData == null) {
                UMLog.i("emvData.msr_cardData == null", "isCTLS");
            } else {
                UMLog.i("emvData.msr_cardData ", Common.getHexStringFromBytes(emvData.msr_cardData.cardData));
            }
        } else {
            UMLog.i("WorldPay emvData == null || ", "!isCTLS");
            byte[] btags = Common.getByteArray(sb.toString());
            HashMap<String, Map<String, byte[]>> hashMap = new HashMap<String, Map<String, byte[]>>();
            int rt = this.device.emv_retrieveTransactionResult(btags, hashMap);
            if (rt != 0) {
                return null;
            }
            if (hashMap == null) {
                return null;
            }
            unenc = (Map)hashMap.get("tags");
            mask = (Map<String, byte[]>)hashMap.get("masked");
            enc = (Map<String, byte[]>)hashMap.get("encrypted");
            if (emvData != null) {
                Iterator<Map.Entry<String, byte[]>> unenc4 = null;
                Map<String, byte[]> mask4 = null;
                Map<String, byte[]> enc4 = null;
                unenc4 = emvData.unencryptedTags;
                mask4 = emvData.maskedTags;
                enc4 = emvData.encryptedTags;
                if (unenc4 != null && unenc4.size() > 0) {
                    for (Map.Entry<Object, Object> entry : unenc4.entrySet()) {
                        if (!unenc.containsKey(entry.getKey()) || ((byte[])unenc.get(entry.getKey())).length != 0) continue;
                        unenc.remove(entry.getKey());
                        unenc.put((String)entry.getKey(), (byte[])entry.getValue());
                    }
                }
                if (mask4 != null && mask4.size() > 0) {
                    for (Map.Entry<Object, Object> entry : mask4.entrySet()) {
                        if (!mask.containsKey(entry.getKey()) || mask.get(entry.getKey()).length != 0) continue;
                        mask.remove(entry.getKey());
                        mask.put((String)entry.getKey(), (byte[])entry.getValue());
                    }
                }
                if (enc4 != null && enc4.size() > 0) {
                    for (Map.Entry<Object, Object> entry : enc4.entrySet()) {
                        if (!enc.containsKey(entry.getKey()) || enc.get(entry.getKey()).length != 0) continue;
                        enc.remove(entry.getKey());
                        enc.put((String)entry.getKey(), (byte[])entry.getValue());
                    }
                }
            }
        }
        if (unenc == null) {
            return null;
        }
        if (unenc.containsKey("FF8106") && (map = Common.processTLV(val = (byte[])unenc.get("FF8106"))).containsKey("tags")) {
            Map<String, byte[]> unenc2 = map.get("tags");
            for (Map.Entry<String, byte[]> entry : unenc2.entrySet()) {
                if (unenc.containsKey(entry.getKey())) {
                    unenc.remove(entry.getKey());
                }
                unenc.put(entry.getKey(), entry.getValue());
            }
        }
        if (unenc.containsKey("FF8105")) {
            val = (byte[])unenc.get("FF8105");
            Map<String, Map<String, byte[]>> map2 = Common.processTLV(val);
            if (map2.containsKey("tags")) {
                Map<String, byte[]> unenc2 = map2.get("tags");
                for (Map.Entry<String, byte[]> entry : unenc2.entrySet()) {
                    if (unenc.containsKey(entry.getKey())) {
                        unenc.remove(entry.getKey());
                    }
                    unenc.put(entry.getKey(), entry.getValue());
                }
            }
            if (this.isCTLS) {
                if (map2.containsKey("encrypted")) {
                    Map<String, byte[]> unenc2 = map2.get("encrypted");
                    for (Map.Entry<String, byte[]> entry : unenc2.entrySet()) {
                        if (unenc.containsKey(entry.getKey())) {
                            unenc.remove(entry.getKey());
                        }
                        unenc.put(entry.getKey(), entry.getValue());
                    }
                }
                if (map2.containsKey("masked")) {
                    Map<String, byte[]> unenc2 = map2.get("masked");
                    for (Map.Entry<String, byte[]> entry : unenc2.entrySet()) {
                        String key = entry.getKey();
                        byte[] value2 = entry.getValue();
                        String string = this.maskTagToKBTag(key);
                        if (unenc.containsKey(string)) {
                            unenc.remove(string);
                        }
                        unenc.put(string, value2);
                    }
                }
            }
            mask = map2.get("masked");
            enc = map2.get("encrypted");
        }
        if (this.isCTLS) {
            Map<String, byte[]> newDict2;
            ResDataStruct resData = new ResDataStruct();
            boolean bl = false;
            if (unenc.containsKey("84") || unenc.containsKey("4F")) {
                byte[] aid = null;
                aid = unenc.containsKey("84") ? (byte[])unenc.get("84") : (byte[])unenc.get("4F");
                if (aid != null && aid.length > 0) {
                    Map<String, byte[]> newDict3;
                    String _aid = Common.getHexStringFromBytes(aid);
                    int n = this.device.ctls_retrieveApplicationData(_aid, resData);
                    byte[] aidTLV = null;
                    if (resData != null) {
                        aidTLV = resData.resData;
                    }
                    if (aidTLV != null && aidTLV.length > 0 && (newDict3 = Common.processTLVUnencrypted(aidTLV)) != null && newDict3.size() > 0) {
                        byte[] group = null;
                        if (newDict3.containsKey("FFE4")) {
                            group = newDict3.get("FFE4");
                        } else if (newDict3.containsKey("DFEE2D")) {
                            group = newDict3.get("DFEE2D");
                        }
                        if (group != null && group.length == 1) {
                            int n2 = this.device.ctls_getConfigurationGroup(group[0], resData);
                            if (resData != null) {
                                aidTLV = resData.resData;
                            }
                            if (aidTLV != null && aidTLV.length > 0 && (newDict3 = Common.processTLVUnencrypted(aidTLV)) != null && newDict3.size() > 0) {
                                for (Map.Entry<String, byte[]> entry : newDict3.entrySet()) {
                                    if (unenc.containsKey(entry.getKey())) {
                                        if (((byte[])unenc.get(entry.getKey())).length != 0) continue;
                                        unenc.remove(entry.getKey());
                                        unenc.put(entry.getKey(), entry.getValue());
                                        continue;
                                    }
                                    unenc.put(entry.getKey(), entry.getValue());
                                }
                            }
                        }
                    }
                }
            }
            int n = this.device.ctls_retrieveTerminalData(resData);
            if (resData != null && resData.resData != null && resData.resData.length > 0 && (newDict2 = Common.processTLVUnencrypted(resData.resData)) != null && newDict2.size() > 0) {
                for (Map.Entry<String, byte[]> entry : newDict2.entrySet()) {
                    if (unenc.containsKey(entry.getKey())) {
                        if (((byte[])unenc.get(entry.getKey())).length != 0) continue;
                        unenc.remove(entry.getKey());
                        unenc.put((String)entry.getKey(), (byte[])entry.getValue());
                        continue;
                    }
                    unenc.put((String)entry.getKey(), (byte[])entry.getValue());
                }
            }
        }
        if (unenc.containsKey("DFEE23") && (val = (byte[])unenc.get("DFEE23")) != null && ((byte[])val).length > 10 && val[0] == 2 && val[((Object)val).length - 1] == 3) {
            return this.msrToKB((byte[])val);
        }
        if (enc != null && enc.size() > 0) {
            val = enc.entrySet().iterator();
            while (val.hasNext()) {
                Map.Entry entry = (Map.Entry)val.next();
                String key = (String)entry.getKey();
                value = (byte[])entry.getValue();
                if (key.equals("FFEE13") && unenc.containsKey("DFEF4D")) {
                    this.currentData.emvDataTrack1 = Common.getHexStringFromBytes((byte[])unenc.get("DFEF4D"));
                }
                if (unenc.containsKey(key)) {
                    unenc.remove(key);
                }
                unenc.put(key, value);
            }
        }
        if (mask != null && mask.size() > 0) {
            for (Map.Entry entry : mask.entrySet()) {
                String key = (String)entry.getKey();
                value = (byte[])entry.getValue();
                String theKey = this.maskTagToKBTag(key);
                if (unenc.containsKey(theKey)) {
                    unenc.remove(theKey);
                }
                unenc.put(theKey, value);
            }
        }
        StringBuilder finalTags = new StringBuilder();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.isCTLS) {
            for (Map.Entry entry : unenc.entrySet()) {
                arrayList.add((String)entry.getKey());
            }
        }
        for (String str : tags) {
            void var18_70;
            int n;
            StringBuilder stringBuilder;
            int n3;
            if (arrayList.contains(str)) {
                arrayList.remove(str);
            }
            String val2 = "";
            if (unenc.containsKey(str)) {
                val2 = Common.getHexStringFromBytes((byte[])unenc.get(str));
            }
            if (val2.length() == 0 && str.toUpperCase().equals("DFEE25")) {
                finalTags.append("DFEE25020203");
                continue;
            }
            if (val2.length() == 0 && str.toUpperCase().equals("DFEE26")) {
                finalTags.append("DFEE26022000");
                continue;
            }
            if (val2.length() > 0 && str.toUpperCase().equals("DFEE12")) {
                this.currentData.emvDataKSN = val2.toLowerCase();
            } else if (val2.length() == 0 && str.toUpperCase().equals("DFEE12")) {
                if (unenc.containsKey("FFEE12")) {
                    val2 = Common.getHexStringFromBytes((byte[])unenc.get("FFEE12"));
                }
                this.currentData.emvDataKSN = val2.toLowerCase();
            } else if (val2.length() > 0 && str.equals("9F10") && firstAC != null && firstAC.containsKey("9F10")) {
                val2 = Common.getHexStringFromBytes(firstAC.get("9F10"));
            } else if (val2.length() > 0 && str.equals("9F26") && firstAC != null && firstAC.containsKey("9F26")) {
                val2 = Common.getHexStringFromBytes(firstAC.get("9F26"));
            } else if (val2.length() == 0 && str.equals("57")) {
                void var17_57;
                Object var17_55 = null;
                if (unenc.containsKey("DFEF4C")) {
                    byte[] byArray = (byte[])unenc.get("DFEF4C");
                }
                if (var17_57 != null && ((void)var17_57).length > 1) {
                    int offset2;
                    void var18_64 = var17_57[0];
                    void lent2 = var17_57[1];
                    int offset1 = 8 - var18_64 % 8;
                    if (offset1 == 8) {
                        offset1 = 0;
                    }
                    if ((offset2 = 8 - lent2 % 8) == 8) {
                        offset2 = 0;
                    }
                    void var18_65 = var18_64 + offset1;
                    lent2 += offset2;
                    byte[] theData = null;
                    if (unenc.containsKey("DFEF4D")) {
                        theData = (byte[])unenc.get("DFEF4D");
                    }
                    if (theData != null && theData.length >= var18_65 + lent2) {
                        byte[] t2Data = new byte[lent2];
                        System.arraycopy(theData, (int)var18_65, t2Data, 0, (int)lent2);
                        val2 = Common.getHexStringFromBytes(t2Data);
                        if (this.currentData.emvDataTrack2 == null || this.currentData.emvData.length() == 0) {
                            this.currentData.emvDataTrack2 = val2.toLowerCase();
                        }
                        UMLog.i("WorldPay currentData.emvDataTrack2 1", this.currentData.emvDataTrack2);
                    }
                }
            } else if (this.transName.length() == 0 && val2.length() > 0 && (str.equals("5F20") || str.equals("50"))) {
                this.transName = Common.getAsciiFromByte(Common.getBytesFromHexString(val2));
            } else if (this.PAN.length() == 0 && val2.length() > 0 && str.equals("DFEF5B")) {
                this.PAN = val2;
            } else if (this.PAN.length() == 0 && val2.length() > 0 && str.equals("DFEF5D")) {
                int n4 = val2.indexOf(68);
                this.PAN = val2.substring(0, n4);
            }
            if (val2.length() == 0 && str.toUpperCase().equals("DFEF57") && (n3 = this.device.device_getFirmwareVersion(stringBuilder = new StringBuilder())) == 0) {
                byte[] fwbyutes = stringBuilder.toString().getBytes();
                val2 = Common.getHexStringFromBytes(fwbyutes);
            }
            boolean bl = false;
            byte[] byArray = new byte[1];
            if (val2.length() > 0) {
                n = val2.length() / 2;
            }
            if (n < 128) {
                byArray[0] = (byte)(n & 0xFF);
            } else if (n < 256) {
                byte[] byArray2 = new byte[]{-127, (byte)(n & 0xFF)};
            } else {
                byte[] byArray3 = new byte[]{-126, (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
            }
            if (str.equals("FFEE12")) continue;
            if (str.equals("57") && this.isCTLS) {
                if (this.currentData == null || val2 == null || val2.length() <= 0) continue;
                if (enc57.length() > 0) {
                    val2 = enc57;
                    UMLog.i("val = enc57", val2);
                }
                this.currentData.emvDataTrack2 = val2.toLowerCase();
                UMLog.i("WorldPay currentData.emvDataTrack2 2", this.currentData.emvDataTrack2);
                continue;
            }
            if (this.isCTLS) {
                if (((void)var18_70).length <= 0 || var18_70[0] == false) continue;
                finalTags.append(str + Common.getHexStringFromBytes((byte[])var18_70) + val2);
                continue;
            }
            finalTags.append(str + Common.getHexStringFromBytes((byte[])var18_70) + val2);
        }
        if (this.isCTLS) {
            if (arrayList.size() > 0) {
                for (String entry : arrayList) {
                    if (!unenc.containsKey(entry) || entry.toUpperCase().startsWith("FF") || entry.toUpperCase().startsWith("DF")) continue;
                    byte[] val3 = (byte[])unenc.get(entry);
                    int dataLen = 0;
                    byte[] valLen = new byte[1];
                    if (val3.length > 0) {
                        dataLen = val3.length;
                    }
                    if (dataLen < 128) {
                        valLen[0] = (byte)(dataLen & 0xFF);
                    } else {
                        valLen = dataLen < 256 ? new byte[]{-127, (byte)(dataLen & 0xFF)} : new byte[]{-126, (byte)(dataLen >> 8 & 0xFF), (byte)(dataLen & 0xFF)};
                    }
                    finalTags.append(entry + Common.getHexStringFromBytes(valLen) + Common.getHexStringFromBytes(val3));
                }
            }
            String f = finalTags.toString().toUpperCase();
            String res = Base64.encodeToString((byte[])Common.getByteArray(f), (int)0);
            res = res.replace("\r", "");
            this.currentData.emvData = res = res.replace("\n", "");
            return res;
        }
        this.currentData.cardData = finalTags.toString().toUpperCase();
        return finalTags.toString().toUpperCase();
    }

    public String getSUM(String strData) {
        String strLRC = null;
        byte[] toCharArray = Common.getByteArray(strData);
        byte[] sum = new byte[]{toCharArray[0]};
        for (int i = 1; i < toCharArray.length; ++i) {
            sum[0] = (byte)(sum[0] + toCharArray[i]);
        }
        strLRC = Common.getHexStringFromBytes(sum);
        return strLRC;
    }

    public String getLRC(String strData) {
        String strLRC = null;
        byte[] toCharArray = Common.getByteArray(strData);
        byte[] lrc = new byte[]{toCharArray[0]};
        for (int i = 1; i < toCharArray.length; ++i) {
            lrc[0] = (byte)(lrc[0] ^ toCharArray[i]);
        }
        strLRC = Common.getHexStringFromBytes(lrc);
        return strLRC;
    }

    public byte[] makeCommand(String commandBodyData) {
        String sum = this.getSUM(commandBodyData);
        String lrc = this.getLRC(commandBodyData);
        short length = (short)(commandBodyData.length() / 2);
        byte[] lowHigh = new byte[]{(byte)(length & 0xFF), (byte)(length >> 8 & 0xFF)};
        String commandLength = Common.getHexStringFromBytes(lowHigh);
        String commandData = "";
        commandData = !commandBodyData.startsWith("5669564f") ? "02" + commandLength + commandBodyData + lrc + sum + "03" : commandBodyData;
        return Common.getByteArray(commandData);
    }

    public String msrToKB(byte[] data) {
        boolean hasOptional;
        if (data == null || data.length == 0) {
            return "";
        }
        String strData = Common.getHexStringFromBytes(data);
        UMLog.i("msrToKB", strData);
        if (data[0] != 2) {
            data = this.makeCommand(Common.getHexStringFromBytes(data));
        }
        if (data.length < 20) {
            return Common.getHexStringFromBytes(data);
        }
        int len = 0;
        if (data[3] == 192) {
            len = data[6] + data[7];
        } else {
            if ((data[8] & 1) == 1) {
                len += data[5];
            }
            if ((data[8] & 2) == 2) {
                len += data[6];
            }
            if ((data[8] & 4) == 4) {
                len += data[7];
            }
        }
        int offset = 10;
        boolean bl = hasOptional = (data[4] & 0x40) == 64;
        if (hasOptional) {
            offset = offset + 1 + data[10];
        }
        byte[] part1 = new byte[offset];
        byte[] part2 = new byte[len];
        byte[] part3 = new byte[data.length - len - offset];
        System.arraycopy(data, 0, part1, 0, offset);
        System.arraycopy(data, offset, part2, 0, len);
        System.arraycopy(data, offset + len, part3, 0, part3.length);
        String total = Common.getHexStringFromBytes(part1) + new String(part2) + Common.getHexStringFromBytes(part3);
        return total.toUpperCase();
    }

    @Override
    public void emvTransactionData(IDTEMVData emvData) {
        String strCardData;
        int idx;
        byte[] fff2;
        if (emvData == null) {
            return;
        }
        if (emvData.unencryptedTags != null && emvData.unencryptedTags.size() > 0) {
            fff2 = null;
            if (emvData.unencryptedTags.containsKey("FFF2")) {
                fff2 = emvData.unencryptedTags.get("FFF2");
                emvData.unencryptedTags.put("9F1E", fff2);
                emvData.unencryptedTags.remove("FFF2");
            }
        }
        if (emvData.msr_cardData != null && emvData.msr_cardData.unencryptedTags != null && emvData.msr_cardData.unencryptedTags.size() > 0) {
            fff2 = null;
            if (emvData.msr_cardData.unencryptedTags.containsKey("FFF2")) {
                fff2 = emvData.msr_cardData.unencryptedTags.get("FFF2");
                emvData.msr_cardData.unencryptedTags.put("9F1E", fff2);
                emvData.msr_cardData.unencryptedTags.remove("FFF2");
            }
        }
        if (emvData.msr_cardData != null && emvData.msr_cardData.cardData != null && emvData.msr_cardData.cardData.length > 0 && (idx = (strCardData = Common.getHexStringFromBytes(emvData.msr_cardData.cardData)).toUpperCase().indexOf("FFF2")) != -1) {
            emvData.msr_cardData.cardData[idx /= 2] = -97;
            emvData.msr_cardData.cardData[idx + 1] = 30;
        }
        this.currentTransactionData = emvData;
        if (emvData.cardType == 1) {
            this.isCTLS = true;
        }
        this.sendMessage("CARD READ OK");
        if (emvData.unencryptedTags != null && emvData.unencryptedTags.size() > 0) {
            byte[] e1 = null;
            if (emvData.unencryptedTags.containsKey("FFEE1F")) {
                e1 = emvData.unencryptedTags.get("FFEE1F");
            }
            byte[] e2 = null;
            if (emvData.unencryptedTags.containsKey("DFEE02")) {
                e2 = emvData.unencryptedTags.get("DFEE02");
            }
            byte[] iad = null;
            if (emvData.unencryptedTags.containsKey("9F10")) {
                iad = emvData.unencryptedTags.get("9F10");
            }
            if (e1 != null && e1.length > 3) {
                boolean isError = false;
                String transReason = "";
                if (e1[0] == 32) {
                    transReason = "CARD NOT SUPPORTED";
                    isError = true;
                }
                if (e1[0] == 0 && e1[3] == 4) {
                    transReason = "CARD NOT SUPPORTED";
                    isError = true;
                }
                if (e1[0] == 66) {
                    transReason = "DECLINE OFFLINE";
                    isError = true;
                }
                if (e1[0] == 39) {
                    transReason = "NOT SUPPORTED";
                    isError = true;
                }
                if (isError) {
                    this.endTransaction(transReason, 10, 65535, emvData);
                    return;
                }
            }
        }
        if (this.isCTLS && emvData.encryptedTags != null && emvData.encryptedTags.size() > 0) {
            emvData.result = 9;
        }
        if (emvData.result == 4) {
            this.firstACData = emvData;
            this.handler.post(this.doCompletion);
            return;
        }
        if (emvData.result == 16) {
            this.handler.post(this.doAuthentication);
            return;
        }
        if ((this.goOnline || this.isNEO) && emvData != null && emvData.unencryptedTags != null || emvData.result == 7 || emvData.result == 9) {
            String transData;
            this.currentData.cardInputCode = CARD_INPUT_CODE.CARD_INPUT_CODE_CHIP_READ;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e1) {
                // empty catch block
            }
            if (emvData.result == 7) {
                this.currentData.cardInputCode = CARD_INPUT_CODE.CARD_INPUT_CODE_MAGSTRIPE_READ_CHIP_READ_FAILURE;
                if (emvData.msr_cardData != null && emvData.msr_cardData.rawTrackData != null && emvData.msr_cardData.rawTrackData.length > 20) {
                    this.msrData = new byte[emvData.msr_cardData.rawTrackData.length - 4];
                    System.arraycopy(emvData.msr_cardData.rawTrackData, 4, this.msrData, 0, this.msrData.length);
                }
            }
            if (emvData != null && emvData.unencryptedTags != null && emvData.unencryptedTags.containsKey("DFEE23")) {
                this.msrData = emvData.unencryptedTags.get("DFEE23");
            }
            IDTEMVData ctlsTags = null;
            if (emvData.result == 9) {
                ctlsTags = emvData;
            }
            this.currentData.cardData = transData = this.createQCKB(this.msrData, emvData);
            String WPdata = this.worldPayXML(this.currentData);
            if (this.storeXMLRecord(this._data, WPdata)) {
                this.endTransaction("Transaction Record Stored", 0, 0, emvData);
                return;
            }
            if (this._requestOnly || this.currentData.transactionType == TRANSACTION_TYPE.TRANSACTION_TYPE_QUICK_CHIP_START) {
                this.endTransaction(WPdata, 0, 0, emvData);
                return;
            }
            String response = this.postToWorldPay(this.currentData.isTest, WPdata, 20000, false);
            if (this.returnRequest) {
                response = this.PrettyXml(WPdata) + "\r\n\r\n" + response;
            }
            if (this.isNEO) {
                if (response.contains("<ExpressResponseMessage>Approved</ExpressResponseMessage>")) {
                    int n = this.device.ctls_displayOnlineAuthResult(true, null);
                } else {
                    int n = this.device.ctls_displayOnlineAuthResult(false, null);
                }
            }
            this.endTransaction(response, 0, 0, emvData);
            return;
        }
        if (this.originalCallback != null) {
            this.originalCallback.emvTransactionData(emvData);
        }
        this.endTransaction(WorldPay.getErrorString(emvData.result), emvData.result, 0, emvData);
    }

    @Override
    public void deviceConnected() {
        UMLog.i("deviceConnected", "callback");
        if (this.originalCallback != null) {
            this.originalCallback.deviceConnected();
        }
    }

    @Override
    public void deviceDisconnected() {
        UMLog.i("deviceDisconnected", "callback");
        inTransaction = false;
        if (this.originalCallback != null) {
            this.originalCallback.deviceDisconnected();
        }
        UMLog.i("deviceDisconnected", "Reset callbacks");
        inTransaction = false;
        this.currentData = null;
        this.device.m_recListener = this.originalCallback;
        this.originalCallback = null;
        this.myCallback = null;
    }

    @Override
    public void timeout(int errorCode) {
        UMLog.i("timeout", "errorCode " + errorCode + " hasVAS " + hasVAS);
        if (this.originalCallback != null && !hasVAS) {
            this.originalCallback.timeout(errorCode);
        }
        if (this.transactionType != 3 || errorCode != 61091) {
            UMLog.i("timeout", "Reset callbacks");
            inTransaction = false;
            this.currentData = null;
            if (this.originalCallback != null) {
                this.device.m_recListener = this.originalCallback;
            }
            this.originalCallback = null;
            this.myCallback = null;
        }
    }

    @Override
    public void autoConfigCompleted(StructConfigParameters profile) {
    }

    @Override
    public void autoConfigProgress(int progressValue) {
    }

    @Override
    public void msgRKICompleted(String MACResult) {
    }

    @Override
    public void ICCNotifyInfo(byte[] dataNotify, String strMessage) {
    }

    @Override
    public void msgBatteryLow() {
    }

    @Override
    public void LoadXMLConfigFailureInfo(int index, String strMessage) {
    }

    @Override
    public void msgToConnectDevice() {
    }

    @Override
    public void msgAudioVolumeAjustFailed() {
    }

    @Override
    public void dataInOutMonitor(byte[] data, boolean isIncoming) {
        UMLog.i("dataInOutMonitor", "isIncoming " + isIncoming);
    }

    public static String getErrorString(int code) {
        switch (code) {
            case 0: {
                return "no error, beginning task";
            }
            case 1: {
                return "no response from reader";
            }
            case 2: {
                return "invalid response data";
            }
            case 3: {
                return "time out for task or CMD";
            }
            case 4: {
                return "wrong parameter";
            }
            case 5: {
                return "SDK is doing MSR or ICC task";
            }
            case 6: {
                return "SDK is doing PINPad task";
            }
            case 7: {
                return "SDK is doing CTLS task";
            }
            case 8: {
                return "Firmware return timeout value";
            }
            case 9: {
                return "SDK is doing Other task";
            }
            case 10: {
                return "err response or data";
            }
            case 11: {
                return "no reader attached";
            }
            case 12: {
                return "mono audio is enabled";
            }
            case 13: {
                return "did connection";
            }
            case 14: {
                return "audio volume is too low";
            }
            case 15: {
                return "task or CMD be canceled";
            }
            case 16: {
                return "UF wrong string format";
            }
            case 17: {
                return "UF file not found";
            }
            case 18: {
                return "UF wrong file format";
            }
            case 19: {
                return "Attempt to contact online host failed";
            }
            case 20: {
                return "Attempt to perform RKI failed";
            }
            case 21: {
                return "Missing DLL.  Cannot access device.";
            }
            case 22: {
                return "Firmware Block Transfer Successful";
            }
            case 23: {
                return "SDK is doing Firmware Update task";
            }
            case 24: {
                return "Applying the firmware update downloaded to memory";
            }
            case 25: {
                return "No Data Available";
            }
            case 26: {
                return "SDK Busy doing file transfer task";
            }
            case 27: {
                return "Applying the file transfer";
            }
            case 28: {
                return "File Transfer Successful";
            }
            case 29: {
                return "Not enough space available on drive";
            }
            case 30: {
                return "Entering Bootload Mode";
            }
            case 31: {
                return "Starting Firmware Update";
            }
            case 32: {
                return "PCI File Mismatch";
            }
            case 33: {
                return "Incorrect FW File Block Size";
            }
            case 34: {
                return "Device is busy finalizing transaction.";
            }
            case 35: {
                return "The SDK Busy doing RKI update";
            }
            case 36: {
                return "Bad MSR Swipe";
            }
            case 37: {
                return "Financial card not allowed";
            }
            case 38: {
                return "SDK Busy waiting for input event";
            }
            case 39: {
                return "Unsupported Command";
            }
            case 40: {
                return "Erasing SPI VP8800";
            }
            case 41: {
                return "SDK is doing EMV task";
            }
            case 42: {
                return "SDK is doing Camera task";
            }
            case 43: {
                return "SDK is doing ViVO Config task";
            }
            case 44: {
                return "SDK is starting VIVO Config task";
            }
            case 45: {
                return "SDK is finishing ViVO Config task";
            }
            case 46: {
                return "ViVO Config task failed";
            }
            case 47: {
                return "ViVO Config Message";
            }
            case 48: {
                return "Failed to change ViVO Config mode";
            }
            case 49: {
                return "VivoConfig updated was cancelled";
            }
            case 50: {
                return "ViVO Config Verify Success";
            }
            case 51: {
                return "ViVO Vonfig Verify failure";
            }
            case 52: {
                return "Command is invalid when accessing a device in remote mode";
            }
            case 53: {
                return "Remote command execution class not found";
            }
            case 54: {
                return "Remote command execution method not found";
            }
            case 55: {
                return "Remote command execution failed";
            }
            case 56: {
                return "SDK is finishing writing ViVO Config task with warning";
            }
            case 57: {
                return "ViVO Config Verify Success with warning";
            }
            case 58: {
                return "ViVOconfig Started, Hash value correct";
            }
            case 59: {
                return "ViVOconfig Started, Hash value incorrect";
            }
            case 60: {
                return "ViVOconfig failed, Hash value incorrect";
            }
            case 61: {
                return "ViVOconfig started, Hash value incorrect but was repaired";
            }
            case 62: {
                return "ViVOconfig failed, file version not compatible with this SDK. Use newer SDK";
            }
            case 63: {
                return "ViVOconfig failed, error reading or parsing .json format";
            }
            case 64: {
                return "ViVOconfig failed, firmware version does not match";
            }
            case 65: {
                return "Failed downloading FW Bootloader A";
            }
            case 66: {
                return "Failed downloading FW Bootloader B";
            }
            case 67: {
                return "Failed downloading FW K81";
            }
            case 68: {
                return "Failed downloading FW 1050";
            }
            case 69: {
                return "Failed downloading FW Contact Kernel";
            }
            case 70: {
                return "Failed downloading FW Contactless Kernel AMEX";
            }
            case 71: {
                return "Failed downloading FW Contactless Kernel Apple Pay VAS";
            }
            case 72: {
                return "Failed downloading FW Contactless Kernel CUP";
            }
            case 73: {
                return "Failed downloading FW Contactless Kernel DPASS";
            }
            case 74: {
                return "Failed downloading FW Contactless Kernel INTERAC";
            }
            case 75: {
                return "Failed downloading FW Contactless Kernel JCB";
            }
            case 76: {
                return "Failed downloading FW Contactless Kernel MCHIP";
            }
            case 77: {
                return "Failed downloading FW Contactless Kernel PPSE";
            }
            case 78: {
                return "Failed downloading FW Contactless Kernel SmartTap";
            }
            case 79: {
                return "Failed downloading FW Contactless Kernel VCPS";
            }
            case 80: {
                return "Multiple FW Update Sequence Complete";
            }
            case 81: {
                return "Multiple FW Update Sequence Starting Next Update";
            }
            case 82: {
                return "Unable to compelte multi-fw update";
            }
            case 83: {
                return "VC File Verify Hash Failure";
            }
            case 84: {
                return "VC File Verify Hash Repaired";
            }
            case 85: {
                return "VC File Verify Firmware Mismatch";
            }
            case 86: {
                return "VC File Verify File Version Incorrect";
            }
            case 87: {
                return "VC File Verify File Format Error";
            }
            case 88: {
                return "SDK is finishing ViVO Config Reading Task";
            }
            case 89: {
                return "ViVO Config read config task failed";
            }
            case 90: {
                return "Success, but wait for device to reboot";
            }
            case 91: {
                return "Bootloader A must be loaded before Bootloader B can be installed";
            }
            case 92: {
                return "Bootloader B must be loaded before other updates can be installed";
            }
            case 8448: {
                return "Remote Server Unknown Error";
            }
            case 8449: {
                return "Remote Server Success";
            }
            case 8450: {
                return "Remote Server Busy With Command";
            }
            case 8451: {
                return "Remote Server Busy With Workflow";
            }
            case 8452: {
                return "Remote Server Busy With FW Update";
            }
            case 8453: {
                return "Remote Server Busy With RKI";
            }
            case 8454: {
                return " Remote Server Busy With Transaction";
            }
            case 8455: {
                return "Remote Server No Response";
            }
            case 8456: {
                return "Remote Server Device Not Specified";
            }
            case 8457: {
                return "Remote Server Device Not Available";
            }
            case 8458: {
                return "Remote Server Incorrect Parameters";
            }
            case 8459: {
                return "Remote Server App Not Found";
            }
            case 8460: {
                return "Remote Server App Already Exists";
            }
            case 8461: {
                return "Remote Server App Not Subscribed";
            }
            case 8462: {
                return "Remote Server App Not Client";
            }
            case 8463: {
                return "Remote Server No Host.";
            }
            case 8464: {
                return "Remote Server Setting App State to Existing App State.";
            }
            case 8465: {
                return "Remote Server Changing App State While Exclusive Lock ON. Must set state APP_STATE_EXCLUSIVE_LOCK_OFF.";
            }
            case 8466: {
                return "Remote Server Busy With  Configuration.";
            }
            case 8467: {
                return "Remote Server awaiting more data";
            }
            case 8468: {
                return "Partial data packet send without valid data";
            }
            case 8469: {
                return "Partial data packet must be either type String or Byte[]";
            }
            case 8470: {
                return "Partial data packet send with wrong start position";
            }
            case 8471: {
                return "Partial data packet send with wrong total size";
            }
            case 256: {
                return "Log is full";
            }
            case 768: {
                return "Key Type(TDES) of Session Key is not same as the related Master Key.";
            }
            case 1024: {
                return "Related Key was not loaded.";
            }
            case 1040: {
                return "Non-SRED Device need Load Manufacture Key and Firmware Key.";
            }
            case 1280: {
                return "Key Same.";
            }
            case 1281: {
                return "Key is all zero";
            }
            case 1282: {
                return "TR-31 format error";
            }
            case 1792: {
                return "No BDK of Pairing MSR Key.";
            }
            case 1793: {
                return "Have BDK of Pairing MSR Key, Not Pairing with MSR (No PAN Encryption Key)";
            }
            case 1794: {
                return "PAN is Error Key.";
            }
            case 1795: {
                return "Pairing Failed";
            }
            case 1796: {
                return "MSR Pairing Key Other Error";
            }
            case 1797: {
                return "No Internal MSR PAN (or Internal MSR PAN is erased timeout)";
            }
            case 2048: {
                return "Invalid Pinpad Data Received";
            }
            case 2049: {
                return "Key Pad Cancel";
            }
            case 2050: {
                return "External Command Cancel";
            }
            case 2051: {
                return "Invalid Input Parameters";
            }
            case 2052: {
                return "PAN Error";
            }
            case 2053: {
                return "PIN DUKPT Key is absent";
            }
            case 2054: {
                return "PIN DUKPT Key is exhausted";
            }
            case 2055: {
                return "Display Error Message";
            }
            case 2060: {
                return "Not Allowed";
            }
            case 3073: {
                return "Incorrect Frame Tag";
            }
            case 3074: {
                return "Incorrect Frame Type";
            }
            case 3075: {
                return "Unknown Frame Type";
            }
            case 3076: {
                return "Unknown Command";
            }
            case 3077: {
                return "Unknown Sub-Command";
            }
            case 3078: {
                return "CRC Error";
            }
            case 3079: {
                return "Failed";
            }
            case 3080: {
                return "Timeout";
            }
            case 3082: {
                return "Incorrect Parameter";
            }
            case 3083: {
                return "Command Not Supported";
            }
            case 3084: {
                return "Sub-Command Not Supported";
            }
            case 3085: {
                return "Parameter Not Supported / Status Abort Command";
            }
            case 3087: {
                return "Sub-Command Not Allowed";
            }
            case 3159: {
                return "No Payment Occurred (VAS transaction)";
            }
            case 3329: {
                return "Incorrect Header Tag";
            }
            case 3330: {
                return "Unknown Command";
            }
            case 3331: {
                return "Unknown Sub-Command";
            }
            case 3332: {
                return "CRC Error in Frame";
            }
            case 3333: {
                return "Incorrect Parameter";
            }
            case 3334: {
                return "Parameter Not Supported";
            }
            case 3335: {
                return "Mal-formatted Data";
            }
            case 3336: {
                return "Timeout";
            }
            case 3338: {
                return "Failed / NACK";
            }
            case 3339: {
                return "Command not Allowed (Passthough Mode May Be On)";
            }
            case 3340: {
                return "Sub-Command not Allowed";
            }
            case 3341: {
                return "Buffer Overflow (Data Length too large for reader buffer)";
            }
            case 3342: {
                return "User Interface Event";
            }
            case 3343: {
                return "Decryption Error";
            }
            case 3345: {
                return "Communication type not supported, VT-1, burst, etc.";
            }
            case 3346: {
                return "Secure interface is not functional or is in an intermediate state.";
            }
            case 3347: {
                return "Data field is not mod 8";
            }
            case 3348: {
                return "Pad 0x80 not found where expected";
            }
            case 3349: {
                return "Specified key type is invalid";
            }
            case 3350: {
                return "Busy - device, resource or system is busy";
            }
            case 3351: {
                return "Hash code problem";
            }
            case 3352: {
                return "Could not store the key into the SAM(InstallKey)";
            }
            case 3353: {
                return "Frame is too large";
            }
            case 3354: {
                return "Unit powered up in authentication state but POS must resend the InitSecureComm command";
            }
            case 3355: {
                return "The EEPROM may not be initialized because SecCommInterface does not make sense";
            }
            case 3356: {
                return "Problem encoding APDU";
            }
            case 3360: {
                return "Unsupported Index(ILM) SAM Transceiver error \u2013 problem communicating with the SAM(Key Mgr)";
            }
            case 3361: {
                return "Unexpected Sequence Counter in multiple frames for single bitmap(ILM) Length error in data returned from the SAM(Key Mgr)";
            }
            case 3362: {
                return "Improper bit map(ILM)";
            }
            case 3363: {
                return "Request Online Authorization (Contactless Only)";
            }
            case 3364: {
                return "ViVOCard3 raw data read successful";
            }
            case 3365: {
                return "Message index not available(ILM) ViVOcomm activate transaction card type(ViVOcomm)";
            }
            case 3366: {
                return "Version Information Mismatch(ILM)";
            }
            case 3367: {
                return "Not sending commands in correct index message index(ILM)";
            }
            case 3368: {
                return "Time out or next expected message not received(ILM)";
            }
            case 3369: {
                return "ILM languages not available for viewing(ILM)";
            }
            case 3370: {
                return "Other language not supported(ILM)";
            }
            case 3371: {
                return "Device Not Ready";
            }
            case 3372: {
                return "The 8341 operation was exited by the Cancel Transaction command";
            }
            case 3373: {
                return "The 8341 operation was exited by the user pressing the cancel key";
            }
            case 3376: {
                return "Request Online Authorization (Contact Only)";
            }
            case 3377: {
                return "Request Online PIN (for Cardholder Verification Method -CVM)";
            }
            case 3378: {
                return "Request Signature (for Cardholder Verification Method - CVM)";
            }
            case 3379: {
                return "Advice Required";
            }
            case 3380: {
                return "Reversal Required";
            }
            case 3381: {
                return "Advice and Reversal Required";
            }
            case 3382: {
                return "No Advice or Reversal Required (Declined)";
            }
            case 3385: {
                return "Reserved";
            }
            case 3386: {
                return "Fallback from Contact (ICC) to Magstripe";
            }
            case 3387: {
                return "Fallback from Contactless to Contact";
            }
            case 3388: {
                return "Fallback from Contactless to Magstripe";
            }
            case 3389: {
                return "Fallback from Contactless to Other Interface";
            }
            case 3393: {
                return "Unknown Error from SAM";
            }
            case 3394: {
                return "Invalid data detected by SAM";
            }
            case 3395: {
                return "Incomplete data detected by SAM";
            }
            case 3396: {
                return "Reserved";
            }
            case 3397: {
                return "Invalid key hash algorithm";
            }
            case 3398: {
                return "Invalid key encryption algorithm";
            }
            case 3399: {
                return "Invalid modulus length";
            }
            case 3400: {
                return "Invalid exponent";
            }
            case 3401: {
                return "Key already exists";
            }
            case 3402: {
                return "No space for new RID";
            }
            case 3403: {
                return "Key not found";
            }
            case 3404: {
                return "Crypto not responding";
            }
            case 3405: {
                return "Crypto communication error";
            }
            case 3406: {
                return "Module-specific error for Key Manager";
            }
            case 3407: {
                return "All key slots are full (maximum number of keys has been installed)";
            }
            case 3408: {
                return "Key data is bad or corrupt";
            }
            case 3409: {
                return "Keys out of sync between contactless and contact interfaces (use this command on one interface at a time)";
            }
            case 3413: {
                return "Illegal duplicate data set";
            }
            case 3414: {
                return "Indication to fail the transaction to Pass Through Mode";
            }
            case 3415: {
                return "No payment transaction occurred. The response is loyalty only.";
            }
            case 3417: {
                return "Start Transaction successful. Perform Authentication..";
            }
            case 3424: {
                return "Data does not exist";
            }
            case 3425: {
                return "Data Full";
            }
            case 3426: {
                return "Write Flash Error";
            }
            case 3427: {
                return "OK and Have Next Command";
            }
            case 3428: {
                return "One Kernel was or some Kernels were disabled for absent or self-test error";
            }
            case 3440: {
                return "Antenna Error";
            }
            case 3456: {
                return "Use another card";
            }
            case 3457: {
                return "Insert or swipe card";
            }
            case 3472: {
                return "Data encryption Key does not exist";
            }
            case 3473: {
                return "Account DUKPT Key KSN exausted";
            }
            case 3474: {
                return "MAC DUKPT Key does not exist (if enable MAC verification)";
            }
            case 3475: {
                return "MAC DUKPT Key KSN exhausted (if enable MAC verification)";
            }
            case 3476: {
                return "No DEK / Desjardins Data Key / TransArmor RSA Cert";
            }
            case 3477: {
                return "Encryption Switch is Off";
            }
            case 3491: {
                return "Error code for card insertion";
            }
            case 3489: {
                return "The SD card does NOT exist";
            }
            case 3488: {
                return "The screen or object already exists";
            }
            case 3490: {
                return "Error decoding QR code";
            }
            case 3492: {
                return "Error code for card insertion before sending a transaction command (for products with motors)";
            }
            case 3493: {
                return "LCD control is rejected, due to LCD is not in working state";
            }
            case 3328: {
                return "This Key had been loaded.";
            }
            case 3584: {
                return "Base Time was loaded.";
            }
            case 3840: {
                return "Encryption Or Decryption Failed.";
            }
            case 4096: {
                return "Battery Low Warning (It is High Priority Response while Battery is Low.)";
            }
            case 6144: {
                return "Send \u201cCancel Command\u201d after send \u201cGet Encrypted PIN\u201d &\u201dGet Numeric \u201c& \u201cGet Amount\u201d";
            }
            case 6400: {
                return "Press \u201cCancel\u201d key after send \u201cGet Encrypted PIN\u201d &\u201dGet Numeric \u201c& \u201cGet Amount\u201d";
            }
            case 12543: {
                return "Security Chip is not connect";
            }
            case 12288: {
                return "Security Chip is deactivation & Device is In Removal Legally State.";
            }
            case 12304: {
                return "Master Chip was Activated.";
            }
            case 12545: {
                return "Security Chip is activation &  Device is In Removal Legally State.";
            }
            case 21760: {
                return "No Admin DUKPT Key.";
            }
            case 21761: {
                return "Admin  DUKPT Key STOP.";
            }
            case 21762: {
                return "Admin DUKPT Key KSN is Error.";
            }
            case 21763: {
                return "Get Authentication Code1 Failed.";
            }
            case 21764: {
                return "Validate Authentication Code Error.";
            }
            case 21765: {
                return "Encrypt or Decrypt data failed.";
            }
            case 21766: {
                return "Not Support the New Key Type.";
            }
            case 21767: {
                return "New Key Index is Error.";
            }
            case 21768: {
                return "Step Error.";
            }
            case 21769: {
                return "KSN Error";
            }
            case 21770: {
                return "MAC Error.";
            }
            case 21771: {
                return "Key Usage Error.";
            }
            case 21772: {
                return "Mode Of Use Error.";
            }
            case 21775: {
                return "Other Error.";
            }
            case 21808: {
                return "Key Number Error";
            }
            case 21809: {
                return "Key Block length error";
            }
            case 21810: {
                return "Key Length Error";
            }
            case 21811: {
                return "HMAC checking error";
            }
            case 24576: {
                return "Save or Config Failed / Or Read Config Error.";
            }
            case 25088: {
                return "No Serial Number.";
            }
            case 26880: {
                return "Invalid Command - Protocol is right, but task ID is invalid.";
            }
            case 27136: {
                return "Unsupported Command - Protocol and task ID are right, but command is invalid.";
            }
            case 27137: {
                return "Unsupported Command \u2013 Protocol and task ID are right, but command is invalid \u2013 In this State";
            }
            case 27138: {
                return "Unsupported Command - Protocol and task ID are right, but command is invalid - for disable";
            }
            case 27392: {
                return "Unknown parameter in command - Protocol task ID and command are right, but parameter is invalid.";
            }
            case 27648: {
                return "Unknown parameter in command \u2013 Protocol task ID and command are right, but length is out of the requirement.";
            }
            case 27904: {
                return "Beeper Control Error.";
            }
            case 27905: {
                return "LED Control Error.";
            }
            case 27920: {
                return "ICC Reading Function Disabled (Do Not Support ICC related reading characteristics commands).";
            }
            case 27921: {
                return "MSR Reading Function Disabled (Do Not Support MSR related reading characteristics commands)";
            }
            case 29184: {
                return "Device is suspend (MKSK suspend or press password suspend).";
            }
            case 29440: {
                return "PIN DUKPT is STOP (21 bit 1).";
            }
            case 29696: {
                return "Device is Busy.";
            }
            case 30208: {
                return "Device is in Transparent Transmission mode";
            }
            case 57600: {
                return "Can not enter sleep mode";
            }
            case 57856: {
                return "File has existed";
            }
            case 58112: {
                return "File has not existed";
            }
            case 58131: {
                return "IO line low -- Card error after session start";
            }
            case 58368: {
                return "Open File Error";
            }
            case 58624: {
                return "SmartCard Error";
            }
            case 58880: {
                return "Get MSR Card data is error";
            }
            case 59136: {
                return "Command time out";
            }
            case 59392: {
                return "File read or write is error";
            }
            case 59648: {
                return "Active 1850 error!";
            }
            case 59904: {
                return "Load bootloader error";
            }
            case 61184: {
                return "Protocol Error- STX or ETX or check error.";
            }
            case 60160: {
                return "Picture is not exist";
            }
            case 11266: {
                return "No Microprocessor ICC seated";
            }
            case 11270: {
                return "no card seated to request ATR";
            }
            case 11521: {
                return "Card Not Supported,";
            }
            case 11523: {
                return "Card Not Supported, wants CRC";
            }
            case 26893: {
                return "Command not supported on reader without ICC support";
            }
            case 33024: {
                return "Timeout";
            }
            case 33280: {
                return "invalid TS character received - Wrong operation step";
            }
            case 33536: {
                return "Decode MSR Error";
            }
            case 33792: {
                return "TriMagII no Response";
            }
            case 34048: {
                return "No Swipe MSR Card";
            }
            case 34064: {
                return "No Financial Card";
            }
            case 34304: {
                return "Unsupported F, D, or combination of F and D";
            }
            case 34560: {
                return "protocol not supported EMV TD1 out of range";
            }
            case 34816: {
                return "power not at proper level";
            }
            case 35072: {
                return "ATR length too long";
            }
            case 35585: {
                return "EMV invalid TA1 byte value";
            }
            case 35586: {
                return "EMV TB1 required";
            }
            case 35587: {
                return "EMV Unsupported TB1 only 00 allowed";
            }
            case 35588: {
                return "EMV Card Error, invalid BWI or CWI";
            }
            case 35590: {
                return "EMV TB2 not allowed in ATR";
            }
            case 35591: {
                return "EMV TC2 out of range";
            }
            case 35592: {
                return "EMV TC2 out of range";
            }
            case 35593: {
                return "per EMV96 TA3 must be > 0xF";
            }
            case 35600: {
                return "ICC error on power-up";
            }
            case 35601: {
                return "EMV T=1 then TB3 required";
            }
            case 35602: {
                return "Card Error, invalid BWI or CWI";
            }
            case 35603: {
                return "Card Error, invalid BWI or CWI";
            }
            case 35607: {
                return "EMV TC1/TB3 conflict*";
            }
            case 35616: {
                return "EMV TD2 out of range must be T=1";
            }
            case 35840: {
                return "TCK error";
            }
            case 41732: {
                return "connector has no voltage setting";
            }
            case 41733: {
                return "ICC error on power-up invalid (SBLK(IFSD) exchange";
            }
            case 58113: {
                return "ICC error after session start";
            }
            case 65280: {
                return "Request to go online";
            }
            case 65281: {
                return "EMV: Accept the offline transaction";
            }
            case 65282: {
                return "EMV: Decline the offline transaction";
            }
            case 65283: {
                return "EMV: Accept the online transaction";
            }
            case 65284: {
                return "EMV: Decline the online transaction";
            }
            case 65285: {
                return "EMV: Application may fallback to magstripe technology";
            }
            case 65286: {
                return "EMV: ICC detected tah the conditions of use are not satisfied";
            }
            case 65287: {
                return "EMV: ICC didn't accept transaction";
            }
            case 65288: {
                return "EMV: Transaction was cancelled";
            }
            case 65289: {
                return "EMV: Application was not selected by kernel or ICC format error or ICC missing data error";
            }
            case 65290: {
                return "EMV: Transaction is terminated";
            }
            case 65291: {
                return "EMV: Other EMV Error";
            }
            case 65535: {
                return "NO RESPONSE";
            }
            case 61442: {
                return "ICC communication timeout";
            }
            case 61443: {
                return "ICC communication Error";
            }
            case 61445: {
                return "ICC Encrypted C - APDU Data Structure Length Error Or Format Error.";
            }
            case 61455: {
                return "ICC Card Seated and Highest Priority, disable MSR work request";
            }
            case 61967: {
                return "No Financial Card";
            }
            case 61968: {
                return "In Encrypt Result state, TLV total Length is greater than Max Length";
            }
            case 61969: {
                return "ICC L2 is not in idle state.";
            }
            case 61970: {
                return "Transaction Type Error.";
            }
            case 61971: {
                return "Major Config Error for Set Terminal Data.";
            }
            case 4097: {
                return "INVALID ARG";
            }
            case 4098: {
                return "FILE_OPEN_FAILED";
            }
            case 4099: {
                return "FILE OPERATION_FAILED";
            }
            case 8193: {
                return "MEMORY_NOT_ENOUGH";
            }
            case 12290: {
                return "SMARTCARD_FAIL";
            }
            case 12291: {
                return "SMARTCARD_INIT_FAILED";
            }
            case 12292: {
                return "FALLBACK_SITUATION";
            }
            case 12293: {
                return "SMARTCARD_ABSENT";
            }
            case 12294: {
                return "SMARTCARD_TIMEOUT";
            }
            case 20481: {
                return "EMV_PARSING_TAGS_FAILED";
            }
            case 20482: {
                return "EMV_DUPLICATE_CARD_DATA_ELEMENT";
            }
            case 20483: {
                return "EMV_DATA_FORMAT_INCORRECT";
            }
            case 20484: {
                return "EMV_NO_TERM_APP";
            }
            case 20485: {
                return "EMV_NO_MATCHING_APP";
            }
            case 20486: {
                return "EMV_MISSING_MANDATORY_OBJECT";
            }
            case 20487: {
                return "EMV_APP_SELECTION_RETRY";
            }
            case 20488: {
                return "EMV_GET_AMOUNT_ERROR";
            }
            case 20489: {
                return "EMV_CARD_REJECTED";
            }
            case 20496: {
                return "EMV_AIP_NOT_RECEIVED";
            }
            case 20497: {
                return "EMV_AFL_NOT_RECEIVED";
            }
            case 20498: {
                return "EMV_AFL_LEN_OUT_OF_RANGE";
            }
            case 20499: {
                return "EMV_SFI_OUT_OF_RANGE";
            }
            case 20500: {
                return "EMV_AFL_INCORRECT";
            }
            case 20501: {
                return "EMV_EXP_DATE_INCORRECT";
            }
            case 20502: {
                return "EMV_EFF_DATE_INCORRECT";
            }
            case 20503: {
                return "EMV_ISS_COD_TBL_OUT_OF_RANGE";
            }
            case 20504: {
                return "EMV_CRYPTOGRAM_TYPE_INCORRECT";
            }
            case 20505: {
                return "EMV_PSE_NOT_SUPPORTED_BY_CARD";
            }
            case 20512: {
                return "EMV_USER_SELECTED_LANGUAGE";
            }
            case 20513: {
                return "EMV_SERVICE_NOT_ALLOWED";
            }
            case 20514: {
                return "EMV_NO_TAG_FOUND";
            }
            case 20515: {
                return "EMV_CARD_BLOCKED";
            }
            case 20516: {
                return "EMV_LEN_INCORRECT";
            }
            case 20517: {
                return "CARD_COM_ERROR";
            }
            case 20518: {
                return "EMV_TSC_NOT_INCREASED";
            }
            case 20519: {
                return "EMV_HASH_INCORRECT";
            }
            case 20520: {
                return "EMV_NO_ARC";
            }
            case 20521: {
                return "EMV_INVALID_ARC";
            }
            case 20528: {
                return "If EMV transaction, terminated because no online comm. Otherwise Firmware error Timeout Workstate 1";
            }
            case 20529: {
                return "If EMV transaction, terminated because trans type incorrect. Otherwise Firmware error Timeout Workstate 2";
            }
            case 20530: {
                return "If EMV transaction, terminated because no app support. Otherwise Firmware Data Error";
            }
            case 20532: {
                return "If EMV transaction, terminated because Language not selected. Otherwise Firmware error Application Version Error";
            }
            case 20533: {
                return "If EMV transaction, terminated because Terminal Data Missing. Otherwise Firmware Flash Error";
            }
            case 20534: {
                return "IF EMV transaction, terminated because Blocked AID encountered. Otherwise Firmware Check value error";
            }
            case 20535: {
                return "RETURN_CODE_FW_DEVICE_NAME_ERROR";
            }
            case 20536: {
                return "RETURN_CODE_FW_ENCRYPTION_MODE_ERROR";
            }
            case 20537: {
                return "RETURN_CODE_FW_FIRMWARE_ADDRESS_ERROR";
            }
            case 24577: {
                return "CVM_TYPE_UNKNOWN";
            }
            case 24578: {
                return "CVM_AIP_NOT_SUPPORTED";
            }
            case 24579: {
                return "CVM_TAG_8E_MISSING";
            }
            case 24580: {
                return "CVM_TAG_8E_FORMAT_ERROR";
            }
            case 24581: {
                return "CVM_CODE_IS_NOT_SUPPORTED";
            }
            case 24582: {
                return "CVM_COND_CODE_IS_NOT_SUPPORTED";
            }
            case 24583: {
                return "NO_MORE_CVM";
            }
            case 24584: {
                return "PIN_BYPASSED_BEFORE";
            }
            case 28673: {
                return "PK_BUFFER_SIZE_TOO_BIG";
            }
            case 28674: {
                return "PK_FILE_WRITE_ERROR";
            }
            case 28675: {
                return "PK_HASH_ERROR";
            }
            case 29952: {
                return "FW Self-Test Failed(De - active Device)";
            }
            case 29953: {
                return "TTK Self -Test \u2013 No MTK Key or No Key";
            }
            case 29954: {
                return "TTK Self -Test \u2013 MTK Key Stop or Key Stop";
            }
            case 29955: {
                return "TTK Self -Test \u2013 No EMV L2 Configuration Data";
            }
            case 29956: {
                return "TTK Self -Test \u2013 EMV L2 Configuration Check Value Failed (De - active Device)";
            }
            case 29957: {
                return "TTK Self -Test \u2013 Future Key Check Value Failed(De - active Device)";
            }
            case 29958: {
                return "TTK Self -Test \u2013 MTK Key Update Error";
            }
            case 29968: {
                return "TTK Self-Test \u2013 MTK Key manage error";
            }
            case 29969: {
                return "TTK Self-Test \u2013 No EMV L2 Configuration Data \u2013 Terminal Data";
            }
            case 29970: {
                return "TTK Self-Test \u2013 No EMV L2 Configuration Data \u2013 Application Data";
            }
            case 29971: {
                return "TTK Self-Test \u2013 No EMV L2 Configuration Data \u2013 CA Public Key";
            }
            case 29972: {
                return "TTK Self-Test \u2013 No EMV L2 Configuration Data \u2013 CRL";
            }
            case 29973: {
                return "TTK Self-Test \u2013 Error EMV L2 Configuration Data";
            }
            case 29974: {
                return "TTK Self-Test \u2013 Future Key Check Value Failed(De - active Device)";
            }
            case 32752: {
                return "Server returned a HTTP error condition on Authorize";
            }
            case 32753: {
                return "Server returned a HTTP error condition on Step 1";
            }
            case 32754: {
                return "Server returned a HTTP error condition on Step 2";
            }
            case 32755: {
                return "Server returned a HTTP error condition on Step 3";
            }
            case 32769: {
                return "Authorization: Cannot initialize RKI; no customer/ key information found";
            }
            case 33025: {
                return "Step 1: No key injection established";
            }
            case 33026: {
                return "Step 1: Failed to encrypt challenge";
            }
            case 33027: {
                return "Step 1: challenge length is incorrect";
            }
            case 33028: {
                return "Step 1: Incorrect challenge data";
            }
            case 33029: {
                return "Step 1: Response length incorrect";
            }
            case 33030: {
                return "Step 1: Firmware responded NAK for Step 1";
            }
            case 33031: {
                return "Step 1: Admin key not found fdor Step 1";
            }
            case 33281: {
                return "Step 2: Customer key id could not be found in the DB";
            }
            case 33282: {
                return "Step 2: Key Slot does not exist";
            }
            case 33283: {
                return "Step 2: Could not get the future KSI from the server";
            }
            case 33284: {
                return "Step 2: Could not get TR31 data block";
            }
            case 33285: {
                return "Step 2: TR31 block length is incorrect";
            }
            case 33286: {
                return "Step 2: Incorrect challenge data";
            }
            case 33287: {
                return "Step 2: Firmware responded NAK for Step 2";
            }
            case 33537: {
                return "Step 3: No key injection record found";
            }
            case 33538: {
                return "Step 3: Remote Key Injection failed(NAK)";
            }
            case 33539: {
                return "Step 3: Incorrect response form";
            }
            case 33540: {
                return "Step 3: Firmware responded NAK for Step 3";
            }
            case 32770: {
                return "GET_ONLINE_PIN";
            }
            case 53248: {
                return "Data not exist";
            }
            case 53249: {
                return "Data access error";
            }
            case 53504: {
                return "RID not exist";
            }
            case 53505: {
                return "RID existed";
            }
            case 53506: {
                return "Index not exist";
            }
            case 53760: {
                return "Maximum exceeded";
            }
            case 53761: {
                return "Hash error";
            }
            case 53765: {
                return "System Busy";
            }
            case 3585: {
                return "Unable to go online";
            }
            case 3586: {
                return "Technical Issue";
            }
            case 3587: {
                return "Declined";
            }
            case 3588: {
                return "Issuer Referral transaction";
            }
            case 3841: {
                return "Decline the online transaction";
            }
            case 3842: {
                return "Request to go online";
            }
            case 3843: {
                return "Transaction is terminated";
            }
            case 3845: {
                return "Application was not selected by kernel or ICC format error or ICC missing data error";
            }
            case 3847: {
                return "ICC didn't accept transaction";
            }
            case 3850: {
                return "Application may fallback to magstripe technology";
            }
            case 3852: {
                return "Transaction was cancelled";
            }
            case 3853: {
                return "Timeout";
            }
            case 3855: {
                return "Other EMV Error";
            }
            case 3856: {
                return "Accept the offline transaction";
            }
            case 3857: {
                return "Decline the offline transaction";
            }
            case 3873: {
                return "ICC detected tah the conditions of use are not satisfied";
            }
            case 3874: {
                return "No app were found on card matching terminal configuration";
            }
            case 3875: {
                return "Terminal file does not exist";
            }
            case 3876: {
                return "CAPK file does not exist";
            }
            case 3877: {
                return "CRL Entry does not exist";
            }
            case 4094: {
                return "Return code when blocking is disabled";
            }
            case 4095: {
                return "Return code when command is not applicable on the selected device";
            }
            case 48096: {
                return "CM100 Success";
            }
            case 48097: {
                return "CM100 Parameter Error";
            }
            case 48098: {
                return "CM100 Low Output Buffer";
            }
            case 48099: {
                return "CM100 Card Not Found";
            }
            case 48100: {
                return "CM100 Collision Card Exists";
            }
            case 48101: {
                return "CM100 Too Many Cards Exist";
            }
            case 48102: {
                return "CM100 Saved Data Does Not Exist";
            }
            case 48104: {
                return "CM100 No Data Available";
            }
            case 48105: {
                return "CM100 Invalid CID Returned";
            }
            case 48106: {
                return "CM100 Invalid Card Exists";
            }
            case 48108: {
                return "CM100 Command Unsupported";
            }
            case 48109: {
                return "CM100 Error In Command Process";
            }
            case 48110: {
                return "CM100 Invalid Command";
            }
            case 36913: {
                return "Unknown command";
            }
            case 36914: {
                return "Wrong parameter (such as the length of the command is incorrect)";
            }
            case 36920: {
                return "Wait (the command couldn\u2019t be finished in BWT)";
            }
            case 36921: {
                return "Busy (a previously command has not been finished)";
            }
            case 36922: {
                return "Number of retries over limit";
            }
            case 36928: {
                return "Invalid Manufacturing system data";
            }
            case 36929: {
                return "Not authenticated";
            }
            case 36930: {
                return "Invalid Master DUKPT Key";
            }
            case 36931: {
                return "Invalid MAC Key";
            }
            case 36932: {
                return "Reserved for future use";
            }
            case 36933: {
                return "Reserved for future use";
            }
            case 36934: {
                return "Invalid DATA DUKPT Key";
            }
            case 36935: {
                return "Invalid PIN Pairing DUKPT Key";
            }
            case 36936: {
                return "Invalid DATA Pairing DUKPT Key";
            }
            case 36937: {
                return "No nonce generated";
            }
            case 39241: {
                return "No GUID available.  Perform getVersion first.";
            }
            case 39248: {
                return "MAC Calculation unsuccessful. Check BDK value.";
            }
            case 36938: {
                return "Not ready";
            }
            case 36939: {
                return "not MAC Data";
            }
            case 36944: {
                return "Invalid Certificate";
            }
            case 36945: {
                return "Duplicate key detected";
            }
            case 36946: {
                return "AT checks failed";
            }
            case 36947: {
                return "TR34 checks failed";
            }
            case 36948: {
                return "TR31 checks failed";
            }
            case 36949: {
                return "MAC checks failed";
            }
            case 36950: {
                return "Firmware download failed";
            }
            case 36951: {
                return "LCL - KEK exists";
            }
            case 36960: {
                return "Log is full";
            }
            case 36961: {
                return "Removal sensor unengaged";
            }
            case 36962: {
                return "Any hardware problems";
            }
            case 36976: {
                return "ICC communication timeout";
            }
            case 36977: {
                return "ICC data error (such check sum error)";
            }
            case 36978: {
                return "Smart Card not powered up";
            }
            case 61952: {
                return "No AID or No Application Data";
            }
            case 61953: {
                return "No Terminal Data";
            }
            case 61954: {
                return "Wrong TLV format";
            }
            case 61955: {
                return "AID list is full, maxim is 16";
            }
            case 61956: {
                return "No any CA Key";
            }
            case 61957: {
                return "No CA Key  RID";
            }
            case 61958: {
                return "No CA Key  Index";
            }
            case 61959: {
                return "CA Key  list is full, maxim is 96";
            }
            case 61960: {
                return "Wrong CA Key hash";
            }
            case 61961: {
                return "Wrong Transaction Command Format";
            }
            case 61962: {
                return "Unexpected Command";
            }
            case 61963: {
                return "No CRL";
            }
            case 61964: {
                return "CRL list is full, maxim is 30";
            }
            case 61965: {
                return "No amount, other amount and transaction type in Transaction Command";
            }
            case 61966: {
                return "Wrong CA Hash and Encryption algorithm";
            }
            case 7169: {
                return "RKI could not retrieve device serial number";
            }
            case 7170: {
                return "RKI could not retrieve device firmware version";
            }
            case 7171: {
                return "RKI failed on Step 1: Authenticate a RKI with Server";
            }
            case 7172: {
                return "RKI failed on Step 2: Initiate  RKI with Server";
            }
            case 7173: {
                return "RKI failed on Step 3: Request Key Pair";
            }
            case 9216: {
                return "Cannot retrieve device serial number in RKI update";
            }
            case 9217: {
                return "Cannot retrieve device certificates in RKI update";
            }
            case 9218: {
                return "Starting RKI Update Process";
            }
            case 9219: {
                return "Cannot retrieve key device group in RKI update";
            }
            case 9220: {
                return "PEDI Command failed in RKI Update";
            }
            case 9221: {
                return "Invalid RSA Signature in RKI Update";
            }
            case 9222: {
                return "PEDK Command failed in RKI Update";
            }
            case 9223: {
                return "PEDK Command failed setting keys in RKI Update";
            }
            case 9224: {
                return "PEDV Command failed in RKI Update";
            }
            case 9225: {
                return "PEDV Command failed verifying keys in RKI Update";
            }
            case 9226: {
                return "Completed RKI Update Process";
            }
            case 9227: {
                return "Completed RKI Update Process. More keys available.";
            }
            case 9228: {
                return "Error ending secure task.";
            }
            case 9229: {
                return "Unknown Failure.";
            }
            case 9230: {
                return "Failed on device key request, symmetric RKI.";
            }
            case 9231: {
                return "Failed to get keys from the server, symmetric RKI.";
            }
            case 9232: {
                return "Failed on device to set key, symmetric RKI.";
            }
            case 9233: {
                return "Failed to validate key with server, symmetric RKI.";
            }
            case 9234: {
                return "Error starting secure task.";
            }
            case 61096: {
                return "Mifare Card.";
            }
            case 61097: {
                return "VAS and Payment.";
            }
            case 61098: {
                return "Payment OK VAS Fail.";
            }
        }
        return "";
    }

    public static class WorldPayData {
        public MARKET_CODE marketCode = MARKET_CODE.MARKET_CODE_RETAIL;
        public String referenceNumber = "";
        public String ticketNumber = "";
        public String terminalID = "01";
        public String amount = "";
        public String cardData = "";
        public String accountID = "";
        public String accountToken = "";
        public String acceptorID = "";
        public TERMINAL_ENVIRONMENT_CODE_TYPE terminalEnvironmentCode = TERMINAL_ENVIRONMENT_CODE_TYPE.TERMINAL_ENVIRONMENT_CODE_LOCAL_UNATTENDED;
        public TERMINAL_TYPE terminalType = TERMINAL_TYPE.TERMINAL_TYPE_POINT_OF_SALE;
        public TERMINAL_CAPABILITY_CODE terminalCapabilityCode = TERMINAL_CAPABILITY_CODE.TERMINAL_CAPABILITY_CODE_CONTACTLESS_CHIP_READER;
        public CARD_PRESENT_CODE cardPresentCode = CARD_PRESENT_CODE.CARD_PRESENT_CODE_PRESENT;
        public CARD_HOLDER_PRESENT_CODE cardHolderPresent = CARD_HOLDER_PRESENT_CODE.CARD_HOLDER_PRESENT_CODE_PRESENT;
        public CARD_INPUT_CODE cardInputCode = CARD_INPUT_CODE.CARD_INPUT_CODE_CHIP_READ;
        public String originalAmount = "0.00";
        public String transactionID = "";
        public String salesTax = "0.00";
        public String tip = "0.00";
        public String cashBack = "0.00";
        public TRANSACTION_TYPE transactionType = TRANSACTION_TYPE.TRANSACTION_TYPE_SALE;
        public boolean isTest = false;
        public boolean msrOnly = false;
        public int timeout = 30;
        public boolean duplicateCheckDisable = false;
        public boolean duplicateOverride = false;
        public boolean enableCTLS = false;
        public boolean declinePartial = false;
        public String emvData = "";
        public String emvDataKSN = "";
        public String emvDataTrack2 = "";
        public String emvDataTrack1 = "";
        public String additionalTags = "";
        public String authAmount = "";
        public boolean storeTransaction = false;
        public String storagePassword = "";
        public String storageMemo = "";
        public String license = "";
        public String authReversal = "";
        public String tokenSubstitute = "";
        public String paymentAccountID = "";
        public String paymentAccountReferenceNumber = "";
        public boolean storeOnHostNetworkError = false;
    }

    public static class ReceiptData {
        public boolean isApproved = false;
        public String result = "";
        public String transID = "";
        public ENTRY_METHOD entryMethod = ENTRY_METHOD.ENTRY_METHOD_UNKNOWN;
        public String card = "";
        public String account = "";
        public String transType = "";
        public Date dateTime = new Date(System.currentTimeMillis());
        public String amount = "";
        public String aid = "";
        public String iad = "";
        public String authCode = "";
        public String cert = "";
        public String name = "";
        public CVM_TYPE cvm = CVM_TYPE.CVM_TYPE_UNKNOWN;
        public TRANSACTION_TYPE saleType = TRANSACTION_TYPE.TRANSACTION_TYPE_SALE;
        public String authReversal = "";
        public String tokenSubstitute = "";
    }

    public static enum TRANSACTION_TYPE {
        TRANSACTION_TYPE_SALE,
        TRANSACTION_TYPE_PRE_AUTH,
        TRANSACTION_TYPE_COMPLETION,
        TRANSACTION_TYPE_VOID,
        TRANSACTION_TYPE_RETURN,
        TRANSACTION_TYPE_CREDIT,
        TRANSACTION_TYPE_QUICK_CHIP_START,
        TRANSACTION_TYPE_QUICK_CHIP_FINISH,
        TRANSACTION_TYPE_REVERSAL_FULL,
        TRANSACTION_TYPE_REVERSAL_PARTIAL;

    }

    public static enum ENTRY_METHOD {
        ENTRY_METHOD_UNKNOWN,
        ENTRY_METHOD_SWIPE,
        ENTRY_METHOD_CONTACT,
        ENTRY_METHOD_CTLS;

    }

    public static enum CVM_TYPE {
        CVM_TYPE_UNKNOWN,
        CVM_TYPE_NO_CVM,
        CVM_TYPE_SIGNATURE;

    }

    public static enum MARKET_CODE {
        MARKET_CODE_DEFAULT,
        MARKET_CODE_AUTO_RENTAL,
        MARKET_CODE_DIRECT_MARKETING,
        MARKET_CODE_ECOMMERCE,
        MARKET_CODE_FOOD_RESTAURANT,
        MARKET_CODE_HOTEL_LODGING,
        MARKET_CODE_PETROLEUM,
        MARKET_CODE_RETAIL,
        MARKET_CODE_QSR,
        MARKET_CODE_GROCERY;

    }

    public static enum TERMINAL_TYPE {
        TERMINAL_TYPE_UNKNOWN,
        TERMINAL_TYPE_POINT_OF_SALE,
        TERMINAL_TYPE_ECOMMERCE,
        TERMINAL_TYPE_MOTO,
        TERMINAL_TYPE_FUEL_PUMP,
        TERMINAL_TYPE_ATM,
        TERMINAL_TYPE_VOICE;

    }

    public static enum TERMINAL_CAPABILITY_CODE {
        TERMINAL_CAPABILITY_CODE_DEFAULT,
        TERMINAL_CAPABILITY_CODE_UNKNOWN,
        TERMINAL_CAPABILITY_CODE_NO_TERMINAL,
        TERMINAL_CAPABILITY_CODE_MAGSRIPE_READER,
        TERMINAL_CAPABILITY_CODE_CONTACTLESS_MAGSTRIPE_READER,
        TERMINAL_CAPABILITY_CODE_KEY_ENTERED,
        TERMINAL_CAPABILITY_CODE_CHIP_READER,
        TERMINAL_CAPABILITY_CODE_CONTACTLESS_CHIP_READER;

    }

    public static enum TERMINAL_ENVIRONMENT_CODE_TYPE {
        TERMINAL_ENVIRONMENT_CODE_DEFAULT,
        TERMINAL_ENVIRONMENT_CODE_NO_TERMINAL,
        TERMINAL_ENVIRONMENT_CODE_LOCAL_ATTENDED,
        TERMINAL_ENVIRONMENT_CODE_LOCAL_UNATTENDED,
        TERMINAL_ENVIRONMENT_CODE_REMOTE_ATTENDED,
        TERMINAL_ENVIRONMENT_CODE_REMOTE_UNATTENDED,
        TERMINAL_ENVIRONMENT_CODE_ECOMMERCE;

    }

    public static enum CARD_PRESENT_CODE {
        CARD_PRESENT_CODE_DEFAULT,
        CARD_PRESENT_CODE_UNKNOWN,
        CARD_PRESENT_CODE_PRESENT,
        CARD_PRESENT_CODE_NOT_PRESENT;

    }

    public static enum CARD_INPUT_CODE {
        CARD_INPUT_CODE_DEFAULT,
        CARD_INPUT_CODE_UNKNOWN,
        CARD_INPUT_CODE_MAGSTRIPE_READ,
        CARD_INPUT_CODE_CONTACTLESS_MAGSTRIPE_READ,
        CARD_INPUT_CODE_MANUAL_KEYED,
        CARD_INPUT_CODE_MANUAL_KEYED_MAGSTRIPE_FAILURE,
        CARD_INPUT_CODE_CHIP_READ,
        CARD_INPUT_CODE_CONTACTLESS_CHIP_READ,
        CARD_INPUT_CODE_MANUAL_KEYED_CHIP_READ_FAILURE,
        CARD_INPUT_CODE_MAGSTRIPE_READ_CHIP_READ_FAILURE,
        CARD_INPUT_CODE_MAGSTRIPE_READ_NON_TECHNICAL_FALLBACK;

    }

    public static enum CARD_HOLDER_PRESENT_CODE {
        CARD_HOLDER_PRESENT_CODE_DEFAULT,
        CARD_HOLDER_PRESENT_CODE_UNKNOWN,
        CARD_HOLDER_PRESENT_CODE_PRESENT,
        CARD_HOLDER_PRESENT_CODE_NOT_PRESENT,
        CARD_HOLDER_PRESENT_CODE_MAIL_ORDER,
        CARD_HOLDER_PRESENT_CODE_PHONE_ORDER,
        CARD_HOLDER_PRESENT_CODE_STANDING_AUTH,
        CARD_HOLDER_PRESENT_CODE_ECOMMERCE;

    }
}

