/*
 * Decompiled with CFR 0.152.
 */
package com.idtechproducts.device.audiojack.config;

import android.content.Context;
import android.os.Build;
import com.idtechproducts.device.Common;
import com.idtechproducts.device.OnReceiverListener;
import com.idtechproducts.device.StructConfigParameters;
import com.idtechproducts.device.audiojack.config.UmXmlParser;
import java.io.File;
import java.util.Locale;

public final class UniMagConfigHelper {
    private StructConfigParameters myConfigParams;
    private String _strFileName = null;
    private final String _strManufacture;
    private final String _strMP;
    private final int SDKMajorVersion;
    private final int SDKMinorVersion;
    private int XMLBuildVersion_FromXML = 0;
    private String _concatenatedXmlVersion;
    private final OnReceiverListener _cbMagReaderMsg;
    private final Context mContext;

    public UniMagConfigHelper(OnReceiverListener _callback, Context ctx, int majorVer, int minorVer) {
        this._cbMagReaderMsg = _callback;
        this.mContext = ctx;
        this.SDKMajorVersion = majorVer;
        this.SDKMinorVersion = minorVer;
        String temp = Build.MANUFACTURER;
        this._strManufacture = temp = temp.toLowerCase(Locale.ENGLISH).replaceAll("\\s*", "");
        temp = Build.MODEL;
        this._strMP = temp = temp.toLowerCase(Locale.ENGLISH).replaceAll("\\s*", "");
    }

    public void setPathFileName(String strFileName) {
        this._strFileName = strFileName;
    }

    public String getManufacture() {
        return this._strManufacture;
    }

    public String getModel() {
        return this._strMP;
    }

    public StructConfigParameters getConfigParams() {
        return this.myConfigParams;
    }

    public boolean loadingXMLFile(boolean bAuto) {
        if (this._strFileName == null && !bAuto) {
            this._cbMagReaderMsg.LoadXMLConfigFailureInfo(2, "Wrong XML file name, please set the filename or enable the auto update.");
            return false;
        }
        return this.loadingXMLFile(this._strFileName, bAuto);
    }

    public String getLoadedXmlVersion() {
        return this._concatenatedXmlVersion;
    }

    private boolean downloadXMLFile() {
        return false;
    }

    private boolean tryToReadXML(String strXMLFileName) {
        return true;
    }

    private boolean loadingXMLFile(String strXMLFileNameWithPath, boolean bAuto) {
        UmXmlParser.UMXmlParseResult r;
        boolean bReadyToReadXML = false;
        if (Common.isFileExist(strXMLFileNameWithPath)) {
            bReadyToReadXML = this.tryToReadXML(strXMLFileNameWithPath);
            if (bReadyToReadXML) {
                r = UmXmlParser.parseFile(strXMLFileNameWithPath, this._strManufacture, this._strMP, false);
                if (this.ReadXMLCfgByModel(r)) {
                    return true;
                }
                bReadyToReadXML = false;
            }
        } else if (!bAuto) {
            this._cbMagReaderMsg.LoadXMLConfigFailureInfo(3, "The XML file does not exist and the auto update disabled.");
            return false;
        }
        if (!bReadyToReadXML) {
            String strTmpFileName;
            if (Common.isStorageExist()) {
                strTmpFileName = Common.getSDRootFilePath() + File.separator + "IDT_uniMagCfg" + this.SDKMajorVersion + "." + this.SDKMinorVersion + ".xml";
                if (Common.isFileExist(strTmpFileName) && (bReadyToReadXML = this.tryToReadXML(strTmpFileName))) {
                    strXMLFileNameWithPath = strTmpFileName;
                }
            } else {
                strTmpFileName = Common.getApplicationPath(this.mContext) + File.separator + "IDT_uniMagCfg" + this.SDKMajorVersion + "." + this.SDKMinorVersion + ".xml";
                if (Common.isFileExist(strTmpFileName) && (bReadyToReadXML = this.tryToReadXML(strTmpFileName))) {
                    strXMLFileNameWithPath = strTmpFileName;
                }
            }
        }
        if (bReadyToReadXML) {
            r = UmXmlParser.parseFile(strXMLFileNameWithPath, this._strManufacture, this._strMP, false);
            if (this.ReadXMLCfgByModel(r)) {
                return true;
            }
            boolean bAutoUpdate = false;
            if (bAutoUpdate) {
                return this.downloadXMLFile();
            }
        } else {
            if (!bAuto) {
                boolean bAutoUpdate = false;
                if (!bAutoUpdate) {
                    return false;
                }
                return this.downloadXMLFile();
            }
            return this.downloadXMLFile();
        }
        return false;
    }

    private boolean ReadXMLCfgByModel(UmXmlParser.UMXmlParseResult r) {
        if (r.config == null) {
            return false;
        }
        this.myConfigParams = r.config;
        this._concatenatedXmlVersion = r.SDKMajorVersion != null && r.SDKMinorVersion != null && r.XMLVersion != null ? r.SDKMajorVersion + "." + r.SDKMinorVersion + "." + r.XMLVersion : "";
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean loadingXMLFileAfterDownload(String strXMLFileNameWithPath) {
        boolean bReadyToReadXML = false;
        if (Common.isFileExist(strXMLFileNameWithPath)) {
            bReadyToReadXML = this.tryToReadXML(strXMLFileNameWithPath);
        }
        if (bReadyToReadXML) {
            UmXmlParser.UMXmlParseResult r = UmXmlParser.parseFile(strXMLFileNameWithPath, this._strManufacture, this._strMP, false);
            if (this.ReadXMLCfgByModel(r)) {
                return true;
            }
            this._cbMagReaderMsg.LoadXMLConfigFailureInfo(1, "This phone model is not supported by the current SDK. Please contact supporter for assistance.");
            return false;
        }
        this._cbMagReaderMsg.LoadXMLConfigFailureInfo(1, "This phone model is not supported by the current SDK. Please contact supporter for assistance.");
        return false;
    }

    private String getXMLVersionInfo() {
        return this.SDKMajorVersion + "." + this.SDKMinorVersion + "." + this.XMLBuildVersion_FromXML;
    }
}

