/*
 * Decompiled with CFR 0.152.
 */
package com.idtechproducts.device.audiojack.io;

import com.idtechproducts.device.audiojack.io.CommandManageUARTWaveform;

public class CommandManageUARTWaveform24K
extends CommandManageUARTWaveform {
    byte[] peak2idleSmooth = new byte[4];
    byte[] valley2idelSmooth = new byte[4];
    byte[] idle2peakSmooth = new byte[4];
    byte[] idel2valleySmooth = new byte[4];
    byte[] smooth = new byte[8];
    byte[] smoothFromIdle = new byte[8];
    byte[] lineFrame = new byte[]{-128, -128};
    byte[] idleLineFrame = new byte[]{-128, -128, -128, -128};
    byte[] negativeFrame = new byte[]{1, -1, 1, -1};
    byte[] positiveFrame = new byte[]{-1, 1, -1, 1};
    byte[] startFrame = new byte[]{-128, -128, 1, -1, 1, -1};
    byte[] stopFrame = new byte[]{-1, 1, -1, 1};

    @Override
    public void adjustDirection(int directionOutput) {
        this.peak2idleSmooth[0] = -34;
        this.peak2idleSmooth[1] = -66;
        this.peak2idleSmooth[2] = -98;
        this.peak2idleSmooth[3] = -117;
        this.valley2idelSmooth[0] = 12;
        this.valley2idelSmooth[1] = 31;
        this.valley2idelSmooth[2] = 63;
        this.valley2idelSmooth[3] = 95;
        this.idle2peakSmooth[3] = -34;
        this.idle2peakSmooth[2] = -66;
        this.idle2peakSmooth[1] = -98;
        this.idle2peakSmooth[0] = -117;
        this.idel2valleySmooth[3] = 12;
        this.idel2valleySmooth[2] = 31;
        this.idel2valleySmooth[1] = 63;
        this.idel2valleySmooth[0] = 95;
        if (directionOutput == 1) {
            this.positiveFrame[0] = 1;
            this.positiveFrame[1] = -1;
            this.positiveFrame[2] = 1;
            this.positiveFrame[3] = -1;
            this.negativeFrame[0] = -1;
            this.negativeFrame[1] = 1;
            this.negativeFrame[2] = -1;
            this.negativeFrame[3] = 1;
            this.startFrame[0] = -128;
            this.startFrame[1] = -128;
            this.startFrame[2] = -1;
            this.startFrame[3] = 1;
            this.startFrame[4] = -1;
            this.startFrame[5] = 1;
            this.stopFrame[0] = 1;
            this.stopFrame[1] = -1;
            this.stopFrame[2] = 1;
            this.stopFrame[3] = -1;
            this.smooth[0] = this.valley2idelSmooth[0];
            this.smooth[1] = this.peak2idleSmooth[0];
            this.smooth[2] = this.valley2idelSmooth[1];
            this.smooth[3] = this.peak2idleSmooth[1];
            this.smooth[4] = this.valley2idelSmooth[2];
            this.smooth[5] = this.peak2idleSmooth[2];
            this.smooth[6] = this.valley2idelSmooth[3];
            this.smooth[7] = this.peak2idleSmooth[3];
            this.smoothFromIdle[0] = this.idle2peakSmooth[0];
            this.smoothFromIdle[1] = this.idel2valleySmooth[0];
            this.smoothFromIdle[2] = this.idle2peakSmooth[1];
            this.smoothFromIdle[3] = this.idel2valleySmooth[1];
            this.smoothFromIdle[4] = this.idle2peakSmooth[2];
            this.smoothFromIdle[5] = this.idel2valleySmooth[2];
            this.smoothFromIdle[6] = this.idle2peakSmooth[3];
            this.smoothFromIdle[7] = this.idel2valleySmooth[3];
        } else if (directionOutput == 0) {
            this.positiveFrame[0] = -1;
            this.positiveFrame[1] = 1;
            this.positiveFrame[2] = -1;
            this.positiveFrame[3] = 1;
            this.negativeFrame[0] = 1;
            this.negativeFrame[1] = -1;
            this.negativeFrame[2] = 1;
            this.negativeFrame[3] = -1;
            this.stopFrame[0] = -1;
            this.stopFrame[1] = 1;
            this.stopFrame[2] = -1;
            this.stopFrame[3] = 1;
            this.startFrame[0] = -128;
            this.startFrame[1] = -128;
            this.startFrame[2] = 1;
            this.startFrame[3] = -1;
            this.startFrame[4] = 1;
            this.startFrame[5] = -1;
            this.smooth[0] = this.peak2idleSmooth[0];
            this.smooth[1] = this.valley2idelSmooth[0];
            this.smooth[2] = this.peak2idleSmooth[1];
            this.smooth[3] = this.valley2idelSmooth[1];
            this.smooth[4] = this.peak2idleSmooth[2];
            this.smooth[5] = this.valley2idelSmooth[2];
            this.smooth[6] = this.peak2idleSmooth[3];
            this.smooth[7] = this.valley2idelSmooth[3];
            this.smoothFromIdle[0] = this.idel2valleySmooth[0];
            this.smoothFromIdle[1] = this.idle2peakSmooth[0];
            this.smoothFromIdle[2] = this.idel2valleySmooth[1];
            this.smoothFromIdle[3] = this.idle2peakSmooth[1];
            this.smoothFromIdle[4] = this.idel2valleySmooth[2];
            this.smoothFromIdle[5] = this.idle2peakSmooth[2];
            this.smoothFromIdle[6] = this.idel2valleySmooth[3];
            this.smoothFromIdle[7] = this.idle2peakSmooth[3];
        }
    }

    @Override
    public byte[] getWaveBufferDataByFlag(byte halfByte) {
        int writePos = 0;
        byte[] realBuffer = null;
        byte flag = (byte)(halfByte >> 4 & 0xF);
        switch (flag) {
            case 0: {
                realBuffer = null;
                realBuffer = new byte[50];
                System.arraycopy(this.startFrame, 0, realBuffer, writePos, this.startFrame.length);
                writePos += this.startFrame.length;
                byte oneBit = 0;
                byte fourBits = halfByte;
                for (int i = 0; i < 4; ++i) {
                    oneBit = (byte)(fourBits & 1);
                    if (oneBit == 0) {
                        System.arraycopy(this.positiveFrame, 0, realBuffer, writePos, this.positiveFrame.length);
                        System.arraycopy(this.lineFrame, 0, realBuffer, writePos += this.positiveFrame.length, this.lineFrame.length);
                        System.arraycopy(this.negativeFrame, 0, realBuffer, writePos += this.lineFrame.length, this.negativeFrame.length);
                        writePos += this.negativeFrame.length;
                    } else {
                        System.arraycopy(this.negativeFrame, 0, realBuffer, writePos, this.negativeFrame.length);
                        System.arraycopy(this.lineFrame, 0, realBuffer, writePos += this.negativeFrame.length, this.lineFrame.length);
                        System.arraycopy(this.positiveFrame, 0, realBuffer, writePos += this.lineFrame.length, this.positiveFrame.length);
                        writePos += this.positiveFrame.length;
                    }
                    fourBits = (byte)(halfByte >> 1 + i);
                }
                System.arraycopy(this.stopFrame, 0, realBuffer, writePos, this.stopFrame.length);
                writePos += this.stopFrame.length;
                break;
            }
            case 15: {
                realBuffer = null;
                realBuffer = new byte[this.positiveFrame.length];
                writePos = 0;
                for (int i = 0; i < 1; ++i) {
                    System.arraycopy(this.positiveFrame, 0, realBuffer, writePos, this.positiveFrame.length);
                    writePos += this.positiveFrame.length;
                }
                break;
            }
            case 7: {
                realBuffer = null;
                realBuffer = new byte[this.idleLineFrame.length];
                writePos = 0;
                for (int i = 0; i < 1; ++i) {
                    System.arraycopy(this.idleLineFrame, 0, realBuffer, writePos, this.idleLineFrame.length);
                    writePos += this.idleLineFrame.length;
                }
                break;
            }
            case 6: {
                realBuffer = null;
                realBuffer = new byte[this.smooth.length];
                writePos = 0;
                for (int i = 0; i < 1; ++i) {
                    System.arraycopy(this.smooth, 0, realBuffer, writePos, this.smooth.length);
                    writePos += this.smooth.length;
                }
                break;
            }
            case 5: {
                realBuffer = null;
                realBuffer = new byte[this.smoothFromIdle.length];
                writePos = 0;
                for (int i = 0; i < 1; ++i) {
                    System.arraycopy(this.smoothFromIdle, 0, realBuffer, writePos, this.smoothFromIdle.length);
                    writePos += this.smoothFromIdle.length;
                }
                break;
            }
            default: {
                return null;
            }
        }
        return realBuffer;
    }
}

