/*
 * Decompiled with CFR 0.152.
 */
package com.idtechproducts.device.audiojack.io;

import android.media.AudioTrack;
import com.idtechproducts.device.Common;
import com.idtechproducts.device.StructConfigParameters;
import com.idtechproducts.device.audiojack.io.PlayerAudioTrack;

public class FreqCommPlayerAudioTrack
extends PlayerAudioTrack {
    static final int kAUDIO_CHANNEL = 12;
    static final int kAUDIO_ENCODING = 3;
    private static final int kFRAME_SIZE = 2;
    private static final int[] kQIT_PERIOD_FREQ = new int[]{2400, 3000, 3400, 4000};
    private static byte[][] cachedFskChunk;
    private static int cachedFskChunk_freq;
    private static int cachedFskChunk_dir;

    @Override
    public AudioTrack getCommandAudioTrack(byte[] commandString) {
        byte[] toneData;
        AudioTrack ret;
        int outputFreq = this.config.getFrequenceOutput();
        int[] ret_loopFrameIndex = new int[2];
        if (this.config.getPowerupLastBeforeCMD() < 500) {
            this.config.setPowerupLastBeforeCMD((short)500);
        }
        if ((ret = new AudioTrack(3, outputFreq, 12, 3, (toneData = FreqCommPlayerAudioTrack.synthesizeCommandString(this.config, commandString, outputFreq, ret_loopFrameIndex)).length, 0)).write(toneData, 0, toneData.length) != toneData.length) {
            ret.release();
            throw new RuntimeException();
        }
        if (ret.getState() != 1) {
            throw new RuntimeException();
        }
        return ret;
    }

    private static byte[] synthesizeCommandString(StructConfigParameters config, byte[] command_string, int playbackFrequency, int[] ret_loopFrameIndex) {
        byte qit;
        int i;
        Object qperiod;
        int K_before = 18 * config.getPowerupLastBeforeCMD() / 10;
        int K_after = 12000;
        byte[] ecm_single = new byte[]{-1, 0};
        int ecm_count = 3;
        byte[] ecm = new byte[ecm_single.length * 3];
        for (int i2 = 0; i2 < 3; ++i2) {
            System.arraycopy(ecm_single, 0, ecm, i2 * ecm_single.length, ecm_single.length);
        }
        byte[] qitStr_ecm = FreqCommPlayerAudioTrack.synth_cmdToQit(ecm);
        byte[] qitStr_cmd = FreqCommPlayerAudioTrack.synth_cmdToQit(command_string);
        int qperiod_repCount = 10;
        byte[] kperiod = Common.synthesizeStereoSquareWavePeriod(2000, playbackFrequency, config.getDirectionOutputWave());
        if (cachedFskChunk != null && cachedFskChunk_freq == playbackFrequency && cachedFskChunk_dir == config.getDirectionOutputWave()) {
            qperiod = cachedFskChunk;
        } else {
            qperiod = new byte[4][];
            for (int i3 = 0; i3 < 4; ++i3) {
                byte[] period = Common.synthesizeStereoSquareWavePeriod(kQIT_PERIOD_FREQ[i3], playbackFrequency, config.getDirectionOutputWave());
                qperiod[i3] = new byte[period.length * 10];
                for (int j = 0; j < 10; ++j) {
                    System.arraycopy(period, 0, qperiod[i3], j * period.length, period.length);
                }
            }
            cachedFskChunk = qperiod;
            cachedFskChunk_freq = playbackFrequency;
            cachedFskChunk_dir = config.getDirectionOutputWave();
        }
        int totalFrames = kperiod.length / 2 * (K_before + K_after) + (FreqCommPlayerAudioTrack.synth_qperiodLenSum(qitStr_ecm, playbackFrequency) + FreqCommPlayerAudioTrack.synth_qperiodLenSum(qitStr_cmd, playbackFrequency)) * 10;
        byte[] ret = new byte[totalFrames * 2];
        int retI = 0;
        for (i = 0; i < K_before; ++i) {
            System.arraycopy(kperiod, 0, ret, retI, kperiod.length);
            retI += kperiod.length;
        }
        for (i = 0; i < qitStr_ecm.length; ++i) {
            qit = qitStr_ecm[i];
            System.arraycopy(qperiod[qit], 0, ret, retI, qperiod[qit].length);
            retI += qperiod[qit].length;
        }
        for (i = 0; i < qitStr_cmd.length; ++i) {
            qit = qitStr_cmd[i];
            System.arraycopy(qperiod[qit], 0, ret, retI, qperiod[qit].length);
            retI += qperiod[qit].length;
        }
        ret_loopFrameIndex[0] = retI / 2;
        for (i = 0; i < K_after; ++i) {
            System.arraycopy(kperiod, 0, ret, retI, kperiod.length);
            retI += kperiod.length;
        }
        ret_loopFrameIndex[1] = retI / 2;
        return ret;
    }

    private static int synth_qperiodLenSum(byte[] qitString, int playbackFrequency) {
        int[] qitPeriodLen = new int[4];
        for (int i = 0; i < 4; ++i) {
            qitPeriodLen[i] = (int)Math.round((double)playbackFrequency / (double)kQIT_PERIOD_FREQ[i]);
        }
        int ret = 0;
        for (int i = 0; i < qitString.length; ++i) {
            ret += qitPeriodLen[qitString[i]];
        }
        return ret;
    }

    private static byte[] synth_cmdToQit(byte[] command_string) {
        byte[] stringQ = new byte[command_string.length * 4];
        int iStringQ = 0;
        for (int iChar = 0; iChar < command_string.length; ++iChar) {
            byte c = command_string[iChar];
            for (int iQit = 0; iQit < 4; ++iQit) {
                byte qit;
                stringQ[iStringQ] = qit = (byte)(c >> iQit * 2 & 3);
                ++iStringQ;
            }
        }
        return stringQ;
    }
}

